use_prelude!();
use std::sync::Arc;

use super::presence_manager_v2::V2Presence;

/// A token returned by `observe_peers_v2`. Retain this object to continue
/// receiving callback updates.
pub struct PeersObserver {
    _context: Arc<PeersObserverCtx>,
}

impl PeersObserver {
    pub(crate) fn new(context: Arc<PeersObserverCtx>) -> Self {
        Self { _context: context }
    }
}

pub(crate) struct PeersObserverCtx {
    pub(crate) on_presence: Box<dyn Fn(V2Presence) + Send + Sync + 'static>,
}

impl PeersObserverCtx {
    pub(crate) fn new(on_presence: Box<dyn Fn(V2Presence) + Send + Sync + 'static>) -> Self {
        Self { on_presence }
    }
}
