#[macro_use]
extern crate serde_json;
mod common;

use ditto_test_support::ditto_test;

#[ditto_test]
fn insert_event() {
    use chrono::Utc;
    let test_dir = common::temp_persistence_dir();
    let ditto = common::get_ditto(test_dir.path());
    let store = ditto.store();
    let content = json!({"hello": "again"});
    let ts = store.timeseries("test").unwrap();
    let datetime = Utc::now();
    let _ = ts.insert(&datetime, content).unwrap();
    let _ = test_dir;
}
