mod common;

use ditto_test_support::ditto_test;

#[ditto_test]
fn ensure_activated_before_starting_sync() {
    let test_dir = common::temp_persistence_dir();
    let mut ditto = common::get_unactivated_ditto(test_dir.path());
    let res = ditto.try_start_sync();
    assert!(res.is_err());
    let err = res.err().unwrap();
    assert_eq!(err.to_string(), "Sync could not be started because Ditto has not yet been activated. This can be achieved with a successful call to `set_license_token`. If you need to obtain a license token then please visit https://portal.ditto.live.");
    drop(test_dir);
}

/// A basic smoke test which tests that the FFI bindings are wired up
/// correctly and nothing horrible happens.
#[ditto_test]
fn garbage_collection() {
    let test_dir = common::temp_persistence_dir();
    let dk = common::get_ditto(test_dir.path());
    dk.run_garbage_collection();
}
