extern crate dittolive_ditto;
#[macro_use]
extern crate serde_json;

use ditto_test_support::ditto_test;
use dittolive_ditto::prelude::*;

mod common;

#[ditto_test]
fn simple_insert() {
    let test_dir = common::temp_persistence_dir();
    let ditto = common::get_ditto_kit(test_dir.path());
    let store = ditto.store();
    let content = json!({"hello": "again"});
    let collection = store.collection("test").unwrap();
    let id = collection.insert(content, None, false).unwrap();
    let doc = collection.find_by_id(id.to_owned()).exec().unwrap();
    assert_eq!(id, doc.id());
    assert_eq!(doc.get::<String>("hello").unwrap(), "again");
    drop(test_dir);
}
