mod common;

use ditto_test_support::ditto_test;

#[ditto_test]
fn valid_license() {
    let test_dir = common::temp_persistence_dir();
    let mut ditto = common::get_unactivated_ditto_kit(test_dir.path());
    let license_token = std::env::var("DITTO_LICENSE").expect("No License Env Var provided");
    let res = ditto.set_license_token(&license_token);
    assert!(res.is_ok());
    drop(test_dir);
}

#[ditto_test]
fn license_nonsense() {
    let test_dir = common::temp_persistence_dir();
    let mut ditto = common::get_unactivated_ditto_kit(test_dir.path());
    let invalid_license = "this is total nonsense and not base64";
    let res = ditto.set_license_token(invalid_license);
    assert!(res.is_err());
    let err = res.err().unwrap();
    assert_eq!(err.to_string(), "The license failed verification. Obtain a valid license token at https://portal.ditto.live.");
    drop(test_dir);
}

#[ditto_test]
fn license_expired() {
    let test_dir = common::temp_persistence_dir();
    let mut ditto = common::get_unactivated_ditto_kit(test_dir.path());
    let expired_license = "o2d1c2VyX2lkb3Rlc3RAZGl0dG8ubGl2ZWZleHBpcnl0MjAxOC0xMC0zMVQwMDowMDowMFppc2lnbmF0dXJleFh1U2xqVTZyT2xSMVNKQ2RDNFJoakNjYWR1NkdyV1Z3MUV4anlDRlNuQ3l2cjA5OU9iaGV6RGMwUnRFTEE2RmJxdk9KcHhOWU1Zbk5VeFNubnlpUExUZz09";
    let res = ditto.set_license_token(expired_license);
    assert!(res.is_err());
    let err = res.err().unwrap();
    assert_eq!(err.to_string(), "The license expired on 2018-10-31 00:00:00 UTC. Obtain a valid license token at https://portal.ditto.live.");
    drop(test_dir);
}

#[ditto_test]
fn license_tampered() {
    let test_dir = common::temp_persistence_dir();
    let mut ditto = common::get_unactivated_ditto_kit(test_dir.path());
    let tampered_license = "o2d1c2VyX2lkcnJ1c3NlbGxAZGl0dG8ubGl2ZWZleHBpcnl4HjIwMTktMDktMThUMTA6MzM6MTkuNTU4NzYzODk4WmlzaWduYXR1cmV4WDdieUtId080b1dlLy9PbUllNlcrZ2EwZS9mdlQ0R3hxTCs2OFEyZ2JFWEJvYU9LOGJsaUd5dktoNEVzc2FYaFQybVFMOEtHalZGYWtWUjlibG5jNzB3PT0=";
    let res = ditto.set_license_token(tampered_license);
    assert!(res.is_err());
    let err = res.err().unwrap();
    assert_eq!(err.to_string(), "The license failed verification. Obtain a valid license token at https://portal.ditto.live.");
    drop(test_dir);
}
