use_prelude!();
use super::*;

#[derive(Debug)]
pub enum LiveQueryEvent {
    Initial,

    Update {
        old_documents: Vec<ffi_sdk::BoxedDocument>,
        insertions: Box<[usize]>,
        deletions: Box<[usize]>,
        updates: Box<[usize]>,
        moves: Vec<LiveQueryMove>,
    },
}

impl LiveQueryEvent {
    pub fn hash(&self, docs: &[ffi_sdk::BoxedDocument]) -> Result<u64, DittoError> {
        let mut hash: u64 = 0;
        let status = unsafe { ffi_sdk::ditto_documents_hash(docs.into(), hash.as_out()) };
        if status != 0 {
            return Err(DittoError::from_ffi(ErrorKind::InvalidInput));
        }
        Ok(hash)
    }

    pub fn hash_mnemonic(&self, docs: &[ffi_sdk::BoxedDocument]) -> Result<String, DittoError> {
        let mut mnemonic_c_str = None;
        let out_mnemonic = mnemonic_c_str.manually_drop_mut().as_out();
        let status = unsafe { ffi_sdk::ditto_documents_hash_mnemonic(docs.into(), out_mnemonic) };
        if status != 0 {
            return Err(DittoError::from_ffi(ErrorKind::InvalidInput));
        }
        Ok(mnemonic_c_str.unwrap().to_string())
    }
}
