//! Internal / private prelude

#![allow(unused_imports)]

pub(in crate) use ::safer_ffi::prelude::*;
pub(in crate) use ::std::{
    any::Any,
    borrow::Borrow,
    collections::HashMap,
    convert::{TryFrom, TryInto},
    ops::Not,
    os::raw::c_void,
    path::{Path, PathBuf},
    pin::Pin,
    sync::Arc,
};
pub(in crate) use ::tap::*;

pub(in crate) use crate::{
    ditto_kit::DittoKit,
    prelude::*,
    store::Store,
    utils::{extension_traits::*, Str},
};

pub(in crate) mod marker {
    pub(in crate) use crate::utils::InvariantLifetimeMarker as InvariantLifetime;
}
