extern crate dittolive_ditto;
#[macro_use]
extern crate serde_json;

use dittolive_ditto::prelude::*;

mod common;

#[test]
fn simple_insert() {
    let ditto = common::get_ditto().unwrap();
    let store = ditto.store();
    let content = json!({"hello": "again"});
    let collection = store.collection("test").unwrap();
    let id = collection.insert(content, None, false).unwrap();
    let doc = collection.find_by_id(id.to_owned()).exec().unwrap();
    assert_eq!(id, doc.id());
    assert_eq!(doc.get::<String>("hello").unwrap(), "again");
}
