use_prelude!();
use super::*;

#[derive(Debug)]
pub enum LiveQueryEvent {
    Initial,

    Update {
        old_documents: Vec<ffi_sdk::BoxedDocument>,
        insertions: Box<[usize]>,
        deletions: Box<[usize]>,
        updates: Box<[usize]>,
        moves: Vec<LiveQueryMove>,
    },
}

impl LiveQueryEvent {
    pub fn hash(&self, docs: &[ffi_sdk::BoxedDocument]) -> Result<u64, DittoError> {
        unsafe { ffi_sdk::ditto_documents_hash(docs.into()).ok() }
    }

    pub fn hash_mnemonic(&self, docs: &[ffi_sdk::BoxedDocument]) -> Result<String, DittoError> {
        let mnemonic_c_str = unsafe { ffi_sdk::ditto_documents_hash_mnemonic(docs.into()).ok()? };
        Ok(mnemonic_c_str.unwrap().to_string())
    }
}
