//! Manually Generated DittoFFI Bindings
//!
//! These must be updated when dittoffi changes

use std::{
    fmt,
    os::raw::{c_double, c_int, c_uint, c_ulonglong, c_void},
};

use ::safer_ffi::prelude::*;

#[repr(C)]
pub struct Ditto {
    _private: [u8; 0],
}

macro_rules! opaque_wrap {(
    $pub:vis
    type $TypeName:ident ~ repr_c::Box<$Pointee:ty>;
    $(
        fn drop $($rest:tt)*
    )?
) => (
    #[repr(transparent)]
    $pub
    struct $TypeName {
        ptr: ::core::ptr::NonNull<$Pointee>,
    }

    impl ::core::ops::DerefMut for $TypeName {
        fn deref_mut (self: &'_ mut Self) -> &'_ mut $Pointee
        {
            impl ::core::ops::Deref for $TypeName {
                type Target = $Pointee;

                fn deref (self: &'_ Self) -> &'_ $Pointee
                {
                    unsafe {
                        self.ptr.as_ref()
                    }
                }
            }

            unsafe {
                self.ptr.as_mut()
            }
        }
    }

    unsafe impl ::core::marker::Send for $TypeName {}
    unsafe impl ::core::marker::Sync for $TypeName {}

    $(
        impl Drop for $TypeName {
            fn drop $($rest)*
        }
    )?
)}

opaque_wrap! {
    pub type BoxedDitto ~ repr_c::Box<Ditto>;
    fn drop(&mut self) {
        unsafe {
            ditto_drop(self);
            // At this point, we *could* ditto_free, but things could go south
            // especially as ditto_drop basically does all the actual clean up work
        }
    }
}

impl fmt::Debug for BoxedDitto {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.debug_struct("Ditto").finish()
    }
}

opaque_wrap! {
    pub type BoxedAuthClient ~ repr_c::Box<AuthClient>;
    fn drop(&mut self) {
        unsafe {ditto_auth_client_free(&mut **self);}
    }
}

#[repr(C)]
pub struct UninitializedDitto {
    _private: [u8; 0],
}

opaque_wrap! {
    pub type BoxedUninitializedDitto ~ repr_c::Box<UninitializedDitto>;
}

#[repr(C)]
#[derive(Debug, Clone, PartialEq, Eq)]
pub enum Platform {
    Windows,
    Mac,
    Ios,
    Android,
    Linux,
    Unknown,
}

#[repr(C)]
#[derive(Debug, Clone, PartialEq, Eq)]
#[allow(dead_code)]
pub enum Language {
    Swift,
    ObjectiveC,
    CPlusPlus,
    CSharp,
    Javascript,
    Unknown,
    Rust,
}

#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq, Eq)]
pub enum CLogLevel {
    // Starts at 1 to match the Rust log levels which have an `Off` case with
    // value 0
    Error = 1,
    Warning,
    Info,
    Debug,
    Verbose,
}

#[repr(C)]
#[derive(Debug, Clone, PartialEq, Eq)]
pub enum WebSocketMode {
    Enabled,
    Disabled,
}

#[repr(C)]
#[allow(non_camel_case_types)]
pub struct StaticTcpClientPlatformHandle {
    _private: [u8; 0],
}

opaque_wrap! {
    pub type BoxedStaticTcpClient ~ repr_c::Box<StaticTcpClientPlatformHandle>;
    fn drop(&mut self) {
        unsafe {static_tcp_client_free_handle(&mut **self);}
    }
}

#[repr(C)]
#[allow(non_camel_case_types)]
pub struct WebsocketClientPlatformHandle {
    _private: [u8; 0],
}

opaque_wrap! {
    pub type BoxedWebsocketClient ~ repr_c::Box<WebsocketClientPlatformHandle>;
    fn drop(&mut self) {
        unsafe {websocket_client_free_handle(&mut **self);}
    }
}

#[repr(C)]
#[allow(non_camel_case_types)]
pub struct BleClientPlatformHandle {
    _private: [u8; 0],
}

opaque_wrap! {
    pub type BoxedBleClient ~ repr_c::Box<BleClientPlatformHandle>;
    fn drop(&mut self) {
        unsafe {ble_client_free_handle(&mut **self);}
    }
}

#[repr(C)]
#[allow(non_camel_case_types)]
pub struct BleServerPlatformHandle {
    _private: [u8; 0],
}

opaque_wrap! {
    pub type BoxedBleServer ~ repr_c::Box<BleServerPlatformHandle>;
    fn drop(&mut self) {
        unsafe {ble_server_free_handle(&mut **self);}
    }
}

#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
#[allow(dead_code)]
pub enum LicenseVerificationResult {
    LicenseOk = 0,
    VerificationFailed = -1,
    LicenseExpired = -2,
    UnsupportedFutureVersion = -3,
}

#[repr(C)]
pub struct CWriteTransaction {
    _private: [u8; 0],
}

opaque_wrap! {
    pub type BoxedWriteTransaction ~ repr_c::Box<CWriteTransaction>;
    fn drop(&mut self) {
        unsafe {
            ditto_write_transaction_free(&mut **self);
        }
    }
}

#[repr(C)]
pub struct CReadTransaction {
    _private: [u8; 0],
}

opaque_wrap! {
    pub type BoxedReadTransaction ~ repr_c::Box<CReadTransaction>;
    fn drop(&mut self) {

        let ptr: *mut CReadTransaction  = &mut **self;
        unsafe {ditto_read_transaction_free(ptr)}
    }
}

// This type is NOT opaque
#[repr(C)]
pub struct COrderByParam<'__> {
    pub query_c_str: char_p::Ref<'__>,
    pub direction: QuerySortDirection,
}

#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[allow(dead_code)]
pub enum QuerySortDirection {
    Ascending = 1,
    Descending,
}

#[repr(C)]
#[derive(Clone, Copy, Debug)]
pub struct Document {
    _private: [u8; 0],
}

opaque_wrap! {
    pub type BoxedDocument ~ repr_c::Box<Document>;
    fn drop(&mut self) {
        unsafe {
            ditto_document_free(self);
        }
    }
}

impl fmt::Debug for BoxedDocument {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        let c_str = unsafe { ditto_document_id(self) };
        // TODO: FIXME
        f.debug_struct("Document").field("id", &c_str).finish()
    }
}

#[repr(C)]
#[derive(Clone, Copy, Debug)]
pub struct TimeseriesEvent {
    _private: [u8; 0],
}

opaque_wrap! {
    pub type BoxedTimeseriesEvent ~ repr_c::Box<TimeseriesEvent>;
    fn drop(&mut self) {
        unsafe {
            ditto_timeseries_event_free(self);
        }
    }
}

#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[allow(dead_code)]
pub enum LiveQueryAvailability {
    Always,
    WhenSignalled,
}

#[repr(C)]
#[allow(nonstandard_style)]
pub struct c_cb_params {
    /// Must be freed with `ditto_free_documents`.
    pub documents: repr_c::Vec<BoxedDocument>,
    pub is_initial: bool,
    /// Must be freed with `ditto_free_documents`.
    pub old_documents: Option<repr_c::Vec<BoxedDocument>>,
    /// Must be freed using `ditto_free_indices`.
    pub insertions: Option<c_slice::Box<usize>>,
    /// Must be freed using `ditto_free_indices`.
    pub deletions: Option<c_slice::Box<usize>>,
    /// Must be freed using `ditto_free_indices`.
    pub updates: Option<c_slice::Box<usize>>,
    /// Must be freed using `ditto_free_indices`.
    pub moves: Option<c_slice::Box<usize>>,
}

#[repr(C)]
#[derive(Copy, Clone, Debug)]
#[allow(dead_code)]
pub enum AttachmentFileOperation {
    Copy = 1,
    Move,
}

#[repr(C)]
pub struct Attachment {
    pub id: c_slice::Box<u8>,
    pub len: u64,
    pub handle: BoxedAttachmentHandle,
}

#[repr(C)]
pub struct AttachmentHandle {
    _private: [u8; 0],
}

#[repr(C)]
pub struct AuthClient {
    _private: [u8; 0],
}

opaque_wrap! {
    pub type BoxedAttachmentHandle ~ repr_c::Box<AttachmentHandle>;
    fn drop(&mut self) {
        unsafe {
            ditto_free_attachment_handle(self);
        }
    }
}

impl fmt::Debug for BoxedAttachmentHandle {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.debug_struct("AttachmentHandle").finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub enum StringPrimitiveFormat {
    WithQuotes,
    WithoutQuotes,
}

#[repr(C)]
pub struct slice_ref_uint8_t {
    ptr: *const u8,
    len: usize,
}

impl From<&[u8]> for slice_ref_uint8_t {
    fn from(x: &[u8]) -> Self {
        slice_ref_uint8_t {
            ptr: x.as_ptr(),
            len: x.len(),
        }
    }
}

#[repr(C)]
pub struct slice_boxed_uint8_t {
    ptr: *mut u8,
    len: usize,
}

#[allow(improper_ctypes)]
#[link(name = "dittoffi")]
extern "C" {
    pub fn ditto_init_sdk_version(
        platform: Platform,
        language: Language,
        sdk_semver: char_p::Ref<'_>,
    );

    pub fn uninitialized_ditto_make(working_dir: char_p::Ref<'_>) -> BoxedUninitializedDitto;
    pub fn ditto_make(
        uninit_ditto: BoxedUninitializedDitto,
        auth_client: &'_ AuthClient,
    ) -> BoxedDitto;

    pub fn ditto_logger_init();
    pub fn ditto_logger_enabled(enabled: bool);
    pub fn ditto_logger_enabled_get() -> bool;
    pub fn ditto_logger_emoji_headings_enabled(enabled: bool);
    pub fn ditto_logger_emoji_headings_enabled_get() -> bool;
    pub fn ditto_logger_minimum_log_level_get() -> CLogLevel;
    pub fn ditto_logger_minimum_log_level(log_level: CLogLevel);

    pub fn ditto_shutdown(ditto: &'_ Ditto);
    pub fn ditto_drop(ditto: &'_ mut Ditto);
    pub fn ditto_free(ditto: BoxedDitto);
    pub fn ditto_start_tcp_server(ditto: &'_ Ditto, bind: Option<char_p::Ref<'_>>) -> c_int;
    pub fn ditto_stop_tcp_server(ditto: &'_ Ditto);
    pub fn ditto_start_http_server(
        ditto: &'_ Ditto,
        bind: Option<char_p::Ref<'_>>,
        static_path: Option<char_p::Ref<'_>>,
        enable_websocket: WebSocketMode,
        tls_cert_path: Option<char_p::Ref<'_>>,
        tls_key_path: Option<char_p::Ref<'_>>,
    ) -> c_int;
    pub fn ditto_stop_http_server(ditto: &'_ Ditto);
    pub fn ditto_add_static_tcp_client(
        ditto: &Ditto,
        address: char_p::Ref<'_>,
    ) -> BoxedStaticTcpClient;
    pub fn ditto_add_websocket_client(
        ditto: &'_ Ditto,
        address: char_p::Ref<'_>,
    ) -> BoxedWebsocketClient;
    pub fn ditto_add_internal_ble_client_transport(ditto: &'_ Ditto) -> BoxedBleClient;
    pub fn ditto_add_internal_ble_server_transport(ditto: &'_ Ditto) -> BoxedBleServer;
    pub fn ditto_get_sdk_version() -> char_p::Box;
    pub fn verify_license(
        license: char_p::Ref<'_>,
        out_err_msg: Option<Out<'_, Option<char_p::Box>>>,
    ) -> LicenseVerificationResult;
    pub fn ditto_run_garbage_collection(ditto: &'_ Ditto);

    pub fn ditto_get_collection_names(
        ditto: &'_ Ditto,
        out_names: Out<'_, Option<repr_c::Vec<char_p::Box>>>,
    ) -> c_int;

    pub fn ditto_queries_hash(
        ditto: &Ditto,
        coll_names: c_slice::Ref<'_, char_p::Ref<'_>>,
        queries: c_slice::Ref<'_, char_p::Ref<'_>>,
        c_hash: Out<'_, u64>,
    ) -> c_int;

    pub fn ditto_queries_hash_mnemonic(
        ditto: &'_ Ditto,
        coll_names: c_slice::Ref<'_, char_p::Ref<'_>>,
        queries: c_slice::Ref<'_, char_p::Ref<'_>>,
        out_mnemonic_hash: Out<'_, Option<char_p::Box>>,
    ) -> c_int;

    pub fn ditto_collection(ditto: &'_ Ditto, name: char_p::Ref<'_>) -> c_int;

    pub fn ditto_collection_insert(
        ditto: &'_ Ditto,
        coll_name: char_p::Ref<'_>,
        transaction: &'_ mut CWriteTransaction,
        document: BoxedDocument,
        id: Out<'_, Option<c_slice::Box<u8>>>,
    ) -> c_int;

    pub fn ditto_collection_update(
        ditto: &'_ Ditto,
        coll_name: char_p::Ref<'_>,
        transaction: &'_ mut CWriteTransaction,
        document: BoxedDocument,
    ) -> c_int;

    pub fn ditto_collection_evict(
        ditto: &'_ Ditto,
        coll_name: char_p::Ref<'_>,
        transaction: &'_ mut CWriteTransaction,
        id: c_slice::Ref<'_, u8>,
        out_evicted: Option<Out<'_, bool>>,
    ) -> c_int;

    pub fn ditto_collection_remove(
        ditto: &'_ Ditto,
        coll_name: char_p::Ref<'_>,
        transaction: &'_ mut CWriteTransaction,
        id: c_slice::Ref<'_, u8>,
        out_removed: Option<Out<'_, bool>>,
    ) -> c_int;

    pub fn ditto_collection_get(
        ditto: &'_ Ditto,
        coll_name: char_p::Ref<'_>,
        id: c_slice::Ref<'_, u8>,
        transaction: &'_ mut CReadTransaction,
        document: Out<'_, Option<BoxedDocument>>,
    ) -> c_int;

    pub fn ditto_collection_exec_query_str<'order_ref, 'order: 'order_ref>(
        ditto: &'_ Ditto,
        coll_name: char_p::Ref<'_>,
        transaction: &'_ mut CWriteTransaction,
        query: char_p::Ref<'_>,
        query_args: Option<c_slice::Ref<'_, u8>>,
        order_by_params: c_slice::Ref<'order_ref, COrderByParam<'order>>,
        limit: c_int,
        offset: c_uint,
        out_documents: Out<'_, Option<repr_c::Vec<BoxedDocument>>>,
    ) -> c_int;

    pub fn ditto_collection_remove_query_str<'order_ref, 'order: 'order_ref>(
        ditto: &'_ Ditto,
        coll_name: char_p::Ref<'_>,
        transaction: &'_ mut CWriteTransaction,
        query: char_p::Ref<'_>,
        query_args: Option<c_slice::Ref<'_, u8>>,
        order_by_params: c_slice::Ref<'order_ref, COrderByParam<'order>>,
        limit: c_int,
        offset: c_uint,
        out_ids: Out<'_, repr_c::Vec<c_slice::Box<u8>>>,
    ) -> c_int;

    pub fn ditto_collection_evict_query_str<'order_ref, 'order: 'order_ref>(
        ditto: &'_ Ditto,
        coll_name: char_p::Ref<'_>,
        transaction: &'_ mut CWriteTransaction,
        query: char_p::Ref<'_>,
        query_args: Option<c_slice::Ref<'_, u8>>,
        order_by_params: c_slice::Ref<'order_ref, COrderByParam<'order>>,
        limit: c_int,
        offset: c_uint,
        out_ids: Out<'_, repr_c::Vec<c_slice::Box<u8>>>,
    ) -> c_int;

    pub fn ditto_read_transaction<'txn>(
        ditto: &'_ Ditto,
        txn: Out<'txn, Option<BoxedReadTransaction>>,
    ) -> c_int;

    pub fn ditto_read_transaction_free(transaction: *mut CReadTransaction);

    pub fn ditto_write_transaction(
        ditto: &'_ Ditto,
        txn: Out<'_, Option<BoxedWriteTransaction>>,
    ) -> c_int;

    pub fn ditto_write_transaction_free(txn: *mut CWriteTransaction);

    pub fn ditto_write_transaction_commit(
        ditto: &Ditto,
        transaction: BoxedWriteTransaction,
    ) -> c_int;

    pub fn ditto_write_transaction_rollback(transaction: BoxedWriteTransaction);

    pub fn ditto_document_new_cbor(
        cbor: c_slice::Ref<'_, u8>,
        id: Option<c_slice::Ref<'_, u8>>,
        _site_id: c_ulonglong,
        document: Out<'_, Option<BoxedDocument>>,
    ) -> c_int;

    pub fn ditto_document_new_cbor_with_timestamp(
        cbor: c_slice::Ref<'_, u8>,
        id: Option<c_slice::Ref<'_, u8>>,
        _site_id: c_ulonglong,
        timestamp: c_uint,
        document: Out<'_, Option<BoxedDocument>>,
    ) -> c_int;

    pub fn ditto_document_id(document: &'_ Document) -> c_slice::Box<u8>;

    pub fn ditto_document_id_query_compatible(
        id: c_slice::Ref<'_, u8>,
        string_primitive_format: StringPrimitiveFormat,
    ) -> char_p::Box;

    pub fn ditto_validate_document_id(
        cbor: c_slice::Ref<'_, u8>,
        out_cbor: Out<'_, Option<c_slice::Box<u8>>>,
    ) -> c_uint;

    pub fn ditto_add_subscription(
        ditto: &'_ Ditto,
        collection: char_p::Ref<'_>,
        query: char_p::Ref<'_>,
        query_args_cbor: Option<c_slice::Ref<'_, u8>>,
    ) -> c_int;

    pub fn ditto_remove_subscription(
        ditto: &'_ Ditto,
        collection: char_p::Ref<'_>,
        query: char_p::Ref<'_>,
        query_args_cbor: Option<c_slice::Ref<'_, u8>>,
    ) -> c_int;

    pub fn ditto_live_query_webhook_generate_new_api_secret(ditto: &'_ Ditto) -> c_int;

    pub fn ditto_live_query_webhook_start_all(ditto: &'_ Ditto) -> c_int;

    pub fn ditto_live_query_webhook_start_by_id(
        ditto: &'_ Ditto,
        id: c_slice::Ref<'_, u8>,
    ) -> c_int;

    pub fn ditto_live_query_webhook_register_str(
        ditto: &'_ Ditto,
        coll_name: char_p::Ref<'_>,
        query: char_p::Ref<'_>,
        order_by: c_slice::Ref<'_, COrderByParam>,
        limit: c_int,
        offset: c_uint,
        url: char_p::Ref<'_>,
        out_id: Out<'_, Option<c_slice::Box<u8>>>,
    ) -> c_int;

    pub fn ditto_live_query_register_str(
        ditto: &'_ Ditto,
        coll_name: char_p::Ref<'_>,
        query: char_p::Ref<'_>,
        query_args_cbor: Option<c_slice::Ref<'_, u8>>,
        order_by: c_slice::Ref<'_, COrderByParam>,
        limit: c_int,
        offset: c_uint,
        lq_availability: LiveQueryAvailability,
        id: Out<'_, i64>,
        ctx: *mut c_void,
        retain: Option<unsafe extern "C" fn(*mut c_void)>,
        release: Option<unsafe extern "C" fn(*mut c_void)>,
        c_cb: unsafe extern "C" fn(ctx: *mut c_void, params: c_cb_params),
    ) -> c_int;

    pub fn ditto_live_query_start(ditto: &'_ Ditto, id: i64) -> c_int;

    pub fn ditto_live_query_stop(ditto: &'_ Ditto, id: i64);

    pub fn ditto_stop_all_live_queries(ditto: &mut Ditto);

    pub fn ditto_live_query_signal_available_next(ditto: &'_ Ditto, id: i64);

    pub fn ditto_documents_hash(
        documents: c_slice::Ref<'_, BoxedDocument>,
        c_hash: Out<'_, u64>,
    ) -> c_int;

    pub fn ditto_documents_hash_mnemonic(
        documents: c_slice::Ref<'_, BoxedDocument>,
        out_hash_mnemonic: Out<'_, Option<char_p::Box>>,
    ) -> c_int;

    pub fn ditto_new_attachment_from_file(
        ditto: &'_ Ditto,
        source_path: char_p::Ref<'_>,
        file_operation: AttachmentFileOperation,
        out_attachment: Out<'_, Attachment>,
    ) -> c_uint;

    pub fn ditto_get_complete_attachment_path(
        ditto: &'_ Ditto,
        handle: &'_ AttachmentHandle,
    ) -> char_p::Box;

    pub fn ditto_resolve_attachment(
        ditto: &'_ Ditto,
        id: c_slice::Ref<'_, u8>,
        ctx: *mut c_void,
        retain: Option<unsafe extern "C" fn(*mut c_void)>,
        release: Option<unsafe extern "C" fn(*mut c_void)>,
        out_cancel_token: Out<'_, u64>,
        on_complete_cb: unsafe extern "C" fn(ctx: *mut c_void, BoxedAttachmentHandle),
        on_progress_cb: unsafe extern "C" fn(ctx: *mut c_void, u64, u64),
        on_deleted_cb: unsafe extern "C" fn(ctx: *mut c_void),
    ) -> c_uint;

    pub fn ditto_cancel_resolve_attachment(
        ditto: &'_ Ditto,
        id: c_slice::Ref<'_, u8>,
        cancel_token: u64,
    ) -> c_uint;

    pub fn ditto_document_update(
        document: &'_ mut Document,
        cbor: c_slice::Ref<'_, u8>,
        create_path: bool,
    ) -> c_int;

    pub fn ditto_collection_update_multiple(
        ditto: &'_ Ditto,
        coll_name: char_p::Ref<'_>,
        transaction: &'_ mut CWriteTransaction,
        documents: repr_c::Vec<BoxedDocument>,
    ) -> c_int;

    pub fn ditto_error_message() -> Option<char_p::Box>;

    pub fn ditto_document_cbor(document: &'_ Document) -> c_slice::Box<u8>;

    pub fn ditto_document_get_cbor(
        document: &'_ Document,
        pointer: char_p::Ref<'_>,
    ) -> Option<c_slice::Box<u8>>;

    pub fn ditto_document_set_cbor(
        document: &'_ mut Document,
        pointer: char_p::Ref<'_>,
        cbor: c_slice::Ref<'_, u8>,
        create_path: bool,
    ) -> c_int;

    pub fn ditto_document_set_cbor_with_timestamp(
        document: &'_ mut Document,
        pointer: char_p::Ref<'_>,
        cbor: c_slice::Ref<'_, u8>,
        create_path: bool,
        timestamp: c_uint,
    ) -> c_int;

    pub fn ditto_document_remove(document: &'_ mut Document, pointer: char_p::Ref<'_>) -> c_int;

    pub fn ditto_document_insert_cbor(
        document: &'_ mut Document,
        pointer: char_p::Ref<'_>,
        cbor: c_slice::Ref<'_, u8>,
    ) -> c_int;

    pub fn ditto_document_push_cbor(
        document: &'_ mut Document,
        pointer: char_p::Ref<'_>,
        cbor: c_slice::Ref<'_, u8>,
    ) -> c_int;

    pub fn ditto_document_pop_cbor(
        document: &'_ mut Document,
        pointer: char_p::Ref<'_>,
        out_cbor: Out<'_, c_slice::Box<u8>>,
    ) -> c_int;

    pub fn ditto_document_free(document: &mut Document);

    pub fn ditto_document_replace_with_counter(
        document: &'_ mut Document,
        pointer: char_p::Ref<'_>,
    ) -> c_int;

    pub fn ditto_document_replace_with_counter_with_timestamp(
        document: &'_ mut Document,
        pointer: char_p::Ref<'_>,
        timestamp: c_uint,
    ) -> c_int;

    pub fn ditto_document_increment_counter(
        document: &'_ mut Document,
        pointer: char_p::Ref<'_>,
        amount: c_double,
    ) -> c_int;

    pub fn ditto_free_attachment_handle(handle: &mut AttachmentHandle);

    pub fn static_tcp_client_free_handle(handle: *mut StaticTcpClientPlatformHandle);

    pub fn websocket_client_free_handle(handle: *mut WebsocketClientPlatformHandle);

    pub fn ble_client_free_handle(handle: *mut BleClientPlatformHandle);

    pub fn ble_server_free_handle(handle: *mut BleServerPlatformHandle);

    pub fn ditto_free_documents(documents: Option<repr_c::Vec<BoxedDocument>>);

    pub fn ditto_free_indices(indices: Option<c_slice::Box<usize>>);

    pub fn ditto_c_string_free(s: char_p::Box);

    pub fn ditto_c_bytes_free(bytes: c_slice::Box<u8>);

    pub fn ditto_auth_client_make_with_web(
        working_dir: char_p::Ref<'_>,
        app_id: char_p::Ref<'_>,
        base_url: char_p::Ref<'_>,
        auth_client: Out<'_, Option<BoxedAuthClient>>,
    ) -> c_int;

    pub fn ditto_auth_client_make_for_development(
        working_dir: Option<char_p::Ref<'_>>,
        app_id: char_p::Ref<'_>,
        site_id: c_ulonglong,
        auth_client: Out<'_, Option<BoxedAuthClient>>,
    ) -> c_int;

    pub fn ditto_auth_client_make_with_shared_key(
        working_dir: Option<char_p::Ref<'_>>,
        app_id: char_p::Ref<'_>,
        key_der_b64: char_p::Ref<'_>,
        site_id: c_ulonglong,
        auth_client: Out<'_, Option<BoxedAuthClient>>,
    ) -> c_int;

    pub fn ditto_auth_client_make_with_static_x509(
        config_cbor_b64: char_p::Ref<'_>,
        auth_client: Out<'_, Option<BoxedAuthClient>>,
    ) -> c_int;

    pub fn ditto_auth_client_free(auth_client: *mut AuthClient);

    pub fn ditto_auth_client_get_site_id(auth_client: &'_ AuthClient) -> c_ulonglong;

    pub fn ditto_timeseries_event_from_cbor(
        timestamp: [u8; 8], // a u64 ... but arm32 friendly
        nanos: u32,
        ts_name: char_p::Ref<'_>,
        cbor: slice_ref_uint8_t,
        event: *mut Option<BoxedTimeseriesEvent>, // non-nullable Out<Option<BoxedTimeseriesEvent>>
    ) -> c_int;

    pub fn ditto_insert_timeseries_event(
        ditto: &'_ Ditto,
        transaction: &'_ mut CWriteTransaction,
        ts_event: BoxedTimeseriesEvent,
    ) -> c_int;

    pub fn ditto_timeseries_event_free(document: &mut TimeseriesEvent);

}

#[cfg(test)]
mod test {

    use super::*;

    /// Minimal test to force cargo/rustc to attempt to link to
    /// libdittoffi
    // This should not use ditto_test as it is public
    #[test]
    fn test_linking() {
        unsafe {
            ditto_logger_init();
        }
    }
}
