# `libdittoffi` System Crate

This is a `*-sys` crate that is responsible for downloading the underlying Ditto library for your target platform and exposing it to your Rust application.
Typical users of `dittolive-ditto` will not need to interact with this crate directly, except for debugging purposes.


## Building

The included `build.rs` script will attempt to detect your target architecture and download the appropriate copy the binary `ditto` library (libdittoffi).
By default, Cargo (and the underlying linker used by the Rust compiler) will search for this library in [a number of places](https://doc.rust-lang.org/cargo/reference/environment-variables.html#dynamic-library-paths).
*If you want to cross-compile for a different rustc target, you may need to manually download the appropriate binary.*
You can also manually download the library and place it in one of the searched locations yourself.
Further, you can use the environment variable `DITTOFFI_SEARCH_PATH` to specify the directory which *contains* the target library in a way which is platform agnostic.
One can also explicitly pass a `-L` argument to rustc via the `RUSTFLAGS` environment variable to specify a library search directory, although this will invalidate the build cache of *all* the dependencies (as touching `RUSTFLAGS` does).

Note, you can also override build script behavior in your local Cargo `config.toml` file as described [here](https://doc.rust-lang.org/cargo/reference/build-scripts.html#overriding-build-scripts).
