disp
====

[![crates.io](https://img.shields.io/crates/v/disp.svg)](https://crates.io/crates/disp)
[![Documentation](https://docs.rs/disp/badge.svg)](https://docs.rs/disp)
[![Build Status](https://travis-ci.org/btwiuse/disp.svg?branch=master)](https://travis-ci.org/btwiuse/disp)

derive `Display` for types that implement `Debug`

Example

```
mod hello {
    use std::fmt::Display;

    #[derive(Debug, disp::Display)]
    pub struct Hello {}
}

fn main() {
    let hello = hello::Hello {};
    println!("Debug: {hello:?}, world!");
    println!("Display: {hello}, world!");
}
```

Output:

```
Debug: Hello, world!
Display: Hello, world!
```
