use std::env;

fn main() {
    let mut args = env::args().into_iter();
    args.next().unwrap();
    
    let msg = if let Some(msg) = args.next() { msg } else { String::from("your message here") }.to_lowercase();
    let letters = ('a'..='z').collect::<Vec<char>>();
    for char in msg.chars().into_iter() {
        if letters.contains(&char) {
            print!(":regional_indicator_{char}: ");
        }else if char == ' ' {
            print!("   ");
        }else if let Ok(numba) = char.to_string().parse::<u8>() {
            print!(":{}: ", match numba {
                0 => {
                    "zero"  
                },
                1 => {
                    "one"
                },
                2 => {
                    "two"
                },
                3 => {
                    "three"
                },
                4 => {
                    "four"
                },
                5 => {
                    "five"
                },
                6 => {
                    "six"
                },
                7 => {
                    "seven"
                },
                8 => {
                    "eight"
                },
                9 => {
                    "nine"
                },
                _ => {
                    "zero"
                }
            })
        }
    }
}
