disktest - Hard Disk (HDD), Solid State Disk (SSD), USB Stick, SD-Card tester
=============================================================================

<https://bues.ch/h/disktest>

Disktest is a tool to check Hard Disks, Solid State Disks, USB sticks,
SD cards or similar storage media for errors.

It does so by writing a pseudo random sequence to the device and then
reading it back and verifying it to the expected pseudo random sequence.

This tool can be used to:

-   Check disks for hardware errors (e.g. platter errors, Flash errors,
    etc\...).
-   Overwrite storage media with a cryptographically strong pseudo
    random stream. This can either be used to delete existing data on
    the disk, or to prepare the disk for encryption.
-   Test for tampered media that pretend to have more storage area than
    they physically actually have. Sometimes such media are sold by
    fraudulent sellers for cheap prices.
-   Measure read and write speed.
-   \... probably lots of other tasks.

The random number stream is generated by the following algorithm: :

    OUTPUT_DATA := CHACHA20(PBKDF2(SEED | THREAD_ID))

If more than one thread is used, then each thread generates such a
random number stream, which are then interleaved in a regular pattern.

Security
========

The default algorithm [ChaCha20](https://en.wikipedia.org/wiki/Salsa20)
is a cryptographically strong random number generator. That means if the
seed is kept secret, then the random sequence cannot be predicted or
reconstructed by anybody else.

See option [\--seed]{.title-ref} under [\--help]{.title-ref} for more
details.

Example
=======

The following disktest invocation will write a secure sequence to the
disk device [/dev/sdc]{.title-ref} and subsequently read back and verify
the sequence from the disk device.

``` {.sh}
disktest --write --verify -j0 /dev/sdc
```

*WARNING*: This will irrevocably overwrite all data on the disk
[/dev/sdc]{.title-ref}! Be absolutely certain that the device path is
correct before starting the command. Your data cannot be recovered.

You probably need [root]{.title-ref} permissions to write to raw disk
devices ([/dev/sdX]{.title-ref} or [/dev/mmcblkX]{.title-ref}).

The target [device]{.title-ref} does not have to be an actual hardware
device node. It can be any file path on any file system. For example you
can mount an USB stick file system and write to a file on that file
system. However, please note that this leaves a couple minor untested
spots in the USB stick\'s memory, which are reserved to the file system.
Also see the [Windows]{.title-ref} section below.

Windows
=======

On Windows disktest can write to any file on any mounted storage media.

If your storage media under test is drive D, then the following command
would run a write + verify test on that device:

``` {.sh}
disktest --write --verify -j0 D:\testfile.img
```

Dependencies
============

-   [Rust 1.59.0](https://www.rust-lang.org/) or later.
-   Crate dependencies will automatically be downloaded by cargo.

Installing from crates.io
=========================

Download the latest version of disktest from
[crates.io](https://crates.io/) and install it to \`\$HOME/.cargo/bin\`:

``` {.sh}
cargo install disktest
```

Installing from source package
==============================

Build disktest and install it to \`\$HOME/.cargo/bin\`:

``` {.sh}
cd path/to/source/package
cargo install --path .
```

Running from source package without installing
==============================================

Build and run disktest in place without installing it:

``` {.sh}
cd path/to/source/package
cargo run --release --  DISKTEST_OPTIONS_HERE
```

See below for a description of the available [disktest]{.title-ref}
options.

Disktest command line options
=============================

Please run either of the following commands to show more information
about the available command line options.

``` {.sh}
cargo run --release -- --help
cargo run --release -- -h
disktest --help
disktest -h
```

Speed
=====

The following table shows some example speed measurements of disktest in
various operation mode on different hardware.

These speed tests don\'t write to an actual disk, but only to the
[/dev/null]{.title-ref} device, which is a device that does nothing. So
these speed test results do not include the speed limits of any actual
disk hardware.

    =====================================  =========  ===============================  =================
    Command                                Algorithm  Hardware                         Data rate written
    =====================================  =========  ===============================  =================
    disktest -j12 -ACHACHA20 -w /dev/null  ChaCha20   AMD Ryzen 5 5500U; 6x2 cores     7.1 GiB/s
    disktest -j12 -ACHACHA12 -w /dev/null  ChaCha12   AMD Ryzen 5 5500U; 6x2 cores     7.3 GiB/s
    disktest -j12 -ACHACHA8 -w /dev/null   ChaCha8    AMD Ryzen 5 5500U; 6x2 cores     7.3 GiB/s
    disktest -j12 -ACRC -w /dev/null       CRC        AMD Ryzen 5 5500U; 6x2 cores     7.5 GiB/s
    disktest -j4 -ACHACHA20 -w /dev/null   ChaCha20   Intel i5-3320M; 2x2 cores        2.0 GiB/s
    disktest -j4 -ACHACHA12 -w /dev/null   ChaCha12   Intel i5-3320M; 2x2 cores        3.1 GiB/s
    disktest -j4 -ACHACHA8 -w /dev/null    ChaCha8    Intel i5-3320M; 2x2 cores        4.2 GiB/s
    disktest -j4 -ACRC -w /dev/null        CRC        Intel i5-3320M; 2x2 cores        4.6 GiB/s
    disktest -j4 -ACHACHA20 -w /dev/null   ChaCha20   Raspberry Pi 4; 4 cores 1.5 GHz  300 MiB/s
    disktest -j4 -ACHACHA12 -w /dev/null   ChaCha12   Raspberry Pi 4; 4 cores 1.5 GHz  400 MiB/s
    disktest -j4 -ACHACHA8 -w /dev/null    ChaCha8    Raspberry Pi 4; 4 cores 1.5 GHz  500 MiB/s
    disktest -j4 -ACRC -w /dev/null        CRC        Raspberry Pi 4; 4 cores 1.5 GHz  680 MiB/s
    =====================================  =========  ===============================  =================

The read data rates are similar, because the algorithm used is exactly
the same.

Note: The default rust compiler shipped with Raspberry Pi OS is too old
to compile Disktest. A newer Rust compiler must be used on Raspberry Pi.

License
=======

Copyright (c) 2020-2022 Michael Buesch \<<m@bues.ch>\>

Licensed under the terms of the GNU General Public License version 2, or
(at your option) any later version.
