use read_write_at::{WriteAtMut, ReadAtMut};
// use std::mem::MaybeUninit;

pub trait RandomAccessFile: ReadAtMut + WriteAtMut {
    fn read_to_end(&mut self, offset: u64) -> Result<Vec<u8>, std::io::Error>;
    fn size(&self) -> Result<u64, std::io::Error>;
    fn size_from(&self, offset: u64) -> Result<u64, std::io::Error> {
        Ok(self.size()? - offset)
    }
}

impl RandomAccessFile for std::fs::File {
    fn read_to_end(&mut self, offset: u64) -> Result<Vec<u8>, std::io::Error> {
        let len = self.size_from(offset)? as usize;
        // let buf: &mut [u8] = &mut vec![unsafe { MaybeUninit::uninit().assume_init()}; len];
        let mut buf = vec![0; len];
        self.read_exact_at(buf.as_mut_slice(), offset)?;
        Ok(buf)
    }

    // This should be in bytes.
    fn size(&self) -> Result<u64, std::io::Error> {
        Ok(self.metadata()?.len())
    }
}