# Get disk list information and collect into Vec
[![crates.io](https://img.shields.io/crates/v/systemstat.svg)](https://crates.io/crates/disk_list)
[![API Docs](https://docs.rs/systemstat/badge.svg)](https://docs.rs/disk_list/)
[![unlicense](https://img.shields.io/badge/un-license-green.svg?style=flat)](https://unlicense.org)

|  Supported platforms  | 
| ----------- | 
|FreeBSD|
|Linux|
|OpenBSD|
|Windows|
|macOS|

## Examples
```rust
use disk_list;
fn get(){
     let list = disk_list::get_disk_list();
    //get disk info vec![vec![mount_from,file_type,mount_on,available_space,total_space]]
    assert_eq!(
        vec![
            vec!["C", "NTFS", "C:\\", "18.2 GB", "107.4 GB"],
            vec!["FILE", "FAT32", "D:\\", "191.1 GB", "214.7 GB"],
            vec!["DATA", "NTFS", "E:\\", "678.5 GB", "785.5 GB"]
        ],
        list
    );
}
```
