# Summary

- [Introduction](README.md)
- [Roadmap](ROADMAP.md)
- [Getting Set Up](setup.md)
- [Hello, World!](hello_world.md)
- [Describing the UI](elements/index.md)
  - [Intro to Elements](elements/vnodes.md)
  - [Conditional Rendering](elements/conditional_rendering.md)
  - [Lists](elements/lists.md)
  - [Special Attributes](elements/special_attributes.md)
- [Components](components/index.md)
  - [Properties](components/propsmacro.md)
  - [Reusing, Importing, and Exporting](components/exporting_components.md)
  - [Children and Attributes](components/component_children.md)
  - [How Data Flows](components/composing.md)
- [Adding Interactivity](interactivity/index.md)
  - [Event Listeners](interactivity/event_handlers.md)
  - [Hooks](interactivity/hooks.md)
  - [UseState](interactivity/usestate.md)
  - [UseRef](interactivity/useref.md)
  - [User Input](interactivity/user_input.md)
  <!-- - [Effects](interactivity/lifecycles.md) -->
- [Managing State](state/index.md)
  - [Local State](state/localstate.md)
  - [Global State](state/sharedstate.md)
  - [Lifting State](state/liftingstate.md)
  - [Error handling](state/errorhandling.md)
- [Helper Crates](helpers/index.md)
  - [Fermi](state/fermi.md)
  - [Router](state/router.md)
- [Working with Async](async/index.md)
  - [UseFuture](async/use_future.md)
  - [UseCoroutine](async/coroutines.md)
  <!-- - [Fetching](async/fetching.md) -->
  <!-- - [Updating State](async/loading_state.md)
  - [WebSockets](async/sockets.md) -->
  <!-- - [Tasks](async/asynctasks.md) -->

<!--
- [Putting it all together: Dog Search Engine](tutorial/index.md)
  - [New app](tutorial/new_app.md)
  - [Structuring our app](tutorial/structure.md)
  - [Defining State](tutorial/state.md)
  - [Defining Components](tutorial/components.md)
  - [Styling](tutorial/styling.md)
  - [Bundling](tutorial/publishing.md) -->


- [Next Steps and Advanced Topics](final.md)


-----------

[Contributors](misc/contributors.md)


  <!-- - [Suspense](concepts/suspense.md) -->
  <!-- - [Async Callbacks](concepts/asynccallbacks.md) -->

