# Reference Guide

This folder holds a bunch of useful reference code. However, none of the code is meant to be executed (nothing special will happen).


| Reference:                                          | What it does                                           |
| --------------------------------------------------- | ------------------------------------------------------ |
| [Basics](./basics.rs)                               | How to render a simple app                             |
| [Empty](./empty.rs)                                 | Components can return None                             |
| [Children](./children.rs)                           | Components can have children                           |
| [Suspense](./suspense.rs)                           | Suspense can be achieved with use_suspense             |
| [Conditional Rendering](./conditional_rendering.rs) | Elements can be hidden conditionally                   |
| [Controlled Inputs](./controlled_inputs.rs)         | Inputs are "controlled" similar to React               |
| [Fragments](./fragments.rs)                         | Components can return multiple elements without a root |
| [Inline Styles](./inline_styles.rs)                 | Styles can be inlined as element attributes            |
| [Spread Pattern for Props](./spreadpattern.rs)      | Props can be spread into component calls               |
| [Iterators](./iterators.rs)                         | Lists of elements can be made from iterators           |
| [Listener](./listener.rs)                           | State can be updated from event listeners              |
| [Memo](./memo.rs)                                   | Memoization is controlled via PartialEq                |
| [Custom Elements](./custom_elements.rs)             | Define custom elements                                 |
| [Anti-patterns](./antipatterns.rs)                  | What not to do!                                        |
