# Dioxus: Reference and Advanced Guides

![dioxuslogo](./images/dioxuslogo_full.png)

**Dioxus** is a framework and ecosystem for building fast, scalable, and robust user interfaces with the Rust programming language. This guide will help you get started with Dioxus running on the Web, Desktop, Mobile, and more.

> This book is the reference and Advanced Guides for the Dioxus framework. For a tutorial on how to actually *use* Dioxus, make sure to check out the [official guide](https://dioxuslabs.com/guide/).


## Reference and Guides

With the reference, we aim to maintain documentation of functionality that might not be mentioned in the official guide to keep the information load to a minimum. Some topics not included by the guide but discussed in the reference include:

- ThreadSafety of the VirtualDom
- Full usage of `rsx!` and included features
- Spread pattern for component properties
- Testing
- Memoization in Depth
- Custom Elements
- Custom Renderers


## Contributing

If this doc is lacking in any way, is confusing, has a typo, or you'd just like to help improve things, feel free to make a PR against the [Dioxus repo](https://github.com/DioxusLabs/dioxus/tree/master/docs/reference).

All contributions will be licensed under MIT/Apache2.
