# Congrats!

Congrats! You've made it through the `learning Dioxus` book. Throughout this tutorial, you've learned a ton:

- How to build User Interfaces with Elements
- How to compose Element groups together as Components
- How to handle user input with event listeners
- How to manage local and global state
- How to work with async using tasks, coroutines, and suspense
- How to build custom hooks and handlers

With any luck, you followed through the "Putting it All Together" mini guide and have your very own dog search engine app!

# Next Steps and Advanced Topics

Continuing on your journey with Dioxus, you can try a number of things:

- Build a simple TUI app 
- Publish your search engine app
- Deploy a WASM app to GitHub
- Design a custom hook
- Contribute to the ecosystem!

There are a number of advanced topics we glossed over:

- The underlying NodeFactory API
- Static elements and templates
- Anti-patterns
- Bundling/distribution
- Working with wasm apps

# Contributing to the ecosystem

Dioxus is still quite young and could use your help!

The core team is actively working on:

- Declarative window management (via Tauri) for Desktop apps
- Portals for Dioxus Core
- Mobile support 
- Integration with 3D renderers
- Better async story (suspense, error handling)
- Global state management
- Web development server
- LiveView
- Broader platform support (iOS/Android/TV/embedded)

If there's something specifically interesting to you, don't be afraid to jump in!

