
rule EXPL_Shitrix_Exploit_Code_Jan20_1 {
   meta:
      description = "Detects payloads used in Shitrix exploitation CVE-2019-19781"
      author = "Florian Roth"
      reference = "https://isc.sans.edu/forums/diary/Citrix+ADC+Exploits+Overview+of+Observed+Payloads/25704/"
      date = "2020-01-13"
      score = 70
      type = "file"
   strings:
      $s01 = "/netscaler/portal/scripts/rmpm.pl" ascii
      $s02 = "tee /netscaler/portal/templates/" ascii
      $s03 = "exec(\\'(wget -q -O- http://" ascii
      $s04 = "cd /netscaler/portal; ls" ascii
      $s05 = "cat /flash/nsconfig/ns.conf" ascii
      $s06 = "/netscaler/portal/scripts/PersonalBookmak.pl" ascii
      $s07 = "template.new({'BLOCK'='print readpipe(" ascii /* TrustedSec templae */
      $s08 = "pwnpzi1337" fullword ascii /* PZI india static user name */
      $s09 = "template.new({'BLOCK'=" /* PZI exploit URL decoded form */
      $s10 = "template.new({'BLOCK'%3d" /* PZI exploit URl encoded form */
      $s11 = "my ($citrixmd, %FORM);" /* Perl backdoor */
      $s12 = "(CMD, \"($citrixmd) 2>&1" /* Perl backdoor */

      $b1 = "NSC_USER:" ascii nocase /* https://twitter.com/ItsReallyNick/status/1217308463174496256 */
      $b2 = "NSC_NONCE:" ascii nocase /* https://twitter.com/ItsReallyNick/status/1217308463174496256 */
      $b3 = "/../" ascii
   condition:
      1 of ($s*) or all of ($b*)
}
