/*
   Yara Rule Set
   Author: Florian Roth
   Date: 2016-10-08
   Identifier: Malware - October 2016
*/

/* Rule Set ----------------------------------------------------------------- */

rule Unspecified_Malware_Oct16_A {
   meta:
      description = "Detects an unspecififed malware - October 2016"
      license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
      reference = "Internal Research"
      date = "2016-10-08"
      score = 80
      hash1 = "d112a7e21902287e4a37112bf17d7c73a7b206e7bc81780fd87991c1519f38c8"
   strings:
      $x1 = "%s\\system32\\%s.dll" fullword ascii
      $x2 = "%SystemRoot%\\System32\\svch%s -k nets" fullword ascii
      $x3 = "\\\\.\\pipe\\96DBA249-E88E-4c47-98DC-E18E6E3E3E5A" fullword ascii

      $s1 = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Image File Execution Options" fullword ascii
      $s2 = "boottemp.exe" fullword ascii
      $s3 = "at \\\\%s %d:%d C:\\%s.exe" fullword ascii
      $s4 = "cryptcom.dll" fullword ascii
      $s5 = "Wininet.dll" fullword ascii
      $s6 = "\\\\%s\\%s\\%s.exe" fullword ascii
      $s7 = "%s%d.exe" fullword ascii
      $s8 = "booter.exe" fullword ascii
      $s9 = "\\\\%s\\pipe%s" fullword ascii
      $s10 = "C:\\DelInfo.bin" fullword ascii

      $op0 = { ae 44 00 00 cb 44 00 00 dc 44 00 00 f5 44 00 00 } /* Opcode */
      $op1 = { ae 44 00 00 cb 44 00 00 dc 44 00 00 f5 44 00 00 } /* Opcode */
      $op2 = { ee 11 74 cf 73 0b 91 c4 c9 57 b2 d9 36 86 a5 b4 } /* Opcode */
   condition:
      /* File Detection */
      ( uint16(0) == 0x5a4d and filesize < 1000KB and (
         2 of ($x*) or 3 of ($s*) or all of ($op*)
      ) )
      /* In Memory */
      or ( 6 of them )
}

rule Sality_Malware_Oct16 {
   meta:
      description = "Detects an unspecififed malware - October 2016"
      license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
      reference = "Internal Research"
      date = "2016-10-08"
      score = 80
      hash1 = "8eaff5e1d4b55dd6e25f007549271da10afd1fa25064d7105de0ca2735487aad"
   strings:
      $s1 = "Hello world!" fullword wide
      $s2 = "[LordPE]" fullword ascii
   condition:
      ( uint16(0) == 0x5a4d and filesize < 300KB and all of them )
}

rule Unspecified_Malware_Oct16_C {
   meta:
      description = "Detects an unspecififed malware - October 2016"
      license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
      reference = "Internal Research"
      date = "2016-10-08"
      score = 80
      hash1 = "a451157f75627b2fef3d663946c94ef7dacb58f08b31d0ec4c0a542a1c4e6205"
   strings:
      $s1 = "dUSER32.DLL" fullword wide
      $s2 = "output.dll" fullword ascii
   condition:
      ( uint16(0) == 0x5a4d and filesize < 5000KB and all of them )
}

/*
   Yara Rule Set
   Author: Florian Roth
   Date: 2016-10-08
   Identifier: Malware October 2016
*/

/* Rule Set ----------------------------------------------------------------- */

rule Bladabindi_Malware_B64 {
   meta:
      description = "Detects Bladabindi Malware using Base64 encoded strings"
      license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
      reference = "Internal Research"
      date = "2016-10-08"
      hash1 = "dda668b0792b7679979e61f2038cf9a8ec39415cc161be00d2c8301e7d48768d"
   strings:
      $s1 = "XHN5c3RlbTMyXA==" fullword ascii /* base64 encoded string '\system32\' */
      $s2 = "RXhlY3V0ZSBFUlJPUg==" fullword ascii /* base64 encoded string 'Execute ERROR' */
      $s3 = "dHJvamFuLmV4ZQ==" fullword ascii /* base64 encoded string 'trojan.exe' */
      $s4 = "VXBkYXRlIEVSUk9S" fullword ascii /* base64 encoded string 'Update ERROR' */
      $s5 = "RG93bmxvYWQgRVJST1I=" fullword ascii /* base64 encoded string 'Download ERROR' */
   condition:
      uint16(0) == 0x5a4d and filesize < 700KB and 1 of them
}

rule Dorkbot_Injector_Malware {
   meta:
      description = "Detects Darkbot Injector"
      license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
      reference = "Internal Research"
      date = "2016-10-08"
      hash1 = "bc3c5ac7180c8ac21d6908d747aa6122154d2bb51bb99ff0e0b1c65088d275dc"
   strings:
      $s1 = "Enter an integer, a real number, a character and a string : " fullword ascii
      $s2 = "ready to finish" fullword ascii
      $s3 = "EYEnpw" fullword ascii
      $s4 = "somewhere i belong" fullword ascii
      $s5 = "Not all fields were assigned" fullword ascii
      $s6 = "take down" fullword ascii
      $s7 = "real number = %f" fullword ascii
   condition:
      ( uint16(0) == 0x5a4d and filesize < 500KB and 6 of them )
}

rule Unspecified_Malware_Oct16_D {
   meta:
      description = "Detects unspecified malware - October 2016"
      license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
      reference = "Internal Research"
      date = "2016-10-08"
      hash1 = "cd5f3bc0176a6803093ffdea6a7442c416e0d2945b6903063d17f5bb8d17519d"
   strings:
      $s1 = "C:\\file.exe" fullword wide
      $s2 = "new.exe" fullword wide
      $s3 = "passwordIterations" fullword ascii

      $op0 = { 10 00 12 00 1a 00 05 00 01 00 01 00 01 00 10 00 } /* Opcode */
      $op1 = { 41 32 00 36 00 62 00 34 00 32 00 65 00 37 00 62 } /* Opcode */
      $op2 = { 3c 4d 6f 64 75 6c 65 3e 00 6e 65 77 2e 65 78 65 } /* Opcode */
   condition:
      uint16(0) == 0x5a4d and filesize < 1000KB and ( all of ($s*) or all of ($op*) )
}

rule Unspecified_Malware_Oct16_E {
   meta:
      description = "Detects unspecified Malware - October 2016"
      license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
      reference = "Internal Research"
      date = "2016-10-08"
      hash1 = "28093385130b61f22920c0ce6e56de1f2cd8eef589bebe2af31f36f51f2b4d01"
   strings:
      $s1 = "P3pORt" fullword ascii
      $s2 = "msdownld.tmp" fullword ascii
      $s3 = "TMP4351$.TMP" fullword ascii
   condition:
      ( uint16(0) == 0x5a4d and filesize < 1000KB and all of them )
}
