
/* Malware ----------------------------------------------------------------- */

rule TrojanDownloader {
	meta:
		description = "Trojan Downloader - Flash Exploit Feb15"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "http://goo.gl/wJ8V1I"
		date = "2015/02/11"
		hash = "5b8d4280ff6fc9c8e1b9593cbaeb04a29e64a81e"
		score = 60
	strings:
		$x1 = "Hello World!" fullword ascii
		$x2 = "CONIN$" fullword ascii

		$s6 = "GetCommandLineA" fullword ascii
		$s7 = "ExitProcess" fullword ascii
		$s8 = "CreateFileA" fullword ascii

		$s5 = "SetConsoleMode" fullword ascii
		$s9 = "TerminateProcess" fullword ascii
		$s10 = "GetCurrentProcess" fullword ascii
		$s11 = "UnhandledExceptionFilter" fullword ascii
		$s3 = "user32.dll" fullword ascii
		$s16 = "GetEnvironmentStrings" fullword ascii
		$s2 = "GetLastActivePopup" fullword ascii
		$s17 = "GetFileType" fullword ascii
		$s19 = "HeapCreate" fullword ascii
		$s20 = "VirtualFree" fullword ascii
		$s21 = "WriteFile" fullword ascii
		$s22 = "GetOEMCP" fullword ascii
		$s23 = "VirtualAlloc" fullword ascii
		$s24 = "GetProcAddress" fullword ascii
		$s26 = "FlushFileBuffers" fullword ascii
		$s27 = "SetStdHandle" fullword ascii
		$s28 = "KERNEL32.dll" fullword ascii
	condition:
		$x1 and $x2 and ( all of ($s*) ) and filesize < 35000
}

/*
   Yara Rule Set
   Author: Florian Roth
   Date: 2017-08-01
   Identifier: IsmDoor
   Reference: https://twitter.com/Voulnet/status/892104753295110145
   License: http://creativecommons.org/licenses/by-nc-sa/4.0/
*/

/* Rule Set ----------------------------------------------------------------- */

rule IsmDoor_Jul17_A2 {
   meta:
      description = "Detects IsmDoor Malware"
      license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
      reference = "https://twitter.com/Voulnet/status/892104753295110145"
      date = "2017-08-01"
      hash1 = "be72c89efef5e59c4f815d2fce0da5a6fac8c90b86ee0e424868d4ae5e550a59"
      hash2 = "ea1be14eb474c9f70e498c764aaafc8b34173c80cac9a8b89156e9390bd87ba8"
   strings:
      $s1 = "powershell -exec bypass -file \"" fullword ascii
      $s2 = "PAQlFcaWUaFkVICEx2CkNCUUpGcA" ascii
      $s3 = "\\Documents" fullword ascii
      $s4 = "\\Libraries" fullword ascii
   condition:
      ( uint16(0) == 0x5a4d and filesize < 300KB and 3 of them )
}

rule Unknown_Malware_Sample_Jul17_2 {
   meta:
      description = "Detects unknown malware sample with pastebin RAW URL"
      license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
      reference = "https://goo.gl/iqH8CK"
      date = "2017-08-01"
      hash1 = "3530d480db082af1823a7eb236203aca24dc3685f08c301466909f0794508a52"
   strings:
      $s1 = "4System.Web.Services.Protocols.SoapHttpClientProtocol" fullword ascii
      $s2 = "https://pastebin.com/raw/" wide
      $s3 = "My.Computer" fullword ascii
      $s4 = "MyTemplate" fullword ascii
   condition:
      ( uint16(0) == 0x5a4d and filesize < 200KB and all of them )
}

rule MAL_unspecified_Jan18_1 {
   meta:
      description = "Detects unspecified malware sample"
      license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
      reference = "Internal Research"
      date = "2018-01-19"
      hash1 = "f87879b29ff83616e9c9044bd5fb847cf5d2efdd2f01fc284d1a6ce7d464a417"
   strings:
      $s1 = "User-Agent: Mozilla/4.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko" fullword ascii
      $s2 = "ping 192.0.2.2 -n 1 -w %d >nul 2>&1" fullword ascii
      $s3 = "[Log Started] - [%.2d/%.2d/%d %.2d:%.2d:%.2d]" fullword ascii
      $s4 = "start /b \"\" cmd /c del \"%%~f0\"&exit /b" fullword ascii
      $s5 = "[%s] - [%.2d/%.2d/%d %.2d:%.2d:%.2d]" fullword ascii
      $s6 = "%s\\%s.bat" fullword ascii
      $s7 = "DEL /s \"%s\" >nul 2>&1" fullword ascii
   condition:
      filesize < 300KB and 2 of them
}
