/*
    Yara Rule Set
    Author: Florian Roth
    Date: 2015-06-23
    Identifier: CN-PentestSet
*/

rule CN_Honker_mafix_root {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file root"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "826778ef9c22177d41698b467586604e001fed19"
    strings:
        $s0 = "echo \"# vbox (voice box) getty\" >> /tmp/.init1" fullword ascii /* PEStudio Blacklist: strings */
        $s1 = "cp /var/log/tcp.log $HOMEDIR/.owned/bex2/snifflog" fullword ascii
        $s2 = "if [ -f /sbin/xlogin ]; then" fullword ascii /* PEStudio Blacklist: strings */
    condition:
        filesize < 96KB and all of them
}

rule CN_Honker_passwd_dict_3389 {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file 3389.txt"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "2897e909e48a9f56ce762244c3a3e9319e12362f"
    strings:
        $s0 = "654321" fullword ascii /* reversed goodware string '123456' */
        $s1 = "admin123" fullword ascii /* PEStudio Blacklist: strings */
        $s2 = "admin123456" fullword ascii /* PEStudio Blacklist: strings */
        $s3 = "administrator" fullword ascii /* PEStudio Blacklist: strings */ /* Goodware String - occured 2 times */
        $s4 = "passwd" fullword ascii /* PEStudio Blacklist: strings */ /* Goodware String - occured 42 times */
        $s5 = "password" fullword ascii /* PEStudio Blacklist: strings */ /* Goodware String - occured 244 times */
        $s7 = "12345678" fullword ascii /* Goodware String - occured 29 times */
    condition:
        filesize < 1KB and all of them
}

rule CN_Honker_Perl_serv_U {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file Perl-serv-U.pl"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "f333c597ff746ebd5a641fbc248497d61e3ec17b"
    strings:
        $s1 = "$dir = 'C:\\\\WINNT\\\\System32\\\\';" fullword ascii /* PEStudio Blacklist: strings */
        $s2 = "$sock = IO::Socket::INET->new(\"127.0.0.1:$adminport\") || die \"fail\";" fullword ascii /* PEStudio Blacklist: strings */
    condition:
        filesize < 8KB and all of them
}

rule CN_Honker_F4ck_Team_f4ck {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file f4ck.txt"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "e216f4ba3a07de5cdbb12acc038cd8156618759e"
    strings:
        $s0 = "PassWord:F4ckTeam!@#" fullword ascii /* PEStudio Blacklist: strings */
        $s1 = "UserName:F4ck" fullword ascii /* PEStudio Blacklist: strings */
        $s2 = "F4ck Team" fullword ascii
    condition:
        filesize < 1KB and all of them
}

rule CN_Honker_sig_3389_3389 {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file 3389.vbs"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "f92b74f41a2138cc05c6b6993bcc86c706017e49"
    strings:
        $s1 = "success = obj.run(\"cmd /c takeown /f %SystemRoot%\\system32\\sethc.exe&echo y| " ascii /* PEStudio Blacklist: strings */
    condition:
        filesize < 10KB and all of them
}

rule CN_Honker_sig_3389_3389_2 {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file 3389.bat"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "5ff92f39ade12f8ba6cb75dfdc9bb907e49f0ebd"
    strings:
        $s1 = "@del c:\\termsrvhack.dll" fullword ascii
        $s2 = "@del c:\\3389.txt" fullword ascii
    condition:
        filesize < 3KB and all of them
}

rule CN_Honker_Injection_Transit_jmCook {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file jmCook.asp"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "5e1851c77ce922e682333a3cb83b8506e1d7395d"
    strings:
        $s1 = ".Open \"POST\",PostUrl,False" fullword ascii /* PEStudio Blacklist: strings */
        $s2 = "JmdcwName=request(\"jmdcw\")" fullword ascii /* PEStudio Blacklist: strings */
    condition:
        filesize < 9KB and all of them
}

rule CN_Honker_Pwdump7_Pwdump7 {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file Pwdump7.bat"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "67d0e215c96370dcdc681bb2638703c2eeea188a"
    strings:
        $s1 = "Pwdump7.exe >pass.txt" fullword ascii /* PEStudio Blacklist: strings */
    condition:
        filesize < 1KB and all of them
}

rule CN_Honker_portRecall_pr {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file pr"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "583cf6dc2304121d835f2879803a22fea76930f3"
    strings:
        $s1 = "Usage: Same as lcx.exe in win32 :)" fullword ascii
        $s2 = "connect to client" fullword ascii /* PEStudio Blacklist: strings */
        $s3 = "PR(Packet redirection) for linux " fullword ascii /* PEStudio Blacklist: strings */
    condition:
        filesize < 70KB and all of them
}

rule CN_Honker_sig_3389_3389_3 {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file 3389.bat"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "cfedec7bd327897694f83501d76063fe16b13450"
    strings:
        $s1 = "echo \"fDenyTSConnections\"=dword:00000000>>3389.reg " fullword ascii /* PEStudio Blacklist: strings */
        $s2 = "echo \"PortNumber\"=dword:00000d3d>>3389.reg " fullword ascii /* PEStudio Blacklist: strings */
        $s3 = "echo [HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Terminal Server]>>" ascii /* PEStudio Blacklist: strings */
    condition:
        filesize < 2KB and all of them
}

rule CN_Honker_Alien_D {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file D.ASP"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "de9cd4bd72b1384b182d58621f51815a77a5f07d"
    strings:
        $s0 = "Paths_str=\"c:\\windows\\\"&chr(13)&chr(10)&\"c:\\Documents and Settings\\\"&chr" ascii /* PEStudio Blacklist: strings */
        $s1 = "CONST_FSO=\"Script\"&\"ing.Fil\"&\"eSyst\"&\"emObject\"" fullword ascii /* PEStudio Blacklist: strings */
        $s2 = "Response.Write \"<form id='form1' name='form1' method='post' action=''>\"" fullword ascii /* PEStudio Blacklist: strings */
        $s3 = "set getAtt=FSO.GetFile(filepath)" fullword ascii
        $s4 = "Response.Write \"<input name='NoCheckTemp' type='checkbox' id='NoCheckTemp' chec" ascii
    condition:
        filesize < 30KB and 2 of them
}

rule CN_Honker_ChinaChopper_db {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file db.mdb"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "af79ff2689a6b7a90a5d3c0ebe709e42f2a15597"
    strings:
        $s1 = "http://www.maicaidao.com/server.phpcaidao" fullword wide /* PEStudio Blacklist: strings */
        $s2 = "<O>act=login</O>" fullword wide /* PEStudio Blacklist: strings */
        $s3 = "<H>localhost</H>" fullword wide /* PEStudio Blacklist: strings */
    condition:
        filesize < 340KB and 2 of them
}

rule CN_Honker_syconfig {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file syconfig.dll"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "ff75353df77d610d3bccfbffb2c9dfa258b2fac9"
    strings:
        $s9 = "Hashq.CrackHost+FormUnit" fullword ascii /* PEStudio Blacklist: strings */
    condition:
        uint16(0) == 0x0100 and filesize < 18KB and all of them
}

rule CN_Honker_linux_bin {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file linux_bin"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "26e71e6ebc6a3bdda9467ce929610c94de8a7ca0"
    strings:
        $s1 = "client.sin_port = htons(atoi(argv[3]));" fullword ascii /* PEStudio Blacklist: strings */
        $s2 = "printf(\"\\n\\n*********Waiting Client connect*****\\n\\n\");" fullword ascii /* PEStudio Blacklist: strings */
    condition:
        filesize < 20KB and all of them
}

rule CN_Honker_Intersect2_Beta {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file Intersect2-Beta.py"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "3ba5f720c4994cd4ad519b457e232365e66f37cc"
    strings:
        $s1 = "os.system(\"ls -alhR /home > AllUsers.txt\")" fullword ascii /* PEStudio Blacklist: strings */
        $s2 = "os.system('getent passwd > passwd.txt')" fullword ascii /* PEStudio Blacklist: strings */
        $s3 = "os.system(\"rm -rf credentials/\")" fullword ascii /* PEStudio Blacklist: strings */
    condition:
        uint16(0) == 0x2123 and filesize < 50KB and 2 of them
}

rule CN_Honker_IIS_logcleaner1_0_readme {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file readme.txt"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "2ab47d876b49e9a693f602f3545381415e82a556"
    strings:
        $s2 = "LogCleaner.exe <ip> [Logpath]" fullword ascii
        $s3 = "http://l-y.vicp.net" fullword ascii
    condition:
        filesize < 7KB and all of them
}

rule CN_Honker_Alien_command {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file command.txt"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "5896b74158ef153d426fba76c2324cd9c261c709"
    strings:
        $s0 = "for /d %i in (E:\\freehost\\*) do @echo %i" fullword ascii /* PEStudio Blacklist: strings */
        $s1 = "/c \"C:\\windows\\temp\\cscript\" C:\\windows\\temp\\iis.vbs" fullword ascii /* PEStudio Blacklist: strings */
    condition:
        filesize < 8KB and all of them
}

rule CN_Honker_portRecall_bc {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file bc.pl"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "2084990406398afd856b2309c7f579d7d61c3767"
    strings:
        $s0 = "print \"[*] Connected to remote host \\n\"; " fullword ascii /* PEStudio Blacklist: strings */
        $s1 = "print \"Usage: $0 [Host] [Port] \\n\\n\";  " fullword ascii /* PEStudio Blacklist: strings */
        $s5 = "print \"[*] Resolving HostName\\n\"; " fullword ascii /* PEStudio Blacklist: strings */
    condition:
        filesize < 10KB and all of them
}

rule CN_Honker_Tuoku_script_MSSQL_ {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file MSSQL_.asp"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "7097c21f92306983add3b5b29a517204cd6cd819"
    strings:
        $s1 = "GetLoginCookie = Request.Cookies(Cookie_Login)" fullword ascii /* PEStudio Blacklist: strings */
        $s2 = "if ShellPath=\"\" Then ShellPath = \"c:\\\\windows\\\\system32\\\\cmd.exe\"" fullword ascii /* PEStudio Blacklist: strings */
        $s8 = "Set DD=CM.exec(ShellPath&\" /c \"&DefCmd)" fullword ascii /* PEStudio Blacklist: strings */
    condition:
        filesize < 100KB and all of them
}

rule CN_Honker_nc_MOVE {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file MOVE.txt"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "4195370c103ca467cddc8f2724a8e477635be424"
    strings:
        $s0 = "Destination: http://202.113.20.235/gj/images/2.asp" fullword ascii /* PEStudio Blacklist: strings */
        $s1 = "HOST: 202.113.20.235" fullword ascii /* PEStudio Blacklist: strings */
        $s2 = "MOVE /gj/images/A.txt HTTP/1.1" fullword ascii
    condition:
        filesize < 1KB and all of them
}

rule CN_Honker_mssqlpw_scan {
    meta:
        description = "Script from disclosed CN Honker Pentest Toolset - file mssqlpw scan.txt"
        license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
        reference = "Disclosed CN Honker Pentest Toolset"
        date = "2015-06-23"
		score = 70
        hash = "e49def9d72bfef09a639ef3f7329083a0b8b151c"
    strings:
        $s0 = "response.Write(\"I Get it ! Password is <font color=red>\" & str & \"</font><BR>" ascii /* PEStudio Blacklist: strings */
        $s1 = "response.Write \"Done!<br>Process \" & tTime & \" s\"" fullword ascii /* PEStudio Blacklist: strings */
    condition:
        filesize < 6KB and all of them
}
