
/*
	Yara Rule Set
	Author: Florian Roth
	Date: 2016-08-29
	Identifier: VT Research QA Malware
*/

/* Rule Set ----------------------------------------------------------------- */

/* Rules that can be used in any tool with YARA support */

rule Malware_QA_not_copy {
	meta:
		description = "VT Research QA uploaded malware - file not copy.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "VT Research QA"
		date = "2016-08-29"
		score = 80
		hash1 = "1410f38498567b64a4b984c69fe4f2859421e4ac598b9750d8f703f1d209f836"
	strings:
		$x1 = "U2VydmVyLmV4ZQ==" fullword wide /* base64 encoded string 'Server.exe' */
		$x2 = "\\not copy\\obj\\Debug\\not copy.pdb" ascii
		$x3 = "fuckyou888.ddns.net" fullword wide

		$s1 = "cmd.exe /c ping 0 -n 2 & del \"" fullword wide
		$s2 = "Server.exe" fullword wide
		$s3 = "Execute ERROR" fullword wide
		$s4 = "not copy.exe" fullword wide
		$s5 = "Non HosT" fullword wide
		$s6 = "netsh firewall delete allowedprogram" fullword wide
	condition:
		( uint16(0) == 0x5a4d and filesize < 1000KB and ( 1 of ($x*) or 4 of ($s*) ) )
		or ( 5 of them )
}

rule Malware_QA_update {
	meta:
		description = "VT Research QA uploaded malware - file update.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "VT Research QA"
		date = "2016-08-29"
		score = 80
		hash1 = "6d805533623d7063241620eec38b7eb9b625533ccadeaf4f6c2cc6db32711541"
		hash2 = "6415b45f5bae6429dd5d92d6cae46e8a704873b7090853e68e80cd179058903e"
	strings:
		$x1 = "UnActiveOfflineKeylogger" fullword ascii
		$x2 = "BTRESULTDownload File|Mass Download : File Downloaded , Executing new one in temp dir...|" fullword ascii
		$x3 = "ActiveOnlineKeylogger" fullword ascii
		$x4 = "C:\\Users\\DarkCoderSc\\" ascii
		$x5 = "Celesty Binder\\Stub\\STATIC\\Stub.pdb" ascii
		$x6 = "BTRESULTUpdate from URL|Update : File Downloaded , Executing new one in temp dir...|" fullword ascii

		$s1 = "MSRSAAP.EXE" fullword wide
		$s2 = "Command successfully executed!|" fullword ascii
		$s3 = "BTMemoryLoadLibary: Get DLLEntyPoint failed" fullword ascii
		$s4 = "I wasn't able to open the hosts file, maybe because UAC is enabled in remote computer!" fullword ascii
		$s5 = "\\Internet Explorer\\iexplore.exe" fullword ascii
		$s6 = "ping 127.0.0.1 -n 4 > NUL && \"" fullword ascii
		$s7 = "BTMemoryGetProcAddress: DLL doesn't export anything" fullword ascii
		$s8 = "POST /index.php/1.0" fullword ascii
	condition:
		( uint16(0) == 0x5a4d and filesize < 3000KB and ( 1 of ($x*) or 3 of ($s*) ) )
		or ( all of them )
}

rule Malware_QA_tls {
	meta:
		description = "VT Research QA uploaded malware - file tls.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "VT Research QA"
		date = "2016-08-29"
		score = 80
		hash1 = "f06d1f2bee2eb6590afbfa7f011ceba9bd91ba31cdc721bc728e13b547ac9370"
	strings:
		$s1 = "\\funoverip\\ultimate-payload-template1\\" ascii
		$s2 = "ULTIMATEPAYLOADTEMPLATE1" fullword wide
		$s3 = "ultimate-payload-template1" fullword wide
	condition:
		( uint16(0) == 0x5a4d and filesize < 300KB and 1 of them ) or ( all of them )
}

rule Malware_QA_get_The_FucKinG_IP {
	meta:
		description = "VT Research QA uploaded malware - file get The FucKinG IP.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "VT Research QA"
		date = "2016-08-29"
		score = 80
		hash1 = "7b2c04e384919075be96e3412d92c14fc1165d1bc7556fd207488959c5c4d2f7"
	strings:
		$x1 = "C:\\Users\\Mdram ahmed\\AppData"
		$x2 = "\\Local\\Temporary Projects\\get The FucKinG IP\\" ascii
		$x3 = "get The FucKinG IP.exe" fullword wide
		$x4 = "get ip by mdr3m" fullword wide
		$x5 = "MDR3M kik: Mdr3mhm" fullword wide
	condition:
		( uint16(0) == 0x5a4d and filesize < 1000KB and 1 of ($x*) ) or ( 2 of them )
}

rule Malware_QA_vqgk {
	meta:
		description = "VT Research QA uploaded malware - file vqgk.dll"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "VT Research QA"
		date = "2016-08-29"
		score = 80
		hash1 = "99541ab28fc3328e25723607df4b0d9ea0a1af31b58e2da07eff9f15c4e6565c"
	strings:
		$x1 = "Z:\\devcenter\\aggressor\\external" ascii
		$x2 = "\\beacon\\Release\\beacon.pdb" fullword ascii
		$x3 = "%d is an x86 process (can't inject x64 content)" fullword ascii
		$x4 = "%d is an x64 process (can't inject x86 content)" fullword ascii

		$s1 = "powershell -nop -exec bypass -EncodedCommand \"%s\"" fullword ascii
		$s2 = "Could not open process token: %d (%u)" fullword ascii
		$s3 = "\\\\%s\\pipe\\msagent_%x" fullword ascii
		$s4 = "\\sysnative\\rundll32.exe" fullword ascii
		$s5 = "Failed to impersonate logged on user %d (%u)" fullword ascii
		$s6 = "IEX (New-Object Net.Webclient).DownloadString('http://127.0.0.1:%u/'); %s" fullword ascii
		$s7 = "could not write to process memory: %d" fullword ascii
		$s8 = "beacon.dll" fullword ascii
		$s9 = "Failed to impersonate token from %d (%u)" fullword ascii
	condition:
		( uint16(0) == 0x5a4d and filesize < 600KB and ( 1 of ($x*) or 5 of ($s*) ) ) or ( 7 of them )
}

rule Malware_QA_1177 {
	meta:
		description = "VT Research QA uploaded malware - file 1177.vbs"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "VT Research QA"
		date = "2016-08-29"
		score = 80
		hash1 = "ff3a2740330a6cbae7888e7066942b53015728c367cf9725e840af5b2a3fa247"
	strings:
		$x1 = ".specialfolders (\"startup\") & \"\\ServerName.EXE\"" fullword ascii
		$x2 = "expandenvironmentstrings(\"%%InsallDir%%\") " ascii

		$s1 = "CreateObject(\"WScript.Shell\").Run(" ascii
		$s2 = "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAA" ascii
		$s3 = "cial Thank's to Dev-point.com" fullword ascii
		$s4 = ".createElement(\"tmp\")" fullword ascii
		$s5 = "'%CopyToStartUp%" fullword ascii
	condition:
		( uint16(0) == 0x4d27 and filesize < 100KB and ( 1 of ($x*) or 4 of ($s*) ) )
		or ( 5 of them )
}
