/*
	Yara Rule Set
	Author: Florian Roth
	Date: 2016-04-09
	Identifier: APT 6 Malware
*/

rule APT6_Malware_Sample_Gen {
	meta:
		description = "Rule written for 2 malware samples that communicated to APT6 C2 servers"
		license = "https://creativecommons.org/licenses/by-nc/4.0/"
		author = "Florian Roth"
		reference = "https://otx.alienvault.com/pulse/56c4d1664637f26ad04e5b73/"
		date = "2016-04-09"
		score = 80
		type = "file"
		hash1 = "321ec239bfa6927d39155ef5f10741ed786219489bbbb1dc8fee66e22f9f8e80"
		hash2 = "7aef130b19d1f940e4c4cee6efe0f190f1402d2e0f741ee605c77518a04cb6d7"
	strings:
		/* Specific strings from samples */
		$x2 = "SPCK!it is a [(?riddle?) wrapped in a {mystery}] inside an <enigma>!" fullword ascii
		$x3 = "636C7369643A46334430443336462D323346382D343638322D413139352D373443393242303344344146" fullword ascii

		/* Malware Strings */
		$s1 = "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)" fullword ascii
		$s2 = "DUMPTHIN" fullword ascii
		$s3 = "\"C:\\WINDOWS\\system32\\" fullword ascii
		$s4 = "window.eval(f.decodeURIComponent(a));" fullword ascii
		$s5 = "/tbedrs.dll" fullword ascii
		$s6 = "NSISDL/1.2 (Mozilla)" fullword ascii
		$s7 = "NSIS_Inetc (Mozilla)" fullword ascii
		$s8 = "/logos.gif" fullword ascii
		$s9 = "synflood" fullword ascii
		$s10 = "IconFile=C:\\WINDOWS\\system32\\SHELL32.dll" fullword ascii
		$s11 = "udpflood" fullword ascii
		$s12 = "shellcode" fullword ascii
		$s13 = "&PassWord=" fullword ascii
		$s14 = "SystemPropertiesProtection.exe" fullword ascii
		$s15 = "SystemPropertiesRemote.exe" fullword ascii

		/* C2 Server user by APT 6 group */
		$c1 = "jobcall.org" ascii
		$c2 = "sportsinfinite.com" ascii
		$c3 = "milsatcom.us" ascii
		$c4 = "geographicphotographer.com" ascii
		$c5 = "snowsmooth.com" ascii
		$c6 = "goodre.net" ascii
		$c7 = "gloflabs.com" ascii
	condition:
		(
			uint16(0) == 0x5a4d and filesize < 1000KB and
			( ( 1 of ($x*) and 3 of ($s*) ) or 1 of ($c*) )
		) or
		( 6 of them )
}
