private rule plist_macos {
    meta:
        hashes = "76eb97aba93979be06dbf0a872518f9514d0bb20b680c887d6fd5cc79dce3681"
    strings:
        $sr1 = "PropertyList-1.0.dtd" fullword
        $sr2 = "<plist"
    condition:
        filesize < 20KB
        and uint32be(0) == 0x3c3f786d
        and all of ($sr*)
        and @sr2[1] < 0x100

}
rule gen_malware_MacOS_plist_suspicious {
   meta:
      description = "Suspicious PLIST files in MacOS (possible malware persistence)"
      author = "John Lambert @JohnLaTwC"
      date = "2018-12-14"
      modified = "2021-05-27"
      reference = "https://objective-see.com/blog/blog_0x3A.html"
      hash1 = "0541fc6a11f4226d52ae3d4158deb8f50ed61b25bb5f889d446102e1ee57b76d"
      hash2 = "6cc6abec7d203f99c43ce16630edc39451428d280b02739757f17fd01fc7dca3"
      hash3 = "76eb97aba93979be06dbf0a872518f9514d0bb20b680c887d6fd5cc79dce3681"
      hash4 = "8921e3f1955f7141d1231f8cfd95230143525f259e578fdc1dd98494f62ec4a1"
      hash5 = "9a3fd0d2b0bca7d2f7e3c70cb15a7005a1afa1ce78371fd3fa9c526a288b64ce"
      hash6 = "737355121685afc38854413d8a1657886f9aa24f54673953749386defe843017"
      hash7 = "9b77622653934995ee8bb5562df311f5bb6d6719933e2671fe231a664da76d30"
      hash8 = "c449f8115b4b939271cb92008a497457e1ab1cf2cbd8f4b58f7ba955cf5624f0"
      hash9 = "cdb2fb9c8e84f0140824403ec32a2431fb357cd0f184c1790152834cc3ad3c1b"
   strings:
      $p1 = "python" ascii
      $p2 = "<string>-c" ascii
      // possible bitcoin wallet. could be coinminer config
      $v0 = /\<string\>[\/|\w]{0,20}\+[\/|\+|=|\w]{59,80}\<\/string\>/
      //see 0541fc6a11f4226d52ae3d4158deb8f50ed61b25bb5f889d446102e1ee57b76d
      $v1 = "curl " fullword
      // see 9a3fd0d2b0bca7d2f7e3c70cb15a7005a1afa1ce78371fd3fa9c526a288b64ce
      $v2 = "PAYLOAD_DATA"
      $v3 = "base64"
      // see 9a3fd0d2b0bca7d2f7e3c70cb15a7005a1afa1ce78371fd3fa9c526a288b64ce
      //PAYLOAD_BASE64
      $vb640 = /(AAQQBZAEwATwBBAEQAXwBCAEEAUwBFADYANA|AEEAWQBMAE8AQQBEAF8AQgBBAFMARQA2ADQA|BBWUxPQURfQkFTRTY0|QVlMT0FEX0JBU0U2N|UABBAFkATABPAEEARABfAEIAQQBTAEUANgA0A|UEFZTE9BRF9CQVNFNj)/
      //subprocess
      $vb641 = /(AHUAYgBwAHIAbwBjAGUAcwBzA|c3VicHJvY2Vzc|cwB1AGIAcAByAG8AYwBlAHMAcw|dWJwcm9jZXNz|MAdQBiAHAAcgBvAGMAZQBzAHMA|N1YnByb2Nlc3)/
      // #!/usr
      $vb642 = "IyEvdXNy"
      // # -*-
      $vb643 = "IyAtKi0"
      //add_header
      $vb644 = /(AGQAZABfAGgAZQBhAGQAZQByA|EAZABkAF8AaABlAGEAZABlAHIA|FkZF9oZWFkZX|YQBkAGQAXwBoAGUAYQBkAGUAcg|YWRkX2hlYWRlc|ZGRfaGVhZGVy)/

      $fp1 = "&#10;do&#10;&#09;echo"  // Shells.plist
      $fp2 = "<string>com.cisco.base64</string>"  // Webex
      $fp3 = "video/mp4;base64"
      $fp4 = "<key>Content-Length</key>"
      $fp5 = "<string>yara</string>"
   condition:
      plist_macos and ( 1 of ($v*) or all of ($p*) )
      and not 1 of ($fp*)
}
