/*
   Yara Rule Set
   Author: Jonas Lejon
   Date: 2017-04-06
   Identifier: APT 10 Malware
*/

import "pe"

rule APT10_Malware_Sample_Gen {
   meta:
      description = "APT 10 / Cloud Hopper malware campaign"
      license = "https://creativecommons.org/licenses/by-nc/4.0/"
      author = "Florian Roth"
      reference = "https://www.pwc.co.uk/issues/cyber-security-data-privacy/insights/operation-cloud-hopper.html"
      date = "2017-04-06"
      score = 80
      type = "file"

   strings:
      /* C2 Servers */
      $c2_1 = "002562066559681.r3u8.com" ascii
      $c2_2 = "031168053846049.r3u8.com" ascii
      $c2_3 = "0625.have8000.com" ascii
      $c2_4 = "1.gadskysun.com" ascii
      $c2_5 = "100fanwen.com" ascii
      $c2_6 = "11.usyahooapis.com" ascii
      $c2_7 = "19518473326.r3u8.com" ascii
      $c2_8 = "1960445709311199.r3u8.com" ascii
      $c2_9 = "1j.www1.biz" ascii
      $c2_10 = "1z.itsaol.com" ascii
      $c2_11 = "2012yearleft.com" ascii
      $c2_12 = "2014.zzux.com" ascii
      $c2_13 = "202017845.r3u8.com" ascii
      $c2_14 = "2139465544784.r3u8.com" ascii
      $c2_15 = "2789203959848958.r3u8.com" ascii
      $c2_16 = "5590428449750026.r3u8.com" ascii
      $c2_17 = "5q.niushenghuo.info" ascii
      $c2_18 = "6r.suibian2010.info" ascii
      $c2_19 = "9gowg.tech" ascii
      $c2_20 = "Hamiltion.catholicmmb.com" ascii
      $c2_21 = "a.wubangtu.info" ascii
      $c2_22 = "a1.suibian2010.info" ascii
      $c2_24 = "abc.wikaba.com" ascii
      $c2_25 = "abcd120719.6600.org" ascii
      $c2_26 = "abcd120807.3322.org" ascii
      $c2_27 = "acc.emailfound.info" ascii
      $c2_28 = "acc.lehigtapp.com" ascii
      $c2_29 = "acsocietyy.com" ascii
      $c2_31 = "ad.webbooting.com" ascii
      $c2_32 = "additional.sexidude.com" ascii
      $c2_33 = "af.zyns.com" ascii
      $c2_34 = "afc.https443.org" ascii
      $c2_35 = "ako.ddns.us" ascii
      $c2_36 = "androidmusicapp.onmypc.us" ascii
      $c2_37 = "announcements.toythieves.com" ascii
      $c2_38 = "anvprn.com" ascii
      $c2_39 = "aotuo.9966.org" ascii
      $c2_40 = "apec.qtsofta.com" ascii
      $c2_41 = "app.lehigtapp.com" ascii
      $c2_42 = "apple.cmdnetview.com" ascii
      $c2_43 = "apple.defensewar.org" ascii
      $c2_44 = "apple.ikwb.com" ascii
      $c2_45 = "appledownload.ourhobby.com" ascii
      $c2_46 = "appleimages.itemdb.com" ascii
      $c2_47 = "appleimages.longmusic.com" ascii
      $c2_48 = "applelib120102.9966.org" ascii
      $c2_49 = "applemirror.organiccrap.com" ascii
      $c2_50 = "applemirror.squirly.info" ascii
      $c2_51 = "applemusic.isasecret.com" ascii
      $c2_52 = "applemusic.itemdb.com" ascii
      $c2_53 = "applemusic.wikaba.com" ascii
      $c2_54 = "applemusic.xxuz.com" ascii
      $c2_55 = "applemusic.zzux.com" ascii
      $c2_56 = "apples.sytes.net" ascii
      $c2_57 = "appleupdate.itemdb.com" ascii
      $c2_58 = "architectisusa.com" ascii
      $c2_59 = "area.wthelpdesk.com" ascii
      $c2_60 = "army.xxuz.com" ascii
      $c2_61 = "art.p6p6.net" ascii
      $c2_62 = "asfzx.x24hr.com" ascii
      $c2_64 = "availab.wikaba.com" ascii
      $c2_65 = "availability.justdied.com" ascii
      $c2_66 = "ba.my03.com" ascii
      $c2_67 = "baby.macforlinux.net" ascii
      $c2_68 = "baby.myie12.com" ascii
      $c2_69 = "baby.usmirocomney.net" ascii
      $c2_70 = "back.jungleheart.com" ascii
      $c2_71 = "back.mofa.dynamic-dns.net" ascii
      $c2_72 = "bak.have8000.com" ascii
      $c2_73 = "bak.ignorelist.com" ascii
      $c2_74 = "bak.un.dnsrd.com" ascii
      $c2_75 = "balance1.wikaba.com" ascii
      $c2_76 = "balk.n7go.com" ascii
      $c2_77 = "banana.cmdnetview.com" ascii
      $c2_78 = "barrybaker.6600.org" ascii
      $c2_79 = "bbs.jungleheart.com" ascii
      $c2_80 = "bdoncloud.com" ascii
      $c2_81 = "be.mrslove.com" ascii
      $c2_82 = "be.yourtrap.com" ascii
      $c2_83 = "belowto.com" ascii
      $c2_84 = "bethel.webhop.net" ascii
      $c2_85 = "bexm.cleansite.biz" ascii
      $c2_86 = "bezu.itemdb.com" ascii
      $c2_87 = "bk56.twilightparadox.com" ascii
      $c2_88 = "blaaaaaaaaaaaa.windowsupdate.3-a.net" ascii
      $c2_89 = "blog.defensewar.org" ascii
      $c2_90 = "brand.fartit.com" ascii
      $c2_91 = "bridgeluxlightmadness.com" ascii
      $c2_92 = "bulletproof.squirly.info" ascii
      $c2_93 = "cao.p6p6.net" ascii
      $c2_94 = "cata.qtsofta.com" ascii
      $c2_95 = "catholicmmb.com" ascii
      $c2_96 = "cc.dynamicdns.co.uk" ascii
      $c2_97 = "ccfchrist.com" ascii
      $c2_98 = "ccupdatedata.authorizeddns.net" ascii
      $c2_99 = "cd.usyahooapis.com" ascii
      $c2_100 = "cdn.incloud-go.com" ascii
      $c2_101 = "center.shenajou.com" ascii
      $c2_102 = "cgei493860.r3u8.com" ascii
      $c2_103 = "chaindungeons.com" ascii
      $c2_104 = "chibashiri.com" ascii
      $c2_105 = "childrenstow.com" ascii
      $c2_106 = "cia.ezua.com" ascii
      $c2_107 = "cia.toh.info" ascii
      $c2_108 = "ciaoci.chickenkiller.com" ascii
      $c2_109 = "civilwar123.authorizeddns.org" ascii
      $c2_110 = "civilwar520.onmypc.org" ascii
      $c2_111 = "ckusshani.com" ascii
      $c2_112 = "cloud-kingl.com" ascii
      $c2_113 = "cloud-maste.com" ascii
      $c2_114 = "cloudns.8800.org" ascii
      $c2_115 = "cmdnetview.com" ascii
      $c2_116 = "cms.sindeali.com" ascii
      $c2_117 = "cnnews.mylftv.com" ascii
      $c2_118 = "commissioner.shenajou.com" ascii
      $c2_119 = "commons.onedumb.com" ascii
      $c2_120 = "contactus.myddns.com" ascii
      $c2_121 = "contactus.onmypc.us" ascii
      $c2_122 = "contract.4mydomain.com" ascii
      $c2_123 = "contractus.qpoe.com" ascii
      $c2_124 = "contractus.zzux.com" ascii
      $c2_125 = "coreck.suayay.com" ascii
      $c2_128 = "ctdl.windowsupdate.itsaol.com" ascii
      $c2_129 = "ctdl.windowsupdate.nsatcdns.com" ascii
      $c2_130 = "ctldl.appledownload.ourhobby.com" ascii
      $c2_131 = "ctldl.applemusic.itemdb.com" ascii
      $c2_132 = "ctldl.itunesmusic.jkub.com" ascii
      $c2_133 = "ctldl.microsoftmusic.onedumb.com" ascii
      $c2_134 = "ctldl.microsoftupdate.qhigh.com" ascii
      $c2_135 = "ctldl.windowsupdate.authorizeddns.org" ascii
      $c2_136 = "ctldl.windowsupdate.authorizeddns.us" ascii
      $c2_137 = "ctldl.windowsupdate.dnset.com" ascii
      $c2_138 = "ctldl.windowsupdate.esmtp.biz" ascii
      $c2_139 = "ctldl.windowsupdate.ezua.com" ascii
      $c2_140 = "ctldl.windowsupdate.gettrials.com" ascii
      $c2_141 = "ctldl.windowsupdate.itsaol.com" ascii
      $c2_142 = "ctldl.windowsupdate.lflinkup.com" ascii
      $c2_143 = "ctldl.windowsupdate.mrface.com" ascii
      $c2_144 = "ctldl.windowsupdate.nsatcdns.com" ascii
      $c2_145 = "ctldl.windowsupdate.organiccrap.com" ascii
      $c2_146 = "ctldl.windowsupdate.x24hr.com" ascii
      $c2_147 = "cvnx.zyns.com" ascii
      $c2_148 = "cwiinatonal.com" ascii
      $c2_149 = "daddy.gostudyantivirus.com" ascii
      $c2_150 = "dcc.jimingroup.com" ascii
      $c2_151 = "dd.ddns.us" ascii
      $c2_152 = "de.onmypc.info" ascii
      $c2_153 = "dear.loveddos.com" ascii
      $c2_154 = "dec.seyesb.acmetoy.com" ascii
      $c2_155 = "dedgesuite.net" ascii
      $c2_156 = "dedydns.ns01.us" ascii
      $c2_157 = "defensewar.org" ascii
      $c2_158 = "demoones.com" ascii
      $c2_159 = "department.shenajou.com" ascii
      $c2_160 = "details.squirly.info" ascii
      $c2_161 = "development.shenajou.com" ascii
      $c2_162 = "devilcase.acmetoy.com" ascii
      $c2_163 = "dfgwerzc.3322.org" ascii
      $c2_164 = "dick.ccfchrist.com" ascii
      $c2_165 = "digsby.ourhobby.com" ascii
      $c2_166 = "disruptive.https443.net" ascii
      $c2_167 = "dlmix.ourdvs.com" ascii
      $c2_168 = "dnspoddwg.authorizeddns.org" ascii
      $c2_170 = "document.methoder.com" ascii
      $c2_171 = "document.shenajou.com" ascii
      $c2_172 = "domainnow.yourtrap.com" ascii
      $c2_173 = "download.applemusic.itemdb.com" ascii
      $c2_174 = "download.microsoftmusic.onedumb.com" ascii
      $c2_175 = "download.windowsupdate.authorizeddns.org" ascii
      $c2_176 = "download.windowsupdate.dedgesuite.net" ascii
      $c2_177 = "download.windowsupdate.dnset.com" ascii
      $c2_178 = "download.windowsupdate.itsaol.com" ascii
      $c2_179 = "download.windowsupdate.lflinkup.com" ascii
      $c2_180 = "download.windowsupdate.nsatcdns.com" ascii
      $c2_181 = "download.windowsupdate.x24hr.com" ascii
      $c2_182 = "downloadlink.mypicture.info" ascii
      $c2_183 = "drives.methoder.com" ascii
      $c2_184 = "dst.1dumb.com" ascii
      $c2_185 = "duosay.com" ascii
      $c2_186 = "dyncojinf.6600.org" ascii
      $c2_187 = "dynsbluecheck.7766.org" ascii
      $c2_188 = "ea.onmypc.info" ascii
      $c2_189 = "ea.rebatesrule.net" ascii
      $c2_190 = "edgar.ccfchrist.com" ascii
      $c2_191 = "ehshiroshima.mylftv.com" ascii
      $c2_192 = "emailfound.info" ascii
      $c2_193 = "eric-averyanov.wha.la" ascii
      $c2_194 = "essashi.com" ascii
      $c2_195 = "eu.acmetoy.com" ascii
      $c2_196 = "eu.wha.la" ascii
      $c2_197 = "eu.zzux.com" ascii
      $c2_198 = "everydayfilmlink.com" ascii
      $c2_199 = "ewe.toshste.com" ascii
      $c2_200 = "eweek.2waky.com" ascii
      $c2_201 = "exprenum.com" ascii
      $c2_202 = "express.lflinkup.com" ascii
      $c2_203 = "extraordinary.dynamic-dns.net" ascii
      $c2_204 = "f068v.site" ascii
      $c2_205 = "fabian.ccfchrist.com" ascii
      $c2_206 = "fastemail.dnsrd.com" ascii
      $c2_207 = "fastmail2.com" ascii
      $c2_208 = "fbi.sexxxy.biz" ascii
      $c2_209 = "fbi.zyns.com" ascii
      $c2_210 = "fcztqbg.zj.r3u8.com" ascii
      $c2_211 = "feed.jungleheart.com" ascii
      $c2_212 = "fftpoor.com" ascii
      $c2_213 = "fg.v4.download.windowsupdates.dnsrd.com" ascii
      $c2_214 = "fgipv6.download.windowsupdate.com.mwcname.com" ascii
      $c2_215 = "file.zzux.com" ascii
      $c2_216 = "files.architectisusa.com" ascii
      $c2_217 = "film.everydayfilmlink.com" ascii
      $c2_218 = "filmlist.everydayfilmlink.com" ascii
      $c2_219 = "findme.epac.to" ascii
      $c2_220 = "fire.mrface.com" ascii
      $c2_221 = "fish.toh.info" ascii
      $c2_222 = "fiveavmersi.websegoo.net" ascii
      $c2_223 = "fjs.wikaba.com" ascii
      $c2_224 = "flea.poulsenv.com" ascii
      $c2_225 = "flynews.edns.biz" ascii
      $c2_226 = "fo.mysecondarydns.com" ascii
      $c2_227 = "foal.wchildress.com" ascii
      $c2_228 = "follow.wha.la" ascii
      $c2_229 = "foo.shenajou.com" ascii
      $c2_230 = "for.ddns.mobi" ascii
      $c2_231 = "fr.wikaba.com" ascii
      $c2_232 = "franck.demoones.com" ascii
      $c2_233 = "ftp.2014.zzux.com" ascii
      $c2_234 = "ftp.additional.sexidude.com" ascii
      $c2_235 = "ftp.afc.https443.org" ascii
      $c2_236 = "ftp.announcements.toythieves.com" ascii
      $c2_237 = "ftp.apple.ikwb.com" ascii
      $c2_238 = "ftp.appledownload.ourhobby.com" ascii
      $c2_239 = "ftp.appleimages.itemdb.com" ascii
      $c2_240 = "ftp.appleimages.longmusic.com" ascii
      $c2_241 = "ftp.appleimages.organiccrap.com" ascii
      $c2_242 = "ftp.applemirror.organiccrap.com" ascii
      $c2_243 = "ftp.applemirror.squirly.info" ascii
      $c2_244 = "ftp.applemusic.isasecret.com" ascii
      $c2_245 = "ftp.applemusic.itemdb.com" ascii
      $c2_246 = "ftp.applemusic.wikaba.com" ascii
      $c2_247 = "ftp.applemusic.xxuz.com" ascii
      $c2_248 = "ftp.applemusic.zzux.com" ascii
      $c2_249 = "ftp.appleupdate.itemdb.com" ascii
      $c2_250 = "ftp.architectisusa.com" ascii
      $c2_251 = "ftp.asfzx.x24hr.com" ascii
      $c2_252 = "ftp.availab.wikaba.com" ascii
      $c2_253 = "ftp.availability.justdied.com" ascii
      $c2_254 = "ftp.back.jungleheart.com" ascii
      $c2_255 = "ftp.balance1.wikaba.com" ascii
      $c2_256 = "ftp.be.mrslove.com" ascii
      $c2_257 = "ftp.brand.fartit.com" ascii
      $c2_258 = "ftp.bulletproof.squirly.info" ascii
      $c2_259 = "ftp.cia.ezua.com" ascii
      $c2_260 = "ftp.cia.toh.info" ascii
      $c2_261 = "ftp.civilwar123.authorizeddns.org" ascii
      $c2_262 = "ftp.civilwar520.onmypc.org" ascii
      $c2_263 = "ftp.cloudfileserverbs.dynamicdns.co.uk" ascii
      $c2_264 = "ftp.cnnews.mylftv.com" ascii
      $c2_265 = "ftp.commons.onedumb.com" ascii
      $c2_266 = "ftp.contractus.qpoe.com" ascii
      $c2_267 = "ftp.cvnx.zyns.com" ascii
      $c2_268 = "ftp.de.onmypc.info" ascii
      $c2_269 = "ftp.details.squirly.info" ascii
      $c2_270 = "ftp.devilcase.acmetoy.com" ascii
      $c2_271 = "ftp.disruptive.https443.net" ascii
      $c2_272 = "ftp.domainnow.yourtrap.com" ascii
      $c2_273 = "ftp.ea.onmypc.info" ascii
      $c2_274 = "ftp.ehshiroshima.mylftv.com" ascii
      $c2_275 = "ftp.eric-averyanov.wha.la" ascii
      $c2_276 = "ftp.eu.acmetoy.com" ascii
      $c2_277 = "ftp.eu.wha.la" ascii
      $c2_278 = "ftp.eu.zzux.com" ascii
      $c2_279 = "ftp.fbi.sexxxy.biz" ascii
      $c2_280 = "ftp.file.zzux.com" ascii
      $c2_281 = "ftp.findme.epac.to" ascii
      $c2_282 = "ftp.fire.mrface.com" ascii
      $c2_283 = "ftp.fjs.wikaba.com" ascii
      $c2_284 = "ftp.fr.wikaba.com" ascii
      $c2_285 = "ftp.fuck.ikwb.com" ascii
      $c2_286 = "ftp.fuckmm.dns-dns.com" ascii
      $c2_287 = "ftp.generat.almostmy.com" ascii
      $c2_288 = "ftp.goldtoyota.com" ascii
      $c2_289 = "ftp.goodmusic.justdied.com" ascii
      $c2_290 = "ftp.helpus.ddns.info" ascii
      $c2_291 = "ftp.hii.qhigh.com" ascii
      $c2_292 = "ftp.innocent-isayev.sexidude.com" ascii
      $c2_293 = "ftp.invoices.sexxxy.biz" ascii
      $c2_294 = "ftp.iphone.vizvaz.com" ascii
      $c2_295 = "ftp.itlans.isasecret.com" ascii
      $c2_296 = "ftp.itunesdownload.jkub.com" ascii
      $c2_297 = "ftp.itunesdownload.wikaba.com" ascii
      $c2_298 = "ftp.itunesimages.itemdb.com" ascii
      $c2_299 = "ftp.itunesimages.itsaol.com" ascii
      $c2_300 = "ftp.itunesimages.qpoe.com" ascii
      $c2_301 = "ftp.itunesmirror.fartit.com" ascii
      $c2_302 = "ftp.itunesmirror.itsaol.com" ascii
      $c2_303 = "ftp.itunesmusic.ikwb.com" ascii
      $c2_304 = "ftp.itunesmusic.jetos.com" ascii
      $c2_305 = "ftp.itunesmusic.jkub.com" ascii
      $c2_306 = "ftp.itunesmusic.zzux.com" ascii
      $c2_307 = "ftp.itunesupdate.itsaol.com" ascii
      $c2_308 = "ftp.itunesupdates.organiccrap.com" ascii
      $c2_309 = "ftp.japanfilmsite.ikwb.com" ascii
      $c2_310 = "ftp.jimin.mymom.info" ascii
      $c2_311 = "ftp.jp.serveuser.com" ascii
      $c2_312 = "ftp.key.zzux.com" ascii
      $c2_313 = "ftp.knowledge.sellclassics.com" ascii
      $c2_314 = "ftp.lan.dynssl.com" ascii
      $c2_315 = "ftp.latestnews.epac.to" ascii
      $c2_316 = "ftp.latestnews.organiccrap.com" ascii
      $c2_317 = "ftp.leedong.longmusic.com" ascii
      $c2_318 = "ftp.macfee.mrface.com" ascii
      $c2_319 = "ftp.maffc.mrface.com" ascii
      $c2_320 = "ftp.malware.dsmtp.com" ascii
      $c2_321 = "ftp.manager.jetos.com" ascii
      $c2_322 = "ftp.martin.sellclassics.com" ascii
      $c2_323 = "ftp.mason.vizvaz.com" ascii
      $c2_324 = "ftp.mediapath.organiccrap.com" ascii
      $c2_325 = "ftp.microsoft.got-game.org" ascii
      $c2_326 = "ftp.microsoft.mrface.com" ascii
      $c2_327 = "ftp.microsoftimages.organiccrap.com" ascii
      $c2_328 = "ftp.microsoftmusic.mrbasic.com" ascii
      $c2_329 = "ftp.microsoftqckmanager.pcanywhere.net" ascii
      $c2_330 = "ftp.microsoftupdate.mrbasic.com" ascii
      $c2_331 = "ftp.microsoftupdate.qhigh.com" ascii
      $c2_332 = "ftp.micrsoftware.dsmtp.com" ascii
      $c2_333 = "ftp.mircsoft.compress.to" ascii
      $c2_334 = "ftp.mmy.ddns.us" ascii
      $c2_335 = "ftp.mod.jetos.com" ascii
      $c2_336 = "ftp.mofa.dynamic-dns.net" ascii
      $c2_337 = "ftp.mofa.ns01.info" ascii
      $c2_338 = "ftp.moscowdic.trickip.org" ascii
      $c2_339 = "ftp.msg.ezua.com" ascii
      $c2_340 = "ftp.musicfile.ikwb.com" ascii
      $c2_341 = "ftp.musicjj.zzux.com" ascii
      $c2_342 = "ftp.mymusicbox.vizvaz.com" ascii
      $c2_343 = "ftp.myphpwebsite.itsaol.com" ascii
      $c2_344 = "ftp.myrestroomimage.isasecret.com" ascii
      $c2_345 = "ftp.na.americanunfinished.com" ascii
      $c2_346 = "ftp.na.onmypc.org" ascii
      $c2_347 = "ftp.newsdata.jkub.com" ascii
      $c2_348 = "ftp.newsroom.cleansite.info" ascii
      $c2_349 = "ftp.no.authorizeddns.org" ascii
      $c2_350 = "ftp.nsa.mefound.com" ascii
      $c2_351 = "ftp.nt.mynumber.org" ascii
      $c2_352 = "ftp.nttdata.otzo.com" ascii
      $c2_353 = "ftp.nz.compress.to" ascii
      $c2_354 = "ftp.ol.almostmy.com" ascii
      $c2_355 = "ftp.oracleupdate.dns04.com" ascii
      $c2_356 = "ftp.portal.mrface.com" ascii
      $c2_357 = "ftp.portal.sendsmtp.com" ascii
      $c2_358 = "ftp.portalser.dynamic-dns.net" ascii
      $c2_359 = "ftp.praskovya-matveyeva.mefound.com" ascii
      $c2_360 = "ftp.praskovya-ulyanova.dumb1.com" ascii
      $c2_361 = "ftp.products.almostmy.com" ascii
      $c2_362 = "ftp.products.cleansite.us" ascii
      $c2_363 = "ftp.products.serveuser.com" ascii
      $c2_364 = "ftp.purchase.lflinkup.org" ascii
      $c2_365 = "ftp.recent.dns-stuff.com" ascii
      $c2_366 = "ftp.recent.fartit.com" ascii
      $c2_367 = "ftp.referred.gr8domain.biz" ascii
      $c2_368 = "ftp.referred.yourtrap.com" ascii
      $c2_369 = "ftp.register.ourhobby.com" ascii
      $c2_370 = "ftp.registration2.instanthq.com" ascii
      $c2_371 = "ftp.registrations.4pu.com" ascii
      $c2_372 = "ftp.registrations.organiccrap.com" ascii
      $c2_373 = "ftp.remeberdata.iownyour.org" ascii
      $c2_374 = "ftp.reserveds.onedumb.com" ascii
      $c2_375 = "ftp.rethem.almostmy.com" ascii
      $c2_376 = "ftp.sdmsg.onmypc.org" ascii
      $c2_377 = "ftp.se.toythieves.com" ascii
      $c2_378 = "ftp.secertnews.mrbasic.com" ascii
      $c2_379 = "ftp.senseye.ikwb.com" ascii
      $c2_380 = "ftp.senseye.mrbonus.com" ascii
      $c2_381 = "ftp.septdlluckysystem.jungleheart.com" ascii
      $c2_382 = "ftp.seraphim-yurieva.justdied.com" ascii
      $c2_383 = "ftp.serv.justdied.com" ascii
      $c2_384 = "ftp.server1.proxydns.com" ascii
      $c2_385 = "ftp.seyesb.acmetoy.com" ascii
      $c2_386 = "ftp.shugiin.jkub.com" ascii
      $c2_387 = "ftp.singed.otzo.com" ascii
      $c2_388 = "ftp.sstday.jkub.com" ascii
      $c2_389 = "ftp.support1.mrface.com" ascii
      $c2_390 = "ftp.supportus.mefound.com" ascii
      $c2_391 = "ftp.svc.dynssl.com" ascii
      $c2_392 = "ftp.synssl.dnset.com" ascii
      $c2_393 = "ftp.tamraj.fartit.com" ascii
      $c2_394 = "ftp.tfa.longmusic.com" ascii
      $c2_395 = "ftp.thunder.wikaba.com" ascii
      $c2_396 = "ftp.ticket.instanthq.com" ascii
      $c2_397 = "ftp.ticket.serveuser.com" ascii
      $c2_398 = "ftp.tokyofile.2waky.com" ascii
      $c2_399 = "ftp.tophost.dynamicdns.co.uk" ascii
      $c2_400 = "ftp.transfer.lflinkup.org" ascii
      $c2_401 = "ftp.transfer.mrbasic.com" ascii
      $c2_402 = "ftp.transfer.vizvaz.com" ascii
      $c2_403 = "ftp.ugreen.itemdb.com" ascii
      $c2_404 = "ftp.uk.dynamicdns.org.uk" ascii
      $c2_405 = "ftp.un.ddns.info" ascii
      $c2_406 = "ftp.un.dnsrd.com" ascii
      $c2_407 = "ftp.usa.itsaol.com" ascii
      $c2_408 = "ftp.well.itsaol.com" ascii
      $c2_409 = "ftp.well.mrbasic.com" ascii
      $c2_410 = "ftp.wike.wikaba.com" ascii
      $c2_411 = "ftp.windowfile.itemdb.com" ascii
      $c2_412 = "ftp.windowsimages.itemdb.com" ascii
      $c2_413 = "ftp.windowsimages.qhigh.com" ascii
      $c2_414 = "ftp.windowsmirrors.vizvaz.com" ascii
      $c2_415 = "ftp.windowsupdate.2waky.com" ascii
      $c2_416 = "ftp.windowsupdate.3-a.net" ascii
      $c2_417 = "ftp.windowsupdate.authorizeddns.us" ascii
      $c2_418 = "ftp.windowsupdate.dns05.com" ascii
      $c2_419 = "ftp.windowsupdate.esmtp.biz" ascii
      $c2_420 = "ftp.windowsupdate.ezua.com" ascii
      $c2_421 = "ftp.windowsupdate.fartit.com" ascii
      $c2_422 = "ftp.windowsupdate.gettrials.com" ascii
      $c2_423 = "ftp.windowsupdate.instanthq.com" ascii
      $c2_424 = "ftp.windowsupdate.jungleheart.com" ascii
      $c2_425 = "ftp.windowsupdate.lflink.com" ascii
      $c2_426 = "ftp.windowsupdate.mrface.com" ascii
      $c2_427 = "ftp.windowsupdate.mylftv.com" ascii
      $c2_428 = "ftp.windowsupdate.rebatesrule.net" ascii
      $c2_429 = "ftp.windowsupdate.sellclassics.com" ascii
      $c2_430 = "ftp.windowsupdate.serveusers.com" ascii
      $c2_431 = "ftp.yandexr.sellclassics.com" ascii
      $c2_432 = "fu.epac.to" ascii
      $c2_433 = "fuck.ikwb.com" ascii
      $c2_434 = "fuckanti.com" ascii
      $c2_435 = "fuckdd.8800.org" ascii
      $c2_436 = "fuckmm.8800.org" ascii
      $c2_437 = "fuckmm.dns-dns.com" ascii
      $c2_438 = "fukuoka.cloud-maste.com" ascii
      $c2_439 = "g3ypf.online" ascii
      $c2_440 = "gadskysun.com" ascii
      $c2_441 = "gavin.ccfchrist.com" ascii
      $c2_442 = "generat.almostmy.com" ascii
      $c2_443 = "generousd.hopto.org" ascii
      $c2_444 = "gensuzuki.6600.org" ascii
      $c2_446 = "gh.mysecondarydns.com" ascii
      $c2_447 = "gifuonlineshopping.mynumber.org" ascii
      $c2_448 = "glicense.shenajou.com" ascii
      $c2_449 = "globalnews.wikaba.com" ascii
      $c2_450 = "gmail.com.mailsserver.com" ascii
      $c2_451 = "gmpcw.com" ascii
      $c2_452 = "gold.polopurple.com" ascii
      $c2_453 = "goldtoyota.com" ascii
      $c2_454 = "goodmusic.justdied.com" ascii
      $c2_455 = "goodsampjp.com" ascii
      $c2_456 = "gooesdataios.instanthq.com" ascii
      $c2_457 = "google.macforlinux.net" ascii
      $c2_458 = "google.usrobothome.com" ascii
      $c2_459 = "googlemeail.com" ascii
      $c2_460 = "gostudyantivirus.com" ascii
      $c2_461 = "gostudymbaa.com" ascii
      $c2_462 = "gotourisma.com" ascii
      $c2_463 = "gt4study.com" ascii
      $c2_464 = "gtsofta.com" ascii
      $c2_465 = "haoyujd.info" ascii
      $c2_466 = "happy.workerisgood.com" ascii
      $c2_467 = "have8000.com" ascii
      $c2_468 = "helpus.ddns.info" ascii
      $c2_469 = "helshellfucde.8866.org" ascii
      $c2_470 = "hg8fmv.racing" ascii
      $c2_471 = "hii.qhigh.com" ascii
      $c2_472 = "hk.2012yearleft.com" ascii
      $c2_473 = "hk.cmdnetview.com" ascii
      $c2_474 = "hk.have8000.com" ascii
      $c2_475 = "hk.loveddos.com" ascii
      $c2_476 = "home.trickip.org" ascii
      $c2_477 = "hostport9.net" ascii
      $c2_478 = "hotmai.info" ascii
      $c2_479 = "hotmail.com.mailsserver.com" ascii
      $c2_480 = "hukuoka.cloud-maste.com" ascii
      $c2_481 = "iamges.itunesmusic.jkub.com" ascii
      $c2_482 = "ibmmsg.strangled.net" ascii
      $c2_483 = "icfeds.cf" ascii
      $c2_484 = "idpmus.hostport9.net" ascii
      $c2_486 = "im.suibian2010.info" ascii
      $c2_487 = "image.websago.info" ascii
      $c2_488 = "images.itunesmusic.jkub.com" ascii
      $c2_489 = "images.thedomais.info" ascii
      $c2_490 = "images.tyoto-go-jp.com" ascii
      $c2_491 = "images.windowsupdate.organiccrap.com" ascii
      $c2_492 = "imap.architectisusa.com" ascii
      $c2_493 = "imap.dnset.com" ascii
      $c2_494 = "imap.lflink.com" ascii
      $c2_495 = "imap.onmypc.net" ascii
      $c2_496 = "imap.ygto.com" ascii
      $c2_497 = "img.station155.com" ascii
      $c2_498 = "improvejpese.com" ascii
      $c2_499 = "incloud-go.com" ascii
      $c2_500 = "incloud-obert.com" ascii
      $c2_501 = "ingemar.catholicmmb.com" ascii
      $c2_502 = "innocent-isayev.sexidude.com" ascii
      $c2_503 = "innov-tec.com.ua" ascii
      $c2_504 = "inspgon.re26.com" ascii
      $c2_505 = "interpreter.shenajou.com" ascii
      $c2_506 = "invoices.sexxxy.biz" ascii
      $c2_508 = "iphone.vizvaz.com" ascii
      $c2_509 = "ipv4.applemusic.itemdb.com" ascii
      $c2_510 = "ipv4.itunesmusic.jkub.com" ascii
      $c2_511 = "ipv4.japanenvnews.qpoe.com" ascii
      $c2_512 = "ipv4.microsoftmusic.onedumb.com" ascii
      $c2_513 = "ipv4.microsoftupdate.mrbasic.com" ascii
      $c2_514 = "ipv4.microsoftupdate.qhigh.com" ascii
      $c2_515 = "ipv4.windowsupdate.3-a.net" ascii
      $c2_516 = "ipv4.windowsupdate.authorizeddns.org" ascii
      $c2_517 = "ipv4.windowsupdate.authorizeddns.us" ascii
      $c2_518 = "ipv4.windowsupdate.dnset.com" ascii
      $c2_519 = "ipv4.windowsupdate.esmtp.biz" ascii
      $c2_520 = "ipv4.windowsupdate.ezua.com" ascii
      $c2_521 = "ipv4.windowsupdate.fartit.com" ascii
      $c2_522 = "ipv4.windowsupdate.gettrials.com" ascii
      $c2_523 = "ipv4.windowsupdate.itsaol.com" ascii
      $c2_524 = "ipv4.windowsupdate.lflink.com" ascii
      $c2_525 = "ipv4.windowsupdate.lflinkup.com" ascii
      $c2_526 = "ipv4.windowsupdate.mrface.com" ascii
      $c2_527 = "ipv4.windowsupdate.mylftv.com" ascii
      $c2_528 = "ipv4.windowsupdate.nsatcdns.com" ascii
      $c2_529 = "ipv4.windowsupdate.x24hr.com" ascii
      $c2_530 = "ipv6microsoft.dlmix.ourdvs.com" ascii
      $c2_531 = "itlans.isasecret.com" ascii
      $c2_532 = "itunesdownload.jkub.com" ascii
      $c2_533 = "itunesdownload.vizvaz.com" ascii
      $c2_534 = "itunesdownload.wikaba.com" ascii
      $c2_535 = "itunesimages.itemdb.com" ascii
      $c2_536 = "itunesimages.itsaol.com" ascii
      $c2_537 = "itunesimages.qpoe.com" ascii
      $c2_538 = "itunesmirror.fartit.com" ascii
      $c2_539 = "itunesmirror.itsaol.com" ascii
      $c2_540 = "itunesmusic.ikwb.com" ascii
      $c2_541 = "itunesmusic.jetos.com" ascii
      $c2_542 = "itunesmusic.jkub.com" ascii
      $c2_543 = "itunesmusic.zzux.com" ascii
      $c2_544 = "itunesupdate.itsaol.com" ascii
      $c2_545 = "itunesupdates.organiccrap.com" ascii
      $c2_546 = "iw.mrslove.com" ascii
      $c2_547 = "ixrayeye.com" ascii
      $c2_548 = "james.tffghelth.com" ascii
      $c2_549 = "janpan.bigmoney.biz" ascii
      $c2_550 = "janpun.americanunfinished.com" ascii
      $c2_551 = "jap.japanmusicinfo.com" ascii
      $c2_552 = "japan.fuckanti.com" ascii
      $c2_553 = "japan.linuxforover.com" ascii
      $c2_554 = "japan.loveddos.com" ascii
      $c2_555 = "japanenvnews.qpoe.com" ascii
      $c2_556 = "japanfilmsite.ikwb.com" ascii
      $c2_557 = "japanfst.japanteam.org" ascii
      $c2_558 = "japanmusicinfo.com" ascii
      $c2_559 = "japanteam.org" ascii
      $c2_560 = "jcie.mofa.ns01.info" ascii
      $c2_561 = "jepsen.r3u8.com" ascii
      $c2_562 = "jica-go-jp.bike" ascii
      $c2_563 = "jica-go-jp.biz" ascii
      $c2_564 = "jimin-jp.biz" ascii
      $c2_565 = "jimin.jimindaddy.com" ascii
      $c2_566 = "jimin.mymom.info" ascii
      $c2_567 = "jimindaddy.com" ascii
      $c2_568 = "jimingroup.com" ascii
      $c2_569 = "jimintokoy.com" ascii
      $c2_570 = "jj.mysecondarydns.com" ascii
      $c2_571 = "jmuroran.com" ascii
      $c2_572 = "jp.rakutenmusic.com" ascii
      $c2_573 = "jp.serveuser.com" ascii
      $c2_574 = "jpcert.org" ascii
      $c2_575 = "jpn.longmusic.com" ascii
      $c2_576 = "jpnxzshopdata.authorizeddns.org" ascii
      $c2_577 = "jpstarmarket.serveusers.com" ascii
      $c2_578 = "kaka.lehigtapp.com" ascii
      $c2_579 = "kawasaki.cloud-maste.com" ascii
      $c2_580 = "kawasaki.unhamj.com" ascii
      $c2_581 = "kennedy.tffghelth.com" ascii
      $c2_582 = "key.zzux.com" ascii
      $c2_583 = "kikimusic.sellclassics.com" ascii
      $c2_584 = "kmd.crabdance.com" ascii
      $c2_585 = "knowledge.sellclassics.com" ascii
      $c2_586 = "ktgmktanxgvn.r3u8.com" ascii
      $c2_587 = "kxsbwappupdate.dhcp.biz" ascii
      $c2_588 = "kztmusiclnk.dnsrd.com" ascii
      $c2_589 = "lan.dynssl.com" ascii
      $c2_590 = "last.p6p6.net" ascii
      $c2_591 = "latestnews.epac.to" ascii
      $c2_592 = "latestnews.organiccrap.com" ascii
      $c2_593 = "leedong.longmusic.com" ascii
      $c2_594 = "lehigtapp.com" ascii
      $c2_595 = "lennon.fftpoor.com" ascii
      $c2_596 = "license.shenajou.com" ascii
      $c2_597 = "lie.jetos.com" ascii
      $c2_598 = "linuxforover.com" ascii
      $c2_599 = "linuxsofta.com" ascii
      $c2_600 = "lion.wchildress.com" ascii
      $c2_601 = "lizard.poulsenv.com" ascii
      $c2_602 = "logon-live.com" ascii
      $c2_603 = "lottedfstravel.webbooting.com" ascii
      $c2_604 = "loveddos.com" ascii
      $c2_605 = "lzf550.r3u8.com" ascii
      $c2_606 = "ma.vizvaz.com" ascii
      $c2_607 = "mac.goldtoyota.com" ascii
      $c2_608 = "mac.methoder.com" ascii
      $c2_609 = "macfee.mrface.com" ascii
      $c2_610 = "macforlinux.net" ascii
      $c2_611 = "maffc.mrface.com" ascii
      $c2_612 = "mail.architectisusa.com" ascii
      $c2_613 = "mail.macforlinux.net" ascii
      $c2_614 = "mailcarriage.co.uk" ascii
      $c2_615 = "mailj.hostport9.net" ascii
      $c2_616 = "mailserever.com" ascii
      $c2_617 = "mailsserver.com" ascii
      $c2_618 = "mailvserver.com" ascii
      $c2_619 = "malcolm.fftpoor.com" ascii
      $c2_620 = "malware.dsmtp.com" ascii
      $c2_621 = "manager.architectisusa.com" ascii
      $c2_622 = "manager.jetos.com" ascii
      $c2_623 = "markabcinfo.dynamicdns.me.uk" ascii
      $c2_624 = "martin.sellclassics.com" ascii
      $c2_625 = "mason.vizvaz.com" ascii
      $c2_626 = "mbaby.macforlinux.net" ascii
      $c2_627 = "medexplor.thedomais.info" ascii
      $c2_628 = "mediapath.organiccrap.com" ascii
      $c2_629 = "meiji-ac-jp.com" ascii
      $c2_630 = "mesjm.emailfound.info" ascii
      $c2_631 = "message.emailfound.info" ascii
      $c2_632 = "message.p6p6.net" ascii
      $c2_633 = "messagea.emailfound.info" ascii
      $c2_634 = "methoder.com" ascii
      $c2_635 = "mf.ddns.info" ascii
      $c2_636 = "microcnmlgb.3322.org" ascii
      $c2_637 = "microdef.2288.org" ascii
      $c2_638 = "microhome.wikaba.com" ascii
      $c2_639 = "microsoft.got-game.org" ascii
      $c2_640 = "microsoft.mrface.com" ascii
      $c2_641 = "microsoftdownload.zzux.com" ascii
      $c2_642 = "microsoftempowering.sendsmtp.com" ascii
      $c2_643 = "microsoften.com" ascii
      $c2_644 = "microsoftgame.mrface.com" ascii
      $c2_645 = "microsoftgetstarted.sexidude.com" ascii
      $c2_646 = "microsoftimages.organiccrap.com" ascii
      $c2_647 = "microsoftmirror.mrbasic.com" ascii
      $c2_648 = "microsoftmusic.itemdb.com" ascii
      $c2_649 = "microsoftmusic.mrbasic.com" ascii
      $c2_650 = "microsoftmusic.onedumb.com" ascii
      $c2_651 = "microsoftqckmanager.pcanywhere.net" ascii
      $c2_652 = "microsoftstore.jetos.com" ascii
      $c2_653 = "microsoftstores.itemdb.com" ascii
      $c2_654 = "microsoftupdate.mrbasic.com" ascii
      $c2_655 = "microsoftupdate.qhigh.com" ascii
      $c2_656 = "microsoftupdates.vizvaz.com" ascii
      $c2_657 = "micrsoftware.dsmtp.com" ascii
      $c2_658 = "mircsoft.compress.to" ascii
      $c2_659 = "mivsee.website0012.net" ascii
      $c2_660 = "mmofoojap.2288.org" ascii
      $c2_661 = "mmy.ddns.us" ascii
      $c2_662 = "mobile.2waky.com" ascii
      $c2_663 = "mocha.100fanwen.com" ascii
      $c2_664 = "mod.jetos.com" ascii
      $c2_665 = "mofa-go-jp.com" ascii
      $c2_666 = "mofa.dynamic-dns.net" ascii
      $c2_667 = "mofa.ns01.info" ascii
      $c2_668 = "mofa.strangled.net" ascii
      $c2_669 = "mofaess.com" ascii
      $c2_670 = "mongoles.3322.org" ascii
      $c2_671 = "monkey.2012yearleft.com" ascii
      $c2_672 = "moscowstdsupdate.toythieves.com" ascii
      $c2_673 = "mrsloveaqx.mrslove.com" ascii
      $c2_674 = "ms.ecc.u-tokyo-ac-jp.com" ascii
      $c2_675 = "mseupdate.ourhobby.com" ascii
      $c2_676 = "msg.ezua.com" ascii
      $c2_677 = "msn.incloud-go.com" ascii
      $c2_678 = "muller.exprenum.com" ascii
      $c2_679 = "music.applemusic.itemdb.com" ascii
      $c2_680 = "music.cleansite.us" ascii
      $c2_681 = "music.websegoo.net" ascii
      $c2_682 = "musicfile.ikwb.com" ascii
      $c2_683 = "musicinfo.everydayfilmlink.com" ascii
      $c2_684 = "musiclinker.jkub.com" ascii
      $c2_685 = "musicsecph.squirly.info" ascii
      $c2_686 = "mx.yetrula.eu" ascii
      $c2_687 = "myie12.com" ascii
      $c2_688 = "mymusicbox.lflinkup.org" ascii
      $c2_689 = "mymusicbox.vizvaz.com" ascii
      $c2_690 = "myphpwebsite.itsaol.com" ascii
      $c2_691 = "myrestroomimage.isasecret.com" ascii
      $c2_692 = "mytwhomeinst.sendsmtp.com" ascii
      $c2_693 = "myurinikoreaaps.ninth.biz" ascii
      $c2_694 = "na.americanunfinished.com" ascii
      $c2_695 = "na.onmypc.org" ascii
      $c2_696 = "nasa.xxuz.com" ascii
      $c2_697 = "nec.website0012.net" ascii
      $c2_698 = "news.100fanwen.com" ascii
      $c2_699 = "newsdata.jkub.com" ascii
      $c2_700 = "newsfile.toythieves.com" ascii
      $c2_701 = "newsreport.justdied.com" ascii
      $c2_702 = "newsroom.cleansite.info" ascii
      $c2_703 = "nezwq.ezua.com" ascii
      $c2_704 = "ngcc.8800.org" ascii
      $c2_705 = "niushenghuo.info" ascii
      $c2_706 = "nk10.belowto.com" ascii
      $c2_707 = "nk20.belowto.com" ascii
      $c2_708 = "nlddnsinfo.https443.org" ascii
      $c2_709 = "nmrx.mrbonus.com" ascii
      $c2_710 = "nn.dynssl.com" ascii
      $c2_711 = "no.authorizeddns.org" ascii
      $c2_712 = "node.mofaess.com" ascii
      $c2_713 = "nodns2.qipian.org" ascii
      $c2_714 = "nposnewsinfo.qhigh.com" ascii
      $c2_715 = "ns1.belowto.com" ascii
      $c2_716 = "ns1.tlchs2.ml" ascii
      $c2_717 = "ns2.belowto.com" ascii
      $c2_718 = "ns21.belowto.com" ascii
      $c2_719 = "ns22.belowto.com" ascii
      $c2_720 = "ns4.belowto.com" ascii
      $c2_721 = "ns5.belowto.com" ascii
      $c2_722 = "nsa.mefound.com" ascii
      $c2_723 = "nsatcdns.com" ascii
      $c2_724 = "nt.mynumber.org" ascii
      $c2_725 = "nttdata.otzo.com" ascii
      $c2_726 = "nunluck.re26.com" ascii
      $c2_727 = "nz.compress.to" ascii
      $c2_728 = "oipbl.com" ascii
      $c2_729 = "ol.almostmy.com" ascii
      $c2_730 = "oldbmwy.com" ascii
      $c2_731 = "oms.sindeali.com" ascii
      $c2_732 = "openmofa.8866.org" ascii
      $c2_733 = "oracleupdate.dns04.com" ascii
      $c2_734 = "osaka-jpgo.com" ascii
      $c2_735 = "outlook.otzo.com" ascii
      $c2_736 = "owlmedia.mefound.com" ascii
      $c2_737 = "p6p6.net" ascii
      $c2_738 = "peopleinfodata.3-a.net" ascii
      $c2_739 = "phptecinfohelp.itemdb.com" ascii
      $c2_740 = "pictures.everydayfilmlink.com" ascii
      $c2_741 = "pj.qpoe.com" ascii
      $c2_742 = "points.mofaess.com" ascii
      $c2_743 = "polopurple.com" ascii
      $c2_744 = "pop.architectisusa.com" ascii
      $c2_745 = "pop.loveddos.com" ascii
      $c2_746 = "portal.mrface.com" ascii
      $c2_747 = "portal.sendsmtp.com" ascii
      $c2_748 = "portalser.dynamic-dns.net" ascii
      $c2_749 = "poulsenv.com" ascii
      $c2_750 = "praskovya-matveyeva.mefound.com" ascii
      $c2_751 = "praskovya-ulyanova.dumb1.com" ascii
      $c2_752 = "premium.redforlinux.com" ascii
      $c2_753 = "products.almostmy.com" ascii
      $c2_754 = "products.cleansite.us" ascii
      $c2_755 = "products.serveuser.com" ascii
      $c2_756 = "program.acmetoy.com" ascii
      $c2_757 = "prrmes4019.r3u8.com" ascii
      $c2_758 = "purchase.lflinkup.org" ascii
      $c2_759 = "q6.niushenghuo.info" ascii
      $c2_760 = "qtsofta.com" ascii
      $c2_761 = "quick.oldbmwy.com" ascii
      $c2_762 = "r3u8.com" ascii
      $c2_763 = "radiorig.com" ascii
      $c2_764 = "rain.orctldl.windowsupdate.authorizeddns.us" ascii
      $c2_765 = "rakutenmusic.com" ascii
      $c2_766 = "rdns-4.infoproduto1.tk" ascii
      $c2_767 = "re26.com" ascii
      $c2_768 = "read.xxuz.com" ascii
      $c2_769 = "recent.dns-stuff.com" ascii
      $c2_770 = "recent.fartit.com" ascii
      $c2_771 = "record.hostport9.net" ascii
      $c2_772 = "record.webssl9.info" ascii
      $c2_773 = "record.wschandler.com" ascii
      $c2_774 = "redforlinux.com" ascii
      $c2_775 = "referred.gr8domain.biz" ascii
      $c2_776 = "referred.yourtrap.com" ascii
      $c2_777 = "register.ourhobby.com" ascii
      $c2_778 = "registration2.instanthq.com" ascii
      $c2_779 = "registrations.4pu.com" ascii
      $c2_780 = "registrations.organiccrap.com" ascii
      $c2_781 = "reports.tomorrowforgood.com" ascii
      $c2_782 = "reserveds.onedumb.com" ascii
      $c2_783 = "resources.applemusic.itemdb.com" ascii
      $c2_784 = "rethem.almostmy.com" ascii
      $c2_785 = "rg197.win" ascii
      $c2_786 = "rlbeiydn.hi.r3u8.com" ascii
      $c2_787 = "saiyo.exprenum.com" ascii
      $c2_788 = "sakai.unhamj.com" ascii
      $c2_789 = "salvaiona.com" ascii
      $c2_790 = "sappore.cloud-maste.com" ascii
      $c2_791 = "sapporo.cloud-maste.com" ascii
      $c2_792 = "sapporot.com" ascii
      $c2_793 = "sat.suayay.com" ascii
      $c2_794 = "saverd.re26.com" ascii
      $c2_795 = "sbuudd.webssl9.info" ascii
      $c2_796 = "sc.weboot.info" ascii
      $c2_797 = "scholz-versand.com" ascii
      $c2_798 = "scorpion.poulsenv.com" ascii
      $c2_799 = "scrlk.exprenum.com" ascii
      $c2_800 = "sdmsg.onmypc.org" ascii
      $c2_801 = "se.toythieves.com" ascii
      $c2_802 = "sea.websegoo.net" ascii
      $c2_803 = "secertnews.mrbasic.com" ascii
      $c2_804 = "secmicrosooo.6600.org" ascii
      $c2_805 = "secnetshit.com" ascii
      $c2_806 = "secserverupdate.toh.info" ascii
      $c2_807 = "sell.mofaess.com" ascii
      $c2_808 = "sema.linuxsofta.com" ascii
      $c2_809 = "send.have8000.com" ascii
      $c2_810 = "send.mofa.ns01.info" ascii
      $c2_811 = "sendmsg.jumpingcrab.com" ascii
      $c2_812 = "senseye.ikwb.com" ascii
      $c2_813 = "senseye.mrbonus.com" ascii
      $c2_814 = "septdlluckysystem.jungleheart.com" ascii
      $c2_815 = "seraphim-yurieva.justdied.com" ascii
      $c2_816 = "serv.justdied.com" ascii
      $c2_817 = "server1.proxydns.com" ascii
      $c2_818 = "seyesb.acmetoy.com" ascii
      $c2_819 = "sha.25u.com" ascii
      $c2_820 = "sha.ikwb.com" ascii
      $c2_821 = "shenajou.com" ascii
      $c2_822 = "shoppingcentre.station155.com" ascii
      $c2_823 = "shrimp.UsFfUnicef.com" ascii
      $c2_824 = "shrimp.bdoncloud.com" ascii
      $c2_825 = "shugiin.jkub.com" ascii
      $c2_826 = "sindeali.com" ascii
      $c2_827 = "singed.otzo.com" ascii
      $c2_828 = "siteinit.info" ascii
      $c2_829 = "sky.oldbmwy.com" ascii
      $c2_830 = "sma.jimindaddy.com" ascii
      $c2_831 = "smo.gadskysun.com" ascii
      $c2_832 = "smtp.architectisusa.com" ascii
      $c2_833 = "smtp.macforlinux.net" ascii
      $c2_834 = "smtp230.toldweb.com" ascii
      $c2_835 = "somthing.re26.com" ascii
      $c2_836 = "sstday.jkub.com" ascii
      $c2_837 = "start.usrobothome.com" ascii
      $c2_838 = "station155.com" ascii
      $c2_839 = "stevenlf.com" ascii
      $c2_840 = "stone.jumpingcrab.com" ascii
      $c2_841 = "style.u-tokyo-ac-jp.com" ascii
      $c2_842 = "suayay.com" ascii
      $c2_843 = "suibian2010.info" ascii
      $c2_844 = "support1.mrface.com" ascii
      $c2_845 = "supportus.mefound.com" ascii
      $c2_846 = "suzukigooogle.8866.org" ascii
      $c2_847 = "svc.dynssl.com" ascii
      $c2_848 = "synssl.dnset.com" ascii
      $c2_849 = "sz.thedomais.info" ascii
      $c2_850 = "taipei.yourtrap.com" ascii
      $c2_851 = "taipeifoodsite.ocry.com" ascii
      $c2_852 = "tamraj.fartit.com" ascii
      $c2_853 = "telegraph.mefound.com" ascii
      $c2_854 = "test.usyahooapis.com" ascii
      $c2_855 = "tfa.longmusic.com" ascii
      $c2_856 = "tffghelth.com" ascii
      $c2_857 = "thedomais.info" ascii
      $c2_858 = "ticket.instanthq.com" ascii
      $c2_859 = "ticket.jetos.com" ascii
      $c2_860 = "ticket.serveuser.com" ascii
      $c2_861 = "tidatacenter.shenajou.com" ascii
      $c2_862 = "tisdatacenter.shenajou.com" ascii
      $c2_863 = "tisupdateinfo.faqserv.com" ascii
      $c2_864 = "tokyo-gojp.com" ascii
      $c2_865 = "tokyofile.2waky.com" ascii
      $c2_866 = "tomorrowforgood.com" ascii
      $c2_867 = "tophost.dynamicdns.co.uk" ascii
      $c2_868 = "toshste.com" ascii
      $c2_869 = "toya.7766.org" ascii
      $c2_870 = "transfer.lflinkup.org" ascii
      $c2_871 = "transfer.mrbasic.com" ascii
      $c2_872 = "transfer.vizvaz.com" ascii
      $c2_873 = "trasul.mypicture.info" ascii
      $c2_874 = "travelyokogawafz.fartit.com" ascii
      $c2_875 = "trendmicroupdate.shenajou.com" ascii
      $c2_876 = "trendsecurity.shenajou.com" ascii
      $c2_877 = "trout.belowto.com" ascii
      $c2_878 = "tv.goldtoyota.com" ascii
      $c2_879 = "tw.2012yearleft.com" ascii
      $c2_880 = "twmusic.proxydns.com" ascii
      $c2_881 = "twpeoplemusicsite.my03.com" ascii
      $c2_882 = "twtravelinfomation.toythieves.com" ascii
      $c2_883 = "twx.mynumber.org" ascii
      $c2_884 = "tyoto-go-jp.com" ascii
      $c2_885 = "u-tokyo-ac-jp.com" ascii
      $c2_886 = "u1.FartIT.com" ascii
      $c2_887 = "u1.haoyujd.info" ascii
      $c2_888 = "ubuntusofta.com" ascii
      $c2_889 = "ugreen.itemdb.com" ascii
      $c2_890 = "ui.hdcdui.com" ascii
      $c2_891 = "uk.dynamicdns.org.uk" ascii
      $c2_892 = "ukuoka.cloud-maste.com" ascii
      $c2_893 = "ultimedia.vmmini.com" ascii
      $c2_894 = "un.ddns.info" ascii
      $c2_895 = "un.dnsrd.com" ascii
      $c2_896 = "unhamj.com" ascii
      $c2_897 = "update.yourtrap.com" ascii
      $c2_898 = "updatemirrors.fartit.com" ascii
      $c2_899 = "updates.itsaol.com" ascii
      $c2_900 = "ups.improvejpese.com" ascii
      $c2_901 = "urearapetsu.com" ascii
      $c2_902 = "usa.got-game.org" ascii
      $c2_903 = "usa.itsaol.com" ascii
      $c2_904 = "usa.japanteam.org" ascii
      $c2_905 = "usffunicef.com" ascii
      $c2_906 = "usmirocomney.net" ascii
      $c2_907 = "usrobothome.com" ascii
      $c2_908 = "usyahooapis.com" ascii
      $c2_909 = "uu.logon-live.com" ascii
      $c2_910 = "uu.niushenghuo.info" ascii
      $c2_911 = "ux.niushenghuo.info" ascii
      $c2_912 = "v4.appledownload.ourhobby.com" ascii
      $c2_913 = "v4.itunesmusic.jkub.com" ascii
      $c2_914 = "v4.microsoftmusic.onedumb.com" ascii
      $c2_915 = "v4.microsoftupdate.mrbasic.com" ascii
      $c2_916 = "v4.windowsupdate.DEDGESUITE.NET" ascii
      $c2_917 = "v4.windowsupdate.authorizeddns.org" ascii
      $c2_918 = "v4.windowsupdate.dnset.com" ascii
      $c2_919 = "v4.windowsupdate.itsaol.com" ascii
      $c2_920 = "v4.windowsupdate.lflinkup.com" ascii
      $c2_921 = "v4.windowsupdate.mrface.com" ascii
      $c2_922 = "v4.windowsupdate.nsatcdns.com" ascii
      $c2_923 = "v4.windowsupdate.x24hr.com" ascii
      $c2_924 = "v4.windowsupdates.dnsrd.com" ascii
      $c2_925 = "veryhuai.info" ascii
      $c2_926 = "video.vmdnsup.org" ascii
      $c2_927 = "vmdnsup.org" ascii
      $c2_929 = "vmyiersend.WEBSAGO.INFO" ascii
      $c2_930 = "vmyisan.website0012.net" ascii
      $c2_932 = "wchildress.com" ascii
      $c2_934 = "wcxh.mynetav.net" ascii
      $c2_935 = "wdsupdates.com" ascii
      $c2_936 = "webbooting.com" ascii
      $c2_937 = "webdirectnews.dynamicdns.biz" ascii
      $c2_938 = "webinfoseco.ygto.com" ascii
      $c2_939 = "webmailentry.jetos.com" ascii
      $c2_940 = "weboot.info" ascii
      $c2_941 = "websago.info" ascii
      $c2_942 = "websegoo.net" ascii
      $c2_943 = "website0012.net" ascii
      $c2_944 = "websiteboo.website0012.net" ascii
      $c2_945 = "websqlnewsmanager.ninth.biz" ascii
      $c2_946 = "webssl9.info" ascii
      $c2_947 = "well.itsaol.com" ascii
      $c2_948 = "well.mrbasic.com" ascii
      $c2_949 = "whale.toshste.com" ascii
      $c2_950 = "whellbuy.wschandler.com" ascii
      $c2_951 = "whyis.haoyujd.info" ascii
      $c2_952 = "wike.wikaba.com" ascii
      $c2_953 = "windowfile.itemdb.com" ascii
      $c2_954 = "windowsimages.itemdb.com" ascii
      $c2_955 = "windowsimages.qhigh.com" ascii
      $c2_956 = "windowsmirrors.vizvaz.com" ascii
      $c2_957 = "windowsstores.gettrials.com" ascii
      $c2_958 = "windowsstores.organiccrap.com" ascii
      $c2_959 = "windowsupdate.2waky.com" ascii
      $c2_960 = "windowsupdate.3-a.net" ascii
      $c2_961 = "windowsupdate.acmetoy.com" ascii
      $c2_962 = "windowsupdate.authorizeddns.net" ascii
      $c2_963 = "windowsupdate.authorizeddns.org" ascii
      $c2_964 = "windowsupdate.authorizeddns.us" ascii
      $c2_965 = "windowsupdate.com.mwcname.com" ascii
      $c2_966 = "windowsupdate.dedgesuite.net" ascii
      $c2_967 = "windowsupdate.dns05.com" ascii
      $c2_968 = "windowsupdate.dnset.com" ascii
      $c2_969 = "windowsupdate.esmtp.biz" ascii
      $c2_970 = "windowsupdate.ezua.com" ascii
      $c2_971 = "windowsupdate.fartit.com" ascii
      $c2_972 = "windowsupdate.gettrials.com" ascii
      $c2_973 = "windowsupdate.instanthq.com" ascii
      $c2_974 = "windowsupdate.itsaol.com" ascii
      $c2_975 = "windowsupdate.jungleheart.com" ascii
      $c2_976 = "windowsupdate.lflink.com" ascii
      $c2_977 = "windowsupdate.mrface.com" ascii
      $c2_978 = "windowsupdate.mylftv.com" ascii
      $c2_979 = "windowsupdate.nsatcdns.com" ascii
      $c2_980 = "windowsupdate.organiccrap.com" ascii
      $c2_981 = "windowsupdate.rebatesrule.net" ascii
      $c2_982 = "windowsupdate.sellclassics.com" ascii
      $c2_983 = "windowsupdate.serveusers.com" ascii
      $c2_984 = "windowsupdate.vizvaz.com" ascii
      $c2_985 = "windowsupdate.wcwname.com" ascii
      $c2_986 = "windowsupdate.x24hr.com" ascii
      $c2_987 = "windowsupdate.ygto.com" ascii
      $c2_988 = "windowsupdates.dnset.com" ascii
      $c2_989 = "windowsupdates.ezua.com" ascii
      $c2_990 = "windowsupdates.ikwb.com" ascii
      $c2_991 = "windowsupdates.itemdb.com" ascii
      $c2_992 = "windowsupdates.proxydns.com" ascii
      $c2_993 = "workerisgood.com" ascii
      $c2_994 = "woyaofanwen.com" ascii
      $c2_995 = "wschandler.com" ascii
      $c2_996 = "wthelpdesk.com" ascii
      $c2_997 = "wubangtu.info" ascii
      $c2_998 = "www-meti-go-jp.tyoto-go-jp.com" ascii
      $c2_999 = "www.2014.zzux.com" ascii
      $c2_1000 = "www.97sm.com" ascii
      $c2_1001 = "www.9gowg.tech" ascii
      $c2_1002 = "www.abdominal.faqserv.com" ascii
      $c2_1003 = "www.additional.sexidude.com" ascii
      $c2_1004 = "www.afc.https443.org" ascii
      $c2_1005 = "www.androidmusicapp.onmypc.us" ascii
      $c2_1006 = "www.announcements.toythieves.com" ascii
      $c2_1007 = "www.anx-own-334.mrbasic.com" ascii
      $c2_1008 = "www.apple.ikwb.com" ascii
      $c2_1009 = "www.appledownload.ourhobby.com" ascii
      $c2_1010 = "www.appleimages.itemdb.com" ascii
      $c2_1011 = "www.appleimages.longmusic.com" ascii
      $c2_1012 = "www.appleimages.organiccrap.com" ascii
      $c2_1013 = "www.applejuice.itemdb.com" ascii
      $c2_1014 = "www.applemirror.organiccrap.com" ascii
      $c2_1015 = "www.applemirror.squirly.info" ascii
      $c2_1016 = "www.applemusic.isasecret.com" ascii
      $c2_1017 = "www.applemusic.itemdb.com" ascii
      $c2_1018 = "www.applemusic.wikaba.com" ascii
      $c2_1019 = "www.applemusic.xxuz.com" ascii
      $c2_1020 = "www.applemusic.zzux.com" ascii
      $c2_1021 = "www.appleupdate.itemdb.com" ascii
      $c2_1022 = "www.appleupdateurl.2waky.com" ascii
      $c2_1023 = "www.architectisusa.com" ascii
      $c2_1024 = "www.army.xxuz.com" ascii
      $c2_1025 = "www.art.p6p6.net" ascii
      $c2_1026 = "www.asfzx.x24hr.com" ascii
      $c2_1027 = "www.availab.wikaba.com" ascii
      $c2_1028 = "www.availability.justdied.com" ascii
      $c2_1029 = "www.babymusicsitetr.mymom.info" ascii
      $c2_1030 = "www.back.jungleheart.com" ascii
      $c2_1031 = "www.balance1.wikaba.com" ascii
      $c2_1032 = "www.be.mrslove.com" ascii
      $c2_1033 = "www.belowto.com" ascii
      $c2_1034 = "www.billing.organiccrap.com" ascii
      $c2_1035 = "www.blaaaaaaaaaaaa.windowsupdate.3-a.net" ascii
      $c2_1036 = "www.brand.fartit.com" ascii
      $c2_1037 = "www.bulletproof.squirly.info" ascii
      $c2_1038 = "www.cabbage.iownyour.biz" ascii
      $c2_1039 = "www.ccupdatedata.authorizeddns.net" ascii
      $c2_1040 = "www.cdn.incloud-go.com" ascii
      $c2_1041 = "www.center.shenajou.com" ascii
      $c2_1042 = "www.chaindungeons.com" ascii
      $c2_1043 = "www.cia.ezua.com" ascii
      $c2_1044 = "www.cia.toh.info" ascii
      $c2_1045 = "www.civilwar123.authorizeddns.org" ascii
      $c2_1046 = "www.civilwar520.onmypc.org" ascii
      $c2_1047 = "www.cloud-maste.com" ascii
      $c2_1048 = "www.cnnews.mylftv.com" ascii
      $c2_1049 = "www.commissioner.shenajou.com" ascii
      $c2_1050 = "www.commons.onedumb.com" ascii
      $c2_1051 = "www.contractus.qpoe.com" ascii
      $c2_1052 = "www.corp-dnsonline.itsaol.com" ascii
      $c2_1053 = "www.courier.jetos.com" ascii
      $c2_1054 = "www.cress.mynetav.net" ascii
      $c2_1055 = "www.ctdl.windowsupdate.nsatcdns.com" ascii
      $c2_1056 = "www.ctldl.microsoftupdate.qhigh.com" ascii
      $c2_1057 = "www.ctldl.windowsupdate.authorizeddns.us" ascii
      $c2_1058 = "www.ctldl.windowsupdate.esmtp.biz" ascii
      $c2_1059 = "www.ctldl.windowsupdate.mrface.com" ascii
      $c2_1060 = "www.cwiinatonal.com" ascii
      $c2_1061 = "www.dasoftactivemodule.toythieves.com" ascii
      $c2_1062 = "www.dasonews.youdontcare.com" ascii
      $c2_1063 = "www.daughter.vizvaz.com" ascii
      $c2_1064 = "www.de.onmypc.info" ascii
      $c2_1065 = "www.details.squirly.info" ascii
      $c2_1066 = "www.development.shenajou.com" ascii
      $c2_1067 = "www.devilcase.acmetoy.com" ascii
      $c2_1068 = "www.disruptive.https443.net" ascii
      $c2_1069 = "www.dns-hinettw.25u.com" ascii
      $c2_1070 = "www.document.shenajou.com" ascii
      $c2_1071 = "www.domainnow.yourtrap.com" ascii
      $c2_1072 = "www.download.windowsupdate.nsatcdns.com" ascii
      $c2_1073 = "www.ea.onmypc.info" ascii
      $c2_1074 = "www.eddo.qpoe.com" ascii
      $c2_1075 = "www.ehshiroshima.mylftv.com" ascii
      $c2_1076 = "www.eric-averyanov.wha.la" ascii
      $c2_1077 = "www.eu.acmetoy.com" ascii
      $c2_1078 = "www.eu.wha.la" ascii
      $c2_1079 = "www.express.lflinkup.com" ascii
      $c2_1080 = "www.extraordinary.dynamic-dns.net" ascii
      $c2_1081 = "www.f068v.site" ascii
      $c2_1082 = "www.facefile.fartit.com" ascii
      $c2_1083 = "www.fertile.authorizeddns.net" ascii
      $c2_1084 = "www.file.zzux.com" ascii
      $c2_1085 = "www.findme.epac.to" ascii
      $c2_1086 = "www.fire.mrface.com" ascii
      $c2_1087 = "www.firstnews.jkub.com" ascii
      $c2_1088 = "www.fjs.wikaba.com" ascii
      $c2_1089 = "www.foal.wchildress.com" ascii
      $c2_1090 = "www.fr.wikaba.com" ascii
      $c2_1091 = "www.freegamecenter.onedumb.com" ascii
      $c2_1092 = "www.fruit.qhigh.com" ascii
      $c2_1093 = "www.fuck.ikwb.com" ascii
      $c2_1094 = "www.fuckmm.dns-dns.com" ascii
      $c2_1095 = "www.fukuoka.cloud-maste.com" ascii
      $c2_1096 = "www.g3ypf.online" ascii
      $c2_1097 = "www.garlic.dyndns.pro" ascii
      $c2_1098 = "www.generat.almostmy.com" ascii
      $c2_1099 = "www.glicense.shenajou.com" ascii
      $c2_1100 = "www.goldtoyota.com" ascii
      $c2_1101 = "www.goodmusic.justdied.com" ascii
      $c2_1102 = "www.gooesdataios.instanthq.com" ascii
      $c2_1103 = "www.grammar.jkub.com" ascii
      $c2_1104 = "www.helpus.ddns.info" ascii
      $c2_1105 = "www.hii.qhigh.com" ascii
      $c2_1106 = "www.hinetonlinedns.dns05.com" ascii
      $c2_1107 = "www.incloud-go.com" ascii
      $c2_1108 = "www.innocent-isayev.sexidude.com" ascii
      $c2_1109 = "www.interpreter.shenajou.com" ascii
      $c2_1110 = "www.invoices.sexxxy.biz" ascii
      $c2_1111 = "www.iphone.vizvaz.com" ascii
      $c2_1112 = "www.ipv4.microsoftupdate.mrbasic.com" ascii
      $c2_1113 = "www.ipv4.windowsupdate.3-a.net" ascii
      $c2_1114 = "www.ipv4.windowsupdate.esmtp.biz" ascii
      $c2_1115 = "www.ipv4.windowsupdate.fartit.com" ascii
      $c2_1116 = "www.ipv4.windowsupdate.lflink.com" ascii
      $c2_1117 = "www.ipv4.windowsupdate.mrface.com" ascii
      $c2_1118 = "www.ipv4.windowsupdate.mylftv.com" ascii
      $c2_1119 = "www.ipv4.windowsupdate.nsatcdns.com" ascii
      $c2_1120 = "www.itlans.isasecret.com" ascii
      $c2_1121 = "www.itunesdownload.jkub.com" ascii
      $c2_1122 = "www.itunesdownload.vizvaz.com" ascii
      $c2_1123 = "www.itunesdownload.wikaba.com" ascii
      $c2_1124 = "www.itunesimages.itemdb.com" ascii
      $c2_1125 = "www.itunesimages.itsaol.com" ascii
      $c2_1126 = "www.itunesimages.qpoe.com" ascii
      $c2_1127 = "www.itunesmirror.fartit.com" ascii
      $c2_1128 = "www.itunesmirror.itsaol.com" ascii
      $c2_1129 = "www.itunesmusic.ikwb.com" ascii
      $c2_1130 = "www.itunesmusic.jetos.com" ascii
      $c2_1131 = "www.itunesmusic.jkub.com" ascii
      $c2_1132 = "www.itunesmusic.zzux.com" ascii
      $c2_1133 = "www.itunesupdate.itsaol.com" ascii
      $c2_1134 = "www.itunesupdates.organiccrap.com" ascii
      $c2_1135 = "www.japanenvnews.qpoe.com" ascii
      $c2_1136 = "www.jd978.com" ascii
      $c2_1137 = "www.jimin.jimindaddy.com" ascii
      $c2_1138 = "www.jimin.mymom.info" ascii
      $c2_1139 = "www.jp.serveuser.com" ascii
      $c2_1140 = "www.jpnappstore.ourhobby.com" ascii
      $c2_1141 = "www.jpnewslogs.sendsmtp.com" ascii
      $c2_1142 = "www.jpnxzshopdata.authorizeddns.org" ascii
      $c2_1143 = "www.kawasaki.cloud-maste.com" ascii
      $c2_1144 = "www.kawasaki.unhamj.com" ascii
      $c2_1145 = "www.key.zzux.com" ascii
      $c2_1146 = "www.knowledge.sellclassics.com" ascii
      $c2_1147 = "www.lan.dynssl.com" ascii
      $c2_1148 = "www.last.p6p6.net" ascii
      $c2_1149 = "www.latestnews.epac.to" ascii
      $c2_1150 = "www.latestnews.organiccrap.com" ascii
      $c2_1151 = "www.leedong.longmusic.com" ascii
      $c2_1152 = "www.leeks.mrbonus.com" ascii
      $c2_1153 = "www.liberty.acmetoy.com" ascii
      $c2_1154 = "www.license.shenajou.com" ascii
      $c2_1155 = "www.lion.wchildress.com" ascii
      $c2_1156 = "www.loveddos.com" ascii
      $c2_1157 = "www.macfee.mrface.com" ascii
      $c2_1158 = "www.macforlinux.net" ascii
      $c2_1159 = "www.maffc.mrface.com" ascii
      $c2_1160 = "www.malware.dsmtp.com" ascii
      $c2_1161 = "www.manager.jetos.com" ascii
      $c2_1162 = "www.markabcinfo.dynamicdns.me.uk" ascii
      $c2_1163 = "www.mason.vizvaz.com" ascii
      $c2_1164 = "www.mediapath.organiccrap.com" ascii
      $c2_1165 = "www.meiji-ac-jp.com" ascii
      $c2_1166 = "www.messagea.emailfound.info" ascii
      $c2_1167 = "www.microsoft.got-game.org" ascii
      $c2_1168 = "www.microsoft.mrface.com" ascii
      $c2_1169 = "www.microsoftempowering.sendsmtp.com" ascii
      $c2_1170 = "www.microsoftgame.mrface.com" ascii
      $c2_1171 = "www.microsoftgetstarted.sexidude.com" ascii
      $c2_1172 = "www.microsoftimages.organiccrap.com" ascii
      $c2_1173 = "www.microsoftmirror.mrbasic.com" ascii
      $c2_1174 = "www.microsoftmusic.itemdb.com" ascii
      $c2_1175 = "www.microsoftmusic.mrbasic.com" ascii
      $c2_1176 = "www.microsoftqckmanager.pcanywhere.net" ascii
      $c2_1177 = "www.microsoftupdate.mrbasic.com" ascii
      $c2_1178 = "www.microsoftupdate.qhigh.com" ascii
      $c2_1179 = "www.micrsoftware.dsmtp.com" ascii
      $c2_1180 = "www.mircsoft.compress.to" ascii
      $c2_1181 = "www.mmy.ddns.us" ascii
      $c2_1182 = "www.mod.jetos.com" ascii
      $c2_1183 = "www.mofa.dynamic-dns.net" ascii
      $c2_1184 = "www.mofa.ns01.info" ascii
      $c2_1185 = "www.moonnightthse.zyns.com" ascii
      $c2_1186 = "www.moscowdic.trickip.org" ascii
      $c2_1187 = "www.moscowstdsupdate.toythieves.com" ascii
      $c2_1188 = "www.mseupdate.ourhobby.com" ascii
      $c2_1189 = "www.msg.ezua.com" ascii
      $c2_1190 = "www.msn.incloud-go.com" ascii
      $c2_1191 = "www.musicfile.ikwb.com" ascii
      $c2_1192 = "www.musicjj.zzux.com" ascii
      $c2_1193 = "www.musicsecph.squirly.info" ascii
      $c2_1194 = "www.mymusicbox.lflinkup.org" ascii
      $c2_1195 = "www.mymusicbox.vizvaz.com" ascii
      $c2_1196 = "www.myrestroomimage.isasecret.com" ascii
      $c2_1197 = "www.mytwhomeinst.sendsmtp.com" ascii
      $c2_1198 = "www.myurinikoreaaps.ninth.biz" ascii
      $c2_1199 = "www.na.americanunfinished.com" ascii
      $c2_1200 = "www.na.onmypc.org" ascii
      $c2_1201 = "www.networkjpnzee.mynetav.org" ascii
      $c2_1202 = "www.newcityoforward.rebatesrule.net" ascii
      $c2_1203 = "www.newdnssec-info.4mydomain.com" ascii
      $c2_1204 = "www.newsdata.jkub.com" ascii
      $c2_1205 = "www.newsfile.toythieves.com" ascii
      $c2_1206 = "www.newsroom.cleansite.info" ascii
      $c2_1207 = "www.nlddnsinfo.https443.org" ascii
      $c2_1208 = "www.no.authorizeddns.org" ascii
      $c2_1209 = "www.nposnewsinfo.qhigh.com" ascii
      $c2_1210 = "www.nsa.mefound.com" ascii
      $c2_1211 = "www.nt.mynumber.org" ascii
      $c2_1212 = "www.nttdata.otzo.com" ascii
      $c2_1213 = "www.nuisance.serveusers.com" ascii
      $c2_1214 = "www.nz.compress.to" ascii
      $c2_1215 = "www.ol.almostmy.com" ascii
      $c2_1216 = "www.oldbmwy.com" ascii
      $c2_1217 = "www.onion.jkub.com" ascii
      $c2_1218 = "www.onlinednsserver.sendsmtp.com" ascii
      $c2_1219 = "www.oracleupdate.dns04.com" ascii
      $c2_1220 = "www.oyster.jkub.com" ascii
      $c2_1221 = "www.p6p6.net" ascii
      $c2_1222 = "www.packetsdsquery.dns05.com" ascii
      $c2_1223 = "www.pepper.sexxxy.biz" ascii
      $c2_1224 = "www.phptecinfohelp.itemdb.com" ascii
      $c2_1225 = "www.pickled.myddns.com" ascii
      $c2_1226 = "www.polopurple.com" ascii
      $c2_1227 = "www.portal.mrface.com" ascii
      $c2_1228 = "www.portal.sendsmtp.com" ascii
      $c2_1229 = "www.portalser.dynamic-dns.net" ascii
      $c2_1230 = "www.praskovya-matveyeva.mefound.com" ascii
      $c2_1231 = "www.praskovya-ulyanova.dumb1.com" ascii
      $c2_1232 = "www.products.almostmy.com" ascii
      $c2_1233 = "www.products.cleansite.us" ascii
      $c2_1234 = "www.products.serveuser.com" ascii
      $c2_1235 = "www.purchase.lflinkup.org" ascii
      $c2_1236 = "www.rainbow.mypop3.org" ascii
      $c2_1237 = "www.re26.com" ascii
      $c2_1238 = "www.read.xxuz.com" ascii
      $c2_1239 = "www.recent.dns-stuff.com" ascii
      $c2_1240 = "www.recent.fartit.com" ascii
      $c2_1241 = "www.redflower.isasecret.com" ascii
      $c2_1242 = "www.referred.gr8domain.biz" ascii
      $c2_1243 = "www.referred.yourtrap.com" ascii
      $c2_1244 = "www.register.ourhobby.com" ascii
      $c2_1245 = "www.registration2.instanthq.com" ascii
      $c2_1246 = "www.registrations.4pu.com" ascii
      $c2_1247 = "www.registrations.organiccrap.com" ascii
      $c2_1248 = "www.remeberdata.iownyour.org" ascii
      $c2_1249 = "www.reserveds.onedumb.com" ascii
      $c2_1250 = "www.rethem.almostmy.com" ascii
      $c2_1251 = "www.rg197.win" ascii
      $c2_1252 = "www.sakai.unhamj.com" ascii
      $c2_1253 = "www.sapporo.cloud-maste.com" ascii
      $c2_1254 = "www.sauerkraut.sellclassics.com" ascii
      $c2_1255 = "www.saverd.re26.com" ascii
      $c2_1256 = "www.sbuudd.webssl9.info" ascii
      $c2_1257 = "www.sdmsg.onmypc.org" ascii
      $c2_1258 = "www.se.toythieves.com" ascii
      $c2_1259 = "www.secertnews.mrbasic.com" ascii
      $c2_1260 = "www.secnetshit.com" ascii
      $c2_1261 = "www.secserverupdate.toh.info" ascii
      $c2_1262 = "www.senseye.ikwb.com" ascii
      $c2_1263 = "www.senseye.mrbonus.com" ascii
      $c2_1264 = "www.septdlluckysystem.jungleheart.com" ascii
      $c2_1265 = "www.seraphim-yurieva.justdied.com" ascii
      $c2_1266 = "www.serv.justdied.com" ascii
      $c2_1267 = "www.server1.proxydns.com" ascii
      $c2_1268 = "www.seyesb.acmetoy.com" ascii
      $c2_1269 = "www.showy.almostmy.com" ascii
      $c2_1270 = "www.shugiin.jkub.com" ascii
      $c2_1271 = "www.sindeali.com" ascii
      $c2_1272 = "www.singed.otzo.com" ascii
      $c2_1273 = "www.sojourner.mypicture.info" ascii
      $c2_1274 = "www.sstday.jkub.com" ascii
      $c2_1275 = "www.support1.mrface.com" ascii
      $c2_1276 = "www.supportus.mefound.com" ascii
      $c2_1277 = "www.svc.dynssl.com" ascii
      $c2_1278 = "www.sweetheart.sexxxy.biz" ascii
      $c2_1279 = "www.synssl.dnset.com" ascii
      $c2_1280 = "www.tamraj.fartit.com" ascii
      $c2_1281 = "www.telegraph.mefound.com" ascii
      $c2_1282 = "www.tfa.longmusic.com" ascii
      $c2_1283 = "www.thunder.wikaba.com" ascii
      $c2_1284 = "www.ticket.instanthq.com" ascii
      $c2_1285 = "www.ticket.serveuser.com" ascii
      $c2_1286 = "www.tisupdateinfo.faqserv.com" ascii
      $c2_1287 = "www.tokyofile.2waky.com" ascii
      $c2_1288 = "www.tophost.dynamicdns.co.uk" ascii
      $c2_1289 = "www.transfer.lflinkup.org" ascii
      $c2_1290 = "www.transfer.mrbasic.com" ascii
      $c2_1291 = "www.transfer.vizvaz.com" ascii
      $c2_1292 = "www.twgovernmentinfo.acmetoy.com" ascii
      $c2_1293 = "www.twsslpopservupro.dynssl.com" ascii
      $c2_1294 = "www.ugreen.itemdb.com" ascii
      $c2_1295 = "www.uk.dynamicdns.org.uk" ascii
      $c2_1296 = "www.un.ddns.info" ascii
      $c2_1297 = "www.un.dnsrd.com" ascii
      $c2_1298 = "www.unhamj.com" ascii
      $c2_1299 = "www.usa.itsaol.com" ascii
      $c2_1300 = "www.usffunicef.com" ascii
      $c2_1301 = "www.usliveupdateonline.ygto.com" ascii
      $c2_1302 = "www.ut-portal-u-tokyo-ac-jp.tyoto-go-jp.com" ascii
      $c2_1303 = "www.v4.windowsupdate.mrface.com" ascii
      $c2_1304 = "www.v4.windowsupdate.nsatcdns.com" ascii
      $c2_1305 = "www.vmmini.com" ascii
      $c2_1306 = "www.wchildress.com" ascii
      $c2_1307 = "www.webdirectnews.dynamicdns.biz" ascii
      $c2_1308 = "www.webmailentry.jetos.com" ascii
      $c2_1309 = "www.websqlnewsmanager.ninth.biz" ascii
      $c2_1310 = "www.well.itsaol.com" ascii
      $c2_1311 = "www.well.mrbasic.com" ascii
      $c2_1312 = "www.windowfile.itemdb.com" ascii
      $c2_1313 = "www.windowsimages.itemdb.com" ascii
      $c2_1314 = "www.windowsimages.qhigh.com" ascii
      $c2_1315 = "www.windowsmirrors.vizvaz.com" ascii
      $c2_1316 = "www.windowsupdate.2waky.com" ascii
      $c2_1317 = "www.windowsupdate.3-a.net" ascii
      $c2_1318 = "www.windowsupdate.acmetoy.com" ascii
      $c2_1319 = "www.windowsupdate.authorizeddns.net" ascii
      $c2_1320 = "www.windowsupdate.authorizeddns.org" ascii
      $c2_1321 = "www.windowsupdate.authorizeddns.us" ascii
      $c2_1322 = "www.windowsupdate.dns05.com" ascii
      $c2_1323 = "www.windowsupdate.dnset.com" ascii
      $c2_1324 = "www.windowsupdate.esmtp.biz" ascii
      $c2_1325 = "www.windowsupdate.ezua.com" ascii
      $c2_1326 = "www.windowsupdate.fartit.com" ascii
      $c2_1327 = "www.windowsupdate.gettrials.com" ascii
      $c2_1328 = "www.windowsupdate.instanthq.com" ascii
      $c2_1329 = "www.windowsupdate.itsaol.com" ascii
      $c2_1330 = "www.windowsupdate.jungleheart.com" ascii
      $c2_1331 = "www.windowsupdate.lflink.com" ascii
      $c2_1332 = "www.windowsupdate.mrface.com" ascii
      $c2_1333 = "www.windowsupdate.mylftv.com" ascii
      $c2_1334 = "www.windowsupdate.nsatcdns.com" ascii
      $c2_1335 = "www.windowsupdate.organiccrap.com" ascii
      $c2_1336 = "www.windowsupdate.rebatesrule.net" ascii
      $c2_1337 = "www.windowsupdate.sellclassics.com" ascii
      $c2_1338 = "www.windowsupdate.serveusers.com" ascii
      $c2_1339 = "www.windowsupdate.x24hr.com" ascii
      $c2_1340 = "www.yahoo.incloud-go.com" ascii
      $c2_1341 = "www.yandexr.sellclassics.com" ascii
      $c2_1342 = "www.yeahyeahyeahs.3322.org" ascii
      $c2_1343 = "www.yokohamajpinstaz.mrbonus.com" ascii
      $c2_1344 = "www.zaigawebinfo.rebatesrule.net" ascii
      $c2_1345 = "www.zebra.incloud-go.com" ascii
      $c2_1346 = "www2.qpoe.com" ascii
      $c2_1347 = "www2.zyns.com" ascii
      $c2_1348 = "www2.zzux.com" ascii
      $c2_1349 = "x7.usyahooapis.com" ascii
      $c2_1350 = "xi.dyndns.pro" ascii
      $c2_1351 = "xi.sexxxy.biz" ascii
      $c2_1352 = "xread10821.9966.org" ascii
      $c2_1353 = "xsince.tk" ascii
      $c2_1354 = "xt.dnset.com" ascii
      $c2_1355 = "xyrn998754.2288.org" ascii
      $c2_1356 = "yahoo.incloud-go.com" ascii
      $c2_1357 = "yallago.cu.cc" ascii
      $c2_1358 = "yandexr.sellclassics.com" ascii
      $c2_1359 = "yeahyeahyeahs.3322.org" ascii
      $c2_1360 = "yeap1.jumpingcrab.com" ascii
      $c2_1361 = "yfrfyhf.youdontcare.com" ascii
      $c2_1362 = "yo.acmetoy.com" ascii
      $c2_1363 = "za.myftp.info" ascii
      $c2_1364 = "zabbix.servercontrols.pw" ascii
      $c2_1365 = "zaigawebinfo.rebatesrule.net" ascii
      $c2_1367 = "zebra.UsFfUnicef.com" ascii
      $c2_1368 = "zebra.bdoncloud.com" ascii
      $c2_1369 = "zebra.incloud-go.com" ascii
      $c2_1370 = "zebra.unhamj.com" ascii
      $c2_1371 = "zebra.wthelpdesk.com" ascii
      $c2_1372 = "zero.pcanywhere.net" ascii
      $c2_1373 = "zg.ns02.biz" ascii
      $c2_1374 = "zone.demoones.com" ascii
   condition:
      1 of ($c2_*)
}

rule APT_APT10_Malware_Imphash_Dec18_1 {
   meta:
      description = "Detects APT10 malware based on ImpHashes"
      author = "Florian Roth"
      reference = "AlienVault OTX IOCs - statistical sample analysis"
      date = "2018-12-28"
   condition:
      uint16(0) == 0x5a4d and filesize < 6000KB and (
         pe.imphash() == "0556ff5e5f8744bff47d4921494ba46d" or
         pe.imphash() == "cb1194123f68a68eb14552c085b620ce" or
         pe.imphash() == "efad9ff8c0d2a6419bf1dd970bcd806d" or
         pe.imphash() == "7a861cd9c495e1d950a43cb708a22985" or
         pe.imphash() == "a5d0545030be75a421529c2b0be6c4bd" or
         pe.imphash() == "94491f4a812b0297419dc888aa4fd2a5"
      )
}
