# Digester

Digester is a tool for generating hashes and hash-based message authentication
codes (MACs). It was written as a demonstration of some of Rust's awesome
features, including the extensive use of [Cargo features], [trait objects],
and [clap's derive macros].

Another cool tooling feature is that you can rename crates, so that you can
import a package using a crate name that you prefer. For example, I import
the `md-5` package under the crate name `md5` to retain consistency with the
`md2` and `md4` crates. (I would have loved to import `groestl` as `grøstl`,
but crate names are required to be ASCII as of current writing.)

## Usage

As generated by [clap], when all features are enabled:

```
USAGE:
    digester [OPTIONS] --algorithm <ALGORITHM> [FILES]...

ARGS:
    <FILES>...    Files to hash; stdin by default

OPTIONS:
    -a, --algorithm <ALGORITHM>      Hash algorithm to use [possible values: blake2b, blake2s,
                                     blake3, fsb160, fsb224, fsb256, fsb384, fsb512, gost94-crypto-
                                     pro, gost94s2015, grøstl224, grøstl256, grøstl384, grøstl512,
                                     md2, md4, md5, ripemd160, ripemd256, ripemd320, sha1, sha224,
                                     sha256, sha384, sha512, sha512-224, sha512-256, sha3-224, sha3-
                                     256, sha3-384, sha3-512, shabal192, shabal224, shabal256,
                                     shabal384, shabal512, sm3, streebog256, streebog512, tiger,
                                     tiger2, whirlpool]
    -h, --help                       Print help information
        --mac-key <MAC_KEY>          MAC key [env: MAC_KEY]
        --mac-key-fd <MAC_KEY_FD>    File descriptor for MAC key
    -r, --reverse                    Reverse the format of the output
    -V, --version                    Print version information
```

[Cargo features]: https://doc.rust-lang.org/stable/cargo/reference/features.html
[trait objects]: https://doc.rust-lang.org/book/ch17-02-trait-objects.html
[clap]: https://github.com/clap-rs/clap
[clap's derive macros]: https://github.com/clap-rs/clap/blob/master/examples/tutorial_derive/README.md
