#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1385
#define LARGE_STATE_COUNT 211
#define SYMBOL_COUNT 242
#define ALIAS_COUNT 5
#define TOKEN_COUNT 125
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 34
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 101

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_LBRACE = 6,
  anon_sym_COMMA = 7,
  anon_sym_RBRACE = 8,
  anon_sym_as = 9,
  anon_sym_import = 10,
  anon_sym_from = 11,
  anon_sym_var = 12,
  anon_sym_let = 13,
  anon_sym_const = 14,
  anon_sym_else = 15,
  anon_sym_if = 16,
  anon_sym_switch = 17,
  anon_sym_for = 18,
  anon_sym_LPAREN = 19,
  anon_sym_RPAREN = 20,
  anon_sym_await = 21,
  anon_sym_in = 22,
  anon_sym_of = 23,
  anon_sym_while = 24,
  anon_sym_do = 25,
  anon_sym_try = 26,
  anon_sym_with = 27,
  anon_sym_break = 28,
  anon_sym_continue = 29,
  anon_sym_debugger = 30,
  anon_sym_return = 31,
  anon_sym_throw = 32,
  anon_sym_SEMI = 33,
  anon_sym_COLON = 34,
  anon_sym_case = 35,
  anon_sym_catch = 36,
  anon_sym_finally = 37,
  anon_sym_yield = 38,
  anon_sym_EQ = 39,
  anon_sym_LBRACK = 40,
  anon_sym_RBRACK = 41,
  anon_sym_LT = 42,
  anon_sym_GT = 43,
  anon_sym_SLASH = 44,
  sym_jsx_text = 45,
  sym_jsx_identifier = 46,
  anon_sym_DOT = 47,
  anon_sym_class = 48,
  anon_sym_extends = 49,
  anon_sym_async = 50,
  anon_sym_function = 51,
  anon_sym_EQ_GT = 52,
  anon_sym_QMARK_DOT = 53,
  anon_sym_new = 54,
  anon_sym_PLUS_EQ = 55,
  anon_sym_DASH_EQ = 56,
  anon_sym_STAR_EQ = 57,
  anon_sym_SLASH_EQ = 58,
  anon_sym_PERCENT_EQ = 59,
  anon_sym_CARET_EQ = 60,
  anon_sym_AMP_EQ = 61,
  anon_sym_PIPE_EQ = 62,
  anon_sym_GT_GT_EQ = 63,
  anon_sym_GT_GT_GT_EQ = 64,
  anon_sym_LT_LT_EQ = 65,
  anon_sym_STAR_STAR_EQ = 66,
  anon_sym_AMP_AMP_EQ = 67,
  anon_sym_PIPE_PIPE_EQ = 68,
  anon_sym_QMARK_QMARK_EQ = 69,
  anon_sym_DOT_DOT_DOT = 70,
  anon_sym_QMARK = 71,
  anon_sym_AMP_AMP = 72,
  anon_sym_PIPE_PIPE = 73,
  anon_sym_GT_GT = 74,
  anon_sym_GT_GT_GT = 75,
  anon_sym_LT_LT = 76,
  anon_sym_AMP = 77,
  anon_sym_CARET = 78,
  anon_sym_PIPE = 79,
  anon_sym_PLUS = 80,
  anon_sym_DASH = 81,
  anon_sym_PERCENT = 82,
  anon_sym_STAR_STAR = 83,
  anon_sym_LT_EQ = 84,
  anon_sym_EQ_EQ = 85,
  anon_sym_EQ_EQ_EQ = 86,
  anon_sym_BANG_EQ = 87,
  anon_sym_BANG_EQ_EQ = 88,
  anon_sym_GT_EQ = 89,
  anon_sym_QMARK_QMARK = 90,
  anon_sym_instanceof = 91,
  anon_sym_BANG = 92,
  anon_sym_TILDE = 93,
  anon_sym_typeof = 94,
  anon_sym_void = 95,
  anon_sym_delete = 96,
  anon_sym_PLUS_PLUS = 97,
  anon_sym_DASH_DASH = 98,
  anon_sym_DQUOTE = 99,
  anon_sym_SQUOTE = 100,
  sym_unescaped_double_string_fragment = 101,
  sym_unescaped_single_string_fragment = 102,
  sym_escape_sequence = 103,
  sym_comment = 104,
  anon_sym_BQUOTE = 105,
  anon_sym_DOLLAR_LBRACE = 106,
  anon_sym_SLASH2 = 107,
  sym_regex_pattern = 108,
  sym_regex_flags = 109,
  sym_number = 110,
  sym_private_property_identifier = 111,
  anon_sym_target = 112,
  sym_this = 113,
  sym_super = 114,
  sym_true = 115,
  sym_false = 116,
  sym_null = 117,
  sym_undefined = 118,
  anon_sym_AT = 119,
  anon_sym_static = 120,
  anon_sym_get = 121,
  anon_sym_set = 122,
  sym__automatic_semicolon = 123,
  sym__template_chars = 124,
  sym_program = 125,
  sym_export_statement = 126,
  sym_export_clause = 127,
  sym__import_export_specifier = 128,
  sym_declaration = 129,
  sym_import = 130,
  sym_import_statement = 131,
  sym_import_clause = 132,
  sym__from_clause = 133,
  sym_namespace_import = 134,
  sym_named_imports = 135,
  sym_expression_statement = 136,
  sym_variable_declaration = 137,
  sym_lexical_declaration = 138,
  sym_variable_declarator = 139,
  sym_statement_block = 140,
  sym_else_clause = 141,
  sym_if_statement = 142,
  sym_switch_statement = 143,
  sym_for_statement = 144,
  sym_for_in_statement = 145,
  sym__for_header = 146,
  sym_while_statement = 147,
  sym_do_statement = 148,
  sym_try_statement = 149,
  sym_with_statement = 150,
  sym_break_statement = 151,
  sym_continue_statement = 152,
  sym_debugger_statement = 153,
  sym_return_statement = 154,
  sym_throw_statement = 155,
  sym_empty_statement = 156,
  sym_labeled_statement = 157,
  sym_switch_body = 158,
  sym_switch_case = 159,
  sym_switch_default = 160,
  sym_catch_clause = 161,
  sym_finally_clause = 162,
  sym_parenthesized_expression = 163,
  sym_expression = 164,
  sym_primary_expression = 165,
  sym_yield_expression = 166,
  sym_object = 167,
  sym_object_pattern = 168,
  sym_assignment_pattern = 169,
  sym_object_assignment_pattern = 170,
  sym_array = 171,
  sym_array_pattern = 172,
  sym_jsx_element = 173,
  sym_jsx_fragment = 174,
  sym_jsx_expression = 175,
  sym_jsx_opening_element = 176,
  sym_nested_identifier = 177,
  sym_jsx_namespace_name = 178,
  sym_jsx_closing_element = 179,
  sym_jsx_self_closing_element = 180,
  sym_jsx_attribute = 181,
  sym_class = 182,
  sym_class_declaration = 183,
  sym_class_heritage = 184,
  sym_function = 185,
  sym_function_declaration = 186,
  sym_generator_function = 187,
  sym_generator_function_declaration = 188,
  sym_arrow_function = 189,
  sym_call_expression = 190,
  sym_new_expression = 191,
  sym_await_expression = 192,
  sym_member_expression = 193,
  sym_subscript_expression = 194,
  sym_assignment_expression = 195,
  sym__augmented_assignment_lhs = 196,
  sym_augmented_assignment_expression = 197,
  sym__initializer = 198,
  sym__destructuring_pattern = 199,
  sym_spread_element = 200,
  sym_ternary_expression = 201,
  sym_binary_expression = 202,
  sym_unary_expression = 203,
  sym_update_expression = 204,
  sym_sequence_expression = 205,
  sym_string = 206,
  sym_template_string = 207,
  sym_template_substitution = 208,
  sym_regex = 209,
  sym_meta_property = 210,
  sym_arguments = 211,
  sym_decorator = 212,
  sym_decorator_member_expression = 213,
  sym_decorator_call_expression = 214,
  sym_class_body = 215,
  sym_field_definition = 216,
  sym_formal_parameters = 217,
  sym_pattern = 218,
  sym_rest_pattern = 219,
  sym_method_definition = 220,
  sym_pair = 221,
  sym_pair_pattern = 222,
  sym__property_name = 223,
  sym_computed_property_name = 224,
  aux_sym_program_repeat1 = 225,
  aux_sym_export_statement_repeat1 = 226,
  aux_sym_export_clause_repeat1 = 227,
  aux_sym_named_imports_repeat1 = 228,
  aux_sym_variable_declaration_repeat1 = 229,
  aux_sym_switch_body_repeat1 = 230,
  aux_sym_object_repeat1 = 231,
  aux_sym_object_pattern_repeat1 = 232,
  aux_sym_array_repeat1 = 233,
  aux_sym_array_pattern_repeat1 = 234,
  aux_sym_jsx_element_repeat1 = 235,
  aux_sym_jsx_opening_element_repeat1 = 236,
  aux_sym_string_repeat1 = 237,
  aux_sym_string_repeat2 = 238,
  aux_sym_template_string_repeat1 = 239,
  aux_sym_class_body_repeat1 = 240,
  aux_sym_formal_parameters_repeat1 = 241,
  alias_sym_import_specifier = 242,
  alias_sym_property_identifier = 243,
  alias_sym_shorthand_property_identifier = 244,
  alias_sym_shorthand_property_identifier_pattern = 245,
  alias_sym_statement_identifier = 246,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_as] = "as",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_with] = "with",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_SEMI] = ";",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SLASH] = "/",
  [sym_jsx_text] = "jsx_text",
  [sym_jsx_identifier] = "identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_extends] = "extends",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_new] = "new",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_QMARK] = "\?",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_typeof] = "typeof",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [sym_private_property_identifier] = "private_property_identifier",
  [anon_sym_target] = "target",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "_template_chars",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_export_clause] = "export_clause",
  [sym__import_export_specifier] = "export_specifier",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_jsx_element] = "jsx_element",
  [sym_jsx_fragment] = "jsx_fragment",
  [sym_jsx_expression] = "jsx_expression",
  [sym_jsx_opening_element] = "jsx_opening_element",
  [sym_nested_identifier] = "nested_identifier",
  [sym_jsx_namespace_name] = "jsx_namespace_name",
  [sym_jsx_closing_element] = "jsx_closing_element",
  [sym_jsx_self_closing_element] = "jsx_self_closing_element",
  [sym_jsx_attribute] = "jsx_attribute",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function] = "function",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_field_definition] = "field_definition",
  [sym_formal_parameters] = "formal_parameters",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_jsx_element_repeat1] = "jsx_element_repeat1",
  [aux_sym_jsx_opening_element_repeat1] = "jsx_opening_element_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_import_specifier] = "import_specifier",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [sym_jsx_text] = sym_jsx_text,
  [sym_jsx_identifier] = sym_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_unescaped_double_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_unescaped_single_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [sym_private_property_identifier] = sym_private_property_identifier,
  [anon_sym_target] = anon_sym_target,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_export_clause] = sym_export_clause,
  [sym__import_export_specifier] = sym__import_export_specifier,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_jsx_element] = sym_jsx_element,
  [sym_jsx_fragment] = sym_jsx_fragment,
  [sym_jsx_expression] = sym_jsx_expression,
  [sym_jsx_opening_element] = sym_jsx_opening_element,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_jsx_namespace_name] = sym_jsx_namespace_name,
  [sym_jsx_closing_element] = sym_jsx_closing_element,
  [sym_jsx_self_closing_element] = sym_jsx_self_closing_element,
  [sym_jsx_attribute] = sym_jsx_attribute,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function] = sym_function,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_field_definition] = sym_field_definition,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_jsx_element_repeat1] = aux_sym_jsx_element_repeat1,
  [aux_sym_jsx_opening_element_repeat1] = aux_sym_jsx_opening_element_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_import_specifier] = alias_sym_import_specifier,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_private_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__import_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_opening_element] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_namespace_name] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_self_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_opening_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_close_tag = 7,
  field_condition = 8,
  field_consequence = 9,
  field_constructor = 10,
  field_declaration = 11,
  field_decorator = 12,
  field_finalizer = 13,
  field_flags = 14,
  field_function = 15,
  field_handler = 16,
  field_increment = 17,
  field_index = 18,
  field_initializer = 19,
  field_key = 20,
  field_label = 21,
  field_left = 22,
  field_member = 23,
  field_name = 24,
  field_object = 25,
  field_open_tag = 26,
  field_operator = 27,
  field_parameter = 28,
  field_parameters = 29,
  field_pattern = 30,
  field_property = 31,
  field_right = 32,
  field_source = 33,
  field_value = 34,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_label] = "label",
  [field_left] = "left",
  [field_member] = "member",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_right] = "right",
  [field_source] = "source",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 1},
  [7] = {.index = 4, .length = 1},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 2},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 2},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 15, .length = 1},
  [14] = {.index = 16, .length = 1},
  [15] = {.index = 17, .length = 2},
  [16] = {.index = 19, .length = 2},
  [19] = {.index = 21, .length = 1},
  [20] = {.index = 22, .length = 2},
  [21] = {.index = 24, .length = 2},
  [22] = {.index = 26, .length = 2},
  [23] = {.index = 28, .length = 3},
  [24] = {.index = 31, .length = 2},
  [25] = {.index = 33, .length = 2},
  [26] = {.index = 35, .length = 2},
  [27] = {.index = 37, .length = 2},
  [28] = {.index = 39, .length = 1},
  [29] = {.index = 40, .length = 1},
  [30] = {.index = 41, .length = 1},
  [31] = {.index = 42, .length = 1},
  [32] = {.index = 43, .length = 1},
  [33] = {.index = 44, .length = 1},
  [34] = {.index = 45, .length = 2},
  [35] = {.index = 47, .length = 1},
  [36] = {.index = 48, .length = 2},
  [37] = {.index = 50, .length = 2},
  [38] = {.index = 17, .length = 2},
  [39] = {.index = 19, .length = 2},
  [40] = {.index = 52, .length = 3},
  [41] = {.index = 55, .length = 2},
  [42] = {.index = 55, .length = 2},
  [43] = {.index = 57, .length = 2},
  [44] = {.index = 59, .length = 2},
  [45] = {.index = 61, .length = 2},
  [46] = {.index = 63, .length = 2},
  [47] = {.index = 65, .length = 2},
  [48] = {.index = 67, .length = 1},
  [49] = {.index = 68, .length = 1},
  [50] = {.index = 69, .length = 2},
  [51] = {.index = 17, .length = 2},
  [52] = {.index = 71, .length = 2},
  [53] = {.index = 73, .length = 3},
  [54] = {.index = 69, .length = 2},
  [55] = {.index = 76, .length = 1},
  [56] = {.index = 77, .length = 3},
  [57] = {.index = 80, .length = 3},
  [58] = {.index = 83, .length = 3},
  [59] = {.index = 86, .length = 2},
  [60] = {.index = 88, .length = 2},
  [61] = {.index = 90, .length = 2},
  [62] = {.index = 92, .length = 1},
  [63] = {.index = 93, .length = 2},
  [64] = {.index = 95, .length = 2},
  [65] = {.index = 97, .length = 1},
  [66] = {.index = 98, .length = 2},
  [67] = {.index = 100, .length = 2},
  [68] = {.index = 102, .length = 2},
  [69] = {.index = 104, .length = 2},
  [70] = {.index = 102, .length = 2},
  [71] = {.index = 106, .length = 2},
  [72] = {.index = 108, .length = 3},
  [73] = {.index = 111, .length = 2},
  [74] = {.index = 113, .length = 2},
  [75] = {.index = 115, .length = 3},
  [76] = {.index = 118, .length = 2},
  [77] = {.index = 120, .length = 2},
  [78] = {.index = 122, .length = 4},
  [79] = {.index = 126, .length = 2},
  [80] = {.index = 128, .length = 2},
  [81] = {.index = 130, .length = 2},
  [82] = {.index = 132, .length = 3},
  [83] = {.index = 135, .length = 2},
  [84] = {.index = 137, .length = 3},
  [85] = {.index = 140, .length = 2},
  [86] = {.index = 142, .length = 3},
  [87] = {.index = 145, .length = 1},
  [88] = {.index = 146, .length = 2},
  [89] = {.index = 148, .length = 3},
  [90] = {.index = 151, .length = 4},
  [91] = {.index = 155, .length = 2},
  [92] = {.index = 155, .length = 2},
  [93] = {.index = 157, .length = 3},
  [94] = {.index = 160, .length = 3},
  [95] = {.index = 163, .length = 3},
  [96] = {.index = 166, .length = 4},
  [97] = {.index = 170, .length = 2},
  [98] = {.index = 172, .length = 4},
  [99] = {.index = 176, .length = 2},
  [100] = {.index = 178, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_declaration, 1},
  [2] =
    {field_name, 0},
  [3] =
    {field_body, 1},
  [4] =
    {field_constructor, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_argument, 0},
    {field_operator, 1},
  [9] =
    {field_arguments, 1},
    {field_function, 0},
  [11] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [13] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [15] =
    {field_declaration, 2},
  [16] =
    {field_label, 0},
  [17] =
    {field_left, 0},
    {field_right, 2},
  [19] =
    {field_body, 2},
    {field_parameter, 0},
  [21] =
    {field_source, 1},
  [22] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [24] =
    {field_condition, 1},
    {field_consequence, 2},
  [26] =
    {field_body, 2},
    {field_value, 1},
  [28] =
    {field_body, 2},
    {field_left, 1, .inherited = true},
    {field_right, 1, .inherited = true},
  [31] =
    {field_body, 2},
    {field_condition, 1},
  [33] =
    {field_body, 1},
    {field_handler, 2},
  [35] =
    {field_body, 1},
    {field_finalizer, 2},
  [37] =
    {field_body, 2},
    {field_object, 1},
  [39] =
    {field_label, 1},
  [40] =
    {field_name, 1},
  [41] =
    {field_attribute, 0},
  [42] =
    {field_pattern, 1},
  [43] =
    {field_member, 0},
  [44] =
    {field_property, 0},
  [45] =
    {field_body, 2},
    {field_name, 1},
  [47] =
    {field_body, 2},
  [48] =
    {field_body, 2},
    {field_parameters, 1},
  [50] =
    {field_arguments, 2},
    {field_constructor, 1},
  [52] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [55] =
    {field_object, 0},
    {field_property, 2},
  [57] =
    {field_arguments, 2},
    {field_function, 0},
  [59] =
    {field_close_tag, 2},
    {field_open_tag, 0},
  [61] =
    {field_body, 2},
    {field_parameters, 0},
  [63] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [65] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [67] =
    {field_source, 2, .inherited = true},
  [68] =
    {field_value, 2},
  [69] =
    {field_alias, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [71] =
    {field_key, 0},
    {field_value, 2},
  [73] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1},
  [76] =
    {field_value, 1},
  [77] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [80] =
    {field_body, 3},
    {field_left, 2, .inherited = true},
    {field_right, 2, .inherited = true},
  [83] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [86] =
    {field_attribute, 2, .inherited = true},
    {field_name, 1},
  [88] =
    {field_attribute, 0, .inherited = true},
    {field_attribute, 1, .inherited = true},
  [90] =
    {field_flags, 3},
    {field_pattern, 1},
  [92] =
    {field_property, 1},
  [93] =
    {field_property, 0},
    {field_value, 1, .inherited = true},
  [95] =
    {field_decorator, 0, .inherited = true},
    {field_property, 1},
  [97] =
    {field_member, 1, .inherited = true},
  [98] =
    {field_member, 0, .inherited = true},
    {field_member, 1, .inherited = true},
  [100] =
    {field_body, 3},
    {field_name, 1},
  [102] =
    {field_body, 3},
    {field_parameter, 1},
  [104] =
    {field_body, 3},
    {field_parameters, 2},
  [106] =
    {field_body, 3},
    {field_parameters, 1},
  [108] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [111] =
    {field_index, 2},
    {field_object, 0},
  [113] =
    {field_declaration, 3},
    {field_decorator, 0, .inherited = true},
  [115] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [118] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [120] =
    {field_alias, 2},
    {field_name, 0},
  [122] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_parameters, 2},
  [126] =
    {field_body, 1},
    {field_condition, 3},
  [128] =
    {field_property, 1},
    {field_value, 2, .inherited = true},
  [130] =
    {field_decorator, 0, .inherited = true},
    {field_property, 2},
  [132] =
    {field_decorator, 0, .inherited = true},
    {field_property, 1},
    {field_value, 2, .inherited = true},
  [135] =
    {field_body, 4},
    {field_parameters, 3},
  [137] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [140] =
    {field_index, 3},
    {field_object, 0},
  [142] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [145] =
    {field_name, 2},
  [146] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [148] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [151] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_parameters, 3},
  [155] =
    {field_left, 1},
    {field_right, 3},
  [157] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [160] =
    {field_decorator, 0, .inherited = true},
    {field_property, 2},
    {field_value, 3, .inherited = true},
  [163] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4},
  [166] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_parameters, 4},
  [170] =
    {field_left, 2},
    {field_right, 4},
  [172] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [176] =
    {field_body, 4},
    {field_parameter, 2},
  [178] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_parameters, 5},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [4] = {
    [0] = alias_sym_property_identifier,
  },
  [14] = {
    [0] = alias_sym_statement_identifier,
  },
  [15] = {
    [0] = sym_identifier,
  },
  [16] = {
    [0] = sym_identifier,
  },
  [17] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [18] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [28] = {
    [1] = alias_sym_statement_identifier,
  },
  [41] = {
    [2] = alias_sym_property_identifier,
  },
  [51] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [54] = {
    [1] = alias_sym_import_specifier,
  },
  [68] = {
    [1] = sym_identifier,
  },
  [91] = {
    [1] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__import_export_specifier, 2,
    sym__import_export_specifier,
    alias_sym_import_specifier,
  0,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < '`'
    ? (c < '%'
      ? (c < 0
        ? c == 0
        : c <= '#')
      : (c <= '/' || (c < '['
        ? (c >= ':' && c <= '@')
        : c <= '^')))
    : (c <= '`' || (c < 8203
      ? (c < 160
        ? (c >= '{' && c <= '~')
        : c <= 160)
      : (c <= 8203 || (c < 65279
        ? c == 8288
        : c <= 65279)))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < '`'
    ? (c < '%'
      ? (c < 0
        ? c == 0
        : c <= '#')
      : (c <= '/' || (c < '['
        ? (c >= ':' && c <= '@')
        : c <= '^')))
    : (c <= '~' || (c < 8288
      ? (c < 8203
        ? c == 160
        : c <= 8203)
      : (c <= 8288 || c == 65279))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < '`'
    ? (c < '%'
      ? (c < 0
        ? c == 0
        : c <= '#')
      : (c <= '/' || (c < '['
        ? (c >= ':' && c <= '@')
        : c <= '^')))
    : (c <= '`' || (c < 8203
      ? (c < 160
        ? (c >= '|' && c <= '~')
        : c <= 160)
      : (c <= 8203 || (c < 65279
        ? c == 8288
        : c <= 65279)))));
}

static inline bool sym_private_property_identifier_character_set_1(int32_t c) {
  return (c < '{'
    ? (c < '%'
      ? (c < 0
        ? c == 0
        : c <= '#')
      : (c <= '@' || (c < '`'
        ? (c >= '[' && c <= '^')
        : c <= '`')))
    : (c <= '~' || (c < 8288
      ? (c < 8203
        ? c == 160
        : c <= 8203)
      : (c <= 8288 || c == 65279))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(65);
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(158);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '$') ADVANCE(195);
      if (lookahead == '%') ADVANCE(142);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(73);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(138);
      if (lookahead == ',') ADVANCE(71);
      if (lookahead == '-') ADVANCE(140);
      if (lookahead == '.') ADVANCE(99);
      if (lookahead == '/') ADVANCE(180);
      if (lookahead == '0') ADVANCE(185);
      if (lookahead == ':') ADVANCE(76);
      if (lookahead == ';') ADVANCE(75);
      if (lookahead == '<') ADVANCE(84);
      if (lookahead == '=') ADVANCE(79);
      if (lookahead == '>') ADVANCE(87);
      if (lookahead == '?') ADVANCE(119);
      if (lookahead == '@') ADVANCE(198);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == ']') ADVANCE(82);
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(135);
      if (lookahead == '}') ADVANCE(72);
      if (lookahead == '~') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(62)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(186);
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(196);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(18)
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == '[') ADVANCE(22);
      if (lookahead == '\\') ADVANCE(61);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(181);
      if (lookahead != 0) ADVANCE(182);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(66);
      if (lookahead == '\\') ADVANCE(24);
      if (!sym_private_property_identifier_character_set_1(lookahead)) ADVANCE(197);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(153);
      if (lookahead == '"') ADVANCE(158);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(73);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '.') ADVANCE(100);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == '0') ADVANCE(185);
      if (lookahead == ':') ADVANCE(76);
      if (lookahead == '<') ADVANCE(83);
      if (lookahead == '>') ADVANCE(86);
      if (lookahead == '@') ADVANCE(198);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '~') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(186);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != ']' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(196);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '"') ADVANCE(158);
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == '%') ADVANCE(142);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(73);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(138);
      if (lookahead == ',') ADVANCE(71);
      if (lookahead == '-') ADVANCE(140);
      if (lookahead == '.') ADVANCE(100);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(185);
      if (lookahead == ':') ADVANCE(76);
      if (lookahead == ';') ADVANCE(75);
      if (lookahead == '<') ADVANCE(84);
      if (lookahead == '=') ADVANCE(79);
      if (lookahead == '>') ADVANCE(87);
      if (lookahead == '?') ADVANCE(119);
      if (lookahead == '@') ADVANCE(198);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead == ']') ADVANCE(82);
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(135);
      if (lookahead == '}') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(186);
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '~') ADVANCE(196);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(132);
      if (lookahead == '(') ADVANCE(73);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == ',') ADVANCE(71);
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '.') ADVANCE(98);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == ':') ADVANCE(76);
      if (lookahead == ';') ADVANCE(75);
      if (lookahead == '<') ADVANCE(85);
      if (lookahead == '=') ADVANCE(20);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '?') ADVANCE(120);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead == ']') ADVANCE(82);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(136);
      if (lookahead == '}') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(6)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(183);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(196);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(132);
      if (lookahead == '(') ADVANCE(73);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == ',') ADVANCE(71);
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '.') ADVANCE(98);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == ':') ADVANCE(76);
      if (lookahead == ';') ADVANCE(75);
      if (lookahead == '<') ADVANCE(85);
      if (lookahead == '=') ADVANCE(20);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '?') ADVANCE(120);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead == ']') ADVANCE(82);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(136);
      if (lookahead == '}') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(6)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(196);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(158);
      if (lookahead == '/') ADVANCE(161);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(164);
      if (lookahead != 0) ADVANCE(165);
      END_STATE();
    case 8:
      if (lookahead == '$') ADVANCE(27);
      if (lookahead == '/') ADVANCE(180);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(9)
      END_STATE();
    case 9:
      if (lookahead == '$') ADVANCE(27);
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(9)
      END_STATE();
    case 10:
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '/') ADVANCE(167);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(170);
      if (lookahead != 0) ADVANCE(171);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(177);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(176);
      if (lookahead != 0) ADVANCE(13);
      END_STATE();
    case 13:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead != 0) ADVANCE(13);
      END_STATE();
    case 14:
      if (lookahead == '.') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(192);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(118);
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(98);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == ':') ADVANCE(76);
      if (lookahead == '=') ADVANCE(77);
      if (lookahead == '>') ADVANCE(86);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(16)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      if (lookahead != 0 &&
          lookahead > '~') ADVANCE(196);
      END_STATE();
    case 17:
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '<') ADVANCE(83);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(95);
      if (lookahead != 0 &&
          lookahead != '>' &&
          lookahead != '}') ADVANCE(96);
      END_STATE();
    case 18:
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(18)
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(148);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(146);
      END_STATE();
    case 21:
      if (lookahead == '\\') ADVANCE(24);
      if (!sym_private_property_identifier_character_set_1(lookahead)) ADVANCE(197);
      END_STATE();
    case 22:
      if (lookahead == '\\') ADVANCE(60);
      if (lookahead == ']') ADVANCE(182);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(22);
      END_STATE();
    case 23:
      if (lookahead == 'u') ADVANCE(28);
      if (lookahead == 'x') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(175);
      if (lookahead != 0) ADVANCE(172);
      END_STATE();
    case 24:
      if (lookahead == 'u') ADVANCE(29);
      END_STATE();
    case 25:
      if (lookahead == 'u') ADVANCE(30);
      END_STATE();
    case 26:
      if (lookahead == 'u') ADVANCE(31);
      if (lookahead == 'x') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(175);
      if (lookahead != 0) ADVANCE(172);
      END_STATE();
    case 27:
      if (lookahead == '{') ADVANCE(179);
      END_STATE();
    case 28:
      if (lookahead == '{') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      END_STATE();
    case 29:
      if (lookahead == '{') ADVANCE(50);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      END_STATE();
    case 30:
      if (lookahead == '{') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(59);
      END_STATE();
    case 31:
      if (lookahead == '{') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 32:
      if (lookahead == '}') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(32);
      END_STATE();
    case 33:
      if (lookahead == '}') ADVANCE(197);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(33);
      END_STATE();
    case 34:
      if (lookahead == '}') ADVANCE(172);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      END_STATE();
    case 35:
      if (lookahead == '}') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 36:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 37:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(187);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(188);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(186);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(192);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(190);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(196);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(197);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(189);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(173);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(33);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(32);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 58:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 60:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(22);
      END_STATE();
    case 61:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(182);
      END_STATE();
    case 62:
      if (eof) ADVANCE(65);
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(158);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '$') ADVANCE(195);
      if (lookahead == '%') ADVANCE(142);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(73);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(138);
      if (lookahead == ',') ADVANCE(71);
      if (lookahead == '-') ADVANCE(140);
      if (lookahead == '.') ADVANCE(99);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == '0') ADVANCE(185);
      if (lookahead == ':') ADVANCE(76);
      if (lookahead == ';') ADVANCE(75);
      if (lookahead == '<') ADVANCE(84);
      if (lookahead == '=') ADVANCE(79);
      if (lookahead == '>') ADVANCE(87);
      if (lookahead == '?') ADVANCE(119);
      if (lookahead == '@') ADVANCE(198);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead == ']') ADVANCE(82);
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(135);
      if (lookahead == '}') ADVANCE(72);
      if (lookahead == '~') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(62)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(186);
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(196);
      END_STATE();
    case 63:
      if (eof) ADVANCE(65);
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(158);
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(132);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(73);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == ',') ADVANCE(71);
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '.') ADVANCE(100);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == '0') ADVANCE(185);
      if (lookahead == ':') ADVANCE(76);
      if (lookahead == ';') ADVANCE(75);
      if (lookahead == '<') ADVANCE(85);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '?') ADVANCE(120);
      if (lookahead == '@') ADVANCE(198);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead == ']') ADVANCE(82);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(136);
      if (lookahead == '}') ADVANCE(72);
      if (lookahead == '~') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(63)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(186);
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(196);
      END_STATE();
    case 64:
      if (eof) ADVANCE(65);
      if (lookahead == '!') ADVANCE(153);
      if (lookahead == '"') ADVANCE(158);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(73);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == ',') ADVANCE(71);
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '.') ADVANCE(14);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == '0') ADVANCE(185);
      if (lookahead == ':') ADVANCE(76);
      if (lookahead == ';') ADVANCE(75);
      if (lookahead == '<') ADVANCE(83);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(86);
      if (lookahead == '@') ADVANCE(198);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead == ']') ADVANCE(82);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '}') ADVANCE(72);
      if (lookahead == '~') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(64)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(186);
      if (lookahead != 0 &&
          lookahead > 31 &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != '^' &&
          lookahead != '|') ADVANCE(196);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(144);
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(143);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(146);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(146);
      if (lookahead == '>') ADVANCE(101);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(101);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(130);
      if (lookahead == '=') ADVANCE(145);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(129);
      if (lookahead == '=') ADVANCE(145);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(150);
      if (lookahead == '>') ADVANCE(125);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(150);
      if (lookahead == '>') ADVANCE(126);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(177);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(177);
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '\n') ADVANCE(96);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(177);
      if (lookahead != 0) ADVANCE(91);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(94);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(96);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(93);
      if (lookahead == '/') ADVANCE(96);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(13);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(93);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(13);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(95);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(96);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(96);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_jsx_identifier);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(97);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(192);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(192);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(102);
      if (lookahead == '?') ADVANCE(152);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(102);
      if (lookahead == '?') ADVANCE(151);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '>') ADVANCE(128);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(127);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(112);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(113);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(122);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(121);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(108);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(110);
      if (lookahead == '|') ADVANCE(124);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(123);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(156);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(156);
      if (lookahead == '=') ADVANCE(103);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(157);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(157);
      if (lookahead == '=') ADVANCE(104);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(107);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(147);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(149);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(148);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '\n') ADVANCE(165);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(160);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(163);
      if (lookahead == '/') ADVANCE(160);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(165);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(162);
      if (lookahead == '/') ADVANCE(165);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(163);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(162);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(163);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(161);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(164);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(165);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(165);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '\n') ADVANCE(171);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(166);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(169);
      if (lookahead == '/') ADVANCE(166);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(171);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(168);
      if (lookahead == '/') ADVANCE(171);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(169);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(168);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(169);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '/') ADVANCE(167);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(170);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(171);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(171);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(25);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(196);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(172);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(174);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(177);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(177);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(18)
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == '[') ADVANCE(22);
      if (lookahead == '\\') ADVANCE(61);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(181);
      if (lookahead != 0) ADVANCE(182);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(22);
      if (lookahead == '\\') ADVANCE(61);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(182);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(25);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(183);
      if (!sym_identifier_character_set_2(lookahead)) ADVANCE(196);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(193);
      if (lookahead == '0') ADVANCE(190);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(37);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(36);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(38);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(46);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(186);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(193);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(36);
      if (lookahead == '_') ADVANCE(39);
      if (lookahead == 'n') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(186);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(184);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(187);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(38);
      if (lookahead == 'n') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(188);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(46);
      if (lookahead == 'n') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(189);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(190);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(36);
      if (lookahead == '_') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(192);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(36);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(192);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(97);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      if (lookahead != 0 &&
          lookahead > '~' &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(196);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead == '{') ADVANCE(179);
      if (!sym_identifier_character_set_3(lookahead)) ADVANCE(196);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(25);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(196);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_private_property_identifier);
      if (lookahead == '\\') ADVANCE(24);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(197);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      if (lookahead == 'v') ADVANCE(16);
      if (lookahead == 'w') ADVANCE(17);
      if (lookahead == 'y') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(21);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'l') ADVANCE(23);
      if (lookahead == 'o') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(25);
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'x') ADVANCE(28);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'i') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      if (lookahead == 'u') ADVANCE(33);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(34);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(35);
      if (lookahead == 'm') ADVANCE(36);
      if (lookahead == 'n') ADVANCE(37);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 11:
      if (lookahead == 'f') ADVANCE(41);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 't') ADVANCE(44);
      if (lookahead == 'u') ADVANCE(45);
      if (lookahead == 'w') ADVANCE(46);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(47);
      if (lookahead == 'h') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      if (lookahead == 'y') ADVANCE(50);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(51);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 17:
      if (lookahead == 'h') ADVANCE(54);
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(56);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'y') ADVANCE(57);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(60);
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(62);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(63);
      END_STATE();
    case 25:
      if (lookahead == 'b') ADVANCE(64);
      if (lookahead == 'f') ADVANCE(65);
      if (lookahead == 'l') ADVANCE(66);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(67);
      END_STATE();
    case 28:
      if (lookahead == 'p') ADVANCE(68);
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(72);
      END_STATE();
    case 32:
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(76);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 38:
      if (lookahead == 't') ADVANCE(78);
      END_STATE();
    case 39:
      if (lookahead == 'w') ADVANCE(79);
      END_STATE();
    case 40:
      if (lookahead == 'l') ADVANCE(80);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(83);
      END_STATE();
    case 45:
      if (lookahead == 'p') ADVANCE(84);
      END_STATE();
    case 46:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 47:
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(87);
      if (lookahead == 'r') ADVANCE(88);
      END_STATE();
    case 49:
      if (lookahead == 'u') ADVANCE(89);
      if (lookahead == 'y') ADVANCE(90);
      END_STATE();
    case 50:
      if (lookahead == 'p') ADVANCE(91);
      END_STATE();
    case 51:
      if (lookahead == 'd') ADVANCE(92);
      END_STATE();
    case 52:
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(95);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 57:
      if (lookahead == 'n') ADVANCE(98);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(99);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(100);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(101);
      END_STATE();
    case 61:
      if (lookahead == 'c') ADVANCE(102);
      END_STATE();
    case 62:
      if (lookahead == 's') ADVANCE(103);
      END_STATE();
    case 63:
      if (lookahead == 's') ADVANCE(104);
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 64:
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(107);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 68:
      if (lookahead == 'o') ADVANCE(110);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 70:
      if (lookahead == 's') ADVANCE(112);
      END_STATE();
    case 71:
      if (lookahead == 'a') ADVANCE(113);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 73:
      if (lookahead == 'm') ADVANCE(114);
      END_STATE();
    case 74:
      if (lookahead == 'c') ADVANCE(115);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 76:
      if (lookahead == 'o') ADVANCE(116);
      END_STATE();
    case 77:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 81:
      if (lookahead == 'u') ADVANCE(119);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 85:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 86:
      if (lookahead == 'g') ADVANCE(123);
      END_STATE();
    case 87:
      if (lookahead == 's') ADVANCE(124);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(125);
      END_STATE();
    case 89:
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 91:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 94:
      if (lookahead == 'd') ADVANCE(129);
      END_STATE();
    case 95:
      if (lookahead == 'l') ADVANCE(130);
      END_STATE();
    case 96:
      if (lookahead == 'h') ADVANCE(131);
      END_STATE();
    case 97:
      if (lookahead == 'l') ADVANCE(132);
      END_STATE();
    case 98:
      if (lookahead == 'c') ADVANCE(133);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 100:
      if (lookahead == 'k') ADVANCE(135);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 102:
      if (lookahead == 'h') ADVANCE(136);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(137);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 105:
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 106:
      if (lookahead == 'g') ADVANCE(140);
      END_STATE();
    case 107:
      if (lookahead == 'u') ADVANCE(141);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 110:
      if (lookahead == 'r') ADVANCE(143);
      END_STATE();
    case 111:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 113:
      if (lookahead == 'l') ADVANCE(146);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(149);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(151);
      END_STATE();
    case 121:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 122:
      if (lookahead == 'c') ADVANCE(153);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(154);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 125:
      if (lookahead == 'w') ADVANCE(155);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 127:
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 128:
      if (lookahead == 'f') ADVANCE(157);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 132:
      if (lookahead == 'd') ADVANCE(159);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 139:
      if (lookahead == 'n') ADVANCE(160);
      END_STATE();
    case 140:
      if (lookahead == 'g') ADVANCE(161);
      END_STATE();
    case 141:
      if (lookahead == 'l') ADVANCE(162);
      END_STATE();
    case 142:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 143:
      if (lookahead == 't') ADVANCE(164);
      END_STATE();
    case 144:
      if (lookahead == 'd') ADVANCE(165);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 146:
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 149:
      if (lookahead == 'n') ADVANCE(169);
      END_STATE();
    case 150:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 151:
      if (lookahead == 'c') ADVANCE(171);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 153:
      if (lookahead == 'h') ADVANCE(172);
      END_STATE();
    case 154:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 156:
      if (lookahead == 'f') ADVANCE(174);
      END_STATE();
    case 157:
      if (lookahead == 'i') ADVANCE(175);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 160:
      if (lookahead == 'u') ADVANCE(176);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 162:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 165:
      if (lookahead == 's') ADVANCE(179);
      END_STATE();
    case 166:
      if (lookahead == 'y') ADVANCE(180);
      END_STATE();
    case 167:
      if (lookahead == 'o') ADVANCE(181);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 169:
      if (lookahead == 'c') ADVANCE(182);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 175:
      if (lookahead == 'n') ADVANCE(183);
      END_STATE();
    case 176:
      if (lookahead == 'e') ADVANCE(184);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 181:
      if (lookahead == 'n') ADVANCE(186);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 187:
      if (lookahead == 'o') ADVANCE(189);
      END_STATE();
    case 188:
      if (lookahead == 'd') ADVANCE(190);
      END_STATE();
    case 189:
      if (lookahead == 'f') ADVANCE(191);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 64},
  [2] = {.lex_state = 64},
  [3] = {.lex_state = 64},
  [4] = {.lex_state = 64},
  [5] = {.lex_state = 64},
  [6] = {.lex_state = 64},
  [7] = {.lex_state = 64},
  [8] = {.lex_state = 64},
  [9] = {.lex_state = 64},
  [10] = {.lex_state = 64},
  [11] = {.lex_state = 64},
  [12] = {.lex_state = 64},
  [13] = {.lex_state = 64},
  [14] = {.lex_state = 64},
  [15] = {.lex_state = 64},
  [16] = {.lex_state = 64},
  [17] = {.lex_state = 64},
  [18] = {.lex_state = 64},
  [19] = {.lex_state = 64},
  [20] = {.lex_state = 64},
  [21] = {.lex_state = 64},
  [22] = {.lex_state = 64},
  [23] = {.lex_state = 64},
  [24] = {.lex_state = 64},
  [25] = {.lex_state = 64},
  [26] = {.lex_state = 64},
  [27] = {.lex_state = 64},
  [28] = {.lex_state = 64},
  [29] = {.lex_state = 64},
  [30] = {.lex_state = 64},
  [31] = {.lex_state = 64},
  [32] = {.lex_state = 64},
  [33] = {.lex_state = 64},
  [34] = {.lex_state = 64},
  [35] = {.lex_state = 64},
  [36] = {.lex_state = 64},
  [37] = {.lex_state = 64},
  [38] = {.lex_state = 64},
  [39] = {.lex_state = 64},
  [40] = {.lex_state = 64},
  [41] = {.lex_state = 64},
  [42] = {.lex_state = 64},
  [43] = {.lex_state = 64},
  [44] = {.lex_state = 63},
  [45] = {.lex_state = 63, .external_lex_state = 2},
  [46] = {.lex_state = 63},
  [47] = {.lex_state = 63, .external_lex_state = 2},
  [48] = {.lex_state = 63, .external_lex_state = 2},
  [49] = {.lex_state = 63, .external_lex_state = 2},
  [50] = {.lex_state = 63, .external_lex_state = 2},
  [51] = {.lex_state = 63, .external_lex_state = 2},
  [52] = {.lex_state = 63, .external_lex_state = 2},
  [53] = {.lex_state = 63, .external_lex_state = 2},
  [54] = {.lex_state = 63, .external_lex_state = 2},
  [55] = {.lex_state = 63, .external_lex_state = 2},
  [56] = {.lex_state = 63, .external_lex_state = 2},
  [57] = {.lex_state = 63, .external_lex_state = 2},
  [58] = {.lex_state = 63, .external_lex_state = 2},
  [59] = {.lex_state = 63, .external_lex_state = 2},
  [60] = {.lex_state = 63, .external_lex_state = 2},
  [61] = {.lex_state = 63, .external_lex_state = 2},
  [62] = {.lex_state = 64},
  [63] = {.lex_state = 64},
  [64] = {.lex_state = 64},
  [65] = {.lex_state = 64},
  [66] = {.lex_state = 64},
  [67] = {.lex_state = 64},
  [68] = {.lex_state = 64},
  [69] = {.lex_state = 64},
  [70] = {.lex_state = 64},
  [71] = {.lex_state = 64},
  [72] = {.lex_state = 64},
  [73] = {.lex_state = 64},
  [74] = {.lex_state = 64},
  [75] = {.lex_state = 64},
  [76] = {.lex_state = 64},
  [77] = {.lex_state = 64},
  [78] = {.lex_state = 64},
  [79] = {.lex_state = 64},
  [80] = {.lex_state = 64},
  [81] = {.lex_state = 64},
  [82] = {.lex_state = 64},
  [83] = {.lex_state = 64},
  [84] = {.lex_state = 64},
  [85] = {.lex_state = 64},
  [86] = {.lex_state = 64},
  [87] = {.lex_state = 64, .external_lex_state = 2},
  [88] = {.lex_state = 64},
  [89] = {.lex_state = 4, .external_lex_state = 2},
  [90] = {.lex_state = 64},
  [91] = {.lex_state = 4, .external_lex_state = 2},
  [92] = {.lex_state = 64},
  [93] = {.lex_state = 4, .external_lex_state = 2},
  [94] = {.lex_state = 64},
  [95] = {.lex_state = 64},
  [96] = {.lex_state = 64},
  [97] = {.lex_state = 64},
  [98] = {.lex_state = 64},
  [99] = {.lex_state = 64},
  [100] = {.lex_state = 64},
  [101] = {.lex_state = 64},
  [102] = {.lex_state = 64},
  [103] = {.lex_state = 64},
  [104] = {.lex_state = 3},
  [105] = {.lex_state = 64},
  [106] = {.lex_state = 64},
  [107] = {.lex_state = 64},
  [108] = {.lex_state = 64},
  [109] = {.lex_state = 64},
  [110] = {.lex_state = 64},
  [111] = {.lex_state = 64},
  [112] = {.lex_state = 64},
  [113] = {.lex_state = 64},
  [114] = {.lex_state = 64},
  [115] = {.lex_state = 64},
  [116] = {.lex_state = 64},
  [117] = {.lex_state = 64},
  [118] = {.lex_state = 3},
  [119] = {.lex_state = 64},
  [120] = {.lex_state = 3},
  [121] = {.lex_state = 64},
  [122] = {.lex_state = 64},
  [123] = {.lex_state = 64},
  [124] = {.lex_state = 3},
  [125] = {.lex_state = 64},
  [126] = {.lex_state = 64},
  [127] = {.lex_state = 64},
  [128] = {.lex_state = 64},
  [129] = {.lex_state = 64},
  [130] = {.lex_state = 64},
  [131] = {.lex_state = 64},
  [132] = {.lex_state = 64},
  [133] = {.lex_state = 64},
  [134] = {.lex_state = 64},
  [135] = {.lex_state = 64},
  [136] = {.lex_state = 64},
  [137] = {.lex_state = 64},
  [138] = {.lex_state = 64},
  [139] = {.lex_state = 64},
  [140] = {.lex_state = 64},
  [141] = {.lex_state = 64},
  [142] = {.lex_state = 64},
  [143] = {.lex_state = 64},
  [144] = {.lex_state = 64},
  [145] = {.lex_state = 64},
  [146] = {.lex_state = 64},
  [147] = {.lex_state = 64},
  [148] = {.lex_state = 64},
  [149] = {.lex_state = 64},
  [150] = {.lex_state = 64},
  [151] = {.lex_state = 64},
  [152] = {.lex_state = 64},
  [153] = {.lex_state = 64},
  [154] = {.lex_state = 64},
  [155] = {.lex_state = 64},
  [156] = {.lex_state = 64},
  [157] = {.lex_state = 64},
  [158] = {.lex_state = 64},
  [159] = {.lex_state = 64},
  [160] = {.lex_state = 64},
  [161] = {.lex_state = 64},
  [162] = {.lex_state = 64},
  [163] = {.lex_state = 64},
  [164] = {.lex_state = 64},
  [165] = {.lex_state = 64},
  [166] = {.lex_state = 64},
  [167] = {.lex_state = 64},
  [168] = {.lex_state = 64},
  [169] = {.lex_state = 64},
  [170] = {.lex_state = 64},
  [171] = {.lex_state = 64},
  [172] = {.lex_state = 64},
  [173] = {.lex_state = 64},
  [174] = {.lex_state = 64},
  [175] = {.lex_state = 64},
  [176] = {.lex_state = 64},
  [177] = {.lex_state = 64},
  [178] = {.lex_state = 64},
  [179] = {.lex_state = 64},
  [180] = {.lex_state = 64},
  [181] = {.lex_state = 64},
  [182] = {.lex_state = 64},
  [183] = {.lex_state = 64},
  [184] = {.lex_state = 64},
  [185] = {.lex_state = 64},
  [186] = {.lex_state = 64},
  [187] = {.lex_state = 64},
  [188] = {.lex_state = 64},
  [189] = {.lex_state = 64},
  [190] = {.lex_state = 64},
  [191] = {.lex_state = 64},
  [192] = {.lex_state = 64},
  [193] = {.lex_state = 64},
  [194] = {.lex_state = 64},
  [195] = {.lex_state = 64},
  [196] = {.lex_state = 64},
  [197] = {.lex_state = 64},
  [198] = {.lex_state = 4, .external_lex_state = 2},
  [199] = {.lex_state = 4, .external_lex_state = 2},
  [200] = {.lex_state = 4, .external_lex_state = 2},
  [201] = {.lex_state = 4, .external_lex_state = 2},
  [202] = {.lex_state = 4, .external_lex_state = 2},
  [203] = {.lex_state = 4, .external_lex_state = 2},
  [204] = {.lex_state = 4, .external_lex_state = 2},
  [205] = {.lex_state = 4, .external_lex_state = 2},
  [206] = {.lex_state = 4, .external_lex_state = 2},
  [207] = {.lex_state = 4, .external_lex_state = 2},
  [208] = {.lex_state = 4, .external_lex_state = 2},
  [209] = {.lex_state = 64, .external_lex_state = 2},
  [210] = {.lex_state = 64, .external_lex_state = 2},
  [211] = {.lex_state = 4},
  [212] = {.lex_state = 64},
  [213] = {.lex_state = 4},
  [214] = {.lex_state = 64},
  [215] = {.lex_state = 4, .external_lex_state = 2},
  [216] = {.lex_state = 64},
  [217] = {.lex_state = 4, .external_lex_state = 2},
  [218] = {.lex_state = 4, .external_lex_state = 2},
  [219] = {.lex_state = 4},
  [220] = {.lex_state = 4, .external_lex_state = 2},
  [221] = {.lex_state = 4, .external_lex_state = 2},
  [222] = {.lex_state = 4},
  [223] = {.lex_state = 4, .external_lex_state = 2},
  [224] = {.lex_state = 4, .external_lex_state = 2},
  [225] = {.lex_state = 64},
  [226] = {.lex_state = 4},
  [227] = {.lex_state = 64, .external_lex_state = 2},
  [228] = {.lex_state = 64},
  [229] = {.lex_state = 4},
  [230] = {.lex_state = 64},
  [231] = {.lex_state = 64, .external_lex_state = 2},
  [232] = {.lex_state = 64, .external_lex_state = 2},
  [233] = {.lex_state = 64},
  [234] = {.lex_state = 64},
  [235] = {.lex_state = 64, .external_lex_state = 2},
  [236] = {.lex_state = 64, .external_lex_state = 2},
  [237] = {.lex_state = 64, .external_lex_state = 2},
  [238] = {.lex_state = 64, .external_lex_state = 2},
  [239] = {.lex_state = 64},
  [240] = {.lex_state = 64, .external_lex_state = 2},
  [241] = {.lex_state = 64, .external_lex_state = 2},
  [242] = {.lex_state = 64, .external_lex_state = 2},
  [243] = {.lex_state = 64, .external_lex_state = 2},
  [244] = {.lex_state = 64, .external_lex_state = 2},
  [245] = {.lex_state = 64, .external_lex_state = 2},
  [246] = {.lex_state = 64, .external_lex_state = 2},
  [247] = {.lex_state = 64},
  [248] = {.lex_state = 64},
  [249] = {.lex_state = 64},
  [250] = {.lex_state = 64},
  [251] = {.lex_state = 64},
  [252] = {.lex_state = 64},
  [253] = {.lex_state = 64},
  [254] = {.lex_state = 64},
  [255] = {.lex_state = 64},
  [256] = {.lex_state = 64},
  [257] = {.lex_state = 64},
  [258] = {.lex_state = 64},
  [259] = {.lex_state = 64},
  [260] = {.lex_state = 64},
  [261] = {.lex_state = 64},
  [262] = {.lex_state = 64},
  [263] = {.lex_state = 64},
  [264] = {.lex_state = 64},
  [265] = {.lex_state = 64},
  [266] = {.lex_state = 64},
  [267] = {.lex_state = 64},
  [268] = {.lex_state = 64},
  [269] = {.lex_state = 64},
  [270] = {.lex_state = 64},
  [271] = {.lex_state = 64},
  [272] = {.lex_state = 64},
  [273] = {.lex_state = 64},
  [274] = {.lex_state = 64},
  [275] = {.lex_state = 64},
  [276] = {.lex_state = 64},
  [277] = {.lex_state = 64},
  [278] = {.lex_state = 64},
  [279] = {.lex_state = 64},
  [280] = {.lex_state = 64},
  [281] = {.lex_state = 64},
  [282] = {.lex_state = 64},
  [283] = {.lex_state = 64},
  [284] = {.lex_state = 64},
  [285] = {.lex_state = 64},
  [286] = {.lex_state = 64},
  [287] = {.lex_state = 64},
  [288] = {.lex_state = 64},
  [289] = {.lex_state = 64},
  [290] = {.lex_state = 64},
  [291] = {.lex_state = 64},
  [292] = {.lex_state = 64},
  [293] = {.lex_state = 64},
  [294] = {.lex_state = 64},
  [295] = {.lex_state = 64},
  [296] = {.lex_state = 64},
  [297] = {.lex_state = 64},
  [298] = {.lex_state = 64},
  [299] = {.lex_state = 64},
  [300] = {.lex_state = 64},
  [301] = {.lex_state = 64},
  [302] = {.lex_state = 64},
  [303] = {.lex_state = 64},
  [304] = {.lex_state = 64},
  [305] = {.lex_state = 64},
  [306] = {.lex_state = 64},
  [307] = {.lex_state = 64},
  [308] = {.lex_state = 64},
  [309] = {.lex_state = 64},
  [310] = {.lex_state = 64},
  [311] = {.lex_state = 64},
  [312] = {.lex_state = 64},
  [313] = {.lex_state = 64},
  [314] = {.lex_state = 64},
  [315] = {.lex_state = 64},
  [316] = {.lex_state = 64},
  [317] = {.lex_state = 64},
  [318] = {.lex_state = 64},
  [319] = {.lex_state = 64},
  [320] = {.lex_state = 64},
  [321] = {.lex_state = 64},
  [322] = {.lex_state = 64},
  [323] = {.lex_state = 64},
  [324] = {.lex_state = 64},
  [325] = {.lex_state = 64},
  [326] = {.lex_state = 64},
  [327] = {.lex_state = 64},
  [328] = {.lex_state = 64},
  [329] = {.lex_state = 64},
  [330] = {.lex_state = 64},
  [331] = {.lex_state = 64},
  [332] = {.lex_state = 64},
  [333] = {.lex_state = 64},
  [334] = {.lex_state = 64},
  [335] = {.lex_state = 64},
  [336] = {.lex_state = 64},
  [337] = {.lex_state = 64},
  [338] = {.lex_state = 64},
  [339] = {.lex_state = 4, .external_lex_state = 2},
  [340] = {.lex_state = 4, .external_lex_state = 2},
  [341] = {.lex_state = 4, .external_lex_state = 2},
  [342] = {.lex_state = 4},
  [343] = {.lex_state = 4},
  [344] = {.lex_state = 4},
  [345] = {.lex_state = 4},
  [346] = {.lex_state = 4},
  [347] = {.lex_state = 4},
  [348] = {.lex_state = 4},
  [349] = {.lex_state = 4},
  [350] = {.lex_state = 4},
  [351] = {.lex_state = 4},
  [352] = {.lex_state = 4, .external_lex_state = 2},
  [353] = {.lex_state = 4, .external_lex_state = 2},
  [354] = {.lex_state = 4, .external_lex_state = 2},
  [355] = {.lex_state = 4, .external_lex_state = 2},
  [356] = {.lex_state = 4, .external_lex_state = 2},
  [357] = {.lex_state = 4, .external_lex_state = 2},
  [358] = {.lex_state = 4, .external_lex_state = 2},
  [359] = {.lex_state = 4, .external_lex_state = 2},
  [360] = {.lex_state = 4, .external_lex_state = 2},
  [361] = {.lex_state = 4},
  [362] = {.lex_state = 4, .external_lex_state = 2},
  [363] = {.lex_state = 4},
  [364] = {.lex_state = 4},
  [365] = {.lex_state = 4, .external_lex_state = 2},
  [366] = {.lex_state = 4, .external_lex_state = 2},
  [367] = {.lex_state = 4, .external_lex_state = 2},
  [368] = {.lex_state = 4, .external_lex_state = 2},
  [369] = {.lex_state = 4, .external_lex_state = 2},
  [370] = {.lex_state = 64},
  [371] = {.lex_state = 64},
  [372] = {.lex_state = 4, .external_lex_state = 2},
  [373] = {.lex_state = 4, .external_lex_state = 2},
  [374] = {.lex_state = 64},
  [375] = {.lex_state = 64},
  [376] = {.lex_state = 4, .external_lex_state = 2},
  [377] = {.lex_state = 4},
  [378] = {.lex_state = 4},
  [379] = {.lex_state = 4},
  [380] = {.lex_state = 4},
  [381] = {.lex_state = 4},
  [382] = {.lex_state = 4},
  [383] = {.lex_state = 63},
  [384] = {.lex_state = 63},
  [385] = {.lex_state = 63},
  [386] = {.lex_state = 4},
  [387] = {.lex_state = 4},
  [388] = {.lex_state = 4},
  [389] = {.lex_state = 63, .external_lex_state = 2},
  [390] = {.lex_state = 63},
  [391] = {.lex_state = 63, .external_lex_state = 2},
  [392] = {.lex_state = 63},
  [393] = {.lex_state = 63},
  [394] = {.lex_state = 63},
  [395] = {.lex_state = 63},
  [396] = {.lex_state = 63},
  [397] = {.lex_state = 63},
  [398] = {.lex_state = 63},
  [399] = {.lex_state = 63},
  [400] = {.lex_state = 63},
  [401] = {.lex_state = 63},
  [402] = {.lex_state = 63},
  [403] = {.lex_state = 63},
  [404] = {.lex_state = 63},
  [405] = {.lex_state = 63},
  [406] = {.lex_state = 63},
  [407] = {.lex_state = 63},
  [408] = {.lex_state = 63, .external_lex_state = 2},
  [409] = {.lex_state = 63},
  [410] = {.lex_state = 63},
  [411] = {.lex_state = 63},
  [412] = {.lex_state = 63},
  [413] = {.lex_state = 63},
  [414] = {.lex_state = 63},
  [415] = {.lex_state = 63},
  [416] = {.lex_state = 63},
  [417] = {.lex_state = 63},
  [418] = {.lex_state = 63, .external_lex_state = 2},
  [419] = {.lex_state = 63},
  [420] = {.lex_state = 63},
  [421] = {.lex_state = 63},
  [422] = {.lex_state = 63},
  [423] = {.lex_state = 5},
  [424] = {.lex_state = 63, .external_lex_state = 2},
  [425] = {.lex_state = 63},
  [426] = {.lex_state = 63},
  [427] = {.lex_state = 63},
  [428] = {.lex_state = 63},
  [429] = {.lex_state = 63},
  [430] = {.lex_state = 63},
  [431] = {.lex_state = 63, .external_lex_state = 2},
  [432] = {.lex_state = 63, .external_lex_state = 2},
  [433] = {.lex_state = 63},
  [434] = {.lex_state = 63, .external_lex_state = 2},
  [435] = {.lex_state = 63},
  [436] = {.lex_state = 63, .external_lex_state = 2},
  [437] = {.lex_state = 63},
  [438] = {.lex_state = 63},
  [439] = {.lex_state = 63},
  [440] = {.lex_state = 63},
  [441] = {.lex_state = 63, .external_lex_state = 2},
  [442] = {.lex_state = 63},
  [443] = {.lex_state = 63},
  [444] = {.lex_state = 63, .external_lex_state = 2},
  [445] = {.lex_state = 63},
  [446] = {.lex_state = 63},
  [447] = {.lex_state = 63, .external_lex_state = 2},
  [448] = {.lex_state = 63, .external_lex_state = 2},
  [449] = {.lex_state = 63, .external_lex_state = 2},
  [450] = {.lex_state = 63, .external_lex_state = 2},
  [451] = {.lex_state = 63, .external_lex_state = 2},
  [452] = {.lex_state = 63},
  [453] = {.lex_state = 63},
  [454] = {.lex_state = 63},
  [455] = {.lex_state = 63, .external_lex_state = 2},
  [456] = {.lex_state = 63},
  [457] = {.lex_state = 63},
  [458] = {.lex_state = 63, .external_lex_state = 2},
  [459] = {.lex_state = 63},
  [460] = {.lex_state = 63, .external_lex_state = 2},
  [461] = {.lex_state = 63},
  [462] = {.lex_state = 63},
  [463] = {.lex_state = 63},
  [464] = {.lex_state = 63},
  [465] = {.lex_state = 63, .external_lex_state = 2},
  [466] = {.lex_state = 63},
  [467] = {.lex_state = 63},
  [468] = {.lex_state = 63},
  [469] = {.lex_state = 63},
  [470] = {.lex_state = 63},
  [471] = {.lex_state = 63},
  [472] = {.lex_state = 63, .external_lex_state = 2},
  [473] = {.lex_state = 63},
  [474] = {.lex_state = 63},
  [475] = {.lex_state = 63, .external_lex_state = 2},
  [476] = {.lex_state = 63},
  [477] = {.lex_state = 63},
  [478] = {.lex_state = 63},
  [479] = {.lex_state = 63},
  [480] = {.lex_state = 63},
  [481] = {.lex_state = 63},
  [482] = {.lex_state = 63},
  [483] = {.lex_state = 63},
  [484] = {.lex_state = 63},
  [485] = {.lex_state = 63, .external_lex_state = 2},
  [486] = {.lex_state = 63, .external_lex_state = 2},
  [487] = {.lex_state = 63},
  [488] = {.lex_state = 63},
  [489] = {.lex_state = 63, .external_lex_state = 2},
  [490] = {.lex_state = 63, .external_lex_state = 2},
  [491] = {.lex_state = 63},
  [492] = {.lex_state = 63},
  [493] = {.lex_state = 63},
  [494] = {.lex_state = 63, .external_lex_state = 2},
  [495] = {.lex_state = 63, .external_lex_state = 2},
  [496] = {.lex_state = 63, .external_lex_state = 2},
  [497] = {.lex_state = 63},
  [498] = {.lex_state = 63},
  [499] = {.lex_state = 63, .external_lex_state = 2},
  [500] = {.lex_state = 63},
  [501] = {.lex_state = 63},
  [502] = {.lex_state = 63},
  [503] = {.lex_state = 63, .external_lex_state = 2},
  [504] = {.lex_state = 63},
  [505] = {.lex_state = 63, .external_lex_state = 2},
  [506] = {.lex_state = 63, .external_lex_state = 2},
  [507] = {.lex_state = 63},
  [508] = {.lex_state = 63, .external_lex_state = 2},
  [509] = {.lex_state = 63},
  [510] = {.lex_state = 63},
  [511] = {.lex_state = 63},
  [512] = {.lex_state = 63},
  [513] = {.lex_state = 63},
  [514] = {.lex_state = 63},
  [515] = {.lex_state = 63, .external_lex_state = 2},
  [516] = {.lex_state = 63},
  [517] = {.lex_state = 63, .external_lex_state = 2},
  [518] = {.lex_state = 63, .external_lex_state = 2},
  [519] = {.lex_state = 63, .external_lex_state = 2},
  [520] = {.lex_state = 63, .external_lex_state = 2},
  [521] = {.lex_state = 63, .external_lex_state = 2},
  [522] = {.lex_state = 63, .external_lex_state = 2},
  [523] = {.lex_state = 63, .external_lex_state = 2},
  [524] = {.lex_state = 63},
  [525] = {.lex_state = 63, .external_lex_state = 2},
  [526] = {.lex_state = 63, .external_lex_state = 2},
  [527] = {.lex_state = 63, .external_lex_state = 2},
  [528] = {.lex_state = 63, .external_lex_state = 2},
  [529] = {.lex_state = 63, .external_lex_state = 2},
  [530] = {.lex_state = 5, .external_lex_state = 2},
  [531] = {.lex_state = 63, .external_lex_state = 2},
  [532] = {.lex_state = 63, .external_lex_state = 2},
  [533] = {.lex_state = 63, .external_lex_state = 2},
  [534] = {.lex_state = 63, .external_lex_state = 2},
  [535] = {.lex_state = 63, .external_lex_state = 2},
  [536] = {.lex_state = 63},
  [537] = {.lex_state = 63},
  [538] = {.lex_state = 63},
  [539] = {.lex_state = 63, .external_lex_state = 2},
  [540] = {.lex_state = 63},
  [541] = {.lex_state = 63, .external_lex_state = 2},
  [542] = {.lex_state = 63, .external_lex_state = 2},
  [543] = {.lex_state = 63, .external_lex_state = 2},
  [544] = {.lex_state = 63, .external_lex_state = 2},
  [545] = {.lex_state = 63, .external_lex_state = 2},
  [546] = {.lex_state = 63},
  [547] = {.lex_state = 63, .external_lex_state = 2},
  [548] = {.lex_state = 63},
  [549] = {.lex_state = 63, .external_lex_state = 2},
  [550] = {.lex_state = 63, .external_lex_state = 2},
  [551] = {.lex_state = 63, .external_lex_state = 2},
  [552] = {.lex_state = 63},
  [553] = {.lex_state = 63, .external_lex_state = 2},
  [554] = {.lex_state = 63, .external_lex_state = 2},
  [555] = {.lex_state = 63, .external_lex_state = 2},
  [556] = {.lex_state = 63},
  [557] = {.lex_state = 63, .external_lex_state = 2},
  [558] = {.lex_state = 63, .external_lex_state = 2},
  [559] = {.lex_state = 63, .external_lex_state = 2},
  [560] = {.lex_state = 63, .external_lex_state = 2},
  [561] = {.lex_state = 63, .external_lex_state = 2},
  [562] = {.lex_state = 63},
  [563] = {.lex_state = 63, .external_lex_state = 2},
  [564] = {.lex_state = 63, .external_lex_state = 2},
  [565] = {.lex_state = 63},
  [566] = {.lex_state = 63, .external_lex_state = 2},
  [567] = {.lex_state = 63, .external_lex_state = 2},
  [568] = {.lex_state = 63},
  [569] = {.lex_state = 63, .external_lex_state = 2},
  [570] = {.lex_state = 63, .external_lex_state = 2},
  [571] = {.lex_state = 63, .external_lex_state = 2},
  [572] = {.lex_state = 63, .external_lex_state = 2},
  [573] = {.lex_state = 63, .external_lex_state = 2},
  [574] = {.lex_state = 63, .external_lex_state = 2},
  [575] = {.lex_state = 63, .external_lex_state = 2},
  [576] = {.lex_state = 63},
  [577] = {.lex_state = 63},
  [578] = {.lex_state = 63},
  [579] = {.lex_state = 63, .external_lex_state = 2},
  [580] = {.lex_state = 63},
  [581] = {.lex_state = 63},
  [582] = {.lex_state = 63},
  [583] = {.lex_state = 63, .external_lex_state = 2},
  [584] = {.lex_state = 63},
  [585] = {.lex_state = 63},
  [586] = {.lex_state = 63},
  [587] = {.lex_state = 63, .external_lex_state = 2},
  [588] = {.lex_state = 63},
  [589] = {.lex_state = 63},
  [590] = {.lex_state = 63},
  [591] = {.lex_state = 63, .external_lex_state = 2},
  [592] = {.lex_state = 63, .external_lex_state = 2},
  [593] = {.lex_state = 63},
  [594] = {.lex_state = 63},
  [595] = {.lex_state = 63},
  [596] = {.lex_state = 63},
  [597] = {.lex_state = 63, .external_lex_state = 2},
  [598] = {.lex_state = 63},
  [599] = {.lex_state = 63},
  [600] = {.lex_state = 63},
  [601] = {.lex_state = 63, .external_lex_state = 2},
  [602] = {.lex_state = 63},
  [603] = {.lex_state = 63, .external_lex_state = 2},
  [604] = {.lex_state = 63},
  [605] = {.lex_state = 63, .external_lex_state = 2},
  [606] = {.lex_state = 63},
  [607] = {.lex_state = 63, .external_lex_state = 2},
  [608] = {.lex_state = 63, .external_lex_state = 2},
  [609] = {.lex_state = 63, .external_lex_state = 2},
  [610] = {.lex_state = 63, .external_lex_state = 2},
  [611] = {.lex_state = 63, .external_lex_state = 2},
  [612] = {.lex_state = 63},
  [613] = {.lex_state = 63},
  [614] = {.lex_state = 63, .external_lex_state = 2},
  [615] = {.lex_state = 63, .external_lex_state = 2},
  [616] = {.lex_state = 63},
  [617] = {.lex_state = 63, .external_lex_state = 2},
  [618] = {.lex_state = 63, .external_lex_state = 2},
  [619] = {.lex_state = 63, .external_lex_state = 2},
  [620] = {.lex_state = 63, .external_lex_state = 2},
  [621] = {.lex_state = 63, .external_lex_state = 2},
  [622] = {.lex_state = 63, .external_lex_state = 2},
  [623] = {.lex_state = 63, .external_lex_state = 2},
  [624] = {.lex_state = 63},
  [625] = {.lex_state = 63},
  [626] = {.lex_state = 63, .external_lex_state = 2},
  [627] = {.lex_state = 63},
  [628] = {.lex_state = 63, .external_lex_state = 2},
  [629] = {.lex_state = 63, .external_lex_state = 2},
  [630] = {.lex_state = 63, .external_lex_state = 2},
  [631] = {.lex_state = 63},
  [632] = {.lex_state = 63, .external_lex_state = 2},
  [633] = {.lex_state = 63},
  [634] = {.lex_state = 63},
  [635] = {.lex_state = 63, .external_lex_state = 2},
  [636] = {.lex_state = 63},
  [637] = {.lex_state = 63, .external_lex_state = 2},
  [638] = {.lex_state = 63, .external_lex_state = 2},
  [639] = {.lex_state = 63, .external_lex_state = 2},
  [640] = {.lex_state = 63, .external_lex_state = 2},
  [641] = {.lex_state = 63},
  [642] = {.lex_state = 63},
  [643] = {.lex_state = 63},
  [644] = {.lex_state = 63},
  [645] = {.lex_state = 63},
  [646] = {.lex_state = 63},
  [647] = {.lex_state = 63},
  [648] = {.lex_state = 63},
  [649] = {.lex_state = 63},
  [650] = {.lex_state = 63},
  [651] = {.lex_state = 63},
  [652] = {.lex_state = 63},
  [653] = {.lex_state = 63},
  [654] = {.lex_state = 63},
  [655] = {.lex_state = 63},
  [656] = {.lex_state = 64},
  [657] = {.lex_state = 64},
  [658] = {.lex_state = 64},
  [659] = {.lex_state = 64},
  [660] = {.lex_state = 64},
  [661] = {.lex_state = 64},
  [662] = {.lex_state = 64},
  [663] = {.lex_state = 64},
  [664] = {.lex_state = 64},
  [665] = {.lex_state = 64},
  [666] = {.lex_state = 64},
  [667] = {.lex_state = 64},
  [668] = {.lex_state = 64},
  [669] = {.lex_state = 64},
  [670] = {.lex_state = 64},
  [671] = {.lex_state = 64},
  [672] = {.lex_state = 64},
  [673] = {.lex_state = 64},
  [674] = {.lex_state = 64},
  [675] = {.lex_state = 64},
  [676] = {.lex_state = 64},
  [677] = {.lex_state = 64},
  [678] = {.lex_state = 64},
  [679] = {.lex_state = 64},
  [680] = {.lex_state = 64},
  [681] = {.lex_state = 64},
  [682] = {.lex_state = 64},
  [683] = {.lex_state = 64},
  [684] = {.lex_state = 64},
  [685] = {.lex_state = 64},
  [686] = {.lex_state = 64},
  [687] = {.lex_state = 64},
  [688] = {.lex_state = 64},
  [689] = {.lex_state = 64},
  [690] = {.lex_state = 64},
  [691] = {.lex_state = 64},
  [692] = {.lex_state = 64},
  [693] = {.lex_state = 64},
  [694] = {.lex_state = 64, .external_lex_state = 2},
  [695] = {.lex_state = 64},
  [696] = {.lex_state = 64},
  [697] = {.lex_state = 64},
  [698] = {.lex_state = 64, .external_lex_state = 2},
  [699] = {.lex_state = 64, .external_lex_state = 2},
  [700] = {.lex_state = 64, .external_lex_state = 2},
  [701] = {.lex_state = 64, .external_lex_state = 2},
  [702] = {.lex_state = 64, .external_lex_state = 2},
  [703] = {.lex_state = 64},
  [704] = {.lex_state = 64},
  [705] = {.lex_state = 64},
  [706] = {.lex_state = 64},
  [707] = {.lex_state = 64},
  [708] = {.lex_state = 64, .external_lex_state = 2},
  [709] = {.lex_state = 64, .external_lex_state = 2},
  [710] = {.lex_state = 64, .external_lex_state = 2},
  [711] = {.lex_state = 64, .external_lex_state = 2},
  [712] = {.lex_state = 64, .external_lex_state = 2},
  [713] = {.lex_state = 64},
  [714] = {.lex_state = 64, .external_lex_state = 2},
  [715] = {.lex_state = 64},
  [716] = {.lex_state = 63},
  [717] = {.lex_state = 64},
  [718] = {.lex_state = 64},
  [719] = {.lex_state = 64},
  [720] = {.lex_state = 64},
  [721] = {.lex_state = 64},
  [722] = {.lex_state = 64},
  [723] = {.lex_state = 64},
  [724] = {.lex_state = 63},
  [725] = {.lex_state = 64},
  [726] = {.lex_state = 64},
  [727] = {.lex_state = 64},
  [728] = {.lex_state = 64},
  [729] = {.lex_state = 64},
  [730] = {.lex_state = 64},
  [731] = {.lex_state = 64},
  [732] = {.lex_state = 64},
  [733] = {.lex_state = 64},
  [734] = {.lex_state = 64},
  [735] = {.lex_state = 64},
  [736] = {.lex_state = 64},
  [737] = {.lex_state = 64},
  [738] = {.lex_state = 64},
  [739] = {.lex_state = 64},
  [740] = {.lex_state = 64},
  [741] = {.lex_state = 64},
  [742] = {.lex_state = 64},
  [743] = {.lex_state = 64},
  [744] = {.lex_state = 64},
  [745] = {.lex_state = 64},
  [746] = {.lex_state = 64},
  [747] = {.lex_state = 64},
  [748] = {.lex_state = 64},
  [749] = {.lex_state = 64},
  [750] = {.lex_state = 64},
  [751] = {.lex_state = 64},
  [752] = {.lex_state = 64},
  [753] = {.lex_state = 64},
  [754] = {.lex_state = 64},
  [755] = {.lex_state = 64},
  [756] = {.lex_state = 4},
  [757] = {.lex_state = 4},
  [758] = {.lex_state = 64},
  [759] = {.lex_state = 64},
  [760] = {.lex_state = 4},
  [761] = {.lex_state = 64},
  [762] = {.lex_state = 64},
  [763] = {.lex_state = 64},
  [764] = {.lex_state = 64},
  [765] = {.lex_state = 64},
  [766] = {.lex_state = 64},
  [767] = {.lex_state = 64},
  [768] = {.lex_state = 64},
  [769] = {.lex_state = 64},
  [770] = {.lex_state = 64},
  [771] = {.lex_state = 64},
  [772] = {.lex_state = 64},
  [773] = {.lex_state = 64},
  [774] = {.lex_state = 64},
  [775] = {.lex_state = 64},
  [776] = {.lex_state = 64},
  [777] = {.lex_state = 16},
  [778] = {.lex_state = 16},
  [779] = {.lex_state = 16},
  [780] = {.lex_state = 16},
  [781] = {.lex_state = 16},
  [782] = {.lex_state = 17},
  [783] = {.lex_state = 17},
  [784] = {.lex_state = 16},
  [785] = {.lex_state = 17},
  [786] = {.lex_state = 16},
  [787] = {.lex_state = 16},
  [788] = {.lex_state = 17},
  [789] = {.lex_state = 16},
  [790] = {.lex_state = 17},
  [791] = {.lex_state = 16},
  [792] = {.lex_state = 17},
  [793] = {.lex_state = 64},
  [794] = {.lex_state = 17},
  [795] = {.lex_state = 16},
  [796] = {.lex_state = 64},
  [797] = {.lex_state = 16},
  [798] = {.lex_state = 17},
  [799] = {.lex_state = 16},
  [800] = {.lex_state = 17},
  [801] = {.lex_state = 16},
  [802] = {.lex_state = 17},
  [803] = {.lex_state = 16},
  [804] = {.lex_state = 16},
  [805] = {.lex_state = 16},
  [806] = {.lex_state = 16},
  [807] = {.lex_state = 16},
  [808] = {.lex_state = 16},
  [809] = {.lex_state = 16},
  [810] = {.lex_state = 16},
  [811] = {.lex_state = 16},
  [812] = {.lex_state = 16},
  [813] = {.lex_state = 17},
  [814] = {.lex_state = 16},
  [815] = {.lex_state = 17},
  [816] = {.lex_state = 17},
  [817] = {.lex_state = 16},
  [818] = {.lex_state = 17},
  [819] = {.lex_state = 16},
  [820] = {.lex_state = 16},
  [821] = {.lex_state = 16},
  [822] = {.lex_state = 16},
  [823] = {.lex_state = 17},
  [824] = {.lex_state = 17},
  [825] = {.lex_state = 17},
  [826] = {.lex_state = 16},
  [827] = {.lex_state = 16},
  [828] = {.lex_state = 16},
  [829] = {.lex_state = 64},
  [830] = {.lex_state = 64},
  [831] = {.lex_state = 64},
  [832] = {.lex_state = 64},
  [833] = {.lex_state = 16},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 64},
  [837] = {.lex_state = 64},
  [838] = {.lex_state = 64},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 64},
  [842] = {.lex_state = 64},
  [843] = {.lex_state = 64},
  [844] = {.lex_state = 64},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 64},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 64, .external_lex_state = 2},
  [849] = {.lex_state = 64},
  [850] = {.lex_state = 8, .external_lex_state = 3},
  [851] = {.lex_state = 0, .external_lex_state = 2},
  [852] = {.lex_state = 64},
  [853] = {.lex_state = 64, .external_lex_state = 2},
  [854] = {.lex_state = 16},
  [855] = {.lex_state = 16},
  [856] = {.lex_state = 16},
  [857] = {.lex_state = 64, .external_lex_state = 2},
  [858] = {.lex_state = 16},
  [859] = {.lex_state = 8, .external_lex_state = 3},
  [860] = {.lex_state = 16},
  [861] = {.lex_state = 64, .external_lex_state = 2},
  [862] = {.lex_state = 64, .external_lex_state = 2},
  [863] = {.lex_state = 16},
  [864] = {.lex_state = 16},
  [865] = {.lex_state = 0, .external_lex_state = 2},
  [866] = {.lex_state = 8, .external_lex_state = 3},
  [867] = {.lex_state = 8, .external_lex_state = 3},
  [868] = {.lex_state = 16},
  [869] = {.lex_state = 64},
  [870] = {.lex_state = 64, .external_lex_state = 2},
  [871] = {.lex_state = 0, .external_lex_state = 2},
  [872] = {.lex_state = 0, .external_lex_state = 2},
  [873] = {.lex_state = 64},
  [874] = {.lex_state = 8, .external_lex_state = 3},
  [875] = {.lex_state = 16},
  [876] = {.lex_state = 16},
  [877] = {.lex_state = 16},
  [878] = {.lex_state = 64},
  [879] = {.lex_state = 16},
  [880] = {.lex_state = 16},
  [881] = {.lex_state = 16},
  [882] = {.lex_state = 64, .external_lex_state = 2},
  [883] = {.lex_state = 64, .external_lex_state = 2},
  [884] = {.lex_state = 64},
  [885] = {.lex_state = 64},
  [886] = {.lex_state = 16},
  [887] = {.lex_state = 64, .external_lex_state = 2},
  [888] = {.lex_state = 16},
  [889] = {.lex_state = 16},
  [890] = {.lex_state = 16},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 16},
  [893] = {.lex_state = 16},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 16},
  [896] = {.lex_state = 16},
  [897] = {.lex_state = 16},
  [898] = {.lex_state = 64},
  [899] = {.lex_state = 64},
  [900] = {.lex_state = 16},
  [901] = {.lex_state = 64},
  [902] = {.lex_state = 64},
  [903] = {.lex_state = 16},
  [904] = {.lex_state = 64},
  [905] = {.lex_state = 64},
  [906] = {.lex_state = 64},
  [907] = {.lex_state = 16},
  [908] = {.lex_state = 16},
  [909] = {.lex_state = 16},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 16},
  [912] = {.lex_state = 16},
  [913] = {.lex_state = 64},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 64},
  [917] = {.lex_state = 64},
  [918] = {.lex_state = 64},
  [919] = {.lex_state = 16},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 16},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 16},
  [924] = {.lex_state = 16},
  [925] = {.lex_state = 0, .external_lex_state = 2},
  [926] = {.lex_state = 16},
  [927] = {.lex_state = 64},
  [928] = {.lex_state = 16},
  [929] = {.lex_state = 0, .external_lex_state = 2},
  [930] = {.lex_state = 10},
  [931] = {.lex_state = 7},
  [932] = {.lex_state = 64},
  [933] = {.lex_state = 7},
  [934] = {.lex_state = 10},
  [935] = {.lex_state = 64},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 10},
  [938] = {.lex_state = 64},
  [939] = {.lex_state = 64},
  [940] = {.lex_state = 64},
  [941] = {.lex_state = 64, .external_lex_state = 2},
  [942] = {.lex_state = 64},
  [943] = {.lex_state = 16},
  [944] = {.lex_state = 10},
  [945] = {.lex_state = 7},
  [946] = {.lex_state = 64},
  [947] = {.lex_state = 64},
  [948] = {.lex_state = 16},
  [949] = {.lex_state = 0, .external_lex_state = 2},
  [950] = {.lex_state = 64},
  [951] = {.lex_state = 64},
  [952] = {.lex_state = 64},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 64},
  [955] = {.lex_state = 64},
  [956] = {.lex_state = 64},
  [957] = {.lex_state = 64},
  [958] = {.lex_state = 8, .external_lex_state = 3},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 64},
  [963] = {.lex_state = 7},
  [964] = {.lex_state = 16},
  [965] = {.lex_state = 64},
  [966] = {.lex_state = 10},
  [967] = {.lex_state = 0, .external_lex_state = 2},
  [968] = {.lex_state = 0, .external_lex_state = 2},
  [969] = {.lex_state = 64},
  [970] = {.lex_state = 16},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 64},
  [973] = {.lex_state = 64},
  [974] = {.lex_state = 64},
  [975] = {.lex_state = 7},
  [976] = {.lex_state = 64},
  [977] = {.lex_state = 10},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 64},
  [980] = {.lex_state = 0, .external_lex_state = 2},
  [981] = {.lex_state = 7},
  [982] = {.lex_state = 0, .external_lex_state = 2},
  [983] = {.lex_state = 64},
  [984] = {.lex_state = 64},
  [985] = {.lex_state = 64},
  [986] = {.lex_state = 0, .external_lex_state = 2},
  [987] = {.lex_state = 64},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 7},
  [990] = {.lex_state = 10},
  [991] = {.lex_state = 64},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 17},
  [995] = {.lex_state = 17},
  [996] = {.lex_state = 17},
  [997] = {.lex_state = 0, .external_lex_state = 2},
  [998] = {.lex_state = 64},
  [999] = {.lex_state = 17},
  [1000] = {.lex_state = 17},
  [1001] = {.lex_state = 17},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 17},
  [1004] = {.lex_state = 64},
  [1005] = {.lex_state = 17},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 64},
  [1008] = {.lex_state = 17},
  [1009] = {.lex_state = 64},
  [1010] = {.lex_state = 64},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 64, .external_lex_state = 2},
  [1013] = {.lex_state = 64},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 17},
  [1017] = {.lex_state = 17},
  [1018] = {.lex_state = 64},
  [1019] = {.lex_state = 17},
  [1020] = {.lex_state = 64},
  [1021] = {.lex_state = 17},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 64, .external_lex_state = 2},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 64, .external_lex_state = 2},
  [1028] = {.lex_state = 17},
  [1029] = {.lex_state = 64},
  [1030] = {.lex_state = 3},
  [1031] = {.lex_state = 64, .external_lex_state = 2},
  [1032] = {.lex_state = 64},
  [1033] = {.lex_state = 64},
  [1034] = {.lex_state = 64},
  [1035] = {.lex_state = 64, .external_lex_state = 2},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 64},
  [1038] = {.lex_state = 64},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 64},
  [1047] = {.lex_state = 3},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 64},
  [1051] = {.lex_state = 3},
  [1052] = {.lex_state = 64, .external_lex_state = 2},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 64, .external_lex_state = 2},
  [1063] = {.lex_state = 64},
  [1064] = {.lex_state = 0, .external_lex_state = 2},
  [1065] = {.lex_state = 64, .external_lex_state = 2},
  [1066] = {.lex_state = 64, .external_lex_state = 2},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 17},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 64},
  [1072] = {.lex_state = 64},
  [1073] = {.lex_state = 64},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 17},
  [1077] = {.lex_state = 64},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 3},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 64},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 17},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 16},
  [1107] = {.lex_state = 64},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 0, .external_lex_state = 2},
  [1110] = {.lex_state = 64},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0, .external_lex_state = 2},
  [1114] = {.lex_state = 0, .external_lex_state = 2},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 0},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 3},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 64},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 0, .external_lex_state = 2},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 0},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 0},
  [1157] = {.lex_state = 0, .external_lex_state = 2},
  [1158] = {.lex_state = 0},
  [1159] = {.lex_state = 0, .external_lex_state = 2},
  [1160] = {.lex_state = 0, .external_lex_state = 2},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 0, .external_lex_state = 2},
  [1163] = {.lex_state = 0, .external_lex_state = 2},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 64},
  [1167] = {.lex_state = 64},
  [1168] = {.lex_state = 64},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 0},
  [1172] = {.lex_state = 64},
  [1173] = {.lex_state = 0},
  [1174] = {.lex_state = 0},
  [1175] = {.lex_state = 0},
  [1176] = {.lex_state = 0},
  [1177] = {.lex_state = 0},
  [1178] = {.lex_state = 0},
  [1179] = {.lex_state = 0},
  [1180] = {.lex_state = 0},
  [1181] = {.lex_state = 0},
  [1182] = {.lex_state = 0},
  [1183] = {.lex_state = 0},
  [1184] = {.lex_state = 0},
  [1185] = {.lex_state = 0},
  [1186] = {.lex_state = 0},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 64},
  [1189] = {.lex_state = 0},
  [1190] = {.lex_state = 0, .external_lex_state = 2},
  [1191] = {.lex_state = 0, .external_lex_state = 2},
  [1192] = {.lex_state = 64},
  [1193] = {.lex_state = 0},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 0, .external_lex_state = 2},
  [1196] = {.lex_state = 0, .external_lex_state = 2},
  [1197] = {.lex_state = 0},
  [1198] = {.lex_state = 0, .external_lex_state = 2},
  [1199] = {.lex_state = 0},
  [1200] = {.lex_state = 0},
  [1201] = {.lex_state = 0},
  [1202] = {.lex_state = 0},
  [1203] = {.lex_state = 64},
  [1204] = {.lex_state = 0, .external_lex_state = 2},
  [1205] = {.lex_state = 0},
  [1206] = {.lex_state = 0},
  [1207] = {.lex_state = 0},
  [1208] = {.lex_state = 64},
  [1209] = {.lex_state = 0, .external_lex_state = 2},
  [1210] = {.lex_state = 0},
  [1211] = {.lex_state = 0},
  [1212] = {.lex_state = 0},
  [1213] = {.lex_state = 64},
  [1214] = {.lex_state = 0, .external_lex_state = 2},
  [1215] = {.lex_state = 0},
  [1216] = {.lex_state = 0},
  [1217] = {.lex_state = 0},
  [1218] = {.lex_state = 0},
  [1219] = {.lex_state = 0},
  [1220] = {.lex_state = 0},
  [1221] = {.lex_state = 0},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 0},
  [1224] = {.lex_state = 0},
  [1225] = {.lex_state = 0},
  [1226] = {.lex_state = 0},
  [1227] = {.lex_state = 64},
  [1228] = {.lex_state = 0},
  [1229] = {.lex_state = 64},
  [1230] = {.lex_state = 0},
  [1231] = {.lex_state = 3},
  [1232] = {.lex_state = 0},
  [1233] = {.lex_state = 0, .external_lex_state = 2},
  [1234] = {.lex_state = 0},
  [1235] = {.lex_state = 3},
  [1236] = {.lex_state = 0},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 0},
  [1239] = {.lex_state = 0},
  [1240] = {.lex_state = 64},
  [1241] = {.lex_state = 0},
  [1242] = {.lex_state = 0},
  [1243] = {.lex_state = 0},
  [1244] = {.lex_state = 0},
  [1245] = {.lex_state = 0},
  [1246] = {.lex_state = 0},
  [1247] = {.lex_state = 0},
  [1248] = {.lex_state = 0},
  [1249] = {.lex_state = 0},
  [1250] = {.lex_state = 0},
  [1251] = {.lex_state = 0},
  [1252] = {.lex_state = 0},
  [1253] = {.lex_state = 64},
  [1254] = {.lex_state = 0},
  [1255] = {.lex_state = 3},
  [1256] = {.lex_state = 0},
  [1257] = {.lex_state = 0, .external_lex_state = 2},
  [1258] = {.lex_state = 0},
  [1259] = {.lex_state = 0},
  [1260] = {.lex_state = 0},
  [1261] = {.lex_state = 0},
  [1262] = {.lex_state = 0},
  [1263] = {.lex_state = 0},
  [1264] = {.lex_state = 0},
  [1265] = {.lex_state = 0},
  [1266] = {.lex_state = 0},
  [1267] = {.lex_state = 0},
  [1268] = {.lex_state = 0},
  [1269] = {.lex_state = 0},
  [1270] = {.lex_state = 0},
  [1271] = {.lex_state = 0},
  [1272] = {.lex_state = 0},
  [1273] = {.lex_state = 0},
  [1274] = {.lex_state = 0},
  [1275] = {.lex_state = 0},
  [1276] = {.lex_state = 0},
  [1277] = {.lex_state = 0},
  [1278] = {.lex_state = 0},
  [1279] = {.lex_state = 0},
  [1280] = {.lex_state = 0},
  [1281] = {.lex_state = 0},
  [1282] = {.lex_state = 0},
  [1283] = {.lex_state = 1},
  [1284] = {.lex_state = 64},
  [1285] = {.lex_state = 64},
  [1286] = {.lex_state = 0},
  [1287] = {.lex_state = 8},
  [1288] = {.lex_state = 0},
  [1289] = {.lex_state = 64},
  [1290] = {.lex_state = 64},
  [1291] = {.lex_state = 64},
  [1292] = {.lex_state = 64},
  [1293] = {.lex_state = 64},
  [1294] = {.lex_state = 64},
  [1295] = {.lex_state = 64},
  [1296] = {.lex_state = 64},
  [1297] = {.lex_state = 64},
  [1298] = {.lex_state = 64},
  [1299] = {.lex_state = 0},
  [1300] = {.lex_state = 0},
  [1301] = {.lex_state = 64},
  [1302] = {.lex_state = 0},
  [1303] = {.lex_state = 0},
  [1304] = {.lex_state = 0},
  [1305] = {.lex_state = 0},
  [1306] = {.lex_state = 64},
  [1307] = {.lex_state = 0},
  [1308] = {.lex_state = 0},
  [1309] = {.lex_state = 1},
  [1310] = {.lex_state = 0},
  [1311] = {.lex_state = 0},
  [1312] = {.lex_state = 0},
  [1313] = {.lex_state = 64},
  [1314] = {.lex_state = 64},
  [1315] = {.lex_state = 64},
  [1316] = {.lex_state = 0},
  [1317] = {.lex_state = 64},
  [1318] = {.lex_state = 64},
  [1319] = {.lex_state = 64},
  [1320] = {.lex_state = 64},
  [1321] = {.lex_state = 64},
  [1322] = {.lex_state = 0},
  [1323] = {.lex_state = 64},
  [1324] = {.lex_state = 64},
  [1325] = {.lex_state = 0},
  [1326] = {.lex_state = 64},
  [1327] = {.lex_state = 64},
  [1328] = {.lex_state = 0},
  [1329] = {.lex_state = 0},
  [1330] = {.lex_state = 64},
  [1331] = {.lex_state = 0},
  [1332] = {.lex_state = 0},
  [1333] = {.lex_state = 0},
  [1334] = {.lex_state = 0},
  [1335] = {.lex_state = 0},
  [1336] = {.lex_state = 8},
  [1337] = {.lex_state = 0},
  [1338] = {.lex_state = 64},
  [1339] = {.lex_state = 64},
  [1340] = {.lex_state = 0},
  [1341] = {.lex_state = 64},
  [1342] = {.lex_state = 0},
  [1343] = {.lex_state = 0},
  [1344] = {.lex_state = 64},
  [1345] = {.lex_state = 64},
  [1346] = {.lex_state = 64},
  [1347] = {.lex_state = 64},
  [1348] = {.lex_state = 64},
  [1349] = {.lex_state = 0},
  [1350] = {.lex_state = 0},
  [1351] = {.lex_state = 0},
  [1352] = {.lex_state = 0},
  [1353] = {.lex_state = 0},
  [1354] = {.lex_state = 64},
  [1355] = {.lex_state = 64},
  [1356] = {.lex_state = 64},
  [1357] = {.lex_state = 0},
  [1358] = {.lex_state = 0},
  [1359] = {.lex_state = 64},
  [1360] = {.lex_state = 64},
  [1361] = {.lex_state = 64},
  [1362] = {.lex_state = 0},
  [1363] = {.lex_state = 0},
  [1364] = {.lex_state = 64},
  [1365] = {.lex_state = 64},
  [1366] = {.lex_state = 64},
  [1367] = {.lex_state = 0},
  [1368] = {.lex_state = 64},
  [1369] = {.lex_state = 64},
  [1370] = {.lex_state = 64},
  [1371] = {.lex_state = 64},
  [1372] = {.lex_state = 64},
  [1373] = {.lex_state = 64},
  [1374] = {.lex_state = 0},
  [1375] = {.lex_state = 64},
  [1376] = {.lex_state = 64},
  [1377] = {.lex_state = 64},
  [1378] = {.lex_state = 64},
  [1379] = {.lex_state = 64},
  [1380] = {.lex_state = 0},
  [1381] = {.lex_state = 64},
  [1382] = {.lex_state = 64},
  [1383] = {.lex_state = 64},
  [1384] = {.lex_state = 64},
};

enum {
  ts_external_token__automatic_semicolon = 0,
  ts_external_token__template_chars = 1,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__automatic_semicolon] = sym__automatic_semicolon,
  [ts_external_token__template_chars] = sym__template_chars,
};

static const bool ts_external_scanner_states[4][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__template_chars] = true,
  },
  [2] = {
    [ts_external_token__automatic_semicolon] = true,
  },
  [3] = {
    [ts_external_token__template_chars] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_private_property_identifier] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1286),
    [sym_export_statement] = STATE(22),
    [sym_declaration] = STATE(22),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_for_in_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_try_statement] = STATE(22),
    [sym_with_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_debugger_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_throw_statement] = STATE(22),
    [sym_empty_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_hash_bang_line] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [2] = {
    [sym_export_statement] = STATE(21),
    [sym_declaration] = STATE(21),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(21),
    [sym_expression_statement] = STATE(21),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(21),
    [sym_if_statement] = STATE(21),
    [sym_switch_statement] = STATE(21),
    [sym_for_statement] = STATE(21),
    [sym_for_in_statement] = STATE(21),
    [sym_while_statement] = STATE(21),
    [sym_do_statement] = STATE(21),
    [sym_try_statement] = STATE(21),
    [sym_with_statement] = STATE(21),
    [sym_break_statement] = STATE(21),
    [sym_continue_statement] = STATE(21),
    [sym_debugger_statement] = STATE(21),
    [sym_return_statement] = STATE(21),
    [sym_throw_statement] = STATE(21),
    [sym_empty_statement] = STATE(21),
    [sym_labeled_statement] = STATE(21),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1351),
    [sym_object_assignment_pattern] = STATE(1067),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1351),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1351),
    [sym_spread_element] = STATE(1040),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(609),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [sym_rest_pattern] = STATE(1067),
    [sym_method_definition] = STATE(1040),
    [sym_pair] = STATE(1040),
    [sym_pair_pattern] = STATE(1067),
    [sym__property_name] = STATE(1069),
    [sym_computed_property_name] = STATE(1069),
    [aux_sym_program_repeat1] = STATE(21),
    [aux_sym_export_statement_repeat1] = STATE(703),
    [aux_sym_object_repeat1] = STATE(1042),
    [aux_sym_object_pattern_repeat1] = STATE(1074),
    [sym_identifier] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(93),
    [anon_sym_STAR] = ACTIONS(95),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(97),
    [anon_sym_RBRACE] = ACTIONS(99),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(101),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(103),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(107),
    [sym_private_property_identifier] = ACTIONS(109),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(111),
    [anon_sym_get] = ACTIONS(113),
    [anon_sym_set] = ACTIONS(113),
  },
  [3] = {
    [sym_export_statement] = STATE(17),
    [sym_declaration] = STATE(17),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_for_in_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_try_statement] = STATE(17),
    [sym_with_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_debugger_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_throw_statement] = STATE(17),
    [sym_empty_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1351),
    [sym_object_assignment_pattern] = STATE(1067),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1351),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1351),
    [sym_spread_element] = STATE(993),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(609),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [sym_rest_pattern] = STATE(1067),
    [sym_method_definition] = STATE(993),
    [sym_pair] = STATE(993),
    [sym_pair_pattern] = STATE(1067),
    [sym__property_name] = STATE(1069),
    [sym_computed_property_name] = STATE(1069),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(703),
    [aux_sym_object_repeat1] = STATE(1070),
    [aux_sym_object_pattern_repeat1] = STATE(1074),
    [sym_identifier] = ACTIONS(115),
    [anon_sym_export] = ACTIONS(117),
    [anon_sym_STAR] = ACTIONS(95),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(97),
    [anon_sym_RBRACE] = ACTIONS(119),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(101),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(121),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(107),
    [sym_private_property_identifier] = ACTIONS(109),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(123),
    [anon_sym_get] = ACTIONS(125),
    [anon_sym_set] = ACTIONS(125),
  },
  [4] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1351),
    [sym_object_assignment_pattern] = STATE(1067),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1351),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1351),
    [sym_spread_element] = STATE(993),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(609),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [sym_rest_pattern] = STATE(1067),
    [sym_method_definition] = STATE(993),
    [sym_pair] = STATE(993),
    [sym_pair_pattern] = STATE(1067),
    [sym__property_name] = STATE(1069),
    [sym_computed_property_name] = STATE(1069),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(703),
    [aux_sym_object_repeat1] = STATE(1070),
    [aux_sym_object_pattern_repeat1] = STATE(1074),
    [sym_identifier] = ACTIONS(115),
    [anon_sym_export] = ACTIONS(117),
    [anon_sym_STAR] = ACTIONS(95),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(97),
    [anon_sym_RBRACE] = ACTIONS(127),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(101),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(121),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(107),
    [sym_private_property_identifier] = ACTIONS(109),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(123),
    [anon_sym_get] = ACTIONS(125),
    [anon_sym_set] = ACTIONS(125),
  },
  [5] = {
    [sym_export_statement] = STATE(17),
    [sym_declaration] = STATE(17),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_for_in_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_try_statement] = STATE(17),
    [sym_with_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_debugger_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_throw_statement] = STATE(17),
    [sym_empty_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1351),
    [sym_object_assignment_pattern] = STATE(1067),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1351),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1351),
    [sym_spread_element] = STATE(993),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(609),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [sym_rest_pattern] = STATE(1067),
    [sym_method_definition] = STATE(993),
    [sym_pair] = STATE(993),
    [sym_pair_pattern] = STATE(1067),
    [sym__property_name] = STATE(1069),
    [sym_computed_property_name] = STATE(1069),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(703),
    [aux_sym_object_repeat1] = STATE(1070),
    [aux_sym_object_pattern_repeat1] = STATE(1074),
    [sym_identifier] = ACTIONS(115),
    [anon_sym_export] = ACTIONS(117),
    [anon_sym_STAR] = ACTIONS(95),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(97),
    [anon_sym_RBRACE] = ACTIONS(129),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(101),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(121),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(107),
    [sym_private_property_identifier] = ACTIONS(109),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(123),
    [anon_sym_get] = ACTIONS(125),
    [anon_sym_set] = ACTIONS(125),
  },
  [6] = {
    [sym_export_statement] = STATE(21),
    [sym_declaration] = STATE(21),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(21),
    [sym_expression_statement] = STATE(21),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(21),
    [sym_if_statement] = STATE(21),
    [sym_switch_statement] = STATE(21),
    [sym_for_statement] = STATE(21),
    [sym_for_in_statement] = STATE(21),
    [sym_while_statement] = STATE(21),
    [sym_do_statement] = STATE(21),
    [sym_try_statement] = STATE(21),
    [sym_with_statement] = STATE(21),
    [sym_break_statement] = STATE(21),
    [sym_continue_statement] = STATE(21),
    [sym_debugger_statement] = STATE(21),
    [sym_return_statement] = STATE(21),
    [sym_throw_statement] = STATE(21),
    [sym_empty_statement] = STATE(21),
    [sym_labeled_statement] = STATE(21),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1351),
    [sym_object_assignment_pattern] = STATE(1067),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1351),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1351),
    [sym_spread_element] = STATE(1040),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(609),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [sym_rest_pattern] = STATE(1067),
    [sym_method_definition] = STATE(1040),
    [sym_pair] = STATE(1040),
    [sym_pair_pattern] = STATE(1067),
    [sym__property_name] = STATE(1069),
    [sym_computed_property_name] = STATE(1069),
    [aux_sym_program_repeat1] = STATE(21),
    [aux_sym_export_statement_repeat1] = STATE(703),
    [aux_sym_object_repeat1] = STATE(1042),
    [aux_sym_object_pattern_repeat1] = STATE(1074),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_export] = ACTIONS(133),
    [anon_sym_STAR] = ACTIONS(95),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(97),
    [anon_sym_RBRACE] = ACTIONS(99),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(101),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(107),
    [sym_private_property_identifier] = ACTIONS(109),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(137),
    [anon_sym_get] = ACTIONS(139),
    [anon_sym_set] = ACTIONS(139),
  },
  [7] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [ts_builtin_sym_end] = ACTIONS(141),
    [sym_identifier] = ACTIONS(143),
    [anon_sym_export] = ACTIONS(146),
    [anon_sym_default] = ACTIONS(149),
    [anon_sym_LBRACE] = ACTIONS(151),
    [anon_sym_RBRACE] = ACTIONS(141),
    [anon_sym_import] = ACTIONS(154),
    [anon_sym_var] = ACTIONS(157),
    [anon_sym_let] = ACTIONS(160),
    [anon_sym_const] = ACTIONS(160),
    [anon_sym_if] = ACTIONS(163),
    [anon_sym_switch] = ACTIONS(166),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_LPAREN] = ACTIONS(172),
    [anon_sym_await] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(178),
    [anon_sym_do] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(184),
    [anon_sym_with] = ACTIONS(187),
    [anon_sym_break] = ACTIONS(190),
    [anon_sym_continue] = ACTIONS(193),
    [anon_sym_debugger] = ACTIONS(196),
    [anon_sym_return] = ACTIONS(199),
    [anon_sym_throw] = ACTIONS(202),
    [anon_sym_SEMI] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(149),
    [anon_sym_yield] = ACTIONS(208),
    [anon_sym_LBRACK] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(214),
    [anon_sym_SLASH] = ACTIONS(217),
    [anon_sym_class] = ACTIONS(220),
    [anon_sym_async] = ACTIONS(223),
    [anon_sym_function] = ACTIONS(226),
    [anon_sym_new] = ACTIONS(229),
    [anon_sym_PLUS] = ACTIONS(232),
    [anon_sym_DASH] = ACTIONS(232),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_TILDE] = ACTIONS(235),
    [anon_sym_typeof] = ACTIONS(238),
    [anon_sym_void] = ACTIONS(238),
    [anon_sym_delete] = ACTIONS(238),
    [anon_sym_PLUS_PLUS] = ACTIONS(241),
    [anon_sym_DASH_DASH] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(244),
    [anon_sym_SQUOTE] = ACTIONS(247),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(250),
    [sym_number] = ACTIONS(253),
    [sym_this] = ACTIONS(256),
    [sym_super] = ACTIONS(256),
    [sym_true] = ACTIONS(256),
    [sym_false] = ACTIONS(256),
    [sym_null] = ACTIONS(256),
    [sym_undefined] = ACTIONS(259),
    [anon_sym_AT] = ACTIONS(262),
    [anon_sym_static] = ACTIONS(265),
    [anon_sym_get] = ACTIONS(265),
    [anon_sym_set] = ACTIONS(265),
  },
  [8] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(268),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(270),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(268),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [9] = {
    [sym_export_statement] = STATE(10),
    [sym_declaration] = STATE(10),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(10),
    [sym_expression_statement] = STATE(10),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(10),
    [sym_if_statement] = STATE(10),
    [sym_switch_statement] = STATE(10),
    [sym_for_statement] = STATE(10),
    [sym_for_in_statement] = STATE(10),
    [sym_while_statement] = STATE(10),
    [sym_do_statement] = STATE(10),
    [sym_try_statement] = STATE(10),
    [sym_with_statement] = STATE(10),
    [sym_break_statement] = STATE(10),
    [sym_continue_statement] = STATE(10),
    [sym_debugger_statement] = STATE(10),
    [sym_return_statement] = STATE(10),
    [sym_throw_statement] = STATE(10),
    [sym_empty_statement] = STATE(10),
    [sym_labeled_statement] = STATE(10),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(10),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(272),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(274),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(272),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [10] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(278),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(276),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [11] = {
    [sym_export_statement] = STATE(8),
    [sym_declaration] = STATE(8),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(8),
    [sym_expression_statement] = STATE(8),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(8),
    [sym_if_statement] = STATE(8),
    [sym_switch_statement] = STATE(8),
    [sym_for_statement] = STATE(8),
    [sym_for_in_statement] = STATE(8),
    [sym_while_statement] = STATE(8),
    [sym_do_statement] = STATE(8),
    [sym_try_statement] = STATE(8),
    [sym_with_statement] = STATE(8),
    [sym_break_statement] = STATE(8),
    [sym_continue_statement] = STATE(8),
    [sym_debugger_statement] = STATE(8),
    [sym_return_statement] = STATE(8),
    [sym_throw_statement] = STATE(8),
    [sym_empty_statement] = STATE(8),
    [sym_labeled_statement] = STATE(8),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(8),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(282),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(280),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [12] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(284),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [13] = {
    [sym_export_statement] = STATE(16),
    [sym_declaration] = STATE(16),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(16),
    [sym_expression_statement] = STATE(16),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_switch_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_do_statement] = STATE(16),
    [sym_try_statement] = STATE(16),
    [sym_with_statement] = STATE(16),
    [sym_break_statement] = STATE(16),
    [sym_continue_statement] = STATE(16),
    [sym_debugger_statement] = STATE(16),
    [sym_return_statement] = STATE(16),
    [sym_throw_statement] = STATE(16),
    [sym_empty_statement] = STATE(16),
    [sym_labeled_statement] = STATE(16),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(286),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [14] = {
    [sym_export_statement] = STATE(17),
    [sym_declaration] = STATE(17),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_for_in_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_try_statement] = STATE(17),
    [sym_with_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_debugger_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_throw_statement] = STATE(17),
    [sym_empty_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(288),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [15] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(286),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [16] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(290),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [17] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(292),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [18] = {
    [sym_export_statement] = STATE(19),
    [sym_declaration] = STATE(19),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(19),
    [sym_expression_statement] = STATE(19),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_switch_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_for_in_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_do_statement] = STATE(19),
    [sym_try_statement] = STATE(19),
    [sym_with_statement] = STATE(19),
    [sym_break_statement] = STATE(19),
    [sym_continue_statement] = STATE(19),
    [sym_debugger_statement] = STATE(19),
    [sym_return_statement] = STATE(19),
    [sym_throw_statement] = STATE(19),
    [sym_empty_statement] = STATE(19),
    [sym_labeled_statement] = STATE(19),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [ts_builtin_sym_end] = ACTIONS(294),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [19] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [ts_builtin_sym_end] = ACTIONS(296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [20] = {
    [sym_export_statement] = STATE(24),
    [sym_declaration] = STATE(24),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(24),
    [sym_expression_statement] = STATE(24),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(24),
    [sym_if_statement] = STATE(24),
    [sym_switch_statement] = STATE(24),
    [sym_for_statement] = STATE(24),
    [sym_for_in_statement] = STATE(24),
    [sym_while_statement] = STATE(24),
    [sym_do_statement] = STATE(24),
    [sym_try_statement] = STATE(24),
    [sym_with_statement] = STATE(24),
    [sym_break_statement] = STATE(24),
    [sym_continue_statement] = STATE(24),
    [sym_debugger_statement] = STATE(24),
    [sym_return_statement] = STATE(24),
    [sym_throw_statement] = STATE(24),
    [sym_empty_statement] = STATE(24),
    [sym_labeled_statement] = STATE(24),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(24),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(298),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [21] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(300),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [22] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [ts_builtin_sym_end] = ACTIONS(294),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [23] = {
    [sym_export_statement] = STATE(21),
    [sym_declaration] = STATE(21),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(21),
    [sym_expression_statement] = STATE(21),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(21),
    [sym_if_statement] = STATE(21),
    [sym_switch_statement] = STATE(21),
    [sym_for_statement] = STATE(21),
    [sym_for_in_statement] = STATE(21),
    [sym_while_statement] = STATE(21),
    [sym_do_statement] = STATE(21),
    [sym_try_statement] = STATE(21),
    [sym_with_statement] = STATE(21),
    [sym_break_statement] = STATE(21),
    [sym_continue_statement] = STATE(21),
    [sym_debugger_statement] = STATE(21),
    [sym_return_statement] = STATE(21),
    [sym_throw_statement] = STATE(21),
    [sym_empty_statement] = STATE(21),
    [sym_labeled_statement] = STATE(21),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(21),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(302),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [24] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(304),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [25] = {
    [sym_export_statement] = STATE(233),
    [sym_declaration] = STATE(233),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(233),
    [sym_expression_statement] = STATE(233),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(233),
    [sym_if_statement] = STATE(233),
    [sym_switch_statement] = STATE(233),
    [sym_for_statement] = STATE(233),
    [sym_for_in_statement] = STATE(233),
    [sym_while_statement] = STATE(233),
    [sym_do_statement] = STATE(233),
    [sym_try_statement] = STATE(233),
    [sym_with_statement] = STATE(233),
    [sym_break_statement] = STATE(233),
    [sym_continue_statement] = STATE(233),
    [sym_debugger_statement] = STATE(233),
    [sym_return_statement] = STATE(233),
    [sym_throw_statement] = STATE(233),
    [sym_empty_statement] = STATE(233),
    [sym_labeled_statement] = STATE(233),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [26] = {
    [sym_export_statement] = STATE(317),
    [sym_declaration] = STATE(318),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(319),
    [sym_expression_statement] = STATE(320),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(321),
    [sym_if_statement] = STATE(322),
    [sym_switch_statement] = STATE(323),
    [sym_for_statement] = STATE(324),
    [sym_for_in_statement] = STATE(325),
    [sym_while_statement] = STATE(326),
    [sym_do_statement] = STATE(327),
    [sym_try_statement] = STATE(328),
    [sym_with_statement] = STATE(329),
    [sym_break_statement] = STATE(330),
    [sym_continue_statement] = STATE(331),
    [sym_debugger_statement] = STATE(332),
    [sym_return_statement] = STATE(333),
    [sym_throw_statement] = STATE(334),
    [sym_empty_statement] = STATE(335),
    [sym_labeled_statement] = STATE(336),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [27] = {
    [sym_export_statement] = STATE(279),
    [sym_declaration] = STATE(279),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(279),
    [sym_expression_statement] = STATE(279),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(279),
    [sym_if_statement] = STATE(279),
    [sym_switch_statement] = STATE(279),
    [sym_for_statement] = STATE(279),
    [sym_for_in_statement] = STATE(279),
    [sym_while_statement] = STATE(279),
    [sym_do_statement] = STATE(279),
    [sym_try_statement] = STATE(279),
    [sym_with_statement] = STATE(279),
    [sym_break_statement] = STATE(279),
    [sym_continue_statement] = STATE(279),
    [sym_debugger_statement] = STATE(279),
    [sym_return_statement] = STATE(279),
    [sym_throw_statement] = STATE(279),
    [sym_empty_statement] = STATE(279),
    [sym_labeled_statement] = STATE(279),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [28] = {
    [sym_export_statement] = STATE(313),
    [sym_declaration] = STATE(313),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(313),
    [sym_expression_statement] = STATE(313),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(313),
    [sym_if_statement] = STATE(313),
    [sym_switch_statement] = STATE(313),
    [sym_for_statement] = STATE(313),
    [sym_for_in_statement] = STATE(313),
    [sym_while_statement] = STATE(313),
    [sym_do_statement] = STATE(313),
    [sym_try_statement] = STATE(313),
    [sym_with_statement] = STATE(313),
    [sym_break_statement] = STATE(313),
    [sym_continue_statement] = STATE(313),
    [sym_debugger_statement] = STATE(313),
    [sym_return_statement] = STATE(313),
    [sym_throw_statement] = STATE(313),
    [sym_empty_statement] = STATE(313),
    [sym_labeled_statement] = STATE(313),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [29] = {
    [sym_export_statement] = STATE(263),
    [sym_declaration] = STATE(262),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(261),
    [sym_expression_statement] = STATE(260),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(259),
    [sym_if_statement] = STATE(258),
    [sym_switch_statement] = STATE(257),
    [sym_for_statement] = STATE(295),
    [sym_for_in_statement] = STATE(255),
    [sym_while_statement] = STATE(254),
    [sym_do_statement] = STATE(248),
    [sym_try_statement] = STATE(252),
    [sym_with_statement] = STATE(251),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(249),
    [sym_debugger_statement] = STATE(296),
    [sym_return_statement] = STATE(307),
    [sym_throw_statement] = STATE(270),
    [sym_empty_statement] = STATE(271),
    [sym_labeled_statement] = STATE(272),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(898),
    [sym_identifier] = ACTIONS(306),
    [anon_sym_export] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(312),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(314),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(318),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(320),
    [anon_sym_async] = ACTIONS(322),
    [anon_sym_function] = ACTIONS(324),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(326),
    [anon_sym_get] = ACTIONS(326),
    [anon_sym_set] = ACTIONS(326),
  },
  [30] = {
    [sym_export_statement] = STATE(294),
    [sym_declaration] = STATE(294),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(294),
    [sym_expression_statement] = STATE(294),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(294),
    [sym_if_statement] = STATE(294),
    [sym_switch_statement] = STATE(294),
    [sym_for_statement] = STATE(294),
    [sym_for_in_statement] = STATE(294),
    [sym_while_statement] = STATE(294),
    [sym_do_statement] = STATE(294),
    [sym_try_statement] = STATE(294),
    [sym_with_statement] = STATE(294),
    [sym_break_statement] = STATE(294),
    [sym_continue_statement] = STATE(294),
    [sym_debugger_statement] = STATE(294),
    [sym_return_statement] = STATE(294),
    [sym_throw_statement] = STATE(294),
    [sym_empty_statement] = STATE(294),
    [sym_labeled_statement] = STATE(294),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [31] = {
    [sym_export_statement] = STATE(279),
    [sym_declaration] = STATE(279),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(279),
    [sym_expression_statement] = STATE(279),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(279),
    [sym_if_statement] = STATE(279),
    [sym_switch_statement] = STATE(279),
    [sym_for_statement] = STATE(279),
    [sym_for_in_statement] = STATE(279),
    [sym_while_statement] = STATE(279),
    [sym_do_statement] = STATE(279),
    [sym_try_statement] = STATE(279),
    [sym_with_statement] = STATE(279),
    [sym_break_statement] = STATE(279),
    [sym_continue_statement] = STATE(279),
    [sym_debugger_statement] = STATE(279),
    [sym_return_statement] = STATE(279),
    [sym_throw_statement] = STATE(279),
    [sym_empty_statement] = STATE(279),
    [sym_labeled_statement] = STATE(279),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(898),
    [sym_identifier] = ACTIONS(306),
    [anon_sym_export] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(312),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(314),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(318),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(320),
    [anon_sym_async] = ACTIONS(322),
    [anon_sym_function] = ACTIONS(324),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(326),
    [anon_sym_get] = ACTIONS(326),
    [anon_sym_set] = ACTIONS(326),
  },
  [32] = {
    [sym_export_statement] = STATE(280),
    [sym_declaration] = STATE(280),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(280),
    [sym_expression_statement] = STATE(280),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(280),
    [sym_if_statement] = STATE(280),
    [sym_switch_statement] = STATE(280),
    [sym_for_statement] = STATE(280),
    [sym_for_in_statement] = STATE(280),
    [sym_while_statement] = STATE(280),
    [sym_do_statement] = STATE(280),
    [sym_try_statement] = STATE(280),
    [sym_with_statement] = STATE(280),
    [sym_break_statement] = STATE(280),
    [sym_continue_statement] = STATE(280),
    [sym_debugger_statement] = STATE(280),
    [sym_return_statement] = STATE(280),
    [sym_throw_statement] = STATE(280),
    [sym_empty_statement] = STATE(280),
    [sym_labeled_statement] = STATE(280),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(898),
    [sym_identifier] = ACTIONS(306),
    [anon_sym_export] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(312),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(314),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(318),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(320),
    [anon_sym_async] = ACTIONS(322),
    [anon_sym_function] = ACTIONS(324),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(326),
    [anon_sym_get] = ACTIONS(326),
    [anon_sym_set] = ACTIONS(326),
  },
  [33] = {
    [sym_export_statement] = STATE(1034),
    [sym_declaration] = STATE(1034),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(1034),
    [sym_expression_statement] = STATE(1034),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(1034),
    [sym_if_statement] = STATE(1034),
    [sym_switch_statement] = STATE(1034),
    [sym_for_statement] = STATE(1034),
    [sym_for_in_statement] = STATE(1034),
    [sym_while_statement] = STATE(1034),
    [sym_do_statement] = STATE(1034),
    [sym_try_statement] = STATE(1034),
    [sym_with_statement] = STATE(1034),
    [sym_break_statement] = STATE(1034),
    [sym_continue_statement] = STATE(1034),
    [sym_debugger_statement] = STATE(1034),
    [sym_return_statement] = STATE(1034),
    [sym_throw_statement] = STATE(1034),
    [sym_empty_statement] = STATE(1034),
    [sym_labeled_statement] = STATE(1034),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(898),
    [sym_identifier] = ACTIONS(306),
    [anon_sym_export] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(312),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(314),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(318),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(320),
    [anon_sym_async] = ACTIONS(322),
    [anon_sym_function] = ACTIONS(324),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(326),
    [anon_sym_get] = ACTIONS(326),
    [anon_sym_set] = ACTIONS(326),
  },
  [34] = {
    [sym_export_statement] = STATE(308),
    [sym_declaration] = STATE(308),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(308),
    [sym_expression_statement] = STATE(308),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(308),
    [sym_if_statement] = STATE(308),
    [sym_switch_statement] = STATE(308),
    [sym_for_statement] = STATE(308),
    [sym_for_in_statement] = STATE(308),
    [sym_while_statement] = STATE(308),
    [sym_do_statement] = STATE(308),
    [sym_try_statement] = STATE(308),
    [sym_with_statement] = STATE(308),
    [sym_break_statement] = STATE(308),
    [sym_continue_statement] = STATE(308),
    [sym_debugger_statement] = STATE(308),
    [sym_return_statement] = STATE(308),
    [sym_throw_statement] = STATE(308),
    [sym_empty_statement] = STATE(308),
    [sym_labeled_statement] = STATE(308),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(898),
    [sym_identifier] = ACTIONS(306),
    [anon_sym_export] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(312),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(314),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(318),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(320),
    [anon_sym_async] = ACTIONS(322),
    [anon_sym_function] = ACTIONS(324),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(326),
    [anon_sym_get] = ACTIONS(326),
    [anon_sym_set] = ACTIONS(326),
  },
  [35] = {
    [sym_export_statement] = STATE(314),
    [sym_declaration] = STATE(314),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(314),
    [sym_expression_statement] = STATE(314),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(314),
    [sym_if_statement] = STATE(314),
    [sym_switch_statement] = STATE(314),
    [sym_for_statement] = STATE(314),
    [sym_for_in_statement] = STATE(314),
    [sym_while_statement] = STATE(314),
    [sym_do_statement] = STATE(314),
    [sym_try_statement] = STATE(314),
    [sym_with_statement] = STATE(314),
    [sym_break_statement] = STATE(314),
    [sym_continue_statement] = STATE(314),
    [sym_debugger_statement] = STATE(314),
    [sym_return_statement] = STATE(314),
    [sym_throw_statement] = STATE(314),
    [sym_empty_statement] = STATE(314),
    [sym_labeled_statement] = STATE(314),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(898),
    [sym_identifier] = ACTIONS(306),
    [anon_sym_export] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(312),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(314),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(318),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(320),
    [anon_sym_async] = ACTIONS(322),
    [anon_sym_function] = ACTIONS(324),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(326),
    [anon_sym_get] = ACTIONS(326),
    [anon_sym_set] = ACTIONS(326),
  },
  [36] = {
    [sym_export_statement] = STATE(317),
    [sym_declaration] = STATE(318),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(319),
    [sym_expression_statement] = STATE(320),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(321),
    [sym_if_statement] = STATE(322),
    [sym_switch_statement] = STATE(323),
    [sym_for_statement] = STATE(324),
    [sym_for_in_statement] = STATE(325),
    [sym_while_statement] = STATE(326),
    [sym_do_statement] = STATE(327),
    [sym_try_statement] = STATE(328),
    [sym_with_statement] = STATE(329),
    [sym_break_statement] = STATE(330),
    [sym_continue_statement] = STATE(331),
    [sym_debugger_statement] = STATE(332),
    [sym_return_statement] = STATE(333),
    [sym_throw_statement] = STATE(334),
    [sym_empty_statement] = STATE(335),
    [sym_labeled_statement] = STATE(336),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(898),
    [sym_identifier] = ACTIONS(306),
    [anon_sym_export] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(312),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(314),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(318),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(320),
    [anon_sym_async] = ACTIONS(322),
    [anon_sym_function] = ACTIONS(324),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(326),
    [anon_sym_get] = ACTIONS(326),
    [anon_sym_set] = ACTIONS(326),
  },
  [37] = {
    [sym_export_statement] = STATE(294),
    [sym_declaration] = STATE(294),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(294),
    [sym_expression_statement] = STATE(294),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(294),
    [sym_if_statement] = STATE(294),
    [sym_switch_statement] = STATE(294),
    [sym_for_statement] = STATE(294),
    [sym_for_in_statement] = STATE(294),
    [sym_while_statement] = STATE(294),
    [sym_do_statement] = STATE(294),
    [sym_try_statement] = STATE(294),
    [sym_with_statement] = STATE(294),
    [sym_break_statement] = STATE(294),
    [sym_continue_statement] = STATE(294),
    [sym_debugger_statement] = STATE(294),
    [sym_return_statement] = STATE(294),
    [sym_throw_statement] = STATE(294),
    [sym_empty_statement] = STATE(294),
    [sym_labeled_statement] = STATE(294),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(898),
    [sym_identifier] = ACTIONS(306),
    [anon_sym_export] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(312),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(314),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(318),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(320),
    [anon_sym_async] = ACTIONS(322),
    [anon_sym_function] = ACTIONS(324),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(326),
    [anon_sym_get] = ACTIONS(326),
    [anon_sym_set] = ACTIONS(326),
  },
  [38] = {
    [sym_export_statement] = STATE(308),
    [sym_declaration] = STATE(308),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(308),
    [sym_expression_statement] = STATE(308),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(308),
    [sym_if_statement] = STATE(308),
    [sym_switch_statement] = STATE(308),
    [sym_for_statement] = STATE(308),
    [sym_for_in_statement] = STATE(308),
    [sym_while_statement] = STATE(308),
    [sym_do_statement] = STATE(308),
    [sym_try_statement] = STATE(308),
    [sym_with_statement] = STATE(308),
    [sym_break_statement] = STATE(308),
    [sym_continue_statement] = STATE(308),
    [sym_debugger_statement] = STATE(308),
    [sym_return_statement] = STATE(308),
    [sym_throw_statement] = STATE(308),
    [sym_empty_statement] = STATE(308),
    [sym_labeled_statement] = STATE(308),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [39] = {
    [sym_export_statement] = STATE(314),
    [sym_declaration] = STATE(314),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(314),
    [sym_expression_statement] = STATE(314),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(314),
    [sym_if_statement] = STATE(314),
    [sym_switch_statement] = STATE(314),
    [sym_for_statement] = STATE(314),
    [sym_for_in_statement] = STATE(314),
    [sym_while_statement] = STATE(314),
    [sym_do_statement] = STATE(314),
    [sym_try_statement] = STATE(314),
    [sym_with_statement] = STATE(314),
    [sym_break_statement] = STATE(314),
    [sym_continue_statement] = STATE(314),
    [sym_debugger_statement] = STATE(314),
    [sym_return_statement] = STATE(314),
    [sym_throw_statement] = STATE(314),
    [sym_empty_statement] = STATE(314),
    [sym_labeled_statement] = STATE(314),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [40] = {
    [sym_export_statement] = STATE(263),
    [sym_declaration] = STATE(262),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(261),
    [sym_expression_statement] = STATE(260),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(259),
    [sym_if_statement] = STATE(258),
    [sym_switch_statement] = STATE(257),
    [sym_for_statement] = STATE(295),
    [sym_for_in_statement] = STATE(255),
    [sym_while_statement] = STATE(254),
    [sym_do_statement] = STATE(248),
    [sym_try_statement] = STATE(252),
    [sym_with_statement] = STATE(251),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(249),
    [sym_debugger_statement] = STATE(296),
    [sym_return_statement] = STATE(307),
    [sym_throw_statement] = STATE(270),
    [sym_empty_statement] = STATE(271),
    [sym_labeled_statement] = STATE(272),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [41] = {
    [sym_export_statement] = STATE(280),
    [sym_declaration] = STATE(280),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(280),
    [sym_expression_statement] = STATE(280),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(280),
    [sym_if_statement] = STATE(280),
    [sym_switch_statement] = STATE(280),
    [sym_for_statement] = STATE(280),
    [sym_for_in_statement] = STATE(280),
    [sym_while_statement] = STATE(280),
    [sym_do_statement] = STATE(280),
    [sym_try_statement] = STATE(280),
    [sym_with_statement] = STATE(280),
    [sym_break_statement] = STATE(280),
    [sym_continue_statement] = STATE(280),
    [sym_debugger_statement] = STATE(280),
    [sym_return_statement] = STATE(280),
    [sym_throw_statement] = STATE(280),
    [sym_empty_statement] = STATE(280),
    [sym_labeled_statement] = STATE(280),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(918),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [42] = {
    [sym_export_statement] = STATE(1378),
    [sym_declaration] = STATE(1378),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(1378),
    [sym_expression_statement] = STATE(1378),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(1378),
    [sym_if_statement] = STATE(1378),
    [sym_switch_statement] = STATE(1378),
    [sym_for_statement] = STATE(1378),
    [sym_for_in_statement] = STATE(1378),
    [sym_while_statement] = STATE(1378),
    [sym_do_statement] = STATE(1378),
    [sym_try_statement] = STATE(1378),
    [sym_with_statement] = STATE(1378),
    [sym_break_statement] = STATE(1378),
    [sym_continue_statement] = STATE(1378),
    [sym_debugger_statement] = STATE(1378),
    [sym_return_statement] = STATE(1378),
    [sym_throw_statement] = STATE(1378),
    [sym_empty_statement] = STATE(1378),
    [sym_labeled_statement] = STATE(1378),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(898),
    [sym_identifier] = ACTIONS(306),
    [anon_sym_export] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(312),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(314),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(318),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(320),
    [anon_sym_async] = ACTIONS(322),
    [anon_sym_function] = ACTIONS(324),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(326),
    [anon_sym_get] = ACTIONS(326),
    [anon_sym_set] = ACTIONS(326),
  },
  [43] = {
    [sym_export_statement] = STATE(313),
    [sym_declaration] = STATE(313),
    [sym_import] = STATE(575),
    [sym_import_statement] = STATE(313),
    [sym_expression_statement] = STATE(313),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_statement_block] = STATE(313),
    [sym_if_statement] = STATE(313),
    [sym_switch_statement] = STATE(313),
    [sym_for_statement] = STATE(313),
    [sym_for_in_statement] = STATE(313),
    [sym_while_statement] = STATE(313),
    [sym_do_statement] = STATE(313),
    [sym_try_statement] = STATE(313),
    [sym_with_statement] = STATE(313),
    [sym_break_statement] = STATE(313),
    [sym_continue_statement] = STATE(313),
    [sym_debugger_statement] = STATE(313),
    [sym_return_statement] = STATE(313),
    [sym_throw_statement] = STATE(313),
    [sym_empty_statement] = STATE(313),
    [sym_labeled_statement] = STATE(313),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(898),
    [sym_identifier] = ACTIONS(306),
    [anon_sym_export] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(312),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(314),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(318),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(320),
    [anon_sym_async] = ACTIONS(322),
    [anon_sym_function] = ACTIONS(324),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(326),
    [anon_sym_get] = ACTIONS(326),
    [anon_sym_set] = ACTIONS(326),
  },
  [44] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(403),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_STAR] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_COMMA] = ACTIONS(336),
    [anon_sym_RBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_RPAREN] = ACTIONS(336),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_in] = ACTIONS(344),
    [anon_sym_COLON] = ACTIONS(336),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_RBRACK] = ACTIONS(336),
    [anon_sym_LT] = ACTIONS(350),
    [anon_sym_GT] = ACTIONS(344),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_DOT] = ACTIONS(344),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_QMARK_DOT] = ACTIONS(336),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_QMARK] = ACTIONS(344),
    [anon_sym_AMP_AMP] = ACTIONS(336),
    [anon_sym_PIPE_PIPE] = ACTIONS(336),
    [anon_sym_GT_GT] = ACTIONS(344),
    [anon_sym_GT_GT_GT] = ACTIONS(336),
    [anon_sym_LT_LT] = ACTIONS(336),
    [anon_sym_AMP] = ACTIONS(344),
    [anon_sym_CARET] = ACTIONS(336),
    [anon_sym_PIPE] = ACTIONS(344),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_PERCENT] = ACTIONS(336),
    [anon_sym_STAR_STAR] = ACTIONS(336),
    [anon_sym_LT_EQ] = ACTIONS(336),
    [anon_sym_EQ_EQ] = ACTIONS(344),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(336),
    [anon_sym_BANG_EQ] = ACTIONS(344),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(336),
    [anon_sym_GT_EQ] = ACTIONS(336),
    [anon_sym_QMARK_QMARK] = ACTIONS(336),
    [anon_sym_instanceof] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(362),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [45] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(455),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_STAR] = ACTIONS(386),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_COMMA] = ACTIONS(336),
    [anon_sym_RBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_in] = ACTIONS(344),
    [anon_sym_SEMI] = ACTIONS(336),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(392),
    [anon_sym_GT] = ACTIONS(344),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_DOT] = ACTIONS(344),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_QMARK_DOT] = ACTIONS(336),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(344),
    [anon_sym_AMP_AMP] = ACTIONS(336),
    [anon_sym_PIPE_PIPE] = ACTIONS(336),
    [anon_sym_GT_GT] = ACTIONS(344),
    [anon_sym_GT_GT_GT] = ACTIONS(336),
    [anon_sym_LT_LT] = ACTIONS(336),
    [anon_sym_AMP] = ACTIONS(344),
    [anon_sym_CARET] = ACTIONS(336),
    [anon_sym_PIPE] = ACTIONS(344),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_PERCENT] = ACTIONS(336),
    [anon_sym_STAR_STAR] = ACTIONS(336),
    [anon_sym_LT_EQ] = ACTIONS(336),
    [anon_sym_EQ_EQ] = ACTIONS(344),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(336),
    [anon_sym_BANG_EQ] = ACTIONS(344),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(336),
    [anon_sym_GT_EQ] = ACTIONS(336),
    [anon_sym_QMARK_QMARK] = ACTIONS(336),
    [anon_sym_instanceof] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
    [sym__automatic_semicolon] = ACTIONS(336),
  },
  [46] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(625),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_STAR] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_in] = ACTIONS(344),
    [anon_sym_COLON] = ACTIONS(336),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(350),
    [anon_sym_GT] = ACTIONS(344),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_DOT] = ACTIONS(344),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_QMARK_DOT] = ACTIONS(336),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_QMARK] = ACTIONS(344),
    [anon_sym_AMP_AMP] = ACTIONS(336),
    [anon_sym_PIPE_PIPE] = ACTIONS(336),
    [anon_sym_GT_GT] = ACTIONS(344),
    [anon_sym_GT_GT_GT] = ACTIONS(336),
    [anon_sym_LT_LT] = ACTIONS(336),
    [anon_sym_AMP] = ACTIONS(344),
    [anon_sym_CARET] = ACTIONS(336),
    [anon_sym_PIPE] = ACTIONS(344),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_PERCENT] = ACTIONS(336),
    [anon_sym_STAR_STAR] = ACTIONS(336),
    [anon_sym_LT_EQ] = ACTIONS(336),
    [anon_sym_EQ_EQ] = ACTIONS(344),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(336),
    [anon_sym_BANG_EQ] = ACTIONS(344),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(336),
    [anon_sym_GT_EQ] = ACTIONS(336),
    [anon_sym_QMARK_QMARK] = ACTIONS(336),
    [anon_sym_instanceof] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(418),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [47] = {
    [ts_builtin_sym_end] = ACTIONS(428),
    [sym_identifier] = ACTIONS(430),
    [anon_sym_export] = ACTIONS(430),
    [anon_sym_STAR] = ACTIONS(432),
    [anon_sym_default] = ACTIONS(430),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_COMMA] = ACTIONS(434),
    [anon_sym_RBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(430),
    [anon_sym_var] = ACTIONS(430),
    [anon_sym_let] = ACTIONS(430),
    [anon_sym_const] = ACTIONS(430),
    [anon_sym_else] = ACTIONS(430),
    [anon_sym_if] = ACTIONS(430),
    [anon_sym_switch] = ACTIONS(430),
    [anon_sym_for] = ACTIONS(430),
    [anon_sym_LPAREN] = ACTIONS(428),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_in] = ACTIONS(432),
    [anon_sym_while] = ACTIONS(430),
    [anon_sym_do] = ACTIONS(430),
    [anon_sym_try] = ACTIONS(430),
    [anon_sym_with] = ACTIONS(430),
    [anon_sym_break] = ACTIONS(430),
    [anon_sym_continue] = ACTIONS(430),
    [anon_sym_debugger] = ACTIONS(430),
    [anon_sym_return] = ACTIONS(430),
    [anon_sym_throw] = ACTIONS(430),
    [anon_sym_SEMI] = ACTIONS(428),
    [anon_sym_case] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(430),
    [anon_sym_EQ] = ACTIONS(436),
    [anon_sym_LBRACK] = ACTIONS(428),
    [anon_sym_LT] = ACTIONS(430),
    [anon_sym_GT] = ACTIONS(432),
    [anon_sym_SLASH] = ACTIONS(430),
    [anon_sym_DOT] = ACTIONS(432),
    [anon_sym_class] = ACTIONS(430),
    [anon_sym_async] = ACTIONS(430),
    [anon_sym_function] = ACTIONS(430),
    [anon_sym_QMARK_DOT] = ACTIONS(434),
    [anon_sym_new] = ACTIONS(430),
    [anon_sym_QMARK] = ACTIONS(432),
    [anon_sym_AMP_AMP] = ACTIONS(434),
    [anon_sym_PIPE_PIPE] = ACTIONS(434),
    [anon_sym_GT_GT] = ACTIONS(432),
    [anon_sym_GT_GT_GT] = ACTIONS(434),
    [anon_sym_LT_LT] = ACTIONS(434),
    [anon_sym_AMP] = ACTIONS(432),
    [anon_sym_CARET] = ACTIONS(434),
    [anon_sym_PIPE] = ACTIONS(432),
    [anon_sym_PLUS] = ACTIONS(430),
    [anon_sym_DASH] = ACTIONS(430),
    [anon_sym_PERCENT] = ACTIONS(434),
    [anon_sym_STAR_STAR] = ACTIONS(434),
    [anon_sym_LT_EQ] = ACTIONS(434),
    [anon_sym_EQ_EQ] = ACTIONS(432),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(434),
    [anon_sym_BANG_EQ] = ACTIONS(432),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(434),
    [anon_sym_GT_EQ] = ACTIONS(434),
    [anon_sym_QMARK_QMARK] = ACTIONS(434),
    [anon_sym_instanceof] = ACTIONS(432),
    [anon_sym_BANG] = ACTIONS(430),
    [anon_sym_TILDE] = ACTIONS(428),
    [anon_sym_typeof] = ACTIONS(430),
    [anon_sym_void] = ACTIONS(430),
    [anon_sym_delete] = ACTIONS(430),
    [anon_sym_PLUS_PLUS] = ACTIONS(428),
    [anon_sym_DASH_DASH] = ACTIONS(428),
    [anon_sym_DQUOTE] = ACTIONS(428),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(428),
    [sym_number] = ACTIONS(428),
    [sym_this] = ACTIONS(430),
    [sym_super] = ACTIONS(430),
    [sym_true] = ACTIONS(430),
    [sym_false] = ACTIONS(430),
    [sym_null] = ACTIONS(430),
    [sym_undefined] = ACTIONS(430),
    [anon_sym_AT] = ACTIONS(428),
    [anon_sym_static] = ACTIONS(430),
    [anon_sym_get] = ACTIONS(430),
    [anon_sym_set] = ACTIONS(430),
    [sym__automatic_semicolon] = ACTIONS(438),
  },
  [48] = {
    [ts_builtin_sym_end] = ACTIONS(440),
    [sym_identifier] = ACTIONS(442),
    [anon_sym_export] = ACTIONS(442),
    [anon_sym_STAR] = ACTIONS(442),
    [anon_sym_default] = ACTIONS(442),
    [anon_sym_LBRACE] = ACTIONS(440),
    [anon_sym_COMMA] = ACTIONS(440),
    [anon_sym_RBRACE] = ACTIONS(440),
    [anon_sym_import] = ACTIONS(442),
    [anon_sym_var] = ACTIONS(442),
    [anon_sym_let] = ACTIONS(442),
    [anon_sym_const] = ACTIONS(442),
    [anon_sym_else] = ACTIONS(442),
    [anon_sym_if] = ACTIONS(442),
    [anon_sym_switch] = ACTIONS(442),
    [anon_sym_for] = ACTIONS(442),
    [anon_sym_LPAREN] = ACTIONS(440),
    [anon_sym_await] = ACTIONS(442),
    [anon_sym_in] = ACTIONS(442),
    [anon_sym_while] = ACTIONS(442),
    [anon_sym_do] = ACTIONS(442),
    [anon_sym_try] = ACTIONS(442),
    [anon_sym_with] = ACTIONS(442),
    [anon_sym_break] = ACTIONS(442),
    [anon_sym_continue] = ACTIONS(442),
    [anon_sym_debugger] = ACTIONS(442),
    [anon_sym_return] = ACTIONS(442),
    [anon_sym_throw] = ACTIONS(442),
    [anon_sym_SEMI] = ACTIONS(440),
    [anon_sym_case] = ACTIONS(442),
    [anon_sym_yield] = ACTIONS(442),
    [anon_sym_LBRACK] = ACTIONS(440),
    [anon_sym_LT] = ACTIONS(442),
    [anon_sym_GT] = ACTIONS(442),
    [anon_sym_SLASH] = ACTIONS(442),
    [anon_sym_DOT] = ACTIONS(442),
    [anon_sym_class] = ACTIONS(442),
    [anon_sym_async] = ACTIONS(442),
    [anon_sym_function] = ACTIONS(442),
    [anon_sym_QMARK_DOT] = ACTIONS(440),
    [anon_sym_new] = ACTIONS(442),
    [anon_sym_QMARK] = ACTIONS(442),
    [anon_sym_AMP_AMP] = ACTIONS(440),
    [anon_sym_PIPE_PIPE] = ACTIONS(440),
    [anon_sym_GT_GT] = ACTIONS(442),
    [anon_sym_GT_GT_GT] = ACTIONS(440),
    [anon_sym_LT_LT] = ACTIONS(440),
    [anon_sym_AMP] = ACTIONS(442),
    [anon_sym_CARET] = ACTIONS(440),
    [anon_sym_PIPE] = ACTIONS(442),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_PERCENT] = ACTIONS(440),
    [anon_sym_STAR_STAR] = ACTIONS(440),
    [anon_sym_LT_EQ] = ACTIONS(440),
    [anon_sym_EQ_EQ] = ACTIONS(442),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(440),
    [anon_sym_BANG_EQ] = ACTIONS(442),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(440),
    [anon_sym_GT_EQ] = ACTIONS(440),
    [anon_sym_QMARK_QMARK] = ACTIONS(440),
    [anon_sym_instanceof] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(440),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(440),
    [anon_sym_DASH_DASH] = ACTIONS(440),
    [anon_sym_DQUOTE] = ACTIONS(440),
    [anon_sym_SQUOTE] = ACTIONS(440),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [sym_number] = ACTIONS(440),
    [sym_this] = ACTIONS(442),
    [sym_super] = ACTIONS(442),
    [sym_true] = ACTIONS(442),
    [sym_false] = ACTIONS(442),
    [sym_null] = ACTIONS(442),
    [sym_undefined] = ACTIONS(442),
    [anon_sym_AT] = ACTIONS(440),
    [anon_sym_static] = ACTIONS(442),
    [anon_sym_get] = ACTIONS(442),
    [anon_sym_set] = ACTIONS(442),
    [sym__automatic_semicolon] = ACTIONS(444),
  },
  [49] = {
    [ts_builtin_sym_end] = ACTIONS(428),
    [sym_identifier] = ACTIONS(430),
    [anon_sym_export] = ACTIONS(430),
    [anon_sym_STAR] = ACTIONS(430),
    [anon_sym_default] = ACTIONS(430),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_COMMA] = ACTIONS(428),
    [anon_sym_RBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(430),
    [anon_sym_var] = ACTIONS(430),
    [anon_sym_let] = ACTIONS(430),
    [anon_sym_const] = ACTIONS(430),
    [anon_sym_else] = ACTIONS(430),
    [anon_sym_if] = ACTIONS(430),
    [anon_sym_switch] = ACTIONS(430),
    [anon_sym_for] = ACTIONS(430),
    [anon_sym_LPAREN] = ACTIONS(428),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_in] = ACTIONS(430),
    [anon_sym_while] = ACTIONS(430),
    [anon_sym_do] = ACTIONS(430),
    [anon_sym_try] = ACTIONS(430),
    [anon_sym_with] = ACTIONS(430),
    [anon_sym_break] = ACTIONS(430),
    [anon_sym_continue] = ACTIONS(430),
    [anon_sym_debugger] = ACTIONS(430),
    [anon_sym_return] = ACTIONS(430),
    [anon_sym_throw] = ACTIONS(430),
    [anon_sym_SEMI] = ACTIONS(428),
    [anon_sym_case] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(430),
    [anon_sym_LBRACK] = ACTIONS(428),
    [anon_sym_LT] = ACTIONS(430),
    [anon_sym_GT] = ACTIONS(430),
    [anon_sym_SLASH] = ACTIONS(430),
    [anon_sym_DOT] = ACTIONS(430),
    [anon_sym_class] = ACTIONS(430),
    [anon_sym_async] = ACTIONS(430),
    [anon_sym_function] = ACTIONS(430),
    [anon_sym_QMARK_DOT] = ACTIONS(428),
    [anon_sym_new] = ACTIONS(430),
    [anon_sym_QMARK] = ACTIONS(430),
    [anon_sym_AMP_AMP] = ACTIONS(428),
    [anon_sym_PIPE_PIPE] = ACTIONS(428),
    [anon_sym_GT_GT] = ACTIONS(430),
    [anon_sym_GT_GT_GT] = ACTIONS(428),
    [anon_sym_LT_LT] = ACTIONS(428),
    [anon_sym_AMP] = ACTIONS(430),
    [anon_sym_CARET] = ACTIONS(428),
    [anon_sym_PIPE] = ACTIONS(430),
    [anon_sym_PLUS] = ACTIONS(430),
    [anon_sym_DASH] = ACTIONS(430),
    [anon_sym_PERCENT] = ACTIONS(428),
    [anon_sym_STAR_STAR] = ACTIONS(428),
    [anon_sym_LT_EQ] = ACTIONS(428),
    [anon_sym_EQ_EQ] = ACTIONS(430),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(428),
    [anon_sym_BANG_EQ] = ACTIONS(430),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(428),
    [anon_sym_GT_EQ] = ACTIONS(428),
    [anon_sym_QMARK_QMARK] = ACTIONS(428),
    [anon_sym_instanceof] = ACTIONS(430),
    [anon_sym_BANG] = ACTIONS(430),
    [anon_sym_TILDE] = ACTIONS(428),
    [anon_sym_typeof] = ACTIONS(430),
    [anon_sym_void] = ACTIONS(430),
    [anon_sym_delete] = ACTIONS(430),
    [anon_sym_PLUS_PLUS] = ACTIONS(428),
    [anon_sym_DASH_DASH] = ACTIONS(428),
    [anon_sym_DQUOTE] = ACTIONS(428),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(428),
    [sym_number] = ACTIONS(428),
    [sym_this] = ACTIONS(430),
    [sym_super] = ACTIONS(430),
    [sym_true] = ACTIONS(430),
    [sym_false] = ACTIONS(430),
    [sym_null] = ACTIONS(430),
    [sym_undefined] = ACTIONS(430),
    [anon_sym_AT] = ACTIONS(428),
    [anon_sym_static] = ACTIONS(430),
    [anon_sym_get] = ACTIONS(430),
    [anon_sym_set] = ACTIONS(430),
    [sym__automatic_semicolon] = ACTIONS(446),
  },
  [50] = {
    [ts_builtin_sym_end] = ACTIONS(448),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(450),
    [anon_sym_STAR] = ACTIONS(452),
    [anon_sym_default] = ACTIONS(450),
    [anon_sym_LBRACE] = ACTIONS(448),
    [anon_sym_COMMA] = ACTIONS(454),
    [anon_sym_RBRACE] = ACTIONS(448),
    [anon_sym_import] = ACTIONS(450),
    [anon_sym_var] = ACTIONS(450),
    [anon_sym_let] = ACTIONS(450),
    [anon_sym_const] = ACTIONS(450),
    [anon_sym_else] = ACTIONS(450),
    [anon_sym_if] = ACTIONS(450),
    [anon_sym_switch] = ACTIONS(450),
    [anon_sym_for] = ACTIONS(450),
    [anon_sym_LPAREN] = ACTIONS(448),
    [anon_sym_await] = ACTIONS(450),
    [anon_sym_in] = ACTIONS(452),
    [anon_sym_while] = ACTIONS(450),
    [anon_sym_do] = ACTIONS(450),
    [anon_sym_try] = ACTIONS(450),
    [anon_sym_with] = ACTIONS(450),
    [anon_sym_break] = ACTIONS(450),
    [anon_sym_continue] = ACTIONS(450),
    [anon_sym_debugger] = ACTIONS(450),
    [anon_sym_return] = ACTIONS(450),
    [anon_sym_throw] = ACTIONS(450),
    [anon_sym_SEMI] = ACTIONS(448),
    [anon_sym_case] = ACTIONS(450),
    [anon_sym_yield] = ACTIONS(450),
    [anon_sym_LBRACK] = ACTIONS(448),
    [anon_sym_LT] = ACTIONS(450),
    [anon_sym_GT] = ACTIONS(452),
    [anon_sym_SLASH] = ACTIONS(450),
    [anon_sym_DOT] = ACTIONS(452),
    [anon_sym_class] = ACTIONS(450),
    [anon_sym_async] = ACTIONS(450),
    [anon_sym_function] = ACTIONS(450),
    [anon_sym_QMARK_DOT] = ACTIONS(454),
    [anon_sym_new] = ACTIONS(450),
    [anon_sym_QMARK] = ACTIONS(452),
    [anon_sym_AMP_AMP] = ACTIONS(454),
    [anon_sym_PIPE_PIPE] = ACTIONS(454),
    [anon_sym_GT_GT] = ACTIONS(452),
    [anon_sym_GT_GT_GT] = ACTIONS(454),
    [anon_sym_LT_LT] = ACTIONS(454),
    [anon_sym_AMP] = ACTIONS(452),
    [anon_sym_CARET] = ACTIONS(454),
    [anon_sym_PIPE] = ACTIONS(452),
    [anon_sym_PLUS] = ACTIONS(450),
    [anon_sym_DASH] = ACTIONS(450),
    [anon_sym_PERCENT] = ACTIONS(454),
    [anon_sym_STAR_STAR] = ACTIONS(454),
    [anon_sym_LT_EQ] = ACTIONS(454),
    [anon_sym_EQ_EQ] = ACTIONS(452),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(454),
    [anon_sym_BANG_EQ] = ACTIONS(452),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(454),
    [anon_sym_GT_EQ] = ACTIONS(454),
    [anon_sym_QMARK_QMARK] = ACTIONS(454),
    [anon_sym_instanceof] = ACTIONS(452),
    [anon_sym_BANG] = ACTIONS(450),
    [anon_sym_TILDE] = ACTIONS(448),
    [anon_sym_typeof] = ACTIONS(450),
    [anon_sym_void] = ACTIONS(450),
    [anon_sym_delete] = ACTIONS(450),
    [anon_sym_PLUS_PLUS] = ACTIONS(448),
    [anon_sym_DASH_DASH] = ACTIONS(448),
    [anon_sym_DQUOTE] = ACTIONS(448),
    [anon_sym_SQUOTE] = ACTIONS(448),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(448),
    [sym_number] = ACTIONS(448),
    [sym_this] = ACTIONS(450),
    [sym_super] = ACTIONS(450),
    [sym_true] = ACTIONS(450),
    [sym_false] = ACTIONS(450),
    [sym_null] = ACTIONS(450),
    [sym_undefined] = ACTIONS(450),
    [anon_sym_AT] = ACTIONS(448),
    [anon_sym_static] = ACTIONS(450),
    [anon_sym_get] = ACTIONS(450),
    [anon_sym_set] = ACTIONS(450),
    [sym__automatic_semicolon] = ACTIONS(456),
  },
  [51] = {
    [ts_builtin_sym_end] = ACTIONS(458),
    [sym_identifier] = ACTIONS(460),
    [anon_sym_export] = ACTIONS(460),
    [anon_sym_STAR] = ACTIONS(462),
    [anon_sym_default] = ACTIONS(460),
    [anon_sym_LBRACE] = ACTIONS(458),
    [anon_sym_COMMA] = ACTIONS(464),
    [anon_sym_RBRACE] = ACTIONS(458),
    [anon_sym_import] = ACTIONS(460),
    [anon_sym_var] = ACTIONS(460),
    [anon_sym_let] = ACTIONS(460),
    [anon_sym_const] = ACTIONS(460),
    [anon_sym_else] = ACTIONS(460),
    [anon_sym_if] = ACTIONS(460),
    [anon_sym_switch] = ACTIONS(460),
    [anon_sym_for] = ACTIONS(460),
    [anon_sym_LPAREN] = ACTIONS(458),
    [anon_sym_await] = ACTIONS(460),
    [anon_sym_in] = ACTIONS(462),
    [anon_sym_while] = ACTIONS(460),
    [anon_sym_do] = ACTIONS(460),
    [anon_sym_try] = ACTIONS(460),
    [anon_sym_with] = ACTIONS(460),
    [anon_sym_break] = ACTIONS(460),
    [anon_sym_continue] = ACTIONS(460),
    [anon_sym_debugger] = ACTIONS(460),
    [anon_sym_return] = ACTIONS(460),
    [anon_sym_throw] = ACTIONS(460),
    [anon_sym_SEMI] = ACTIONS(458),
    [anon_sym_case] = ACTIONS(460),
    [anon_sym_yield] = ACTIONS(460),
    [anon_sym_LBRACK] = ACTIONS(458),
    [anon_sym_LT] = ACTIONS(460),
    [anon_sym_GT] = ACTIONS(462),
    [anon_sym_SLASH] = ACTIONS(460),
    [anon_sym_DOT] = ACTIONS(462),
    [anon_sym_class] = ACTIONS(460),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(460),
    [anon_sym_QMARK_DOT] = ACTIONS(464),
    [anon_sym_new] = ACTIONS(460),
    [anon_sym_QMARK] = ACTIONS(462),
    [anon_sym_AMP_AMP] = ACTIONS(464),
    [anon_sym_PIPE_PIPE] = ACTIONS(464),
    [anon_sym_GT_GT] = ACTIONS(462),
    [anon_sym_GT_GT_GT] = ACTIONS(464),
    [anon_sym_LT_LT] = ACTIONS(464),
    [anon_sym_AMP] = ACTIONS(462),
    [anon_sym_CARET] = ACTIONS(464),
    [anon_sym_PIPE] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(460),
    [anon_sym_DASH] = ACTIONS(460),
    [anon_sym_PERCENT] = ACTIONS(464),
    [anon_sym_STAR_STAR] = ACTIONS(464),
    [anon_sym_LT_EQ] = ACTIONS(464),
    [anon_sym_EQ_EQ] = ACTIONS(462),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(464),
    [anon_sym_BANG_EQ] = ACTIONS(462),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(464),
    [anon_sym_GT_EQ] = ACTIONS(464),
    [anon_sym_QMARK_QMARK] = ACTIONS(464),
    [anon_sym_instanceof] = ACTIONS(462),
    [anon_sym_BANG] = ACTIONS(460),
    [anon_sym_TILDE] = ACTIONS(458),
    [anon_sym_typeof] = ACTIONS(460),
    [anon_sym_void] = ACTIONS(460),
    [anon_sym_delete] = ACTIONS(460),
    [anon_sym_PLUS_PLUS] = ACTIONS(458),
    [anon_sym_DASH_DASH] = ACTIONS(458),
    [anon_sym_DQUOTE] = ACTIONS(458),
    [anon_sym_SQUOTE] = ACTIONS(458),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(458),
    [sym_number] = ACTIONS(458),
    [sym_this] = ACTIONS(460),
    [sym_super] = ACTIONS(460),
    [sym_true] = ACTIONS(460),
    [sym_false] = ACTIONS(460),
    [sym_null] = ACTIONS(460),
    [sym_undefined] = ACTIONS(460),
    [anon_sym_AT] = ACTIONS(458),
    [anon_sym_static] = ACTIONS(460),
    [anon_sym_get] = ACTIONS(460),
    [anon_sym_set] = ACTIONS(460),
    [sym__automatic_semicolon] = ACTIONS(466),
  },
  [52] = {
    [ts_builtin_sym_end] = ACTIONS(468),
    [sym_identifier] = ACTIONS(470),
    [anon_sym_export] = ACTIONS(470),
    [anon_sym_STAR] = ACTIONS(472),
    [anon_sym_default] = ACTIONS(470),
    [anon_sym_LBRACE] = ACTIONS(468),
    [anon_sym_COMMA] = ACTIONS(474),
    [anon_sym_RBRACE] = ACTIONS(468),
    [anon_sym_import] = ACTIONS(470),
    [anon_sym_var] = ACTIONS(470),
    [anon_sym_let] = ACTIONS(470),
    [anon_sym_const] = ACTIONS(470),
    [anon_sym_else] = ACTIONS(470),
    [anon_sym_if] = ACTIONS(470),
    [anon_sym_switch] = ACTIONS(470),
    [anon_sym_for] = ACTIONS(470),
    [anon_sym_LPAREN] = ACTIONS(468),
    [anon_sym_await] = ACTIONS(470),
    [anon_sym_in] = ACTIONS(472),
    [anon_sym_while] = ACTIONS(470),
    [anon_sym_do] = ACTIONS(470),
    [anon_sym_try] = ACTIONS(470),
    [anon_sym_with] = ACTIONS(470),
    [anon_sym_break] = ACTIONS(470),
    [anon_sym_continue] = ACTIONS(470),
    [anon_sym_debugger] = ACTIONS(470),
    [anon_sym_return] = ACTIONS(470),
    [anon_sym_throw] = ACTIONS(470),
    [anon_sym_SEMI] = ACTIONS(468),
    [anon_sym_case] = ACTIONS(470),
    [anon_sym_yield] = ACTIONS(470),
    [anon_sym_LBRACK] = ACTIONS(468),
    [anon_sym_LT] = ACTIONS(470),
    [anon_sym_GT] = ACTIONS(472),
    [anon_sym_SLASH] = ACTIONS(470),
    [anon_sym_DOT] = ACTIONS(472),
    [anon_sym_class] = ACTIONS(470),
    [anon_sym_async] = ACTIONS(470),
    [anon_sym_function] = ACTIONS(470),
    [anon_sym_QMARK_DOT] = ACTIONS(474),
    [anon_sym_new] = ACTIONS(470),
    [anon_sym_QMARK] = ACTIONS(472),
    [anon_sym_AMP_AMP] = ACTIONS(474),
    [anon_sym_PIPE_PIPE] = ACTIONS(474),
    [anon_sym_GT_GT] = ACTIONS(472),
    [anon_sym_GT_GT_GT] = ACTIONS(474),
    [anon_sym_LT_LT] = ACTIONS(474),
    [anon_sym_AMP] = ACTIONS(472),
    [anon_sym_CARET] = ACTIONS(474),
    [anon_sym_PIPE] = ACTIONS(472),
    [anon_sym_PLUS] = ACTIONS(470),
    [anon_sym_DASH] = ACTIONS(470),
    [anon_sym_PERCENT] = ACTIONS(474),
    [anon_sym_STAR_STAR] = ACTIONS(474),
    [anon_sym_LT_EQ] = ACTIONS(474),
    [anon_sym_EQ_EQ] = ACTIONS(472),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(474),
    [anon_sym_BANG_EQ] = ACTIONS(472),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(474),
    [anon_sym_GT_EQ] = ACTIONS(474),
    [anon_sym_QMARK_QMARK] = ACTIONS(474),
    [anon_sym_instanceof] = ACTIONS(472),
    [anon_sym_BANG] = ACTIONS(470),
    [anon_sym_TILDE] = ACTIONS(468),
    [anon_sym_typeof] = ACTIONS(470),
    [anon_sym_void] = ACTIONS(470),
    [anon_sym_delete] = ACTIONS(470),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(468),
    [anon_sym_SQUOTE] = ACTIONS(468),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(468),
    [sym_number] = ACTIONS(468),
    [sym_this] = ACTIONS(470),
    [sym_super] = ACTIONS(470),
    [sym_true] = ACTIONS(470),
    [sym_false] = ACTIONS(470),
    [sym_null] = ACTIONS(470),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(468),
    [anon_sym_static] = ACTIONS(470),
    [anon_sym_get] = ACTIONS(470),
    [anon_sym_set] = ACTIONS(470),
    [sym__automatic_semicolon] = ACTIONS(476),
  },
  [53] = {
    [ts_builtin_sym_end] = ACTIONS(478),
    [sym_identifier] = ACTIONS(480),
    [anon_sym_export] = ACTIONS(480),
    [anon_sym_STAR] = ACTIONS(482),
    [anon_sym_default] = ACTIONS(480),
    [anon_sym_LBRACE] = ACTIONS(478),
    [anon_sym_COMMA] = ACTIONS(484),
    [anon_sym_RBRACE] = ACTIONS(478),
    [anon_sym_import] = ACTIONS(480),
    [anon_sym_var] = ACTIONS(480),
    [anon_sym_let] = ACTIONS(480),
    [anon_sym_const] = ACTIONS(480),
    [anon_sym_else] = ACTIONS(480),
    [anon_sym_if] = ACTIONS(480),
    [anon_sym_switch] = ACTIONS(480),
    [anon_sym_for] = ACTIONS(480),
    [anon_sym_LPAREN] = ACTIONS(478),
    [anon_sym_await] = ACTIONS(480),
    [anon_sym_in] = ACTIONS(482),
    [anon_sym_while] = ACTIONS(480),
    [anon_sym_do] = ACTIONS(480),
    [anon_sym_try] = ACTIONS(480),
    [anon_sym_with] = ACTIONS(480),
    [anon_sym_break] = ACTIONS(480),
    [anon_sym_continue] = ACTIONS(480),
    [anon_sym_debugger] = ACTIONS(480),
    [anon_sym_return] = ACTIONS(480),
    [anon_sym_throw] = ACTIONS(480),
    [anon_sym_SEMI] = ACTIONS(478),
    [anon_sym_case] = ACTIONS(480),
    [anon_sym_yield] = ACTIONS(480),
    [anon_sym_LBRACK] = ACTIONS(478),
    [anon_sym_LT] = ACTIONS(480),
    [anon_sym_GT] = ACTIONS(482),
    [anon_sym_SLASH] = ACTIONS(480),
    [anon_sym_DOT] = ACTIONS(482),
    [anon_sym_class] = ACTIONS(480),
    [anon_sym_async] = ACTIONS(480),
    [anon_sym_function] = ACTIONS(480),
    [anon_sym_QMARK_DOT] = ACTIONS(484),
    [anon_sym_new] = ACTIONS(480),
    [anon_sym_QMARK] = ACTIONS(482),
    [anon_sym_AMP_AMP] = ACTIONS(484),
    [anon_sym_PIPE_PIPE] = ACTIONS(484),
    [anon_sym_GT_GT] = ACTIONS(482),
    [anon_sym_GT_GT_GT] = ACTIONS(484),
    [anon_sym_LT_LT] = ACTIONS(484),
    [anon_sym_AMP] = ACTIONS(482),
    [anon_sym_CARET] = ACTIONS(484),
    [anon_sym_PIPE] = ACTIONS(482),
    [anon_sym_PLUS] = ACTIONS(480),
    [anon_sym_DASH] = ACTIONS(480),
    [anon_sym_PERCENT] = ACTIONS(484),
    [anon_sym_STAR_STAR] = ACTIONS(484),
    [anon_sym_LT_EQ] = ACTIONS(484),
    [anon_sym_EQ_EQ] = ACTIONS(482),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(484),
    [anon_sym_BANG_EQ] = ACTIONS(482),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(484),
    [anon_sym_GT_EQ] = ACTIONS(484),
    [anon_sym_QMARK_QMARK] = ACTIONS(484),
    [anon_sym_instanceof] = ACTIONS(482),
    [anon_sym_BANG] = ACTIONS(480),
    [anon_sym_TILDE] = ACTIONS(478),
    [anon_sym_typeof] = ACTIONS(480),
    [anon_sym_void] = ACTIONS(480),
    [anon_sym_delete] = ACTIONS(480),
    [anon_sym_PLUS_PLUS] = ACTIONS(478),
    [anon_sym_DASH_DASH] = ACTIONS(478),
    [anon_sym_DQUOTE] = ACTIONS(478),
    [anon_sym_SQUOTE] = ACTIONS(478),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(478),
    [sym_number] = ACTIONS(478),
    [sym_this] = ACTIONS(480),
    [sym_super] = ACTIONS(480),
    [sym_true] = ACTIONS(480),
    [sym_false] = ACTIONS(480),
    [sym_null] = ACTIONS(480),
    [sym_undefined] = ACTIONS(480),
    [anon_sym_AT] = ACTIONS(478),
    [anon_sym_static] = ACTIONS(480),
    [anon_sym_get] = ACTIONS(480),
    [anon_sym_set] = ACTIONS(480),
    [sym__automatic_semicolon] = ACTIONS(486),
  },
  [54] = {
    [ts_builtin_sym_end] = ACTIONS(488),
    [sym_identifier] = ACTIONS(490),
    [anon_sym_export] = ACTIONS(490),
    [anon_sym_STAR] = ACTIONS(492),
    [anon_sym_default] = ACTIONS(490),
    [anon_sym_LBRACE] = ACTIONS(488),
    [anon_sym_COMMA] = ACTIONS(494),
    [anon_sym_RBRACE] = ACTIONS(488),
    [anon_sym_import] = ACTIONS(490),
    [anon_sym_var] = ACTIONS(490),
    [anon_sym_let] = ACTIONS(490),
    [anon_sym_const] = ACTIONS(490),
    [anon_sym_else] = ACTIONS(490),
    [anon_sym_if] = ACTIONS(490),
    [anon_sym_switch] = ACTIONS(490),
    [anon_sym_for] = ACTIONS(490),
    [anon_sym_LPAREN] = ACTIONS(488),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_in] = ACTIONS(492),
    [anon_sym_while] = ACTIONS(490),
    [anon_sym_do] = ACTIONS(490),
    [anon_sym_try] = ACTIONS(490),
    [anon_sym_with] = ACTIONS(490),
    [anon_sym_break] = ACTIONS(490),
    [anon_sym_continue] = ACTIONS(490),
    [anon_sym_debugger] = ACTIONS(490),
    [anon_sym_return] = ACTIONS(490),
    [anon_sym_throw] = ACTIONS(490),
    [anon_sym_SEMI] = ACTIONS(488),
    [anon_sym_case] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(490),
    [anon_sym_LBRACK] = ACTIONS(488),
    [anon_sym_LT] = ACTIONS(490),
    [anon_sym_GT] = ACTIONS(492),
    [anon_sym_SLASH] = ACTIONS(490),
    [anon_sym_DOT] = ACTIONS(492),
    [anon_sym_class] = ACTIONS(490),
    [anon_sym_async] = ACTIONS(490),
    [anon_sym_function] = ACTIONS(490),
    [anon_sym_QMARK_DOT] = ACTIONS(494),
    [anon_sym_new] = ACTIONS(490),
    [anon_sym_QMARK] = ACTIONS(492),
    [anon_sym_AMP_AMP] = ACTIONS(494),
    [anon_sym_PIPE_PIPE] = ACTIONS(494),
    [anon_sym_GT_GT] = ACTIONS(492),
    [anon_sym_GT_GT_GT] = ACTIONS(494),
    [anon_sym_LT_LT] = ACTIONS(494),
    [anon_sym_AMP] = ACTIONS(492),
    [anon_sym_CARET] = ACTIONS(494),
    [anon_sym_PIPE] = ACTIONS(492),
    [anon_sym_PLUS] = ACTIONS(490),
    [anon_sym_DASH] = ACTIONS(490),
    [anon_sym_PERCENT] = ACTIONS(494),
    [anon_sym_STAR_STAR] = ACTIONS(494),
    [anon_sym_LT_EQ] = ACTIONS(494),
    [anon_sym_EQ_EQ] = ACTIONS(492),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(494),
    [anon_sym_BANG_EQ] = ACTIONS(492),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(494),
    [anon_sym_GT_EQ] = ACTIONS(494),
    [anon_sym_QMARK_QMARK] = ACTIONS(494),
    [anon_sym_instanceof] = ACTIONS(492),
    [anon_sym_BANG] = ACTIONS(490),
    [anon_sym_TILDE] = ACTIONS(488),
    [anon_sym_typeof] = ACTIONS(490),
    [anon_sym_void] = ACTIONS(490),
    [anon_sym_delete] = ACTIONS(490),
    [anon_sym_PLUS_PLUS] = ACTIONS(488),
    [anon_sym_DASH_DASH] = ACTIONS(488),
    [anon_sym_DQUOTE] = ACTIONS(488),
    [anon_sym_SQUOTE] = ACTIONS(488),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(488),
    [sym_number] = ACTIONS(488),
    [sym_this] = ACTIONS(490),
    [sym_super] = ACTIONS(490),
    [sym_true] = ACTIONS(490),
    [sym_false] = ACTIONS(490),
    [sym_null] = ACTIONS(490),
    [sym_undefined] = ACTIONS(490),
    [anon_sym_AT] = ACTIONS(488),
    [anon_sym_static] = ACTIONS(490),
    [anon_sym_get] = ACTIONS(490),
    [anon_sym_set] = ACTIONS(490),
    [sym__automatic_semicolon] = ACTIONS(496),
  },
  [55] = {
    [ts_builtin_sym_end] = ACTIONS(440),
    [sym_identifier] = ACTIONS(442),
    [anon_sym_export] = ACTIONS(442),
    [anon_sym_STAR] = ACTIONS(442),
    [anon_sym_default] = ACTIONS(442),
    [anon_sym_LBRACE] = ACTIONS(440),
    [anon_sym_COMMA] = ACTIONS(440),
    [anon_sym_RBRACE] = ACTIONS(440),
    [anon_sym_import] = ACTIONS(442),
    [anon_sym_var] = ACTIONS(442),
    [anon_sym_let] = ACTIONS(442),
    [anon_sym_const] = ACTIONS(442),
    [anon_sym_else] = ACTIONS(442),
    [anon_sym_if] = ACTIONS(442),
    [anon_sym_switch] = ACTIONS(442),
    [anon_sym_for] = ACTIONS(442),
    [anon_sym_LPAREN] = ACTIONS(440),
    [anon_sym_await] = ACTIONS(442),
    [anon_sym_in] = ACTIONS(442),
    [anon_sym_while] = ACTIONS(442),
    [anon_sym_do] = ACTIONS(442),
    [anon_sym_try] = ACTIONS(442),
    [anon_sym_with] = ACTIONS(442),
    [anon_sym_break] = ACTIONS(442),
    [anon_sym_continue] = ACTIONS(442),
    [anon_sym_debugger] = ACTIONS(442),
    [anon_sym_return] = ACTIONS(442),
    [anon_sym_throw] = ACTIONS(442),
    [anon_sym_SEMI] = ACTIONS(440),
    [anon_sym_case] = ACTIONS(442),
    [anon_sym_yield] = ACTIONS(442),
    [anon_sym_LBRACK] = ACTIONS(440),
    [anon_sym_LT] = ACTIONS(442),
    [anon_sym_GT] = ACTIONS(442),
    [anon_sym_SLASH] = ACTIONS(442),
    [anon_sym_DOT] = ACTIONS(442),
    [anon_sym_class] = ACTIONS(442),
    [anon_sym_async] = ACTIONS(442),
    [anon_sym_function] = ACTIONS(442),
    [anon_sym_QMARK_DOT] = ACTIONS(440),
    [anon_sym_new] = ACTIONS(442),
    [anon_sym_QMARK] = ACTIONS(442),
    [anon_sym_AMP_AMP] = ACTIONS(440),
    [anon_sym_PIPE_PIPE] = ACTIONS(440),
    [anon_sym_GT_GT] = ACTIONS(442),
    [anon_sym_GT_GT_GT] = ACTIONS(440),
    [anon_sym_LT_LT] = ACTIONS(440),
    [anon_sym_AMP] = ACTIONS(442),
    [anon_sym_CARET] = ACTIONS(440),
    [anon_sym_PIPE] = ACTIONS(442),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_PERCENT] = ACTIONS(440),
    [anon_sym_STAR_STAR] = ACTIONS(440),
    [anon_sym_LT_EQ] = ACTIONS(440),
    [anon_sym_EQ_EQ] = ACTIONS(442),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(440),
    [anon_sym_BANG_EQ] = ACTIONS(442),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(440),
    [anon_sym_GT_EQ] = ACTIONS(440),
    [anon_sym_QMARK_QMARK] = ACTIONS(440),
    [anon_sym_instanceof] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(440),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(440),
    [anon_sym_DASH_DASH] = ACTIONS(440),
    [anon_sym_DQUOTE] = ACTIONS(440),
    [anon_sym_SQUOTE] = ACTIONS(440),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [sym_number] = ACTIONS(440),
    [sym_this] = ACTIONS(442),
    [sym_super] = ACTIONS(442),
    [sym_true] = ACTIONS(442),
    [sym_false] = ACTIONS(442),
    [sym_null] = ACTIONS(442),
    [sym_undefined] = ACTIONS(442),
    [anon_sym_AT] = ACTIONS(440),
    [anon_sym_static] = ACTIONS(442),
    [anon_sym_get] = ACTIONS(442),
    [anon_sym_set] = ACTIONS(442),
    [sym__automatic_semicolon] = ACTIONS(440),
  },
  [56] = {
    [ts_builtin_sym_end] = ACTIONS(498),
    [sym_identifier] = ACTIONS(500),
    [anon_sym_export] = ACTIONS(500),
    [anon_sym_STAR] = ACTIONS(502),
    [anon_sym_default] = ACTIONS(500),
    [anon_sym_LBRACE] = ACTIONS(498),
    [anon_sym_COMMA] = ACTIONS(504),
    [anon_sym_RBRACE] = ACTIONS(498),
    [anon_sym_import] = ACTIONS(500),
    [anon_sym_var] = ACTIONS(500),
    [anon_sym_let] = ACTIONS(500),
    [anon_sym_const] = ACTIONS(500),
    [anon_sym_else] = ACTIONS(500),
    [anon_sym_if] = ACTIONS(500),
    [anon_sym_switch] = ACTIONS(500),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_LPAREN] = ACTIONS(498),
    [anon_sym_await] = ACTIONS(500),
    [anon_sym_in] = ACTIONS(502),
    [anon_sym_while] = ACTIONS(500),
    [anon_sym_do] = ACTIONS(500),
    [anon_sym_try] = ACTIONS(500),
    [anon_sym_with] = ACTIONS(500),
    [anon_sym_break] = ACTIONS(500),
    [anon_sym_continue] = ACTIONS(500),
    [anon_sym_debugger] = ACTIONS(500),
    [anon_sym_return] = ACTIONS(500),
    [anon_sym_throw] = ACTIONS(500),
    [anon_sym_SEMI] = ACTIONS(498),
    [anon_sym_case] = ACTIONS(500),
    [anon_sym_yield] = ACTIONS(500),
    [anon_sym_LBRACK] = ACTIONS(498),
    [anon_sym_LT] = ACTIONS(500),
    [anon_sym_GT] = ACTIONS(502),
    [anon_sym_SLASH] = ACTIONS(500),
    [anon_sym_DOT] = ACTIONS(502),
    [anon_sym_class] = ACTIONS(500),
    [anon_sym_async] = ACTIONS(500),
    [anon_sym_function] = ACTIONS(500),
    [anon_sym_QMARK_DOT] = ACTIONS(504),
    [anon_sym_new] = ACTIONS(500),
    [anon_sym_QMARK] = ACTIONS(502),
    [anon_sym_AMP_AMP] = ACTIONS(504),
    [anon_sym_PIPE_PIPE] = ACTIONS(504),
    [anon_sym_GT_GT] = ACTIONS(502),
    [anon_sym_GT_GT_GT] = ACTIONS(504),
    [anon_sym_LT_LT] = ACTIONS(504),
    [anon_sym_AMP] = ACTIONS(502),
    [anon_sym_CARET] = ACTIONS(504),
    [anon_sym_PIPE] = ACTIONS(502),
    [anon_sym_PLUS] = ACTIONS(500),
    [anon_sym_DASH] = ACTIONS(500),
    [anon_sym_PERCENT] = ACTIONS(504),
    [anon_sym_STAR_STAR] = ACTIONS(504),
    [anon_sym_LT_EQ] = ACTIONS(504),
    [anon_sym_EQ_EQ] = ACTIONS(502),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(504),
    [anon_sym_BANG_EQ] = ACTIONS(502),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(504),
    [anon_sym_GT_EQ] = ACTIONS(504),
    [anon_sym_QMARK_QMARK] = ACTIONS(504),
    [anon_sym_instanceof] = ACTIONS(502),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(498),
    [anon_sym_typeof] = ACTIONS(500),
    [anon_sym_void] = ACTIONS(500),
    [anon_sym_delete] = ACTIONS(500),
    [anon_sym_PLUS_PLUS] = ACTIONS(498),
    [anon_sym_DASH_DASH] = ACTIONS(498),
    [anon_sym_DQUOTE] = ACTIONS(498),
    [anon_sym_SQUOTE] = ACTIONS(498),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(498),
    [sym_number] = ACTIONS(498),
    [sym_this] = ACTIONS(500),
    [sym_super] = ACTIONS(500),
    [sym_true] = ACTIONS(500),
    [sym_false] = ACTIONS(500),
    [sym_null] = ACTIONS(500),
    [sym_undefined] = ACTIONS(500),
    [anon_sym_AT] = ACTIONS(498),
    [anon_sym_static] = ACTIONS(500),
    [anon_sym_get] = ACTIONS(500),
    [anon_sym_set] = ACTIONS(500),
    [sym__automatic_semicolon] = ACTIONS(506),
  },
  [57] = {
    [ts_builtin_sym_end] = ACTIONS(508),
    [sym_identifier] = ACTIONS(510),
    [anon_sym_export] = ACTIONS(510),
    [anon_sym_STAR] = ACTIONS(512),
    [anon_sym_default] = ACTIONS(510),
    [anon_sym_LBRACE] = ACTIONS(508),
    [anon_sym_COMMA] = ACTIONS(514),
    [anon_sym_RBRACE] = ACTIONS(508),
    [anon_sym_import] = ACTIONS(510),
    [anon_sym_var] = ACTIONS(510),
    [anon_sym_let] = ACTIONS(510),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_else] = ACTIONS(510),
    [anon_sym_if] = ACTIONS(510),
    [anon_sym_switch] = ACTIONS(510),
    [anon_sym_for] = ACTIONS(510),
    [anon_sym_LPAREN] = ACTIONS(508),
    [anon_sym_await] = ACTIONS(510),
    [anon_sym_in] = ACTIONS(512),
    [anon_sym_while] = ACTIONS(510),
    [anon_sym_do] = ACTIONS(510),
    [anon_sym_try] = ACTIONS(510),
    [anon_sym_with] = ACTIONS(510),
    [anon_sym_break] = ACTIONS(510),
    [anon_sym_continue] = ACTIONS(510),
    [anon_sym_debugger] = ACTIONS(510),
    [anon_sym_return] = ACTIONS(510),
    [anon_sym_throw] = ACTIONS(510),
    [anon_sym_SEMI] = ACTIONS(508),
    [anon_sym_case] = ACTIONS(510),
    [anon_sym_yield] = ACTIONS(510),
    [anon_sym_LBRACK] = ACTIONS(508),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(512),
    [anon_sym_SLASH] = ACTIONS(510),
    [anon_sym_DOT] = ACTIONS(512),
    [anon_sym_class] = ACTIONS(510),
    [anon_sym_async] = ACTIONS(510),
    [anon_sym_function] = ACTIONS(510),
    [anon_sym_QMARK_DOT] = ACTIONS(514),
    [anon_sym_new] = ACTIONS(510),
    [anon_sym_QMARK] = ACTIONS(512),
    [anon_sym_AMP_AMP] = ACTIONS(514),
    [anon_sym_PIPE_PIPE] = ACTIONS(514),
    [anon_sym_GT_GT] = ACTIONS(512),
    [anon_sym_GT_GT_GT] = ACTIONS(514),
    [anon_sym_LT_LT] = ACTIONS(514),
    [anon_sym_AMP] = ACTIONS(512),
    [anon_sym_CARET] = ACTIONS(514),
    [anon_sym_PIPE] = ACTIONS(512),
    [anon_sym_PLUS] = ACTIONS(510),
    [anon_sym_DASH] = ACTIONS(510),
    [anon_sym_PERCENT] = ACTIONS(514),
    [anon_sym_STAR_STAR] = ACTIONS(514),
    [anon_sym_LT_EQ] = ACTIONS(514),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(514),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(514),
    [anon_sym_GT_EQ] = ACTIONS(514),
    [anon_sym_QMARK_QMARK] = ACTIONS(514),
    [anon_sym_instanceof] = ACTIONS(512),
    [anon_sym_BANG] = ACTIONS(510),
    [anon_sym_TILDE] = ACTIONS(508),
    [anon_sym_typeof] = ACTIONS(510),
    [anon_sym_void] = ACTIONS(510),
    [anon_sym_delete] = ACTIONS(510),
    [anon_sym_PLUS_PLUS] = ACTIONS(508),
    [anon_sym_DASH_DASH] = ACTIONS(508),
    [anon_sym_DQUOTE] = ACTIONS(508),
    [anon_sym_SQUOTE] = ACTIONS(508),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(508),
    [sym_number] = ACTIONS(508),
    [sym_this] = ACTIONS(510),
    [sym_super] = ACTIONS(510),
    [sym_true] = ACTIONS(510),
    [sym_false] = ACTIONS(510),
    [sym_null] = ACTIONS(510),
    [sym_undefined] = ACTIONS(510),
    [anon_sym_AT] = ACTIONS(508),
    [anon_sym_static] = ACTIONS(510),
    [anon_sym_get] = ACTIONS(510),
    [anon_sym_set] = ACTIONS(510),
    [sym__automatic_semicolon] = ACTIONS(516),
  },
  [58] = {
    [ts_builtin_sym_end] = ACTIONS(518),
    [sym_identifier] = ACTIONS(520),
    [anon_sym_export] = ACTIONS(520),
    [anon_sym_STAR] = ACTIONS(520),
    [anon_sym_default] = ACTIONS(520),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_COMMA] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(518),
    [anon_sym_import] = ACTIONS(520),
    [anon_sym_var] = ACTIONS(520),
    [anon_sym_let] = ACTIONS(520),
    [anon_sym_const] = ACTIONS(520),
    [anon_sym_else] = ACTIONS(520),
    [anon_sym_if] = ACTIONS(520),
    [anon_sym_switch] = ACTIONS(520),
    [anon_sym_for] = ACTIONS(520),
    [anon_sym_LPAREN] = ACTIONS(518),
    [anon_sym_await] = ACTIONS(520),
    [anon_sym_in] = ACTIONS(520),
    [anon_sym_while] = ACTIONS(520),
    [anon_sym_do] = ACTIONS(520),
    [anon_sym_try] = ACTIONS(520),
    [anon_sym_with] = ACTIONS(520),
    [anon_sym_break] = ACTIONS(520),
    [anon_sym_continue] = ACTIONS(520),
    [anon_sym_debugger] = ACTIONS(520),
    [anon_sym_return] = ACTIONS(520),
    [anon_sym_throw] = ACTIONS(520),
    [anon_sym_SEMI] = ACTIONS(518),
    [anon_sym_case] = ACTIONS(520),
    [anon_sym_yield] = ACTIONS(520),
    [anon_sym_LBRACK] = ACTIONS(518),
    [anon_sym_LT] = ACTIONS(520),
    [anon_sym_GT] = ACTIONS(520),
    [anon_sym_SLASH] = ACTIONS(520),
    [anon_sym_DOT] = ACTIONS(520),
    [anon_sym_class] = ACTIONS(520),
    [anon_sym_async] = ACTIONS(520),
    [anon_sym_function] = ACTIONS(520),
    [anon_sym_QMARK_DOT] = ACTIONS(518),
    [anon_sym_new] = ACTIONS(520),
    [anon_sym_QMARK] = ACTIONS(520),
    [anon_sym_AMP_AMP] = ACTIONS(518),
    [anon_sym_PIPE_PIPE] = ACTIONS(518),
    [anon_sym_GT_GT] = ACTIONS(520),
    [anon_sym_GT_GT_GT] = ACTIONS(518),
    [anon_sym_LT_LT] = ACTIONS(518),
    [anon_sym_AMP] = ACTIONS(520),
    [anon_sym_CARET] = ACTIONS(518),
    [anon_sym_PIPE] = ACTIONS(520),
    [anon_sym_PLUS] = ACTIONS(520),
    [anon_sym_DASH] = ACTIONS(520),
    [anon_sym_PERCENT] = ACTIONS(518),
    [anon_sym_STAR_STAR] = ACTIONS(518),
    [anon_sym_LT_EQ] = ACTIONS(518),
    [anon_sym_EQ_EQ] = ACTIONS(520),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(518),
    [anon_sym_BANG_EQ] = ACTIONS(520),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(518),
    [anon_sym_GT_EQ] = ACTIONS(518),
    [anon_sym_QMARK_QMARK] = ACTIONS(518),
    [anon_sym_instanceof] = ACTIONS(520),
    [anon_sym_BANG] = ACTIONS(520),
    [anon_sym_TILDE] = ACTIONS(518),
    [anon_sym_typeof] = ACTIONS(520),
    [anon_sym_void] = ACTIONS(520),
    [anon_sym_delete] = ACTIONS(520),
    [anon_sym_PLUS_PLUS] = ACTIONS(518),
    [anon_sym_DASH_DASH] = ACTIONS(518),
    [anon_sym_DQUOTE] = ACTIONS(518),
    [anon_sym_SQUOTE] = ACTIONS(518),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(518),
    [sym_number] = ACTIONS(518),
    [sym_this] = ACTIONS(520),
    [sym_super] = ACTIONS(520),
    [sym_true] = ACTIONS(520),
    [sym_false] = ACTIONS(520),
    [sym_null] = ACTIONS(520),
    [sym_undefined] = ACTIONS(520),
    [anon_sym_AT] = ACTIONS(518),
    [anon_sym_static] = ACTIONS(520),
    [anon_sym_get] = ACTIONS(520),
    [anon_sym_set] = ACTIONS(520),
    [sym__automatic_semicolon] = ACTIONS(518),
  },
  [59] = {
    [ts_builtin_sym_end] = ACTIONS(522),
    [sym_identifier] = ACTIONS(524),
    [anon_sym_export] = ACTIONS(524),
    [anon_sym_STAR] = ACTIONS(526),
    [anon_sym_default] = ACTIONS(524),
    [anon_sym_LBRACE] = ACTIONS(522),
    [anon_sym_COMMA] = ACTIONS(528),
    [anon_sym_RBRACE] = ACTIONS(522),
    [anon_sym_import] = ACTIONS(524),
    [anon_sym_var] = ACTIONS(524),
    [anon_sym_let] = ACTIONS(524),
    [anon_sym_const] = ACTIONS(524),
    [anon_sym_else] = ACTIONS(524),
    [anon_sym_if] = ACTIONS(524),
    [anon_sym_switch] = ACTIONS(524),
    [anon_sym_for] = ACTIONS(524),
    [anon_sym_LPAREN] = ACTIONS(522),
    [anon_sym_await] = ACTIONS(524),
    [anon_sym_in] = ACTIONS(526),
    [anon_sym_while] = ACTIONS(524),
    [anon_sym_do] = ACTIONS(524),
    [anon_sym_try] = ACTIONS(524),
    [anon_sym_with] = ACTIONS(524),
    [anon_sym_break] = ACTIONS(524),
    [anon_sym_continue] = ACTIONS(524),
    [anon_sym_debugger] = ACTIONS(524),
    [anon_sym_return] = ACTIONS(524),
    [anon_sym_throw] = ACTIONS(524),
    [anon_sym_SEMI] = ACTIONS(522),
    [anon_sym_case] = ACTIONS(524),
    [anon_sym_yield] = ACTIONS(524),
    [anon_sym_LBRACK] = ACTIONS(522),
    [anon_sym_LT] = ACTIONS(524),
    [anon_sym_GT] = ACTIONS(526),
    [anon_sym_SLASH] = ACTIONS(524),
    [anon_sym_DOT] = ACTIONS(526),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(524),
    [anon_sym_function] = ACTIONS(524),
    [anon_sym_QMARK_DOT] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(524),
    [anon_sym_QMARK] = ACTIONS(526),
    [anon_sym_AMP_AMP] = ACTIONS(528),
    [anon_sym_PIPE_PIPE] = ACTIONS(528),
    [anon_sym_GT_GT] = ACTIONS(526),
    [anon_sym_GT_GT_GT] = ACTIONS(528),
    [anon_sym_LT_LT] = ACTIONS(528),
    [anon_sym_AMP] = ACTIONS(526),
    [anon_sym_CARET] = ACTIONS(528),
    [anon_sym_PIPE] = ACTIONS(526),
    [anon_sym_PLUS] = ACTIONS(524),
    [anon_sym_DASH] = ACTIONS(524),
    [anon_sym_PERCENT] = ACTIONS(528),
    [anon_sym_STAR_STAR] = ACTIONS(528),
    [anon_sym_LT_EQ] = ACTIONS(528),
    [anon_sym_EQ_EQ] = ACTIONS(526),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(528),
    [anon_sym_BANG_EQ] = ACTIONS(526),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(528),
    [anon_sym_GT_EQ] = ACTIONS(528),
    [anon_sym_QMARK_QMARK] = ACTIONS(528),
    [anon_sym_instanceof] = ACTIONS(526),
    [anon_sym_BANG] = ACTIONS(524),
    [anon_sym_TILDE] = ACTIONS(522),
    [anon_sym_typeof] = ACTIONS(524),
    [anon_sym_void] = ACTIONS(524),
    [anon_sym_delete] = ACTIONS(524),
    [anon_sym_PLUS_PLUS] = ACTIONS(522),
    [anon_sym_DASH_DASH] = ACTIONS(522),
    [anon_sym_DQUOTE] = ACTIONS(522),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(522),
    [sym_number] = ACTIONS(522),
    [sym_this] = ACTIONS(524),
    [sym_super] = ACTIONS(524),
    [sym_true] = ACTIONS(524),
    [sym_false] = ACTIONS(524),
    [sym_null] = ACTIONS(524),
    [sym_undefined] = ACTIONS(524),
    [anon_sym_AT] = ACTIONS(522),
    [anon_sym_static] = ACTIONS(524),
    [anon_sym_get] = ACTIONS(524),
    [anon_sym_set] = ACTIONS(524),
    [sym__automatic_semicolon] = ACTIONS(530),
  },
  [60] = {
    [ts_builtin_sym_end] = ACTIONS(532),
    [sym_identifier] = ACTIONS(534),
    [anon_sym_export] = ACTIONS(534),
    [anon_sym_STAR] = ACTIONS(534),
    [anon_sym_default] = ACTIONS(534),
    [anon_sym_LBRACE] = ACTIONS(532),
    [anon_sym_COMMA] = ACTIONS(532),
    [anon_sym_RBRACE] = ACTIONS(532),
    [anon_sym_import] = ACTIONS(534),
    [anon_sym_var] = ACTIONS(534),
    [anon_sym_let] = ACTIONS(534),
    [anon_sym_const] = ACTIONS(534),
    [anon_sym_else] = ACTIONS(534),
    [anon_sym_if] = ACTIONS(534),
    [anon_sym_switch] = ACTIONS(534),
    [anon_sym_for] = ACTIONS(534),
    [anon_sym_LPAREN] = ACTIONS(532),
    [anon_sym_await] = ACTIONS(534),
    [anon_sym_in] = ACTIONS(534),
    [anon_sym_while] = ACTIONS(534),
    [anon_sym_do] = ACTIONS(534),
    [anon_sym_try] = ACTIONS(534),
    [anon_sym_with] = ACTIONS(534),
    [anon_sym_break] = ACTIONS(534),
    [anon_sym_continue] = ACTIONS(534),
    [anon_sym_debugger] = ACTIONS(534),
    [anon_sym_return] = ACTIONS(534),
    [anon_sym_throw] = ACTIONS(534),
    [anon_sym_SEMI] = ACTIONS(532),
    [anon_sym_case] = ACTIONS(534),
    [anon_sym_yield] = ACTIONS(534),
    [anon_sym_LBRACK] = ACTIONS(532),
    [anon_sym_LT] = ACTIONS(534),
    [anon_sym_GT] = ACTIONS(534),
    [anon_sym_SLASH] = ACTIONS(534),
    [anon_sym_DOT] = ACTIONS(534),
    [anon_sym_class] = ACTIONS(534),
    [anon_sym_async] = ACTIONS(534),
    [anon_sym_function] = ACTIONS(534),
    [anon_sym_QMARK_DOT] = ACTIONS(532),
    [anon_sym_new] = ACTIONS(534),
    [anon_sym_QMARK] = ACTIONS(534),
    [anon_sym_AMP_AMP] = ACTIONS(532),
    [anon_sym_PIPE_PIPE] = ACTIONS(532),
    [anon_sym_GT_GT] = ACTIONS(534),
    [anon_sym_GT_GT_GT] = ACTIONS(532),
    [anon_sym_LT_LT] = ACTIONS(532),
    [anon_sym_AMP] = ACTIONS(534),
    [anon_sym_CARET] = ACTIONS(532),
    [anon_sym_PIPE] = ACTIONS(534),
    [anon_sym_PLUS] = ACTIONS(534),
    [anon_sym_DASH] = ACTIONS(534),
    [anon_sym_PERCENT] = ACTIONS(532),
    [anon_sym_STAR_STAR] = ACTIONS(532),
    [anon_sym_LT_EQ] = ACTIONS(532),
    [anon_sym_EQ_EQ] = ACTIONS(534),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(532),
    [anon_sym_BANG_EQ] = ACTIONS(534),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(532),
    [anon_sym_GT_EQ] = ACTIONS(532),
    [anon_sym_QMARK_QMARK] = ACTIONS(532),
    [anon_sym_instanceof] = ACTIONS(534),
    [anon_sym_BANG] = ACTIONS(534),
    [anon_sym_TILDE] = ACTIONS(532),
    [anon_sym_typeof] = ACTIONS(534),
    [anon_sym_void] = ACTIONS(534),
    [anon_sym_delete] = ACTIONS(534),
    [anon_sym_PLUS_PLUS] = ACTIONS(532),
    [anon_sym_DASH_DASH] = ACTIONS(532),
    [anon_sym_DQUOTE] = ACTIONS(532),
    [anon_sym_SQUOTE] = ACTIONS(532),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(532),
    [sym_number] = ACTIONS(532),
    [sym_this] = ACTIONS(534),
    [sym_super] = ACTIONS(534),
    [sym_true] = ACTIONS(534),
    [sym_false] = ACTIONS(534),
    [sym_null] = ACTIONS(534),
    [sym_undefined] = ACTIONS(534),
    [anon_sym_AT] = ACTIONS(532),
    [anon_sym_static] = ACTIONS(534),
    [anon_sym_get] = ACTIONS(534),
    [anon_sym_set] = ACTIONS(534),
    [sym__automatic_semicolon] = ACTIONS(532),
  },
  [61] = {
    [ts_builtin_sym_end] = ACTIONS(536),
    [sym_identifier] = ACTIONS(538),
    [anon_sym_export] = ACTIONS(538),
    [anon_sym_STAR] = ACTIONS(538),
    [anon_sym_default] = ACTIONS(538),
    [anon_sym_LBRACE] = ACTIONS(536),
    [anon_sym_COMMA] = ACTIONS(536),
    [anon_sym_RBRACE] = ACTIONS(536),
    [anon_sym_import] = ACTIONS(538),
    [anon_sym_var] = ACTIONS(538),
    [anon_sym_let] = ACTIONS(538),
    [anon_sym_const] = ACTIONS(538),
    [anon_sym_else] = ACTIONS(538),
    [anon_sym_if] = ACTIONS(538),
    [anon_sym_switch] = ACTIONS(538),
    [anon_sym_for] = ACTIONS(538),
    [anon_sym_LPAREN] = ACTIONS(536),
    [anon_sym_await] = ACTIONS(538),
    [anon_sym_in] = ACTIONS(538),
    [anon_sym_while] = ACTIONS(538),
    [anon_sym_do] = ACTIONS(538),
    [anon_sym_try] = ACTIONS(538),
    [anon_sym_with] = ACTIONS(538),
    [anon_sym_break] = ACTIONS(538),
    [anon_sym_continue] = ACTIONS(538),
    [anon_sym_debugger] = ACTIONS(538),
    [anon_sym_return] = ACTIONS(538),
    [anon_sym_throw] = ACTIONS(538),
    [anon_sym_SEMI] = ACTIONS(536),
    [anon_sym_case] = ACTIONS(538),
    [anon_sym_yield] = ACTIONS(538),
    [anon_sym_LBRACK] = ACTIONS(536),
    [anon_sym_LT] = ACTIONS(538),
    [anon_sym_GT] = ACTIONS(538),
    [anon_sym_SLASH] = ACTIONS(538),
    [anon_sym_DOT] = ACTIONS(538),
    [anon_sym_class] = ACTIONS(538),
    [anon_sym_async] = ACTIONS(538),
    [anon_sym_function] = ACTIONS(538),
    [anon_sym_QMARK_DOT] = ACTIONS(536),
    [anon_sym_new] = ACTIONS(538),
    [anon_sym_QMARK] = ACTIONS(538),
    [anon_sym_AMP_AMP] = ACTIONS(536),
    [anon_sym_PIPE_PIPE] = ACTIONS(536),
    [anon_sym_GT_GT] = ACTIONS(538),
    [anon_sym_GT_GT_GT] = ACTIONS(536),
    [anon_sym_LT_LT] = ACTIONS(536),
    [anon_sym_AMP] = ACTIONS(538),
    [anon_sym_CARET] = ACTIONS(536),
    [anon_sym_PIPE] = ACTIONS(538),
    [anon_sym_PLUS] = ACTIONS(538),
    [anon_sym_DASH] = ACTIONS(538),
    [anon_sym_PERCENT] = ACTIONS(536),
    [anon_sym_STAR_STAR] = ACTIONS(536),
    [anon_sym_LT_EQ] = ACTIONS(536),
    [anon_sym_EQ_EQ] = ACTIONS(538),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(536),
    [anon_sym_BANG_EQ] = ACTIONS(538),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(536),
    [anon_sym_GT_EQ] = ACTIONS(536),
    [anon_sym_QMARK_QMARK] = ACTIONS(536),
    [anon_sym_instanceof] = ACTIONS(538),
    [anon_sym_BANG] = ACTIONS(538),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_typeof] = ACTIONS(538),
    [anon_sym_void] = ACTIONS(538),
    [anon_sym_delete] = ACTIONS(538),
    [anon_sym_PLUS_PLUS] = ACTIONS(536),
    [anon_sym_DASH_DASH] = ACTIONS(536),
    [anon_sym_DQUOTE] = ACTIONS(536),
    [anon_sym_SQUOTE] = ACTIONS(536),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(536),
    [sym_number] = ACTIONS(536),
    [sym_this] = ACTIONS(538),
    [sym_super] = ACTIONS(538),
    [sym_true] = ACTIONS(538),
    [sym_false] = ACTIONS(538),
    [sym_null] = ACTIONS(538),
    [sym_undefined] = ACTIONS(538),
    [anon_sym_AT] = ACTIONS(536),
    [anon_sym_static] = ACTIONS(538),
    [anon_sym_get] = ACTIONS(538),
    [anon_sym_set] = ACTIONS(538),
    [sym__automatic_semicolon] = ACTIONS(536),
  },
  [62] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(537),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(915),
    [sym_assignment_pattern] = STATE(1075),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(915),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(915),
    [sym_spread_element] = STATE(1058),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [sym_pattern] = STATE(960),
    [sym_rest_pattern] = STATE(922),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [aux_sym_array_repeat1] = STATE(1060),
    [aux_sym_array_pattern_repeat1] = STATE(1053),
    [sym_identifier] = ACTIONS(540),
    [anon_sym_export] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(544),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_RBRACK] = ACTIONS(546),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(550),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(552),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(542),
    [anon_sym_get] = ACTIONS(542),
    [anon_sym_set] = ACTIONS(542),
  },
  [63] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(536),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(915),
    [sym_assignment_pattern] = STATE(1075),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(915),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(915),
    [sym_spread_element] = STATE(1056),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [sym_pattern] = STATE(960),
    [sym_rest_pattern] = STATE(922),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [aux_sym_array_repeat1] = STATE(1054),
    [aux_sym_array_pattern_repeat1] = STATE(1053),
    [sym_identifier] = ACTIONS(540),
    [anon_sym_export] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(544),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_RBRACK] = ACTIONS(554),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(550),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(552),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(542),
    [anon_sym_get] = ACTIONS(542),
    [anon_sym_set] = ACTIONS(542),
  },
  [64] = {
    [sym_declaration] = STATE(337),
    [sym_import] = STATE(575),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(563),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(976),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(320),
    [anon_sym_async] = ACTIONS(556),
    [anon_sym_function] = ACTIONS(324),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [65] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(537),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(915),
    [sym_assignment_pattern] = STATE(1075),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(915),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(915),
    [sym_spread_element] = STATE(1058),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [sym_pattern] = STATE(960),
    [sym_rest_pattern] = STATE(922),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [aux_sym_array_repeat1] = STATE(1060),
    [aux_sym_array_pattern_repeat1] = STATE(1053),
    [sym_identifier] = ACTIONS(540),
    [anon_sym_export] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(544),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_RBRACK] = ACTIONS(558),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(550),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(552),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(542),
    [anon_sym_get] = ACTIONS(542),
    [anon_sym_set] = ACTIONS(542),
  },
  [66] = {
    [sym_import] = STATE(575),
    [sym_expression_statement] = STATE(84),
    [sym_variable_declaration] = STATE(84),
    [sym_lexical_declaration] = STATE(84),
    [sym_empty_statement] = STATE(84),
    [sym_parenthesized_expression] = STATE(373),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1071),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1071),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(373),
    [sym_subscript_expression] = STATE(373),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1071),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_LBRACE] = ACTIONS(564),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_var] = ACTIONS(566),
    [anon_sym_let] = ACTIONS(568),
    [anon_sym_const] = ACTIONS(568),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(570),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(572),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(574),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
  },
  [67] = {
    [sym_declaration] = STATE(277),
    [sym_import] = STATE(575),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(640),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(962),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(576),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [68] = {
    [sym_declaration] = STATE(337),
    [sym_import] = STATE(575),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(563),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(962),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(576),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [69] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(536),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(915),
    [sym_assignment_pattern] = STATE(1075),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(915),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(915),
    [sym_spread_element] = STATE(1056),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [sym_pattern] = STATE(960),
    [sym_rest_pattern] = STATE(922),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [aux_sym_array_repeat1] = STATE(1054),
    [aux_sym_array_pattern_repeat1] = STATE(1053),
    [sym_identifier] = ACTIONS(540),
    [anon_sym_export] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(544),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_RBRACK] = ACTIONS(578),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(550),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(552),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(542),
    [anon_sym_get] = ACTIONS(542),
    [anon_sym_set] = ACTIONS(542),
  },
  [70] = {
    [sym_import] = STATE(575),
    [sym_expression_statement] = STATE(82),
    [sym_variable_declaration] = STATE(82),
    [sym_lexical_declaration] = STATE(82),
    [sym_empty_statement] = STATE(82),
    [sym_parenthesized_expression] = STATE(373),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1071),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1071),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(373),
    [sym_subscript_expression] = STATE(373),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1071),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_LBRACE] = ACTIONS(564),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_var] = ACTIONS(566),
    [anon_sym_let] = ACTIONS(568),
    [anon_sym_const] = ACTIONS(568),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(570),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(572),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(574),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
  },
  [71] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(537),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(915),
    [sym_assignment_pattern] = STATE(1075),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(915),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(915),
    [sym_spread_element] = STATE(1058),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [sym_pattern] = STATE(960),
    [sym_rest_pattern] = STATE(922),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [aux_sym_array_repeat1] = STATE(1060),
    [aux_sym_array_pattern_repeat1] = STATE(1053),
    [sym_identifier] = ACTIONS(540),
    [anon_sym_export] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(544),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_RBRACK] = ACTIONS(580),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(550),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(552),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(542),
    [anon_sym_get] = ACTIONS(542),
    [anon_sym_set] = ACTIONS(542),
  },
  [72] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(540),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(915),
    [sym_assignment_pattern] = STATE(1075),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(915),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(915),
    [sym_spread_element] = STATE(1056),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [sym_pattern] = STATE(960),
    [sym_rest_pattern] = STATE(922),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [aux_sym_array_repeat1] = STATE(1054),
    [aux_sym_array_pattern_repeat1] = STATE(1053),
    [sym_identifier] = ACTIONS(540),
    [anon_sym_export] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(544),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_RBRACK] = ACTIONS(578),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(550),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(552),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(542),
    [anon_sym_get] = ACTIONS(542),
    [anon_sym_set] = ACTIONS(542),
  },
  [73] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(537),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(915),
    [sym_assignment_pattern] = STATE(1075),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(915),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(915),
    [sym_spread_element] = STATE(1058),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [sym_pattern] = STATE(960),
    [sym_rest_pattern] = STATE(922),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [aux_sym_array_repeat1] = STATE(1060),
    [aux_sym_array_pattern_repeat1] = STATE(1053),
    [sym_identifier] = ACTIONS(540),
    [anon_sym_export] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(544),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_RBRACK] = ACTIONS(582),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(550),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(552),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(542),
    [anon_sym_get] = ACTIONS(542),
    [anon_sym_set] = ACTIONS(542),
  },
  [74] = {
    [sym_declaration] = STATE(277),
    [sym_import] = STATE(575),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(640),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_class_declaration] = STATE(276),
    [sym_function] = STATE(575),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function] = STATE(575),
    [sym_generator_function_declaration] = STATE(276),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(976),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(320),
    [anon_sym_async] = ACTIONS(556),
    [anon_sym_function] = ACTIONS(324),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [75] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(647),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(915),
    [sym_assignment_pattern] = STATE(1075),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(915),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(915),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [sym_pattern] = STATE(960),
    [sym_rest_pattern] = STATE(922),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [aux_sym_array_pattern_repeat1] = STATE(1053),
    [sym_identifier] = ACTIONS(584),
    [anon_sym_export] = ACTIONS(586),
    [anon_sym_LBRACE] = ACTIONS(588),
    [anon_sym_COMMA] = ACTIONS(590),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(592),
    [anon_sym_RBRACK] = ACTIONS(594),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(596),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(598),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(586),
    [anon_sym_get] = ACTIONS(586),
    [anon_sym_set] = ACTIONS(586),
  },
  [76] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(516),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(915),
    [sym_assignment_pattern] = STATE(1128),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(915),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(915),
    [sym_spread_element] = STATE(1091),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [sym_pattern] = STATE(1092),
    [sym_rest_pattern] = STATE(922),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(540),
    [anon_sym_export] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(600),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_RBRACK] = ACTIONS(600),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(550),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(552),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(542),
    [anon_sym_get] = ACTIONS(542),
    [anon_sym_set] = ACTIONS(542),
  },
  [77] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(613),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(915),
    [sym_assignment_pattern] = STATE(1086),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(915),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(915),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(1363),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [sym_pattern] = STATE(936),
    [sym_rest_pattern] = STATE(922),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(540),
    [anon_sym_export] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_RPAREN] = ACTIONS(603),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(550),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(598),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(542),
    [anon_sym_get] = ACTIONS(542),
    [anon_sym_set] = ACTIONS(542),
  },
  [78] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(627),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(915),
    [sym_assignment_pattern] = STATE(1086),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(915),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(915),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(1335),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [sym_pattern] = STATE(936),
    [sym_rest_pattern] = STATE(922),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(540),
    [anon_sym_export] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_RPAREN] = ACTIONS(603),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(550),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(598),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(542),
    [anon_sym_get] = ACTIONS(542),
    [anon_sym_set] = ACTIONS(542),
  },
  [79] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(516),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_spread_element] = STATE(1091),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_COMMA] = ACTIONS(605),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_RPAREN] = ACTIONS(605),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_RBRACK] = ACTIONS(605),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(607),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [80] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(524),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_spread_element] = STATE(1101),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [aux_sym_array_repeat1] = STATE(1100),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_COMMA] = ACTIONS(609),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_RPAREN] = ACTIONS(611),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(607),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [81] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(538),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_spread_element] = STATE(1080),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [aux_sym_array_repeat1] = STATE(1079),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_COMMA] = ACTIONS(609),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_RPAREN] = ACTIONS(613),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(607),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [82] = {
    [sym_import] = STATE(575),
    [sym_expression_statement] = STATE(92),
    [sym_empty_statement] = STATE(92),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [83] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(589),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_spread_element] = STATE(1380),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(1380),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_RBRACE] = ACTIONS(615),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(607),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [84] = {
    [sym_import] = STATE(575),
    [sym_expression_statement] = STATE(90),
    [sym_empty_statement] = STATE(90),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1257),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [85] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(616),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(915),
    [sym_assignment_pattern] = STATE(1200),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(915),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(915),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [sym_pattern] = STATE(1006),
    [sym_rest_pattern] = STATE(922),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(540),
    [anon_sym_export] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(550),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(598),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(542),
    [anon_sym_get] = ACTIONS(542),
    [anon_sym_set] = ACTIONS(542),
  },
  [86] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(576),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_spread_element] = STATE(1282),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(1282),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_RBRACE] = ACTIONS(617),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(607),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [87] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(532),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1148),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(619),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
    [sym__automatic_semicolon] = ACTIONS(619),
  },
  [88] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(388),
    [sym_expression] = STATE(655),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1072),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1072),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(388),
    [sym_subscript_expression] = STATE(388),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1072),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(621),
    [anon_sym_export] = ACTIONS(623),
    [anon_sym_LBRACE] = ACTIONS(625),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_var] = ACTIONS(627),
    [anon_sym_let] = ACTIONS(627),
    [anon_sym_const] = ACTIONS(627),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(629),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(631),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(633),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(623),
    [anon_sym_get] = ACTIONS(623),
    [anon_sym_set] = ACTIONS(623),
  },
  [89] = {
    [sym_export_clause] = STATE(941),
    [sym_declaration] = STATE(278),
    [sym_namespace_import] = STATE(1203),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_class_declaration] = STATE(276),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function_declaration] = STATE(276),
    [sym_decorator] = STATE(766),
    [aux_sym_export_statement_repeat1] = STATE(955),
    [aux_sym_object_repeat1] = STATE(1082),
    [aux_sym_object_pattern_repeat1] = STATE(1026),
    [anon_sym_STAR] = ACTIONS(635),
    [anon_sym_default] = ACTIONS(637),
    [anon_sym_LBRACE] = ACTIONS(639),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_RBRACE] = ACTIONS(643),
    [anon_sym_var] = ACTIONS(645),
    [anon_sym_let] = ACTIONS(647),
    [anon_sym_const] = ACTIONS(647),
    [anon_sym_LPAREN] = ACTIONS(649),
    [anon_sym_in] = ACTIONS(652),
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_COLON] = ACTIONS(654),
    [anon_sym_EQ] = ACTIONS(657),
    [anon_sym_LBRACK] = ACTIONS(641),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_GT] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_DOT] = ACTIONS(641),
    [anon_sym_class] = ACTIONS(659),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_EQ_GT] = ACTIONS(665),
    [anon_sym_QMARK_DOT] = ACTIONS(641),
    [anon_sym_PLUS_EQ] = ACTIONS(667),
    [anon_sym_DASH_EQ] = ACTIONS(667),
    [anon_sym_STAR_EQ] = ACTIONS(667),
    [anon_sym_SLASH_EQ] = ACTIONS(667),
    [anon_sym_PERCENT_EQ] = ACTIONS(667),
    [anon_sym_CARET_EQ] = ACTIONS(667),
    [anon_sym_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_LT_LT_EQ] = ACTIONS(667),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(667),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(667),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(667),
    [anon_sym_QMARK] = ACTIONS(652),
    [anon_sym_AMP_AMP] = ACTIONS(652),
    [anon_sym_PIPE_PIPE] = ACTIONS(652),
    [anon_sym_GT_GT] = ACTIONS(652),
    [anon_sym_GT_GT_GT] = ACTIONS(652),
    [anon_sym_LT_LT] = ACTIONS(652),
    [anon_sym_AMP] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(652),
    [anon_sym_PIPE] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_PERCENT] = ACTIONS(652),
    [anon_sym_STAR_STAR] = ACTIONS(652),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(652),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(652),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_QMARK_QMARK] = ACTIONS(652),
    [anon_sym_instanceof] = ACTIONS(641),
    [anon_sym_PLUS_PLUS] = ACTIONS(641),
    [anon_sym_DASH_DASH] = ACTIONS(641),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [anon_sym_AT] = ACTIONS(87),
    [sym__automatic_semicolon] = ACTIONS(641),
  },
  [90] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(634),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(1322),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_RPAREN] = ACTIONS(669),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [91] = {
    [sym_export_clause] = STATE(941),
    [sym_declaration] = STATE(278),
    [sym_namespace_import] = STATE(1203),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_class_declaration] = STATE(276),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function_declaration] = STATE(276),
    [sym_decorator] = STATE(766),
    [aux_sym_export_statement_repeat1] = STATE(955),
    [aux_sym_object_repeat1] = STATE(1082),
    [aux_sym_object_pattern_repeat1] = STATE(1026),
    [anon_sym_STAR] = ACTIONS(635),
    [anon_sym_default] = ACTIONS(637),
    [anon_sym_LBRACE] = ACTIONS(639),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_RBRACE] = ACTIONS(671),
    [anon_sym_var] = ACTIONS(645),
    [anon_sym_let] = ACTIONS(647),
    [anon_sym_const] = ACTIONS(647),
    [anon_sym_LPAREN] = ACTIONS(649),
    [anon_sym_in] = ACTIONS(652),
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_COLON] = ACTIONS(654),
    [anon_sym_EQ] = ACTIONS(657),
    [anon_sym_LBRACK] = ACTIONS(641),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_GT] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_DOT] = ACTIONS(641),
    [anon_sym_class] = ACTIONS(659),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_EQ_GT] = ACTIONS(665),
    [anon_sym_QMARK_DOT] = ACTIONS(641),
    [anon_sym_PLUS_EQ] = ACTIONS(667),
    [anon_sym_DASH_EQ] = ACTIONS(667),
    [anon_sym_STAR_EQ] = ACTIONS(667),
    [anon_sym_SLASH_EQ] = ACTIONS(667),
    [anon_sym_PERCENT_EQ] = ACTIONS(667),
    [anon_sym_CARET_EQ] = ACTIONS(667),
    [anon_sym_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_LT_LT_EQ] = ACTIONS(667),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(667),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(667),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(667),
    [anon_sym_QMARK] = ACTIONS(652),
    [anon_sym_AMP_AMP] = ACTIONS(652),
    [anon_sym_PIPE_PIPE] = ACTIONS(652),
    [anon_sym_GT_GT] = ACTIONS(652),
    [anon_sym_GT_GT_GT] = ACTIONS(652),
    [anon_sym_LT_LT] = ACTIONS(652),
    [anon_sym_AMP] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(652),
    [anon_sym_PIPE] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_PERCENT] = ACTIONS(652),
    [anon_sym_STAR_STAR] = ACTIONS(652),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(652),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(652),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_QMARK_QMARK] = ACTIONS(652),
    [anon_sym_instanceof] = ACTIONS(641),
    [anon_sym_PLUS_PLUS] = ACTIONS(641),
    [anon_sym_DASH_DASH] = ACTIONS(641),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [anon_sym_AT] = ACTIONS(87),
    [sym__automatic_semicolon] = ACTIONS(641),
  },
  [92] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(548),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(1307),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_RPAREN] = ACTIONS(673),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [93] = {
    [sym_export_clause] = STATE(941),
    [sym_declaration] = STATE(278),
    [sym_namespace_import] = STATE(1203),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_class_declaration] = STATE(276),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function_declaration] = STATE(276),
    [sym_decorator] = STATE(766),
    [aux_sym_export_statement_repeat1] = STATE(955),
    [aux_sym_object_repeat1] = STATE(1025),
    [aux_sym_object_pattern_repeat1] = STATE(1026),
    [anon_sym_STAR] = ACTIONS(635),
    [anon_sym_default] = ACTIONS(637),
    [anon_sym_LBRACE] = ACTIONS(639),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_RBRACE] = ACTIONS(675),
    [anon_sym_var] = ACTIONS(645),
    [anon_sym_let] = ACTIONS(647),
    [anon_sym_const] = ACTIONS(647),
    [anon_sym_LPAREN] = ACTIONS(649),
    [anon_sym_in] = ACTIONS(652),
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_COLON] = ACTIONS(654),
    [anon_sym_EQ] = ACTIONS(657),
    [anon_sym_LBRACK] = ACTIONS(641),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_GT] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_DOT] = ACTIONS(641),
    [anon_sym_class] = ACTIONS(659),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_EQ_GT] = ACTIONS(665),
    [anon_sym_QMARK_DOT] = ACTIONS(641),
    [anon_sym_PLUS_EQ] = ACTIONS(667),
    [anon_sym_DASH_EQ] = ACTIONS(667),
    [anon_sym_STAR_EQ] = ACTIONS(667),
    [anon_sym_SLASH_EQ] = ACTIONS(667),
    [anon_sym_PERCENT_EQ] = ACTIONS(667),
    [anon_sym_CARET_EQ] = ACTIONS(667),
    [anon_sym_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_LT_LT_EQ] = ACTIONS(667),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(667),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(667),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(667),
    [anon_sym_QMARK] = ACTIONS(652),
    [anon_sym_AMP_AMP] = ACTIONS(652),
    [anon_sym_PIPE_PIPE] = ACTIONS(652),
    [anon_sym_GT_GT] = ACTIONS(652),
    [anon_sym_GT_GT_GT] = ACTIONS(652),
    [anon_sym_LT_LT] = ACTIONS(652),
    [anon_sym_AMP] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(652),
    [anon_sym_PIPE] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_PERCENT] = ACTIONS(652),
    [anon_sym_STAR_STAR] = ACTIONS(652),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(652),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(652),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_QMARK_QMARK] = ACTIONS(652),
    [anon_sym_instanceof] = ACTIONS(641),
    [anon_sym_PLUS_PLUS] = ACTIONS(641),
    [anon_sym_DASH_DASH] = ACTIONS(641),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [anon_sym_AT] = ACTIONS(87),
    [sym__automatic_semicolon] = ACTIONS(641),
  },
  [94] = {
    [sym_import] = STATE(492),
    [sym_statement_block] = STATE(470),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(595),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(677),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [95] = {
    [sym_import] = STATE(492),
    [sym_statement_block] = STATE(470),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(396),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(679),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [96] = {
    [sym_import] = STATE(492),
    [sym_statement_block] = STATE(428),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(596),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(677),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [97] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(623),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(503),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(681),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [98] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(617),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(432),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(681),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [99] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(541),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1157),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [100] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(552),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(1358),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [101] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(570),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(436),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(681),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [102] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(624),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(1316),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [103] = {
    [sym_import] = STATE(492),
    [sym_statement_block] = STATE(487),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(419),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(679),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [104] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(655),
    [sym_primary_expression] = STATE(399),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_DOT] = ACTIONS(683),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [105] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(416),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(953),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [106] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(603),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(460),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(681),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [107] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(621),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(424),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(681),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [108] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(578),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(1357),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [109] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(565),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(1302),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [110] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(633),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(1328),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [111] = {
    [sym_import] = STATE(492),
    [sym_statement_block] = STATE(427),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(598),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(677),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [112] = {
    [sym_import] = STATE(492),
    [sym_statement_block] = STATE(500),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(568),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(677),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [113] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(613),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(1363),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [114] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(547),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(505),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(681),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [115] = {
    [sym_import] = STATE(492),
    [sym_statement_block] = STATE(487),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(581),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(677),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [116] = {
    [sym_import] = STATE(492),
    [sym_statement_block] = STATE(483),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(604),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(677),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [117] = {
    [sym_import] = STATE(492),
    [sym_statement_block] = STATE(500),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(412),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(679),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [118] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(372),
    [sym_expression] = STATE(653),
    [sym_primary_expression] = STATE(522),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(372),
    [sym_subscript_expression] = STATE(372),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(685),
    [anon_sym_export] = ACTIONS(687),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_DOT] = ACTIONS(689),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(691),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(693),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(695),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(687),
    [anon_sym_get] = ACTIONS(687),
    [anon_sym_set] = ACTIONS(687),
  },
  [119] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(599),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(1312),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [120] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(655),
    [sym_primary_expression] = STATE(399),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(697),
    [anon_sym_export] = ACTIONS(699),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_DOT] = ACTIONS(683),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(701),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(699),
    [anon_sym_get] = ACTIONS(699),
    [anon_sym_set] = ACTIONS(699),
  },
  [121] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(636),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(1362),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [122] = {
    [sym_import] = STATE(492),
    [sym_statement_block] = STATE(428),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(421),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(679),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [123] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(546),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(1304),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [124] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(655),
    [sym_primary_expression] = STATE(399),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_DOT] = ACTIONS(689),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [125] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(612),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(1367),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [126] = {
    [sym_import] = STATE(492),
    [sym_statement_block] = STATE(427),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(406),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(679),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [127] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(533),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_sequence_expression] = STATE(1159),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [128] = {
    [sym_import] = STATE(492),
    [sym_statement_block] = STATE(483),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(398),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(679),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [129] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(556),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_sequence_expression] = STATE(1305),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [130] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(431),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [131] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(441),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [132] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(646),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [133] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(494),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [134] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(499),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [135] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(647),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [136] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(472),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [137] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(485),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [138] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(644),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [139] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(393),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [140] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(392),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [141] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(475),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [142] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(390),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [143] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(562),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [144] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(520),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [145] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(577),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [146] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(446),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [147] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(580),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [148] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(582),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [149] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(584),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [150] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(404),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [151] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(585),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [152] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(586),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [153] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(588),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [154] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(642),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [155] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(489),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [156] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(590),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [157] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(446),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1078),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1078),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1078),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(703),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [158] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(649),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [159] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(490),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [160] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(394),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [161] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(593),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [162] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(495),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [163] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(594),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [164] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(606),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [165] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(602),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [166] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(405),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [167] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(513),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [168] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(410),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [169] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(465),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [170] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(393),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [171] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(397),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [172] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(392),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [173] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(390),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [174] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(631),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [175] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(394),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [176] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(414),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [177] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(401),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [178] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(600),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [179] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(446),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1041),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1041),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1041),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(705),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [180] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(402),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [181] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(407),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [182] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(411),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [183] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(413),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [184] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(458),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [185] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(417),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [186] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(508),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [187] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(434),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [188] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(616),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [189] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(420),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [190] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(451),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [191] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(450),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [192] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(444),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [193] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(449),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [194] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(361),
    [sym_expression] = STATE(422),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1343),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1343),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(361),
    [sym_subscript_expression] = STATE(361),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(757),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1343),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1303),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_export] = ACTIONS(330),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(342),
    [anon_sym_yield] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(356),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_typeof] = ACTIONS(366),
    [anon_sym_void] = ACTIONS(366),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(330),
    [anon_sym_get] = ACTIONS(330),
    [anon_sym_set] = ACTIONS(330),
  },
  [195] = {
    [sym_import] = STATE(492),
    [sym_parenthesized_expression] = STATE(348),
    [sym_expression] = STATE(648),
    [sym_primary_expression] = STATE(498),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(492),
    [sym_object_pattern] = STATE(1311),
    [sym_array] = STATE(492),
    [sym_array_pattern] = STATE(1311),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(782),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(492),
    [sym_function] = STATE(492),
    [sym_generator_function] = STATE(492),
    [sym_arrow_function] = STATE(492),
    [sym_call_expression] = STATE(492),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(348),
    [sym_subscript_expression] = STATE(348),
    [sym_assignment_expression] = STATE(501),
    [sym__augmented_assignment_lhs] = STATE(756),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym__destructuring_pattern] = STATE(1311),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(492),
    [sym_template_string] = STATE(492),
    [sym_regex] = STATE(492),
    [sym_meta_property] = STATE(492),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1342),
    [aux_sym_export_statement_repeat1] = STATE(984),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_export] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_await] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(354),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_typeof] = ACTIONS(422),
    [anon_sym_void] = ACTIONS(422),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_get] = ACTIONS(402),
    [anon_sym_set] = ACTIONS(402),
  },
  [196] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(447),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [197] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(376),
    [sym_expression] = STATE(448),
    [sym_primary_expression] = STATE(574),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1288),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1288),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(794),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(376),
    [sym_subscript_expression] = STATE(376),
    [sym_assignment_expression] = STATE(569),
    [sym__augmented_assignment_lhs] = STATE(760),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym__destructuring_pattern] = STATE(1288),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(766),
    [sym_formal_parameters] = STATE(1308),
    [aux_sym_export_statement_repeat1] = STATE(985),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [198] = {
    [sym_export_clause] = STATE(941),
    [sym_declaration] = STATE(278),
    [sym_namespace_import] = STATE(1203),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_class_declaration] = STATE(276),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function_declaration] = STATE(276),
    [sym_decorator] = STATE(766),
    [aux_sym_export_statement_repeat1] = STATE(955),
    [anon_sym_STAR] = ACTIONS(635),
    [anon_sym_default] = ACTIONS(637),
    [anon_sym_LBRACE] = ACTIONS(639),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_var] = ACTIONS(645),
    [anon_sym_let] = ACTIONS(647),
    [anon_sym_const] = ACTIONS(647),
    [anon_sym_LPAREN] = ACTIONS(641),
    [anon_sym_in] = ACTIONS(652),
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_COLON] = ACTIONS(707),
    [anon_sym_EQ] = ACTIONS(709),
    [anon_sym_LBRACK] = ACTIONS(641),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_GT] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_DOT] = ACTIONS(641),
    [anon_sym_class] = ACTIONS(659),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_EQ_GT] = ACTIONS(665),
    [anon_sym_QMARK_DOT] = ACTIONS(641),
    [anon_sym_PLUS_EQ] = ACTIONS(667),
    [anon_sym_DASH_EQ] = ACTIONS(667),
    [anon_sym_STAR_EQ] = ACTIONS(667),
    [anon_sym_SLASH_EQ] = ACTIONS(667),
    [anon_sym_PERCENT_EQ] = ACTIONS(667),
    [anon_sym_CARET_EQ] = ACTIONS(667),
    [anon_sym_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_LT_LT_EQ] = ACTIONS(667),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(667),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(667),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(667),
    [anon_sym_QMARK] = ACTIONS(652),
    [anon_sym_AMP_AMP] = ACTIONS(652),
    [anon_sym_PIPE_PIPE] = ACTIONS(652),
    [anon_sym_GT_GT] = ACTIONS(652),
    [anon_sym_GT_GT_GT] = ACTIONS(652),
    [anon_sym_LT_LT] = ACTIONS(652),
    [anon_sym_AMP] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(652),
    [anon_sym_PIPE] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_PERCENT] = ACTIONS(652),
    [anon_sym_STAR_STAR] = ACTIONS(652),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(652),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(652),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_QMARK_QMARK] = ACTIONS(652),
    [anon_sym_instanceof] = ACTIONS(641),
    [anon_sym_PLUS_PLUS] = ACTIONS(641),
    [anon_sym_DASH_DASH] = ACTIONS(641),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [anon_sym_AT] = ACTIONS(87),
    [sym__automatic_semicolon] = ACTIONS(641),
  },
  [199] = {
    [sym_export_clause] = STATE(941),
    [sym_declaration] = STATE(278),
    [sym_namespace_import] = STATE(1203),
    [sym_variable_declaration] = STATE(276),
    [sym_lexical_declaration] = STATE(276),
    [sym_class_declaration] = STATE(276),
    [sym_function_declaration] = STATE(276),
    [sym_generator_function_declaration] = STATE(276),
    [sym_decorator] = STATE(766),
    [aux_sym_export_statement_repeat1] = STATE(954),
    [anon_sym_STAR] = ACTIONS(635),
    [anon_sym_default] = ACTIONS(711),
    [anon_sym_LBRACE] = ACTIONS(639),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_var] = ACTIONS(645),
    [anon_sym_let] = ACTIONS(647),
    [anon_sym_const] = ACTIONS(647),
    [anon_sym_LPAREN] = ACTIONS(641),
    [anon_sym_in] = ACTIONS(652),
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_COLON] = ACTIONS(713),
    [anon_sym_EQ] = ACTIONS(709),
    [anon_sym_LBRACK] = ACTIONS(641),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_GT] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_DOT] = ACTIONS(641),
    [anon_sym_class] = ACTIONS(715),
    [anon_sym_async] = ACTIONS(717),
    [anon_sym_function] = ACTIONS(719),
    [anon_sym_EQ_GT] = ACTIONS(665),
    [anon_sym_QMARK_DOT] = ACTIONS(641),
    [anon_sym_PLUS_EQ] = ACTIONS(667),
    [anon_sym_DASH_EQ] = ACTIONS(667),
    [anon_sym_STAR_EQ] = ACTIONS(667),
    [anon_sym_SLASH_EQ] = ACTIONS(667),
    [anon_sym_PERCENT_EQ] = ACTIONS(667),
    [anon_sym_CARET_EQ] = ACTIONS(667),
    [anon_sym_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_LT_LT_EQ] = ACTIONS(667),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(667),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(667),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(667),
    [anon_sym_QMARK] = ACTIONS(652),
    [anon_sym_AMP_AMP] = ACTIONS(652),
    [anon_sym_PIPE_PIPE] = ACTIONS(652),
    [anon_sym_GT_GT] = ACTIONS(652),
    [anon_sym_GT_GT_GT] = ACTIONS(652),
    [anon_sym_LT_LT] = ACTIONS(652),
    [anon_sym_AMP] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(652),
    [anon_sym_PIPE] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_PERCENT] = ACTIONS(652),
    [anon_sym_STAR_STAR] = ACTIONS(652),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(652),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(652),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_QMARK_QMARK] = ACTIONS(652),
    [anon_sym_instanceof] = ACTIONS(641),
    [anon_sym_PLUS_PLUS] = ACTIONS(641),
    [anon_sym_DASH_DASH] = ACTIONS(641),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [anon_sym_AT] = ACTIONS(87),
    [sym__automatic_semicolon] = ACTIONS(641),
  },
  [200] = {
    [sym_string] = STATE(1221),
    [sym_formal_parameters] = STATE(1340),
    [sym__property_name] = STATE(1221),
    [sym_computed_property_name] = STATE(1221),
    [aux_sym_object_repeat1] = STATE(1082),
    [aux_sym_object_pattern_repeat1] = STATE(1026),
    [sym_identifier] = ACTIONS(721),
    [anon_sym_export] = ACTIONS(723),
    [anon_sym_STAR] = ACTIONS(725),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_RBRACE] = ACTIONS(643),
    [anon_sym_LPAREN] = ACTIONS(728),
    [anon_sym_in] = ACTIONS(652),
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_COLON] = ACTIONS(654),
    [anon_sym_EQ] = ACTIONS(657),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_GT] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_DOT] = ACTIONS(652),
    [anon_sym_async] = ACTIONS(723),
    [anon_sym_function] = ACTIONS(735),
    [anon_sym_EQ_GT] = ACTIONS(665),
    [anon_sym_QMARK_DOT] = ACTIONS(641),
    [anon_sym_PLUS_EQ] = ACTIONS(667),
    [anon_sym_DASH_EQ] = ACTIONS(667),
    [anon_sym_STAR_EQ] = ACTIONS(667),
    [anon_sym_SLASH_EQ] = ACTIONS(667),
    [anon_sym_PERCENT_EQ] = ACTIONS(667),
    [anon_sym_CARET_EQ] = ACTIONS(667),
    [anon_sym_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_LT_LT_EQ] = ACTIONS(667),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(667),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(667),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(667),
    [anon_sym_QMARK] = ACTIONS(652),
    [anon_sym_AMP_AMP] = ACTIONS(652),
    [anon_sym_PIPE_PIPE] = ACTIONS(652),
    [anon_sym_GT_GT] = ACTIONS(652),
    [anon_sym_GT_GT_GT] = ACTIONS(652),
    [anon_sym_LT_LT] = ACTIONS(652),
    [anon_sym_AMP] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(652),
    [anon_sym_PIPE] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_PERCENT] = ACTIONS(652),
    [anon_sym_STAR_STAR] = ACTIONS(652),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(652),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(652),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_QMARK_QMARK] = ACTIONS(652),
    [anon_sym_instanceof] = ACTIONS(652),
    [anon_sym_PLUS_PLUS] = ACTIONS(641),
    [anon_sym_DASH_DASH] = ACTIONS(641),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [sym_number] = ACTIONS(737),
    [sym_private_property_identifier] = ACTIONS(737),
    [anon_sym_static] = ACTIONS(723),
    [anon_sym_get] = ACTIONS(739),
    [anon_sym_set] = ACTIONS(739),
    [sym__automatic_semicolon] = ACTIONS(641),
  },
  [201] = {
    [sym_string] = STATE(1221),
    [sym_formal_parameters] = STATE(1340),
    [sym__property_name] = STATE(1221),
    [sym_computed_property_name] = STATE(1221),
    [aux_sym_object_repeat1] = STATE(1082),
    [aux_sym_object_pattern_repeat1] = STATE(1026),
    [sym_identifier] = ACTIONS(721),
    [anon_sym_export] = ACTIONS(723),
    [anon_sym_STAR] = ACTIONS(725),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_RBRACE] = ACTIONS(671),
    [anon_sym_LPAREN] = ACTIONS(728),
    [anon_sym_in] = ACTIONS(652),
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_COLON] = ACTIONS(654),
    [anon_sym_EQ] = ACTIONS(657),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_GT] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_DOT] = ACTIONS(652),
    [anon_sym_async] = ACTIONS(723),
    [anon_sym_function] = ACTIONS(735),
    [anon_sym_EQ_GT] = ACTIONS(665),
    [anon_sym_QMARK_DOT] = ACTIONS(641),
    [anon_sym_PLUS_EQ] = ACTIONS(667),
    [anon_sym_DASH_EQ] = ACTIONS(667),
    [anon_sym_STAR_EQ] = ACTIONS(667),
    [anon_sym_SLASH_EQ] = ACTIONS(667),
    [anon_sym_PERCENT_EQ] = ACTIONS(667),
    [anon_sym_CARET_EQ] = ACTIONS(667),
    [anon_sym_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_LT_LT_EQ] = ACTIONS(667),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(667),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(667),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(667),
    [anon_sym_QMARK] = ACTIONS(652),
    [anon_sym_AMP_AMP] = ACTIONS(652),
    [anon_sym_PIPE_PIPE] = ACTIONS(652),
    [anon_sym_GT_GT] = ACTIONS(652),
    [anon_sym_GT_GT_GT] = ACTIONS(652),
    [anon_sym_LT_LT] = ACTIONS(652),
    [anon_sym_AMP] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(652),
    [anon_sym_PIPE] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_PERCENT] = ACTIONS(652),
    [anon_sym_STAR_STAR] = ACTIONS(652),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(652),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(652),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_QMARK_QMARK] = ACTIONS(652),
    [anon_sym_instanceof] = ACTIONS(652),
    [anon_sym_PLUS_PLUS] = ACTIONS(641),
    [anon_sym_DASH_DASH] = ACTIONS(641),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [sym_number] = ACTIONS(737),
    [sym_private_property_identifier] = ACTIONS(737),
    [anon_sym_static] = ACTIONS(723),
    [anon_sym_get] = ACTIONS(739),
    [anon_sym_set] = ACTIONS(739),
    [sym__automatic_semicolon] = ACTIONS(641),
  },
  [202] = {
    [sym_string] = STATE(1221),
    [sym_formal_parameters] = STATE(1340),
    [sym__property_name] = STATE(1221),
    [sym_computed_property_name] = STATE(1221),
    [aux_sym_object_repeat1] = STATE(1025),
    [aux_sym_object_pattern_repeat1] = STATE(1026),
    [sym_identifier] = ACTIONS(721),
    [anon_sym_export] = ACTIONS(723),
    [anon_sym_STAR] = ACTIONS(725),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_RBRACE] = ACTIONS(675),
    [anon_sym_LPAREN] = ACTIONS(728),
    [anon_sym_in] = ACTIONS(652),
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_COLON] = ACTIONS(654),
    [anon_sym_EQ] = ACTIONS(657),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_GT] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_DOT] = ACTIONS(652),
    [anon_sym_async] = ACTIONS(723),
    [anon_sym_function] = ACTIONS(735),
    [anon_sym_EQ_GT] = ACTIONS(665),
    [anon_sym_QMARK_DOT] = ACTIONS(641),
    [anon_sym_PLUS_EQ] = ACTIONS(667),
    [anon_sym_DASH_EQ] = ACTIONS(667),
    [anon_sym_STAR_EQ] = ACTIONS(667),
    [anon_sym_SLASH_EQ] = ACTIONS(667),
    [anon_sym_PERCENT_EQ] = ACTIONS(667),
    [anon_sym_CARET_EQ] = ACTIONS(667),
    [anon_sym_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_LT_LT_EQ] = ACTIONS(667),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(667),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(667),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(667),
    [anon_sym_QMARK] = ACTIONS(652),
    [anon_sym_AMP_AMP] = ACTIONS(652),
    [anon_sym_PIPE_PIPE] = ACTIONS(652),
    [anon_sym_GT_GT] = ACTIONS(652),
    [anon_sym_GT_GT_GT] = ACTIONS(652),
    [anon_sym_LT_LT] = ACTIONS(652),
    [anon_sym_AMP] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(652),
    [anon_sym_PIPE] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_PERCENT] = ACTIONS(652),
    [anon_sym_STAR_STAR] = ACTIONS(652),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(652),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(652),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_QMARK_QMARK] = ACTIONS(652),
    [anon_sym_instanceof] = ACTIONS(652),
    [anon_sym_PLUS_PLUS] = ACTIONS(641),
    [anon_sym_DASH_DASH] = ACTIONS(641),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [sym_number] = ACTIONS(737),
    [sym_private_property_identifier] = ACTIONS(737),
    [anon_sym_static] = ACTIONS(723),
    [anon_sym_get] = ACTIONS(739),
    [anon_sym_set] = ACTIONS(739),
    [sym__automatic_semicolon] = ACTIONS(641),
  },
  [203] = {
    [sym_string] = STATE(1221),
    [sym__property_name] = STATE(1221),
    [sym_computed_property_name] = STATE(1221),
    [aux_sym_object_repeat1] = STATE(1025),
    [aux_sym_object_pattern_repeat1] = STATE(1026),
    [sym_identifier] = ACTIONS(741),
    [anon_sym_export] = ACTIONS(741),
    [anon_sym_STAR] = ACTIONS(725),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_RBRACE] = ACTIONS(675),
    [anon_sym_LPAREN] = ACTIONS(649),
    [anon_sym_in] = ACTIONS(652),
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_COLON] = ACTIONS(654),
    [anon_sym_EQ] = ACTIONS(657),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_GT] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_DOT] = ACTIONS(652),
    [anon_sym_async] = ACTIONS(743),
    [anon_sym_EQ_GT] = ACTIONS(665),
    [anon_sym_QMARK_DOT] = ACTIONS(641),
    [anon_sym_PLUS_EQ] = ACTIONS(667),
    [anon_sym_DASH_EQ] = ACTIONS(667),
    [anon_sym_STAR_EQ] = ACTIONS(667),
    [anon_sym_SLASH_EQ] = ACTIONS(667),
    [anon_sym_PERCENT_EQ] = ACTIONS(667),
    [anon_sym_CARET_EQ] = ACTIONS(667),
    [anon_sym_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_LT_LT_EQ] = ACTIONS(667),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(667),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(667),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(667),
    [anon_sym_QMARK] = ACTIONS(652),
    [anon_sym_AMP_AMP] = ACTIONS(652),
    [anon_sym_PIPE_PIPE] = ACTIONS(652),
    [anon_sym_GT_GT] = ACTIONS(652),
    [anon_sym_GT_GT_GT] = ACTIONS(652),
    [anon_sym_LT_LT] = ACTIONS(652),
    [anon_sym_AMP] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(652),
    [anon_sym_PIPE] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_PERCENT] = ACTIONS(652),
    [anon_sym_STAR_STAR] = ACTIONS(652),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(652),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(652),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_QMARK_QMARK] = ACTIONS(652),
    [anon_sym_instanceof] = ACTIONS(652),
    [anon_sym_PLUS_PLUS] = ACTIONS(641),
    [anon_sym_DASH_DASH] = ACTIONS(641),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [sym_number] = ACTIONS(737),
    [sym_private_property_identifier] = ACTIONS(737),
    [anon_sym_static] = ACTIONS(741),
    [anon_sym_get] = ACTIONS(745),
    [anon_sym_set] = ACTIONS(745),
    [sym__automatic_semicolon] = ACTIONS(641),
  },
  [204] = {
    [sym_string] = STATE(1221),
    [sym__property_name] = STATE(1221),
    [sym_computed_property_name] = STATE(1221),
    [aux_sym_object_repeat1] = STATE(1082),
    [aux_sym_object_pattern_repeat1] = STATE(1026),
    [sym_identifier] = ACTIONS(741),
    [anon_sym_export] = ACTIONS(741),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_RBRACE] = ACTIONS(671),
    [anon_sym_LPAREN] = ACTIONS(649),
    [anon_sym_in] = ACTIONS(652),
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_COLON] = ACTIONS(654),
    [anon_sym_EQ] = ACTIONS(657),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_GT] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_DOT] = ACTIONS(652),
    [anon_sym_async] = ACTIONS(741),
    [anon_sym_EQ_GT] = ACTIONS(665),
    [anon_sym_QMARK_DOT] = ACTIONS(641),
    [anon_sym_PLUS_EQ] = ACTIONS(667),
    [anon_sym_DASH_EQ] = ACTIONS(667),
    [anon_sym_STAR_EQ] = ACTIONS(667),
    [anon_sym_SLASH_EQ] = ACTIONS(667),
    [anon_sym_PERCENT_EQ] = ACTIONS(667),
    [anon_sym_CARET_EQ] = ACTIONS(667),
    [anon_sym_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_LT_LT_EQ] = ACTIONS(667),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(667),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(667),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(667),
    [anon_sym_QMARK] = ACTIONS(652),
    [anon_sym_AMP_AMP] = ACTIONS(652),
    [anon_sym_PIPE_PIPE] = ACTIONS(652),
    [anon_sym_GT_GT] = ACTIONS(652),
    [anon_sym_GT_GT_GT] = ACTIONS(652),
    [anon_sym_LT_LT] = ACTIONS(652),
    [anon_sym_AMP] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(652),
    [anon_sym_PIPE] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_PERCENT] = ACTIONS(652),
    [anon_sym_STAR_STAR] = ACTIONS(652),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(652),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(652),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_QMARK_QMARK] = ACTIONS(652),
    [anon_sym_instanceof] = ACTIONS(652),
    [anon_sym_PLUS_PLUS] = ACTIONS(641),
    [anon_sym_DASH_DASH] = ACTIONS(641),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [sym_number] = ACTIONS(737),
    [sym_private_property_identifier] = ACTIONS(737),
    [anon_sym_static] = ACTIONS(741),
    [anon_sym_get] = ACTIONS(741),
    [anon_sym_set] = ACTIONS(741),
    [sym__automatic_semicolon] = ACTIONS(641),
  },
  [205] = {
    [sym_string] = STATE(1221),
    [sym__property_name] = STATE(1221),
    [sym_computed_property_name] = STATE(1221),
    [aux_sym_object_repeat1] = STATE(1082),
    [aux_sym_object_pattern_repeat1] = STATE(1026),
    [sym_identifier] = ACTIONS(741),
    [anon_sym_export] = ACTIONS(741),
    [anon_sym_STAR] = ACTIONS(725),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_RBRACE] = ACTIONS(671),
    [anon_sym_LPAREN] = ACTIONS(649),
    [anon_sym_in] = ACTIONS(652),
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_COLON] = ACTIONS(654),
    [anon_sym_EQ] = ACTIONS(657),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_GT] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_DOT] = ACTIONS(652),
    [anon_sym_async] = ACTIONS(743),
    [anon_sym_EQ_GT] = ACTIONS(665),
    [anon_sym_QMARK_DOT] = ACTIONS(641),
    [anon_sym_PLUS_EQ] = ACTIONS(667),
    [anon_sym_DASH_EQ] = ACTIONS(667),
    [anon_sym_STAR_EQ] = ACTIONS(667),
    [anon_sym_SLASH_EQ] = ACTIONS(667),
    [anon_sym_PERCENT_EQ] = ACTIONS(667),
    [anon_sym_CARET_EQ] = ACTIONS(667),
    [anon_sym_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_LT_LT_EQ] = ACTIONS(667),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(667),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(667),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(667),
    [anon_sym_QMARK] = ACTIONS(652),
    [anon_sym_AMP_AMP] = ACTIONS(652),
    [anon_sym_PIPE_PIPE] = ACTIONS(652),
    [anon_sym_GT_GT] = ACTIONS(652),
    [anon_sym_GT_GT_GT] = ACTIONS(652),
    [anon_sym_LT_LT] = ACTIONS(652),
    [anon_sym_AMP] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(652),
    [anon_sym_PIPE] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_PERCENT] = ACTIONS(652),
    [anon_sym_STAR_STAR] = ACTIONS(652),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(652),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(652),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_QMARK_QMARK] = ACTIONS(652),
    [anon_sym_instanceof] = ACTIONS(652),
    [anon_sym_PLUS_PLUS] = ACTIONS(641),
    [anon_sym_DASH_DASH] = ACTIONS(641),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [sym_number] = ACTIONS(737),
    [sym_private_property_identifier] = ACTIONS(737),
    [anon_sym_static] = ACTIONS(741),
    [anon_sym_get] = ACTIONS(745),
    [anon_sym_set] = ACTIONS(745),
    [sym__automatic_semicolon] = ACTIONS(641),
  },
  [206] = {
    [sym_string] = STATE(1221),
    [sym__property_name] = STATE(1221),
    [sym_computed_property_name] = STATE(1221),
    [aux_sym_object_repeat1] = STATE(1082),
    [aux_sym_object_pattern_repeat1] = STATE(1026),
    [sym_identifier] = ACTIONS(741),
    [anon_sym_export] = ACTIONS(741),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_RBRACE] = ACTIONS(643),
    [anon_sym_LPAREN] = ACTIONS(649),
    [anon_sym_in] = ACTIONS(652),
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_COLON] = ACTIONS(654),
    [anon_sym_EQ] = ACTIONS(657),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_GT] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_DOT] = ACTIONS(652),
    [anon_sym_async] = ACTIONS(741),
    [anon_sym_EQ_GT] = ACTIONS(665),
    [anon_sym_QMARK_DOT] = ACTIONS(641),
    [anon_sym_PLUS_EQ] = ACTIONS(667),
    [anon_sym_DASH_EQ] = ACTIONS(667),
    [anon_sym_STAR_EQ] = ACTIONS(667),
    [anon_sym_SLASH_EQ] = ACTIONS(667),
    [anon_sym_PERCENT_EQ] = ACTIONS(667),
    [anon_sym_CARET_EQ] = ACTIONS(667),
    [anon_sym_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_LT_LT_EQ] = ACTIONS(667),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(667),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(667),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(667),
    [anon_sym_QMARK] = ACTIONS(652),
    [anon_sym_AMP_AMP] = ACTIONS(652),
    [anon_sym_PIPE_PIPE] = ACTIONS(652),
    [anon_sym_GT_GT] = ACTIONS(652),
    [anon_sym_GT_GT_GT] = ACTIONS(652),
    [anon_sym_LT_LT] = ACTIONS(652),
    [anon_sym_AMP] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(652),
    [anon_sym_PIPE] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_PERCENT] = ACTIONS(652),
    [anon_sym_STAR_STAR] = ACTIONS(652),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(652),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(652),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_QMARK_QMARK] = ACTIONS(652),
    [anon_sym_instanceof] = ACTIONS(652),
    [anon_sym_PLUS_PLUS] = ACTIONS(641),
    [anon_sym_DASH_DASH] = ACTIONS(641),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [sym_number] = ACTIONS(737),
    [sym_private_property_identifier] = ACTIONS(737),
    [anon_sym_static] = ACTIONS(741),
    [anon_sym_get] = ACTIONS(741),
    [anon_sym_set] = ACTIONS(741),
    [sym__automatic_semicolon] = ACTIONS(641),
  },
  [207] = {
    [sym_string] = STATE(1221),
    [sym__property_name] = STATE(1221),
    [sym_computed_property_name] = STATE(1221),
    [aux_sym_object_repeat1] = STATE(1082),
    [aux_sym_object_pattern_repeat1] = STATE(1026),
    [sym_identifier] = ACTIONS(741),
    [anon_sym_export] = ACTIONS(741),
    [anon_sym_STAR] = ACTIONS(725),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_RBRACE] = ACTIONS(643),
    [anon_sym_LPAREN] = ACTIONS(649),
    [anon_sym_in] = ACTIONS(652),
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_COLON] = ACTIONS(654),
    [anon_sym_EQ] = ACTIONS(657),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_GT] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_DOT] = ACTIONS(652),
    [anon_sym_async] = ACTIONS(743),
    [anon_sym_EQ_GT] = ACTIONS(665),
    [anon_sym_QMARK_DOT] = ACTIONS(641),
    [anon_sym_PLUS_EQ] = ACTIONS(667),
    [anon_sym_DASH_EQ] = ACTIONS(667),
    [anon_sym_STAR_EQ] = ACTIONS(667),
    [anon_sym_SLASH_EQ] = ACTIONS(667),
    [anon_sym_PERCENT_EQ] = ACTIONS(667),
    [anon_sym_CARET_EQ] = ACTIONS(667),
    [anon_sym_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_LT_LT_EQ] = ACTIONS(667),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(667),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(667),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(667),
    [anon_sym_QMARK] = ACTIONS(652),
    [anon_sym_AMP_AMP] = ACTIONS(652),
    [anon_sym_PIPE_PIPE] = ACTIONS(652),
    [anon_sym_GT_GT] = ACTIONS(652),
    [anon_sym_GT_GT_GT] = ACTIONS(652),
    [anon_sym_LT_LT] = ACTIONS(652),
    [anon_sym_AMP] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(652),
    [anon_sym_PIPE] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_PERCENT] = ACTIONS(652),
    [anon_sym_STAR_STAR] = ACTIONS(652),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(652),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(652),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_QMARK_QMARK] = ACTIONS(652),
    [anon_sym_instanceof] = ACTIONS(652),
    [anon_sym_PLUS_PLUS] = ACTIONS(641),
    [anon_sym_DASH_DASH] = ACTIONS(641),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [sym_number] = ACTIONS(737),
    [sym_private_property_identifier] = ACTIONS(737),
    [anon_sym_static] = ACTIONS(741),
    [anon_sym_get] = ACTIONS(745),
    [anon_sym_set] = ACTIONS(745),
    [sym__automatic_semicolon] = ACTIONS(641),
  },
  [208] = {
    [sym_string] = STATE(1221),
    [sym__property_name] = STATE(1221),
    [sym_computed_property_name] = STATE(1221),
    [aux_sym_object_repeat1] = STATE(1025),
    [aux_sym_object_pattern_repeat1] = STATE(1026),
    [sym_identifier] = ACTIONS(741),
    [anon_sym_export] = ACTIONS(741),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_RBRACE] = ACTIONS(675),
    [anon_sym_LPAREN] = ACTIONS(649),
    [anon_sym_in] = ACTIONS(652),
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_COLON] = ACTIONS(654),
    [anon_sym_EQ] = ACTIONS(657),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_GT] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_DOT] = ACTIONS(652),
    [anon_sym_async] = ACTIONS(741),
    [anon_sym_EQ_GT] = ACTIONS(665),
    [anon_sym_QMARK_DOT] = ACTIONS(641),
    [anon_sym_PLUS_EQ] = ACTIONS(667),
    [anon_sym_DASH_EQ] = ACTIONS(667),
    [anon_sym_STAR_EQ] = ACTIONS(667),
    [anon_sym_SLASH_EQ] = ACTIONS(667),
    [anon_sym_PERCENT_EQ] = ACTIONS(667),
    [anon_sym_CARET_EQ] = ACTIONS(667),
    [anon_sym_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(667),
    [anon_sym_LT_LT_EQ] = ACTIONS(667),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(667),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(667),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(667),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(667),
    [anon_sym_QMARK] = ACTIONS(652),
    [anon_sym_AMP_AMP] = ACTIONS(652),
    [anon_sym_PIPE_PIPE] = ACTIONS(652),
    [anon_sym_GT_GT] = ACTIONS(652),
    [anon_sym_GT_GT_GT] = ACTIONS(652),
    [anon_sym_LT_LT] = ACTIONS(652),
    [anon_sym_AMP] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(652),
    [anon_sym_PIPE] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_PERCENT] = ACTIONS(652),
    [anon_sym_STAR_STAR] = ACTIONS(652),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(652),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(652),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_QMARK_QMARK] = ACTIONS(652),
    [anon_sym_instanceof] = ACTIONS(652),
    [anon_sym_PLUS_PLUS] = ACTIONS(641),
    [anon_sym_DASH_DASH] = ACTIONS(641),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [sym_number] = ACTIONS(737),
    [sym_private_property_identifier] = ACTIONS(737),
    [anon_sym_static] = ACTIONS(741),
    [anon_sym_get] = ACTIONS(741),
    [anon_sym_set] = ACTIONS(741),
    [sym__automatic_semicolon] = ACTIONS(641),
  },
  [209] = {
    [ts_builtin_sym_end] = ACTIONS(440),
    [sym_identifier] = ACTIONS(442),
    [anon_sym_export] = ACTIONS(442),
    [anon_sym_STAR] = ACTIONS(440),
    [anon_sym_default] = ACTIONS(442),
    [anon_sym_LBRACE] = ACTIONS(440),
    [anon_sym_COMMA] = ACTIONS(440),
    [anon_sym_RBRACE] = ACTIONS(440),
    [anon_sym_import] = ACTIONS(442),
    [anon_sym_var] = ACTIONS(442),
    [anon_sym_let] = ACTIONS(442),
    [anon_sym_const] = ACTIONS(442),
    [anon_sym_else] = ACTIONS(442),
    [anon_sym_if] = ACTIONS(442),
    [anon_sym_switch] = ACTIONS(442),
    [anon_sym_for] = ACTIONS(442),
    [anon_sym_LPAREN] = ACTIONS(440),
    [anon_sym_await] = ACTIONS(442),
    [anon_sym_while] = ACTIONS(442),
    [anon_sym_do] = ACTIONS(442),
    [anon_sym_try] = ACTIONS(442),
    [anon_sym_with] = ACTIONS(442),
    [anon_sym_break] = ACTIONS(442),
    [anon_sym_continue] = ACTIONS(442),
    [anon_sym_debugger] = ACTIONS(442),
    [anon_sym_return] = ACTIONS(442),
    [anon_sym_throw] = ACTIONS(442),
    [anon_sym_SEMI] = ACTIONS(440),
    [anon_sym_case] = ACTIONS(442),
    [anon_sym_catch] = ACTIONS(442),
    [anon_sym_finally] = ACTIONS(442),
    [anon_sym_yield] = ACTIONS(442),
    [anon_sym_LBRACK] = ACTIONS(440),
    [anon_sym_LT] = ACTIONS(440),
    [anon_sym_SLASH] = ACTIONS(442),
    [anon_sym_class] = ACTIONS(442),
    [anon_sym_async] = ACTIONS(442),
    [anon_sym_function] = ACTIONS(442),
    [anon_sym_new] = ACTIONS(442),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(440),
    [anon_sym_TILDE] = ACTIONS(440),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(440),
    [anon_sym_DASH_DASH] = ACTIONS(440),
    [anon_sym_DQUOTE] = ACTIONS(440),
    [anon_sym_SQUOTE] = ACTIONS(440),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [sym_number] = ACTIONS(440),
    [sym_private_property_identifier] = ACTIONS(440),
    [sym_this] = ACTIONS(442),
    [sym_super] = ACTIONS(442),
    [sym_true] = ACTIONS(442),
    [sym_false] = ACTIONS(442),
    [sym_null] = ACTIONS(442),
    [sym_undefined] = ACTIONS(442),
    [anon_sym_AT] = ACTIONS(440),
    [anon_sym_static] = ACTIONS(442),
    [anon_sym_get] = ACTIONS(442),
    [anon_sym_set] = ACTIONS(442),
    [sym__automatic_semicolon] = ACTIONS(747),
  },
  [210] = {
    [ts_builtin_sym_end] = ACTIONS(428),
    [sym_identifier] = ACTIONS(430),
    [anon_sym_export] = ACTIONS(430),
    [anon_sym_STAR] = ACTIONS(428),
    [anon_sym_default] = ACTIONS(430),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_COMMA] = ACTIONS(428),
    [anon_sym_RBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(430),
    [anon_sym_var] = ACTIONS(430),
    [anon_sym_let] = ACTIONS(430),
    [anon_sym_const] = ACTIONS(430),
    [anon_sym_else] = ACTIONS(430),
    [anon_sym_if] = ACTIONS(430),
    [anon_sym_switch] = ACTIONS(430),
    [anon_sym_for] = ACTIONS(430),
    [anon_sym_LPAREN] = ACTIONS(428),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_while] = ACTIONS(430),
    [anon_sym_do] = ACTIONS(430),
    [anon_sym_try] = ACTIONS(430),
    [anon_sym_with] = ACTIONS(430),
    [anon_sym_break] = ACTIONS(430),
    [anon_sym_continue] = ACTIONS(430),
    [anon_sym_debugger] = ACTIONS(430),
    [anon_sym_return] = ACTIONS(430),
    [anon_sym_throw] = ACTIONS(430),
    [anon_sym_SEMI] = ACTIONS(428),
    [anon_sym_case] = ACTIONS(430),
    [anon_sym_catch] = ACTIONS(430),
    [anon_sym_finally] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(430),
    [anon_sym_LBRACK] = ACTIONS(428),
    [anon_sym_LT] = ACTIONS(428),
    [anon_sym_SLASH] = ACTIONS(430),
    [anon_sym_class] = ACTIONS(430),
    [anon_sym_async] = ACTIONS(430),
    [anon_sym_function] = ACTIONS(430),
    [anon_sym_new] = ACTIONS(430),
    [anon_sym_PLUS] = ACTIONS(430),
    [anon_sym_DASH] = ACTIONS(430),
    [anon_sym_BANG] = ACTIONS(428),
    [anon_sym_TILDE] = ACTIONS(428),
    [anon_sym_typeof] = ACTIONS(430),
    [anon_sym_void] = ACTIONS(430),
    [anon_sym_delete] = ACTIONS(430),
    [anon_sym_PLUS_PLUS] = ACTIONS(428),
    [anon_sym_DASH_DASH] = ACTIONS(428),
    [anon_sym_DQUOTE] = ACTIONS(428),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(428),
    [sym_number] = ACTIONS(428),
    [sym_private_property_identifier] = ACTIONS(428),
    [sym_this] = ACTIONS(430),
    [sym_super] = ACTIONS(430),
    [sym_true] = ACTIONS(430),
    [sym_false] = ACTIONS(430),
    [sym_null] = ACTIONS(430),
    [sym_undefined] = ACTIONS(430),
    [anon_sym_AT] = ACTIONS(428),
    [anon_sym_static] = ACTIONS(430),
    [anon_sym_get] = ACTIONS(430),
    [anon_sym_set] = ACTIONS(430),
    [sym__automatic_semicolon] = ACTIONS(438),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(749), 1,
      sym_identifier,
    ACTIONS(753), 1,
      anon_sym_LPAREN,
    ACTIONS(756), 1,
      anon_sym_EQ,
    ACTIONS(758), 1,
      anon_sym_function,
    ACTIONS(760), 1,
      anon_sym_EQ_GT,
    STATE(1353), 1,
      sym_formal_parameters,
    ACTIONS(751), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(641), 15,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(667), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(652), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [87] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(532), 19,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      sym_private_property_identifier,
      anon_sym_AT,
    ACTIONS(534), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [158] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(749), 1,
      sym_identifier,
    ACTIONS(753), 1,
      anon_sym_LPAREN,
    ACTIONS(758), 1,
      anon_sym_function,
    ACTIONS(760), 1,
      anon_sym_EQ_GT,
    ACTIONS(762), 1,
      anon_sym_EQ,
    STATE(1353), 1,
      sym_formal_parameters,
    ACTIONS(751), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(641), 15,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(667), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(652), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [245] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(440), 19,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      sym_private_property_identifier,
      anon_sym_AT,
    ACTIONS(442), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [316] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(665), 1,
      anon_sym_EQ_GT,
    ACTIONS(709), 1,
      anon_sym_EQ,
    ACTIONS(713), 1,
      anon_sym_COLON,
    ACTIONS(753), 1,
      anon_sym_LPAREN,
    ACTIONS(764), 1,
      sym_identifier,
    ACTIONS(768), 1,
      anon_sym_function,
    STATE(1340), 1,
      sym_formal_parameters,
    ACTIONS(766), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(641), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(667), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(652), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [404] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_catch,
    ACTIONS(776), 1,
      anon_sym_finally,
    STATE(225), 1,
      sym_catch_clause,
    STATE(338), 1,
      sym_finally_clause,
    ACTIONS(770), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(772), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [482] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(665), 1,
      anon_sym_EQ_GT,
    ACTIONS(709), 1,
      anon_sym_EQ,
    ACTIONS(753), 1,
      anon_sym_LPAREN,
    ACTIONS(764), 1,
      sym_identifier,
    ACTIONS(778), 1,
      anon_sym_function,
    STATE(1340), 1,
      sym_formal_parameters,
    ACTIONS(766), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(641), 14,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(667), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(652), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [568] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(665), 1,
      anon_sym_EQ_GT,
    ACTIONS(753), 1,
      anon_sym_LPAREN,
    ACTIONS(762), 1,
      anon_sym_EQ,
    ACTIONS(764), 1,
      sym_identifier,
    ACTIONS(778), 1,
      anon_sym_function,
    STATE(1340), 1,
      sym_formal_parameters,
    ACTIONS(766), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(641), 14,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(667), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(652), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [654] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(749), 1,
      sym_identifier,
    ACTIONS(753), 1,
      anon_sym_LPAREN,
    ACTIONS(758), 1,
      anon_sym_function,
    ACTIONS(760), 1,
      anon_sym_EQ_GT,
    ACTIONS(783), 1,
      anon_sym_EQ,
    STATE(1353), 1,
      sym_formal_parameters,
    ACTIONS(780), 4,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(751), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(641), 10,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(667), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(652), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [742] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(665), 1,
      anon_sym_EQ_GT,
    ACTIONS(709), 1,
      anon_sym_EQ,
    ACTIONS(753), 1,
      anon_sym_LPAREN,
    ACTIONS(764), 1,
      sym_identifier,
    ACTIONS(778), 1,
      anon_sym_function,
    ACTIONS(786), 1,
      anon_sym_in,
    ACTIONS(789), 1,
      anon_sym_of,
    STATE(1340), 1,
      sym_formal_parameters,
    ACTIONS(766), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(641), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(667), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(652), 21,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [832] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(665), 1,
      anon_sym_EQ_GT,
    ACTIONS(707), 1,
      anon_sym_COLON,
    ACTIONS(709), 1,
      anon_sym_EQ,
    ACTIONS(735), 1,
      anon_sym_function,
    ACTIONS(753), 1,
      anon_sym_LPAREN,
    ACTIONS(764), 1,
      sym_identifier,
    STATE(1340), 1,
      sym_formal_parameters,
    ACTIONS(766), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(641), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(667), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(652), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [920] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(753), 1,
      anon_sym_LPAREN,
    ACTIONS(758), 1,
      anon_sym_function,
    ACTIONS(762), 1,
      anon_sym_EQ,
    ACTIONS(791), 1,
      sym_identifier,
    ACTIONS(795), 1,
      anon_sym_EQ_GT,
    STATE(1331), 1,
      sym_formal_parameters,
    ACTIONS(793), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(641), 12,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(667), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(652), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1004] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(665), 1,
      anon_sym_EQ_GT,
    ACTIONS(709), 1,
      anon_sym_EQ,
    ACTIONS(735), 1,
      anon_sym_function,
    ACTIONS(753), 1,
      anon_sym_LPAREN,
    ACTIONS(764), 1,
      sym_identifier,
    STATE(1340), 1,
      sym_formal_parameters,
    ACTIONS(766), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(641), 12,
      sym__automatic_semicolon,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(667), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(652), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1088] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(665), 1,
      anon_sym_EQ_GT,
    ACTIONS(709), 1,
      anon_sym_EQ,
    ACTIONS(753), 1,
      anon_sym_LPAREN,
    ACTIONS(764), 1,
      sym_identifier,
    ACTIONS(768), 1,
      anon_sym_function,
    STATE(1340), 1,
      sym_formal_parameters,
    ACTIONS(766), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(641), 12,
      sym__automatic_semicolon,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(667), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(652), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1172] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 1,
      anon_sym_finally,
    STATE(274), 1,
      sym_finally_clause,
    ACTIONS(797), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(799), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1244] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(749), 1,
      sym_identifier,
    ACTIONS(753), 1,
      anon_sym_LPAREN,
    ACTIONS(758), 1,
      anon_sym_function,
    ACTIONS(760), 1,
      anon_sym_EQ_GT,
    ACTIONS(780), 1,
      anon_sym_RBRACK,
    ACTIONS(783), 1,
      anon_sym_EQ,
    ACTIONS(801), 1,
      anon_sym_COMMA,
    STATE(1353), 1,
      sym_formal_parameters,
    ACTIONS(751), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(641), 10,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(667), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(652), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1332] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(538), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1399] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(805), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1466] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(753), 1,
      anon_sym_LPAREN,
    ACTIONS(758), 1,
      anon_sym_function,
    ACTIONS(762), 1,
      anon_sym_EQ,
    ACTIONS(786), 1,
      anon_sym_in,
    ACTIONS(789), 1,
      anon_sym_of,
    ACTIONS(791), 1,
      sym_identifier,
    ACTIONS(795), 1,
      anon_sym_EQ_GT,
    STATE(1331), 1,
      sym_formal_parameters,
    ACTIONS(793), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(641), 10,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(667), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(652), 21,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1553] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(809), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1620] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(520), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1687] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(440), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(442), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1754] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 1,
      anon_sym_else,
    STATE(293), 1,
      sym_else_clause,
    ACTIONS(811), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(813), 41,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1825] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(817), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(819), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1892] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(530), 1,
      sym__automatic_semicolon,
    ACTIONS(522), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(524), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1961] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(506), 1,
      sym__automatic_semicolon,
    ACTIONS(498), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(500), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2030] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(486), 1,
      sym__automatic_semicolon,
    ACTIONS(478), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(480), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2099] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(476), 1,
      sym__automatic_semicolon,
    ACTIONS(468), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(470), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2168] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(821), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(823), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2235] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(456), 1,
      sym__automatic_semicolon,
    ACTIONS(448), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(450), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2304] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(496), 1,
      sym__automatic_semicolon,
    ACTIONS(488), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(490), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2373] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(516), 1,
      sym__automatic_semicolon,
    ACTIONS(508), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(510), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2442] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(825), 1,
      sym__automatic_semicolon,
    ACTIONS(440), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(442), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2511] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(466), 1,
      sym__automatic_semicolon,
    ACTIONS(458), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(460), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2580] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(532), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(534), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2647] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym__automatic_semicolon,
    ACTIONS(428), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(430), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2716] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(829), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(831), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2782] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2848] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2914] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2980] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3046] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3112] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(837), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(839), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3178] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3244] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3310] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(843), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3376] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3442] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3508] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3574] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3640] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3706] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3772] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3838] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(845), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(847), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3904] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(849), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(851), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3970] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(853), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(855), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4036] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(857), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(859), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4102] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(863), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4168] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(863), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4234] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4300] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4366] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4432] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(865), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(867), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4498] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(869), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(871), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4564] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(873), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(875), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4630] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(877), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(879), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4696] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(883), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4762] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(885), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(887), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4828] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(891), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4894] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(893), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(895), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4960] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(899), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5026] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(903), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5092] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(903), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5158] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(903), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5224] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(905), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(907), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5290] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(903), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5356] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(909), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(911), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5422] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(915), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5488] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(919), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5554] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(921), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(923), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5620] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(903), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5686] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(903), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5752] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(927), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5818] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(929), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(931), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5884] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5950] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(835), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6016] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(933), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(935), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6082] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(937), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(939), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6148] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(943), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6214] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(943), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6280] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(945), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(947), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6346] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(951), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6412] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(953), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(955), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6478] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(957), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(959), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6544] = 3,
    ACTIONS