#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1108
#define LARGE_STATE_COUNT 101
#define SYMBOL_COUNT 227
#define ALIAS_COUNT 0
#define TOKEN_COUNT 101
#define EXTERNAL_TOKEN_COUNT 6
#define FIELD_COUNT 26
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 96

enum {
  sym_identifier = 1,
  anon_sym_import = 2,
  anon_sym_DOT = 3,
  anon_sym_from = 4,
  anon_sym___future__ = 5,
  anon_sym_LPAREN = 6,
  anon_sym_RPAREN = 7,
  anon_sym_COMMA = 8,
  anon_sym_as = 9,
  anon_sym_STAR = 10,
  anon_sym_print = 11,
  anon_sym_GT_GT = 12,
  anon_sym_assert = 13,
  anon_sym_COLON_EQ = 14,
  anon_sym_return = 15,
  anon_sym_del = 16,
  anon_sym_raise = 17,
  anon_sym_pass = 18,
  anon_sym_break = 19,
  anon_sym_continue = 20,
  anon_sym_if = 21,
  anon_sym_COLON = 22,
  anon_sym_elif = 23,
  anon_sym_else = 24,
  anon_sym_async = 25,
  anon_sym_for = 26,
  anon_sym_in = 27,
  anon_sym_while = 28,
  anon_sym_try = 29,
  anon_sym_except = 30,
  anon_sym_finally = 31,
  anon_sym_with = 32,
  anon_sym_def = 33,
  anon_sym_DASH_GT = 34,
  anon_sym_STAR_STAR = 35,
  anon_sym_global = 36,
  anon_sym_nonlocal = 37,
  anon_sym_exec = 38,
  anon_sym_class = 39,
  anon_sym_AT = 40,
  anon_sym_LBRACK = 41,
  anon_sym_RBRACK = 42,
  anon_sym_EQ = 43,
  anon_sym_not = 44,
  anon_sym_and = 45,
  anon_sym_or = 46,
  anon_sym_PLUS = 47,
  anon_sym_DASH = 48,
  anon_sym_SLASH = 49,
  anon_sym_PERCENT = 50,
  anon_sym_SLASH_SLASH = 51,
  anon_sym_PIPE = 52,
  anon_sym_AMP = 53,
  anon_sym_CARET = 54,
  anon_sym_LT_LT = 55,
  anon_sym_TILDE = 56,
  anon_sym_LT = 57,
  anon_sym_LT_EQ = 58,
  anon_sym_EQ_EQ = 59,
  anon_sym_BANG_EQ = 60,
  anon_sym_GT_EQ = 61,
  anon_sym_GT = 62,
  anon_sym_LT_GT = 63,
  anon_sym_is = 64,
  anon_sym_lambda = 65,
  anon_sym_PLUS_EQ = 66,
  anon_sym_DASH_EQ = 67,
  anon_sym_STAR_EQ = 68,
  anon_sym_SLASH_EQ = 69,
  anon_sym_AT_EQ = 70,
  anon_sym_SLASH_SLASH_EQ = 71,
  anon_sym_PERCENT_EQ = 72,
  anon_sym_STAR_STAR_EQ = 73,
  anon_sym_GT_GT_EQ = 74,
  anon_sym_LT_LT_EQ = 75,
  anon_sym_AMP_EQ = 76,
  anon_sym_CARET_EQ = 77,
  anon_sym_PIPE_EQ = 78,
  anon_sym_yield = 79,
  sym_ellipsis = 80,
  anon_sym_LBRACE = 81,
  anon_sym_RBRACE = 82,
  sym_escape_sequence = 83,
  sym__not_escape_sequence = 84,
  aux_sym_format_specifier_token1 = 85,
  sym_type_conversion = 86,
  sym_integer = 87,
  sym_float = 88,
  anon_sym_await = 89,
  sym_true = 90,
  sym_false = 91,
  sym_none = 92,
  sym_comment = 93,
  sym__semicolon = 94,
  sym__newline = 95,
  sym__indent = 96,
  sym__dedent = 97,
  sym__string_start = 98,
  sym__string_content = 99,
  sym__string_end = 100,
  sym_module = 101,
  sym__statement = 102,
  sym__simple_statements = 103,
  sym_import_statement = 104,
  sym_import_prefix = 105,
  sym_relative_import = 106,
  sym_future_import_statement = 107,
  sym_import_from_statement = 108,
  sym__import_list = 109,
  sym_aliased_import = 110,
  sym_wildcard_import = 111,
  sym_print_statement = 112,
  sym_chevron = 113,
  sym_assert_statement = 114,
  sym_expression_statement = 115,
  sym_named_expression = 116,
  sym_return_statement = 117,
  sym_delete_statement = 118,
  sym_raise_statement = 119,
  sym_pass_statement = 120,
  sym_break_statement = 121,
  sym_continue_statement = 122,
  sym_if_statement = 123,
  sym_elif_clause = 124,
  sym_else_clause = 125,
  sym_for_statement = 126,
  sym_while_statement = 127,
  sym_try_statement = 128,
  sym_except_clause = 129,
  sym_finally_clause = 130,
  sym_with_statement = 131,
  sym_with_clause = 132,
  sym_with_item = 133,
  sym_function_definition = 134,
  sym_parameters = 135,
  sym_lambda_parameters = 136,
  sym_list_splat = 137,
  sym_dictionary_splat = 138,
  sym_global_statement = 139,
  sym_nonlocal_statement = 140,
  sym_exec_statement = 141,
  sym_class_definition = 142,
  sym_parenthesized_list_splat = 143,
  sym_argument_list = 144,
  sym_decorated_definition = 145,
  sym_decorator = 146,
  sym_block = 147,
  sym_expression_list = 148,
  sym_dotted_name = 149,
  sym__parameters = 150,
  sym__patterns = 151,
  sym_parameter = 152,
  sym_pattern = 153,
  sym_tuple_pattern = 154,
  sym_list_pattern = 155,
  sym_default_parameter = 156,
  sym_typed_default_parameter = 157,
  sym_list_splat_pattern = 158,
  sym_dictionary_splat_pattern = 159,
  sym__expression_within_for_in_clause = 160,
  sym_expression = 161,
  sym_primary_expression = 162,
  sym_not_operator = 163,
  sym_boolean_operator = 164,
  sym_binary_operator = 165,
  sym_unary_operator = 166,
  sym_comparison_operator = 167,
  sym_lambda = 168,
  sym_lambda_within_for_in_clause = 169,
  sym_assignment = 170,
  sym_augmented_assignment = 171,
  sym_pattern_list = 172,
  sym__right_hand_side = 173,
  sym_yield = 174,
  sym_attribute = 175,
  sym_subscript = 176,
  sym_slice = 177,
  sym_call = 178,
  sym_typed_parameter = 179,
  sym_type = 180,
  sym_keyword_argument = 181,
  sym_list = 182,
  sym_set = 183,
  sym_tuple = 184,
  sym_dictionary = 185,
  sym_pair = 186,
  sym_list_comprehension = 187,
  sym_dictionary_comprehension = 188,
  sym_set_comprehension = 189,
  sym_generator_expression = 190,
  sym__comprehension_clauses = 191,
  sym_parenthesized_expression = 192,
  sym__collection_elements = 193,
  sym_for_in_clause = 194,
  sym_if_clause = 195,
  sym_conditional_expression = 196,
  sym_concatenated_string = 197,
  sym_string = 198,
  sym_interpolation = 199,
  sym_format_specifier = 200,
  sym_format_expression = 201,
  sym_await = 202,
  aux_sym_module_repeat1 = 203,
  aux_sym__simple_statements_repeat1 = 204,
  aux_sym_import_prefix_repeat1 = 205,
  aux_sym__import_list_repeat1 = 206,
  aux_sym_print_statement_repeat1 = 207,
  aux_sym_assert_statement_repeat1 = 208,
  aux_sym_if_statement_repeat1 = 209,
  aux_sym_try_statement_repeat1 = 210,
  aux_sym_with_clause_repeat1 = 211,
  aux_sym_global_statement_repeat1 = 212,
  aux_sym_argument_list_repeat1 = 213,
  aux_sym_decorated_definition_repeat1 = 214,
  aux_sym_dotted_name_repeat1 = 215,
  aux_sym__parameters_repeat1 = 216,
  aux_sym__patterns_repeat1 = 217,
  aux_sym_comparison_operator_repeat1 = 218,
  aux_sym_subscript_repeat1 = 219,
  aux_sym_dictionary_repeat1 = 220,
  aux_sym__comprehension_clauses_repeat1 = 221,
  aux_sym__collection_elements_repeat1 = 222,
  aux_sym_for_in_clause_repeat1 = 223,
  aux_sym_concatenated_string_repeat1 = 224,
  aux_sym_string_repeat1 = 225,
  aux_sym_format_specifier_repeat1 = 226,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_from] = "from",
  [anon_sym___future__] = "__future__",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COMMA] = ",",
  [anon_sym_as] = "as",
  [anon_sym_STAR] = "*",
  [anon_sym_print] = "print",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_assert] = "assert",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_return] = "return",
  [anon_sym_del] = "del",
  [anon_sym_raise] = "raise",
  [anon_sym_pass] = "pass",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_if] = "if",
  [anon_sym_COLON] = ":",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_async] = "async",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_try] = "try",
  [anon_sym_except] = "except",
  [anon_sym_finally] = "finally",
  [anon_sym_with] = "with",
  [anon_sym_def] = "def",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_global] = "global",
  [anon_sym_nonlocal] = "nonlocal",
  [anon_sym_exec] = "exec",
  [anon_sym_class] = "class",
  [anon_sym_AT] = "@",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_EQ] = "=",
  [anon_sym_not] = "not",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_TILDE] = "~",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_is] = "is",
  [anon_sym_lambda] = "lambda",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AT_EQ] = "@=",
  [anon_sym_SLASH_SLASH_EQ] = "//=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_yield] = "yield",
  [sym_ellipsis] = "ellipsis",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [sym_escape_sequence] = "escape_sequence",
  [sym__not_escape_sequence] = "_not_escape_sequence",
  [aux_sym_format_specifier_token1] = "format_specifier_token1",
  [sym_type_conversion] = "type_conversion",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_await] = "await",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_none] = "none",
  [sym_comment] = "comment",
  [sym__semicolon] = "_semicolon",
  [sym__newline] = "_newline",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym__string_start] = "\"",
  [sym__string_content] = "_string_content",
  [sym__string_end] = "\"",
  [sym_module] = "module",
  [sym__statement] = "_statement",
  [sym__simple_statements] = "_simple_statements",
  [sym_import_statement] = "import_statement",
  [sym_import_prefix] = "import_prefix",
  [sym_relative_import] = "relative_import",
  [sym_future_import_statement] = "future_import_statement",
  [sym_import_from_statement] = "import_from_statement",
  [sym__import_list] = "_import_list",
  [sym_aliased_import] = "aliased_import",
  [sym_wildcard_import] = "wildcard_import",
  [sym_print_statement] = "print_statement",
  [sym_chevron] = "chevron",
  [sym_assert_statement] = "assert_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_named_expression] = "named_expression",
  [sym_return_statement] = "return_statement",
  [sym_delete_statement] = "delete_statement",
  [sym_raise_statement] = "raise_statement",
  [sym_pass_statement] = "pass_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_try_statement] = "try_statement",
  [sym_except_clause] = "except_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_with_statement] = "with_statement",
  [sym_with_clause] = "with_clause",
  [sym_with_item] = "with_item",
  [sym_function_definition] = "function_definition",
  [sym_parameters] = "parameters",
  [sym_lambda_parameters] = "lambda_parameters",
  [sym_list_splat] = "list_splat",
  [sym_dictionary_splat] = "dictionary_splat",
  [sym_global_statement] = "global_statement",
  [sym_nonlocal_statement] = "nonlocal_statement",
  [sym_exec_statement] = "exec_statement",
  [sym_class_definition] = "class_definition",
  [sym_parenthesized_list_splat] = "parenthesized_list_splat",
  [sym_argument_list] = "argument_list",
  [sym_decorated_definition] = "decorated_definition",
  [sym_decorator] = "decorator",
  [sym_block] = "block",
  [sym_expression_list] = "expression_list",
  [sym_dotted_name] = "dotted_name",
  [sym__parameters] = "_parameters",
  [sym__patterns] = "_patterns",
  [sym_parameter] = "parameter",
  [sym_pattern] = "pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_list_pattern] = "list_pattern",
  [sym_default_parameter] = "default_parameter",
  [sym_typed_default_parameter] = "typed_default_parameter",
  [sym_list_splat_pattern] = "list_splat_pattern",
  [sym_dictionary_splat_pattern] = "dictionary_splat_pattern",
  [sym__expression_within_for_in_clause] = "_expression_within_for_in_clause",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_not_operator] = "not_operator",
  [sym_boolean_operator] = "boolean_operator",
  [sym_binary_operator] = "binary_operator",
  [sym_unary_operator] = "unary_operator",
  [sym_comparison_operator] = "comparison_operator",
  [sym_lambda] = "lambda",
  [sym_lambda_within_for_in_clause] = "lambda",
  [sym_assignment] = "assignment",
  [sym_augmented_assignment] = "augmented_assignment",
  [sym_pattern_list] = "pattern_list",
  [sym__right_hand_side] = "_right_hand_side",
  [sym_yield] = "yield",
  [sym_attribute] = "attribute",
  [sym_subscript] = "subscript",
  [sym_slice] = "slice",
  [sym_call] = "call",
  [sym_typed_parameter] = "typed_parameter",
  [sym_type] = "type",
  [sym_keyword_argument] = "keyword_argument",
  [sym_list] = "list",
  [sym_set] = "set",
  [sym_tuple] = "tuple",
  [sym_dictionary] = "dictionary",
  [sym_pair] = "pair",
  [sym_list_comprehension] = "list_comprehension",
  [sym_dictionary_comprehension] = "dictionary_comprehension",
  [sym_set_comprehension] = "set_comprehension",
  [sym_generator_expression] = "generator_expression",
  [sym__comprehension_clauses] = "_comprehension_clauses",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym__collection_elements] = "_collection_elements",
  [sym_for_in_clause] = "for_in_clause",
  [sym_if_clause] = "if_clause",
  [sym_conditional_expression] = "conditional_expression",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string] = "string",
  [sym_interpolation] = "interpolation",
  [sym_format_specifier] = "format_specifier",
  [sym_format_expression] = "format_expression",
  [sym_await] = "await",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym__simple_statements_repeat1] = "_simple_statements_repeat1",
  [aux_sym_import_prefix_repeat1] = "import_prefix_repeat1",
  [aux_sym__import_list_repeat1] = "_import_list_repeat1",
  [aux_sym_print_statement_repeat1] = "print_statement_repeat1",
  [aux_sym_assert_statement_repeat1] = "assert_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_with_clause_repeat1] = "with_clause_repeat1",
  [aux_sym_global_statement_repeat1] = "global_statement_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_decorated_definition_repeat1] = "decorated_definition_repeat1",
  [aux_sym_dotted_name_repeat1] = "dotted_name_repeat1",
  [aux_sym__parameters_repeat1] = "_parameters_repeat1",
  [aux_sym__patterns_repeat1] = "_patterns_repeat1",
  [aux_sym_comparison_operator_repeat1] = "comparison_operator_repeat1",
  [aux_sym_subscript_repeat1] = "subscript_repeat1",
  [aux_sym_dictionary_repeat1] = "dictionary_repeat1",
  [aux_sym__comprehension_clauses_repeat1] = "_comprehension_clauses_repeat1",
  [aux_sym__collection_elements_repeat1] = "_collection_elements_repeat1",
  [aux_sym_for_in_clause_repeat1] = "for_in_clause_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_format_specifier_repeat1] = "format_specifier_repeat1",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_from] = anon_sym_from,
  [anon_sym___future__] = anon_sym___future__,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_print] = anon_sym_print,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_del] = anon_sym_del,
  [anon_sym_raise] = anon_sym_raise,
  [anon_sym_pass] = anon_sym_pass,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_except] = anon_sym_except,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_nonlocal] = anon_sym_nonlocal,
  [anon_sym_exec] = anon_sym_exec,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_lambda] = anon_sym_lambda,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AT_EQ] = anon_sym_AT_EQ,
  [anon_sym_SLASH_SLASH_EQ] = anon_sym_SLASH_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_yield] = anon_sym_yield,
  [sym_ellipsis] = sym_ellipsis,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__not_escape_sequence] = sym__not_escape_sequence,
  [aux_sym_format_specifier_token1] = aux_sym_format_specifier_token1,
  [sym_type_conversion] = sym_type_conversion,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_await] = anon_sym_await,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_none] = sym_none,
  [sym_comment] = sym_comment,
  [sym__semicolon] = sym__semicolon,
  [sym__newline] = sym__newline,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym__string_start] = sym__string_start,
  [sym__string_content] = sym__string_content,
  [sym__string_end] = sym__string_start,
  [sym_module] = sym_module,
  [sym__statement] = sym__statement,
  [sym__simple_statements] = sym__simple_statements,
  [sym_import_statement] = sym_import_statement,
  [sym_import_prefix] = sym_import_prefix,
  [sym_relative_import] = sym_relative_import,
  [sym_future_import_statement] = sym_future_import_statement,
  [sym_import_from_statement] = sym_import_from_statement,
  [sym__import_list] = sym__import_list,
  [sym_aliased_import] = sym_aliased_import,
  [sym_wildcard_import] = sym_wildcard_import,
  [sym_print_statement] = sym_print_statement,
  [sym_chevron] = sym_chevron,
  [sym_assert_statement] = sym_assert_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_named_expression] = sym_named_expression,
  [sym_return_statement] = sym_return_statement,
  [sym_delete_statement] = sym_delete_statement,
  [sym_raise_statement] = sym_raise_statement,
  [sym_pass_statement] = sym_pass_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_except_clause] = sym_except_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_with_statement] = sym_with_statement,
  [sym_with_clause] = sym_with_clause,
  [sym_with_item] = sym_with_item,
  [sym_function_definition] = sym_function_definition,
  [sym_parameters] = sym_parameters,
  [sym_lambda_parameters] = sym_lambda_parameters,
  [sym_list_splat] = sym_list_splat,
  [sym_dictionary_splat] = sym_dictionary_splat,
  [sym_global_statement] = sym_global_statement,
  [sym_nonlocal_statement] = sym_nonlocal_statement,
  [sym_exec_statement] = sym_exec_statement,
  [sym_class_definition] = sym_class_definition,
  [sym_parenthesized_list_splat] = sym_parenthesized_list_splat,
  [sym_argument_list] = sym_argument_list,
  [sym_decorated_definition] = sym_decorated_definition,
  [sym_decorator] = sym_decorator,
  [sym_block] = sym_block,
  [sym_expression_list] = sym_expression_list,
  [sym_dotted_name] = sym_dotted_name,
  [sym__parameters] = sym__parameters,
  [sym__patterns] = sym__patterns,
  [sym_parameter] = sym_parameter,
  [sym_pattern] = sym_pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_list_pattern] = sym_list_pattern,
  [sym_default_parameter] = sym_default_parameter,
  [sym_typed_default_parameter] = sym_typed_default_parameter,
  [sym_list_splat_pattern] = sym_list_splat_pattern,
  [sym_dictionary_splat_pattern] = sym_dictionary_splat_pattern,
  [sym__expression_within_for_in_clause] = sym__expression_within_for_in_clause,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_not_operator] = sym_not_operator,
  [sym_boolean_operator] = sym_boolean_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym_unary_operator] = sym_unary_operator,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_lambda] = sym_lambda,
  [sym_lambda_within_for_in_clause] = sym_lambda,
  [sym_assignment] = sym_assignment,
  [sym_augmented_assignment] = sym_augmented_assignment,
  [sym_pattern_list] = sym_pattern_list,
  [sym__right_hand_side] = sym__right_hand_side,
  [sym_yield] = sym_yield,
  [sym_attribute] = sym_attribute,
  [sym_subscript] = sym_subscript,
  [sym_slice] = sym_slice,
  [sym_call] = sym_call,
  [sym_typed_parameter] = sym_typed_parameter,
  [sym_type] = sym_type,
  [sym_keyword_argument] = sym_keyword_argument,
  [sym_list] = sym_list,
  [sym_set] = sym_set,
  [sym_tuple] = sym_tuple,
  [sym_dictionary] = sym_dictionary,
  [sym_pair] = sym_pair,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_dictionary_comprehension] = sym_dictionary_comprehension,
  [sym_set_comprehension] = sym_set_comprehension,
  [sym_generator_expression] = sym_generator_expression,
  [sym__comprehension_clauses] = sym__comprehension_clauses,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym__collection_elements] = sym__collection_elements,
  [sym_for_in_clause] = sym_for_in_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string] = sym_string,
  [sym_interpolation] = sym_interpolation,
  [sym_format_specifier] = sym_format_specifier,
  [sym_format_expression] = sym_format_expression,
  [sym_await] = sym_await,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym__simple_statements_repeat1] = aux_sym__simple_statements_repeat1,
  [aux_sym_import_prefix_repeat1] = aux_sym_import_prefix_repeat1,
  [aux_sym__import_list_repeat1] = aux_sym__import_list_repeat1,
  [aux_sym_print_statement_repeat1] = aux_sym_print_statement_repeat1,
  [aux_sym_assert_statement_repeat1] = aux_sym_assert_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_with_clause_repeat1] = aux_sym_with_clause_repeat1,
  [aux_sym_global_statement_repeat1] = aux_sym_global_statement_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_decorated_definition_repeat1] = aux_sym_decorated_definition_repeat1,
  [aux_sym_dotted_name_repeat1] = aux_sym_dotted_name_repeat1,
  [aux_sym__parameters_repeat1] = aux_sym__parameters_repeat1,
  [aux_sym__patterns_repeat1] = aux_sym__patterns_repeat1,
  [aux_sym_comparison_operator_repeat1] = aux_sym_comparison_operator_repeat1,
  [aux_sym_subscript_repeat1] = aux_sym_subscript_repeat1,
  [aux_sym_dictionary_repeat1] = aux_sym_dictionary_repeat1,
  [aux_sym__comprehension_clauses_repeat1] = aux_sym__comprehension_clauses_repeat1,
  [aux_sym__collection_elements_repeat1] = aux_sym__collection_elements_repeat1,
  [aux_sym_for_in_clause_repeat1] = aux_sym_for_in_clause_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_format_specifier_repeat1] = aux_sym_format_specifier_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___future__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_print] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_del] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_raise] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonlocal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lambda] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [sym_ellipsis] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__not_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_format_specifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_type_conversion] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_none] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym__string_start] = {
    .visible = true,
    .named = false,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym__string_end] = {
    .visible = true,
    .named = false,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_statements] = {
    .visible = false,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_relative_import] = {
    .visible = true,
    .named = true,
  },
  [sym_future_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_from_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__import_list] = {
    .visible = false,
    .named = true,
  },
  [sym_aliased_import] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard_import] = {
    .visible = true,
    .named = true,
  },
  [sym_print_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_chevron] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_named_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_raise_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pass_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_except_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_global_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_nonlocal_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_exec_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_decorated_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_dotted_name] = {
    .visible = true,
    .named = true,
  },
  [sym__parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__patterns] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_within_for_in_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_not_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_within_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_list] = {
    .visible = true,
    .named = true,
  },
  [sym__right_hand_side] = {
    .visible = false,
    .named = true,
  },
  [sym_yield] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_slice] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_set_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__comprehension_clauses] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__collection_elements] = {
    .visible = false,
    .named = true,
  },
  [sym_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_format_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_format_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__import_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_print_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assert_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_with_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_decorated_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dotted_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comparison_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comprehension_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__collection_elements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_in_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_cause = 7,
  field_code = 8,
  field_condition = 9,
  field_consequence = 10,
  field_definition = 11,
  field_function = 12,
  field_key = 13,
  field_left = 14,
  field_module_name = 15,
  field_name = 16,
  field_object = 17,
  field_operator = 18,
  field_operators = 19,
  field_parameters = 20,
  field_return_type = 21,
  field_right = 22,
  field_subscript = 23,
  field_superclasses = 24,
  field_type = 25,
  field_value = 26,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_cause] = "cause",
  [field_code] = "code",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_definition] = "definition",
  [field_function] = "function",
  [field_key] = "key",
  [field_left] = "left",
  [field_module_name] = "module_name",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_operators] = "operators",
  [field_parameters] = "parameters",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_subscript] = "subscript",
  [field_superclasses] = "superclasses",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 1},
  [7] = {.index = 4, .length = 1},
  [8] = {.index = 5, .length = 2},
  [10] = {.index = 7, .length = 2},
  [11] = {.index = 9, .length = 1},
  [12] = {.index = 10, .length = 1},
  [13] = {.index = 11, .length = 2},
  [14] = {.index = 13, .length = 1},
  [15] = {.index = 14, .length = 2},
  [16] = {.index = 16, .length = 1},
  [17] = {.index = 17, .length = 1},
  [18] = {.index = 18, .length = 2},
  [19] = {.index = 20, .length = 2},
  [20] = {.index = 22, .length = 2},
  [21] = {.index = 24, .length = 3},
  [22] = {.index = 27, .length = 2},
  [23] = {.index = 29, .length = 1},
  [24] = {.index = 30, .length = 2},
  [25] = {.index = 32, .length = 1},
  [26] = {.index = 33, .length = 2},
  [27] = {.index = 35, .length = 2},
  [28] = {.index = 37, .length = 1},
  [29] = {.index = 38, .length = 2},
  [30] = {.index = 40, .length = 1},
  [32] = {.index = 41, .length = 1},
  [33] = {.index = 42, .length = 2},
  [34] = {.index = 44, .length = 1},
  [35] = {.index = 45, .length = 2},
  [36] = {.index = 47, .length = 2},
  [37] = {.index = 17, .length = 1},
  [38] = {.index = 49, .length = 1},
  [39] = {.index = 50, .length = 2},
  [40] = {.index = 52, .length = 2},
  [41] = {.index = 54, .length = 1},
  [42] = {.index = 55, .length = 2},
  [43] = {.index = 57, .length = 2},
  [44] = {.index = 59, .length = 2},
  [45] = {.index = 61, .length = 2},
  [46] = {.index = 63, .length = 1},
  [47] = {.index = 64, .length = 3},
  [48] = {.index = 67, .length = 3},
  [49] = {.index = 70, .length = 3},
  [50] = {.index = 73, .length = 1},
  [51] = {.index = 74, .length = 3},
  [52] = {.index = 77, .length = 3},
  [53] = {.index = 80, .length = 2},
  [54] = {.index = 82, .length = 2},
  [55] = {.index = 84, .length = 3},
  [56] = {.index = 87, .length = 3},
  [57] = {.index = 90, .length = 3},
  [58] = {.index = 93, .length = 3},
  [59] = {.index = 18, .length = 2},
  [60] = {.index = 96, .length = 1},
  [61] = {.index = 97, .length = 3},
  [62] = {.index = 100, .length = 2},
  [63] = {.index = 102, .length = 1},
  [64] = {.index = 103, .length = 2},
  [65] = {.index = 105, .length = 2},
  [66] = {.index = 107, .length = 4},
  [67] = {.index = 111, .length = 2},
  [68] = {.index = 113, .length = 4},
  [69] = {.index = 117, .length = 4},
  [70] = {.index = 121, .length = 2},
  [71] = {.index = 123, .length = 3},
  [72] = {.index = 126, .length = 3},
  [73] = {.index = 129, .length = 4},
  [75] = {.index = 133, .length = 4},
  [76] = {.index = 137, .length = 4},
  [77] = {.index = 141, .length = 3},
  [78] = {.index = 144, .length = 2},
  [79] = {.index = 146, .length = 3},
  [80] = {.index = 149, .length = 5},
  [81] = {.index = 154, .length = 3},
  [82] = {.index = 157, .length = 4},
  [83] = {.index = 161, .length = 4},
  [84] = {.index = 165, .length = 4},
  [86] = {.index = 169, .length = 4},
  [87] = {.index = 173, .length = 3},
  [88] = {.index = 176, .length = 4},
  [89] = {.index = 180, .length = 4},
  [90] = {.index = 184, .length = 4},
  [91] = {.index = 188, .length = 5},
  [92] = {.index = 193, .length = 5},
  [93] = {.index = 198, .length = 5},
  [94] = {.index = 203, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1, .inherited = true},
  [1] =
    {field_name, 0},
  [2] =
    {field_argument, 1},
  [3] =
    {field_value, 0},
  [4] =
    {field_code, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_operators, 1, .inherited = true},
  [10] =
    {field_definition, 1},
  [11] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [13] =
    {field_argument, 2, .inherited = true},
  [14] =
    {field_argument, 1},
    {field_argument, 2, .inherited = true},
  [16] =
    {field_cause, 2},
  [17] =
    {field_body, 2},
  [18] =
    {field_name, 0},
    {field_value, 2},
  [20] =
    {field_left, 0},
    {field_type, 2},
  [22] =
    {field_left, 0},
    {field_right, 2},
  [24] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [27] =
    {field_attribute, 2},
    {field_object, 0},
  [29] =
    {field_operators, 0},
  [30] =
    {field_operators, 0, .inherited = true},
    {field_operators, 1, .inherited = true},
  [32] =
    {field_name, 1},
  [33] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [35] =
    {field_alias, 2},
    {field_name, 0},
  [37] =
    {field_name, 3, .inherited = true},
  [38] =
    {field_module_name, 1},
    {field_name, 3, .inherited = true},
  [40] =
    {field_module_name, 1},
  [41] =
    {field_body, 1},
  [42] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [44] =
    {field_cause, 3},
  [45] =
    {field_condition, 1},
    {field_consequence, 3},
  [47] =
    {field_body, 3},
    {field_condition, 1},
  [49] =
    {field_body, 3},
  [50] =
    {field_alias, 2},
    {field_value, 0},
  [52] =
    {field_body, 3},
    {field_name, 1},
  [54] =
    {field_type, 2},
  [55] =
    {field_body, 3},
    {field_parameters, 1},
  [57] =
    {field_key, 0},
    {field_value, 2},
  [59] =
    {field_subscript, 2},
    {field_value, 0},
  [61] =
    {field_operators, 0},
    {field_operators, 1},
  [63] =
    {field_alternative, 0},
  [64] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [67] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [70] =
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [73] =
    {field_body, 4},
  [74] =
    {field_alternative, 4},
    {field_body, 3},
    {field_condition, 1},
  [77] =
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [80] =
    {field_body, 2},
    {field_body, 3},
  [82] =
    {field_body, 3},
    {field_body, 4},
  [84] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [87] =
    {field_body, 3},
    {field_body, 4},
    {field_name, 1},
  [90] =
    {field_body, 4},
    {field_name, 1},
    {field_superclasses, 2},
  [93] =
    {field_left, 0},
    {field_right, 4},
    {field_type, 2},
  [96] =
    {field_subscript, 1},
  [97] =
    {field_subscript, 2},
    {field_subscript, 3, .inherited = true},
    {field_value, 0},
  [100] =
    {field_subscript, 0, .inherited = true},
    {field_subscript, 1, .inherited = true},
  [102] =
    {field_name, 4, .inherited = true},
  [103] =
    {field_module_name, 1},
    {field_name, 4, .inherited = true},
  [105] =
    {field_left, 1},
    {field_right, 3},
  [107] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [111] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [113] =
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [117] =
    {field_alternative, 5, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [121] =
    {field_body, 4},
    {field_body, 5},
  [123] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [126] =
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [129] =
    {field_alternative, 5},
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [133] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
  [137] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_superclasses, 2},
  [141] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 4},
  [144] =
    {field_left, 2},
    {field_right, 4},
  [146] =
    {field_left, 1},
    {field_right, 3},
    {field_right, 4},
  [149] =
    {field_alternative, 5, .inherited = true},
    {field_alternative, 6},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [154] =
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [157] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
  [161] =
    {field_alternative, 6},
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [165] =
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [169] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [173] =
    {field_left, 2},
    {field_right, 4},
    {field_right, 5},
  [176] =
    {field_alternative, 7},
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [180] =
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [184] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [188] =
    {field_alternative, 7},
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [193] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [198] =
    {field_alternative, 8},
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [203] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [4] = {
    [1] = sym_identifier,
  },
  [9] = {
    [0] = sym_list_splat_pattern,
  },
  [31] = {
    [1] = sym_parenthesized_expression,
  },
  [35] = {
    [3] = sym_block,
  },
  [36] = {
    [3] = sym_block,
  },
  [37] = {
    [2] = sym_block,
  },
  [38] = {
    [3] = sym_block,
  },
  [40] = {
    [3] = sym_block,
  },
  [47] = {
    [3] = sym_block,
  },
  [48] = {
    [3] = sym_block,
  },
  [50] = {
    [4] = sym_block,
  },
  [51] = {
    [3] = sym_block,
  },
  [55] = {
    [4] = sym_block,
  },
  [57] = {
    [4] = sym_block,
  },
  [59] = {
    [0] = sym_identifier,
  },
  [66] = {
    [3] = sym_block,
  },
  [71] = {
    [5] = sym_block,
  },
  [72] = {
    [5] = sym_block,
  },
  [74] = {
    [2] = sym_block,
  },
  [81] = {
    [6] = sym_block,
  },
  [83] = {
    [5] = sym_block,
  },
  [85] = {
    [3] = sym_block,
  },
  [86] = {
    [6] = sym_block,
  },
  [88] = {
    [6] = sym_block,
  },
  [90] = {
    [7] = sym_block,
  },
  [95] = {
    [5] = sym_block,
  },
};

static uint16_t ts_non_terminal_alias_map[] = {
  sym__simple_statements, 2,
    sym__simple_statements,
    sym_block,
  sym_parenthesized_list_splat, 2,
    sym_parenthesized_list_splat,
    sym_parenthesized_expression,
  0,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 43020
    ? (c < 4096
      ? (c < 2693
        ? (c < 1969
          ? (c < 910
            ? (c < 736
              ? (c < 186
                ? (c < 170
                  ? (c < 'a'
                    ? (c >= 'A' && c <= '_')
                    : c <= 'z')
                  : (c <= 170 || c == 181))
                : (c <= 186 || (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))))
              : (c <= 740 || (c < 891
                ? (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c >= 886 && c <= 887)))
                : (c <= 893 || (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || c == 908))))))
            : (c <= 929 || (c < 1646
              ? (c < 1369
                ? (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c >= 1329 && c <= 1366)))
                : (c <= 1369 || (c < 1519
                  ? (c < 1488
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))))
              : (c <= 1647 || (c < 1786
                ? (c < 1765
                  ? (c < 1749
                    ? (c >= 1649 && c <= 1747)
                    : c <= 1749)
                  : (c <= 1766 || (c >= 1774 && c <= 1775)))
                : (c <= 1788 || (c < 1810
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1808)
                  : (c <= 1839 || (c >= 1869 && c <= 1957)))))))))
          : (c <= 1969 || (c < 2474
            ? (c < 2208
              ? (c < 2074
                ? (c < 2042
                  ? (c < 2036
                    ? (c >= 1994 && c <= 2026)
                    : c <= 2037)
                  : (c <= 2042 || (c >= 2048 && c <= 2069)))
                : (c <= 2074 || (c < 2112
                  ? (c < 2088
                    ? c == 2084
                    : c <= 2088)
                  : (c <= 2136 || (c >= 2144 && c <= 2154)))))
              : (c <= 2228 || (c < 2392
                ? (c < 2365
                  ? (c < 2308
                    ? (c >= 2230 && c <= 2247)
                    : c <= 2361)
                  : (c <= 2365 || c == 2384))
                : (c <= 2401 || (c < 2447
                  ? (c < 2437
                    ? (c >= 2417 && c <= 2432)
                    : c <= 2444)
                  : (c <= 2448 || (c >= 2451 && c <= 2472)))))))
            : (c <= 2480 || (c < 2575
              ? (c < 2524
                ? (c < 2493
                  ? (c < 2486
                    ? c == 2482
                    : c <= 2489)
                  : (c <= 2493 || c == 2510))
                : (c <= 2525 || (c < 2556
                  ? (c < 2544
                    ? (c >= 2527 && c <= 2529)
                    : c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))))
              : (c <= 2576 || (c < 2616
                ? (c < 2610
                  ? (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)
                  : (c <= 2611 || (c >= 2613 && c <= 2614)))
                : (c <= 2617 || (c < 2654
                  ? (c >= 2649 && c <= 2652)
                  : (c <= 2654 || (c >= 2674 && c <= 2676)))))))))))
        : (c <= 2701 || (c < 3214
          ? (c < 2947
            ? (c < 2821
              ? (c < 2741
                ? (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c >= 2738 && c <= 2739)))
                : (c <= 2745 || (c < 2784
                  ? (c < 2768
                    ? c == 2749
                    : c <= 2768)
                  : (c <= 2785 || c == 2809))))
              : (c <= 2828 || (c < 2869
                ? (c < 2858
                  ? (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)
                  : (c <= 2864 || (c >= 2866 && c <= 2867)))
                : (c <= 2873 || (c < 2911
                  ? (c < 2908
                    ? c == 2877
                    : c <= 2909)
                  : (c <= 2913 || c == 2929))))))
            : (c <= 2947 || (c < 3024
              ? (c < 2972
                ? (c < 2962
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)
                  : (c <= 2965 || (c >= 2969 && c <= 2970)))
                : (c <= 2972 || (c < 2984
                  ? (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)
                  : (c <= 2986 || (c >= 2990 && c <= 3001)))))
              : (c <= 3024 || (c < 3133
                ? (c < 3090
                  ? (c < 3086
                    ? (c >= 3077 && c <= 3084)
                    : c <= 3088)
                  : (c <= 3112 || (c >= 3114 && c <= 3129)))
                : (c <= 3133 || (c < 3200
                  ? (c < 3168
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3169)
                  : (c <= 3200 || (c >= 3205 && c <= 3212)))))))))
          : (c <= 3216 || (c < 3520
            ? (c < 3346
              ? (c < 3294
                ? (c < 3253
                  ? (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)
                  : (c <= 3257 || c == 3261))
                : (c <= 3294 || (c < 3332
                  ? (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)
                  : (c <= 3340 || (c >= 3342 && c <= 3344)))))
              : (c <= 3386 || (c < 3450
                ? (c < 3412
                  ? (c < 3406
                    ? c == 3389
                    : c <= 3406)
                  : (c <= 3414 || (c >= 3423 && c <= 3425)))
                : (c <= 3455 || (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || c == 3517))))))
            : (c <= 3526 || (c < 3762
              ? (c < 3716
                ? (c < 3648
                  ? (c < 3634
                    ? (c >= 3585 && c <= 3632)
                    : c <= 3634)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c >= 3751 && c <= 3760)))))
              : (c <= 3762 || (c < 3840
                ? (c < 3782
                  ? (c < 3776
                    ? c == 3773
                    : c <= 3780)
                  : (c <= 3782 || (c >= 3804 && c <= 3807)))
                : (c <= 3840 || (c < 3913
                  ? (c >= 3904 && c <= 3911)
                  : (c <= 3948 || (c >= 3976 && c <= 3980)))))))))))))
      : (c <= 4138 || (c < 8025
        ? (c < 5952
          ? (c < 4752
            ? (c < 4295
              ? (c < 4197
                ? (c < 4186
                  ? (c < 4176
                    ? c == 4159
                    : c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4238
                  ? (c < 4213
                    ? (c >= 4206 && c <= 4208)
                    : c <= 4225)
                  : (c <= 4238 || (c >= 4256 && c <= 4293)))))
              : (c <= 4295 || (c < 4688
                ? (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))
                : (c <= 4694 || (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))))))
            : (c <= 4784 || (c < 5024
              ? (c < 4808
                ? (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))
                : (c <= 4822 || (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))))
              : (c <= 5109 || (c < 5792
                ? (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))
                : (c <= 5866 || (c < 5902
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5900)
                  : (c <= 5905 || (c >= 5920 && c <= 5937)))))))))
          : (c <= 5969 || (c < 7043
            ? (c < 6400
              ? (c < 6108
                ? (c < 6016
                  ? (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : c <= 6000)
                  : (c <= 6067 || c == 6103))
                : (c <= 6108 || (c < 6314
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6312)
                  : (c <= 6314 || (c >= 6320 && c <= 6389)))))
              : (c <= 6430 || (c < 6656
                ? (c < 6528
                  ? (c < 6512
                    ? (c >= 6480 && c <= 6509)
                    : c <= 6516)
                  : (c <= 6571 || (c >= 6576 && c <= 6601)))
                : (c <= 6678 || (c < 6917
                  ? (c < 6823
                    ? (c >= 6688 && c <= 6740)
                    : c <= 6823)
                  : (c <= 6963 || (c >= 6981 && c <= 6987)))))))
            : (c <= 7072 || (c < 7406
              ? (c < 7258
                ? (c < 7168
                  ? (c < 7098
                    ? (c >= 7086 && c <= 7087)
                    : c <= 7141)
                  : (c <= 7203 || (c >= 7245 && c <= 7247)))
                : (c <= 7293 || (c < 7357
                  ? (c < 7312
                    ? (c >= 7296 && c <= 7304)
                    : c <= 7354)
                  : (c <= 7359 || (c >= 7401 && c <= 7404)))))
              : (c <= 7411 || (c < 7960
                ? (c < 7424
                  ? (c < 7418
                    ? (c >= 7413 && c <= 7414)
                    : c <= 7418)
                  : (c <= 7615 || (c >= 7680 && c <= 7957)))
                : (c <= 7965 || (c < 8008
                  ? (c >= 7968 && c <= 8005)
                  : (c <= 8013 || (c >= 8016 && c <= 8023)))))))))))
        : (c <= 8025 || (c < 11631
          ? (c < 8469
            ? (c < 8150
              ? (c < 8118
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c >= 8064 && c <= 8116)))
                : (c <= 8124 || (c < 8134
                  ? (c < 8130
                    ? c == 8126
                    : c <= 8132)
                  : (c <= 8140 || (c >= 8144 && c <= 8147)))))
              : (c <= 8155 || (c < 8319
                ? (c < 8182
                  ? (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8455
                  ? (c < 8450
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8450)
                  : (c <= 8455 || (c >= 8458 && c <= 8467)))))))
            : (c <= 8469 || (c < 11264
              ? (c < 8490
                ? (c < 8486
                  ? (c < 8484
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8484)
                  : (c <= 8486 || c == 8488))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c >= 8544 && c <= 8584)))))
              : (c <= 11310 || (c < 11520
                ? (c < 11499
                  ? (c < 11360
                    ? (c >= 11312 && c <= 11358)
                    : c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : (c <= 11565 || (c >= 11568 && c <= 11623)))))))))
          : (c <= 11631 || (c < 12704
            ? (c < 12293
              ? (c < 11704
                ? (c < 11688
                  ? (c < 11680
                    ? (c >= 11648 && c <= 11670)
                    : c <= 11686)
                  : (c <= 11694 || (c >= 11696 && c <= 11702)))
                : (c <= 11710 || (c < 11728
                  ? (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))))
              : (c <= 12295 || (c < 12445
                ? (c < 12344
                  ? (c < 12337
                    ? (c >= 12321 && c <= 12329)
                    : c <= 12341)
                  : (c <= 12348 || (c >= 12353 && c <= 12438)))
                : (c <= 12447 || (c < 12549
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)
                  : (c <= 12591 || (c >= 12593 && c <= 12686)))))))
            : (c <= 12735 || (c < 42623
              ? (c < 42192
                ? (c < 19968
                  ? (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)
                  : (c <= 40956 || (c >= 40960 && c <= 42124)))
                : (c <= 42237 || (c < 42538
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))))
              : (c <= 42653 || (c < 42946
                ? (c < 42786
                  ? (c < 42775
                    ? (c >= 42656 && c <= 42735)
                    : c <= 42783)
                  : (c <= 42888 || (c >= 42891 && c <= 42943)))
                : (c <= 42954 || (c < 43011
                  ? (c >= 42997 && c <= 43009)
                  : (c <= 43013 || (c >= 43015 && c <= 43018)))))))))))))))
    : (c <= 43042 || (c < 70453
      ? (c < 66176
        ? (c < 64112
          ? (c < 43697
            ? (c < 43471
              ? (c < 43261
                ? (c < 43250
                  ? (c < 43138
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43187)
                  : (c <= 43255 || c == 43259))
                : (c <= 43262 || (c < 43360
                  ? (c < 43312
                    ? (c >= 43274 && c <= 43301)
                    : c <= 43334)
                  : (c <= 43388 || (c >= 43396 && c <= 43442)))))
              : (c <= 43471 || (c < 43584
                ? (c < 43514
                  ? (c < 43494
                    ? (c >= 43488 && c <= 43492)
                    : c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43642
                  ? (c < 43616
                    ? (c >= 43588 && c <= 43595)
                    : c <= 43638)
                  : (c <= 43642 || (c >= 43646 && c <= 43695)))))))
            : (c <= 43697 || (c < 43793
              ? (c < 43739
                ? (c < 43712
                  ? (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)
                  : (c <= 43712 || c == 43714))
                : (c <= 43741 || (c < 43777
                  ? (c < 43762
                    ? (c >= 43744 && c <= 43754)
                    : c <= 43764)
                  : (c <= 43782 || (c >= 43785 && c <= 43790)))))
              : (c <= 43798 || (c < 43888
                ? (c < 43824
                  ? (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55243
                  ? (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)
                  : (c <= 55291 || (c >= 63744 && c <= 64109)))))))))
          : (c <= 64217 || (c < 65147
            ? (c < 64326
              ? (c < 64298
                ? (c < 64285
                  ? (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)
                  : (c <= 64285 || (c >= 64287 && c <= 64296)))
                : (c <= 64310 || (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c >= 64323 && c <= 64324)))))
              : (c <= 64433 || (c < 65008
                ? (c < 64848
                  ? (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)
                  : (c <= 64911 || (c >= 64914 && c <= 64967)))
                : (c <= 65017 || (c < 65143
                  ? (c < 65139
                    ? c == 65137
                    : c <= 65139)
                  : (c <= 65143 || c == 65145))))))
            : (c <= 65147 || (c < 65498
              ? (c < 65382
                ? (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))
                : (c <= 65437 || (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))))
              : (c <= 65500 || (c < 65599
                ? (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : (c <= 65786 || (c >= 65856 && c <= 65908)))))))))))
        : (c <= 66204 || (c < 68416
          ? (c < 67639
            ? (c < 66736
              ? (c < 66432
                ? (c < 66349
                  ? (c < 66304
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66335)
                  : (c <= 66378 || (c >= 66384 && c <= 66421)))
                : (c <= 66461 || (c < 66513
                  ? (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)
                  : (c <= 66517 || (c >= 66560 && c <= 66717)))))
              : (c <= 66771 || (c < 67392
                ? (c < 66864
                  ? (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)
                  : (c <= 66915 || (c >= 67072 && c <= 67382)))
                : (c <= 67413 || (c < 67592
                  ? (c < 67584
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))))))
            : (c <= 67640 || (c < 68030
              ? (c < 67808
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c >= 67712 && c <= 67742)))
                : (c <= 67826 || (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c >= 67968 && c <= 68023)))))
              : (c <= 68031 || (c < 68192
                ? (c < 68117
                  ? (c < 68112
                    ? c == 68096
                    : c <= 68115)
                  : (c <= 68119 || (c >= 68121 && c <= 68149)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68324 || (c >= 68352 && c <= 68405)))))))))
          : (c <= 68437 || (c < 69968
            ? (c < 69415
              ? (c < 68800
                ? (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c >= 68736 && c <= 68786)))
                : (c <= 68850 || (c < 69296
                  ? (c < 69248
                    ? (c >= 68864 && c <= 68899)
                    : c <= 69289)
                  : (c <= 69297 || (c >= 69376 && c <= 69404)))))
              : (c <= 69415 || (c < 69763
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69424 && c <= 69445)
                    : c <= 69572)
                  : (c <= 69622 || (c >= 69635 && c <= 69687)))
                : (c <= 69807 || (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || c == 69959))))))
            : (c <= 70002 || (c < 70282
              ? (c < 70108
                ? (c < 70081
                  ? (c < 70019
                    ? c == 70006
                    : c <= 70066)
                  : (c <= 70084 || c == 70106))
                : (c <= 70108 || (c < 70272
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)
                  : (c <= 70278 || c == 70280))))
              : (c <= 70285 || (c < 70415
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70366 || (c >= 70405 && c <= 70412)))
                : (c <= 70416 || (c < 70442
                  ? (c >= 70419 && c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))))))))))))
      : (c <= 70457 || (c < 113808
        ? (c < 72818
          ? (c < 71945
            ? (c < 71040
              ? (c < 70727
                ? (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))
                : (c <= 70730 || (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || c == 70855))))
              : (c <= 71086 || (c < 71352
                ? (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71131)
                    : c <= 71215)
                  : (c <= 71236 || (c >= 71296 && c <= 71338)))
                : (c <= 71352 || (c < 71840
                  ? (c < 71680
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))))))
            : (c <= 71945 || (c < 72192
              ? (c < 72001
                ? (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))
                : (c <= 72001 || (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))))
              : (c <= 72192 || (c < 72349
                ? (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))
                : (c <= 72349 || (c < 72714
                  ? (c < 72704
                    ? (c >= 72384 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))))))))
          : (c <= 72847 || (c < 92992
            ? (c < 73648
              ? (c < 73056
                ? (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))
                : (c <= 73061 || (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c >= 73440 && c <= 73458)))))
              : (c <= 73648 || (c < 82944
                ? (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c >= 77824 && c <= 78894)))
                : (c <= 83526 || (c < 92880
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92909 || (c >= 92928 && c <= 92975)))))))
            : (c <= 92995 || (c < 100352
              ? (c < 94032
                ? (c < 93760
                  ? (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)
                  : (c <= 93823 || (c >= 93952 && c <= 94026)))
                : (c <= 94032 || (c < 94179
                  ? (c < 94176
                    ? (c >= 94099 && c <= 94111)
                    : c <= 94177)
                  : (c <= 94179 || (c >= 94208 && c <= 100343)))))
              : (c <= 101589 || (c < 110960
                ? (c < 110928
                  ? (c < 110592
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110878)
                  : (c <= 110930 || (c >= 110948 && c <= 110951)))
                : (c <= 111355 || (c < 113776
                  ? (c >= 113664 && c <= 113770)
                  : (c <= 113788 || (c >= 113792 && c <= 113800)))))))))))
        : (c <= 113817 || (c < 126469
          ? (c < 120488
            ? (c < 120005
              ? (c < 119973
                ? (c < 119966
                  ? (c < 119894
                    ? (c >= 119808 && c <= 119892)
                    : c <= 119964)
                  : (c <= 119967 || c == 119970))
                : (c <= 119974 || (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c >= 119997 && c <= 120003)))))
              : (c <= 120069 || (c < 120123
                ? (c < 120086
                  ? (c < 120077
                    ? (c >= 120071 && c <= 120074)
                    : c <= 120084)
                  : (c <= 120092 || (c >= 120094 && c <= 120121)))
                : (c <= 120126 || (c < 120138
                  ? (c < 120134
                    ? (c >= 120128 && c <= 120132)
                    : c <= 120134)
                  : (c <= 120144 || (c >= 120146 && c <= 120485)))))))
            : (c <= 120512 || (c < 120772
              ? (c < 120630
                ? (c < 120572
                  ? (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)
                  : (c <= 120596 || (c >= 120598 && c <= 120628)))
                : (c <= 120654 || (c < 120714
                  ? (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)
                  : (c <= 120744 || (c >= 120746 && c <= 120770)))))
              : (c <= 120779 || (c < 124928
                ? (c < 123214
                  ? (c < 123191
                    ? (c >= 123136 && c <= 123180)
                    : c <= 123197)
                  : (c <= 123214 || (c >= 123584 && c <= 123627)))
                : (c <= 125124 || (c < 125259
                  ? (c >= 125184 && c <= 125251)
                  : (c <= 125259 || (c >= 126464 && c <= 126467)))))))))
          : (c <= 126495 || (c < 126561
            ? (c < 126537
              ? (c < 126516
                ? (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c >= 126505 && c <= 126514)))
                : (c <= 126519 || (c < 126530
                  ? (c < 126523
                    ? c == 126521
                    : c <= 126523)
                  : (c <= 126530 || c == 126535))))
              : (c <= 126537 || (c < 126551
                ? (c < 126545
                  ? (c < 126541
                    ? c == 126539
                    : c <= 126543)
                  : (c <= 126546 || c == 126548))
                : (c <= 126551 || (c < 126557
                  ? (c < 126555
                    ? c == 126553
                    : c <= 126555)
                  : (c <= 126557 || c == 126559))))))
            : (c <= 126562 || (c < 126629
              ? (c < 126585
                ? (c < 126572
                  ? (c < 126567
                    ? c == 126564
                    : c <= 126570)
                  : (c <= 126578 || (c >= 126580 && c <= 126583)))
                : (c <= 126588 || (c < 126603
                  ? (c < 126592
                    ? c == 126590
                    : c <= 126601)
                  : (c <= 126619 || (c >= 126625 && c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 173824
                  ? (c < 131072
                    ? (c >= 126635 && c <= 126651)
                    : c <= 173789)
                  : (c <= 177972 || (c >= 177984 && c <= 178205)))
                : (c <= 183969 || (c < 194560
                  ? (c >= 183984 && c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 43052
    ? (c < 3718
      ? (c < 2730
        ? (c < 2042
          ? (c < 1015
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'A'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'a' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 192
                  ? (c < 186
                    ? c == 183
                    : c <= 186)
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 908
                  ? (c < 902
                    ? c == 895
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))))))
            : (c <= 1153 || (c < 1519
              ? (c < 1425
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))
                : (c <= 1469 || (c < 1476
                  ? (c < 1473
                    ? c == 1471
                    : c <= 1474)
                  : (c <= 1477 || (c < 1488
                    ? c == 1479
                    : c <= 1514)))))
              : (c <= 1522 || (c < 1770
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)
                  : (c <= 1747 || (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)))
                : (c <= 1788 || (c < 1869
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1866)
                  : (c <= 1969 || (c >= 1984 && c <= 2037)))))))))
          : (c <= 2042 || (c < 2534
            ? (c < 2447
              ? (c < 2230
                ? (c < 2112
                  ? (c < 2048
                    ? c == 2045
                    : c <= 2093)
                  : (c <= 2139 || (c < 2208
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2228)))
                : (c <= 2247 || (c < 2406
                  ? (c < 2275
                    ? (c >= 2259 && c <= 2273)
                    : c <= 2403)
                  : (c <= 2415 || (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)))))
              : (c <= 2448 || (c < 2503
                ? (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)))
                : (c <= 2504 || (c < 2524
                  ? (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)
                  : (c <= 2525 || (c >= 2527 && c <= 2531)))))))
            : (c <= 2545 || (c < 2622
              ? (c < 2579
                ? (c < 2561
                  ? (c < 2558
                    ? c == 2556
                    : c <= 2558)
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))
                : (c <= 2600 || (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)))))
              : (c <= 2626 || (c < 2662
                ? (c < 2641
                  ? (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)
                  : (c <= 2641 || (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)))
                : (c <= 2677 || (c < 2703
                  ? (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)
                  : (c <= 2705 || (c >= 2707 && c <= 2728)))))))))))
        : (c <= 2736 || (c < 3142
          ? (c < 2918
            ? (c < 2831
              ? (c < 2768
                ? (c < 2748
                  ? (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)
                  : (c <= 2757 || (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)))
                : (c <= 2768 || (c < 2809
                  ? (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)
                  : (c <= 2815 || (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)))))
              : (c <= 2832 || (c < 2887
                ? (c < 2866
                  ? (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)
                  : (c <= 2867 || (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)))
                : (c <= 2888 || (c < 2908
                  ? (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)
                  : (c <= 2909 || (c >= 2911 && c <= 2915)))))))
            : (c <= 2927 || (c < 3006
              ? (c < 2969
                ? (c < 2949
                  ? (c < 2946
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)))
                : (c <= 2970 || (c < 2979
                  ? (c < 2974
                    ? c == 2972
                    : c <= 2975)
                  : (c <= 2980 || (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)))))
              : (c <= 3010 || (c < 3072
                ? (c < 3024
                  ? (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)
                  : (c <= 3024 || (c < 3046
                    ? c == 3031
                    : c <= 3055)))
                : (c <= 3084 || (c < 3114
                  ? (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)
                  : (c <= 3129 || (c >= 3133 && c <= 3140)))))))))
          : (c <= 3144 || (c < 3398
            ? (c < 3260
              ? (c < 3200
                ? (c < 3160
                  ? (c < 3157
                    ? (c >= 3146 && c <= 3149)
                    : c <= 3158)
                  : (c <= 3162 || (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)))
                : (c <= 3203 || (c < 3218
                  ? (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)
                  : (c <= 3240 || (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)))))
              : (c <= 3268 || (c < 3302
                ? (c < 3285
                  ? (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)
                  : (c <= 3286 || (c < 3296
                    ? c == 3294
                    : c <= 3299)))
                : (c <= 3311 || (c < 3342
                  ? (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)
                  : (c <= 3344 || (c >= 3346 && c <= 3396)))))))
            : (c <= 3400 || (c < 3530
              ? (c < 3457
                ? (c < 3423
                  ? (c < 3412
                    ? (c >= 3402 && c <= 3406)
                    : c <= 3415)
                  : (c <= 3427 || (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)))
                : (c <= 3459 || (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || (c < 3520
                    ? c == 3517
                    : c <= 3526)))))
              : (c <= 3530 || (c < 3585
                ? (c < 3544
                  ? (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)
                  : (c <= 3551 || (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)))
                : (c <= 3642 || (c < 3713
                  ? (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)
                  : (c <= 3714 || c == 3716))))))))))))
      : (c <= 3722 || (c < 7296
        ? (c < 5024
          ? (c < 4256
            ? (c < 3893
              ? (c < 3784
                ? (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3773 || (c < 3782
                    ? (c >= 3776 && c <= 3780)
                    : c <= 3782)))
                : (c <= 3789 || (c < 3840
                  ? (c < 3804
                    ? (c >= 3792 && c <= 3801)
                    : c <= 3807)
                  : (c <= 3840 || (c < 3872
                    ? (c >= 3864 && c <= 3865)
                    : c <= 3881)))))
              : (c <= 3893 || (c < 3974
                ? (c < 3902
                  ? (c < 3897
                    ? c == 3895
                    : c <= 3897)
                  : (c <= 3911 || (c < 3953
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3972)))
                : (c <= 3991 || (c < 4096
                  ? (c < 4038
                    ? (c >= 3993 && c <= 4028)
                    : c <= 4038)
                  : (c <= 4169 || (c >= 4176 && c <= 4253)))))))
            : (c <= 4293 || (c < 4786
              ? (c < 4688
                ? (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))
                : (c <= 4694 || (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))))
              : (c <= 4789 || (c < 4882
                ? (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))
                : (c <= 4885 || (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c >= 4992 && c <= 5007)))))))))
          : (c <= 5109 || (c < 6400
            ? (c < 5998
              ? (c < 5870
                ? (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)))
                : (c <= 5880 || (c < 5920
                  ? (c < 5902
                    ? (c >= 5888 && c <= 5900)
                    : c <= 5908)
                  : (c <= 5940 || (c < 5984
                    ? (c >= 5952 && c <= 5971)
                    : c <= 5996)))))
              : (c <= 6000 || (c < 6155
                ? (c < 6103
                  ? (c < 6016
                    ? (c >= 6002 && c <= 6003)
                    : c <= 6099)
                  : (c <= 6103 || (c < 6112
                    ? (c >= 6108 && c <= 6109)
                    : c <= 6121)))
                : (c <= 6157 || (c < 6272
                  ? (c < 6176
                    ? (c >= 6160 && c <= 6169)
                    : c <= 6264)
                  : (c <= 6314 || (c >= 6320 && c <= 6389)))))))
            : (c <= 6430 || (c < 6800
              ? (c < 6576
                ? (c < 6470
                  ? (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)
                  : (c <= 6509 || (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)))
                : (c <= 6601 || (c < 6688
                  ? (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)
                  : (c <= 6750 || (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)))))
              : (c <= 6809 || (c < 7019
                ? (c < 6847
                  ? (c < 6832
                    ? c == 6823
                    : c <= 6845)
                  : (c <= 6848 || (c < 6992
                    ? (c >= 6912 && c <= 6987)
                    : c <= 7001)))
                : (c <= 7027 || (c < 7232
                  ? (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)
                  : (c <= 7241 || (c >= 7245 && c <= 7293)))))))))))
        : (c <= 7304 || (c < 11264
          ? (c < 8178
            ? (c < 8027
              ? (c < 7675
                ? (c < 7376
                  ? (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)
                  : (c <= 7378 || (c < 7424
                    ? (c >= 7380 && c <= 7418)
                    : c <= 7673)))
                : (c <= 7957 || (c < 8008
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)
                  : (c <= 8013 || (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)))))
              : (c <= 8027 || (c < 8130
                ? (c < 8064
                  ? (c < 8031
                    ? c == 8029
                    : c <= 8061)
                  : (c <= 8116 || (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)))
                : (c <= 8132 || (c < 8150
                  ? (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)
                  : (c <= 8155 || (c >= 8160 && c <= 8172)))))))
            : (c <= 8180 || (c < 8458
              ? (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))
              : (c <= 8467 || (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c >= 8544 && c <= 8584)))))))))
          : (c <= 11310 || (c < 12353
            ? (c < 11696
              ? (c < 11565
                ? (c < 11499
                  ? (c < 11360
                    ? (c >= 11312 && c <= 11358)
                    : c <= 11492)
                  : (c <= 11507 || (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)))
                : (c <= 11565 || (c < 11647
                  ? (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)
                  : (c <= 11670 || (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)))))
              : (c <= 11702 || (c < 11744
                ? (c < 11720
                  ? (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)
                  : (c <= 11726 || (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)))
                : (c <= 11775 || (c < 12337
                  ? (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)
                  : (c <= 12341 || (c >= 12344 && c <= 12348)))))))
            : (c <= 12438 || (c < 42192
              ? (c < 12593
                ? (c < 12449
                  ? (c < 12445
                    ? (c >= 12441 && c <= 12442)
                    : c <= 12447)
                  : (c <= 12538 || (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)))
                : (c <= 12686 || (c < 13312
                  ? (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)
                  : (c <= 19903 || (c < 40960
                    ? (c >= 19968 && c <= 40956)
                    : c <= 42124)))))
              : (c <= 42237 || (c < 42775
                ? (c < 42560
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42539)
                  : (c <= 42607 || (c < 42623
                    ? (c >= 42612 && c <= 42621)
                    : c <= 42737)))
                : (c <= 42783 || (c < 42946
                  ? (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42943)
                  : (c <= 42954 || (c >= 42997 && c <= 43047)))))))))))))))
    : (c <= 43052 || (c < 71096
      ? (c < 66864
        ? (c < 64914
          ? (c < 43816
            ? (c < 43520
              ? (c < 43261
                ? (c < 43216
                  ? (c < 43136
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43205)
                  : (c <= 43225 || (c < 43259
                    ? (c >= 43232 && c <= 43255)
                    : c <= 43259)))
                : (c <= 43309 || (c < 43392
                  ? (c < 43360
                    ? (c >= 43312 && c <= 43347)
                    : c <= 43388)
                  : (c <= 43456 || (c < 43488
                    ? (c >= 43471 && c <= 43481)
                    : c <= 43518)))))
              : (c <= 43574 || (c < 43744
                ? (c < 43616
                  ? (c < 43600
                    ? (c >= 43584 && c <= 43597)
                    : c <= 43609)
                  : (c <= 43638 || (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)))
                : (c <= 43759 || (c < 43785
                  ? (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)
                  : (c <= 43790 || (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)))))))
            : (c <= 43822 || (c < 64275
              ? (c < 44032
                ? (c < 43888
                  ? (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)
                  : (c <= 44010 || (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)))
                : (c <= 55203 || (c < 63744
                  ? (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)
                  : (c <= 64109 || (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)))))
              : (c <= 64279 || (c < 64323
                ? (c < 64312
                  ? (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)
                  : (c <= 64316 || (c < 64320
                    ? c == 64318
                    : c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65549
            ? (c < 65151
              ? (c < 65137
                ? (c < 65056
                  ? (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65039)
                  : (c <= 65071 || (c < 65101
                    ? (c >= 65075 && c <= 65076)
                    : c <= 65103)))
                : (c <= 65137 || (c < 65145
                  ? (c < 65143
                    ? c == 65139
                    : c <= 65143)
                  : (c <= 65145 || (c < 65149
                    ? c == 65147
                    : c <= 65149)))))
              : (c <= 65276 || (c < 65474
                ? (c < 65343
                  ? (c < 65313
                    ? (c >= 65296 && c <= 65305)
                    : c <= 65338)
                  : (c <= 65343 || (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65470)))
                : (c <= 65479 || (c < 65498
                  ? (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)
                  : (c <= 65500 || (c >= 65536 && c <= 65547)))))))
            : (c <= 65574 || (c < 66349
              ? (c < 65856
                ? (c < 65599
                  ? (c < 65596
                    ? (c >= 65576 && c <= 65594)
                    : c <= 65597)
                  : (c <= 65613 || (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)))
                : (c <= 65908 || (c < 66208
                  ? (c < 66176
                    ? c == 66045
                    : c <= 66204)
                  : (c <= 66256 || (c < 66304
                    ? c == 66272
                    : c <= 66335)))))
              : (c <= 66378 || (c < 66560
                ? (c < 66464
                  ? (c < 66432
                    ? (c >= 66384 && c <= 66426)
                    : c <= 66461)
                  : (c <= 66499 || (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)))
                : (c <= 66717 || (c < 66776
                  ? (c < 66736
                    ? (c >= 66720 && c <= 66729)
                    : c <= 66771)
                  : (c <= 66811 || (c >= 66816 && c <= 66855)))))))))))
        : (c <= 66915 || (c < 69632
          ? (c < 68152
            ? (c < 67808
              ? (c < 67594
                ? (c < 67424
                  ? (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)
                  : (c <= 67431 || (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)))
                : (c <= 67637 || (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)))))
              : (c <= 67826 || (c < 68096
                ? (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c < 68030
                    ? (c >= 67968 && c <= 68023)
                    : c <= 68031)))
                : (c <= 68099 || (c < 68117
                  ? (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : c <= 68115)
                  : (c <= 68119 || (c >= 68121 && c <= 68149)))))))
            : (c <= 68154 || (c < 68800
              ? (c < 68352
                ? (c < 68224
                  ? (c < 68192
                    ? c == 68159
                    : c <= 68220)
                  : (c <= 68252 || (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68326)))
                : (c <= 68405 || (c < 68480
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : c <= 68466)
                  : (c <= 68497 || (c < 68736
                    ? (c >= 68608 && c <= 68680)
                    : c <= 68786)))))
              : (c <= 68850 || (c < 69376
                ? (c < 69248
                  ? (c < 68912
                    ? (c >= 68864 && c <= 68903)
                    : c <= 68921)
                  : (c <= 69289 || (c < 69296
                    ? (c >= 69291 && c <= 69292)
                    : c <= 69297)))
                : (c <= 69404 || (c < 69552
                  ? (c < 69424
                    ? c == 69415
                    : c <= 69456)
                  : (c <= 69572 || (c >= 69600 && c <= 69622)))))))))
          : (c <= 69702 || (c < 70384
            ? (c < 70094
              ? (c < 69942
                ? (c < 69840
                  ? (c < 69759
                    ? (c >= 69734 && c <= 69743)
                    : c <= 69818)
                  : (c <= 69864 || (c < 69888
                    ? (c >= 69872 && c <= 69881)
                    : c <= 69940)))
                : (c <= 69951 || (c < 70006
                  ? (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)
                  : (c <= 70006 || (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : c <= 70092)))))
              : (c <= 70106 || (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70199 || (c < 70272
                    ? c == 70206
                    : c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70378)))))))
            : (c <= 70393 || (c < 70487
              ? (c < 70450
                ? (c < 70415
                  ? (c < 70405
                    ? (c >= 70400 && c <= 70403)
                    : c <= 70412)
                  : (c <= 70416 || (c < 70442
                    ? (c >= 70419 && c <= 70440)
                    : c <= 70448)))
                : (c <= 70451 || (c < 70471
                  ? (c < 70459
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70468)
                  : (c <= 70472 || (c < 70480
                    ? (c >= 70475 && c <= 70477)
                    : c <= 70480)))))
              : (c <= 70487 || (c < 70750
                ? (c < 70512
                  ? (c < 70502
                    ? (c >= 70493 && c <= 70499)
                    : c <= 70508)
                  : (c <= 70516 || (c < 70736
                    ? (c >= 70656 && c <= 70730)
                    : c <= 70745)))
                : (c <= 70753 || (c < 70864
                  ? (c < 70855
                    ? (c >= 70784 && c <= 70853)
                    : c <= 70855)
                  : (c <= 70873 || (c >= 71040 && c <= 71093)))))))))))))
      : (c <= 71104 || (c < 119894
        ? (c < 73104
          ? (c < 72163
            ? (c < 71935
              ? (c < 71360
                ? (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)
                  : (c <= 71236 || (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)))
                : (c <= 71369 || (c < 71472
                  ? (c < 71453
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71467)
                  : (c <= 71481 || (c < 71840
                    ? (c >= 71680 && c <= 71738)
                    : c <= 71913)))))
              : (c <= 71942 || (c < 71995
                ? (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c < 71991
                    ? (c >= 71960 && c <= 71989)
                    : c <= 71992)))
                : (c <= 72003 || (c < 72106
                  ? (c < 72096
                    ? (c >= 72016 && c <= 72025)
                    : c <= 72103)
                  : (c <= 72151 || (c >= 72154 && c <= 72161)))))))
            : (c <= 72164 || (c < 72873
              ? (c < 72704
                ? (c < 72272
                  ? (c < 72263
                    ? (c >= 72192 && c <= 72254)
                    : c <= 72263)
                  : (c <= 72345 || (c < 72384
                    ? c == 72349
                    : c <= 72440)))
                : (c <= 72712 || (c < 72784
                  ? (c < 72760
                    ? (c >= 72714 && c <= 72758)
                    : c <= 72768)
                  : (c <= 72793 || (c < 72850
                    ? (c >= 72818 && c <= 72847)
                    : c <= 72871)))))
              : (c <= 72886 || (c < 73023
                ? (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73014 || (c < 73020
                    ? c == 73018
                    : c <= 73021)))
                : (c <= 73031 || (c < 73063
                  ? (c < 73056
                    ? (c >= 73040 && c <= 73049)
                    : c <= 73061)
                  : (c <= 73064 || (c >= 73066 && c <= 73102)))))))))
          : (c <= 73105 || (c < 94095
            ? (c < 92768
              ? (c < 74752
                ? (c < 73440
                  ? (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)
                  : (c <= 73462 || (c < 73728
                    ? c == 73648
                    : c <= 74649)))
                : (c <= 74862 || (c < 82944
                  ? (c < 77824
                    ? (c >= 74880 && c <= 75075)
                    : c <= 78894)
                  : (c <= 83526 || (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)))))
              : (c <= 92777 || (c < 93027
                ? (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))
                : (c <= 93047 || (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c >= 94031 && c <= 94087)))))))
            : (c <= 94111 || (c < 113776
              ? (c < 101632
                ? (c < 94192
                  ? (c < 94179
                    ? (c >= 94176 && c <= 94177)
                    : c <= 94180)
                  : (c <= 94193 || (c < 100352
                    ? (c >= 94208 && c <= 100343)
                    : c <= 101589)))
                : (c <= 101640 || (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110878)
                    : c <= 110930)
                  : (c <= 110951 || (c < 113664
                    ? (c >= 110960 && c <= 111355)
                    : c <= 113770)))))
              : (c <= 113788 || (c < 119163
                ? (c < 113821
                  ? (c < 113808
                    ? (c >= 113792 && c <= 113800)
                    : c <= 113817)
                  : (c <= 113822 || (c < 119149
                    ? (c >= 119141 && c <= 119145)
                    : c <= 119154)))
                : (c <= 119170 || (c < 119362
                  ? (c < 119210
                    ? (c >= 119173 && c <= 119179)
                    : c <= 119213)
                  : (c <= 119364 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 124928
          ? (c < 120630
            ? (c < 120094
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)))))
              : (c <= 120121 || (c < 120488
                ? (c < 120134
                  ? (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)
                  : (c <= 120134 || (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)))
                : (c <= 120512 || (c < 120572
                  ? (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)
                  : (c <= 120596 || (c >= 120598 && c <= 120628)))))))
            : (c <= 120654 || (c < 121505
              ? (c < 120782
                ? (c < 120714
                  ? (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)
                  : (c <= 120744 || (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)))
                : (c <= 120831 || (c < 121461
                  ? (c < 121403
                    ? (c >= 121344 && c <= 121398)
                    : c <= 121452)
                  : (c <= 121461 || (c < 121499
                    ? c == 121476
                    : c <= 121503)))))
              : (c <= 121519 || (c < 123136
                ? (c < 122907
                  ? (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)
                  : (c <= 122913 || (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)))
                : (c <= 123180 || (c < 123214
                  ? (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)
                  : (c <= 123214 || (c >= 123584 && c <= 123641)))))))))
          : (c <= 125124 || (c < 126557
            ? (c < 126523
              ? (c < 126497
                ? (c < 125264
                  ? (c < 125184
                    ? (c >= 125136 && c <= 125142)
                    : c <= 125259)
                  : (c <= 125273 || (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)))
                : (c <= 126498 || (c < 126505
                  ? (c < 126503
                    ? c == 126500
                    : c <= 126503)
                  : (c <= 126514 || (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)))))
              : (c <= 126523 || (c < 126545
                ? (c < 126537
                  ? (c < 126535
                    ? c == 126530
                    : c <= 126535)
                  : (c <= 126537 || (c < 126541
                    ? c == 126539
                    : c <= 126543)))
                : (c <= 126546 || (c < 126553
                  ? (c < 126551
                    ? c == 126548
                    : c <= 126551)
                  : (c <= 126553 || c == 126555))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173789 || (c < 177984
                    ? (c >= 173824 && c <= 177972)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(39);
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '#') ADVANCE(110);
      if (lookahead == '%') ADVANCE(60);
      if (lookahead == '&') ADVANCE(63);
      if (lookahead == '(') ADVANCE(42);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == '*') ADVANCE(45);
      if (lookahead == '+') ADVANCE(56);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(58);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == '/') ADVANCE(59);
      if (lookahead == '0') ADVANCE(99);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == ';') ADVANCE(111);
      if (lookahead == '<') ADVANCE(67);
      if (lookahead == '=') ADVANCE(55);
      if (lookahead == '>') ADVANCE(72);
      if (lookahead == '@') ADVANCE(52);
      if (lookahead == '[') ADVANCE(53);
      if (lookahead == '\\') SKIP(35)
      if (lookahead == ']') ADVANCE(54);
      if (lookahead == '^') ADVANCE(64);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(62);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '~') ADVANCE(66);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(98);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(109);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(10)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(10)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(91);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(4)
      if (lookahead == '#') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(93);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(94);
      if (lookahead != 0) ADVANCE(95);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(11)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(11)
      if (lookahead == '\r') SKIP(5)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(9)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(9)
      if (lookahead == '\r') SKIP(7)
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '#') ADVANCE(110);
      if (lookahead == '%') ADVANCE(60);
      if (lookahead == '&') ADVANCE(63);
      if (lookahead == '(') ADVANCE(42);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == '*') ADVANCE(45);
      if (lookahead == '+') ADVANCE(56);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(57);
      if (lookahead == '.') ADVANCE(40);
      if (lookahead == '/') ADVANCE(59);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == ';') ADVANCE(111);
      if (lookahead == '<') ADVANCE(67);
      if (lookahead == '=') ADVANCE(55);
      if (lookahead == '>') ADVANCE(72);
      if (lookahead == '@') ADVANCE(52);
      if (lookahead == '[') ADVANCE(53);
      if (lookahead == '\\') SKIP(8)
      if (lookahead == ']') ADVANCE(54);
      if (lookahead == '^') ADVANCE(64);
      if (lookahead == '|') ADVANCE(62);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(9)
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(109);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '#') ADVANCE(110);
      if (lookahead == '%') ADVANCE(60);
      if (lookahead == '&') ADVANCE(63);
      if (lookahead == '(') ADVANCE(42);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == '*') ADVANCE(45);
      if (lookahead == '+') ADVANCE(56);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(57);
      if (lookahead == '.') ADVANCE(40);
      if (lookahead == '/') ADVANCE(59);
      if (lookahead == ':') ADVANCE(48);
      if (lookahead == ';') ADVANCE(111);
      if (lookahead == '<') ADVANCE(67);
      if (lookahead == '=') ADVANCE(55);
      if (lookahead == '>') ADVANCE(72);
      if (lookahead == '@') ADVANCE(52);
      if (lookahead == '[') ADVANCE(53);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == ']') ADVANCE(54);
      if (lookahead == '^') ADVANCE(64);
      if (lookahead == '|') ADVANCE(62);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(10)
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(109);
      END_STATE();
    case 11:
      if (lookahead == '#') ADVANCE(110);
      if (lookahead == '-') ADVANCE(15);
      if (lookahead == ':') ADVANCE(48);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(11)
      END_STATE();
    case 12:
      if (lookahead == '#') ADVANCE(110);
      if (lookahead == '\\') ADVANCE(92);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(12)
      END_STATE();
    case 13:
      if (lookahead == '.') ADVANCE(87);
      END_STATE();
    case 14:
      if (lookahead == '=') ADVANCE(70);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(96);
      END_STATE();
    case 15:
      if (lookahead == '>') ADVANCE(50);
      END_STATE();
    case 16:
      if (lookahead == '_') ADVANCE(20);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(101);
      END_STATE();
    case 17:
      if (lookahead == '_') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(102);
      END_STATE();
    case 18:
      if (lookahead == '_') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(103);
      END_STATE();
    case 19:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 20:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(101);
      END_STATE();
    case 21:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(102);
      END_STATE();
    case 22:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 23:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(90);
      END_STATE();
    case 24:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(23);
      END_STATE();
    case 25:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(103);
      END_STATE();
    case 26:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 27:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(26);
      END_STATE();
    case 28:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(27);
      END_STATE();
    case 29:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(28);
      END_STATE();
    case 30:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(29);
      END_STATE();
    case 31:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(30);
      END_STATE();
    case 32:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(31);
      END_STATE();
    case 33:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(32);
      END_STATE();
    case 34:
      if (eof) ADVANCE(39);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 35:
      if (eof) ADVANCE(39);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(34)
      END_STATE();
    case 36:
      if (eof) ADVANCE(39);
      if (lookahead == '\n') SKIP(38)
      END_STATE();
    case 37:
      if (eof) ADVANCE(39);
      if (lookahead == '\n') SKIP(38)
      if (lookahead == '\r') SKIP(36)
      END_STATE();
    case 38:
      if (eof) ADVANCE(39);
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '#') ADVANCE(110);
      if (lookahead == '%') ADVANCE(60);
      if (lookahead == '&') ADVANCE(63);
      if (lookahead == '(') ADVANCE(42);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == '*') ADVANCE(45);
      if (lookahead == '+') ADVANCE(56);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(57);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == '/') ADVANCE(59);
      if (lookahead == '0') ADVANCE(99);
      if (lookahead == ':') ADVANCE(48);
      if (lookahead == ';') ADVANCE(111);
      if (lookahead == '<') ADVANCE(67);
      if (lookahead == '=') ADVANCE(55);
      if (lookahead == '>') ADVANCE(72);
      if (lookahead == '@') ADVANCE(52);
      if (lookahead == '[') ADVANCE(53);
      if (lookahead == '\\') SKIP(37)
      if (lookahead == ']') ADVANCE(54);
      if (lookahead == '^') ADVANCE(64);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(62);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '~') ADVANCE(66);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(38)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(98);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(109);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(105);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(51);
      if (lookahead == '=') ADVANCE(76);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(82);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(47);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(81);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '=') ADVANCE(78);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(69);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(74);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(75);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(50);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(61);
      if (lookahead == '=') ADVANCE(77);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '=') ADVANCE(79);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(86);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(85);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(83);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(65);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(73);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(46);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_AT_EQ);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_EQ);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_ellipsis);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(92);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym__not_escape_sequence);
      if (lookahead == '\n') ADVANCE(91);
      if (lookahead == '\r') ADVANCE(3);
      if (lookahead == 'U') ADVANCE(33);
      if (lookahead == 'u') ADVANCE(29);
      if (lookahead == 'x') ADVANCE(27);
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'a' ||
          lookahead == 'b' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          ('t' <= lookahead && lookahead <= 'v')) ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(24);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == '\r') ADVANCE(95);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(95);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == '#') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(94);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(95);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(95);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_type_conversion);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(107);
      if (lookahead == '_') ADVANCE(100);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(98);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(107);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(16);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(17);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(18);
      if (lookahead == '_') ADVANCE(100);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(98);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(107);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(98);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(20);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(97);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(101);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(21);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(102);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(25);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(103);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_float);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(107);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(105);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(108);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(105);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(109);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(110);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym__semicolon);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'N') ADVANCE(2);
      if (lookahead == 'T') ADVANCE(3);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == '_') ADVANCE(5);
      if (lookahead == 'a') ADVANCE(6);
      if (lookahead == 'b') ADVANCE(7);
      if (lookahead == 'c') ADVANCE(8);
      if (lookahead == 'd') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(10);
      if (lookahead == 'f') ADVANCE(11);
      if (lookahead == 'g') ADVANCE(12);
      if (lookahead == 'i') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(14);
      if (lookahead == 'n') ADVANCE(15);
      if (lookahead == 'o') ADVANCE(16);
      if (lookahead == 'p') ADVANCE(17);
      if (lookahead == 'r') ADVANCE(18);
      if (lookahead == 't') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'a') ADVANCE(22);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 3:
      if (lookahead == 'r') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(25)
      END_STATE();
    case 5:
      if (lookahead == '_') ADVANCE(26);
      END_STATE();
    case 6:
      if (lookahead == 'n') ADVANCE(27);
      if (lookahead == 's') ADVANCE(28);
      if (lookahead == 'w') ADVANCE(29);
      END_STATE();
    case 7:
      if (lookahead == 'r') ADVANCE(30);
      END_STATE();
    case 8:
      if (lookahead == 'l') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 10:
      if (lookahead == 'l') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 11:
      if (lookahead == 'i') ADVANCE(36);
      if (lookahead == 'o') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(38);
      END_STATE();
    case 12:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(40);
      if (lookahead == 'm') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(42);
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(44);
      END_STATE();
    case 15:
      if (lookahead == 'o') ADVANCE(45);
      END_STATE();
    case 16:
      if (lookahead == 'r') ADVANCE(46);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(47);
      if (lookahead == 'r') ADVANCE(48);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(49);
      if (lookahead == 'e') ADVANCE(50);
      END_STATE();
    case 19:
      if (lookahead == 'r') ADVANCE(51);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(52);
      if (lookahead == 'i') ADVANCE(53);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(54);
      END_STATE();
    case 22:
      if (lookahead == 'l') ADVANCE(55);
      END_STATE();
    case 23:
      if (lookahead == 'n') ADVANCE(56);
      END_STATE();
    case 24:
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 25:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 26:
      if (lookahead == 'f') ADVANCE(58);
      END_STATE();
    case 27:
      if (lookahead == 'd') ADVANCE(59);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(60);
      if (lookahead == 'y') ADVANCE(61);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(62);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(63);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 32:
      if (lookahead == 'n') ADVANCE(65);
      END_STATE();
    case 33:
      if (lookahead == 'f') ADVANCE(66);
      if (lookahead == 'l') ADVANCE(67);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(68);
      if (lookahead == 's') ADVANCE(69);
      END_STATE();
    case 35:
      if (lookahead == 'c') ADVANCE(70);
      if (lookahead == 'e') ADVANCE(71);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(72);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(73);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 39:
      if (lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 41:
      if (lookahead == 'p') ADVANCE(76);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 44:
      if (lookahead == 'm') ADVANCE(77);
      END_STATE();
    case 45:
      if (lookahead == 'n') ADVANCE(78);
      if (lookahead == 't') ADVANCE(79);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 47:
      if (lookahead == 's') ADVANCE(80);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(81);
      END_STATE();
    case 49:
      if (lookahead == 'i') ADVANCE(82);
      END_STATE();
    case 50:
      if (lookahead == 't') ADVANCE(83);
      END_STATE();
    case 51:
      if (lookahead == 'y') ADVANCE(84);
      END_STATE();
    case 52:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 53:
      if (lookahead == 't') ADVANCE(86);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(87);
      END_STATE();
    case 55:
      if (lookahead == 's') ADVANCE(88);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(89);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 58:
      if (lookahead == 'u') ADVANCE(91);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 61:
      if (lookahead == 'n') ADVANCE(93);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(95);
      END_STATE();
    case 64:
      if (lookahead == 's') ADVANCE(96);
      END_STATE();
    case 65:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_del);
      END_STATE();
    case 68:
      if (lookahead == 'f') ADVANCE(98);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 70:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 71:
      if (lookahead == 'c') ADVANCE(101);
      END_STATE();
    case 72:
      if (lookahead == 'a') ADVANCE(102);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 74:
      if (lookahead == 'm') ADVANCE(103);
      END_STATE();
    case 75:
      if (lookahead == 'b') ADVANCE(104);
      END_STATE();
    case 76:
      if (lookahead == 'o') ADVANCE(105);
      END_STATE();
    case 77:
      if (lookahead == 'b') ADVANCE(106);
      END_STATE();
    case 78:
      if (lookahead == 'l') ADVANCE(107);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 80:
      if (lookahead == 's') ADVANCE(108);
      END_STATE();
    case 81:
      if (lookahead == 'n') ADVANCE(109);
      END_STATE();
    case 82:
      if (lookahead == 's') ADVANCE(110);
      END_STATE();
    case 83:
      if (lookahead == 'u') ADVANCE(111);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 85:
      if (lookahead == 'l') ADVANCE(112);
      END_STATE();
    case 86:
      if (lookahead == 'h') ADVANCE(113);
      END_STATE();
    case 87:
      if (lookahead == 'l') ADVANCE(114);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(115);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_none);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 91:
      if (lookahead == 't') ADVANCE(116);
      END_STATE();
    case 92:
      if (lookahead == 'r') ADVANCE(117);
      END_STATE();
    case 93:
      if (lookahead == 'c') ADVANCE(118);
      END_STATE();
    case 94:
      if (lookahead == 't') ADVANCE(119);
      END_STATE();
    case 95:
      if (lookahead == 'k') ADVANCE(120);
      END_STATE();
    case 96:
      if (lookahead == 's') ADVANCE(121);
      END_STATE();
    case 97:
      if (lookahead == 'i') ADVANCE(122);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 100:
      if (lookahead == 'p') ADVANCE(123);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_exec);
      END_STATE();
    case 102:
      if (lookahead == 'l') ADVANCE(124);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 104:
      if (lookahead == 'a') ADVANCE(125);
      END_STATE();
    case 105:
      if (lookahead == 'r') ADVANCE(126);
      END_STATE();
    case 106:
      if (lookahead == 'd') ADVANCE(127);
      END_STATE();
    case 107:
      if (lookahead == 'o') ADVANCE(128);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_pass);
      END_STATE();
    case 109:
      if (lookahead == 't') ADVANCE(129);
      END_STATE();
    case 110:
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 111:
      if (lookahead == 'r') ADVANCE(131);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 114:
      if (lookahead == 'd') ADVANCE(133);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 116:
      if (lookahead == 'u') ADVANCE(134);
      END_STATE();
    case 117:
      if (lookahead == 't') ADVANCE(135);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 122:
      if (lookahead == 'n') ADVANCE(136);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(137);
      END_STATE();
    case 124:
      if (lookahead == 'l') ADVANCE(138);
      END_STATE();
    case 125:
      if (lookahead == 'l') ADVANCE(139);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(140);
      END_STATE();
    case 127:
      if (lookahead == 'a') ADVANCE(141);
      END_STATE();
    case 128:
      if (lookahead == 'c') ADVANCE(142);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_print);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_raise);
      END_STATE();
    case 131:
      if (lookahead == 'n') ADVANCE(143);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 134:
      if (lookahead == 'r') ADVANCE(144);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 136:
      if (lookahead == 'u') ADVANCE(145);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_except);
      END_STATE();
    case 138:
      if (lookahead == 'y') ADVANCE(146);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_lambda);
      END_STATE();
    case 142:
      if (lookahead == 'a') ADVANCE(147);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 144:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 145:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 147:
      if (lookahead == 'l') ADVANCE(150);
      END_STATE();
    case 148:
      if (lookahead == '_') ADVANCE(151);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_nonlocal);
      END_STATE();
    case 151:
      if (lookahead == '_') ADVANCE(152);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym___future__);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 38, .external_lex_state = 2},
  [2] = {.lex_state = 38, .external_lex_state = 3},
  [3] = {.lex_state = 38, .external_lex_state = 3},
  [4] = {.lex_state = 38, .external_lex_state = 3},
  [5] = {.lex_state = 38, .external_lex_state = 3},
  [6] = {.lex_state = 38, .external_lex_state = 3},
  [7] = {.lex_state = 38, .external_lex_state = 3},
  [8] = {.lex_state = 38, .external_lex_state = 3},
  [9] = {.lex_state = 38, .external_lex_state = 3},
  [10] = {.lex_state = 38, .external_lex_state = 3},
  [11] = {.lex_state = 38, .external_lex_state = 3},
  [12] = {.lex_state = 38, .external_lex_state = 3},
  [13] = {.lex_state = 38, .external_lex_state = 3},
  [14] = {.lex_state = 38, .external_lex_state = 3},
  [15] = {.lex_state = 38, .external_lex_state = 3},
  [16] = {.lex_state = 38, .external_lex_state = 3},
  [17] = {.lex_state = 38, .external_lex_state = 3},
  [18] = {.lex_state = 38, .external_lex_state = 3},
  [19] = {.lex_state = 38, .external_lex_state = 3},
  [20] = {.lex_state = 38, .external_lex_state = 3},
  [21] = {.lex_state = 38, .external_lex_state = 3},
  [22] = {.lex_state = 38, .external_lex_state = 3},
  [23] = {.lex_state = 38, .external_lex_state = 3},
  [24] = {.lex_state = 38, .external_lex_state = 3},
  [25] = {.lex_state = 38, .external_lex_state = 3},
  [26] = {.lex_state = 38, .external_lex_state = 3},
  [27] = {.lex_state = 38, .external_lex_state = 3},
  [28] = {.lex_state = 38, .external_lex_state = 3},
  [29] = {.lex_state = 38, .external_lex_state = 3},
  [30] = {.lex_state = 38, .external_lex_state = 3},
  [31] = {.lex_state = 38, .external_lex_state = 3},
  [32] = {.lex_state = 38, .external_lex_state = 3},
  [33] = {.lex_state = 38, .external_lex_state = 3},
  [34] = {.lex_state = 38, .external_lex_state = 3},
  [35] = {.lex_state = 38, .external_lex_state = 3},
  [36] = {.lex_state = 38, .external_lex_state = 3},
  [37] = {.lex_state = 38, .external_lex_state = 3},
  [38] = {.lex_state = 38, .external_lex_state = 3},
  [39] = {.lex_state = 38, .external_lex_state = 3},
  [40] = {.lex_state = 38, .external_lex_state = 3},
  [41] = {.lex_state = 38, .external_lex_state = 3},
  [42] = {.lex_state = 38, .external_lex_state = 2},
  [43] = {.lex_state = 38, .external_lex_state = 3},
  [44] = {.lex_state = 38, .external_lex_state = 3},
  [45] = {.lex_state = 38, .external_lex_state = 2},
  [46] = {.lex_state = 38, .external_lex_state = 4},
  [47] = {.lex_state = 38, .external_lex_state = 4},
  [48] = {.lex_state = 38, .external_lex_state = 5},
  [49] = {.lex_state = 38, .external_lex_state = 5},
  [50] = {.lex_state = 38, .external_lex_state = 5},
  [51] = {.lex_state = 38, .external_lex_state = 5},
  [52] = {.lex_state = 38, .external_lex_state = 5},
  [53] = {.lex_state = 38, .external_lex_state = 5},
  [54] = {.lex_state = 38, .external_lex_state = 5},
  [55] = {.lex_state = 38, .external_lex_state = 5},
  [56] = {.lex_state = 38, .external_lex_state = 5},
  [57] = {.lex_state = 38, .external_lex_state = 5},
  [58] = {.lex_state = 38, .external_lex_state = 5},
  [59] = {.lex_state = 38, .external_lex_state = 5},
  [60] = {.lex_state = 38, .external_lex_state = 5},
  [61] = {.lex_state = 38, .external_lex_state = 5},
  [62] = {.lex_state = 38, .external_lex_state = 5},
  [63] = {.lex_state = 38, .external_lex_state = 5},
  [64] = {.lex_state = 38, .external_lex_state = 5},
  [65] = {.lex_state = 38, .external_lex_state = 5},
  [66] = {.lex_state = 38, .external_lex_state = 5},
  [67] = {.lex_state = 38, .external_lex_state = 5},
  [68] = {.lex_state = 38, .external_lex_state = 5},
  [69] = {.lex_state = 38, .external_lex_state = 5},
  [70] = {.lex_state = 38, .external_lex_state = 5},
  [71] = {.lex_state = 38, .external_lex_state = 5},
  [72] = {.lex_state = 38, .external_lex_state = 5},
  [73] = {.lex_state = 38, .external_lex_state = 5},
  [74] = {.lex_state = 38, .external_lex_state = 5},
  [75] = {.lex_state = 38, .external_lex_state = 5},
  [76] = {.lex_state = 38, .external_lex_state = 5},
  [77] = {.lex_state = 38, .external_lex_state = 5},
  [78] = {.lex_state = 38, .external_lex_state = 5},
  [79] = {.lex_state = 38, .external_lex_state = 5},
  [80] = {.lex_state = 38, .external_lex_state = 5},
  [81] = {.lex_state = 38, .external_lex_state = 5},
  [82] = {.lex_state = 38, .external_lex_state = 5},
  [83] = {.lex_state = 38, .external_lex_state = 5},
  [84] = {.lex_state = 38, .external_lex_state = 5},
  [85] = {.lex_state = 38, .external_lex_state = 5},
  [86] = {.lex_state = 38, .external_lex_state = 4},
  [87] = {.lex_state = 38, .external_lex_state = 4},
  [88] = {.lex_state = 38, .external_lex_state = 4},
  [89] = {.lex_state = 38, .external_lex_state = 4},
  [90] = {.lex_state = 38, .external_lex_state = 4},
  [91] = {.lex_state = 38, .external_lex_state = 4},
  [92] = {.lex_state = 38, .external_lex_state = 2},
  [93] = {.lex_state = 38, .external_lex_state = 2},
  [94] = {.lex_state = 38, .external_lex_state = 2},
  [95] = {.lex_state = 38, .external_lex_state = 4},
  [96] = {.lex_state = 38, .external_lex_state = 2},
  [97] = {.lex_state = 38, .external_lex_state = 2},
  [98] = {.lex_state = 38, .external_lex_state = 2},
  [99] = {.lex_state = 38, .external_lex_state = 2},
  [100] = {.lex_state = 38, .external_lex_state = 2},
  [101] = {.lex_state = 38, .external_lex_state = 2},
  [102] = {.lex_state = 38, .external_lex_state = 2},
  [103] = {.lex_state = 38, .external_lex_state = 2},
  [104] = {.lex_state = 38, .external_lex_state = 2},
  [105] = {.lex_state = 38, .external_lex_state = 2},
  [106] = {.lex_state = 38, .external_lex_state = 2},
  [107] = {.lex_state = 38, .external_lex_state = 2},
  [108] = {.lex_state = 38, .external_lex_state = 2},
  [109] = {.lex_state = 38, .external_lex_state = 2},
  [110] = {.lex_state = 38, .external_lex_state = 2},
  [111] = {.lex_state = 38, .external_lex_state = 2},
  [112] = {.lex_state = 38, .external_lex_state = 2},
  [113] = {.lex_state = 38, .external_lex_state = 2},
  [114] = {.lex_state = 38, .external_lex_state = 2},
  [115] = {.lex_state = 10},
  [116] = {.lex_state = 38, .external_lex_state = 2},
  [117] = {.lex_state = 38, .external_lex_state = 2},
  [118] = {.lex_state = 10},
  [119] = {.lex_state = 10},
  [120] = {.lex_state = 10},
  [121] = {.lex_state = 38, .external_lex_state = 2},
  [122] = {.lex_state = 38, .external_lex_state = 2},
  [123] = {.lex_state = 38, .external_lex_state = 2},
  [124] = {.lex_state = 38, .external_lex_state = 2},
  [125] = {.lex_state = 10},
  [126] = {.lex_state = 10},
  [127] = {.lex_state = 38, .external_lex_state = 2},
  [128] = {.lex_state = 10},
  [129] = {.lex_state = 38, .external_lex_state = 2},
  [130] = {.lex_state = 38, .external_lex_state = 2},
  [131] = {.lex_state = 38, .external_lex_state = 2},
  [132] = {.lex_state = 38, .external_lex_state = 2},
  [133] = {.lex_state = 38, .external_lex_state = 2},
  [134] = {.lex_state = 38, .external_lex_state = 2},
  [135] = {.lex_state = 38, .external_lex_state = 2},
  [136] = {.lex_state = 38, .external_lex_state = 2},
  [137] = {.lex_state = 38, .external_lex_state = 2},
  [138] = {.lex_state = 38, .external_lex_state = 2},
  [139] = {.lex_state = 38, .external_lex_state = 2},
  [140] = {.lex_state = 38, .external_lex_state = 2},
  [141] = {.lex_state = 38, .external_lex_state = 2},
  [142] = {.lex_state = 38, .external_lex_state = 2},
  [143] = {.lex_state = 38, .external_lex_state = 2},
  [144] = {.lex_state = 38, .external_lex_state = 2},
  [145] = {.lex_state = 38, .external_lex_state = 2},
  [146] = {.lex_state = 38, .external_lex_state = 2},
  [147] = {.lex_state = 38, .external_lex_state = 2},
  [148] = {.lex_state = 38, .external_lex_state = 2},
  [149] = {.lex_state = 38, .external_lex_state = 2},
  [150] = {.lex_state = 38, .external_lex_state = 2},
  [151] = {.lex_state = 38, .external_lex_state = 2},
  [152] = {.lex_state = 38, .external_lex_state = 2},
  [153] = {.lex_state = 38, .external_lex_state = 2},
  [154] = {.lex_state = 38, .external_lex_state = 2},
  [155] = {.lex_state = 38, .external_lex_state = 2},
  [156] = {.lex_state = 38, .external_lex_state = 2},
  [157] = {.lex_state = 38, .external_lex_state = 2},
  [158] = {.lex_state = 38, .external_lex_state = 2},
  [159] = {.lex_state = 10, .external_lex_state = 6},
  [160] = {.lex_state = 38, .external_lex_state = 2},
  [161] = {.lex_state = 10, .external_lex_state = 6},
  [162] = {.lex_state = 38, .external_lex_state = 3},
  [163] = {.lex_state = 38, .external_lex_state = 4},
  [164] = {.lex_state = 38, .external_lex_state = 2},
  [165] = {.lex_state = 38, .external_lex_state = 2},
  [166] = {.lex_state = 38, .external_lex_state = 2},
  [167] = {.lex_state = 38, .external_lex_state = 2},
  [168] = {.lex_state = 10, .external_lex_state = 4},
  [169] = {.lex_state = 38, .external_lex_state = 4},
  [170] = {.lex_state = 38, .external_lex_state = 2},
  [171] = {.lex_state = 38, .external_lex_state = 3},
  [172] = {.lex_state = 38, .external_lex_state = 2},
  [173] = {.lex_state = 38, .external_lex_state = 2},
  [174] = {.lex_state = 38, .external_lex_state = 2},
  [175] = {.lex_state = 10, .external_lex_state = 6},
  [176] = {.lex_state = 38, .external_lex_state = 2},
  [177] = {.lex_state = 10, .external_lex_state = 6},
  [178] = {.lex_state = 10, .external_lex_state = 6},
  [179] = {.lex_state = 38, .external_lex_state = 2},
  [180] = {.lex_state = 38, .external_lex_state = 2},
  [181] = {.lex_state = 10, .external_lex_state = 6},
  [182] = {.lex_state = 38, .external_lex_state = 2},
  [183] = {.lex_state = 38, .external_lex_state = 2},
  [184] = {.lex_state = 38, .external_lex_state = 2},
  [185] = {.lex_state = 38, .external_lex_state = 2},
  [186] = {.lex_state = 10, .external_lex_state = 6},
  [187] = {.lex_state = 38, .external_lex_state = 2},
  [188] = {.lex_state = 10, .external_lex_state = 6},
  [189] = {.lex_state = 38, .external_lex_state = 2},
  [190] = {.lex_state = 38, .external_lex_state = 2},
  [191] = {.lex_state = 38, .external_lex_state = 2},
  [192] = {.lex_state = 38, .external_lex_state = 4},
  [193] = {.lex_state = 38, .external_lex_state = 4},
  [194] = {.lex_state = 38, .external_lex_state = 4},
  [195] = {.lex_state = 10, .external_lex_state = 6},
  [196] = {.lex_state = 9, .external_lex_state = 6},
  [197] = {.lex_state = 38, .external_lex_state = 2},
  [198] = {.lex_state = 38, .external_lex_state = 2},
  [199] = {.lex_state = 38, .external_lex_state = 2},
  [200] = {.lex_state = 38, .external_lex_state = 2},
  [201] = {.lex_state = 38, .external_lex_state = 3},
  [202] = {.lex_state = 38, .external_lex_state = 4},
  [203] = {.lex_state = 38, .external_lex_state = 4},
  [204] = {.lex_state = 38, .external_lex_state = 4},
  [205] = {.lex_state = 38, .external_lex_state = 2},
  [206] = {.lex_state = 38, .external_lex_state = 2},
  [207] = {.lex_state = 38, .external_lex_state = 3},
  [208] = {.lex_state = 38, .external_lex_state = 3},
  [209] = {.lex_state = 38, .external_lex_state = 2},
  [210] = {.lex_state = 10, .external_lex_state = 6},
  [211] = {.lex_state = 38, .external_lex_state = 4},
  [212] = {.lex_state = 38, .external_lex_state = 2},
  [213] = {.lex_state = 38, .external_lex_state = 4},
  [214] = {.lex_state = 10, .external_lex_state = 6},
  [215] = {.lex_state = 10, .external_lex_state = 6},
  [216] = {.lex_state = 38, .external_lex_state = 4},
  [217] = {.lex_state = 38, .external_lex_state = 2},
  [218] = {.lex_state = 38, .external_lex_state = 2},
  [219] = {.lex_state = 38, .external_lex_state = 2},
  [220] = {.lex_state = 38, .external_lex_state = 2},
  [221] = {.lex_state = 38, .external_lex_state = 2},
  [222] = {.lex_state = 10, .external_lex_state = 6},
  [223] = {.lex_state = 38, .external_lex_state = 2},
  [224] = {.lex_state = 38, .external_lex_state = 2},
  [225] = {.lex_state = 38, .external_lex_state = 2},
  [226] = {.lex_state = 38, .external_lex_state = 2},
  [227] = {.lex_state = 38, .external_lex_state = 2},
  [228] = {.lex_state = 38, .external_lex_state = 2},
  [229] = {.lex_state = 38, .external_lex_state = 3},
  [230] = {.lex_state = 38, .external_lex_state = 2},
  [231] = {.lex_state = 38, .external_lex_state = 2},
  [232] = {.lex_state = 38, .external_lex_state = 3},
  [233] = {.lex_state = 38, .external_lex_state = 2},
  [234] = {.lex_state = 38, .external_lex_state = 2},
  [235] = {.lex_state = 38, .external_lex_state = 2},
  [236] = {.lex_state = 38, .external_lex_state = 2},
  [237] = {.lex_state = 38, .external_lex_state = 3},
  [238] = {.lex_state = 38, .external_lex_state = 2},
  [239] = {.lex_state = 38, .external_lex_state = 2},
  [240] = {.lex_state = 38, .external_lex_state = 3},
  [241] = {.lex_state = 38, .external_lex_state = 3},
  [242] = {.lex_state = 38, .external_lex_state = 2},
  [243] = {.lex_state = 38, .external_lex_state = 2},
  [244] = {.lex_state = 38, .external_lex_state = 2},
  [245] = {.lex_state = 38, .external_lex_state = 2},
  [246] = {.lex_state = 38, .external_lex_state = 2},
  [247] = {.lex_state = 38, .external_lex_state = 3},
  [248] = {.lex_state = 38, .external_lex_state = 2},
  [249] = {.lex_state = 38, .external_lex_state = 2},
  [250] = {.lex_state = 38, .external_lex_state = 3},
  [251] = {.lex_state = 38, .external_lex_state = 3},
  [252] = {.lex_state = 38, .external_lex_state = 2},
  [253] = {.lex_state = 38, .external_lex_state = 2},
  [254] = {.lex_state = 38, .external_lex_state = 2},
  [255] = {.lex_state = 38, .external_lex_state = 2},
  [256] = {.lex_state = 38, .external_lex_state = 2},
  [257] = {.lex_state = 38, .external_lex_state = 2},
  [258] = {.lex_state = 38, .external_lex_state = 2},
  [259] = {.lex_state = 38, .external_lex_state = 2},
  [260] = {.lex_state = 38, .external_lex_state = 2},
  [261] = {.lex_state = 38, .external_lex_state = 2},
  [262] = {.lex_state = 38, .external_lex_state = 2},
  [263] = {.lex_state = 38, .external_lex_state = 2},
  [264] = {.lex_state = 38, .external_lex_state = 2},
  [265] = {.lex_state = 38, .external_lex_state = 2},
  [266] = {.lex_state = 38, .external_lex_state = 2},
  [267] = {.lex_state = 38, .external_lex_state = 2},
  [268] = {.lex_state = 38, .external_lex_state = 2},
  [269] = {.lex_state = 38, .external_lex_state = 2},
  [270] = {.lex_state = 38, .external_lex_state = 2},
  [271] = {.lex_state = 38, .external_lex_state = 2},
  [272] = {.lex_state = 38, .external_lex_state = 2},
  [273] = {.lex_state = 38, .external_lex_state = 3},
  [274] = {.lex_state = 38, .external_lex_state = 2},
  [275] = {.lex_state = 38, .external_lex_state = 2},
  [276] = {.lex_state = 38, .external_lex_state = 2},
  [277] = {.lex_state = 38, .external_lex_state = 2},
  [278] = {.lex_state = 38, .external_lex_state = 2},
  [279] = {.lex_state = 38, .external_lex_state = 2},
  [280] = {.lex_state = 38, .external_lex_state = 2},
  [281] = {.lex_state = 38, .external_lex_state = 2},
  [282] = {.lex_state = 38, .external_lex_state = 2},
  [283] = {.lex_state = 38, .external_lex_state = 2},
  [284] = {.lex_state = 38, .external_lex_state = 2},
  [285] = {.lex_state = 38, .external_lex_state = 2},
  [286] = {.lex_state = 38, .external_lex_state = 2},
  [287] = {.lex_state = 38, .external_lex_state = 2},
  [288] = {.lex_state = 38, .external_lex_state = 2},
  [289] = {.lex_state = 38, .external_lex_state = 2},
  [290] = {.lex_state = 38, .external_lex_state = 2},
  [291] = {.lex_state = 38, .external_lex_state = 2},
  [292] = {.lex_state = 38, .external_lex_state = 2},
  [293] = {.lex_state = 38, .external_lex_state = 2},
  [294] = {.lex_state = 38, .external_lex_state = 2},
  [295] = {.lex_state = 38, .external_lex_state = 2},
  [296] = {.lex_state = 38, .external_lex_state = 2},
  [297] = {.lex_state = 38, .external_lex_state = 2},
  [298] = {.lex_state = 38, .external_lex_state = 2},
  [299] = {.lex_state = 38, .external_lex_state = 2},
  [300] = {.lex_state = 38, .external_lex_state = 2},
  [301] = {.lex_state = 38, .external_lex_state = 2},
  [302] = {.lex_state = 38, .external_lex_state = 2},
  [303] = {.lex_state = 38, .external_lex_state = 2},
  [304] = {.lex_state = 38, .external_lex_state = 2},
  [305] = {.lex_state = 38, .external_lex_state = 2},
  [306] = {.lex_state = 38, .external_lex_state = 2},
  [307] = {.lex_state = 38, .external_lex_state = 2},
  [308] = {.lex_state = 38, .external_lex_state = 3},
  [309] = {.lex_state = 38, .external_lex_state = 2},
  [310] = {.lex_state = 38, .external_lex_state = 2},
  [311] = {.lex_state = 38, .external_lex_state = 2},
  [312] = {.lex_state = 38, .external_lex_state = 2},
  [313] = {.lex_state = 38, .external_lex_state = 3},
  [314] = {.lex_state = 38, .external_lex_state = 2},
  [315] = {.lex_state = 38, .external_lex_state = 2},
  [316] = {.lex_state = 38, .external_lex_state = 3},
  [317] = {.lex_state = 38, .external_lex_state = 3},
  [318] = {.lex_state = 38, .external_lex_state = 2},
  [319] = {.lex_state = 38, .external_lex_state = 2},
  [320] = {.lex_state = 38, .external_lex_state = 2},
  [321] = {.lex_state = 38, .external_lex_state = 2},
  [322] = {.lex_state = 38, .external_lex_state = 3},
  [323] = {.lex_state = 38, .external_lex_state = 2},
  [324] = {.lex_state = 38, .external_lex_state = 2},
  [325] = {.lex_state = 38, .external_lex_state = 2},
  [326] = {.lex_state = 38, .external_lex_state = 2},
  [327] = {.lex_state = 38, .external_lex_state = 2},
  [328] = {.lex_state = 38, .external_lex_state = 2},
  [329] = {.lex_state = 38, .external_lex_state = 2},
  [330] = {.lex_state = 38, .external_lex_state = 2},
  [331] = {.lex_state = 38, .external_lex_state = 2},
  [332] = {.lex_state = 38, .external_lex_state = 2},
  [333] = {.lex_state = 38, .external_lex_state = 2},
  [334] = {.lex_state = 38, .external_lex_state = 2},
  [335] = {.lex_state = 38, .external_lex_state = 2},
  [336] = {.lex_state = 38, .external_lex_state = 3},
  [337] = {.lex_state = 38, .external_lex_state = 3},
  [338] = {.lex_state = 38, .external_lex_state = 3},
  [339] = {.lex_state = 38, .external_lex_state = 2},
  [340] = {.lex_state = 38, .external_lex_state = 2},
  [341] = {.lex_state = 38, .external_lex_state = 3},
  [342] = {.lex_state = 38, .external_lex_state = 3},
  [343] = {.lex_state = 38, .external_lex_state = 2},
  [344] = {.lex_state = 38, .external_lex_state = 3},
  [345] = {.lex_state = 38, .external_lex_state = 2},
  [346] = {.lex_state = 38, .external_lex_state = 3},
  [347] = {.lex_state = 38, .external_lex_state = 2},
  [348] = {.lex_state = 38, .external_lex_state = 2},
  [349] = {.lex_state = 38, .external_lex_state = 2},
  [350] = {.lex_state = 38, .external_lex_state = 2},
  [351] = {.lex_state = 38, .external_lex_state = 3},
  [352] = {.lex_state = 38, .external_lex_state = 2},
  [353] = {.lex_state = 38, .external_lex_state = 3},
  [354] = {.lex_state = 38, .external_lex_state = 2},
  [355] = {.lex_state = 38, .external_lex_state = 3},
  [356] = {.lex_state = 38, .external_lex_state = 3},
  [357] = {.lex_state = 38, .external_lex_state = 3},
  [358] = {.lex_state = 38, .external_lex_state = 2},
  [359] = {.lex_state = 38, .external_lex_state = 3},
  [360] = {.lex_state = 10, .external_lex_state = 2},
  [361] = {.lex_state = 10, .external_lex_state = 2},
  [362] = {.lex_state = 38, .external_lex_state = 2},
  [363] = {.lex_state = 10, .external_lex_state = 2},
  [364] = {.lex_state = 38, .external_lex_state = 3},
  [365] = {.lex_state = 38, .external_lex_state = 3},
  [366] = {.lex_state = 38, .external_lex_state = 2},
  [367] = {.lex_state = 38, .external_lex_state = 3},
  [368] = {.lex_state = 38, .external_lex_state = 3},
  [369] = {.lex_state = 38, .external_lex_state = 3},
  [370] = {.lex_state = 38, .external_lex_state = 3},
  [371] = {.lex_state = 38, .external_lex_state = 2},
  [372] = {.lex_state = 38, .external_lex_state = 2},
  [373] = {.lex_state = 38, .external_lex_state = 2},
  [374] = {.lex_state = 38, .external_lex_state = 3},
  [375] = {.lex_state = 38, .external_lex_state = 2},
  [376] = {.lex_state = 38, .external_lex_state = 2},
  [377] = {.lex_state = 38, .external_lex_state = 3},
  [378] = {.lex_state = 38, .external_lex_state = 3},
  [379] = {.lex_state = 38, .external_lex_state = 3},
  [380] = {.lex_state = 38, .external_lex_state = 2},
  [381] = {.lex_state = 38, .external_lex_state = 3},
  [382] = {.lex_state = 38, .external_lex_state = 3},
  [383] = {.lex_state = 38, .external_lex_state = 2},
  [384] = {.lex_state = 38, .external_lex_state = 3},
  [385] = {.lex_state = 38, .external_lex_state = 2},
  [386] = {.lex_state = 38, .external_lex_state = 2},
  [387] = {.lex_state = 38, .external_lex_state = 2},
  [388] = {.lex_state = 38, .external_lex_state = 2},
  [389] = {.lex_state = 38, .external_lex_state = 3},
  [390] = {.lex_state = 38, .external_lex_state = 2},
  [391] = {.lex_state = 38, .external_lex_state = 3},
  [392] = {.lex_state = 38, .external_lex_state = 3},
  [393] = {.lex_state = 38, .external_lex_state = 2},
  [394] = {.lex_state = 38, .external_lex_state = 2},
  [395] = {.lex_state = 38, .external_lex_state = 3},
  [396] = {.lex_state = 38, .external_lex_state = 3},
  [397] = {.lex_state = 38, .external_lex_state = 3},
  [398] = {.lex_state = 38, .external_lex_state = 2},
  [399] = {.lex_state = 38, .external_lex_state = 2},
  [400] = {.lex_state = 38, .external_lex_state = 3},
  [401] = {.lex_state = 38, .external_lex_state = 2},
  [402] = {.lex_state = 38, .external_lex_state = 3},
  [403] = {.lex_state = 38, .external_lex_state = 2},
  [404] = {.lex_state = 38, .external_lex_state = 2},
  [405] = {.lex_state = 38, .external_lex_state = 2},
  [406] = {.lex_state = 38, .external_lex_state = 3},
  [407] = {.lex_state = 38, .external_lex_state = 2},
  [408] = {.lex_state = 38, .external_lex_state = 2},
  [409] = {.lex_state = 38, .external_lex_state = 3},
  [410] = {.lex_state = 38, .external_lex_state = 2},
  [411] = {.lex_state = 38, .external_lex_state = 2},
  [412] = {.lex_state = 38, .external_lex_state = 3},
  [413] = {.lex_state = 38, .external_lex_state = 3},
  [414] = {.lex_state = 38, .external_lex_state = 3},
  [415] = {.lex_state = 38, .external_lex_state = 3},
  [416] = {.lex_state = 38, .external_lex_state = 3},
  [417] = {.lex_state = 38, .external_lex_state = 2},
  [418] = {.lex_state = 38, .external_lex_state = 2},
  [419] = {.lex_state = 38, .external_lex_state = 2},
  [420] = {.lex_state = 38, .external_lex_state = 3},
  [421] = {.lex_state = 38, .external_lex_state = 2},
  [422] = {.lex_state = 38, .external_lex_state = 3},
  [423] = {.lex_state = 38, .external_lex_state = 3},
  [424] = {.lex_state = 38, .external_lex_state = 3},
  [425] = {.lex_state = 38, .external_lex_state = 3},
  [426] = {.lex_state = 38, .external_lex_state = 2},
  [427] = {.lex_state = 38, .external_lex_state = 2},
  [428] = {.lex_state = 38, .external_lex_state = 2},
  [429] = {.lex_state = 38, .external_lex_state = 3},
  [430] = {.lex_state = 38, .external_lex_state = 2},
  [431] = {.lex_state = 38, .external_lex_state = 2},
  [432] = {.lex_state = 38, .external_lex_state = 2},
  [433] = {.lex_state = 38, .external_lex_state = 2},
  [434] = {.lex_state = 38, .external_lex_state = 3},
  [435] = {.lex_state = 38, .external_lex_state = 2},
  [436] = {.lex_state = 38, .external_lex_state = 2},
  [437] = {.lex_state = 38, .external_lex_state = 2},
  [438] = {.lex_state = 10, .external_lex_state = 2},
  [439] = {.lex_state = 38, .external_lex_state = 2},
  [440] = {.lex_state = 38, .external_lex_state = 2},
  [441] = {.lex_state = 38, .external_lex_state = 2},
  [442] = {.lex_state = 10, .external_lex_state = 2},
  [443] = {.lex_state = 38, .external_lex_state = 2},
  [444] = {.lex_state = 38, .external_lex_state = 2},
  [445] = {.lex_state = 10},
  [446] = {.lex_state = 10},
  [447] = {.lex_state = 10},
  [448] = {.lex_state = 10},
  [449] = {.lex_state = 10},
  [450] = {.lex_state = 10},
  [451] = {.lex_state = 10},
  [452] = {.lex_state = 10},
  [453] = {.lex_state = 10},
  [454] = {.lex_state = 10},
  [455] = {.lex_state = 10},
  [456] = {.lex_state = 10},
  [457] = {.lex_state = 10},
  [458] = {.lex_state = 10},
  [459] = {.lex_state = 10},
  [460] = {.lex_state = 10},
  [461] = {.lex_state = 10},
  [462] = {.lex_state = 10},
  [463] = {.lex_state = 38, .external_lex_state = 2},
  [464] = {.lex_state = 38, .external_lex_state = 2},
  [465] = {.lex_state = 10},
  [466] = {.lex_state = 10},
  [467] = {.lex_state = 10},
  [468] = {.lex_state = 10},
  [469] = {.lex_state = 10},
  [470] = {.lex_state = 10},
  [471] = {.lex_state = 10},
  [472] = {.lex_state = 10},
  [473] = {.lex_state = 10},
  [474] = {.lex_state = 10},
  [475] = {.lex_state = 10},
  [476] = {.lex_state = 10},
  [477] = {.lex_state = 10},
  [478] = {.lex_state = 10},
  [479] = {.lex_state = 10},
  [480] = {.lex_state = 10},
  [481] = {.lex_state = 10},
  [482] = {.lex_state = 10},
  [483] = {.lex_state = 10},
  [484] = {.lex_state = 10},
  [485] = {.lex_state = 10},
  [486] = {.lex_state = 10},
  [487] = {.lex_state = 10},
  [488] = {.lex_state = 10},
  [489] = {.lex_state = 10},
  [490] = {.lex_state = 9},
  [491] = {.lex_state = 10},
  [492] = {.lex_state = 10},
  [493] = {.lex_state = 38, .external_lex_state = 2},
  [494] = {.lex_state = 10},
  [495] = {.lex_state = 9},
  [496] = {.lex_state = 10},
  [497] = {.lex_state = 10},
  [498] = {.lex_state = 10, .external_lex_state = 4},
  [499] = {.lex_state = 10},
  [500] = {.lex_state = 10, .external_lex_state = 6},
  [501] = {.lex_state = 10, .external_lex_state = 4},
  [502] = {.lex_state = 10, .external_lex_state = 4},
  [503] = {.lex_state = 10, .external_lex_state = 6},
  [504] = {.lex_state = 10},
  [505] = {.lex_state = 10, .external_lex_state = 6},
  [506] = {.lex_state = 10, .external_lex_state = 2},
  [507] = {.lex_state = 38, .external_lex_state = 2},
  [508] = {.lex_state = 10, .external_lex_state = 6},
  [509] = {.lex_state = 10, .external_lex_state = 6},
  [510] = {.lex_state = 10, .external_lex_state = 6},
  [511] = {.lex_state = 10, .external_lex_state = 6},
  [512] = {.lex_state = 38, .external_lex_state = 2},
  [513] = {.lex_state = 10, .external_lex_state = 6},
  [514] = {.lex_state = 10, .external_lex_state = 6},
  [515] = {.lex_state = 10, .external_lex_state = 6},
  [516] = {.lex_state = 10, .external_lex_state = 6},
  [517] = {.lex_state = 10, .external_lex_state = 2},
  [518] = {.lex_state = 10, .external_lex_state = 2},
  [519] = {.lex_state = 38, .external_lex_state = 2},
  [520] = {.lex_state = 38, .external_lex_state = 2},
  [521] = {.lex_state = 38, .external_lex_state = 2},
  [522] = {.lex_state = 9, .external_lex_state = 6},
  [523] = {.lex_state = 10},
  [524] = {.lex_state = 10},
  [525] = {.lex_state = 10},
  [526] = {.lex_state = 38, .external_lex_state = 2},
  [527] = {.lex_state = 38, .external_lex_state = 2},
  [528] = {.lex_state = 38, .external_lex_state = 2},
  [529] = {.lex_state = 38, .external_lex_state = 2},
  [530] = {.lex_state = 38, .external_lex_state = 2},
  [531] = {.lex_state = 38, .external_lex_state = 2},
  [532] = {.lex_state = 38, .external_lex_state = 2},
  [533] = {.lex_state = 38, .external_lex_state = 2},
  [534] = {.lex_state = 9},
  [535] = {.lex_state = 38, .external_lex_state = 2},
  [536] = {.lex_state = 38, .external_lex_state = 2},
  [537] = {.lex_state = 38, .external_lex_state = 2},
  [538] = {.lex_state = 38, .external_lex_state = 2},
  [539] = {.lex_state = 38, .external_lex_state = 2},
  [540] = {.lex_state = 38, .external_lex_state = 2},
  [541] = {.lex_state = 38, .external_lex_state = 2},
  [542] = {.lex_state = 38, .external_lex_state = 2},
  [543] = {.lex_state = 38, .external_lex_state = 2},
  [544] = {.lex_state = 38, .external_lex_state = 2},
  [545] = {.lex_state = 38, .external_lex_state = 2},
  [546] = {.lex_state = 38, .external_lex_state = 2},
  [547] = {.lex_state = 38, .external_lex_state = 2},
  [548] = {.lex_state = 38, .external_lex_state = 2},
  [549] = {.lex_state = 38, .external_lex_state = 2},
  [550] = {.lex_state = 38, .external_lex_state = 2},
  [551] = {.lex_state = 38, .external_lex_state = 2},
  [552] = {.lex_state = 38, .external_lex_state = 2},
  [553] = {.lex_state = 38, .external_lex_state = 2},
  [554] = {.lex_state = 10},
  [555] = {.lex_state = 10},
  [556] = {.lex_state = 10},
  [557] = {.lex_state = 10},
  [558] = {.lex_state = 38, .external_lex_state = 2},
  [559] = {.lex_state = 10},
  [560] = {.lex_state = 38, .external_lex_state = 2},
  [561] = {.lex_state = 10},
  [562] = {.lex_state = 10},
  [563] = {.lex_state = 10},
  [564] = {.lex_state = 10, .external_lex_state = 4},
  [565] = {.lex_state = 10},
  [566] = {.lex_state = 38, .external_lex_state = 2},
  [567] = {.lex_state = 10},
  [568] = {.lex_state = 10},
  [569] = {.lex_state = 38, .external_lex_state = 2},
  [570] = {.lex_state = 10, .external_lex_state = 4},
  [571] = {.lex_state = 38, .external_lex_state = 2},
  [572] = {.lex_state = 10},
  [573] = {.lex_state = 10},
  [574] = {.lex_state = 38, .external_lex_state = 2},
  [575] = {.lex_state = 38, .external_lex_state = 2},
  [576] = {.lex_state = 38, .external_lex_state = 2},
  [577] = {.lex_state = 38, .external_lex_state = 2},
  [578] = {.lex_state = 38, .external_lex_state = 2},
  [579] = {.lex_state = 38, .external_lex_state = 2},
  [580] = {.lex_state = 38, .external_lex_state = 2},
  [581] = {.lex_state = 38, .external_lex_state = 2},
  [582] = {.lex_state = 38, .external_lex_state = 2},
  [583] = {.lex_state = 38, .external_lex_state = 2},
  [584] = {.lex_state = 9},
  [585] = {.lex_state = 10, .external_lex_state = 6},
  [586] = {.lex_state = 10, .external_lex_state = 2},
  [587] = {.lex_state = 10, .external_lex_state = 6},
  [588] = {.lex_state = 10},
  [589] = {.lex_state = 9},
  [590] = {.lex_state = 10, .external_lex_state = 6},
  [591] = {.lex_state = 10},
  [592] = {.lex_state = 10, .external_lex_state = 6},
  [593] = {.lex_state = 10, .external_lex_state = 6},
  [594] = {.lex_state = 10},
  [595] = {.lex_state = 10, .external_lex_state = 6},
  [596] = {.lex_state = 10, .external_lex_state = 6},
  [597] = {.lex_state = 10, .external_lex_state = 6},
  [598] = {.lex_state = 10, .external_lex_state = 6},
  [599] = {.lex_state = 10, .external_lex_state = 6},
  [600] = {.lex_state = 10, .external_lex_state = 6},
  [601] = {.lex_state = 10},
  [602] = {.lex_state = 10, .external_lex_state = 6},
  [603] = {.lex_state = 10, .external_lex_state = 6},
  [604] = {.lex_state = 10, .external_lex_state = 6},
  [605] = {.lex_state = 10, .external_lex_state = 6},
  [606] = {.lex_state = 10, .external_lex_state = 6},
  [607] = {.lex_state = 10, .external_lex_state = 6},
  [608] = {.lex_state = 10, .external_lex_state = 6},
  [609] = {.lex_state = 10, .external_lex_state = 6},
  [610] = {.lex_state = 10, .external_lex_state = 6},
  [611] = {.lex_state = 10, .external_lex_state = 2},
  [612] = {.lex_state = 10, .external_lex_state = 6},
  [613] = {.lex_state = 10},
  [614] = {.lex_state = 10, .external_lex_state = 6},
  [615] = {.lex_state = 10, .external_lex_state = 6},
  [616] = {.lex_state = 10, .external_lex_state = 6},
  [617] = {.lex_state = 10},
  [618] = {.lex_state = 10},
  [619] = {.lex_state = 10},
  [620] = {.lex_state = 10},
  [621] = {.lex_state = 10},
  [622] = {.lex_state = 10},
  [623] = {.lex_state = 10},
  [624] = {.lex_state = 10},
  [625] = {.lex_state = 9},
  [626] = {.lex_state = 10},
  [627] = {.lex_state = 10},
  [628] = {.lex_state = 10},
  [629] = {.lex_state = 10},
  [630] = {.lex_state = 10},
  [631] = {.lex_state = 10},
  [632] = {.lex_state = 10},
  [633] = {.lex_state = 10},
  [634] = {.lex_state = 10},
  [635] = {.lex_state = 10},
  [636] = {.lex_state = 9},
  [637] = {.lex_state = 10},
  [638] = {.lex_state = 10},
  [639] = {.lex_state = 10},
  [640] = {.lex_state = 10},
  [641] = {.lex_state = 10},
  [642] = {.lex_state = 10},
  [643] = {.lex_state = 10},
  [644] = {.lex_state = 10},
  [645] = {.lex_state = 10},
  [646] = {.lex_state = 10},
  [647] = {.lex_state = 10},
  [648] = {.lex_state = 10},
  [649] = {.lex_state = 38},
  [650] = {.lex_state = 38},
  [651] = {.lex_state = 38},
  [652] = {.lex_state = 38},
  [653] = {.lex_state = 38},
  [654] = {.lex_state = 0, .external_lex_state = 6},
  [655] = {.lex_state = 38},
  [656] = {.lex_state = 10, .external_lex_state = 6},
  [657] = {.lex_state = 10},
  [658] = {.lex_state = 10},
  [659] = {.lex_state = 38},
  [660] = {.lex_state = 0, .external_lex_state = 6},
  [661] = {.lex_state = 38},
  [662] = {.lex_state = 38},
  [663] = {.lex_state = 38},
  [664] = {.lex_state = 10},
  [665] = {.lex_state = 38},
  [666] = {.lex_state = 38},
  [667] = {.lex_state = 38},
  [668] = {.lex_state = 38},
  [669] = {.lex_state = 38},
  [670] = {.lex_state = 38},
  [671] = {.lex_state = 38},
  [672] = {.lex_state = 38},
  [673] = {.lex_state = 38},
  [674] = {.lex_state = 38},
  [675] = {.lex_state = 38},
  [676] = {.lex_state = 38},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 38},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 38},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 38},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 38},
  [685] = {.lex_state = 38},
  [686] = {.lex_state = 38},
  [687] = {.lex_state = 38},
  [688] = {.lex_state = 38},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 38},
  [691] = {.lex_state = 38},
  [692] = {.lex_state = 38},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 38},
  [695] = {.lex_state = 38},
  [696] = {.lex_state = 38},
  [697] = {.lex_state = 38},
  [698] = {.lex_state = 38},
  [699] = {.lex_state = 38},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0, .external_lex_state = 6},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0, .external_lex_state = 6},
  [720] = {.lex_state = 0, .external_lex_state = 6},
  [721] = {.lex_state = 0, .external_lex_state = 6},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0, .external_lex_state = 6},
  [724] = {.lex_state = 0, .external_lex_state = 6},
  [725] = {.lex_state = 0, .external_lex_state = 6},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 0},
  [728] = {.lex_state = 0, .external_lex_state = 6},
  [729] = {.lex_state = 38},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 0, .external_lex_state = 6},
  [734] = {.lex_state = 0, .external_lex_state = 6},
  [735] = {.lex_state = 12, .external_lex_state = 7},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 0, .external_lex_state = 6},
  [738] = {.lex_state = 0, .external_lex_state = 6},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 38},
  [741] = {.lex_state = 38},
  [742] = {.lex_state = 0, .external_lex_state = 6},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 0, .external_lex_state = 6},
  [745] = {.lex_state = 12, .external_lex_state = 7},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 12, .external_lex_state = 7},
  [748] = {.lex_state = 12, .external_lex_state = 7},
  [749] = {.lex_state = 38},
  [750] = {.lex_state = 12, .external_lex_state = 7},
  [751] = {.lex_state = 12, .external_lex_state = 7},
  [752] = {.lex_state = 38},
  [753] = {.lex_state = 38},
  [754] = {.lex_state = 12, .external_lex_state = 7},
  [755] = {.lex_state = 0, .external_lex_state = 6},
  [756] = {.lex_state = 0, .external_lex_state = 6},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 12, .external_lex_state = 7},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 0, .external_lex_state = 6},
  [762] = {.lex_state = 38},
  [763] = {.lex_state = 38},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 12, .external_lex_state = 7},
  [768] = {.lex_state = 38},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 38},
  [771] = {.lex_state = 38},
  [772] = {.lex_state = 0, .external_lex_state = 6},
  [773] = {.lex_state = 38},
  [774] = {.lex_state = 38},
  [775] = {.lex_state = 38},
  [776] = {.lex_state = 0, .external_lex_state = 6},
  [777] = {.lex_state = 38},
  [778] = {.lex_state = 10},
  [779] = {.lex_state = 38},
  [780] = {.lex_state = 38},
  [781] = {.lex_state = 10},
  [782] = {.lex_state = 0, .external_lex_state = 6},
  [783] = {.lex_state = 10, .external_lex_state = 6},
  [784] = {.lex_state = 38},
  [785] = {.lex_state = 38},
  [786] = {.lex_state = 38},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 38},
  [789] = {.lex_state = 38},
  [790] = {.lex_state = 10, .external_lex_state = 6},
  [791] = {.lex_state = 10},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 0, .external_lex_state = 6},
  [794] = {.lex_state = 38},
  [795] = {.lex_state = 38},
  [796] = {.lex_state = 38},
  [797] = {.lex_state = 10},
  [798] = {.lex_state = 38},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 38},
  [801] = {.lex_state = 10, .external_lex_state = 6},
  [802] = {.lex_state = 38},
  [803] = {.lex_state = 0, .external_lex_state = 6},
  [804] = {.lex_state = 38},
  [805] = {.lex_state = 0, .external_lex_state = 6},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 10, .external_lex_state = 6},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 10},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 0},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 0, .external_lex_state = 6},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 4},
  [820] = {.lex_state = 0, .external_lex_state = 6},
  [821] = {.lex_state = 12, .external_lex_state = 7},
  [822] = {.lex_state = 12, .external_lex_state = 7},
  [823] = {.lex_state = 4},
  [824] = {.lex_state = 0, .external_lex_state = 6},
  [825] = {.lex_state = 0, .external_lex_state = 6},
  [826] = {.lex_state = 0, .external_lex_state = 6},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 4},
  [831] = {.lex_state = 12, .external_lex_state = 7},
  [832] = {.lex_state = 0, .external_lex_state = 6},
  [833] = {.lex_state = 0, .external_lex_state = 6},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0, .external_lex_state = 6},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0, .external_lex_state = 6},
  [839] = {.lex_state = 0, .external_lex_state = 6},
  [840] = {.lex_state = 0, .external_lex_state = 6},
  [841] = {.lex_state = 38},
  [842] = {.lex_state = 38},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 10},
  [846] = {.lex_state = 0, .external_lex_state = 6},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0, .external_lex_state = 6},
  [853] = {.lex_state = 38},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 10},
  [856] = {.lex_state = 38},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0, .external_lex_state = 6},
  [859] = {.lex_state = 0, .external_lex_state = 6},
  [860] = {.lex_state = 0, .external_lex_state = 6},
  [861] = {.lex_state = 38},
  [862] = {.lex_state = 38},
  [863] = {.lex_state = 38},
  [864] = {.lex_state = 38},
  [865] = {.lex_state = 38},
  [866] = {.lex_state = 38},
  [867] = {.lex_state = 38},
  [868] = {.lex_state = 0, .external_lex_state = 6},
  [869] = {.lex_state = 0, .external_lex_state = 6},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 0, .external_lex_state = 6},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0, .external_lex_state = 6},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 0, .external_lex_state = 6},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 0, .external_lex_state = 6},
  [880] = {.lex_state = 0, .external_lex_state = 6},
  [881] = {.lex_state = 0, .external_lex_state = 6},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 0, .external_lex_state = 6},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 38},
  [887] = {.lex_state = 38},
  [888] = {.lex_state = 38},
  [889] = {.lex_state = 38},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0, .external_lex_state = 6},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0, .external_lex_state = 6},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0, .external_lex_state = 6},
  [900] = {.lex_state = 38},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 4},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0, .external_lex_state = 6},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 38},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 38},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 0, .external_lex_state = 6},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 38},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 0, .external_lex_state = 6},
  [938] = {.lex_state = 0, .external_lex_state = 6},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0, .external_lex_state = 6},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 38},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 38},
  [952] = {.lex_state = 38},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0, .external_lex_state = 6},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0, .external_lex_state = 6},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0, .external_lex_state = 6},
  [960] = {.lex_state = 0, .external_lex_state = 6},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 38},
  [963] = {.lex_state = 38},
  [964] = {.lex_state = 38},
  [965] = {.lex_state = 0, .external_lex_state = 6},
  [966] = {.lex_state = 0, .external_lex_state = 6},
  [967] = {.lex_state = 38},
  [968] = {.lex_state = 38},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 0, .external_lex_state = 6},
  [971] = {.lex_state = 38},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 0, .external_lex_state = 6},
  [974] = {.lex_state = 0, .external_lex_state = 6},
  [975] = {.lex_state = 0, .external_lex_state = 6},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0, .external_lex_state = 6},
  [978] = {.lex_state = 0, .external_lex_state = 6},
  [979] = {.lex_state = 38},
  [980] = {.lex_state = 0, .external_lex_state = 6},
  [981] = {.lex_state = 0, .external_lex_state = 6},
  [982] = {.lex_state = 0, .external_lex_state = 6},
  [983] = {.lex_state = 0, .external_lex_state = 6},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 11},
  [987] = {.lex_state = 11},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0, .external_lex_state = 6},
  [995] = {.lex_state = 11},
  [996] = {.lex_state = 11},
  [997] = {.lex_state = 0, .external_lex_state = 6},
  [998] = {.lex_state = 11},
  [999] = {.lex_state = 0, .external_lex_state = 6},
  [1000] = {.lex_state = 0, .external_lex_state = 6},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0, .external_lex_state = 6},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0, .external_lex_state = 6},
  [1008] = {.lex_state = 0, .external_lex_state = 6},
  [1009] = {.lex_state = 11},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0, .external_lex_state = 6},
  [1012] = {.lex_state = 0, .external_lex_state = 6},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 38},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 38},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 38},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 38},
  [1048] = {.lex_state = 38},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 38},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 38},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 38},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 38},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 38},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 38},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 38},
  [1071] = {.lex_state = 38},
  [1072] = {.lex_state = 38},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 38},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 38},
  [1078] = {.lex_state = 38},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 38},
  [1081] = {.lex_state = 38},
  [1082] = {.lex_state = 38},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 38},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 38},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 38},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 38},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 38},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 38},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 38},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 38},
};

enum {
  ts_external_token__newline = 0,
  ts_external_token__indent = 1,
  ts_external_token__dedent = 2,
  ts_external_token__string_start = 3,
  ts_external_token__string_content = 4,
  ts_external_token__string_end = 5,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__newline] = sym__newline,
  [ts_external_token__indent] = sym__indent,
  [ts_external_token__dedent] = sym__dedent,
  [ts_external_token__string_start] = sym__string_start,
  [ts_external_token__string_content] = sym__string_content,
  [ts_external_token__string_end] = sym__string_end,
};

static bool ts_external_scanner_states[8][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__newline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
  },
  [2] = {
    [ts_external_token__string_start] = true,
  },
  [3] = {
    [ts_external_token__dedent] = true,
    [ts_external_token__string_start] = true,
  },
  [4] = {
    [ts_external_token__newline] = true,
    [ts_external_token__string_start] = true,
  },
  [5] = {
    [ts_external_token__newline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token__string_start] = true,
  },
  [6] = {
    [ts_external_token__newline] = true,
  },
  [7] = {
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym___future__] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_print] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_del] = ACTIONS(1),
    [anon_sym_raise] = ACTIONS(1),
    [anon_sym_pass] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_except] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_nonlocal] = ACTIONS(1),
    [anon_sym_exec] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_lambda] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AT_EQ] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [sym_ellipsis] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [sym_type_conversion] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_none] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym__semicolon] = ACTIONS(1),
    [sym__newline] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym__string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym__string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_module] = STATE(1085),
    [sym__statement] = STATE(42),
    [sym__simple_statements] = STATE(42),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_if_statement] = STATE(42),
    [sym_for_statement] = STATE(42),
    [sym_while_statement] = STATE(42),
    [sym_try_statement] = STATE(42),
    [sym_with_statement] = STATE(42),
    [sym_function_definition] = STATE(42),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_class_definition] = STATE(42),
    [sym_decorated_definition] = STATE(42),
    [sym_decorator] = STATE(732),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(42),
    [aux_sym_decorated_definition_repeat1] = STATE(732),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(35),
    [anon_sym_for] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_with] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(75),
  },
  [2] = {
    [sym__statement] = STATE(40),
    [sym__simple_statements] = STATE(40),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(40),
    [sym_for_statement] = STATE(40),
    [sym_while_statement] = STATE(40),
    [sym_try_statement] = STATE(40),
    [sym_with_statement] = STATE(40),
    [sym_function_definition] = STATE(40),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(40),
    [sym_decorated_definition] = STATE(40),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(808),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(40),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [3] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(322),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [4] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(316),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [5] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(290),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [6] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(362),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [7] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(357),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [8] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(354),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [9] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(369),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [10] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(401),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [11] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(365),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [12] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(381),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [13] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(368),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [14] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(337),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [15] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(395),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [16] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(346),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [17] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(433),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [18] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(269),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [19] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(373),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [20] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(338),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [21] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(298),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [22] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(410),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [23] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(380),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [24] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(386),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [25] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(415),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [26] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(403),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [27] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(413),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [28] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(375),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [29] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(389),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [30] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(423),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [31] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(219),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [32] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(351),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [33] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(308),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [34] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(335),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [35] = {
    [sym__statement] = STATE(40),
    [sym__simple_statements] = STATE(40),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(40),
    [sym_for_statement] = STATE(40),
    [sym_while_statement] = STATE(40),
    [sym_try_statement] = STATE(40),
    [sym_with_statement] = STATE(40),
    [sym_function_definition] = STATE(40),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(40),
    [sym_decorated_definition] = STATE(40),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(806),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(40),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [36] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(347),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [37] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(41),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(208),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [38] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(339),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [39] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(727),
    [sym_block] = STATE(408),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [40] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(727),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(75),
  },
  [41] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(727),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym__string_start] = ACTIONS(75),
  },
  [42] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(732),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(732),
    [ts_builtin_sym_end] = ACTIONS(103),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(35),
    [anon_sym_for] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_with] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(75),
  },
  [43] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(727),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_import] = ACTIONS(108),
    [anon_sym_from] = ACTIONS(111),
    [anon_sym_LPAREN] = ACTIONS(114),
    [anon_sym_STAR] = ACTIONS(117),
    [anon_sym_print] = ACTIONS(120),
    [anon_sym_assert] = ACTIONS(123),
    [anon_sym_return] = ACTIONS(126),
    [anon_sym_del] = ACTIONS(129),
    [anon_sym_raise] = ACTIONS(132),
    [anon_sym_pass] = ACTIONS(135),
    [anon_sym_break] = ACTIONS(138),
    [anon_sym_continue] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(144),
    [anon_sym_async] = ACTIONS(147),
    [anon_sym_for] = ACTIONS(150),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_try] = ACTIONS(156),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_def] = ACTIONS(162),
    [anon_sym_global] = ACTIONS(165),
    [anon_sym_nonlocal] = ACTIONS(168),
    [anon_sym_exec] = ACTIONS(171),
    [anon_sym_class] = ACTIONS(174),
    [anon_sym_AT] = ACTIONS(177),
    [anon_sym_LBRACK] = ACTIONS(180),
    [anon_sym_not] = ACTIONS(183),
    [anon_sym_PLUS] = ACTIONS(186),
    [anon_sym_DASH] = ACTIONS(186),
    [anon_sym_TILDE] = ACTIONS(186),
    [anon_sym_lambda] = ACTIONS(189),
    [anon_sym_yield] = ACTIONS(192),
    [sym_ellipsis] = ACTIONS(195),
    [anon_sym_LBRACE] = ACTIONS(198),
    [sym_integer] = ACTIONS(201),
    [sym_float] = ACTIONS(195),
    [anon_sym_await] = ACTIONS(204),
    [sym_true] = ACTIONS(201),
    [sym_false] = ACTIONS(201),
    [sym_none] = ACTIONS(201),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(207),
    [sym__string_start] = ACTIONS(209),
  },
  [44] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(727),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(212),
    [sym__string_start] = ACTIONS(75),
  },
  [45] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(732),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(732),
    [ts_builtin_sym_end] = ACTIONS(207),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_import] = ACTIONS(108),
    [anon_sym_from] = ACTIONS(111),
    [anon_sym_LPAREN] = ACTIONS(114),
    [anon_sym_STAR] = ACTIONS(117),
    [anon_sym_print] = ACTIONS(120),
    [anon_sym_assert] = ACTIONS(123),
    [anon_sym_return] = ACTIONS(126),
    [anon_sym_del] = ACTIONS(129),
    [anon_sym_raise] = ACTIONS(132),
    [anon_sym_pass] = ACTIONS(135),
    [anon_sym_break] = ACTIONS(138),
    [anon_sym_continue] = ACTIONS(141),
    [anon_sym_if] = ACTIONS(214),
    [anon_sym_async] = ACTIONS(217),
    [anon_sym_for] = ACTIONS(220),
    [anon_sym_while] = ACTIONS(223),
    [anon_sym_try] = ACTIONS(226),
    [anon_sym_with] = ACTIONS(229),
    [anon_sym_def] = ACTIONS(232),
    [anon_sym_global] = ACTIONS(165),
    [anon_sym_nonlocal] = ACTIONS(168),
    [anon_sym_exec] = ACTIONS(171),
    [anon_sym_class] = ACTIONS(235),
    [anon_sym_AT] = ACTIONS(177),
    [anon_sym_LBRACK] = ACTIONS(180),
    [anon_sym_not] = ACTIONS(183),
    [anon_sym_PLUS] = ACTIONS(186),
    [anon_sym_DASH] = ACTIONS(186),
    [anon_sym_TILDE] = ACTIONS(186),
    [anon_sym_lambda] = ACTIONS(189),
    [anon_sym_yield] = ACTIONS(192),
    [sym_ellipsis] = ACTIONS(195),
    [anon_sym_LBRACE] = ACTIONS(198),
    [sym_integer] = ACTIONS(201),
    [sym_float] = ACTIONS(195),
    [anon_sym_await] = ACTIONS(204),
    [sym_true] = ACTIONS(201),
    [sym_false] = ACTIONS(201),
    [sym_none] = ACTIONS(201),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(209),
  },
  [46] = {
    [sym_chevron] = STATE(852),
    [sym_named_expression] = STATE(721),
    [sym_expression] = STATE(772),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_attribute] = STATE(605),
    [sym_subscript] = STATE(605),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(238),
    [anon_sym_DOT] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(242),
    [anon_sym_COMMA] = ACTIONS(244),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_print] = ACTIONS(247),
    [anon_sym_GT_GT] = ACTIONS(249),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_COLON] = ACTIONS(251),
    [anon_sym_async] = ACTIONS(247),
    [anon_sym_in] = ACTIONS(240),
    [anon_sym_STAR_STAR] = ACTIONS(240),
    [anon_sym_exec] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(240),
    [anon_sym_LBRACK] = ACTIONS(242),
    [anon_sym_EQ] = ACTIONS(253),
    [anon_sym_not] = ACTIONS(240),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(240),
    [anon_sym_SLASH_SLASH] = ACTIONS(240),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_AMP] = ACTIONS(240),
    [anon_sym_CARET] = ACTIONS(240),
    [anon_sym_LT_LT] = ACTIONS(240),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(242),
    [anon_sym_EQ_EQ] = ACTIONS(242),
    [anon_sym_BANG_EQ] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(242),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_LT_GT] = ACTIONS(242),
    [anon_sym_is] = ACTIONS(240),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_PLUS_EQ] = ACTIONS(251),
    [anon_sym_DASH_EQ] = ACTIONS(251),
    [anon_sym_STAR_EQ] = ACTIONS(251),
    [anon_sym_SLASH_EQ] = ACTIONS(251),
    [anon_sym_AT_EQ] = ACTIONS(251),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(251),
    [anon_sym_PERCENT_EQ] = ACTIONS(251),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(251),
    [anon_sym_GT_GT_EQ] = ACTIONS(251),
    [anon_sym_LT_LT_EQ] = ACTIONS(251),
    [anon_sym_AMP_EQ] = ACTIONS(251),
    [anon_sym_CARET_EQ] = ACTIONS(251),
    [anon_sym_PIPE_EQ] = ACTIONS(251),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(255),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__semicolon] = ACTIONS(242),
    [sym__newline] = ACTIONS(242),
    [sym__string_start] = ACTIONS(75),
  },
  [47] = {
    [sym_named_expression] = STATE(721),
    [sym_expression] = STATE(723),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_attribute] = STATE(605),
    [sym_subscript] = STATE(605),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(238),
    [anon_sym_DOT] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_COMMA] = ACTIONS(244),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_print] = ACTIONS(247),
    [anon_sym_GT_GT] = ACTIONS(240),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_COLON] = ACTIONS(251),
    [anon_sym_async] = ACTIONS(247),
    [anon_sym_in] = ACTIONS(240),
    [anon_sym_STAR_STAR] = ACTIONS(240),
    [anon_sym_exec] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(240),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_EQ] = ACTIONS(253),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(261),
    [anon_sym_DASH] = ACTIONS(261),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(240),
    [anon_sym_SLASH_SLASH] = ACTIONS(240),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_AMP] = ACTIONS(240),
    [anon_sym_CARET] = ACTIONS(240),
    [anon_sym_LT_LT] = ACTIONS(240),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(242),
    [anon_sym_EQ_EQ] = ACTIONS(242),
    [anon_sym_BANG_EQ] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(242),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_LT_GT] = ACTIONS(242),
    [anon_sym_is] = ACTIONS(240),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_PLUS_EQ] = ACTIONS(251),
    [anon_sym_DASH_EQ] = ACTIONS(251),
    [anon_sym_STAR_EQ] = ACTIONS(251),
    [anon_sym_SLASH_EQ] = ACTIONS(251),
    [anon_sym_AT_EQ] = ACTIONS(251),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(251),
    [anon_sym_PERCENT_EQ] = ACTIONS(251),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(251),
    [anon_sym_GT_GT_EQ] = ACTIONS(251),
    [anon_sym_LT_LT_EQ] = ACTIONS(251),
    [anon_sym_AMP_EQ] = ACTIONS(251),
    [anon_sym_CARET_EQ] = ACTIONS(251),
    [anon_sym_PIPE_EQ] = ACTIONS(251),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(255),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__semicolon] = ACTIONS(242),
    [sym__newline] = ACTIONS(242),
    [sym__string_start] = ACTIONS(75),
  },
  [48] = {
    [sym__simple_statements] = STATE(412),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(265),
    [sym__indent] = ACTIONS(267),
    [sym__string_start] = ACTIONS(75),
  },
  [49] = {
    [sym__simple_statements] = STATE(400),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(269),
    [sym__indent] = ACTIONS(271),
    [sym__string_start] = ACTIONS(75),
  },
  [50] = {
    [sym__simple_statements] = STATE(419),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(273),
    [sym__indent] = ACTIONS(275),
    [sym__string_start] = ACTIONS(75),
  },
  [51] = {
    [sym__simple_statements] = STATE(356),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym__indent] = ACTIONS(279),
    [sym__string_start] = ACTIONS(75),
  },
  [52] = {
    [sym__simple_statements] = STATE(313),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(281),
    [sym__indent] = ACTIONS(283),
    [sym__string_start] = ACTIONS(75),
  },
  [53] = {
    [sym__simple_statements] = STATE(311),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(285),
    [sym__indent] = ACTIONS(287),
    [sym__string_start] = ACTIONS(75),
  },
  [54] = {
    [sym__simple_statements] = STATE(343),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(289),
    [sym__indent] = ACTIONS(291),
    [sym__string_start] = ACTIONS(75),
  },
  [55] = {
    [sym__simple_statements] = STATE(813),
    [sym_import_statement] = STATE(894),
    [sym_future_import_statement] = STATE(894),
    [sym_import_from_statement] = STATE(894),
    [sym_print_statement] = STATE(894),
    [sym_assert_statement] = STATE(894),
    [sym_expression_statement] = STATE(894),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(894),
    [sym_delete_statement] = STATE(894),
    [sym_raise_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_global_statement] = STATE(894),
    [sym_nonlocal_statement] = STATE(894),
    [sym_exec_statement] = STATE(894),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(293),
    [sym__indent] = ACTIONS(295),
    [sym__string_start] = ACTIONS(75),
  },
  [56] = {
    [sym__simple_statements] = STATE(409),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(297),
    [sym__indent] = ACTIONS(299),
    [sym__string_start] = ACTIONS(75),
  },
  [57] = {
    [sym__simple_statements] = STATE(273),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(301),
    [sym__indent] = ACTIONS(303),
    [sym__string_start] = ACTIONS(75),
  },
  [58] = {
    [sym__simple_statements] = STATE(201),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(305),
    [sym__indent] = ACTIONS(307),
    [sym__string_start] = ACTIONS(75),
  },
  [59] = {
    [sym__simple_statements] = STATE(342),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(309),
    [sym__indent] = ACTIONS(311),
    [sym__string_start] = ACTIONS(75),
  },
  [60] = {
    [sym__simple_statements] = STATE(431),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(313),
    [sym__indent] = ACTIONS(315),
    [sym__string_start] = ACTIONS(75),
  },
  [61] = {
    [sym__simple_statements] = STATE(382),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(317),
    [sym__indent] = ACTIONS(319),
    [sym__string_start] = ACTIONS(75),
  },
  [62] = {
    [sym__simple_statements] = STATE(391),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(321),
    [sym__indent] = ACTIONS(323),
    [sym__string_start] = ACTIONS(75),
  },
  [63] = {
    [sym__simple_statements] = STATE(814),
    [sym_import_statement] = STATE(894),
    [sym_future_import_statement] = STATE(894),
    [sym_import_from_statement] = STATE(894),
    [sym_print_statement] = STATE(894),
    [sym_assert_statement] = STATE(894),
    [sym_expression_statement] = STATE(894),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(894),
    [sym_delete_statement] = STATE(894),
    [sym_raise_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_global_statement] = STATE(894),
    [sym_nonlocal_statement] = STATE(894),
    [sym_exec_statement] = STATE(894),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(325),
    [sym__indent] = ACTIONS(327),
    [sym__string_start] = ACTIONS(75),
  },
  [64] = {
    [sym__simple_statements] = STATE(407),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(329),
    [sym__indent] = ACTIONS(331),
    [sym__string_start] = ACTIONS(75),
  },
  [65] = {
    [sym__simple_statements] = STATE(336),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(333),
    [sym__indent] = ACTIONS(335),
    [sym__string_start] = ACTIONS(75),
  },
  [66] = {
    [sym__simple_statements] = STATE(206),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(337),
    [sym__indent] = ACTIONS(339),
    [sym__string_start] = ACTIONS(75),
  },
  [67] = {
    [sym__simple_statements] = STATE(355),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(341),
    [sym__indent] = ACTIONS(343),
    [sym__string_start] = ACTIONS(75),
  },
  [68] = {
    [sym__simple_statements] = STATE(285),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(345),
    [sym__indent] = ACTIONS(347),
    [sym__string_start] = ACTIONS(75),
  },
  [69] = {
    [sym__simple_statements] = STATE(345),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(349),
    [sym__indent] = ACTIONS(351),
    [sym__string_start] = ACTIONS(75),
  },
  [70] = {
    [sym__simple_statements] = STATE(416),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(353),
    [sym__indent] = ACTIONS(355),
    [sym__string_start] = ACTIONS(75),
  },
  [71] = {
    [sym__simple_statements] = STATE(404),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(357),
    [sym__indent] = ACTIONS(359),
    [sym__string_start] = ACTIONS(75),
  },
  [72] = {
    [sym__simple_statements] = STATE(388),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(361),
    [sym__indent] = ACTIONS(363),
    [sym__string_start] = ACTIONS(75),
  },
  [73] = {
    [sym__simple_statements] = STATE(305),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(365),
    [sym__indent] = ACTIONS(367),
    [sym__string_start] = ACTIONS(75),
  },
  [74] = {
    [sym__simple_statements] = STATE(430),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(369),
    [sym__indent] = ACTIONS(371),
    [sym__string_start] = ACTIONS(75),
  },
  [75] = {
    [sym__simple_statements] = STATE(359),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(373),
    [sym__indent] = ACTIONS(375),
    [sym__string_start] = ACTIONS(75),
  },
  [76] = {
    [sym__simple_statements] = STATE(371),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(377),
    [sym__indent] = ACTIONS(379),
    [sym__string_start] = ACTIONS(75),
  },
  [77] = {
    [sym__simple_statements] = STATE(390),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(381),
    [sym__indent] = ACTIONS(383),
    [sym__string_start] = ACTIONS(75),
  },
  [78] = {
    [sym__simple_statements] = STATE(399),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(385),
    [sym__indent] = ACTIONS(387),
    [sym__string_start] = ACTIONS(75),
  },
  [79] = {
    [sym__simple_statements] = STATE(350),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(389),
    [sym__indent] = ACTIONS(391),
    [sym__string_start] = ACTIONS(75),
  },
  [80] = {
    [sym__simple_statements] = STATE(414),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(393),
    [sym__indent] = ACTIONS(395),
    [sym__string_start] = ACTIONS(75),
  },
  [81] = {
    [sym__simple_statements] = STATE(340),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(397),
    [sym__indent] = ACTIONS(399),
    [sym__string_start] = ACTIONS(75),
  },
  [82] = {
    [sym__simple_statements] = STATE(358),
    [sym_import_statement] = STATE(899),
    [sym_future_import_statement] = STATE(899),
    [sym_import_from_statement] = STATE(899),
    [sym_print_statement] = STATE(899),
    [sym_assert_statement] = STATE(899),
    [sym_expression_statement] = STATE(899),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(899),
    [sym_delete_statement] = STATE(899),
    [sym_raise_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_global_statement] = STATE(899),
    [sym_nonlocal_statement] = STATE(899),
    [sym_exec_statement] = STATE(899),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(401),
    [sym__indent] = ACTIONS(403),
    [sym__string_start] = ACTIONS(75),
  },
  [83] = {
    [sym__simple_statements] = STATE(364),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(405),
    [sym__indent] = ACTIONS(407),
    [sym__string_start] = ACTIONS(75),
  },
  [84] = {
    [sym__simple_statements] = STATE(317),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(409),
    [sym__indent] = ACTIONS(411),
    [sym__string_start] = ACTIONS(75),
  },
  [85] = {
    [sym__simple_statements] = STATE(379),
    [sym_import_statement] = STATE(959),
    [sym_future_import_statement] = STATE(959),
    [sym_import_from_statement] = STATE(959),
    [sym_print_statement] = STATE(959),
    [sym_assert_statement] = STATE(959),
    [sym_expression_statement] = STATE(959),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(959),
    [sym_delete_statement] = STATE(959),
    [sym_raise_statement] = STATE(959),
    [sym_pass_statement] = STATE(959),
    [sym_break_statement] = STATE(959),
    [sym_continue_statement] = STATE(959),
    [sym_global_statement] = STATE(959),
    [sym_nonlocal_statement] = STATE(959),
    [sym_exec_statement] = STATE(959),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(413),
    [sym__indent] = ACTIONS(415),
    [sym__string_start] = ACTIONS(75),
  },
  [86] = {
    [sym_import_statement] = STATE(974),
    [sym_future_import_statement] = STATE(974),
    [sym_import_from_statement] = STATE(974),
    [sym_print_statement] = STATE(974),
    [sym_assert_statement] = STATE(974),
    [sym_expression_statement] = STATE(974),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(974),
    [sym_delete_statement] = STATE(974),
    [sym_raise_statement] = STATE(974),
    [sym_pass_statement] = STATE(974),
    [sym_break_statement] = STATE(974),
    [sym_continue_statement] = STATE(974),
    [sym_global_statement] = STATE(974),
    [sym_nonlocal_statement] = STATE(974),
    [sym_exec_statement] = STATE(974),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(417),
    [sym__string_start] = ACTIONS(75),
  },
  [87] = {
    [sym_import_statement] = STATE(974),
    [sym_future_import_statement] = STATE(974),
    [sym_import_from_statement] = STATE(974),
    [sym_print_statement] = STATE(974),
    [sym_assert_statement] = STATE(974),
    [sym_expression_statement] = STATE(974),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(974),
    [sym_delete_statement] = STATE(974),
    [sym_raise_statement] = STATE(974),
    [sym_pass_statement] = STATE(974),
    [sym_break_statement] = STATE(974),
    [sym_continue_statement] = STATE(974),
    [sym_global_statement] = STATE(974),
    [sym_nonlocal_statement] = STATE(974),
    [sym_exec_statement] = STATE(974),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(419),
    [sym__string_start] = ACTIONS(75),
  },
  [88] = {
    [sym_import_statement] = STATE(974),
    [sym_future_import_statement] = STATE(974),
    [sym_import_from_statement] = STATE(974),
    [sym_print_statement] = STATE(974),
    [sym_assert_statement] = STATE(974),
    [sym_expression_statement] = STATE(974),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(974),
    [sym_delete_statement] = STATE(974),
    [sym_raise_statement] = STATE(974),
    [sym_pass_statement] = STATE(974),
    [sym_break_statement] = STATE(974),
    [sym_continue_statement] = STATE(974),
    [sym_global_statement] = STATE(974),
    [sym_nonlocal_statement] = STATE(974),
    [sym_exec_statement] = STATE(974),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(421),
    [sym__string_start] = ACTIONS(75),
  },
  [89] = {
    [sym_import_statement] = STATE(974),
    [sym_future_import_statement] = STATE(974),
    [sym_import_from_statement] = STATE(974),
    [sym_print_statement] = STATE(974),
    [sym_assert_statement] = STATE(974),
    [sym_expression_statement] = STATE(974),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(974),
    [sym_delete_statement] = STATE(974),
    [sym_raise_statement] = STATE(974),
    [sym_pass_statement] = STATE(974),
    [sym_break_statement] = STATE(974),
    [sym_continue_statement] = STATE(974),
    [sym_global_statement] = STATE(974),
    [sym_nonlocal_statement] = STATE(974),
    [sym_exec_statement] = STATE(974),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(423),
    [sym__string_start] = ACTIONS(75),
  },
  [90] = {
    [sym_import_statement] = STATE(974),
    [sym_future_import_statement] = STATE(974),
    [sym_import_from_statement] = STATE(974),
    [sym_print_statement] = STATE(974),
    [sym_assert_statement] = STATE(974),
    [sym_expression_statement] = STATE(974),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(974),
    [sym_delete_statement] = STATE(974),
    [sym_raise_statement] = STATE(974),
    [sym_pass_statement] = STATE(974),
    [sym_break_statement] = STATE(974),
    [sym_continue_statement] = STATE(974),
    [sym_global_statement] = STATE(974),
    [sym_nonlocal_statement] = STATE(974),
    [sym_exec_statement] = STATE(974),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(425),
    [sym__string_start] = ACTIONS(75),
  },
  [91] = {
    [sym_import_statement] = STATE(974),
    [sym_future_import_statement] = STATE(974),
    [sym_import_from_statement] = STATE(974),
    [sym_print_statement] = STATE(974),
    [sym_assert_statement] = STATE(974),
    [sym_expression_statement] = STATE(974),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(974),
    [sym_delete_statement] = STATE(974),
    [sym_raise_statement] = STATE(974),
    [sym_pass_statement] = STATE(974),
    [sym_break_statement] = STATE(974),
    [sym_continue_statement] = STATE(974),
    [sym_global_statement] = STATE(974),
    [sym_nonlocal_statement] = STATE(974),
    [sym_exec_statement] = STATE(974),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(427),
    [sym__string_start] = ACTIONS(75),
  },
  [92] = {
    [sym_import_statement] = STATE(974),
    [sym_future_import_statement] = STATE(974),
    [sym_import_from_statement] = STATE(974),
    [sym_print_statement] = STATE(974),
    [sym_assert_statement] = STATE(974),
    [sym_expression_statement] = STATE(974),
    [sym_named_expression] = STATE(721),
    [sym_return_statement] = STATE(974),
    [sym_delete_statement] = STATE(974),
    [sym_raise_statement] = STATE(974),
    [sym_pass_statement] = STATE(974),
    [sym_break_statement] = STATE(974),
    [sym_continue_statement] = STATE(974),
    [sym_global_statement] = STATE(974),
    [sym_nonlocal_statement] = STATE(974),
    [sym_exec_statement] = STATE(974),
    [sym_pattern] = STATE(667),
    [sym_tuple_pattern] = STATE(655),
    [sym_list_pattern] = STATE(655),
    [sym_list_splat_pattern] = STATE(655),
    [sym_expression] = STATE(738),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_assignment] = STATE(999),
    [sym_augmented_assignment] = STATE(999),
    [sym_pattern_list] = STATE(668),
    [sym_yield] = STATE(999),
    [sym_attribute] = STATE(210),
    [sym_subscript] = STATE(210),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(263),
    [anon_sym_global] = ACTIONS(47),
    [anon_sym_nonlocal] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(73),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(75),
  },
  [93] = {
    [sym_named_expression] = STATE(672),
    [sym_expression] = STATE(676),
    [sym_primary_expression] = STATE(448),
    [sym_not_operator] = STATE(672),
    [sym_boolean_operator] = STATE(672),
    [sym_binary_operator] = STATE(454),
    [sym_unary_operator] = STATE(454),
    [sym_comparison_operator] = STATE(672),
    [sym_lambda] = STATE(672),
    [sym_attribute] = STATE(454),
    [sym_subscript] = STATE(454),
    [sym_call] = STATE(454),
    [sym_list] = STATE(454),
    [sym_set] = STATE(454),
    [sym_tuple] = STATE(454),
    [sym_dictionary] = STATE(454),
    [sym_list_comprehension] = STATE(454),
    [sym_dictionary_comprehension] = STATE(454),
    [sym_set_comprehension] = STATE(454),
    [sym_generator_expression] = STATE(454),
    [sym_parenthesized_expression] = STATE(454),
    [sym_conditional_expression] = STATE(672),
    [sym_concatenated_string] = STATE(454),
    [sym_string] = STATE(361),
    [sym_await] = STATE(672),
    [sym_identifier] = ACTIONS(429),
    [anon_sym_DOT] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(431),
    [anon_sym_RPAREN] = ACTIONS(242),
    [anon_sym_COMMA] = ACTIONS(242),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_print] = ACTIONS(433),
    [anon_sym_GT_GT] = ACTIONS(242),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_COLON] = ACTIONS(242),
    [anon_sym_else] = ACTIONS(240),
    [anon_sym_async] = ACTIONS(433),
    [anon_sym_in] = ACTIONS(240),
    [anon_sym_STAR_STAR] = ACTIONS(242),
    [anon_sym_exec] = ACTIONS(433),
    [anon_sym_AT] = ACTIONS(242),
    [anon_sym_LBRACK] = ACTIONS(435),
    [anon_sym_RBRACK] = ACTIONS(242),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_not] = ACTIONS(437),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(439),
    [anon_sym_DASH] = ACTIONS(439),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(242),
    [anon_sym_SLASH_SLASH] = ACTIONS(242),
    [anon_sym_PIPE] = ACTIONS(242),
    [anon_sym_AMP] = ACTIONS(242),
    [anon_sym_CARET] = ACTIONS(242),
    [anon_sym_LT_LT] = ACTIONS(242),
    [anon_sym_TILDE] = ACTIONS(439),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(242),
    [anon_sym_EQ_EQ] = ACTIONS(242),
    [anon_sym_BANG_EQ] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(242),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_LT_GT] = ACTIONS(242),
    [anon_sym_is] = ACTIONS(240),
    [anon_sym_lambda] = ACTIONS(441),
    [sym_ellipsis] = ACTIONS(443),
    [anon_sym_LBRACE] = ACTIONS(445),
    [anon_sym_RBRACE] = ACTIONS(242),
    [sym_type_conversion] = ACTIONS(242),
    [sym_integer] = ACTIONS(447),
    [sym_float] = ACTIONS(443),
    [anon_sym_await] = ACTIONS(449),
    [sym_true] = ACTIONS(447),
    [sym_false] = ACTIONS(447),
    [sym_none] = ACTIONS(447),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(451),
  },
  [94] = {
    [sym_named_expression] = STATE(672),
    [sym_expression] = STATE(676),
    [sym_primary_expression] = STATE(447),
    [sym_not_operator] = STATE(672),
    [sym_boolean_operator] = STATE(672),
    [sym_binary_operator] = STATE(454),
    [sym_unary_operator] = STATE(454),
    [sym_comparison_operator] = STATE(672),
    [sym_lambda] = STATE(672),
    [sym_attribute] = STATE(454),
    [sym_subscript] = STATE(454),
    [sym_call] = STATE(454),
    [sym_list] = STATE(454),
    [sym_set] = STATE(454),
    [sym_tuple] = STATE(454),
    [sym_dictionary] = STATE(454),
    [sym_list_comprehension] = STATE(454),
    [sym_dictionary_comprehension] = STATE(454),
    [sym_set_comprehension] = STATE(454),
    [sym_generator_expression] = STATE(454),
    [sym_parenthesized_expression] = STATE(454),
    [sym_conditional_expression] = STATE(672),
    [sym_concatenated_string] = STATE(454),
    [sym_string] = STATE(361),
    [sym_await] = STATE(672),
    [sym_identifier] = ACTIONS(453),
    [anon_sym_DOT] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(455),
    [anon_sym_RPAREN] = ACTIONS(242),
    [anon_sym_COMMA] = ACTIONS(242),
    [anon_sym_as] = ACTIONS(240),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_print] = ACTIONS(457),
    [anon_sym_GT_GT] = ACTIONS(242),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_COLON] = ACTIONS(242),
    [anon_sym_async] = ACTIONS(457),
    [anon_sym_for] = ACTIONS(240),
    [anon_sym_in] = ACTIONS(240),
    [anon_sym_STAR_STAR] = ACTIONS(242),
    [anon_sym_exec] = ACTIONS(457),
    [anon_sym_AT] = ACTIONS(242),
    [anon_sym_LBRACK] = ACTIONS(459),
    [anon_sym_RBRACK] = ACTIONS(242),
    [anon_sym_not] = ACTIONS(461),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(242),
    [anon_sym_SLASH_SLASH] = ACTIONS(242),
    [anon_sym_PIPE] = ACTIONS(242),
    [anon_sym_AMP] = ACTIONS(242),
    [anon_sym_CARET] = ACTIONS(242),
    [anon_sym_LT_LT] = ACTIONS(242),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(242),
    [anon_sym_EQ_EQ] = ACTIONS(242),
    [anon_sym_BANG_EQ] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(242),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_LT_GT] = ACTIONS(242),
    [anon_sym_is] = ACTIONS(240),
    [anon_sym_lambda] = ACTIONS(465),
    [sym_ellipsis] = ACTIONS(443),
    [anon_sym_LBRACE] = ACTIONS(445),
    [anon_sym_RBRACE] = ACTIONS(242),
    [sym_integer] = ACTIONS(447),
    [sym_float] = ACTIONS(443),
    [anon_sym_await] = ACTIONS(467),
    [sym_true] = ACTIONS(447),
    [sym_false] = ACTIONS(447),
    [sym_none] = ACTIONS(447),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(451),
  },
  [95] = {
    [sym_named_expression] = STATE(721),
    [sym_expression] = STATE(723),
    [sym_primary_expression] = STATE(500),
    [sym_not_operator] = STATE(721),
    [sym_boolean_operator] = STATE(721),
    [sym_binary_operator] = STATE(605),
    [sym_unary_operator] = STATE(605),
    [sym_comparison_operator] = STATE(721),
    [sym_lambda] = STATE(721),
    [sym_attribute] = STATE(605),
    [sym_subscript] = STATE(605),
    [sym_call] = STATE(605),
    [sym_list] = STATE(605),
    [sym_set] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_dictionary] = STATE(605),
    [sym_list_comprehension] = STATE(605),
    [sym_dictionary_comprehension] = STATE(605),
    [sym_set_comprehension] = STATE(605),
    [sym_generator_expression] = STATE(605),
    [sym_parenthesized_expression] = STATE(605),
    [sym_conditional_expression] = STATE(721),
    [sym_concatenated_string] = STATE(605),
    [sym_string] = STATE(498),
    [sym_await] = STATE(721),
    [sym_identifier] = ACTIONS(238),
    [anon_sym_DOT] = ACTIONS(240),
    [anon_sym_from] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_COMMA] = ACTIONS(242),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_print] = ACTIONS(247),
    [anon_sym_GT_GT] = ACTIONS(242),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_async] = ACTIONS(247),
    [anon_sym_in] = ACTIONS(240),
    [anon_sym_STAR_STAR] = ACTIONS(242),
    [anon_sym_exec] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(242),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(242),
    [anon_sym_SLASH_SLASH] = ACTIONS(242),
    [anon_sym_PIPE] = ACTIONS(242),
    [anon_sym_AMP] = ACTIONS(242),
    [anon_sym_CARET] = ACTIONS(242),
    [anon_sym_LT_LT] = ACTIONS(242),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(242),
    [anon_sym_EQ_EQ] = ACTIONS(242),
    [anon_sym_BANG_EQ] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(242),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_LT_GT] = ACTIONS(242),
    [anon_sym_is] = ACTIONS(240),
    [anon_sym_lambda] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(255),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__semicolon] = ACTIONS(242),
    [sym__newline] = ACTIONS(242),
    [sym__string_start] = ACTIONS(75),
  },
  [96] = {
    [sym_named_expression] = STATE(672),
    [sym_expression] = STATE(676),
    [sym_primary_expression] = STATE(447),
    [sym_not_operator] = STATE(672),
    [sym_boolean_operator] = STATE(672),
    [sym_binary_operator] = STATE(454),
    [sym_unary_operator] = STATE(454),
    [sym_comparison_operator] = STATE(672),
    [sym_lambda] = STATE(672),
    [sym_attribute] = STATE(454),
    [sym_subscript] = STATE(454),
    [sym_call] = STATE(454),
    [sym_list] = STATE(454),
    [sym_set] = STATE(454),
    [sym_tuple] = STATE(454),
    [sym_dictionary] = STATE(454),
    [sym_list_comprehension] = STATE(454),
    [sym_dictionary_comprehension] = STATE(454),
    [sym_set_comprehension] = STATE(454),
    [sym_generator_expression] = STATE(454),
    [sym_parenthesized_expression] = STATE(454),
    [sym_conditional_expression] = STATE(672),
    [sym_concatenated_string] = STATE(454),
    [sym_string] = STATE(361),
    [sym_await] = STATE(672),
    [sym_identifier] = ACTIONS(453),
    [anon_sym_DOT] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(455),
    [anon_sym_RPAREN] = ACTIONS(242),
    [anon_sym_COMMA] = ACTIONS(242),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_print] = ACTIONS(457),
    [anon_sym_GT_GT] = ACTIONS(242),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_async] = ACTIONS(457),
    [anon_sym_for] = ACTIONS(240),
    [anon_sym_in] = ACTIONS(240),
    [anon_sym_STAR_STAR] = ACTIONS(242),
    [anon_sym_exec] = ACTIONS(457),
    [anon_sym_AT] = ACTIONS(242),
    [anon_sym_LBRACK] = ACTIONS(459),
    [anon_sym_EQ] = ACTIONS(469),
    [anon_sym_not] = ACTIONS(461),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(242),
    [anon_sym_SLASH_SLASH] = ACTIONS(242),
    [anon_sym_PIPE] = ACTIONS(242),
    [anon_sym_AMP] = ACTIONS(242),
    [anon_sym_CARET] = ACTIONS(242),
    [anon_sym_LT_LT] = ACTIONS(242),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(242),
    [anon_sym_EQ_EQ] = ACTIONS(242),
    [anon_sym_BANG_EQ] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(242),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_LT_GT] = ACTIONS(242),
    [anon_sym_is] = ACTIONS(240),
    [anon_sym_lambda] = ACTIONS(465),
    [sym_ellipsis] = ACTIONS(443),
    [anon_sym_LBRACE] = ACTIONS(445),
    [sym_integer] = ACTIONS(447),
    [sym_float] = ACTIONS(443),
    [anon_sym_await] = ACTIONS(467),
    [sym_true] = ACTIONS(447),
    [sym_false] = ACTIONS(447),
    [sym_none] = ACTIONS(447),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(451),
  },
  [97] = {
    [sym_named_expression] = STATE(763),
    [sym_expression] = STATE(770),
    [sym_primary_expression] = STATE(504),
    [sym_not_operator] = STATE(763),
    [sym_boolean_operator] = STATE(763),
    [sym_binary_operator] = STATE(640),
    [sym_unary_operator] = STATE(640),
    [sym_comparison_operator] = STATE(763),
    [sym_lambda] = STATE(763),
    [sym_attribute] = STATE(640),
    [sym_subscript] = STATE(640),
    [sym_call] = STATE(640),
    [sym_list] = STATE(640),
    [sym_set] = STATE(640),
    [sym_tuple] = STATE(640),
    [sym_dictionary] = STATE(640),
    [sym_list_comprehension] = STATE(640),
    [sym_dictionary_comprehension] = STATE(640),
    [sym_set_comprehension] = STATE(640),
    [sym_generator_expression] = STATE(640),
    [sym_parenthesized_expression] = STATE(640),
    [sym_conditional_expression] = STATE(763),
    [sym_concatenated_string] = STATE(640),
    [sym_string] = STATE(506),
    [sym_await] = STATE(763),
    [sym_identifier] = ACTIONS(471),
    [anon_sym_DOT] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_RPAREN] = ACTIONS(242),
    [anon_sym_COMMA] = ACTIONS(242),
    [anon_sym_as] = ACTIONS(240),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_print] = ACTIONS(433),
    [anon_sym_GT_GT] = ACTIONS(242),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_COLON] = ACTIONS(242),
    [anon_sym_async] = ACTIONS(433),
    [anon_sym_in] = ACTIONS(240),
    [anon_sym_STAR_STAR] = ACTIONS(242),
    [anon_sym_exec] = ACTIONS(433),
    [anon_sym_AT] = ACTIONS(242),
    [anon_sym_LBRACK] = ACTIONS(475),
    [anon_sym_not] = ACTIONS(477),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(479),
    [anon_sym_DASH] = ACTIONS(479),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(242),
    [anon_sym_SLASH_SLASH] = ACTIONS(242),
    [anon_sym_PIPE] = ACTIONS(242),
    [anon_sym_AMP] = ACTIONS(242),
    [anon_sym_CARET] = ACTIONS(242),
    [anon_sym_LT_LT] = ACTIONS(242),
    [anon_sym_TILDE] = ACTIONS(479),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(242),
    [anon_sym_EQ_EQ] = ACTIONS(242),
    [anon_sym_BANG_EQ] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(242),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_LT_GT] = ACTIONS(242),
    [anon_sym_is] = ACTIONS(240),
    [anon_sym_lambda] = ACTIONS(481),
    [sym_ellipsis] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [sym_integer] = ACTIONS(487),
    [sym_float] = ACTIONS(483),
    [anon_sym_await] = ACTIONS(489),
    [sym_true] = ACTIONS(487),
    [sym_false] = ACTIONS(487),
    [sym_none] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(491),
  },
  [98] = {
    [sym_named_expression] = STATE(672),
    [sym_expression] = STATE(676),
    [sym_primary_expression] = STATE(447),
    [sym_not_operator] = STATE(672),
    [sym_boolean_operator] = STATE(672),
    [sym_binary_operator] = STATE(454),
    [sym_unary_operator] = STATE(454),
    [sym_comparison_operator] = STATE(672),
    [sym_lambda] = STATE(672),
    [sym_attribute] = STATE(454),
    [sym_subscript] = STATE(454),
    [sym_call] = STATE(454),
    [sym_list] = STATE(454),
    [sym_set] = STATE(454),
    [sym_tuple] = STATE(454),
    [sym_dictionary] = STATE(454),
    [sym_list_comprehension] = STATE(454),
    [sym_dictionary_comprehension] = STATE(454),
    [sym_set_comprehension] = STATE(454),
    [sym_generator_expression] = STATE(454),
    [sym_parenthesized_expression] = STATE(454),
    [sym_conditional_expression] = STATE(672),
    [sym_concatenated_string] = STATE(454),
    [sym_string] = STATE(361),
    [sym_await] = STATE(672),
    [sym_identifier] = ACTIONS(453),
    [anon_sym_DOT] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(455),
    [anon_sym_RPAREN] = ACTIONS(244),
    [anon_sym_COMMA] = ACTIONS(244),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_print] = ACTIONS(457),
    [anon_sym_GT_GT] = ACTIONS(242),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_async] = ACTIONS(457),
    [anon_sym_for] = ACTIONS(240),
    [anon_sym_in] = ACTIONS(240),
    [anon_sym_STAR_STAR] = ACTIONS(242),
    [anon_sym_exec] = ACTIONS(457),
    [anon_sym_AT] = ACTIONS(242),
    [anon_sym_LBRACK] = ACTIONS(459),
    [anon_sym_RBRACK] = ACTIONS(244),
    [anon_sym_not] = ACTIONS(461),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(242),
    [anon_sym_SLASH_SLASH] = ACTIONS(242),
    [anon_sym_PIPE] = ACTIONS(242),
    [anon_sym_AMP] = ACTIONS(242),
    [anon_sym_CARET] = ACTIONS(242),
    [anon_sym_LT_LT] = ACTIONS(242),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(242),
    [anon_sym_EQ_EQ] = ACTIONS(242),
    [anon_sym_BANG_EQ] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(242),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_LT_GT] = ACTIONS(242),
    [anon_sym_is] = ACTIONS(240),
    [anon_sym_lambda] = ACTIONS(465),
    [sym_ellipsis] = ACTIONS(443),
    [anon_sym_LBRACE] = ACTIONS(445),
    [sym_integer] = ACTIONS(447),
    [sym_float] = ACTIONS(443),
    [anon_sym_await] = ACTIONS(467),
    [sym_true] = ACTIONS(447),
    [sym_false] = ACTIONS(447),
    [sym_none] = ACTIONS(447),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(451),
  },
  [99] = {
    [sym_named_expression] = STATE(672),
    [sym_expression] = STATE(676),
    [sym_primary_expression] = STATE(448),
    [sym_not_operator] = STATE(672),
    [sym_boolean_operator] = STATE(672),
    [sym_binary_operator] = STATE(454),
    [sym_unary_operator] = STATE(454),
    [sym_comparison_operator] = STATE(672),
    [sym_lambda] = STATE(672),
    [sym_attribute] = STATE(454),
    [sym_subscript] = STATE(454),
    [sym_call] = STATE(454),
    [sym_list] = STATE(454),
    [sym_set] = STATE(454),
    [sym_tuple] = STATE(454),
    [sym_dictionary] = STATE(454),
    [sym_list_comprehension] = STATE(454),
    [sym_dictionary_comprehension] = STATE(454),
    [sym_set_comprehension] = STATE(454),
    [sym_generator_expression] = STATE(454),
    [sym_parenthesized_expression] = STATE(454),
    [sym_conditional_expression] = STATE(672),
    [sym_concatenated_string] = STATE(454),
    [sym_string] = STATE(361),
    [sym_await] = STATE(672),
    [sym_identifier] = ACTIONS(429),
    [anon_sym_DOT] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(431),
    [anon_sym_RPAREN] = ACTIONS(242),
    [anon_sym_COMMA] = ACTIONS(242),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_print] = ACTIONS(433),
    [anon_sym_GT_GT] = ACTIONS(242),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_async] = ACTIONS(433),
    [anon_sym_in] = ACTIONS(240),
    [anon_sym_STAR_STAR] = ACTIONS(242),
    [anon_sym_exec] = ACTIONS(433),
    [anon_sym_AT] = ACTIONS(242),
    [anon_sym_LBRACK] = ACTIONS(435),
    [anon_sym_EQ] = ACTIONS(469),
    [anon_sym_not] = ACTIONS(437),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(439),
    [anon_sym_DASH] = ACTIONS(439),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(242),
    [anon_sym_SLASH_SLASH] = ACTIONS(242),
    [anon_sym_PIPE] = ACTIONS(242),
    [anon_sym_AMP] = ACTIONS(242),
    [anon_sym_CARET] = ACTIONS(242),
    [anon_sym_LT_LT] = ACTIONS(242),
    [anon_sym_TILDE] = ACTIONS(439),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(242),
    [anon_sym_EQ_EQ] = ACTIONS(242),
    [anon_sym_BANG_EQ] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(242),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_LT_GT] = ACTIONS(242),
    [anon_sym_is] = ACTIONS(240),
    [anon_sym_lambda] = ACTIONS(441),
    [sym_ellipsis] = ACTIONS(443),
    [anon_sym_LBRACE] = ACTIONS(445),
    [sym_integer] = ACTIONS(447),
    [sym_float] = ACTIONS(443),
    [anon_sym_await] = ACTIONS(449),
    [sym_true] = ACTIONS(447),
    [sym_false] = ACTIONS(447),
    [sym_none] = ACTIONS(447),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(451),
  },
  [100] = {
    [sym_named_expression] = STATE(672),
    [sym_expression] = STATE(676),
    [sym_primary_expression] = STATE(448),
    [sym_not_operator] = STATE(672),
    [sym_boolean_operator] = STATE(672),
    [sym_binary_operator] = STATE(454),
    [sym_unary_operator] = STATE(454),
    [sym_comparison_operator] = STATE(672),
    [sym_lambda] = STATE(672),
    [sym_attribute] = STATE(454),
    [sym_subscript] = STATE(454),
    [sym_call] = STATE(454),
    [sym_list] = STATE(454),
    [sym_set] = STATE(454),
    [sym_tuple] = STATE(454),
    [sym_dictionary] = STATE(454),
    [sym_list_comprehension] = STATE(454),
    [sym_dictionary_comprehension] = STATE(454),
    [sym_set_comprehension] = STATE(454),
    [sym_generator_expression] = STATE(454),
    [sym_parenthesized_expression] = STATE(454),
    [sym_conditional_expression] = STATE(672),
    [sym_concatenated_string] = STATE(454),
    [sym_string] = STATE(361),
    [sym_await] = STATE(672),
    [sym_identifier] = ACTIONS(429),
    [anon_sym_DOT] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(431),
    [anon_sym_RPAREN] = ACTIONS(493),
    [anon_sym_COMMA] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_print] = ACTIONS(433),
    [anon_sym_GT_GT] = ACTIONS(242),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_async] = ACTIONS(433),
    [anon_sym_in] = ACTIONS(240),
    [anon_sym_STAR_STAR] = ACTIONS(242),
    [anon_sym_exec] = ACTIONS(433),
    [anon_sym_AT] = ACTIONS(242),
    [anon_sym_LBRACK] = ACTIONS(435),
    [anon_sym_RBRACK] = ACTIONS(493),
    [anon_sym_not] = ACTIONS(437),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(439),
    [anon_sym_DASH] = ACTIONS(439),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(242),
    [anon_sym_SLASH_SLASH] = ACTIONS(242),
    [anon_sym_PIPE] = ACTIONS(242),
    [anon_sym_AMP] = ACTIONS(242),
    [anon_sym_CARET] = ACTIONS(242),
    [anon_sym_LT_LT] = ACTIONS(242),
    [anon_sym_TILDE] = ACTIONS(439),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(242),
    [anon_sym_EQ_EQ] = ACTIONS(242),
    [anon_sym_BANG_EQ] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(242),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_LT_GT] = ACTIONS(242),
    [anon_sym_is] = ACTIONS(240),
    [anon_sym_lambda] = ACTIONS(441),
    [sym_ellipsis] = ACTIONS(443),
    [anon_sym_LBRACE] = ACTIONS(445),
    [sym_integer] = ACTIONS(447),
    [sym_float] = ACTIONS(443),
    [anon_sym_await] = ACTIONS(449),
    [sym_true] = ACTIONS(447),
    [sym_false] = ACTIONS(447),
    [sym_none] = ACTIONS(447),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(451),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(496), 1,
      sym_identifier,
    ACTIONS(498), 1,
      anon_sym_LPAREN,
    ACTIONS(500), 1,
      anon_sym_STAR,
    ACTIONS(504), 1,
      anon_sym_LBRACK,
    ACTIONS(506), 1,
      anon_sym_RBRACK,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(510), 1,
      anon_sym_await,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(708), 1,
      sym_expression,
    STATE(848), 1,
      sym_pattern,
    STATE(1083), 1,
      sym__collection_elements,
    STATE(1096), 1,
      sym__patterns,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(588), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(502), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(655), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    STATE(827), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [113] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(496), 1,
      sym_identifier,
    ACTIONS(498), 1,
      anon_sym_LPAREN,
    ACTIONS(500), 1,
      anon_sym_STAR,
    ACTIONS(504), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(510), 1,
      anon_sym_await,
    ACTIONS(512), 1,
      anon_sym_RBRACK,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(703), 1,
      sym_expression,
    STATE(848), 1,
      sym_pattern,
    STATE(1096), 1,
      sym__patterns,
    STATE(1097), 1,
      sym__collection_elements,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(588), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(502), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(655), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    STATE(827), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [226] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(496), 1,
      sym_identifier,
    ACTIONS(498), 1,
      anon_sym_LPAREN,
    ACTIONS(500), 1,
      anon_sym_STAR,
    ACTIONS(504), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(510), 1,
      anon_sym_await,
    ACTIONS(514), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(705), 1,
      sym_expression,
    STATE(848), 1,
      sym_pattern,
    STATE(925), 1,
      sym_yield,
    STATE(1022), 1,
      sym__collection_elements,
    STATE(1034), 1,
      sym__patterns,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(588), 2,
      sym_attribute,
      sym_subscript,
    STATE(827), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(502), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(655), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [341] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(65), 1,
      anon_sym_yield,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(667), 1,
      sym_pattern,
    STATE(668), 1,
      sym_pattern_list,
    STATE(776), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    STATE(210), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(263), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(655), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1012), 5,
      sym_expression_list,
      sym_assignment,
      sym_augmented_assignment,
      sym__right_hand_side,
      sym_yield,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [450] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(65), 1,
      anon_sym_yield,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(667), 1,
      sym_pattern,
    STATE(668), 1,
      sym_pattern_list,
    STATE(776), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    STATE(210), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(263), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(655), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(973), 5,
      sym_expression_list,
      sym_assignment,
      sym_augmented_assignment,
      sym__right_hand_side,
      sym_yield,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [559] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(496), 1,
      sym_identifier,
    ACTIONS(498), 1,
      anon_sym_LPAREN,
    ACTIONS(500), 1,
      anon_sym_STAR,
    ACTIONS(504), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(510), 1,
      anon_sym_await,
    ACTIONS(516), 1,
      anon_sym_RBRACK,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(708), 1,
      sym_expression,
    STATE(848), 1,
      sym_pattern,
    STATE(1083), 1,
      sym__collection_elements,
    STATE(1096), 1,
      sym__patterns,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(588), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(502), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(655), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    STATE(827), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [672] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(65), 1,
      anon_sym_yield,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(667), 1,
      sym_pattern,
    STATE(668), 1,
      sym_pattern_list,
    STATE(776), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    STATE(210), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(263), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(655), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1007), 5,
      sym_expression_list,
      sym_assignment,
      sym_augmented_assignment,
      sym__right_hand_side,
      sym_yield,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [781] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(496), 1,
      sym_identifier,
    ACTIONS(498), 1,
      anon_sym_LPAREN,
    ACTIONS(500), 1,
      anon_sym_STAR,
    ACTIONS(504), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(510), 1,
      anon_sym_await,
    ACTIONS(518), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_expression,
    STATE(848), 1,
      sym_pattern,
    STATE(898), 1,
      sym_yield,
    STATE(1034), 1,
      sym__patterns,
    STATE(1087), 1,
      sym__collection_elements,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(588), 2,
      sym_attribute,
      sym_subscript,
    STATE(827), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(502), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(655), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [896] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(496), 1,
      sym_identifier,
    ACTIONS(498), 1,
      anon_sym_LPAREN,
    ACTIONS(500), 1,
      anon_sym_STAR,
    ACTIONS(504), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(510), 1,
      anon_sym_await,
    ACTIONS(520), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_expression,
    STATE(848), 1,
      sym_pattern,
    STATE(898), 1,
      sym_yield,
    STATE(905), 1,
      sym_parenthesized_list_splat,
    STATE(910), 1,
      sym_list_splat,
    STATE(1034), 1,
      sym__patterns,
    STATE(1087), 1,
      sym__collection_elements,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(588), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(502), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(655), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [1013] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_TILDE,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_in,
    ACTIONS(534), 1,
      anon_sym_LBRACK,
    STATE(361), 1,
      sym_string,
    STATE(661), 1,
      sym_pattern,
    STATE(664), 1,
      sym_primary_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(536), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(565), 2,
      sym_attribute,
      sym_subscript,
    STATE(655), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(528), 4,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
    STATE(454), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
    ACTIONS(530), 15,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [1111] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(538), 1,
      anon_sym_LPAREN,
    ACTIONS(540), 1,
      anon_sym_COMMA,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(546), 1,
      anon_sym_RBRACE,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(692), 1,
      sym_expression,
    STATE(765), 1,
      sym_pair,
    STATE(921), 1,
      sym_dictionary_splat,
    STATE(1064), 1,
      sym__collection_elements,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(827), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [1223] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(538), 1,
      anon_sym_LPAREN,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(548), 1,
      anon_sym_COMMA,
    ACTIONS(550), 1,
      anon_sym_RBRACE,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(686), 1,
      sym_expression,
    STATE(743), 1,
      sym_pair,
    STATE(907), 1,
      sym_dictionary_splat,
    STATE(1073), 1,
      sym__collection_elements,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(827), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [1335] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(538), 1,
      anon_sym_LPAREN,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(552), 1,
      anon_sym_COMMA,
    ACTIONS(554), 1,
      anon_sym_RBRACE,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(695), 1,
      sym_expression,
    STATE(766), 1,
      sym_pair,
    STATE(945), 1,
      sym_dictionary_splat,
    STATE(1046), 1,
      sym__collection_elements,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(827), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [1447] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_TILDE,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(534), 1,
      anon_sym_LBRACK,
    ACTIONS(558), 1,
      anon_sym_in,
    STATE(361), 1,
      sym_string,
    STATE(661), 1,
      sym_pattern,
    STATE(664), 1,
      sym_primary_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(536), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(565), 2,
      sym_attribute,
      sym_subscript,
    STATE(655), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(528), 4,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
    STATE(454), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
    ACTIONS(556), 15,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [1545] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 17,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(560), 36,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_RBRACE,
      sym_type_conversion,
  [1606] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(568), 1,
      anon_sym_STAR,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(760), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(566), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    STATE(872), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [1705] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(538), 1,
      anon_sym_LPAREN,
    ACTIONS(568), 1,
      anon_sym_STAR,
    ACTIONS(570), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(693), 1,
      sym_expression,
    STATE(897), 1,
      sym_with_item,
    STATE(947), 1,
      sym_yield,
    STATE(1059), 1,
      sym__collection_elements,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(827), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [1810] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(574), 17,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(572), 36,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_RBRACE,
      sym_type_conversion,
  [1871] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(578), 17,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(576), 36,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_RBRACE,
      sym_type_conversion,
  [1932] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(578), 17,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(576), 36,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_RBRACE,
      sym_type_conversion,
  [1993] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(538), 1,
      anon_sym_LPAREN,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      anon_sym_RPAREN,
    ACTIONS(584), 1,
      anon_sym_COMMA,
    ACTIONS(588), 1,
      anon_sym_await,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(701), 1,
      sym_expression,
    STATE(936), 1,
      sym_parenthesized_list_splat,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(586), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(935), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [2096] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(538), 1,
      anon_sym_LPAREN,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(588), 1,
      anon_sym_await,
    ACTIONS(590), 1,
      anon_sym_RPAREN,
    ACTIONS(592), 1,
      anon_sym_COMMA,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(706), 1,
      sym_expression,
    STATE(931), 1,
      sym_parenthesized_list_splat,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(586), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(932), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [2199] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(582), 1,
      anon_sym_RPAREN,
    ACTIONS(584), 1,
      anon_sym_COMMA,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_await,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(799), 1,
      sym_expression,
    STATE(936), 1,
      sym_parenthesized_list_splat,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(586), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(935), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [2302] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(538), 1,
      anon_sym_LPAREN,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(588), 1,
      anon_sym_await,
    ACTIONS(598), 1,
      anon_sym_RPAREN,
    ACTIONS(600), 1,
      anon_sym_COMMA,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(707), 1,
      sym_expression,
    STATE(946), 1,
      sym_parenthesized_list_splat,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(586), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(944), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [2405] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(604), 17,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(602), 36,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_RBRACE,
      sym_type_conversion,
  [2466] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(608), 17,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(606), 36,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_RBRACE,
      sym_type_conversion,
  [2527] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(568), 1,
      anon_sym_STAR,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(760), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(610), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    STATE(872), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [2626] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(574), 17,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(572), 36,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_RBRACE,
      sym_type_conversion,
  [2687] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_await,
    ACTIONS(612), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(817), 1,
      sym_expression,
    STATE(1002), 1,
      sym_parenthesized_list_splat,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(586), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(1006), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [2787] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(538), 1,
      anon_sym_LPAREN,
    ACTIONS(568), 1,
      anon_sym_STAR,
    ACTIONS(570), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_expression,
    STATE(898), 1,
      sym_yield,
    STATE(1087), 1,
      sym__collection_elements,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(827), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [2889] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(538), 1,
      anon_sym_LPAREN,
    ACTIONS(568), 1,
      anon_sym_STAR,
    ACTIONS(614), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_expression,
    STATE(898), 1,
      sym_yield,
    STATE(905), 1,
      sym_parenthesized_list_splat,
    STATE(910), 1,
      sym_list_splat,
    STATE(1087), 1,
      sym__collection_elements,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [2993] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_await,
    ACTIONS(616), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(817), 1,
      sym_expression,
    STATE(1002), 1,
      sym_parenthesized_list_splat,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(586), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(1006), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [3093] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(538), 1,
      anon_sym_LPAREN,
    ACTIONS(568), 1,
      anon_sym_STAR,
    ACTIONS(614), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_expression,
    STATE(898), 1,
      sym_yield,
    STATE(1087), 1,
      sym__collection_elements,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(827), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [3195] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(622), 1,
      anon_sym_lambda,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(713), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(764), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(618), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(620), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [3291] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_await,
    ACTIONS(624), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(817), 1,
      sym_expression,
    STATE(1002), 1,
      sym_parenthesized_list_splat,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(586), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(1006), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [3391] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_await,
    ACTIONS(626), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(817), 1,
      sym_expression,
    STATE(1002), 1,
      sym_parenthesized_list_splat,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(586), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(1006), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [3491] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(538), 1,
      anon_sym_LPAREN,
    ACTIONS(568), 1,
      anon_sym_STAR,
    ACTIONS(628), 1,
      anon_sym_RBRACK,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(708), 1,
      sym_expression,
    STATE(1083), 1,
      sym__collection_elements,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(827), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [3591] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_await,
    ACTIONS(630), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(817), 1,
      sym_expression,
    STATE(1002), 1,
      sym_parenthesized_list_splat,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(586), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(1006), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [3691] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_await,
    ACTIONS(632), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(817), 1,
      sym_expression,
    STATE(1002), 1,
      sym_parenthesized_list_splat,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(586), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(1006), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [3791] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_await,
    ACTIONS(634), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(817), 1,
      sym_expression,
    STATE(1002), 1,
      sym_parenthesized_list_splat,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(586), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(1006), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [3891] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(538), 1,
      anon_sym_LPAREN,
    ACTIONS(568), 1,
      anon_sym_STAR,
    ACTIONS(636), 1,
      anon_sym_RBRACK,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(708), 1,
      sym_expression,
    STATE(1083), 1,
      sym__collection_elements,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(827), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [3991] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_await,
    ACTIONS(638), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(817), 1,
      sym_expression,
    STATE(1002), 1,
      sym_parenthesized_list_splat,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(586), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(1006), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [4091] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(538), 1,
      anon_sym_LPAREN,
    ACTIONS(568), 1,
      anon_sym_STAR,
    ACTIONS(636), 1,
      anon_sym_RBRACK,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(702), 1,
      sym_expression,
    STATE(1055), 1,
      sym__collection_elements,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(827), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [4191] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(538), 1,
      anon_sym_LPAREN,
    ACTIONS(568), 1,
      anon_sym_STAR,
    ACTIONS(570), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(700), 1,
      sym_expression,
    STATE(947), 1,
      sym_yield,
    STATE(1059), 1,
      sym__collection_elements,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(827), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [4293] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(538), 1,
      anon_sym_LPAREN,
    ACTIONS(568), 1,
      anon_sym_STAR,
    ACTIONS(640), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(705), 1,
      sym_expression,
    STATE(925), 1,
      sym_yield,
    STATE(1022), 1,
      sym__collection_elements,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(827), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [4395] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(538), 1,
      anon_sym_LPAREN,
    ACTIONS(568), 1,
      anon_sym_STAR,
    ACTIONS(642), 1,
      anon_sym_RBRACK,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(703), 1,
      sym_expression,
    STATE(1097), 1,
      sym__collection_elements,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(827), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [4495] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(538), 1,
      anon_sym_LPAREN,
    ACTIONS(568), 1,
      anon_sym_STAR,
    ACTIONS(570), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_expression,
    STATE(898), 1,
      sym_yield,
    STATE(905), 1,
      sym_parenthesized_list_splat,
    STATE(910), 1,
      sym_list_splat,
    STATE(1087), 1,
      sym__collection_elements,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [4599] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_await,
    ACTIONS(644), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(817), 1,
      sym_expression,
    STATE(1002), 1,
      sym_parenthesized_list_splat,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(586), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(1006), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [4699] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_await,
    ACTIONS(646), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(817), 1,
      sym_expression,
    STATE(1002), 1,
      sym_parenthesized_list_splat,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(586), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(1006), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [4799] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_await,
    ACTIONS(648), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(817), 1,
      sym_expression,
    STATE(1002), 1,
      sym_parenthesized_list_splat,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(586), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(1006), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [4899] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_await,
    ACTIONS(650), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(817), 1,
      sym_expression,
    STATE(1002), 1,
      sym_parenthesized_list_splat,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(586), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(1006), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [4999] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(622), 1,
      anon_sym_lambda,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(713), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(764), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(652), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(654), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [5095] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(622), 1,
      anon_sym_lambda,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(713), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(764), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(656), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(658), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [5191] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(622), 1,
      anon_sym_lambda,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(713), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(764), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(660), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(662), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [5287] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(664), 1,
      anon_sym_from,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(730), 1,
      sym_expression,
    STATE(885), 1,
      sym_expression_list,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(666), 4,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [5382] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(542), 1,
      anon_sym_STAR,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_await,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(817), 1,
      sym_expression,
    STATE(1002), 1,
      sym_parenthesized_list_splat,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(586), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    STATE(1006), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [5479] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(729), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(668), 5,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [5569] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(508), 1,
      anon_sym_yield,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(568), 1,
      anon_sym_STAR,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(760), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(872), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [5663] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 1,
      anon_sym_COMMA,
    ACTIONS(253), 1,
      anon_sym_EQ,
    ACTIONS(670), 1,
      anon_sym_for,
    ACTIONS(672), 1,
      anon_sym_with,
    ACTIONS(674), 1,
      anon_sym_def,
    ACTIONS(251), 14,
      anon_sym_COLON,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(240), 15,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(242), 16,
      sym__newline,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      sym__semicolon,
  [5733] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(729), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(676), 5,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [5823] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 1,
      anon_sym_COMMA,
    ACTIONS(253), 1,
      anon_sym_EQ,
    ACTIONS(678), 1,
      anon_sym_for,
    ACTIONS(680), 1,
      anon_sym_with,
    ACTIONS(682), 1,
      anon_sym_def,
    ACTIONS(251), 14,
      anon_sym_COLON,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(240), 15,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(242), 16,
      sym__newline,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      sym__semicolon,
  [5893] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      anon_sym_else,
    ACTIONS(690), 1,
      anon_sym_except,
    ACTIONS(692), 1,
      anon_sym_finally,
    STATE(344), 1,
      sym_else_clause,
    STATE(424), 1,
      sym_finally_clause,
    STATE(232), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(686), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(684), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [5962] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    ACTIONS(694), 1,
      anon_sym_from,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(761), 1,
      sym_expression,
    STATE(978), 1,
      sym_expression_list,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(666), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [6055] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_else,
    ACTIONS(698), 1,
      anon_sym_except,
    ACTIONS(700), 1,
      anon_sym_finally,
    STATE(348), 1,
      sym_else_clause,
    STATE(428), 1,
      sym_finally_clause,
    STATE(212), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(686), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(684), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [6124] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_else,
    ACTIONS(698), 1,
      anon_sym_except,
    ACTIONS(700), 1,
      anon_sym_finally,
    STATE(352), 1,
      sym_else_clause,
    STATE(411), 1,
      sym_finally_clause,
    STATE(212), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(702), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(704), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [6193] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(706), 1,
      anon_sym_RBRACE,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(853), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(1004), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [6286] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(708), 1,
      anon_sym_RBRACE,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(853), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(1004), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [6379] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 1,
      anon_sym_COMMA,
    ACTIONS(253), 1,
      anon_sym_EQ,
    ACTIONS(710), 1,
      sym__string_start,
    STATE(965), 1,
      sym_string,
    ACTIONS(251), 14,
      anon_sym_COLON,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(240), 15,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(242), 16,
      sym__newline,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      sym__semicolon,
  [6446] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_from,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(733), 1,
      sym_expression,
    STATE(966), 1,
      sym_expression_list,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(714), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [6539] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(716), 1,
      anon_sym_RBRACE,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(853), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(1004), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [6632] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      anon_sym_else,
    ACTIONS(690), 1,
      anon_sym_except,
    ACTIONS(692), 1,
      anon_sym_finally,
    STATE(341), 1,
      sym_else_clause,
    STATE(370), 1,
      sym_finally_clause,
    STATE(232), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(702), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(704), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [6701] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(718), 1,
      anon_sym_RBRACE,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(853), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(1004), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [6794] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(720), 1,
      anon_sym_RBRACE,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(853), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(1004), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [6887] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    ACTIONS(722), 1,
      anon_sym_RBRACE,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(853), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(1004), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [6980] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(578), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(576), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [7036] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(724), 1,
      anon_sym_COLON,
    ACTIONS(726), 1,
      anon_sym_RBRACK,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(788), 1,
      sym_expression,
    STATE(1001), 1,
      sym_slice,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [7128] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(574), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(572), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [7184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(608), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(606), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [7240] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(724), 1,
      anon_sym_COLON,
    ACTIONS(728), 1,
      anon_sym_RBRACK,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(788), 1,
      sym_expression,
    STATE(1001), 1,
      sym_slice,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [7332] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(724), 1,
      anon_sym_COLON,
    ACTIONS(730), 1,
      anon_sym_RBRACK,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(788), 1,
      sym_expression,
    STATE(1001), 1,
      sym_slice,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [7424] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(560), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [7480] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(734), 1,
      anon_sym_COLON,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(789), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(732), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [7570] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(724), 1,
      anon_sym_COLON,
    ACTIONS(736), 1,
      anon_sym_RBRACK,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(788), 1,
      sym_expression,
    STATE(1001), 1,
      sym_slice,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [7662] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(724), 1,
      anon_sym_COLON,
    ACTIONS(738), 1,
      anon_sym_RBRACK,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(788), 1,
      sym_expression,
    STATE(1001), 1,
      sym_slice,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [7754] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(742), 1,
      anon_sym_COLON,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(795), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(740), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [7844] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(578), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(576), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [7900] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(724), 1,
      anon_sym_COLON,
    ACTIONS(744), 1,
      anon_sym_RBRACK,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(788), 1,
      sym_expression,
    STATE(1001), 1,
      sym_slice,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [7992] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(604), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(602), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [8048] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(724), 1,
      anon_sym_COLON,
    ACTIONS(746), 1,
      anon_sym_RBRACK,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(788), 1,
      sym_expression,
    STATE(1001), 1,
      sym_slice,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [8140] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(724), 1,
      anon_sym_COLON,
    ACTIONS(748), 1,
      anon_sym_RBRACK,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(788), 1,
      sym_expression,
    STATE(1001), 1,
      sym_slice,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [8232] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(724), 1,
      anon_sym_COLON,
    ACTIONS(750), 1,
      anon_sym_RBRACK,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(788), 1,
      sym_expression,
    STATE(1001), 1,
      sym_slice,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [8324] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    ACTIONS(752), 1,
      anon_sym_from,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(755), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(668), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [8414] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    ACTIONS(754), 1,
      anon_sym_from,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(755), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(676), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [8504] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(737), 1,
      sym_expression,
    STATE(1003), 1,
      sym_expression_list,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(756), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [8594] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(574), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(572), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [8650] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(760), 1,
      anon_sym_COMMA,
    ACTIONS(765), 1,
      anon_sym_COLON_EQ,
    ACTIONS(767), 2,
      anon_sym_COLON,
      anon_sym_EQ,
    ACTIONS(769), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(763), 15,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(758), 16,
      sym__newline,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      sym__semicolon,
  [8714] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(544), 1,
      anon_sym_STAR_STAR,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(853), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(1004), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [8804] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(724), 1,
      anon_sym_COLON,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(741), 1,
      sym_expression,
    STATE(939), 1,
      sym_slice,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [8893] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_else,
    ACTIONS(775), 1,
      anon_sym_elif,
    STATE(253), 1,
      aux_sym_if_statement_repeat1,
    STATE(349), 1,
      sym_elif_clause,
    STATE(376), 1,
      sym_else_clause,
    ACTIONS(771), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(773), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [8958] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(829), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(732), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [9045] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      anon_sym_else,
    ACTIONS(781), 1,
      anon_sym_elif,
    STATE(207), 1,
      aux_sym_if_statement_repeat1,
    STATE(353), 1,
      sym_elif_clause,
    STATE(406), 1,
      sym_else_clause,
    ACTIONS(779), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(777), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [9110] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(803), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(783), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [9197] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(755), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(785), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [9284] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(803), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(787), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [9371] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(622), 1,
      anon_sym_lambda,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(713), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(731), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [9458] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_else,
    ACTIONS(775), 1,
      anon_sym_elif,
    STATE(221), 1,
      aux_sym_if_statement_repeat1,
    STATE(349), 1,
      sym_elif_clause,
    STATE(426), 1,
      sym_else_clause,
    ACTIONS(779), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(777), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [9523] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      anon_sym_else,
    ACTIONS(781), 1,
      anon_sym_elif,
    STATE(240), 1,
      aux_sym_if_statement_repeat1,
    STATE(353), 1,
      sym_elif_clause,
    STATE(397), 1,
      sym_else_clause,
    ACTIONS(791), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(789), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [9588] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      anon_sym_else,
    ACTIONS(781), 1,
      anon_sym_elif,
    STATE(229), 1,
      aux_sym_if_statement_repeat1,
    STATE(353), 1,
      sym_elif_clause,
    STATE(384), 1,
      sym_else_clause,
    ACTIONS(795), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(793), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [9653] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(622), 1,
      anon_sym_lambda,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(711), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(769), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [9740] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(760), 1,
      anon_sym_COMMA,
    ACTIONS(767), 1,
      anon_sym_EQ,
    ACTIONS(769), 14,
      anon_sym_COLON,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(763), 15,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(758), 16,
      sym__newline,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      sym__semicolon,
  [9801] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(803), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(797), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [9888] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 1,
      anon_sym_except,
    STATE(212), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(799), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(801), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [9947] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(803), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(806), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [10034] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 1,
      anon_sym_COMMA,
    ACTIONS(817), 1,
      anon_sym_EQ,
    ACTIONS(815), 14,
      anon_sym_COLON,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(813), 15,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(808), 16,
      sym__newline,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      sym__semicolon,
  [10095] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(828), 1,
      anon_sym_EQ,
    ACTIONS(826), 14,
      anon_sym_COLON,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(824), 15,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(819), 16,
      sym__newline,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      sym__semicolon,
  [10156] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(755), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(830), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [10243] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(475), 1,
      anon_sym_LBRACK,
    ACTIONS(477), 1,
      anon_sym_not,
    ACTIONS(481), 1,
      anon_sym_lambda,
    ACTIONS(485), 1,
      anon_sym_LBRACE,
    ACTIONS(489), 1,
      anon_sym_await,
    ACTIONS(491), 1,
      sym__string_start,
    ACTIONS(832), 1,
      anon_sym_LPAREN,
    STATE(504), 1,
      sym_primary_expression,
    STATE(506), 1,
      sym_string,
    STATE(749), 1,
      sym_expression,
    STATE(887), 1,
      sym_with_item,
    STATE(1104), 1,
      sym_with_clause,
    ACTIONS(483), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(479), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(487), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(763), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(640), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [10332] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(811), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(834), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [10419] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_else,
    ACTIONS(775), 1,
      anon_sym_elif,
    STATE(199), 1,
      aux_sym_if_statement_repeat1,
    STATE(349), 1,
      sym_elif_clause,
    STATE(387), 1,
      sym_else_clause,
    ACTIONS(795), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(793), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [10484] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(475), 1,
      anon_sym_LBRACK,
    ACTIONS(477), 1,
      anon_sym_not,
    ACTIONS(481), 1,
      anon_sym_lambda,
    ACTIONS(485), 1,
      anon_sym_LBRACE,
    ACTIONS(489), 1,
      anon_sym_await,
    ACTIONS(491), 1,
      sym__string_start,
    ACTIONS(832), 1,
      anon_sym_LPAREN,
    STATE(504), 1,
      sym_primary_expression,
    STATE(506), 1,
      sym_string,
    STATE(749), 1,
      sym_expression,
    STATE(887), 1,
      sym_with_item,
    STATE(1056), 1,
      sym_with_clause,
    ACTIONS(483), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(479), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(487), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(763), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(640), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [10573] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_else,
    ACTIONS(775), 1,
      anon_sym_elif,
    STATE(253), 1,
      aux_sym_if_statement_repeat1,
    STATE(349), 1,
      sym_elif_clause,
    STATE(398), 1,
      sym_else_clause,
    ACTIONS(791), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(789), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [10638] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 1,
      anon_sym_COMMA,
    ACTIONS(253), 1,
      anon_sym_EQ,
    ACTIONS(251), 14,
      anon_sym_COLON,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(240), 15,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(242), 16,
      sym__newline,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      sym__semicolon,
  [10699] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(475), 1,
      anon_sym_LBRACK,
    ACTIONS(477), 1,
      anon_sym_not,
    ACTIONS(481), 1,
      anon_sym_lambda,
    ACTIONS(485), 1,
      anon_sym_LBRACE,
    ACTIONS(489), 1,
      anon_sym_await,
    ACTIONS(491), 1,
      sym__string_start,
    ACTIONS(832), 1,
      anon_sym_LPAREN,
    STATE(504), 1,
      sym_primary_expression,
    STATE(506), 1,
      sym_string,
    STATE(749), 1,
      sym_expression,
    STATE(887), 1,
      sym_with_item,
    STATE(1062), 1,
      sym_with_clause,
    ACTIONS(483), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(479), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(487), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(763), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(640), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [10788] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(724), 1,
      anon_sym_COLON,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(752), 1,
      sym_expression,
    STATE(928), 1,
      sym_slice,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [10877] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(622), 1,
      anon_sym_lambda,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(710), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(736), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [10964] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(724), 1,
      anon_sym_COLON,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(773), 1,
      sym_expression,
    STATE(950), 1,
      sym_slice,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [11053] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(475), 1,
      anon_sym_LBRACK,
    ACTIONS(477), 1,
      anon_sym_not,
    ACTIONS(481), 1,
      anon_sym_lambda,
    ACTIONS(485), 1,
      anon_sym_LBRACE,
    ACTIONS(489), 1,
      anon_sym_await,
    ACTIONS(491), 1,
      sym__string_start,
    ACTIONS(832), 1,
      anon_sym_LPAREN,
    STATE(504), 1,
      sym_primary_expression,
    STATE(506), 1,
      sym_string,
    STATE(749), 1,
      sym_expression,
    STATE(887), 1,
      sym_with_item,
    STATE(1084), 1,
      sym_with_clause,
    ACTIONS(483), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(479), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(487), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(763), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(640), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [11142] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(724), 1,
      anon_sym_COLON,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(788), 1,
      sym_expression,
    STATE(1001), 1,
      sym_slice,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [11231] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      anon_sym_else,
    ACTIONS(781), 1,
      anon_sym_elif,
    STATE(240), 1,
      aux_sym_if_statement_repeat1,
    STATE(353), 1,
      sym_elif_clause,
    STATE(378), 1,
      sym_else_clause,
    ACTIONS(771), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(773), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [11296] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(812), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(836), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [11383] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(622), 1,
      anon_sym_lambda,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(713), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(764), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [11470] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(838), 1,
      anon_sym_except,
    STATE(232), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(799), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(801), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [11529] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(467), 1,
      anon_sym_await,
    ACTIONS(622), 1,
      anon_sym_lambda,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(713), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(716), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [11616] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(843), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [11670] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(753), 1,
      sym_expression,
    STATE(1047), 1,
      sym_type,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [11756] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(845), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(847), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [11810] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(851), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(849), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [11864] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(753), 1,
      sym_expression,
    STATE(1075), 1,
      sym_type,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [11950] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(800), 1,
      sym_expression,
    STATE(1072), 1,
      sym_expression_list,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [12036] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(857), 1,
      anon_sym_elif,
    STATE(240), 1,
      aux_sym_if_statement_repeat1,
    STATE(353), 1,
      sym_elif_clause,
    ACTIONS(855), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(853), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [12096] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(843), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [12150] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(753), 1,
      sym_expression,
    STATE(1077), 1,
      sym_type,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [12236] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(794), 1,
      sym_expression,
    STATE(1067), 1,
      sym_expression_list,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [12322] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(753), 1,
      sym_expression,
    STATE(856), 1,
      sym_type,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [12408] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      anon_sym_LPAREN,
    ACTIONS(475), 1,
      anon_sym_LBRACK,
    ACTIONS(477), 1,
      anon_sym_not,
    ACTIONS(481), 1,
      anon_sym_lambda,
    ACTIONS(485), 1,
      anon_sym_LBRACE,
    ACTIONS(489), 1,
      anon_sym_await,
    ACTIONS(491), 1,
      sym__string_start,
    STATE(504), 1,
      sym_primary_expression,
    STATE(506), 1,
      sym_string,
    STATE(749), 1,
      sym_expression,
    STATE(888), 1,
      sym_with_item,
    ACTIONS(483), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(479), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(487), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(763), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(640), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [12494] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(780), 1,
      sym_expression,
    STATE(1107), 1,
      sym_expression_list,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [12580] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(860), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [12634] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(860), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [12688] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(753), 1,
      sym_expression,
    STATE(948), 1,
      sym_type,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [12774] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(845), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(847), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [12828] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(864), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [12882] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(753), 1,
      sym_expression,
    STATE(1078), 1,
      sym_type,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [12968] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(868), 1,
      anon_sym_elif,
    STATE(253), 1,
      aux_sym_if_statement_repeat1,
    STATE(349), 1,
      sym_elif_clause,
    ACTIONS(855), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(853), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [13028] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(744), 1,
      sym_expression,
    STATE(997), 1,
      sym_expression_list,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [13114] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      anon_sym_LPAREN,
    ACTIONS(475), 1,
      anon_sym_LBRACK,
    ACTIONS(477), 1,
      anon_sym_not,
    ACTIONS(481), 1,
      anon_sym_lambda,
    ACTIONS(485), 1,
      anon_sym_LBRACE,
    ACTIONS(489), 1,
      anon_sym_await,
    ACTIONS(491), 1,
      sym__string_start,
    ACTIONS(871), 1,
      anon_sym_COLON,
    STATE(504), 1,
      sym_primary_expression,
    STATE(506), 1,
      sym_string,
    STATE(804), 1,
      sym_expression,
    ACTIONS(483), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(479), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(487), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(763), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(640), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [13200] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(793), 1,
      sym_expression,
    STATE(938), 1,
      sym_type,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [13286] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      anon_sym_LPAREN,
    ACTIONS(475), 1,
      anon_sym_LBRACK,
    ACTIONS(477), 1,
      anon_sym_not,
    ACTIONS(481), 1,
      anon_sym_lambda,
    ACTIONS(485), 1,
      anon_sym_LBRACE,
    ACTIONS(489), 1,
      anon_sym_await,
    ACTIONS(491), 1,
      sym__string_start,
    ACTIONS(873), 1,
      anon_sym_COLON,
    STATE(504), 1,
      sym_primary_expression,
    STATE(506), 1,
      sym_string,
    STATE(785), 1,
      sym_expression,
    ACTIONS(483), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(479), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(487), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(763), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(640), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [13372] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(864), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [13426] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(786), 1,
      sym_expression,
    STATE(1043), 1,
      sym_expression_list,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [13512] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(851), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(849), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [13566] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(690), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [13649] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(870), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [13732] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(725), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [13815] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(756), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [13898] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(688), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [13981] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(865), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [14064] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(864), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [14147] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(694), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [14230] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(877), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [14283] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(862), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [14366] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(866), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [14449] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(696), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [14532] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(879), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [14585] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(724), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [14668] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(759), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [14751] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(670), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [14834] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(842), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [14917] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(734), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [15000] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(699), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [15083] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(796), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [15166] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(684), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [15249] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(841), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [15332] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(843), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [15415] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(784), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [15498] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(883), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(885), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [15551] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      anon_sym_LPAREN,
    ACTIONS(475), 1,
      anon_sym_LBRACK,
    ACTIONS(477), 1,
      anon_sym_not,
    ACTIONS(481), 1,
      anon_sym_lambda,
    ACTIONS(485), 1,
      anon_sym_LBRACE,
    ACTIONS(489), 1,
      anon_sym_await,
    ACTIONS(491), 1,
      sym__string_start,
    STATE(504), 1,
      sym_primary_expression,
    STATE(506), 1,
      sym_string,
    STATE(762), 1,
      sym_expression,
    ACTIONS(483), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(479), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(487), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(763), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(640), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [15634] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      anon_sym_LPAREN,
    ACTIONS(475), 1,
      anon_sym_LBRACK,
    ACTIONS(477), 1,
      anon_sym_not,
    ACTIONS(481), 1,
      anon_sym_lambda,
    ACTIONS(485), 1,
      anon_sym_LBRACE,
    ACTIONS(489), 1,
      anon_sym_await,
    ACTIONS(491), 1,
      sym__string_start,
    STATE(504), 1,
      sym_primary_expression,
    STATE(506), 1,
      sym_string,
    STATE(771), 1,
      sym_expression,
    ACTIONS(483), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(479), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(487), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(763), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(640), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [15717] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(851), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [15800] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      anon_sym_LPAREN,
    ACTIONS(475), 1,
      anon_sym_LBRACK,
    ACTIONS(477), 1,
      anon_sym_not,
    ACTIONS(481), 1,
      anon_sym_lambda,
    ACTIONS(485), 1,
      anon_sym_LBRACE,
    ACTIONS(489), 1,
      anon_sym_await,
    ACTIONS(491), 1,
      sym__string_start,
    STATE(504), 1,
      sym_primary_expression,
    STATE(506), 1,
      sym_string,
    STATE(740), 1,
      sym_expression,
    ACTIONS(483), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(479), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(487), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(763), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(640), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [15883] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(887), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(889), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [15936] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      anon_sym_LPAREN,
    ACTIONS(475), 1,
      anon_sym_LBRACK,
    ACTIONS(477), 1,
      anon_sym_not,
    ACTIONS(481), 1,
      anon_sym_lambda,
    ACTIONS(485), 1,
      anon_sym_LBRACE,
    ACTIONS(489), 1,
      anon_sym_await,
    ACTIONS(491), 1,
      sym__string_start,
    STATE(504), 1,
      sym_primary_expression,
    STATE(506), 1,
      sym_string,
    STATE(774), 1,
      sym_expression,
    ACTIONS(483), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(479), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(487), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(763), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(640), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [16019] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(849), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [16102] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(742), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [16185] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(757), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [16268] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(698), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [16351] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(720), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [16434] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(775), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [16517] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(891), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(893), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [16570] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(685), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [16653] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      anon_sym_LPAREN,
    ACTIONS(475), 1,
      anon_sym_LBRACK,
    ACTIONS(477), 1,
      anon_sym_not,
    ACTIONS(481), 1,
      anon_sym_lambda,
    ACTIONS(485), 1,
      anon_sym_LBRACE,
    ACTIONS(489), 1,
      anon_sym_await,
    ACTIONS(491), 1,
      sym__string_start,
    STATE(504), 1,
      sym_primary_expression,
    STATE(506), 1,
      sym_string,
    STATE(779), 1,
      sym_expression,
    ACTIONS(483), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(479), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(487), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(763), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(640), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [16736] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(670), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [16819] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      anon_sym_LPAREN,
    ACTIONS(475), 1,
      anon_sym_LBRACK,
    ACTIONS(477), 1,
      anon_sym_not,
    ACTIONS(481), 1,
      anon_sym_lambda,
    ACTIONS(485), 1,
      anon_sym_LBRACE,
    ACTIONS(489), 1,
      anon_sym_await,
    ACTIONS(491), 1,
      sym__string_start,
    STATE(504), 1,
      sym_primary_expression,
    STATE(506), 1,
      sym_string,
    STATE(768), 1,
      sym_expression,
    ACTIONS(483), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(479), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(487), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(763), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(640), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [16902] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(682), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [16985] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(697), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [17068] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(895), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(897), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [17121] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(867), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [17204] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(728), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [17287] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(891), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(893), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [17340] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(899), 1,
      sym_identifier,
    ACTIONS(903), 1,
      anon_sym_await,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(746), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(647), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(901), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [17425] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(782), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [17508] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(879), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [17561] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(717), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [17644] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(895), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(897), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [17697] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(834), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [17780] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(835), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [17863] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(887), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(889), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [17916] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(883), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(885), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [17969] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(755), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [18052] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(863), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [18135] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(729), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [18218] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(803), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [18301] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(877), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [18354] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      anon_sym_LPAREN,
    ACTIONS(475), 1,
      anon_sym_LBRACK,
    ACTIONS(477), 1,
      anon_sym_not,
    ACTIONS(481), 1,
      anon_sym_lambda,
    ACTIONS(485), 1,
      anon_sym_LBRACE,
    ACTIONS(489), 1,
      anon_sym_await,
    ACTIONS(491), 1,
      sym__string_start,
    STATE(504), 1,
      sym_primary_expression,
    STATE(506), 1,
      sym_string,
    STATE(777), 1,
      sym_expression,
    ACTIONS(483), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(479), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(487), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(763), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(640), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [18437] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(691), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [18520] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(826), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [18603] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(847), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [18686] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(719), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [18769] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(810), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [18852] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(832), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [18935] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(718), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [19018] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(746), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [19101] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(255), 1,
      anon_sym_await,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    STATE(498), 1,
      sym_string,
    STATE(500), 1,
      sym_primary_expression,
    STATE(820), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(247), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(605), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [19184] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(453), 1,
      sym_identifier,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_LBRACK,
    ACTIONS(461), 1,
      anon_sym_not,
    ACTIONS(465), 1,
      anon_sym_lambda,
    ACTIONS(467), 1,
      anon_sym_await,
    STATE(361), 1,
      sym_string,
    STATE(447), 1,
      sym_primary_expression,
    STATE(687), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(457), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(463), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [19267] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_LBRACK,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_await,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(361), 1,
      sym_string,
    STATE(448), 1,
      sym_primary_expression,
    STATE(787), 1,
      sym_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(433), 3,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(672), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(454), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [19350] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(905), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(907), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [19402] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      anon_sym_else,
    STATE(392), 1,
      sym_else_clause,
    ACTIONS(911), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(909), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [19458] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      anon_sym_else,
    STATE(425), 1,
      sym_else_clause,
    ACTIONS(915), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(913), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [19514] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(905), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(907), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [19566] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_else,
    STATE(432), 1,
      sym_else_clause,
    ACTIONS(917), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(919), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [19622] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(921), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(923), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [19674] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(692), 1,
      anon_sym_finally,
    STATE(396), 1,
      sym_finally_clause,
    ACTIONS(927), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(925), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [19730] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      anon_sym_else,
    STATE(429), 1,
      sym_else_clause,
    ACTIONS(931), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(929), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [19786] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_else,
    STATE(383), 1,
      sym_else_clause,
    ACTIONS(911), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(909), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [19842] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(692), 1,
      anon_sym_finally,
    STATE(374), 1,
      sym_finally_clause,
    ACTIONS(935), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(933), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [19898] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_else,
    STATE(436), 1,
      sym_else_clause,
    ACTIONS(931), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(929), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [19954] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      anon_sym_else,
    STATE(377), 1,
      sym_else_clause,
    ACTIONS(917), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(919), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [20010] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_else,
    STATE(385), 1,
      sym_else_clause,
    ACTIONS(915), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(913), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [20066] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_finally,
    STATE(417), 1,
      sym_finally_clause,
    ACTIONS(935), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(933), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [20122] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(937), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(939), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [20174] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_else,
    STATE(394), 1,
      sym_else_clause,
    ACTIONS(941), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(943), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [20230] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      anon_sym_else,
    STATE(422), 1,
      sym_else_clause,
    ACTIONS(947), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(945), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [20286] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_finally,
    STATE(435), 1,
      sym_finally_clause,
    ACTIONS(927), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(925), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [20342] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(937), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(939), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [20394] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_else,
    STATE(366), 1,
      sym_else_clause,
    ACTIONS(947), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(945), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [20450] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      anon_sym_else,
    STATE(402), 1,
      sym_else_clause,
    ACTIONS(941), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(943), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [20506] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(921), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(923), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [20558] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(951), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(949), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [20609] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(953), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(955), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [20660] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(953), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(955), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [20711] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(363), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(959), 6,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(957), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [20766] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      sym__string_start,
    STATE(360), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(763), 6,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(758), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [20821] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(951), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(949), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [20872] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(965), 1,
      sym__string_start,
    STATE(363), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(963), 6,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(961), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [20927] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(970), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(968), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [20977] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(972), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21027] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(978), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21077] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(684), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21127] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(982), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(980), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21177] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(986), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(984), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21227] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(927), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(925), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21277] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(990), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21327] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(994), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21377] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(998), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21427] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1002), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1000), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21477] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1006), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21527] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1010), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21577] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1012), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21627] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1010), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21677] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1018), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1016), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21727] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1022), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21777] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(998), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1026), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1024), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21877] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1030), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21927] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1034), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1032), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [21977] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1038), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22027] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(972), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22077] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1034), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1032), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22127] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1026), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1024), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22177] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1006), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22227] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1042), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22277] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(990), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22327] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1030), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22377] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(684), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22427] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1046), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22477] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1050), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1048), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22527] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1054), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1052), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22577] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1058), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1056), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22627] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1058), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1056), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22677] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1060), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1062), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22727] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1066), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1064), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22777] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1068), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1070), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1046), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22877] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(982), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(980), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22927] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1018), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1016), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [22977] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(534), 1,
      anon_sym_LBRACK,
    ACTIONS(1072), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_string,
    STATE(664), 1,
      sym_primary_expression,
    STATE(848), 1,
      sym_pattern,
    STATE(1034), 1,
      sym__patterns,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    STATE(565), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(655), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(528), 4,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
    STATE(454), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [23059] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1074), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [23109] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1078), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1080), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [23159] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(986), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(984), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [23209] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1042), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [23259] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1082), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1084), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [23309] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(927), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(925), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [23359] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1060), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1062), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [23409] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1068), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1070), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [23459] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1078), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1080), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [23509] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1082), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1084), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [23559] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1088), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1086), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [23609] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1002), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1000), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [23659] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(704), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [23709] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(970), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(968), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [23759] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(704), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [23809] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(534), 1,
      anon_sym_LBRACK,
    STATE(361), 1,
      sym_string,
    STATE(661), 1,
      sym_pattern,
    STATE(664), 1,
      sym_primary_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(1090), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    STATE(565), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(655), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(528), 4,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
    STATE(454), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [23889] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(978), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [23939] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1022), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [23989] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(933), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [24039] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1038), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [24089] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1074), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [24139] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(445), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      sym__string_start,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(534), 1,
      anon_sym_LBRACK,
    STATE(361), 1,
      sym_string,
    STATE(661), 1,
      sym_pattern,
    STATE(664), 1,
      sym_primary_expression,
    ACTIONS(443), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(1092), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    STATE(565), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(655), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(447), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(528), 4,
      anon_sym_print,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
    STATE(454), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
  [24219] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(933), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [24269] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1096), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1094), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      anon_sym_await,
      sym_true,
      sym_false,
      sym_none,
  [24319] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1066), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1064), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_re