#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1080
#define LARGE_STATE_COUNT 274
#define SYMBOL_COUNT 287
#define ALIAS_COUNT 1
#define TOKEN_COUNT 127
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 36
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 200

enum {
  sym_identifier = 1,
  sym_decimal_integer_literal = 2,
  sym_hex_integer_literal = 3,
  sym_octal_integer_literal = 4,
  sym_binary_integer_literal = 5,
  sym_decimal_floating_point_literal = 6,
  sym_hex_floating_point_literal = 7,
  sym_true = 8,
  sym_false = 9,
  sym_character_literal = 10,
  sym_string_literal = 11,
  sym_text_block = 12,
  sym_null_literal = 13,
  anon_sym_LPAREN = 14,
  anon_sym_AMP = 15,
  anon_sym_RPAREN = 16,
  anon_sym_EQ = 17,
  anon_sym_PLUS_EQ = 18,
  anon_sym_DASH_EQ = 19,
  anon_sym_STAR_EQ = 20,
  anon_sym_SLASH_EQ = 21,
  anon_sym_AMP_EQ = 22,
  anon_sym_PIPE_EQ = 23,
  anon_sym_CARET_EQ = 24,
  anon_sym_PERCENT_EQ = 25,
  anon_sym_LT_LT_EQ = 26,
  anon_sym_GT_GT_EQ = 27,
  anon_sym_GT_GT_GT_EQ = 28,
  anon_sym_GT = 29,
  anon_sym_LT = 30,
  anon_sym_GT_EQ = 31,
  anon_sym_LT_EQ = 32,
  anon_sym_EQ_EQ = 33,
  anon_sym_BANG_EQ = 34,
  anon_sym_AMP_AMP = 35,
  anon_sym_PIPE_PIPE = 36,
  anon_sym_PLUS = 37,
  anon_sym_DASH = 38,
  anon_sym_STAR = 39,
  anon_sym_SLASH = 40,
  anon_sym_PIPE = 41,
  anon_sym_CARET = 42,
  anon_sym_PERCENT = 43,
  anon_sym_LT_LT = 44,
  anon_sym_GT_GT = 45,
  anon_sym_GT_GT_GT = 46,
  anon_sym_instanceof = 47,
  anon_sym_DASH_GT = 48,
  anon_sym_COMMA = 49,
  anon_sym_QMARK = 50,
  anon_sym_COLON = 51,
  anon_sym_BANG = 52,
  anon_sym_TILDE = 53,
  anon_sym_PLUS_PLUS = 54,
  anon_sym_DASH_DASH = 55,
  anon_sym_new = 56,
  anon_sym_LBRACK = 57,
  anon_sym_RBRACK = 58,
  anon_sym_DOT = 59,
  anon_sym_class = 60,
  anon_sym_COLON_COLON = 61,
  anon_sym_extends = 62,
  anon_sym_switch = 63,
  anon_sym_LBRACE = 64,
  anon_sym_RBRACE = 65,
  anon_sym_case = 66,
  anon_sym_default = 67,
  anon_sym_SEMI = 68,
  anon_sym_assert = 69,
  anon_sym_do = 70,
  anon_sym_while = 71,
  anon_sym_break = 72,
  anon_sym_continue = 73,
  anon_sym_return = 74,
  anon_sym_yield = 75,
  anon_sym_synchronized = 76,
  anon_sym_throw = 77,
  anon_sym_try = 78,
  anon_sym_catch = 79,
  anon_sym_finally = 80,
  anon_sym_if = 81,
  anon_sym_else = 82,
  anon_sym_for = 83,
  anon_sym_AT = 84,
  anon_sym_open = 85,
  anon_sym_module = 86,
  anon_sym_requires = 87,
  anon_sym_transitive = 88,
  anon_sym_static = 89,
  anon_sym_exports = 90,
  anon_sym_to = 91,
  anon_sym_opens = 92,
  anon_sym_uses = 93,
  anon_sym_provides = 94,
  anon_sym_with = 95,
  anon_sym_package = 96,
  anon_sym_import = 97,
  anon_sym_enum = 98,
  anon_sym_public = 99,
  anon_sym_protected = 100,
  anon_sym_private = 101,
  anon_sym_abstract = 102,
  anon_sym_final = 103,
  anon_sym_strictfp = 104,
  anon_sym_native = 105,
  anon_sym_transient = 106,
  anon_sym_volatile = 107,
  anon_sym_implements = 108,
  anon_sym_record = 109,
  anon_sym_ATinterface = 110,
  anon_sym_interface = 111,
  anon_sym_byte = 112,
  anon_sym_short = 113,
  anon_sym_int = 114,
  anon_sym_long = 115,
  anon_sym_char = 116,
  anon_sym_float = 117,
  anon_sym_double = 118,
  sym_boolean_type = 119,
  sym_void_type = 120,
  anon_sym_DOT_DOT_DOT = 121,
  anon_sym_throws = 122,
  sym_this = 123,
  sym_super = 124,
  sym_line_comment = 125,
  sym_block_comment = 126,
  sym_program = 127,
  sym__literal = 128,
  sym_expression = 129,
  sym_cast_expression = 130,
  sym_assignment_expression = 131,
  sym_binary_expression = 132,
  sym_instanceof_expression = 133,
  sym_lambda_expression = 134,
  sym_inferred_parameters = 135,
  sym_ternary_expression = 136,
  sym_unary_expression = 137,
  sym_update_expression = 138,
  sym_primary_expression = 139,
  sym_array_creation_expression = 140,
  sym_dimensions_expr = 141,
  sym_parenthesized_expression = 142,
  sym_class_literal = 143,
  sym_object_creation_expression = 144,
  sym__unqualified_object_creation_expression = 145,
  sym_field_access = 146,
  sym_array_access = 147,
  sym_method_invocation = 148,
  sym_argument_list = 149,
  sym_method_reference = 150,
  sym_type_arguments = 151,
  sym_wildcard = 152,
  sym__wildcard_bounds = 153,
  sym_dimensions = 154,
  sym_switch_expression = 155,
  sym_switch_block = 156,
  sym_switch_block_statement_group = 157,
  sym_switch_rule = 158,
  sym_switch_label = 159,
  sym_statement = 160,
  sym_block = 161,
  sym_expression_statement = 162,
  sym_labeled_statement = 163,
  sym_assert_statement = 164,
  sym_do_statement = 165,
  sym_break_statement = 166,
  sym_continue_statement = 167,
  sym_return_statement = 168,
  sym_yield_statement = 169,
  sym_synchronized_statement = 170,
  sym_throw_statement = 171,
  sym_try_statement = 172,
  sym_catch_clause = 173,
  sym_catch_formal_parameter = 174,
  sym_catch_type = 175,
  sym_finally_clause = 176,
  sym_try_with_resources_statement = 177,
  sym_resource_specification = 178,
  sym_resource = 179,
  sym_if_statement = 180,
  sym_while_statement = 181,
  sym_for_statement = 182,
  sym_enhanced_for_statement = 183,
  sym__annotation = 184,
  sym_marker_annotation = 185,
  sym_annotation = 186,
  sym_annotation_argument_list = 187,
  sym_element_value_pair = 188,
  sym__element_value = 189,
  sym_element_value_array_initializer = 190,
  sym_declaration = 191,
  sym_module_declaration = 192,
  sym_module_body = 193,
  sym_module_directive = 194,
  sym_requires_module_directive = 195,
  sym_requires_modifier = 196,
  sym_exports_module_directive = 197,
  sym_opens_module_directive = 198,
  sym_uses_module_directive = 199,
  sym_provides_module_directive = 200,
  sym_package_declaration = 201,
  sym_import_declaration = 202,
  sym_asterisk = 203,
  sym_enum_declaration = 204,
  sym_enum_body = 205,
  sym_enum_body_declarations = 206,
  sym_enum_constant = 207,
  sym_class_declaration = 208,
  sym_modifiers = 209,
  sym_type_parameters = 210,
  sym_type_parameter = 211,
  sym_type_bound = 212,
  sym_superclass = 213,
  sym_super_interfaces = 214,
  sym_interface_type_list = 215,
  sym_class_body = 216,
  sym_static_initializer = 217,
  sym_constructor_declaration = 218,
  sym__constructor_declarator = 219,
  sym_constructor_body = 220,
  sym_explicit_constructor_invocation = 221,
  sym_scoped_identifier = 222,
  sym_field_declaration = 223,
  sym_record_declaration = 224,
  sym_annotation_type_declaration = 225,
  sym_annotation_type_body = 226,
  sym_annotation_type_element_declaration = 227,
  sym__default_value = 228,
  sym_interface_declaration = 229,
  sym_extends_interfaces = 230,
  sym_interface_body = 231,
  sym_constant_declaration = 232,
  sym__variable_declarator_list = 233,
  sym_variable_declarator = 234,
  sym__variable_declarator_id = 235,
  sym_array_initializer = 236,
  sym__type = 237,
  sym__unannotated_type = 238,
  sym_annotated_type = 239,
  sym_scoped_type_identifier = 240,
  sym_generic_type = 241,
  sym_array_type = 242,
  sym_integral_type = 243,
  sym_floating_point_type = 244,
  sym__method_header = 245,
  sym__method_declarator = 246,
  sym_formal_parameters = 247,
  sym_formal_parameter = 248,
  sym_receiver_parameter = 249,
  sym_spread_parameter = 250,
  sym_throws = 251,
  sym_local_variable_declaration = 252,
  sym_method_declaration = 253,
  aux_sym_program_repeat1 = 254,
  aux_sym_cast_expression_repeat1 = 255,
  aux_sym_inferred_parameters_repeat1 = 256,
  aux_sym_array_creation_expression_repeat1 = 257,
  aux_sym_dimensions_expr_repeat1 = 258,
  aux_sym_argument_list_repeat1 = 259,
  aux_sym_type_arguments_repeat1 = 260,
  aux_sym_dimensions_repeat1 = 261,
  aux_sym_switch_block_repeat1 = 262,
  aux_sym_switch_block_repeat2 = 263,
  aux_sym_switch_block_statement_group_repeat1 = 264,
  aux_sym_try_statement_repeat1 = 265,
  aux_sym_catch_type_repeat1 = 266,
  aux_sym_resource_specification_repeat1 = 267,
  aux_sym_for_statement_repeat1 = 268,
  aux_sym_for_statement_repeat2 = 269,
  aux_sym_annotation_argument_list_repeat1 = 270,
  aux_sym_element_value_array_initializer_repeat1 = 271,
  aux_sym_module_body_repeat1 = 272,
  aux_sym_requires_module_directive_repeat1 = 273,
  aux_sym_exports_module_directive_repeat1 = 274,
  aux_sym_provides_module_directive_repeat1 = 275,
  aux_sym_enum_body_repeat1 = 276,
  aux_sym_enum_body_declarations_repeat1 = 277,
  aux_sym_modifiers_repeat1 = 278,
  aux_sym_type_parameters_repeat1 = 279,
  aux_sym_type_bound_repeat1 = 280,
  aux_sym_interface_type_list_repeat1 = 281,
  aux_sym_annotation_type_body_repeat1 = 282,
  aux_sym_interface_body_repeat1 = 283,
  aux_sym__variable_declarator_list_repeat1 = 284,
  aux_sym_array_initializer_repeat1 = 285,
  aux_sym_formal_parameters_repeat1 = 286,
  alias_sym_type_identifier = 287,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_decimal_integer_literal] = "decimal_integer_literal",
  [sym_hex_integer_literal] = "hex_integer_literal",
  [sym_octal_integer_literal] = "octal_integer_literal",
  [sym_binary_integer_literal] = "binary_integer_literal",
  [sym_decimal_floating_point_literal] = "decimal_floating_point_literal",
  [sym_hex_floating_point_literal] = "hex_floating_point_literal",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_character_literal] = "character_literal",
  [sym_string_literal] = "string_literal",
  [sym_text_block] = "text_block",
  [sym_null_literal] = "null_literal",
  [anon_sym_LPAREN] = "(",
  [anon_sym_AMP] = "&",
  [anon_sym_RPAREN] = ")",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_COMMA] = ",",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COLON] = ":",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_new] = "new",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_extends] = "extends",
  [anon_sym_switch] = "switch",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_SEMI] = ";",
  [anon_sym_assert] = "assert",
  [anon_sym_do] = "do",
  [anon_sym_while] = "while",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_return] = "return",
  [anon_sym_yield] = "yield",
  [anon_sym_synchronized] = "synchronized",
  [anon_sym_throw] = "throw",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_AT] = "@",
  [anon_sym_open] = "open",
  [anon_sym_module] = "module",
  [anon_sym_requires] = "requires",
  [anon_sym_transitive] = "transitive",
  [anon_sym_static] = "static",
  [anon_sym_exports] = "exports",
  [anon_sym_to] = "to",
  [anon_sym_opens] = "opens",
  [anon_sym_uses] = "uses",
  [anon_sym_provides] = "provides",
  [anon_sym_with] = "with",
  [anon_sym_package] = "package",
  [anon_sym_import] = "import",
  [anon_sym_enum] = "enum",
  [anon_sym_public] = "public",
  [anon_sym_protected] = "protected",
  [anon_sym_private] = "private",
  [anon_sym_abstract] = "abstract",
  [anon_sym_final] = "final",
  [anon_sym_strictfp] = "strictfp",
  [anon_sym_native] = "native",
  [anon_sym_transient] = "transient",
  [anon_sym_volatile] = "volatile",
  [anon_sym_implements] = "implements",
  [anon_sym_record] = "record",
  [anon_sym_ATinterface] = "@interface",
  [anon_sym_interface] = "interface",
  [anon_sym_byte] = "byte",
  [anon_sym_short] = "short",
  [anon_sym_int] = "int",
  [anon_sym_long] = "long",
  [anon_sym_char] = "char",
  [anon_sym_float] = "float",
  [anon_sym_double] = "double",
  [sym_boolean_type] = "boolean_type",
  [sym_void_type] = "void_type",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_throws] = "throws",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_line_comment] = "line_comment",
  [sym_block_comment] = "block_comment",
  [sym_program] = "program",
  [sym__literal] = "_literal",
  [sym_expression] = "expression",
  [sym_cast_expression] = "cast_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_instanceof_expression] = "instanceof_expression",
  [sym_lambda_expression] = "lambda_expression",
  [sym_inferred_parameters] = "inferred_parameters",
  [sym_ternary_expression] = "ternary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_primary_expression] = "primary_expression",
  [sym_array_creation_expression] = "array_creation_expression",
  [sym_dimensions_expr] = "dimensions_expr",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_class_literal] = "class_literal",
  [sym_object_creation_expression] = "object_creation_expression",
  [sym__unqualified_object_creation_expression] = "_unqualified_object_creation_expression",
  [sym_field_access] = "field_access",
  [sym_array_access] = "array_access",
  [sym_method_invocation] = "method_invocation",
  [sym_argument_list] = "argument_list",
  [sym_method_reference] = "method_reference",
  [sym_type_arguments] = "type_arguments",
  [sym_wildcard] = "wildcard",
  [sym__wildcard_bounds] = "_wildcard_bounds",
  [sym_dimensions] = "dimensions",
  [sym_switch_expression] = "switch_expression",
  [sym_switch_block] = "switch_block",
  [sym_switch_block_statement_group] = "switch_block_statement_group",
  [sym_switch_rule] = "switch_rule",
  [sym_switch_label] = "switch_label",
  [sym_statement] = "statement",
  [sym_block] = "block",
  [sym_expression_statement] = "expression_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_assert_statement] = "assert_statement",
  [sym_do_statement] = "do_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_return_statement] = "return_statement",
  [sym_yield_statement] = "yield_statement",
  [sym_synchronized_statement] = "synchronized_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_catch_formal_parameter] = "catch_formal_parameter",
  [sym_catch_type] = "catch_type",
  [sym_finally_clause] = "finally_clause",
  [sym_try_with_resources_statement] = "try_with_resources_statement",
  [sym_resource_specification] = "resource_specification",
  [sym_resource] = "resource",
  [sym_if_statement] = "if_statement",
  [sym_while_statement] = "while_statement",
  [sym_for_statement] = "for_statement",
  [sym_enhanced_for_statement] = "enhanced_for_statement",
  [sym__annotation] = "_annotation",
  [sym_marker_annotation] = "marker_annotation",
  [sym_annotation] = "annotation",
  [sym_annotation_argument_list] = "annotation_argument_list",
  [sym_element_value_pair] = "element_value_pair",
  [sym__element_value] = "_element_value",
  [sym_element_value_array_initializer] = "element_value_array_initializer",
  [sym_declaration] = "declaration",
  [sym_module_declaration] = "module_declaration",
  [sym_module_body] = "module_body",
  [sym_module_directive] = "module_directive",
  [sym_requires_module_directive] = "requires_module_directive",
  [sym_requires_modifier] = "requires_modifier",
  [sym_exports_module_directive] = "exports_module_directive",
  [sym_opens_module_directive] = "opens_module_directive",
  [sym_uses_module_directive] = "uses_module_directive",
  [sym_provides_module_directive] = "provides_module_directive",
  [sym_package_declaration] = "package_declaration",
  [sym_import_declaration] = "import_declaration",
  [sym_asterisk] = "asterisk",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_body_declarations] = "enum_body_declarations",
  [sym_enum_constant] = "enum_constant",
  [sym_class_declaration] = "class_declaration",
  [sym_modifiers] = "modifiers",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_type_bound] = "type_bound",
  [sym_superclass] = "superclass",
  [sym_super_interfaces] = "super_interfaces",
  [sym_interface_type_list] = "interface_type_list",
  [sym_class_body] = "class_body",
  [sym_static_initializer] = "static_initializer",
  [sym_constructor_declaration] = "constructor_declaration",
  [sym__constructor_declarator] = "_constructor_declarator",
  [sym_constructor_body] = "constructor_body",
  [sym_explicit_constructor_invocation] = "explicit_constructor_invocation",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_field_declaration] = "field_declaration",
  [sym_record_declaration] = "record_declaration",
  [sym_annotation_type_declaration] = "annotation_type_declaration",
  [sym_annotation_type_body] = "annotation_type_body",
  [sym_annotation_type_element_declaration] = "annotation_type_element_declaration",
  [sym__default_value] = "_default_value",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_interfaces] = "extends_interfaces",
  [sym_interface_body] = "interface_body",
  [sym_constant_declaration] = "constant_declaration",
  [sym__variable_declarator_list] = "_variable_declarator_list",
  [sym_variable_declarator] = "variable_declarator",
  [sym__variable_declarator_id] = "_variable_declarator_id",
  [sym_array_initializer] = "array_initializer",
  [sym__type] = "_type",
  [sym__unannotated_type] = "_unannotated_type",
  [sym_annotated_type] = "annotated_type",
  [sym_scoped_type_identifier] = "scoped_type_identifier",
  [sym_generic_type] = "generic_type",
  [sym_array_type] = "array_type",
  [sym_integral_type] = "integral_type",
  [sym_floating_point_type] = "floating_point_type",
  [sym__method_header] = "_method_header",
  [sym__method_declarator] = "_method_declarator",
  [sym_formal_parameters] = "formal_parameters",
  [sym_formal_parameter] = "formal_parameter",
  [sym_receiver_parameter] = "receiver_parameter",
  [sym_spread_parameter] = "spread_parameter",
  [sym_throws] = "throws",
  [sym_local_variable_declaration] = "local_variable_declaration",
  [sym_method_declaration] = "method_declaration",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_cast_expression_repeat1] = "cast_expression_repeat1",
  [aux_sym_inferred_parameters_repeat1] = "inferred_parameters_repeat1",
  [aux_sym_array_creation_expression_repeat1] = "array_creation_expression_repeat1",
  [aux_sym_dimensions_expr_repeat1] = "dimensions_expr_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_dimensions_repeat1] = "dimensions_repeat1",
  [aux_sym_switch_block_repeat1] = "switch_block_repeat1",
  [aux_sym_switch_block_repeat2] = "switch_block_repeat2",
  [aux_sym_switch_block_statement_group_repeat1] = "switch_block_statement_group_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_catch_type_repeat1] = "catch_type_repeat1",
  [aux_sym_resource_specification_repeat1] = "resource_specification_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_for_statement_repeat2] = "for_statement_repeat2",
  [aux_sym_annotation_argument_list_repeat1] = "annotation_argument_list_repeat1",
  [aux_sym_element_value_array_initializer_repeat1] = "element_value_array_initializer_repeat1",
  [aux_sym_module_body_repeat1] = "module_body_repeat1",
  [aux_sym_requires_module_directive_repeat1] = "requires_module_directive_repeat1",
  [aux_sym_exports_module_directive_repeat1] = "exports_module_directive_repeat1",
  [aux_sym_provides_module_directive_repeat1] = "provides_module_directive_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_enum_body_declarations_repeat1] = "enum_body_declarations_repeat1",
  [aux_sym_modifiers_repeat1] = "modifiers_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_type_bound_repeat1] = "type_bound_repeat1",
  [aux_sym_interface_type_list_repeat1] = "interface_type_list_repeat1",
  [aux_sym_annotation_type_body_repeat1] = "annotation_type_body_repeat1",
  [aux_sym_interface_body_repeat1] = "interface_body_repeat1",
  [aux_sym__variable_declarator_list_repeat1] = "_variable_declarator_list_repeat1",
  [aux_sym_array_initializer_repeat1] = "array_initializer_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_decimal_integer_literal] = sym_decimal_integer_literal,
  [sym_hex_integer_literal] = sym_hex_integer_literal,
  [sym_octal_integer_literal] = sym_octal_integer_literal,
  [sym_binary_integer_literal] = sym_binary_integer_literal,
  [sym_decimal_floating_point_literal] = sym_decimal_floating_point_literal,
  [sym_hex_floating_point_literal] = sym_hex_floating_point_literal,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_character_literal] = sym_character_literal,
  [sym_string_literal] = sym_string_literal,
  [sym_text_block] = sym_text_block,
  [sym_null_literal] = sym_null_literal,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_synchronized] = anon_sym_synchronized,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_open] = anon_sym_open,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_requires] = anon_sym_requires,
  [anon_sym_transitive] = anon_sym_transitive,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_exports] = anon_sym_exports,
  [anon_sym_to] = anon_sym_to,
  [anon_sym_opens] = anon_sym_opens,
  [anon_sym_uses] = anon_sym_uses,
  [anon_sym_provides] = anon_sym_provides,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_final] = anon_sym_final,
  [anon_sym_strictfp] = anon_sym_strictfp,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_transient] = anon_sym_transient,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_record] = anon_sym_record,
  [anon_sym_ATinterface] = anon_sym_ATinterface,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_byte] = anon_sym_byte,
  [anon_sym_short] = anon_sym_short,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_char] = anon_sym_char,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_double] = anon_sym_double,
  [sym_boolean_type] = sym_boolean_type,
  [sym_void_type] = sym_void_type,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_throws] = anon_sym_throws,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_line_comment] = sym_line_comment,
  [sym_block_comment] = sym_block_comment,
  [sym_program] = sym_program,
  [sym__literal] = sym__literal,
  [sym_expression] = sym_expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_instanceof_expression] = sym_instanceof_expression,
  [sym_lambda_expression] = sym_lambda_expression,
  [sym_inferred_parameters] = sym_inferred_parameters,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_array_creation_expression] = sym_array_creation_expression,
  [sym_dimensions_expr] = sym_dimensions_expr,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_class_literal] = sym_class_literal,
  [sym_object_creation_expression] = sym_object_creation_expression,
  [sym__unqualified_object_creation_expression] = sym__unqualified_object_creation_expression,
  [sym_field_access] = sym_field_access,
  [sym_array_access] = sym_array_access,
  [sym_method_invocation] = sym_method_invocation,
  [sym_argument_list] = sym_argument_list,
  [sym_method_reference] = sym_method_reference,
  [sym_type_arguments] = sym_type_arguments,
  [sym_wildcard] = sym_wildcard,
  [sym__wildcard_bounds] = sym__wildcard_bounds,
  [sym_dimensions] = sym_dimensions,
  [sym_switch_expression] = sym_switch_expression,
  [sym_switch_block] = sym_switch_block,
  [sym_switch_block_statement_group] = sym_switch_block_statement_group,
  [sym_switch_rule] = sym_switch_rule,
  [sym_switch_label] = sym_switch_label,
  [sym_statement] = sym_statement,
  [sym_block] = sym_block,
  [sym_expression_statement] = sym_expression_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_assert_statement] = sym_assert_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_yield_statement] = sym_yield_statement,
  [sym_synchronized_statement] = sym_synchronized_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_catch_formal_parameter] = sym_catch_formal_parameter,
  [sym_catch_type] = sym_catch_type,
  [sym_finally_clause] = sym_finally_clause,
  [sym_try_with_resources_statement] = sym_try_with_resources_statement,
  [sym_resource_specification] = sym_resource_specification,
  [sym_resource] = sym_resource,
  [sym_if_statement] = sym_if_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_enhanced_for_statement] = sym_enhanced_for_statement,
  [sym__annotation] = sym__annotation,
  [sym_marker_annotation] = sym_marker_annotation,
  [sym_annotation] = sym_annotation,
  [sym_annotation_argument_list] = sym_annotation_argument_list,
  [sym_element_value_pair] = sym_element_value_pair,
  [sym__element_value] = sym__element_value,
  [sym_element_value_array_initializer] = sym_element_value_array_initializer,
  [sym_declaration] = sym_declaration,
  [sym_module_declaration] = sym_module_declaration,
  [sym_module_body] = sym_module_body,
  [sym_module_directive] = sym_module_directive,
  [sym_requires_module_directive] = sym_requires_module_directive,
  [sym_requires_modifier] = sym_requires_modifier,
  [sym_exports_module_directive] = sym_exports_module_directive,
  [sym_opens_module_directive] = sym_opens_module_directive,
  [sym_uses_module_directive] = sym_uses_module_directive,
  [sym_provides_module_directive] = sym_provides_module_directive,
  [sym_package_declaration] = sym_package_declaration,
  [sym_import_declaration] = sym_import_declaration,
  [sym_asterisk] = sym_asterisk,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_body_declarations] = sym_enum_body_declarations,
  [sym_enum_constant] = sym_enum_constant,
  [sym_class_declaration] = sym_class_declaration,
  [sym_modifiers] = sym_modifiers,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_type_bound] = sym_type_bound,
  [sym_superclass] = sym_superclass,
  [sym_super_interfaces] = sym_super_interfaces,
  [sym_interface_type_list] = sym_interface_type_list,
  [sym_class_body] = sym_class_body,
  [sym_static_initializer] = sym_static_initializer,
  [sym_constructor_declaration] = sym_constructor_declaration,
  [sym__constructor_declarator] = sym__constructor_declarator,
  [sym_constructor_body] = sym_constructor_body,
  [sym_explicit_constructor_invocation] = sym_explicit_constructor_invocation,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym_field_declaration] = sym_field_declaration,
  [sym_record_declaration] = sym_record_declaration,
  [sym_annotation_type_declaration] = sym_annotation_type_declaration,
  [sym_annotation_type_body] = sym_annotation_type_body,
  [sym_annotation_type_element_declaration] = sym_annotation_type_element_declaration,
  [sym__default_value] = sym__default_value,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_interfaces] = sym_extends_interfaces,
  [sym_interface_body] = sym_interface_body,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym__variable_declarator_list] = sym__variable_declarator_list,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym__variable_declarator_id] = sym__variable_declarator_id,
  [sym_array_initializer] = sym_array_initializer,
  [sym__type] = sym__type,
  [sym__unannotated_type] = sym__unannotated_type,
  [sym_annotated_type] = sym_annotated_type,
  [sym_scoped_type_identifier] = sym_scoped_type_identifier,
  [sym_generic_type] = sym_generic_type,
  [sym_array_type] = sym_array_type,
  [sym_integral_type] = sym_integral_type,
  [sym_floating_point_type] = sym_floating_point_type,
  [sym__method_header] = sym__method_header,
  [sym__method_declarator] = sym__method_declarator,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_formal_parameter] = sym_formal_parameter,
  [sym_receiver_parameter] = sym_receiver_parameter,
  [sym_spread_parameter] = sym_spread_parameter,
  [sym_throws] = sym_throws,
  [sym_local_variable_declaration] = sym_local_variable_declaration,
  [sym_method_declaration] = sym_method_declaration,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_cast_expression_repeat1] = aux_sym_cast_expression_repeat1,
  [aux_sym_inferred_parameters_repeat1] = aux_sym_inferred_parameters_repeat1,
  [aux_sym_array_creation_expression_repeat1] = aux_sym_array_creation_expression_repeat1,
  [aux_sym_dimensions_expr_repeat1] = aux_sym_dimensions_expr_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_dimensions_repeat1] = aux_sym_dimensions_repeat1,
  [aux_sym_switch_block_repeat1] = aux_sym_switch_block_repeat1,
  [aux_sym_switch_block_repeat2] = aux_sym_switch_block_repeat2,
  [aux_sym_switch_block_statement_group_repeat1] = aux_sym_switch_block_statement_group_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_catch_type_repeat1] = aux_sym_catch_type_repeat1,
  [aux_sym_resource_specification_repeat1] = aux_sym_resource_specification_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_for_statement_repeat2] = aux_sym_for_statement_repeat2,
  [aux_sym_annotation_argument_list_repeat1] = aux_sym_annotation_argument_list_repeat1,
  [aux_sym_element_value_array_initializer_repeat1] = aux_sym_element_value_array_initializer_repeat1,
  [aux_sym_module_body_repeat1] = aux_sym_module_body_repeat1,
  [aux_sym_requires_module_directive_repeat1] = aux_sym_requires_module_directive_repeat1,
  [aux_sym_exports_module_directive_repeat1] = aux_sym_exports_module_directive_repeat1,
  [aux_sym_provides_module_directive_repeat1] = aux_sym_provides_module_directive_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_enum_body_declarations_repeat1] = aux_sym_enum_body_declarations_repeat1,
  [aux_sym_modifiers_repeat1] = aux_sym_modifiers_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_type_bound_repeat1] = aux_sym_type_bound_repeat1,
  [aux_sym_interface_type_list_repeat1] = aux_sym_interface_type_list_repeat1,
  [aux_sym_annotation_type_body_repeat1] = aux_sym_annotation_type_body_repeat1,
  [aux_sym_interface_body_repeat1] = aux_sym_interface_body_repeat1,
  [aux_sym__variable_declarator_list_repeat1] = aux_sym__variable_declarator_list_repeat1,
  [aux_sym_array_initializer_repeat1] = aux_sym_array_initializer_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_octal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_character_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_text_block] = {
    .visible = true,
    .named = true,
  },
  [sym_null_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_synchronized] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_open] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_requires] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transitive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exports] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_to] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_opens] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uses] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_provides] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strictfp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_record] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATinterface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_char] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double] = {
    .visible = true,
    .named = false,
  },
  [sym_boolean_type] = {
    .visible = true,
    .named = true,
  },
  [sym_void_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throws] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instanceof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_inferred_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_array_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dimensions_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_object_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__unqualified_object_creation_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym_array_access] = {
    .visible = true,
    .named = true,
  },
  [sym_method_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_method_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard] = {
    .visible = true,
    .named = true,
  },
  [sym__wildcard_bounds] = {
    .visible = false,
    .named = true,
  },
  [sym_dimensions] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block_statement_group] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_label] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yield_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_synchronized_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_type] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_try_with_resources_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_resource_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_resource] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_enhanced_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_marker_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_element_value_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__element_value] = {
    .visible = false,
    .named = true,
  },
  [sym_element_value_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module_body] = {
    .visible = true,
    .named = true,
  },
  [sym_module_directive] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_requires_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_requires_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_exports_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_opens_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_uses_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_provides_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_package_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_asterisk] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body_declarations] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_superclass] = {
    .visible = true,
    .named = true,
  },
  [sym_super_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_type_list] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_static_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__constructor_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_body] = {
    .visible = true,
    .named = true,
  },
  [sym_explicit_constructor_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_record_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_body] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_element_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__default_value] = {
    .visible = false,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_list] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_id] = {
    .visible = false,
    .named = true,
  },
  [sym_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__unannotated_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_annotated_type] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_integral_type] = {
    .visible = true,
    .named = true,
  },
  [sym_floating_point_type] = {
    .visible = true,
    .named = true,
  },
  [sym__method_header] = {
    .visible = false,
    .named = true,
  },
  [sym__method_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_receiver_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_throws] = {
    .visible = true,
    .named = true,
  },
  [sym_local_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_method_declaration] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cast_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inferred_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_creation_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_statement_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_catch_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_resource_specification_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_element_value_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_requires_module_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_exports_module_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_provides_module_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_bound_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_type_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_type_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_declarator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_array = 3,
  field_body = 4,
  field_condition = 5,
  field_consequence = 6,
  field_constructor = 7,
  field_declarator = 8,
  field_dimensions = 9,
  field_element = 10,
  field_field = 11,
  field_index = 12,
  field_init = 13,
  field_interfaces = 14,
  field_key = 15,
  field_left = 16,
  field_modifiers = 17,
  field_module = 18,
  field_modules = 19,
  field_name = 20,
  field_object = 21,
  field_operand = 22,
  field_operator = 23,
  field_package = 24,
  field_parameters = 25,
  field_provided = 26,
  field_provider = 27,
  field_resources = 28,
  field_right = 29,
  field_scope = 30,
  field_superclass = 31,
  field_type = 32,
  field_type_arguments = 33,
  field_type_parameters = 34,
  field_update = 35,
  field_value = 36,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_array] = "array",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declarator] = "declarator",
  [field_dimensions] = "dimensions",
  [field_element] = "element",
  [field_field] = "field",
  [field_index] = "index",
  [field_init] = "init",
  [field_interfaces] = "interfaces",
  [field_key] = "key",
  [field_left] = "left",
  [field_modifiers] = "modifiers",
  [field_module] = "module",
  [field_modules] = "modules",
  [field_name] = "name",
  [field_object] = "object",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_package] = "package",
  [field_parameters] = "parameters",
  [field_provided] = "provided",
  [field_provider] = "provider",
  [field_resources] = "resources",
  [field_right] = "right",
  [field_scope] = "scope",
  [field_superclass] = "superclass",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 3},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 5, .length = 1},
  [6] = {.index = 5, .length = 1},
  [7] = {.index = 6, .length = 2},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 8, .length = 1},
  [11] = {.index = 9, .length = 2},
  [12] = {.index = 11, .length = 1},
  [13] = {.index = 12, .length = 2},
  [14] = {.index = 14, .length = 3},
  [15] = {.index = 17, .length = 2},
  [16] = {.index = 19, .length = 2},
  [17] = {.index = 17, .length = 2},
  [18] = {.index = 19, .length = 2},
  [19] = {.index = 21, .length = 2},
  [20] = {.index = 23, .length = 2},
  [21] = {.index = 25, .length = 1},
  [22] = {.index = 26, .length = 1},
  [23] = {.index = 27, .length = 2},
  [24] = {.index = 29, .length = 2},
  [25] = {.index = 31, .length = 2},
  [26] = {.index = 31, .length = 2},
  [27] = {.index = 33, .length = 3},
  [28] = {.index = 21, .length = 2},
  [30] = {.index = 36, .length = 2},
  [31] = {.index = 36, .length = 2},
  [32] = {.index = 33, .length = 3},
  [33] = {.index = 38, .length = 2},
  [35] = {.index = 40, .length = 2},
  [36] = {.index = 42, .length = 3},
  [37] = {.index = 45, .length = 2},
  [38] = {.index = 45, .length = 2},
  [39] = {.index = 47, .length = 2},
  [40] = {.index = 49, .length = 2},
  [42] = {.index = 51, .length = 3},
  [43] = {.index = 54, .length = 1},
  [44] = {.index = 55, .length = 2},
  [45] = {.index = 57, .length = 2},
  [46] = {.index = 59, .length = 3},
  [47] = {.index = 62, .length = 3},
  [48] = {.index = 59, .length = 3},
  [49] = {.index = 62, .length = 3},
  [50] = {.index = 65, .length = 3},
  [51] = {.index = 65, .length = 3},
  [52] = {.index = 68, .length = 3},
  [53] = {.index = 71, .length = 3},
  [54] = {.index = 74, .length = 3},
  [55] = {.index = 77, .length = 2},
  [56] = {.index = 77, .length = 2},
  [57] = {.index = 79, .length = 2},
  [58] = {.index = 79, .length = 2},
  [60] = {.index = 81, .length = 2},
  [61] = {.index = 83, .length = 3},
  [62] = {.index = 83, .length = 3},
  [64] = {.index = 86, .length = 2},
  [65] = {.index = 88, .length = 2},
  [66] = {.index = 90, .length = 1},
  [67] = {.index = 91, .length = 2},
  [68] = {.index = 93, .length = 3},
  [70] = {.index = 96, .length = 3},
  [72] = {.index = 99, .length = 2},
  [73] = {.index = 101, .length = 4},
  [74] = {.index = 105, .length = 4},
  [75] = {.index = 109, .length = 5},
  [76] = {.index = 114, .length = 6},
  [77] = {.index = 120, .length = 4},
  [78] = {.index = 124, .length = 4},
  [79] = {.index = 128, .length = 4},
  [80] = {.index = 132, .length = 2},
  [81] = {.index = 134, .length = 3},
  [82] = {.index = 137, .length = 1},
  [83] = {.index = 138, .length = 2},
  [84] = {.index = 140, .length = 1},
  [85] = {.index = 141, .length = 2},
  [86] = {.index = 143, .length = 3},
  [87] = {.index = 146, .length = 2},
  [88] = {.index = 146, .length = 2},
  [89] = {.index = 148, .length = 4},
  [90] = {.index = 148, .length = 4},
  [91] = {.index = 152, .length = 3},
  [92] = {.index = 155, .length = 3},
  [93] = {.index = 158, .length = 3},
  [94] = {.index = 161, .length = 3},
  [95] = {.index = 164, .length = 2},
  [96] = {.index = 166, .length = 2},
  [97] = {.index = 166, .length = 2},
  [98] = {.index = 168, .length = 4},
  [99] = {.index = 172, .length = 5},
  [100] = {.index = 177, .length = 6},
  [101] = {.index = 183, .length = 3},
  [102] = {.index = 186, .length = 5},
  [103] = {.index = 191, .length = 4},
  [104] = {.index = 99, .length = 2},
  [105] = {.index = 195, .length = 5},
  [106] = {.index = 200, .length = 4},
  [107] = {.index = 204, .length = 2},
  [108] = {.index = 206, .length = 1},
  [109] = {.index = 207, .length = 2},
  [110] = {.index = 209, .length = 2},
  [111] = {.index = 211, .length = 1},
  [112] = {.index = 211, .length = 1},
  [113] = {.index = 212, .length = 2},
  [114] = {.index = 214, .length = 1},
  [115] = {.index = 214, .length = 1},
  [116] = {.index = 54, .length = 1},
  [117] = {.index = 215, .length = 3},
  [118] = {.index = 218, .length = 3},
  [119] = {.index = 218, .length = 3},
  [120] = {.index = 221, .length = 4},
  [121] = {.index = 225, .length = 4},
  [122] = {.index = 229, .length = 4},
  [123] = {.index = 233, .length = 3},
  [124] = {.index = 236, .length = 3},
  [125] = {.index = 239, .length = 4},
  [126] = {.index = 243, .length = 5},
  [127] = {.index = 248, .length = 3},
  [128] = {.index = 248, .length = 3},
  [129] = {.index = 251, .length = 4},
  [130] = {.index = 255, .length = 1},
  [131] = {.index = 256, .length = 2},
  [132] = {.index = 258, .length = 2},
  [133] = {.index = 260, .length = 1},
  [134] = {.index = 261, .length = 2},
  [135] = {.index = 263, .length = 2},
  [136] = {.index = 265, .length = 2},
  [137] = {.index = 267, .length = 3},
  [138] = {.index = 270, .length = 3},
  [139] = {.index = 273, .length = 2},
  [140] = {.index = 273, .length = 2},
  [141] = {.index = 275, .length = 3},
  [142] = {.index = 278, .length = 4},
  [143] = {.index = 278, .length = 4},
  [144] = {.index = 282, .length = 5},
  [145] = {.index = 287, .length = 3},
  [146] = {.index = 290, .length = 2},
  [147] = {.index = 292, .length = 3},
  [148] = {.index = 295, .length = 3},
  [149] = {.index = 298, .length = 3},
  [150] = {.index = 301, .length = 3},
  [151] = {.index = 304, .length = 3},
  [152] = {.index = 307, .length = 5},
  [153] = {.index = 312, .length = 4},
  [154] = {.index = 316, .length = 4},
  [155] = {.index = 320, .length = 2},
  [156] = {.index = 320, .length = 2},
  [157] = {.index = 320, .length = 2},
  [158] = {.index = 320, .length = 2},
  [159] = {.index = 322, .length = 1},
  [160] = {.index = 322, .length = 1},
  [161] = {.index = 322, .length = 1},
  [162] = {.index = 322, .length = 1},
  [163] = {.index = 323, .length = 2},
  [164] = {.index = 325, .length = 3},
  [165] = {.index = 328, .length = 4},
  [166] = {.index = 332, .length = 4},
  [167] = {.index = 336, .length = 4},
  [168] = {.index = 340, .length = 4},
  [169] = {.index = 344, .length = 4},
  [170] = {.index = 348, .length = 5},
  [171] = {.index = 353, .length = 5},
  [172] = {.index = 358, .length = 1},
  [173] = {.index = 358, .length = 1},
  [174] = {.index = 359, .length = 3},
  [175] = {.index = 362, .length = 2},
  [176] = {.index = 359, .length = 3},
  [177] = {.index = 359, .length = 3},
  [178] = {.index = 359, .length = 3},
  [179] = {.index = 364, .length = 1},
  [180] = {.index = 364, .length = 1},
  [181] = {.index = 365, .length = 2},
  [182] = {.index = 367, .length = 2},
  [183] = {.index = 365, .length = 2},
  [184] = {.index = 365, .length = 2},
  [185] = {.index = 365, .length = 2},
  [186] = {.index = 369, .length = 2},
  [187] = {.index = 371, .length = 1},
  [188] = {.index = 372, .length = 3},
  [189] = {.index = 375, .length = 3},
  [190] = {.index = 378, .length = 3},
  [191] = {.index = 381, .length = 5},
  [192] = {.index = 386, .length = 5},
  [193] = {.index = 391, .length = 5},
  [194] = {.index = 396, .length = 3},
  [195] = {.index = 399, .length = 3},
  [196] = {.index = 402, .length = 4},
  [197] = {.index = 406, .length = 4},
  [198] = {.index = 410, .length = 6},
  [199] = {.index = 416, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_arguments, 0, .inherited = true},
  [3] =
    {field_operand, 1},
    {field_operator, 0},
  [5] =
    {field_name, 1},
  [6] =
    {field_arguments, 1},
    {field_name, 0},
  [8] =
    {field_name, 0},
  [9] =
    {field_dimensions, 1},
    {field_element, 0},
  [11] =
    {field_declarator, 0},
  [12] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [14] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
  [17] =
    {field_arguments, 2},
    {field_type, 1},
  [19] =
    {field_dimensions, 2},
    {field_type, 1},
  [21] =
    {field_body, 2},
    {field_name, 1},
  [23] =
    {field_body, 2},
    {field_condition, 1},
  [25] =
    {field_body, 2},
  [26] =
    {field_body, 1},
  [27] =
    {field_body, 2},
    {field_resources, 1},
  [29] =
    {field_condition, 1},
    {field_consequence, 2},
  [31] =
    {field_arguments, 2},
    {field_name, 1},
  [33] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [36] =
    {field_field, 2},
    {field_object, 0},
  [38] =
    {field_body, 2},
    {field_parameters, 0},
  [40] =
    {field_left, 0},
    {field_right, 2},
  [42] =
    {field_arguments, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_type_arguments, 2, .inherited = true},
  [45] =
    {field_dimensions, 1},
    {field_name, 0},
  [47] =
    {field_declarator, 1, .inherited = true},
    {field_type, 0},
  [49] =
    {field_declarator, 0},
    {field_declarator, 1, .inherited = true},
  [51] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
  [54] =
    {field_type, 1},
  [55] =
    {field_type, 1},
    {field_value, 3},
  [57] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [59] =
    {field_dimensions, 2},
    {field_type, 1},
    {field_value, 3},
  [62] =
    {field_dimensions, 2},
    {field_dimensions, 3},
    {field_type, 1},
  [65] =
    {field_arguments, 3},
    {field_type, 2},
    {field_type_arguments, 1},
  [68] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [71] =
    {field_body, 3},
    {field_name, 1},
    {field_superclass, 2},
  [74] =
    {field_body, 3},
    {field_interfaces, 2},
    {field_name, 1},
  [77] =
    {field_name, 2},
    {field_scope, 0},
  [79] =
    {field_body, 3},
    {field_name, 2},
  [81] =
    {field_body, 3},
    {field_name, 1},
  [83] =
    {field_arguments, 3},
    {field_name, 2},
    {field_object, 0},
  [86] =
    {field_array, 0},
    {field_index, 2},
  [88] =
    {field_declarator, 2, .inherited = true},
    {field_type, 1},
  [90] =
    {field_declarator, 1},
  [91] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [93] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_value, 2},
  [96] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [99] =
    {field_name, 0},
    {field_parameters, 1},
  [101] =
    {field_body, 1},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [105] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0},
  [109] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [114] =
    {field_body, 1},
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [120] =
    {field_body, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [124] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [128] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_superclass, 2},
  [132] =
    {field_body, 1},
    {field_condition, 3},
  [134] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [137] =
    {field_init, 1},
  [138] =
    {field_init, 0, .inherited = true},
    {field_init, 1, .inherited = true},
  [140] =
    {field_modifiers, 0},
  [141] =
    {field_body, 1},
    {field_name, 0},
  [143] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [146] =
    {field_field, 4},
    {field_object, 0},
  [148] =
    {field_arguments, 4},
    {field_name, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [152] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [155] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [158] =
    {field_body, 4},
    {field_name, 2},
    {field_superclass, 3},
  [161] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 2},
  [164] =
    {field_body, 4},
    {field_name, 2},
  [166] =
    {field_body, 4},
    {field_name, 3},
  [168] =
    {field_body, 2},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [172] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [177] =
    {field_body, 2},
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [183] =
    {field_name, 1},
    {field_parameters, 2},
    {field_type_parameters, 0},
  [186] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1},
    {field_type_parameters, 0},
  [191] =
    {field_body, 2},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [195] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [200] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
    {field_value, 3},
  [204] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [206] =
    {field_body, 5},
  [207] =
    {field_body, 5},
    {field_init, 2},
  [209] =
    {field_key, 0},
    {field_value, 2},
  [211] =
    {field_module, 1},
  [212] =
    {field_modifiers, 0, .inherited = true},
    {field_modifiers, 1, .inherited = true},
  [214] =
    {field_package, 1},
  [215] =
    {field_arguments, 1},
    {field_body, 2},
    {field_name, 0},
  [218] =
    {field_arguments, 5},
    {field_name, 4},
    {field_object, 0},
  [221] =
    {field_body, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [225] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [229] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_superclass, 3},
  [233] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [236] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [239] =
    {field_body, 3},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [243] =
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_parameters, 3, .inherited = true},
    {field_type, 2},
    {field_type_parameters, 0},
  [248] =
    {field_dimensions, 2},
    {field_name, 0},
    {field_parameters, 1},
  [251] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
    {field_value, 4},
  [255] =
    {field_body, 4},
  [256] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [258] =
    {field_body, 6},
    {field_update, 4},
  [260] =
    {field_update, 1},
  [261] =
    {field_update, 0, .inherited = true},
    {field_update, 1, .inherited = true},
  [263] =
    {field_body, 6},
    {field_condition, 3},
  [265] =
    {field_body, 6},
    {field_init, 2},
  [267] =
    {field_body, 6},
    {field_init, 2},
    {field_update, 4},
  [270] =
    {field_body, 6},
    {field_condition, 3},
    {field_init, 2},
  [273] =
    {field_modifiers, 1, .inherited = true},
    {field_module, 2},
  [275] =
    {field_arguments, 2},
    {field_body, 3},
    {field_name, 1},
  [278] =
    {field_arguments, 6},
    {field_name, 5},
    {field_object, 0},
    {field_type_arguments, 4},
  [282] =
    {field_body, 6},
    {field_interfaces, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [287] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [290] =
    {field_arguments, 1},
    {field_constructor, 0},
  [292] =
    {field_body, 7},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [295] =
    {field_body, 7},
    {field_condition, 3},
    {field_update, 5},
  [298] =
    {field_body, 7},
    {field_init, 2},
    {field_update, 5},
  [301] =
    {field_body, 7},
    {field_condition, 4},
    {field_init, 2},
  [304] =
    {field_body, 7},
    {field_init, 2},
    {field_init, 3, .inherited = true},
  [307] =
    {field_body, 7},
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_type, 2},
    {field_value, 5},
  [312] =
    {field_body, 7},
    {field_init, 2},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [316] =
    {field_body, 7},
    {field_condition, 3},
    {field_init, 2},
    {field_update, 5},
  [320] =
    {field_modules, 3},
    {field_package, 1},
  [322] =
    {field_provided, 1},
  [323] =
    {field_name, 1},
    {field_type, 0},
  [325] =
    {field_arguments, 2},
    {field_constructor, 1},
    {field_type_arguments, 0},
  [328] =
    {field_body, 8},
    {field_condition, 3},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [332] =
    {field_body, 8},
    {field_init, 2},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [336] =
    {field_body, 8},
    {field_condition, 4},
    {field_init, 2},
    {field_update, 6},
  [340] =
    {field_body, 8},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 6},
  [344] =
    {field_body, 8},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
  [348] =
    {field_body, 8},
    {field_dimensions, 4, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_type, 3},
    {field_value, 6},
  [353] =
    {field_body, 8},
    {field_condition, 3},
    {field_init, 2},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [358] =
    {field_modules, 1},
  [359] =
    {field_modules, 3},
    {field_modules, 4, .inherited = true},
    {field_package, 1},
  [362] =
    {field_modules, 0, .inherited = true},
    {field_modules, 1, .inherited = true},
  [364] =
    {field_provider, 1},
  [365] =
    {field_provided, 1},
    {field_provider, 4, .inherited = true},
  [367] =
    {field_provider, 0, .inherited = true},
    {field_provider, 1, .inherited = true},
  [369] =
    {field_name, 2},
    {field_type, 1},
  [371] =
    {field_value, 1},
  [372] =
    {field_dimensions, 4},
    {field_name, 1},
    {field_type, 0},
  [375] =
    {field_name, 1},
    {field_type, 0},
    {field_value, 4, .inherited = true},
  [378] =
    {field_arguments, 3},
    {field_constructor, 2},
    {field_object, 0},
  [381] =
    {field_body, 9},
    {field_condition, 4},
    {field_init, 2},
    {field_update, 6},
    {field_update, 7, .inherited = true},
  [386] =
    {field_body, 9},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 6},
    {field_update, 7, .inherited = true},
  [391] =
    {field_body, 9},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 7},
  [396] =
    {field_dimensions, 5},
    {field_name, 2},
    {field_type, 1},
  [399] =
    {field_name, 2},
    {field_type, 1},
    {field_value, 5, .inherited = true},
  [402] =
    {field_dimensions, 4},
    {field_name, 1},
    {field_type, 0},
    {field_value, 5, .inherited = true},
  [406] =
    {field_arguments, 4},
    {field_constructor, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [410] =
    {field_body, 10},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 7},
    {field_update, 8, .inherited = true},
  [416] =
    {field_dimensions, 5},
    {field_name, 2},
    {field_type, 1},
    {field_value, 6, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [2] = {
    [0] = alias_sym_type_identifier,
  },
  [5] = {
    [1] = sym_identifier,
  },
  [7] = {
    [0] = sym_identifier,
  },
  [9] = {
    [0] = sym_identifier,
  },
  [17] = {
    [1] = alias_sym_type_identifier,
  },
  [18] = {
    [1] = alias_sym_type_identifier,
  },
  [25] = {
    [1] = sym_identifier,
  },
  [27] = {
    [0] = sym_identifier,
  },
  [28] = {
    [1] = sym_identifier,
  },
  [29] = {
    [1] = sym_identifier,
  },
  [30] = {
    [2] = sym_identifier,
  },
  [34] = {
    [0] = alias_sym_type_identifier,
    [2] = alias_sym_type_identifier,
  },
  [37] = {
    [0] = sym_identifier,
  },
  [41] = {
    [2] = alias_sym_type_identifier,
  },
  [48] = {
    [1] = alias_sym_type_identifier,
  },
  [49] = {
    [1] = alias_sym_type_identifier,
  },
  [51] = {
    [2] = alias_sym_type_identifier,
  },
  [55] = {
    [0] = sym_identifier,
  },
  [57] = {
    [2] = sym_identifier,
  },
  [59] = {
    [2] = sym_identifier,
  },
  [61] = {
    [2] = sym_identifier,
  },
  [63] = {
    [0] = alias_sym_type_identifier,
    [3] = alias_sym_type_identifier,
  },
  [69] = {
    [3] = alias_sym_type_identifier,
  },
  [71] = {
    [1] = alias_sym_type_identifier,
  },
  [87] = {
    [4] = sym_identifier,
  },
  [89] = {
    [3] = sym_identifier,
  },
  [96] = {
    [3] = sym_identifier,
  },
  [104] = {
    [0] = sym_identifier,
  },
  [111] = {
    [1] = sym_identifier,
  },
  [114] = {
    [1] = sym_identifier,
  },
  [116] = {
    [1] = sym_identifier,
  },
  [118] = {
    [4] = sym_identifier,
  },
  [127] = {
    [0] = sym_identifier,
  },
  [139] = {
    [2] = sym_identifier,
  },
  [142] = {
    [5] = sym_identifier,
  },
  [155] = {
    [1] = sym_identifier,
    [3] = sym_identifier,
  },
  [156] = {
    [1] = sym_identifier,
  },
  [157] = {
    [3] = sym_identifier,
  },
  [159] = {
    [1] = sym_identifier,
    [3] = sym_identifier,
  },
  [160] = {
    [1] = sym_identifier,
  },
  [161] = {
    [3] = sym_identifier,
  },
  [172] = {
    [1] = sym_identifier,
  },
  [174] = {
    [1] = sym_identifier,
    [3] = sym_identifier,
  },
  [176] = {
    [1] = sym_identifier,
  },
  [177] = {
    [3] = sym_identifier,
  },
  [179] = {
    [1] = sym_identifier,
  },
  [181] = {
    [1] = sym_identifier,
    [3] = sym_identifier,
  },
  [183] = {
    [1] = sym_identifier,
  },
  [184] = {
    [3] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 6688
    ? (c < 2984
      ? (c < 2365
        ? (c < 1376
          ? (c < 880
            ? (c < 192
              ? (c < 170
                ? (c < '_'
                  ? (c >= '$' && c <= 'Z')
                  : (c <= '_' || (c >= 'a' && c <= 'z')))
                : (c <= 170 || (c < 186
                  ? c == 181
                  : c <= 186)))
              : (c <= 214 || (c < 736
                ? (c < 248
                  ? (c >= 216 && c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))
                : (c <= 740 || (c < 750
                  ? c == 748
                  : c <= 750)))))
            : (c <= 884 || (c < 910
              ? (c < 902
                ? (c < 890
                  ? (c >= 886 && c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 908
                  ? (c >= 904 && c <= 906)
                  : c <= 908)))
              : (c <= 929 || (c < 1162
                ? (c < 1015
                  ? (c >= 931 && c <= 1013)
                  : c <= 1153)
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2208
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2228 || (c < 2308
                  ? (c >= 2230 && c <= 2247)
                  : c <= 2361)))))))))
        : (c <= 2365 || (c < 2703
          ? (c < 2544
            ? (c < 2474
              ? (c < 2437
                ? (c < 2392
                  ? c == 2384
                  : (c <= 2401 || (c >= 2417 && c <= 2432)))
                : (c <= 2444 || (c < 2451
                  ? (c >= 2447 && c <= 2448)
                  : c <= 2472)))
              : (c <= 2480 || (c < 2510
                ? (c < 2486
                  ? c == 2482
                  : (c <= 2489 || c == 2493))
                : (c <= 2510 || (c < 2527
                  ? (c >= 2524 && c <= 2525)
                  : c <= 2529)))))
            : (c <= 2545 || (c < 2613
              ? (c < 2579
                ? (c < 2565
                  ? c == 2556
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))
                : (c <= 2600 || (c < 2610
                  ? (c >= 2602 && c <= 2608)
                  : c <= 2611)))
              : (c <= 2614 || (c < 2654
                ? (c < 2649
                  ? (c >= 2616 && c <= 2617)
                  : c <= 2652)
                : (c <= 2654 || (c < 2693
                  ? (c >= 2674 && c <= 2676)
                  : c <= 2701)))))))
          : (c <= 2705 || (c < 2869
            ? (c < 2784
              ? (c < 2741
                ? (c < 2730
                  ? (c >= 2707 && c <= 2728)
                  : (c <= 2736 || (c >= 2738 && c <= 2739)))
                : (c <= 2745 || (c < 2768
                  ? c == 2749
                  : c <= 2768)))
              : (c <= 2785 || (c < 2835
                ? (c < 2821
                  ? c == 2809
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))
                : (c <= 2856 || (c < 2866
                  ? (c >= 2858 && c <= 2864)
                  : c <= 2867)))))
            : (c <= 2873 || (c < 2958
              ? (c < 2929
                ? (c < 2908
                  ? c == 2877
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))
                : (c <= 2929 || (c < 2949
                  ? c == 2947
                  : c <= 2954)))
              : (c <= 2960 || (c < 2972
                ? (c < 2969
                  ? (c >= 2962 && c <= 2965)
                  : c <= 2970)
                : (c <= 2972 || (c < 2979
                  ? (c >= 2974 && c <= 2975)
                  : c <= 2980)))))))))))
      : (c <= 2986 || (c < 4186
        ? (c < 3450
          ? (c < 3242
            ? (c < 3133
              ? (c < 3086
                ? (c < 3024
                  ? (c >= 2990 && c <= 3001)
                  : (c <= 3024 || (c >= 3077 && c <= 3084)))
                : (c <= 3088 || (c < 3114
                  ? (c >= 3090 && c <= 3112)
                  : c <= 3129)))
              : (c <= 3133 || (c < 3205
                ? (c < 3168
                  ? (c >= 3160 && c <= 3162)
                  : (c <= 3169 || c == 3200))
                : (c <= 3212 || (c < 3218
                  ? (c >= 3214 && c <= 3216)
                  : c <= 3240)))))
            : (c <= 3251 || (c < 3342
              ? (c < 3296
                ? (c < 3261
                  ? (c >= 3253 && c <= 3257)
                  : (c <= 3261 || c == 3294))
                : (c <= 3297 || (c < 3332
                  ? (c >= 3313 && c <= 3314)
                  : c <= 3340)))
              : (c <= 3344 || (c < 3406
                ? (c < 3389
                  ? (c >= 3346 && c <= 3386)
                  : c <= 3389)
                : (c <= 3406 || (c < 3423
                  ? (c >= 3412 && c <= 3414)
                  : c <= 3425)))))))
          : (c <= 3455 || (c < 3751
            ? (c < 3634
              ? (c < 3517
                ? (c < 3482
                  ? (c >= 3461 && c <= 3478)
                  : (c <= 3505 || (c >= 3507 && c <= 3515)))
                : (c <= 3517 || (c < 3585
                  ? (c >= 3520 && c <= 3526)
                  : c <= 3632)))
              : (c <= 3635 || (c < 3718
                ? (c < 3713
                  ? (c >= 3648 && c <= 3654)
                  : (c <= 3714 || c == 3716))
                : (c <= 3722 || (c < 3749
                  ? (c >= 3724 && c <= 3747)
                  : c <= 3749)))))
            : (c <= 3760 || (c < 3904
              ? (c < 3782
                ? (c < 3773
                  ? (c >= 3762 && c <= 3763)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))
                : (c <= 3782 || (c < 3840
                  ? (c >= 3804 && c <= 3807)
                  : c <= 3840)))
              : (c <= 3911 || (c < 4096
                ? (c < 3976
                  ? (c >= 3913 && c <= 3948)
                  : c <= 3980)
                : (c <= 4138 || (c < 4176
                  ? c == 4159
                  : c <= 4181)))))))))
        : (c <= 4189 || (c < 5024
          ? (c < 4698
            ? (c < 4295
              ? (c < 4213
                ? (c < 4197
                  ? c == 4193
                  : (c <= 4198 || (c >= 4206 && c <= 4208)))
                : (c <= 4225 || (c < 4256
                  ? c == 4238
                  : c <= 4293)))
              : (c <= 4295 || (c < 4682
                ? (c < 4304
                  ? c == 4301
                  : (c <= 4346 || (c >= 4348 && c <= 4680)))
                : (c <= 4685 || (c < 4696
                  ? (c >= 4688 && c <= 4694)
                  : c <= 4696)))))
            : (c <= 4701 || (c < 4802
              ? (c < 4786
                ? (c < 4746
                  ? (c >= 4704 && c <= 4744)
                  : (c <= 4749 || (c >= 4752 && c <= 4784)))
                : (c <= 4789 || (c < 4800
                  ? (c >= 4792 && c <= 4798)
                  : c <= 4800)))
              : (c <= 4805 || (c < 4882
                ? (c < 4824
                  ? (c >= 4808 && c <= 4822)
                  : c <= 4880)
                : (c <= 4885 || (c < 4992
                  ? (c >= 4888 && c <= 4954)
                  : c <= 5007)))))))
          : (c <= 5109 || (c < 6103
            ? (c < 5888
              ? (c < 5761
                ? (c < 5121
                  ? (c >= 5112 && c <= 5117)
                  : (c <= 5740 || (c >= 5743 && c <= 5759)))
                : (c <= 5786 || (c < 5873
                  ? (c >= 5792 && c <= 5866)
                  : c <= 5880)))
              : (c <= 5900 || (c < 5984
                ? (c < 5920
                  ? (c >= 5902 && c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6016
                  ? (c >= 5998 && c <= 6000)
                  : c <= 6067)))))
            : (c <= 6103 || (c < 6400
              ? (c < 6279
                ? (c < 6176
                  ? c == 6108
                  : (c <= 6264 || (c >= 6272 && c <= 6276)))
                : (c <= 6312 || (c < 6320
                  ? c == 6314
                  : c <= 6389)))
              : (c <= 6430 || (c < 6528
                ? (c < 6512
                  ? (c >= 6480 && c <= 6509)
                  : c <= 6516)
                : (c <= 6571 || (c < 6656
                  ? (c >= 6576 && c <= 6601)
                  : c <= 6678)))))))))))))
    : (c <= 6740 || (c < 43259
      ? (c < 11264
        ? (c < 8064
          ? (c < 7406
            ? (c < 7168
              ? (c < 7043
                ? (c < 6917
                  ? c == 6823
                  : (c <= 6963 || (c >= 6981 && c <= 6987)))
                : (c <= 7072 || (c < 7098
                  ? (c >= 7086 && c <= 7087)
                  : c <= 7141)))
              : (c <= 7203 || (c < 7312
                ? (c < 7258
                  ? (c >= 7245 && c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))
                : (c <= 7354 || (c < 7401
                  ? (c >= 7357 && c <= 7359)
                  : c <= 7404)))))
            : (c <= 7411 || (c < 8008
              ? (c < 7680
                ? (c < 7418
                  ? (c >= 7413 && c <= 7414)
                  : (c <= 7418 || (c >= 7424 && c <= 7615)))
                : (c <= 7957 || (c < 7968
                  ? (c >= 7960 && c <= 7965)
                  : c <= 8005)))
              : (c <= 8013 || (c < 8027
                ? (c < 8025
                  ? (c >= 8016 && c <= 8023)
                  : c <= 8025)
                : (c <= 8027 || (c < 8031
                  ? c == 8029
                  : c <= 8061)))))))
          : (c <= 8116 || (c < 8455
            ? (c < 8160
              ? (c < 8134
                ? (c < 8126
                  ? (c >= 8118 && c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))
                : (c <= 8140 || (c < 8150
                  ? (c >= 8144 && c <= 8147)
                  : c <= 8155)))
              : (c <= 8172 || (c < 8319
                ? (c < 8182
                  ? (c >= 8178 && c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8450
                  ? (c >= 8336 && c <= 8348)
                  : c <= 8450)))))
            : (c <= 8455 || (c < 8490
              ? (c < 8484
                ? (c < 8469
                  ? (c >= 8458 && c <= 8467)
                  : (c <= 8469 || (c >= 8473 && c <= 8477)))
                : (c <= 8484 || (c < 8488
                  ? c == 8486
                  : c <= 8488)))
              : (c <= 8493 || (c < 8517
                ? (c < 8508
                  ? (c >= 8495 && c <= 8505)
                  : c <= 8511)
                : (c <= 8521 || (c < 8579
                  ? c == 8526
                  : c <= 8580)))))))))
        : (c <= 11310 || (c < 12549
          ? (c < 11704
            ? (c < 11565
              ? (c < 11506
                ? (c < 11360
                  ? (c >= 11312 && c <= 11358)
                  : (c <= 11492 || (c >= 11499 && c <= 11502)))
                : (c <= 11507 || (c < 11559
                  ? (c >= 11520 && c <= 11557)
                  : c <= 11559)))
              : (c <= 11565 || (c < 11680
                ? (c < 11631
                  ? (c >= 11568 && c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))
                : (c <= 11686 || (c < 11696
                  ? (c >= 11688 && c <= 11694)
                  : c <= 11702)))))
            : (c <= 11710 || (c < 12337
              ? (c < 11736
                ? (c < 11720
                  ? (c >= 11712 && c <= 11718)
                  : (c <= 11726 || (c >= 11728 && c <= 11734)))
                : (c <= 11742 || (c < 12293
                  ? c == 11823
                  : c <= 12294)))
              : (c <= 12341 || (c < 12445
                ? (c < 12353
                  ? (c >= 12347 && c <= 12348)
                  : c <= 12438)
                : (c <= 12447 || (c < 12540
                  ? (c >= 12449 && c <= 12538)
                  : c <= 12543)))))))
          : (c <= 12591 || (c < 42623
            ? (c < 40956
              ? (c < 13312
                ? (c < 12704
                  ? (c >= 12593 && c <= 12686)
                  : (c <= 12735 || (c >= 12784 && c <= 12799)))
                : (c <= 13312 || (c < 19968
                  ? c == 19903
                  : c <= 19968)))
              : (c <= 40956 || (c < 42512
                ? (c < 42192
                  ? (c >= 40960 && c <= 42124)
                  : (c <= 42237 || (c >= 42240 && c <= 42508)))
                : (c <= 42527 || (c < 42560
                  ? (c >= 42538 && c <= 42539)
                  : c <= 42606)))))
            : (c <= 42653 || (c < 43011
              ? (c < 42891
                ? (c < 42775
                  ? (c >= 42656 && c <= 42725)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))
                : (c <= 42943 || (c < 42997
                  ? (c >= 42946 && c <= 42954)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67828
            ? (c < 67639
              ? (c < 67584
                ? (c < 67392
                  ? (c >= 67072 && c <= 67382)
                  : (c <= 67413 || (c >= 67424 && c <= 67431)))
                : (c <= 67589 || (c < 67594
                  ? c == 67592
                  : c <= 67637)))
              : (c <= 67640 || (c < 67680
                ? (c < 67647
                  ? c == 67644
                  : c <= 67669)
                : (c <= 67702 || (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)))))
            : (c <= 67829 || (c < 68117
              ? (c < 68030
                ? (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : (c <= 67897 || (c >= 67968 && c <= 68023)))
                : (c <= 68031 || (c < 68112
                  ? c == 68096
                  : c <= 68115)))
              : (c <= 68119 || (c < 68224
                ? (c < 68192
                  ? (c >= 68121 && c <= 68149)
                  : c <= 68220)
                : (c <= 68252 || (c < 68297
                  ? (c >= 68288 && c <= 68295)
                  : c <= 68309)))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1369
          ? (c < 750
            ? (c < 186
              ? (c < 'a'
                ? (c < 'A'
                  ? c == '$'
                  : (c <= 'Z' || c == '_'))
                : (c <= 'z' || (c < 181
                  ? c == 170
                  : c <= 181)))
              : (c <= 186 || (c < 710
                ? (c < 216
                  ? (c >= 192 && c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 748
                  ? (c >= 736 && c <= 740)
                  : c <= 748)))))
            : (c <= 750 || (c < 908
              ? (c < 895
                ? (c < 886
                  ? (c >= 880 && c <= 884)
                  : (c <= 887 || (c >= 890 && c <= 893)))
                : (c <= 895 || (c < 904
                  ? c == 902
                  : c <= 906)))
              : (c <= 908 || (c < 1015
                ? (c < 931
                  ? (c >= 910 && c <= 929)
                  : c <= 1013)
                : (c <= 1153 || (c < 1329
                  ? (c >= 1162 && c <= 1327)
                  : c <= 1366)))))))
          : (c <= 1369 || (c < 1869
            ? (c < 1749
              ? (c < 1568
                ? (c < 1488
                  ? (c >= 1376 && c <= 1416)
                  : (c <= 1514 || (c >= 1519 && c <= 1522)))
                : (c <= 1610 || (c < 1649
                  ? (c >= 1646 && c <= 1647)
                  : c <= 1747)))
              : (c <= 1749 || (c < 1791
                ? (c < 1774
                  ? (c >= 1765 && c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1810
                  ? c == 1808
                  : c <= 1839)))))
            : (c <= 1957 || (c < 2084
              ? (c < 2042
                ? (c < 1994
                  ? c == 1969
                  : (c <= 2026 || (c >= 2036 && c <= 2037)))
                : (c <= 2042 || (c < 2074
                  ? (c >= 2048 && c <= 2069)
                  : c <= 2074)))
              : (c <= 2084 || (c < 2144
                ? (c < 2112
                  ? c == 2088
                  : c <= 2136)
                : (c <= 2154 || (c < 2230
                  ? (c >= 2208 && c <= 2228)
                  : c <= 2247)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4176
        ? (c < 3423
          ? (c < 3218
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3200
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || (c >= 3168 && c <= 3169)))
                : (c <= 3200 || (c < 3214
                  ? (c >= 3205 && c <= 3212)
                  : c <= 3216)))))
            : (c <= 3240 || (c < 3332
              ? (c < 3294
                ? (c < 3253
                  ? (c >= 3242 && c <= 3251)
                  : (c <= 3257 || c == 3261))
                : (c <= 3294 || (c < 3313
                  ? (c >= 3296 && c <= 3297)
                  : c <= 3314)))
              : (c <= 3340 || (c < 3389
                ? (c < 3346
                  ? (c >= 3342 && c <= 3344)
                  : c <= 3386)
                : (c <= 3389 || (c < 3412
                  ? c == 3406
                  : c <= 3414)))))))
          : (c <= 3425 || (c < 3749
            ? (c < 3585
              ? (c < 3507
                ? (c < 3461
                  ? (c >= 3450 && c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3520
                  ? c == 3517
                  : c <= 3526)))
              : (c <= 3632 || (c < 3716
                ? (c < 3648
                  ? (c >= 3634 && c <= 3635)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))
                : (c <= 3716 || (c < 3724
                  ? (c >= 3718 && c <= 3722)
                  : c <= 3747)))))
            : (c <= 3749 || (c < 3840
              ? (c < 3776
                ? (c < 3762
                  ? (c >= 3751 && c <= 3760)
                  : (c <= 3763 || c == 3773))
                : (c <= 3780 || (c < 3804
                  ? c == 3782
                  : c <= 3807)))
              : (c <= 3840 || (c < 3976
                ? (c < 3913
                  ? (c >= 3904 && c <= 3911)
                  : c <= 3948)
                : (c <= 3980 || (c < 4159
                  ? (c >= 4096 && c <= 4138)
                  : c <= 4159)))))))))
        : (c <= 4181 || (c < 4992
          ? (c < 4696
            ? (c < 4256
              ? (c < 4206
                ? (c < 4193
                  ? (c >= 4186 && c <= 4189)
                  : (c <= 4193 || (c >= 4197 && c <= 4198)))
                : (c <= 4208 || (c < 4238
                  ? (c >= 4213 && c <= 4225)
                  : c <= 4238)))
              : (c <= 4293 || (c < 4348
                ? (c < 4301
                  ? c == 4295
                  : (c <= 4301 || (c >= 4304 && c <= 4346)))
                : (c <= 4680 || (c < 4688
                  ? (c >= 4682 && c <= 4685)
                  : c <= 4694)))))
            : (c <= 4696 || (c < 4800
              ? (c < 4752
                ? (c < 4704
                  ? (c >= 4698 && c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4792
                  ? (c >= 4786 && c <= 4789)
                  : c <= 4798)))
              : (c <= 4800 || (c < 4824
                ? (c < 4808
                  ? (c >= 4802 && c <= 4805)
                  : c <= 4822)
                : (c <= 4880 || (c < 4888
                  ? (c >= 4882 && c <= 4885)
                  : c <= 4954)))))))
          : (c <= 5007 || (c < 6016
            ? (c < 5873
              ? (c < 5743
                ? (c < 5112
                  ? (c >= 5024 && c <= 5109)
                  : (c <= 5117 || (c >= 5121 && c <= 5740)))
                : (c <= 5759 || (c < 5792
                  ? (c >= 5761 && c <= 5786)
                  : c <= 5866)))
              : (c <= 5880 || (c < 5952
                ? (c < 5902
                  ? (c >= 5888 && c <= 5900)
                  : (c <= 5905 || (c >= 5920 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43250
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6987 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12540
          ? (c < 11696
            ? (c < 11559
              ? (c < 11499
                ? (c < 11312
                  ? (c >= 11264 && c <= 11310)
                  : (c <= 11358 || (c >= 11360 && c <= 11492)))
                : (c <= 11502 || (c < 11520
                  ? (c >= 11506 && c <= 11507)
                  : c <= 11557)))
              : (c <= 11559 || (c < 11648
                ? (c < 11568
                  ? c == 11565
                  : (c <= 11623 || c == 11631))
                : (c <= 11670 || (c < 11688
                  ? (c >= 11680 && c <= 11686)
                  : c <= 11694)))))
            : (c <= 11702 || (c < 12293
              ? (c < 11728
                ? (c < 11712
                  ? (c >= 11704 && c <= 11710)
                  : (c <= 11718 || (c >= 11720 && c <= 11726)))
                : (c <= 11734 || (c < 11823
                  ? (c >= 11736 && c <= 11742)
                  : c <= 11823)))
              : (c <= 12294 || (c < 12353
                ? (c < 12347
                  ? (c >= 12337 && c <= 12341)
                  : c <= 12348)
                : (c <= 12438 || (c < 12449
                  ? (c >= 12445 && c <= 12447)
                  : c <= 12538)))))))
          : (c <= 12543 || (c < 42560
            ? (c < 19968
              ? (c < 12784
                ? (c < 12593
                  ? (c >= 12549 && c <= 12591)
                  : (c <= 12686 || (c >= 12704 && c <= 12735)))
                : (c <= 12799 || (c < 19903
                  ? c == 13312
                  : c <= 19903)))
              : (c <= 19968 || (c < 42240
                ? (c < 40960
                  ? c == 40956
                  : (c <= 42124 || (c >= 42192 && c <= 42237)))
                : (c <= 42508 || (c < 42538
                  ? (c >= 42512 && c <= 42527)
                  : c <= 42539)))))
            : (c <= 42606 || (c < 42997
              ? (c < 42786
                ? (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : (c <= 42725 || (c >= 42775 && c <= 42783)))
                : (c <= 42888 || (c < 42946
                  ? (c >= 42891 && c <= 42943)
                  : c <= 42954)))
              : (c <= 43009 || (c < 43020
                ? (c < 43015
                  ? (c >= 43011 && c <= 43013)
                  : c <= 43018)
                : (c <= 43042 || (c < 43138
                  ? (c >= 43072 && c <= 43123)
                  : c <= 43187)))))))))))
      : (c <= 43255 || (c < 65142
        ? (c < 43793
          ? (c < 43616
            ? (c < 43471
              ? (c < 43312
                ? (c < 43261
                  ? c == 43259
                  : (c <= 43262 || (c >= 43274 && c <= 43301)))
                : (c <= 43334 || (c < 43396
                  ? (c >= 43360 && c <= 43388)
                  : c <= 43442)))
              : (c <= 43471 || (c < 43520
                ? (c < 43494
                  ? (c >= 43488 && c <= 43492)
                  : (c <= 43503 || (c >= 43514 && c <= 43518)))
                : (c <= 43560 || (c < 43588
                  ? (c >= 43584 && c <= 43586)
                  : c <= 43595)))))
            : (c <= 43638 || (c < 43714
              ? (c < 43701
                ? (c < 43646
                  ? c == 43642
                  : (c <= 43695 || c == 43697))
                : (c <= 43702 || (c < 43712
                  ? (c >= 43705 && c <= 43709)
                  : c <= 43712)))
              : (c <= 43714 || (c < 43762
                ? (c < 43744
                  ? (c >= 43739 && c <= 43741)
                  : c <= 43754)
                : (c <= 43764 || (c < 43785
                  ? (c >= 43777 && c <= 43782)
                  : c <= 43790)))))))
          : (c <= 43798 || (c < 64285
            ? (c < 55203
              ? (c < 43868
                ? (c < 43816
                  ? (c >= 43808 && c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))
                : (c <= 43881 || (c < 44032
                  ? (c >= 43888 && c <= 44002)
                  : c <= 44032)))
              : (c <= 55203 || (c < 64112
                ? (c < 55243
                  ? (c >= 55216 && c <= 55238)
                  : (c <= 55291 || (c >= 63744 && c <= 64109)))
                : (c <= 64217 || (c < 64275
                  ? (c >= 64256 && c <= 64262)
                  : c <= 64279)))))
            : (c <= 64285 || (c < 64326
              ? (c < 64318
                ? (c < 64298
                  ? (c >= 64287 && c <= 64296)
                  : (c <= 64310 || (c >= 64312 && c <= 64316)))
                : (c <= 64318 || (c < 64323
                  ? (c >= 64320 && c <= 64321)
                  : c <= 64324)))
              : (c <= 64433 || (c < 64914
                ? (c < 64848
                  ? (c >= 64467 && c <= 64829)
                  : c <= 64911)
                : (c <= 64967 || (c < 65136
                  ? (c >= 65008 && c <= 65019)
                  : c <= 65140)))))))))
        : (c <= 65276 || (c < 66816
          ? (c < 65664
            ? (c < 65498
              ? (c < 65474
                ? (c < 65345
                  ? (c >= 65313 && c <= 65338)
                  : (c <= 65370 || (c >= 65382 && c <= 65470)))
                : (c <= 65479 || (c < 65490
                  ? (c >= 65482 && c <= 65487)
                  : c <= 65495)))
              : (c <= 65500 || (c < 65596
                ? (c < 65549
                  ? (c >= 65536 && c <= 65547)
                  : (c <= 65574 || (c >= 65576 && c <= 65594)))
                : (c <= 65597 || (c < 65616
                  ? (c >= 65599 && c <= 65613)
                  : c <= 65629)))))
            : (c <= 65786 || (c < 66432
              ? (c < 66349
                ? (c < 66208
                  ? (c >= 66176 && c <= 66204)
                  : (c <= 66256 || (c >= 66304 && c <= 66335)))
                : (c <= 66368 || (c < 66384
                  ? (c >= 66370 && c <= 66377)
                  : c <= 66421)))
              : (c <= 66461 || (c < 66560
                ? (c < 66504
                  ? (c >= 66464 && c <= 66499)
                  : c <= 66511)
                : (c <= 66717 || (c < 66776
                  ? (c >= 66736 && c <= 66771)
                  : c <= 66811)))))))
          : (c <= 66855 || (c < 67828
            ? (c < 67594
              ? (c < 67424
                ? (c < 67072
                  ? (c >= 66864 && c <= 66915)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : c <= 67592)))
              : (c <= 67637 || (c < 67680
                ? (c < 67644
                  ? (c >= 67639 && c <= 67640)
                  : (c <= 67644 || (c >= 67647 && c <= 67669)))
                : (c <= 67702 || (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)))))
            : (c <= 67829 || (c < 68117
              ? (c < 68030
                ? (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : (c <= 67897 || (c >= 67968 && c <= 68023)))
                : (c <= 68031 || (c < 68112
                  ? c == 68096
                  : c <= 68115)))
              : (c <= 68119 || (c < 68224
                ? (c < 68192
                  ? (c >= 68121 && c <= 68149)
                  : c <= 68220)
                : (c <= 68252 || (c < 68297
                  ? (c >= 68288 && c <= 68295)
                  : c <= 68309)))))))))))))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 6400
    ? (c < 2984
      ? (c < 2384
        ? (c < 1376
          ? (c < 750
            ? (c < 186
              ? (c < '_'
                ? (c < '0'
                  ? c == '$'
                  : (c <= '9' || (c >= 'A' && c <= 'Z')))
                : (c <= '_' || (c < 170
                  ? (c >= 'a' && c <= 'z')
                  : (c <= 170 || c == 181))))
              : (c <= 186 || (c < 710
                ? (c < 216
                  ? (c >= 192 && c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 748
                  ? (c >= 736 && c <= 740)
                  : c <= 748)))))
            : (c <= 750 || (c < 908
              ? (c < 895
                ? (c < 886
                  ? (c >= 880 && c <= 884)
                  : (c <= 887 || (c >= 890 && c <= 893)))
                : (c <= 895 || (c < 904
                  ? c == 902
                  : c <= 906)))
              : (c <= 908 || (c < 1162
                ? (c < 931
                  ? (c >= 910 && c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1749
              ? (c < 1632
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1641 || (c < 1649
                  ? (c >= 1646 && c <= 1647)
                  : c <= 1747)))
              : (c <= 1749 || (c < 1808
                ? (c < 1774
                  ? (c >= 1765 && c <= 1766)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1984 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2230
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : (c <= 2154 || (c >= 2208 && c <= 2228)))
                : (c <= 2247 || (c < 2365
                  ? (c >= 2308 && c <= 2361)
                  : c <= 2365)))))))))
        : (c <= 2384 || (c < 2707
          ? (c < 2556
            ? (c < 2482
              ? (c < 2437
                ? (c < 2406
                  ? (c >= 2392 && c <= 2401)
                  : (c <= 2415 || (c >= 2417 && c <= 2432)))
                : (c <= 2444 || (c < 2451
                  ? (c >= 2447 && c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))
              : (c <= 2482 || (c < 2524
                ? (c < 2493
                  ? (c >= 2486 && c <= 2489)
                  : (c <= 2493 || c == 2510))
                : (c <= 2525 || (c < 2534
                  ? (c >= 2527 && c <= 2529)
                  : c <= 2545)))))
            : (c <= 2556 || (c < 2616
              ? (c < 2602
                ? (c < 2575
                  ? (c >= 2565 && c <= 2570)
                  : (c <= 2576 || (c >= 2579 && c <= 2600)))
                : (c <= 2608 || (c < 2613
                  ? (c >= 2610 && c <= 2611)
                  : c <= 2614)))
              : (c <= 2617 || (c < 2674
                ? (c < 2654
                  ? (c >= 2649 && c <= 2652)
                  : (c <= 2654 || (c >= 2662 && c <= 2671)))
                : (c <= 2676 || (c < 2703
                  ? (c >= 2693 && c <= 2701)
                  : c <= 2705)))))))
          : (c <= 2728 || (c < 2869
            ? (c < 2790
              ? (c < 2749
                ? (c < 2738
                  ? (c >= 2730 && c <= 2736)
                  : (c <= 2739 || (c >= 2741 && c <= 2745)))
                : (c <= 2749 || (c < 2784
                  ? c == 2768
                  : c <= 2785)))
              : (c <= 2799 || (c < 2835
                ? (c < 2821
                  ? c == 2809
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))
                : (c <= 2856 || (c < 2866
                  ? (c >= 2858 && c <= 2864)
                  : c <= 2867)))))
            : (c <= 2873 || (c < 2949
              ? (c < 2918
                ? (c < 2908
                  ? c == 2877
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))
                : (c <= 2927 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2972
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : (c <= 2965 || (c >= 2969 && c <= 2970)))
                : (c <= 2972 || (c < 2979
                  ? (c >= 2974 && c <= 2975)
                  : c <= 2980)))))))))))
      : (c <= 2986 || (c < 3913
        ? (c < 3423
          ? (c < 3218
            ? (c < 3133
              ? (c < 3077
                ? (c < 3024
                  ? (c >= 2990 && c <= 3001)
                  : (c <= 3024 || (c >= 3046 && c <= 3055)))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : (c <= 3112 || (c >= 3114 && c <= 3129)))))
              : (c <= 3133 || (c < 3200
                ? (c < 3168
                  ? (c >= 3160 && c <= 3162)
                  : (c <= 3169 || (c >= 3174 && c <= 3183)))
                : (c <= 3200 || (c < 3214
                  ? (c >= 3205 && c <= 3212)
                  : c <= 3216)))))
            : (c <= 3240 || (c < 3313
              ? (c < 3294
                ? (c < 3253
                  ? (c >= 3242 && c <= 3251)
                  : (c <= 3257 || c == 3261))
                : (c <= 3294 || (c < 3302
                  ? (c >= 3296 && c <= 3297)
                  : c <= 3311)))
              : (c <= 3314 || (c < 3389
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : (c <= 3344 || (c >= 3346 && c <= 3386)))
                : (c <= 3389 || (c < 3412
                  ? c == 3406
                  : c <= 3414)))))))
          : (c <= 3425 || (c < 3716
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3430 && c <= 3439)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3648
                ? (c < 3585
                  ? (c >= 3558 && c <= 3567)
                  : (c <= 3632 || (c >= 3634 && c <= 3635)))
                : (c <= 3654 || (c < 3713
                  ? (c >= 3664 && c <= 3673)
                  : c <= 3714)))))
            : (c <= 3716 || (c < 3776
              ? (c < 3751
                ? (c < 3724
                  ? (c >= 3718 && c <= 3722)
                  : (c <= 3747 || c == 3749))
                : (c <= 3760 || (c < 3773
                  ? (c >= 3762 && c <= 3763)
                  : c <= 3773)))
              : (c <= 3780 || (c < 3840
                ? (c < 3792
                  ? c == 3782
                  : (c <= 3801 || (c >= 3804 && c <= 3807)))
                : (c <= 3840 || (c < 3904
                  ? (c >= 3872 && c <= 3881)
                  : c <= 3911)))))))))
        : (c <= 3948 || (c < 4808
          ? (c < 4301
            ? (c < 4197
              ? (c < 4176
                ? (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : (c <= 4138 || (c >= 4159 && c <= 4169)))
                : (c <= 4181 || (c < 4193
                  ? (c >= 4186 && c <= 4189)
                  : c <= 4193)))
              : (c <= 4198 || (c < 4240
                ? (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : (c <= 4225 || c == 4238))
                : (c <= 4249 || (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : c <= 4295)))))
            : (c <= 4301 || (c < 4704
              ? (c < 4688
                ? (c < 4348
                  ? (c >= 4304 && c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))
                : (c <= 4694 || (c < 4698
                  ? c == 4696
                  : c <= 4701)))
              : (c <= 4744 || (c < 4792
                ? (c < 4752
                  ? (c >= 4746 && c <= 4749)
                  : (c <= 4784 || (c >= 4786 && c <= 4789)))
                : (c <= 4798 || (c < 4802
                  ? c == 4800
                  : c <= 4805)))))))
          : (c <= 4822 || (c < 5920
            ? (c < 5121
              ? (c < 4992
                ? (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : (c <= 4885 || (c >= 4888 && c <= 4954)))
                : (c <= 5007 || (c < 5112
                  ? (c >= 5024 && c <= 5109)
                  : c <= 5117)))
              : (c <= 5740 || (c < 5873
                ? (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : (c <= 5786 || (c >= 5792 && c <= 5866)))
                : (c <= 5880 || (c < 5902
                  ? (c >= 5888 && c <= 5900)
                  : c <= 5905)))))
            : (c <= 5937 || (c < 6112
              ? (c < 6016
                ? (c < 5984
                  ? (c >= 5952 && c <= 5969)
                  : (c <= 5996 || (c >= 5998 && c <= 6000)))
                : (c <= 6067 || (c < 6108
                  ? c == 6103
                  : c <= 6108)))
              : (c <= 6121 || (c < 6279
                ? (c < 6176
                  ? (c >= 6160 && c <= 6169)
                  : (c <= 6264 || (c >= 6272 && c <= 6276)))
                : (c <= 6312 || (c < 6320
                  ? c == 6314
                  : c <= 6389)))))))))))))
    : (c <= 6430 || (c < 43138
      ? (c < 8490
        ? (c < 7968
          ? (c < 7086
            ? (c < 6784
              ? (c < 6576
                ? (c < 6512
                  ? (c >= 6470 && c <= 6509)
                  : (c <= 6516 || (c >= 6528 && c <= 6571)))
                : (c <= 6601 || (c < 6656
                  ? (c >= 6608 && c <= 6617)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6793 || (c < 6981
                ? (c < 6823
                  ? (c >= 6800 && c <= 6809)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6987 || (c < 7043
                  ? (c >= 6992 && c <= 7001)
                  : c <= 7072)))))
            : (c <= 7141 || (c < 7401
              ? (c < 7296
                ? (c < 7232
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7241 || (c >= 7245 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))
              : (c <= 7404 || (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))))))
          : (c <= 8005 || (c < 8160
            ? (c < 8064
              ? (c < 8027
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : (c <= 8023 || c == 8025))
                : (c <= 8027 || (c < 8031
                  ? c == 8029
                  : c <= 8061)))
              : (c <= 8116 || (c < 8134
                ? (c < 8126
                  ? (c >= 8118 && c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))
                : (c <= 8140 || (c < 8150
                  ? (c >= 8144 && c <= 8147)
                  : c <= 8155)))))
            : (c <= 8172 || (c < 8455
              ? (c < 8319
                ? (c < 8182
                  ? (c >= 8178 && c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8450
                  ? (c >= 8336 && c <= 8348)
                  : c <= 8450)))
              : (c <= 8455 || (c < 8484
                ? (c < 8469
                  ? (c >= 8458 && c <= 8467)
                  : (c <= 8469 || (c >= 8473 && c <= 8477)))
                : (c <= 8484 || (c < 8488
                  ? c == 8486
                  : c <= 8488)))))))))
        : (c <= 8493 || (c < 12353
          ? (c < 11631
            ? (c < 11360
              ? (c < 8526
                ? (c < 8508
                  ? (c >= 8495 && c <= 8505)
                  : (c <= 8511 || (c >= 8517 && c <= 8521)))
                : (c <= 8526 || (c < 11264
                  ? (c >= 8579 && c <= 8580)
                  : (c <= 11310 || (c >= 11312 && c <= 11358)))))
              : (c <= 11492 || (c < 11559
                ? (c < 11506
                  ? (c >= 11499 && c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11568
                  ? c == 11565
                  : c <= 11623)))))
            : (c <= 11631 || (c < 11720
              ? (c < 11696
                ? (c < 11680
                  ? (c >= 11648 && c <= 11670)
                  : (c <= 11686 || (c >= 11688 && c <= 11694)))
                : (c <= 11702 || (c < 11712
                  ? (c >= 11704 && c <= 11710)
                  : c <= 11718)))
              : (c <= 11726 || (c < 12293
                ? (c < 11736
                  ? (c >= 11728 && c <= 11734)
                  : (c <= 11742 || c == 11823))
                : (c <= 12294 || (c < 12347
                  ? (c >= 12337 && c <= 12341)
                  : c <= 12348)))))))
          : (c <= 12438 || (c < 42240
            ? (c < 12784
              ? (c < 12549
                ? (c < 12449
                  ? (c >= 12445 && c <= 12447)
                  : (c <= 12538 || (c >= 12540 && c <= 12543)))
                : (c <= 12591 || (c < 12704
                  ? (c >= 12593 && c <= 12686)
                  : c <= 12735)))
              : (c <= 12799 || (c < 40956
                ? (c < 19903
                  ? c == 13312
                  : (c <= 19903 || c == 19968))
                : (c <= 40956 || (c < 42192
                  ? (c >= 40960 && c <= 42124)
                  : c <= 42237)))))
            : (c <= 42508 || (c < 42891
              ? (c < 42656
                ? (c < 42560
                  ? (c >= 42512 && c <= 42539)
                  : (c <= 42606 || (c >= 42623 && c <= 42653)))
                : (c <= 42725 || (c < 42786
                  ? (c >= 42775 && c <= 42783)
                  : c <= 42888)))
              : (c <= 42943 || (c < 43015
                ? (c < 42997
                  ? (c >= 42946 && c <= 42954)
                  : (c <= 43009 || (c >= 43011 && c <= 43013)))
                : (c <= 43018 || (c < 43072
                  ? (c >= 43020 && c <= 43042)
                  : c <= 43123)))))))))))
      : (c <= 43187 || (c < 65142
        ? (c < 43793
          ? (c < 43600
            ? (c < 43396
              ? (c < 43261
                ? (c < 43250
                  ? (c >= 43216 && c <= 43225)
                  : (c <= 43255 || c == 43259))
                : (c <= 43262 || (c < 43312
                  ? (c >= 43264 && c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))))
              : (c <= 43442 || (c < 43520
                ? (c < 43488
                  ? (c >= 43471 && c <= 43481)
                  : (c <= 43492 || (c >= 43494 && c <= 43518)))
                : (c <= 43560 || (c < 43588
                  ? (c >= 43584 && c <= 43586)
                  : c <= 43595)))))
            : (c <= 43609 || (c < 43712
              ? (c < 43697
                ? (c < 43642
                  ? (c >= 43616 && c <= 43638)
                  : (c <= 43642 || (c >= 43646 && c <= 43695)))
                : (c <= 43697 || (c < 43705
                  ? (c >= 43701 && c <= 43702)
                  : c <= 43709)))
              : (c <= 43712 || (c < 43762
                ? (c < 43739
                  ? c == 43714
                  : (c <= 43741 || (c >= 43744 && c <= 43754)))
                : (c <= 43764 || (c < 43785
                  ? (c >= 43777 && c <= 43782)
                  : c <= 43790)))))))
          : (c <= 43798 || (c < 64275
            ? (c < 44032
              ? (c < 43868
                ? (c < 43816
                  ? (c >= 43808 && c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))
                : (c <= 43881 || (c < 44016
                  ? (c >= 43888 && c <= 44002)
                  : c <= 44025)))
              : (c <= 44032 || (c < 63744
                ? (c < 55216
                  ? c == 55203
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64256
                  ? (c >= 64112 && c <= 64217)
                  : c <= 64262)))))
            : (c <= 64279 || (c < 64323
              ? (c < 64312
                ? (c < 64287
                  ? c == 64285
                  : (c <= 64296 || (c >= 64298 && c <= 64310)))
                : (c <= 64316 || (c < 64320
                  ? c == 64318
                  : c <= 64321)))
              : (c <= 64324 || (c < 64914
                ? (c < 64467
                  ? (c >= 64326 && c <= 64433)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))
                : (c <= 64967 || (c < 65136
                  ? (c >= 65008 && c <= 65019)
                  : c <= 65140)))))))))
        : (c <= 65276 || (c < 66776
          ? (c < 65616
            ? (c < 65490
              ? (c < 65382
                ? (c < 65313
                  ? (c >= 65296 && c <= 65305)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))
                : (c <= 65470 || (c < 65482
                  ? (c >= 65474 && c <= 65479)
                  : c <= 65487)))
              : (c <= 65495 || (c < 65576
                ? (c < 65536
                  ? (c >= 65498 && c <= 65500)
                  : (c <= 65547 || (c >= 65549 && c <= 65574)))
                : (c <= 65594 || (c < 65599
                  ? (c >= 65596 && c <= 65597)
                  : c <= 65613)))))
            : (c <= 65629 || (c < 66384
              ? (c < 66304
                ? (c < 66176
                  ? (c >= 65664 && c <= 65786)
                  : (c <= 66204 || (c >= 66208 && c <= 66256)))
                : (c <= 66335 || (c < 66370
                  ? (c >= 66349 && c <= 66368)
                  : c <= 66377)))
              : (c <= 66421 || (c < 66560
                ? (c < 66464
                  ? (c >= 66432 && c <= 66461)
                  : (c <= 66499 || (c >= 66504 && c <= 66511)))
                : (c <= 66717 || (c < 66736
                  ? (c >= 66720 && c <= 66729)
                  : c <= 66771)))))))
          : (c <= 66811 || (c < 67808
            ? (c < 67592
              ? (c < 67392
                ? (c < 66864
                  ? (c >= 66816 && c <= 66855)
                  : (c <= 66915 || (c >= 67072 && c <= 67382)))
                : (c <= 67413 || (c < 67584
                  ? (c >= 67424 && c <= 67431)
                  : c <= 67589)))
              : (c <= 67592 || (c < 67647
                ? (c < 67639
                  ? (c >= 67594 && c <= 67637)
                  : (c <= 67640 || c == 67644))
                : (c <= 67669 || (c < 67712
                  ? (c >= 67680 && c <= 67702)
                  : c <= 67742)))))
            : (c <= 67826 || (c < 68112
              ? (c < 67968
                ? (c < 67840
                  ? (c >= 67828 && c <= 67829)
                  : (c <= 67861 || (c >= 67872 && c <= 67897)))
                : (c <= 68023 || (c < 68096
                  ? (c >= 68030 && c <= 68031)
                  : c <= 68096)))
              : (c <= 68115 || (c < 68224
                ? (c < 68121
                  ? (c >= 68117 && c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))
                : (c <= 68252 || (c < 68297
                  ? (c >= 68288 && c <= 68295)
                  : c <= 68309)))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(52);
      if (lookahead == '!') ADVANCE(134);
      if (lookahead == '"') ADVANCE(6);
      if (lookahead == '%') ADVANCE(122);
      if (lookahead == '&') ADVANCE(81);
      if (lookahead == '\'') ADVANCE(23);
      if (lookahead == '(') ADVANCE(78);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '*') ADVANCE(113);
      if (lookahead == '+') ADVANCE(109);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(110);
      if (lookahead == '.') ADVANCE(142);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == '0') ADVANCE(54);
      if (lookahead == ':') ADVANCE(133);
      if (lookahead == ';') ADVANCE(147);
      if (lookahead == '<') ADVANCE(100);
      if (lookahead == '=') ADVANCE(84);
      if (lookahead == '>') ADVANCE(97);
      if (lookahead == '?') ADVANCE(131);
      if (lookahead == '@') ADVANCE(149);
      if (lookahead == '[') ADVANCE(138);
      if (lookahead == ']') ADVANCE(139);
      if (lookahead == '^') ADVANCE(120);
      if (lookahead == '{') ADVANCE(145);
      if (lookahead == '|') ADVANCE(117);
      if (lookahead == '}') ADVANCE(146);
      if (lookahead == '~') ADVANCE(135);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(55);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(152);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(1);
      if (lookahead == '"') ADVANCE(10);
      if (lookahead == '\\') ADVANCE(47);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1);
      if (lookahead != 0) ADVANCE(8);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(1);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(2);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(134);
      if (lookahead == '"') ADVANCE(6);
      if (lookahead == '%') ADVANCE(121);
      if (lookahead == '&') ADVANCE(80);
      if (lookahead == '\'') ADVANCE(23);
      if (lookahead == '(') ADVANCE(78);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '*') ADVANCE(112);
      if (lookahead == '+') ADVANCE(108);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(111);
      if (lookahead == '.') ADVANCE(17);
      if (lookahead == '/') ADVANCE(114);
      if (lookahead == '0') ADVANCE(54);
      if (lookahead == ':') ADVANCE(133);
      if (lookahead == ';') ADVANCE(147);
      if (lookahead == '<') ADVANCE(101);
      if (lookahead == '=') ADVANCE(84);
      if (lookahead == '>') ADVANCE(98);
      if (lookahead == '?') ADVANCE(131);
      if (lookahead == '@') ADVANCE(148);
      if (lookahead == '[') ADVANCE(138);
      if (lookahead == ']') ADVANCE(139);
      if (lookahead == '^') ADVANCE(119);
      if (lookahead == '{') ADVANCE(145);
      if (lookahead == '|') ADVANCE(118);
      if (lookahead == '}') ADVANCE(146);
      if (lookahead == '~') ADVANCE(135);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(55);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(152);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '%') ADVANCE(122);
      if (lookahead == '&') ADVANCE(81);
      if (lookahead == '(') ADVANCE(78);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '*') ADVANCE(113);
      if (lookahead == '+') ADVANCE(109);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(110);
      if (lookahead == '.') ADVANCE(141);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == ':') ADVANCE(133);
      if (lookahead == ';') ADVANCE(147);
      if (lookahead == '<') ADVANCE(100);
      if (lookahead == '=') ADVANCE(84);
      if (lookahead == '>') ADVANCE(97);
      if (lookahead == '?') ADVANCE(131);
      if (lookahead == '@') ADVANCE(148);
      if (lookahead == '[') ADVANCE(138);
      if (lookahead == ']') ADVANCE(139);
      if (lookahead == '^') ADVANCE(120);
      if (lookahead == '{') ADVANCE(145);
      if (lookahead == '|') ADVANCE(117);
      if (lookahead == '}') ADVANCE(146);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(152);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '%') ADVANCE(121);
      if (lookahead == '&') ADVANCE(80);
      if (lookahead == '(') ADVANCE(78);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '*') ADVANCE(112);
      if (lookahead == '+') ADVANCE(108);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(111);
      if (lookahead == '.') ADVANCE(140);
      if (lookahead == '/') ADVANCE(114);
      if (lookahead == ':') ADVANCE(133);
      if (lookahead == ';') ADVANCE(147);
      if (lookahead == '<') ADVANCE(101);
      if (lookahead == '=') ADVANCE(22);
      if (lookahead == '>') ADVANCE(98);
      if (lookahead == '?') ADVANCE(131);
      if (lookahead == '@') ADVANCE(148);
      if (lookahead == '[') ADVANCE(138);
      if (lookahead == ']') ADVANCE(139);
      if (lookahead == '^') ADVANCE(119);
      if (lookahead == '{') ADVANCE(145);
      if (lookahead == '|') ADVANCE(118);
      if (lookahead == '}') ADVANCE(146);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(152);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(49);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(7);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(75);
      if (lookahead == '\\') ADVANCE(49);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(7);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(10);
      if (lookahead == '\\') ADVANCE(47);
      if (lookahead != 0) ADVANCE(8);
      END_STATE();
    case 9:
      if (lookahead == '"') ADVANCE(77);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(9);
      END_STATE();
    case 11:
      if (lookahead == '&') ADVANCE(79);
      if (lookahead == '(') ADVANCE(78);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '.') ADVANCE(141);
      if (lookahead == '/') ADVANCE(14);
      if (lookahead == ':') ADVANCE(133);
      if (lookahead == ';') ADVANCE(147);
      if (lookahead == '<') ADVANCE(99);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(131);
      if (lookahead == '@') ADVANCE(148);
      if (lookahead == '[') ADVANCE(138);
      if (lookahead == '{') ADVANCE(145);
      if (lookahead == '|') ADVANCE(116);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(152);
      END_STATE();
    case 12:
      if (lookahead == '&') ADVANCE(79);
      if (lookahead == '(') ADVANCE(78);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '.') ADVANCE(140);
      if (lookahead == '/') ADVANCE(14);
      if (lookahead == ':') ADVANCE(20);
      if (lookahead == ';') ADVANCE(147);
      if (lookahead == '<') ADVANCE(99);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '@') ADVANCE(149);
      if (lookahead == '{') ADVANCE(145);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(152);
      END_STATE();
    case 13:
      if (lookahead == '\'') ADVANCE(74);
      if (lookahead == '\\') ADVANCE(48);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(13);
      END_STATE();
    case 14:
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == '/') ADVANCE(153);
      END_STATE();
    case 15:
      if (lookahead == '*') ADVANCE(15);
      if (lookahead == '/') ADVANCE(154);
      if (lookahead != 0) ADVANCE(16);
      END_STATE();
    case 16:
      if (lookahead == '*') ADVANCE(15);
      if (lookahead != 0) ADVANCE(16);
      END_STATE();
    case 17:
      if (lookahead == '.') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 18:
      if (lookahead == '.') ADVANCE(151);
      END_STATE();
    case 19:
      if (lookahead == '.') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      END_STATE();
    case 20:
      if (lookahead == ':') ADVANCE(144);
      END_STATE();
    case 21:
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 22:
      if (lookahead == '=') ADVANCE(104);
      END_STATE();
    case 23:
      if (lookahead == '\\') ADVANCE(48);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(13);
      END_STATE();
    case 24:
      if (lookahead == '_') ADVANCE(24);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(55);
      END_STATE();
    case 25:
      if (lookahead == '_') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 26:
      if (lookahead == '_') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 27:
      if (lookahead == '_') ADVANCE(28);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(57);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      END_STATE();
    case 28:
      if (lookahead == '_') ADVANCE(28);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      END_STATE();
    case 29:
      if (lookahead == '_') ADVANCE(28);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(31);
      END_STATE();
    case 31:
      if (lookahead == 'c') ADVANCE(33);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 34:
      if (lookahead == 'f') ADVANCE(30);
      END_STATE();
    case 35:
      if (lookahead == 'n') ADVANCE(37);
      END_STATE();
    case 36:
      if (lookahead == 'r') ADVANCE(34);
      END_STATE();
    case 37:
      if (lookahead == 't') ADVANCE(32);
      END_STATE();
    case 38:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 39:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      END_STATE();
    case 40:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(63);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(61);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      END_STATE();
    case 47:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(8);
      END_STATE();
    case 48:
      if (lookahead != 0) ADVANCE(13);
      END_STATE();
    case 49:
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 50:
      if (eof) ADVANCE(52);
      if (lookahead == '!') ADVANCE(134);
      if (lookahead == '"') ADVANCE(6);
      if (lookahead == '%') ADVANCE(121);
      if (lookahead == '&') ADVANCE(80);
      if (lookahead == '\'') ADVANCE(23);
      if (lookahead == '(') ADVANCE(78);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '*') ADVANCE(112);
      if (lookahead == '+') ADVANCE(108);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(111);
      if (lookahead == '.') ADVANCE(143);
      if (lookahead == '/') ADVANCE(114);
      if (lookahead == '0') ADVANCE(54);
      if (lookahead == ':') ADVANCE(133);
      if (lookahead == ';') ADVANCE(147);
      if (lookahead == '<') ADVANCE(101);
      if (lookahead == '=') ADVANCE(22);
      if (lookahead == '>') ADVANCE(98);
      if (lookahead == '?') ADVANCE(131);
      if (lookahead == '@') ADVANCE(149);
      if (lookahead == '[') ADVANCE(138);
      if (lookahead == ']') ADVANCE(139);
      if (lookahead == '^') ADVANCE(119);
      if (lookahead == '{') ADVANCE(145);
      if (lookahead == '|') ADVANCE(118);
      if (lookahead == '}') ADVANCE(146);
      if (lookahead == '~') ADVANCE(135);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(50)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(55);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(152);
      END_STATE();
    case 51:
      if (eof) ADVANCE(52);
      if (lookahead == '!') ADVANCE(134);
      if (lookahead == '"') ADVANCE(6);
      if (lookahead == '%') ADVANCE(121);
      if (lookahead == '&') ADVANCE(80);
      if (lookahead == '\'') ADVANCE(23);
      if (lookahead == '(') ADVANCE(78);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '*') ADVANCE(112);
      if (lookahead == '+') ADVANCE(108);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(111);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(114);
      if (lookahead == '0') ADVANCE(54);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == ';') ADVANCE(147);
      if (lookahead == '<') ADVANCE(101);
      if (lookahead == '=') ADVANCE(22);
      if (lookahead == '>') ADVANCE(98);
      if (lookahead == '?') ADVANCE(131);
      if (lookahead == '@') ADVANCE(149);
      if (lookahead == ']') ADVANCE(139);
      if (lookahead == '^') ADVANCE(119);
      if (lookahead == '{') ADVANCE(145);
      if (lookahead == '|') ADVANCE(118);
      if (lookahead == '}') ADVANCE(146);
      if (lookahead == '~') ADVANCE(135);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(51)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(55);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(152);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(67);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(40);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(53);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(41);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(19);
      if (lookahead == '_') ADVANCE(24);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(38);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(38);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(55);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(67);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(53);
      if (lookahead == '_') ADVANCE(24);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(38);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(38);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(55);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(73);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(56);
      if (lookahead == '_') ADVANCE(27);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(59);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(39);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(57);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(73);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(56);
      if (lookahead == '_') ADVANCE(45);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(59);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(44);
      if (lookahead == '.') ADVANCE(73);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(56);
      if (lookahead == '_') ADVANCE(45);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(59);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(39);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(57);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(60);
      if (lookahead == '_') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(61);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(62);
      if (lookahead == '_') ADVANCE(40);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(63);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(25);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(38);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(26);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(38);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(46);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(72);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(29);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(72);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(39);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(28);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(68);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(44);
      if (lookahead == '_') ADVANCE(46);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(72);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(39);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(72);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_character_literal);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_string_literal);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_string_literal);
      if (lookahead == '"') ADVANCE(2);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_text_block);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(106);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(106);
      if (lookahead == '=') ADVANCE(89);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(104);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '>') ADVANCE(125);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '>') ADVANCE(126);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(124);
      if (lookahead == '=') ADVANCE(103);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(103);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(136);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == '=') ADVANCE(85);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(137);
      if (lookahead == '=') ADVANCE(86);
      if (lookahead == '>') ADVANCE(129);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(137);
      if (lookahead == '>') ADVANCE(129);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(87);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == '/') ADVANCE(153);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == '/') ADVANCE(153);
      if (lookahead == '=') ADVANCE(88);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '|') ADVANCE(107);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(107);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(91);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(92);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(93);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(94);
      if (lookahead == '>') ADVANCE(128);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(127);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(144);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(18);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == 'i') ADVANCE(35);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_ATinterface);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(152);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(153);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_block_comment);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'p') ADVANCE(12);
      if (lookahead == 'r') ADVANCE(13);
      if (lookahead == 's') ADVANCE(14);
      if (lookahead == 't') ADVANCE(15);
      if (lookahead == 'u') ADVANCE(16);
      if (lookahead == 'v') ADVANCE(17);
      if (lookahead == 'w') ADVANCE(18);
      if (lookahead == 'y') ADVANCE(19);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(20);
      if (lookahead == 's') ADVANCE(21);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(22);
      if (lookahead == 'r') ADVANCE(23);
      if (lookahead == 'y') ADVANCE(24);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(25);
      if (lookahead == 'h') ADVANCE(26);
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(32);
      if (lookahead == 'x') ADVANCE(33);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'i') ADVANCE(35);
      if (lookahead == 'l') ADVANCE(36);
      if (lookahead == 'o') ADVANCE(37);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(38);
      if (lookahead == 'm') ADVANCE(39);
      if (lookahead == 'n') ADVANCE(40);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 9:
      if (lookahead == 'o') ADVANCE(42);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(43);
      if (lookahead == 'e') ADVANCE(44);
      if (lookahead == 'u') ADVANCE(45);
      END_STATE();
    case 11:
      if (lookahead == 'p') ADVANCE(46);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(47);
      if (lookahead == 'r') ADVANCE(48);
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(50);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(51);
      if (lookahead == 't') ADVANCE(52);
      if (lookahead == 'u') ADVANCE(53);
      if (lookahead == 'w') ADVANCE(54);
      if (lookahead == 'y') ADVANCE(55);
      END_STATE();
    case 15:
      if (lookahead == 'h') ADVANCE(56);
      if (lookahead == 'o') ADVANCE(57);
      if (lookahead == 'r') ADVANCE(58);
      END_STATE();
    case 16:
      if (lookahead == 's') ADVANCE(59);
      END_STATE();
    case 17:
      if (lookahead == 'o') ADVANCE(60);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(62);
      END_STATE();
    case 19:
      if (lookahead == 'i') ADVANCE(63);
      END_STATE();
    case 20:
      if (lookahead == 's') ADVANCE(64);
      END_STATE();
    case 21:
      if (lookahead == 's') ADVANCE(65);
      END_STATE();
    case 22:
      if (lookahead == 'o') ADVANCE(66);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 24:
      if (lookahead == 't') ADVANCE(68);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(69);
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(71);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(72);
      END_STATE();
    case 28:
      if (lookahead == 'n') ADVANCE(73);
      END_STATE();
    case 29:
      if (lookahead == 'f') ADVANCE(74);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(75);
      END_STATE();
    case 31:
      if (lookahead == 's') ADVANCE(76);
      END_STATE();
    case 32:
      if (lookahead == 'u') ADVANCE(77);
      END_STATE();
    case 33:
      if (lookahead == 'p') ADVANCE(78);
      if (lookahead == 't') ADVANCE(79);
      END_STATE();
    case 34:
      if (lookahead == 'l') ADVANCE(80);
      END_STATE();
    case 35:
      if (lookahead == 'n') ADVANCE(81);
      END_STATE();
    case 36:
      if (lookahead == 'o') ADVANCE(82);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(83);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 39:
      if (lookahead == 'p') ADVANCE(84);
      END_STATE();
    case 40:
      if (lookahead == 's') ADVANCE(85);
      if (lookahead == 't') ADVANCE(86);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(87);
      END_STATE();
    case 42:
      if (lookahead == 'd') ADVANCE(88);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(89);
      END_STATE();
    case 44:
      if (lookahead == 'w') ADVANCE(90);
      END_STATE();
    case 45:
      if (lookahead == 'l') ADVANCE(91);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 47:
      if (lookahead == 'c') ADVANCE(93);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(94);
      if (lookahead == 'o') ADVANCE(95);
      END_STATE();
    case 49:
      if (lookahead == 'b') ADVANCE(96);
      END_STATE();
    case 50:
      if (lookahead == 'c') ADVANCE(97);
      if (lookahead == 'q') ADVANCE(98);
      if (lookahead == 't') ADVANCE(99);
      END_STATE();
    case 51:
      if (lookahead == 'o') ADVANCE(100);
      END_STATE();
    case 52:
      if (lookahead == 'a') ADVANCE(101);
      if (lookahead == 'r') ADVANCE(102);
      END_STATE();
    case 53:
      if (lookahead == 'p') ADVANCE(103);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(104);
      END_STATE();
    case 55:
      if (lookahead == 'n') ADVANCE(105);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(106);
      if (lookahead == 'r') ADVANCE(107);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_to);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(108);
      if (lookahead == 'u') ADVANCE(109);
      if (lookahead == 'y') ADVANCE(110);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(112);
      if (lookahead == 'l') ADVANCE(113);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(114);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(115);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(116);
      END_STATE();
    case 64:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 66:
      if (lookahead == 'l') ADVANCE(119);
      END_STATE();
    case 67:
      if (lookahead == 'a') ADVANCE(120);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(122);
      END_STATE();
    case 70:
      if (lookahead == 'c') ADVANCE(123);
      END_STATE();
    case 71:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 72:
      if (lookahead == 's') ADVANCE(125);
      END_STATE();
    case 73:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 74:
      if (lookahead == 'a') ADVANCE(127);
      END_STATE();
    case 75:
      if (lookahead == 'b') ADVANCE(128);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(129);
      END_STATE();
    case 77:
      if (lookahead == 'm') ADVANCE(130);
      END_STATE();
    case 78:
      if (lookahead == 'o') ADVANCE(131);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 80:
      if (lookahead == 's') ADVANCE(133);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(134);
      END_STATE();
    case 82:
      if (lookahead == 'a') ADVANCE(135);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 84:
      if (lookahead == 'l') ADVANCE(136);
      if (lookahead == 'o') ADVANCE(137);
      END_STATE();
    case 85:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 87:
      if (lookahead == 'g') ADVANCE(140);
      END_STATE();
    case 88:
      if (lookahead == 'u') ADVANCE(141);
      END_STATE();
    case 89:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 91:
      if (lookahead == 'l') ADVANCE(143);
      END_STATE();
    case 92:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 93:
      if (lookahead == 'k') ADVANCE(145);
      END_STATE();
    case 94:
      if (lookahead == 'v') ADVANCE(146);
      END_STATE();
    case 95:
      if (lookahead == 't') ADVANCE(147);
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 96:
      if (lookahead == 'l') ADVANCE(149);
      END_STATE();
    case 97:
      if (lookahead == 'o') ADVANCE(150);
      END_STATE();
    case 98:
      if (lookahead == 'u') ADVANCE(151);
      END_STATE();
    case 99:
      if (lookahead == 'u') ADVANCE(152);
      END_STATE();
    case 100:
      if (lookahead == 'r') ADVANCE(153);
      END_STATE();
    case 101:
      if (lookahead == 't') ADVANCE(154);
      END_STATE();
    case 102:
      if (lookahead == 'i') ADVANCE(155);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(156);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(157);
      END_STATE();
    case 105:
      if (lookahead == 'c') ADVANCE(158);
      END_STATE();
    case 106:
      if (lookahead == 's') ADVANCE(159);
      END_STATE();
    case 107:
      if (lookahead == 'o') ADVANCE(160);
      END_STATE();
    case 108:
      if (lookahead == 'n') ADVANCE(161);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 111:
      if (lookahead == 's') ADVANCE(163);
      END_STATE();
    case 112:
      if (lookahead == 'd') ADVANCE(164);
      END_STATE();
    case 113:
      if (lookahead == 'a') ADVANCE(165);
      END_STATE();
    case 114:
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 115:
      if (lookahead == 'h') ADVANCE(167);
      END_STATE();
    case 116:
      if (lookahead == 'l') ADVANCE(168);
      END_STATE();
    case 117:
      if (lookahead == 'r') ADVANCE(169);
      END_STATE();
    case 118:
      if (lookahead == 'r') ADVANCE(170);
      END_STATE();
    case 119:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 120:
      if (lookahead == 'k') ADVANCE(172);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_byte);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 123:
      if (lookahead == 'h') ADVANCE(173);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_char);
      END_STATE();
    case 125:
      if (lookahead == 's') ADVANCE(174);
      END_STATE();
    case 126:
      if (lookahead == 'i') ADVANCE(175);
      END_STATE();
    case 127:
      if (lookahead == 'u') ADVANCE(176);
      END_STATE();
    case 128:
      if (lookahead == 'l') ADVANCE(177);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 131:
      if (lookahead == 'r') ADVANCE(178);
      END_STATE();
    case 132:
      if (lookahead == 'n') ADVANCE(179);
      END_STATE();
    case 133:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 134:
      if (lookahead == 'l') ADVANCE(181);
      END_STATE();
    case 135:
      if (lookahead == 't') ADVANCE(182);
      END_STATE();
    case 136:
      if (lookahead == 'e') ADVANCE(183);
      END_STATE();
    case 137:
      if (lookahead == 'r') ADVANCE(184);
      END_STATE();
    case 138:
      if (lookahead == 'a') ADVANCE(185);
      END_STATE();
    case 139:
      if (lookahead == 'r') ADVANCE(186);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_long);
      END_STATE();
    case 141:
      if (lookahead == 'l') ADVANCE(187);
      END_STATE();
    case 142:
      if (lookahead == 'v') ADVANCE(188);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_null_literal);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_open);
      if (lookahead == 's') ADVANCE(189);
      END_STATE();
    case 145:
      if (lookahead == 'a') ADVANCE(190);
      END_STATE();
    case 146:
      if (lookahead == 'a') ADVANCE(191);
      END_STATE();
    case 147:
      if (lookahead == 'e') ADVANCE(192);
      END_STATE();
    case 148:
      if (lookahead == 'i') ADVANCE(193);
      END_STATE();
    case 149:
      if (lookahead == 'i') ADVANCE(194);
      END_STATE();
    case 150:
      if (lookahead == 'r') ADVANCE(195);
      END_STATE();
    case 151:
      if (lookahead == 'i') ADVANCE(196);
      END_STATE();
    case 152:
      if (lookahead == 'r') ADVANCE(197);
      END_STATE();
    case 153:
      if (lookahead == 't') ADVANCE(198);
      END_STATE();
    case 154:
      if (lookahead == 'i') ADVANCE(199);
      END_STATE();
    case 155:
      if (lookahead == 'c') ADVANCE(200);
      END_STATE();
    case 156:
      if (lookahead == 'r') ADVANCE(201);
      END_STATE();
    case 157:
      if (lookahead == 'c') ADVANCE(202);
      END_STATE();
    case 158:
      if (lookahead == 'h') ADVANCE(203);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 160:
      if (lookahead == 'w') ADVANCE(204);
      END_STATE();
    case 161:
      if (lookahead == 's') ADVANCE(205);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_uses);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_void_type);
      END_STATE();
    case 165:
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 166:
      if (lookahead == 'e') ADVANCE(207);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 168:
      if (lookahead == 'd') ADVANCE(208);
      END_STATE();
    case 169:
      if (lookahead == 'a') ADVANCE(209);
      END_STATE();
    case 170:
      if (lookahead == 't') ADVANCE(210);
      END_STATE();
    case 171:
      if (lookahead == 'a') ADVANCE(211);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 175:
      if (lookahead == 'n') ADVANCE(212);
      END_STATE();
    case 176:
      if (lookahead == 'l') ADVANCE(213);
      END_STATE();
    case 177:
      if (lookahead == 'e') ADVANCE(214);
      END_STATE();
    case 178:
      if (lookahead == 't') ADVANCE(215);
      END_STATE();
    case 179:
      if (lookahead == 'd') ADVANCE(216);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_final);
      if (lookahead == 'l') ADVANCE(217);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 183:
      if (lookahead == 'm') ADVANCE(218);
      END_STATE();
    case 184:
      if (lookahead == 't') ADVANCE(219);
      END_STATE();
    case 185:
      if (lookahead == 'n') ADVANCE(220);
      END_STATE();
    case 186:
      if (lookahead == 'f') ADVANCE(221);
      END_STATE();
    case 187:
      if (lookahead == 'e') ADVANCE(222);
      END_STATE();
    case 188:
      if (lookahead == 'e') ADVANCE(223);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_opens);
      END_STATE();
    case 190:
      if (lookahead == 'g') ADVANCE(224);
      END_STATE();
    case 191:
      if (lookahead == 't') ADVANCE(225);
      END_STATE();
    case 192:
      if (lookahead == 'c') ADVANCE(226);
      END_STATE();
    case 193:
      if (lookahead == 'd') ADVANCE(227);
      END_STATE();
    case 194:
      if (lookahead == 'c') ADVANCE(228);
      END_STATE();
    case 195:
      if (lookahead == 'd') ADVANCE(229);
      END_STATE();
    case 196:
      if (lookahead == 'r') ADVANCE(230);
      END_STATE();
    case 197:
      if (lookahead == 'n') ADVANCE(231);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_short);
      END_STATE();
    case 199:
      if (lookahead == 'c') ADVANCE(232);
      END_STATE();
    case 200:
      if (lookahead == 't') ADVANCE(233);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 202:
      if (lookahead == 'h') ADVANCE(234);
      END_STATE();
    case 203:
      if (lookahead == 'r') ADVANCE(235);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_throw);
      if (lookahead == 's') ADVANCE(236);
      END_STATE();
    case 205:
      if (lookahead == 'i') ADVANCE(237);
      END_STATE();
    case 206:
      if (lookahead == 'i') ADVANCE(238);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 209:
      if (lookahead == 'c') ADVANCE(239);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 211:
      if (lookahead == 'n') ADVANCE(240);
      END_STATE();
    case 212:
      if (lookahead == 'u') ADVANCE(241);
      END_STATE();
    case 213:
      if (lookahead == 't') ADVANCE(242);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_double);
      END_STATE();
    case 215:
      if (lookahead == 's') ADVANCE(243);
      END_STATE();
    case 216:
      if (lookahead == 's') ADVANCE(244);
      END_STATE();
    case 217:
      if (lookahead == 'y') ADVANCE(245);
      END_STATE();
    case 218:
      if (lookahead == 'e') ADVANCE(246);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 220:
      if (lookahead == 'c') ADVANCE(247);
      END_STATE();
    case 221:
      if (lookahead == 'a') ADVANCE(248);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 224:
      if (lookahead == 'e') ADVANCE(249);
      END_STATE();
    case 225:
      if (lookahead == 'e') ADVANCE(250);
      END_STATE();
    case 226:
      if (lookahead == 't') ADVANCE(251);
      END_STATE();
    case 227:
      if (lookahead == 'e') ADVANCE(252);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_record);
      END_STATE();
    case 230:
      if (lookahead == 'e') ADVANCE(253);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 233:
      if (lookahead == 'f') ADVANCE(254);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 235:
      if (lookahead == 'o') ADVANCE(255);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_throws);
      END_STATE();
    case 237:
      if (lookahead == 'e') ADVANCE(256);
      if (lookahead == 't') ADVANCE(257);
      END_STATE();
    case 238:
      if (lookahead == 'l') ADVANCE(258);
      END_STATE();
    case 239:
      if (lookahead == 't') ADVANCE(259);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_boolean_type);
      END_STATE();
    case 241:
      if (lookahead == 'e') ADVANCE(260);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_exports);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 246:
      if (lookahead == 'n') ADVANCE(261);
      END_STATE();
    case 247:
      if (lookahead == 'e') ADVANCE(262);
      END_STATE();
    case 248:
      if (lookahead == 'c') ADVANCE(263);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 251:
      if (lookahead == 'e') ADVANCE(264);
      END_STATE();
    case 252:
      if (lookahead == 's') ADVANCE(265);
      END_STATE();
    case 253:
      if (lookahead == 's') ADVANCE(266);
      END_STATE();
    case 254:
      if (lookahead == 'p') ADVANCE(267);
      END_STATE();
    case 255:
      if (lookahead == 'n') ADVANCE(268);
      END_STATE();
    case 256:
      if (lookahead == 'n') ADVANCE(269);
      END_STATE();
    case 257:
      if (lookahead == 'i') ADVANCE(270);
      END_STATE();
    case 258:
      if (lookahead == 'e') ADVANCE(271);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 261:
      if (lookahead == 't') ADVANCE(272);
      END_STATE();
    case 262:
      if (lookahead == 'o') ADVANCE(273);
      END_STATE();
    case 263:
      if (lookahead == 'e') ADVANCE(274);
      END_STATE();
    case 264:
      if (lookahead == 'd') ADVANCE(275);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_provides);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_requires);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_strictfp);
      END_STATE();
    case 268:
      if (lookahead == 'i') ADVANCE(276);
      END_STATE();
    case 269:
      if (lookahead == 't') ADVANCE(277);
      END_STATE();
    case 270:
      if (lookahead == 'v') ADVANCE(278);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 272:
      if (lookahead == 's') ADVANCE(279);
      END_STATE();
    case 273:
      if (lookahead == 'f') ADVANCE(280);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 276:
      if (lookahead == 'z') ADVANCE(281);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_transient);
      END_STATE();
    case 278:
      if (lookahead == 'e') ADVANCE(282);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    case 281:
      if (lookahead == 'e') ADVANCE(283);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_transitive);
      END_STATE();
    case 283:
      if (lookahead == 'd') ADVANCE(284);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_synchronized);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 51},
  [2] = {.lex_state = 51},
  [3] = {.lex_state = 51},
  [4] = {.lex_state = 51},
  [5] = {.lex_state = 51},
  [6] = {.lex_state = 51},
  [7] = {.lex_state = 51},
  [8] = {.lex_state = 51},
  [9] = {.lex_state = 51},
  [10] = {.lex_state = 51},
  [11] = {.lex_state = 51},
  [12] = {.lex_state = 51},
  [13] = {.lex_state = 51},
  [14] = {.lex_state = 51},
  [15] = {.lex_state = 51},
  [16] = {.lex_state = 51},
  [17] = {.lex_state = 51},
  [18] = {.lex_state = 51},
  [19] = {.lex_state = 51},
  [20] = {.lex_state = 51},
  [21] = {.lex_state = 51},
  [22] = {.lex_state = 51},
  [23] = {.lex_state = 51},
  [24] = {.lex_state = 51},
  [25] = {.lex_state = 51},
  [26] = {.lex_state = 51},
  [27] = {.lex_state = 51},
  [28] = {.lex_state = 51},
  [29] = {.lex_state = 51},
  [30] = {.lex_state = 51},
  [31] = {.lex_state = 51},
  [32] = {.lex_state = 51},
  [33] = {.lex_state = 51},
  [34] = {.lex_state = 51},
  [35] = {.lex_state = 51},
  [36] = {.lex_state = 51},
  [37] = {.lex_state = 51},
  [38] = {.lex_state = 51},
  [39] = {.lex_state = 51},
  [40] = {.lex_state = 51},
  [41] = {.lex_state = 51},
  [42] = {.lex_state = 51},
  [43] = {.lex_state = 51},
  [44] = {.lex_state = 51},
  [45] = {.lex_state = 50},
  [46] = {.lex_state = 50},
  [47] = {.lex_state = 51},
  [48] = {.lex_state = 51},
  [49] = {.lex_state = 51},
  [50] = {.lex_state = 50},
  [51] = {.lex_state = 51},
  [52] = {.lex_state = 51},
  [53] = {.lex_state = 51},
  [54] = {.lex_state = 3},
  [55] = {.lex_state = 3},
  [56] = {.lex_state = 3},
  [57] = {.lex_state = 51},
  [58] = {.lex_state = 3},
  [59] = {.lex_state = 3},
  [60] = {.lex_state = 3},
  [61] = {.lex_state = 51},
  [62] = {.lex_state = 51},
  [63] = {.lex_state = 3},
  [64] = {.lex_state = 3},
  [65] = {.lex_state = 51},
  [66] = {.lex_state = 3},
  [67] = {.lex_state = 3},
  [68] = {.lex_state = 3},
  [69] = {.lex_state = 3},
  [70] = {.lex_state = 3},
  [71] = {.lex_state = 3},
  [72] = {.lex_state = 3},
  [73] = {.lex_state = 3},
  [74] = {.lex_state = 51},
  [75] = {.lex_state = 3},
  [76] = {.lex_state = 51},
  [77] = {.lex_state = 51},
  [78] = {.lex_state = 51},
  [79] = {.lex_state = 51},
  [80] = {.lex_state = 51},
  [81] = {.lex_state = 51},
  [82] = {.lex_state = 51},
  [83] = {.lex_state = 51},
  [84] = {.lex_state = 51},
  [85] = {.lex_state = 51},
  [86] = {.lex_state = 51},
  [87] = {.lex_state = 51},
  [88] = {.lex_state = 51},
  [89] = {.lex_state = 51},
  [90] = {.lex_state = 51},
  [91] = {.lex_state = 51},
  [92] = {.lex_state = 51},
  [93] = {.lex_state = 51},
  [94] = {.lex_state = 51},
  [95] = {.lex_state = 51},
  [96] = {.lex_state = 51},
  [97] = {.lex_state = 51},
  [98] = {.lex_state = 3},
  [99] = {.lex_state = 51},
  [100] = {.lex_state = 51},
  [101] = {.lex_state = 51},
  [102] = {.lex_state = 3},
  [103] = {.lex_state = 51},
  [104] = {.lex_state = 51},
  [105] = {.lex_state = 51},
  [106] = {.lex_state = 51},
  [107] = {.lex_state = 51},
  [108] = {.lex_state = 51},
  [109] = {.lex_state = 51},
  [110] = {.lex_state = 51},
  [111] = {.lex_state = 51},
  [112] = {.lex_state = 51},
  [113] = {.lex_state = 51},
  [114] = {.lex_state = 51},
  [115] = {.lex_state = 51},
  [116] = {.lex_state = 51},
  [117] = {.lex_state = 51},
  [118] = {.lex_state = 51},
  [119] = {.lex_state = 3},
  [120] = {.lex_state = 3},
  [121] = {.lex_state = 3},
  [122] = {.lex_state = 3},
  [123] = {.lex_state = 3},
  [124] = {.lex_state = 3},
  [125] = {.lex_state = 3},
  [126] = {.lex_state = 3},
  [127] = {.lex_state = 3},
  [128] = {.lex_state = 3},
  [129] = {.lex_state = 3},
  [130] = {.lex_state = 3},
  [131] = {.lex_state = 3},
  [132] = {.lex_state = 3},
  [133] = {.lex_state = 3},
  [134] = {.lex_state = 3},
  [135] = {.lex_state = 3},
  [136] = {.lex_state = 3},
  [137] = {.lex_state = 3},
  [138] = {.lex_state = 51},
  [139] = {.lex_state = 3},
  [140] = {.lex_state = 3},
  [141] = {.lex_state = 3},
  [142] = {.lex_state = 3},
  [143] = {.lex_state = 3},
  [144] = {.lex_state = 3},
  [145] = {.lex_state = 3},
  [146] = {.lex_state = 51},
  [147] = {.lex_state = 3},
  [148] = {.lex_state = 51},
  [149] = {.lex_state = 51},
  [150] = {.lex_state = 3},
  [151] = {.lex_state = 3},
  [152] = {.lex_state = 51},
  [153] = {.lex_state = 51},
  [154] = {.lex_state = 51},
  [155] = {.lex_state = 3},
  [156] = {.lex_state = 3},
  [157] = {.lex_state = 3},
  [158] = {.lex_state = 51},
  [159] = {.lex_state = 51},
  [160] = {.lex_state = 3},
  [161] = {.lex_state = 51},
  [162] = {.lex_state = 3},
  [163] = {.lex_state = 3},
  [164] = {.lex_state = 51},
  [165] = {.lex_state = 51},
  [166] = {.lex_state = 51},
  [167] = {.lex_state = 3},
  [168] = {.lex_state = 3},
  [169] = {.lex_state = 51},
  [170] = {.lex_state = 51},
  [171] = {.lex_state = 51},
  [172] = {.lex_state = 51},
  [173] = {.lex_state = 51},
  [174] = {.lex_state = 51},
  [175] = {.lex_state = 51},
  [176] = {.lex_state = 51},
  [177] = {.lex_state = 51},
  [178] = {.lex_state = 3},
  [179] = {.lex_state = 51},
  [180] = {.lex_state = 51},
  [181] = {.lex_state = 51},
  [182] = {.lex_state = 51},
  [183] = {.lex_state = 51},
  [184] = {.lex_state = 51},
  [185] = {.lex_state = 3},
  [186] = {.lex_state = 51},
  [187] = {.lex_state = 51},
  [188] = {.lex_state = 51},
  [189] = {.lex_state = 51},
  [190] = {.lex_state = 51},
  [191] = {.lex_state = 3},
  [192] = {.lex_state = 3},
  [193] = {.lex_state = 3},
  [194] = {.lex_state = 51},
  [195] = {.lex_state = 51},
  [196] = {.lex_state = 51},
  [197] = {.lex_state = 51},
  [198] = {.lex_state = 3},
  [199] = {.lex_state = 3},
  [200] = {.lex_state = 3},
  [201] = {.lex_state = 51},
  [202] = {.lex_state = 3},
  [203] = {.lex_state = 3},
  [204] = {.lex_state = 3},
  [205] = {.lex_state = 51},
  [206] = {.lex_state = 51},
  [207] = {.lex_state = 3},
  [208] = {.lex_state = 3},
  [209] = {.lex_state = 3},
  [210] = {.lex_state = 3},
  [211] = {.lex_state = 51},
  [212] = {.lex_state = 3},
  [213] = {.lex_state = 51},
  [214] = {.lex_state = 51},
  [215] = {.lex_state = 51},
  [216] = {.lex_state = 51},
  [217] = {.lex_state = 51},
  [218] = {.lex_state = 51},
  [219] = {.lex_state = 51},
  [220] = {.lex_state = 51},
  [221] = {.lex_state = 51},
  [222] = {.lex_state = 3},
  [223] = {.lex_state = 51},
  [224] = {.lex_state = 3},
  [225] = {.lex_state = 51},
  [226] = {.lex_state = 51},
  [227] = {.lex_state = 3},
  [228] = {.lex_state = 3},
  [229] = {.lex_state = 51},
  [230] = {.lex_state = 3},
  [231] = {.lex_state = 3},
  [232] = {.lex_state = 51},
  [233] = {.lex_state = 3},
  [234] = {.lex_state = 3},
  [235] = {.lex_state = 3},
  [236] = {.lex_state = 3},
  [237] = {.lex_state = 3},
  [238] = {.lex_state = 3},
  [239] = {.lex_state = 3},
  [240] = {.lex_state = 51},
  [241] = {.lex_state = 51},
  [242] = {.lex_state = 3},
  [243] = {.lex_state = 3},
  [244] = {.lex_state = 51},
  [245] = {.lex_state = 51},
  [246] = {.lex_state = 3},
  [247] = {.lex_state = 51},
  [248] = {.lex_state = 51},
  [249] = {.lex_state = 51},
  [250] = {.lex_state = 51},
  [251] = {.lex_state = 51},
  [252] = {.lex_state = 51},
  [253] = {.lex_state = 51},
  [254] = {.lex_state = 51},
  [255] = {.lex_state = 3},
  [256] = {.lex_state = 3},
  [257] = {.lex_state = 51},
  [258] = {.lex_state = 51},
  [259] = {.lex_state = 51},
  [260] = {.lex_state = 51},
  [261] = {.lex_state = 51},
  [262] = {.lex_state = 51},
  [263] = {.lex_state = 3},
  [264] = {.lex_state = 3},
  [265] = {.lex_state = 51},
  [266] = {.lex_state = 51},
  [267] = {.lex_state = 51},
  [268] = {.lex_state = 3},
  [269] = {.lex_state = 3},
  [270] = {.lex_state = 51},
  [271] = {.lex_state = 51},
  [272] = {.lex_state = 3},
  [273] = {.lex_state = 3},
  [274] = {.lex_state = 0},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 0},
  [277] = {.lex_state = 0},
  [278] = {.lex_state = 0},
  [279] = {.lex_state = 4},
  [280] = {.lex_state = 4},
  [281] = {.lex_state = 0},
  [282] = {.lex_state = 0},
  [283] = {.lex_state = 0},
  [284] = {.lex_state = 4},
  [285] = {.lex_state = 4},
  [286] = {.lex_state = 4},
  [287] = {.lex_state = 4},
  [288] = {.lex_state = 4},
  [289] = {.lex_state = 4},
  [290] = {.lex_state = 4},
  [291] = {.lex_state = 4},
  [292] = {.lex_state = 4},
  [293] = {.lex_state = 4},
  [294] = {.lex_state = 4},
  [295] = {.lex_state = 4},
  [296] = {.lex_state = 0},
  [297] = {.lex_state = 4},
  [298] = {.lex_state = 0},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 4},
  [301] = {.lex_state = 5},
  [302] = {.lex_state = 4},
  [303] = {.lex_state = 5},
  [304] = {.lex_state = 4},
  [305] = {.lex_state = 5},
  [306] = {.lex_state = 12},
  [307] = {.lex_state = 12},
  [308] = {.lex_state = 5},
  [309] = {.lex_state = 3},
  [310] = {.lex_state = 5},
  [311] = {.lex_state = 3},
  [312] = {.lex_state = 3},
  [313] = {.lex_state = 3},
  [314] = {.lex_state = 3},
  [315] = {.lex_state = 3},
  [316] = {.lex_state = 3},
  [317] = {.lex_state = 3},
  [318] = {.lex_state = 4},
  [319] = {.lex_state = 5},
  [320] = {.lex_state = 12},
  [321] = {.lex_state = 4},
  [322] = {.lex_state = 5},
  [323] = {.lex_state = 5},
  [324] = {.lex_state = 5},
  [325] = {.lex_state = 12},
  [326] = {.lex_state = 4},
  [327] = {.lex_state = 5},
  [328] = {.lex_state = 5},
  [329] = {.lex_state = 5},
  [330] = {.lex_state = 5},
  [331] = {.lex_state = 5},
  [332] = {.lex_state = 5},
  [333] = {.lex_state = 4},
  [334] = {.lex_state = 5},
  [335] = {.lex_state = 5},
  [336] = {.lex_state = 5},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 5},
  [339] = {.lex_state = 5},
  [340] = {.lex_state = 5},
  [341] = {.lex_state = 5},
  [342] = {.lex_state = 5},
  [343] = {.lex_state = 5},
  [344] = {.lex_state = 5},
  [345] = {.lex_state = 5},
  [346] = {.lex_state = 5},
  [347] = {.lex_state = 5},
  [348] = {.lex_state = 5},
  [349] = {.lex_state = 5},
  [350] = {.lex_state = 5},
  [351] = {.lex_state = 5},
  [352] = {.lex_state = 5},
  [353] = {.lex_state = 5},
  [354] = {.lex_state = 5},
  [355] = {.lex_state = 5},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 5},
  [358] = {.lex_state = 5},
  [359] = {.lex_state = 5},
  [360] = {.lex_state = 5},
  [361] = {.lex_state = 5},
  [362] = {.lex_state = 5},
  [363] = {.lex_state = 5},
  [364] = {.lex_state = 5},
  [365] = {.lex_state = 5},
  [366] = {.lex_state = 5},
  [367] = {.lex_state = 5},
  [368] = {.lex_state = 5},
  [369] = {.lex_state = 5},
  [370] = {.lex_state = 5},
  [371] = {.lex_state = 5},
  [372] = {.lex_state = 5},
  [373] = {.lex_state = 5},
  [374] = {.lex_state = 5},
  [375] = {.lex_state = 5},
  [376] = {.lex_state = 5},
  [377] = {.lex_state = 5},
  [378] = {.lex_state = 5},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 3},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 3},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 3},
  [389] = {.lex_state = 3},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 3},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 0},
  [394] = {.lex_state = 3},
  [395] = {.lex_state = 3},
  [396] = {.lex_state = 0},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 3},
  [402] = {.lex_state = 3},
  [403] = {.lex_state = 0},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 0},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 0},
  [410] = {.lex_state = 51},
  [411] = {.lex_state = 51},
  [412] = {.lex_state = 51},
  [413] = {.lex_state = 51},
  [414] = {.lex_state = 51},
  [415] = {.lex_state = 0},
  [416] = {.lex_state = 51},
  [417] = {.lex_state = 51},
  [418] = {.lex_state = 51},
  [419] = {.lex_state = 51},
  [420] = {.lex_state = 51},
  [421] = {.lex_state = 51},
  [422] = {.lex_state = 0},
  [423] = {.lex_state = 0},
  [424] = {.lex_state = 51},
  [425] = {.lex_state = 11},
  [426] = {.lex_state = 51},
  [427] = {.lex_state = 11},
  [428] = {.lex_state = 51},
  [429] = {.lex_state = 51},
  [430] = {.lex_state = 5},
  [431] = {.lex_state = 51},
  [432] = {.lex_state = 51},
  [433] = {.lex_state = 51},
  [434] = {.lex_state = 51},
  [435] = {.lex_state = 51},
  [436] = {.lex_state = 51},
  [437] = {.lex_state = 51},
  [438] = {.lex_state = 51},
  [439] = {.lex_state = 11},
  [440] = {.lex_state = 51},
  [441] = {.lex_state = 0},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 51},
  [444] = {.lex_state = 0},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 3},
  [447] = {.lex_state = 3},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 51},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 5},
  [454] = {.lex_state = 0},
  [455] = {.lex_state = 51},
  [456] = {.lex_state = 51},
  [457] = {.lex_state = 11},
  [458] = {.lex_state = 11},
  [459] = {.lex_state = 51},
  [460] = {.lex_state = 51},
  [461] = {.lex_state = 51},
  [462] = {.lex_state = 51},
  [463] = {.lex_state = 51},
  [464] = {.lex_state = 51},
  [465] = {.lex_state = 51},
  [466] = {.lex_state = 51},
  [467] = {.lex_state = 51},
  [468] = {.lex_state = 51},
  [469] = {.lex_state = 11},
  [470] = {.lex_state = 51},
  [471] = {.lex_state = 51},
  [472] = {.lex_state = 51},
  [473] = {.lex_state = 51},
  [474] = {.lex_state = 51},
  [475] = {.lex_state = 51},
  [476] = {.lex_state = 51},
  [477] = {.lex_state = 51},
  [478] = {.lex_state = 51},
  [479] = {.lex_state = 51},
  [480] = {.lex_state = 51},
  [481] = {.lex_state = 51},
  [482] = {.lex_state = 11},
  [483] = {.lex_state = 51},
  [484] = {.lex_state = 51},
  [485] = {.lex_state = 51},
  [486] = {.lex_state = 51},
  [487] = {.lex_state = 51},
  [488] = {.lex_state = 51},
  [489] = {.lex_state = 51},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 51},
  [492] = {.lex_state = 51},
  [493] = {.lex_state = 51},
  [494] = {.lex_state = 51},
  [495] = {.lex_state = 3},
  [496] = {.lex_state = 51},
  [497] = {.lex_state = 51},
  [498] = {.lex_state = 51},
  [499] = {.lex_state = 51},
  [500] = {.lex_state = 51},
  [501] = {.lex_state = 51},
  [502] = {.lex_state = 3},
  [503] = {.lex_state = 3},
  [504] = {.lex_state = 51},
  [505] = {.lex_state = 51},
  [506] = {.lex_state = 51},
  [507] = {.lex_state = 3},
  [508] = {.lex_state = 3},
  [509] = {.lex_state = 51},
  [510] = {.lex_state = 3},
  [511] = {.lex_state = 51},
  [512] = {.lex_state = 3},
  [513] = {.lex_state = 51},
  [514] = {.lex_state = 51},
  [515] = {.lex_state = 51},
  [516] = {.lex_state = 51},
  [517] = {.lex_state = 3},
  [518] = {.lex_state = 3},
  [519] = {.lex_state = 51},
  [520] = {.lex_state = 51},
  [521] = {.lex_state = 3},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 3},
  [524] = {.lex_state = 3},
  [525] = {.lex_state = 3},
  [526] = {.lex_state = 3},
  [527] = {.lex_state = 3},
  [528] = {.lex_state = 3},
  [529] = {.lex_state = 3},
  [530] = {.lex_state = 3},
  [531] = {.lex_state = 3},
  [532] = {.lex_state = 3},
  [533] = {.lex_state = 3},
  [534] = {.lex_state = 3},
  [535] = {.lex_state = 11},
  [536] = {.lex_state = 3},
  [537] = {.lex_state = 3},
  [538] = {.lex_state = 11},
  [539] = {.lex_state = 3},
  [540] = {.lex_state = 3},
  [541] = {.lex_state = 3},
  [542] = {.lex_state = 3},
  [543] = {.lex_state = 3},
  [544] = {.lex_state = 3},
  [545] = {.lex_state = 0},
  [546] = {.lex_state = 11},
  [547] = {.lex_state = 0},
  [548] = {.lex_state = 11},
  [549] = {.lex_state = 11},
  [550] = {.lex_state = 11},
  [551] = {.lex_state = 11},
  [552] = {.lex_state = 11},
  [553] = {.lex_state = 11},
  [554] = {.lex_state = 11},
  [555] = {.lex_state = 11},
  [556] = {.lex_state = 4},
  [557] = {.lex_state = 11},
  [558] = {.lex_state = 11},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 11},
  [561] = {.lex_state = 11},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 4},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 4},
  [570] = {.lex_state = 11},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 3},
  [573] = {.lex_state = 4},
  [574] = {.lex_state = 4},
  [575] = {.lex_state = 3},
  [576] = {.lex_state = 4},
  [577] = {.lex_state = 3},
  [578] = {.lex_state = 3},
  [579] = {.lex_state = 11},
  [580] = {.lex_state = 3},
  [581] = {.lex_state = 4},
  [582] = {.lex_state = 3},
  [583] = {.lex_state = 3},
  [584] = {.lex_state = 3},
  [585] = {.lex_state = 4},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 3},
  [588] = {.lex_state = 3},
  [589] = {.lex_state = 3},
  [590] = {.lex_state = 3},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 3},
  [593] = {.lex_state = 3},
  [594] = {.lex_state = 3},
  [595] = {.lex_state = 3},
  [596] = {.lex_state = 4},
  [597] = {.lex_state = 4},
  [598] = {.lex_state = 3},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 4},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 3},
  [603] = {.lex_state = 4},
  [604] = {.lex_state = 3},
  [605] = {.lex_state = 3},
  [606] = {.lex_state = 3},
  [607] = {.lex_state = 3},
  [608] = {.lex_state = 3},
  [609] = {.lex_state = 3},
  [610] = {.lex_state = 4},
  [611] = {.lex_state = 4},
  [612] = {.lex_state = 3},
  [613] = {.lex_state = 3},
  [614] = {.lex_state = 3},
  [615] = {.lex_state = 3},
  [616] = {.lex_state = 4},
  [617] = {.lex_state = 3},
  [618] = {.lex_state = 3},
  [619] = {.lex_state = 3},
  [620] = {.lex_state = 3},
  [621] = {.lex_state = 4},
  [622] = {.lex_state = 4},
  [623] = {.lex_state = 4},
  [624] = {.lex_state = 4},
  [625] = {.lex_state = 3},
  [626] = {.lex_state = 0},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 12},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 3},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 3},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 3},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 3},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 3},
  [654] = {.lex_state = 3},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 3},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 3},
  [670] = {.lex_state = 3},
  [671] = {.lex_state = 3},
  [672] = {.lex_state = 3},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 3},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 3},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 3},
  [685] = {.lex_state = 3},
  [686] = {.lex_state = 3},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 3},
  [693] = {.lex_state = 3},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 3},
  [700] = {.lex_state = 3},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 4},
  [713] = {.lex_state = 4},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 4},
  [716] = {.lex_state = 4},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 12},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 12},
  [721] = {.lex_state = 4},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 4},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 4},
  [728] = {.lex_state = 0},
  [729] = {.lex_state = 0},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 12},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 12},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 12},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 4},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 4},
  [771] = {.lex_state = 4},
  [772] = {.lex_state = 12},
  [773] = {.lex_state = 4},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 4},
  [776] = {.lex_state = 4},
  [777] = {.lex_state = 4},
  [778] = {.lex_state = 4},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 4},
  [784] = {.lex_state = 4},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 4},
  [787] = {.lex_state = 4},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 12},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 0},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 0},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 12},
  [810] = {.lex_state = 4},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 12},
  [813] = {.lex_state = 12},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 4},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 4},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 4},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 4},
  [830] = {.lex_state = 12},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 4},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 4},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 12},
  [849] = {.lex_state = 12},
  [850] = {.lex_state = 4},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 4},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 12},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 4},
  [878] = {.lex_state = 12},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 12},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 4},
  [887] = {.lex_state = 4},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 4},
  [893] = {.lex_state = 4},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 4},
  [897] = {.lex_state = 4},
  [898] = {.lex_state = 4},
  [899] = {.lex_state = 4},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 12},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 12},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 4},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 12},
  [912] = {.lex_state = 4},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 4},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 4},
  [923] = {.lex_state = 4},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 4},
  [926] = {.lex_state = 4},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 12},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 4},
  [947] = {.lex_state = 4},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 4},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 4},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 4},
  [963] = {.lex_state = 0},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 4},
  [970] = {.lex_state = 4},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 4},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 12},
  [980] = {.lex_state = 4},
  [981] = {.lex_state = 4},
  [982] = {.lex_state = 12},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 12},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 4},
  [992] = {.lex_state = 4},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 4},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 4},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_decimal_integer_literal] = ACTIONS(1),
    [sym_hex_integer_literal] = ACTIONS(1),
    [sym_octal_integer_literal] = ACTIONS(1),
    [sym_binary_integer_literal] = ACTIONS(1),
    [sym_decimal_floating_point_literal] = ACTIONS(1),
    [sym_hex_floating_point_literal] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_character_literal] = ACTIONS(1),
    [sym_string_literal] = ACTIONS(1),
    [sym_text_block] = ACTIONS(1),
    [sym_null_literal] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_synchronized] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_open] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_requires] = ACTIONS(1),
    [anon_sym_transitive] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_exports] = ACTIONS(1),
    [anon_sym_to] = ACTIONS(1),
    [anon_sym_opens] = ACTIONS(1),
    [anon_sym_uses] = ACTIONS(1),
    [anon_sym_provides] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_final] = ACTIONS(1),
    [anon_sym_strictfp] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_transient] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_record] = ACTIONS(1),
    [anon_sym_ATinterface] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_byte] = ACTIONS(1),
    [anon_sym_short] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_long] = ACTIONS(1),
    [anon_sym_char] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_double] = ACTIONS(1),
    [sym_boolean_type] = ACTIONS(1),
    [sym_void_type] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_throws] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_program] = STATE(1068),
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(10),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_program_repeat1] = STATE(10),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_switch_label] = STATE(1076),
    [sym_statement] = STATE(5),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_program_repeat1] = STATE(5),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_switch_block_statement_group_repeat1] = STATE(240),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(83),
    [anon_sym_case] = ACTIONS(85),
    [anon_sym_default] = ACTIONS(85),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(453),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_type_arguments] = STATE(943),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(13),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_explicit_constructor_invocation] = STATE(12),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_program_repeat1] = STATE(13),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_LT] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(89),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [ts_builtin_sym_end] = ACTIONS(95),
    [sym_identifier] = ACTIONS(97),
    [sym_decimal_integer_literal] = ACTIONS(100),
    [sym_hex_integer_literal] = ACTIONS(100),
    [sym_octal_integer_literal] = ACTIONS(103),
    [sym_binary_integer_literal] = ACTIONS(103),
    [sym_decimal_floating_point_literal] = ACTIONS(103),
    [sym_hex_floating_point_literal] = ACTIONS(100),
    [sym_true] = ACTIONS(100),
    [sym_false] = ACTIONS(100),
    [sym_character_literal] = ACTIONS(103),
    [sym_string_literal] = ACTIONS(100),
    [sym_text_block] = ACTIONS(103),
    [sym_null_literal] = ACTIONS(100),
    [anon_sym_LPAREN] = ACTIONS(106),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(109),
    [anon_sym_BANG] = ACTIONS(112),
    [anon_sym_TILDE] = ACTIONS(112),
    [anon_sym_PLUS_PLUS] = ACTIONS(115),
    [anon_sym_DASH_DASH] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(118),
    [anon_sym_class] = ACTIONS(121),
    [anon_sym_switch] = ACTIONS(124),
    [anon_sym_LBRACE] = ACTIONS(127),
    [anon_sym_RBRACE] = ACTIONS(95),
    [anon_sym_case] = ACTIONS(130),
    [anon_sym_default] = ACTIONS(132),
    [anon_sym_SEMI] = ACTIONS(135),
    [anon_sym_assert] = ACTIONS(138),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(144),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(150),
    [anon_sym_return] = ACTIONS(153),
    [anon_sym_yield] = ACTIONS(156),
    [anon_sym_synchronized] = ACTIONS(159),
    [anon_sym_throw] = ACTIONS(162),
    [anon_sym_try] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(168),
    [anon_sym_for] = ACTIONS(171),
    [anon_sym_AT] = ACTIONS(174),
    [anon_sym_open] = ACTIONS(177),
    [anon_sym_module] = ACTIONS(180),
    [anon_sym_static] = ACTIONS(132),
    [anon_sym_package] = ACTIONS(183),
    [anon_sym_import] = ACTIONS(186),
    [anon_sym_enum] = ACTIONS(189),
    [anon_sym_public] = ACTIONS(132),
    [anon_sym_protected] = ACTIONS(132),
    [anon_sym_private] = ACTIONS(132),
    [anon_sym_abstract] = ACTIONS(132),
    [anon_sym_final] = ACTIONS(132),
    [anon_sym_strictfp] = ACTIONS(132),
    [anon_sym_native] = ACTIONS(132),
    [anon_sym_transient] = ACTIONS(132),
    [anon_sym_volatile] = ACTIONS(132),
    [anon_sym_ATinterface] = ACTIONS(192),
    [anon_sym_interface] = ACTIONS(195),
    [anon_sym_byte] = ACTIONS(198),
    [anon_sym_short] = ACTIONS(198),
    [anon_sym_int] = ACTIONS(198),
    [anon_sym_long] = ACTIONS(198),
    [anon_sym_char] = ACTIONS(198),
    [anon_sym_float] = ACTIONS(201),
    [anon_sym_double] = ACTIONS(201),
    [sym_boolean_type] = ACTIONS(204),
    [sym_void_type] = ACTIONS(204),
    [sym_this] = ACTIONS(207),
    [sym_super] = ACTIONS(210),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(213),
    [anon_sym_case] = ACTIONS(215),
    [anon_sym_default] = ACTIONS(215),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(217),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(219),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(221),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(8),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_program_repeat1] = STATE(8),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(223),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [ts_builtin_sym_end] = ACTIONS(225),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(7),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(227),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(6),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(229),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(229),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(221),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(226),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(154),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(158),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(166),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(171),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(172),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [21] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(180),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [22] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(188),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [23] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(213),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [24] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(262),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [25] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(138),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [26] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(205),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [27] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(206),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [28] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(247),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [29] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(248),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [30] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(253),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [31] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(257),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(259),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(189),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [34] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(261),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [35] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(177),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [36] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(232),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(181),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(179),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(165),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [40] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(176),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(174),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(1079),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(201),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(153),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_yield_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(415),
    [sym_marker_annotation] = STATE(415),
    [sym_annotation] = STATE(415),
    [sym_declaration] = STATE(159),
    [sym_module_declaration] = STATE(152),
    [sym_package_declaration] = STATE(152),
    [sym_import_declaration] = STATE(152),
    [sym_enum_declaration] = STATE(152),
    [sym_class_declaration] = STATE(152),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(152),
    [sym_interface_declaration] = STATE(152),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(569),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(508),
    [aux_sym_modifiers_repeat1] = STATE(337),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [45] = {
    [ts_builtin_sym_end] = ACTIONS(231),
    [sym_identifier] = ACTIONS(233),
    [sym_decimal_integer_literal] = ACTIONS(233),
    [sym_hex_integer_literal] = ACTIONS(233),
    [sym_octal_integer_literal] = ACTIONS(231),
    [sym_binary_integer_literal] = ACTIONS(231),
    [sym_decimal_floating_point_literal] = ACTIONS(231),
    [sym_hex_floating_point_literal] = ACTIONS(233),
    [sym_true] = ACTIONS(233),
    [sym_false] = ACTIONS(233),
    [sym_character_literal] = ACTIONS(231),
    [sym_string_literal] = ACTIONS(233),
    [sym_text_block] = ACTIONS(231),
    [sym_null_literal] = ACTIONS(233),
    [anon_sym_LPAREN] = ACTIONS(231),
    [anon_sym_AMP] = ACTIONS(233),
    [anon_sym_RPAREN] = ACTIONS(231),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(231),
    [anon_sym_LT_EQ] = ACTIONS(231),
    [anon_sym_EQ_EQ] = ACTIONS(231),
    [anon_sym_BANG_EQ] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_PLUS] = ACTIONS(233),
    [anon_sym_DASH] = ACTIONS(233),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_SLASH] = ACTIONS(233),
    [anon_sym_PIPE] = ACTIONS(233),
    [anon_sym_CARET] = ACTIONS(231),
    [anon_sym_PERCENT] = ACTIONS(231),
    [anon_sym_LT_LT] = ACTIONS(231),
    [anon_sym_GT_GT] = ACTIONS(233),
    [anon_sym_GT_GT_GT] = ACTIONS(231),
    [anon_sym_instanceof] = ACTIONS(233),
    [anon_sym_DASH_GT] = ACTIONS(231),
    [anon_sym_COMMA] = ACTIONS(231),
    [anon_sym_QMARK] = ACTIONS(231),
    [anon_sym_COLON] = ACTIONS(233),
    [anon_sym_BANG] = ACTIONS(233),
    [anon_sym_TILDE] = ACTIONS(231),
    [anon_sym_PLUS_PLUS] = ACTIONS(231),
    [anon_sym_DASH_DASH] = ACTIONS(231),
    [anon_sym_new] = ACTIONS(233),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(231),
    [anon_sym_DOT] = ACTIONS(233),
    [anon_sym_class] = ACTIONS(233),
    [anon_sym_COLON_COLON] = ACTIONS(231),
    [anon_sym_switch] = ACTIONS(233),
    [anon_sym_LBRACE] = ACTIONS(231),
    [anon_sym_RBRACE] = ACTIONS(231),
    [anon_sym_case] = ACTIONS(233),
    [anon_sym_default] = ACTIONS(233),
    [anon_sym_SEMI] = ACTIONS(231),
    [anon_sym_assert] = ACTIONS(233),
    [anon_sym_do] = ACTIONS(233),
    [anon_sym_while] = ACTIONS(233),
    [anon_sym_break] = ACTIONS(233),
    [anon_sym_continue] = ACTIONS(233),
    [anon_sym_return] = ACTIONS(233),
    [anon_sym_yield] = ACTIONS(233),
    [anon_sym_synchronized] = ACTIONS(233),
    [anon_sym_throw] = ACTIONS(233),
    [anon_sym_try] = ACTIONS(233),
    [anon_sym_if] = ACTIONS(233),
    [anon_sym_else] = ACTIONS(233),
    [anon_sym_for] = ACTIONS(233),
    [anon_sym_AT] = ACTIONS(233),
    [anon_sym_open] = ACTIONS(233),
    [anon_sym_module] = ACTIONS(233),
    [anon_sym_static] = ACTIONS(233),
    [anon_sym_package] = ACTIONS(233),
    [anon_sym_import] = ACTIONS(233),
    [anon_sym_enum] = ACTIONS(233),
    [anon_sym_public] = ACTIONS(233),
    [anon_sym_protected] = ACTIONS(233),
    [anon_sym_private] = ACTIONS(233),
    [anon_sym_abstract] = ACTIONS(233),
    [anon_sym_final] = ACTIONS(233),
    [anon_sym_strictfp] = ACTIONS(233),
    [anon_sym_native] = ACTIONS(233),
    [anon_sym_transient] = ACTIONS(233),
    [anon_sym_volatile] = ACTIONS(233),
    [anon_sym_record] = ACTIONS(233),
    [anon_sym_ATinterface] = ACTIONS(231),
    [anon_sym_interface] = ACTIONS(233),
    [anon_sym_byte] = ACTIONS(233),
    [anon_sym_short] = ACTIONS(233),
    [anon_sym_int] = ACTIONS(233),
    [anon_sym_long] = ACTIONS(233),
    [anon_sym_char] = ACTIONS(233),
    [anon_sym_float] = ACTIONS(233),
    [anon_sym_double] = ACTIONS(233),
    [sym_boolean_type] = ACTIONS(233),
    [sym_void_type] = ACTIONS(233),
    [sym_this] = ACTIONS(233),
    [sym_super] = ACTIONS(233),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [46] = {
    [ts_builtin_sym_end] = ACTIONS(235),
    [sym_identifier] = ACTIONS(237),
    [sym_decimal_integer_literal] = ACTIONS(237),
    [sym_hex_integer_literal] = ACTIONS(237),
    [sym_octal_integer_literal] = ACTIONS(235),
    [sym_binary_integer_literal] = ACTIONS(235),
    [sym_decimal_floating_point_literal] = ACTIONS(235),
    [sym_hex_floating_point_literal] = ACTIONS(237),
    [sym_true] = ACTIONS(237),
    [sym_false] = ACTIONS(237),
    [sym_character_literal] = ACTIONS(235),
    [sym_string_literal] = ACTIONS(237),
    [sym_text_block] = ACTIONS(235),
    [sym_null_literal] = ACTIONS(237),
    [anon_sym_LPAREN] = ACTIONS(235),
    [anon_sym_AMP] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(237),
    [anon_sym_LT] = ACTIONS(237),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_AMP_AMP] = ACTIONS(235),
    [anon_sym_PIPE_PIPE] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(237),
    [anon_sym_DASH] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(235),
    [anon_sym_SLASH] = ACTIONS(237),
    [anon_sym_PIPE] = ACTIONS(237),
    [anon_sym_CARET] = ACTIONS(235),
    [anon_sym_PERCENT] = ACTIONS(235),
    [anon_sym_LT_LT] = ACTIONS(235),
    [anon_sym_GT_GT] = ACTIONS(237),
    [anon_sym_GT_GT_GT] = ACTIONS(235),
    [anon_sym_instanceof] = ACTIONS(237),
    [anon_sym_DASH_GT] = ACTIONS(235),
    [anon_sym_COMMA] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(235),
    [anon_sym_COLON] = ACTIONS(237),
    [anon_sym_BANG] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(235),
    [anon_sym_PLUS_PLUS] = ACTIONS(235),
    [anon_sym_DASH_DASH] = ACTIONS(235),
    [anon_sym_new] = ACTIONS(237),
    [anon_sym_LBRACK] = ACTIONS(235),
    [anon_sym_RBRACK] = ACTIONS(235),
    [anon_sym_DOT] = ACTIONS(237),
    [anon_sym_class] = ACTIONS(237),
    [anon_sym_COLON_COLON] = ACTIONS(235),
    [anon_sym_switch] = ACTIONS(237),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_RBRACE] = ACTIONS(235),
    [anon_sym_case] = ACTIONS(237),
    [anon_sym_default] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(235),
    [anon_sym_assert] = ACTIONS(237),
    [anon_sym_do] = ACTIONS(237),
    [anon_sym_while] = ACTIONS(237),
    [anon_sym_break] = ACTIONS(237),
    [anon_sym_continue] = ACTIONS(237),
    [anon_sym_return] = ACTIONS(237),
    [anon_sym_yield] = ACTIONS(237),
    [anon_sym_synchronized] = ACTIONS(237),
    [anon_sym_throw] = ACTIONS(237),
    [anon_sym_try] = ACTIONS(237),
    [anon_sym_if] = ACTIONS(237),
    [anon_sym_else] = ACTIONS(237),
    [anon_sym_for] = ACTIONS(237),
    [anon_sym_AT] = ACTIONS(237),
    [anon_sym_open] = ACTIONS(237),
    [anon_sym_module] = ACTIONS(237),
    [anon_sym_static] = ACTIONS(237),
    [anon_sym_package] = ACTIONS(237),
    [anon_sym_import] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(237),
    [anon_sym_public] = ACTIONS(237),
    [anon_sym_protected] = ACTIONS(237),
    [anon_sym_private] = ACTIONS(237),
    [anon_sym_abstract] = ACTIONS(237),
    [anon_sym_final] = ACTIONS(237),
    [anon_sym_strictfp] = ACTIONS(237),
    [anon_sym_native] = ACTIONS(237),
    [anon_sym_transient] = ACTIONS(237),
    [anon_sym_volatile] = ACTIONS(237),
    [anon_sym_record] = ACTIONS(237),
    [anon_sym_ATinterface] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_byte] = ACTIONS(237),
    [anon_sym_short] = ACTIONS(237),
    [anon_sym_int] = ACTIONS(237),
    [anon_sym_long] = ACTIONS(237),
    [anon_sym_char] = ACTIONS(237),
    [anon_sym_float] = ACTIONS(237),
    [anon_sym_double] = ACTIONS(237),
    [sym_boolean_type] = ACTIONS(237),
    [sym_void_type] = ACTIONS(237),
    [sym_this] = ACTIONS(237),
    [sym_super] = ACTIONS(237),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [47] = {
    [ts_builtin_sym_end] = ACTIONS(239),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(241),
    [sym_hex_integer_literal] = ACTIONS(241),
    [sym_octal_integer_literal] = ACTIONS(239),
    [sym_binary_integer_literal] = ACTIONS(239),
    [sym_decimal_floating_point_literal] = ACTIONS(239),
    [sym_hex_floating_point_literal] = ACTIONS(241),
    [sym_true] = ACTIONS(241),
    [sym_false] = ACTIONS(241),
    [sym_character_literal] = ACTIONS(239),
    [sym_string_literal] = ACTIONS(241),
    [sym_text_block] = ACTIONS(239),
    [sym_null_literal] = ACTIONS(241),
    [anon_sym_LPAREN] = ACTIONS(239),
    [anon_sym_AMP] = ACTIONS(241),
    [anon_sym_RPAREN] = ACTIONS(239),
    [anon_sym_GT] = ACTIONS(241),
    [anon_sym_LT] = ACTIONS(241),
    [anon_sym_GT_EQ] = ACTIONS(239),
    [anon_sym_LT_EQ] = ACTIONS(239),
    [anon_sym_EQ_EQ] = ACTIONS(239),
    [anon_sym_BANG_EQ] = ACTIONS(239),
    [anon_sym_AMP_AMP] = ACTIONS(239),
    [anon_sym_PIPE_PIPE] = ACTIONS(239),
    [anon_sym_PLUS] = ACTIONS(241),
    [anon_sym_DASH] = ACTIONS(241),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_PIPE] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(239),
    [anon_sym_PERCENT] = ACTIONS(239),
    [anon_sym_LT_LT] = ACTIONS(239),
    [anon_sym_GT_GT] = ACTIONS(241),
    [anon_sym_GT_GT_GT] = ACTIONS(239),
    [anon_sym_instanceof] = ACTIONS(241),
    [anon_sym_DASH_GT] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(239),
    [anon_sym_COLON] = ACTIONS(239),
    [anon_sym_BANG] = ACTIONS(241),
    [anon_sym_TILDE] = ACTIONS(239),
    [anon_sym_PLUS_PLUS] = ACTIONS(239),
    [anon_sym_DASH_DASH] = ACTIONS(239),
    [anon_sym_new] = ACTIONS(241),
    [anon_sym_RBRACK] = ACTIONS(239),
    [anon_sym_class] = ACTIONS(241),
    [anon_sym_switch] = ACTIONS(241),
    [anon_sym_LBRACE] = ACTIONS(239),
    [anon_sym_RBRACE] = ACTIONS(239),
    [anon_sym_case] = ACTIONS(241),
    [anon_sym_default] = ACTIONS(241),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_assert] = ACTIONS(241),
    [anon_sym_do] = ACTIONS(241),
    [anon_sym_while] = ACTIONS(241),
    [anon_sym_break] = ACTIONS(241),
    [anon_sym_continue] = ACTIONS(241),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_yield] = ACTIONS(241),
    [anon_sym_synchronized] = ACTIONS(241),
    [anon_sym_throw] = ACTIONS(241),
    [anon_sym_try] = ACTIONS(241),
    [anon_sym_if] = ACTIONS(241),
    [anon_sym_else] = ACTIONS(241),
    [anon_sym_for] = ACTIONS(241),
    [anon_sym_AT] = ACTIONS(241),
    [anon_sym_open] = ACTIONS(241),
    [anon_sym_module] = ACTIONS(241),
    [anon_sym_static] = ACTIONS(241),
    [anon_sym_package] = ACTIONS(241),
    [anon_sym_import] = ACTIONS(241),
    [anon_sym_enum] = ACTIONS(241),
    [anon_sym_public] = ACTIONS(241),
    [anon_sym_protected] = ACTIONS(241),
    [anon_sym_private] = ACTIONS(241),
    [anon_sym_abstract] = ACTIONS(241),
    [anon_sym_final] = ACTIONS(241),
    [anon_sym_strictfp] = ACTIONS(241),
    [anon_sym_native] = ACTIONS(241),
    [anon_sym_transient] = ACTIONS(241),
    [anon_sym_volatile] = ACTIONS(241),
    [anon_sym_record] = ACTIONS(241),
    [anon_sym_ATinterface] = ACTIONS(239),
    [anon_sym_interface] = ACTIONS(241),
    [anon_sym_byte] = ACTIONS(241),
    [anon_sym_short] = ACTIONS(241),
    [anon_sym_int] = ACTIONS(241),
    [anon_sym_long] = ACTIONS(241),
    [anon_sym_char] = ACTIONS(241),
    [anon_sym_float] = ACTIONS(241),
    [anon_sym_double] = ACTIONS(241),
    [sym_boolean_type] = ACTIONS(241),
    [sym_void_type] = ACTIONS(241),
    [sym_this] = ACTIONS(241),
    [sym_super] = ACTIONS(241),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [48] = {
    [ts_builtin_sym_end] = ACTIONS(243),
    [sym_identifier] = ACTIONS(245),
    [sym_decimal_integer_literal] = ACTIONS(245),
    [sym_hex_integer_literal] = ACTIONS(245),
    [sym_octal_integer_literal] = ACTIONS(243),
    [sym_binary_integer_literal] = ACTIONS(243),
    [sym_decimal_floating_point_literal] = ACTIONS(243),
    [sym_hex_floating_point_literal] = ACTIONS(245),
    [sym_true] = ACTIONS(245),
    [sym_false] = ACTIONS(245),
    [sym_character_literal] = ACTIONS(243),
    [sym_string_literal] = ACTIONS(245),
    [sym_text_block] = ACTIONS(243),
    [sym_null_literal] = ACTIONS(245),
    [anon_sym_LPAREN] = ACTIONS(243),
    [anon_sym_AMP] = ACTIONS(245),
    [anon_sym_RPAREN] = ACTIONS(243),
    [anon_sym_GT] = ACTIONS(245),
    [anon_sym_LT] = ACTIONS(245),
    [anon_sym_GT_EQ] = ACTIONS(243),
    [anon_sym_LT_EQ] = ACTIONS(243),
    [anon_sym_EQ_EQ] = ACTIONS(243),
    [anon_sym_BANG_EQ] = ACTIONS(243),
    [anon_sym_AMP_AMP] = ACTIONS(243),
    [anon_sym_PIPE_PIPE] = ACTIONS(243),
    [anon_sym_PLUS] = ACTIONS(245),
    [anon_sym_DASH] = ACTIONS(245),
    [anon_sym_STAR] = ACTIONS(243),
    [anon_sym_SLASH] = ACTIONS(245),
    [anon_sym_PIPE] = ACTIONS(245),
    [anon_sym_CARET] = ACTIONS(243),
    [anon_sym_PERCENT] = ACTIONS(243),
    [anon_sym_LT_LT] = ACTIONS(243),
    [anon_sym_GT_GT] = ACTIONS(245),
    [anon_sym_GT_GT_GT] = ACTIONS(243),
    [anon_sym_instanceof] = ACTIONS(245),
    [anon_sym_DASH_GT] = ACTIONS(243),
    [anon_sym_COMMA] = ACTIONS(243),
    [anon_sym_QMARK] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(243),
    [anon_sym_BANG] = ACTIONS(245),
    [anon_sym_TILDE] = ACTIONS(243),
    [anon_sym_PLUS_PLUS] = ACTIONS(243),
    [anon_sym_DASH_DASH] = ACTIONS(243),
    [anon_sym_new] = ACTIONS(245),
    [anon_sym_RBRACK] = ACTIONS(243),
    [anon_sym_class] = ACTIONS(245),
    [anon_sym_switch] = ACTIONS(245),
    [anon_sym_LBRACE] = ACTIONS(243),
    [anon_sym_RBRACE] = ACTIONS(243),
    [anon_sym_case] = ACTIONS(245),
    [anon_sym_default] = ACTIONS(245),
    [anon_sym_SEMI] = ACTIONS(243),
    [anon_sym_assert] = ACTIONS(245),
    [anon_sym_do] = ACTIONS(245),
    [anon_sym_while] = ACTIONS(245),
    [anon_sym_break] = ACTIONS(245),
    [anon_sym_continue] = ACTIONS(245),
    [anon_sym_return] = ACTIONS(245),
    [anon_sym_yield] = ACTIONS(245),
    [anon_sym_synchronized] = ACTIONS(245),
    [anon_sym_throw] = ACTIONS(245),
    [anon_sym_try] = ACTIONS(245),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_else] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(245),
    [anon_sym_AT] = ACTIONS(245),
    [anon_sym_open] = ACTIONS(245),
    [anon_sym_module] = ACTIONS(245),
    [anon_sym_static] = ACTIONS(245),
    [anon_sym_package] = ACTIONS(245),
    [anon_sym_import] = ACTIONS(245),
    [anon_sym_enum] = ACTIONS(245),
    [anon_sym_public] = ACTIONS(245),
    [anon_sym_protected] = ACTIONS(245),
    [anon_sym_private] = ACTIONS(245),
    [anon_sym_abstract] = ACTIONS(245),
    [anon_sym_final] = ACTIONS(245),
    [anon_sym_strictfp] = ACTIONS(245),
    [anon_sym_native] = ACTIONS(245),
    [anon_sym_transient] = ACTIONS(245),
    [anon_sym_volatile] = ACTIONS(245),
    [anon_sym_record] = ACTIONS(245),
    [anon_sym_ATinterface] = ACTIONS(243),
    [anon_sym_interface] = ACTIONS(245),
    [anon_sym_byte] = ACTIONS(245),
    [anon_sym_short] = ACTIONS(245),
    [anon_sym_int] = ACTIONS(245),
    [anon_sym_long] = ACTIONS(245),
    [anon_sym_char] = ACTIONS(245),
    [anon_sym_float] = ACTIONS(245),
    [anon_sym_double] = ACTIONS(245),
    [sym_boolean_type] = ACTIONS(245),
    [sym_void_type] = ACTIONS(245),
    [sym_this] = ACTIONS(245),
    [sym_super] = ACTIONS(245),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [49] = {
    [ts_builtin_sym_end] = ACTIONS(247),
    [sym_identifier] = ACTIONS(249),
    [sym_decimal_integer_literal] = ACTIONS(249),
    [sym_hex_integer_literal] = ACTIONS(249),
    [sym_octal_integer_literal] = ACTIONS(247),
    [sym_binary_integer_literal] = ACTIONS(247),
    [sym_decimal_floating_point_literal] = ACTIONS(247),
    [sym_hex_floating_point_literal] = ACTIONS(249),
    [sym_true] = ACTIONS(249),
    [sym_false] = ACTIONS(249),
    [sym_character_literal] = ACTIONS(247),
    [sym_string_literal] = ACTIONS(249),
    [sym_text_block] = ACTIONS(247),
    [sym_null_literal] = ACTIONS(249),
    [anon_sym_LPAREN] = ACTIONS(247),
    [anon_sym_AMP] = ACTIONS(249),
    [anon_sym_RPAREN] = ACTIONS(247),
    [anon_sym_GT] = ACTIONS(249),
    [anon_sym_LT] = ACTIONS(249),
    [anon_sym_GT_EQ] = ACTIONS(247),
    [anon_sym_LT_EQ] = ACTIONS(247),
    [anon_sym_EQ_EQ] = ACTIONS(247),
    [anon_sym_BANG_EQ] = ACTIONS(247),
    [anon_sym_AMP_AMP] = ACTIONS(247),
    [anon_sym_PIPE_PIPE] = ACTIONS(247),
    [anon_sym_PLUS] = ACTIONS(249),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_STAR] = ACTIONS(247),
    [anon_sym_SLASH] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(249),
    [anon_sym_CARET] = ACTIONS(247),
    [anon_sym_PERCENT] = ACTIONS(247),
    [anon_sym_LT_LT] = ACTIONS(247),
    [anon_sym_GT_GT] = ACTIONS(249),
    [anon_sym_GT_GT_GT] = ACTIONS(247),
    [anon_sym_instanceof] = ACTIONS(249),
    [anon_sym_DASH_GT] = ACTIONS(247),
    [anon_sym_COMMA] = ACTIONS(247),
    [anon_sym_QMARK] = ACTIONS(247),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_BANG] = ACTIONS(249),
    [anon_sym_TILDE] = ACTIONS(247),
    [anon_sym_PLUS_PLUS] = ACTIONS(247),
    [anon_sym_DASH_DASH] = ACTIONS(247),
    [anon_sym_new] = ACTIONS(249),
    [anon_sym_RBRACK] = ACTIONS(247),
    [anon_sym_class] = ACTIONS(249),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_LBRACE] = ACTIONS(247),
    [anon_sym_RBRACE] = ACTIONS(247),
    [anon_sym_case] = ACTIONS(249),
    [anon_sym_default] = ACTIONS(249),
    [anon_sym_SEMI] = ACTIONS(247),
    [anon_sym_assert] = ACTIONS(249),
    [anon_sym_do] = ACTIONS(249),
    [anon_sym_while] = ACTIONS(249),
    [anon_sym_break] = ACTIONS(249),
    [anon_sym_continue] = ACTIONS(249),
    [anon_sym_return] = ACTIONS(249),
    [anon_sym_yield] = ACTIONS(249),
    [anon_sym_synchronized] = ACTIONS(249),
    [anon_sym_throw] = ACTIONS(249),
    [anon_sym_try] = ACTIONS(249),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_else] = ACTIONS(249),
    [anon_sym_for] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [anon_sym_open] = ACTIONS(249),
    [anon_sym_module] = ACTIONS(249),
    [anon_sym_static] = ACTIONS(249),
    [anon_sym_package] = ACTIONS(249),
    [anon_sym_import] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(249),
    [anon_sym_public] = ACTIONS(249),
    [anon_sym_protected] = ACTIONS(249),
    [anon_sym_private] = ACTIONS(249),
    [anon_sym_abstract] = ACTIONS(249),
    [anon_sym_final] = ACTIONS(249),
    [anon_sym_strictfp] = ACTIONS(249),
    [anon_sym_native] = ACTIONS(249),
    [anon_sym_transient] = ACTIONS(249),
    [anon_sym_volatile] = ACTIONS(249),
    [anon_sym_ATinterface] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_byte] = ACTIONS(249),
    [anon_sym_short] = ACTIONS(249),
    [anon_sym_int] = ACTIONS(249),
    [anon_sym_long] = ACTIONS(249),
    [anon_sym_char] = ACTIONS(249),
    [anon_sym_float] = ACTIONS(249),
    [anon_sym_double] = ACTIONS(249),
    [sym_boolean_type] = ACTIONS(249),
    [sym_void_type] = ACTIONS(249),
    [sym_this] = ACTIONS(249),
    [sym_super] = ACTIONS(249),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [50] = {
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(251),
    [sym_hex_integer_literal] = ACTIONS(251),
    [sym_octal_integer_literal] = ACTIONS(253),
    [sym_binary_integer_literal] = ACTIONS(253),
    [sym_decimal_floating_point_literal] = ACTIONS(253),
    [sym_hex_floating_point_literal] = ACTIONS(251),
    [sym_true] = ACTIONS(251),
    [sym_false] = ACTIONS(251),
    [sym_character_literal] = ACTIONS(253),
    [sym_string_literal] = ACTIONS(251),
    [sym_text_block] = ACTIONS(253),
    [sym_null_literal] = ACTIONS(251),
    [anon_sym_LPAREN] = ACTIONS(253),
    [anon_sym_AMP] = ACTIONS(251),
    [anon_sym_RPAREN] = ACTIONS(253),
    [anon_sym_GT] = ACTIONS(251),
    [anon_sym_LT] = ACTIONS(251),
    [anon_sym_GT_EQ] = ACTIONS(253),
    [anon_sym_LT_EQ] = ACTIONS(253),
    [anon_sym_EQ_EQ] = ACTIONS(253),
    [anon_sym_BANG_EQ] = ACTIONS(253),
    [anon_sym_AMP_AMP] = ACTIONS(253),
    [anon_sym_PIPE_PIPE] = ACTIONS(253),
    [anon_sym_PLUS] = ACTIONS(251),
    [anon_sym_DASH] = ACTIONS(251),
    [anon_sym_STAR] = ACTIONS(253),
    [anon_sym_SLASH] = ACTIONS(251),
    [anon_sym_PIPE] = ACTIONS(251),
    [anon_sym_CARET] = ACTIONS(253),
    [anon_sym_PERCENT] = ACTIONS(253),
    [anon_sym_LT_LT] = ACTIONS(253),
    [anon_sym_GT_GT] = ACTIONS(251),
    [anon_sym_GT_GT_GT] = ACTIONS(253),
    [anon_sym_instanceof] = ACTIONS(251),
    [anon_sym_DASH_GT] = ACTIONS(253),
    [anon_sym_COMMA] = ACTIONS(253),
    [anon_sym_QMARK] = ACTIONS(253),
    [anon_sym_COLON] = ACTIONS(251),
    [anon_sym_BANG] = ACTIONS(251),
    [anon_sym_TILDE] = ACTIONS(253),
    [anon_sym_PLUS_PLUS] = ACTIONS(253),
    [anon_sym_DASH_DASH] = ACTIONS(253),
    [anon_sym_new] = ACTIONS(251),
    [anon_sym_LBRACK] = ACTIONS(253),
    [anon_sym_RBRACK] = ACTIONS(253),
    [anon_sym_DOT] = ACTIONS(251),
    [anon_sym_class] = ACTIONS(251),
    [anon_sym_COLON_COLON] = ACTIONS(253),
    [anon_sym_switch] = ACTIONS(251),
    [anon_sym_LBRACE] = ACTIONS(253),
    [anon_sym_RBRACE] = ACTIONS(253),
    [anon_sym_default] = ACTIONS(251),
    [anon_sym_SEMI] = ACTIONS(253),
    [anon_sym_assert] = ACTIONS(251),
    [anon_sym_do] = ACTIONS(251),
    [anon_sym_while] = ACTIONS(251),
    [anon_sym_break] = ACTIONS(251),
    [anon_sym_continue] = ACTIONS(251),
    [anon_sym_return] = ACTIONS(251),
    [anon_sym_yield] = ACTIONS(251),
    [anon_sym_synchronized] = ACTIONS(251),
    [anon_sym_throw] = ACTIONS(251),
    [anon_sym_try] = ACTIONS(251),
    [anon_sym_if] = ACTIONS(251),
    [anon_sym_for] = ACTIONS(251),
    [anon_sym_AT] = ACTIONS(251),
    [anon_sym_open] = ACTIONS(251),
    [anon_sym_module] = ACTIONS(251),
    [anon_sym_static] = ACTIONS(251),
    [anon_sym_package] = ACTIONS(251),
    [anon_sym_import] = ACTIONS(251),
    [anon_sym_enum] = ACTIONS(251),
    [anon_sym_public] = ACTIONS(251),
    [anon_sym_protected] = ACTIONS(251),
    [anon_sym_private] = ACTIONS(251),
    [anon_sym_abstract] = ACTIONS(251),
    [anon_sym_final] = ACTIONS(251),
    [anon_sym_strictfp] = ACTIONS(251),
    [anon_sym_native] = ACTIONS(251),
    [anon_sym_transient] = ACTIONS(251),
    [anon_sym_volatile] = ACTIONS(251),
    [anon_sym_ATinterface] = ACTIONS(253),
    [anon_sym_interface] = ACTIONS(251),
    [anon_sym_byte] = ACTIONS(251),
    [anon_sym_short] = ACTIONS(251),
    [anon_sym_int] = ACTIONS(251),
    [anon_sym_long] = ACTIONS(251),
    [anon_sym_char] = ACTIONS(251),
    [anon_sym_float] = ACTIONS(251),
    [anon_sym_double] = ACTIONS(251),
    [sym_boolean_type] = ACTIONS(251),
    [sym_void_type] = ACTIONS(251),
    [sym_this] = ACTIONS(251),
    [sym_super] = ACTIONS(251),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [51] = {
    [ts_builtin_sym_end] = ACTIONS(255),
    [sym_identifier] = ACTIONS(257),
    [sym_decimal_integer_literal] = ACTIONS(257),
    [sym_hex_integer_literal] = ACTIONS(257),
    [sym_octal_integer_literal] = ACTIONS(255),
    [sym_binary_integer_literal] = ACTIONS(255),
    [sym_decimal_floating_point_literal] = ACTIONS(255),
    [sym_hex_floating_point_literal] = ACTIONS(257),
    [sym_true] = ACTIONS(257),
    [sym_false] = ACTIONS(257),
    [sym_character_literal] = ACTIONS(255),
    [sym_string_literal] = ACTIONS(257),
    [sym_text_block] = ACTIONS(255),
    [sym_null_literal] = ACTIONS(257),
    [anon_sym_LPAREN] = ACTIONS(255),
    [anon_sym_AMP] = ACTIONS(257),
    [anon_sym_RPAREN] = ACTIONS(255),
    [anon_sym_GT] = ACTIONS(257),
    [anon_sym_LT] = ACTIONS(257),
    [anon_sym_GT_EQ] = ACTIONS(255),
    [anon_sym_LT_EQ] = ACTIONS(255),
    [anon_sym_EQ_EQ] = ACTIONS(255),
    [anon_sym_BANG_EQ] = ACTIONS(255),
    [anon_sym_AMP_AMP] = ACTIONS(255),
    [anon_sym_PIPE_PIPE] = ACTIONS(255),
    [anon_sym_PLUS] = ACTIONS(257),
    [anon_sym_DASH] = ACTIONS(257),
    [anon_sym_STAR] = ACTIONS(255),
    [anon_sym_SLASH] = ACTIONS(257),
    [anon_sym_PIPE] = ACTIONS(257),
    [anon_sym_CARET] = ACTIONS(255),
    [anon_sym_PERCENT] = ACTIONS(255),
    [anon_sym_LT_LT] = ACTIONS(255),
    [anon_sym_GT_GT] = ACTIONS(257),
    [anon_sym_GT_GT_GT] = ACTIONS(255),
    [anon_sym_instanceof] = ACTIONS(257),
    [anon_sym_DASH_GT] = ACTIONS(255),
    [anon_sym_COMMA] = ACTIONS(255),
    [anon_sym_QMARK] = ACTIONS(255),
    [anon_sym_COLON] = ACTIONS(255),
    [anon_sym_BANG] = ACTIONS(257),
    [anon_sym_TILDE] = ACTIONS(255),
    [anon_sym_PLUS_PLUS] = ACTIONS(255),
    [anon_sym_DASH_DASH] = ACTIONS(255),
    [anon_sym_new] = ACTIONS(257),
    [anon_sym_RBRACK] = ACTIONS(255),
    [anon_sym_class] = ACTIONS(257),
    [anon_sym_switch] = ACTIONS(257),
    [anon_sym_LBRACE] = ACTIONS(255),
    [anon_sym_RBRACE] = ACTIONS(255),
    [anon_sym_case] = ACTIONS(257),
    [anon_sym_default] = ACTIONS(257),
    [anon_sym_SEMI] = ACTIONS(255),
    [anon_sym_assert] = ACTIONS(257),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_while] = ACTIONS(257),
    [anon_sym_break] = ACTIONS(257),
    [anon_sym_continue] = ACTIONS(257),
    [anon_sym_return] = ACTIONS(257),
    [anon_sym_yield] = ACTIONS(257),
    [anon_sym_synchronized] = ACTIONS(257),
    [anon_sym_throw] = ACTIONS(257),
    [anon_sym_try] = ACTIONS(257),
    [anon_sym_if] = ACTIONS(257),
    [anon_sym_else] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(257),
    [anon_sym_open] = ACTIONS(257),
    [anon_sym_module] = ACTIONS(257),
    [anon_sym_static] = ACTIONS(257),
    [anon_sym_package] = ACTIONS(257),
    [anon_sym_import] = ACTIONS(257),
    [anon_sym_enum] = ACTIONS(257),
    [anon_sym_public] = ACTIONS(257),
    [anon_sym_protected] = ACTIONS(257),
    [anon_sym_private] = ACTIONS(257),
    [anon_sym_abstract] = ACTIONS(257),
    [anon_sym_final] = ACTIONS(257),
    [anon_sym_strictfp] = ACTIONS(257),
    [anon_sym_native] = ACTIONS(257),
    [anon_sym_transient] = ACTIONS(257),
    [anon_sym_volatile] = ACTIONS(257),
    [anon_sym_ATinterface] = ACTIONS(255),
    [anon_sym_interface] = ACTIONS(257),
    [anon_sym_byte] = ACTIONS(257),
    [anon_sym_short] = ACTIONS(257),
    [anon_sym_int] = ACTIONS(257),
    [anon_sym_long] = ACTIONS(257),
    [anon_sym_char] = ACTIONS(257),
    [anon_sym_float] = ACTIONS(257),
    [anon_sym_double] = ACTIONS(257),
    [sym_boolean_type] = ACTIONS(257),
    [sym_void_type] = ACTIONS(257),
    [sym_this] = ACTIONS(257),
    [sym_super] = ACTIONS(257),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [52] = {
    [ts_builtin_sym_end] = ACTIONS(259),
    [sym_identifier] = ACTIONS(261),
    [sym_decimal_integer_literal] = ACTIONS(261),
    [sym_hex_integer_literal] = ACTIONS(261),
    [sym_octal_integer_literal] = ACTIONS(259),
    [sym_binary_integer_literal] = ACTIONS(259),
    [sym_decimal_floating_point_literal] = ACTIONS(259),
    [sym_hex_floating_point_literal] = ACTIONS(261),
    [sym_true] = ACTIONS(261),
    [sym_false] = ACTIONS(261),
    [sym_character_literal] = ACTIONS(259),
    [sym_string_literal] = ACTIONS(261),
    [sym_text_block] = ACTIONS(259),
    [sym_null_literal] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(259),
    [anon_sym_AMP] = ACTIONS(261),
    [anon_sym_RPAREN] = ACTIONS(259),
    [anon_sym_GT] = ACTIONS(261),
    [anon_sym_LT] = ACTIONS(261),
    [anon_sym_GT_EQ] = ACTIONS(259),
    [anon_sym_LT_EQ] = ACTIONS(259),
    [anon_sym_EQ_EQ] = ACTIONS(259),
    [anon_sym_BANG_EQ] = ACTIONS(259),
    [anon_sym_AMP_AMP] = ACTIONS(259),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_PLUS] = ACTIONS(261),
    [anon_sym_DASH] = ACTIONS(261),
    [anon_sym_STAR] = ACTIONS(259),
    [anon_sym_SLASH] = ACTIONS(261),
    [anon_sym_PIPE] = ACTIONS(261),
    [anon_sym_CARET] = ACTIONS(259),
    [anon_sym_PERCENT] = ACTIONS(259),
    [anon_sym_LT_LT] = ACTIONS(259),
    [anon_sym_GT_GT] = ACTIONS(261),
    [anon_sym_GT_GT_GT] = ACTIONS(259),
    [anon_sym_instanceof] = ACTIONS(261),
    [anon_sym_DASH_GT] = ACTIONS(259),
    [anon_sym_COMMA] = ACTIONS(259),
    [anon_sym_QMARK] = ACTIONS(259),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_BANG] = ACTIONS(261),
    [anon_sym_TILDE] = ACTIONS(259),
    [anon_sym_PLUS_PLUS] = ACTIONS(259),
    [anon_sym_DASH_DASH] = ACTIONS(259),
    [anon_sym_new] = ACTIONS(261),
    [anon_sym_RBRACK] = ACTIONS(259),
    [anon_sym_class] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(261),
    [anon_sym_LBRACE] = ACTIONS(259),
    [anon_sym_RBRACE] = ACTIONS(259),
    [anon_sym_case] = ACTIONS(261),
    [anon_sym_default] = ACTIONS(261),
    [anon_sym_SEMI] = ACTIONS(259),
    [anon_sym_assert] = ACTIONS(261),
    [anon_sym_do] = ACTIONS(261),
    [anon_sym_while] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(261),
    [anon_sym_continue] = ACTIONS(261),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_yield] = ACTIONS(261),
    [anon_sym_synchronized] = ACTIONS(261),
    [anon_sym_throw] = ACTIONS(261),
    [anon_sym_try] = ACTIONS(261),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_else] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [anon_sym_open] = ACTIONS(261),
    [anon_sym_module] = ACTIONS(261),
    [anon_sym_static] = ACTIONS(261),
    [anon_sym_package] = ACTIONS(261),
    [anon_sym_import] = ACTIONS(261),
    [anon_sym_enum] = ACTIONS(261),
    [anon_sym_public] = ACTIONS(261),
    [anon_sym_protected] = ACTIONS(261),
    [anon_sym_private] = ACTIONS(261),
    [anon_sym_abstract] = ACTIONS(261),
    [anon_sym_final] = ACTIONS(261),
    [anon_sym_strictfp] = ACTIONS(261),
    [anon_sym_native] = ACTIONS(261),
    [anon_sym_transient] = ACTIONS(261),
    [anon_sym_volatile] = ACTIONS(261),
    [anon_sym_ATinterface] = ACTIONS(259),
    [anon_sym_interface] = ACTIONS(261),
    [anon_sym_byte] = ACTIONS(261),
    [anon_sym_short] = ACTIONS(261),
    [anon_sym_int] = ACTIONS(261),
    [anon_sym_long] = ACTIONS(261),
    [anon_sym_char] = ACTIONS(261),
    [anon_sym_float] = ACTIONS(261),
    [anon_sym_double] = ACTIONS(261),
    [sym_boolean_type] = ACTIONS(261),
    [sym_void_type] = ACTIONS(261),
    [sym_this] = ACTIONS(261),
    [sym_super] = ACTIONS(261),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [53] = {
    [ts_builtin_sym_end] = ACTIONS(263),
    [sym_identifier] = ACTIONS(265),
    [sym_decimal_integer_literal] = ACTIONS(265),
    [sym_hex_integer_literal] = ACTIONS(265),
    [sym_octal_integer_literal] = ACTIONS(263),
    [sym_binary_integer_literal] = ACTIONS(263),
    [sym_decimal_floating_point_literal] = ACTIONS(263),
    [sym_hex_floating_point_literal] = ACTIONS(265),
    [sym_true] = ACTIONS(265),
    [sym_false] = ACTIONS(265),
    [sym_character_literal] = ACTIONS(263),
    [sym_string_literal] = ACTIONS(265),
    [sym_text_block] = ACTIONS(263),
    [sym_null_literal] = ACTIONS(265),
    [anon_sym_LPAREN] = ACTIONS(263),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_GT_EQ] = ACTIONS(269),
    [anon_sym_LT_EQ] = ACTIONS(269),
    [anon_sym_EQ_EQ] = ACTIONS(269),
    [anon_sym_BANG_EQ] = ACTIONS(269),
    [anon_sym_AMP_AMP] = ACTIONS(269),
    [anon_sym_PIPE_PIPE] = ACTIONS(269),
    [anon_sym_PLUS] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(269),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(269),
    [anon_sym_PERCENT] = ACTIONS(269),
    [anon_sym_LT_LT] = ACTIONS(269),
    [anon_sym_GT_GT] = ACTIONS(267),
    [anon_sym_GT_GT_GT] = ACTIONS(269),
    [anon_sym_instanceof] = ACTIONS(267),
    [anon_sym_QMARK] = ACTIONS(269),
    [anon_sym_BANG] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(263),
    [anon_sym_PLUS_PLUS] = ACTIONS(269),
    [anon_sym_DASH_DASH] = ACTIONS(269),
    [anon_sym_new] = ACTIONS(265),
    [anon_sym_class] = ACTIONS(265),
    [anon_sym_switch] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(263),
    [anon_sym_RBRACE] = ACTIONS(263),
    [anon_sym_case] = ACTIONS(265),
    [anon_sym_default] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(269),
    [anon_sym_assert] = ACTIONS(265),
    [anon_sym_do] = ACTIONS(265),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(265),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(265),
    [anon_sym_yield] = ACTIONS(265),
    [anon_sym_synchronized] = ACTIONS(265),
    [anon_sym_throw] = ACTIONS(265),
    [anon_sym_try] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(265),
    [anon_sym_else] = ACTIONS(265),
    [anon_sym_for] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_open] = ACTIONS(265),
    [anon_sym_module] = ACTIONS(265),
    [anon_sym_static] = ACTIONS(265),
    [anon_sym_package] = ACTIONS(265),
    [anon_sym_import] = ACTIONS(265),
    [anon_sym_enum] = ACTIONS(265),
    [anon_sym_public] = ACTIONS(265),
    [anon_sym_protected] = ACTIONS(265),
    [anon_sym_private] = ACTIONS(265),
    [anon_sym_abstract] = ACTIONS(265),
    [anon_sym_final] = ACTIONS(265),
    [anon_sym_strictfp] = ACTIONS(265),
    [anon_sym_native] = ACTIONS(265),
    [anon_sym_transient] = ACTIONS(265),
    [anon_sym_volatile] = ACTIONS(265),
    [anon_sym_ATinterface] = ACTIONS(263),
    [anon_sym_interface] = ACTIONS(265),
    [anon_sym_byte] = ACTIONS(265),
    [anon_sym_short] = ACTIONS(265),
    [anon_sym_int] = ACTIONS(265),
    [anon_sym_long] = ACTIONS(265),
    [anon_sym_char] = ACTIONS(265),
    [anon_sym_float] = ACTIONS(265),
    [anon_sym_double] = ACTIONS(265),
    [sym_boolean_type] = ACTIONS(265),
    [sym_void_type] = ACTIONS(265),
    [sym_this] = ACTIONS(265),
    [sym_super] = ACTIONS(265),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [54] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(500),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(531),
    [sym_marker_annotation] = STATE(531),
    [sym_annotation] = STATE(531),
    [sym_modifiers] = STATE(563),
    [sym__type] = STATE(757),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_formal_parameter] = STATE(827),
    [sym_receiver_parameter] = STATE(315),
    [sym_spread_parameter] = STATE(827),
    [aux_sym_dimensions_expr_repeat1] = STATE(542),
    [aux_sym_modifiers_repeat1] = STATE(447),
    [sym_identifier] = ACTIONS(271),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(273),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_default] = ACTIONS(275),
    [anon_sym_synchronized] = ACTIONS(275),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_static] = ACTIONS(275),
    [anon_sym_public] = ACTIONS(275),
    [anon_sym_protected] = ACTIONS(275),
    [anon_sym_private] = ACTIONS(275),
    [anon_sym_abstract] = ACTIONS(275),
    [anon_sym_final] = ACTIONS(275),
    [anon_sym_strictfp] = ACTIONS(275),
    [anon_sym_native] = ACTIONS(275),
    [anon_sym_transient] = ACTIONS(275),
    [anon_sym_volatile] = ACTIONS(275),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [55] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(500),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(531),
    [sym_marker_annotation] = STATE(531),
    [sym_annotation] = STATE(531),
    [sym_modifiers] = STATE(563),
    [sym__type] = STATE(781),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_formal_parameter] = STATE(827),
    [sym_receiver_parameter] = STATE(315),
    [sym_spread_parameter] = STATE(827),
    [aux_sym_dimensions_expr_repeat1] = STATE(542),
    [aux_sym_modifiers_repeat1] = STATE(447),
    [sym_identifier] = ACTIONS(271),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(273),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_default] = ACTIONS(275),
    [anon_sym_synchronized] = ACTIONS(275),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_static] = ACTIONS(275),
    [anon_sym_public] = ACTIONS(275),
    [anon_sym_protected] = ACTIONS(275),
    [anon_sym_private] = ACTIONS(275),
    [anon_sym_abstract] = ACTIONS(275),
    [anon_sym_final] = ACTIONS(275),
    [anon_sym_strictfp] = ACTIONS(275),
    [anon_sym_native] = ACTIONS(275),
    [anon_sym_transient] = ACTIONS(275),
    [anon_sym_volatile] = ACTIONS(275),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [56] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(531),
    [sym_marker_annotation] = STATE(531),
    [sym_annotation] = STATE(531),
    [sym_modifiers] = STATE(568),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(565),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [sym_local_variable_declaration] = STATE(122),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [aux_sym_modifiers_repeat1] = STATE(447),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_default] = ACTIONS(275),
    [anon_sym_SEMI] = ACTIONS(283),
    [anon_sym_synchronized] = ACTIONS(275),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_static] = ACTIONS(275),
    [anon_sym_public] = ACTIONS(275),
    [anon_sym_protected] = ACTIONS(275),
    [anon_sym_private] = ACTIONS(275),
    [anon_sym_abstract] = ACTIONS(275),
    [anon_sym_final] = ACTIONS(275),
    [anon_sym_strictfp] = ACTIONS(275),
    [anon_sym_native] = ACTIONS(275),
    [anon_sym_transient] = ACTIONS(275),
    [anon_sym_volatile] = ACTIONS(275),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [57] = {
    [sym_catch_clause] = STATE(65),
    [sym_finally_clause] = STATE(260),
    [aux_sym_try_statement_repeat1] = STATE(65),
    [ts_builtin_sym_end] = ACTIONS(285),
    [sym_identifier] = ACTIONS(287),
    [sym_decimal_integer_literal] = ACTIONS(287),
    [sym_hex_integer_literal] = ACTIONS(287),
    [sym_octal_integer_literal] = ACTIONS(285),
    [sym_binary_integer_literal] = ACTIONS(285),
    [sym_decimal_floating_point_literal] = ACTIONS(285),
    [sym_hex_floating_point_literal] = ACTIONS(287),
    [sym_true] = ACTIONS(287),
    [sym_false] = ACTIONS(287),
    [sym_character_literal] = ACTIONS(285),
    [sym_string_literal] = ACTIONS(287),
    [sym_text_block] = ACTIONS(285),
    [sym_null_literal] = ACTIONS(287),
    [anon_sym_LPAREN] = ACTIONS(285),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_BANG] = ACTIONS(285),
    [anon_sym_TILDE] = ACTIONS(285),
    [anon_sym_PLUS_PLUS] = ACTIONS(285),
    [anon_sym_DASH_DASH] = ACTIONS(285),
    [anon_sym_new] = ACTIONS(287),
    [anon_sym_class] = ACTIONS(287),
    [anon_sym_switch] = ACTIONS(287),
    [anon_sym_LBRACE] = ACTIONS(285),
    [anon_sym_RBRACE] = ACTIONS(285),
    [anon_sym_case] = ACTIONS(287),
    [anon_sym_default] = ACTIONS(287),
    [anon_sym_SEMI] = ACTIONS(285),
    [anon_sym_assert] = ACTIONS(287),
    [anon_sym_do] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(287),
    [anon_sym_break] = ACTIONS(287),
    [anon_sym_continue] = ACTIONS(287),
    [anon_sym_return] = ACTIONS(287),
    [anon_sym_yield] = ACTIONS(287),
    [anon_sym_synchronized] = ACTIONS(287),
    [anon_sym_throw] = ACTIONS(287),
    [anon_sym_try] = ACTIONS(287),
    [anon_sym_catch] = ACTIONS(289),
    [anon_sym_finally] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(287),
    [anon_sym_else] = ACTIONS(287),
    [anon_sym_for] = ACTIONS(287),
    [anon_sym_AT] = ACTIONS(287),
    [anon_sym_open] = ACTIONS(287),
    [anon_sym_module] = ACTIONS(287),
    [anon_sym_static] = ACTIONS(287),
    [anon_sym_package] = ACTIONS(287),
    [anon_sym_import] = ACTIONS(287),
    [anon_sym_enum] = ACTIONS(287),
    [anon_sym_public] = ACTIONS(287),
    [anon_sym_protected] = ACTIONS(287),
    [anon_sym_private] = ACTIONS(287),
    [anon_sym_abstract] = ACTIONS(287),
    [anon_sym_final] = ACTIONS(287),
    [anon_sym_strictfp] = ACTIONS(287),
    [anon_sym_native] = ACTIONS(287),
    [anon_sym_transient] = ACTIONS(287),
    [anon_sym_volatile] = ACTIONS(287),
    [anon_sym_ATinterface] = ACTIONS(285),
    [anon_sym_interface] = ACTIONS(287),
    [anon_sym_byte] = ACTIONS(287),
    [anon_sym_short] = ACTIONS(287),
    [anon_sym_int] = ACTIONS(287),
    [anon_sym_long] = ACTIONS(287),
    [anon_sym_char] = ACTIONS(287),
    [anon_sym_float] = ACTIONS(287),
    [anon_sym_double] = ACTIONS(287),
    [sym_boolean_type] = ACTIONS(287),
    [sym_void_type] = ACTIONS(287),
    [sym_this] = ACTIONS(287),
    [sym_super] = ACTIONS(287),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [58] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(443),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym__element_value] = STATE(846),
    [sym_element_value_array_initializer] = STATE(846),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(293),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(295),
    [anon_sym_RBRACE] = ACTIONS(297),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [59] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym_block] = STATE(842),
    [sym_expression_statement] = STATE(842),
    [sym_throw_statement] = STATE(842),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [60] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(443),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_element_value_pair] = STATE(837),
    [sym__element_value] = STATE(1025),
    [sym_element_value_array_initializer] = STATE(1025),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(299),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(295),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [61] = {
    [sym_catch_clause] = STATE(57),
    [sym_finally_clause] = STATE(194),
    [aux_sym_try_statement_repeat1] = STATE(57),
    [ts_builtin_sym_end] = ACTIONS(303),
    [sym_identifier] = ACTIONS(305),
    [sym_decimal_integer_literal] = ACTIONS(305),
    [sym_hex_integer_literal] = ACTIONS(305),
    [sym_octal_integer_literal] = ACTIONS(303),
    [sym_binary_integer_literal] = ACTIONS(303),
    [sym_decimal_floating_point_literal] = ACTIONS(303),
    [sym_hex_floating_point_literal] = ACTIONS(305),
    [sym_true] = ACTIONS(305),
    [sym_false] = ACTIONS(305),
    [sym_character_literal] = ACTIONS(303),
    [sym_string_literal] = ACTIONS(305),
    [sym_text_block] = ACTIONS(303),
    [sym_null_literal] = ACTIONS(305),
    [anon_sym_LPAREN] = ACTIONS(303),
    [anon_sym_PLUS] = ACTIONS(305),
    [anon_sym_DASH] = ACTIONS(305),
    [anon_sym_BANG] = ACTIONS(303),
    [anon_sym_TILDE] = ACTIONS(303),
    [anon_sym_PLUS_PLUS] = ACTIONS(303),
    [anon_sym_DASH_DASH] = ACTIONS(303),
    [anon_sym_new] = ACTIONS(305),
    [anon_sym_class] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(305),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_RBRACE] = ACTIONS(303),
    [anon_sym_case] = ACTIONS(305),
    [anon_sym_default] = ACTIONS(305),
    [anon_sym_SEMI] = ACTIONS(303),
    [anon_sym_assert] = ACTIONS(305),
    [anon_sym_do] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_break] = ACTIONS(305),
    [anon_sym_continue] = ACTIONS(305),
    [anon_sym_return] = ACTIONS(305),
    [anon_sym_yield] = ACTIONS(305),
    [anon_sym_synchronized] = ACTIONS(305),
    [anon_sym_throw] = ACTIONS(305),
    [anon_sym_try] = ACTIONS(305),
    [anon_sym_catch] = ACTIONS(289),
    [anon_sym_finally] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_else] = ACTIONS(305),
    [anon_sym_for] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_static] = ACTIONS(305),
    [anon_sym_package] = ACTIONS(305),
    [anon_sym_import] = ACTIONS(305),
    [anon_sym_enum] = ACTIONS(305),
    [anon_sym_public] = ACTIONS(305),
    [anon_sym_protected] = ACTIONS(305),
    [anon_sym_private] = ACTIONS(305),
    [anon_sym_abstract] = ACTIONS(305),
    [anon_sym_final] = ACTIONS(305),
    [anon_sym_strictfp] = ACTIONS(305),
    [anon_sym_native] = ACTIONS(305),
    [anon_sym_transient] = ACTIONS(305),
    [anon_sym_volatile] = ACTIONS(305),
    [anon_sym_ATinterface] = ACTIONS(303),
    [anon_sym_interface] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(305),
    [anon_sym_short] = ACTIONS(305),
    [anon_sym_int] = ACTIONS(305),
    [anon_sym_long] = ACTIONS(305),
    [anon_sym_char] = ACTIONS(305),
    [anon_sym_float] = ACTIONS(305),
    [anon_sym_double] = ACTIONS(305),
    [sym_boolean_type] = ACTIONS(305),
    [sym_void_type] = ACTIONS(305),
    [sym_this] = ACTIONS(305),
    [sym_super] = ACTIONS(305),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [62] = {
    [sym_catch_clause] = STATE(65),
    [sym_finally_clause] = STATE(195),
    [aux_sym_try_statement_repeat1] = STATE(65),
    [ts_builtin_sym_end] = ACTIONS(307),
    [sym_identifier] = ACTIONS(309),
    [sym_decimal_integer_literal] = ACTIONS(309),
    [sym_hex_integer_literal] = ACTIONS(309),
    [sym_octal_integer_literal] = ACTIONS(307),
    [sym_binary_integer_literal] = ACTIONS(307),
    [sym_decimal_floating_point_literal] = ACTIONS(307),
    [sym_hex_floating_point_literal] = ACTIONS(309),
    [sym_true] = ACTIONS(309),
    [sym_false] = ACTIONS(309),
    [sym_character_literal] = ACTIONS(307),
    [sym_string_literal] = ACTIONS(309),
    [sym_text_block] = ACTIONS(307),
    [sym_null_literal] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_PLUS] = ACTIONS(309),
    [anon_sym_DASH] = ACTIONS(309),
    [anon_sym_BANG] = ACTIONS(307),
    [anon_sym_TILDE] = ACTIONS(307),
    [anon_sym_PLUS_PLUS] = ACTIONS(307),
    [anon_sym_DASH_DASH] = ACTIONS(307),
    [anon_sym_new] = ACTIONS(309),
    [anon_sym_class] = ACTIONS(309),
    [anon_sym_switch] = ACTIONS(309),
    [anon_sym_LBRACE] = ACTIONS(307),
    [anon_sym_RBRACE] = ACTIONS(307),
    [anon_sym_case] = ACTIONS(309),
    [anon_sym_default] = ACTIONS(309),
    [anon_sym_SEMI] = ACTIONS(307),
    [anon_sym_assert] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(309),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_break] = ACTIONS(309),
    [anon_sym_continue] = ACTIONS(309),
    [anon_sym_return] = ACTIONS(309),
    [anon_sym_yield] = ACTIONS(309),
    [anon_sym_synchronized] = ACTIONS(309),
    [anon_sym_throw] = ACTIONS(309),
    [anon_sym_try] = ACTIONS(309),
    [anon_sym_catch] = ACTIONS(289),
    [anon_sym_finally] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(309),
    [anon_sym_else] = ACTIONS(309),
    [anon_sym_for] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [anon_sym_open] = ACTIONS(309),
    [anon_sym_module] = ACTIONS(309),
    [anon_sym_static] = ACTIONS(309),
    [anon_sym_package] = ACTIONS(309),
    [anon_sym_import] = ACTIONS(309),
    [anon_sym_enum] = ACTIONS(309),
    [anon_sym_public] = ACTIONS(309),
    [anon_sym_protected] = ACTIONS(309),
    [anon_sym_private] = ACTIONS(309),
    [anon_sym_abstract] = ACTIONS(309),
    [anon_sym_final] = ACTIONS(309),
    [anon_sym_strictfp] = ACTIONS(309),
    [anon_sym_native] = ACTIONS(309),
    [anon_sym_transient] = ACTIONS(309),
    [anon_sym_volatile] = ACTIONS(309),
    [anon_sym_ATinterface] = ACTIONS(307),
    [anon_sym_interface] = ACTIONS(309),
    [anon_sym_byte] = ACTIONS(309),
    [anon_sym_short] = ACTIONS(309),
    [anon_sym_int] = ACTIONS(309),
    [anon_sym_long] = ACTIONS(309),
    [anon_sym_char] = ACTIONS(309),
    [anon_sym_float] = ACTIONS(309),
    [anon_sym_double] = ACTIONS(309),
    [sym_boolean_type] = ACTIONS(309),
    [sym_void_type] = ACTIONS(309),
    [sym_this] = ACTIONS(309),
    [sym_super] = ACTIONS(309),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [63] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(443),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_element_value_pair] = STATE(870),
    [sym__element_value] = STATE(1069),
    [sym_element_value_array_initializer] = STATE(1069),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(299),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(295),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [64] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(467),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym_array_initializer] = STATE(881),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(313),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(315),
    [anon_sym_RBRACE] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [65] = {
    [sym_catch_clause] = STATE(65),
    [aux_sym_try_statement_repeat1] = STATE(65),
    [ts_builtin_sym_end] = ACTIONS(319),
    [sym_identifier] = ACTIONS(321),
    [sym_decimal_integer_literal] = ACTIONS(321),
    [sym_hex_integer_literal] = ACTIONS(321),
    [sym_octal_integer_literal] = ACTIONS(319),
    [sym_binary_integer_literal] = ACTIONS(319),
    [sym_decimal_floating_point_literal] = ACTIONS(319),
    [sym_hex_floating_point_literal] = ACTIONS(321),
    [sym_true] = ACTIONS(321),
    [sym_false] = ACTIONS(321),
    [sym_character_literal] = ACTIONS(319),
    [sym_string_literal] = ACTIONS(321),
    [sym_text_block] = ACTIONS(319),
    [sym_null_literal] = ACTIONS(321),
    [anon_sym_LPAREN] = ACTIONS(319),
    [anon_sym_PLUS] = ACTIONS(321),
    [anon_sym_DASH] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(319),
    [anon_sym_PLUS_PLUS] = ACTIONS(319),
    [anon_sym_DASH_DASH] = ACTIONS(319),
    [anon_sym_new] = ACTIONS(321),
    [anon_sym_class] = ACTIONS(321),
    [anon_sym_switch] = ACTIONS(321),
    [anon_sym_LBRACE] = ACTIONS(319),
    [anon_sym_RBRACE] = ACTIONS(319),
    [anon_sym_case] = ACTIONS(321),
    [anon_sym_default] = ACTIONS(321),
    [anon_sym_SEMI] = ACTIONS(319),
    [anon_sym_assert] = ACTIONS(321),
    [anon_sym_do] = ACTIONS(321),
    [anon_sym_while] = ACTIONS(321),
    [anon_sym_break] = ACTIONS(321),
    [anon_sym_continue] = ACTIONS(321),
    [anon_sym_return] = ACTIONS(321),
    [anon_sym_yield] = ACTIONS(321),
    [anon_sym_synchronized] = ACTIONS(321),
    [anon_sym_throw] = ACTIONS(321),
    [anon_sym_try] = ACTIONS(321),
    [anon_sym_catch] = ACTIONS(323),
    [anon_sym_finally] = ACTIONS(321),
    [anon_sym_if] = ACTIONS(321),
    [anon_sym_else] = ACTIONS(321),
    [anon_sym_for] = ACTIONS(321),
    [anon_sym_AT] = ACTIONS(321),
    [anon_sym_open] = ACTIONS(321),
    [anon_sym_module] = ACTIONS(321),
    [anon_sym_static] = ACTIONS(321),
    [anon_sym_package] = ACTIONS(321),
    [anon_sym_import] = ACTIONS(321),
    [anon_sym_enum] = ACTIONS(321),
    [anon_sym_public] = ACTIONS(321),
    [anon_sym_protected] = ACTIONS(321),
    [anon_sym_private] = ACTIONS(321),
    [anon_sym_abstract] = ACTIONS(321),
    [anon_sym_final] = ACTIONS(321),
    [anon_sym_strictfp] = ACTIONS(321),
    [anon_sym_native] = ACTIONS(321),
    [anon_sym_transient] = ACTIONS(321),
    [anon_sym_volatile] = ACTIONS(321),
    [anon_sym_ATinterface] = ACTIONS(319),
    [anon_sym_interface] = ACTIONS(321),
    [anon_sym_byte] = ACTIONS(321),
    [anon_sym_short] = ACTIONS(321),
    [anon_sym_int] = ACTIONS(321),
    [anon_sym_long] = ACTIONS(321),
    [anon_sym_char] = ACTIONS(321),
    [anon_sym_float] = ACTIONS(321),
    [anon_sym_double] = ACTIONS(321),
    [sym_boolean_type] = ACTIONS(321),
    [sym_void_type] = ACTIONS(321),
    [sym_this] = ACTIONS(321),
    [sym_super] = ACTIONS(321),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [66] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(443),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym__element_value] = STATE(973),
    [sym_element_value_array_initializer] = STATE(973),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(295),
    [anon_sym_RBRACE] = ACTIONS(326),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [67] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(443),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym__element_value] = STATE(973),
    [sym_element_value_array_initializer] = STATE(973),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(295),
    [anon_sym_RBRACE] = ACTIONS(328),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [68] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(443),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym__element_value] = STATE(973),
    [sym_element_value_array_initializer] = STATE(973),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(295),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [69] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(443),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym__element_value] = STATE(909),
    [sym_element_value_array_initializer] = STATE(909),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(295),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [70] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(494),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym__element_value] = STATE(909),
    [sym_element_value_array_initializer] = STATE(909),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(295),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [71] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(492),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym_array_initializer] = STATE(942),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(315),
    [anon_sym_RBRACE] = ACTIONS(330),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [72] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(443),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym__element_value] = STATE(1032),
    [sym_element_value_array_initializer] = STATE(1032),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(295),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [73] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(492),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym_array_initializer] = STATE(942),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(315),
    [anon_sym_RBRACE] = ACTIONS(332),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [74] = {
    [ts_builtin_sym_end] = ACTIONS(334),
    [sym_identifier] = ACTIONS(336),
    [sym_decimal_integer_literal] = ACTIONS(336),
    [sym_hex_integer_literal] = ACTIONS(336),
    [sym_octal_integer_literal] = ACTIONS(334),
    [sym_binary_integer_literal] = ACTIONS(334),
    [sym_decimal_floating_point_literal] = ACTIONS(334),
    [sym_hex_floating_point_literal] = ACTIONS(336),
    [sym_true] = ACTIONS(336),
    [sym_false] = ACTIONS(336),
    [sym_character_literal] = ACTIONS(334),
    [sym_string_literal] = ACTIONS(336),
    [sym_text_block] = ACTIONS(334),
    [sym_null_literal] = ACTIONS(336),
    [anon_sym_LPAREN] = ACTIONS(334),
    [anon_sym_LT] = ACTIONS(334),
    [anon_sym_PLUS] = ACTIONS(336),
    [anon_sym_DASH] = ACTIONS(336),
    [anon_sym_BANG] = ACTIONS(334),
    [anon_sym_TILDE] = ACTIONS(334),
    [anon_sym_PLUS_PLUS] = ACTIONS(334),
    [anon_sym_DASH_DASH] = ACTIONS(334),
    [anon_sym_new] = ACTIONS(336),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_switch] = ACTIONS(336),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_RBRACE] = ACTIONS(334),
    [anon_sym_case] = ACTIONS(336),
    [anon_sym_default] = ACTIONS(336),
    [anon_sym_SEMI] = ACTIONS(334),
    [anon_sym_assert] = ACTIONS(336),
    [anon_sym_do] = ACTIONS(336),
    [anon_sym_while] = ACTIONS(336),
    [anon_sym_break] = ACTIONS(336),
    [anon_sym_continue] = ACTIONS(336),
    [anon_sym_return] = ACTIONS(336),
    [anon_sym_yield] = ACTIONS(336),
    [anon_sym_synchronized] = ACTIONS(336),
    [anon_sym_throw] = ACTIONS(336),
    [anon_sym_try] = ACTIONS(336),
    [anon_sym_if] = ACTIONS(336),
    [anon_sym_else] = ACTIONS(336),
    [anon_sym_for] = ACTIONS(336),
    [anon_sym_AT] = ACTIONS(336),
    [anon_sym_open] = ACTIONS(336),
    [anon_sym_module] = ACTIONS(336),
    [anon_sym_static] = ACTIONS(336),
    [anon_sym_package] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(336),
    [anon_sym_enum] = ACTIONS(336),
    [anon_sym_public] = ACTIONS(336),
    [anon_sym_protected] = ACTIONS(336),
    [anon_sym_private] = ACTIONS(336),
    [anon_sym_abstract] = ACTIONS(336),
    [anon_sym_final] = ACTIONS(336),
    [anon_sym_strictfp] = ACTIONS(336),
    [anon_sym_native] = ACTIONS(336),
    [anon_sym_transient] = ACTIONS(336),
    [anon_sym_volatile] = ACTIONS(336),
    [anon_sym_record] = ACTIONS(336),
    [anon_sym_ATinterface] = ACTIONS(334),
    [anon_sym_interface] = ACTIONS(336),
    [anon_sym_byte] = ACTIONS(336),
    [anon_sym_short] = ACTIONS(336),
    [anon_sym_int] = ACTIONS(336),
    [anon_sym_long] = ACTIONS(336),
    [anon_sym_char] = ACTIONS(336),
    [anon_sym_float] = ACTIONS(336),
    [anon_sym_double] = ACTIONS(336),
    [sym_boolean_type] = ACTIONS(336),
    [sym_void_type] = ACTIONS(336),
    [sym_this] = ACTIONS(336),
    [sym_super] = ACTIONS(336),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [75] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(424),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym_block] = STATE(417),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [76] = {
    [ts_builtin_sym_end] = ACTIONS(338),
    [sym_identifier] = ACTIONS(340),
    [sym_decimal_integer_literal] = ACTIONS(340),
    [sym_hex_integer_literal] = ACTIONS(340),
    [sym_octal_integer_literal] = ACTIONS(338),
    [sym_binary_integer_literal] = ACTIONS(338),
    [sym_decimal_floating_point_literal] = ACTIONS(338),
    [sym_hex_floating_point_literal] = ACTIONS(340),
    [sym_true] = ACTIONS(340),
    [sym_false] = ACTIONS(340),
    [sym_character_literal] = ACTIONS(338),
    [sym_string_literal] = ACTIONS(340),
    [sym_text_block] = ACTIONS(338),
    [sym_null_literal] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(338),
    [anon_sym_LT] = ACTIONS(338),
    [anon_sym_PLUS] = ACTIONS(340),
    [anon_sym_DASH] = ACTIONS(340),
    [anon_sym_BANG] = ACTIONS(338),
    [anon_sym_TILDE] = ACTIONS(338),
    [anon_sym_PLUS_PLUS] = ACTIONS(338),
    [anon_sym_DASH_DASH] = ACTIONS(338),
    [anon_sym_new] = ACTIONS(340),
    [anon_sym_class] = ACTIONS(340),
    [anon_sym_switch] = ACTIONS(340),
    [anon_sym_LBRACE] = ACTIONS(338),
    [anon_sym_RBRACE] = ACTIONS(338),
    [anon_sym_case] = ACTIONS(340),
    [anon_sym_default] = ACTIONS(340),
    [anon_sym_SEMI] = ACTIONS(338),
    [anon_sym_assert] = ACTIONS(340),
    [anon_sym_do] = ACTIONS(340),
    [anon_sym_while] = ACTIONS(340),
    [anon_sym_break] = ACTIONS(340),
    [anon_sym_continue] = ACTIONS(340),
    [anon_sym_return] = ACTIONS(340),
    [anon_sym_yield] = ACTIONS(340),
    [anon_sym_synchronized] = ACTIONS(340),
    [anon_sym_throw] = ACTIONS(340),
    [anon_sym_try] = ACTIONS(340),
    [anon_sym_if] = ACTIONS(340),
    [anon_sym_else] = ACTIONS(340),
    [anon_sym_for] = ACTIONS(340),
    [anon_sym_AT] = ACTIONS(340),
    [anon_sym_open] = ACTIONS(340),
    [anon_sym_module] = ACTIONS(340),
    [anon_sym_static] = ACTIONS(340),
    [anon_sym_package] = ACTIONS(340),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_enum] = ACTIONS(340),
    [anon_sym_public] = ACTIONS(340),
    [anon_sym_protected] = ACTIONS(340),
    [anon_sym_private] = ACTIONS(340),
    [anon_sym_abstract] = ACTIONS(340),
    [anon_sym_final] = ACTIONS(340),
    [anon_sym_strictfp] = ACTIONS(340),
    [anon_sym_native] = ACTIONS(340),
    [anon_sym_transient] = ACTIONS(340),
    [anon_sym_volatile] = ACTIONS(340),
    [anon_sym_record] = ACTIONS(340),
    [anon_sym_ATinterface] = ACTIONS(338),
    [anon_sym_interface] = ACTIONS(340),
    [anon_sym_byte] = ACTIONS(340),
    [anon_sym_short] = ACTIONS(340),
    [anon_sym_int] = ACTIONS(340),
    [anon_sym_long] = ACTIONS(340),
    [anon_sym_char] = ACTIONS(340),
    [anon_sym_float] = ACTIONS(340),
    [anon_sym_double] = ACTIONS(340),
    [sym_boolean_type] = ACTIONS(340),
    [sym_void_type] = ACTIONS(340),
    [sym_this] = ACTIONS(340),
    [sym_super] = ACTIONS(340),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [77] = {
    [ts_builtin_sym_end] = ACTIONS(342),
    [sym_identifier] = ACTIONS(344),
    [sym_decimal_integer_literal] = ACTIONS(344),
    [sym_hex_integer_literal] = ACTIONS(344),
    [sym_octal_integer_literal] = ACTIONS(342),
    [sym_binary_integer_literal] = ACTIONS(342),
    [sym_decimal_floating_point_literal] = ACTIONS(342),
    [sym_hex_floating_point_literal] = ACTIONS(344),
    [sym_true] = ACTIONS(344),
    [sym_false] = ACTIONS(344),
    [sym_character_literal] = ACTIONS(342),
    [sym_string_literal] = ACTIONS(344),
    [sym_text_block] = ACTIONS(342),
    [sym_null_literal] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_LT] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(342),
    [anon_sym_TILDE] = ACTIONS(342),
    [anon_sym_PLUS_PLUS] = ACTIONS(342),
    [anon_sym_DASH_DASH] = ACTIONS(342),
    [anon_sym_new] = ACTIONS(344),
    [anon_sym_class] = ACTIONS(344),
    [anon_sym_switch] = ACTIONS(344),
    [anon_sym_LBRACE] = ACTIONS(342),
    [anon_sym_RBRACE] = ACTIONS(342),
    [anon_sym_case] = ACTIONS(344),
    [anon_sym_default] = ACTIONS(344),
    [anon_sym_SEMI] = ACTIONS(342),
    [anon_sym_assert] = ACTIONS(344),
    [anon_sym_do] = ACTIONS(344),
    [anon_sym_while] = ACTIONS(344),
    [anon_sym_break] = ACTIONS(344),
    [anon_sym_continue] = ACTIONS(344),
    [anon_sym_return] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(344),
    [anon_sym_synchronized] = ACTIONS(344),
    [anon_sym_throw] = ACTIONS(344),
    [anon_sym_try] = ACTIONS(344),
    [anon_sym_if] = ACTIONS(344),
    [anon_sym_else] = ACTIONS(344),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_open] = ACTIONS(344),
    [anon_sym_module] = ACTIONS(344),
    [anon_sym_static] = ACTIONS(344),
    [anon_sym_package] = ACTIONS(344),
    [anon_sym_import] = ACTIONS(344),
    [anon_sym_enum] = ACTIONS(344),
    [anon_sym_public] = ACTIONS(344),
    [anon_sym_protected] = ACTIONS(344),
    [anon_sym_private] = ACTIONS(344),
    [anon_sym_abstract] = ACTIONS(344),
    [anon_sym_final] = ACTIONS(344),
    [anon_sym_strictfp] = ACTIONS(344),
    [anon_sym_native] = ACTIONS(344),
    [anon_sym_transient] = ACTIONS(344),
    [anon_sym_volatile] = ACTIONS(344),
    [anon_sym_record] = ACTIONS(344),
    [anon_sym_ATinterface] = ACTIONS(342),
    [anon_sym_interface] = ACTIONS(344),
    [anon_sym_byte] = ACTIONS(344),
    [anon_sym_short] = ACTIONS(344),
    [anon_sym_int] = ACTIONS(344),
    [anon_sym_long] = ACTIONS(344),
    [anon_sym_char] = ACTIONS(344),
    [anon_sym_float] = ACTIONS(344),
    [anon_sym_double] = ACTIONS(344),
    [sym_boolean_type] = ACTIONS(344),
    [sym_void_type] = ACTIONS(344),
    [sym_this] = ACTIONS(344),
    [sym_super] = ACTIONS(344),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [78] = {
    [ts_builtin_sym_end] = ACTIONS(346),
    [sym_identifier] = ACTIONS(348),
    [sym_decimal_integer_literal] = ACTIONS(348),
    [sym_hex_integer_literal] = ACTIONS(348),
    [sym_octal_integer_literal] = ACTIONS(346),
    [sym_binary_integer_literal] = ACTIONS(346),
    [sym_decimal_floating_point_literal] = ACTIONS(346),
    [sym_hex_floating_point_literal] = ACTIONS(348),
    [sym_true] = ACTIONS(348),
    [sym_false] = ACTIONS(348),
    [sym_character_literal] = ACTIONS(346),
    [sym_string_literal] = ACTIONS(348),
    [sym_text_block] = ACTIONS(346),
    [sym_null_literal] = ACTIONS(348),
    [anon_sym_LPAREN] = ACTIONS(346),
    [anon_sym_LT] = ACTIONS(346),
    [anon_sym_PLUS] = ACTIONS(348),
    [anon_sym_DASH] = ACTIONS(348),
    [anon_sym_BANG] = ACTIONS(346),
    [anon_sym_TILDE] = ACTIONS(346),
    [anon_sym_PLUS_PLUS] = ACTIONS(346),
    [anon_sym_DASH_DASH] = ACTIONS(346),
    [anon_sym_new] = ACTIONS(348),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_switch] = ACTIONS(348),
    [anon_sym_LBRACE] = ACTIONS(346),
    [anon_sym_RBRACE] = ACTIONS(346),
    [anon_sym_case] = ACTIONS(348),
    [anon_sym_default] = ACTIONS(348),
    [anon_sym_SEMI] = ACTIONS(346),
    [anon_sym_assert] = ACTIONS(348),
    [anon_sym_do] = ACTIONS(348),
    [anon_sym_while] = ACTIONS(348),
    [anon_sym_break] = ACTIONS(348),
    [anon_sym_continue] = ACTIONS(348),
    [anon_sym_return] = ACTIONS(348),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_synchronized] = ACTIONS(348),
    [anon_sym_throw] = ACTIONS(348),
    [anon_sym_try] = ACTIONS(348),
    [anon_sym_if] = ACTIONS(348),
    [anon_sym_else] = ACTIONS(348),
    [anon_sym_for] = ACTIONS(348),
    [anon_sym_AT] = ACTIONS(348),
    [anon_sym_open] = ACTIONS(348),
    [anon_sym_module] = ACTIONS(348),
    [anon_sym_static] = ACTIONS(348),
    [anon_sym_package] = ACTIONS(348),
    [anon_sym_import] = ACTIONS(348),
    [anon_sym_enum] = ACTIONS(348),
    [anon_sym_public] = ACTIONS(348),
    [anon_sym_protected] = ACTIONS(348),
    [anon_sym_private] = ACTIONS(348),
    [anon_sym_abstract] = ACTIONS(348),
    [anon_sym_final] = ACTIONS(348),
    [anon_sym_strictfp] = ACTIONS(348),
    [anon_sym_native] = ACTIONS(348),
    [anon_sym_transient] = ACTIONS(348),
    [anon_sym_volatile] = ACTIONS(348),
    [anon_sym_record] = ACTIONS(348),
    [anon_sym_ATinterface] = ACTIONS(346),
    [anon_sym_interface] = ACTIONS(348),
    [anon_sym_byte] = ACTIONS(348),
    [anon_sym_short] = ACTIONS(348),
    [anon_sym_int] = ACTIONS(348),
    [anon_sym_long] = ACTIONS(348),
    [anon_sym_char] = ACTIONS(348),
    [anon_sym_float] = ACTIONS(348),
    [anon_sym_double] = ACTIONS(348),
    [sym_boolean_type] = ACTIONS(348),
    [sym_void_type] = ACTIONS(348),
    [sym_this] = ACTIONS(348),
    [sym_super] = ACTIONS(348),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [79] = {
    [ts_builtin_sym_end] = ACTIONS(350),
    [sym_identifier] = ACTIONS(352),
    [sym_decimal_integer_literal] = ACTIONS(352),
    [sym_hex_integer_literal] = ACTIONS(352),
    [sym_octal_integer_literal] = ACTIONS(350),
    [sym_binary_integer_literal] = ACTIONS(350),
    [sym_decimal_floating_point_literal] = ACTIONS(350),
    [sym_hex_floating_point_literal] = ACTIONS(352),
    [sym_true] = ACTIONS(352),
    [sym_false] = ACTIONS(352),
    [sym_character_literal] = ACTIONS(350),
    [sym_string_literal] = ACTIONS(352),
    [sym_text_block] = ACTIONS(350),
    [sym_null_literal] = ACTIONS(352),
    [anon_sym_LPAREN] = ACTIONS(350),
    [anon_sym_LT] = ACTIONS(350),
    [anon_sym_PLUS] = ACTIONS(352),
    [anon_sym_DASH] = ACTIONS(352),
    [anon_sym_BANG] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(350),
    [anon_sym_DASH_DASH] = ACTIONS(350),
    [anon_sym_new] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(352),
    [anon_sym_switch] = ACTIONS(352),
    [anon_sym_LBRACE] = ACTIONS(350),
    [anon_sym_RBRACE] = ACTIONS(350),
    [anon_sym_case] = ACTIONS(352),
    [anon_sym_default] = ACTIONS(352),
    [anon_sym_SEMI] = ACTIONS(350),
    [anon_sym_assert] = ACTIONS(352),
    [anon_sym_do] = ACTIONS(352),
    [anon_sym_while] = ACTIONS(352),
    [anon_sym_break] = ACTIONS(352),
    [anon_sym_continue] = ACTIONS(352),
    [anon_sym_return] = ACTIONS(352),
    [anon_sym_yield] = ACTIONS(352),
    [anon_sym_synchronized] = ACTIONS(352),
    [anon_sym_throw] = ACTIONS(352),
    [anon_sym_try] = ACTIONS(352),
    [anon_sym_if] = ACTIONS(352),
    [anon_sym_else] = ACTIONS(352),
    [anon_sym_for] = ACTIONS(352),
    [anon_sym_AT] = ACTIONS(352),
    [anon_sym_open] = ACTIONS(352),
    [anon_sym_module] = ACTIONS(352),
    [anon_sym_static] = ACTIONS(352),
    [anon_sym_package] = ACTIONS(352),
    [anon_sym_import] = ACTIONS(352),
    [anon_sym_enum] = ACTIONS(352),
    [anon_sym_public] = ACTIONS(352),
    [anon_sym_protected] = ACTIONS(352),
    [anon_sym_private] = ACTIONS(352),
    [anon_sym_abstract] = ACTIONS(352),
    [anon_sym_final] = ACTIONS(352),
    [anon_sym_strictfp] = ACTIONS(352),
    [anon_sym_native] = ACTIONS(352),
    [anon_sym_transient] = ACTIONS(352),
    [anon_sym_volatile] = ACTIONS(352),
    [anon_sym_record] = ACTIONS(352),
    [anon_sym_ATinterface] = ACTIONS(350),
    [anon_sym_interface] = ACTIONS(352),
    [anon_sym_byte] = ACTIONS(352),
    [anon_sym_short] = ACTIONS(352),
    [anon_sym_int] = ACTIONS(352),
    [anon_sym_long] = ACTIONS(352),
    [anon_sym_char] = ACTIONS(352),
    [anon_sym_float] = ACTIONS(352),
    [anon_sym_double] = ACTIONS(352),
    [sym_boolean_type] = ACTIONS(352),
    [sym_void_type] = ACTIONS(352),
    [sym_this] = ACTIONS(352),
    [sym_super] = ACTIONS(352),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [80] = {
    [ts_builtin_sym_end] = ACTIONS(354),
    [sym_identifier] = ACTIONS(356),
    [sym_decimal_integer_literal] = ACTIONS(356),
    [sym_hex_integer_literal] = ACTIONS(356),
    [sym_octal_integer_literal] = ACTIONS(354),
    [sym_binary_integer_literal] = ACTIONS(354),
    [sym_decimal_floating_point_literal] = ACTIONS(354),
    [sym_hex_floating_point_literal] = ACTIONS(356),
    [sym_true] = ACTIONS(356),
    [sym_false] = ACTIONS(356),
    [sym_character_literal] = ACTIONS(354),
    [sym_string_literal] = ACTIONS(356),
    [sym_text_block] = ACTIONS(354),
    [sym_null_literal] = ACTIONS(356),
    [anon_sym_LPAREN] = ACTIONS(354),
    [anon_sym_LT] = ACTIONS(354),
    [anon_sym_PLUS] = ACTIONS(356),
    [anon_sym_DASH] = ACTIONS(356),
    [anon_sym_BANG] = ACTIONS(354),
    [anon_sym_TILDE] = ACTIONS(354),
    [anon_sym_PLUS_PLUS] = ACTIONS(354),
    [anon_sym_DASH_DASH] = ACTIONS(354),
    [anon_sym_new] = ACTIONS(356),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_switch] = ACTIONS(356),
    [anon_sym_LBRACE] = ACTIONS(354),
    [anon_sym_RBRACE] = ACTIONS(354),
    [anon_sym_case] = ACTIONS(356),
    [anon_sym_default] = ACTIONS(356),
    [anon_sym_SEMI] = ACTIONS(354),
    [anon_sym_assert] = ACTIONS(356),
    [anon_sym_do] = ACTIONS(356),
    [anon_sym_while] = ACTIONS(356),
    [anon_sym_break] = ACTIONS(356),
    [anon_sym_continue] = ACTIONS(356),
    [anon_sym_return] = ACTIONS(356),
    [anon_sym_yield] = ACTIONS(356),
    [anon_sym_synchronized] = ACTIONS(356),
    [anon_sym_throw] = ACTIONS(356),
    [anon_sym_try] = ACTIONS(356),
    [anon_sym_if] = ACTIONS(356),
    [anon_sym_else] = ACTIONS(356),
    [anon_sym_for] = ACTIONS(356),
    [anon_sym_AT] = ACTIONS(356),
    [anon_sym_open] = ACTIONS(356),
    [anon_sym_module] = ACTIONS(356),
    [anon_sym_static] = ACTIONS(356),
    [anon_sym_package] = ACTIONS(356),
    [anon_sym_import] = ACTIONS(356),
    [anon_sym_enum] = ACTIONS(356),
    [anon_sym_public] = ACTIONS(356),
    [anon_sym_protected] = ACTIONS(356),
    [anon_sym_private] = ACTIONS(356),
    [anon_sym_abstract] = ACTIONS(356),
    [anon_sym_final] = ACTIONS(356),
    [anon_sym_strictfp] = ACTIONS(356),
    [anon_sym_native] = ACTIONS(356),
    [anon_sym_transient] = ACTIONS(356),
    [anon_sym_volatile] = ACTIONS(356),
    [anon_sym_record] = ACTIONS(356),
    [anon_sym_ATinterface] = ACTIONS(354),
    [anon_sym_interface] = ACTIONS(356),
    [anon_sym_byte] = ACTIONS(356),
    [anon_sym_short] = ACTIONS(356),
    [anon_sym_int] = ACTIONS(356),
    [anon_sym_long] = ACTIONS(356),
    [anon_sym_char] = ACTIONS(356),
    [anon_sym_float] = ACTIONS(356),
    [anon_sym_double] = ACTIONS(356),
    [sym_boolean_type] = ACTIONS(356),
    [sym_void_type] = ACTIONS(356),
    [sym_this] = ACTIONS(356),
    [sym_super] = ACTIONS(356),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [81] = {
    [ts_builtin_sym_end] = ACTIONS(358),
    [sym_identifier] = ACTIONS(360),
    [sym_decimal_integer_literal] = ACTIONS(360),
    [sym_hex_integer_literal] = ACTIONS(360),
    [sym_octal_integer_literal] = ACTIONS(358),
    [sym_binary_integer_literal] = ACTIONS(358),
    [sym_decimal_floating_point_literal] = ACTIONS(358),
    [sym_hex_floating_point_literal] = ACTIONS(360),
    [sym_true] = ACTIONS(360),
    [sym_false] = ACTIONS(360),
    [sym_character_literal] = ACTIONS(358),
    [sym_string_literal] = ACTIONS(360),
    [sym_text_block] = ACTIONS(358),
    [sym_null_literal] = ACTIONS(360),
    [anon_sym_LPAREN] = ACTIONS(358),
    [anon_sym_LT] = ACTIONS(358),
    [anon_sym_PLUS] = ACTIONS(360),
    [anon_sym_DASH] = ACTIONS(360),
    [anon_sym_BANG] = ACTIONS(358),
    [anon_sym_TILDE] = ACTIONS(358),
    [anon_sym_PLUS_PLUS] = ACTIONS(358),
    [anon_sym_DASH_DASH] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_class] = ACTIONS(360),
    [anon_sym_switch] = ACTIONS(360),
    [anon_sym_LBRACE] = ACTIONS(358),
    [anon_sym_RBRACE] = ACTIONS(358),
    [anon_sym_case] = ACTIONS(360),
    [anon_sym_default] = ACTIONS(360),
    [anon_sym_SEMI] = ACTIONS(358),
    [anon_sym_assert] = ACTIONS(360),
    [anon_sym_do] = ACTIONS(360),
    [anon_sym_while] = ACTIONS(360),
    [anon_sym_break] = ACTIONS(360),
    [anon_sym_continue] = ACTIONS(360),
    [anon_sym_return] = ACTIONS(360),
    [anon_sym_yield] = ACTIONS(360),
    [anon_sym_synchronized] = ACTIONS(360),
    [anon_sym_throw] = ACTIONS(360),
    [anon_sym_try] = ACTIONS(360),
    [anon_sym_if] = ACTIONS(360),
    [anon_sym_else] = ACTIONS(360),
    [anon_sym_for] = ACTIONS(360),
    [anon_sym_AT] = ACTIONS(360),
    [anon_sym_open] = ACTIONS(360),
    [anon_sym_module] = ACTIONS(360),
    [anon_sym_static] = ACTIONS(360),
    [anon_sym_package] = ACTIONS(360),
    [anon_sym_import] = ACTIONS(360),
    [anon_sym_enum] = ACTIONS(360),
    [anon_sym_public] = ACTIONS(360),
    [anon_sym_protected] = ACTIONS(360),
    [anon_sym_private] = ACTIONS(360),
    [anon_sym_abstract] = ACTIONS(360),
    [anon_sym_final] = ACTIONS(360),
    [anon_sym_strictfp] = ACTIONS(360),
    [anon_sym_native] = ACTIONS(360),
    [anon_sym_transient] = ACTIONS(360),
    [anon_sym_volatile] = ACTIONS(360),
    [anon_sym_record] = ACTIONS(360),
    [anon_sym_ATinterface] = ACTIONS(358),
    [anon_sym_interface] = ACTIONS(360),
    [anon_sym_byte] = ACTIONS(360),
    [anon_sym_short] = ACTIONS(360),
    [anon_sym_int] = ACTIONS(360),
    [anon_sym_long] = ACTIONS(360),
    [anon_sym_char] = ACTIONS(360),
    [anon_sym_float] = ACTIONS(360),
    [anon_sym_double] = ACTIONS(360),
    [sym_boolean_type] = ACTIONS(360),
    [sym_void_type] = ACTIONS(360),
    [sym_this] = ACTIONS(360),
    [sym_super] = ACTIONS(360),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [82] = {
    [ts_builtin_sym_end] = ACTIONS(362),
    [sym_identifier] = ACTIONS(364),
    [sym_decimal_integer_literal] = ACTIONS(364),
    [sym_hex_integer_literal] = ACTIONS(364),
    [sym_octal_integer_literal] = ACTIONS(362),
    [sym_binary_integer_literal] = ACTIONS(362),
    [sym_decimal_floating_point_literal] = ACTIONS(362),
    [sym_hex_floating_point_literal] = ACTIONS(364),
    [sym_true] = ACTIONS(364),
    [sym_false] = ACTIONS(364),
    [sym_character_literal] = ACTIONS(362),
    [sym_string_literal] = ACTIONS(364),
    [sym_text_block] = ACTIONS(362),
    [sym_null_literal] = ACTIONS(364),
    [anon_sym_LPAREN] = ACTIONS(362),
    [anon_sym_LT] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(362),
    [anon_sym_TILDE] = ACTIONS(362),
    [anon_sym_PLUS_PLUS] = ACTIONS(362),
    [anon_sym_DASH_DASH] = ACTIONS(362),
    [anon_sym_new] = ACTIONS(364),
    [anon_sym_class] = ACTIONS(364),
    [anon_sym_switch] = ACTIONS(364),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_RBRACE] = ACTIONS(362),
    [anon_sym_case] = ACTIONS(364),
    [anon_sym_default] = ACTIONS(364),
    [anon_sym_SEMI] = ACTIONS(362),
    [anon_sym_assert] = ACTIONS(364),
    [anon_sym_do] = ACTIONS(364),
    [anon_sym_while] = ACTIONS(364),
    [anon_sym_break] = ACTIONS(364),
    [anon_sym_continue] = ACTIONS(364),
    [anon_sym_return] = ACTIONS(364),
    [anon_sym_yield] = ACTIONS(364),
    [anon_sym_synchronized] = ACTIONS(364),
    [anon_sym_throw] = ACTIONS(364),
    [anon_sym_try] = ACTIONS(364),
    [anon_sym_if] = ACTIONS(364),
    [anon_sym_else] = ACTIONS(364),
    [anon_sym_for] = ACTIONS(364),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_open] = ACTIONS(364),
    [anon_sym_module] = ACTIONS(364),
    [anon_sym_static] = ACTIONS(364),
    [anon_sym_package] = ACTIONS(364),
    [anon_sym_import] = ACTIONS(364),
    [anon_sym_enum] = ACTIONS(364),
    [anon_sym_public] = ACTIONS(364),
    [anon_sym_protected] = ACTIONS(364),
    [anon_sym_private] = ACTIONS(364),
    [anon_sym_abstract] = ACTIONS(364),
    [anon_sym_final] = ACTIONS(364),
    [anon_sym_strictfp] = ACTIONS(364),
    [anon_sym_native] = ACTIONS(364),
    [anon_sym_transient] = ACTIONS(364),
    [anon_sym_volatile] = ACTIONS(364),
    [anon_sym_record] = ACTIONS(364),
    [anon_sym_ATinterface] = ACTIONS(362),
    [anon_sym_interface] = ACTIONS(364),
    [anon_sym_byte] = ACTIONS(364),
    [anon_sym_short] = ACTIONS(364),
    [anon_sym_int] = ACTIONS(364),
    [anon_sym_long] = ACTIONS(364),
    [anon_sym_char] = ACTIONS(364),
    [anon_sym_float] = ACTIONS(364),
    [anon_sym_double] = ACTIONS(364),
    [sym_boolean_type] = ACTIONS(364),
    [sym_void_type] = ACTIONS(364),
    [sym_this] = ACTIONS(364),
    [sym_super] = ACTIONS(364),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [83] = {
    [ts_builtin_sym_end] = ACTIONS(366),
    [sym_identifier] = ACTIONS(368),
    [sym_decimal_integer_literal] = ACTIONS(368),
    [sym_hex_integer_literal] = ACTIONS(368),
    [sym_octal_integer_literal] = ACTIONS(366),
    [sym_binary_integer_literal] = ACTIONS(366),
    [sym_decimal_floating_point_literal] = ACTIONS(366),
    [sym_hex_floating_point_literal] = ACTIONS(368),
    [sym_true] = ACTIONS(368),
    [sym_false] = ACTIONS(368),
    [sym_character_literal] = ACTIONS(366),
    [sym_string_literal] = ACTIONS(368),
    [sym_text_block] = ACTIONS(366),
    [sym_null_literal] = ACTIONS(368),
    [anon_sym_LPAREN] = ACTIONS(366),
    [anon_sym_LT] = ACTIONS(366),
    [anon_sym_PLUS] = ACTIONS(368),
    [anon_sym_DASH] = ACTIONS(368),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(366),
    [anon_sym_DASH_DASH] = ACTIONS(366),
    [anon_sym_new] = ACTIONS(368),
    [anon_sym_class] = ACTIONS(368),
    [anon_sym_switch] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(366),
    [anon_sym_RBRACE] = ACTIONS(366),
    [anon_sym_case] = ACTIONS(368),
    [anon_sym_default] = ACTIONS(368),
    [anon_sym_SEMI] = ACTIONS(366),
    [anon_sym_assert] = ACTIONS(368),
    [anon_sym_do] = ACTIONS(368),
    [anon_sym_while] = ACTIONS(368),
    [anon_sym_break] = ACTIONS(368),
    [anon_sym_continue] = ACTIONS(368),
    [anon_sym_return] = ACTIONS(368),
    [anon_sym_yield] = ACTIONS(368),
    [anon_sym_synchronized] = ACTIONS(368),
    [anon_sym_throw] = ACTIONS(368),
    [anon_sym_try] = ACTIONS(368),
    [anon_sym_if] = ACTIONS(368),
    [anon_sym_else] = ACTIONS(368),
    [anon_sym_for] = ACTIONS(368),
    [anon_sym_AT] = ACTIONS(368),
    [anon_sym_open] = ACTIONS(368),
    [anon_sym_module] = ACTIONS(368),
    [anon_sym_static] = ACTIONS(368),
    [anon_sym_package] = ACTIONS(368),
    [anon_sym_import] = ACTIONS(368),
    [anon_sym_enum] = ACTIONS(368),
    [anon_sym_public] = ACTIONS(368),
    [anon_sym_protected] = ACTIONS(368),
    [anon_sym_private] = ACTIONS(368),
    [anon_sym_abstract] = ACTIONS(368),
    [anon_sym_final] = ACTIONS(368),
    [anon_sym_strictfp] = ACTIONS(368),
    [anon_sym_native] = ACTIONS(368),
    [anon_sym_transient] = ACTIONS(368),
    [anon_sym_volatile] = ACTIONS(368),
    [anon_sym_record] = ACTIONS(368),
    [anon_sym_ATinterface] = ACTIONS(366),
    [anon_sym_interface] = ACTIONS(368),
    [anon_sym_byte] = ACTIONS(368),
    [anon_sym_short] = ACTIONS(368),
    [anon_sym_int] = ACTIONS(368),
    [anon_sym_long] = ACTIONS(368),
    [anon_sym_char] = ACTIONS(368),
    [anon_sym_float] = ACTIONS(368),
    [anon_sym_double] = ACTIONS(368),
    [sym_boolean_type] = ACTIONS(368),
    [sym_void_type] = ACTIONS(368),
    [sym_this] = ACTIONS(368),
    [sym_super] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [84] = {
    [ts_builtin_sym_end] = ACTIONS(370),
    [sym_identifier] = ACTIONS(372),
    [sym_decimal_integer_literal] = ACTIONS(372),
    [sym_hex_integer_literal] = ACTIONS(372),
    [sym_octal_integer_literal] = ACTIONS(370),
    [sym_binary_integer_literal] = ACTIONS(370),
    [sym_decimal_floating_point_literal] = ACTIONS(370),
    [sym_hex_floating_point_literal] = ACTIONS(372),
    [sym_true] = ACTIONS(372),
    [sym_false] = ACTIONS(372),
    [sym_character_literal] = ACTIONS(370),
    [sym_string_literal] = ACTIONS(372),
    [sym_text_block] = ACTIONS(370),
    [sym_null_literal] = ACTIONS(372),
    [anon_sym_LPAREN] = ACTIONS(370),
    [anon_sym_LT] = ACTIONS(370),
    [anon_sym_PLUS] = ACTIONS(372),
    [anon_sym_DASH] = ACTIONS(372),
    [anon_sym_BANG] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(370),
    [anon_sym_PLUS_PLUS] = ACTIONS(370),
    [anon_sym_DASH_DASH] = ACTIONS(370),
    [anon_sym_new] = ACTIONS(372),
    [anon_sym_class] = ACTIONS(372),
    [anon_sym_switch] = ACTIONS(372),
    [anon_sym_LBRACE] = ACTIONS(370),
    [anon_sym_RBRACE] = ACTIONS(370),
    [anon_sym_case] = ACTIONS(372),
    [anon_sym_default] = ACTIONS(372),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym_assert] = ACTIONS(372),
    [anon_sym_do] = ACTIONS(372),
    [anon_sym_while] = ACTIONS(372),
    [anon_sym_break] = ACTIONS(372),
    [anon_sym_continue] = ACTIONS(372),
    [anon_sym_return] = ACTIONS(372),
    [anon_sym_yield] = ACTIONS(372),
    [anon_sym_synchronized] = ACTIONS(372),
    [anon_sym_throw] = ACTIONS(372),
    [anon_sym_try] = ACTIONS(372),
    [anon_sym_if] = ACTIONS(372),
    [anon_sym_else] = ACTIONS(372),
    [anon_sym_for] = ACTIONS(372),
    [anon_sym_AT] = ACTIONS(372),
    [anon_sym_open] = ACTIONS(372),
    [anon_sym_module] = ACTIONS(372),
    [anon_sym_static] = ACTIONS(372),
    [anon_sym_package] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(372),
    [anon_sym_enum] = ACTIONS(372),
    [anon_sym_public] = ACTIONS(372),
    [anon_sym_protected] = ACTIONS(372),
    [anon_sym_private] = ACTIONS(372),
    [anon_sym_abstract] = ACTIONS(372),
    [anon_sym_final] = ACTIONS(372),
    [anon_sym_strictfp] = ACTIONS(372),
    [anon_sym_native] = ACTIONS(372),
    [anon_sym_transient] = ACTIONS(372),
    [anon_sym_volatile] = ACTIONS(372),
    [anon_sym_record] = ACTIONS(372),
    [anon_sym_ATinterface] = ACTIONS(370),
    [anon_sym_interface] = ACTIONS(372),
    [anon_sym_byte] = ACTIONS(372),
    [anon_sym_short] = ACTIONS(372),
    [anon_sym_int] = ACTIONS(372),
    [anon_sym_long] = ACTIONS(372),
    [anon_sym_char] = ACTIONS(372),
    [anon_sym_float] = ACTIONS(372),
    [anon_sym_double] = ACTIONS(372),
    [sym_boolean_type] = ACTIONS(372),
    [sym_void_type] = ACTIONS(372),
    [sym_this] = ACTIONS(372),
    [sym_super] = ACTIONS(372),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [85] = {
    [ts_builtin_sym_end] = ACTIONS(374),
    [sym_identifier] = ACTIONS(376),
    [sym_decimal_integer_literal] = ACTIONS(376),
    [sym_hex_integer_literal] = ACTIONS(376),
    [sym_octal_integer_literal] = ACTIONS(374),
    [sym_binary_integer_literal] = ACTIONS(374),
    [sym_decimal_floating_point_literal] = ACTIONS(374),
    [sym_hex_floating_point_literal] = ACTIONS(376),
    [sym_true] = ACTIONS(376),
    [sym_false] = ACTIONS(376),
    [sym_character_literal] = ACTIONS(374),
    [sym_string_literal] = ACTIONS(376),
    [sym_text_block] = ACTIONS(374),
    [sym_null_literal] = ACTIONS(376),
    [anon_sym_LPAREN] = ACTIONS(374),
    [anon_sym_LT] = ACTIONS(374),
    [anon_sym_PLUS] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(376),
    [anon_sym_BANG] = ACTIONS(374),
    [anon_sym_TILDE] = ACTIONS(374),
    [anon_sym_PLUS_PLUS] = ACTIONS(374),
    [anon_sym_DASH_DASH] = ACTIONS(374),
    [anon_sym_new] = ACTIONS(376),
    [anon_sym_class] = ACTIONS(376),
    [anon_sym_switch] = ACTIONS(376),
    [anon_sym_LBRACE] = ACTIONS(374),
    [anon_sym_RBRACE] = ACTIONS(374),
    [anon_sym_case] = ACTIONS(376),
    [anon_sym_default] = ACTIONS(376),
    [anon_sym_SEMI] = ACTIONS(374),
    [anon_sym_assert] = ACTIONS(376),
    [anon_sym_do] = ACTIONS(376),
    [anon_sym_while] = ACTIONS(376),
    [anon_sym_break] = ACTIONS(376),
    [anon_sym_continue] = ACTIONS(376),
    [anon_sym_return] = ACTIONS(376),
    [anon_sym_yield] = ACTIONS(376),
    [anon_sym_synchronized] = ACTIONS(376),
    [anon_sym_throw] = ACTIONS(376),
    [anon_sym_try] = ACTIONS(376),
    [anon_sym_if] = ACTIONS(376),
    [anon_sym_else] = ACTIONS(376),
    [anon_sym_for] = ACTIONS(376),
    [anon_sym_AT] = ACTIONS(376),
    [anon_sym_open] = ACTIONS(376),
    [anon_sym_module] = ACTIONS(376),
    [anon_sym_static] = ACTIONS(376),
    [anon_sym_package] = ACTIONS(376),
    [anon_sym_import] = ACTIONS(376),
    [anon_sym_enum] = ACTIONS(376),
    [anon_sym_public] = ACTIONS(376),
    [anon_sym_protected] = ACTIONS(376),
    [anon_sym_private] = ACTIONS(376),
    [anon_sym_abstract] = ACTIONS(376),
    [anon_sym_final] = ACTIONS(376),
    [anon_sym_strictfp] = ACTIONS(376),
    [anon_sym_native] = ACTIONS(376),
    [anon_sym_transient] = ACTIONS(376),
    [anon_sym_volatile] = ACTIONS(376),
    [anon_sym_record] = ACTIONS(376),
    [anon_sym_ATinterface] = ACTIONS(374),
    [anon_sym_interface] = ACTIONS(376),
    [anon_sym_byte] = ACTIONS(376),
    [anon_sym_short] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_long] = ACTIONS(376),
    [anon_sym_char] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_double] = ACTIONS(376),
    [sym_boolean_type] = ACTIONS(376),
    [sym_void_type] = ACTIONS(376),
    [sym_this] = ACTIONS(376),
    [sym_super] = ACTIONS(376),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [86] = {
    [ts_builtin_sym_end] = ACTIONS(378),
    [sym_identifier] = ACTIONS(380),
    [sym_decimal_integer_literal] = ACTIONS(380),
    [sym_hex_integer_literal] = ACTIONS(380),
    [sym_octal_integer_literal] = ACTIONS(378),
    [sym_binary_integer_literal] = ACTIONS(378),
    [sym_decimal_floating_point_literal] = ACTIONS(378),
    [sym_hex_floating_point_literal] = ACTIONS(380),
    [sym_true] = ACTIONS(380),
    [sym_false] = ACTIONS(380),
    [sym_character_literal] = ACTIONS(378),
    [sym_string_literal] = ACTIONS(380),
    [sym_text_block] = ACTIONS(378),
    [sym_null_literal] = ACTIONS(380),
    [anon_sym_LPAREN] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(378),
    [anon_sym_PLUS] = ACTIONS(380),
    [anon_sym_DASH] = ACTIONS(380),
    [anon_sym_BANG] = ACTIONS(378),
    [anon_sym_TILDE] = ACTIONS(378),
    [anon_sym_PLUS_PLUS] = ACTIONS(378),
    [anon_sym_DASH_DASH] = ACTIONS(378),
    [anon_sym_new] = ACTIONS(380),
    [anon_sym_class] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(380),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(378),
    [anon_sym_case] = ACTIONS(380),
    [anon_sym_default] = ACTIONS(380),
    [anon_sym_SEMI] = ACTIONS(378),
    [anon_sym_assert] = ACTIONS(380),
    [anon_sym_do] = ACTIONS(380),
    [anon_sym_while] = ACTIONS(380),
    [anon_sym_break] = ACTIONS(380),
    [anon_sym_continue] = ACTIONS(380),
    [anon_sym_return] = ACTIONS(380),
    [anon_sym_yield] = ACTIONS(380),
    [anon_sym_synchronized] = ACTIONS(380),
    [anon_sym_throw] = ACTIONS(380),
    [anon_sym_try] = ACTIONS(380),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_else] = ACTIONS(380),
    [anon_sym_for] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(380),
    [anon_sym_open] = ACTIONS(380),
    [anon_sym_module] = ACTIONS(380),
    [anon_sym_static] = ACTIONS(380),
    [anon_sym_package] = ACTIONS(380),
    [anon_sym_import] = ACTIONS(380),
    [anon_sym_enum] = ACTIONS(380),
    [anon_sym_public] = ACTIONS(380),
    [anon_sym_protected] = ACTIONS(380),
    [anon_sym_private] = ACTIONS(380),
    [anon_sym_abstract] = ACTIONS(380),
    [anon_sym_final] = ACTIONS(380),
    [anon_sym_strictfp] = ACTIONS(380),
    [anon_sym_native] = ACTIONS(380),
    [anon_sym_transient] = ACTIONS(380),
    [anon_sym_volatile] = ACTIONS(380),
    [anon_sym_record] = ACTIONS(380),
    [anon_sym_ATinterface] = ACTIONS(378),
    [anon_sym_interface] = ACTIONS(380),
    [anon_sym_byte] = ACTIONS(380),
    [anon_sym_short] = ACTIONS(380),
    [anon_sym_int] = ACTIONS(380),
    [anon_sym_long] = ACTIONS(380),
    [anon_sym_char] = ACTIONS(380),
    [anon_sym_float] = ACTIONS(380),
    [anon_sym_double] = ACTIONS(380),
    [sym_boolean_type] = ACTIONS(380),
    [sym_void_type] = ACTIONS(380),
    [sym_this] = ACTIONS(380),
    [sym_super] = ACTIONS(380),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [87] = {
    [ts_builtin_sym_end] = ACTIONS(382),
    [sym_identifier] = ACTIONS(384),
    [sym_decimal_integer_literal] = ACTIONS(384),
    [sym_hex_integer_literal] = ACTIONS(384),
    [sym_octal_integer_literal] = ACTIONS(382),
    [sym_binary_integer_literal] = ACTIONS(382),
    [sym_decimal_floating_point_literal] = ACTIONS(382),
    [sym_hex_floating_point_literal] = ACTIONS(384),
    [sym_true] = ACTIONS(384),
    [sym_false] = ACTIONS(384),
    [sym_character_literal] = ACTIONS(382),
    [sym_string_literal] = ACTIONS(384),
    [sym_text_block] = ACTIONS(382),
    [sym_null_literal] = ACTIONS(384),
    [anon_sym_LPAREN] = ACTIONS(382),
    [anon_sym_LT] = ACTIONS(382),
    [anon_sym_PLUS] = ACTIONS(384),
    [anon_sym_DASH] = ACTIONS(384),
    [anon_sym_BANG] = ACTIONS(382),
    [anon_sym_TILDE] = ACTIONS(382),
    [anon_sym_PLUS_PLUS] = ACTIONS(382),
    [anon_sym_DASH_DASH] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(384),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(382),
    [anon_sym_RBRACE] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(384),
    [anon_sym_SEMI] = ACTIONS(382),
    [anon_sym_assert] = ACTIONS(384),
    [anon_sym_do] = ACTIONS(384),
    [anon_sym_while] = ACTIONS(384),
    [anon_sym_break] = ACTIONS(384),
    [anon_sym_continue] = ACTIONS(384),
    [anon_sym_return] = ACTIONS(384),
    [anon_sym_yield] = ACTIONS(384),
    [anon_sym_synchronized] = ACTIONS(384),
    [anon_sym_throw] = ACTIONS(384),
    [anon_sym_try] = ACTIONS(384),
    [anon_sym_if] = ACTIONS(384),
    [anon_sym_else] = ACTIONS(384),
    [anon_sym_for] = ACTIONS(384),
    [anon_sym_AT] = ACTIONS(384),
    [anon_sym_open] = ACTIONS(384),
    [anon_sym_module] = ACTIONS(384),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_package] = ACTIONS(384),
    [anon_sym_import] = ACTIONS(384),
    [anon_sym_enum] = ACTIONS(384),
    [anon_sym_public] = ACTIONS(384),
    [anon_sym_protected] = ACTIONS(384),
    [anon_sym_private] = ACTIONS(384),
    [anon_sym_abstract] = ACTIONS(384),
    [anon_sym_final] = ACTIONS(384),
    [anon_sym_strictfp] = ACTIONS(384),
    [anon_sym_native] = ACTIONS(384),
    [anon_sym_transient] = ACTIONS(384),
    [anon_sym_volatile] = ACTIONS(384),
    [anon_sym_record] = ACTIONS(384),
    [anon_sym_ATinterface] = ACTIONS(382),
    [anon_sym_interface] = ACTIONS(384),
    [anon_sym_byte] = ACTIONS(384),
    [anon_sym_short] = ACTIONS(384),
    [anon_sym_int] = ACTIONS(384),
    [anon_sym_long] = ACTIONS(384),
    [anon_sym_char] = ACTIONS(384),
    [anon_sym_float] = ACTIONS(384),
    [anon_sym_double] = ACTIONS(384),
    [sym_boolean_type] = ACTIONS(384),
    [sym_void_type] = ACTIONS(384),
    [sym_this] = ACTIONS(384),
    [sym_super] = ACTIONS(384),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [88] = {
    [ts_builtin_sym_end] = ACTIONS(386),
    [sym_identifier] = ACTIONS(388),
    [sym_decimal_integer_literal] = ACTIONS(388),
    [sym_hex_integer_literal] = ACTIONS(388),
    [sym_octal_integer_literal] = ACTIONS(386),
    [sym_binary_integer_literal] = ACTIONS(386),
    [sym_decimal_floating_point_literal] = ACTIONS(386),
    [sym_hex_floating_point_literal] = ACTIONS(388),
    [sym_true] = ACTIONS(388),
    [sym_false] = ACTIONS(388),
    [sym_character_literal] = ACTIONS(386),
    [sym_string_literal] = ACTIONS(388),
    [sym_text_block] = ACTIONS(386),
    [sym_null_literal] = ACTIONS(388),
    [anon_sym_LPAREN] = ACTIONS(386),
    [anon_sym_LT] = ACTIONS(386),
    [anon_sym_PLUS] = ACTIONS(388),
    [anon_sym_DASH] = ACTIONS(388),
    [anon_sym_BANG] = ACTIONS(386),
    [anon_sym_TILDE] = ACTIONS(386),
    [anon_sym_PLUS_PLUS] = ACTIONS(386),
    [anon_sym_DASH_DASH] = ACTIONS(386),
    [anon_sym_new] = ACTIONS(388),
    [anon_sym_class] = ACTIONS(388),
    [anon_sym_switch] = ACTIONS(388),
    [anon_sym_LBRACE] = ACTIONS(386),
    [anon_sym_RBRACE] = ACTIONS(386),
    [anon_sym_case] = ACTIONS(388),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_SEMI] = ACTIONS(386),
    [anon_sym_assert] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_break] = ACTIONS(388),
    [anon_sym_continue] = ACTIONS(388),
    [anon_sym_return] = ACTIONS(388),
    [anon_sym_yield] = ACTIONS(388),
    [anon_sym_synchronized] = ACTIONS(388),
    [anon_sym_throw] = ACTIONS(388),
    [anon_sym_try] = ACTIONS(388),
    [anon_sym_if] = ACTIONS(388),
    [anon_sym_else] = ACTIONS(388),
    [anon_sym_for] = ACTIONS(388),
    [anon_sym_AT] = ACTIONS(388),
    [anon_sym_open] = ACTIONS(388),
    [anon_sym_module] = ACTIONS(388),
    [anon_sym_static] = ACTIONS(388),
    [anon_sym_package] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(388),
    [anon_sym_enum] = ACTIONS(388),
    [anon_sym_public] = ACTIONS(388),
    [anon_sym_protected] = ACTIONS(388),
    [anon_sym_private] = ACTIONS(388),
    [anon_sym_abstract] = ACTIONS(388),
    [anon_sym_final] = ACTIONS(388),
    [anon_sym_strictfp] = ACTIONS(388),
    [anon_sym_native] = ACTIONS(388),
    [anon_sym_transient] = ACTIONS(388),
    [anon_sym_volatile] = ACTIONS(388),
    [anon_sym_record] = ACTIONS(388),
    [anon_sym_ATinterface] = ACTIONS(386),
    [anon_sym_interface] = ACTIONS(388),
    [anon_sym_byte] = ACTIONS(388),
    [anon_sym_short] = ACTIONS(388),
    [anon_sym_int] = ACTIONS(388),
    [anon_sym_long] = ACTIONS(388),
    [anon_sym_char] = ACTIONS(388),
    [anon_sym_float] = ACTIONS(388),
    [anon_sym_double] = ACTIONS(388),
    [sym_boolean_type] = ACTIONS(388),
    [sym_void_type] = ACTIONS(388),
    [sym_this] = ACTIONS(388),
    [sym_super] = ACTIONS(388),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [89] = {
    [ts_builtin_sym_end] = ACTIONS(390),
    [sym_identifier] = ACTIONS(392),
    [sym_decimal_integer_literal] = ACTIONS(392),
    [sym_hex_integer_literal] = ACTIONS(392),
    [sym_octal_integer_literal] = ACTIONS(390),
    [sym_binary_integer_literal] = ACTIONS(390),
    [sym_decimal_floating_point_literal] = ACTIONS(390),
    [sym_hex_floating_point_literal] = ACTIONS(392),
    [sym_true] = ACTIONS(392),
    [sym_false] = ACTIONS(392),
    [sym_character_literal] = ACTIONS(390),
    [sym_string_literal] = ACTIONS(392),
    [sym_text_block] = ACTIONS(390),
    [sym_null_literal] = ACTIONS(392),
    [anon_sym_LPAREN] = ACTIONS(390),
    [anon_sym_LT] = ACTIONS(390),
    [anon_sym_PLUS] = ACTIONS(392),
    [anon_sym_DASH] = ACTIONS(392),
    [anon_sym_BANG] = ACTIONS(390),
    [anon_sym_TILDE] = ACTIONS(390),
    [anon_sym_PLUS_PLUS] = ACTIONS(390),
    [anon_sym_DASH_DASH] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_switch] = ACTIONS(392),
    [anon_sym_LBRACE] = ACTIONS(390),
    [anon_sym_RBRACE] = ACTIONS(390),
    [anon_sym_case] = ACTIONS(392),
    [anon_sym_default] = ACTIONS(392),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_assert] = ACTIONS(392),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_while] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(392),
    [anon_sym_continue] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(392),
    [anon_sym_yield] = ACTIONS(392),
    [anon_sym_synchronized] = ACTIONS(392),
    [anon_sym_throw] = ACTIONS(392),
    [anon_sym_try] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(392),
    [anon_sym_else] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_open] = ACTIONS(392),
    [anon_sym_module] = ACTIONS(392),
    [anon_sym_static] = ACTIONS(392),
    [anon_sym_package] = ACTIONS(392),
    [anon_sym_import] = ACTIONS(392),
    [anon_sym_enum] = ACTIONS(392),
    [anon_sym_public] = ACTIONS(392),
    [anon_sym_protected] = ACTIONS(392),
    [anon_sym_private] = ACTIONS(392),
    [anon_sym_abstract] = ACTIONS(392),
    [anon_sym_final] = ACTIONS(392),
    [anon_sym_strictfp] = ACTIONS(392),
    [anon_sym_native] = ACTIONS(392),
    [anon_sym_transient] = ACTIONS(392),
    [anon_sym_volatile] = ACTIONS(392),
    [anon_sym_record] = ACTIONS(392),
    [anon_sym_ATinterface] = ACTIONS(390),
    [anon_sym_interface] = ACTIONS(392),
    [anon_sym_byte] = ACTIONS(392),
    [anon_sym_short] = ACTIONS(392),
    [anon_sym_int] = ACTIONS(392),
    [anon_sym_long] = ACTIONS(392),
    [anon_sym_char] = ACTIONS(392),
    [anon_sym_float] = ACTIONS(392),
    [anon_sym_double] = ACTIONS(392),
    [sym_boolean_type] = ACTIONS(392),
    [sym_void_type] = ACTIONS(392),
    [sym_this] = ACTIONS(392),
    [sym_super] = ACTIONS(392),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [90] = {
    [ts_builtin_sym_end] = ACTIONS(394),
    [sym_identifier] = ACTIONS(396),
    [sym_decimal_integer_literal] = ACTIONS(396),
    [sym_hex_integer_literal] = ACTIONS(396),
    [sym_octal_integer_literal] = ACTIONS(394),
    [sym_binary_integer_literal] = ACTIONS(394),
    [sym_decimal_floating_point_literal] = ACTIONS(394),
    [sym_hex_floating_point_literal] = ACTIONS(396),
    [sym_true] = ACTIONS(396),
    [sym_false] = ACTIONS(396),
    [sym_character_literal] = ACTIONS(394),
    [sym_string_literal] = ACTIONS(396),
    [sym_text_block] = ACTIONS(394),
    [sym_null_literal] = ACTIONS(396),
    [anon_sym_LPAREN] = ACTIONS(394),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(396),
    [anon_sym_DASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(394),
    [anon_sym_DASH_DASH] = ACTIONS(394),
    [anon_sym_new] = ACTIONS(396),
    [anon_sym_class] = ACTIONS(396),
    [anon_sym_switch] = ACTIONS(396),
    [anon_sym_LBRACE] = ACTIONS(394),
    [anon_sym_RBRACE] = ACTIONS(394),
    [anon_sym_case] = ACTIONS(396),
    [anon_sym_default] = ACTIONS(396),
    [anon_sym_SEMI] = ACTIONS(394),
    [anon_sym_assert] = ACTIONS(396),
    [anon_sym_do] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(396),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_yield] = ACTIONS(396),
    [anon_sym_synchronized] = ACTIONS(396),
    [anon_sym_throw] = ACTIONS(396),
    [anon_sym_try] = ACTIONS(396),
    [anon_sym_if] = ACTIONS(396),
    [anon_sym_else] = ACTIONS(396),
    [anon_sym_for] = ACTIONS(396),
    [anon_sym_AT] = ACTIONS(396),
    [anon_sym_open] = ACTIONS(396),
    [anon_sym_module] = ACTIONS(396),
    [anon_sym_static] = ACTIONS(396),
    [anon_sym_package] = ACTIONS(396),
    [anon_sym_import] = ACTIONS(396),
    [anon_sym_enum] = ACTIONS(396),
    [anon_sym_public] = ACTIONS(396),
    [anon_sym_protected] = ACTIONS(396),
    [anon_sym_private] = ACTIONS(396),
    [anon_sym_abstract] = ACTIONS(396),
    [anon_sym_final] = ACTIONS(396),
    [anon_sym_strictfp] = ACTIONS(396),
    [anon_sym_native] = ACTIONS(396),
    [anon_sym_transient] = ACTIONS(396),
    [anon_sym_volatile] = ACTIONS(396),
    [anon_sym_record] = ACTIONS(396),
    [anon_sym_ATinterface] = ACTIONS(394),
    [anon_sym_interface] = ACTIONS(396),
    [anon_sym_byte] = ACTIONS(396),
    [anon_sym_short] = ACTIONS(396),
    [anon_sym_int] = ACTIONS(396),
    [anon_sym_long] = ACTIONS(396),
    [anon_sym_char] = ACTIONS(396),
    [anon_sym_float] = ACTIONS(396),
    [anon_sym_double] = ACTIONS(396),
    [sym_boolean_type] = ACTIONS(396),
    [sym_void_type] = ACTIONS(396),
    [sym_this] = ACTIONS(396),
    [sym_super] = ACTIONS(396),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [91] = {
    [ts_builtin_sym_end] = ACTIONS(398),
    [sym_identifier] = ACTIONS(400),
    [sym_decimal_integer_literal] = ACTIONS(400),
    [sym_hex_integer_literal] = ACTIONS(400),
    [sym_octal_integer_literal] = ACTIONS(398),
    [sym_binary_integer_literal] = ACTIONS(398),
    [sym_decimal_floating_point_literal] = ACTIONS(398),
    [sym_hex_floating_point_literal] = ACTIONS(400),
    [sym_true] = ACTIONS(400),
    [sym_false] = ACTIONS(400),
    [sym_character_literal] = ACTIONS(398),
    [sym_string_literal] = ACTIONS(400),
    [sym_text_block] = ACTIONS(398),
    [sym_null_literal] = ACTIONS(400),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym_LT] = ACTIONS(398),
    [anon_sym_PLUS] = ACTIONS(400),
    [anon_sym_DASH] = ACTIONS(400),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_PLUS_PLUS] = ACTIONS(398),
    [anon_sym_DASH_DASH] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(400),
    [anon_sym_class] = ACTIONS(400),
    [anon_sym_switch] = ACTIONS(400),
    [anon_sym_LBRACE] = ACTIONS(398),
    [anon_sym_RBRACE] = ACTIONS(398),
    [anon_sym_case] = ACTIONS(400),
    [anon_sym_default] = ACTIONS(400),
    [anon_sym_SEMI] = ACTIONS(398),
    [anon_sym_assert] = ACTIONS(400),
    [anon_sym_do] = ACTIONS(400),
    [anon_sym_while] = ACTIONS(400),
    [anon_sym_break] = ACTIONS(400),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_return] = ACTIONS(400),
    [anon_sym_yield] = ACTIONS(400),
    [anon_sym_synchronized] = ACTIONS(400),
    [anon_sym_throw] = ACTIONS(400),
    [anon_sym_try] = ACTIONS(400),
    [anon_sym_if] = ACTIONS(400),
    [anon_sym_else] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(400),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_open] = ACTIONS(400),
    [anon_sym_module] = ACTIONS(400),
    [anon_sym_static] = ACTIONS(400),
    [anon_sym_package] = ACTIONS(400),
    [anon_sym_import] = ACTIONS(400),
    [anon_sym_enum] = ACTIONS(400),
    [anon_sym_public] = ACTIONS(400),
    [anon_sym_protected] = ACTIONS(400),
    [anon_sym_private] = ACTIONS(400),
    [anon_sym_abstract] = ACTIONS(400),
    [anon_sym_final] = ACTIONS(400),
    [anon_sym_strictfp] = ACTIONS(400),
    [anon_sym_native] = ACTIONS(400),
    [anon_sym_transient] = ACTIONS(400),
    [anon_sym_volatile] = ACTIONS(400),
    [anon_sym_record] = ACTIONS(400),
    [anon_sym_ATinterface] = ACTIONS(398),
    [anon_sym_interface] = ACTIONS(400),
    [anon_sym_byte] = ACTIONS(400),
    [anon_sym_short] = ACTIONS(400),
    [anon_sym_int] = ACTIONS(400),
    [anon_sym_long] = ACTIONS(400),
    [anon_sym_char] = ACTIONS(400),
    [anon_sym_float] = ACTIONS(400),
    [anon_sym_double] = ACTIONS(400),
    [sym_boolean_type] = ACTIONS(400),
    [sym_void_type] = ACTIONS(400),
    [sym_this] = ACTIONS(400),
    [sym_super] = ACTIONS(400),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [92] = {
    [ts_builtin_sym_end] = ACTIONS(402),
    [sym_identifier] = ACTIONS(404),
    [sym_decimal_integer_literal] = ACTIONS(404),
    [sym_hex_integer_literal] = ACTIONS(404),
    [sym_octal_integer_literal] = ACTIONS(402),
    [sym_binary_integer_literal] = ACTIONS(402),
    [sym_decimal_floating_point_literal] = ACTIONS(402),
    [sym_hex_floating_point_literal] = ACTIONS(404),
    [sym_true] = ACTIONS(404),
    [sym_false] = ACTIONS(404),
    [sym_character_literal] = ACTIONS(402),
    [sym_string_literal] = ACTIONS(404),
    [sym_text_block] = ACTIONS(402),
    [sym_null_literal] = ACTIONS(404),
    [anon_sym_LPAREN] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(402),
    [anon_sym_PLUS] = ACTIONS(404),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_BANG] = ACTIONS(402),
    [anon_sym_TILDE] = ACTIONS(402),
    [anon_sym_PLUS_PLUS] = ACTIONS(402),
    [anon_sym_DASH_DASH] = ACTIONS(402),
    [anon_sym_new] = ACTIONS(404),
    [anon_sym_class] = ACTIONS(404),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(402),
    [anon_sym_RBRACE] = ACTIONS(402),
    [anon_sym_case] = ACTIONS(404),
    [anon_sym_default] = ACTIONS(404),
    [anon_sym_SEMI] = ACTIONS(402),
    [anon_sym_assert] = ACTIONS(404),
    [anon_sym_do] = ACTIONS(404),
    [anon_sym_while] = ACTIONS(404),
    [anon_sym_break] = ACTIONS(404),
    [anon_sym_continue] = ACTIONS(404),
    [anon_sym_return] = ACTIONS(404),
    [anon_sym_yield] = ACTIONS(404),
    [anon_sym_synchronized] = ACTIONS(404),
    [anon_sym_throw] = ACTIONS(404),
    [anon_sym_try] = ACTIONS(404),
    [anon_sym_if] = ACTIONS(404),
    [anon_sym_else] = ACTIONS(404),
    [anon_sym_for] = ACTIONS(404),
    [anon_sym_AT] = ACTIONS(404),
    [anon_sym_open] = ACTIONS(404),
    [anon_sym_module] = ACTIONS(404),
    [anon_sym_static] = ACTIONS(404),
    [anon_sym_package] = ACTIONS(404),
    [anon_sym_import] = ACTIONS(404),
    [anon_sym_enum] = ACTIONS(404),
    [anon_sym_public] = ACTIONS(404),
    [anon_sym_protected] = ACTIONS(404),
    [anon_sym_private] = ACTIONS(404),
    [anon_sym_abstract] = ACTIONS(404),
    [anon_sym_final] = ACTIONS(404),
    [anon_sym_strictfp] = ACTIONS(404),
    [anon_sym_native] = ACTIONS(404),
    [anon_sym_transient] = ACTIONS(404),
    [anon_sym_volatile] = ACTIONS(404),
    [anon_sym_record] = ACTIONS(404),
    [anon_sym_ATinterface] = ACTIONS(402),
    [anon_sym_interface] = ACTIONS(404),
    [anon_sym_byte] = ACTIONS(404),
    [anon_sym_short] = ACTIONS(404),
    [anon_sym_int] = ACTIONS(404),
    [anon_sym_long] = ACTIONS(404),
    [anon_sym_char] = ACTIONS(404),
    [anon_sym_float] = ACTIONS(404),
    [anon_sym_double] = ACTIONS(404),
    [sym_boolean_type] = ACTIONS(404),
    [sym_void_type] = ACTIONS(404),
    [sym_this] = ACTIONS(404),
    [sym_super] = ACTIONS(404),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [93] = {
    [ts_builtin_sym_end] = ACTIONS(406),
    [sym_identifier] = ACTIONS(408),
    [sym_decimal_integer_literal] = ACTIONS(408),
    [sym_hex_integer_literal] = ACTIONS(408),
    [sym_octal_integer_literal] = ACTIONS(406),
    [sym_binary_integer_literal] = ACTIONS(406),
    [sym_decimal_floating_point_literal] = ACTIONS(406),
    [sym_hex_floating_point_literal] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_character_literal] = ACTIONS(406),
    [sym_string_literal] = ACTIONS(408),
    [sym_text_block] = ACTIONS(406),
    [sym_null_literal] = ACTIONS(408),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_LT] = ACTIONS(406),
    [anon_sym_PLUS] = ACTIONS(408),
    [anon_sym_DASH] = ACTIONS(408),
    [anon_sym_BANG] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(406),
    [anon_sym_PLUS_PLUS] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(406),
    [anon_sym_new] = ACTIONS(408),
    [anon_sym_class] = ACTIONS(408),
    [anon_sym_switch] = ACTIONS(408),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(406),
    [anon_sym_case] = ACTIONS(408),
    [anon_sym_default] = ACTIONS(408),
    [anon_sym_SEMI] = ACTIONS(406),
    [anon_sym_assert] = ACTIONS(408),
    [anon_sym_do] = ACTIONS(408),
    [anon_sym_while] = ACTIONS(408),
    [anon_sym_break] = ACTIONS(408),
    [anon_sym_continue] = ACTIONS(408),
    [anon_sym_return] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(408),
    [anon_sym_synchronized] = ACTIONS(408),
    [anon_sym_throw] = ACTIONS(408),
    [anon_sym_try] = ACTIONS(408),
    [anon_sym_if] = ACTIONS(408),
    [anon_sym_else] = ACTIONS(408),
    [anon_sym_for] = ACTIONS(408),
    [anon_sym_AT] = ACTIONS(408),
    [anon_sym_open] = ACTIONS(408),
    [anon_sym_module] = ACTIONS(408),
    [anon_sym_static] = ACTIONS(408),
    [anon_sym_package] = ACTIONS(408),
    [anon_sym_import] = ACTIONS(408),
    [anon_sym_enum] = ACTIONS(408),
    [anon_sym_public] = ACTIONS(408),
    [anon_sym_protected] = ACTIONS(408),
    [anon_sym_private] = ACTIONS(408),
    [anon_sym_abstract] = ACTIONS(408),
    [anon_sym_final] = ACTIONS(408),
    [anon_sym_strictfp] = ACTIONS(408),
    [anon_sym_native] = ACTIONS(408),
    [anon_sym_transient] = ACTIONS(408),
    [anon_sym_volatile] = ACTIONS(408),
    [anon_sym_record] = ACTIONS(408),
    [anon_sym_ATinterface] = ACTIONS(406),
    [anon_sym_interface] = ACTIONS(408),
    [anon_sym_byte] = ACTIONS(408),
    [anon_sym_short] = ACTIONS(408),
    [anon_sym_int] = ACTIONS(408),
    [anon_sym_long] = ACTIONS(408),
    [anon_sym_char] = ACTIONS(408),
    [anon_sym_float] = ACTIONS(408),
    [anon_sym_double] = ACTIONS(408),
    [sym_boolean_type] = ACTIONS(408),
    [sym_void_type] = ACTIONS(408),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [94] = {
    [ts_builtin_sym_end] = ACTIONS(410),
    [sym_identifier] = ACTIONS(412),
    [sym_decimal_integer_literal] = ACTIONS(412),
    [sym_hex_integer_literal] = ACTIONS(412),
    [sym_octal_integer_literal] = ACTIONS(410),
    [sym_binary_integer_literal] = ACTIONS(410),
    [sym_decimal_floating_point_literal] = ACTIONS(410),
    [sym_hex_floating_point_literal] = ACTIONS(412),
    [sym_true] = ACTIONS(412),
    [sym_false] = ACTIONS(412),
    [sym_character_literal] = ACTIONS(410),
    [sym_string_literal] = ACTIONS(412),
    [sym_text_block] = ACTIONS(410),
    [sym_null_literal] = ACTIONS(412),
    [anon_sym_LPAREN] = ACTIONS(410),
    [anon_sym_LT] = ACTIONS(410),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(410),
    [anon_sym_TILDE] = ACTIONS(410),
    [anon_sym_PLUS_PLUS] = ACTIONS(410),
    [anon_sym_DASH_DASH] = ACTIONS(410),
    [anon_sym_new] = ACTIONS(412),
    [anon_sym_class] = ACTIONS(412),
    [anon_sym_switch] = ACTIONS(412),
    [anon_sym_LBRACE] = ACTIONS(410),
    [anon_sym_RBRACE] = ACTIONS(410),
    [anon_sym_case] = ACTIONS(412),
    [anon_sym_default] = ACTIONS(412),
    [anon_sym_SEMI] = ACTIONS(410),
    [anon_sym_assert] = ACTIONS(412),
    [anon_sym_do] = ACTIONS(412),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(412),
    [anon_sym_continue] = ACTIONS(412),
    [anon_sym_return] = ACTIONS(412),
    [anon_sym_yield] = ACTIONS(412),
    [anon_sym_synchronized] = ACTIONS(412),
    [anon_sym_throw] = ACTIONS(412),
    [anon_sym_try] = ACTIONS(412),
    [anon_sym_if] = ACTIONS(412),
    [anon_sym_else] = ACTIONS(412),
    [anon_sym_for] = ACTIONS(412),
    [anon_sym_AT] = ACTIONS(412),
    [anon_sym_open] = ACTIONS(412),
    [anon_sym_module] = ACTIONS(412),
    [anon_sym_static] = ACTIONS(412),
    [anon_sym_package] = ACTIONS(412),
    [anon_sym_import] = ACTIONS(412),
    [anon_sym_enum] = ACTIONS(412),
    [anon_sym_public] = ACTIONS(412),
    [anon_sym_protected] = ACTIONS(412),
    [anon_sym_private] = ACTIONS(412),
    [anon_sym_abstract] = ACTIONS(412),
    [anon_sym_final] = ACTIONS(412),
    [anon_sym_strictfp] = ACTIONS(412),
    [anon_sym_native] = ACTIONS(412),
    [anon_sym_transient] = ACTIONS(412),
    [anon_sym_volatile] = ACTIONS(412),
    [anon_sym_record] = ACTIONS(412),
    [anon_sym_ATinterface] = ACTIONS(410),
    [anon_sym_interface] = ACTIONS(412),
    [anon_sym_byte] = ACTIONS(412),
    [anon_sym_short] = ACTIONS(412),
    [anon_sym_int] = ACTIONS(412),
    [anon_sym_long] = ACTIONS(412),
    [anon_sym_char] = ACTIONS(412),
    [anon_sym_float] = ACTIONS(412),
    [anon_sym_double] = ACTIONS(412),
    [sym_boolean_type] = ACTIONS(412),
    [sym_void_type] = ACTIONS(412),
    [sym_this] = ACTIONS(412),
    [sym_super] = ACTIONS(412),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [95] = {
    [ts_builtin_sym_end] = ACTIONS(414),
    [sym_identifier] = ACTIONS(416),
    [sym_decimal_integer_literal] = ACTIONS(416),
    [sym_hex_integer_literal] = ACTIONS(416),
    [sym_octal_integer_literal] = ACTIONS(414),
    [sym_binary_integer_literal] = ACTIONS(414),
    [sym_decimal_floating_point_literal] = ACTIONS(414),
    [sym_hex_floating_point_literal] = ACTIONS(416),
    [sym_true] = ACTIONS(416),
    [sym_false] = ACTIONS(416),
    [sym_character_literal] = ACTIONS(414),
    [sym_string_literal] = ACTIONS(416),
    [sym_text_block] = ACTIONS(414),
    [sym_null_literal] = ACTIONS(416),
    [anon_sym_LPAREN] = ACTIONS(414),
    [anon_sym_LT] = ACTIONS(414),
    [anon_sym_PLUS] = ACTIONS(416),
    [anon_sym_DASH] = ACTIONS(416),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(414),
    [anon_sym_PLUS_PLUS] = ACTIONS(414),
    [anon_sym_DASH_DASH] = ACTIONS(414),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_class] = ACTIONS(416),
    [anon_sym_switch] = ACTIONS(416),
    [anon_sym_LBRACE] = ACTIONS(414),
    [anon_sym_RBRACE] = ACTIONS(414),
    [anon_sym_case] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(414),
    [anon_sym_assert] = ACTIONS(416),
    [anon_sym_do] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_yield] = ACTIONS(416),
    [anon_sym_synchronized] = ACTIONS(416),
    [anon_sym_throw] = ACTIONS(416),
    [anon_sym_try] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_else] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(416),
    [anon_sym_open] = ACTIONS(416),
    [anon_sym_module] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_package] = ACTIONS(416),
    [anon_sym_import] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_public] = ACTIONS(416),
    [anon_sym_protected] = ACTIONS(416),
    [anon_sym_private] = ACTIONS(416),
    [anon_sym_abstract] = ACTIONS(416),
    [anon_sym_final] = ACTIONS(416),
    [anon_sym_strictfp] = ACTIONS(416),
    [anon_sym_native] = ACTIONS(416),
    [anon_sym_transient] = ACTIONS(416),
    [anon_sym_volatile] = ACTIONS(416),
    [anon_sym_record] = ACTIONS(416),
    [anon_sym_ATinterface] = ACTIONS(414),
    [anon_sym_interface] = ACTIONS(416),
    [anon_sym_byte] = ACTIONS(416),
    [anon_sym_short] = ACTIONS(416),
    [anon_sym_int] = ACTIONS(416),
    [anon_sym_long] = ACTIONS(416),
    [anon_sym_char] = ACTIONS(416),
    [anon_sym_float] = ACTIONS(416),
    [anon_sym_double] = ACTIONS(416),
    [sym_boolean_type] = ACTIONS(416),
    [sym_void_type] = ACTIONS(416),
    [sym_this] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [96] = {
    [ts_builtin_sym_end] = ACTIONS(239),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(241),
    [sym_hex_integer_literal] = ACTIONS(241),
    [sym_octal_integer_literal] = ACTIONS(239),
    [sym_binary_integer_literal] = ACTIONS(239),
    [sym_decimal_floating_point_literal] = ACTIONS(239),
    [sym_hex_floating_point_literal] = ACTIONS(241),
    [sym_true] = ACTIONS(241),
    [sym_false] = ACTIONS(241),
    [sym_character_literal] = ACTIONS(239),
    [sym_string_literal] = ACTIONS(241),
    [sym_text_block] = ACTIONS(239),
    [sym_null_literal] = ACTIONS(241),
    [anon_sym_LPAREN] = ACTIONS(239),
    [anon_sym_PLUS] = ACTIONS(241),
    [anon_sym_DASH] = ACTIONS(241),
    [anon_sym_BANG] = ACTIONS(239),
    [anon_sym_TILDE] = ACTIONS(239),
    [anon_sym_PLUS_PLUS] = ACTIONS(239),
    [anon_sym_DASH_DASH] = ACTIONS(239),
    [anon_sym_new] = ACTIONS(241),
    [anon_sym_class] = ACTIONS(241),
    [anon_sym_switch] = ACTIONS(241),
    [anon_sym_LBRACE] = ACTIONS(239),
    [anon_sym_RBRACE] = ACTIONS(239),
    [anon_sym_case] = ACTIONS(241),
    [anon_sym_default] = ACTIONS(241),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_assert] = ACTIONS(241),
    [anon_sym_do] = ACTIONS(241),
    [anon_sym_while] = ACTIONS(241),
    [anon_sym_break] = ACTIONS(241),
    [anon_sym_continue] = ACTIONS(241),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_yield] = ACTIONS(241),
    [anon_sym_synchronized] = ACTIONS(241),
    [anon_sym_throw] = ACTIONS(241),
    [anon_sym_try] = ACTIONS(241),
    [anon_sym_catch] = ACTIONS(241),
    [anon_sym_finally] = ACTIONS(241),
    [anon_sym_if] = ACTIONS(241),
    [anon_sym_else] = ACTIONS(241),
    [anon_sym_for] = ACTIONS(241),
    [anon_sym_AT] = ACTIONS(241),
    [anon_sym_open] = ACTIONS(241),
    [anon_sym_module] = ACTIONS(241),
    [anon_sym_static] = ACTIONS(241),
    [anon_sym_package] = ACTIONS(241),
    [anon_sym_import] = ACTIONS(241),
    [anon_sym_enum] = ACTIONS(241),
    [anon_sym_public] = ACTIONS(241),
    [anon_sym_protected] = ACTIONS(241),
    [anon_sym_private] = ACTIONS(241),
    [anon_sym_abstract] = ACTIONS(241),
    [anon_sym_final] = ACTIONS(241),
    [anon_sym_strictfp] = ACTIONS(241),
    [anon_sym_native] = ACTIONS(241),
    [anon_sym_transient] = ACTIONS(241),
    [anon_sym_volatile] = ACTIONS(241),
    [anon_sym_ATinterface] = ACTIONS(239),
    [anon_sym_interface] = ACTIONS(241),
    [anon_sym_byte] = ACTIONS(241),
    [anon_sym_short] = ACTIONS(241),
    [anon_sym_int] = ACTIONS(241),
    [anon_sym_long] = ACTIONS(241),
    [anon_sym_char] = ACTIONS(241),
    [anon_sym_float] = ACTIONS(241),
    [anon_sym_double] = ACTIONS(241),
    [sym_boolean_type] = ACTIONS(241),
    [sym_void_type] = ACTIONS(241),
    [sym_this] = ACTIONS(241),
    [sym_super] = ACTIONS(241),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [97] = {
    [ts_builtin_sym_end] = ACTIONS(418),
    [sym_identifier] = ACTIONS(420),
    [sym_decimal_integer_literal] = ACTIONS(420),
    [sym_hex_integer_literal] = ACTIONS(420),
    [sym_octal_integer_literal] = ACTIONS(418),
    [sym_binary_integer_literal] = ACTIONS(418),
    [sym_decimal_floating_point_literal] = ACTIONS(418),
    [sym_hex_floating_point_literal] = ACTIONS(420),
    [sym_true] = ACTIONS(420),
    [sym_false] = ACTIONS(420),
    [sym_character_literal] = ACTIONS(418),
    [sym_string_literal] = ACTIONS(420),
    [sym_text_block] = ACTIONS(418),
    [sym_null_literal] = ACTIONS(420),
    [anon_sym_LPAREN] = ACTIONS(418),
    [anon_sym_LT] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(420),
    [anon_sym_DASH] = ACTIONS(420),
    [anon_sym_BANG] = ACTIONS(418),
    [anon_sym_TILDE] = ACTIONS(418),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_new] = ACTIONS(420),
    [anon_sym_class] = ACTIONS(420),
    [anon_sym_switch] = ACTIONS(420),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_RBRACE] = ACTIONS(418),
    [anon_sym_case] = ACTIONS(420),
    [anon_sym_default] = ACTIONS(420),
    [anon_sym_SEMI] = ACTIONS(418),
    [anon_sym_assert] = ACTIONS(420),
    [anon_sym_do] = ACTIONS(420),
    [anon_sym_while] = ACTIONS(420),
    [anon_sym_break] = ACTIONS(420),
    [anon_sym_continue] = ACTIONS(420),
    [anon_sym_return] = ACTIONS(420),
    [anon_sym_yield] = ACTIONS(420),
    [anon_sym_synchronized] = ACTIONS(420),
    [anon_sym_throw] = ACTIONS(420),
    [anon_sym_try] = ACTIONS(420),
    [anon_sym_if] = ACTIONS(420),
    [anon_sym_else] = ACTIONS(420),
    [anon_sym_for] = ACTIONS(420),
    [anon_sym_AT] = ACTIONS(420),
    [anon_sym_open] = ACTIONS(420),
    [anon_sym_module] = ACTIONS(420),
    [anon_sym_static] = ACTIONS(420),
    [anon_sym_package] = ACTIONS(420),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_enum] = ACTIONS(420),
    [anon_sym_public] = ACTIONS(420),
    [anon_sym_protected] = ACTIONS(420),
    [anon_sym_private] = ACTIONS(420),
    [anon_sym_abstract] = ACTIONS(420),
    [anon_sym_final] = ACTIONS(420),
    [anon_sym_strictfp] = ACTIONS(420),
    [anon_sym_native] = ACTIONS(420),
    [anon_sym_transient] = ACTIONS(420),
    [anon_sym_volatile] = ACTIONS(420),
    [anon_sym_record] = ACTIONS(420),
    [anon_sym_ATinterface] = ACTIONS(418),
    [anon_sym_interface] = ACTIONS(420),
    [anon_sym_byte] = ACTIONS(420),
    [anon_sym_short] = ACTIONS(420),
    [anon_sym_int] = ACTIONS(420),
    [anon_sym_long] = ACTIONS(420),
    [anon_sym_char] = ACTIONS(420),
    [anon_sym_float] = ACTIONS(420),
    [anon_sym_double] = ACTIONS(420),
    [sym_boolean_type] = ACTIONS(420),
    [sym_void_type] = ACTIONS(420),
    [sym_this] = ACTIONS(420),
    [sym_super] = ACTIONS(420),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [98] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(479),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1043),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym_block] = STATE(417),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1043),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(422),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(424),
    [anon_sym_PLUS] = ACTIONS(426),
    [anon_sym_DASH] = ACTIONS(426),
    [anon_sym_BANG] = ACTIONS(428),
    [anon_sym_TILDE] = ACTIONS(428),
    [anon_sym_PLUS_PLUS] = ACTIONS(430),
    [anon_sym_DASH_DASH] = ACTIONS(430),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(432),
    [anon_sym_module] = ACTIONS(432),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [99] = {
    [ts_builtin_sym_end] = ACTIONS(434),
    [sym_identifier] = ACTIONS(436),
    [sym_decimal_integer_literal] = ACTIONS(436),
    [sym_hex_integer_literal] = ACTIONS(436),
    [sym_octal_integer_literal] = ACTIONS(434),
    [sym_binary_integer_literal] = ACTIONS(434),
    [sym_decimal_floating_point_literal] = ACTIONS(434),
    [sym_hex_floating_point_literal] = ACTIONS(436),
    [sym_true] = ACTIONS(436),
    [sym_false] = ACTIONS(436),
    [sym_character_literal] = ACTIONS(434),
    [sym_string_literal] = ACTIONS(436),
    [sym_text_block] = ACTIONS(434),
    [sym_null_literal] = ACTIONS(436),
    [anon_sym_LPAREN] = ACTIONS(434),
    [anon_sym_LT] = ACTIONS(434),
    [anon_sym_PLUS] = ACTIONS(436),
    [anon_sym_DASH] = ACTIONS(436),
    [anon_sym_BANG] = ACTIONS(434),
    [anon_sym_TILDE] = ACTIONS(434),
    [anon_sym_PLUS_PLUS] = ACTIONS(434),
    [anon_sym_DASH_DASH] = ACTIONS(434),
    [anon_sym_new] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(436),
    [anon_sym_switch] = ACTIONS(436),
    [anon_sym_LBRACE] = ACTIONS(434),
    [anon_sym_RBRACE] = ACTIONS(434),
    [anon_sym_case] = ACTIONS(436),
    [anon_sym_default] = ACTIONS(436),
    [anon_sym_SEMI] = ACTIONS(434),
    [anon_sym_assert] = ACTIONS(436),
    [anon_sym_do] = ACTIONS(436),
    [anon_sym_while] = ACTIONS(436),
    [anon_sym_break] = ACTIONS(436),
    [anon_sym_continue] = ACTIONS(436),
    [anon_sym_return] = ACTIONS(436),
    [anon_sym_yield] = ACTIONS(436),
    [anon_sym_synchronized] = ACTIONS(436),
    [anon_sym_throw] = ACTIONS(436),
    [anon_sym_try] = ACTIONS(436),
    [anon_sym_if] = ACTIONS(436),
    [anon_sym_else] = ACTIONS(436),
    [anon_sym_for] = ACTIONS(436),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_open] = ACTIONS(436),
    [anon_sym_module] = ACTIONS(436),
    [anon_sym_static] = ACTIONS(436),
    [anon_sym_package] = ACTIONS(436),
    [anon_sym_import] = ACTIONS(436),
    [anon_sym_enum] = ACTIONS(436),
    [anon_sym_public] = ACTIONS(436),
    [anon_sym_protected] = ACTIONS(436),
    [anon_sym_private] = ACTIONS(436),
    [anon_sym_abstract] = ACTIONS(436),
    [anon_sym_final] = ACTIONS(436),
    [anon_sym_strictfp] = ACTIONS(436),
    [anon_sym_native] = ACTIONS(436),
    [anon_sym_transient] = ACTIONS(436),
    [anon_sym_volatile] = ACTIONS(436),
    [anon_sym_record] = ACTIONS(436),
    [anon_sym_ATinterface] = ACTIONS(434),
    [anon_sym_interface] = ACTIONS(436),
    [anon_sym_byte] = ACTIONS(436),
    [anon_sym_short] = ACTIONS(436),
    [anon_sym_int] = ACTIONS(436),
    [anon_sym_long] = ACTIONS(436),
    [anon_sym_char] = ACTIONS(436),
    [anon_sym_float] = ACTIONS(436),
    [anon_sym_double] = ACTIONS(436),
    [sym_boolean_type] = ACTIONS(436),
    [sym_void_type] = ACTIONS(436),
    [sym_this] = ACTIONS(436),
    [sym_super] = ACTIONS(436),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [100] = {
    [ts_builtin_sym_end] = ACTIONS(438),
    [sym_identifier] = ACTIONS(440),
    [sym_decimal_integer_literal] = ACTIONS(440),
    [sym_hex_integer_literal] = ACTIONS(440),
    [sym_octal_integer_literal] = ACTIONS(438),
    [sym_binary_integer_literal] = ACTIONS(438),
    [sym_decimal_floating_point_literal] = ACTIONS(438),
    [sym_hex_floating_point_literal] = ACTIONS(440),
    [sym_true] = ACTIONS(440),
    [sym_false] = ACTIONS(440),
    [sym_character_literal] = ACTIONS(438),
    [sym_string_literal] = ACTIONS(440),
    [sym_text_block] = ACTIONS(438),
    [sym_null_literal] = ACTIONS(440),
    [anon_sym_LPAREN] = ACTIONS(438),
    [anon_sym_LT] = ACTIONS(438),
    [anon_sym_PLUS] = ACTIONS(440),
    [anon_sym_DASH] = ACTIONS(440),
    [anon_sym_BANG] = ACTIONS(438),
    [anon_sym_TILDE] = ACTIONS(438),
    [anon_sym_PLUS_PLUS] = ACTIONS(438),
    [anon_sym_DASH_DASH] = ACTIONS(438),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_class] = ACTIONS(440),
    [anon_sym_switch] = ACTIONS(440),
    [anon_sym_LBRACE] = ACTIONS(438),
    [anon_sym_RBRACE] = ACTIONS(438),
    [anon_sym_case] = ACTIONS(440),
    [anon_sym_default] = ACTIONS(440),
    [anon_sym_SEMI] = ACTIONS(438),
    [anon_sym_assert] = ACTIONS(440),
    [anon_sym_do] = ACTIONS(440),
    [anon_sym_while] = ACTIONS(440),
    [anon_sym_break] = ACTIONS(440),
    [anon_sym_continue] = ACTIONS(440),
    [anon_sym_return] = ACTIONS(440),
    [anon_sym_yield] = ACTIONS(440),
    [anon_sym_synchronized] = ACTIONS(440),
    [anon_sym_throw] = ACTIONS(440),
    [anon_sym_try] = ACTIONS(440),
    [anon_sym_if] = ACTIONS(440),
    [anon_sym_else] = ACTIONS(440),
    [anon_sym_for] = ACTIONS(440),
    [anon_sym_AT] = ACTIONS(440),
    [anon_sym_open] = ACTIONS(440),
    [anon_sym_module] = ACTIONS(440),
    [anon_sym_static] = ACTIONS(440),
    [anon_sym_package] = ACTIONS(440),
    [anon_sym_import] = ACTIONS(440),
    [anon_sym_enum] = ACTIONS(440),
    [anon_sym_public] = ACTIONS(440),
    [anon_sym_protected] = ACTIONS(440),
    [anon_sym_private] = ACTIONS(440),
    [anon_sym_abstract] = ACTIONS(440),
    [anon_sym_final] = ACTIONS(440),
    [anon_sym_strictfp] = ACTIONS(440),
    [anon_sym_native] = ACTIONS(440),
    [anon_sym_transient] = ACTIONS(440),
    [anon_sym_volatile] = ACTIONS(440),
    [anon_sym_record] = ACTIONS(440),
    [anon_sym_ATinterface] = ACTIONS(438),
    [anon_sym_interface] = ACTIONS(440),
    [anon_sym_byte] = ACTIONS(440),
    [anon_sym_short] = ACTIONS(440),
    [anon_sym_int] = ACTIONS(440),
    [anon_sym_long] = ACTIONS(440),
    [anon_sym_char] = ACTIONS(440),
    [anon_sym_float] = ACTIONS(440),
    [anon_sym_double] = ACTIONS(440),
    [sym_boolean_type] = ACTIONS(440),
    [sym_void_type] = ACTIONS(440),
    [sym_this] = ACTIONS(440),
    [sym_super] = ACTIONS(440),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [101] = {
    [ts_builtin_sym_end] = ACTIONS(442),
    [sym_identifier] = ACTIONS(444),
    [sym_decimal_integer_literal] = ACTIONS(444),
    [sym_hex_integer_literal] = ACTIONS(444),
    [sym_octal_integer_literal] = ACTIONS(442),
    [sym_binary_integer_literal] = ACTIONS(442),
    [sym_decimal_floating_point_literal] = ACTIONS(442),
    [sym_hex_floating_point_literal] = ACTIONS(444),
    [sym_true] = ACTIONS(444),
    [sym_false] = ACTIONS(444),
    [sym_character_literal] = ACTIONS(442),
    [sym_string_literal] = ACTIONS(444),
    [sym_text_block] = ACTIONS(442),
    [sym_null_literal] = ACTIONS(444),
    [anon_sym_LPAREN] = ACTIONS(442),
    [anon_sym_LT] = ACTIONS(442),
    [anon_sym_PLUS] = ACTIONS(444),
    [anon_sym_DASH] = ACTIONS(444),
    [anon_sym_BANG] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(442),
    [anon_sym_DASH_DASH] = ACTIONS(442),
    [anon_sym_new] = ACTIONS(444),
    [anon_sym_class] = ACTIONS(444),
    [anon_sym_switch] = ACTIONS(444),
    [anon_sym_LBRACE] = ACTIONS(442),
    [anon_sym_RBRACE] = ACTIONS(442),
    [anon_sym_case] = ACTIONS(444),
    [anon_sym_default] = ACTIONS(444),
    [anon_sym_SEMI] = ACTIONS(442),
    [anon_sym_assert] = ACTIONS(444),
    [anon_sym_do] = ACTIONS(444),
    [anon_sym_while] = ACTIONS(444),
    [anon_sym_break] = ACTIONS(444),
    [anon_sym_continue] = ACTIONS(444),
    [anon_sym_return] = ACTIONS(444),
    [anon_sym_yield] = ACTIONS(444),
    [anon_sym_synchronized] = ACTIONS(444),
    [anon_sym_throw] = ACTIONS(444),
    [anon_sym_try] = ACTIONS(444),
    [anon_sym_if] = ACTIONS(444),
    [anon_sym_else] = ACTIONS(444),
    [anon_sym_for] = ACTIONS(444),
    [anon_sym_AT] = ACTIONS(444),
    [anon_sym_open] = ACTIONS(444),
    [anon_sym_module] = ACTIONS(444),
    [anon_sym_static] = ACTIONS(444),
    [anon_sym_package] = ACTIONS(444),
    [anon_sym_import] = ACTIONS(444),
    [anon_sym_enum] = ACTIONS(444),
    [anon_sym_public] = ACTIONS(444),
    [anon_sym_protected] = ACTIONS(444),
    [anon_sym_private] = ACTIONS(444),
    [anon_sym_abstract] = ACTIONS(444),
    [anon_sym_final] = ACTIONS(444),
    [anon_sym_strictfp] = ACTIONS(444),
    [anon_sym_native] = ACTIONS(444),
    [anon_sym_transient] = ACTIONS(444),
    [anon_sym_volatile] = ACTIONS(444),
    [anon_sym_record] = ACTIONS(444),
    [anon_sym_ATinterface] = ACTIONS(442),
    [anon_sym_interface] = ACTIONS(444),
    [anon_sym_byte] = ACTIONS(444),
    [anon_sym_short] = ACTIONS(444),
    [anon_sym_int] = ACTIONS(444),
    [anon_sym_long] = ACTIONS(444),
    [anon_sym_char] = ACTIONS(444),
    [anon_sym_float] = ACTIONS(444),
    [anon_sym_double] = ACTIONS(444),
    [sym_boolean_type] = ACTIONS(444),
    [sym_void_type] = ACTIONS(444),
    [sym_this] = ACTIONS(444),
    [sym_super] = ACTIONS(444),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [102] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(480),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym_array_initializer] = STATE(888),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(315),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [103] = {
    [ts_builtin_sym_end] = ACTIONS(446),
    [sym_identifier] = ACTIONS(448),
    [sym_decimal_integer_literal] = ACTIONS(448),
    [sym_hex_integer_literal] = ACTIONS(448),
    [sym_octal_integer_literal] = ACTIONS(446),
    [sym_binary_integer_literal] = ACTIONS(446),
    [sym_decimal_floating_point_literal] = ACTIONS(446),
    [sym_hex_floating_point_literal] = ACTIONS(448),
    [sym_true] = ACTIONS(448),
    [sym_false] = ACTIONS(448),
    [sym_character_literal] = ACTIONS(446),
    [sym_string_literal] = ACTIONS(448),
    [sym_text_block] = ACTIONS(446),
    [sym_null_literal] = ACTIONS(448),
    [anon_sym_LPAREN] = ACTIONS(446),
    [anon_sym_LT] = ACTIONS(446),
    [anon_sym_PLUS] = ACTIONS(448),
    [anon_sym_DASH] = ACTIONS(448),
    [anon_sym_BANG] = ACTIONS(446),
    [anon_sym_TILDE] = ACTIONS(446),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_new] = ACTIONS(448),
    [anon_sym_class] = ACTIONS(448),
    [anon_sym_switch] = ACTIONS(448),
    [anon_sym_LBRACE] = ACTIONS(446),
    [anon_sym_RBRACE] = ACTIONS(446),
    [anon_sym_case] = ACTIONS(448),
    [anon_sym_default] = ACTIONS(448),
    [anon_sym_SEMI] = ACTIONS(446),
    [anon_sym_assert] = ACTIONS(448),
    [anon_sym_do] = ACTIONS(448),
    [anon_sym_while] = ACTIONS(448),
    [anon_sym_break] = ACTIONS(448),
    [anon_sym_continue] = ACTIONS(448),
    [anon_sym_return] = ACTIONS(448),
    [anon_sym_yield] = ACTIONS(448),
    [anon_sym_synchronized] = ACTIONS(448),
    [anon_sym_throw] = ACTIONS(448),
    [anon_sym_try] = ACTIONS(448),
    [anon_sym_if] = ACTIONS(448),
    [anon_sym_else] = ACTIONS(448),
    [anon_sym_for] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(448),
    [anon_sym_open] = ACTIONS(448),
    [anon_sym_module] = ACTIONS(448),
    [anon_sym_static] = ACTIONS(448),
    [anon_sym_package] = ACTIONS(448),
    [anon_sym_import] = ACTIONS(448),
    [anon_sym_enum] = ACTIONS(448),
    [anon_sym_public] = ACTIONS(448),
    [anon_sym_protected] = ACTIONS(448),
    [anon_sym_private] = ACTIONS(448),
    [anon_sym_abstract] = ACTIONS(448),
    [anon_sym_final] = ACTIONS(448),
    [anon_sym_strictfp] = ACTIONS(448),
    [anon_sym_native] = ACTIONS(448),
    [anon_sym_transient] = ACTIONS(448),
    [anon_sym_volatile] = ACTIONS(448),
    [anon_sym_record] = ACTIONS(448),
    [anon_sym_ATinterface] = ACTIONS(446),
    [anon_sym_interface] = ACTIONS(448),
    [anon_sym_byte] = ACTIONS(448),
    [anon_sym_short] = ACTIONS(448),
    [anon_sym_int] = ACTIONS(448),
    [anon_sym_long] = ACTIONS(448),
    [anon_sym_char] = ACTIONS(448),
    [anon_sym_float] = ACTIONS(448),
    [anon_sym_double] = ACTIONS(448),
    [sym_boolean_type] = ACTIONS(448),
    [sym_void_type] = ACTIONS(448),
    [sym_this] = ACTIONS(448),
    [sym_super] = ACTIONS(448),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [104] = {
    [ts_builtin_sym_end] = ACTIONS(243),
    [sym_identifier] = ACTIONS(245),
    [sym_decimal_integer_literal] = ACTIONS(245),
    [sym_hex_integer_literal] = ACTIONS(245),
    [sym_octal_integer_literal] = ACTIONS(243),
    [sym_binary_integer_literal] = ACTIONS(243),
    [sym_decimal_floating_point_literal] = ACTIONS(243),
    [sym_hex_floating_point_literal] = ACTIONS(245),
    [sym_true] = ACTIONS(245),
    [sym_false] = ACTIONS(245),
    [sym_character_literal] = ACTIONS(243),
    [sym_string_literal] = ACTIONS(245),
    [sym_text_block] = ACTIONS(243),
    [sym_null_literal] = ACTIONS(245),
    [anon_sym_LPAREN] = ACTIONS(243),
    [anon_sym_PLUS] = ACTIONS(245),
    [anon_sym_DASH] = ACTIONS(245),
    [anon_sym_BANG] = ACTIONS(243),
    [anon_sym_TILDE] = ACTIONS(243),
    [anon_sym_PLUS_PLUS] = ACTIONS(243),
    [anon_sym_DASH_DASH] = ACTIONS(243),
    [anon_sym_new] = ACTIONS(245),
    [anon_sym_class] = ACTIONS(245),
    [anon_sym_switch] = ACTIONS(245),
    [anon_sym_LBRACE] = ACTIONS(243),
    [anon_sym_RBRACE] = ACTIONS(243),
    [anon_sym_case] = ACTIONS(245),
    [anon_sym_default] = ACTIONS(245),
    [anon_sym_SEMI] = ACTIONS(243),
    [anon_sym_assert] = ACTIONS(245),
    [anon_sym_do] = ACTIONS(245),
    [anon_sym_while] = ACTIONS(245),
    [anon_sym_break] = ACTIONS(245),
    [anon_sym_continue] = ACTIONS(245),
    [anon_sym_return] = ACTIONS(245),
    [anon_sym_yield] = ACTIONS(245),
    [anon_sym_synchronized] = ACTIONS(245),
    [anon_sym_throw] = ACTIONS(245),
    [anon_sym_try] = ACTIONS(245),
    [anon_sym_catch] = ACTIONS(245),
    [anon_sym_finally] = ACTIONS(245),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_else] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(245),
    [anon_sym_AT] = ACTIONS(245),
    [anon_sym_open] = ACTIONS(245),
    [anon_sym_module] = ACTIONS(245),
    [anon_sym_static] = ACTIONS(245),
    [anon_sym_package] = ACTIONS(245),
    [anon_sym_import] = ACTIONS(245),
    [anon_sym_enum] = ACTIONS(245),
    [anon_sym_public] = ACTIONS(245),
    [anon_sym_protected] = ACTIONS(245),
    [anon_sym_private] = ACTIONS(245),
    [anon_sym_abstract] = ACTIONS(245),
    [anon_sym_final] = ACTIONS(245),
    [anon_sym_strictfp] = ACTIONS(245),
    [anon_sym_native] = ACTIONS(245),
    [anon_sym_transient] = ACTIONS(245),
    [anon_sym_volatile] = ACTIONS(245),
    [anon_sym_ATinterface] = ACTIONS(243),
    [anon_sym_interface] = ACTIONS(245),
    [anon_sym_byte] = ACTIONS(245),
    [anon_sym_short] = ACTIONS(245),
    [anon_sym_int] = ACTIONS(245),
    [anon_sym_long] = ACTIONS(245),
    [anon_sym_char] = ACTIONS(245),
    [anon_sym_float] = ACTIONS(245),
    [anon_sym_double] = ACTIONS(245),
    [sym_boolean_type] = ACTIONS(245),
    [sym_void_type] = ACTIONS(245),
    [sym_this] = ACTIONS(245),
    [sym_super] = ACTIONS(245),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [105] = {
    [ts_builtin_sym_end] = ACTIONS(450),
    [sym_identifier] = ACTIONS(452),
    [sym_decimal_integer_literal] = ACTIONS(452),
    [sym_hex_integer_literal] = ACTIONS(452),
    [sym_octal_integer_literal] = ACTIONS(450),
    [sym_binary_integer_literal] = ACTIONS(450),
    [sym_decimal_floating_point_literal] = ACTIONS(450),
    [sym_hex_floating_point_literal] = ACTIONS(452),
    [sym_true] = ACTIONS(452),
    [sym_false] = ACTIONS(452),
    [sym_character_literal] = ACTIONS(450),
    [sym_string_literal] = ACTIONS(452),
    [sym_text_block] = ACTIONS(450),
    [sym_null_literal] = ACTIONS(452),
    [anon_sym_LPAREN] = ACTIONS(450),
    [anon_sym_LT] = ACTIONS(450),
    [anon_sym_PLUS] = ACTIONS(452),
    [anon_sym_DASH] = ACTIONS(452),
    [anon_sym_BANG] = ACTIONS(450),
    [anon_sym_TILDE] = ACTIONS(450),
    [anon_sym_PLUS_PLUS] = ACTIONS(450),
    [anon_sym_DASH_DASH] = ACTIONS(450),
    [anon_sym_new] = ACTIONS(452),
    [anon_sym_class] = ACTIONS(452),
    [anon_sym_switch] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(450),
    [anon_sym_RBRACE] = ACTIONS(450),
    [anon_sym_case] = ACTIONS(452),
    [anon_sym_default] = ACTIONS(452),
    [anon_sym_SEMI] = ACTIONS(450),
    [anon_sym_assert] = ACTIONS(452),
    [anon_sym_do] = ACTIONS(452),
    [anon_sym_while] = ACTIONS(452),
    [anon_sym_break] = ACTIONS(452),
    [anon_sym_continue] = ACTIONS(452),
    [anon_sym_return] = ACTIONS(452),
    [anon_sym_yield] = ACTIONS(452),
    [anon_sym_synchronized] = ACTIONS(452),
    [anon_sym_throw] = ACTIONS(452),
    [anon_sym_try] = ACTIONS(452),
    [anon_sym_if] = ACTIONS(452),
    [anon_sym_else] = ACTIONS(452),
    [anon_sym_for] = ACTIONS(452),
    [anon_sym_AT] = ACTIONS(452),
    [anon_sym_open] = ACTIONS(452),
    [anon_sym_module] = ACTIONS(452),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_package] = ACTIONS(452),
    [anon_sym_import] = ACTIONS(452),
    [anon_sym_enum] = ACTIONS(452),
    [anon_sym_public] = ACTIONS(452),
    [anon_sym_protected] = ACTIONS(452),
    [anon_sym_private] = ACTIONS(452),
    [anon_sym_abstract] = ACTIONS(452),
    [anon_sym_final] = ACTIONS(452),
    [anon_sym_strictfp] = ACTIONS(452),
    [anon_sym_native] = ACTIONS(452),
    [anon_sym_transient] = ACTIONS(452),
    [anon_sym_volatile] = ACTIONS(452),
    [anon_sym_record] = ACTIONS(452),
    [anon_sym_ATinterface] = ACTIONS(450),
    [anon_sym_interface] = ACTIONS(452),
    [anon_sym_byte] = ACTIONS(452),
    [anon_sym_short] = ACTIONS(452),
    [anon_sym_int] = ACTIONS(452),
    [anon_sym_long] = ACTIONS(452),
    [anon_sym_char] = ACTIONS(452),
    [anon_sym_float] = ACTIONS(452),
    [anon_sym_double] = ACTIONS(452),
    [sym_boolean_type] = ACTIONS(452),
    [sym_void_type] = ACTIONS(452),
    [sym_this] = ACTIONS(452),
    [sym_super] = ACTIONS(452),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [106] = {
    [ts_builtin_sym_end] = ACTIONS(454),
    [sym_identifier] = ACTIONS(456),
    [sym_decimal_integer_literal] = ACTIONS(456),
    [sym_hex_integer_literal] = ACTIONS(456),
    [sym_octal_integer_literal] = ACTIONS(454),
    [sym_binary_integer_literal] = ACTIONS(454),
    [sym_decimal_floating_point_literal] = ACTIONS(454),
    [sym_hex_floating_point_literal] = ACTIONS(456),
    [sym_true] = ACTIONS(456),
    [sym_false] = ACTIONS(456),
    [sym_character_literal] = ACTIONS(454),
    [sym_string_literal] = ACTIONS(456),
    [sym_text_block] = ACTIONS(454),
    [sym_null_literal] = ACTIONS(456),
    [anon_sym_LPAREN] = ACTIONS(454),
    [anon_sym_LT] = ACTIONS(454),
    [anon_sym_PLUS] = ACTIONS(456),
    [anon_sym_DASH] = ACTIONS(456),
    [anon_sym_BANG] = ACTIONS(454),
    [anon_sym_TILDE] = ACTIONS(454),
    [anon_sym_PLUS_PLUS] = ACTIONS(454),
    [anon_sym_DASH_DASH] = ACTIONS(454),
    [anon_sym_new] = ACTIONS(456),
    [anon_sym_class] = ACTIONS(456),
    [anon_sym_switch] = ACTIONS(456),
    [anon_sym_LBRACE] = ACTIONS(454),
    [anon_sym_RBRACE] = ACTIONS(454),
    [anon_sym_case] = ACTIONS(456),
    [anon_sym_default] = ACTIONS(456),
    [anon_sym_SEMI] = ACTIONS(454),
    [anon_sym_assert] = ACTIONS(456),
    [anon_sym_do] = ACTIONS(456),
    [anon_sym_while] = ACTIONS(456),
    [anon_sym_break] = ACTIONS(456),
    [anon_sym_continue] = ACTIONS(456),
    [anon_sym_return] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(456),
    [anon_sym_synchronized] = ACTIONS(456),
    [anon_sym_throw] = ACTIONS(456),
    [anon_sym_try] = ACTIONS(456),
    [anon_sym_if] = ACTIONS(456),
    [anon_sym_else] = ACTIONS(456),
    [anon_sym_for] = ACTIONS(456),
    [anon_sym_AT] = ACTIONS(456),
    [anon_sym_open] = ACTIONS(456),
    [anon_sym_module] = ACTIONS(456),
    [anon_sym_static] = ACTIONS(456),
    [anon_sym_package] = ACTIONS(456),
    [anon_sym_import] = ACTIONS(456),
    [anon_sym_enum] = ACTIONS(456),
    [anon_sym_public] = ACTIONS(456),
    [anon_sym_protected] = ACTIONS(456),
    [anon_sym_private] = ACTIONS(456),
    [anon_sym_abstract] = ACTIONS(456),
    [anon_sym_final] = ACTIONS(456),
    [anon_sym_strictfp] = ACTIONS(456),
    [anon_sym_native] = ACTIONS(456),
    [anon_sym_transient] = ACTIONS(456),
    [anon_sym_volatile] = ACTIONS(456),
    [anon_sym_record] = ACTIONS(456),
    [anon_sym_ATinterface] = ACTIONS(454),
    [anon_sym_interface] = ACTIONS(456),
    [anon_sym_byte] = ACTIONS(456),
    [anon_sym_short] = ACTIONS(456),
    [anon_sym_int] = ACTIONS(456),
    [anon_sym_long] = ACTIONS(456),
    [anon_sym_char] = ACTIONS(456),
    [anon_sym_float] = ACTIONS(456),
    [anon_sym_double] = ACTIONS(456),
    [sym_boolean_type] = ACTIONS(456),
    [sym_void_type] = ACTIONS(456),
    [sym_this] = ACTIONS(456),
    [sym_super] = ACTIONS(456),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [107] = {
    [ts_builtin_sym_end] = ACTIONS(458),
    [sym_identifier] = ACTIONS(460),
    [sym_decimal_integer_literal] = ACTIONS(460),
    [sym_hex_integer_literal] = ACTIONS(460),
    [sym_octal_integer_literal] = ACTIONS(458),
    [sym_binary_integer_literal] = ACTIONS(458),
    [sym_decimal_floating_point_literal] = ACTIONS(458),
    [sym_hex_floating_point_literal] = ACTIONS(460),
    [sym_true] = ACTIONS(460),
    [sym_false] = ACTIONS(460),
    [sym_character_literal] = ACTIONS(458),
    [sym_string_literal] = ACTIONS(460),
    [sym_text_block] = ACTIONS(458),
    [sym_null_literal] = ACTIONS(460),
    [anon_sym_LPAREN] = ACTIONS(458),
    [anon_sym_LT] = ACTIONS(458),
    [anon_sym_PLUS] = ACTIONS(460),
    [anon_sym_DASH] = ACTIONS(460),
    [anon_sym_BANG] = ACTIONS(458),
    [anon_sym_TILDE] = ACTIONS(458),
    [anon_sym_PLUS_PLUS] = ACTIONS(458),
    [anon_sym_DASH_DASH] = ACTIONS(458),
    [anon_sym_new] = ACTIONS(460),
    [anon_sym_class] = ACTIONS(460),
    [anon_sym_switch] = ACTIONS(460),
    [anon_sym_LBRACE] = ACTIONS(458),
    [anon_sym_RBRACE] = ACTIONS(458),
    [anon_sym_case] = ACTIONS(460),
    [anon_sym_default] = ACTIONS(460),
    [anon_sym_SEMI] = ACTIONS(458),
    [anon_sym_assert] = ACTIONS(460),
    [anon_sym_do] = ACTIONS(460),
    [anon_sym_while] = ACTIONS(460),
    [anon_sym_break] = ACTIONS(460),
    [anon_sym_continue] = ACTIONS(460),
    [anon_sym_return] = ACTIONS(460),
    [anon_sym_yield] = ACTIONS(460),
    [anon_sym_synchronized] = ACTIONS(460),
    [anon_sym_throw] = ACTIONS(460),
    [anon_sym_try] = ACTIONS(460),
    [anon_sym_if] = ACTIONS(460),
    [anon_sym_else] = ACTIONS(460),
    [anon_sym_for] = ACTIONS(460),
    [anon_sym_AT] = ACTIONS(460),
    [anon_sym_open] = ACTIONS(460),
    [anon_sym_module] = ACTIONS(460),
    [anon_sym_static] = ACTIONS(460),
    [anon_sym_package] = ACTIONS(460),
    [anon_sym_import] = ACTIONS(460),
    [anon_sym_enum] = ACTIONS(460),
    [anon_sym_public] = ACTIONS(460),
    [anon_sym_protected] = ACTIONS(460),
    [anon_sym_private] = ACTIONS(460),
    [anon_sym_abstract] = ACTIONS(460),
    [anon_sym_final] = ACTIONS(460),
    [anon_sym_strictfp] = ACTIONS(460),
    [anon_sym_native] = ACTIONS(460),
    [anon_sym_transient] = ACTIONS(460),
    [anon_sym_volatile] = ACTIONS(460),
    [anon_sym_record] = ACTIONS(460),
    [anon_sym_ATinterface] = ACTIONS(458),
    [anon_sym_interface] = ACTIONS(460),
    [anon_sym_byte] = ACTIONS(460),
    [anon_sym_short] = ACTIONS(460),
    [anon_sym_int] = ACTIONS(460),
    [anon_sym_long] = ACTIONS(460),
    [anon_sym_char] = ACTIONS(460),
    [anon_sym_float] = ACTIONS(460),
    [anon_sym_double] = ACTIONS(460),
    [sym_boolean_type] = ACTIONS(460),
    [sym_void_type] = ACTIONS(460),
    [sym_this] = ACTIONS(460),
    [sym_super] = ACTIONS(460),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [108] = {
    [ts_builtin_sym_end] = ACTIONS(462),
    [sym_identifier] = ACTIONS(464),
    [sym_decimal_integer_literal] = ACTIONS(464),
    [sym_hex_integer_literal] = ACTIONS(464),
    [sym_octal_integer_literal] = ACTIONS(462),
    [sym_binary_integer_literal] = ACTIONS(462),
    [sym_decimal_floating_point_literal] = ACTIONS(462),
    [sym_hex_floating_point_literal] = ACTIONS(464),
    [sym_true] = ACTIONS(464),
    [sym_false] = ACTIONS(464),
    [sym_character_literal] = ACTIONS(462),
    [sym_string_literal] = ACTIONS(464),
    [sym_text_block] = ACTIONS(462),
    [sym_null_literal] = ACTIONS(464),
    [anon_sym_LPAREN] = ACTIONS(462),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(462),
    [anon_sym_TILDE] = ACTIONS(462),
    [anon_sym_PLUS_PLUS] = ACTIONS(462),
    [anon_sym_DASH_DASH] = ACTIONS(462),
    [anon_sym_new] = ACTIONS(464),
    [anon_sym_class] = ACTIONS(464),
    [anon_sym_switch] = ACTIONS(464),
    [anon_sym_LBRACE] = ACTIONS(462),
    [anon_sym_RBRACE] = ACTIONS(462),
    [anon_sym_case] = ACTIONS(464),
    [anon_sym_default] = ACTIONS(464),
    [anon_sym_SEMI] = ACTIONS(462),
    [anon_sym_assert] = ACTIONS(464),
    [anon_sym_do] = ACTIONS(464),
    [anon_sym_while] = ACTIONS(464),
    [anon_sym_break] = ACTIONS(464),
    [anon_sym_continue] = ACTIONS(464),
    [anon_sym_return] = ACTIONS(464),
    [anon_sym_yield] = ACTIONS(464),
    [anon_sym_synchronized] = ACTIONS(464),
    [anon_sym_throw] = ACTIONS(464),
    [anon_sym_try] = ACTIONS(464),
    [anon_sym_if] = ACTIONS(464),
    [anon_sym_else] = ACTIONS(464),
    [anon_sym_for] = ACTIONS(464),
    [anon_sym_AT] = ACTIONS(464),
    [anon_sym_open] = ACTIONS(464),
    [anon_sym_module] = ACTIONS(464),
    [anon_sym_static] = ACTIONS(464),
    [anon_sym_package] = ACTIONS(464),
    [anon_sym_import] = ACTIONS(464),
    [anon_sym_enum] = ACTIONS(464),
    [anon_sym_public] = ACTIONS(464),
    [anon_sym_protected] = ACTIONS(464),
    [anon_sym_private] = ACTIONS(464),
    [anon_sym_abstract] = ACTIONS(464),
    [anon_sym_final] = ACTIONS(464),
    [anon_sym_strictfp] = ACTIONS(464),
    [anon_sym_native] = ACTIONS(464),
    [anon_sym_transient] = ACTIONS(464),
    [anon_sym_volatile] = ACTIONS(464),
    [anon_sym_record] = ACTIONS(464),
    [anon_sym_ATinterface] = ACTIONS(462),
    [anon_sym_interface] = ACTIONS(464),
    [anon_sym_byte] = ACTIONS(464),
    [anon_sym_short] = ACTIONS(464),
    [anon_sym_int] = ACTIONS(464),
    [anon_sym_long] = ACTIONS(464),
    [anon_sym_char] = ACTIONS(464),
    [anon_sym_float] = ACTIONS(464),
    [anon_sym_double] = ACTIONS(464),
    [sym_boolean_type] = ACTIONS(464),
    [sym_void_type] = ACTIONS(464),
    [sym_this] = ACTIONS(464),
    [sym_super] = ACTIONS(464),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [109] = {
    [ts_builtin_sym_end] = ACTIONS(466),
    [sym_identifier] = ACTIONS(468),
    [sym_decimal_integer_literal] = ACTIONS(468),
    [sym_hex_integer_literal] = ACTIONS(468),
    [sym_octal_integer_literal] = ACTIONS(466),
    [sym_binary_integer_literal] = ACTIONS(466),
    [sym_decimal_floating_point_literal] = ACTIONS(466),
    [sym_hex_floating_point_literal] = ACTIONS(468),
    [sym_true] = ACTIONS(468),
    [sym_false] = ACTIONS(468),
    [sym_character_literal] = ACTIONS(466),
    [sym_string_literal] = ACTIONS(468),
    [sym_text_block] = ACTIONS(466),
    [sym_null_literal] = ACTIONS(468),
    [anon_sym_LPAREN] = ACTIONS(466),
    [anon_sym_LT] = ACTIONS(466),
    [anon_sym_PLUS] = ACTIONS(468),
    [anon_sym_DASH] = ACTIONS(468),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_PLUS_PLUS] = ACTIONS(466),
    [anon_sym_DASH_DASH] = ACTIONS(466),
    [anon_sym_new] = ACTIONS(468),
    [anon_sym_class] = ACTIONS(468),
    [anon_sym_switch] = ACTIONS(468),
    [anon_sym_LBRACE] = ACTIONS(466),
    [anon_sym_RBRACE] = ACTIONS(466),
    [anon_sym_case] = ACTIONS(468),
    [anon_sym_default] = ACTIONS(468),
    [anon_sym_SEMI] = ACTIONS(466),
    [anon_sym_assert] = ACTIONS(468),
    [anon_sym_do] = ACTIONS(468),
    [anon_sym_while] = ACTIONS(468),
    [anon_sym_break] = ACTIONS(468),
    [anon_sym_continue] = ACTIONS(468),
    [anon_sym_return] = ACTIONS(468),
    [anon_sym_yield] = ACTIONS(468),
    [anon_sym_synchronized] = ACTIONS(468),
    [anon_sym_throw] = ACTIONS(468),
    [anon_sym_try] = ACTIONS(468),
    [anon_sym_if] = ACTIONS(468),
    [anon_sym_else] = ACTIONS(468),
    [anon_sym_for] = ACTIONS(468),
    [anon_sym_AT] = ACTIONS(468),
    [anon_sym_open] = ACTIONS(468),
    [anon_sym_module] = ACTIONS(468),
    [anon_sym_static] = ACTIONS(468),
    [anon_sym_package] = ACTIONS(468),
    [anon_sym_import] = ACTIONS(468),
    [anon_sym_enum] = ACTIONS(468),
    [anon_sym_public] = ACTIONS(468),
    [anon_sym_protected] = ACTIONS(468),
    [anon_sym_private] = ACTIONS(468),
    [anon_sym_abstract] = ACTIONS(468),
    [anon_sym_final] = ACTIONS(468),
    [anon_sym_strictfp] = ACTIONS(468),
    [anon_sym_native] = ACTIONS(468),
    [anon_sym_transient] = ACTIONS(468),
    [anon_sym_volatile] = ACTIONS(468),
    [anon_sym_record] = ACTIONS(468),
    [anon_sym_ATinterface] = ACTIONS(466),
    [anon_sym_interface] = ACTIONS(468),
    [anon_sym_byte] = ACTIONS(468),
    [anon_sym_short] = ACTIONS(468),
    [anon_sym_int] = ACTIONS(468),
    [anon_sym_long] = ACTIONS(468),
    [anon_sym_char] = ACTIONS(468),
    [anon_sym_float] = ACTIONS(468),
    [anon_sym_double] = ACTIONS(468),
    [sym_boolean_type] = ACTIONS(468),
    [sym_void_type] = ACTIONS(468),
    [sym_this] = ACTIONS(468),
    [sym_super] = ACTIONS(468),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [110] = {
    [ts_builtin_sym_end] = ACTIONS(470),
    [sym_identifier] = ACTIONS(472),
    [sym_decimal_integer_literal] = ACTIONS(472),
    [sym_hex_integer_literal] = ACTIONS(472),
    [sym_octal_integer_literal] = ACTIONS(470),
    [sym_binary_integer_literal] = ACTIONS(470),
    [sym_decimal_floating_point_literal] = ACTIONS(470),
    [sym_hex_floating_point_literal] = ACTIONS(472),
    [sym_true] = ACTIONS(472),
    [sym_false] = ACTIONS(472),
    [sym_character_literal] = ACTIONS(470),
    [sym_string_literal] = ACTIONS(472),
    [sym_text_block] = ACTIONS(470),
    [sym_null_literal] = ACTIONS(472),
    [anon_sym_LPAREN] = ACTIONS(470),
    [anon_sym_LT] = ACTIONS(470),
    [anon_sym_PLUS] = ACTIONS(472),
    [anon_sym_DASH] = ACTIONS(472),
    [anon_sym_BANG] = ACTIONS(470),
    [anon_sym_TILDE] = ACTIONS(470),
    [anon_sym_PLUS_PLUS] = ACTIONS(470),
    [anon_sym_DASH_DASH] = ACTIONS(470),
    [anon_sym_new] = ACTIONS(472),
    [anon_sym_class] = ACTIONS(472),
    [anon_sym_switch] = ACTIONS(472),
    [anon_sym_LBRACE] = ACTIONS(470),
    [anon_sym_RBRACE] = ACTIONS(470),
    [anon_sym_case] = ACTIONS(472),
    [anon_sym_default] = ACTIONS(472),
    [anon_sym_SEMI] = ACTIONS(470),
    [anon_sym_assert] = ACTIONS(472),
    [anon_sym_do] = ACTIONS(472),
    [anon_sym_while] = ACTIONS(472),
    [anon_sym_break] = ACTIONS(472),
    [anon_sym_continue] = ACTIONS(472),
    [anon_sym_return] = ACTIONS(472),
    [anon_sym_yield] = ACTIONS(472),
    [anon_sym_synchronized] = ACTIONS(472),
    [anon_sym_throw] = ACTIONS(472),
    [anon_sym_try] = ACTIONS(472),
    [anon_sym_if] = ACTIONS(472),
    [anon_sym_else] = ACTIONS(472),
    [anon_sym_for] = ACTIONS(472),
    [anon_sym_AT] = ACTIONS(472),
    [anon_sym_open] = ACTIONS(472),
    [anon_sym_module] = ACTIONS(472),
    [anon_sym_static] = ACTIONS(472),
    [anon_sym_package] = ACTIONS(472),
    [anon_sym_import] = ACTIONS(472),
    [anon_sym_enum] = ACTIONS(472),
    [anon_sym_public] = ACTIONS(472),
    [anon_sym_protected] = ACTIONS(472),
    [anon_sym_private] = ACTIONS(472),
    [anon_sym_abstract] = ACTIONS(472),
    [anon_sym_final] = ACTIONS(472),
    [anon_sym_strictfp] = ACTIONS(472),
    [anon_sym_native] = ACTIONS(472),
    [anon_sym_transient] = ACTIONS(472),
    [anon_sym_volatile] = ACTIONS(472),
    [anon_sym_record] = ACTIONS(472),
    [anon_sym_ATinterface] = ACTIONS(470),
    [anon_sym_interface] = ACTIONS(472),
    [anon_sym_byte] = ACTIONS(472),
    [anon_sym_short] = ACTIONS(472),
    [anon_sym_int] = ACTIONS(472),
    [anon_sym_long] = ACTIONS(472),
    [anon_sym_char] = ACTIONS(472),
    [anon_sym_float] = ACTIONS(472),
    [anon_sym_double] = ACTIONS(472),
    [sym_boolean_type] = ACTIONS(472),
    [sym_void_type] = ACTIONS(472),
    [sym_this] = ACTIONS(472),
    [sym_super] = ACTIONS(472),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [111] = {
    [ts_builtin_sym_end] = ACTIONS(474),
    [sym_identifier] = ACTIONS(476),
    [sym_decimal_integer_literal] = ACTIONS(476),
    [sym_hex_integer_literal] = ACTIONS(476),
    [sym_octal_integer_literal] = ACTIONS(474),
    [sym_binary_integer_literal] = ACTIONS(474),
    [sym_decimal_floating_point_literal] = ACTIONS(474),
    [sym_hex_floating_point_literal] = ACTIONS(476),
    [sym_true] = ACTIONS(476),
    [sym_false] = ACTIONS(476),
    [sym_character_literal] = ACTIONS(474),
    [sym_string_literal] = ACTIONS(476),
    [sym_text_block] = ACTIONS(474),
    [sym_null_literal] = ACTIONS(476),
    [anon_sym_LPAREN] = ACTIONS(474),
    [anon_sym_LT] = ACTIONS(474),
    [anon_sym_PLUS] = ACTIONS(476),
    [anon_sym_DASH] = ACTIONS(476),
    [anon_sym_BANG] = ACTIONS(474),
    [anon_sym_TILDE] = ACTIONS(474),
    [anon_sym_PLUS_PLUS] = ACTIONS(474),
    [anon_sym_DASH_DASH] = ACTIONS(474),
    [anon_sym_new] = ACTIONS(476),
    [anon_sym_class] = ACTIONS(476),
    [anon_sym_switch] = ACTIONS(476),
    [anon_sym_LBRACE] = ACTIONS(474),
    [anon_sym_RBRACE] = ACTIONS(474),
    [anon_sym_case] = ACTIONS(476),
    [anon_sym_default] = ACTIONS(476),
    [anon_sym_SEMI] = ACTIONS(474),
    [anon_sym_assert] = ACTIONS(476),
    [anon_sym_do] = ACTIONS(476),
    [anon_sym_while] = ACTIONS(476),
    [anon_sym_break] = ACTIONS(476),
    [anon_sym_continue] = ACTIONS(476),
    [anon_sym_return] = ACTIONS(476),
    [anon_sym_yield] = ACTIONS(476),
    [anon_sym_synchronized] = ACTIONS(476),
    [anon_sym_throw] = ACTIONS(476),
    [anon_sym_try] = ACTIONS(476),
    [anon_sym_if] = ACTIONS(476),
    [anon_sym_else] = ACTIONS(476),
    [anon_sym_for] = ACTIONS(476),
    [anon_sym_AT] = ACTIONS(476),
    [anon_sym_open] = ACTIONS(476),
    [anon_sym_module] = ACTIONS(476),
    [anon_sym_static] = ACTIONS(476),
    [anon_sym_package] = ACTIONS(476),
    [anon_sym_import] = ACTIONS(476),
    [anon_sym_enum] = ACTIONS(476),
    [anon_sym_public] = ACTIONS(476),
    [anon_sym_protected] = ACTIONS(476),
    [anon_sym_private] = ACTIONS(476),
    [anon_sym_abstract] = ACTIONS(476),
    [anon_sym_final] = ACTIONS(476),
    [anon_sym_strictfp] = ACTIONS(476),
    [anon_sym_native] = ACTIONS(476),
    [anon_sym_transient] = ACTIONS(476),
    [anon_sym_volatile] = ACTIONS(476),
    [anon_sym_record] = ACTIONS(476),
    [anon_sym_ATinterface] = ACTIONS(474),
    [anon_sym_interface] = ACTIONS(476),
    [anon_sym_byte] = ACTIONS(476),
    [anon_sym_short] = ACTIONS(476),
    [anon_sym_int] = ACTIONS(476),
    [anon_sym_long] = ACTIONS(476),
    [anon_sym_char] = ACTIONS(476),
    [anon_sym_float] = ACTIONS(476),
    [anon_sym_double] = ACTIONS(476),
    [sym_boolean_type] = ACTIONS(476),
    [sym_void_type] = ACTIONS(476),
    [sym_this] = ACTIONS(476),
    [sym_super] = ACTIONS(476),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [112] = {
    [ts_builtin_sym_end] = ACTIONS(478),
    [sym_identifier] = ACTIONS(480),
    [sym_decimal_integer_literal] = ACTIONS(480),
    [sym_hex_integer_literal] = ACTIONS(480),
    [sym_octal_integer_literal] = ACTIONS(478),
    [sym_binary_integer_literal] = ACTIONS(478),
    [sym_decimal_floating_point_literal] = ACTIONS(478),
    [sym_hex_floating_point_literal] = ACTIONS(480),
    [sym_true] = ACTIONS(480),
    [sym_false] = ACTIONS(480),
    [sym_character_literal] = ACTIONS(478),
    [sym_string_literal] = ACTIONS(480),
    [sym_text_block] = ACTIONS(478),
    [sym_null_literal] = ACTIONS(480),
    [anon_sym_LPAREN] = ACTIONS(478),
    [anon_sym_LT] = ACTIONS(478),
    [anon_sym_PLUS] = ACTIONS(480),
    [anon_sym_DASH] = ACTIONS(480),
    [anon_sym_BANG] = ACTIONS(478),
    [anon_sym_TILDE] = ACTIONS(478),
    [anon_sym_PLUS_PLUS] = ACTIONS(478),
    [anon_sym_DASH_DASH] = ACTIONS(478),
    [anon_sym_new] = ACTIONS(480),
    [anon_sym_class] = ACTIONS(480),
    [anon_sym_switch] = ACTIONS(480),
    [anon_sym_LBRACE] = ACTIONS(478),
    [anon_sym_RBRACE] = ACTIONS(478),
    [anon_sym_case] = ACTIONS(480),
    [anon_sym_default] = ACTIONS(480),
    [anon_sym_SEMI] = ACTIONS(478),
    [anon_sym_assert] = ACTIONS(480),
    [anon_sym_do] = ACTIONS(480),
    [anon_sym_while] = ACTIONS(480),
    [anon_sym_break] = ACTIONS(480),
    [anon_sym_continue] = ACTIONS(480),
    [anon_sym_return] = ACTIONS(480),
    [anon_sym_yield] = ACTIONS(480),
    [anon_sym_synchronized] = ACTIONS(480),
    [anon_sym_throw] = ACTIONS(480),
    [anon_sym_try] = ACTIONS(480),
    [anon_sym_if] = ACTIONS(480),
    [anon_sym_else] = ACTIONS(480),
    [anon_sym_for] = ACTIONS(480),
    [anon_sym_AT] = ACTIONS(480),
    [anon_sym_open] = ACTIONS(480),
    [anon_sym_module] = ACTIONS(480),
    [anon_sym_static] = ACTIONS(480),
    [anon_sym_package] = ACTIONS(480),
    [anon_sym_import] = ACTIONS(480),
    [anon_sym_enum] = ACTIONS(480),
    [anon_sym_public] = ACTIONS(480),
    [anon_sym_protected] = ACTIONS(480),
    [anon_sym_private] = ACTIONS(480),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_final] = ACTIONS(480),
    [anon_sym_strictfp] = ACTIONS(480),
    [anon_sym_native] = ACTIONS(480),
    [anon_sym_transient] = ACTIONS(480),
    [anon_sym_volatile] = ACTIONS(480),
    [anon_sym_record] = ACTIONS(480),
    [anon_sym_ATinterface] = ACTIONS(478),
    [anon_sym_interface] = ACTIONS(480),
    [anon_sym_byte] = ACTIONS(480),
    [anon_sym_short] = ACTIONS(480),
    [anon_sym_int] = ACTIONS(480),
    [anon_sym_long] = ACTIONS(480),
    [anon_sym_char] = ACTIONS(480),
    [anon_sym_float] = ACTIONS(480),
    [anon_sym_double] = ACTIONS(480),
    [sym_boolean_type] = ACTIONS(480),
    [sym_void_type] = ACTIONS(480),
    [sym_this] = ACTIONS(480),
    [sym_super] = ACTIONS(480),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [113] = {
    [ts_builtin_sym_end] = ACTIONS(482),
    [sym_identifier] = ACTIONS(484),
    [sym_decimal_integer_literal] = ACTIONS(484),
    [sym_hex_integer_literal] = ACTIONS(484),
    [sym_octal_integer_literal] = ACTIONS(482),
    [sym_binary_integer_literal] = ACTIONS(482),
    [sym_decimal_floating_point_literal] = ACTIONS(482),
    [sym_hex_floating_point_literal] = ACTIONS(484),
    [sym_true] = ACTIONS(484),
    [sym_false] = ACTIONS(484),
    [sym_character_literal] = ACTIONS(482),
    [sym_string_literal] = ACTIONS(484),
    [sym_text_block] = ACTIONS(482),
    [sym_null_literal] = ACTIONS(484),
    [anon_sym_LPAREN] = ACTIONS(482),
    [anon_sym_LT] = ACTIONS(482),
    [anon_sym_PLUS] = ACTIONS(484),
    [anon_sym_DASH] = ACTIONS(484),
    [anon_sym_BANG] = ACTIONS(482),
    [anon_sym_TILDE] = ACTIONS(482),
    [anon_sym_PLUS_PLUS] = ACTIONS(482),
    [anon_sym_DASH_DASH] = ACTIONS(482),
    [anon_sym_new] = ACTIONS(484),
    [anon_sym_class] = ACTIONS(484),
    [anon_sym_switch] = ACTIONS(484),
    [anon_sym_LBRACE] = ACTIONS(482),
    [anon_sym_RBRACE] = ACTIONS(482),
    [anon_sym_case] = ACTIONS(484),
    [anon_sym_default] = ACTIONS(484),
    [anon_sym_SEMI] = ACTIONS(482),
    [anon_sym_assert] = ACTIONS(484),
    [anon_sym_do] = ACTIONS(484),
    [anon_sym_while] = ACTIONS(484),
    [anon_sym_break] = ACTIONS(484),
    [anon_sym_continue] = ACTIONS(484),
    [anon_sym_return] = ACTIONS(484),
    [anon_sym_yield] = ACTIONS(484),
    [anon_sym_synchronized] = ACTIONS(484),
    [anon_sym_throw] = ACTIONS(484),
    [anon_sym_try] = ACTIONS(484),
    [anon_sym_if] = ACTIONS(484),
    [anon_sym_else] = ACTIONS(484),
    [anon_sym_for] = ACTIONS(484),
    [anon_sym_AT] = ACTIONS(484),
    [anon_sym_open] = ACTIONS(484),
    [anon_sym_module] = ACTIONS(484),
    [anon_sym_static] = ACTIONS(484),
    [anon_sym_package] = ACTIONS(484),
    [anon_sym_import] = ACTIONS(484),
    [anon_sym_enum] = ACTIONS(484),
    [anon_sym_public] = ACTIONS(484),
    [anon_sym_protected] = ACTIONS(484),
    [anon_sym_private] = ACTIONS(484),
    [anon_sym_abstract] = ACTIONS(484),
    [anon_sym_final] = ACTIONS(484),
    [anon_sym_strictfp] = ACTIONS(484),
    [anon_sym_native] = ACTIONS(484),
    [anon_sym_transient] = ACTIONS(484),
    [anon_sym_volatile] = ACTIONS(484),
    [anon_sym_record] = ACTIONS(484),
    [anon_sym_ATinterface] = ACTIONS(482),
    [anon_sym_interface] = ACTIONS(484),
    [anon_sym_byte] = ACTIONS(484),
    [anon_sym_short] = ACTIONS(484),
    [anon_sym_int] = ACTIONS(484),
    [anon_sym_long] = ACTIONS(484),
    [anon_sym_char] = ACTIONS(484),
    [anon_sym_float] = ACTIONS(484),
    [anon_sym_double] = ACTIONS(484),
    [sym_boolean_type] = ACTIONS(484),
    [sym_void_type] = ACTIONS(484),
    [sym_this] = ACTIONS(484),
    [sym_super] = ACTIONS(484),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [114] = {
    [ts_builtin_sym_end] = ACTIONS(486),
    [sym_identifier] = ACTIONS(488),
    [sym_decimal_integer_literal] = ACTIONS(488),
    [sym_hex_integer_literal] = ACTIONS(488),
    [sym_octal_integer_literal] = ACTIONS(486),
    [sym_binary_integer_literal] = ACTIONS(486),
    [sym_decimal_floating_point_literal] = ACTIONS(486),
    [sym_hex_floating_point_literal] = ACTIONS(488),
    [sym_true] = ACTIONS(488),
    [sym_false] = ACTIONS(488),
    [sym_character_literal] = ACTIONS(486),
    [sym_string_literal] = ACTIONS(488),
    [sym_text_block] = ACTIONS(486),
    [sym_null_literal] = ACTIONS(488),
    [anon_sym_LPAREN] = ACTIONS(486),
    [anon_sym_LT] = ACTIONS(486),
    [anon_sym_PLUS] = ACTIONS(488),
    [anon_sym_DASH] = ACTIONS(488),
    [anon_sym_BANG] = ACTIONS(486),
    [anon_sym_TILDE] = ACTIONS(486),
    [anon_sym_PLUS_PLUS] = ACTIONS(486),
    [anon_sym_DASH_DASH] = ACTIONS(486),
    [anon_sym_new] = ACTIONS(488),
    [anon_sym_class] = ACTIONS(488),
    [anon_sym_switch] = ACTIONS(488),
    [anon_sym_LBRACE] = ACTIONS(486),
    [anon_sym_RBRACE] = ACTIONS(486),
    [anon_sym_case] = ACTIONS(488),
    [anon_sym_default] = ACTIONS(488),
    [anon_sym_SEMI] = ACTIONS(486),
    [anon_sym_assert] = ACTIONS(488),
    [anon_sym_do] = ACTIONS(488),
    [anon_sym_while] = ACTIONS(488),
    [anon_sym_break] = ACTIONS(488),
    [anon_sym_continue] = ACTIONS(488),
    [anon_sym_return] = ACTIONS(488),
    [anon_sym_yield] = ACTIONS(488),
    [anon_sym_synchronized] = ACTIONS(488),
    [anon_sym_throw] = ACTIONS(488),
    [anon_sym_try] = ACTIONS(488),
    [anon_sym_if] = ACTIONS(488),
    [anon_sym_else] = ACTIONS(488),
    [anon_sym_for] = ACTIONS(488),
    [anon_sym_AT] = ACTIONS(488),
    [anon_sym_open] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(488),
    [anon_sym_static] = ACTIONS(488),
    [anon_sym_package] = ACTIONS(488),
    [anon_sym_import] = ACTIONS(488),
    [anon_sym_enum] = ACTIONS(488),
    [anon_sym_public] = ACTIONS(488),
    [anon_sym_protected] = ACTIONS(488),
    [anon_sym_private] = ACTIONS(488),
    [anon_sym_abstract] = ACTIONS(488),
    [anon_sym_final] = ACTIONS(488),
    [anon_sym_strictfp] = ACTIONS(488),
    [anon_sym_native] = ACTIONS(488),
    [anon_sym_transient] = ACTIONS(488),
    [anon_sym_volatile] = ACTIONS(488),
    [anon_sym_record] = ACTIONS(488),
    [anon_sym_ATinterface] = ACTIONS(486),
    [anon_sym_interface] = ACTIONS(488),
    [anon_sym_byte] = ACTIONS(488),
    [anon_sym_short] = ACTIONS(488),
    [anon_sym_int] = ACTIONS(488),
    [anon_sym_long] = ACTIONS(488),
    [anon_sym_char] = ACTIONS(488),
    [anon_sym_float] = ACTIONS(488),
    [anon_sym_double] = ACTIONS(488),
    [sym_boolean_type] = ACTIONS(488),
    [sym_void_type] = ACTIONS(488),
    [sym_this] = ACTIONS(488),
    [sym_super] = ACTIONS(488),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [115] = {
    [ts_builtin_sym_end] = ACTIONS(490),
    [sym_identifier] = ACTIONS(492),
    [sym_decimal_integer_literal] = ACTIONS(492),
    [sym_hex_integer_literal] = ACTIONS(492),
    [sym_octal_integer_literal] = ACTIONS(490),
    [sym_binary_integer_literal] = ACTIONS(490),
    [sym_decimal_floating_point_literal] = ACTIONS(490),
    [sym_hex_floating_point_literal] = ACTIONS(492),
    [sym_true] = ACTIONS(492),
    [sym_false] = ACTIONS(492),
    [sym_character_literal] = ACTIONS(490),
    [sym_string_literal] = ACTIONS(492),
    [sym_text_block] = ACTIONS(490),
    [sym_null_literal] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(490),
    [anon_sym_LT] = ACTIONS(490),
    [anon_sym_PLUS] = ACTIONS(492),
    [anon_sym_DASH] = ACTIONS(492),
    [anon_sym_BANG] = ACTIONS(490),
    [anon_sym_TILDE] = ACTIONS(490),
    [anon_sym_PLUS_PLUS] = ACTIONS(490),
    [anon_sym_DASH_DASH] = ACTIONS(490),
    [anon_sym_new] = ACTIONS(492),
    [anon_sym_class] = ACTIONS(492),
    [anon_sym_switch] = ACTIONS(492),
    [anon_sym_LBRACE] = ACTIONS(490),
    [anon_sym_RBRACE] = ACTIONS(490),
    [anon_sym_case] = ACTIONS(492),
    [anon_sym_default] = ACTIONS(492),
    [anon_sym_SEMI] = ACTIONS(490),
    [anon_sym_assert] = ACTIONS(492),
    [anon_sym_do] = ACTIONS(492),
    [anon_sym_while] = ACTIONS(492),
    [anon_sym_break] = ACTIONS(492),
    [anon_sym_continue] = ACTIONS(492),
    [anon_sym_return] = ACTIONS(492),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_synchronized] = ACTIONS(492),
    [anon_sym_throw] = ACTIONS(492),
    [anon_sym_try] = ACTIONS(492),
    [anon_sym_if] = ACTIONS(492),
    [anon_sym_else] = ACTIONS(492),
    [anon_sym_for] = ACTIONS(492),
    [anon_sym_AT] = ACTIONS(492),
    [anon_sym_open] = ACTIONS(492),
    [anon_sym_module] = ACTIONS(492),
    [anon_sym_static] = ACTIONS(492),
    [anon_sym_package] = ACTIONS(492),
    [anon_sym_import] = ACTIONS(492),
    [anon_sym_enum] = ACTIONS(492),
    [anon_sym_public] = ACTIONS(492),
    [anon_sym_protected] = ACTIONS(492),
    [anon_sym_private] = ACTIONS(492),
    [anon_sym_abstract] = ACTIONS(492),
    [anon_sym_final] = ACTIONS(492),
    [anon_sym_strictfp] = ACTIONS(492),
    [anon_sym_native] = ACTIONS(492),
    [anon_sym_transient] = ACTIONS(492),
    [anon_sym_volatile] = ACTIONS(492),
    [anon_sym_record] = ACTIONS(492),
    [anon_sym_ATinterface] = ACTIONS(490),
    [anon_sym_interface] = ACTIONS(492),
    [anon_sym_byte] = ACTIONS(492),
    [anon_sym_short] = ACTIONS(492),
    [anon_sym_int] = ACTIONS(492),
    [anon_sym_long] = ACTIONS(492),
    [anon_sym_char] = ACTIONS(492),
    [anon_sym_float] = ACTIONS(492),
    [anon_sym_double] = ACTIONS(492),
    [sym_boolean_type] = ACTIONS(492),
    [sym_void_type] = ACTIONS(492),
    [sym_this] = ACTIONS(492),
    [sym_super] = ACTIONS(492),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [116] = {
    [ts_builtin_sym_end] = ACTIONS(494),
    [sym_identifier] = ACTIONS(496),
    [sym_decimal_integer_literal] = ACTIONS(496),
    [sym_hex_integer_literal] = ACTIONS(496),
    [sym_octal_integer_literal] = ACTIONS(494),
    [sym_binary_integer_literal] = ACTIONS(494),
    [sym_decimal_floating_point_literal] = ACTIONS(494),
    [sym_hex_floating_point_literal] = ACTIONS(496),
    [sym_true] = ACTIONS(496),
    [sym_false] = ACTIONS(496),
    [sym_character_literal] = ACTIONS(494),
    [sym_string_literal] = ACTIONS(496),
    [sym_text_block] = ACTIONS(494),
    [sym_null_literal] = ACTIONS(496),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_LT] = ACTIONS(494),
    [anon_sym_PLUS] = ACTIONS(496),
    [anon_sym_DASH] = ACTIONS(496),
    [anon_sym_BANG] = ACTIONS(494),
    [anon_sym_TILDE] = ACTIONS(494),
    [anon_sym_PLUS_PLUS] = ACTIONS(494),
    [anon_sym_DASH_DASH] = ACTIONS(494),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_class] = ACTIONS(496),
    [anon_sym_switch] = ACTIONS(496),
    [anon_sym_LBRACE] = ACTIONS(494),
    [anon_sym_RBRACE] = ACTIONS(494),
    [anon_sym_case] = ACTIONS(496),
    [anon_sym_default] = ACTIONS(496),
    [anon_sym_SEMI] = ACTIONS(494),
    [anon_sym_assert] = ACTIONS(496),
    [anon_sym_do] = ACTIONS(496),
    [anon_sym_while] = ACTIONS(496),
    [anon_sym_break] = ACTIONS(496),
    [anon_sym_continue] = ACTIONS(496),
    [anon_sym_return] = ACTIONS(496),
    [anon_sym_yield] = ACTIONS(496),
    [anon_sym_synchronized] = ACTIONS(496),
    [anon_sym_throw] = ACTIONS(496),
    [anon_sym_try] = ACTIONS(496),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_else] = ACTIONS(496),
    [anon_sym_for] = ACTIONS(496),
    [anon_sym_AT] = ACTIONS(496),
    [anon_sym_open] = ACTIONS(496),
    [anon_sym_module] = ACTIONS(496),
    [anon_sym_static] = ACTIONS(496),
    [anon_sym_package] = ACTIONS(496),
    [anon_sym_import] = ACTIONS(496),
    [anon_sym_enum] = ACTIONS(496),
    [anon_sym_public] = ACTIONS(496),
    [anon_sym_protected] = ACTIONS(496),
    [anon_sym_private] = ACTIONS(496),
    [anon_sym_abstract] = ACTIONS(496),
    [anon_sym_final] = ACTIONS(496),
    [anon_sym_strictfp] = ACTIONS(496),
    [anon_sym_native] = ACTIONS(496),
    [anon_sym_transient] = ACTIONS(496),
    [anon_sym_volatile] = ACTIONS(496),
    [anon_sym_record] = ACTIONS(496),
    [anon_sym_ATinterface] = ACTIONS(494),
    [anon_sym_interface] = ACTIONS(496),
    [anon_sym_byte] = ACTIONS(496),
    [anon_sym_short] = ACTIONS(496),
    [anon_sym_int] = ACTIONS(496),
    [anon_sym_long] = ACTIONS(496),
    [anon_sym_char] = ACTIONS(496),
    [anon_sym_float] = ACTIONS(496),
    [anon_sym_double] = ACTIONS(496),
    [sym_boolean_type] = ACTIONS(496),
    [sym_void_type] = ACTIONS(496),
    [sym_this] = ACTIONS(496),
    [sym_super] = ACTIONS(496),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [117] = {
    [ts_builtin_sym_end] = ACTIONS(498),
    [sym_identifier] = ACTIONS(500),
    [sym_decimal_integer_literal] = ACTIONS(500),
    [sym_hex_integer_literal] = ACTIONS(500),
    [sym_octal_integer_literal] = ACTIONS(498),
    [sym_binary_integer_literal] = ACTIONS(498),
    [sym_decimal_floating_point_literal] = ACTIONS(498),
    [sym_hex_floating_point_literal] = ACTIONS(500),
    [sym_true] = ACTIONS(500),
    [sym_false] = ACTIONS(500),
    [sym_character_literal] = ACTIONS(498),
    [sym_string_literal] = ACTIONS(500),
    [sym_text_block] = ACTIONS(498),
    [sym_null_literal] = ACTIONS(500),
    [anon_sym_LPAREN] = ACTIONS(498),
    [anon_sym_LT] = ACTIONS(498),
    [anon_sym_PLUS] = ACTIONS(500),
    [anon_sym_DASH] = ACTIONS(500),
    [anon_sym_BANG] = ACTIONS(498),
    [anon_sym_TILDE] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(498),
    [anon_sym_DASH_DASH] = ACTIONS(498),
    [anon_sym_new] = ACTIONS(500),
    [anon_sym_class] = ACTIONS(500),
    [anon_sym_switch] = ACTIONS(500),
    [anon_sym_LBRACE] = ACTIONS(498),
    [anon_sym_RBRACE] = ACTIONS(498),
    [anon_sym_case] = ACTIONS(500),
    [anon_sym_default] = ACTIONS(500),
    [anon_sym_SEMI] = ACTIONS(498),
    [anon_sym_assert] = ACTIONS(500),
    [anon_sym_do] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(500),
    [anon_sym_break] = ACTIONS(500),
    [anon_sym_continue] = ACTIONS(500),
    [anon_sym_return] = ACTIONS(500),
    [anon_sym_yield] = ACTIONS(500),
    [anon_sym_synchronized] = ACTIONS(500),
    [anon_sym_throw] = ACTIONS(500),
    [anon_sym_try] = ACTIONS(500),
    [anon_sym_if] = ACTIONS(500),
    [anon_sym_else] = ACTIONS(500),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_AT] = ACTIONS(500),
    [anon_sym_open] = ACTIONS(500),
    [anon_sym_module] = ACTIONS(500),
    [anon_sym_static] = ACTIONS(500),
    [anon_sym_package] = ACTIONS(500),
    [anon_sym_import] = ACTIONS(500),
    [anon_sym_enum] = ACTIONS(500),
    [anon_sym_public] = ACTIONS(500),
    [anon_sym_protected] = ACTIONS(500),
    [anon_sym_private] = ACTIONS(500),
    [anon_sym_abstract] = ACTIONS(500),
    [anon_sym_final] = ACTIONS(500),
    [anon_sym_strictfp] = ACTIONS(500),
    [anon_sym_native] = ACTIONS(500),
    [anon_sym_transient] = ACTIONS(500),
    [anon_sym_volatile] = ACTIONS(500),
    [anon_sym_record] = ACTIONS(500),
    [anon_sym_ATinterface] = ACTIONS(498),
    [anon_sym_interface] = ACTIONS(500),
    [anon_sym_byte] = ACTIONS(500),
    [anon_sym_short] = ACTIONS(500),
    [anon_sym_int] = ACTIONS(500),
    [anon_sym_long] = ACTIONS(500),
    [anon_sym_char] = ACTIONS(500),
    [anon_sym_float] = ACTIONS(500),
    [anon_sym_double] = ACTIONS(500),
    [sym_boolean_type] = ACTIONS(500),
    [sym_void_type] = ACTIONS(500),
    [sym_this] = ACTIONS(500),
    [sym_super] = ACTIONS(500),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [118] = {
    [ts_builtin_sym_end] = ACTIONS(502),
    [sym_identifier] = ACTIONS(504),
    [sym_decimal_integer_literal] = ACTIONS(504),
    [sym_hex_integer_literal] = ACTIONS(504),
    [sym_octal_integer_literal] = ACTIONS(502),
    [sym_binary_integer_literal] = ACTIONS(502),
    [sym_decimal_floating_point_literal] = ACTIONS(502),
    [sym_hex_floating_point_literal] = ACTIONS(504),
    [sym_true] = ACTIONS(504),
    [sym_false] = ACTIONS(504),
    [sym_character_literal] = ACTIONS(502),
    [sym_string_literal] = ACTIONS(504),
    [sym_text_block] = ACTIONS(502),
    [sym_null_literal] = ACTIONS(504),
    [anon_sym_LPAREN] = ACTIONS(502),
    [anon_sym_PLUS] = ACTIONS(504),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_BANG] = ACTIONS(502),
    [anon_sym_TILDE] = ACTIONS(502),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [anon_sym_new] = ACTIONS(504),
    [anon_sym_class] = ACTIONS(504),
    [anon_sym_switch] = ACTIONS(504),
    [anon_sym_LBRACE] = ACTIONS(502),
    [anon_sym_RBRACE] = ACTIONS(502),
    [anon_sym_case] = ACTIONS(504),
    [anon_sym_default] = ACTIONS(504),
    [anon_sym_SEMI] = ACTIONS(502),
    [anon_sym_assert] = ACTIONS(504),
    [anon_sym_do] = ACTIONS(504),
    [anon_sym_while] = ACTIONS(504),
    [anon_sym_break] = ACTIONS(504),
    [anon_sym_continue] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(504),
    [anon_sym_yield] = ACTIONS(504),
    [anon_sym_synchronized] = ACTIONS(504),
    [anon_sym_throw] = ACTIONS(504),
    [anon_sym_try] = ACTIONS(504),
    [anon_sym_catch] = ACTIONS(504),
    [anon_sym_finally] = ACTIONS(504),
    [anon_sym_if] = ACTIONS(504),
    [anon_sym_else] = ACTIONS(504),
    [anon_sym_for] = ACTIONS(504),
    [anon_sym_AT] = ACTIONS(504),
    [anon_sym_open] = ACTIONS(504),
    [anon_sym_module] = ACTIONS(504),
    [anon_sym_static] = ACTIONS(504),
    [anon_sym_package] = ACTIONS(504),
    [anon_sym_import] = ACTIONS(504),
    [anon_sym_enum] = ACTIONS(504),
    [anon_sym_public] = ACTIONS(504),
    [anon_sym_protected] = ACTIONS(504),
    [anon_sym_private] = ACTIONS(504),
    [anon_sym_abstract] = ACTIONS(504),
    [anon_sym_final] = ACTIONS(504),
    [anon_sym_strictfp] = ACTIONS(504),
    [anon_sym_native] = ACTIONS(504),
    [anon_sym_transient] = ACTIONS(504),
    [anon_sym_volatile] = ACTIONS(504),
    [anon_sym_ATinterface] = ACTIONS(502),
    [anon_sym_interface] = ACTIONS(504),
    [anon_sym_byte] = ACTIONS(504),
    [anon_sym_short] = ACTIONS(504),
    [anon_sym_int] = ACTIONS(504),
    [anon_sym_long] = ACTIONS(504),
    [anon_sym_char] = ACTIONS(504),
    [anon_sym_float] = ACTIONS(504),
    [anon_sym_double] = ACTIONS(504),
    [sym_boolean_type] = ACTIONS(504),
    [sym_void_type] = ACTIONS(504),
    [sym_this] = ACTIONS(504),
    [sym_super] = ACTIONS(504),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [119] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(492),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym_array_initializer] = STATE(942),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(315),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [120] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(506),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(506),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [121] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(468),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(508),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [122] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(510),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [123] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(516),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(512),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [124] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(511),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(514),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [125] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(456),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(516),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [126] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(505),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(518),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [127] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(478),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(520),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [128] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(486),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [129] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(459),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(524),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [130] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(505),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(526),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [131] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(515),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(528),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [132] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(506),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(530),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [133] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(471),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(532),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [134] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(514),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(534),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [135] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(465),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(536),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [136] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(483),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(538),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [137] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(466),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(540),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [138] = {
    [ts_builtin_sym_end] = ACTIONS(542),
    [sym_identifier] = ACTIONS(544),
    [sym_decimal_integer_literal] = ACTIONS(544),
    [sym_hex_integer_literal] = ACTIONS(544),
    [sym_octal_integer_literal] = ACTIONS(542),
    [sym_binary_integer_literal] = ACTIONS(542),
    [sym_decimal_floating_point_literal] = ACTIONS(542),
    [sym_hex_floating_point_literal] = ACTIONS(544),
    [sym_true] = ACTIONS(544),
    [sym_false] = ACTIONS(544),
    [sym_character_literal] = ACTIONS(542),
    [sym_string_literal] = ACTIONS(544),
    [sym_text_block] = ACTIONS(542),
    [sym_null_literal] = ACTIONS(544),
    [anon_sym_LPAREN] = ACTIONS(542),
    [anon_sym_PLUS] = ACTIONS(544),
    [anon_sym_DASH] = ACTIONS(544),
    [anon_sym_BANG] = ACTIONS(542),
    [anon_sym_TILDE] = ACTIONS(542),
    [anon_sym_PLUS_PLUS] = ACTIONS(542),
    [anon_sym_DASH_DASH] = ACTIONS(542),
    [anon_sym_new] = ACTIONS(544),
    [anon_sym_class] = ACTIONS(544),
    [anon_sym_switch] = ACTIONS(544),
    [anon_sym_LBRACE] = ACTIONS(542),
    [anon_sym_RBRACE] = ACTIONS(542),
    [anon_sym_case] = ACTIONS(544),
    [anon_sym_default] = ACTIONS(544),
    [anon_sym_SEMI] = ACTIONS(542),
    [anon_sym_assert] = ACTIONS(544),
    [anon_sym_do] = ACTIONS(544),
    [anon_sym_while] = ACTIONS(544),
    [anon_sym_break] = ACTIONS(544),
    [anon_sym_continue] = ACTIONS(544),
    [anon_sym_return] = ACTIONS(544),
    [anon_sym_yield] = ACTIONS(544),
    [anon_sym_synchronized] = ACTIONS(544),
    [anon_sym_throw] = ACTIONS(544),
    [anon_sym_try] = ACTIONS(544),
    [anon_sym_if] = ACTIONS(544),
    [anon_sym_else] = ACTIONS(544),
    [anon_sym_for] = ACTIONS(544),
    [anon_sym_AT] = ACTIONS(544),
    [anon_sym_open] = ACTIONS(544),
    [anon_sym_module] = ACTIONS(544),
    [anon_sym_static] = ACTIONS(544),
    [anon_sym_package] = ACTIONS(544),
    [anon_sym_import] = ACTIONS(544),
    [anon_sym_enum] = ACTIONS(544),
    [anon_sym_public] = ACTIONS(544),
    [anon_sym_protected] = ACTIONS(544),
    [anon_sym_private] = ACTIONS(544),
    [anon_sym_abstract] = ACTIONS(544),
    [anon_sym_final] = ACTIONS(544),
    [anon_sym_strictfp] = ACTIONS(544),
    [anon_sym_native] = ACTIONS(544),
    [anon_sym_transient] = ACTIONS(544),
    [anon_sym_volatile] = ACTIONS(544),
    [anon_sym_ATinterface] = ACTIONS(542),
    [anon_sym_interface] = ACTIONS(544),
    [anon_sym_byte] = ACTIONS(544),
    [anon_sym_short] = ACTIONS(544),
    [anon_sym_int] = ACTIONS(544),
    [anon_sym_long] = ACTIONS(544),
    [anon_sym_char] = ACTIONS(544),
    [anon_sym_float] = ACTIONS(544),
    [anon_sym_double] = ACTIONS(544),
    [sym_boolean_type] = ACTIONS(544),
    [sym_void_type] = ACTIONS(544),
    [sym_this] = ACTIONS(544),
    [sym_super] = ACTIONS(544),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [139] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(506),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [140] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(437),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [141] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(438),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [142] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(412),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [143] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(440),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [144] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(434),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [145] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(431),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [146] = {
    [ts_builtin_sym_end] = ACTIONS(546),
    [sym_identifier] = ACTIONS(548),
    [sym_decimal_integer_literal] = ACTIONS(548),
    [sym_hex_integer_literal] = ACTIONS(548),
    [sym_octal_integer_literal] = ACTIONS(546),
    [sym_binary_integer_literal] = ACTIONS(546),
    [sym_decimal_floating_point_literal] = ACTIONS(546),
    [sym_hex_floating_point_literal] = ACTIONS(548),
    [sym_true] = ACTIONS(548),
    [sym_false] = ACTIONS(548),
    [sym_character_literal] = ACTIONS(546),
    [sym_string_literal] = ACTIONS(548),
    [sym_text_block] = ACTIONS(546),
    [sym_null_literal] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(546),
    [anon_sym_PLUS] = ACTIONS(548),
    [anon_sym_DASH] = ACTIONS(548),
    [anon_sym_BANG] = ACTIONS(546),
    [anon_sym_TILDE] = ACTIONS(546),
    [anon_sym_PLUS_PLUS] = ACTIONS(546),
    [anon_sym_DASH_DASH] = ACTIONS(546),
    [anon_sym_new] = ACTIONS(548),
    [anon_sym_class] = ACTIONS(548),
    [anon_sym_switch] = ACTIONS(548),
    [anon_sym_LBRACE] = ACTIONS(546),
    [anon_sym_RBRACE] = ACTIONS(546),
    [anon_sym_case] = ACTIONS(548),
    [anon_sym_default] = ACTIONS(548),
    [anon_sym_SEMI] = ACTIONS(546),
    [anon_sym_assert] = ACTIONS(548),
    [anon_sym_do] = ACTIONS(548),
    [anon_sym_while] = ACTIONS(548),
    [anon_sym_break] = ACTIONS(548),
    [anon_sym_continue] = ACTIONS(548),
    [anon_sym_return] = ACTIONS(548),
    [anon_sym_yield] = ACTIONS(548),
    [anon_sym_synchronized] = ACTIONS(548),
    [anon_sym_throw] = ACTIONS(548),
    [anon_sym_try] = ACTIONS(548),
    [anon_sym_if] = ACTIONS(548),
    [anon_sym_else] = ACTIONS(548),
    [anon_sym_for] = ACTIONS(548),
    [anon_sym_AT] = ACTIONS(548),
    [anon_sym_open] = ACTIONS(548),
    [anon_sym_module] = ACTIONS(548),
    [anon_sym_static] = ACTIONS(548),
    [anon_sym_package] = ACTIONS(548),
    [anon_sym_import] = ACTIONS(548),
    [anon_sym_enum] = ACTIONS(548),
    [anon_sym_public] = ACTIONS(548),
    [anon_sym_protected] = ACTIONS(548),
    [anon_sym_private] = ACTIONS(548),
    [anon_sym_abstract] = ACTIONS(548),
    [anon_sym_final] = ACTIONS(548),
    [anon_sym_strictfp] = ACTIONS(548),
    [anon_sym_native] = ACTIONS(548),
    [anon_sym_transient] = ACTIONS(548),
    [anon_sym_volatile] = ACTIONS(548),
    [anon_sym_ATinterface] = ACTIONS(546),
    [anon_sym_interface] = ACTIONS(548),
    [anon_sym_byte] = ACTIONS(548),
    [anon_sym_short] = ACTIONS(548),
    [anon_sym_int] = ACTIONS(548),
    [anon_sym_long] = ACTIONS(548),
    [anon_sym_char] = ACTIONS(548),
    [anon_sym_float] = ACTIONS(548),
    [anon_sym_double] = ACTIONS(548),
    [sym_boolean_type] = ACTIONS(548),
    [sym_void_type] = ACTIONS(548),
    [sym_this] = ACTIONS(548),
    [sym_super] = ACTIONS(548),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [147] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(520),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [148] = {
    [ts_builtin_sym_end] = ACTIONS(550),
    [sym_identifier] = ACTIONS(552),
    [sym_decimal_integer_literal] = ACTIONS(552),
    [sym_hex_integer_literal] = ACTIONS(552),
    [sym_octal_integer_literal] = ACTIONS(550),
    [sym_binary_integer_literal] = ACTIONS(550),
    [sym_decimal_floating_point_literal] = ACTIONS(550),
    [sym_hex_floating_point_literal] = ACTIONS(552),
    [sym_true] = ACTIONS(552),
    [sym_false] = ACTIONS(552),
    [sym_character_literal] = ACTIONS(550),
    [sym_string_literal] = ACTIONS(552),
    [sym_text_block] = ACTIONS(550),
    [sym_null_literal] = ACTIONS(552),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_PLUS] = ACTIONS(552),
    [anon_sym_DASH] = ACTIONS(552),
    [anon_sym_BANG] = ACTIONS(550),
    [anon_sym_TILDE] = ACTIONS(550),
    [anon_sym_PLUS_PLUS] = ACTIONS(550),
    [anon_sym_DASH_DASH] = ACTIONS(550),
    [anon_sym_new] = ACTIONS(552),
    [anon_sym_class] = ACTIONS(552),
    [anon_sym_switch] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(550),
    [anon_sym_RBRACE] = ACTIONS(550),
    [anon_sym_case] = ACTIONS(552),
    [anon_sym_default] = ACTIONS(552),
    [anon_sym_SEMI] = ACTIONS(550),
    [anon_sym_assert] = ACTIONS(552),
    [anon_sym_do] = ACTIONS(552),
    [anon_sym_while] = ACTIONS(552),
    [anon_sym_break] = ACTIONS(552),
    [anon_sym_continue] = ACTIONS(552),
    [anon_sym_return] = ACTIONS(552),
    [anon_sym_yield] = ACTIONS(552),
    [anon_sym_synchronized] = ACTIONS(552),
    [anon_sym_throw] = ACTIONS(552),
    [anon_sym_try] = ACTIONS(552),
    [anon_sym_if] = ACTIONS(552),
    [anon_sym_else] = ACTIONS(552),
    [anon_sym_for] = ACTIONS(552),
    [anon_sym_AT] = ACTIONS(552),
    [anon_sym_open] = ACTIONS(552),
    [anon_sym_module] = ACTIONS(552),
    [anon_sym_static] = ACTIONS(552),
    [anon_sym_package] = ACTIONS(552),
    [anon_sym_import] = ACTIONS(552),
    [anon_sym_enum] = ACTIONS(552),
    [anon_sym_public] = ACTIONS(552),
    [anon_sym_protected] = ACTIONS(552),
    [anon_sym_private] = ACTIONS(552),
    [anon_sym_abstract] = ACTIONS(552),
    [anon_sym_final] = ACTIONS(552),
    [anon_sym_strictfp] = ACTIONS(552),
    [anon_sym_native] = ACTIONS(552),
    [anon_sym_transient] = ACTIONS(552),
    [anon_sym_volatile] = ACTIONS(552),
    [anon_sym_ATinterface] = ACTIONS(550),
    [anon_sym_interface] = ACTIONS(552),
    [anon_sym_byte] = ACTIONS(552),
    [anon_sym_short] = ACTIONS(552),
    [anon_sym_int] = ACTIONS(552),
    [anon_sym_long] = ACTIONS(552),
    [anon_sym_char] = ACTIONS(552),
    [anon_sym_float] = ACTIONS(552),
    [anon_sym_double] = ACTIONS(552),
    [sym_boolean_type] = ACTIONS(552),
    [sym_void_type] = ACTIONS(552),
    [sym_this] = ACTIONS(552),
    [sym_super] = ACTIONS(552),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [149] = {
    [ts_builtin_sym_end] = ACTIONS(554),
    [sym_identifier] = ACTIONS(556),
    [sym_decimal_integer_literal] = ACTIONS(556),
    [sym_hex_integer_literal] = ACTIONS(556),
    [sym_octal_integer_literal] = ACTIONS(554),
    [sym_binary_integer_literal] = ACTIONS(554),
    [sym_decimal_floating_point_literal] = ACTIONS(554),
    [sym_hex_floating_point_literal] = ACTIONS(556),
    [sym_true] = ACTIONS(556),
    [sym_false] = ACTIONS(556),
    [sym_character_literal] = ACTIONS(554),
    [sym_string_literal] = ACTIONS(556),
    [sym_text_block] = ACTIONS(554),
    [sym_null_literal] = ACTIONS(556),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_BANG] = ACTIONS(554),
    [anon_sym_TILDE] = ACTIONS(554),
    [anon_sym_PLUS_PLUS] = ACTIONS(554),
    [anon_sym_DASH_DASH] = ACTIONS(554),
    [anon_sym_new] = ACTIONS(556),
    [anon_sym_class] = ACTIONS(556),
    [anon_sym_switch] = ACTIONS(556),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_RBRACE] = ACTIONS(554),
    [anon_sym_case] = ACTIONS(556),
    [anon_sym_default] = ACTIONS(556),
    [anon_sym_SEMI] = ACTIONS(554),
    [anon_sym_assert] = ACTIONS(556),
    [anon_sym_do] = ACTIONS(556),
    [anon_sym_while] = ACTIONS(556),
    [anon_sym_break] = ACTIONS(556),
    [anon_sym_continue] = ACTIONS(556),
    [anon_sym_return] = ACTIONS(556),
    [anon_sym_yield] = ACTIONS(556),
    [anon_sym_synchronized] = ACTIONS(556),
    [anon_sym_throw] = ACTIONS(556),
    [anon_sym_try] = ACTIONS(556),
    [anon_sym_if] = ACTIONS(556),
    [anon_sym_else] = ACTIONS(556),
    [anon_sym_for] = ACTIONS(556),
    [anon_sym_AT] = ACTIONS(556),
    [anon_sym_open] = ACTIONS(556),
    [anon_sym_module] = ACTIONS(556),
    [anon_sym_static] = ACTIONS(556),
    [anon_sym_package] = ACTIONS(556),
    [anon_sym_import] = ACTIONS(556),
    [anon_sym_enum] = ACTIONS(556),
    [anon_sym_public] = ACTIONS(556),
    [anon_sym_protected] = ACTIONS(556),
    [anon_sym_private] = ACTIONS(556),
    [anon_sym_abstract] = ACTIONS(556),
    [anon_sym_final] = ACTIONS(556),
    [anon_sym_strictfp] = ACTIONS(556),
    [anon_sym_native] = ACTIONS(556),
    [anon_sym_transient] = ACTIONS(556),
    [anon_sym_volatile] = ACTIONS(556),
    [anon_sym_ATinterface] = ACTIONS(554),
    [anon_sym_interface] = ACTIONS(556),
    [anon_sym_byte] = ACTIONS(556),
    [anon_sym_short] = ACTIONS(556),
    [anon_sym_int] = ACTIONS(556),
    [anon_sym_long] = ACTIONS(556),
    [anon_sym_char] = ACTIONS(556),
    [anon_sym_float] = ACTIONS(556),
    [anon_sym_double] = ACTIONS(556),
    [sym_boolean_type] = ACTIONS(556),
    [sym_void_type] = ACTIONS(556),
    [sym_this] = ACTIONS(556),
    [sym_super] = ACTIONS(556),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [150] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(519),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [151] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(433),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [152] = {
    [ts_builtin_sym_end] = ACTIONS(558),
    [sym_identifier] = ACTIONS(560),
    [sym_decimal_integer_literal] = ACTIONS(560),
    [sym_hex_integer_literal] = ACTIONS(560),
    [sym_octal_integer_literal] = ACTIONS(558),
    [sym_binary_integer_literal] = ACTIONS(558),
    [sym_decimal_floating_point_literal] = ACTIONS(558),
    [sym_hex_floating_point_literal] = ACTIONS(560),
    [sym_true] = ACTIONS(560),
    [sym_false] = ACTIONS(560),
    [sym_character_literal] = ACTIONS(558),
    [sym_string_literal] = ACTIONS(560),
    [sym_text_block] = ACTIONS(558),
    [sym_null_literal] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(558),
    [anon_sym_PLUS] = ACTIONS(560),
    [anon_sym_DASH] = ACTIONS(560),
    [anon_sym_BANG] = ACTIONS(558),
    [anon_sym_TILDE] = ACTIONS(558),
    [anon_sym_PLUS_PLUS] = ACTIONS(558),
    [anon_sym_DASH_DASH] = ACTIONS(558),
    [anon_sym_new] = ACTIONS(560),
    [anon_sym_class] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(560),
    [anon_sym_LBRACE] = ACTIONS(558),
    [anon_sym_RBRACE] = ACTIONS(558),
    [anon_sym_case] = ACTIONS(560),
    [anon_sym_default] = ACTIONS(560),
    [anon_sym_SEMI] = ACTIONS(558),
    [anon_sym_assert] = ACTIONS(560),
    [anon_sym_do] = ACTIONS(560),
    [anon_sym_while] = ACTIONS(560),
    [anon_sym_break] = ACTIONS(560),
    [anon_sym_continue] = ACTIONS(560),
    [anon_sym_return] = ACTIONS(560),
    [anon_sym_yield] = ACTIONS(560),
    [anon_sym_synchronized] = ACTIONS(560),
    [anon_sym_throw] = ACTIONS(560),
    [anon_sym_try] = ACTIONS(560),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_else] = ACTIONS(560),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_AT] = ACTIONS(560),
    [anon_sym_open] = ACTIONS(560),
    [anon_sym_module] = ACTIONS(560),
    [anon_sym_static] = ACTIONS(560),
    [anon_sym_package] = ACTIONS(560),
    [anon_sym_import] = ACTIONS(560),
    [anon_sym_enum] = ACTIONS(560),
    [anon_sym_public] = ACTIONS(560),
    [anon_sym_protected] = ACTIONS(560),
    [anon_sym_private] = ACTIONS(560),
    [anon_sym_abstract] = ACTIONS(560),
    [anon_sym_final] = ACTIONS(560),
    [anon_sym_strictfp] = ACTIONS(560),
    [anon_sym_native] = ACTIONS(560),
    [anon_sym_transient] = ACTIONS(560),
    [anon_sym_volatile] = ACTIONS(560),
    [anon_sym_ATinterface] = ACTIONS(558),
    [anon_sym_interface] = ACTIONS(560),
    [anon_sym_byte] = ACTIONS(560),
    [anon_sym_short] = ACTIONS(560),
    [anon_sym_int] = ACTIONS(560),
    [anon_sym_long] = ACTIONS(560),
    [anon_sym_char] = ACTIONS(560),
    [anon_sym_float] = ACTIONS(560),
    [anon_sym_double] = ACTIONS(560),
    [sym_boolean_type] = ACTIONS(560),
    [sym_void_type] = ACTIONS(560),
    [sym_this] = ACTIONS(560),
    [sym_super] = ACTIONS(560),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [153] = {
    [ts_builtin_sym_end] = ACTIONS(562),
    [sym_identifier] = ACTIONS(564),
    [sym_decimal_integer_literal] = ACTIONS(564),
    [sym_hex_integer_literal] = ACTIONS(564),
    [sym_octal_integer_literal] = ACTIONS(562),
    [sym_binary_integer_literal] = ACTIONS(562),
    [sym_decimal_floating_point_literal] = ACTIONS(562),
    [sym_hex_floating_point_literal] = ACTIONS(564),
    [sym_true] = ACTIONS(564),
    [sym_false] = ACTIONS(564),
    [sym_character_literal] = ACTIONS(562),
    [sym_string_literal] = ACTIONS(564),
    [sym_text_block] = ACTIONS(562),
    [sym_null_literal] = ACTIONS(564),
    [anon_sym_LPAREN] = ACTIONS(562),
    [anon_sym_PLUS] = ACTIONS(564),
    [anon_sym_DASH] = ACTIONS(564),
    [anon_sym_BANG] = ACTIONS(562),
    [anon_sym_TILDE] = ACTIONS(562),
    [anon_sym_PLUS_PLUS] = ACTIONS(562),
    [anon_sym_DASH_DASH] = ACTIONS(562),
    [anon_sym_new] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_switch] = ACTIONS(564),
    [anon_sym_LBRACE] = ACTIONS(562),
    [anon_sym_RBRACE] = ACTIONS(562),
    [anon_sym_case] = ACTIONS(564),
    [anon_sym_default] = ACTIONS(564),
    [anon_sym_SEMI] = ACTIONS(562),
    [anon_sym_assert] = ACTIONS(564),
    [anon_sym_do] = ACTIONS(564),
    [anon_sym_while] = ACTIONS(564),
    [anon_sym_break] = ACTIONS(564),
    [anon_sym_continue] = ACTIONS(564),
    [anon_sym_return] = ACTIONS(564),
    [anon_sym_yield] = ACTIONS(564),
    [anon_sym_synchronized] = ACTIONS(564),
    [anon_sym_throw] = ACTIONS(564),
    [anon_sym_try] = ACTIONS(564),
    [anon_sym_if] = ACTIONS(564),
    [anon_sym_else] = ACTIONS(564),
    [anon_sym_for] = ACTIONS(564),
    [anon_sym_AT] = ACTIONS(564),
    [anon_sym_open] = ACTIONS(564),
    [anon_sym_module] = ACTIONS(564),
    [anon_sym_static] = ACTIONS(564),
    [anon_sym_package] = ACTIONS(564),
    [anon_sym_import] = ACTIONS(564),
    [anon_sym_enum] = ACTIONS(564),
    [anon_sym_public] = ACTIONS(564),
    [anon_sym_protected] = ACTIONS(564),
    [anon_sym_private] = ACTIONS(564),
    [anon_sym_abstract] = ACTIONS(564),
    [anon_sym_final] = ACTIONS(564),
    [anon_sym_strictfp] = ACTIONS(564),
    [anon_sym_native] = ACTIONS(564),
    [anon_sym_transient] = ACTIONS(564),
    [anon_sym_volatile] = ACTIONS(564),
    [anon_sym_ATinterface] = ACTIONS(562),
    [anon_sym_interface] = ACTIONS(564),
    [anon_sym_byte] = ACTIONS(564),
    [anon_sym_short] = ACTIONS(564),
    [anon_sym_int] = ACTIONS(564),
    [anon_sym_long] = ACTIONS(564),
    [anon_sym_char] = ACTIONS(564),
    [anon_sym_float] = ACTIONS(564),
    [anon_sym_double] = ACTIONS(564),
    [sym_boolean_type] = ACTIONS(564),
    [sym_void_type] = ACTIONS(564),
    [sym_this] = ACTIONS(564),
    [sym_super] = ACTIONS(564),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [154] = {
    [ts_builtin_sym_end] = ACTIONS(566),
    [sym_identifier] = ACTIONS(568),
    [sym_decimal_integer_literal] = ACTIONS(568),
    [sym_hex_integer_literal] = ACTIONS(568),
    [sym_octal_integer_literal] = ACTIONS(566),
    [sym_binary_integer_literal] = ACTIONS(566),
    [sym_decimal_floating_point_literal] = ACTIONS(566),
    [sym_hex_floating_point_literal] = ACTIONS(568),
    [sym_true] = ACTIONS(568),
    [sym_false] = ACTIONS(568),
    [sym_character_literal] = ACTIONS(566),
    [sym_string_literal] = ACTIONS(568),
    [sym_text_block] = ACTIONS(566),
    [sym_null_literal] = ACTIONS(568),
    [anon_sym_LPAREN] = ACTIONS(566),
    [anon_sym_PLUS] = ACTIONS(568),
    [anon_sym_DASH] = ACTIONS(568),
    [anon_sym_BANG] = ACTIONS(566),
    [anon_sym_TILDE] = ACTIONS(566),
    [anon_sym_PLUS_PLUS] = ACTIONS(566),
    [anon_sym_DASH_DASH] = ACTIONS(566),
    [anon_sym_new] = ACTIONS(568),
    [anon_sym_class] = ACTIONS(568),
    [anon_sym_switch] = ACTIONS(568),
    [anon_sym_LBRACE] = ACTIONS(566),
    [anon_sym_RBRACE] = ACTIONS(566),
    [anon_sym_case] = ACTIONS(568),
    [anon_sym_default] = ACTIONS(568),
    [anon_sym_SEMI] = ACTIONS(566),
    [anon_sym_assert] = ACTIONS(568),
    [anon_sym_do] = ACTIONS(568),
    [anon_sym_while] = ACTIONS(568),
    [anon_sym_break] = ACTIONS(568),
    [anon_sym_continue] = ACTIONS(568),
    [anon_sym_return] = ACTIONS(568),
    [anon_sym_yield] = ACTIONS(568),
    [anon_sym_synchronized] = ACTIONS(568),
    [anon_sym_throw] = ACTIONS(568),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_if] = ACTIONS(568),
    [anon_sym_else] = ACTIONS(568),
    [anon_sym_for] = ACTIONS(568),
    [anon_sym_AT] = ACTIONS(568),
    [anon_sym_open] = ACTIONS(568),
    [anon_sym_module] = ACTIONS(568),
    [anon_sym_static] = ACTIONS(568),
    [anon_sym_package] = ACTIONS(568),
    [anon_sym_import] = ACTIONS(568),
    [anon_sym_enum] = ACTIONS(568),
    [anon_sym_public] = ACTIONS(568),
    [anon_sym_protected] = ACTIONS(568),
    [anon_sym_private] = ACTIONS(568),
    [anon_sym_abstract] = ACTIONS(568),
    [anon_sym_final] = ACTIONS(568),
    [anon_sym_strictfp] = ACTIONS(568),
    [anon_sym_native] = ACTIONS(568),
    [anon_sym_transient] = ACTIONS(568),
    [anon_sym_volatile] = ACTIONS(568),
    [anon_sym_ATinterface] = ACTIONS(566),
    [anon_sym_interface] = ACTIONS(568),
    [anon_sym_byte] = ACTIONS(568),
    [anon_sym_short] = ACTIONS(568),
    [anon_sym_int] = ACTIONS(568),
    [anon_sym_long] = ACTIONS(568),
    [anon_sym_char] = ACTIONS(568),
    [anon_sym_float] = ACTIONS(568),
    [anon_sym_double] = ACTIONS(568),
    [sym_boolean_type] = ACTIONS(568),
    [sym_void_type] = ACTIONS(568),
    [sym_this] = ACTIONS(568),
    [sym_super] = ACTIONS(568),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [155] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(501),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [156] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(500),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [157] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(497),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [158] = {
    [ts_builtin_sym_end] = ACTIONS(570),
    [sym_identifier] = ACTIONS(572),
    [sym_decimal_integer_literal] = ACTIONS(572),
    [sym_hex_integer_literal] = ACTIONS(572),
    [sym_octal_integer_literal] = ACTIONS(570),
    [sym_binary_integer_literal] = ACTIONS(570),
    [sym_decimal_floating_point_literal] = ACTIONS(570),
    [sym_hex_floating_point_literal] = ACTIONS(572),
    [sym_true] = ACTIONS(572),
    [sym_false] = ACTIONS(572),
    [sym_character_literal] = ACTIONS(570),
    [sym_string_literal] = ACTIONS(572),
    [sym_text_block] = ACTIONS(570),
    [sym_null_literal] = ACTIONS(572),
    [anon_sym_LPAREN] = ACTIONS(570),
    [anon_sym_PLUS] = ACTIONS(572),
    [anon_sym_DASH] = ACTIONS(572),
    [anon_sym_BANG] = ACTIONS(570),
    [anon_sym_TILDE] = ACTIONS(570),
    [anon_sym_PLUS_PLUS] = ACTIONS(570),
    [anon_sym_DASH_DASH] = ACTIONS(570),
    [anon_sym_new] = ACTIONS(572),
    [anon_sym_class] = ACTIONS(572),
    [anon_sym_switch] = ACTIONS(572),
    [anon_sym_LBRACE] = ACTIONS(570),
    [anon_sym_RBRACE] = ACTIONS(570),
    [anon_sym_case] = ACTIONS(572),
    [anon_sym_default] = ACTIONS(572),
    [anon_sym_SEMI] = ACTIONS(570),
    [anon_sym_assert] = ACTIONS(572),
    [anon_sym_do] = ACTIONS(572),
    [anon_sym_while] = ACTIONS(572),
    [anon_sym_break] = ACTIONS(572),
    [anon_sym_continue] = ACTIONS(572),
    [anon_sym_return] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(572),
    [anon_sym_synchronized] = ACTIONS(572),
    [anon_sym_throw] = ACTIONS(572),
    [anon_sym_try] = ACTIONS(572),
    [anon_sym_if] = ACTIONS(572),
    [anon_sym_else] = ACTIONS(572),
    [anon_sym_for] = ACTIONS(572),
    [anon_sym_AT] = ACTIONS(572),
    [anon_sym_open] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(572),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_package] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(572),
    [anon_sym_enum] = ACTIONS(572),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(572),
    [anon_sym_final] = ACTIONS(572),
    [anon_sym_strictfp] = ACTIONS(572),
    [anon_sym_native] = ACTIONS(572),
    [anon_sym_transient] = ACTIONS(572),
    [anon_sym_volatile] = ACTIONS(572),
    [anon_sym_ATinterface] = ACTIONS(570),
    [anon_sym_interface] = ACTIONS(572),
    [anon_sym_byte] = ACTIONS(572),
    [anon_sym_short] = ACTIONS(572),
    [anon_sym_int] = ACTIONS(572),
    [anon_sym_long] = ACTIONS(572),
    [anon_sym_char] = ACTIONS(572),
    [anon_sym_float] = ACTIONS(572),
    [anon_sym_double] = ACTIONS(572),
    [sym_boolean_type] = ACTIONS(572),
    [sym_void_type] = ACTIONS(572),
    [sym_this] = ACTIONS(572),
    [sym_super] = ACTIONS(572),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [159] = {
    [ts_builtin_sym_end] = ACTIONS(263),
    [sym_identifier] = ACTIONS(265),
    [sym_decimal_integer_literal] = ACTIONS(265),
    [sym_hex_integer_literal] = ACTIONS(265),
    [sym_octal_integer_literal] = ACTIONS(263),
    [sym_binary_integer_literal] = ACTIONS(263),
    [sym_decimal_floating_point_literal] = ACTIONS(263),
    [sym_hex_floating_point_literal] = ACTIONS(265),
    [sym_true] = ACTIONS(265),
    [sym_false] = ACTIONS(265),
    [sym_character_literal] = ACTIONS(263),
    [sym_string_literal] = ACTIONS(265),
    [sym_text_block] = ACTIONS(263),
    [sym_null_literal] = ACTIONS(265),
    [anon_sym_LPAREN] = ACTIONS(263),
    [anon_sym_PLUS] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(265),
    [anon_sym_BANG] = ACTIONS(263),
    [anon_sym_TILDE] = ACTIONS(263),
    [anon_sym_PLUS_PLUS] = ACTIONS(263),
    [anon_sym_DASH_DASH] = ACTIONS(263),
    [anon_sym_new] = ACTIONS(265),
    [anon_sym_class] = ACTIONS(265),
    [anon_sym_switch] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(263),
    [anon_sym_RBRACE] = ACTIONS(263),
    [anon_sym_case] = ACTIONS(265),
    [anon_sym_default] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(263),
    [anon_sym_assert] = ACTIONS(265),
    [anon_sym_do] = ACTIONS(265),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(265),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(265),
    [anon_sym_yield] = ACTIONS(265),
    [anon_sym_synchronized] = ACTIONS(265),
    [anon_sym_throw] = ACTIONS(265),
    [anon_sym_try] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(265),
    [anon_sym_else] = ACTIONS(265),
    [anon_sym_for] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_open] = ACTIONS(265),
    [anon_sym_module] = ACTIONS(265),
    [anon_sym_static] = ACTIONS(265),
    [anon_sym_package] = ACTIONS(265),
    [anon_sym_import] = ACTIONS(265),
    [anon_sym_enum] = ACTIONS(265),
    [anon_sym_public] = ACTIONS(265),
    [anon_sym_protected] = ACTIONS(265),
    [anon_sym_private] = ACTIONS(265),
    [anon_sym_abstract] = ACTIONS(265),
    [anon_sym_final] = ACTIONS(265),
    [anon_sym_strictfp] = ACTIONS(265),
    [anon_sym_native] = ACTIONS(265),
    [anon_sym_transient] = ACTIONS(265),
    [anon_sym_volatile] = ACTIONS(265),
    [anon_sym_ATinterface] = ACTIONS(263),
    [anon_sym_interface] = ACTIONS(265),
    [anon_sym_byte] = ACTIONS(265),
    [anon_sym_short] = ACTIONS(265),
    [anon_sym_int] = ACTIONS(265),
    [anon_sym_long] = ACTIONS(265),
    [anon_sym_char] = ACTIONS(265),
    [anon_sym_float] = ACTIONS(265),
    [anon_sym_double] = ACTIONS(265),
    [sym_boolean_type] = ACTIONS(265),
    [sym_void_type] = ACTIONS(265),
    [sym_this] = ACTIONS(265),
    [sym_super] = ACTIONS(265),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [160] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(491),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [161] = {
    [ts_builtin_sym_end] = ACTIONS(574),
    [sym_identifier] = ACTIONS(576),
    [sym_decimal_integer_literal] = ACTIONS(576),
    [sym_hex_integer_literal] = ACTIONS(576),
    [sym_octal_integer_literal] = ACTIONS(574),
    [sym_binary_integer_literal] = ACTIONS(574),
    [sym_decimal_floating_point_literal] = ACTIONS(574),
    [sym_hex_floating_point_literal] = ACTIONS(576),
    [sym_true] = ACTIONS(576),
    [sym_false] = ACTIONS(576),
    [sym_character_literal] = ACTIONS(574),
    [sym_string_literal] = ACTIONS(576),
    [sym_text_block] = ACTIONS(574),
    [sym_null_literal] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(574),
    [anon_sym_PLUS] = ACTIONS(576),
    [anon_sym_DASH] = ACTIONS(576),
    [anon_sym_BANG] = ACTIONS(574),
    [anon_sym_TILDE] = ACTIONS(574),
    [anon_sym_PLUS_PLUS] = ACTIONS(574),
    [anon_sym_DASH_DASH] = ACTIONS(574),
    [anon_sym_new] = ACTIONS(576),
    [anon_sym_class] = ACTIONS(576),
    [anon_sym_switch] = ACTIONS(576),
    [anon_sym_LBRACE] = ACTIONS(574),
    [anon_sym_RBRACE] = ACTIONS(574),
    [anon_sym_case] = ACTIONS(576),
    [anon_sym_default] = ACTIONS(576),
    [anon_sym_SEMI] = ACTIONS(574),
    [anon_sym_assert] = ACTIONS(576),
    [anon_sym_do] = ACTIONS(576),
    [anon_sym_while] = ACTIONS(576),
    [anon_sym_break] = ACTIONS(576),
    [anon_sym_continue] = ACTIONS(576),
    [anon_sym_return] = ACTIONS(576),
    [anon_sym_yield] = ACTIONS(576),
    [anon_sym_synchronized] = ACTIONS(576),
    [anon_sym_throw] = ACTIONS(576),
    [anon_sym_try] = ACTIONS(576),
    [anon_sym_if] = ACTIONS(576),
    [anon_sym_else] = ACTIONS(576),
    [anon_sym_for] = ACTIONS(576),
    [anon_sym_AT] = ACTIONS(576),
    [anon_sym_open] = ACTIONS(576),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_static] = ACTIONS(576),
    [anon_sym_package] = ACTIONS(576),
    [anon_sym_import] = ACTIONS(576),
    [anon_sym_enum] = ACTIONS(576),
    [anon_sym_public] = ACTIONS(576),
    [anon_sym_protected] = ACTIONS(576),
    [anon_sym_private] = ACTIONS(576),
    [anon_sym_abstract] = ACTIONS(576),
    [anon_sym_final] = ACTIONS(576),
    [anon_sym_strictfp] = ACTIONS(576),
    [anon_sym_native] = ACTIONS(576),
    [anon_sym_transient] = ACTIONS(576),
    [anon_sym_volatile] = ACTIONS(576),
    [anon_sym_ATinterface] = ACTIONS(574),
    [anon_sym_interface] = ACTIONS(576),
    [anon_sym_byte] = ACTIONS(576),
    [anon_sym_short] = ACTIONS(576),
    [anon_sym_int] = ACTIONS(576),
    [anon_sym_long] = ACTIONS(576),
    [anon_sym_char] = ACTIONS(576),
    [anon_sym_float] = ACTIONS(576),
    [anon_sym_double] = ACTIONS(576),
    [sym_boolean_type] = ACTIONS(576),
    [sym_void_type] = ACTIONS(576),
    [sym_this] = ACTIONS(576),
    [sym_super] = ACTIONS(576),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [162] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(416),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1043),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1043),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(422),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(424),
    [anon_sym_PLUS] = ACTIONS(426),
    [anon_sym_DASH] = ACTIONS(426),
    [anon_sym_BANG] = ACTIONS(428),
    [anon_sym_TILDE] = ACTIONS(428),
    [anon_sym_PLUS_PLUS] = ACTIONS(430),
    [anon_sym_DASH_DASH] = ACTIONS(430),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(432),
    [anon_sym_module] = ACTIONS(432),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [163] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(421),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1043),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1043),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(422),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(424),
    [anon_sym_PLUS] = ACTIONS(426),
    [anon_sym_DASH] = ACTIONS(426),
    [anon_sym_BANG] = ACTIONS(428),
    [anon_sym_TILDE] = ACTIONS(428),
    [anon_sym_PLUS_PLUS] = ACTIONS(430),
    [anon_sym_DASH_DASH] = ACTIONS(430),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(432),
    [anon_sym_module] = ACTIONS(432),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [164] = {
    [ts_builtin_sym_end] = ACTIONS(578),
    [sym_identifier] = ACTIONS(580),
    [sym_decimal_integer_literal] = ACTIONS(580),
    [sym_hex_integer_literal] = ACTIONS(580),
    [sym_octal_integer_literal] = ACTIONS(578),
    [sym_binary_integer_literal] = ACTIONS(578),
    [sym_decimal_floating_point_literal] = ACTIONS(578),
    [sym_hex_floating_point_literal] = ACTIONS(580),
    [sym_true] = ACTIONS(580),
    [sym_false] = ACTIONS(580),
    [sym_character_literal] = ACTIONS(578),
    [sym_string_literal] = ACTIONS(580),
    [sym_text_block] = ACTIONS(578),
    [sym_null_literal] = ACTIONS(580),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_PLUS] = ACTIONS(580),
    [anon_sym_DASH] = ACTIONS(580),
    [anon_sym_BANG] = ACTIONS(578),
    [anon_sym_TILDE] = ACTIONS(578),
    [anon_sym_PLUS_PLUS] = ACTIONS(578),
    [anon_sym_DASH_DASH] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(580),
    [anon_sym_class] = ACTIONS(580),
    [anon_sym_switch] = ACTIONS(580),
    [anon_sym_LBRACE] = ACTIONS(578),
    [anon_sym_RBRACE] = ACTIONS(578),
    [anon_sym_case] = ACTIONS(580),
    [anon_sym_default] = ACTIONS(580),
    [anon_sym_SEMI] = ACTIONS(578),
    [anon_sym_assert] = ACTIONS(580),
    [anon_sym_do] = ACTIONS(580),
    [anon_sym_while] = ACTIONS(580),
    [anon_sym_break] = ACTIONS(580),
    [anon_sym_continue] = ACTIONS(580),
    [anon_sym_return] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(580),
    [anon_sym_synchronized] = ACTIONS(580),
    [anon_sym_throw] = ACTIONS(580),
    [anon_sym_try] = ACTIONS(580),
    [anon_sym_if] = ACTIONS(580),
    [anon_sym_else] = ACTIONS(580),
    [anon_sym_for] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(580),
    [anon_sym_open] = ACTIONS(580),
    [anon_sym_module] = ACTIONS(580),
    [anon_sym_static] = ACTIONS(580),
    [anon_sym_package] = ACTIONS(580),
    [anon_sym_import] = ACTIONS(580),
    [anon_sym_enum] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(580),
    [anon_sym_protected] = ACTIONS(580),
    [anon_sym_private] = ACTIONS(580),
    [anon_sym_abstract] = ACTIONS(580),
    [anon_sym_final] = ACTIONS(580),
    [anon_sym_strictfp] = ACTIONS(580),
    [anon_sym_native] = ACTIONS(580),
    [anon_sym_transient] = ACTIONS(580),
    [anon_sym_volatile] = ACTIONS(580),
    [anon_sym_ATinterface] = ACTIONS(578),
    [anon_sym_interface] = ACTIONS(580),
    [anon_sym_byte] = ACTIONS(580),
    [anon_sym_short] = ACTIONS(580),
    [anon_sym_int] = ACTIONS(580),
    [anon_sym_long] = ACTIONS(580),
    [anon_sym_char] = ACTIONS(580),
    [anon_sym_float] = ACTIONS(580),
    [anon_sym_double] = ACTIONS(580),
    [sym_boolean_type] = ACTIONS(580),
    [sym_void_type] = ACTIONS(580),
    [sym_this] = ACTIONS(580),
    [sym_super] = ACTIONS(580),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [165] = {
    [ts_builtin_sym_end] = ACTIONS(582),
    [sym_identifier] = ACTIONS(584),
    [sym_decimal_integer_literal] = ACTIONS(584),
    [sym_hex_integer_literal] = ACTIONS(584),
    [sym_octal_integer_literal] = ACTIONS(582),
    [sym_binary_integer_literal] = ACTIONS(582),
    [sym_decimal_floating_point_literal] = ACTIONS(582),
    [sym_hex_floating_point_literal] = ACTIONS(584),
    [sym_true] = ACTIONS(584),
    [sym_false] = ACTIONS(584),
    [sym_character_literal] = ACTIONS(582),
    [sym_string_literal] = ACTIONS(584),
    [sym_text_block] = ACTIONS(582),
    [sym_null_literal] = ACTIONS(584),
    [anon_sym_LPAREN] = ACTIONS(582),
    [anon_sym_PLUS] = ACTIONS(584),
    [anon_sym_DASH] = ACTIONS(584),
    [anon_sym_BANG] = ACTIONS(582),
    [anon_sym_TILDE] = ACTIONS(582),
    [anon_sym_PLUS_PLUS] = ACTIONS(582),
    [anon_sym_DASH_DASH] = ACTIONS(582),
    [anon_sym_new] = ACTIONS(584),
    [anon_sym_class] = ACTIONS(584),
    [anon_sym_switch] = ACTIONS(584),
    [anon_sym_LBRACE] = ACTIONS(582),
    [anon_sym_RBRACE] = ACTIONS(582),
    [anon_sym_case] = ACTIONS(584),
    [anon_sym_default] = ACTIONS(584),
    [anon_sym_SEMI] = ACTIONS(582),
    [anon_sym_assert] = ACTIONS(584),
    [anon_sym_do] = ACTIONS(584),
    [anon_sym_while] = ACTIONS(584),
    [anon_sym_break] = ACTIONS(584),
    [anon_sym_continue] = ACTIONS(584),
    [anon_sym_return] = ACTIONS(584),
    [anon_sym_yield] = ACTIONS(584),
    [anon_sym_synchronized] = ACTIONS(584),
    [anon_sym_throw] = ACTIONS(584),
    [anon_sym_try] = ACTIONS(584),
    [anon_sym_if] = ACTIONS(584),
    [anon_sym_else] = ACTIONS(584),
    [anon_sym_for] = ACTIONS(584),
    [anon_sym_AT] = ACTIONS(584),
    [anon_sym_open] = ACTIONS(584),
    [anon_sym_module] = ACTIONS(584),
    [anon_sym_static] = ACTIONS(584),
    [anon_sym_package] = ACTIONS(584),
    [anon_sym_import] = ACTIONS(584),
    [anon_sym_enum] = ACTIONS(584),
    [anon_sym_public] = ACTIONS(584),
    [anon_sym_protected] = ACTIONS(584),
    [anon_sym_private] = ACTIONS(584),
    [anon_sym_abstract] = ACTIONS(584),
    [anon_sym_final] = ACTIONS(584),
    [anon_sym_strictfp] = ACTIONS(584),
    [anon_sym_native] = ACTIONS(584),
    [anon_sym_transient] = ACTIONS(584),
    [anon_sym_volatile] = ACTIONS(584),
    [anon_sym_ATinterface] = ACTIONS(582),
    [anon_sym_interface] = ACTIONS(584),
    [anon_sym_byte] = ACTIONS(584),
    [anon_sym_short] = ACTIONS(584),
    [anon_sym_int] = ACTIONS(584),
    [anon_sym_long] = ACTIONS(584),
    [anon_sym_char] = ACTIONS(584),
    [anon_sym_float] = ACTIONS(584),
    [anon_sym_double] = ACTIONS(584),
    [sym_boolean_type] = ACTIONS(584),
    [sym_void_type] = ACTIONS(584),
    [sym_this] = ACTIONS(584),
    [sym_super] = ACTIONS(584),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [166] = {
    [ts_builtin_sym_end] = ACTIONS(586),
    [sym_identifier] = ACTIONS(588),
    [sym_decimal_integer_literal] = ACTIONS(588),
    [sym_hex_integer_literal] = ACTIONS(588),
    [sym_octal_integer_literal] = ACTIONS(586),
    [sym_binary_integer_literal] = ACTIONS(586),
    [sym_decimal_floating_point_literal] = ACTIONS(586),
    [sym_hex_floating_point_literal] = ACTIONS(588),
    [sym_true] = ACTIONS(588),
    [sym_false] = ACTIONS(588),
    [sym_character_literal] = ACTIONS(586),
    [sym_string_literal] = ACTIONS(588),
    [sym_text_block] = ACTIONS(586),
    [sym_null_literal] = ACTIONS(588),
    [anon_sym_LPAREN] = ACTIONS(586),
    [anon_sym_PLUS] = ACTIONS(588),
    [anon_sym_DASH] = ACTIONS(588),
    [anon_sym_BANG] = ACTIONS(586),
    [anon_sym_TILDE] = ACTIONS(586),
    [anon_sym_PLUS_PLUS] = ACTIONS(586),
    [anon_sym_DASH_DASH] = ACTIONS(586),
    [anon_sym_new] = ACTIONS(588),
    [anon_sym_class] = ACTIONS(588),
    [anon_sym_switch] = ACTIONS(588),
    [anon_sym_LBRACE] = ACTIONS(586),
    [anon_sym_RBRACE] = ACTIONS(586),
    [anon_sym_case] = ACTIONS(588),
    [anon_sym_default] = ACTIONS(588),
    [anon_sym_SEMI] = ACTIONS(586),
    [anon_sym_assert] = ACTIONS(588),
    [anon_sym_do] = ACTIONS(588),
    [anon_sym_while] = ACTIONS(588),
    [anon_sym_break] = ACTIONS(588),
    [anon_sym_continue] = ACTIONS(588),
    [anon_sym_return] = ACTIONS(588),
    [anon_sym_yield] = ACTIONS(588),
    [anon_sym_synchronized] = ACTIONS(588),
    [anon_sym_throw] = ACTIONS(588),
    [anon_sym_try] = ACTIONS(588),
    [anon_sym_if] = ACTIONS(588),
    [anon_sym_else] = ACTIONS(588),
    [anon_sym_for] = ACTIONS(588),
    [anon_sym_AT] = ACTIONS(588),
    [anon_sym_open] = ACTIONS(588),
    [anon_sym_module] = ACTIONS(588),
    [anon_sym_static] = ACTIONS(588),
    [anon_sym_package] = ACTIONS(588),
    [anon_sym_import] = ACTIONS(588),
    [anon_sym_enum] = ACTIONS(588),
    [anon_sym_public] = ACTIONS(588),
    [anon_sym_protected] = ACTIONS(588),
    [anon_sym_private] = ACTIONS(588),
    [anon_sym_abstract] = ACTIONS(588),
    [anon_sym_final] = ACTIONS(588),
    [anon_sym_strictfp] = ACTIONS(588),
    [anon_sym_native] = ACTIONS(588),
    [anon_sym_transient] = ACTIONS(588),
    [anon_sym_volatile] = ACTIONS(588),
    [anon_sym_ATinterface] = ACTIONS(586),
    [anon_sym_interface] = ACTIONS(588),
    [anon_sym_byte] = ACTIONS(588),
    [anon_sym_short] = ACTIONS(588),
    [anon_sym_int] = ACTIONS(588),
    [anon_sym_long] = ACTIONS(588),
    [anon_sym_char] = ACTIONS(588),
    [anon_sym_float] = ACTIONS(588),
    [anon_sym_double] = ACTIONS(588),
    [sym_boolean_type] = ACTIONS(588),
    [sym_void_type] = ACTIONS(588),
    [sym_this] = ACTIONS(588),
    [sym_super] = ACTIONS(588),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [167] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(505),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [168] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(487),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [169] = {
    [ts_builtin_sym_end] = ACTIONS(590),
    [sym_identifier] = ACTIONS(592),
    [sym_decimal_integer_literal] = ACTIONS(592),
    [sym_hex_integer_literal] = ACTIONS(592),
    [sym_octal_integer_literal] = ACTIONS(590),
    [sym_binary_integer_literal] = ACTIONS(590),
    [sym_decimal_floating_point_literal] = ACTIONS(590),
    [sym_hex_floating_point_literal] = ACTIONS(592),
    [sym_true] = ACTIONS(592),
    [sym_false] = ACTIONS(592),
    [sym_character_literal] = ACTIONS(590),
    [sym_string_literal] = ACTIONS(592),
    [sym_text_block] = ACTIONS(590),
    [sym_null_literal] = ACTIONS(592),
    [anon_sym_LPAREN] = ACTIONS(590),
    [anon_sym_PLUS] = ACTIONS(592),
    [anon_sym_DASH] = ACTIONS(592),
    [anon_sym_BANG] = ACTIONS(590),
    [anon_sym_TILDE] = ACTIONS(590),
    [anon_sym_PLUS_PLUS] = ACTIONS(590),
    [anon_sym_DASH_DASH] = ACTIONS(590),
    [anon_sym_new] = ACTIONS(592),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_switch] = ACTIONS(592),
    [anon_sym_LBRACE] = ACTIONS(590),
    [anon_sym_RBRACE] = ACTIONS(590),
    [anon_sym_case] = ACTIONS(592),
    [anon_sym_default] = ACTIONS(592),
    [anon_sym_SEMI] = ACTIONS(590),
    [anon_sym_assert] = ACTIONS(592),
    [anon_sym_do] = ACTIONS(592),
    [anon_sym_while] = ACTIONS(592),
    [anon_sym_break] = ACTIONS(592),
    [anon_sym_continue] = ACTIONS(592),
    [anon_sym_return] = ACTIONS(592),
    [anon_sym_yield] = ACTIONS(592),
    [anon_sym_synchronized] = ACTIONS(592),
    [anon_sym_throw] = ACTIONS(592),
    [anon_sym_try] = ACTIONS(592),
    [anon_sym_if] = ACTIONS(592),
    [anon_sym_else] = ACTIONS(592),
    [anon_sym_for] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(592),
    [anon_sym_open] = ACTIONS(592),
    [anon_sym_module] = ACTIONS(592),
    [anon_sym_static] = ACTIONS(592),
    [anon_sym_package] = ACTIONS(592),
    [anon_sym_import] = ACTIONS(592),
    [anon_sym_enum] = ACTIONS(592),
    [anon_sym_public] = ACTIONS(592),
    [anon_sym_protected] = ACTIONS(592),
    [anon_sym_private] = ACTIONS(592),
    [anon_sym_abstract] = ACTIONS(592),
    [anon_sym_final] = ACTIONS(592),
    [anon_sym_strictfp] = ACTIONS(592),
    [anon_sym_native] = ACTIONS(592),
    [anon_sym_transient] = ACTIONS(592),
    [anon_sym_volatile] = ACTIONS(592),
    [anon_sym_ATinterface] = ACTIONS(590),
    [anon_sym_interface] = ACTIONS(592),
    [anon_sym_byte] = ACTIONS(592),
    [anon_sym_short] = ACTIONS(592),
    [anon_sym_int] = ACTIONS(592),
    [anon_sym_long] = ACTIONS(592),
    [anon_sym_char] = ACTIONS(592),
    [anon_sym_float] = ACTIONS(592),
    [anon_sym_double] = ACTIONS(592),
    [sym_boolean_type] = ACTIONS(592),
    [sym_void_type] = ACTIONS(592),
    [sym_this] = ACTIONS(592),
    [sym_super] = ACTIONS(592),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [170] = {
    [ts_builtin_sym_end] = ACTIONS(594),
    [sym_identifier] = ACTIONS(596),
    [sym_decimal_integer_literal] = ACTIONS(596),
    [sym_hex_integer_literal] = ACTIONS(596),
    [sym_octal_integer_literal] = ACTIONS(594),
    [sym_binary_integer_literal] = ACTIONS(594),
    [sym_decimal_floating_point_literal] = ACTIONS(594),
    [sym_hex_floating_point_literal] = ACTIONS(596),
    [sym_true] = ACTIONS(596),
    [sym_false] = ACTIONS(596),
    [sym_character_literal] = ACTIONS(594),
    [sym_string_literal] = ACTIONS(596),
    [sym_text_block] = ACTIONS(594),
    [sym_null_literal] = ACTIONS(596),
    [anon_sym_LPAREN] = ACTIONS(594),
    [anon_sym_PLUS] = ACTIONS(596),
    [anon_sym_DASH] = ACTIONS(596),
    [anon_sym_BANG] = ACTIONS(594),
    [anon_sym_TILDE] = ACTIONS(594),
    [anon_sym_PLUS_PLUS] = ACTIONS(594),
    [anon_sym_DASH_DASH] = ACTIONS(594),
    [anon_sym_new] = ACTIONS(596),
    [anon_sym_class] = ACTIONS(596),
    [anon_sym_switch] = ACTIONS(596),
    [anon_sym_LBRACE] = ACTIONS(594),
    [anon_sym_RBRACE] = ACTIONS(594),
    [anon_sym_case] = ACTIONS(596),
    [anon_sym_default] = ACTIONS(596),
    [anon_sym_SEMI] = ACTIONS(594),
    [anon_sym_assert] = ACTIONS(596),
    [anon_sym_do] = ACTIONS(596),
    [anon_sym_while] = ACTIONS(596),
    [anon_sym_break] = ACTIONS(596),
    [anon_sym_continue] = ACTIONS(596),
    [anon_sym_return] = ACTIONS(596),
    [anon_sym_yield] = ACTIONS(596),
    [anon_sym_synchronized] = ACTIONS(596),
    [anon_sym_throw] = ACTIONS(596),
    [anon_sym_try] = ACTIONS(596),
    [anon_sym_if] = ACTIONS(596),
    [anon_sym_else] = ACTIONS(596),
    [anon_sym_for] = ACTIONS(596),
    [anon_sym_AT] = ACTIONS(596),
    [anon_sym_open] = ACTIONS(596),
    [anon_sym_module] = ACTIONS(596),
    [anon_sym_static] = ACTIONS(596),
    [anon_sym_package] = ACTIONS(596),
    [anon_sym_import] = ACTIONS(596),
    [anon_sym_enum] = ACTIONS(596),
    [anon_sym_public] = ACTIONS(596),
    [anon_sym_protected] = ACTIONS(596),
    [anon_sym_private] = ACTIONS(596),
    [anon_sym_abstract] = ACTIONS(596),
    [anon_sym_final] = ACTIONS(596),
    [anon_sym_strictfp] = ACTIONS(596),
    [anon_sym_native] = ACTIONS(596),
    [anon_sym_transient] = ACTIONS(596),
    [anon_sym_volatile] = ACTIONS(596),
    [anon_sym_ATinterface] = ACTIONS(594),
    [anon_sym_interface] = ACTIONS(596),
    [anon_sym_byte] = ACTIONS(596),
    [anon_sym_short] = ACTIONS(596),
    [anon_sym_int] = ACTIONS(596),
    [anon_sym_long] = ACTIONS(596),
    [anon_sym_char] = ACTIONS(596),
    [anon_sym_float] = ACTIONS(596),
    [anon_sym_double] = ACTIONS(596),
    [sym_boolean_type] = ACTIONS(596),
    [sym_void_type] = ACTIONS(596),
    [sym_this] = ACTIONS(596),
    [sym_super] = ACTIONS(596),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [171] = {
    [ts_builtin_sym_end] = ACTIONS(598),
    [sym_identifier] = ACTIONS(600),
    [sym_decimal_integer_literal] = ACTIONS(600),
    [sym_hex_integer_literal] = ACTIONS(600),
    [sym_octal_integer_literal] = ACTIONS(598),
    [sym_binary_integer_literal] = ACTIONS(598),
    [sym_decimal_floating_point_literal] = ACTIONS(598),
    [sym_hex_floating_point_literal] = ACTIONS(600),
    [sym_true] = ACTIONS(600),
    [sym_false] = ACTIONS(600),
    [sym_character_literal] = ACTIONS(598),
    [sym_string_literal] = ACTIONS(600),
    [sym_text_block] = ACTIONS(598),
    [sym_null_literal] = ACTIONS(600),
    [anon_sym_LPAREN] = ACTIONS(598),
    [anon_sym_PLUS] = ACTIONS(600),
    [anon_sym_DASH] = ACTIONS(600),
    [anon_sym_BANG] = ACTIONS(598),
    [anon_sym_TILDE] = ACTIONS(598),
    [anon_sym_PLUS_PLUS] = ACTIONS(598),
    [anon_sym_DASH_DASH] = ACTIONS(598),
    [anon_sym_new] = ACTIONS(600),
    [anon_sym_class] = ACTIONS(600),
    [anon_sym_switch] = ACTIONS(600),
    [anon_sym_LBRACE] = ACTIONS(598),
    [anon_sym_RBRACE] = ACTIONS(598),
    [anon_sym_case] = ACTIONS(600),
    [anon_sym_default] = ACTIONS(600),
    [anon_sym_SEMI] = ACTIONS(598),
    [anon_sym_assert] = ACTIONS(600),
    [anon_sym_do] = ACTIONS(600),
    [anon_sym_while] = ACTIONS(600),
    [anon_sym_break] = ACTIONS(600),
    [anon_sym_continue] = ACTIONS(600),
    [anon_sym_return] = ACTIONS(600),
    [anon_sym_yield] = ACTIONS(600),
    [anon_sym_synchronized] = ACTIONS(600),
    [anon_sym_throw] = ACTIONS(600),
    [anon_sym_try] = ACTIONS(600),
    [anon_sym_if] = ACTIONS(600),
    [anon_sym_else] = ACTIONS(600),
    [anon_sym_for] = ACTIONS(600),
    [anon_sym_AT] = ACTIONS(600),
    [anon_sym_open] = ACTIONS(600),
    [anon_sym_module] = ACTIONS(600),
    [anon_sym_static] = ACTIONS(600),
    [anon_sym_package] = ACTIONS(600),
    [anon_sym_import] = ACTIONS(600),
    [anon_sym_enum] = ACTIONS(600),
    [anon_sym_public] = ACTIONS(600),
    [anon_sym_protected] = ACTIONS(600),
    [anon_sym_private] = ACTIONS(600),
    [anon_sym_abstract] = ACTIONS(600),
    [anon_sym_final] = ACTIONS(600),
    [anon_sym_strictfp] = ACTIONS(600),
    [anon_sym_native] = ACTIONS(600),
    [anon_sym_transient] = ACTIONS(600),
    [anon_sym_volatile] = ACTIONS(600),
    [anon_sym_ATinterface] = ACTIONS(598),
    [anon_sym_interface] = ACTIONS(600),
    [anon_sym_byte] = ACTIONS(600),
    [anon_sym_short] = ACTIONS(600),
    [anon_sym_int] = ACTIONS(600),
    [anon_sym_long] = ACTIONS(600),
    [anon_sym_char] = ACTIONS(600),
    [anon_sym_float] = ACTIONS(600),
    [anon_sym_double] = ACTIONS(600),
    [sym_boolean_type] = ACTIONS(600),
    [sym_void_type] = ACTIONS(600),
    [sym_this] = ACTIONS(600),
    [sym_super] = ACTIONS(600),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [172] = {
    [ts_builtin_sym_end] = ACTIONS(602),
    [sym_identifier] = ACTIONS(604),
    [sym_decimal_integer_literal] = ACTIONS(604),
    [sym_hex_integer_literal] = ACTIONS(604),
    [sym_octal_integer_literal] = ACTIONS(602),
    [sym_binary_integer_literal] = ACTIONS(602),
    [sym_decimal_floating_point_literal] = ACTIONS(602),
    [sym_hex_floating_point_literal] = ACTIONS(604),
    [sym_true] = ACTIONS(604),
    [sym_false] = ACTIONS(604),
    [sym_character_literal] = ACTIONS(602),
    [sym_string_literal] = ACTIONS(604),
    [sym_text_block] = ACTIONS(602),
    [sym_null_literal] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(602),
    [anon_sym_PLUS] = ACTIONS(604),
    [anon_sym_DASH] = ACTIONS(604),
    [anon_sym_BANG] = ACTIONS(602),
    [anon_sym_TILDE] = ACTIONS(602),
    [anon_sym_PLUS_PLUS] = ACTIONS(602),
    [anon_sym_DASH_DASH] = ACTIONS(602),
    [anon_sym_new] = ACTIONS(604),
    [anon_sym_class] = ACTIONS(604),
    [anon_sym_switch] = ACTIONS(604),
    [anon_sym_LBRACE] = ACTIONS(602),
    [anon_sym_RBRACE] = ACTIONS(602),
    [anon_sym_case] = ACTIONS(604),
    [anon_sym_default] = ACTIONS(604),
    [anon_sym_SEMI] = ACTIONS(602),
    [anon_sym_assert] = ACTIONS(604),
    [anon_sym_do] = ACTIONS(604),
    [anon_sym_while] = ACTIONS(604),
    [anon_sym_break] = ACTIONS(604),
    [anon_sym_continue] = ACTIONS(604),
    [anon_sym_return] = ACTIONS(604),
    [anon_sym_yield] = ACTIONS(604),
    [anon_sym_synchronized] = ACTIONS(604),
    [anon_sym_throw] = ACTIONS(604),
    [anon_sym_try] = ACTIONS(604),
    [anon_sym_if] = ACTIONS(604),
    [anon_sym_else] = ACTIONS(604),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_AT] = ACTIONS(604),
    [anon_sym_open] = ACTIONS(604),
    [anon_sym_module] = ACTIONS(604),
    [anon_sym_static] = ACTIONS(604),
    [anon_sym_package] = ACTIONS(604),
    [anon_sym_import] = ACTIONS(604),
    [anon_sym_enum] = ACTIONS(604),
    [anon_sym_public] = ACTIONS(604),
    [anon_sym_protected] = ACTIONS(604),
    [anon_sym_private] = ACTIONS(604),
    [anon_sym_abstract] = ACTIONS(604),
    [anon_sym_final] = ACTIONS(604),
    [anon_sym_strictfp] = ACTIONS(604),
    [anon_sym_native] = ACTIONS(604),
    [anon_sym_transient] = ACTIONS(604),
    [anon_sym_volatile] = ACTIONS(604),
    [anon_sym_ATinterface] = ACTIONS(602),
    [anon_sym_interface] = ACTIONS(604),
    [anon_sym_byte] = ACTIONS(604),
    [anon_sym_short] = ACTIONS(604),
    [anon_sym_int] = ACTIONS(604),
    [anon_sym_long] = ACTIONS(604),
    [anon_sym_char] = ACTIONS(604),
    [anon_sym_float] = ACTIONS(604),
    [anon_sym_double] = ACTIONS(604),
    [sym_boolean_type] = ACTIONS(604),
    [sym_void_type] = ACTIONS(604),
    [sym_this] = ACTIONS(604),
    [sym_super] = ACTIONS(604),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [173] = {
    [ts_builtin_sym_end] = ACTIONS(606),
    [sym_identifier] = ACTIONS(608),
    [sym_decimal_integer_literal] = ACTIONS(608),
    [sym_hex_integer_literal] = ACTIONS(608),
    [sym_octal_integer_literal] = ACTIONS(606),
    [sym_binary_integer_literal] = ACTIONS(606),
    [sym_decimal_floating_point_literal] = ACTIONS(606),
    [sym_hex_floating_point_literal] = ACTIONS(608),
    [sym_true] = ACTIONS(608),
    [sym_false] = ACTIONS(608),
    [sym_character_literal] = ACTIONS(606),
    [sym_string_literal] = ACTIONS(608),
    [sym_text_block] = ACTIONS(606),
    [sym_null_literal] = ACTIONS(608),
    [anon_sym_LPAREN] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_BANG] = ACTIONS(606),
    [anon_sym_TILDE] = ACTIONS(606),
    [anon_sym_PLUS_PLUS] = ACTIONS(606),
    [anon_sym_DASH_DASH] = ACTIONS(606),
    [anon_sym_new] = ACTIONS(608),
    [anon_sym_class] = ACTIONS(608),
    [anon_sym_switch] = ACTIONS(608),
    [anon_sym_LBRACE] = ACTIONS(606),
    [anon_sym_RBRACE] = ACTIONS(606),
    [anon_sym_case] = ACTIONS(608),
    [anon_sym_default] = ACTIONS(608),
    [anon_sym_SEMI] = ACTIONS(606),
    [anon_sym_assert] = ACTIONS(608),
    [anon_sym_do] = ACTIONS(608),
    [anon_sym_while] = ACTIONS(608),
    [anon_sym_break] = ACTIONS(608),
    [anon_sym_continue] = ACTIONS(608),
    [anon_sym_return] = ACTIONS(608),
    [anon_sym_yield] = ACTIONS(608),
    [anon_sym_synchronized] = ACTIONS(608),
    [anon_sym_throw] = ACTIONS(608),
    [anon_sym_try] = ACTIONS(608),
    [anon_sym_if] = ACTIONS(608),
    [anon_sym_else] = ACTIONS(608),
    [anon_sym_for] = ACTIONS(608),
    [anon_sym_AT] = ACTIONS(608),
    [anon_sym_open] = ACTIONS(608),
    [anon_sym_module] = ACTIONS(608),
    [anon_sym_static] = ACTIONS(608),
    [anon_sym_package] = ACTIONS(608),
    [anon_sym_import] = ACTIONS(608),
    [anon_sym_enum] = ACTIONS(608),
    [anon_sym_public] = ACTIONS(608),
    [anon_sym_protected] = ACTIONS(608),
    [anon_sym_private] = ACTIONS(608),
    [anon_sym_abstract] = ACTIONS(608),
    [anon_sym_final] = ACTIONS(608),
    [anon_sym_strictfp] = ACTIONS(608),
    [anon_sym_native] = ACTIONS(608),
    [anon_sym_transient] = ACTIONS(608),
    [anon_sym_volatile] = ACTIONS(608),
    [anon_sym_ATinterface] = ACTIONS(606),
    [anon_sym_interface] = ACTIONS(608),
    [anon_sym_byte] = ACTIONS(608),
    [anon_sym_short] = ACTIONS(608),
    [anon_sym_int] = ACTIONS(608),
    [anon_sym_long] = ACTIONS(608),
    [anon_sym_char] = ACTIONS(608),
    [anon_sym_float] = ACTIONS(608),
    [anon_sym_double] = ACTIONS(608),
    [sym_boolean_type] = ACTIONS(608),
    [sym_void_type] = ACTIONS(608),
    [sym_this] = ACTIONS(608),
    [sym_super] = ACTIONS(608),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [174] = {
    [ts_builtin_sym_end] = ACTIONS(610),
    [sym_identifier] = ACTIONS(612),
    [sym_decimal_integer_literal] = ACTIONS(612),
    [sym_hex_integer_literal] = ACTIONS(612),
    [sym_octal_integer_literal] = ACTIONS(610),
    [sym_binary_integer_literal] = ACTIONS(610),
    [sym_decimal_floating_point_literal] = ACTIONS(610),
    [sym_hex_floating_point_literal] = ACTIONS(612),
    [sym_true] = ACTIONS(612),
    [sym_false] = ACTIONS(612),
    [sym_character_literal] = ACTIONS(610),
    [sym_string_literal] = ACTIONS(612),
    [sym_text_block] = ACTIONS(610),
    [sym_null_literal] = ACTIONS(612),
    [anon_sym_LPAREN] = ACTIONS(610),
    [anon_sym_PLUS] = ACTIONS(612),
    [anon_sym_DASH] = ACTIONS(612),
    [anon_sym_BANG] = ACTIONS(610),
    [anon_sym_TILDE] = ACTIONS(610),
    [anon_sym_PLUS_PLUS] = ACTIONS(610),
    [anon_sym_DASH_DASH] = ACTIONS(610),
    [anon_sym_new] = ACTIONS(612),
    [anon_sym_class] = ACTIONS(612),
    [anon_sym_switch] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(610),
    [anon_sym_RBRACE] = ACTIONS(610),
    [anon_sym_case] = ACTIONS(612),
    [anon_sym_default] = ACTIONS(612),
    [anon_sym_SEMI] = ACTIONS(610),
    [anon_sym_assert] = ACTIONS(612),
    [anon_sym_do] = ACTIONS(612),
    [anon_sym_while] = ACTIONS(612),
    [anon_sym_break] = ACTIONS(612),
    [anon_sym_continue] = ACTIONS(612),
    [anon_sym_return] = ACTIONS(612),
    [anon_sym_yield] = ACTIONS(612),
    [anon_sym_synchronized] = ACTIONS(612),
    [anon_sym_throw] = ACTIONS(612),
    [anon_sym_try] = ACTIONS(612),
    [anon_sym_if] = ACTIONS(612),
    [anon_sym_else] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(612),
    [anon_sym_AT] = ACTIONS(612),
    [anon_sym_open] = ACTIONS(612),
    [anon_sym_module] = ACTIONS(612),
    [anon_sym_static] = ACTIONS(612),
    [anon_sym_package] = ACTIONS(612),
    [anon_sym_import] = ACTIONS(612),
    [anon_sym_enum] = ACTIONS(612),
    [anon_sym_public] = ACTIONS(612),
    [anon_sym_protected] = ACTIONS(612),
    [anon_sym_private] = ACTIONS(612),
    [anon_sym_abstract] = ACTIONS(612),
    [anon_sym_final] = ACTIONS(612),
    [anon_sym_strictfp] = ACTIONS(612),
    [anon_sym_native] = ACTIONS(612),
    [anon_sym_transient] = ACTIONS(612),
    [anon_sym_volatile] = ACTIONS(612),
    [anon_sym_ATinterface] = ACTIONS(610),
    [anon_sym_interface] = ACTIONS(612),
    [anon_sym_byte] = ACTIONS(612),
    [anon_sym_short] = ACTIONS(612),
    [anon_sym_int] = ACTIONS(612),
    [anon_sym_long] = ACTIONS(612),
    [anon_sym_char] = ACTIONS(612),
    [anon_sym_float] = ACTIONS(612),
    [anon_sym_double] = ACTIONS(612),
    [sym_boolean_type] = ACTIONS(612),
    [sym_void_type] = ACTIONS(612),
    [sym_this] = ACTIONS(612),
    [sym_super] = ACTIONS(612),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [175] = {
    [ts_builtin_sym_end] = ACTIONS(614),
    [sym_identifier] = ACTIONS(616),
    [sym_decimal_integer_literal] = ACTIONS(616),
    [sym_hex_integer_literal] = ACTIONS(616),
    [sym_octal_integer_literal] = ACTIONS(614),
    [sym_binary_integer_literal] = ACTIONS(614),
    [sym_decimal_floating_point_literal] = ACTIONS(614),
    [sym_hex_floating_point_literal] = ACTIONS(616),
    [sym_true] = ACTIONS(616),
    [sym_false] = ACTIONS(616),
    [sym_character_literal] = ACTIONS(614),
    [sym_string_literal] = ACTIONS(616),
    [sym_text_block] = ACTIONS(614),
    [sym_null_literal] = ACTIONS(616),
    [anon_sym_LPAREN] = ACTIONS(614),
    [anon_sym_PLUS] = ACTIONS(616),
    [anon_sym_DASH] = ACTIONS(616),
    [anon_sym_BANG] = ACTIONS(614),
    [anon_sym_TILDE] = ACTIONS(614),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_new] = ACTIONS(616),
    [anon_sym_class] = ACTIONS(616),
    [anon_sym_switch] = ACTIONS(616),
    [anon_sym_LBRACE] = ACTIONS(614),
    [anon_sym_RBRACE] = ACTIONS(614),
    [anon_sym_case] = ACTIONS(616),
    [anon_sym_default] = ACTIONS(616),
    [anon_sym_SEMI] = ACTIONS(614),
    [anon_sym_assert] = ACTIONS(616),
    [anon_sym_do] = ACTIONS(616),
    [anon_sym_while] = ACTIONS(616),
    [anon_sym_break] = ACTIONS(616),
    [anon_sym_continue] = ACTIONS(616),
    [anon_sym_return] = ACTIONS(616),
    [anon_sym_yield] = ACTIONS(616),
    [anon_sym_synchronized] = ACTIONS(616),
    [anon_sym_throw] = ACTIONS(616),
    [anon_sym_try] = ACTIONS(616),
    [anon_sym_if] = ACTIONS(616),
    [anon_sym_else] = ACTIONS(616),
    [anon_sym_for] = ACTIONS(616),
    [anon_sym_AT] = ACTIONS(616),
    [anon_sym_open] = ACTIONS(616),
    [anon_sym_module] = ACTIONS(616),
    [anon_sym_static] = ACTIONS(616),
    [anon_sym_package] = ACTIONS(616),
    [anon_sym_import] = ACTIONS(616),
    [anon_sym_enum] = ACTIONS(616),
    [anon_sym_public] = ACTIONS(616),
    [anon_sym_protected] = ACTIONS(616),
    [anon_sym_private] = ACTIONS(616),
    [anon_sym_abstract] = ACTIONS(616),
    [anon_sym_final] = ACTIONS(616),
    [anon_sym_strictfp] = ACTIONS(616),
    [anon_sym_native] = ACTIONS(616),
    [anon_sym_transient] = ACTIONS(616),
    [anon_sym_volatile] = ACTIONS(616),
    [anon_sym_ATinterface] = ACTIONS(614),
    [anon_sym_interface] = ACTIONS(616),
    [anon_sym_byte] = ACTIONS(616),
    [anon_sym_short] = ACTIONS(616),
    [anon_sym_int] = ACTIONS(616),
    [anon_sym_long] = ACTIONS(616),
    [anon_sym_char] = ACTIONS(616),
    [anon_sym_float] = ACTIONS(616),
    [anon_sym_double] = ACTIONS(616),
    [sym_boolean_type] = ACTIONS(616),
    [sym_void_type] = ACTIONS(616),
    [sym_this] = ACTIONS(616),
    [sym_super] = ACTIONS(616),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [176] = {
    [ts_builtin_sym_end] = ACTIONS(618),
    [sym_identifier] = ACTIONS(620),
    [sym_decimal_integer_literal] = ACTIONS(620),
    [sym_hex_integer_literal] = ACTIONS(620),
    [sym_octal_integer_literal] = ACTIONS(618),
    [sym_binary_integer_literal] = ACTIONS(618),
    [sym_decimal_floating_point_literal] = ACTIONS(618),
    [sym_hex_floating_point_literal] = ACTIONS(620),
    [sym_true] = ACTIONS(620),
    [sym_false] = ACTIONS(620),
    [sym_character_literal] = ACTIONS(618),
    [sym_string_literal] = ACTIONS(620),
    [sym_text_block] = ACTIONS(618),
    [sym_null_literal] = ACTIONS(620),
    [anon_sym_LPAREN] = ACTIONS(618),
    [anon_sym_PLUS] = ACTIONS(620),
    [anon_sym_DASH] = ACTIONS(620),
    [anon_sym_BANG] = ACTIONS(618),
    [anon_sym_TILDE] = ACTIONS(618),
    [anon_sym_PLUS_PLUS] = ACTIONS(618),
    [anon_sym_DASH_DASH] = ACTIONS(618),
    [anon_sym_new] = ACTIONS(620),
    [anon_sym_class] = ACTIONS(620),
    [anon_sym_switch] = ACTIONS(620),
    [anon_sym_LBRACE] = ACTIONS(618),
    [anon_sym_RBRACE] = ACTIONS(618),
    [anon_sym_case] = ACTIONS(620),
    [anon_sym_default] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(618),
    [anon_sym_assert] = ACTIONS(620),
    [anon_sym_do] = ACTIONS(620),
    [anon_sym_while] = ACTIONS(620),
    [anon_sym_break] = ACTIONS(620),
    [anon_sym_continue] = ACTIONS(620),
    [anon_sym_return] = ACTIONS(620),
    [anon_sym_yield] = ACTIONS(620),
    [anon_sym_synchronized] = ACTIONS(620),
    [anon_sym_throw] = ACTIONS(620),
    [anon_sym_try] = ACTIONS(620),
    [anon_sym_if] = ACTIONS(620),
    [anon_sym_else] = ACTIONS(620),
    [anon_sym_for] = ACTIONS(620),
    [anon_sym_AT] = ACTIONS(620),
    [anon_sym_open] = ACTIONS(620),
    [anon_sym_module] = ACTIONS(620),
    [anon_sym_static] = ACTIONS(620),
    [anon_sym_package] = ACTIONS(620),
    [anon_sym_import] = ACTIONS(620),
    [anon_sym_enum] = ACTIONS(620),
    [anon_sym_public] = ACTIONS(620),
    [anon_sym_protected] = ACTIONS(620),
    [anon_sym_private] = ACTIONS(620),
    [anon_sym_abstract] = ACTIONS(620),
    [anon_sym_final] = ACTIONS(620),
    [anon_sym_strictfp] = ACTIONS(620),
    [anon_sym_native] = ACTIONS(620),
    [anon_sym_transient] = ACTIONS(620),
    [anon_sym_volatile] = ACTIONS(620),
    [anon_sym_ATinterface] = ACTIONS(618),
    [anon_sym_interface] = ACTIONS(620),
    [anon_sym_byte] = ACTIONS(620),
    [anon_sym_short] = ACTIONS(620),
    [anon_sym_int] = ACTIONS(620),
    [anon_sym_long] = ACTIONS(620),
    [anon_sym_char] = ACTIONS(620),
    [anon_sym_float] = ACTIONS(620),
    [anon_sym_double] = ACTIONS(620),
    [sym_boolean_type] = ACTIONS(620),
    [sym_void_type] = ACTIONS(620),
    [sym_this] = ACTIONS(620),
    [sym_super] = ACTIONS(620),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [177] = {
    [ts_builtin_sym_end] = ACTIONS(622),
    [sym_identifier] = ACTIONS(624),
    [sym_decimal_integer_literal] = ACTIONS(624),
    [sym_hex_integer_literal] = ACTIONS(624),
    [sym_octal_integer_literal] = ACTIONS(622),
    [sym_binary_integer_literal] = ACTIONS(622),
    [sym_decimal_floating_point_literal] = ACTIONS(622),
    [sym_hex_floating_point_literal] = ACTIONS(624),
    [sym_true] = ACTIONS(624),
    [sym_false] = ACTIONS(624),
    [sym_character_literal] = ACTIONS(622),
    [sym_string_literal] = ACTIONS(624),
    [sym_text_block] = ACTIONS(622),
    [sym_null_literal] = ACTIONS(624),
    [anon_sym_LPAREN] = ACTIONS(622),
    [anon_sym_PLUS] = ACTIONS(624),
    [anon_sym_DASH] = ACTIONS(624),
    [anon_sym_BANG] = ACTIONS(622),
    [anon_sym_TILDE] = ACTIONS(622),
    [anon_sym_PLUS_PLUS] = ACTIONS(622),
    [anon_sym_DASH_DASH] = ACTIONS(622),
    [anon_sym_new] = ACTIONS(624),
    [anon_sym_class] = ACTIONS(624),
    [anon_sym_switch] = ACTIONS(624),
    [anon_sym_LBRACE] = ACTIONS(622),
    [anon_sym_RBRACE] = ACTIONS(622),
    [anon_sym_case] = ACTIONS(624),
    [anon_sym_default] = ACTIONS(624),
    [anon_sym_SEMI] = ACTIONS(622),
    [anon_sym_assert] = ACTIONS(624),
    [anon_sym_do] = ACTIONS(624),
    [anon_sym_while] = ACTIONS(624),
    [anon_sym_break] = ACTIONS(624),
    [anon_sym_continue] = ACTIONS(624),
    [anon_sym_return] = ACTIONS(624),
    [anon_sym_yield] = ACTIONS(624),
    [anon_sym_synchronized] = ACTIONS(624),
    [anon_sym_throw] = ACTIONS(624),
    [anon_sym_try] = ACTIONS(624),
    [anon_sym_if] = ACTIONS(624),
    [anon_sym_else] = ACTIONS(624),
    [anon_sym_for] = ACTIONS(624),
    [anon_sym_AT] = ACTIONS(624),
    [anon_sym_open] = ACTIONS(624),
    [anon_sym_module] = ACTIONS(624),
    [anon_sym_static] = ACTIONS(624),
    [anon_sym_package] = ACTIONS(624),
    [anon_sym_import] = ACTIONS(624),
    [anon_sym_enum] = ACTIONS(624),
    [anon_sym_public] = ACTIONS(624),
    [anon_sym_protected] = ACTIONS(624),
    [anon_sym_private] = ACTIONS(624),
    [anon_sym_abstract] = ACTIONS(624),
    [anon_sym_final] = ACTIONS(624),
    [anon_sym_strictfp] = ACTIONS(624),
    [anon_sym_native] = ACTIONS(624),
    [anon_sym_transient] = ACTIONS(624),
    [anon_sym_volatile] = ACTIONS(624),
    [anon_sym_ATinterface] = ACTIONS(622),
    [anon_sym_interface] = ACTIONS(624),
    [anon_sym_byte] = ACTIONS(624),
    [anon_sym_short] = ACTIONS(624),
    [anon_sym_int] = ACTIONS(624),
    [anon_sym_long] = ACTIONS(624),
    [anon_sym_char] = ACTIONS(624),
    [anon_sym_float] = ACTIONS(624),
    [anon_sym_double] = ACTIONS(624),
    [sym_boolean_type] = ACTIONS(624),
    [sym_void_type] = ACTIONS(624),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(624),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [178] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(413),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [179] = {
    [ts_builtin_sym_end] = ACTIONS(626),
    [sym_identifier] = ACTIONS(628),
    [sym_decimal_integer_literal] = ACTIONS(628),
    [sym_hex_integer_literal] = ACTIONS(628),
    [sym_octal_integer_literal] = ACTIONS(626),
    [sym_binary_integer_literal] = ACTIONS(626),
    [sym_decimal_floating_point_literal] = ACTIONS(626),
    [sym_hex_floating_point_literal] = ACTIONS(628),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_character_literal] = ACTIONS(626),
    [sym_string_literal] = ACTIONS(628),
    [sym_text_block] = ACTIONS(626),
    [sym_null_literal] = ACTIONS(628),
    [anon_sym_LPAREN] = ACTIONS(626),
    [anon_sym_PLUS] = ACTIONS(628),
    [anon_sym_DASH] = ACTIONS(628),
    [anon_sym_BANG] = ACTIONS(626),
    [anon_sym_TILDE] = ACTIONS(626),
    [anon_sym_PLUS_PLUS] = ACTIONS(626),
    [anon_sym_DASH_DASH] = ACTIONS(626),
    [anon_sym_new] = ACTIONS(628),
    [anon_sym_class] = ACTIONS(628),
    [anon_sym_switch] = ACTIONS(628),
    [anon_sym_LBRACE] = ACTIONS(626),
    [anon_sym_RBRACE] = ACTIONS(626),
    [anon_sym_case] = ACTIONS(628),
    [anon_sym_default] = ACTIONS(628),
    [anon_sym_SEMI] = ACTIONS(626),
    [anon_sym_assert] = ACTIONS(628),
    [anon_sym_do] = ACTIONS(628),
    [anon_sym_while] = ACTIONS(628),
    [anon_sym_break] = ACTIONS(628),
    [anon_sym_continue] = ACTIONS(628),
    [anon_sym_return] = ACTIONS(628),
    [anon_sym_yield] = ACTIONS(628),
    [anon_sym_synchronized] = ACTIONS(628),
    [anon_sym_throw] = ACTIONS(628),
    [anon_sym_try] = ACTIONS(628),
    [anon_sym_if] = ACTIONS(628),
    [anon_sym_else] = ACTIONS(628),
    [anon_sym_for] = ACTIONS(628),
    [anon_sym_AT] = ACTIONS(628),
    [anon_sym_open] = ACTIONS(628),
    [anon_sym_module] = ACTIONS(628),
    [anon_sym_static] = ACTIONS(628),
    [anon_sym_package] = ACTIONS(628),
    [anon_sym_import] = ACTIONS(628),
    [anon_sym_enum] = ACTIONS(628),
    [anon_sym_public] = ACTIONS(628),
    [anon_sym_protected] = ACTIONS(628),
    [anon_sym_private] = ACTIONS(628),
    [anon_sym_abstract] = ACTIONS(628),
    [anon_sym_final] = ACTIONS(628),
    [anon_sym_strictfp] = ACTIONS(628),
    [anon_sym_native] = ACTIONS(628),
    [anon_sym_transient] = ACTIONS(628),
    [anon_sym_volatile] = ACTIONS(628),
    [anon_sym_ATinterface] = ACTIONS(626),
    [anon_sym_interface] = ACTIONS(628),
    [anon_sym_byte] = ACTIONS(628),
    [anon_sym_short] = ACTIONS(628),
    [anon_sym_int] = ACTIONS(628),
    [anon_sym_long] = ACTIONS(628),
    [anon_sym_char] = ACTIONS(628),
    [anon_sym_float] = ACTIONS(628),
    [anon_sym_double] = ACTIONS(628),
    [sym_boolean_type] = ACTIONS(628),
    [sym_void_type] = ACTIONS(628),
    [sym_this] = ACTIONS(628),
    [sym_super] = ACTIONS(628),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [180] = {
    [ts_builtin_sym_end] = ACTIONS(630),
    [sym_identifier] = ACTIONS(632),
    [sym_decimal_integer_literal] = ACTIONS(632),
    [sym_hex_integer_literal] = ACTIONS(632),
    [sym_octal_integer_literal] = ACTIONS(630),
    [sym_binary_integer_literal] = ACTIONS(630),
    [sym_decimal_floating_point_literal] = ACTIONS(630),
    [sym_hex_floating_point_literal] = ACTIONS(632),
    [sym_true] = ACTIONS(632),
    [sym_false] = ACTIONS(632),
    [sym_character_literal] = ACTIONS(630),
    [sym_string_literal] = ACTIONS(632),
    [sym_text_block] = ACTIONS(630),
    [sym_null_literal] = ACTIONS(632),
    [anon_sym_LPAREN] = ACTIONS(630),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_DASH] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(630),
    [anon_sym_TILDE] = ACTIONS(630),
    [anon_sym_PLUS_PLUS] = ACTIONS(630),
    [anon_sym_DASH_DASH] = ACTIONS(630),
    [anon_sym_new] = ACTIONS(632),
    [anon_sym_class] = ACTIONS(632),
    [anon_sym_switch] = ACTIONS(632),
    [anon_sym_LBRACE] = ACTIONS(630),
    [anon_sym_RBRACE] = ACTIONS(630),
    [anon_sym_case] = ACTIONS(632),
    [anon_sym_default] = ACTIONS(632),
    [anon_sym_SEMI] = ACTIONS(630),
    [anon_sym_assert] = ACTIONS(632),
    [anon_sym_do] = ACTIONS(632),
    [anon_sym_while] = ACTIONS(632),
    [anon_sym_break] = ACTIONS(632),
    [anon_sym_continue] = ACTIONS(632),
    [anon_sym_return] = ACTIONS(632),
    [anon_sym_yield] = ACTIONS(632),
    [anon_sym_synchronized] = ACTIONS(632),
    [anon_sym_throw] = ACTIONS(632),
    [anon_sym_try] = ACTIONS(632),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_else] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(632),
    [anon_sym_AT] = ACTIONS(632),
    [anon_sym_open] = ACTIONS(632),
    [anon_sym_module] = ACTIONS(632),
    [anon_sym_static] = ACTIONS(632),
    [anon_sym_package] = ACTIONS(632),
    [anon_sym_import] = ACTIONS(632),
    [anon_sym_enum] = ACTIONS(632),
    [anon_sym_public] = ACTIONS(632),
    [anon_sym_protected] = ACTIONS(632),
    [anon_sym_private] = ACTIONS(632),
    [anon_sym_abstract] = ACTIONS(632),
    [anon_sym_final] = ACTIONS(632),
    [anon_sym_strictfp] = ACTIONS(632),
    [anon_sym_native] = ACTIONS(632),
    [anon_sym_transient] = ACTIONS(632),
    [anon_sym_volatile] = ACTIONS(632),
    [anon_sym_ATinterface] = ACTIONS(630),
    [anon_sym_interface] = ACTIONS(632),
    [anon_sym_byte] = ACTIONS(632),
    [anon_sym_short] = ACTIONS(632),
    [anon_sym_int] = ACTIONS(632),
    [anon_sym_long] = ACTIONS(632),
    [anon_sym_char] = ACTIONS(632),
    [anon_sym_float] = ACTIONS(632),
    [anon_sym_double] = ACTIONS(632),
    [sym_boolean_type] = ACTIONS(632),
    [sym_void_type] = ACTIONS(632),
    [sym_this] = ACTIONS(632),
    [sym_super] = ACTIONS(632),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [181] = {
    [ts_builtin_sym_end] = ACTIONS(634),
    [sym_identifier] = ACTIONS(636),
    [sym_decimal_integer_literal] = ACTIONS(636),
    [sym_hex_integer_literal] = ACTIONS(636),
    [sym_octal_integer_literal] = ACTIONS(634),
    [sym_binary_integer_literal] = ACTIONS(634),
    [sym_decimal_floating_point_literal] = ACTIONS(634),
    [sym_hex_floating_point_literal] = ACTIONS(636),
    [sym_true] = ACTIONS(636),
    [sym_false] = ACTIONS(636),
    [sym_character_literal] = ACTIONS(634),
    [sym_string_literal] = ACTIONS(636),
    [sym_text_block] = ACTIONS(634),
    [sym_null_literal] = ACTIONS(636),
    [anon_sym_LPAREN] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(636),
    [anon_sym_DASH] = ACTIONS(636),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(634),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [anon_sym_new] = ACTIONS(636),
    [anon_sym_class] = ACTIONS(636),
    [anon_sym_switch] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(634),
    [anon_sym_RBRACE] = ACTIONS(634),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_default] = ACTIONS(636),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_assert] = ACTIONS(636),
    [anon_sym_do] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_break] = ACTIONS(636),
    [anon_sym_continue] = ACTIONS(636),
    [anon_sym_return] = ACTIONS(636),
    [anon_sym_yield] = ACTIONS(636),
    [anon_sym_synchronized] = ACTIONS(636),
    [anon_sym_throw] = ACTIONS(636),
    [anon_sym_try] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_else] = ACTIONS(636),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_AT] = ACTIONS(636),
    [anon_sym_open] = ACTIONS(636),
    [anon_sym_module] = ACTIONS(636),
    [anon_sym_static] = ACTIONS(636),
    [anon_sym_package] = ACTIONS(636),
    [anon_sym_import] = ACTIONS(636),
    [anon_sym_enum] = ACTIONS(636),
    [anon_sym_public] = ACTIONS(636),
    [anon_sym_protected] = ACTIONS(636),
    [anon_sym_private] = ACTIONS(636),
    [anon_sym_abstract] = ACTIONS(636),
    [anon_sym_final] = ACTIONS(636),
    [anon_sym_strictfp] = ACTIONS(636),
    [anon_sym_native] = ACTIONS(636),
    [anon_sym_transient] = ACTIONS(636),
    [anon_sym_volatile] = ACTIONS(636),
    [anon_sym_ATinterface] = ACTIONS(634),
    [anon_sym_interface] = ACTIONS(636),
    [anon_sym_byte] = ACTIONS(636),
    [anon_sym_short] = ACTIONS(636),
    [anon_sym_int] = ACTIONS(636),
    [anon_sym_long] = ACTIONS(636),
    [anon_sym_char] = ACTIONS(636),
    [anon_sym_float] = ACTIONS(636),
    [anon_sym_double] = ACTIONS(636),
    [sym_boolean_type] = ACTIONS(636),
    [sym_void_type] = ACTIONS(636),
    [sym_this] = ACTIONS(636),
    [sym_super] = ACTIONS(636),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [182] = {
    [ts_builtin_sym_end] = ACTIONS(638),
    [sym_identifier] = ACTIONS(640),
    [sym_decimal_integer_literal] = ACTIONS(640),
    [sym_hex_integer_literal] = ACTIONS(640),
    [sym_octal_integer_literal] = ACTIONS(638),
    [sym_binary_integer_literal] = ACTIONS(638),
    [sym_decimal_floating_point_literal] = ACTIONS(638),
    [sym_hex_floating_point_literal] = ACTIONS(640),
    [sym_true] = ACTIONS(640),
    [sym_false] = ACTIONS(640),
    [sym_character_literal] = ACTIONS(638),
    [sym_string_literal] = ACTIONS(640),
    [sym_text_block] = ACTIONS(638),
    [sym_null_literal] = ACTIONS(640),
    [anon_sym_LPAREN] = ACTIONS(638),
    [anon_sym_PLUS] = ACTIONS(640),
    [anon_sym_DASH] = ACTIONS(640),
    [anon_sym_BANG] = ACTIONS(638),
    [anon_sym_TILDE] = ACTIONS(638),
    [anon_sym_PLUS_PLUS] = ACTIONS(638),
    [anon_sym_DASH_DASH] = ACTIONS(638),
    [anon_sym_new] = ACTIONS(640),
    [anon_sym_class] = ACTIONS(640),
    [anon_sym_switch] = ACTIONS(640),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_RBRACE] = ACTIONS(638),
    [anon_sym_case] = ACTIONS(640),
    [anon_sym_default] = ACTIONS(640),
    [anon_sym_SEMI] = ACTIONS(638),
    [anon_sym_assert] = ACTIONS(640),
    [anon_sym_do] = ACTIONS(640),
    [anon_sym_while] = ACTIONS(640),
    [anon_sym_break] = ACTIONS(640),
    [anon_sym_continue] = ACTIONS(640),
    [anon_sym_return] = ACTIONS(640),
    [anon_sym_yield] = ACTIONS(640),
    [anon_sym_synchronized] = ACTIONS(640),
    [anon_sym_throw] = ACTIONS(640),
    [anon_sym_try] = ACTIONS(640),
    [anon_sym_if] = ACTIONS(640),
    [anon_sym_else] = ACTIONS(640),
    [anon_sym_for] = ACTIONS(640),
    [anon_sym_AT] = ACTIONS(640),
    [anon_sym_open] = ACTIONS(640),
    [anon_sym_module] = ACTIONS(640),
    [anon_sym_static] = ACTIONS(640),
    [anon_sym_package] = ACTIONS(640),
    [anon_sym_import] = ACTIONS(640),
    [anon_sym_enum] = ACTIONS(640),
    [anon_sym_public] = ACTIONS(640),
    [anon_sym_protected] = ACTIONS(640),
    [anon_sym_private] = ACTIONS(640),
    [anon_sym_abstract] = ACTIONS(640),
    [anon_sym_final] = ACTIONS(640),
    [anon_sym_strictfp] = ACTIONS(640),
    [anon_sym_native] = ACTIONS(640),
    [anon_sym_transient] = ACTIONS(640),
    [anon_sym_volatile] = ACTIONS(640),
    [anon_sym_ATinterface] = ACTIONS(638),
    [anon_sym_interface] = ACTIONS(640),
    [anon_sym_byte] = ACTIONS(640),
    [anon_sym_short] = ACTIONS(640),
    [anon_sym_int] = ACTIONS(640),
    [anon_sym_long] = ACTIONS(640),
    [anon_sym_char] = ACTIONS(640),
    [anon_sym_float] = ACTIONS(640),
    [anon_sym_double] = ACTIONS(640),
    [sym_boolean_type] = ACTIONS(640),
    [sym_void_type] = ACTIONS(640),
    [sym_this] = ACTIONS(640),
    [sym_super] = ACTIONS(640),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [183] = {
    [ts_builtin_sym_end] = ACTIONS(642),
    [sym_identifier] = ACTIONS(644),
    [sym_decimal_integer_literal] = ACTIONS(644),
    [sym_hex_integer_literal] = ACTIONS(644),
    [sym_octal_integer_literal] = ACTIONS(642),
    [sym_binary_integer_literal] = ACTIONS(642),
    [sym_decimal_floating_point_literal] = ACTIONS(642),
    [sym_hex_floating_point_literal] = ACTIONS(644),
    [sym_true] = ACTIONS(644),
    [sym_false] = ACTIONS(644),
    [sym_character_literal] = ACTIONS(642),
    [sym_string_literal] = ACTIONS(644),
    [sym_text_block] = ACTIONS(642),
    [sym_null_literal] = ACTIONS(644),
    [anon_sym_LPAREN] = ACTIONS(642),
    [anon_sym_PLUS] = ACTIONS(644),
    [anon_sym_DASH] = ACTIONS(644),
    [anon_sym_BANG] = ACTIONS(642),
    [anon_sym_TILDE] = ACTIONS(642),
    [anon_sym_PLUS_PLUS] = ACTIONS(642),
    [anon_sym_DASH_DASH] = ACTIONS(642),
    [anon_sym_new] = ACTIONS(644),
    [anon_sym_class] = ACTIONS(644),
    [anon_sym_switch] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(642),
    [anon_sym_RBRACE] = ACTIONS(642),
    [anon_sym_case] = ACTIONS(644),
    [anon_sym_default] = ACTIONS(644),
    [anon_sym_SEMI] = ACTIONS(642),
    [anon_sym_assert] = ACTIONS(644),
    [anon_sym_do] = ACTIONS(644),
    [anon_sym_while] = ACTIONS(644),
    [anon_sym_break] = ACTIONS(644),
    [anon_sym_continue] = ACTIONS(644),
    [anon_sym_return] = ACTIONS(644),
    [anon_sym_yield] = ACTIONS(644),
    [anon_sym_synchronized] = ACTIONS(644),
    [anon_sym_throw] = ACTIONS(644),
    [anon_sym_try] = ACTIONS(644),
    [anon_sym_if] = ACTIONS(644),
    [anon_sym_else] = ACTIONS(644),
    [anon_sym_for] = ACTIONS(644),
    [anon_sym_AT] = ACTIONS(644),
    [anon_sym_open] = ACTIONS(644),
    [anon_sym_module] = ACTIONS(644),
    [anon_sym_static] = ACTIONS(644),
    [anon_sym_package] = ACTIONS(644),
    [anon_sym_import] = ACTIONS(644),
    [anon_sym_enum] = ACTIONS(644),
    [anon_sym_public] = ACTIONS(644),
    [anon_sym_protected] = ACTIONS(644),
    [anon_sym_private] = ACTIONS(644),
    [anon_sym_abstract] = ACTIONS(644),
    [anon_sym_final] = ACTIONS(644),
    [anon_sym_strictfp] = ACTIONS(644),
    [anon_sym_native] = ACTIONS(644),
    [anon_sym_transient] = ACTIONS(644),
    [anon_sym_volatile] = ACTIONS(644),
    [anon_sym_ATinterface] = ACTIONS(642),
    [anon_sym_interface] = ACTIONS(644),
    [anon_sym_byte] = ACTIONS(644),
    [anon_sym_short] = ACTIONS(644),
    [anon_sym_int] = ACTIONS(644),
    [anon_sym_long] = ACTIONS(644),
    [anon_sym_char] = ACTIONS(644),
    [anon_sym_float] = ACTIONS(644),
    [anon_sym_double] = ACTIONS(644),
    [sym_boolean_type] = ACTIONS(644),
    [sym_void_type] = ACTIONS(644),
    [sym_this] = ACTIONS(644),
    [sym_super] = ACTIONS(644),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [184] = {
    [ts_builtin_sym_end] = ACTIONS(646),
    [sym_identifier] = ACTIONS(648),
    [sym_decimal_integer_literal] = ACTIONS(648),
    [sym_hex_integer_literal] = ACTIONS(648),
    [sym_octal_integer_literal] = ACTIONS(646),
    [sym_binary_integer_literal] = ACTIONS(646),
    [sym_decimal_floating_point_literal] = ACTIONS(646),
    [sym_hex_floating_point_literal] = ACTIONS(648),
    [sym_true] = ACTIONS(648),
    [sym_false] = ACTIONS(648),
    [sym_character_literal] = ACTIONS(646),
    [sym_string_literal] = ACTIONS(648),
    [sym_text_block] = ACTIONS(646),
    [sym_null_literal] = ACTIONS(648),
    [anon_sym_LPAREN] = ACTIONS(646),
    [anon_sym_PLUS] = ACTIONS(648),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_BANG] = ACTIONS(646),
    [anon_sym_TILDE] = ACTIONS(646),
    [anon_sym_PLUS_PLUS] = ACTIONS(646),
    [anon_sym_DASH_DASH] = ACTIONS(646),
    [anon_sym_new] = ACTIONS(648),
    [anon_sym_class] = ACTIONS(648),
    [anon_sym_switch] = ACTIONS(648),
    [anon_sym_LBRACE] = ACTIONS(646),
    [anon_sym_RBRACE] = ACTIONS(646),
    [anon_sym_case] = ACTIONS(648),
    [anon_sym_default] = ACTIONS(648),
    [anon_sym_SEMI] = ACTIONS(646),
    [anon_sym_assert] = ACTIONS(648),
    [anon_sym_do] = ACTIONS(648),
    [anon_sym_while] = ACTIONS(648),
    [anon_sym_break] = ACTIONS(648),
    [anon_sym_continue] = ACTIONS(648),
    [anon_sym_return] = ACTIONS(648),
    [anon_sym_yield] = ACTIONS(648),
    [anon_sym_synchronized] = ACTIONS(648),
    [anon_sym_throw] = ACTIONS(648),
    [anon_sym_try] = ACTIONS(648),
    [anon_sym_if] = ACTIONS(648),
    [anon_sym_else] = ACTIONS(648),
    [anon_sym_for] = ACTIONS(648),
    [anon_sym_AT] = ACTIONS(648),
    [anon_sym_open] = ACTIONS(648),
    [anon_sym_module] = ACTIONS(648),
    [anon_sym_static] = ACTIONS(648),
    [anon_sym_package] = ACTIONS(648),
    [anon_sym_import] = ACTIONS(648),
    [anon_sym_enum] = ACTIONS(648),
    [anon_sym_public] = ACTIONS(648),
    [anon_sym_protected] = ACTIONS(648),
    [anon_sym_private] = ACTIONS(648),
    [anon_sym_abstract] = ACTIONS(648),
    [anon_sym_final] = ACTIONS(648),
    [anon_sym_strictfp] = ACTIONS(648),
    [anon_sym_native] = ACTIONS(648),
    [anon_sym_transient] = ACTIONS(648),
    [anon_sym_volatile] = ACTIONS(648),
    [anon_sym_ATinterface] = ACTIONS(646),
    [anon_sym_interface] = ACTIONS(648),
    [anon_sym_byte] = ACTIONS(648),
    [anon_sym_short] = ACTIONS(648),
    [anon_sym_int] = ACTIONS(648),
    [anon_sym_long] = ACTIONS(648),
    [anon_sym_char] = ACTIONS(648),
    [anon_sym_float] = ACTIONS(648),
    [anon_sym_double] = ACTIONS(648),
    [sym_boolean_type] = ACTIONS(648),
    [sym_void_type] = ACTIONS(648),
    [sym_this] = ACTIONS(648),
    [sym_super] = ACTIONS(648),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [185] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(484),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [186] = {
    [ts_builtin_sym_end] = ACTIONS(650),
    [sym_identifier] = ACTIONS(652),
    [sym_decimal_integer_literal] = ACTIONS(652),
    [sym_hex_integer_literal] = ACTIONS(652),
    [sym_octal_integer_literal] = ACTIONS(650),
    [sym_binary_integer_literal] = ACTIONS(650),
    [sym_decimal_floating_point_literal] = ACTIONS(650),
    [sym_hex_floating_point_literal] = ACTIONS(652),
    [sym_true] = ACTIONS(652),
    [sym_false] = ACTIONS(652),
    [sym_character_literal] = ACTIONS(650),
    [sym_string_literal] = ACTIONS(652),
    [sym_text_block] = ACTIONS(650),
    [sym_null_literal] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_BANG] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_PLUS_PLUS] = ACTIONS(650),
    [anon_sym_DASH_DASH] = ACTIONS(650),
    [anon_sym_new] = ACTIONS(652),
    [anon_sym_class] = ACTIONS(652),
    [anon_sym_switch] = ACTIONS(652),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_case] = ACTIONS(652),
    [anon_sym_default] = ACTIONS(652),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_assert] = ACTIONS(652),
    [anon_sym_do] = ACTIONS(652),
    [anon_sym_while] = ACTIONS(652),
    [anon_sym_break] = ACTIONS(652),
    [anon_sym_continue] = ACTIONS(652),
    [anon_sym_return] = ACTIONS(652),
    [anon_sym_yield] = ACTIONS(652),
    [anon_sym_synchronized] = ACTIONS(652),
    [anon_sym_throw] = ACTIONS(652),
    [anon_sym_try] = ACTIONS(652),
    [anon_sym_if] = ACTIONS(652),
    [anon_sym_else] = ACTIONS(652),
    [anon_sym_for] = ACTIONS(652),
    [anon_sym_AT] = ACTIONS(652),
    [anon_sym_open] = ACTIONS(652),
    [anon_sym_module] = ACTIONS(652),
    [anon_sym_static] = ACTIONS(652),
    [anon_sym_package] = ACTIONS(652),
    [anon_sym_import] = ACTIONS(652),
    [anon_sym_enum] = ACTIONS(652),
    [anon_sym_public] = ACTIONS(652),
    [anon_sym_protected] = ACTIONS(652),
    [anon_sym_private] = ACTIONS(652),
    [anon_sym_abstract] = ACTIONS(652),
    [anon_sym_final] = ACTIONS(652),
    [anon_sym_strictfp] = ACTIONS(652),
    [anon_sym_native] = ACTIONS(652),
    [anon_sym_transient] = ACTIONS(652),
    [anon_sym_volatile] = ACTIONS(652),
    [anon_sym_ATinterface] = ACTIONS(650),
    [anon_sym_interface] = ACTIONS(652),
    [anon_sym_byte] = ACTIONS(652),
    [anon_sym_short] = ACTIONS(652),
    [anon_sym_int] = ACTIONS(652),
    [anon_sym_long] = ACTIONS(652),
    [anon_sym_char] = ACTIONS(652),
    [anon_sym_float] = ACTIONS(652),
    [anon_sym_double] = ACTIONS(652),
    [sym_boolean_type] = ACTIONS(652),
    [sym_void_type] = ACTIONS(652),
    [sym_this] = ACTIONS(652),
    [sym_super] = ACTIONS(652),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [187] = {
    [ts_builtin_sym_end] = ACTIONS(654),
    [sym_identifier] = ACTIONS(656),
    [sym_decimal_integer_literal] = ACTIONS(656),
    [sym_hex_integer_literal] = ACTIONS(656),
    [sym_octal_integer_literal] = ACTIONS(654),
    [sym_binary_integer_literal] = ACTIONS(654),
    [sym_decimal_floating_point_literal] = ACTIONS(654),
    [sym_hex_floating_point_literal] = ACTIONS(656),
    [sym_true] = ACTIONS(656),
    [sym_false] = ACTIONS(656),
    [sym_character_literal] = ACTIONS(654),
    [sym_string_literal] = ACTIONS(656),
    [sym_text_block] = ACTIONS(654),
    [sym_null_literal] = ACTIONS(656),
    [anon_sym_LPAREN] = ACTIONS(654),
    [anon_sym_PLUS] = ACTIONS(656),
    [anon_sym_DASH] = ACTIONS(656),
    [anon_sym_BANG] = ACTIONS(654),
    [anon_sym_TILDE] = ACTIONS(654),
    [anon_sym_PLUS_PLUS] = ACTIONS(654),
    [anon_sym_DASH_DASH] = ACTIONS(654),
    [anon_sym_new] = ACTIONS(656),
    [anon_sym_class] = ACTIONS(656),
    [anon_sym_switch] = ACTIONS(656),
    [anon_sym_LBRACE] = ACTIONS(654),
    [anon_sym_RBRACE] = ACTIONS(654),
    [anon_sym_case] = ACTIONS(656),
    [anon_sym_default] = ACTIONS(656),
    [anon_sym_SEMI] = ACTIONS(654),
    [anon_sym_assert] = ACTIONS(656),
    [anon_sym_do] = ACTIONS(656),
    [anon_sym_while] = ACTIONS(656),
    [anon_sym_break] = ACTIONS(656),
    [anon_sym_continue] = ACTIONS(656),
    [anon_sym_return] = ACTIONS(656),
    [anon_sym_yield] = ACTIONS(656),
    [anon_sym_synchronized] = ACTIONS(656),
    [anon_sym_throw] = ACTIONS(656),
    [anon_sym_try] = ACTIONS(656),
    [anon_sym_if] = ACTIONS(656),
    [anon_sym_else] = ACTIONS(656),
    [anon_sym_for] = ACTIONS(656),
    [anon_sym_AT] = ACTIONS(656),
    [anon_sym_open] = ACTIONS(656),
    [anon_sym_module] = ACTIONS(656),
    [anon_sym_static] = ACTIONS(656),
    [anon_sym_package] = ACTIONS(656),
    [anon_sym_import] = ACTIONS(656),
    [anon_sym_enum] = ACTIONS(656),
    [anon_sym_public] = ACTIONS(656),
    [anon_sym_protected] = ACTIONS(656),
    [anon_sym_private] = ACTIONS(656),
    [anon_sym_abstract] = ACTIONS(656),
    [anon_sym_final] = ACTIONS(656),
    [anon_sym_strictfp] = ACTIONS(656),
    [anon_sym_native] = ACTIONS(656),
    [anon_sym_transient] = ACTIONS(656),
    [anon_sym_volatile] = ACTIONS(656),
    [anon_sym_ATinterface] = ACTIONS(654),
    [anon_sym_interface] = ACTIONS(656),
    [anon_sym_byte] = ACTIONS(656),
    [anon_sym_short] = ACTIONS(656),
    [anon_sym_int] = ACTIONS(656),
    [anon_sym_long] = ACTIONS(656),
    [anon_sym_char] = ACTIONS(656),
    [anon_sym_float] = ACTIONS(656),
    [anon_sym_double] = ACTIONS(656),
    [sym_boolean_type] = ACTIONS(656),
    [sym_void_type] = ACTIONS(656),
    [sym_this] = ACTIONS(656),
    [sym_super] = ACTIONS(656),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [188] = {
    [ts_builtin_sym_end] = ACTIONS(658),
    [sym_identifier] = ACTIONS(660),
    [sym_decimal_integer_literal] = ACTIONS(660),
    [sym_hex_integer_literal] = ACTIONS(660),
    [sym_octal_integer_literal] = ACTIONS(658),
    [sym_binary_integer_literal] = ACTIONS(658),
    [sym_decimal_floating_point_literal] = ACTIONS(658),
    [sym_hex_floating_point_literal] = ACTIONS(660),
    [sym_true] = ACTIONS(660),
    [sym_false] = ACTIONS(660),
    [sym_character_literal] = ACTIONS(658),
    [sym_string_literal] = ACTIONS(660),
    [sym_text_block] = ACTIONS(658),
    [sym_null_literal] = ACTIONS(660),
    [anon_sym_LPAREN] = ACTIONS(658),
    [anon_sym_PLUS] = ACTIONS(660),
    [anon_sym_DASH] = ACTIONS(660),
    [anon_sym_BANG] = ACTIONS(658),
    [anon_sym_TILDE] = ACTIONS(658),
    [anon_sym_PLUS_PLUS] = ACTIONS(658),
    [anon_sym_DASH_DASH] = ACTIONS(658),
    [anon_sym_new] = ACTIONS(660),
    [anon_sym_class] = ACTIONS(660),
    [anon_sym_switch] = ACTIONS(660),
    [anon_sym_LBRACE] = ACTIONS(658),
    [anon_sym_RBRACE] = ACTIONS(658),
    [anon_sym_case] = ACTIONS(660),
    [anon_sym_default] = ACTIONS(660),
    [anon_sym_SEMI] = ACTIONS(658),
    [anon_sym_assert] = ACTIONS(660),
    [anon_sym_do] = ACTIONS(660),
    [anon_sym_while] = ACTIONS(660),
    [anon_sym_break] = ACTIONS(660),
    [anon_sym_continue] = ACTIONS(660),
    [anon_sym_return] = ACTIONS(660),
    [anon_sym_yield] = ACTIONS(660),
    [anon_sym_synchronized] = ACTIONS(660),
    [anon_sym_throw] = ACTIONS(660),
    [anon_sym_try] = ACTIONS(660),
    [anon_sym_if] = ACTIONS(660),
    [anon_sym_else] = ACTIONS(660),
    [anon_sym_for] = ACTIONS(660),
    [anon_sym_AT] = ACTIONS(660),
    [anon_sym_open] = ACTIONS(660),
    [anon_sym_module] = ACTIONS(660),
    [anon_sym_static] = ACTIONS(660),
    [anon_sym_package] = ACTIONS(660),
    [anon_sym_import] = ACTIONS(660),
    [anon_sym_enum] = ACTIONS(660),
    [anon_sym_public] = ACTIONS(660),
    [anon_sym_protected] = ACTIONS(660),
    [anon_sym_private] = ACTIONS(660),
    [anon_sym_abstract] = ACTIONS(660),
    [anon_sym_final] = ACTIONS(660),
    [anon_sym_strictfp] = ACTIONS(660),
    [anon_sym_native] = ACTIONS(660),
    [anon_sym_transient] = ACTIONS(660),
    [anon_sym_volatile] = ACTIONS(660),
    [anon_sym_ATinterface] = ACTIONS(658),
    [anon_sym_interface] = ACTIONS(660),
    [anon_sym_byte] = ACTIONS(660),
    [anon_sym_short] = ACTIONS(660),
    [anon_sym_int] = ACTIONS(660),
    [anon_sym_long] = ACTIONS(660),
    [anon_sym_char] = ACTIONS(660),
    [anon_sym_float] = ACTIONS(660),
    [anon_sym_double] = ACTIONS(660),
    [sym_boolean_type] = ACTIONS(660),
    [sym_void_type] = ACTIONS(660),
    [sym_this] = ACTIONS(660),
    [sym_super] = ACTIONS(660),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [189] = {
    [ts_builtin_sym_end] = ACTIONS(662),
    [sym_identifier] = ACTIONS(664),
    [sym_decimal_integer_literal] = ACTIONS(664),
    [sym_hex_integer_literal] = ACTIONS(664),
    [sym_octal_integer_literal] = ACTIONS(662),
    [sym_binary_integer_literal] = ACTIONS(662),
    [sym_decimal_floating_point_literal] = ACTIONS(662),
    [sym_hex_floating_point_literal] = ACTIONS(664),
    [sym_true] = ACTIONS(664),
    [sym_false] = ACTIONS(664),
    [sym_character_literal] = ACTIONS(662),
    [sym_string_literal] = ACTIONS(664),
    [sym_text_block] = ACTIONS(662),
    [sym_null_literal] = ACTIONS(664),
    [anon_sym_LPAREN] = ACTIONS(662),
    [anon_sym_PLUS] = ACTIONS(664),
    [anon_sym_DASH] = ACTIONS(664),
    [anon_sym_BANG] = ACTIONS(662),
    [anon_sym_TILDE] = ACTIONS(662),
    [anon_sym_PLUS_PLUS] = ACTIONS(662),
    [anon_sym_DASH_DASH] = ACTIONS(662),
    [anon_sym_new] = ACTIONS(664),
    [anon_sym_class] = ACTIONS(664),
    [anon_sym_switch] = ACTIONS(664),
    [anon_sym_LBRACE] = ACTIONS(662),
    [anon_sym_RBRACE] = ACTIONS(662),
    [anon_sym_case] = ACTIONS(664),
    [anon_sym_default] = ACTIONS(664),
    [anon_sym_SEMI] = ACTIONS(662),
    [anon_sym_assert] = ACTIONS(664),
    [anon_sym_do] = ACTIONS(664),
    [anon_sym_while] = ACTIONS(664),
    [anon_sym_break] = ACTIONS(664),
    [anon_sym_continue] = ACTIONS(664),
    [anon_sym_return] = ACTIONS(664),
    [anon_sym_yield] = ACTIONS(664),
    [anon_sym_synchronized] = ACTIONS(664),
    [anon_sym_throw] = ACTIONS(664),
    [anon_sym_try] = ACTIONS(664),
    [anon_sym_if] = ACTIONS(664),
    [anon_sym_else] = ACTIONS(664),
    [anon_sym_for] = ACTIONS(664),
    [anon_sym_AT] = ACTIONS(664),
    [anon_sym_open] = ACTIONS(664),
    [anon_sym_module] = ACTIONS(664),
    [anon_sym_static] = ACTIONS(664),
    [anon_sym_package] = ACTIONS(664),
    [anon_sym_import] = ACTIONS(664),
    [anon_sym_enum] = ACTIONS(664),
    [anon_sym_public] = ACTIONS(664),
    [anon_sym_protected] = ACTIONS(664),
    [anon_sym_private] = ACTIONS(664),
    [anon_sym_abstract] = ACTIONS(664),
    [anon_sym_final] = ACTIONS(664),
    [anon_sym_strictfp] = ACTIONS(664),
    [anon_sym_native] = ACTIONS(664),
    [anon_sym_transient] = ACTIONS(664),
    [anon_sym_volatile] = ACTIONS(664),
    [anon_sym_ATinterface] = ACTIONS(662),
    [anon_sym_interface] = ACTIONS(664),
    [anon_sym_byte] = ACTIONS(664),
    [anon_sym_short] = ACTIONS(664),
    [anon_sym_int] = ACTIONS(664),
    [anon_sym_long] = ACTIONS(664),
    [anon_sym_char] = ACTIONS(664),
    [anon_sym_float] = ACTIONS(664),
    [anon_sym_double] = ACTIONS(664),
    [sym_boolean_type] = ACTIONS(664),
    [sym_void_type] = ACTIONS(664),
    [sym_this] = ACTIONS(664),
    [sym_super] = ACTIONS(664),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [190] = {
    [ts_builtin_sym_end] = ACTIONS(666),
    [sym_identifier] = ACTIONS(668),
    [sym_decimal_integer_literal] = ACTIONS(668),
    [sym_hex_integer_literal] = ACTIONS(668),
    [sym_octal_integer_literal] = ACTIONS(666),
    [sym_binary_integer_literal] = ACTIONS(666),
    [sym_decimal_floating_point_literal] = ACTIONS(666),
    [sym_hex_floating_point_literal] = ACTIONS(668),
    [sym_true] = ACTIONS(668),
    [sym_false] = ACTIONS(668),
    [sym_character_literal] = ACTIONS(666),
    [sym_string_literal] = ACTIONS(668),
    [sym_text_block] = ACTIONS(666),
    [sym_null_literal] = ACTIONS(668),
    [anon_sym_LPAREN] = ACTIONS(666),
    [anon_sym_PLUS] = ACTIONS(668),
    [anon_sym_DASH] = ACTIONS(668),
    [anon_sym_BANG] = ACTIONS(666),
    [anon_sym_TILDE] = ACTIONS(666),
    [anon_sym_PLUS_PLUS] = ACTIONS(666),
    [anon_sym_DASH_DASH] = ACTIONS(666),
    [anon_sym_new] = ACTIONS(668),
    [anon_sym_class] = ACTIONS(668),
    [anon_sym_switch] = ACTIONS(668),
    [anon_sym_LBRACE] = ACTIONS(666),
    [anon_sym_RBRACE] = ACTIONS(666),
    [anon_sym_case] = ACTIONS(668),
    [anon_sym_default] = ACTIONS(668),
    [anon_sym_SEMI] = ACTIONS(666),
    [anon_sym_assert] = ACTIONS(668),
    [anon_sym_do] = ACTIONS(668),
    [anon_sym_while] = ACTIONS(668),
    [anon_sym_break] = ACTIONS(668),
    [anon_sym_continue] = ACTIONS(668),
    [anon_sym_return] = ACTIONS(668),
    [anon_sym_yield] = ACTIONS(668),
    [anon_sym_synchronized] = ACTIONS(668),
    [anon_sym_throw] = ACTIONS(668),
    [anon_sym_try] = ACTIONS(668),
    [anon_sym_if] = ACTIONS(668),
    [anon_sym_else] = ACTIONS(668),
    [anon_sym_for] = ACTIONS(668),
    [anon_sym_AT] = ACTIONS(668),
    [anon_sym_open] = ACTIONS(668),
    [anon_sym_module] = ACTIONS(668),
    [anon_sym_static] = ACTIONS(668),
    [anon_sym_package] = ACTIONS(668),
    [anon_sym_import] = ACTIONS(668),
    [anon_sym_enum] = ACTIONS(668),
    [anon_sym_public] = ACTIONS(668),
    [anon_sym_protected] = ACTIONS(668),
    [anon_sym_private] = ACTIONS(668),
    [anon_sym_abstract] = ACTIONS(668),
    [anon_sym_final] = ACTIONS(668),
    [anon_sym_strictfp] = ACTIONS(668),
    [anon_sym_native] = ACTIONS(668),
    [anon_sym_transient] = ACTIONS(668),
    [anon_sym_volatile] = ACTIONS(668),
    [anon_sym_ATinterface] = ACTIONS(666),
    [anon_sym_interface] = ACTIONS(668),
    [anon_sym_byte] = ACTIONS(668),
    [anon_sym_short] = ACTIONS(668),
    [anon_sym_int] = ACTIONS(668),
    [anon_sym_long] = ACTIONS(668),
    [anon_sym_char] = ACTIONS(668),
    [anon_sym_float] = ACTIONS(668),
    [anon_sym_double] = ACTIONS(668),
    [sym_boolean_type] = ACTIONS(668),
    [sym_void_type] = ACTIONS(668),
    [sym_this] = ACTIONS(668),
    [sym_super] = ACTIONS(668),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [191] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(488),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [192] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(499),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [193] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(461),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1043),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1043),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(422),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(424),
    [anon_sym_PLUS] = ACTIONS(426),
    [anon_sym_DASH] = ACTIONS(426),
    [anon_sym_BANG] = ACTIONS(428),
    [anon_sym_TILDE] = ACTIONS(428),
    [anon_sym_PLUS_PLUS] = ACTIONS(430),
    [anon_sym_DASH_DASH] = ACTIONS(430),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(432),
    [anon_sym_module] = ACTIONS(432),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [194] = {
    [ts_builtin_sym_end] = ACTIONS(285),
    [sym_identifier] = ACTIONS(287),
    [sym_decimal_integer_literal] = ACTIONS(287),
    [sym_hex_integer_literal] = ACTIONS(287),
    [sym_octal_integer_literal] = ACTIONS(285),
    [sym_binary_integer_literal] = ACTIONS(285),
    [sym_decimal_floating_point_literal] = ACTIONS(285),
    [sym_hex_floating_point_literal] = ACTIONS(287),
    [sym_true] = ACTIONS(287),
    [sym_false] = ACTIONS(287),
    [sym_character_literal] = ACTIONS(285),
    [sym_string_literal] = ACTIONS(287),
    [sym_text_block] = ACTIONS(285),
    [sym_null_literal] = ACTIONS(287),
    [anon_sym_LPAREN] = ACTIONS(285),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_BANG] = ACTIONS(285),
    [anon_sym_TILDE] = ACTIONS(285),
    [anon_sym_PLUS_PLUS] = ACTIONS(285),
    [anon_sym_DASH_DASH] = ACTIONS(285),
    [anon_sym_new] = ACTIONS(287),
    [anon_sym_class] = ACTIONS(287),
    [anon_sym_switch] = ACTIONS(287),
    [anon_sym_LBRACE] = ACTIONS(285),
    [anon_sym_RBRACE] = ACTIONS(285),
    [anon_sym_case] = ACTIONS(287),
    [anon_sym_default] = ACTIONS(287),
    [anon_sym_SEMI] = ACTIONS(285),
    [anon_sym_assert] = ACTIONS(287),
    [anon_sym_do] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(287),
    [anon_sym_break] = ACTIONS(287),
    [anon_sym_continue] = ACTIONS(287),
    [anon_sym_return] = ACTIONS(287),
    [anon_sym_yield] = ACTIONS(287),
    [anon_sym_synchronized] = ACTIONS(287),
    [anon_sym_throw] = ACTIONS(287),
    [anon_sym_try] = ACTIONS(287),
    [anon_sym_if] = ACTIONS(287),
    [anon_sym_else] = ACTIONS(287),
    [anon_sym_for] = ACTIONS(287),
    [anon_sym_AT] = ACTIONS(287),
    [anon_sym_open] = ACTIONS(287),
    [anon_sym_module] = ACTIONS(287),
    [anon_sym_static] = ACTIONS(287),
    [anon_sym_package] = ACTIONS(287),
    [anon_sym_import] = ACTIONS(287),
    [anon_sym_enum] = ACTIONS(287),
    [anon_sym_public] = ACTIONS(287),
    [anon_sym_protected] = ACTIONS(287),
    [anon_sym_private] = ACTIONS(287),
    [anon_sym_abstract] = ACTIONS(287),
    [anon_sym_final] = ACTIONS(287),
    [anon_sym_strictfp] = ACTIONS(287),
    [anon_sym_native] = ACTIONS(287),
    [anon_sym_transient] = ACTIONS(287),
    [anon_sym_volatile] = ACTIONS(287),
    [anon_sym_ATinterface] = ACTIONS(285),
    [anon_sym_interface] = ACTIONS(287),
    [anon_sym_byte] = ACTIONS(287),
    [anon_sym_short] = ACTIONS(287),
    [anon_sym_int] = ACTIONS(287),
    [anon_sym_long] = ACTIONS(287),
    [anon_sym_char] = ACTIONS(287),
    [anon_sym_float] = ACTIONS(287),
    [anon_sym_double] = ACTIONS(287),
    [sym_boolean_type] = ACTIONS(287),
    [sym_void_type] = ACTIONS(287),
    [sym_this] = ACTIONS(287),
    [sym_super] = ACTIONS(287),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [195] = {
    [ts_builtin_sym_end] = ACTIONS(670),
    [sym_identifier] = ACTIONS(672),
    [sym_decimal_integer_literal] = ACTIONS(672),
    [sym_hex_integer_literal] = ACTIONS(672),
    [sym_octal_integer_literal] = ACTIONS(670),
    [sym_binary_integer_literal] = ACTIONS(670),
    [sym_decimal_floating_point_literal] = ACTIONS(670),
    [sym_hex_floating_point_literal] = ACTIONS(672),
    [sym_true] = ACTIONS(672),
    [sym_false] = ACTIONS(672),
    [sym_character_literal] = ACTIONS(670),
    [sym_string_literal] = ACTIONS(672),
    [sym_text_block] = ACTIONS(670),
    [sym_null_literal] = ACTIONS(672),
    [anon_sym_LPAREN] = ACTIONS(670),
    [anon_sym_PLUS] = ACTIONS(672),
    [anon_sym_DASH] = ACTIONS(672),
    [anon_sym_BANG] = ACTIONS(670),
    [anon_sym_TILDE] = ACTIONS(670),
    [anon_sym_PLUS_PLUS] = ACTIONS(670),
    [anon_sym_DASH_DASH] = ACTIONS(670),
    [anon_sym_new] = ACTIONS(672),
    [anon_sym_class] = ACTIONS(672),
    [anon_sym_switch] = ACTIONS(672),
    [anon_sym_LBRACE] = ACTIONS(670),
    [anon_sym_RBRACE] = ACTIONS(670),
    [anon_sym_case] = ACTIONS(672),
    [anon_sym_default] = ACTIONS(672),
    [anon_sym_SEMI] = ACTIONS(670),
    [anon_sym_assert] = ACTIONS(672),
    [anon_sym_do] = ACTIONS(672),
    [anon_sym_while] = ACTIONS(672),
    [anon_sym_break] = ACTIONS(672),
    [anon_sym_continue] = ACTIONS(672),
    [anon_sym_return] = ACTIONS(672),
    [anon_sym_yield] = ACTIONS(672),
    [anon_sym_synchronized] = ACTIONS(672),
    [anon_sym_throw] = ACTIONS(672),
    [anon_sym_try] = ACTIONS(672),
    [anon_sym_if] = ACTIONS(672),
    [anon_sym_else] = ACTIONS(672),
    [anon_sym_for] = ACTIONS(672),
    [anon_sym_AT] = ACTIONS(672),
    [anon_sym_open] = ACTIONS(672),
    [anon_sym_module] = ACTIONS(672),
    [anon_sym_static] = ACTIONS(672),
    [anon_sym_package] = ACTIONS(672),
    [anon_sym_import] = ACTIONS(672),
    [anon_sym_enum] = ACTIONS(672),
    [anon_sym_public] = ACTIONS(672),
    [anon_sym_protected] = ACTIONS(672),
    [anon_sym_private] = ACTIONS(672),
    [anon_sym_abstract] = ACTIONS(672),
    [anon_sym_final] = ACTIONS(672),
    [anon_sym_strictfp] = ACTIONS(672),
    [anon_sym_native] = ACTIONS(672),
    [anon_sym_transient] = ACTIONS(672),
    [anon_sym_volatile] = ACTIONS(672),
    [anon_sym_ATinterface] = ACTIONS(670),
    [anon_sym_interface] = ACTIONS(672),
    [anon_sym_byte] = ACTIONS(672),
    [anon_sym_short] = ACTIONS(672),
    [anon_sym_int] = ACTIONS(672),
    [anon_sym_long] = ACTIONS(672),
    [anon_sym_char] = ACTIONS(672),
    [anon_sym_float] = ACTIONS(672),
    [anon_sym_double] = ACTIONS(672),
    [sym_boolean_type] = ACTIONS(672),
    [sym_void_type] = ACTIONS(672),
    [sym_this] = ACTIONS(672),
    [sym_super] = ACTIONS(672),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [196] = {
    [ts_builtin_sym_end] = ACTIONS(674),
    [sym_identifier] = ACTIONS(676),
    [sym_decimal_integer_literal] = ACTIONS(676),
    [sym_hex_integer_literal] = ACTIONS(676),
    [sym_octal_integer_literal] = ACTIONS(674),
    [sym_binary_integer_literal] = ACTIONS(674),
    [sym_decimal_floating_point_literal] = ACTIONS(674),
    [sym_hex_floating_point_literal] = ACTIONS(676),
    [sym_true] = ACTIONS(676),
    [sym_false] = ACTIONS(676),
    [sym_character_literal] = ACTIONS(674),
    [sym_string_literal] = ACTIONS(676),
    [sym_text_block] = ACTIONS(674),
    [sym_null_literal] = ACTIONS(676),
    [anon_sym_LPAREN] = ACTIONS(674),
    [anon_sym_PLUS] = ACTIONS(676),
    [anon_sym_DASH] = ACTIONS(676),
    [anon_sym_BANG] = ACTIONS(674),
    [anon_sym_TILDE] = ACTIONS(674),
    [anon_sym_PLUS_PLUS] = ACTIONS(674),
    [anon_sym_DASH_DASH] = ACTIONS(674),
    [anon_sym_new] = ACTIONS(676),
    [anon_sym_class] = ACTIONS(676),
    [anon_sym_switch] = ACTIONS(676),
    [anon_sym_LBRACE] = ACTIONS(674),
    [anon_sym_RBRACE] = ACTIONS(674),
    [anon_sym_case] = ACTIONS(676),
    [anon_sym_default] = ACTIONS(676),
    [anon_sym_SEMI] = ACTIONS(674),
    [anon_sym_assert] = ACTIONS(676),
    [anon_sym_do] = ACTIONS(676),
    [anon_sym_while] = ACTIONS(676),
    [anon_sym_break] = ACTIONS(676),
    [anon_sym_continue] = ACTIONS(676),
    [anon_sym_return] = ACTIONS(676),
    [anon_sym_yield] = ACTIONS(676),
    [anon_sym_synchronized] = ACTIONS(676),
    [anon_sym_throw] = ACTIONS(676),
    [anon_sym_try] = ACTIONS(676),
    [anon_sym_if] = ACTIONS(676),
    [anon_sym_else] = ACTIONS(676),
    [anon_sym_for] = ACTIONS(676),
    [anon_sym_AT] = ACTIONS(676),
    [anon_sym_open] = ACTIONS(676),
    [anon_sym_module] = ACTIONS(676),
    [anon_sym_static] = ACTIONS(676),
    [anon_sym_package] = ACTIONS(676),
    [anon_sym_import] = ACTIONS(676),
    [anon_sym_enum] = ACTIONS(676),
    [anon_sym_public] = ACTIONS(676),
    [anon_sym_protected] = ACTIONS(676),
    [anon_sym_private] = ACTIONS(676),
    [anon_sym_abstract] = ACTIONS(676),
    [anon_sym_final] = ACTIONS(676),
    [anon_sym_strictfp] = ACTIONS(676),
    [anon_sym_native] = ACTIONS(676),
    [anon_sym_transient] = ACTIONS(676),
    [anon_sym_volatile] = ACTIONS(676),
    [anon_sym_ATinterface] = ACTIONS(674),
    [anon_sym_interface] = ACTIONS(676),
    [anon_sym_byte] = ACTIONS(676),
    [anon_sym_short] = ACTIONS(676),
    [anon_sym_int] = ACTIONS(676),
    [anon_sym_long] = ACTIONS(676),
    [anon_sym_char] = ACTIONS(676),
    [anon_sym_float] = ACTIONS(676),
    [anon_sym_double] = ACTIONS(676),
    [sym_boolean_type] = ACTIONS(676),
    [sym_void_type] = ACTIONS(676),
    [sym_this] = ACTIONS(676),
    [sym_super] = ACTIONS(676),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [197] = {
    [ts_builtin_sym_end] = ACTIONS(678),
    [sym_identifier] = ACTIONS(680),
    [sym_decimal_integer_literal] = ACTIONS(680),
    [sym_hex_integer_literal] = ACTIONS(680),
    [sym_octal_integer_literal] = ACTIONS(678),
    [sym_binary_integer_literal] = ACTIONS(678),
    [sym_decimal_floating_point_literal] = ACTIONS(678),
    [sym_hex_floating_point_literal] = ACTIONS(680),
    [sym_true] = ACTIONS(680),
    [sym_false] = ACTIONS(680),
    [sym_character_literal] = ACTIONS(678),
    [sym_string_literal] = ACTIONS(680),
    [sym_text_block] = ACTIONS(678),
    [sym_null_literal] = ACTIONS(680),
    [anon_sym_LPAREN] = ACTIONS(678),
    [anon_sym_PLUS] = ACTIONS(680),
    [anon_sym_DASH] = ACTIONS(680),
    [anon_sym_BANG] = ACTIONS(678),
    [anon_sym_TILDE] = ACTIONS(678),
    [anon_sym_PLUS_PLUS] = ACTIONS(678),
    [anon_sym_DASH_DASH] = ACTIONS(678),
    [anon_sym_new] = ACTIONS(680),
    [anon_sym_class] = ACTIONS(680),
    [anon_sym_switch] = ACTIONS(680),
    [anon_sym_LBRACE] = ACTIONS(678),
    [anon_sym_RBRACE] = ACTIONS(678),
    [anon_sym_case] = ACTIONS(680),
    [anon_sym_default] = ACTIONS(680),
    [anon_sym_SEMI] = ACTIONS(678),
    [anon_sym_assert] = ACTIONS(680),
    [anon_sym_do] = ACTIONS(680),
    [anon_sym_while] = ACTIONS(680),
    [anon_sym_break] = ACTIONS(680),
    [anon_sym_continue] = ACTIONS(680),
    [anon_sym_return] = ACTIONS(680),
    [anon_sym_yield] = ACTIONS(680),
    [anon_sym_synchronized] = ACTIONS(680),
    [anon_sym_throw] = ACTIONS(680),
    [anon_sym_try] = ACTIONS(680),
    [anon_sym_if] = ACTIONS(680),
    [anon_sym_else] = ACTIONS(680),
    [anon_sym_for] = ACTIONS(680),
    [anon_sym_AT] = ACTIONS(680),
    [anon_sym_open] = ACTIONS(680),
    [anon_sym_module] = ACTIONS(680),
    [anon_sym_static] = ACTIONS(680),
    [anon_sym_package] = ACTIONS(680),
    [anon_sym_import] = ACTIONS(680),
    [anon_sym_enum] = ACTIONS(680),
    [anon_sym_public] = ACTIONS(680),
    [anon_sym_protected] = ACTIONS(680),
    [anon_sym_private] = ACTIONS(680),
    [anon_sym_abstract] = ACTIONS(680),
    [anon_sym_final] = ACTIONS(680),
    [anon_sym_strictfp] = ACTIONS(680),
    [anon_sym_native] = ACTIONS(680),
    [anon_sym_transient] = ACTIONS(680),
    [anon_sym_volatile] = ACTIONS(680),
    [anon_sym_ATinterface] = ACTIONS(678),
    [anon_sym_interface] = ACTIONS(680),
    [anon_sym_byte] = ACTIONS(680),
    [anon_sym_short] = ACTIONS(680),
    [anon_sym_int] = ACTIONS(680),
    [anon_sym_long] = ACTIONS(680),
    [anon_sym_char] = ACTIONS(680),
    [anon_sym_float] = ACTIONS(680),
    [anon_sym_double] = ACTIONS(680),
    [sym_boolean_type] = ACTIONS(680),
    [sym_void_type] = ACTIONS(680),
    [sym_this] = ACTIONS(680),
    [sym_super] = ACTIONS(680),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [198] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(436),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [199] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(460),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1043),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1043),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(422),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(424),
    [anon_sym_PLUS] = ACTIONS(426),
    [anon_sym_DASH] = ACTIONS(426),
    [anon_sym_BANG] = ACTIONS(428),
    [anon_sym_TILDE] = ACTIONS(428),
    [anon_sym_PLUS_PLUS] = ACTIONS(430),
    [anon_sym_DASH_DASH] = ACTIONS(430),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(432),
    [anon_sym_module] = ACTIONS(432),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [200] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(451),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1043),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1043),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(422),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(424),
    [anon_sym_PLUS] = ACTIONS(426),
    [anon_sym_DASH] = ACTIONS(426),
    [anon_sym_BANG] = ACTIONS(428),
    [anon_sym_TILDE] = ACTIONS(428),
    [anon_sym_PLUS_PLUS] = ACTIONS(430),
    [anon_sym_DASH_DASH] = ACTIONS(430),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(432),
    [anon_sym_module] = ACTIONS(432),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [201] = {
    [ts_builtin_sym_end] = ACTIONS(682),
    [sym_identifier] = ACTIONS(684),
    [sym_decimal_integer_literal] = ACTIONS(684),
    [sym_hex_integer_literal] = ACTIONS(684),
    [sym_octal_integer_literal] = ACTIONS(682),
    [sym_binary_integer_literal] = ACTIONS(682),
    [sym_decimal_floating_point_literal] = ACTIONS(682),
    [sym_hex_floating_point_literal] = ACTIONS(684),
    [sym_true] = ACTIONS(684),
    [sym_false] = ACTIONS(684),
    [sym_character_literal] = ACTIONS(682),
    [sym_string_literal] = ACTIONS(684),
    [sym_text_block] = ACTIONS(682),
    [sym_null_literal] = ACTIONS(684),
    [anon_sym_LPAREN] = ACTIONS(682),
    [anon_sym_PLUS] = ACTIONS(684),
    [anon_sym_DASH] = ACTIONS(684),
    [anon_sym_BANG] = ACTIONS(682),
    [anon_sym_TILDE] = ACTIONS(682),
    [anon_sym_PLUS_PLUS] = ACTIONS(682),
    [anon_sym_DASH_DASH] = ACTIONS(682),
    [anon_sym_new] = ACTIONS(684),
    [anon_sym_class] = ACTIONS(684),
    [anon_sym_switch] = ACTIONS(684),
    [anon_sym_LBRACE] = ACTIONS(682),
    [anon_sym_RBRACE] = ACTIONS(682),
    [anon_sym_case] = ACTIONS(684),
    [anon_sym_default] = ACTIONS(684),
    [anon_sym_SEMI] = ACTIONS(682),
    [anon_sym_assert] = ACTIONS(684),
    [anon_sym_do] = ACTIONS(684),
    [anon_sym_while] = ACTIONS(684),
    [anon_sym_break] = ACTIONS(684),
    [anon_sym_continue] = ACTIONS(684),
    [anon_sym_return] = ACTIONS(684),
    [anon_sym_yield] = ACTIONS(684),
    [anon_sym_synchronized] = ACTIONS(684),
    [anon_sym_throw] = ACTIONS(684),
    [anon_sym_try] = ACTIONS(684),
    [anon_sym_if] = ACTIONS(684),
    [anon_sym_else] = ACTIONS(684),
    [anon_sym_for] = ACTIONS(684),
    [anon_sym_AT] = ACTIONS(684),
    [anon_sym_open] = ACTIONS(684),
    [anon_sym_module] = ACTIONS(684),
    [anon_sym_static] = ACTIONS(684),
    [anon_sym_package] = ACTIONS(684),
    [anon_sym_import] = ACTIONS(684),
    [anon_sym_enum] = ACTIONS(684),
    [anon_sym_public] = ACTIONS(684),
    [anon_sym_protected] = ACTIONS(684),
    [anon_sym_private] = ACTIONS(684),
    [anon_sym_abstract] = ACTIONS(684),
    [anon_sym_final] = ACTIONS(684),
    [anon_sym_strictfp] = ACTIONS(684),
    [anon_sym_native] = ACTIONS(684),
    [anon_sym_transient] = ACTIONS(684),
    [anon_sym_volatile] = ACTIONS(684),
    [anon_sym_ATinterface] = ACTIONS(682),
    [anon_sym_interface] = ACTIONS(684),
    [anon_sym_byte] = ACTIONS(684),
    [anon_sym_short] = ACTIONS(684),
    [anon_sym_int] = ACTIONS(684),
    [anon_sym_long] = ACTIONS(684),
    [anon_sym_char] = ACTIONS(684),
    [anon_sym_float] = ACTIONS(684),
    [anon_sym_double] = ACTIONS(684),
    [sym_boolean_type] = ACTIONS(684),
    [sym_void_type] = ACTIONS(684),
    [sym_this] = ACTIONS(684),
    [sym_super] = ACTIONS(684),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [202] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(489),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [203] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(472),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1043),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1043),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(422),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(424),
    [anon_sym_PLUS] = ACTIONS(426),
    [anon_sym_DASH] = ACTIONS(426),
    [anon_sym_BANG] = ACTIONS(428),
    [anon_sym_TILDE] = ACTIONS(428),
    [anon_sym_PLUS_PLUS] = ACTIONS(430),
    [anon_sym_DASH_DASH] = ACTIONS(430),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(432),
    [anon_sym_module] = ACTIONS(432),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [204] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(474),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1043),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1043),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(422),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(424),
    [anon_sym_PLUS] = ACTIONS(426),
    [anon_sym_DASH] = ACTIONS(426),
    [anon_sym_BANG] = ACTIONS(428),
    [anon_sym_TILDE] = ACTIONS(428),
    [anon_sym_PLUS_PLUS] = ACTIONS(430),
    [anon_sym_DASH_DASH] = ACTIONS(430),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(432),
    [anon_sym_module] = ACTIONS(432),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [205] = {
    [ts_builtin_sym_end] = ACTIONS(686),
    [sym_identifier] = ACTIONS(688),
    [sym_decimal_integer_literal] = ACTIONS(688),
    [sym_hex_integer_literal] = ACTIONS(688),
    [sym_octal_integer_literal] = ACTIONS(686),
    [sym_binary_integer_literal] = ACTIONS(686),
    [sym_decimal_floating_point_literal] = ACTIONS(686),
    [sym_hex_floating_point_literal] = ACTIONS(688),
    [sym_true] = ACTIONS(688),
    [sym_false] = ACTIONS(688),
    [sym_character_literal] = ACTIONS(686),
    [sym_string_literal] = ACTIONS(688),
    [sym_text_block] = ACTIONS(686),
    [sym_null_literal] = ACTIONS(688),
    [anon_sym_LPAREN] = ACTIONS(686),
    [anon_sym_PLUS] = ACTIONS(688),
    [anon_sym_DASH] = ACTIONS(688),
    [anon_sym_BANG] = ACTIONS(686),
    [anon_sym_TILDE] = ACTIONS(686),
    [anon_sym_PLUS_PLUS] = ACTIONS(686),
    [anon_sym_DASH_DASH] = ACTIONS(686),
    [anon_sym_new] = ACTIONS(688),
    [anon_sym_class] = ACTIONS(688),
    [anon_sym_switch] = ACTIONS(688),
    [anon_sym_LBRACE] = ACTIONS(686),
    [anon_sym_RBRACE] = ACTIONS(686),
    [anon_sym_case] = ACTIONS(688),
    [anon_sym_default] = ACTIONS(688),
    [anon_sym_SEMI] = ACTIONS(686),
    [anon_sym_assert] = ACTIONS(688),
    [anon_sym_do] = ACTIONS(688),
    [anon_sym_while] = ACTIONS(688),
    [anon_sym_break] = ACTIONS(688),
    [anon_sym_continue] = ACTIONS(688),
    [anon_sym_return] = ACTIONS(688),
    [anon_sym_yield] = ACTIONS(688),
    [anon_sym_synchronized] = ACTIONS(688),
    [anon_sym_throw] = ACTIONS(688),
    [anon_sym_try] = ACTIONS(688),
    [anon_sym_if] = ACTIONS(688),
    [anon_sym_else] = ACTIONS(688),
    [anon_sym_for] = ACTIONS(688),
    [anon_sym_AT] = ACTIONS(688),
    [anon_sym_open] = ACTIONS(688),
    [anon_sym_module] = ACTIONS(688),
    [anon_sym_static] = ACTIONS(688),
    [anon_sym_package] = ACTIONS(688),
    [anon_sym_import] = ACTIONS(688),
    [anon_sym_enum] = ACTIONS(688),
    [anon_sym_public] = ACTIONS(688),
    [anon_sym_protected] = ACTIONS(688),
    [anon_sym_private] = ACTIONS(688),
    [anon_sym_abstract] = ACTIONS(688),
    [anon_sym_final] = ACTIONS(688),
    [anon_sym_strictfp] = ACTIONS(688),
    [anon_sym_native] = ACTIONS(688),
    [anon_sym_transient] = ACTIONS(688),
    [anon_sym_volatile] = ACTIONS(688),
    [anon_sym_ATinterface] = ACTIONS(686),
    [anon_sym_interface] = ACTIONS(688),
    [anon_sym_byte] = ACTIONS(688),
    [anon_sym_short] = ACTIONS(688),
    [anon_sym_int] = ACTIONS(688),
    [anon_sym_long] = ACTIONS(688),
    [anon_sym_char] = ACTIONS(688),
    [anon_sym_float] = ACTIONS(688),
    [anon_sym_double] = ACTIONS(688),
    [sym_boolean_type] = ACTIONS(688),
    [sym_void_type] = ACTIONS(688),
    [sym_this] = ACTIONS(688),
    [sym_super] = ACTIONS(688),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [206] = {
    [ts_builtin_sym_end] = ACTIONS(690),
    [sym_identifier] = ACTIONS(692),
    [sym_decimal_integer_literal] = ACTIONS(692),
    [sym_hex_integer_literal] = ACTIONS(692),
    [sym_octal_integer_literal] = ACTIONS(690),
    [sym_binary_integer_literal] = ACTIONS(690),
    [sym_decimal_floating_point_literal] = ACTIONS(690),
    [sym_hex_floating_point_literal] = ACTIONS(692),
    [sym_true] = ACTIONS(692),
    [sym_false] = ACTIONS(692),
    [sym_character_literal] = ACTIONS(690),
    [sym_string_literal] = ACTIONS(692),
    [sym_text_block] = ACTIONS(690),
    [sym_null_literal] = ACTIONS(692),
    [anon_sym_LPAREN] = ACTIONS(690),
    [anon_sym_PLUS] = ACTIONS(692),
    [anon_sym_DASH] = ACTIONS(692),
    [anon_sym_BANG] = ACTIONS(690),
    [anon_sym_TILDE] = ACTIONS(690),
    [anon_sym_PLUS_PLUS] = ACTIONS(690),
    [anon_sym_DASH_DASH] = ACTIONS(690),
    [anon_sym_new] = ACTIONS(692),
    [anon_sym_class] = ACTIONS(692),
    [anon_sym_switch] = ACTIONS(692),
    [anon_sym_LBRACE] = ACTIONS(690),
    [anon_sym_RBRACE] = ACTIONS(690),
    [anon_sym_case] = ACTIONS(692),
    [anon_sym_default] = ACTIONS(692),
    [anon_sym_SEMI] = ACTIONS(690),
    [anon_sym_assert] = ACTIONS(692),
    [anon_sym_do] = ACTIONS(692),
    [anon_sym_while] = ACTIONS(692),
    [anon_sym_break] = ACTIONS(692),
    [anon_sym_continue] = ACTIONS(692),
    [anon_sym_return] = ACTIONS(692),
    [anon_sym_yield] = ACTIONS(692),
    [anon_sym_synchronized] = ACTIONS(692),
    [anon_sym_throw] = ACTIONS(692),
    [anon_sym_try] = ACTIONS(692),
    [anon_sym_if] = ACTIONS(692),
    [anon_sym_else] = ACTIONS(692),
    [anon_sym_for] = ACTIONS(692),
    [anon_sym_AT] = ACTIONS(692),
    [anon_sym_open] = ACTIONS(692),
    [anon_sym_module] = ACTIONS(692),
    [anon_sym_static] = ACTIONS(692),
    [anon_sym_package] = ACTIONS(692),
    [anon_sym_import] = ACTIONS(692),
    [anon_sym_enum] = ACTIONS(692),
    [anon_sym_public] = ACTIONS(692),
    [anon_sym_protected] = ACTIONS(692),
    [anon_sym_private] = ACTIONS(692),
    [anon_sym_abstract] = ACTIONS(692),
    [anon_sym_final] = ACTIONS(692),
    [anon_sym_strictfp] = ACTIONS(692),
    [anon_sym_native] = ACTIONS(692),
    [anon_sym_transient] = ACTIONS(692),
    [anon_sym_volatile] = ACTIONS(692),
    [anon_sym_ATinterface] = ACTIONS(690),
    [anon_sym_interface] = ACTIONS(692),
    [anon_sym_byte] = ACTIONS(692),
    [anon_sym_short] = ACTIONS(692),
    [anon_sym_int] = ACTIONS(692),
    [anon_sym_long] = ACTIONS(692),
    [anon_sym_char] = ACTIONS(692),
    [anon_sym_float] = ACTIONS(692),
    [anon_sym_double] = ACTIONS(692),
    [sym_boolean_type] = ACTIONS(692),
    [sym_void_type] = ACTIONS(692),
    [sym_this] = ACTIONS(692),
    [sym_super] = ACTIONS(692),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [207] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(481),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1043),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1043),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(422),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(424),
    [anon_sym_PLUS] = ACTIONS(426),
    [anon_sym_DASH] = ACTIONS(426),
    [anon_sym_BANG] = ACTIONS(428),
    [anon_sym_TILDE] = ACTIONS(428),
    [anon_sym_PLUS_PLUS] = ACTIONS(430),
    [anon_sym_DASH_DASH] = ACTIONS(430),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(432),
    [anon_sym_module] = ACTIONS(432),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [208] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(477),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [209] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(432),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [210] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(498),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1067),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1067),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [211] = {
    [ts_builtin_sym_end] = ACTIONS(694),
    [sym_identifier] = ACTIONS(696),
    [sym_decimal_integer_literal] = ACTIONS(696),
    [sym_hex_integer_literal] = ACTIONS(696),
    [sym_octal_integer_literal] = ACTIONS(694),
    [sym_binary_integer_literal] = ACTIONS(694),
    [sym_decimal_floating_point_literal] = ACTIONS(694),
    [sym_hex_floating_point_literal] = ACTIONS(696),
    [sym_true] = ACTIONS(696),
    [sym_false] = ACTIONS(696),
    [sym_character_literal] = ACTIONS(694),
    [sym_string_literal] = ACTIONS(696),
    [sym_text_block] = ACTIONS(694),
    [sym_null_literal] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_PLUS_PLUS] = ACTIONS(694),
    [anon_sym_DASH_DASH] = ACTIONS(694),
    [anon_sym_new] = ACTIONS(696),
    [anon_sym_class] = ACTIONS(696),
    [anon_sym_switch] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_case] = ACTIONS(696),
    [anon_sym_default] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_assert] = ACTIONS(696),
    [anon_sym_do] = ACTIONS(696),
    [anon_sym_while] = ACTIONS(696),
    [anon_sym_break] = ACTIONS(696),
    [anon_sym_continue] = ACTIONS(696),
    [anon_sym_return] = ACTIONS(696),
    [anon_sym_yield] = ACTIONS(696),
    [anon_sym_synchronized] = ACTIONS(696),
    [anon_sym_throw] = ACTIONS(696),
    [anon_sym_try] = ACTIONS(696),
    [anon_sym_if] = ACTIONS(696),
    [anon_sym_else] = ACTIONS(696),
    [anon_sym_for] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_open] = ACTIONS(696),
    [anon_sym_module] = ACTIONS(696),
    [anon_sym_static] = ACTIONS(696),
    [anon_sym_package] = ACTIONS(696),
    [anon_sym_import] = ACTIONS(696),
    [anon_sym_enum] = ACTIONS(696),
    [anon_sym_public] = ACTIONS(696),
    [anon_sym_protected] = ACTIONS(696),
    [anon_sym_private] = ACTIONS(696),
    [anon_sym_abstract] = ACTIONS(696),
    [anon_sym_final] = ACTIONS(696),
    [anon_sym_strictfp] = ACTIONS(696),
    [anon_sym_native] = ACTIONS(696),
    [anon_sym_transient] = ACTIONS(696),
    [anon_sym_volatile] = ACTIONS(696),
    [anon_sym_ATinterface] = ACTIONS(694),
    [anon_sym_interface] = ACTIONS(696),
    [anon_sym_byte] = ACTIONS(696),
    [anon_sym_short] = ACTIONS(696),
    [anon_sym_int] = ACTIONS(696),
    [anon_sym_long] = ACTIONS(696),
    [anon_sym_char] = ACTIONS(696),
    [anon_sym_float] = ACTIONS(696),
    [anon_sym_double] = ACTIONS(696),
    [sym_boolean_type] = ACTIONS(696),
    [sym_void_type] = ACTIONS(696),
    [sym_this] = ACTIONS(696),
    [sym_super] = ACTIONS(696),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [212] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(473),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1043),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1043),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(422),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(424),
    [anon_sym_PLUS] = ACTIONS(426),
    [anon_sym_DASH] = ACTIONS(426),
    [anon_sym_BANG] = ACTIONS(428),
    [anon_sym_TILDE] = ACTIONS(428),
    [anon_sym_PLUS_PLUS] = ACTIONS(430),
    [anon_sym_DASH_DASH] = ACTIONS(430),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(432),
    [anon_sym_module] = ACTIONS(432),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [213] = {
    [ts_builtin_sym_end] = ACTIONS(698),
    [sym_identifier] = ACTIONS(700),
    [sym_decimal_integer_literal] = ACTIONS(700),
    [sym_hex_integer_literal] = ACTIONS(700),
    [sym_octal_integer_literal] = ACTIONS(698),
    [sym_binary_integer_literal] = ACTIONS(698),
    [sym_decimal_floating_point_literal] = ACTIONS(698),
    [sym_hex_floating_point_literal] = ACTIONS(700),
    [sym_true] = ACTIONS(700),
    [sym_false] = ACTIONS(700),
    [sym_character_literal] = ACTIONS(698),
    [sym_string_literal] = ACTIONS(700),
    [sym_text_block] = ACTIONS(698),
    [sym_null_literal] = ACTIONS(700),
    [anon_sym_LPAREN] = ACTIONS(698),
    [anon_sym_PLUS] = ACTIONS(700),
    [anon_sym_DASH] = ACTIONS(700),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_TILDE] = ACTIONS(698),
    [anon_sym_PLUS_PLUS] = ACTIONS(698),
    [anon_sym_DASH_DASH] = ACTIONS(698),
    [anon_sym_new] = ACTIONS(700),
    [anon_sym_class] = ACTIONS(700),
    [anon_sym_switch] = ACTIONS(700),
    [anon_sym_LBRACE] = ACTIONS(698),
    [anon_sym_RBRACE] = ACTIONS(698),
    [anon_sym_case] = ACTIONS(700),
    [anon_sym_default] = ACTIONS(700),
    [anon_sym_SEMI] = ACTIONS(698),
    [anon_sym_assert] = ACTIONS(700),
    [anon_sym_do] = ACTIONS(700),
    [anon_sym_while] = ACTIONS(700),
    [anon_sym_break] = ACTIONS(700),
    [anon_sym_continue] = ACTIONS(700),
    [anon_sym_return] = ACTIONS(700),
    [anon_sym_yield] = ACTIONS(700),
    [anon_sym_synchronized] = ACTIONS(700),
    [anon_sym_throw] = ACTIONS(700),
    [anon_sym_try] = ACTIONS(700),
    [anon_sym_if] = ACTIONS(700),
    [anon_sym_else] = ACTIONS(700),
    [anon_sym_for] = ACTIONS(700),
    [anon_sym_AT] = ACTIONS(700),
    [anon_sym_open] = ACTIONS(700),
    [anon_sym_module] = ACTIONS(700),
    [anon_sym_static] = ACTIONS(700),
    [anon_sym_package] = ACTIONS(700),
    [anon_sym_import] = ACTIONS(700),
    [anon_sym_enum] = ACTIONS(700),
    [anon_sym_public] = ACTIONS(700),
    [anon_sym_protected] = ACTIONS(700),
    [anon_sym_private] = ACTIONS(700),
    [anon_sym_abstract] = ACTIONS(700),
    [anon_sym_final] = ACTIONS(700),
    [anon_sym_strictfp] = ACTIONS(700),
    [anon_sym_native] = ACTIONS(700),
    [anon_sym_transient] = ACTIONS(700),
    [anon_sym_volatile] = ACTIONS(700),
    [anon_sym_ATinterface] = ACTIONS(698),
    [anon_sym_interface] = ACTIONS(700),
    [anon_sym_byte] = ACTIONS(700),
    [anon_sym_short] = ACTIONS(700),
    [anon_sym_int] = ACTIONS(700),
    [anon_sym_long] = ACTIONS(700),
    [anon_sym_char] = ACTIONS(700),
    [anon_sym_float] = ACTIONS(700),
    [anon_sym_double] = ACTIONS(700),
    [sym_boolean_type] = ACTIONS(700),
    [sym_void_type] = ACTIONS(700),
    [sym_this] = ACTIONS(700),
    [sym_super] = ACTIONS(700),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [214] = {
    [ts_builtin_sym_end] = ACTIONS(702),
    [sym_identifier] = ACTIONS(704),
    [sym_decimal_integer_literal] = ACTIONS(704),
    [sym_hex_integer_literal] = ACTIONS(704),
    [sym_octal_integer_literal] = ACTIONS(702),
    [sym_binary_integer_literal] = ACTIONS(702),
    [sym_decimal_floating_point_literal] = ACTIONS(702),
    [sym_hex_floating_point_literal] = ACTIONS(704),
    [sym_true] = ACTIONS(704),
    [sym_false] = ACTIONS(704),
    [sym_character_literal] = ACTIONS(702),
    [sym_string_literal] = ACTIONS(704),
    [sym_text_block] = ACTIONS(702),
    [sym_null_literal] = ACTIONS(704),
    [anon_sym_LPAREN] = ACTIONS(702),
    [anon_sym_PLUS] = ACTIONS(704),
    [anon_sym_DASH] = ACTIONS(704),
    [anon_sym_BANG] = ACTIONS(702),
    [anon_sym_TILDE] = ACTIONS(702),
    [anon_sym_PLUS_PLUS] = ACTIONS(702),
    [anon_sym_DASH_DASH] = ACTIONS(702),
    [anon_sym_new] = ACTIONS(704),
    [anon_sym_class] = ACTIONS(704),
    [anon_sym_switch] = ACTIONS(704),
    [anon_sym_LBRACE] = ACTIONS(702),
    [anon_sym_RBRACE] = ACTIONS(702),
    [anon_sym_case] = ACTIONS(704),
    [anon_sym_default] = ACTIONS(704),
    [anon_sym_SEMI] = ACTIONS(702),
    [anon_sym_assert] = ACTIONS(704),
    [anon_sym_do] = ACTIONS(704),
    [anon_sym_while] = ACTIONS(704),
    [anon_sym_break] = ACTIONS(704),
    [anon_sym_continue] = ACTIONS(704),
    [anon_sym_return] = ACTIONS(704),
    [anon_sym_yield] = ACTIONS(704),
    [anon_sym_synchronized] = ACTIONS(704),
    [anon_sym_throw] = ACTIONS(704),
    [anon_sym_try] = ACTIONS(704),
    [anon_sym_if] = ACTIONS(704),
    [anon_sym_else] = ACTIONS(704),
    [anon_sym_for] = ACTIONS(704),
    [anon_sym_AT] = ACTIONS(704),
    [anon_sym_open] = ACTIONS(704),
    [anon_sym_module] = ACTIONS(704),
    [anon_sym_static] = ACTIONS(704),
    [anon_sym_package] = ACTIONS(704),
    [anon_sym_import] = ACTIONS(704),
    [anon_sym_enum] = ACTIONS(704),
    [anon_sym_public] = ACTIONS(704),
    [anon_sym_protected] = ACTIONS(704),
    [anon_sym_private] = ACTIONS(704),
    [anon_sym_abstract] = ACTIONS(704),
    [anon_sym_final] = ACTIONS(704),
    [anon_sym_strictfp] = ACTIONS(704),
    [anon_sym_native] = ACTIONS(704),
    [anon_sym_transient] = ACTIONS(704),
    [anon_sym_volatile] = ACTIONS(704),
    [anon_sym_ATinterface] = ACTIONS(702),
    [anon_sym_interface] = ACTIONS(704),
    [anon_sym_byte] = ACTIONS(704),
    [anon_sym_short] = ACTIONS(704),
    [anon_sym_int] = ACTIONS(704),
    [anon_sym_long] = ACTIONS(704),
    [anon_sym_char] = ACTIONS(704),
    [anon_sym_float] = ACTIONS(704),
    [anon_sym_double] = ACTIONS(704),
    [sym_boolean_type] = ACTIONS(704),
    [sym_void_type] = ACTIONS(704),
    [sym_this] = ACTIONS(704),
    [sym_super] = ACTIONS(704),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [215] = {
    [ts_builtin_sym_end] = ACTIONS(706),
    [sym_identifier] = ACTIONS(708),
    [sym_decimal_integer_literal] = ACTIONS(708),
    [sym_hex_integer_literal] = ACTIONS(708),
    [sym_octal_integer_literal] = ACTIONS(706),
    [sym_binary_integer_literal] = ACTIONS(706),
    [sym_decimal_floating_point_literal] = ACTIONS(706),
    [sym_hex_floating_point_literal] = ACTIONS(708),
    [sym_true] = ACTIONS(708),
    [sym_false] = ACTIONS(708),
    [sym_character_literal] = ACTIONS(706),
    [sym_string_literal] = ACTIONS(708),
    [sym_text_block] = ACTIONS(706),
    [sym_null_literal] = ACTIONS(708),
    [anon_sym_LPAREN] = ACTIONS(706),
    [anon_sym_PLUS] = ACTIONS(708),
    [anon_sym_DASH] = ACTIONS(708),
    [anon_sym_BANG] = ACTIONS(706),
    [anon_sym_TILDE] = ACTIONS(706),
    [anon_sym_PLUS_PLUS] = ACTIONS(706),
    [anon_sym_DASH_DASH] = ACTIONS(706),
    [anon_sym_new] = ACTIONS(708),
    [anon_sym_class] = ACTIONS(708),
    [anon_sym_switch] = ACTIONS(708),
    [anon_sym_LBRACE] = ACTIONS(706),
    [anon_sym_RBRACE] = ACTIONS(706),
    [anon_sym_case] = ACTIONS(708),
    [anon_sym_default] = ACTIONS(708),
    [anon_sym_SEMI] = ACTIONS(706),
    [anon_sym_assert] = ACTIONS(708),
    [anon_sym_do] = ACTIONS(708),
    [anon_sym_while] = ACTIONS(708),
    [anon_sym_break] = ACTIONS(708),
    [anon_sym_continue] = ACTIONS(708),
    [anon_sym_return] = ACTIONS(708),
    [anon_sym_yield] = ACTIONS(708),
    [anon_sym_synchronized] = ACTIONS(708),
    [anon_sym_throw] = ACTIONS(708),
    [anon_sym_try] = ACTIONS(708),
    [anon_sym_if] = ACTIONS(708),
    [anon_sym_else] = ACTIONS(708),
    [anon_sym_for] = ACTIONS(708),
    [anon_sym_AT] = ACTIONS(708),
    [anon_sym_open] = ACTIONS(708),
    [anon_sym_module] = ACTIONS(708),
    [anon_sym_static] = ACTIONS(708),
    [anon_sym_package] = ACTIONS(708),
    [anon_sym_import] = ACTIONS(708),
    [anon_sym_enum] = ACTIONS(708),
    [anon_sym_public] = ACTIONS(708),
    [anon_sym_protected] = ACTIONS(708),
    [anon_sym_private] = ACTIONS(708),
    [anon_sym_abstract] = ACTIONS(708),
    [anon_sym_final] = ACTIONS(708),
    [anon_sym_strictfp] = ACTIONS(708),
    [anon_sym_native] = ACTIONS(708),
    [anon_sym_transient] = ACTIONS(708),
    [anon_sym_volatile] = ACTIONS(708),
    [anon_sym_ATinterface] = ACTIONS(706),
    [anon_sym_interface] = ACTIONS(708),
    [anon_sym_byte] = ACTIONS(708),
    [anon_sym_short] = ACTIONS(708),
    [anon_sym_int] = ACTIONS(708),
    [anon_sym_long] = ACTIONS(708),
    [anon_sym_char] = ACTIONS(708),
    [anon_sym_float] = ACTIONS(708),
    [anon_sym_double] = ACTIONS(708),
    [sym_boolean_type] = ACTIONS(708),
    [sym_void_type] = ACTIONS(708),
    [sym_this] = ACTIONS(708),
    [sym_super] = ACTIONS(708),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [216] = {
    [ts_builtin_sym_end] = ACTIONS(710),
    [sym_identifier] = ACTIONS(712),
    [sym_decimal_integer_literal] = ACTIONS(712),
    [sym_hex_integer_literal] = ACTIONS(712),
    [sym_octal_integer_literal] = ACTIONS(710),
    [sym_binary_integer_literal] = ACTIONS(710),
    [sym_decimal_floating_point_literal] = ACTIONS(710),
    [sym_hex_floating_point_literal] = ACTIONS(712),
    [sym_true] = ACTIONS(712),
    [sym_false] = ACTIONS(712),
    [sym_character_literal] = ACTIONS(710),
    [sym_string_literal] = ACTIONS(712),
    [sym_text_block] = ACTIONS(710),
    [sym_null_literal] = ACTIONS(712),
    [anon_sym_LPAREN] = ACTIONS(710),
    [anon_sym_PLUS] = ACTIONS(712),
    [anon_sym_DASH] = ACTIONS(712),
    [anon_sym_BANG] = ACTIONS(710),
    [anon_sym_TILDE] = ACTIONS(710),
    [anon_sym_PLUS_PLUS] = ACTIONS(710),
    [anon_sym_DASH_DASH] = ACTIONS(710),
    [anon_sym_new] = ACTIONS(712),
    [anon_sym_class] = ACTIONS(712),
    [anon_sym_switch] = ACTIONS(712),
    [anon_sym_LBRACE] = ACTIONS(710),
    [anon_sym_RBRACE] = ACTIONS(710),
    [anon_sym_case] = ACTIONS(712),
    [anon_sym_default] = ACTIONS(712),
    [anon_sym_SEMI] = ACTIONS(710),
    [anon_sym_assert] = ACTIONS(712),
    [anon_sym_do] = ACTIONS(712),
    [anon_sym_while] = ACTIONS(712),
    [anon_sym_break] = ACTIONS(712),
    [anon_sym_continue] = ACTIONS(712),
    [anon_sym_return] = ACTIONS(712),
    [anon_sym_yield] = ACTIONS(712),
    [anon_sym_synchronized] = ACTIONS(712),
    [anon_sym_throw] = ACTIONS(712),
    [anon_sym_try] = ACTIONS(712),
    [anon_sym_if] = ACTIONS(712),
    [anon_sym_else] = ACTIONS(712),
    [anon_sym_for] = ACTIONS(712),
    [anon_sym_AT] = ACTIONS(712),
    [anon_sym_open] = ACTIONS(712),
    [anon_sym_module] = ACTIONS(712),
    [anon_sym_static] = ACTIONS(712),
    [anon_sym_package] = ACTIONS(712),
    [anon_sym_import] = ACTIONS(712),
    [anon_sym_enum] = ACTIONS(712),
    [anon_sym_public] = ACTIONS(712),
    [anon_sym_protected] = ACTIONS(712),
    [anon_sym_private] = ACTIONS(712),
    [anon_sym_abstract] = ACTIONS(712),
    [anon_sym_final] = ACTIONS(712),
    [anon_sym_strictfp] = ACTIONS(712),
    [anon_sym_native] = ACTIONS(712),
    [anon_sym_transient] = ACTIONS(712),
    [anon_sym_volatile] = ACTIONS(712),
    [anon_sym_ATinterface] = ACTIONS(710),
    [anon_sym_interface] = ACTIONS(712),
    [anon_sym_byte] = ACTIONS(712),
    [anon_sym_short] = ACTIONS(712),
    [anon_sym_int] = ACTIONS(712),
    [anon_sym_long] = ACTIONS(712),
    [anon_sym_char] = ACTIONS(712),
    [anon_sym_float] = ACTIONS(712),
    [anon_sym_double] = ACTIONS(712),
    [sym_boolean_type] = ACTIONS(712),
    [sym_void_type] = ACTIONS(712),
    [sym_this] = ACTIONS(712),
    [sym_super] = ACTIONS(712),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [217] = {
    [ts_builtin_sym_end] = ACTIONS(714),
    [sym_identifier] = ACTIONS(716),
    [sym_decimal_integer_literal] = ACTIONS(716),
    [sym_hex_integer_literal] = ACTIONS(716),
    [sym_octal_integer_literal] = ACTIONS(714),
    [sym_binary_integer_literal] = ACTIONS(714),
    [sym_decimal_floating_point_literal] = ACTIONS(714),
    [sym_hex_floating_point_literal] = ACTIONS(716),
    [sym_true] = ACTIONS(716),
    [sym_false] = ACTIONS(716),
    [sym_character_literal] = ACTIONS(714),
    [sym_string_literal] = ACTIONS(716),
    [sym_text_block] = ACTIONS(714),
    [sym_null_literal] = ACTIONS(716),
    [anon_sym_LPAREN] = ACTIONS(714),
    [anon_sym_PLUS] = ACTIONS(716),
    [anon_sym_DASH] = ACTIONS(716),
    [anon_sym_BANG] = ACTIONS(714),
    [anon_sym_TILDE] = ACTIONS(714),
    [anon_sym_PLUS_PLUS] = ACTIONS(714),
    [anon_sym_DASH_DASH] = ACTIONS(714),
    [anon_sym_new] = ACTIONS(716),
    [anon_sym_class] = ACTIONS(716),
    [anon_sym_switch] = ACTIONS(716),
    [anon_sym_LBRACE] = ACTIONS(714),
    [anon_sym_RBRACE] = ACTIONS(714),
    [anon_sym_case] = ACTIONS(716),
    [anon_sym_default] = ACTIONS(716),
    [anon_sym_SEMI] = ACTIONS(714),
    [anon_sym_assert] = ACTIONS(716),
    [anon_sym_do] = ACTIONS(716),
    [anon_sym_while] = ACTIONS(716),
    [anon_sym_break] = ACTIONS(716),
    [anon_sym_continue] = ACTIONS(716),
    [anon_sym_return] = ACTIONS(716),
    [anon_sym_yield] = ACTIONS(716),
    [anon_sym_synchronized] = ACTIONS(716),
    [anon_sym_throw] = ACTIONS(716),
    [anon_sym_try] = ACTIONS(716),
    [anon_sym_if] = ACTIONS(716),
    [anon_sym_else] = ACTIONS(716),
    [anon_sym_for] = ACTIONS(716),
    [anon_sym_AT] = ACTIONS(716),
    [anon_sym_open] = ACTIONS(716),
    [anon_sym_module] = ACTIONS(716),
    [anon_sym_static] = ACTIONS(716),
    [anon_sym_package] = ACTIONS(716),
    [anon_sym_import] = ACTIONS(716),
    [anon_sym_enum] = ACTIONS(716),
    [anon_sym_public] = ACTIONS(716),
    [anon_sym_protected] = ACTIONS(716),
    [anon_sym_private] = ACTIONS(716),
    [anon_sym_abstract] = ACTIONS(716),
    [anon_sym_final] = ACTIONS(716),
    [anon_sym_strictfp] = ACTIONS(716),
    [anon_sym_native] = ACTIONS(716),
    [anon_sym_transient] = ACTIONS(716),
    [anon_sym_volatile] = ACTIONS(716),
    [anon_sym_ATinterface] = ACTIONS(714),
    [anon_sym_interface] = ACTIONS(716),
    [anon_sym_byte] = ACTIONS(716),
    [anon_sym_short] = ACTIONS(716),
    [anon_sym_int] = ACTIONS(716),
    [anon_sym_long] = ACTIONS(716),
    [anon_sym_char] = ACTIONS(716),
    [anon_sym_float] = ACTIONS(716),
    [anon_sym_double] = ACTIONS(716),
    [sym_boolean_type] = ACTIONS(716),
    [sym_void_type] = ACTIONS(716),
    [sym_this] = ACTIONS(716),
    [sym_super] = ACTIONS(716),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [218] = {
    [ts_builtin_sym_end] = ACTIONS(718),
    [sym_identifier] = ACTIONS(720),
    [sym_decimal_integer_literal] = ACTIONS(720),
    [sym_hex_integer_literal] = ACTIONS(720),
    [sym_octal_integer_literal] = ACTIONS(718),
    [sym_binary_integer_literal] = ACTIONS(718),
    [sym_decimal_floating_point_literal] = ACTIONS(718),
    [sym_hex_floating_point_literal] = ACTIONS(720),
    [sym_true] = ACTIONS(720),
    [sym_false] = ACTIONS(720),
    [sym_character_literal] = ACTIONS(718),
    [sym_string_literal] = ACTIONS(720),
    [sym_text_block] = ACTIONS(718),
    [sym_null_literal] = ACTIONS(720),
    [anon_sym_LPAREN] = ACTIONS(718),
    [anon_sym_PLUS] = ACTIONS(720),
    [anon_sym_DASH] = ACTIONS(720),
    [anon_sym_BANG] = ACTIONS(718),
    [anon_sym_TILDE] = ACTIONS(718),
    [anon_sym_PLUS_PLUS] = ACTIONS(718),
    [anon_sym_DASH_DASH] = ACTIONS(718),
    [anon_sym_new] = ACTIONS(720),
    [anon_sym_class] = ACTIONS(720),
    [anon_sym_switch] = ACTIONS(720),
    [anon_sym_LBRACE] = ACTIONS(718),
    [anon_sym_RBRACE] = ACTIONS(718),
    [anon_sym_case] = ACTIONS(720),
    [anon_sym_default] = ACTIONS(720),
    [anon_sym_SEMI] = ACTIONS(718),
    [anon_sym_assert] = ACTIONS(720),
    [anon_sym_do] = ACTIONS(720),
    [anon_sym_while] = ACTIONS(720),
    [anon_sym_break] = ACTIONS(720),
    [anon_sym_continue] = ACTIONS(720),
    [anon_sym_return] = ACTIONS(720),
    [anon_sym_yield] = ACTIONS(720),
    [anon_sym_synchronized] = ACTIONS(720),
    [anon_sym_throw] = ACTIONS(720),
    [anon_sym_try] = ACTIONS(720),
    [anon_sym_if] = ACTIONS(720),
    [anon_sym_else] = ACTIONS(720),
    [anon_sym_for] = ACTIONS(720),
    [anon_sym_AT] = ACTIONS(720),
    [anon_sym_open] = ACTIONS(720),
    [anon_sym_module] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(720),
    [anon_sym_package] = ACTIONS(720),
    [anon_sym_import] = ACTIONS(720),
    [anon_sym_enum] = ACTIONS(720),
    [anon_sym_public] = ACTIONS(720),
    [anon_sym_protected] = ACTIONS(720),
    [anon_sym_private] = ACTIONS(720),
    [anon_sym_abstract] = ACTIONS(720),
    [anon_sym_final] = ACTIONS(720),
    [anon_sym_strictfp] = ACTIONS(720),
    [anon_sym_native] = ACTIONS(720),
    [anon_sym_transient] = ACTIONS(720),
    [anon_sym_volatile] = ACTIONS(720),
    [anon_sym_ATinterface] = ACTIONS(718),
    [anon_sym_interface] = ACTIONS(720),
    [anon_sym_byte] = ACTIONS(720),
    [anon_sym_short] = ACTIONS(720),
    [anon_sym_int] = ACTIONS(720),
    [anon_sym_long] = ACTIONS(720),
    [anon_sym_char] = ACTIONS(720),
    [anon_sym_float] = ACTIONS(720),
    [anon_sym_double] = ACTIONS(720),
    [sym_boolean_type] = ACTIONS(720),
    [sym_void_type] = ACTIONS(720),
    [sym_this] = ACTIONS(720),
    [sym_super] = ACTIONS(720),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [219] = {
    [ts_builtin_sym_end] = ACTIONS(722),
    [sym_identifier] = ACTIONS(724),
    [sym_decimal_integer_literal] = ACTIONS(724),
    [sym_hex_integer_literal] = ACTIONS(724),
    [sym_octal_integer_literal] = ACTIONS(722),
    [sym_binary_integer_literal] = ACTIONS(722),
    [sym_decimal_floating_point_literal] = ACTIONS(722),
    [sym_hex_floating_point_literal] = ACTIONS(724),
    [sym_true] = ACTIONS(724),
    [sym_false] = ACTIONS(724),
    [sym_character_literal] = ACTIONS(722),
    [sym_string_literal] = ACTIONS(724),
    [sym_text_block] = ACTIONS(722),
    [sym_null_literal] = ACTIONS(724),
    [anon_sym_LPAREN] = ACTIONS(722),
    [anon_sym_PLUS] = ACTIONS(724),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_BANG] = ACTIONS(722),
    [anon_sym_TILDE] = ACTIONS(722),
    [anon_sym_PLUS_PLUS] = ACTIONS(722),
    [anon_sym_DASH_DASH] = ACTIONS(722),
    [anon_sym_new] = ACTIONS(724),
    [anon_sym_class] = ACTIONS(724),
    [anon_sym_switch] = ACTIONS(724),
    [anon_sym_LBRACE] = ACTIONS(722),
    [anon_sym_RBRACE] = ACTIONS(722),
    [anon_sym_case] = ACTIONS(724),
    [anon_sym_default] = ACTIONS(724),
    [anon_sym_SEMI] = ACTIONS(722),
    [anon_sym_assert] = ACTIONS(724),
    [anon_sym_do] = ACTIONS(724),
    [anon_sym_while] = ACTIONS(724),
    [anon_sym_break] = ACTIONS(724),
    [anon_sym_continue] = ACTIONS(724),
    [anon_sym_return] = ACTIONS(724),
    [anon_sym_yield] = ACTIONS(724),
    [anon_sym_synchronized] = ACTIONS(724),
    [anon_sym_throw] = ACTIONS(724),
    [anon_sym_try] = ACTIONS(724),
    [anon_sym_if] = ACTIONS(724),
    [anon_sym_else] = ACTIONS(724),
    [anon_sym_for] = ACTIONS(724),
    [anon_sym_AT] = ACTIONS(724),
    [anon_sym_open] = ACTIONS(724),
    [anon_sym_module] = ACTIONS(724),
    [anon_sym_static] = ACTIONS(724),
    [anon_sym_package] = ACTIONS(724),
    [anon_sym_import] = ACTIONS(724),
    [anon_sym_enum] = ACTIONS(724),
    [anon_sym_public] = ACTIONS(724),
    [anon_sym_protected] = ACTIONS(724),
    [anon_sym_private] = ACTIONS(724),
    [anon_sym_abstract] = ACTIONS(724),
    [anon_sym_final] = ACTIONS(724),
    [anon_sym_strictfp] = ACTIONS(724),
    [anon_sym_native] = ACTIONS(724),
    [anon_sym_transient] = ACTIONS(724),
    [anon_sym_volatile] = ACTIONS(724),
    [anon_sym_ATinterface] = ACTIONS(722),
    [anon_sym_interface] = ACTIONS(724),
    [anon_sym_byte] = ACTIONS(724),
    [anon_sym_short] = ACTIONS(724),
    [anon_sym_int] = ACTIONS(724),
    [anon_sym_long] = ACTIONS(724),
    [anon_sym_char] = ACTIONS(724),
    [anon_sym_float] = ACTIONS(724),
    [anon_sym_double] = ACTIONS(724),
    [sym_boolean_type] = ACTIONS(724),
    [sym_void_type] = ACTIONS(724),
    [sym_this] = ACTIONS(724),
    [sym_super] = ACTIONS(724),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [220] = {
    [ts_builtin_sym_end] = ACTIONS(726),
    [sym_identifier] = ACTIONS(728),
    [sym_decimal_integer_literal] = ACTIONS(728),
    [sym_hex_integer_literal] = ACTIONS(728),
    [sym_octal_integer_literal] = ACTIONS(726),
    [sym_binary_integer_literal] = ACTIONS(726),
    [sym_decimal_floating_point_literal] = ACTIONS(726),
    [sym_hex_floating_point_literal] = ACTIONS(728),
    [sym_true] = ACTIONS(728),
    [sym_false] = ACTIONS(728),
    [sym_character_literal] = ACTIONS(726),
    [sym_string_literal] = ACTIONS(728),
    [sym_text_block] = ACTIONS(726),
    [sym_null_literal] = ACTIONS(728),
    [anon_sym_LPAREN] = ACTIONS(726),
    [anon_sym_PLUS] = ACTIONS(728),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_BANG] = ACTIONS(726),
    [anon_sym_TILDE] = ACTIONS(726),
    [anon_sym_PLUS_PLUS] = ACTIONS(726),
    [anon_sym_DASH_DASH] = ACTIONS(726),
    [anon_sym_new] = ACTIONS(728),
    [anon_sym_class] = ACTIONS(728),
    [anon_sym_switch] = ACTIONS(728),
    [anon_sym_LBRACE] = ACTIONS(726),
    [anon_sym_RBRACE] = ACTIONS(726),
    [anon_sym_case] = ACTIONS(728),
    [anon_sym_default] = ACTIONS(728),
    [anon_sym_SEMI] = ACTIONS(726),
    [anon_sym_assert] = ACTIONS(728),
    [anon_sym_do] = ACTIONS(728),
    [anon_sym_while] = ACTIONS(728),
    [anon_sym_break] = ACTIONS(728),
    [anon_sym_continue] = ACTIONS(728),
    [anon_sym_return] = ACTIONS(728),
    [anon_sym_yield] = ACTIONS(728),
    [anon_sym_synchronized] = ACTIONS(728),
    [anon_sym_throw] = ACTIONS(728),
    [anon_sym_try] = ACTIONS(728),
    [anon_sym_if] = ACTIONS(728),
    [anon_sym_else] = ACTIONS(728),
    [anon_sym_for] = ACTIONS(728),
    [anon_sym_AT] = ACTIONS(728),
    [anon_sym_open] = ACTIONS(728),
    [anon_sym_module] = ACTIONS(728),
    [anon_sym_static] = ACTIONS(728),
    [anon_sym_package] = ACTIONS(728),
    [anon_sym_import] = ACTIONS(728),
    [anon_sym_enum] = ACTIONS(728),
    [anon_sym_public] = ACTIONS(728),
    [anon_sym_protected] = ACTIONS(728),
    [anon_sym_private] = ACTIONS(728),
    [anon_sym_abstract] = ACTIONS(728),
    [anon_sym_final] = ACTIONS(728),
    [anon_sym_strictfp] = ACTIONS(728),
    [anon_sym_native] = ACTIONS(728),
    [anon_sym_transient] = ACTIONS(728),
    [anon_sym_volatile] = ACTIONS(728),
    [anon_sym_ATinterface] = ACTIONS(726),
    [anon_sym_interface] = ACTIONS(728),
    [anon_sym_byte] = ACTIONS(728),
    [anon_sym_short] = ACTIONS(728),
    [anon_sym_int] = ACTIONS(728),
    [anon_sym_long] = ACTIONS(728),
    [anon_sym_char] = ACTIONS(728),
    [anon_sym_float] = ACTIONS(728),
    [anon_sym_double] = ACTIONS(728),
    [sym_boolean_type] = ACTIONS(728),
    [sym_void_type] = ACTIONS(728),
    [sym_this] = ACTIONS(728),
    [sym_super] = ACTIONS(728),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [221] = {
    [ts_builtin_sym_end] = ACTIONS(730),
    [sym_identifier] = ACTIONS(732),
    [sym_decimal_integer_literal] = ACTIONS(732),
    [sym_hex_integer_literal] = ACTIONS(732),
    [sym_octal_integer_literal] = ACTIONS(730),
    [sym_binary_integer_literal] = ACTIONS(730),
    [sym_decimal_floating_point_literal] = ACTIONS(730),
    [sym_hex_floating_point_literal] = ACTIONS(732),
    [sym_true] = ACTIONS(732),
    [sym_false] = ACTIONS(732),
    [sym_character_literal] = ACTIONS(730),
    [sym_string_literal] = ACTIONS(732),
    [sym_text_block] = ACTIONS(730),
    [sym_null_literal] = ACTIONS(732),
    [anon_sym_LPAREN] = ACTIONS(730),
    [anon_sym_PLUS] = ACTIONS(732),
    [anon_sym_DASH] = ACTIONS(732),
    [anon_sym_BANG] = ACTIONS(730),
    [anon_sym_TILDE] = ACTIONS(730),
    [anon_sym_PLUS_PLUS] = ACTIONS(730),
    [anon_sym_DASH_DASH] = ACTIONS(730),
    [anon_sym_new] = ACTIONS(732),
    [anon_sym_class] = ACTIONS(732),
    [anon_sym_switch] = ACTIONS(732),
    [anon_sym_LBRACE] = ACTIONS(730),
    [anon_sym_RBRACE] = ACTIONS(730),
    [anon_sym_case] = ACTIONS(732),
    [anon_sym_default] = ACTIONS(732),
    [anon_sym_SEMI] = ACTIONS(730),
    [anon_sym_assert] = ACTIONS(732),
    [anon_sym_do] = ACTIONS(732),
    [anon_sym_while] = ACTIONS(732),
    [anon_sym_break] = ACTIONS(732),
    [anon_sym_continue] = ACTIONS(732),
    [anon_sym_return] = ACTIONS(732),
    [anon_sym_yield] = ACTIONS(732),
    [anon_sym_synchronized] = ACTIONS(732),
    [anon_sym_throw] = ACTIONS(732),
    [anon_sym_try] = ACTIONS(732),
    [anon_sym_if] = ACTIONS(732),
    [anon_sym_else] = ACTIONS(732),
    [anon_sym_for] = ACTIONS(732),
    [anon_sym_AT] = ACTIONS(732),
    [anon_sym_open] = ACTIONS(732),
    [anon_sym_module] = ACTIONS(732),
    [anon_sym_static] = ACTIONS(732),
    [anon_sym_package] = ACTIONS(732),
    [anon_sym_import] = ACTIONS(732),
    [anon_sym_enum] = ACTIONS(732),
    [anon_sym_public] = ACTIONS(732),
    [anon_sym_protected] = ACTIONS(732),
    [anon_sym_private] = ACTIONS(732),
    [anon_sym_abstract] = ACTIONS(732),
    [anon_sym_final] = ACTIONS(732),
    [anon_sym_strictfp] = ACTIONS(732),
    [anon_sym_native] = ACTIONS(732),
    [anon_sym_transient] = ACTIONS(732),
    [anon_sym_volatile] = ACTIONS(732),
    [anon_sym_ATinterface] = ACTIONS(730),
    [anon_sym_interface] = ACTIONS(732),
    [anon_sym_byte] = ACTIONS(732),
    [anon_sym_short] = ACTIONS(732),
    [anon_sym_int] = ACTIONS(732),
    [anon_sym_long] = ACTIONS(732),
    [anon_sym_char] = ACTIONS(732),
    [anon_sym_float] = ACTIONS(732),
    [anon_sym_double] = ACTIONS(732),
    [sym_boolean_type] = ACTIONS(732),
    [sym_void_type] = ACTIONS(732),
    [sym_this] = ACTIONS(732),
    [sym_super] = ACTIONS(732),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [222] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(414),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1043),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1043),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(422),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(424),
    [anon_sym_PLUS] = ACTIONS(426),
    [anon_sym_DASH] = ACTIONS(426),
    [anon_sym_BANG] = ACTIONS(428),
    [anon_sym_TILDE] = ACTIONS(428),
    [anon_sym_PLUS_PLUS] = ACTIONS(430),
    [anon_sym_DASH_DASH] = ACTIONS(430),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(432),
    [anon_sym_module] = ACTIONS(432),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [223] = {
    [ts_builtin_sym_end] = ACTIONS(734),
    [sym_identifier] = ACTIONS(736),
    [sym_decimal_integer_literal] = ACTIONS(736),
    [sym_hex_integer_literal] = ACTIONS(736),
    [sym_octal_integer_literal] = ACTIONS(734),
    [sym_binary_integer_literal] = ACTIONS(734),
    [sym_decimal_floating_point_literal] = ACTIONS(734),
    [sym_hex_floating_point_literal] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_character_literal] = ACTIONS(734),
    [sym_string_literal] = ACTIONS(736),
    [sym_text_block] = ACTIONS(734),
    [sym_null_literal] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(734),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(734),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_PLUS_PLUS] = ACTIONS(734),
    [anon_sym_DASH_DASH] = ACTIONS(734),
    [anon_sym_new] = ACTIONS(736),
    [anon_sym_class] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_RBRACE] = ACTIONS(734),
    [anon_sym_case] = ACTIONS(736),
    [anon_sym_default] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_assert] = ACTIONS(736),
    [anon_sym_do] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_break] = ACTIONS(736),
    [anon_sym_continue] = ACTIONS(736),
    [anon_sym_return] = ACTIONS(736),
    [anon_sym_yield] = ACTIONS(736),
    [anon_sym_synchronized] = ACTIONS(736),
    [anon_sym_throw] = ACTIONS(736),
    [anon_sym_try] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_AT] = ACTIONS(736),
    [anon_sym_open] = ACTIONS(736),
    [anon_sym_module] = ACTIONS(736),
    [anon_sym_static] = ACTIONS(736),
    [anon_sym_package] = ACTIONS(736),
    [anon_sym_import] = ACTIONS(736),
    [anon_sym_enum] = ACTIONS(736),
    [anon_sym_public] = ACTIONS(736),
    [anon_sym_protected] = ACTIONS(736),
    [anon_sym_private] = ACTIONS(736),
    [anon_sym_abstract] = ACTIONS(736),
    [anon_sym_final] = ACTIONS(736),
    [anon_sym_strictfp] = ACTIONS(736),
    [anon_sym_native] = ACTIONS(736),
    [anon_sym_transient] = ACTIONS(736),
    [anon_sym_volatile] = ACTIONS(736),
    [anon_sym_ATinterface] = ACTIONS(734),
    [anon_sym_interface] = ACTIONS(736),
    [anon_sym_byte] = ACTIONS(736),
    [anon_sym_short] = ACTIONS(736),
    [anon_sym_int] = ACTIONS(736),
    [anon_sym_long] = ACTIONS(736),
    [anon_sym_char] = ACTIONS(736),
    [anon_sym_float] = ACTIONS(736),
    [anon_sym_double] = ACTIONS(736),
    [sym_boolean_type] = ACTIONS(736),
    [sym_void_type] = ACTIONS(736),
    [sym_this] = ACTIONS(736),
    [sym_super] = ACTIONS(736),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [224] = {
    [sym__literal] = STATE(366),
    [sym_expression] = STATE(476),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(1043),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_primary_expression] = STATE(347),
    [sym_array_creation_expression] = STATE(366),
    [sym_parenthesized_expression] = STATE(366),
    [sym_class_literal] = STATE(366),
    [sym_object_creation_expression] = STATE(366),
    [sym__unqualified_object_creation_expression] = STATE(372),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(366),
    [sym_method_reference] = STATE(366),
    [sym_switch_expression] = STATE(420),
    [sym__annotation] = STATE(539),
    [sym_marker_annotation] = STATE(539),
    [sym_annotation] = STATE(539),
    [sym__type] = STATE(1035),
    [sym__unannotated_type] = STATE(622),
    [sym_annotated_type] = STATE(632),
    [sym_scoped_type_identifier] = STATE(597),
    [sym_generic_type] = STATE(621),
    [sym_array_type] = STATE(560),
    [sym_integral_type] = STATE(560),
    [sym_floating_point_type] = STATE(560),
    [sym_formal_parameters] = STATE(1043),
    [aux_sym_dimensions_expr_repeat1] = STATE(539),
    [sym_identifier] = ACTIONS(422),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(424),
    [anon_sym_PLUS] = ACTIONS(426),
    [anon_sym_DASH] = ACTIONS(426),
    [anon_sym_BANG] = ACTIONS(428),
    [anon_sym_TILDE] = ACTIONS(428),
    [anon_sym_PLUS_PLUS] = ACTIONS(430),
    [anon_sym_DASH_DASH] = ACTIONS(430),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(432),
    [anon_sym_module] = ACTIONS(432),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTI