#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 6140
#define LARGE_STATE_COUNT 1264
#define SYMBOL_COUNT 345
#define ALIAS_COUNT 6
#define TOKEN_COUNT 153
#define EXTERNAL_TOKEN_COUNT 4
#define FIELD_COUNT 39
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 188

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_type = 6,
  anon_sym_EQ = 7,
  anon_sym_as = 8,
  anon_sym_namespace = 9,
  anon_sym_LBRACE = 10,
  anon_sym_COMMA = 11,
  anon_sym_RBRACE = 12,
  anon_sym_typeof = 13,
  anon_sym_import = 14,
  anon_sym_from = 15,
  anon_sym_var = 16,
  anon_sym_let = 17,
  anon_sym_const = 18,
  anon_sym_BANG = 19,
  anon_sym_else = 20,
  anon_sym_if = 21,
  anon_sym_switch = 22,
  anon_sym_for = 23,
  anon_sym_LPAREN = 24,
  anon_sym_RPAREN = 25,
  anon_sym_await = 26,
  anon_sym_in = 27,
  anon_sym_of = 28,
  anon_sym_while = 29,
  anon_sym_do = 30,
  anon_sym_try = 31,
  anon_sym_with = 32,
  anon_sym_break = 33,
  anon_sym_continue = 34,
  anon_sym_debugger = 35,
  anon_sym_return = 36,
  anon_sym_throw = 37,
  anon_sym_SEMI = 38,
  anon_sym_COLON = 39,
  anon_sym_case = 40,
  anon_sym_catch = 41,
  anon_sym_finally = 42,
  anon_sym_yield = 43,
  anon_sym_LBRACK = 44,
  anon_sym_RBRACK = 45,
  anon_sym_LT = 46,
  anon_sym_GT = 47,
  anon_sym_SLASH = 48,
  sym_jsx_text = 49,
  sym_jsx_identifier = 50,
  anon_sym_DOT = 51,
  anon_sym_class = 52,
  anon_sym_async = 53,
  anon_sym_function = 54,
  anon_sym_EQ_GT = 55,
  anon_sym_QMARK_DOT = 56,
  anon_sym_new = 57,
  anon_sym_PLUS_EQ = 58,
  anon_sym_DASH_EQ = 59,
  anon_sym_STAR_EQ = 60,
  anon_sym_SLASH_EQ = 61,
  anon_sym_PERCENT_EQ = 62,
  anon_sym_CARET_EQ = 63,
  anon_sym_AMP_EQ = 64,
  anon_sym_PIPE_EQ = 65,
  anon_sym_GT_GT_EQ = 66,
  anon_sym_GT_GT_GT_EQ = 67,
  anon_sym_LT_LT_EQ = 68,
  anon_sym_STAR_STAR_EQ = 69,
  anon_sym_AMP_AMP_EQ = 70,
  anon_sym_PIPE_PIPE_EQ = 71,
  anon_sym_QMARK_QMARK_EQ = 72,
  anon_sym_DOT_DOT_DOT = 73,
  anon_sym_QMARK = 74,
  anon_sym_AMP_AMP = 75,
  anon_sym_PIPE_PIPE = 76,
  anon_sym_GT_GT = 77,
  anon_sym_GT_GT_GT = 78,
  anon_sym_LT_LT = 79,
  anon_sym_AMP = 80,
  anon_sym_CARET = 81,
  anon_sym_PIPE = 82,
  anon_sym_PLUS = 83,
  anon_sym_DASH = 84,
  anon_sym_PERCENT = 85,
  anon_sym_STAR_STAR = 86,
  anon_sym_LT_EQ = 87,
  anon_sym_EQ_EQ = 88,
  anon_sym_EQ_EQ_EQ = 89,
  anon_sym_BANG_EQ = 90,
  anon_sym_BANG_EQ_EQ = 91,
  anon_sym_GT_EQ = 92,
  anon_sym_QMARK_QMARK = 93,
  anon_sym_instanceof = 94,
  anon_sym_TILDE = 95,
  anon_sym_void = 96,
  anon_sym_delete = 97,
  anon_sym_PLUS_PLUS = 98,
  anon_sym_DASH_DASH = 99,
  anon_sym_DQUOTE = 100,
  anon_sym_SQUOTE = 101,
  sym_unescaped_double_string_fragment = 102,
  sym_unescaped_single_string_fragment = 103,
  sym_escape_sequence = 104,
  sym_comment = 105,
  anon_sym_BQUOTE = 106,
  anon_sym_DOLLAR_LBRACE = 107,
  anon_sym_SLASH2 = 108,
  sym_regex_pattern = 109,
  sym_regex_flags = 110,
  sym_number = 111,
  sym_private_property_identifier = 112,
  anon_sym_target = 113,
  sym_this = 114,
  sym_super = 115,
  sym_true = 116,
  sym_false = 117,
  sym_null = 118,
  sym_undefined = 119,
  anon_sym_AT = 120,
  anon_sym_static = 121,
  anon_sym_readonly = 122,
  anon_sym_get = 123,
  anon_sym_set = 124,
  anon_sym_declare = 125,
  anon_sym_public = 126,
  anon_sym_private = 127,
  anon_sym_protected = 128,
  anon_sym_module = 129,
  anon_sym_any = 130,
  anon_sym_number = 131,
  anon_sym_boolean = 132,
  anon_sym_string = 133,
  anon_sym_symbol = 134,
  anon_sym_abstract = 135,
  anon_sym_require = 136,
  anon_sym_implements = 137,
  anon_sym_global = 138,
  anon_sym_interface = 139,
  anon_sym_extends = 140,
  anon_sym_enum = 141,
  anon_sym_DASH_QMARK_COLON = 142,
  anon_sym_QMARK_COLON = 143,
  anon_sym_asserts = 144,
  anon_sym_infer = 145,
  anon_sym_is = 146,
  anon_sym_keyof = 147,
  anon_sym_LBRACE_PIPE = 148,
  anon_sym_PIPE_RBRACE = 149,
  sym__automatic_semicolon = 150,
  sym__template_chars = 151,
  sym__function_signature_automatic_semicolon = 152,
  sym_program = 153,
  sym_export_statement = 154,
  sym_export_clause = 155,
  sym__import_export_specifier = 156,
  sym_declaration = 157,
  sym_import = 158,
  sym_import_statement = 159,
  sym_import_clause = 160,
  sym__from_clause = 161,
  sym_namespace_import = 162,
  sym_named_imports = 163,
  sym_expression_statement = 164,
  sym_variable_declaration = 165,
  sym_lexical_declaration = 166,
  sym_variable_declarator = 167,
  sym_statement_block = 168,
  sym_else_clause = 169,
  sym_if_statement = 170,
  sym_switch_statement = 171,
  sym_for_statement = 172,
  sym_for_in_statement = 173,
  sym__for_header = 174,
  sym_while_statement = 175,
  sym_do_statement = 176,
  sym_try_statement = 177,
  sym_with_statement = 178,
  sym_break_statement = 179,
  sym_continue_statement = 180,
  sym_debugger_statement = 181,
  sym_return_statement = 182,
  sym_throw_statement = 183,
  sym_empty_statement = 184,
  sym_labeled_statement = 185,
  sym_switch_body = 186,
  sym_switch_case = 187,
  sym_switch_default = 188,
  sym_catch_clause = 189,
  sym_finally_clause = 190,
  sym_parenthesized_expression = 191,
  sym_expression = 192,
  sym_primary_expression = 193,
  sym_yield_expression = 194,
  sym_object = 195,
  sym_object_pattern = 196,
  sym_assignment_pattern = 197,
  sym_object_assignment_pattern = 198,
  sym_array = 199,
  sym_array_pattern = 200,
  sym_jsx_element = 201,
  sym_jsx_fragment = 202,
  sym_jsx_expression = 203,
  sym_jsx_opening_element = 204,
  sym_nested_identifier = 205,
  sym_jsx_namespace_name = 206,
  sym_jsx_closing_element = 207,
  sym_jsx_self_closing_element = 208,
  sym_jsx_attribute = 209,
  sym_class = 210,
  sym_class_declaration = 211,
  sym_class_heritage = 212,
  sym_function = 213,
  sym_function_declaration = 214,
  sym_generator_function = 215,
  sym_generator_function_declaration = 216,
  sym_arrow_function = 217,
  sym__call_signature = 218,
  sym__formal_parameter = 219,
  sym_call_expression = 220,
  sym_new_expression = 221,
  sym_await_expression = 222,
  sym_member_expression = 223,
  sym_subscript_expression = 224,
  sym_assignment_expression = 225,
  sym__augmented_assignment_lhs = 226,
  sym_augmented_assignment_expression = 227,
  sym__initializer = 228,
  sym__destructuring_pattern = 229,
  sym_spread_element = 230,
  sym_ternary_expression = 231,
  sym_binary_expression = 232,
  sym_unary_expression = 233,
  sym_update_expression = 234,
  sym_sequence_expression = 235,
  sym_string = 236,
  sym_template_string = 237,
  sym_template_substitution = 238,
  sym_regex = 239,
  sym_meta_property = 240,
  sym_arguments = 241,
  sym_decorator = 242,
  sym_decorator_member_expression = 243,
  sym_decorator_call_expression = 244,
  sym_class_body = 245,
  sym_formal_parameters = 246,
  sym_pattern = 247,
  sym_rest_pattern = 248,
  sym_method_definition = 249,
  sym_pair = 250,
  sym_pair_pattern = 251,
  sym__property_name = 252,
  sym_computed_property_name = 253,
  sym_public_field_definition = 254,
  sym_non_null_expression = 255,
  sym_method_signature = 256,
  sym_abstract_method_signature = 257,
  sym_function_signature = 258,
  sym_as_expression = 259,
  sym_import_require_clause = 260,
  sym_implements_clause = 261,
  sym_ambient_declaration = 262,
  sym_abstract_class_declaration = 263,
  sym_module = 264,
  sym_internal_module = 265,
  sym__module = 266,
  sym_import_alias = 267,
  sym_nested_type_identifier = 268,
  sym_interface_declaration = 269,
  sym_extends_clause = 270,
  sym_enum_declaration = 271,
  sym_enum_body = 272,
  sym_enum_assignment = 273,
  sym_type_alias_declaration = 274,
  sym_accessibility_modifier = 275,
  sym_required_parameter = 276,
  sym_optional_parameter = 277,
  sym__parameter_name = 278,
  sym_omitting_type_annotation = 279,
  sym_opting_type_annotation = 280,
  sym_type_annotation = 281,
  sym_asserts = 282,
  sym__type = 283,
  sym_tuple_parameter = 284,
  sym_optional_tuple_parameter = 285,
  sym_optional_type = 286,
  sym_rest_type = 287,
  sym__tuple_type_member = 288,
  sym_constructor_type = 289,
  sym__primary_type = 290,
  sym_infer_type = 291,
  sym_conditional_type = 292,
  sym_generic_type = 293,
  sym_type_predicate = 294,
  sym_type_predicate_annotation = 295,
  sym_type_query = 296,
  sym_index_type_query = 297,
  sym_lookup_type = 298,
  sym_mapped_type_clause = 299,
  sym_literal_type = 300,
  sym__number = 301,
  sym_existential_type = 302,
  sym_flow_maybe_type = 303,
  sym_parenthesized_type = 304,
  sym_predefined_type = 305,
  sym_type_arguments = 306,
  sym_object_type = 307,
  sym_call_signature = 308,
  sym_property_signature = 309,
  sym_type_parameters = 310,
  sym_type_parameter = 311,
  sym_default_type = 312,
  sym_constraint = 313,
  sym_construct_signature = 314,
  sym_index_signature = 315,
  sym_array_type = 316,
  sym_tuple_type = 317,
  sym_readonly_type = 318,
  sym_union_type = 319,
  sym_intersection_type = 320,
  sym_function_type = 321,
  aux_sym_program_repeat1 = 322,
  aux_sym_export_statement_repeat1 = 323,
  aux_sym_export_clause_repeat1 = 324,
  aux_sym_named_imports_repeat1 = 325,
  aux_sym_variable_declaration_repeat1 = 326,
  aux_sym_switch_body_repeat1 = 327,
  aux_sym_object_repeat1 = 328,
  aux_sym_object_pattern_repeat1 = 329,
  aux_sym_array_repeat1 = 330,
  aux_sym_array_pattern_repeat1 = 331,
  aux_sym_jsx_element_repeat1 = 332,
  aux_sym_string_repeat1 = 333,
  aux_sym_string_repeat2 = 334,
  aux_sym_template_string_repeat1 = 335,
  aux_sym_class_body_repeat1 = 336,
  aux_sym_formal_parameters_repeat1 = 337,
  aux_sym__jsx_start_opening_element_repeat1 = 338,
  aux_sym_implements_clause_repeat1 = 339,
  aux_sym_extends_clause_repeat1 = 340,
  aux_sym_enum_body_repeat1 = 341,
  aux_sym_object_type_repeat1 = 342,
  aux_sym_type_parameters_repeat1 = 343,
  aux_sym_tuple_type_repeat1 = 344,
  alias_sym_import_specifier = 345,
  alias_sym_property_identifier = 346,
  alias_sym_shorthand_property_identifier = 347,
  alias_sym_shorthand_property_identifier_pattern = 348,
  alias_sym_statement_identifier = 349,
  alias_sym_type_identifier = 350,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_as] = "as",
  [anon_sym_namespace] = "namespace",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_typeof] = "typeof",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_BANG] = "!",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_with] = "with",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_SEMI] = ";",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SLASH] = "/",
  [sym_jsx_text] = "jsx_text",
  [sym_jsx_identifier] = "identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_new] = "new",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_QMARK] = "\?",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_TILDE] = "~",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [sym_private_property_identifier] = "private_property_identifier",
  [anon_sym_target] = "target",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_readonly] = "readonly",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [anon_sym_declare] = "declare",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_module] = "module",
  [anon_sym_any] = "any",
  [anon_sym_number] = "number",
  [anon_sym_boolean] = "boolean",
  [anon_sym_string] = "string",
  [anon_sym_symbol] = "symbol",
  [anon_sym_abstract] = "abstract",
  [anon_sym_require] = "require",
  [anon_sym_implements] = "implements",
  [anon_sym_global] = "global",
  [anon_sym_interface] = "interface",
  [anon_sym_extends] = "extends",
  [anon_sym_enum] = "enum",
  [anon_sym_DASH_QMARK_COLON] = "-\?:",
  [anon_sym_QMARK_COLON] = "\?:",
  [anon_sym_asserts] = "asserts",
  [anon_sym_infer] = "infer",
  [anon_sym_is] = "is",
  [anon_sym_keyof] = "keyof",
  [anon_sym_LBRACE_PIPE] = "{|",
  [anon_sym_PIPE_RBRACE] = "|}",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "_template_chars",
  [sym__function_signature_automatic_semicolon] = "_function_signature_automatic_semicolon",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_export_clause] = "export_clause",
  [sym__import_export_specifier] = "export_specifier",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_jsx_element] = "jsx_element",
  [sym_jsx_fragment] = "jsx_fragment",
  [sym_jsx_expression] = "jsx_expression",
  [sym_jsx_opening_element] = "jsx_opening_element",
  [sym_nested_identifier] = "nested_identifier",
  [sym_jsx_namespace_name] = "jsx_namespace_name",
  [sym_jsx_closing_element] = "jsx_closing_element",
  [sym_jsx_self_closing_element] = "jsx_self_closing_element",
  [sym_jsx_attribute] = "jsx_attribute",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function] = "function",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym__call_signature] = "_call_signature",
  [sym__formal_parameter] = "_formal_parameter",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_formal_parameters] = "formal_parameters",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [sym_public_field_definition] = "public_field_definition",
  [sym_non_null_expression] = "non_null_expression",
  [sym_method_signature] = "method_signature",
  [sym_abstract_method_signature] = "abstract_method_signature",
  [sym_function_signature] = "function_signature",
  [sym_as_expression] = "as_expression",
  [sym_import_require_clause] = "import_require_clause",
  [sym_implements_clause] = "implements_clause",
  [sym_ambient_declaration] = "ambient_declaration",
  [sym_abstract_class_declaration] = "abstract_class_declaration",
  [sym_module] = "module",
  [sym_internal_module] = "internal_module",
  [sym__module] = "_module",
  [sym_import_alias] = "import_alias",
  [sym_nested_type_identifier] = "nested_type_identifier",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_clause] = "extends_clause",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_assignment] = "enum_assignment",
  [sym_type_alias_declaration] = "type_alias_declaration",
  [sym_accessibility_modifier] = "accessibility_modifier",
  [sym_required_parameter] = "required_parameter",
  [sym_optional_parameter] = "optional_parameter",
  [sym__parameter_name] = "_parameter_name",
  [sym_omitting_type_annotation] = "omitting_type_annotation",
  [sym_opting_type_annotation] = "opting_type_annotation",
  [sym_type_annotation] = "type_annotation",
  [sym_asserts] = "asserts",
  [sym__type] = "_type",
  [sym_tuple_parameter] = "required_parameter",
  [sym_optional_tuple_parameter] = "optional_parameter",
  [sym_optional_type] = "optional_type",
  [sym_rest_type] = "rest_type",
  [sym__tuple_type_member] = "_tuple_type_member",
  [sym_constructor_type] = "constructor_type",
  [sym__primary_type] = "_primary_type",
  [sym_infer_type] = "infer_type",
  [sym_conditional_type] = "conditional_type",
  [sym_generic_type] = "generic_type",
  [sym_type_predicate] = "type_predicate",
  [sym_type_predicate_annotation] = "type_predicate_annotation",
  [sym_type_query] = "type_query",
  [sym_index_type_query] = "index_type_query",
  [sym_lookup_type] = "lookup_type",
  [sym_mapped_type_clause] = "mapped_type_clause",
  [sym_literal_type] = "literal_type",
  [sym__number] = "unary_expression",
  [sym_existential_type] = "existential_type",
  [sym_flow_maybe_type] = "flow_maybe_type",
  [sym_parenthesized_type] = "parenthesized_type",
  [sym_predefined_type] = "predefined_type",
  [sym_type_arguments] = "type_arguments",
  [sym_object_type] = "object_type",
  [sym_call_signature] = "call_signature",
  [sym_property_signature] = "property_signature",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_default_type] = "default_type",
  [sym_constraint] = "constraint",
  [sym_construct_signature] = "construct_signature",
  [sym_index_signature] = "index_signature",
  [sym_array_type] = "array_type",
  [sym_tuple_type] = "tuple_type",
  [sym_readonly_type] = "readonly_type",
  [sym_union_type] = "union_type",
  [sym_intersection_type] = "intersection_type",
  [sym_function_type] = "function_type",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_jsx_element_repeat1] = "jsx_element_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym__jsx_start_opening_element_repeat1] = "_jsx_start_opening_element_repeat1",
  [aux_sym_implements_clause_repeat1] = "implements_clause_repeat1",
  [aux_sym_extends_clause_repeat1] = "extends_clause_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_object_type_repeat1] = "object_type_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [alias_sym_import_specifier] = "import_specifier",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_type_identifier] = "type_identifier",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [sym_jsx_text] = sym_jsx_text,
  [sym_jsx_identifier] = sym_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_unescaped_double_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_unescaped_single_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [sym_private_property_identifier] = sym_private_property_identifier,
  [anon_sym_target] = anon_sym_target,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_readonly] = anon_sym_readonly,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_declare] = anon_sym_declare,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_number] = anon_sym_number,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_symbol] = anon_sym_symbol,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_require] = anon_sym_require,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_DASH_QMARK_COLON] = anon_sym_DASH_QMARK_COLON,
  [anon_sym_QMARK_COLON] = anon_sym_QMARK_COLON,
  [anon_sym_asserts] = anon_sym_asserts,
  [anon_sym_infer] = anon_sym_infer,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_keyof] = anon_sym_keyof,
  [anon_sym_LBRACE_PIPE] = anon_sym_LBRACE_PIPE,
  [anon_sym_PIPE_RBRACE] = anon_sym_PIPE_RBRACE,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym__function_signature_automatic_semicolon] = sym__function_signature_automatic_semicolon,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_export_clause] = sym_export_clause,
  [sym__import_export_specifier] = sym__import_export_specifier,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_jsx_element] = sym_jsx_element,
  [sym_jsx_fragment] = sym_jsx_fragment,
  [sym_jsx_expression] = sym_jsx_expression,
  [sym_jsx_opening_element] = sym_jsx_opening_element,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_jsx_namespace_name] = sym_jsx_namespace_name,
  [sym_jsx_closing_element] = sym_jsx_closing_element,
  [sym_jsx_self_closing_element] = sym_jsx_self_closing_element,
  [sym_jsx_attribute] = sym_jsx_attribute,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function] = sym_function,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym__call_signature] = sym__call_signature,
  [sym__formal_parameter] = sym__formal_parameter,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [sym_public_field_definition] = sym_public_field_definition,
  [sym_non_null_expression] = sym_non_null_expression,
  [sym_method_signature] = sym_method_signature,
  [sym_abstract_method_signature] = sym_abstract_method_signature,
  [sym_function_signature] = sym_function_signature,
  [sym_as_expression] = sym_as_expression,
  [sym_import_require_clause] = sym_import_require_clause,
  [sym_implements_clause] = sym_implements_clause,
  [sym_ambient_declaration] = sym_ambient_declaration,
  [sym_abstract_class_declaration] = sym_abstract_class_declaration,
  [sym_module] = sym_module,
  [sym_internal_module] = sym_internal_module,
  [sym__module] = sym__module,
  [sym_import_alias] = sym_import_alias,
  [sym_nested_type_identifier] = sym_nested_type_identifier,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_clause] = sym_extends_clause,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_assignment] = sym_enum_assignment,
  [sym_type_alias_declaration] = sym_type_alias_declaration,
  [sym_accessibility_modifier] = sym_accessibility_modifier,
  [sym_required_parameter] = sym_required_parameter,
  [sym_optional_parameter] = sym_optional_parameter,
  [sym__parameter_name] = sym__parameter_name,
  [sym_omitting_type_annotation] = sym_omitting_type_annotation,
  [sym_opting_type_annotation] = sym_opting_type_annotation,
  [sym_type_annotation] = sym_type_annotation,
  [sym_asserts] = sym_asserts,
  [sym__type] = sym__type,
  [sym_tuple_parameter] = sym_required_parameter,
  [sym_optional_tuple_parameter] = sym_optional_parameter,
  [sym_optional_type] = sym_optional_type,
  [sym_rest_type] = sym_rest_type,
  [sym__tuple_type_member] = sym__tuple_type_member,
  [sym_constructor_type] = sym_constructor_type,
  [sym__primary_type] = sym__primary_type,
  [sym_infer_type] = sym_infer_type,
  [sym_conditional_type] = sym_conditional_type,
  [sym_generic_type] = sym_generic_type,
  [sym_type_predicate] = sym_type_predicate,
  [sym_type_predicate_annotation] = sym_type_predicate_annotation,
  [sym_type_query] = sym_type_query,
  [sym_index_type_query] = sym_index_type_query,
  [sym_lookup_type] = sym_lookup_type,
  [sym_mapped_type_clause] = sym_mapped_type_clause,
  [sym_literal_type] = sym_literal_type,
  [sym__number] = sym_unary_expression,
  [sym_existential_type] = sym_existential_type,
  [sym_flow_maybe_type] = sym_flow_maybe_type,
  [sym_parenthesized_type] = sym_parenthesized_type,
  [sym_predefined_type] = sym_predefined_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_object_type] = sym_object_type,
  [sym_call_signature] = sym_call_signature,
  [sym_property_signature] = sym_property_signature,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_default_type] = sym_default_type,
  [sym_constraint] = sym_constraint,
  [sym_construct_signature] = sym_construct_signature,
  [sym_index_signature] = sym_index_signature,
  [sym_array_type] = sym_array_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_readonly_type] = sym_readonly_type,
  [sym_union_type] = sym_union_type,
  [sym_intersection_type] = sym_intersection_type,
  [sym_function_type] = sym_function_type,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_jsx_element_repeat1] = aux_sym_jsx_element_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym__jsx_start_opening_element_repeat1] = aux_sym__jsx_start_opening_element_repeat1,
  [aux_sym_implements_clause_repeat1] = aux_sym_implements_clause_repeat1,
  [aux_sym_extends_clause_repeat1] = aux_sym_extends_clause_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_object_type_repeat1] = aux_sym_object_type_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [alias_sym_import_specifier] = alias_sym_import_specifier,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_private_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_symbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_require] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asserts] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_infer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keyof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = false,
    .named = true,
  },
  [sym__function_signature_automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__import_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_opening_element] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_namespace_name] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_self_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym__call_signature] = {
    .visible = false,
    .named = true,
  },
  [sym__formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [sym_public_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_non_null_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_as_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_import_require_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_implements_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_ambient_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_internal_module] = {
    .visible = true,
    .named = true,
  },
  [sym__module] = {
    .visible = false,
    .named = true,
  },
  [sym_import_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_accessibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_required_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_name] = {
    .visible = false,
    .named = true,
  },
  [sym_omitting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_opting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_asserts] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_type] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_type_member] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_type] = {
    .visible = true,
    .named = true,
  },
  [sym__primary_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_infer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_index_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_lookup_type] = {
    .visible = true,
    .named = true,
  },
  [sym_mapped_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = true,
    .named = true,
  },
  [sym_existential_type] = {
    .visible = true,
    .named = true,
  },
  [sym_flow_maybe_type] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type] = {
    .visible = true,
    .named = true,
  },
  [sym_predefined_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_object_type] = {
    .visible = true,
    .named = true,
  },
  [sym_call_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_property_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_default_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_construct_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_index_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_readonly_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__jsx_start_opening_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_implements_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_close_tag = 7,
  field_condition = 8,
  field_consequence = 9,
  field_constructor = 10,
  field_declaration = 11,
  field_decorator = 12,
  field_finalizer = 13,
  field_flags = 14,
  field_function = 15,
  field_handler = 16,
  field_increment = 17,
  field_index = 18,
  field_initializer = 19,
  field_key = 20,
  field_label = 21,
  field_left = 22,
  field_module = 23,
  field_name = 24,
  field_object = 25,
  field_open_tag = 26,
  field_operator = 27,
  field_parameter = 28,
  field_parameters = 29,
  field_pattern = 30,
  field_property = 31,
  field_return_type = 32,
  field_right = 33,
  field_sign = 34,
  field_source = 35,
  field_type = 36,
  field_type_arguments = 37,
  field_type_parameters = 38,
  field_value = 39,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_label] = "label",
  [field_left] = "left",
  [field_module] = "module",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_sign] = "sign",
  [field_source] = "source",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 2},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 9, .length = 1},
  [12] = {.index = 10, .length = 1},
  [13] = {.index = 11, .length = 2},
  [14] = {.index = 13, .length = 2},
  [15] = {.index = 15, .length = 2},
  [16] = {.index = 17, .length = 2},
  [17] = {.index = 19, .length = 2},
  [18] = {.index = 21, .length = 2},
  [19] = {.index = 23, .length = 1},
  [20] = {.index = 24, .length = 2},
  [21] = {.index = 26, .length = 1},
  [22] = {.index = 27, .length = 2},
  [23] = {.index = 29, .length = 2},
  [26] = {.index = 31, .length = 2},
  [27] = {.index = 33, .length = 2},
  [28] = {.index = 35, .length = 2},
  [29] = {.index = 37, .length = 2},
  [30] = {.index = 39, .length = 3},
  [31] = {.index = 42, .length = 2},
  [32] = {.index = 44, .length = 2},
  [33] = {.index = 46, .length = 2},
  [34] = {.index = 48, .length = 2},
  [35] = {.index = 50, .length = 2},
  [36] = {.index = 52, .length = 1},
  [37] = {.index = 53, .length = 1},
  [38] = {.index = 54, .length = 1},
  [39] = {.index = 55, .length = 1},
  [40] = {.index = 56, .length = 2},
  [41] = {.index = 58, .length = 2},
  [43] = {.index = 60, .length = 1},
  [44] = {.index = 61, .length = 2},
  [45] = {.index = 63, .length = 4},
  [46] = {.index = 67, .length = 2},
  [47] = {.index = 69, .length = 2},
  [48] = {.index = 24, .length = 2},
  [49] = {.index = 27, .length = 2},
  [50] = {.index = 56, .length = 2},
  [51] = {.index = 71, .length = 3},
  [52] = {.index = 74, .length = 2},
  [53] = {.index = 74, .length = 2},
  [54] = {.index = 76, .length = 3},
  [55] = {.index = 79, .length = 2},
  [56] = {.index = 81, .length = 2},
  [57] = {.index = 83, .length = 4},
  [58] = {.index = 87, .length = 3},
  [59] = {.index = 90, .length = 2},
  [60] = {.index = 92, .length = 2},
  [61] = {.index = 94, .length = 1},
  [62] = {.index = 95, .length = 1},
  [63] = {.index = 96, .length = 1},
  [64] = {.index = 97, .length = 2},
  [65] = {.index = 24, .length = 2},
  [66] = {.index = 99, .length = 2},
  [67] = {.index = 101, .length = 5},
  [68] = {.index = 97, .length = 2},
  [69] = {.index = 106, .length = 1},
  [70] = {.index = 107, .length = 2},
  [71] = {.index = 109, .length = 3},
  [72] = {.index = 112, .length = 2},
  [73] = {.index = 114, .length = 3},
  [74] = {.index = 117, .length = 3},
  [75] = {.index = 120, .length = 2},
  [76] = {.index = 122, .length = 3},
  [77] = {.index = 125, .length = 2},
  [78] = {.index = 127, .length = 2},
  [79] = {.index = 129, .length = 2},
  [80] = {.index = 131, .length = 2},
  [81] = {.index = 133, .length = 4},
  [82] = {.index = 137, .length = 2},
  [83] = {.index = 139, .length = 3},
  [84] = {.index = 142, .length = 3},
  [85] = {.index = 145, .length = 2},
  [86] = {.index = 147, .length = 2},
  [87] = {.index = 149, .length = 4},
  [88] = {.index = 147, .length = 2},
  [89] = {.index = 153, .length = 4},
  [90] = {.index = 157, .length = 4},
  [91] = {.index = 161, .length = 5},
  [92] = {.index = 166, .length = 3},
  [93] = {.index = 112, .length = 2},
  [94] = {.index = 169, .length = 2},
  [95] = {.index = 171, .length = 3},
  [96] = {.index = 174, .length = 2},
  [97] = {.index = 176, .length = 3},
  [98] = {.index = 179, .length = 2},
  [99] = {.index = 181, .length = 3},
  [100] = {.index = 184, .length = 2},
  [101] = {.index = 186, .length = 2},
  [102] = {.index = 188, .length = 5},
  [103] = {.index = 193, .length = 1},
  [104] = {.index = 194, .length = 2},
  [105] = {.index = 196, .length = 2},
  [106] = {.index = 198, .length = 3},
  [107] = {.index = 201, .length = 1},
  [108] = {.index = 202, .length = 2},
  [109] = {.index = 204, .length = 2},
  [110] = {.index = 206, .length = 2},
  [111] = {.index = 208, .length = 4},
  [112] = {.index = 212, .length = 3},
  [113] = {.index = 215, .length = 2},
  [114] = {.index = 217, .length = 4},
  [115] = {.index = 221, .length = 4},
  [116] = {.index = 225, .length = 5},
  [117] = {.index = 230, .length = 2},
  [118] = {.index = 232, .length = 3},
  [119] = {.index = 235, .length = 1},
  [120] = {.index = 236, .length = 2},
  [121] = {.index = 238, .length = 3},
  [122] = {.index = 241, .length = 2},
  [123] = {.index = 243, .length = 3},
  [124] = {.index = 246, .length = 4},
  [125] = {.index = 250, .length = 3},
  [126] = {.index = 253, .length = 3},
  [127] = {.index = 256, .length = 2},
  [128] = {.index = 258, .length = 3},
  [129] = {.index = 261, .length = 5},
  [130] = {.index = 266, .length = 2},
  [131] = {.index = 266, .length = 2},
  [132] = {.index = 268, .length = 3},
  [133] = {.index = 271, .length = 4},
  [134] = {.index = 275, .length = 2},
  [135] = {.index = 277, .length = 2},
  [136] = {.index = 279, .length = 2},
  [137] = {.index = 281, .length = 2},
  [138] = {.index = 283, .length = 3},
  [139] = {.index = 286, .length = 1},
  [140] = {.index = 287, .length = 3},
  [141] = {.index = 290, .length = 5},
  [142] = {.index = 295, .length = 3},
  [143] = {.index = 298, .length = 4},
  [144] = {.index = 302, .length = 3},
  [145] = {.index = 305, .length = 4},
  [146] = {.index = 309, .length = 5},
  [147] = {.index = 314, .length = 2},
  [148] = {.index = 316, .length = 4},
  [149] = {.index = 320, .length = 2},
  [150] = {.index = 322, .length = 4},
  [151] = {.index = 326, .length = 4},
  [152] = {.index = 330, .length = 2},
  [153] = {.index = 332, .length = 2},
  [154] = {.index = 334, .length = 3},
  [155] = {.index = 337, .length = 3},
  [156] = {.index = 340, .length = 2},
  [157] = {.index = 342, .length = 2},
  [158] = {.index = 344, .length = 1},
  [160] = {.index = 345, .length = 4},
  [161] = {.index = 349, .length = 5},
  [162] = {.index = 354, .length = 5},
  [163] = {.index = 359, .length = 3},
  [165] = {.index = 362, .length = 1},
  [166] = {.index = 363, .length = 4},
  [167] = {.index = 367, .length = 4},
  [168] = {.index = 371, .length = 3},
  [169] = {.index = 374, .length = 2},
  [170] = {.index = 376, .length = 2},
  [171] = {.index = 378, .length = 3},
  [172] = {.index = 381, .length = 2},
  [173] = {.index = 383, .length = 2},
  [174] = {.index = 385, .length = 5},
  [175] = {.index = 390, .length = 5},
  [176] = {.index = 395, .length = 4},
  [178] = {.index = 399, .length = 3},
  [179] = {.index = 402, .length = 2},
  [180] = {.index = 404, .length = 2},
  [181] = {.index = 406, .length = 3},
  [182] = {.index = 409, .length = 4},
  [183] = {.index = 413, .length = 4},
  [184] = {.index = 417, .length = 5},
  [185] = {.index = 362, .length = 1},
  [186] = {.index = 422, .length = 3},
  [187] = {.index = 425, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_parameters, 0},
  [2] =
    {field_declaration, 1},
  [3] =
    {field_name, 0},
  [4] =
    {field_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [6] =
    {field_argument, 1},
    {field_operator, 0},
  [8] =
    {field_decorator, 0, .inherited = true},
  [9] =
    {field_body, 1},
  [10] =
    {field_constructor, 1},
  [11] =
    {field_argument, 0},
    {field_operator, 1},
  [13] =
    {field_arguments, 1},
    {field_function, 0},
  [15] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [17] =
    {field_parameters, 0},
    {field_return_type, 1},
  [19] =
    {field_parameters, 1},
    {field_type_parameters, 0},
  [21] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [23] =
    {field_declaration, 2},
  [24] =
    {field_left, 0},
    {field_right, 2},
  [26] =
    {field_label, 0},
  [27] =
    {field_body, 2},
    {field_parameter, 0},
  [29] =
    {field_body, 1},
    {field_name, 0},
  [31] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [33] =
    {field_name, 0},
    {field_type, 1},
  [35] =
    {field_condition, 1},
    {field_consequence, 2},
  [37] =
    {field_body, 2},
    {field_value, 1},
  [39] =
    {field_body, 2},
    {field_left, 1, .inherited = true},
    {field_right, 1, .inherited = true},
  [42] =
    {field_decorator, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [44] =
    {field_body, 2},
    {field_condition, 1},
  [46] =
    {field_body, 1},
    {field_handler, 2},
  [48] =
    {field_body, 1},
    {field_finalizer, 2},
  [50] =
    {field_body, 2},
    {field_object, 1},
  [52] =
    {field_label, 1},
  [53] =
    {field_name, 1},
  [54] =
    {field_attribute, 0},
  [55] =
    {field_pattern, 1},
  [56] =
    {field_body, 2},
    {field_name, 1},
  [58] =
    {field_argument, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
  [60] =
    {field_body, 2},
  [61] =
    {field_body, 2},
    {field_type_parameters, 1},
  [63] =
    {field_body, 2},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [67] =
    {field_arguments, 2},
    {field_constructor, 1},
  [69] =
    {field_constructor, 1},
    {field_type_arguments, 2},
  [71] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [74] =
    {field_object, 0},
    {field_property, 2},
  [76] =
    {field_arguments, 2},
    {field_function, 0},
    {field_type_arguments, 1},
  [79] =
    {field_arguments, 2},
    {field_function, 0},
  [81] =
    {field_close_tag, 2},
    {field_open_tag, 0},
  [83] =
    {field_body, 2},
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [87] =
    {field_parameters, 1},
    {field_return_type, 2},
    {field_type_parameters, 0},
  [90] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [92] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [94] =
    {field_source, 1},
  [95] =
    {field_source, 2, .inherited = true},
  [96] =
    {field_value, 2},
  [97] =
    {field_alias, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [99] =
    {field_key, 0},
    {field_value, 2},
  [101] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [106] =
    {field_value, 1},
  [107] =
    {field_name, 0},
    {field_type, 2},
  [109] =
    {field_name, 0},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [112] =
    {field_body, 3},
    {field_name, 2},
  [114] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [117] =
    {field_body, 3},
    {field_left, 2, .inherited = true},
    {field_right, 2, .inherited = true},
  [120] =
    {field_decorator, 0, .inherited = true},
    {field_value, 2, .inherited = true},
  [122] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [125] =
    {field_attribute, 2, .inherited = true},
    {field_name, 1},
  [127] =
    {field_attribute, 0, .inherited = true},
    {field_attribute, 1, .inherited = true},
  [129] =
    {field_name, 1},
    {field_type_arguments, 2},
  [131] =
    {field_flags, 3},
    {field_pattern, 1},
  [133] =
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [137] =
    {field_body, 3},
    {field_name, 1},
  [139] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [142] =
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [145] =
    {field_body, 3},
    {field_type_parameters, 1},
  [147] =
    {field_body, 3},
    {field_parameter, 1},
  [149] =
    {field_body, 3},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [153] =
    {field_body, 3},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [157] =
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [161] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [166] =
    {field_arguments, 3},
    {field_constructor, 1},
    {field_type_arguments, 2},
  [169] =
    {field_index, 2},
    {field_object, 0},
  [171] =
    {field_arguments, 3},
    {field_function, 0},
    {field_type_arguments, 2},
  [174] =
    {field_declaration, 3},
    {field_decorator, 0, .inherited = true},
  [176] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [179] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [181] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [184] =
    {field_alias, 2},
    {field_name, 0},
  [186] =
    {field_name, 1},
    {field_value, 3},
  [188] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [193] =
    {field_source, 3, .inherited = true},
  [194] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3, .inherited = true},
  [196] =
    {field_body, 1},
    {field_condition, 3},
  [198] =
    {field_attribute, 3, .inherited = true},
    {field_name, 1},
    {field_type_arguments, 2},
  [201] =
    {field_name, 2},
  [202] =
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [204] =
    {field_name, 1},
    {field_type, 2},
  [206] =
    {field_name, 0},
    {field_value, 2, .inherited = true},
  [208] =
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [212] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [215] =
    {field_module, 0},
    {field_name, 2},
  [217] =
    {field_body, 4},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [221] =
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [225] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [230] =
    {field_body, 4},
    {field_name, 2},
  [232] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [235] =
    {field_value, 1, .inherited = true},
  [236] =
    {field_index, 3},
    {field_object, 0},
  [238] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [241] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [243] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [246] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [250] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [253] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [256] =
    {field_alias, 3},
    {field_name, 1},
  [258] =
    {field_name, 1},
    {field_type_parameters, 2},
    {field_value, 4},
  [261] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [266] =
    {field_left, 1},
    {field_right, 3},
  [268] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [271] =
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [275] =
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [277] =
    {field_name, 2},
    {field_type, 3},
  [279] =
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [281] =
    {field_name, 1},
    {field_type, 3},
  [283] =
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [286] =
    {field_name, 3},
  [287] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [290] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [295] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [298] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [302] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [305] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [309] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [314] =
    {field_left, 2},
    {field_right, 4},
  [316] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [320] =
    {field_body, 4},
    {field_parameter, 2},
  [322] =
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [326] =
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [330] =
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [332] =
    {field_name, 2},
    {field_type, 4},
  [334] =
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [337] =
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [340] =
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [342] =
    {field_name, 3},
    {field_type, 4},
  [344] =
    {field_name, 4},
  [345] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [349] =
    {field_body, 6},
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [354] =
    {field_body, 6},
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [359] =
    {field_body, 5},
    {field_parameter, 2},
    {field_type, 3},
  [362] =
    {field_sign, 0},
  [363] =
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [367] =
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [371] =
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [374] =
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [376] =
    {field_name, 3},
    {field_type, 5},
  [378] =
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [381] =
    {field_name, 4},
    {field_value, 5, .inherited = true},
  [383] =
    {field_name, 4},
    {field_type, 5},
  [385] =
    {field_body, 7},
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [390] =
    {field_body, 7},
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [395] =
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [399] =
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [402] =
    {field_name, 4},
    {field_value, 6, .inherited = true},
  [404] =
    {field_name, 4},
    {field_type, 6},
  [406] =
    {field_name, 4},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [409] =
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [413] =
    {field_alternative, 6},
    {field_consequence, 4},
    {field_left, 0},
    {field_right, 2},
  [417] =
    {field_body, 8},
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [422] =
    {field_name, 4},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [425] =
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [7] = {
    [0] = alias_sym_property_identifier,
  },
  [11] = {
    [0] = alias_sym_type_identifier,
  },
  [20] = {
    [0] = sym_identifier,
  },
  [21] = {
    [0] = alias_sym_statement_identifier,
  },
  [22] = {
    [0] = sym_identifier,
  },
  [24] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [25] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [36] = {
    [1] = alias_sym_statement_identifier,
  },
  [40] = {
    [1] = alias_sym_type_identifier,
  },
  [42] = {
    [1] = alias_sym_type_identifier,
  },
  [52] = {
    [2] = alias_sym_property_identifier,
  },
  [65] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [68] = {
    [1] = alias_sym_import_specifier,
  },
  [82] = {
    [1] = alias_sym_type_identifier,
  },
  [83] = {
    [1] = alias_sym_type_identifier,
  },
  [86] = {
    [1] = sym_identifier,
  },
  [93] = {
    [2] = alias_sym_type_identifier,
  },
  [97] = {
    [2] = alias_sym_type_identifier,
  },
  [101] = {
    [1] = alias_sym_type_identifier,
  },
  [112] = {
    [1] = alias_sym_type_identifier,
  },
  [113] = {
    [2] = alias_sym_type_identifier,
  },
  [117] = {
    [2] = alias_sym_type_identifier,
  },
  [118] = {
    [2] = alias_sym_type_identifier,
  },
  [123] = {
    [2] = alias_sym_type_identifier,
  },
  [124] = {
    [2] = alias_sym_type_identifier,
  },
  [126] = {
    [3] = alias_sym_type_identifier,
  },
  [128] = {
    [1] = alias_sym_type_identifier,
  },
  [130] = {
    [1] = sym_identifier,
  },
  [142] = {
    [2] = alias_sym_type_identifier,
  },
  [143] = {
    [2] = alias_sym_type_identifier,
  },
  [144] = {
    [3] = alias_sym_type_identifier,
  },
  [145] = {
    [3] = alias_sym_type_identifier,
  },
  [159] = {
    [3] = alias_sym_property_identifier,
  },
  [160] = {
    [3] = alias_sym_type_identifier,
  },
  [164] = {
    [1] = sym_identifier,
  },
  [177] = {
    [2] = sym_identifier,
  },
  [185] = {
    [3] = sym_identifier,
  },
};

static uint16_t ts_non_terminal_alias_map[] = {
  sym__import_export_specifier, 2,
    sym__import_export_specifier,
    alias_sym_import_specifier,
  0,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < '`'
    ? (c < '%'
      ? (c < 0
        ? c == 0
        : c <= '#')
      : (c <= '/' || (c < '['
        ? (c >= ':' && c <= '@')
        : c <= '^')))
    : (c <= '`' || (c < 8203
      ? (c < 160
        ? (c >= '{' && c <= '~')
        : c <= 160)
      : (c <= 8203 || (c < 65279
        ? c == 8288
        : c <= 65279)))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < '`'
    ? (c < '%'
      ? (c < 0
        ? c == 0
        : c <= '#')
      : (c <= '/' || (c < '['
        ? (c >= ':' && c <= '@')
        : c <= '^')))
    : (c <= '~' || (c < 8288
      ? (c < 8203
        ? c == 160
        : c <= 8203)
      : (c <= 8288 || c == 65279))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < '`'
    ? (c < '%'
      ? (c < 0
        ? c == 0
        : c <= '#')
      : (c <= '/' || (c < '['
        ? (c >= ':' && c <= '@')
        : c <= '^')))
    : (c <= '`' || (c < 8203
      ? (c < 160
        ? (c >= '|' && c <= '~')
        : c <= 160)
      : (c <= 8203 || (c < 65279
        ? c == 8288
        : c <= 65279)))));
}

static inline bool sym_private_property_identifier_character_set_1(int32_t c) {
  return (c < '{'
    ? (c < '%'
      ? (c < 0
        ? c == 0
        : c <= '#')
      : (c <= '@' || (c < '`'
        ? (c >= '[' && c <= '^')
        : c <= '`')))
    : (c <= '~' || (c < 8288
      ? (c < 8203
        ? c == 160
        : c <= 8203)
      : (c <= 8288 || c == 65279))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(76);
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(179);
      if (lookahead == '#') ADVANCE(9);
      if (lookahead == '$') ADVANCE(216);
      if (lookahead == '%') ADVANCE(165);
      if (lookahead == '&') ADVANCE(148);
      if (lookahead == '\'') ADVANCE(180);
      if (lookahead == '(') ADVANCE(91);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == '*') ADVANCE(79);
      if (lookahead == '+') ADVANCE(159);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(163);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(206);
      if (lookahead == ':') ADVANCE(94);
      if (lookahead == ';') ADVANCE(93);
      if (lookahead == '<') ADVANCE(98);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(101);
      if (lookahead == '?') ADVANCE(135);
      if (lookahead == '@') ADVANCE(219);
      if (lookahead == '[') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead == ']') ADVANCE(96);
      if (lookahead == '^') ADVANCE(151);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead == '{') ADVANCE(86);
      if (lookahead == '|') ADVANCE(153);
      if (lookahead == '}') ADVANCE(88);
      if (lookahead == '~') ADVANCE(176);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(73)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(207);
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(217);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(25)
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '[') ADVANCE(32);
      if (lookahead == '\\') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(202);
      if (lookahead != 0) ADVANCE(203);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(179);
      if (lookahead == '#') ADVANCE(31);
      if (lookahead == '%') ADVANCE(165);
      if (lookahead == '&') ADVANCE(148);
      if (lookahead == '\'') ADVANCE(180);
      if (lookahead == '(') ADVANCE(91);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == '*') ADVANCE(79);
      if (lookahead == '+') ADVANCE(159);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(162);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(104);
      if (lookahead == '0') ADVANCE(206);
      if (lookahead == ':') ADVANCE(94);
      if (lookahead == ';') ADVANCE(93);
      if (lookahead == '<') ADVANCE(98);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(101);
      if (lookahead == '?') ADVANCE(135);
      if (lookahead == '@') ADVANCE(219);
      if (lookahead == '[') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == ']') ADVANCE(96);
      if (lookahead == '^') ADVANCE(151);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead == '{') ADVANCE(86);
      if (lookahead == '|') ADVANCE(153);
      if (lookahead == '}') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(2)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(207);
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '~') ADVANCE(217);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(179);
      if (lookahead == '%') ADVANCE(165);
      if (lookahead == '&') ADVANCE(148);
      if (lookahead == '\'') ADVANCE(180);
      if (lookahead == '(') ADVANCE(91);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == '*') ADVANCE(79);
      if (lookahead == '+') ADVANCE(159);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(162);
      if (lookahead == '.') ADVANCE(113);
      if (lookahead == '/') ADVANCE(104);
      if (lookahead == ':') ADVANCE(94);
      if (lookahead == ';') ADVANCE(93);
      if (lookahead == '<') ADVANCE(98);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(101);
      if (lookahead == '?') ADVANCE(135);
      if (lookahead == '@') ADVANCE(219);
      if (lookahead == '[') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == ']') ADVANCE(96);
      if (lookahead == '^') ADVANCE(151);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(153);
      if (lookahead == '}') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(3)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '~') ADVANCE(217);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(179);
      if (lookahead == '%') ADVANCE(164);
      if (lookahead == '&') ADVANCE(149);
      if (lookahead == '\'') ADVANCE(180);
      if (lookahead == '(') ADVANCE(91);
      if (lookahead == '*') ADVANCE(80);
      if (lookahead == '+') ADVANCE(158);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(115);
      if (lookahead == '/') ADVANCE(103);
      if (lookahead == '0') ADVANCE(206);
      if (lookahead == '<') ADVANCE(99);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(102);
      if (lookahead == '?') ADVANCE(136);
      if (lookahead == '@') ADVANCE(219);
      if (lookahead == '[') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == '^') ADVANCE(150);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead == '{') ADVANCE(86);
      if (lookahead == '|') ADVANCE(154);
      if (lookahead == '~') ADVANCE(176);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(207);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < ')' || ';' < lookahead) &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(217);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '%') ADVANCE(164);
      if (lookahead == '&') ADVANCE(149);
      if (lookahead == '(') ADVANCE(91);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == '*') ADVANCE(80);
      if (lookahead == '+') ADVANCE(158);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(112);
      if (lookahead == '/') ADVANCE(103);
      if (lookahead == ':') ADVANCE(94);
      if (lookahead == ';') ADVANCE(93);
      if (lookahead == '<') ADVANCE(99);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(102);
      if (lookahead == '?') ADVANCE(136);
      if (lookahead == '[') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == ']') ADVANCE(96);
      if (lookahead == '^') ADVANCE(150);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(155);
      if (lookahead == '}') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(6)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(217);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '%') ADVANCE(164);
      if (lookahead == '&') ADVANCE(149);
      if (lookahead == '(') ADVANCE(91);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == '*') ADVANCE(80);
      if (lookahead == '+') ADVANCE(158);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(112);
      if (lookahead == '/') ADVANCE(103);
      if (lookahead == ':') ADVANCE(94);
      if (lookahead == ';') ADVANCE(93);
      if (lookahead == '<') ADVANCE(99);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(102);
      if (lookahead == '?') ADVANCE(136);
      if (lookahead == '[') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == ']') ADVANCE(96);
      if (lookahead == '^') ADVANCE(150);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(155);
      if (lookahead == '}') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(6)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(217);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '%') ADVANCE(164);
      if (lookahead == '&') ADVANCE(149);
      if (lookahead == '(') ADVANCE(91);
      if (lookahead == '*') ADVANCE(80);
      if (lookahead == '+') ADVANCE(158);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(112);
      if (lookahead == '/') ADVANCE(103);
      if (lookahead == '<') ADVANCE(99);
      if (lookahead == '=') ADVANCE(29);
      if (lookahead == '>') ADVANCE(102);
      if (lookahead == '?') ADVANCE(136);
      if (lookahead == '[') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == '^') ADVANCE(150);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead == '{') ADVANCE(86);
      if (lookahead == '|') ADVANCE(154);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(8)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != ']' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(217);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '%') ADVANCE(164);
      if (lookahead == '&') ADVANCE(149);
      if (lookahead == '(') ADVANCE(91);
      if (lookahead == '*') ADVANCE(80);
      if (lookahead == '+') ADVANCE(158);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(112);
      if (lookahead == '/') ADVANCE(103);
      if (lookahead == '<') ADVANCE(99);
      if (lookahead == '=') ADVANCE(29);
      if (lookahead == '>') ADVANCE(102);
      if (lookahead == '?') ADVANCE(136);
      if (lookahead == '[') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == '^') ADVANCE(150);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead == '{') ADVANCE(86);
      if (lookahead == '|') ADVANCE(154);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(8)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != ']' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(217);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(77);
      if (lookahead == '\\') ADVANCE(34);
      if (!sym_private_property_identifier_character_set_1(lookahead)) ADVANCE(218);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '"') ADVANCE(179);
      if (lookahead == '&') ADVANCE(147);
      if (lookahead == '\'') ADVANCE(180);
      if (lookahead == '(') ADVANCE(91);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '+') ADVANCE(158);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(103);
      if (lookahead == '0') ADVANCE(206);
      if (lookahead == '<') ADVANCE(97);
      if (lookahead == '?') ADVANCE(134);
      if (lookahead == '@') ADVANCE(219);
      if (lookahead == '[') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == ']') ADVANCE(96);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead == '{') ADVANCE(86);
      if (lookahead == '|') ADVANCE(152);
      if (lookahead == '~') ADVANCE(176);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(10)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(207);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '>' < lookahead) &&
          lookahead != '^' &&
          lookahead != '}') ADVANCE(217);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(179);
      if (lookahead == '#') ADVANCE(31);
      if (lookahead == '&') ADVANCE(147);
      if (lookahead == '\'') ADVANCE(180);
      if (lookahead == '(') ADVANCE(91);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '+') ADVANCE(157);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(206);
      if (lookahead == ':') ADVANCE(94);
      if (lookahead == ';') ADVANCE(93);
      if (lookahead == '<') ADVANCE(97);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '>') ADVANCE(100);
      if (lookahead == '?') ADVANCE(134);
      if (lookahead == '@') ADVANCE(219);
      if (lookahead == '[') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == ']') ADVANCE(96);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead == '{') ADVANCE(86);
      if (lookahead == '|') ADVANCE(156);
      if (lookahead == '}') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(12)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(207);
      if (lookahead != 0 &&
          lookahead > '!' &&
          lookahead != '%' &&
          lookahead != '^' &&
          lookahead != '~') ADVANCE(217);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(179);
      if (lookahead == '#') ADVANCE(31);
      if (lookahead == '&') ADVANCE(147);
      if (lookahead == '\'') ADVANCE(180);
      if (lookahead == '(') ADVANCE(91);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '+') ADVANCE(157);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '0') ADVANCE(206);
      if (lookahead == ':') ADVANCE(94);
      if (lookahead == ';') ADVANCE(93);
      if (lookahead == '<') ADVANCE(97);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '>') ADVANCE(100);
      if (lookahead == '?') ADVANCE(134);
      if (lookahead == '@') ADVANCE(219);
      if (lookahead == '[') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == ']') ADVANCE(96);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead == '{') ADVANCE(86);
      if (lookahead == '|') ADVANCE(156);
      if (lookahead == '}') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(12)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(207);
      if (lookahead != 0 &&
          lookahead > '!' &&
          lookahead != '%' &&
          lookahead != '^' &&
          lookahead != '~') ADVANCE(217);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(179);
      if (lookahead == '#') ADVANCE(31);
      if (lookahead == '\'') ADVANCE(180);
      if (lookahead == '(') ADVANCE(91);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '0') ADVANCE(206);
      if (lookahead == ';') ADVANCE(93);
      if (lookahead == '<') ADVANCE(97);
      if (lookahead == '@') ADVANCE(219);
      if (lookahead == '[') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(45);
      if (lookahead == '}') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(13)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(207);
      if (lookahead != 0 &&
          lookahead > '!' &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != ']' &&
          lookahead != '^' &&
          lookahead != '`' &&
          lookahead != '~') ADVANCE(217);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(179);
      if (lookahead == '&') ADVANCE(147);
      if (lookahead == '\'') ADVANCE(180);
      if (lookahead == '(') ADVANCE(91);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '+') ADVANCE(157);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(51);
      if (lookahead == '/') ADVANCE(103);
      if (lookahead == '0') ADVANCE(206);
      if (lookahead == '<') ADVANCE(97);
      if (lookahead == '>') ADVANCE(100);
      if (lookahead == '?') ADVANCE(134);
      if (lookahead == '[') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == '{') ADVANCE(86);
      if (lookahead == '|') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(14)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(207);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(215);
      if (lookahead != 0 &&
          lookahead > '~') ADVANCE(217);
      END_STATE();
    case 15:
      if (lookahead == '"') ADVANCE(179);
      if (lookahead == '/') ADVANCE(182);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(185);
      if (lookahead != 0) ADVANCE(186);
      END_STATE();
    case 16:
      if (lookahead == '$') ADVANCE(37);
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(17)
      END_STATE();
    case 17:
      if (lookahead == '$') ADVANCE(37);
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(17)
      END_STATE();
    case 18:
      if (lookahead == '&') ADVANCE(147);
      if (lookahead == '(') ADVANCE(91);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(30);
      if (lookahead == '.') ADVANCE(112);
      if (lookahead == '/') ADVANCE(103);
      if (lookahead == ':') ADVANCE(94);
      if (lookahead == '<') ADVANCE(97);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '>') ADVANCE(100);
      if (lookahead == '?') ADVANCE(28);
      if (lookahead == '[') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(18)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(215);
      if (lookahead != 0 &&
          lookahead > '~') ADVANCE(217);
      END_STATE();
    case 19:
      if (lookahead == '\'') ADVANCE(180);
      if (lookahead == '/') ADVANCE(188);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(191);
      if (lookahead != 0) ADVANCE(192);
      END_STATE();
    case 20:
      if (lookahead == '*') ADVANCE(22);
      if (lookahead == '/') ADVANCE(198);
      END_STATE();
    case 21:
      if (lookahead == '*') ADVANCE(21);
      if (lookahead == '/') ADVANCE(197);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 22:
      if (lookahead == '*') ADVANCE(21);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 23:
      if (lookahead == '.') ADVANCE(24);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      END_STATE();
    case 24:
      if (lookahead == '.') ADVANCE(133);
      END_STATE();
    case 25:
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(25)
      END_STATE();
    case 26:
      if (lookahead == '/') ADVANCE(106);
      if (lookahead == '<') ADVANCE(97);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(109);
      if (lookahead != 0 &&
          lookahead != '>' &&
          lookahead != '}') ADVANCE(110);
      END_STATE();
    case 27:
      if (lookahead == ':') ADVANCE(220);
      END_STATE();
    case 28:
      if (lookahead == ':') ADVANCE(221);
      END_STATE();
    case 29:
      if (lookahead == '=') ADVANCE(169);
      END_STATE();
    case 30:
      if (lookahead == '?') ADVANCE(27);
      END_STATE();
    case 31:
      if (lookahead == '\\') ADVANCE(34);
      if (!sym_private_property_identifier_character_set_1(lookahead)) ADVANCE(218);
      END_STATE();
    case 32:
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead == ']') ADVANCE(203);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(32);
      END_STATE();
    case 33:
      if (lookahead == 'u') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(196);
      if (lookahead != 0) ADVANCE(193);
      END_STATE();
    case 34:
      if (lookahead == 'u') ADVANCE(39);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 36:
      if (lookahead == 'u') ADVANCE(41);
      if (lookahead == 'x') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(196);
      if (lookahead != 0) ADVANCE(193);
      END_STATE();
    case 37:
      if (lookahead == '{') ADVANCE(200);
      END_STATE();
    case 38:
      if (lookahead == '{') ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(68);
      END_STATE();
    case 39:
      if (lookahead == '{') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      END_STATE();
    case 40:
      if (lookahead == '{') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(70);
      END_STATE();
    case 41:
      if (lookahead == '{') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(60);
      END_STATE();
    case 42:
      if (lookahead == '}') ADVANCE(217);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 43:
      if (lookahead == '}') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 44:
      if (lookahead == '}') ADVANCE(193);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 45:
      if (lookahead == '}') ADVANCE(223);
      END_STATE();
    case 46:
      if (lookahead == '}') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 47:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(212);
      END_STATE();
    case 48:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(208);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(209);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(207);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(212);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(217);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(218);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(193);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(210);
      END_STATE();
    case 58:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(194);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      END_STATE();
    case 61:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 62:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 63:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 64:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 65:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(59);
      END_STATE();
    case 66:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 67:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 68:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 69:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(66);
      END_STATE();
    case 70:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 71:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(32);
      END_STATE();
    case 72:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(203);
      END_STATE();
    case 73:
      if (eof) ADVANCE(76);
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(179);
      if (lookahead == '#') ADVANCE(9);
      if (lookahead == '$') ADVANCE(216);
      if (lookahead == '%') ADVANCE(165);
      if (lookahead == '&') ADVANCE(148);
      if (lookahead == '\'') ADVANCE(180);
      if (lookahead == '(') ADVANCE(91);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == '*') ADVANCE(79);
      if (lookahead == '+') ADVANCE(159);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(163);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(103);
      if (lookahead == '0') ADVANCE(206);
      if (lookahead == ':') ADVANCE(94);
      if (lookahead == ';') ADVANCE(93);
      if (lookahead == '<') ADVANCE(98);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(101);
      if (lookahead == '?') ADVANCE(135);
      if (lookahead == '@') ADVANCE(219);
      if (lookahead == '[') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == ']') ADVANCE(96);
      if (lookahead == '^') ADVANCE(151);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead == '{') ADVANCE(86);
      if (lookahead == '|') ADVANCE(153);
      if (lookahead == '}') ADVANCE(88);
      if (lookahead == '~') ADVANCE(176);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(73)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(207);
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(217);
      END_STATE();
    case 74:
      if (eof) ADVANCE(76);
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(179);
      if (lookahead == '%') ADVANCE(164);
      if (lookahead == '&') ADVANCE(149);
      if (lookahead == '\'') ADVANCE(180);
      if (lookahead == '(') ADVANCE(91);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == '*') ADVANCE(80);
      if (lookahead == '+') ADVANCE(158);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(115);
      if (lookahead == '/') ADVANCE(103);
      if (lookahead == '0') ADVANCE(206);
      if (lookahead == ':') ADVANCE(94);
      if (lookahead == ';') ADVANCE(93);
      if (lookahead == '<') ADVANCE(99);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(102);
      if (lookahead == '?') ADVANCE(136);
      if (lookahead == '@') ADVANCE(219);
      if (lookahead == '[') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == ']') ADVANCE(96);
      if (lookahead == '^') ADVANCE(150);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(155);
      if (lookahead == '}') ADVANCE(88);
      if (lookahead == '~') ADVANCE(176);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(74)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(207);
      if (lookahead != 0 &&
          lookahead > '#') ADVANCE(217);
      END_STATE();
    case 75:
      if (eof) ADVANCE(76);
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '"') ADVANCE(179);
      if (lookahead == '#') ADVANCE(9);
      if (lookahead == '&') ADVANCE(147);
      if (lookahead == '\'') ADVANCE(180);
      if (lookahead == '(') ADVANCE(91);
      if (lookahead == ')') ADVANCE(92);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '+') ADVANCE(158);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(103);
      if (lookahead == '0') ADVANCE(206);
      if (lookahead == ':') ADVANCE(94);
      if (lookahead == ';') ADVANCE(93);
      if (lookahead == '<') ADVANCE(97);
      if (lookahead == '=') ADVANCE(84);
      if (lookahead == '>') ADVANCE(100);
      if (lookahead == '?') ADVANCE(134);
      if (lookahead == '@') ADVANCE(219);
      if (lookahead == '[') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == ']') ADVANCE(96);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(156);
      if (lookahead == '}') ADVANCE(88);
      if (lookahead == '~') ADVANCE(176);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(75)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(207);
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '%' &&
          lookahead != '^') ADVANCE(217);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(77);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(167);
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(166);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(169);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(169);
      if (lookahead == '>') ADVANCE(116);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(116);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '|') ADVANCE(222);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(171);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(146);
      if (lookahead == '=') ADVANCE(168);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(145);
      if (lookahead == '=') ADVANCE(168);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(173);
      if (lookahead == '>') ADVANCE(141);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(173);
      if (lookahead == '>') ADVANCE(142);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(22);
      if (lookahead == '/') ADVANCE(198);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(22);
      if (lookahead == '/') ADVANCE(198);
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '\n') ADVANCE(110);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(198);
      if (lookahead != 0) ADVANCE(105);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(108);
      if (lookahead == '/') ADVANCE(105);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(110);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '/') ADVANCE(110);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(22);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(22);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '/') ADVANCE(106);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(109);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(110);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(110);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_jsx_identifier);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(111);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(24);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(24);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '?') ADVANCE(175);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '?') ADVANCE(174);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(130);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(131);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(126);
      if (lookahead == '>') ADVANCE(144);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(143);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(128);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(138);
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(137);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(125);
      if (lookahead == '|') ADVANCE(140);
      if (lookahead == '}') ADVANCE(223);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(139);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(139);
      if (lookahead == '}') ADVANCE(223);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '}') ADVANCE(223);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(177);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(177);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(178);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(178);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(178);
      if (lookahead == '=') ADVANCE(119);
      if (lookahead == '?') ADVANCE(27);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(170);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(172);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(132);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '\n') ADVANCE(186);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(181);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '/') ADVANCE(181);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(186);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(183);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(184);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(183);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(184);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(182);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(186);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(186);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '\n') ADVANCE(192);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(187);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(190);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(192);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(189);
      if (lookahead == '/') ADVANCE(192);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(190);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(189);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(190);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '/') ADVANCE(188);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(191);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(192);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(192);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(35);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(217);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(193);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(195);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(198);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      if (lookahead == '*') ADVANCE(22);
      if (lookahead == '/') ADVANCE(198);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(25)
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '[') ADVANCE(32);
      if (lookahead == '\\') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(202);
      if (lookahead != 0) ADVANCE(203);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(32);
      if (lookahead == '\\') ADVANCE(72);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(203);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(35);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      if (!sym_identifier_character_set_2(lookahead)) ADVANCE(217);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(214);
      if (lookahead == '0') ADVANCE(211);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(48);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(47);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(49);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(57);
      if (lookahead == '_') ADVANCE(52);
      if (lookahead == 'n') ADVANCE(205);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(207);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(214);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(47);
      if (lookahead == '_') ADVANCE(50);
      if (lookahead == 'n') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(207);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(205);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(208);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(49);
      if (lookahead == 'n') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(209);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(57);
      if (lookahead == 'n') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(210);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(52);
      if (lookahead == 'n') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(212);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(47);
      if (lookahead == '_') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(111);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(215);
      if (lookahead != 0 &&
          lookahead > '~' &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(217);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == '{') ADVANCE(200);
      if (!sym_identifier_character_set_3(lookahead)) ADVANCE(217);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(35);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(217);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_private_property_identifier);
      if (lookahead == '\\') ADVANCE(34);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(218);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_DASH_QMARK_COLON);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_QMARK_COLON);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_LBRACE_PIPE);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_PIPE_RBRACE);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'k') ADVANCE(9);
      if (lookahead == 'l') ADVANCE(10);
      if (lookahead == 'm') ADVANCE(11);
      if (lookahead == 'n') ADVANCE(12);
      if (lookahead == 'o') ADVANCE(13);
      if (lookahead == 'p') ADVANCE(14);
      if (lookahead == 'r') ADVANCE(15);
      if (lookahead == 's') ADVANCE(16);
      if (lookahead == 't') ADVANCE(17);
      if (lookahead == 'u') ADVANCE(18);
      if (lookahead == 'v') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(23);
      if (lookahead == 's') ADVANCE(24);
      if (lookahead == 'w') ADVANCE(25);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(26);
      if (lookahead == 'r') ADVANCE(27);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(28);
      if (lookahead == 'l') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(33);
      if (lookahead == 'n') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(36);
      if (lookahead == 'i') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(38);
      if (lookahead == 'r') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(41);
      if (lookahead == 'l') ADVANCE(42);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(43);
      if (lookahead == 'm') ADVANCE(44);
      if (lookahead == 'n') ADVANCE(45);
      if (lookahead == 's') ADVANCE(46);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 11:
      if (lookahead == 'o') ADVANCE(49);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(50);
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'u') ADVANCE(52);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(53);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(54);
      if (lookahead == 'u') ADVANCE(55);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(56);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(57);
      if (lookahead == 't') ADVANCE(58);
      if (lookahead == 'u') ADVANCE(59);
      if (lookahead == 'w') ADVANCE(60);
      if (lookahead == 'y') ADVANCE(61);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(62);
      if (lookahead == 'h') ADVANCE(63);
      if (lookahead == 'r') ADVANCE(64);
      if (lookahead == 'y') ADVANCE(65);
      END_STATE();
    case 18:
      if (lookahead == 'n') ADVANCE(66);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(67);
      if (lookahead == 'o') ADVANCE(68);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(69);
      if (lookahead == 'i') ADVANCE(70);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(71);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 23:
      if (lookahead == 'y') ADVANCE(73);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(74);
      if (lookahead == 'y') ADVANCE(75);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(76);
      END_STATE();
    case 26:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(78);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(79);
      if (lookahead == 't') ADVANCE(80);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(81);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(82);
      END_STATE();
    case 31:
      if (lookahead == 'b') ADVANCE(83);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'f') ADVANCE(85);
      if (lookahead == 'l') ADVANCE(86);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 33:
      if (lookahead == 's') ADVANCE(87);
      END_STATE();
    case 34:
      if (lookahead == 'u') ADVANCE(88);
      END_STATE();
    case 35:
      if (lookahead == 'p') ADVANCE(89);
      if (lookahead == 't') ADVANCE(90);
      END_STATE();
    case 36:
      if (lookahead == 'l') ADVANCE(91);
      END_STATE();
    case 37:
      if (lookahead == 'n') ADVANCE(92);
      END_STATE();
    case 38:
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 39:
      if (lookahead == 'o') ADVANCE(94);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(95);
      END_STATE();
    case 41:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(97);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 44:
      if (lookahead == 'p') ADVANCE(98);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'f') ADVANCE(99);
      if (lookahead == 's') ADVANCE(100);
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 47:
      if (lookahead == 'y') ADVANCE(102);
      END_STATE();
    case 48:
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 49:
      if (lookahead == 'd') ADVANCE(104);
      END_STATE();
    case 50:
      if (lookahead == 'm') ADVANCE(105);
      END_STATE();
    case 51:
      if (lookahead == 'w') ADVANCE(106);
      END_STATE();
    case 52:
      if (lookahead == 'l') ADVANCE(107);
      if (lookahead == 'm') ADVANCE(108);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(109);
      if (lookahead == 'o') ADVANCE(110);
      END_STATE();
    case 55:
      if (lookahead == 'b') ADVANCE(111);
      END_STATE();
    case 56:
      if (lookahead == 'a') ADVANCE(112);
      if (lookahead == 'q') ADVANCE(113);
      if (lookahead == 't') ADVANCE(114);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(115);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(116);
      if (lookahead == 'r') ADVANCE(117);
      END_STATE();
    case 59:
      if (lookahead == 'p') ADVANCE(118);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(119);
      END_STATE();
    case 61:
      if (lookahead == 'm') ADVANCE(120);
      END_STATE();
    case 62:
      if (lookahead == 'r') ADVANCE(121);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(122);
      if (lookahead == 'r') ADVANCE(123);
      END_STATE();
    case 64:
      if (lookahead == 'u') ADVANCE(124);
      if (lookahead == 'y') ADVANCE(125);
      END_STATE();
    case 65:
      if (lookahead == 'p') ADVANCE(126);
      END_STATE();
    case 66:
      if (lookahead == 'd') ADVANCE(127);
      END_STATE();
    case 67:
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(129);
      END_STATE();
    case 69:
      if (lookahead == 'i') ADVANCE(130);
      END_STATE();
    case 70:
      if (lookahead == 't') ADVANCE(131);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 72:
      if (lookahead == 't') ADVANCE(133);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_any);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(134);
      END_STATE();
    case 75:
      if (lookahead == 'n') ADVANCE(135);
      END_STATE();
    case 76:
      if (lookahead == 'i') ADVANCE(136);
      END_STATE();
    case 77:
      if (lookahead == 'l') ADVANCE(137);
      END_STATE();
    case 78:
      if (lookahead == 'a') ADVANCE(138);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 80:
      if (lookahead == 'c') ADVANCE(140);
      END_STATE();
    case 81:
      if (lookahead == 's') ADVANCE(141);
      END_STATE();
    case 82:
      if (lookahead == 's') ADVANCE(142);
      if (lookahead == 't') ADVANCE(143);
      END_STATE();
    case 83:
      if (lookahead == 'u') ADVANCE(144);
      END_STATE();
    case 84:
      if (lookahead == 'l') ADVANCE(145);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(146);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(147);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 88:
      if (lookahead == 'm') ADVANCE(149);
      END_STATE();
    case 89:
      if (lookahead == 'o') ADVANCE(150);
      END_STATE();
    case 90:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 91:
      if (lookahead == 's') ADVANCE(152);
      END_STATE();
    case 92:
      if (lookahead == 'a') ADVANCE(153);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 94:
      if (lookahead == 'm') ADVANCE(154);
      END_STATE();
    case 95:
      if (lookahead == 'c') ADVANCE(155);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 97:
      if (lookahead == 'b') ADVANCE(156);
      END_STATE();
    case 98:
      if (lookahead == 'l') ADVANCE(157);
      if (lookahead == 'o') ADVANCE(158);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(159);
      END_STATE();
    case 100:
      if (lookahead == 't') ADVANCE(160);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(161);
      END_STATE();
    case 102:
      if (lookahead == 'o') ADVANCE(162);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 104:
      if (lookahead == 'u') ADVANCE(163);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 107:
      if (lookahead == 'l') ADVANCE(165);
      END_STATE();
    case 108:
      if (lookahead == 'b') ADVANCE(166);
      END_STATE();
    case 109:
      if (lookahead == 'v') ADVANCE(167);
      END_STATE();
    case 110:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 111:
      if (lookahead == 'l') ADVANCE(169);
      END_STATE();
    case 112:
      if (lookahead == 'd') ADVANCE(170);
      END_STATE();
    case 113:
      if (lookahead == 'u') ADVANCE(171);
      END_STATE();
    case 114:
      if (lookahead == 'u') ADVANCE(172);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 117:
      if (lookahead == 'i') ADVANCE(174);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 119:
      if (lookahead == 't') ADVANCE(176);
      END_STATE();
    case 120:
      if (lookahead == 'b') ADVANCE(177);
      END_STATE();
    case 121:
      if (lookahead == 'g') ADVANCE(178);
      END_STATE();
    case 122:
      if (lookahead == 's') ADVANCE(179);
      END_STATE();
    case 123:
      if (lookahead == 'o') ADVANCE(180);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(181);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 126:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 127:
      if (lookahead == 'e') ADVANCE(183);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 129:
      if (lookahead == 'd') ADVANCE(184);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(185);
      END_STATE();
    case 131:
      if (lookahead == 'h') ADVANCE(186);
      END_STATE();
    case 132:
      if (lookahead == 'l') ADVANCE(187);
      END_STATE();
    case 133:
      if (lookahead == 'r') ADVANCE(188);
      END_STATE();
    case 134:
      if (lookahead == 'r') ADVANCE(189);
      END_STATE();
    case 135:
      if (lookahead == 'c') ADVANCE(190);
      END_STATE();
    case 136:
      if (lookahead == 't') ADVANCE(191);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(192);
      END_STATE();
    case 138:
      if (lookahead == 'k') ADVANCE(193);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 140:
      if (lookahead == 'h') ADVANCE(194);
      END_STATE();
    case 141:
      if (lookahead == 's') ADVANCE(195);
      END_STATE();
    case 142:
      if (lookahead == 't') ADVANCE(196);
      END_STATE();
    case 143:
      if (lookahead == 'i') ADVANCE(197);
      END_STATE();
    case 144:
      if (lookahead == 'g') ADVANCE(198);
      END_STATE();
    case 145:
      if (lookahead == 'a') ADVANCE(199);
      END_STATE();
    case 146:
      if (lookahead == 'u') ADVANCE(200);
      END_STATE();
    case 147:
      if (lookahead == 't') ADVANCE(201);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 150:
      if (lookahead == 'r') ADVANCE(202);
      END_STATE();
    case 151:
      if (lookahead == 'n') ADVANCE(203);
      END_STATE();
    case 152:
      if (lookahead == 'e') ADVANCE(204);
      END_STATE();
    case 153:
      if (lookahead == 'l') ADVANCE(205);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 155:
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 156:
      if (lookahead == 'a') ADVANCE(207);
      END_STATE();
    case 157:
      if (lookahead == 'e') ADVANCE(208);
      END_STATE();
    case 158:
      if (lookahead == 'r') ADVANCE(209);
      END_STATE();
    case 159:
      if (lookahead == 'r') ADVANCE(210);
      END_STATE();
    case 160:
      if (lookahead == 'a') ADVANCE(211);
      END_STATE();
    case 161:
      if (lookahead == 'r') ADVANCE(212);
      END_STATE();
    case 162:
      if (lookahead == 'f') ADVANCE(213);
      END_STATE();
    case 163:
      if (lookahead == 'l') ADVANCE(214);
      END_STATE();
    case 164:
      if (lookahead == 's') ADVANCE(215);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 166:
      if (lookahead == 'e') ADVANCE(216);
      END_STATE();
    case 167:
      if (lookahead == 'a') ADVANCE(217);
      END_STATE();
    case 168:
      if (lookahead == 'e') ADVANCE(218);
      END_STATE();
    case 169:
      if (lookahead == 'i') ADVANCE(219);
      END_STATE();
    case 170:
      if (lookahead == 'o') ADVANCE(220);
      END_STATE();
    case 171:
      if (lookahead == 'i') ADVANCE(221);
      END_STATE();
    case 172:
      if (lookahead == 'r') ADVANCE(222);
      END_STATE();
    case 173:
      if (lookahead == 'i') ADVANCE(223);
      END_STATE();
    case 174:
      if (lookahead == 'n') ADVANCE(224);
      END_STATE();
    case 175:
      if (lookahead == 'r') ADVANCE(225);
      END_STATE();
    case 176:
      if (lookahead == 'c') ADVANCE(226);
      END_STATE();
    case 177:
      if (lookahead == 'o') ADVANCE(227);
      END_STATE();
    case 178:
      if (lookahead == 'e') ADVANCE(228);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 180:
      if (lookahead == 'w') ADVANCE(229);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == 'o') ADVANCE(230);
      END_STATE();
    case 183:
      if (lookahead == 'f') ADVANCE(231);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 185:
      if (lookahead == 'e') ADVANCE(232);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 187:
      if (lookahead == 'd') ADVANCE(233);
      END_STATE();
    case 188:
      if (lookahead == 'a') ADVANCE(234);
      END_STATE();
    case 189:
      if (lookahead == 't') ADVANCE(235);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 192:
      if (lookahead == 'a') ADVANCE(236);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 197:
      if (lookahead == 'n') ADVANCE(237);
      END_STATE();
    case 198:
      if (lookahead == 'g') ADVANCE(238);
      END_STATE();
    case 199:
      if (lookahead == 'r') ADVANCE(239);
      END_STATE();
    case 200:
      if (lookahead == 'l') ADVANCE(240);
      END_STATE();
    case 201:
      if (lookahead == 'e') ADVANCE(241);
      END_STATE();
    case 202:
      if (lookahead == 't') ADVANCE(242);
      END_STATE();
    case 203:
      if (lookahead == 'd') ADVANCE(243);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 205:
      if (lookahead == 'l') ADVANCE(244);
      END_STATE();
    case 206:
      if (lookahead == 'i') ADVANCE(245);
      END_STATE();
    case 207:
      if (lookahead == 'l') ADVANCE(246);
      END_STATE();
    case 208:
      if (lookahead == 'm') ADVANCE(247);
      END_STATE();
    case 209:
      if (lookahead == 't') ADVANCE(248);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_infer);
      END_STATE();
    case 211:
      if (lookahead == 'n') ADVANCE(249);
      END_STATE();
    case 212:
      if (lookahead == 'f') ADVANCE(250);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_keyof);
      END_STATE();
    case 214:
      if (lookahead == 'e') ADVANCE(251);
      END_STATE();
    case 215:
      if (lookahead == 'p') ADVANCE(252);
      END_STATE();
    case 216:
      if (lookahead == 'r') ADVANCE(253);
      END_STATE();
    case 217:
      if (lookahead == 't') ADVANCE(254);
      END_STATE();
    case 218:
      if (lookahead == 'c') ADVANCE(255);
      END_STATE();
    case 219:
      if (lookahead == 'c') ADVANCE(256);
      END_STATE();
    case 220:
      if (lookahead == 'n') ADVANCE(257);
      END_STATE();
    case 221:
      if (lookahead == 'r') ADVANCE(258);
      END_STATE();
    case 222:
      if (lookahead == 'n') ADVANCE(259);
      END_STATE();
    case 223:
      if (lookahead == 'c') ADVANCE(260);
      END_STATE();
    case 224:
      if (lookahead == 'g') ADVANCE(261);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 226:
      if (lookahead == 'h') ADVANCE(262);
      END_STATE();
    case 227:
      if (lookahead == 'l') ADVANCE(263);
      END_STATE();
    case 228:
      if (lookahead == 't') ADVANCE(264);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 230:
      if (lookahead == 'f') ADVANCE(265);
      END_STATE();
    case 231:
      if (lookahead == 'i') ADVANCE(266);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 234:
      if (lookahead == 'c') ADVANCE(267);
      END_STATE();
    case 235:
      if (lookahead == 's') ADVANCE(268);
      END_STATE();
    case 236:
      if (lookahead == 'n') ADVANCE(269);
      END_STATE();
    case 237:
      if (lookahead == 'u') ADVANCE(270);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(271);
      END_STATE();
    case 239:
      if (lookahead == 'e') ADVANCE(272);
      END_STATE();
    case 240:
      if (lookahead == 't') ADVANCE(273);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 243:
      if (lookahead == 's') ADVANCE(274);
      END_STATE();
    case 244:
      if (lookahead == 'y') ADVANCE(275);
      END_STATE();
    case 245:
      if (lookahead == 'o') ADVANCE(276);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 247:
      if (lookahead == 'e') ADVANCE(277);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 249:
      if (lookahead == 'c') ADVANCE(278);
      END_STATE();
    case 250:
      if (lookahead == 'a') ADVANCE(279);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 252:
      if (lookahead == 'a') ADVANCE(280);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_number);
      END_STATE();
    case 254:
      if (lookahead == 'e') ADVANCE(281);
      END_STATE();
    case 255:
      if (lookahead == 't') ADVANCE(282);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 257:
      if (lookahead == 'l') ADVANCE(283);
      END_STATE();
    case 258:
      if (lookahead == 'e') ADVANCE(284);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_symbol);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 266:
      if (lookahead == 'n') ADVANCE(285);
      END_STATE();
    case 267:
      if (lookahead == 't') ADVANCE(286);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_asserts);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 270:
      if (lookahead == 'e') ADVANCE(287);
      END_STATE();
    case 271:
      if (lookahead == 'r') ADVANCE(288);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 276:
      if (lookahead == 'n') ADVANCE(289);
      END_STATE();
    case 277:
      if (lookahead == 'n') ADVANCE(290);
      END_STATE();
    case 278:
      if (lookahead == 'e') ADVANCE(291);
      END_STATE();
    case 279:
      if (lookahead == 'c') ADVANCE(292);
      END_STATE();
    case 280:
      if (lookahead == 'c') ADVANCE(293);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 282:
      if (lookahead == 'e') ADVANCE(294);
      END_STATE();
    case 283:
      if (lookahead == 'y') ADVANCE(295);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_require);
      END_STATE();
    case 285:
      if (lookahead == 'e') ADVANCE(296);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 290:
      if (lookahead == 't') ADVANCE(297);
      END_STATE();
    case 291:
      if (lookahead == 'o') ADVANCE(298);
      END_STATE();
    case 292:
      if (lookahead == 'e') ADVANCE(299);
      END_STATE();
    case 293:
      if (lookahead == 'e') ADVANCE(300);
      END_STATE();
    case 294:
      if (lookahead == 'd') ADVANCE(301);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 296:
      if (lookahead == 'd') ADVANCE(302);
      END_STATE();
    case 297:
      if (lookahead == 's') ADVANCE(303);
      END_STATE();
    case 298:
      if (lookahead == 'f') ADVANCE(304);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 75},
  [2] = {.lex_state = 75},
  [3] = {.lex_state = 75},
  [4] = {.lex_state = 75},
  [5] = {.lex_state = 75},
  [6] = {.lex_state = 75},
  [7] = {.lex_state = 75},
  [8] = {.lex_state = 75},
  [9] = {.lex_state = 75},
  [10] = {.lex_state = 75},
  [11] = {.lex_state = 75},
  [12] = {.lex_state = 75},
  [13] = {.lex_state = 75},
  [14] = {.lex_state = 75},
  [15] = {.lex_state = 75},
  [16] = {.lex_state = 75},
  [17] = {.lex_state = 75},
  [18] = {.lex_state = 75},
  [19] = {.lex_state = 75},
  [20] = {.lex_state = 75},
  [21] = {.lex_state = 75},
  [22] = {.lex_state = 75},
  [23] = {.lex_state = 75},
  [24] = {.lex_state = 75},
  [25] = {.lex_state = 75},
  [26] = {.lex_state = 75},
  [27] = {.lex_state = 75},
  [28] = {.lex_state = 75},
  [29] = {.lex_state = 75},
  [30] = {.lex_state = 75},
  [31] = {.lex_state = 75},
  [32] = {.lex_state = 75},
  [33] = {.lex_state = 75},
  [34] = {.lex_state = 75},
  [35] = {.lex_state = 75},
  [36] = {.lex_state = 75},
  [37] = {.lex_state = 75},
  [38] = {.lex_state = 75},
  [39] = {.lex_state = 75},
  [40] = {.lex_state = 75},
  [41] = {.lex_state = 75},
  [42] = {.lex_state = 75},
  [43] = {.lex_state = 75},
  [44] = {.lex_state = 75},
  [45] = {.lex_state = 75},
  [46] = {.lex_state = 75},
  [47] = {.lex_state = 75},
  [48] = {.lex_state = 75},
  [49] = {.lex_state = 75},
  [50] = {.lex_state = 75},
  [51] = {.lex_state = 75},
  [52] = {.lex_state = 75},
  [53] = {.lex_state = 75},
  [54] = {.lex_state = 75},
  [55] = {.lex_state = 75},
  [56] = {.lex_state = 75},
  [57] = {.lex_state = 75},
  [58] = {.lex_state = 75},
  [59] = {.lex_state = 75},
  [60] = {.lex_state = 75},
  [61] = {.lex_state = 75},
  [62] = {.lex_state = 75},
  [63] = {.lex_state = 10},
  [64] = {.lex_state = 10},
  [65] = {.lex_state = 10},
  [66] = {.lex_state = 10},
  [67] = {.lex_state = 10},
  [68] = {.lex_state = 10},
  [69] = {.lex_state = 10},
  [70] = {.lex_state = 10},
  [71] = {.lex_state = 10},
  [72] = {.lex_state = 10},
  [73] = {.lex_state = 10},
  [74] = {.lex_state = 10},
  [75] = {.lex_state = 10},
  [76] = {.lex_state = 10},
  [77] = {.lex_state = 10},
  [78] = {.lex_state = 10},
  [79] = {.lex_state = 10},
  [80] = {.lex_state = 10},
  [81] = {.lex_state = 10},
  [82] = {.lex_state = 10},
  [83] = {.lex_state = 10},
  [84] = {.lex_state = 10},
  [85] = {.lex_state = 10},
  [86] = {.lex_state = 10},
  [87] = {.lex_state = 10},
  [88] = {.lex_state = 10},
  [89] = {.lex_state = 10},
  [90] = {.lex_state = 10},
  [91] = {.lex_state = 10},
  [92] = {.lex_state = 10},
  [93] = {.lex_state = 10},
  [94] = {.lex_state = 10},
  [95] = {.lex_state = 10},
  [96] = {.lex_state = 10},
  [97] = {.lex_state = 10},
  [98] = {.lex_state = 10},
  [99] = {.lex_state = 10},
  [100] = {.lex_state = 10},
  [101] = {.lex_state = 10},
  [102] = {.lex_state = 74, .external_lex_state = 2},
  [103] = {.lex_state = 10},
  [104] = {.lex_state = 10},
  [105] = {.lex_state = 74, .external_lex_state = 3},
  [106] = {.lex_state = 10},
  [107] = {.lex_state = 10},
  [108] = {.lex_state = 10},
  [109] = {.lex_state = 10},
  [110] = {.lex_state = 74, .external_lex_state = 2},
  [111] = {.lex_state = 74, .external_lex_state = 3},
  [112] = {.lex_state = 74, .external_lex_state = 4},
  [113] = {.lex_state = 74, .external_lex_state = 4},
  [114] = {.lex_state = 74, .external_lex_state = 3},
  [115] = {.lex_state = 74, .external_lex_state = 2},
  [116] = {.lex_state = 74, .external_lex_state = 3},
  [117] = {.lex_state = 74, .external_lex_state = 3},
  [118] = {.lex_state = 2, .external_lex_state = 3},
  [119] = {.lex_state = 4, .external_lex_state = 3},
  [120] = {.lex_state = 74, .external_lex_state = 2},
  [121] = {.lex_state = 74, .external_lex_state = 3},
  [122] = {.lex_state = 74, .external_lex_state = 3},
  [123] = {.lex_state = 74, .external_lex_state = 3},
  [124] = {.lex_state = 4, .external_lex_state = 3},
  [125] = {.lex_state = 74, .external_lex_state = 3},
  [126] = {.lex_state = 74, .external_lex_state = 2},
  [127] = {.lex_state = 74, .external_lex_state = 3},
  [128] = {.lex_state = 74, .external_lex_state = 3},
  [129] = {.lex_state = 75},
  [130] = {.lex_state = 75},
  [131] = {.lex_state = 75},
  [132] = {.lex_state = 75},
  [133] = {.lex_state = 75},
  [134] = {.lex_state = 75},
  [135] = {.lex_state = 75},
  [136] = {.lex_state = 75},
  [137] = {.lex_state = 2, .external_lex_state = 2},
  [138] = {.lex_state = 2, .external_lex_state = 3},
  [139] = {.lex_state = 2, .external_lex_state = 4},
  [140] = {.lex_state = 2, .external_lex_state = 3},
  [141] = {.lex_state = 2, .external_lex_state = 4},
  [142] = {.lex_state = 2, .external_lex_state = 2},
  [143] = {.lex_state = 2, .external_lex_state = 2},
  [144] = {.lex_state = 75},
  [145] = {.lex_state = 2, .external_lex_state = 3},
  [146] = {.lex_state = 75},
  [147] = {.lex_state = 2, .external_lex_state = 2},
  [148] = {.lex_state = 75},
  [149] = {.lex_state = 75},
  [150] = {.lex_state = 2, .external_lex_state = 3},
  [151] = {.lex_state = 74, .external_lex_state = 2},
  [152] = {.lex_state = 2, .external_lex_state = 3},
  [153] = {.lex_state = 74, .external_lex_state = 2},
  [154] = {.lex_state = 74, .external_lex_state = 2},
  [155] = {.lex_state = 2, .external_lex_state = 3},
  [156] = {.lex_state = 74, .external_lex_state = 2},
  [157] = {.lex_state = 75},
  [158] = {.lex_state = 2, .external_lex_state = 3},
  [159] = {.lex_state = 75},
  [160] = {.lex_state = 75},
  [161] = {.lex_state = 74, .external_lex_state = 2},
  [162] = {.lex_state = 74, .external_lex_state = 2},
  [163] = {.lex_state = 74, .external_lex_state = 2},
  [164] = {.lex_state = 74, .external_lex_state = 2},
  [165] = {.lex_state = 74, .external_lex_state = 2},
  [166] = {.lex_state = 2, .external_lex_state = 3},
  [167] = {.lex_state = 74, .external_lex_state = 2},
  [168] = {.lex_state = 74, .external_lex_state = 2},
  [169] = {.lex_state = 75},
  [170] = {.lex_state = 74, .external_lex_state = 2},
  [171] = {.lex_state = 2, .external_lex_state = 2},
  [172] = {.lex_state = 2, .external_lex_state = 3},
  [173] = {.lex_state = 75},
  [174] = {.lex_state = 74, .external_lex_state = 2},
  [175] = {.lex_state = 74, .external_lex_state = 2},
  [176] = {.lex_state = 74, .external_lex_state = 2},
  [177] = {.lex_state = 2, .external_lex_state = 3},
  [178] = {.lex_state = 74, .external_lex_state = 2},
  [179] = {.lex_state = 74, .external_lex_state = 2},
  [180] = {.lex_state = 74, .external_lex_state = 2},
  [181] = {.lex_state = 2, .external_lex_state = 3},
  [182] = {.lex_state = 75},
  [183] = {.lex_state = 75},
  [184] = {.lex_state = 74, .external_lex_state = 2},
  [185] = {.lex_state = 75},
  [186] = {.lex_state = 74, .external_lex_state = 2},
  [187] = {.lex_state = 75},
  [188] = {.lex_state = 74, .external_lex_state = 2},
  [189] = {.lex_state = 74, .external_lex_state = 2},
  [190] = {.lex_state = 75},
  [191] = {.lex_state = 74, .external_lex_state = 2},
  [192] = {.lex_state = 74, .external_lex_state = 2},
  [193] = {.lex_state = 74, .external_lex_state = 2},
  [194] = {.lex_state = 74, .external_lex_state = 2},
  [195] = {.lex_state = 75},
  [196] = {.lex_state = 2, .external_lex_state = 3},
  [197] = {.lex_state = 74, .external_lex_state = 2},
  [198] = {.lex_state = 2, .external_lex_state = 3},
  [199] = {.lex_state = 75},
  [200] = {.lex_state = 75},
  [201] = {.lex_state = 75},
  [202] = {.lex_state = 75},
  [203] = {.lex_state = 75, .external_lex_state = 5},
  [204] = {.lex_state = 75},
  [205] = {.lex_state = 2, .external_lex_state = 3},
  [206] = {.lex_state = 2, .external_lex_state = 3},
  [207] = {.lex_state = 75},
  [208] = {.lex_state = 2, .external_lex_state = 3},
  [209] = {.lex_state = 75},
  [210] = {.lex_state = 75},
  [211] = {.lex_state = 75},
  [212] = {.lex_state = 75},
  [213] = {.lex_state = 75},
  [214] = {.lex_state = 75},
  [215] = {.lex_state = 75},
  [216] = {.lex_state = 75},
  [217] = {.lex_state = 75},
  [218] = {.lex_state = 75},
  [219] = {.lex_state = 75},
  [220] = {.lex_state = 75},
  [221] = {.lex_state = 75},
  [222] = {.lex_state = 75},
  [223] = {.lex_state = 75},
  [224] = {.lex_state = 75},
  [225] = {.lex_state = 75},
  [226] = {.lex_state = 75},
  [227] = {.lex_state = 75},
  [228] = {.lex_state = 75},
  [229] = {.lex_state = 75},
  [230] = {.lex_state = 75},
  [231] = {.lex_state = 75},
  [232] = {.lex_state = 75},
  [233] = {.lex_state = 75},
  [234] = {.lex_state = 75},
  [235] = {.lex_state = 75},
  [236] = {.lex_state = 75},
  [237] = {.lex_state = 75},
  [238] = {.lex_state = 75},
  [239] = {.lex_state = 75},
  [240] = {.lex_state = 75},
  [241] = {.lex_state = 75},
  [242] = {.lex_state = 75},
  [243] = {.lex_state = 75},
  [244] = {.lex_state = 75},
  [245] = {.lex_state = 75},
  [246] = {.lex_state = 75},
  [247] = {.lex_state = 75},
  [248] = {.lex_state = 75},
  [249] = {.lex_state = 75},
  [250] = {.lex_state = 75},
  [251] = {.lex_state = 75, .external_lex_state = 5},
  [252] = {.lex_state = 75},
  [253] = {.lex_state = 75},
  [254] = {.lex_state = 75},
  [255] = {.lex_state = 75},
  [256] = {.lex_state = 75},
  [257] = {.lex_state = 75},
  [258] = {.lex_state = 75},
  [259] = {.lex_state = 75},
  [260] = {.lex_state = 75},
  [261] = {.lex_state = 75},
  [262] = {.lex_state = 75},
  [263] = {.lex_state = 75},
  [264] = {.lex_state = 75},
  [265] = {.lex_state = 75},
  [266] = {.lex_state = 3, .external_lex_state = 2},
  [267] = {.lex_state = 75},
  [268] = {.lex_state = 75},
  [269] = {.lex_state = 75},
  [270] = {.lex_state = 75},
  [271] = {.lex_state = 75},
  [272] = {.lex_state = 75},
  [273] = {.lex_state = 75},
  [274] = {.lex_state = 75},
  [275] = {.lex_state = 75},
  [276] = {.lex_state = 75},
  [277] = {.lex_state = 75},
  [278] = {.lex_state = 3, .external_lex_state = 2},
  [279] = {.lex_state = 75},
  [280] = {.lex_state = 75},
  [281] = {.lex_state = 3, .external_lex_state = 2},
  [282] = {.lex_state = 75},
  [283] = {.lex_state = 75},
  [284] = {.lex_state = 75},
  [285] = {.lex_state = 75},
  [286] = {.lex_state = 75},
  [287] = {.lex_state = 75},
  [288] = {.lex_state = 75},
  [289] = {.lex_state = 3, .external_lex_state = 2},
  [290] = {.lex_state = 75},
  [291] = {.lex_state = 75},
  [292] = {.lex_state = 75},
  [293] = {.lex_state = 75},
  [294] = {.lex_state = 75},
  [295] = {.lex_state = 75},
  [296] = {.lex_state = 75},
  [297] = {.lex_state = 75},
  [298] = {.lex_state = 3, .external_lex_state = 2},
  [299] = {.lex_state = 75},
  [300] = {.lex_state = 75},
  [301] = {.lex_state = 3, .external_lex_state = 2},
  [302] = {.lex_state = 75},
  [303] = {.lex_state = 3, .external_lex_state = 2},
  [304] = {.lex_state = 75},
  [305] = {.lex_state = 75},
  [306] = {.lex_state = 75},
  [307] = {.lex_state = 75},
  [308] = {.lex_state = 75},
  [309] = {.lex_state = 75},
  [310] = {.lex_state = 75},
  [311] = {.lex_state = 75},
  [312] = {.lex_state = 75},
  [313] = {.lex_state = 75},
  [314] = {.lex_state = 75},
  [315] = {.lex_state = 75},
  [316] = {.lex_state = 75},
  [317] = {.lex_state = 75},
  [318] = {.lex_state = 75},
  [319] = {.lex_state = 75},
  [320] = {.lex_state = 75},
  [321] = {.lex_state = 75},
  [322] = {.lex_state = 75},
  [323] = {.lex_state = 75},
  [324] = {.lex_state = 75},
  [325] = {.lex_state = 75},
  [326] = {.lex_state = 75},
  [327] = {.lex_state = 75},
  [328] = {.lex_state = 75},
  [329] = {.lex_state = 75},
  [330] = {.lex_state = 75},
  [331] = {.lex_state = 75},
  [332] = {.lex_state = 75},
  [333] = {.lex_state = 75},
  [334] = {.lex_state = 75},
  [335] = {.lex_state = 75},
  [336] = {.lex_state = 75},
  [337] = {.lex_state = 75},
  [338] = {.lex_state = 75},
  [339] = {.lex_state = 75},
  [340] = {.lex_state = 75},
  [341] = {.lex_state = 75},
  [342] = {.lex_state = 75},
  [343] = {.lex_state = 75},
  [344] = {.lex_state = 75},
  [345] = {.lex_state = 75},
  [346] = {.lex_state = 75},
  [347] = {.lex_state = 75},
  [348] = {.lex_state = 75},
  [349] = {.lex_state = 75},
  [350] = {.lex_state = 75},
  [351] = {.lex_state = 75},
  [352] = {.lex_state = 75},
  [353] = {.lex_state = 75},
  [354] = {.lex_state = 75},
  [355] = {.lex_state = 75},
  [356] = {.lex_state = 75},
  [357] = {.lex_state = 75},
  [358] = {.lex_state = 75},
  [359] = {.lex_state = 75},
  [360] = {.lex_state = 75},
  [361] = {.lex_state = 75},
  [362] = {.lex_state = 75},
  [363] = {.lex_state = 75},
  [364] = {.lex_state = 75},
  [365] = {.lex_state = 75},
  [366] = {.lex_state = 75},
  [367] = {.lex_state = 75},
  [368] = {.lex_state = 75},
  [369] = {.lex_state = 75},
  [370] = {.lex_state = 75},
  [371] = {.lex_state = 75},
  [372] = {.lex_state = 75},
  [373] = {.lex_state = 75},
  [374] = {.lex_state = 75},
  [375] = {.lex_state = 75},
  [376] = {.lex_state = 75},
  [377] = {.lex_state = 75},
  [378] = {.lex_state = 75},
  [379] = {.lex_state = 75},
  [380] = {.lex_state = 75},
  [381] = {.lex_state = 75},
  [382] = {.lex_state = 75},
  [383] = {.lex_state = 75},
  [384] = {.lex_state = 75},
  [385] = {.lex_state = 75},
  [386] = {.lex_state = 75},
  [387] = {.lex_state = 75},
  [388] = {.lex_state = 75},
  [389] = {.lex_state = 75},
  [390] = {.lex_state = 75},
  [391] = {.lex_state = 75},
  [392] = {.lex_state = 75},
  [393] = {.lex_state = 75},
  [394] = {.lex_state = 75},
  [395] = {.lex_state = 75},
  [396] = {.lex_state = 75},
  [397] = {.lex_state = 75},
  [398] = {.lex_state = 75},
  [399] = {.lex_state = 75},
  [400] = {.lex_state = 75},
  [401] = {.lex_state = 75},
  [402] = {.lex_state = 75},
  [403] = {.lex_state = 75},
  [404] = {.lex_state = 75},
  [405] = {.lex_state = 75},
  [406] = {.lex_state = 75},
  [407] = {.lex_state = 75},
  [408] = {.lex_state = 75},
  [409] = {.lex_state = 75},
  [410] = {.lex_state = 75},
  [411] = {.lex_state = 75},
  [412] = {.lex_state = 75},
  [413] = {.lex_state = 75},
  [414] = {.lex_state = 75},
  [415] = {.lex_state = 75},
  [416] = {.lex_state = 75},
  [417] = {.lex_state = 75},
  [418] = {.lex_state = 75},
  [419] = {.lex_state = 75},
  [420] = {.lex_state = 75},
  [421] = {.lex_state = 75},
  [422] = {.lex_state = 75},
  [423] = {.lex_state = 75},
  [424] = {.lex_state = 75},
  [425] = {.lex_state = 75},
  [426] = {.lex_state = 75},
  [427] = {.lex_state = 75},
  [428] = {.lex_state = 75},
  [429] = {.lex_state = 75},
  [430] = {.lex_state = 75},
  [431] = {.lex_state = 75},
  [432] = {.lex_state = 75},
  [433] = {.lex_state = 75},
  [434] = {.lex_state = 75},
  [435] = {.lex_state = 75},
  [436] = {.lex_state = 75},
  [437] = {.lex_state = 75},
  [438] = {.lex_state = 75},
  [439] = {.lex_state = 75},
  [440] = {.lex_state = 75},
  [441] = {.lex_state = 75},
  [442] = {.lex_state = 75},
  [443] = {.lex_state = 75},
  [444] = {.lex_state = 75},
  [445] = {.lex_state = 75},
  [446] = {.lex_state = 75},
  [447] = {.lex_state = 75},
  [448] = {.lex_state = 75},
  [449] = {.lex_state = 75},
  [450] = {.lex_state = 75},
  [451] = {.lex_state = 75},
  [452] = {.lex_state = 75},
  [453] = {.lex_state = 75},
  [454] = {.lex_state = 75},
  [455] = {.lex_state = 75},
  [456] = {.lex_state = 75},
  [457] = {.lex_state = 75},
  [458] = {.lex_state = 75},
  [459] = {.lex_state = 75},
  [460] = {.lex_state = 75},
  [461] = {.lex_state = 75},
  [462] = {.lex_state = 75},
  [463] = {.lex_state = 75},
  [464] = {.lex_state = 75},
  [465] = {.lex_state = 75},
  [466] = {.lex_state = 75},
  [467] = {.lex_state = 75},
  [468] = {.lex_state = 75},
  [469] = {.lex_state = 75},
  [470] = {.lex_state = 75},
  [471] = {.lex_state = 75},
  [472] = {.lex_state = 75},
  [473] = {.lex_state = 75},
  [474] = {.lex_state = 75},
  [475] = {.lex_state = 75},
  [476] = {.lex_state = 75},
  [477] = {.lex_state = 75},
  [478] = {.lex_state = 75},
  [479] = {.lex_state = 75},
  [480] = {.lex_state = 75},
  [481] = {.lex_state = 75},
  [482] = {.lex_state = 75},
  [483] = {.lex_state = 75},
  [484] = {.lex_state = 75},
  [485] = {.lex_state = 75},
  [486] = {.lex_state = 75},
  [487] = {.lex_state = 75},
  [488] = {.lex_state = 75},
  [489] = {.lex_state = 75},
  [490] = {.lex_state = 75},
  [491] = {.lex_state = 75},
  [492] = {.lex_state = 75},
  [493] = {.lex_state = 75},
  [494] = {.lex_state = 75},
  [495] = {.lex_state = 75},
  [496] = {.lex_state = 75},
  [497] = {.lex_state = 75},
  [498] = {.lex_state = 75},
  [499] = {.lex_state = 75},
  [500] = {.lex_state = 75},
  [501] = {.lex_state = 75},
  [502] = {.lex_state = 75},
  [503] = {.lex_state = 75},
  [504] = {.lex_state = 75},
  [505] = {.lex_state = 75},
  [506] = {.lex_state = 75},
  [507] = {.lex_state = 75},
  [508] = {.lex_state = 75},
  [509] = {.lex_state = 75},
  [510] = {.lex_state = 75},
  [511] = {.lex_state = 75},
  [512] = {.lex_state = 75},
  [513] = {.lex_state = 75},
  [514] = {.lex_state = 75},
  [515] = {.lex_state = 75},
  [516] = {.lex_state = 75},
  [517] = {.lex_state = 75},
  [518] = {.lex_state = 75},
  [519] = {.lex_state = 75},
  [520] = {.lex_state = 75},
  [521] = {.lex_state = 75},
  [522] = {.lex_state = 75},
  [523] = {.lex_state = 75},
  [524] = {.lex_state = 75},
  [525] = {.lex_state = 75},
  [526] = {.lex_state = 75},
  [527] = {.lex_state = 75},
  [528] = {.lex_state = 75},
  [529] = {.lex_state = 75},
  [530] = {.lex_state = 75},
  [531] = {.lex_state = 75},
  [532] = {.lex_state = 75},
  [533] = {.lex_state = 75},
  [534] = {.lex_state = 75},
  [535] = {.lex_state = 75},
  [536] = {.lex_state = 75},
  [537] = {.lex_state = 75},
  [538] = {.lex_state = 75},
  [539] = {.lex_state = 75},
  [540] = {.lex_state = 75},
  [541] = {.lex_state = 75},
  [542] = {.lex_state = 75},
  [543] = {.lex_state = 75},
  [544] = {.lex_state = 75},
  [545] = {.lex_state = 75},
  [546] = {.lex_state = 75},
  [547] = {.lex_state = 75},
  [548] = {.lex_state = 75},
  [549] = {.lex_state = 75},
  [550] = {.lex_state = 75},
  [551] = {.lex_state = 75},
  [552] = {.lex_state = 75},
  [553] = {.lex_state = 75},
  [554] = {.lex_state = 75},
  [555] = {.lex_state = 75},
  [556] = {.lex_state = 75},
  [557] = {.lex_state = 2, .external_lex_state = 2},
  [558] = {.lex_state = 75},
  [559] = {.lex_state = 75},
  [560] = {.lex_state = 75},
  [561] = {.lex_state = 75},
  [562] = {.lex_state = 75},
  [563] = {.lex_state = 75},
  [564] = {.lex_state = 75},
  [565] = {.lex_state = 75},
  [566] = {.lex_state = 75},
  [567] = {.lex_state = 75},
  [568] = {.lex_state = 75},
  [569] = {.lex_state = 75},
  [570] = {.lex_state = 75},
  [571] = {.lex_state = 75},
  [572] = {.lex_state = 75},
  [573] = {.lex_state = 75},
  [574] = {.lex_state = 75},
  [575] = {.lex_state = 75},
  [576] = {.lex_state = 75},
  [577] = {.lex_state = 75},
  [578] = {.lex_state = 75},
  [579] = {.lex_state = 75},
  [580] = {.lex_state = 75},
  [581] = {.lex_state = 75},
  [582] = {.lex_state = 75},
  [583] = {.lex_state = 75},
  [584] = {.lex_state = 75},
  [585] = {.lex_state = 75},
  [586] = {.lex_state = 75},
  [587] = {.lex_state = 75},
  [588] = {.lex_state = 75},
  [589] = {.lex_state = 75},
  [590] = {.lex_state = 75},
  [591] = {.lex_state = 75},
  [592] = {.lex_state = 75},
  [593] = {.lex_state = 75},
  [594] = {.lex_state = 75},
  [595] = {.lex_state = 75},
  [596] = {.lex_state = 75},
  [597] = {.lex_state = 75},
  [598] = {.lex_state = 3, .external_lex_state = 2},
  [599] = {.lex_state = 75},
  [600] = {.lex_state = 75},
  [601] = {.lex_state = 75},
  [602] = {.lex_state = 75},
  [603] = {.lex_state = 75},
  [604] = {.lex_state = 75},
  [605] = {.lex_state = 75},
  [606] = {.lex_state = 75},
  [607] = {.lex_state = 2, .external_lex_state = 2},
  [608] = {.lex_state = 75},
  [609] = {.lex_state = 75},
  [610] = {.lex_state = 75},
  [611] = {.lex_state = 75},
  [612] = {.lex_state = 75},
  [613] = {.lex_state = 75},
  [614] = {.lex_state = 75},
  [615] = {.lex_state = 75},
  [616] = {.lex_state = 75},
  [617] = {.lex_state = 75},
  [618] = {.lex_state = 75},
  [619] = {.lex_state = 75},
  [620] = {.lex_state = 75},
  [621] = {.lex_state = 75},
  [622] = {.lex_state = 75},
  [623] = {.lex_state = 75},
  [624] = {.lex_state = 75},
  [625] = {.lex_state = 75},
  [626] = {.lex_state = 75},
  [627] = {.lex_state = 2, .external_lex_state = 2},
  [628] = {.lex_state = 75},
  [629] = {.lex_state = 75},
  [630] = {.lex_state = 75},
  [631] = {.lex_state = 75},
  [632] = {.lex_state = 75},
  [633] = {.lex_state = 75},
  [634] = {.lex_state = 75},
  [635] = {.lex_state = 75},
  [636] = {.lex_state = 75},
  [637] = {.lex_state = 75},
  [638] = {.lex_state = 75},
  [639] = {.lex_state = 75},
  [640] = {.lex_state = 75},
  [641] = {.lex_state = 75},
  [642] = {.lex_state = 75},
  [643] = {.lex_state = 75},
  [644] = {.lex_state = 75},
  [645] = {.lex_state = 75},
  [646] = {.lex_state = 75},
  [647] = {.lex_state = 75},
  [648] = {.lex_state = 2, .external_lex_state = 2},
  [649] = {.lex_state = 75},
  [650] = {.lex_state = 75},
  [651] = {.lex_state = 75},
  [652] = {.lex_state = 75},
  [653] = {.lex_state = 75},
  [654] = {.lex_state = 75},
  [655] = {.lex_state = 75},
  [656] = {.lex_state = 2, .external_lex_state = 2},
  [657] = {.lex_state = 75},
  [658] = {.lex_state = 75},
  [659] = {.lex_state = 75},
  [660] = {.lex_state = 75},
  [661] = {.lex_state = 75},
  [662] = {.lex_state = 75},
  [663] = {.lex_state = 2, .external_lex_state = 2},
  [664] = {.lex_state = 75},
  [665] = {.lex_state = 75},
  [666] = {.lex_state = 75},
  [667] = {.lex_state = 75},
  [668] = {.lex_state = 75},
  [669] = {.lex_state = 75},
  [670] = {.lex_state = 75},
  [671] = {.lex_state = 75},
  [672] = {.lex_state = 75},
  [673] = {.lex_state = 75},
  [674] = {.lex_state = 75},
  [675] = {.lex_state = 2, .external_lex_state = 2},
  [676] = {.lex_state = 75},
  [677] = {.lex_state = 75},
  [678] = {.lex_state = 75},
  [679] = {.lex_state = 75},
  [680] = {.lex_state = 75},
  [681] = {.lex_state = 75},
  [682] = {.lex_state = 75},
  [683] = {.lex_state = 75},
  [684] = {.lex_state = 75},
  [685] = {.lex_state = 75},
  [686] = {.lex_state = 75},
  [687] = {.lex_state = 75},
  [688] = {.lex_state = 75},
  [689] = {.lex_state = 75},
  [690] = {.lex_state = 3, .external_lex_state = 2},
  [691] = {.lex_state = 75},
  [692] = {.lex_state = 75},
  [693] = {.lex_state = 75},
  [694] = {.lex_state = 3, .external_lex_state = 2},
  [695] = {.lex_state = 75},
  [696] = {.lex_state = 75},
  [697] = {.lex_state = 75},
  [698] = {.lex_state = 75},
  [699] = {.lex_state = 75},
  [700] = {.lex_state = 75},
  [701] = {.lex_state = 75},
  [702] = {.lex_state = 75},
  [703] = {.lex_state = 75},
  [704] = {.lex_state = 75},
  [705] = {.lex_state = 75},
  [706] = {.lex_state = 75},
  [707] = {.lex_state = 75},
  [708] = {.lex_state = 75},
  [709] = {.lex_state = 75},
  [710] = {.lex_state = 75},
  [711] = {.lex_state = 75},
  [712] = {.lex_state = 75},
  [713] = {.lex_state = 75},
  [714] = {.lex_state = 75},
  [715] = {.lex_state = 75},
  [716] = {.lex_state = 75},
  [717] = {.lex_state = 75},
  [718] = {.lex_state = 75},
  [719] = {.lex_state = 75},
  [720] = {.lex_state = 75},
  [721] = {.lex_state = 75},
  [722] = {.lex_state = 75},
  [723] = {.lex_state = 75},
  [724] = {.lex_state = 75},
  [725] = {.lex_state = 75},
  [726] = {.lex_state = 75},
  [727] = {.lex_state = 75},
  [728] = {.lex_state = 75},
  [729] = {.lex_state = 75},
  [730] = {.lex_state = 75},
  [731] = {.lex_state = 75},
  [732] = {.lex_state = 75},
  [733] = {.lex_state = 75},
  [734] = {.lex_state = 75},
  [735] = {.lex_state = 75},
  [736] = {.lex_state = 75},
  [737] = {.lex_state = 75},
  [738] = {.lex_state = 75},
  [739] = {.lex_state = 75},
  [740] = {.lex_state = 75},
  [741] = {.lex_state = 75},
  [742] = {.lex_state = 75},
  [743] = {.lex_state = 75},
  [744] = {.lex_state = 75},
  [745] = {.lex_state = 75},
  [746] = {.lex_state = 75},
  [747] = {.lex_state = 75},
  [748] = {.lex_state = 75},
  [749] = {.lex_state = 75},
  [750] = {.lex_state = 75},
  [751] = {.lex_state = 75},
  [752] = {.lex_state = 75},
  [753] = {.lex_state = 75},
  [754] = {.lex_state = 75},
  [755] = {.lex_state = 75},
  [756] = {.lex_state = 75},
  [757] = {.lex_state = 75},
  [758] = {.lex_state = 75},
  [759] = {.lex_state = 75},
  [760] = {.lex_state = 75},
  [761] = {.lex_state = 75},
  [762] = {.lex_state = 75},
  [763] = {.lex_state = 75},
  [764] = {.lex_state = 75},
  [765] = {.lex_state = 75},
  [766] = {.lex_state = 75},
  [767] = {.lex_state = 75},
  [768] = {.lex_state = 75},
  [769] = {.lex_state = 75},
  [770] = {.lex_state = 75},
  [771] = {.lex_state = 75},
  [772] = {.lex_state = 75},
  [773] = {.lex_state = 75},
  [774] = {.lex_state = 75},
  [775] = {.lex_state = 75},
  [776] = {.lex_state = 75},
  [777] = {.lex_state = 75},
  [778] = {.lex_state = 75},
  [779] = {.lex_state = 75},
  [780] = {.lex_state = 75},
  [781] = {.lex_state = 75},
  [782] = {.lex_state = 75},
  [783] = {.lex_state = 75},
  [784] = {.lex_state = 75},
  [785] = {.lex_state = 75},
  [786] = {.lex_state = 75},
  [787] = {.lex_state = 75},
  [788] = {.lex_state = 75},
  [789] = {.lex_state = 75},
  [790] = {.lex_state = 75},
  [791] = {.lex_state = 75},
  [792] = {.lex_state = 75},
  [793] = {.lex_state = 75},
  [794] = {.lex_state = 75},
  [795] = {.lex_state = 75},
  [796] = {.lex_state = 75},
  [797] = {.lex_state = 75},
  [798] = {.lex_state = 75},
  [799] = {.lex_state = 75},
  [800] = {.lex_state = 75},
  [801] = {.lex_state = 75},
  [802] = {.lex_state = 75},
  [803] = {.lex_state = 75},
  [804] = {.lex_state = 75},
  [805] = {.lex_state = 75},
  [806] = {.lex_state = 75},
  [807] = {.lex_state = 75},
  [808] = {.lex_state = 75},
  [809] = {.lex_state = 75},
  [810] = {.lex_state = 75},
  [811] = {.lex_state = 75},
  [812] = {.lex_state = 75},
  [813] = {.lex_state = 75},
  [814] = {.lex_state = 75},
  [815] = {.lex_state = 75},
  [816] = {.lex_state = 75},
  [817] = {.lex_state = 75},
  [818] = {.lex_state = 75},
  [819] = {.lex_state = 75},
  [820] = {.lex_state = 75},
  [821] = {.lex_state = 75},
  [822] = {.lex_state = 75},
  [823] = {.lex_state = 75},
  [824] = {.lex_state = 75},
  [825] = {.lex_state = 75},
  [826] = {.lex_state = 75},
  [827] = {.lex_state = 75},
  [828] = {.lex_state = 75},
  [829] = {.lex_state = 75},
  [830] = {.lex_state = 75},
  [831] = {.lex_state = 75},
  [832] = {.lex_state = 75},
  [833] = {.lex_state = 75},
  [834] = {.lex_state = 75},
  [835] = {.lex_state = 75},
  [836] = {.lex_state = 75},
  [837] = {.lex_state = 75},
  [838] = {.lex_state = 75},
  [839] = {.lex_state = 75},
  [840] = {.lex_state = 75},
  [841] = {.lex_state = 75},
  [842] = {.lex_state = 75},
  [843] = {.lex_state = 75},
  [844] = {.lex_state = 75},
  [845] = {.lex_state = 75},
  [846] = {.lex_state = 75},
  [847] = {.lex_state = 75},
  [848] = {.lex_state = 75},
  [849] = {.lex_state = 75},
  [850] = {.lex_state = 75},
  [851] = {.lex_state = 75},
  [852] = {.lex_state = 75},
  [853] = {.lex_state = 75},
  [854] = {.lex_state = 75},
  [855] = {.lex_state = 75},
  [856] = {.lex_state = 75},
  [857] = {.lex_state = 75},
  [858] = {.lex_state = 75},
  [859] = {.lex_state = 75},
  [860] = {.lex_state = 75},
  [861] = {.lex_state = 75},
  [862] = {.lex_state = 75},
  [863] = {.lex_state = 75},
  [864] = {.lex_state = 75},
  [865] = {.lex_state = 75},
  [866] = {.lex_state = 75},
  [867] = {.lex_state = 75},
  [868] = {.lex_state = 75},
  [869] = {.lex_state = 75},
  [870] = {.lex_state = 75},
  [871] = {.lex_state = 75},
  [872] = {.lex_state = 75},
  [873] = {.lex_state = 75},
  [874] = {.lex_state = 75},
  [875] = {.lex_state = 75},
  [876] = {.lex_state = 75},
  [877] = {.lex_state = 75},
  [878] = {.lex_state = 75},
  [879] = {.lex_state = 75},
  [880] = {.lex_state = 75},
  [881] = {.lex_state = 75},
  [882] = {.lex_state = 75},
  [883] = {.lex_state = 75},
  [884] = {.lex_state = 75},
  [885] = {.lex_state = 75},
  [886] = {.lex_state = 75},
  [887] = {.lex_state = 75},
  [888] = {.lex_state = 75},
  [889] = {.lex_state = 75},
  [890] = {.lex_state = 75},
  [891] = {.lex_state = 75},
  [892] = {.lex_state = 75},
  [893] = {.lex_state = 75},
  [894] = {.lex_state = 75},
  [895] = {.lex_state = 75},
  [896] = {.lex_state = 75},
  [897] = {.lex_state = 75},
  [898] = {.lex_state = 75},
  [899] = {.lex_state = 75},
  [900] = {.lex_state = 75},
  [901] = {.lex_state = 75},
  [902] = {.lex_state = 75},
  [903] = {.lex_state = 75},
  [904] = {.lex_state = 75},
  [905] = {.lex_state = 75},
  [906] = {.lex_state = 75},
  [907] = {.lex_state = 75},
  [908] = {.lex_state = 75},
  [909] = {.lex_state = 75},
  [910] = {.lex_state = 2, .external_lex_state = 2},
  [911] = {.lex_state = 2, .external_lex_state = 2},
  [912] = {.lex_state = 2, .external_lex_state = 2},
  [913] = {.lex_state = 2, .external_lex_state = 2},
  [914] = {.lex_state = 2, .external_lex_state = 2},
  [915] = {.lex_state = 2, .external_lex_state = 2},
  [916] = {.lex_state = 2, .external_lex_state = 2},
  [917] = {.lex_state = 2, .external_lex_state = 2},
  [918] = {.lex_state = 2, .external_lex_state = 2},
  [919] = {.lex_state = 2, .external_lex_state = 2},
  [920] = {.lex_state = 2, .external_lex_state = 2},
  [921] = {.lex_state = 2, .external_lex_state = 2},
  [922] = {.lex_state = 2, .external_lex_state = 2},
  [923] = {.lex_state = 2, .external_lex_state = 2},
  [924] = {.lex_state = 2, .external_lex_state = 2},
  [925] = {.lex_state = 2, .external_lex_state = 2},
  [926] = {.lex_state = 2, .external_lex_state = 2},
  [927] = {.lex_state = 75},
  [928] = {.lex_state = 2, .external_lex_state = 2},
  [929] = {.lex_state = 75},
  [930] = {.lex_state = 2, .external_lex_state = 2},
  [931] = {.lex_state = 75},
  [932] = {.lex_state = 2, .external_lex_state = 2},
  [933] = {.lex_state = 2, .external_lex_state = 2},
  [934] = {.lex_state = 2, .external_lex_state = 2},
  [935] = {.lex_state = 75},
  [936] = {.lex_state = 75},
  [937] = {.lex_state = 75},
  [938] = {.lex_state = 2, .external_lex_state = 2},
  [939] = {.lex_state = 2, .external_lex_state = 2},
  [940] = {.lex_state = 2, .external_lex_state = 2},
  [941] = {.lex_state = 2, .external_lex_state = 2},
  [942] = {.lex_state = 2, .external_lex_state = 2},
  [943] = {.lex_state = 75},
  [944] = {.lex_state = 2, .external_lex_state = 2},
  [945] = {.lex_state = 2, .external_lex_state = 2},
  [946] = {.lex_state = 2, .external_lex_state = 2},
  [947] = {.lex_state = 2, .external_lex_state = 2},
  [948] = {.lex_state = 2, .external_lex_state = 2},
  [949] = {.lex_state = 2, .external_lex_state = 2},
  [950] = {.lex_state = 2, .external_lex_state = 2},
  [951] = {.lex_state = 11},
  [952] = {.lex_state = 11},
  [953] = {.lex_state = 11},
  [954] = {.lex_state = 11},
  [955] = {.lex_state = 11},
  [956] = {.lex_state = 11},
  [957] = {.lex_state = 11},
  [958] = {.lex_state = 11},
  [959] = {.lex_state = 11},
  [960] = {.lex_state = 11},
  [961] = {.lex_state = 11},
  [962] = {.lex_state = 2, .external_lex_state = 2},
  [963] = {.lex_state = 2, .external_lex_state = 2},
  [964] = {.lex_state = 3, .external_lex_state = 3},
  [965] = {.lex_state = 3, .external_lex_state = 2},
  [966] = {.lex_state = 3, .external_lex_state = 3},
  [967] = {.lex_state = 2, .external_lex_state = 2},
  [968] = {.lex_state = 2, .external_lex_state = 2},
  [969] = {.lex_state = 2, .external_lex_state = 2},
  [970] = {.lex_state = 2, .external_lex_state = 2},
  [971] = {.lex_state = 3, .external_lex_state = 2},
  [972] = {.lex_state = 2, .external_lex_state = 2},
  [973] = {.lex_state = 3, .external_lex_state = 3},
  [974] = {.lex_state = 3, .external_lex_state = 4},
  [975] = {.lex_state = 3, .external_lex_state = 4},
  [976] = {.lex_state = 3, .external_lex_state = 4},
  [977] = {.lex_state = 2, .external_lex_state = 2},
  [978] = {.lex_state = 2, .external_lex_state = 3},
  [979] = {.lex_state = 2, .external_lex_state = 3},
  [980] = {.lex_state = 2, .external_lex_state = 3},
  [981] = {.lex_state = 3, .external_lex_state = 3},
  [982] = {.lex_state = 2, .external_lex_state = 2},
  [983] = {.lex_state = 3, .external_lex_state = 4},
  [984] = {.lex_state = 3, .external_lex_state = 4},
  [985] = {.lex_state = 2, .external_lex_state = 2},
  [986] = {.lex_state = 2, .external_lex_state = 3},
  [987] = {.lex_state = 2, .external_lex_state = 2},
  [988] = {.lex_state = 2, .external_lex_state = 2},
  [989] = {.lex_state = 2, .external_lex_state = 2},
  [990] = {.lex_state = 2, .external_lex_state = 2},
  [991] = {.lex_state = 2, .external_lex_state = 2},
  [992] = {.lex_state = 2, .external_lex_state = 2},
  [993] = {.lex_state = 2, .external_lex_state = 3},
  [994] = {.lex_state = 3, .external_lex_state = 3},
  [995] = {.lex_state = 2, .external_lex_state = 3},
  [996] = {.lex_state = 3, .external_lex_state = 3},
  [997] = {.lex_state = 2, .external_lex_state = 3},
  [998] = {.lex_state = 2, .external_lex_state = 2},
  [999] = {.lex_state = 3, .external_lex_state = 3},
  [1000] = {.lex_state = 2, .external_lex_state = 2},
  [1001] = {.lex_state = 3, .external_lex_state = 3},
  [1002] = {.lex_state = 2, .external_lex_state = 2},
  [1003] = {.lex_state = 3, .external_lex_state = 3},
  [1004] = {.lex_state = 2, .external_lex_state = 3},
  [1005] = {.lex_state = 2, .external_lex_state = 3},
  [1006] = {.lex_state = 2, .external_lex_state = 3},
  [1007] = {.lex_state = 2, .external_lex_state = 3},
  [1008] = {.lex_state = 2, .external_lex_state = 3},
  [1009] = {.lex_state = 75, .external_lex_state = 5},
  [1010] = {.lex_state = 11},
  [1011] = {.lex_state = 3, .external_lex_state = 3},
  [1012] = {.lex_state = 2, .external_lex_state = 3},
  [1013] = {.lex_state = 2, .external_lex_state = 3},
  [1014] = {.lex_state = 75},
  [1015] = {.lex_state = 75, .external_lex_state = 5},
  [1016] = {.lex_state = 2, .external_lex_state = 2},
  [1017] = {.lex_state = 2, .external_lex_state = 3},
  [1018] = {.lex_state = 2, .external_lex_state = 2},
  [1019] = {.lex_state = 3, .external_lex_state = 3},
  [1020] = {.lex_state = 2, .external_lex_state = 3},
  [1021] = {.lex_state = 75},
  [1022] = {.lex_state = 2, .external_lex_state = 3},
  [1023] = {.lex_state = 2, .external_lex_state = 2},
  [1024] = {.lex_state = 2, .external_lex_state = 3},
  [1025] = {.lex_state = 2, .external_lex_state = 2},
  [1026] = {.lex_state = 2, .external_lex_state = 3},
  [1027] = {.lex_state = 2, .external_lex_state = 3},
  [1028] = {.lex_state = 2, .external_lex_state = 3},
  [1029] = {.lex_state = 2, .external_lex_state = 3},
  [1030] = {.lex_state = 75, .external_lex_state = 5},
  [1031] = {.lex_state = 2, .external_lex_state = 3},
  [1032] = {.lex_state = 75, .external_lex_state = 5},
  [1033] = {.lex_state = 75, .external_lex_state = 5},
  [1034] = {.lex_state = 2, .external_lex_state = 3},
  [1035] = {.lex_state = 2, .external_lex_state = 2},
  [1036] = {.lex_state = 2, .external_lex_state = 2},
  [1037] = {.lex_state = 75, .external_lex_state = 5},
  [1038] = {.lex_state = 2, .external_lex_state = 2},
  [1039] = {.lex_state = 75},
  [1040] = {.lex_state = 3, .external_lex_state = 3},
  [1041] = {.lex_state = 2, .external_lex_state = 3},
  [1042] = {.lex_state = 75, .external_lex_state = 5},
  [1043] = {.lex_state = 2, .external_lex_state = 3},
  [1044] = {.lex_state = 75, .external_lex_state = 5},
  [1045] = {.lex_state = 2, .external_lex_state = 3},
  [1046] = {.lex_state = 2, .external_lex_state = 3},
  [1047] = {.lex_state = 2, .external_lex_state = 3},
  [1048] = {.lex_state = 2, .external_lex_state = 3},
  [1049] = {.lex_state = 75},
  [1050] = {.lex_state = 75},
  [1051] = {.lex_state = 75, .external_lex_state = 5},
  [1052] = {.lex_state = 75, .external_lex_state = 5},
  [1053] = {.lex_state = 75},
  [1054] = {.lex_state = 75, .external_lex_state = 5},
  [1055] = {.lex_state = 75},
  [1056] = {.lex_state = 75},
  [1057] = {.lex_state = 75},
  [1058] = {.lex_state = 75},
  [1059] = {.lex_state = 75},
  [1060] = {.lex_state = 75, .external_lex_state = 5},
  [1061] = {.lex_state = 75, .external_lex_state = 5},
  [1062] = {.lex_state = 75},
  [1063] = {.lex_state = 75, .external_lex_state = 5},
  [1064] = {.lex_state = 75},
  [1065] = {.lex_state = 75, .external_lex_state = 5},
  [1066] = {.lex_state = 75, .external_lex_state = 5},
  [1067] = {.lex_state = 75, .external_lex_state = 5},
  [1068] = {.lex_state = 75, .external_lex_state = 5},
  [1069] = {.lex_state = 75, .external_lex_state = 5},
  [1070] = {.lex_state = 75, .external_lex_state = 5},
  [1071] = {.lex_state = 75},
  [1072] = {.lex_state = 75},
  [1073] = {.lex_state = 75},
  [1074] = {.lex_state = 75},
  [1075] = {.lex_state = 75},
  [1076] = {.lex_state = 75},
  [1077] = {.lex_state = 75},
  [1078] = {.lex_state = 75},
  [1079] = {.lex_state = 75},
  [1080] = {.lex_state = 75},
  [1081] = {.lex_state = 75},
  [1082] = {.lex_state = 75},
  [1083] = {.lex_state = 75},
  [1084] = {.lex_state = 75},
  [1085] = {.lex_state = 75},
  [1086] = {.lex_state = 75},
  [1087] = {.lex_state = 75},
  [1088] = {.lex_state = 75},
  [1089] = {.lex_state = 75},
  [1090] = {.lex_state = 75},
  [1091] = {.lex_state = 75},
  [1092] = {.lex_state = 75},
  [1093] = {.lex_state = 75},
  [1094] = {.lex_state = 75},
  [1095] = {.lex_state = 75},
  [1096] = {.lex_state = 75},
  [1097] = {.lex_state = 75},
  [1098] = {.lex_state = 75},
  [1099] = {.lex_state = 75},
  [1100] = {.lex_state = 75},
  [1101] = {.lex_state = 75},
  [1102] = {.lex_state = 75},
  [1103] = {.lex_state = 75},
  [1104] = {.lex_state = 75},
  [1105] = {.lex_state = 75},
  [1106] = {.lex_state = 75},
  [1107] = {.lex_state = 75},
  [1108] = {.lex_state = 75},
  [1109] = {.lex_state = 75},
  [1110] = {.lex_state = 75},
  [1111] = {.lex_state = 75},
  [1112] = {.lex_state = 75},
  [1113] = {.lex_state = 75},
  [1114] = {.lex_state = 75},
  [1115] = {.lex_state = 75},
  [1116] = {.lex_state = 75},
  [1117] = {.lex_state = 75},
  [1118] = {.lex_state = 75},
  [1119] = {.lex_state = 75},
  [1120] = {.lex_state = 75},
  [1121] = {.lex_state = 75},
  [1122] = {.lex_state = 75},
  [1123] = {.lex_state = 75},
  [1124] = {.lex_state = 75},
  [1125] = {.lex_state = 75},
  [1126] = {.lex_state = 75},
  [1127] = {.lex_state = 75},
  [1128] = {.lex_state = 75},
  [1129] = {.lex_state = 75},
  [1130] = {.lex_state = 75},
  [1131] = {.lex_state = 75},
  [1132] = {.lex_state = 75},
  [1133] = {.lex_state = 75},
  [1134] = {.lex_state = 75},
  [1135] = {.lex_state = 75},
  [1136] = {.lex_state = 75},
  [1137] = {.lex_state = 75},
  [1138] = {.lex_state = 75},
  [1139] = {.lex_state = 75},
  [1140] = {.lex_state = 75},
  [1141] = {.lex_state = 75},
  [1142] = {.lex_state = 75},
  [1143] = {.lex_state = 75},
  [1144] = {.lex_state = 75},
  [1145] = {.lex_state = 75},
  [1146] = {.lex_state = 11},
  [1147] = {.lex_state = 75},
  [1148] = {.lex_state = 75},
  [1149] = {.lex_state = 75},
  [1150] = {.lex_state = 75},
  [1151] = {.lex_state = 75},
  [1152] = {.lex_state = 75},
  [1153] = {.lex_state = 75},
  [1154] = {.lex_state = 75},
  [1155] = {.lex_state = 75},
  [1156] = {.lex_state = 75},
  [1157] = {.lex_state = 75},
  [1158] = {.lex_state = 75},
  [1159] = {.lex_state = 75},
  [1160] = {.lex_state = 75},
  [1161] = {.lex_state = 75},
  [1162] = {.lex_state = 75},
  [1163] = {.lex_state = 75},
  [1164] = {.lex_state = 75},
  [1165] = {.lex_state = 75},
  [1166] = {.lex_state = 75},
  [1167] = {.lex_state = 75},
  [1168] = {.lex_state = 75},
  [1169] = {.lex_state = 75},
  [1170] = {.lex_state = 75},
  [1171] = {.lex_state = 75},
  [1172] = {.lex_state = 75},
  [1173] = {.lex_state = 75},
  [1174] = {.lex_state = 75},
  [1175] = {.lex_state = 75},
  [1176] = {.lex_state = 75},
  [1177] = {.lex_state = 75},
  [1178] = {.lex_state = 75},
  [1179] = {.lex_state = 75},
  [1180] = {.lex_state = 75},
  [1181] = {.lex_state = 75},
  [1182] = {.lex_state = 75},
  [1183] = {.lex_state = 75},
  [1184] = {.lex_state = 75},
  [1185] = {.lex_state = 75},
  [1186] = {.lex_state = 75},
  [1187] = {.lex_state = 75},
  [1188] = {.lex_state = 75},
  [1189] = {.lex_state = 75},
  [1190] = {.lex_state = 75},
  [1191] = {.lex_state = 75},
  [1192] = {.lex_state = 75},
  [1193] = {.lex_state = 75},
  [1194] = {.lex_state = 75},
  [1195] = {.lex_state = 75},
  [1196] = {.lex_state = 75},
  [1197] = {.lex_state = 75},
  [1198] = {.lex_state = 75},
  [1199] = {.lex_state = 75},
  [1200] = {.lex_state = 75},
  [1201] = {.lex_state = 75},
  [1202] = {.lex_state = 75},
  [1203] = {.lex_state = 75},
  [1204] = {.lex_state = 75},
  [1205] = {.lex_state = 75},
  [1206] = {.lex_state = 75},
  [1207] = {.lex_state = 75},
  [1208] = {.lex_state = 75},
  [1209] = {.lex_state = 75},
  [1210] = {.lex_state = 75},
  [1211] = {.lex_state = 75},
  [1212] = {.lex_state = 75},
  [1213] = {.lex_state = 75},
  [1214] = {.lex_state = 75},
  [1215] = {.lex_state = 75},
  [1216] = {.lex_state = 75},
  [1217] = {.lex_state = 75},
  [1218] = {.lex_state = 75},
  [1219] = {.lex_state = 75},
  [1220] = {.lex_state = 11},
  [1221] = {.lex_state = 11},
  [1222] = {.lex_state = 11},
  [1223] = {.lex_state = 3, .external_lex_state = 3},
  [1224] = {.lex_state = 2, .external_lex_state = 2},
  [1225] = {.lex_state = 2, .external_lex_state = 2},
  [1226] = {.lex_state = 11},
  [1227] = {.lex_state = 11},
  [1228] = {.lex_state = 3, .external_lex_state = 2},
  [1229] = {.lex_state = 2, .external_lex_state = 2},
  [1230] = {.lex_state = 11},
  [1231] = {.lex_state = 3, .external_lex_state = 2},
  [1232] = {.lex_state = 2, .external_lex_state = 2},
  [1233] = {.lex_state = 2, .external_lex_state = 2},
  [1234] = {.lex_state = 3, .external_lex_state = 3},
  [1235] = {.lex_state = 2, .external_lex_state = 2},
  [1236] = {.lex_state = 2, .external_lex_state = 2},
  [1237] = {.lex_state = 2, .external_lex_state = 2},
  [1238] = {.lex_state = 2, .external_lex_state = 2},
  [1239] = {.lex_state = 2, .external_lex_state = 2},
  [1240] = {.lex_state = 2, .external_lex_state = 2},
  [1241] = {.lex_state = 2, .external_lex_state = 2},
  [1242] = {.lex_state = 11},
  [1243] = {.lex_state = 2, .external_lex_state = 2},
  [1244] = {.lex_state = 2, .external_lex_state = 2},
  [1245] = {.lex_state = 11},
  [1246] = {.lex_state = 11},
  [1247] = {.lex_state = 11},
  [1248] = {.lex_state = 11},
  [1249] = {.lex_state = 11},
  [1250] = {.lex_state = 11},
  [1251] = {.lex_state = 11},
  [1252] = {.lex_state = 11},
  [1253] = {.lex_state = 11},
  [1254] = {.lex_state = 11},
  [1255] = {.lex_state = 2, .external_lex_state = 3},
  [1256] = {.lex_state = 3, .external_lex_state = 4},
  [1257] = {.lex_state = 2, .external_lex_state = 2},
  [1258] = {.lex_state = 11},
  [1259] = {.lex_state = 11},
  [1260] = {.lex_state = 11},
  [1261] = {.lex_state = 3, .external_lex_state = 4},
  [1262] = {.lex_state = 3, .external_lex_state = 4},
  [1263] = {.lex_state = 11},
  [1264] = {.lex_state = 2, .external_lex_state = 3},
  [1265] = {.lex_state = 2, .external_lex_state = 2},
  [1266] = {.lex_state = 2, .external_lex_state = 3},
  [1267] = {.lex_state = 3, .external_lex_state = 4},
  [1268] = {.lex_state = 3, .external_lex_state = 3},
  [1269] = {.lex_state = 11},
  [1270] = {.lex_state = 3, .external_lex_state = 4},
  [1271] = {.lex_state = 13},
  [1272] = {.lex_state = 2, .external_lex_state = 2},
  [1273] = {.lex_state = 13},
  [1274] = {.lex_state = 2, .external_lex_state = 2},
  [1275] = {.lex_state = 3, .external_lex_state = 3},
  [1276] = {.lex_state = 2, .external_lex_state = 2},
  [1277] = {.lex_state = 13},
  [1278] = {.lex_state = 2, .external_lex_state = 3},
  [1279] = {.lex_state = 2, .external_lex_state = 3},
  [1280] = {.lex_state = 13},
  [1281] = {.lex_state = 13},
  [1282] = {.lex_state = 2, .external_lex_state = 2},
  [1283] = {.lex_state = 13},
  [1284] = {.lex_state = 13},
  [1285] = {.lex_state = 13},
  [1286] = {.lex_state = 2, .external_lex_state = 2},
  [1287] = {.lex_state = 13},
  [1288] = {.lex_state = 13},
  [1289] = {.lex_state = 3, .external_lex_state = 3},
  [1290] = {.lex_state = 13},
  [1291] = {.lex_state = 2, .external_lex_state = 2},
  [1292] = {.lex_state = 2, .external_lex_state = 3},
  [1293] = {.lex_state = 13},
  [1294] = {.lex_state = 13},
  [1295] = {.lex_state = 13},
  [1296] = {.lex_state = 13},
  [1297] = {.lex_state = 13},
  [1298] = {.lex_state = 2, .external_lex_state = 2},
  [1299] = {.lex_state = 13},
  [1300] = {.lex_state = 13},
  [1301] = {.lex_state = 2, .external_lex_state = 2},
  [1302] = {.lex_state = 2, .external_lex_state = 2},
  [1303] = {.lex_state = 3, .external_lex_state = 3},
  [1304] = {.lex_state = 3, .external_lex_state = 3},
  [1305] = {.lex_state = 2, .external_lex_state = 2},
  [1306] = {.lex_state = 13},
  [1307] = {.lex_state = 13},
  [1308] = {.lex_state = 2, .external_lex_state = 2},
  [1309] = {.lex_state = 2, .external_lex_state = 3},
  [1310] = {.lex_state = 2, .external_lex_state = 2},
  [1311] = {.lex_state = 2, .external_lex_state = 2},
  [1312] = {.lex_state = 2, .external_lex_state = 3},
  [1313] = {.lex_state = 3, .external_lex_state = 3},
  [1314] = {.lex_state = 2, .external_lex_state = 3},
  [1315] = {.lex_state = 3, .external_lex_state = 3},
  [1316] = {.lex_state = 3, .external_lex_state = 3},
  [1317] = {.lex_state = 3, .external_lex_state = 3},
  [1318] = {.lex_state = 3, .external_lex_state = 3},
  [1319] = {.lex_state = 3, .external_lex_state = 3},
  [1320] = {.lex_state = 3, .external_lex_state = 3},
  [1321] = {.lex_state = 3, .external_lex_state = 3},
  [1322] = {.lex_state = 2, .external_lex_state = 3},
  [1323] = {.lex_state = 2, .external_lex_state = 3},
  [1324] = {.lex_state = 2, .external_lex_state = 3},
  [1325] = {.lex_state = 2, .external_lex_state = 3},
  [1326] = {.lex_state = 2, .external_lex_state = 2},
  [1327] = {.lex_state = 2, .external_lex_state = 3},
  [1328] = {.lex_state = 3, .external_lex_state = 3},
  [1329] = {.lex_state = 3, .external_lex_state = 3},
  [1330] = {.lex_state = 2, .external_lex_state = 3},
  [1331] = {.lex_state = 2, .external_lex_state = 3},
  [1332] = {.lex_state = 2, .external_lex_state = 2},
  [1333] = {.lex_state = 2, .external_lex_state = 3},
  [1334] = {.lex_state = 2, .external_lex_state = 2},
  [1335] = {.lex_state = 2, .external_lex_state = 2},
  [1336] = {.lex_state = 3, .external_lex_state = 3},
  [1337] = {.lex_state = 2, .external_lex_state = 3},
  [1338] = {.lex_state = 3, .external_lex_state = 2},
  [1339] = {.lex_state = 2, .external_lex_state = 3},
  [1340] = {.lex_state = 11},
  [1341] = {.lex_state = 3, .external_lex_state = 3},
  [1342] = {.lex_state = 2, .external_lex_state = 3},
  [1343] = {.lex_state = 2, .external_lex_state = 2},
  [1344] = {.lex_state = 2, .external_lex_state = 2},
  [1345] = {.lex_state = 2, .external_lex_state = 2},
  [1346] = {.lex_state = 2, .external_lex_state = 3},
  [1347] = {.lex_state = 3, .external_lex_state = 3},
  [1348] = {.lex_state = 2, .external_lex_state = 2},
  [1349] = {.lex_state = 2, .external_lex_state = 3},
  [1350] = {.lex_state = 2, .external_lex_state = 3},
  [1351] = {.lex_state = 2, .external_lex_state = 3},
  [1352] = {.lex_state = 2, .external_lex_state = 2},
  [1353] = {.lex_state = 3, .external_lex_state = 2},
  [1354] = {.lex_state = 2, .external_lex_state = 3},
  [1355] = {.lex_state = 2, .external_lex_state = 2},
  [1356] = {.lex_state = 2, .external_lex_state = 2},
  [1357] = {.lex_state = 2, .external_lex_state = 2},
  [1358] = {.lex_state = 3, .external_lex_state = 2},
  [1359] = {.lex_state = 2, .external_lex_state = 2},
  [1360] = {.lex_state = 3, .external_lex_state = 3},
  [1361] = {.lex_state = 2, .external_lex_state = 2},
  [1362] = {.lex_state = 2, .external_lex_state = 2},
  [1363] = {.lex_state = 3, .external_lex_state = 2},
  [1364] = {.lex_state = 2, .external_lex_state = 3},
  [1365] = {.lex_state = 3, .external_lex_state = 4},
  [1366] = {.lex_state = 2, .external_lex_state = 2},
  [1367] = {.lex_state = 3, .external_lex_state = 4},
  [1368] = {.lex_state = 3, .external_lex_state = 2},
  [1369] = {.lex_state = 3, .external_lex_state = 2},
  [1370] = {.lex_state = 3, .external_lex_state = 2},
  [1371] = {.lex_state = 2, .external_lex_state = 3},
  [1372] = {.lex_state = 2, .external_lex_state = 2},
  [1373] = {.lex_state = 2, .external_lex_state = 2},
  [1374] = {.lex_state = 3, .external_lex_state = 2},
  [1375] = {.lex_state = 2, .external_lex_state = 2},
  [1376] = {.lex_state = 2, .external_lex_state = 3},
  [1377] = {.lex_state = 3, .external_lex_state = 2},
  [1378] = {.lex_state = 2, .external_lex_state = 2},
  [1379] = {.lex_state = 3, .external_lex_state = 3},
  [1380] = {.lex_state = 2, .external_lex_state = 2},
  [1381] = {.lex_state = 2, .external_lex_state = 2},
  [1382] = {.lex_state = 3, .external_lex_state = 2},
  [1383] = {.lex_state = 3, .external_lex_state = 2},
  [1384] = {.lex_state = 3, .external_lex_state = 4},
  [1385] = {.lex_state = 2, .external_lex_state = 3},
  [1386] = {.lex_state = 3, .external_lex_state = 2},
  [1387] = {.lex_state = 2, .external_lex_state = 2},
  [1388] = {.lex_state = 2, .external_lex_state = 2},
  [1389] = {.lex_state = 2, .external_lex_state = 3},
  [1390] = {.lex_state = 2, .external_lex_state = 2},
  [1391] = {.lex_state = 2, .external_lex_state = 2},
  [1392] = {.lex_state = 3, .external_lex_state = 3},
  [1393] = {.lex_state = 2, .external_lex_state = 2},
  [1394] = {.lex_state = 11},
  [1395] = {.lex_state = 3, .external_lex_state = 4},
  [1396] = {.lex_state = 3, .external_lex_state = 4},
  [1397] = {.lex_state = 2, .external_lex_state = 2},
  [1398] = {.lex_state = 11},
  [1399] = {.lex_state = 2, .external_lex_state = 2},
  [1400] = {.lex_state = 2, .external_lex_state = 3},
  [1401] = {.lex_state = 3, .external_lex_state = 3},
  [1402] = {.lex_state = 3, .external_lex_state = 2},
  [1403] = {.lex_state = 3, .external_lex_state = 3},
  [1404] = {.lex_state = 3, .external_lex_state = 2},
  [1405] = {.lex_state = 2, .external_lex_state = 2},
  [1406] = {.lex_state = 3, .external_lex_state = 2},
  [1407] = {.lex_state = 11},
  [1408] = {.lex_state = 3, .external_lex_state = 3},
  [1409] = {.lex_state = 2, .external_lex_state = 2},
  [1410] = {.lex_state = 2, .external_lex_state = 3},
  [1411] = {.lex_state = 3, .external_lex_state = 2},
  [1412] = {.lex_state = 3, .external_lex_state = 4},
  [1413] = {.lex_state = 11},
  [1414] = {.lex_state = 11},
  [1415] = {.lex_state = 13},
  [1416] = {.lex_state = 2, .external_lex_state = 2},
  [1417] = {.lex_state = 3, .external_lex_state = 4},
  [1418] = {.lex_state = 11},
  [1419] = {.lex_state = 11},
  [1420] = {.lex_state = 11},
  [1421] = {.lex_state = 11},
  [1422] = {.lex_state = 13},
  [1423] = {.lex_state = 2, .external_lex_state = 2},
  [1424] = {.lex_state = 3, .external_lex_state = 2},
  [1425] = {.lex_state = 11},
  [1426] = {.lex_state = 11},
  [1427] = {.lex_state = 3, .external_lex_state = 4},
  [1428] = {.lex_state = 11},
  [1429] = {.lex_state = 3, .external_lex_state = 4},
  [1430] = {.lex_state = 3, .external_lex_state = 4},
  [1431] = {.lex_state = 3, .external_lex_state = 3},
  [1432] = {.lex_state = 13},
  [1433] = {.lex_state = 3, .external_lex_state = 4},
  [1434] = {.lex_state = 2, .external_lex_state = 3},
  [1435] = {.lex_state = 2, .external_lex_state = 3},
  [1436] = {.lex_state = 3, .external_lex_state = 3},
  [1437] = {.lex_state = 11},
  [1438] = {.lex_state = 11},
  [1439] = {.lex_state = 3, .external_lex_state = 3},
  [1440] = {.lex_state = 3, .external_lex_state = 4},
  [1441] = {.lex_state = 11},
  [1442] = {.lex_state = 13},
  [1443] = {.lex_state = 11},
  [1444] = {.lex_state = 2, .external_lex_state = 2},
  [1445] = {.lex_state = 11},
  [1446] = {.lex_state = 13},
  [1447] = {.lex_state = 11},
  [1448] = {.lex_state = 2, .external_lex_state = 2},
  [1449] = {.lex_state = 11},
  [1450] = {.lex_state = 2, .external_lex_state = 3},
  [1451] = {.lex_state = 11},
  [1452] = {.lex_state = 3, .external_lex_state = 4},
  [1453] = {.lex_state = 3, .external_lex_state = 3},
  [1454] = {.lex_state = 11},
  [1455] = {.lex_state = 13},
  [1456] = {.lex_state = 3, .external_lex_state = 2},
  [1457] = {.lex_state = 3, .external_lex_state = 4},
  [1458] = {.lex_state = 11},
  [1459] = {.lex_state = 11},
  [1460] = {.lex_state = 11},
  [1461] = {.lex_state = 3, .external_lex_state = 4},
  [1462] = {.lex_state = 11},
  [1463] = {.lex_state = 3, .external_lex_state = 4},
  [1464] = {.lex_state = 11},
  [1465] = {.lex_state = 2, .external_lex_state = 3},
  [1466] = {.lex_state = 2, .external_lex_state = 2},
  [1467] = {.lex_state = 3, .external_lex_state = 4},
  [1468] = {.lex_state = 11},
  [1469] = {.lex_state = 11},
  [1470] = {.lex_state = 2, .external_lex_state = 2},
  [1471] = {.lex_state = 11},
  [1472] = {.lex_state = 3, .external_lex_state = 4},
  [1473] = {.lex_state = 11},
  [1474] = {.lex_state = 2, .external_lex_state = 3},
  [1475] = {.lex_state = 11},
  [1476] = {.lex_state = 11},
  [1477] = {.lex_state = 3, .external_lex_state = 4},
  [1478] = {.lex_state = 11},
  [1479] = {.lex_state = 3, .external_lex_state = 3},
  [1480] = {.lex_state = 2, .external_lex_state = 3},
  [1481] = {.lex_state = 2, .external_lex_state = 3},
  [1482] = {.lex_state = 11},
  [1483] = {.lex_state = 11},
  [1484] = {.lex_state = 11},
  [1485] = {.lex_state = 3, .external_lex_state = 4},
  [1486] = {.lex_state = 3, .external_lex_state = 4},
  [1487] = {.lex_state = 3, .external_lex_state = 4},
  [1488] = {.lex_state = 11},
  [1489] = {.lex_state = 11},
  [1490] = {.lex_state = 2, .external_lex_state = 2},
  [1491] = {.lex_state = 2, .external_lex_state = 3},
  [1492] = {.lex_state = 3, .external_lex_state = 3},
  [1493] = {.lex_state = 2, .external_lex_state = 3},
  [1494] = {.lex_state = 11},
  [1495] = {.lex_state = 3, .external_lex_state = 4},
  [1496] = {.lex_state = 11},
  [1497] = {.lex_state = 11},
  [1498] = {.lex_state = 2, .external_lex_state = 2},
  [1499] = {.lex_state = 2, .external_lex_state = 2},
  [1500] = {.lex_state = 11},
  [1501] = {.lex_state = 11},
  [1502] = {.lex_state = 11},
  [1503] = {.lex_state = 3, .external_lex_state = 4},
  [1504] = {.lex_state = 11},
  [1505] = {.lex_state = 11},
  [1506] = {.lex_state = 11},
  [1507] = {.lex_state = 3, .external_lex_state = 3},
  [1508] = {.lex_state = 11},
  [1509] = {.lex_state = 11},
  [1510] = {.lex_state = 11},
  [1511] = {.lex_state = 11},
  [1512] = {.lex_state = 11},
  [1513] = {.lex_state = 3, .external_lex_state = 4},
  [1514] = {.lex_state = 3, .external_lex_state = 4},
  [1515] = {.lex_state = 2, .external_lex_state = 3},
  [1516] = {.lex_state = 11},
  [1517] = {.lex_state = 11},
  [1518] = {.lex_state = 11},
  [1519] = {.lex_state = 2, .external_lex_state = 2},
  [1520] = {.lex_state = 11},
  [1521] = {.lex_state = 11},
  [1522] = {.lex_state = 11},
  [1523] = {.lex_state = 2, .external_lex_state = 2},
  [1524] = {.lex_state = 11},
  [1525] = {.lex_state = 2, .external_lex_state = 2},
  [1526] = {.lex_state = 3, .external_lex_state = 4},
  [1527] = {.lex_state = 3, .external_lex_state = 3},
  [1528] = {.lex_state = 11},
  [1529] = {.lex_state = 2, .external_lex_state = 3},
  [1530] = {.lex_state = 2, .external_lex_state = 3},
  [1531] = {.lex_state = 2, .external_lex_state = 3},
  [1532] = {.lex_state = 11},
  [1533] = {.lex_state = 2, .external_lex_state = 3},
  [1534] = {.lex_state = 11},
  [1535] = {.lex_state = 3, .external_lex_state = 4},
  [1536] = {.lex_state = 11},
  [1537] = {.lex_state = 11},
  [1538] = {.lex_state = 11},
  [1539] = {.lex_state = 2, .external_lex_state = 3},
  [1540] = {.lex_state = 11},
  [1541] = {.lex_state = 11},
  [1542] = {.lex_state = 11},
  [1543] = {.lex_state = 2, .external_lex_state = 2},
  [1544] = {.lex_state = 2, .external_lex_state = 3},
  [1545] = {.lex_state = 3, .external_lex_state = 3},
  [1546] = {.lex_state = 11},
  [1547] = {.lex_state = 11},
  [1548] = {.lex_state = 11},
  [1549] = {.lex_state = 11},
  [1550] = {.lex_state = 11},
  [1551] = {.lex_state = 11},
  [1552] = {.lex_state = 11},
  [1553] = {.lex_state = 2, .external_lex_state = 2},
  [1554] = {.lex_state = 11},
  [1555] = {.lex_state = 11},
  [1556] = {.lex_state = 2, .external_lex_state = 3},
  [1557] = {.lex_state = 11},
  [1558] = {.lex_state = 11},
  [1559] = {.lex_state = 11},
  [1560] = {.lex_state = 11},
  [1561] = {.lex_state = 3, .external_lex_state = 3},
  [1562] = {.lex_state = 11},
  [1563] = {.lex_state = 3, .external_lex_state = 3},
  [1564] = {.lex_state = 14},
  [1565] = {.lex_state = 11},
  [1566] = {.lex_state = 11},
  [1567] = {.lex_state = 11},
  [1568] = {.lex_state = 2, .external_lex_state = 2},
  [1569] = {.lex_state = 3, .external_lex_state = 3},
  [1570] = {.lex_state = 11},
  [1571] = {.lex_state = 11},
  [1572] = {.lex_state = 11},
  [1573] = {.lex_state = 11},
  [1574] = {.lex_state = 11},
  [1575] = {.lex_state = 11},
  [1576] = {.lex_state = 11},
  [1577] = {.lex_state = 11},
  [1578] = {.lex_state = 11},
  [1579] = {.lex_state = 11},
  [1580] = {.lex_state = 2, .external_lex_state = 2},
  [1581] = {.lex_state = 11},
  [1582] = {.lex_state = 2, .external_lex_state = 3},
  [1583] = {.lex_state = 2, .external_lex_state = 2},
  [1584] = {.lex_state = 2, .external_lex_state = 2},
  [1585] = {.lex_state = 2, .external_lex_state = 3},
  [1586] = {.lex_state = 3, .external_lex_state = 3},
  [1587] = {.lex_state = 2, .external_lex_state = 3},
  [1588] = {.lex_state = 11},
  [1589] = {.lex_state = 3, .external_lex_state = 3},
  [1590] = {.lex_state = 11},
  [1591] = {.lex_state = 11},
  [1592] = {.lex_state = 11},
  [1593] = {.lex_state = 11},
  [1594] = {.lex_state = 11},
  [1595] = {.lex_state = 11},
  [1596] = {.lex_state = 11},
  [1597] = {.lex_state = 11},
  [1598] = {.lex_state = 11},
  [1599] = {.lex_state = 2, .external_lex_state = 2},
  [1600] = {.lex_state = 11},
  [1601] = {.lex_state = 11},
  [1602] = {.lex_state = 11},
  [1603] = {.lex_state = 11},
  [1604] = {.lex_state = 11},
  [1605] = {.lex_state = 11},
  [1606] = {.lex_state = 2, .external_lex_state = 2},
  [1607] = {.lex_state = 11},
  [1608] = {.lex_state = 11},
  [1609] = {.lex_state = 11},
  [1610] = {.lex_state = 11},
  [1611] = {.lex_state = 11},
  [1612] = {.lex_state = 11},
  [1613] = {.lex_state = 11},
  [1614] = {.lex_state = 11},
  [1615] = {.lex_state = 11},
  [1616] = {.lex_state = 11},
  [1617] = {.lex_state = 11},
  [1618] = {.lex_state = 2, .external_lex_state = 3},
  [1619] = {.lex_state = 2, .external_lex_state = 2},
  [1620] = {.lex_state = 2, .external_lex_state = 2},
  [1621] = {.lex_state = 11},
  [1622] = {.lex_state = 11},
  [1623] = {.lex_state = 2, .external_lex_state = 3},
  [1624] = {.lex_state = 3, .external_lex_state = 3},
  [1625] = {.lex_state = 2, .external_lex_state = 2},
  [1626] = {.lex_state = 11},
  [1627] = {.lex_state = 11},
  [1628] = {.lex_state = 11},
  [1629] = {.lex_state = 2, .external_lex_state = 3},
  [1630] = {.lex_state = 2, .external_lex_state = 2},
  [1631] = {.lex_state = 11},
  [1632] = {.lex_state = 11},
  [1633] = {.lex_state = 11},
  [1634] = {.lex_state = 11},
  [1635] = {.lex_state = 2, .external_lex_state = 3},
  [1636] = {.lex_state = 11},
  [1637] = {.lex_state = 11},
  [1638] = {.lex_state = 2, .external_lex_state = 3},
  [1639] = {.lex_state = 11},
  [1640] = {.lex_state = 11},
  [1641] = {.lex_state = 11},
  [1642] = {.lex_state = 11},
  [1643] = {.lex_state = 11},
  [1644] = {.lex_state = 11},
  [1645] = {.lex_state = 11},
  [1646] = {.lex_state = 11},
  [1647] = {.lex_state = 11},
  [1648] = {.lex_state = 11},
  [1649] = {.lex_state = 11},
  [1650] = {.lex_state = 11},
  [1651] = {.lex_state = 11},
  [1652] = {.lex_state = 11},
  [1653] = {.lex_state = 11},
  [1654] = {.lex_state = 11},
  [1655] = {.lex_state = 11},
  [1656] = {.lex_state = 11},
  [1657] = {.lex_state = 11},
  [1658] = {.lex_state = 11},
  [1659] = {.lex_state = 11},
  [1660] = {.lex_state = 11},
  [1661] = {.lex_state = 2, .external_lex_state = 3},
  [1662] = {.lex_state = 11},
  [1663] = {.lex_state = 11},
  [1664] = {.lex_state = 11},
  [1665] = {.lex_state = 11},
  [1666] = {.lex_state = 11},
  [1667] = {.lex_state = 11},
  [1668] = {.lex_state = 11},
  [1669] = {.lex_state = 11},
  [1670] = {.lex_state = 11},
  [1671] = {.lex_state = 11},
  [1672] = {.lex_state = 11},
  [1673] = {.lex_state = 11},
  [1674] = {.lex_state = 11},
  [1675] = {.lex_state = 11},
  [1676] = {.lex_state = 11},
  [1677] = {.lex_state = 11},
  [1678] = {.lex_state = 11},
  [1679] = {.lex_state = 11},
  [1680] = {.lex_state = 2, .external_lex_state = 2},
  [1681] = {.lex_state = 11},
  [1682] = {.lex_state = 11},
  [1683] = {.lex_state = 2, .external_lex_state = 2},
  [1684] = {.lex_state = 11},
  [1685] = {.lex_state = 11},
  [1686] = {.lex_state = 2, .external_lex_state = 2},
  [1687] = {.lex_state = 11},
  [1688] = {.lex_state = 11},
  [1689] = {.lex_state = 11},
  [1690] = {.lex_state = 11},
  [1691] = {.lex_state = 11},
  [1692] = {.lex_state = 11},
  [1693] = {.lex_state = 11},
  [1694] = {.lex_state = 11},
  [1695] = {.lex_state = 11},
  [1696] = {.lex_state = 2, .external_lex_state = 2},
  [1697] = {.lex_state = 11},
  [1698] = {.lex_state = 11},
  [1699] = {.lex_state = 11},
  [1700] = {.lex_state = 11},
  [1701] = {.lex_state = 11},
  [1702] = {.lex_state = 11},
  [1703] = {.lex_state = 11},
  [1704] = {.lex_state = 11},
  [1705] = {.lex_state = 11},
  [1706] = {.lex_state = 11},
  [1707] = {.lex_state = 11},
  [1708] = {.lex_state = 11},
  [1709] = {.lex_state = 11},
  [1710] = {.lex_state = 11},
  [1711] = {.lex_state = 11},
  [1712] = {.lex_state = 2, .external_lex_state = 2},
  [1713] = {.lex_state = 11},
  [1714] = {.lex_state = 11},
  [1715] = {.lex_state = 11},
  [1716] = {.lex_state = 11},
  [1717] = {.lex_state = 11},
  [1718] = {.lex_state = 11},
  [1719] = {.lex_state = 11},
  [1720] = {.lex_state = 11},
  [1721] = {.lex_state = 11},
  [1722] = {.lex_state = 11},
  [1723] = {.lex_state = 2, .external_lex_state = 2},
  [1724] = {.lex_state = 11},
  [1725] = {.lex_state = 11},
  [1726] = {.lex_state = 11},
  [1727] = {.lex_state = 11},
  [1728] = {.lex_state = 11},
  [1729] = {.lex_state = 11},
  [1730] = {.lex_state = 11},
  [1731] = {.lex_state = 11},
  [1732] = {.lex_state = 2, .external_lex_state = 2},
  [1733] = {.lex_state = 11},
  [1734] = {.lex_state = 2, .external_lex_state = 2},
  [1735] = {.lex_state = 11},
  [1736] = {.lex_state = 11},
  [1737] = {.lex_state = 11},
  [1738] = {.lex_state = 11},
  [1739] = {.lex_state = 11},
  [1740] = {.lex_state = 11},
  [1741] = {.lex_state = 11},
  [1742] = {.lex_state = 11},
  [1743] = {.lex_state = 11},
  [1744] = {.lex_state = 3, .external_lex_state = 3},
  [1745] = {.lex_state = 2, .external_lex_state = 3},
  [1746] = {.lex_state = 11},
  [1747] = {.lex_state = 11},
  [1748] = {.lex_state = 11},
  [1749] = {.lex_state = 11},
  [1750] = {.lex_state = 11},
  [1751] = {.lex_state = 3, .external_lex_state = 3},
  [1752] = {.lex_state = 11},
  [1753] = {.lex_state = 11},
  [1754] = {.lex_state = 3, .external_lex_state = 3},
  [1755] = {.lex_state = 11},
  [1756] = {.lex_state = 11},
  [1757] = {.lex_state = 2, .external_lex_state = 3},
  [1758] = {.lex_state = 11},
  [1759] = {.lex_state = 11},
  [1760] = {.lex_state = 11},
  [1761] = {.lex_state = 11},
  [1762] = {.lex_state = 11},
  [1763] = {.lex_state = 11},
  [1764] = {.lex_state = 11},
  [1765] = {.lex_state = 11},
  [1766] = {.lex_state = 11},
  [1767] = {.lex_state = 11},
  [1768] = {.lex_state = 11},
  [1769] = {.lex_state = 3, .external_lex_state = 3},
  [1770] = {.lex_state = 11},
  [1771] = {.lex_state = 11},
  [1772] = {.lex_state = 11},
  [1773] = {.lex_state = 11},
  [1774] = {.lex_state = 11},
  [1775] = {.lex_state = 11},
  [1776] = {.lex_state = 2, .external_lex_state = 2},
  [1777] = {.lex_state = 2, .external_lex_state = 3},
  [1778] = {.lex_state = 11},
  [1779] = {.lex_state = 11},
  [1780] = {.lex_state = 11},
  [1781] = {.lex_state = 11},
  [1782] = {.lex_state = 11},
  [1783] = {.lex_state = 11},
  [1784] = {.lex_state = 11},
  [1785] = {.lex_state = 11},
  [1786] = {.lex_state = 11},
  [1787] = {.lex_state = 11},
  [1788] = {.lex_state = 11},
  [1789] = {.lex_state = 11},
  [1790] = {.lex_state = 11},
  [1791] = {.lex_state = 11},
  [1792] = {.lex_state = 11},
  [1793] = {.lex_state = 11},
  [1794] = {.lex_state = 11},
  [1795] = {.lex_state = 11},
  [1796] = {.lex_state = 11},
  [1797] = {.lex_state = 11},
  [1798] = {.lex_state = 11},
  [1799] = {.lex_state = 11},
  [1800] = {.lex_state = 11},
  [1801] = {.lex_state = 11},
  [1802] = {.lex_state = 11},
  [1803] = {.lex_state = 11},
  [1804] = {.lex_state = 11},
  [1805] = {.lex_state = 11},
  [1806] = {.lex_state = 11},
  [1807] = {.lex_state = 11},
  [1808] = {.lex_state = 11},
  [1809] = {.lex_state = 11},
  [1810] = {.lex_state = 11},
  [1811] = {.lex_state = 2, .external_lex_state = 3},
  [1812] = {.lex_state = 11},
  [1813] = {.lex_state = 2, .external_lex_state = 3},
  [1814] = {.lex_state = 11},
  [1815] = {.lex_state = 11},
  [1816] = {.lex_state = 11},
  [1817] = {.lex_state = 11},
  [1818] = {.lex_state = 11},
  [1819] = {.lex_state = 11},
  [1820] = {.lex_state = 11},
  [1821] = {.lex_state = 11},
  [1822] = {.lex_state = 11},
  [1823] = {.lex_state = 11},
  [1824] = {.lex_state = 11},
  [1825] = {.lex_state = 11},
  [1826] = {.lex_state = 11},
  [1827] = {.lex_state = 11},
  [1828] = {.lex_state = 2, .external_lex_state = 3},
  [1829] = {.lex_state = 11},
  [1830] = {.lex_state = 11},
  [1831] = {.lex_state = 11},
  [1832] = {.lex_state = 11},
  [1833] = {.lex_state = 11},
  [1834] = {.lex_state = 11},
  [1835] = {.lex_state = 11},
  [1836] = {.lex_state = 11},
  [1837] = {.lex_state = 11},
  [1838] = {.lex_state = 11},
  [1839] = {.lex_state = 11},
  [1840] = {.lex_state = 11},
  [1841] = {.lex_state = 11},
  [1842] = {.lex_state = 11},
  [1843] = {.lex_state = 2, .external_lex_state = 3},
  [1844] = {.lex_state = 11},
  [1845] = {.lex_state = 2, .external_lex_state = 2},
  [1846] = {.lex_state = 11},
  [1847] = {.lex_state = 11},
  [1848] = {.lex_state = 11},
  [1849] = {.lex_state = 11},
  [1850] = {.lex_state = 3, .external_lex_state = 3},
  [1851] = {.lex_state = 2, .external_lex_state = 2},
  [1852] = {.lex_state = 11},
  [1853] = {.lex_state = 11},
  [1854] = {.lex_state = 11},
  [1855] = {.lex_state = 11},
  [1856] = {.lex_state = 11},
  [1857] = {.lex_state = 11},
  [1858] = {.lex_state = 11},
  [1859] = {.lex_state = 11},
  [1860] = {.lex_state = 2, .external_lex_state = 3},
  [1861] = {.lex_state = 11},
  [1862] = {.lex_state = 2, .external_lex_state = 3},
  [1863] = {.lex_state = 11},
  [1864] = {.lex_state = 11},
  [1865] = {.lex_state = 11},
  [1866] = {.lex_state = 11},
  [1867] = {.lex_state = 11},
  [1868] = {.lex_state = 11},
  [1869] = {.lex_state = 11},
  [1870] = {.lex_state = 11},
  [1871] = {.lex_state = 11},
  [1872] = {.lex_state = 11},
  [1873] = {.lex_state = 11},
  [1874] = {.lex_state = 11},
  [1875] = {.lex_state = 11},
  [1876] = {.lex_state = 11},
  [1877] = {.lex_state = 11},
  [1878] = {.lex_state = 2, .external_lex_state = 3},
  [1879] = {.lex_state = 11},
  [1880] = {.lex_state = 11},
  [1881] = {.lex_state = 11},
  [1882] = {.lex_state = 11},
  [1883] = {.lex_state = 11},
  [1884] = {.lex_state = 11},
  [1885] = {.lex_state = 11},
  [1886] = {.lex_state = 11},
  [1887] = {.lex_state = 11},
  [1888] = {.lex_state = 11},
  [1889] = {.lex_state = 11},
  [1890] = {.lex_state = 11},
  [1891] = {.lex_state = 11},
  [1892] = {.lex_state = 11},
  [1893] = {.lex_state = 11},
  [1894] = {.lex_state = 11},
  [1895] = {.lex_state = 11},
  [1896] = {.lex_state = 11},
  [1897] = {.lex_state = 2, .external_lex_state = 2},
  [1898] = {.lex_state = 11},
  [1899] = {.lex_state = 11},
  [1900] = {.lex_state = 11},
  [1901] = {.lex_state = 11},
  [1902] = {.lex_state = 11},
  [1903] = {.lex_state = 2, .external_lex_state = 3},
  [1904] = {.lex_state = 11},
  [1905] = {.lex_state = 11},
  [1906] = {.lex_state = 11},
  [1907] = {.lex_state = 11},
  [1908] = {.lex_state = 11},
  [1909] = {.lex_state = 11},
  [1910] = {.lex_state = 11},
  [1911] = {.lex_state = 11},
  [1912] = {.lex_state = 11},
  [1913] = {.lex_state = 11},
  [1914] = {.lex_state = 11},
  [1915] = {.lex_state = 11},
  [1916] = {.lex_state = 11},
  [1917] = {.lex_state = 11},
  [1918] = {.lex_state = 11},
  [1919] = {.lex_state = 11},
  [1920] = {.lex_state = 11},
  [1921] = {.lex_state = 11},
  [1922] = {.lex_state = 11},
  [1923] = {.lex_state = 11},
  [1924] = {.lex_state = 11},
  [1925] = {.lex_state = 11},
  [1926] = {.lex_state = 11},
  [1927] = {.lex_state = 11},
  [1928] = {.lex_state = 11},
  [1929] = {.lex_state = 11},
  [1930] = {.lex_state = 11},
  [1931] = {.lex_state = 11},
  [1932] = {.lex_state = 11},
  [1933] = {.lex_state = 11},
  [1934] = {.lex_state = 11},
  [1935] = {.lex_state = 2, .external_lex_state = 2},
  [1936] = {.lex_state = 2, .external_lex_state = 2},
  [1937] = {.lex_state = 2, .external_lex_state = 2},
  [1938] = {.lex_state = 11},
  [1939] = {.lex_state = 3, .external_lex_state = 3},
  [1940] = {.lex_state = 11},
  [1941] = {.lex_state = 11},
  [1942] = {.lex_state = 2, .external_lex_state = 2},
  [1943] = {.lex_state = 11},
  [1944] = {.lex_state = 11},
  [1945] = {.lex_state = 2, .external_lex_state = 2},
  [1946] = {.lex_state = 11},
  [1947] = {.lex_state = 11},
  [1948] = {.lex_state = 3, .external_lex_state = 3},
  [1949] = {.lex_state = 11},
  [1950] = {.lex_state = 11},
  [1951] = {.lex_state = 11},
  [1952] = {.lex_state = 11},
  [1953] = {.lex_state = 11},
  [1954] = {.lex_state = 11},
  [1955] = {.lex_state = 11},
  [1956] = {.lex_state = 11},
  [1957] = {.lex_state = 11},
  [1958] = {.lex_state = 11},
  [1959] = {.lex_state = 11},
  [1960] = {.lex_state = 2, .external_lex_state = 3},
  [1961] = {.lex_state = 11},
  [1962] = {.lex_state = 11},
  [1963] = {.lex_state = 11},
  [1964] = {.lex_state = 11},
  [1965] = {.lex_state = 11},
  [1966] = {.lex_state = 11},
  [1967] = {.lex_state = 11},
  [1968] = {.lex_state = 11},
  [1969] = {.lex_state = 11},
  [1970] = {.lex_state = 11},
  [1971] = {.lex_state = 11},
  [1972] = {.lex_state = 2, .external_lex_state = 3},
  [1973] = {.lex_state = 11},
  [1974] = {.lex_state = 11},
  [1975] = {.lex_state = 11},
  [1976] = {.lex_state = 3, .external_lex_state = 3},
  [1977] = {.lex_state = 11},
  [1978] = {.lex_state = 11},
  [1979] = {.lex_state = 2, .external_lex_state = 2},
  [1980] = {.lex_state = 11},
  [1981] = {.lex_state = 11},
  [1982] = {.lex_state = 11},
  [1983] = {.lex_state = 11},
  [1984] = {.lex_state = 11},
  [1985] = {.lex_state = 3, .external_lex_state = 3},
  [1986] = {.lex_state = 11},
  [1987] = {.lex_state = 11},
  [1988] = {.lex_state = 11},
  [1989] = {.lex_state = 11},
  [1990] = {.lex_state = 11},
  [1991] = {.lex_state = 11},
  [1992] = {.lex_state = 11},
  [1993] = {.lex_state = 3, .external_lex_state = 3},
  [1994] = {.lex_state = 11},
  [1995] = {.lex_state = 3, .external_lex_state = 3},
  [1996] = {.lex_state = 11},
  [1997] = {.lex_state = 11},
  [1998] = {.lex_state = 11},
  [1999] = {.lex_state = 11},
  [2000] = {.lex_state = 11},
  [2001] = {.lex_state = 11},
  [2002] = {.lex_state = 11},
  [2003] = {.lex_state = 11},
  [2004] = {.lex_state = 11},
  [2005] = {.lex_state = 11},
  [2006] = {.lex_state = 11},
  [2007] = {.lex_state = 11},
  [2008] = {.lex_state = 11},
  [2009] = {.lex_state = 11},
  [2010] = {.lex_state = 11},
  [2011] = {.lex_state = 11},
  [2012] = {.lex_state = 3, .external_lex_state = 3},
  [2013] = {.lex_state = 2, .external_lex_state = 2},
  [2014] = {.lex_state = 11},
  [2015] = {.lex_state = 11},
  [2016] = {.lex_state = 11},
  [2017] = {.lex_state = 11},
  [2018] = {.lex_state = 11},
  [2019] = {.lex_state = 2, .external_lex_state = 2},
  [2020] = {.lex_state = 11},
  [2021] = {.lex_state = 3, .external_lex_state = 3},
  [2022] = {.lex_state = 2, .external_lex_state = 3},
  [2023] = {.lex_state = 13},
  [2024] = {.lex_state = 2, .external_lex_state = 3},
  [2025] = {.lex_state = 2, .external_lex_state = 3},
  [2026] = {.lex_state = 2, .external_lex_state = 3},
  [2027] = {.lex_state = 2, .external_lex_state = 3},
  [2028] = {.lex_state = 2, .external_lex_state = 3},
  [2029] = {.lex_state = 2, .external_lex_state = 3},
  [2030] = {.lex_state = 2, .external_lex_state = 2},
  [2031] = {.lex_state = 2, .external_lex_state = 2},
  [2032] = {.lex_state = 2, .external_lex_state = 3},
  [2033] = {.lex_state = 2, .external_lex_state = 3},
  [2034] = {.lex_state = 2, .external_lex_state = 3},
  [2035] = {.lex_state = 2, .external_lex_state = 3},
  [2036] = {.lex_state = 2, .external_lex_state = 3},
  [2037] = {.lex_state = 3, .external_lex_state = 3},
  [2038] = {.lex_state = 2, .external_lex_state = 3},
  [2039] = {.lex_state = 2, .external_lex_state = 2},
  [2040] = {.lex_state = 3, .external_lex_state = 3},
  [2041] = {.lex_state = 2, .external_lex_state = 3},
  [2042] = {.lex_state = 2, .external_lex_state = 3},
  [2043] = {.lex_state = 2, .external_lex_state = 3},
  [2044] = {.lex_state = 2, .external_lex_state = 3},
  [2045] = {.lex_state = 2, .external_lex_state = 3},
  [2046] = {.lex_state = 2, .external_lex_state = 2},
  [2047] = {.lex_state = 13},
  [2048] = {.lex_state = 3, .external_lex_state = 3},
  [2049] = {.lex_state = 3, .external_lex_state = 3},
  [2050] = {.lex_state = 2, .external_lex_state = 3},
  [2051] = {.lex_state = 2, .external_lex_state = 3},
  [2052] = {.lex_state = 2, .external_lex_state = 3},
  [2053] = {.lex_state = 2, .external_lex_state = 3},
  [2054] = {.lex_state = 2, .external_lex_state = 2},
  [2055] = {.lex_state = 2, .external_lex_state = 3},
  [2056] = {.lex_state = 2, .external_lex_state = 3},
  [2057] = {.lex_state = 2, .external_lex_state = 3},
  [2058] = {.lex_state = 2, .external_lex_state = 3},
  [2059] = {.lex_state = 2, .external_lex_state = 3},
  [2060] = {.lex_state = 2, .external_lex_state = 3},
  [2061] = {.lex_state = 2, .external_lex_state = 3},
  [2062] = {.lex_state = 3, .external_lex_state = 3},
  [2063] = {.lex_state = 2, .external_lex_state = 3},
  [2064] = {.lex_state = 2, .external_lex_state = 3},
  [2065] = {.lex_state = 2, .external_lex_state = 3},
  [2066] = {.lex_state = 2, .external_lex_state = 2},
  [2067] = {.lex_state = 2, .external_lex_state = 3},
  [2068] = {.lex_state = 2, .external_lex_state = 3},
  [2069] = {.lex_state = 2, .external_lex_state = 2},
  [2070] = {.lex_state = 2, .external_lex_state = 3},
  [2071] = {.lex_state = 2, .external_lex_state = 2},
  [2072] = {.lex_state = 2, .external_lex_state = 2},
  [2073] = {.lex_state = 2, .external_lex_state = 2},
  [2074] = {.lex_state = 2, .external_lex_state = 3},
  [2075] = {.lex_state = 2, .external_lex_state = 3},
  [2076] = {.lex_state = 2, .external_lex_state = 3},
  [2077] = {.lex_state = 2, .external_lex_state = 3},
  [2078] = {.lex_state = 2, .external_lex_state = 3},
  [2079] = {.lex_state = 2, .external_lex_state = 3},
  [2080] = {.lex_state = 2, .external_lex_state = 3},
  [2081] = {.lex_state = 2, .external_lex_state = 2},
  [2082] = {.lex_state = 2, .external_lex_state = 3},
  [2083] = {.lex_state = 2, .external_lex_state = 2},
  [2084] = {.lex_state = 2, .external_lex_state = 2},
  [2085] = {.lex_state = 2, .external_lex_state = 3},
  [2086] = {.lex_state = 2, .external_lex_state = 3},
  [2087] = {.lex_state = 2, .external_lex_state = 3},
  [2088] = {.lex_state = 2, .external_lex_state = 3},
  [2089] = {.lex_state = 2, .external_lex_state = 3},
  [2090] = {.lex_state = 2, .external_lex_state = 3},
  [2091] = {.lex_state = 2, .external_lex_state = 3},
  [2092] = {.lex_state = 2, .external_lex_state = 3},
  [2093] = {.lex_state = 2, .external_lex_state = 3},
  [2094] = {.lex_state = 2, .external_lex_state = 3},
  [2095] = {.lex_state = 2, .external_lex_state = 3},
  [2096] = {.lex_state = 2, .external_lex_state = 3},
  [2097] = {.lex_state = 2, .external_lex_state = 2},
  [2098] = {.lex_state = 2, .external_lex_state = 3},
  [2099] = {.lex_state = 2, .external_lex_state = 3},
  [2100] = {.lex_state = 2, .external_lex_state = 3},
  [2101] = {.lex_state = 2, .external_lex_state = 3},
  [2102] = {.lex_state = 2, .external_lex_state = 3},
  [2103] = {.lex_state = 2, .external_lex_state = 3},
  [2104] = {.lex_state = 2, .external_lex_state = 3},
  [2105] = {.lex_state = 2, .external_lex_state = 3},
  [2106] = {.lex_state = 2, .external_lex_state = 3},
  [2107] = {.lex_state = 2, .external_lex_state = 3},
  [2108] = {.lex_state = 2, .external_lex_state = 3},
  [2109] = {.lex_state = 2, .external_lex_state = 3},
  [2110] = {.lex_state = 2, .external_lex_state = 3},
  [2111] = {.lex_state = 2, .external_lex_state = 3},
  [2112] = {.lex_state = 2, .external_lex_state = 3},
  [2113] = {.lex_state = 2, .external_lex_state = 3},
  [2114] = {.lex_state = 2, .external_lex_state = 3},
  [2115] = {.lex_state = 2, .external_lex_state = 3},
  [2116] = {.lex_state = 2, .external_lex_state = 3},
  [2117] = {.lex_state = 2, .external_lex_state = 3},
  [2118] = {.lex_state = 75, .external_lex_state = 5},
  [2119] = {.lex_state = 75, .external_lex_state = 5},
  [2120] = {.lex_state = 75, .external_lex_state = 5},
  [2121] = {.lex_state = 75, .external_lex_state = 5},
  [2122] = {.lex_state = 75, .external_lex_state = 5},
  [2123] = {.lex_state = 75, .external_lex_state = 5},
  [2124] = {.lex_state = 75, .external_lex_state = 5},
  [2125] = {.lex_state = 75, .external_lex_state = 5},
  [2126] = {.lex_state = 75, .external_lex_state = 5},
  [2127] = {.lex_state = 11},
  [2128] = {.lex_state = 11},
  [2129] = {.lex_state = 75, .external_lex_state = 5},
  [2130] = {.lex_state = 11},
  [2131] = {.lex_state = 74, .external_lex_state = 2},
  [2132] = {.lex_state = 11},
  [2133] = {.lex_state = 11},
  [2134] = {.lex_state = 11},
  [2135] = {.lex_state = 11},
  [2136] = {.lex_state = 75, .external_lex_state = 5},
  [2137] = {.lex_state = 75, .external_lex_state = 5},
  [2138] = {.lex_state = 75, .external_lex_state = 5},
  [2139] = {.lex_state = 74, .external_lex_state = 3},
  [2140] = {.lex_state = 11},
  [2141] = {.lex_state = 11},
  [2142] = {.lex_state = 11},
  [2143] = {.lex_state = 11},
  [2144] = {.lex_state = 11},
  [2145] = {.lex_state = 11},
  [2146] = {.lex_state = 11},
  [2147] = {.lex_state = 11},
  [2148] = {.lex_state = 11},
  [2149] = {.lex_state = 11},
  [2150] = {.lex_state = 11},
  [2151] = {.lex_state = 11},
  [2152] = {.lex_state = 11},
  [2153] = {.lex_state = 11},
  [2154] = {.lex_state = 11},
  [2155] = {.lex_state = 11},
  [2156] = {.lex_state = 11},
  [2157] = {.lex_state = 11},
  [2158] = {.lex_state = 11},
  [2159] = {.lex_state = 11},
  [2160] = {.lex_state = 11},
  [2161] = {.lex_state = 74, .external_lex_state = 2},
  [2162] = {.lex_state = 74, .external_lex_state = 3},
  [2163] = {.lex_state = 74, .external_lex_state = 3},
  [2164] = {.lex_state = 74, .external_lex_state = 2},
  [2165] = {.lex_state = 74, .external_lex_state = 2},
  [2166] = {.lex_state = 74, .external_lex_state = 3},
  [2167] = {.lex_state = 74, .external_lex_state = 2},
  [2168] = {.lex_state = 74, .external_lex_state = 2},
  [2169] = {.lex_state = 74, .external_lex_state = 3},
  [2170] = {.lex_state = 74, .external_lex_state = 3},
  [2171] = {.lex_state = 74, .external_lex_state = 2},
  [2172] = {.lex_state = 74, .external_lex_state = 2},
  [2173] = {.lex_state = 74, .external_lex_state = 2},
  [2174] = {.lex_state = 74, .external_lex_state = 3},
  [2175] = {.lex_state = 74, .external_lex_state = 2},
  [2176] = {.lex_state = 74, .external_lex_state = 3},
  [2177] = {.lex_state = 74, .external_lex_state = 2},
  [2178] = {.lex_state = 74, .external_lex_state = 2},
  [2179] = {.lex_state = 74, .external_lex_state = 3},
  [2180] = {.lex_state = 74, .external_lex_state = 2},
  [2181] = {.lex_state = 74, .external_lex_state = 3},
  [2182] = {.lex_state = 74, .external_lex_state = 2},
  [2183] = {.lex_state = 74, .external_lex_state = 3},
  [2184] = {.lex_state = 74, .external_lex_state = 3},
  [2185] = {.lex_state = 74, .external_lex_state = 2},
  [2186] = {.lex_state = 74, .external_lex_state = 3},
  [2187] = {.lex_state = 74, .external_lex_state = 3},
  [2188] = {.lex_state = 74, .external_lex_state = 2},
  [2189] = {.lex_state = 74, .external_lex_state = 3},
  [2190] = {.lex_state = 74, .external_lex_state = 3},
  [2191] = {.lex_state = 74, .external_lex_state = 3},
  [2192] = {.lex_state = 74, .external_lex_state = 3},
  [2193] = {.lex_state = 74, .external_lex_state = 3},
  [2194] = {.lex_state = 74, .external_lex_state = 3},
  [2195] = {.lex_state = 74, .external_lex_state = 3},
  [2196] = {.lex_state = 74, .external_lex_state = 3},
  [2197] = {.lex_state = 74, .external_lex_state = 2},
  [2198] = {.lex_state = 74, .external_lex_state = 3},
  [2199] = {.lex_state = 74, .external_lex_state = 3},
  [2200] = {.lex_state = 74, .external_lex_state = 3},
  [2201] = {.lex_state = 74, .external_lex_state = 3},
  [2202] = {.lex_state = 74, .external_lex_state = 3},
  [2203] = {.lex_state = 74, .external_lex_state = 3},
  [2204] = {.lex_state = 74, .external_lex_state = 3},
  [2205] = {.lex_state = 74, .external_lex_state = 3},
  [2206] = {.lex_state = 74, .external_lex_state = 3},
  [2207] = {.lex_state = 74, .external_lex_state = 3},
  [2208] = {.lex_state = 74, .external_lex_state = 3},
  [2209] = {.lex_state = 74, .external_lex_state = 3},
  [2210] = {.lex_state = 74, .external_lex_state = 3},
  [2211] = {.lex_state = 74, .external_lex_state = 3},
  [2212] = {.lex_state = 74, .external_lex_state = 3},
  [2213] = {.lex_state = 74, .external_lex_state = 3},
  [2214] = {.lex_state = 74, .external_lex_state = 3},
  [2215] = {.lex_state = 74, .external_lex_state = 3},
  [2216] = {.lex_state = 74, .external_lex_state = 3},
  [2217] = {.lex_state = 74, .external_lex_state = 3},
  [2218] = {.lex_state = 74, .external_lex_state = 3},
  [2219] = {.lex_state = 74, .external_lex_state = 2},
  [2220] = {.lex_state = 74, .external_lex_state = 3},
  [2221] = {.lex_state = 74, .external_lex_state = 2},
  [2222] = {.lex_state = 74, .external_lex_state = 3},
  [2223] = {.lex_state = 74, .external_lex_state = 3},
  [2224] = {.lex_state = 74, .external_lex_state = 3},
  [2225] = {.lex_state = 74, .external_lex_state = 3},
  [2226] = {.lex_state = 74, .external_lex_state = 3},
  [2227] = {.lex_state = 74, .external_lex_state = 3},
  [2228] = {.lex_state = 74, .external_lex_state = 3},
  [2229] = {.lex_state = 74, .external_lex_state = 3},
  [2230] = {.lex_state = 74, .external_lex_state = 3},
  [2231] = {.lex_state = 74, .external_lex_state = 2},
  [2232] = {.lex_state = 74, .external_lex_state = 3},
  [2233] = {.lex_state = 11},
  [2234] = {.lex_state = 74, .external_lex_state = 3},
  [2235] = {.lex_state = 74, .external_lex_state = 2},
  [2236] = {.lex_state = 74, .external_lex_state = 3},
  [2237] = {.lex_state = 74, .external_lex_state = 3},
  [2238] = {.lex_state = 74, .external_lex_state = 2},
  [2239] = {.lex_state = 74, .external_lex_state = 3},
  [2240] = {.lex_state = 74, .external_lex_state = 3},
  [2241] = {.lex_state = 74, .external_lex_state = 3},
  [2242] = {.lex_state = 74, .external_lex_state = 3},
  [2243] = {.lex_state = 74, .external_lex_state = 3},
  [2244] = {.lex_state = 74, .external_lex_state = 2},
  [2245] = {.lex_state = 74, .external_lex_state = 3},
  [2246] = {.lex_state = 74, .external_lex_state = 3},
  [2247] = {.lex_state = 74, .external_lex_state = 3},
  [2248] = {.lex_state = 74, .external_lex_state = 3},
  [2249] = {.lex_state = 74, .external_lex_state = 3},
  [2250] = {.lex_state = 74, .external_lex_state = 3},
  [2251] = {.lex_state = 74, .external_lex_state = 3},
  [2252] = {.lex_state = 74, .external_lex_state = 3},
  [2253] = {.lex_state = 74, .external_lex_state = 3},
  [2254] = {.lex_state = 74, .external_lex_state = 3},
  [2255] = {.lex_state = 74, .external_lex_state = 3},
  [2256] = {.lex_state = 74, .external_lex_state = 3},
  [2257] = {.lex_state = 74, .external_lex_state = 3},
  [2258] = {.lex_state = 74, .external_lex_state = 3},
  [2259] = {.lex_state = 11},
  [2260] = {.lex_state = 74, .external_lex_state = 3},
  [2261] = {.lex_state = 74, .external_lex_state = 3},
  [2262] = {.lex_state = 74, .external_lex_state = 3},
  [2263] = {.lex_state = 74, .external_lex_state = 3},
  [2264] = {.lex_state = 74, .external_lex_state = 3},
  [2265] = {.lex_state = 74, .external_lex_state = 3},
  [2266] = {.lex_state = 74, .external_lex_state = 3},
  [2267] = {.lex_state = 74, .external_lex_state = 3},
  [2268] = {.lex_state = 74, .external_lex_state = 3},
  [2269] = {.lex_state = 74, .external_lex_state = 3},
  [2270] = {.lex_state = 74, .external_lex_state = 3},
  [2271] = {.lex_state = 74, .external_lex_state = 3},
  [2272] = {.lex_state = 74, .external_lex_state = 3},
  [2273] = {.lex_state = 74, .external_lex_state = 3},
  [2274] = {.lex_state = 74, .external_lex_state = 3},
  [2275] = {.lex_state = 74, .external_lex_state = 3},
  [2276] = {.lex_state = 74, .external_lex_state = 3},
  [2277] = {.lex_state = 74, .external_lex_state = 3},
  [2278] = {.lex_state = 11},
  [2279] = {.lex_state = 74, .external_lex_state = 2},
  [2280] = {.lex_state = 5, .external_lex_state = 3},
  [2281] = {.lex_state = 74, .external_lex_state = 2},
  [2282] = {.lex_state = 74, .external_lex_state = 3},
  [2283] = {.lex_state = 74, .external_lex_state = 3},
  [2284] = {.lex_state = 74, .external_lex_state = 3},
  [2285] = {.lex_state = 74, .external_lex_state = 3},
  [2286] = {.lex_state = 74, .external_lex_state = 3},
  [2287] = {.lex_state = 74, .external_lex_state = 3},
  [2288] = {.lex_state = 74, .external_lex_state = 3},
  [2289] = {.lex_state = 74, .external_lex_state = 3},
  [2290] = {.lex_state = 74, .external_lex_state = 2},
  [2291] = {.lex_state = 74, .external_lex_state = 3},
  [2292] = {.lex_state = 74, .external_lex_state = 2},
  [2293] = {.lex_state = 74, .external_lex_state = 3},
  [2294] = {.lex_state = 74, .external_lex_state = 3},
  [2295] = {.lex_state = 74, .external_lex_state = 3},
  [2296] = {.lex_state = 74, .external_lex_state = 3},
  [2297] = {.lex_state = 74, .external_lex_state = 2},
  [2298] = {.lex_state = 11},
  [2299] = {.lex_state = 74, .external_lex_state = 3},
  [2300] = {.lex_state = 11},
  [2301] = {.lex_state = 74, .external_lex_state = 2},
  [2302] = {.lex_state = 74, .external_lex_state = 3},
  [2303] = {.lex_state = 74, .external_lex_state = 3},
  [2304] = {.lex_state = 74, .external_lex_state = 3},
  [2305] = {.lex_state = 74, .external_lex_state = 3},
  [2306] = {.lex_state = 74, .external_lex_state = 3},
  [2307] = {.lex_state = 74, .external_lex_state = 3},
  [2308] = {.lex_state = 74, .external_lex_state = 3},
  [2309] = {.lex_state = 74, .external_lex_state = 2},
  [2310] = {.lex_state = 74, .external_lex_state = 2},
  [2311] = {.lex_state = 74, .external_lex_state = 3},
  [2312] = {.lex_state = 74, .external_lex_state = 2},
  [2313] = {.lex_state = 74, .external_lex_state = 2},
  [2314] = {.lex_state = 74, .external_lex_state = 3},
  [2315] = {.lex_state = 74, .external_lex_state = 2},
  [2316] = {.lex_state = 74, .external_lex_state = 2},
  [2317] = {.lex_state = 74, .external_lex_state = 3},
  [2318] = {.lex_state = 74, .external_lex_state = 2},
  [2319] = {.lex_state = 74, .external_lex_state = 2},
  [2320] = {.lex_state = 74, .external_lex_state = 3},
  [2321] = {.lex_state = 74, .external_lex_state = 3},
  [2322] = {.lex_state = 74, .external_lex_state = 3},
  [2323] = {.lex_state = 74, .external_lex_state = 3},
  [2324] = {.lex_state = 74, .external_lex_state = 3},
  [2325] = {.lex_state = 11},
  [2326] = {.lex_state = 74, .external_lex_state = 3},
  [2327] = {.lex_state = 74, .external_lex_state = 3},
  [2328] = {.lex_state = 74, .external_lex_state = 3},
  [2329] = {.lex_state = 74, .external_lex_state = 3},
  [2330] = {.lex_state = 74, .external_lex_state = 2},
  [2331] = {.lex_state = 74, .external_lex_state = 3},
  [2332] = {.lex_state = 74, .external_lex_state = 3},
  [2333] = {.lex_state = 74, .external_lex_state = 3},
  [2334] = {.lex_state = 74, .external_lex_state = 3},
  [2335] = {.lex_state = 11},
  [2336] = {.lex_state = 74, .external_lex_state = 3},
  [2337] = {.lex_state = 74, .external_lex_state = 3},
  [2338] = {.lex_state = 74, .external_lex_state = 3},
  [2339] = {.lex_state = 74, .external_lex_state = 3},
  [2340] = {.lex_state = 74, .external_lex_state = 2},
  [2341] = {.lex_state = 74, .external_lex_state = 3},
  [2342] = {.lex_state = 74, .external_lex_state = 2},
  [2343] = {.lex_state = 74, .external_lex_state = 3},
  [2344] = {.lex_state = 74, .external_lex_state = 2},
  [2345] = {.lex_state = 11},
  [2346] = {.lex_state = 74, .external_lex_state = 3},
  [2347] = {.lex_state = 74, .external_lex_state = 3},
  [2348] = {.lex_state = 74, .external_lex_state = 3},
  [2349] = {.lex_state = 74, .external_lex_state = 2},
  [2350] = {.lex_state = 74, .external_lex_state = 3},
  [2351] = {.lex_state = 74, .external_lex_state = 3},
  [2352] = {.lex_state = 74, .external_lex_state = 3},
  [2353] = {.lex_state = 74, .external_lex_state = 3},
  [2354] = {.lex_state = 74, .external_lex_state = 3},
  [2355] = {.lex_state = 74, .external_lex_state = 3},
  [2356] = {.lex_state = 74, .external_lex_state = 3},
  [2357] = {.lex_state = 74, .external_lex_state = 3},
  [2358] = {.lex_state = 74, .external_lex_state = 3},
  [2359] = {.lex_state = 74, .external_lex_state = 3},
  [2360] = {.lex_state = 74, .external_lex_state = 3},
  [2361] = {.lex_state = 74, .external_lex_state = 4},
  [2362] = {.lex_state = 75},
  [2363] = {.lex_state = 75},
  [2364] = {.lex_state = 74, .external_lex_state = 4},
  [2365] = {.lex_state = 74, .external_lex_state = 4},
  [2366] = {.lex_state = 74, .external_lex_state = 4},
  [2367] = {.lex_state = 74, .external_lex_state = 3},
  [2368] = {.lex_state = 74, .external_lex_state = 4},
  [2369] = {.lex_state = 75},
  [2370] = {.lex_state = 75},
  [2371] = {.lex_state = 75},
  [2372] = {.lex_state = 74, .external_lex_state = 4},
  [2373] = {.lex_state = 74, .external_lex_state = 4},
  [2374] = {.lex_state = 74, .external_lex_state = 4},
  [2375] = {.lex_state = 74, .external_lex_state = 2},
  [2376] = {.lex_state = 74, .external_lex_state = 2},
  [2377] = {.lex_state = 74, .external_lex_state = 2},
  [2378] = {.lex_state = 75},
  [2379] = {.lex_state = 75},
  [2380] = {.lex_state = 74, .external_lex_state = 4},
  [2381] = {.lex_state = 74, .external_lex_state = 4},
  [2382] = {.lex_state = 74, .external_lex_state = 4},
  [2383] = {.lex_state = 74, .external_lex_state = 2},
  [2384] = {.lex_state = 74, .external_lex_state = 4},
  [2385] = {.lex_state = 5, .external_lex_state = 2},
  [2386] = {.lex_state = 74, .external_lex_state = 4},
  [2387] = {.lex_state = 74, .external_lex_state = 4},
  [2388] = {.lex_state = 74, .external_lex_state = 4},
  [2389] = {.lex_state = 74, .external_lex_state = 4},
  [2390] = {.lex_state = 75},
  [2391] = {.lex_state = 74, .external_lex_state = 4},
  [2392] = {.lex_state = 74, .external_lex_state = 3},
  [2393] = {.lex_state = 74, .external_lex_state = 3},
  [2394] = {.lex_state = 74, .external_lex_state = 4},
  [2395] = {.lex_state = 74, .external_lex_state = 3},
  [2396] = {.lex_state = 74, .external_lex_state = 4},
  [2397] = {.lex_state = 74, .external_lex_state = 3},
  [2398] = {.lex_state = 74, .external_lex_state = 4},
  [2399] = {.lex_state = 74, .external_lex_state = 4},
  [2400] = {.lex_state = 75},
  [2401] = {.lex_state = 74, .external_lex_state = 3},
  [2402] = {.lex_state = 74, .external_lex_state = 4},
  [2403] = {.lex_state = 75},
  [2404] = {.lex_state = 74, .external_lex_state = 4},
  [2405] = {.lex_state = 74, .external_lex_state = 4},
  [2406] = {.lex_state = 74, .external_lex_state = 3},
  [2407] = {.lex_state = 74, .external_lex_state = 3},
  [2408] = {.lex_state = 75},
  [2409] = {.lex_state = 74, .external_lex_state = 2},
  [2410] = {.lex_state = 74, .external_lex_state = 2},
  [2411] = {.lex_state = 74, .external_lex_state = 2},
  [2412] = {.lex_state = 74, .external_lex_state = 3},
  [2413] = {.lex_state = 74, .external_lex_state = 3},
  [2414] = {.lex_state = 74, .external_lex_state = 2},
  [2415] = {.lex_state = 74, .external_lex_state = 2},
  [2416] = {.lex_state = 74, .external_lex_state = 3},
  [2417] = {.lex_state = 74, .external_lex_state = 3},
  [2418] = {.lex_state = 74, .external_lex_state = 3},
  [2419] = {.lex_state = 74, .external_lex_state = 3},
  [2420] = {.lex_state = 74, .external_lex_state = 2},
  [2421] = {.lex_state = 74, .external_lex_state = 2},
  [2422] = {.lex_state = 74, .external_lex_state = 3},
  [2423] = {.lex_state = 74, .external_lex_state = 2},
  [2424] = {.lex_state = 74, .external_lex_state = 2},
  [2425] = {.lex_state = 74, .external_lex_state = 2},
  [2426] = {.lex_state = 74, .external_lex_state = 2},
  [2427] = {.lex_state = 74, .external_lex_state = 2},
  [2428] = {.lex_state = 74, .external_lex_state = 2},
  [2429] = {.lex_state = 74, .external_lex_state = 2},
  [2430] = {.lex_state = 74, .external_lex_state = 3},
  [2431] = {.lex_state = 74, .external_lex_state = 2},
  [2432] = {.lex_state = 74, .external_lex_state = 2},
  [2433] = {.lex_state = 74, .external_lex_state = 3},
  [2434] = {.lex_state = 74, .external_lex_state = 3},
  [2435] = {.lex_state = 74, .external_lex_state = 2},
  [2436] = {.lex_state = 74, .external_lex_state = 3},
  [2437] = {.lex_state = 74, .external_lex_state = 3},
  [2438] = {.lex_state = 74, .external_lex_state = 3},
  [2439] = {.lex_state = 74, .external_lex_state = 3},
  [2440] = {.lex_state = 74, .external_lex_state = 3},
  [2441] = {.lex_state = 74, .external_lex_state = 2},
  [2442] = {.lex_state = 74, .external_lex_state = 3},
  [2443] = {.lex_state = 74, .external_lex_state = 2},
  [2444] = {.lex_state = 74, .external_lex_state = 3},
  [2445] = {.lex_state = 74, .external_lex_state = 3},
  [2446] = {.lex_state = 74, .external_lex_state = 3},
  [2447] = {.lex_state = 74, .external_lex_state = 3},
  [2448] = {.lex_state = 74, .external_lex_state = 3},
  [2449] = {.lex_state = 74, .external_lex_state = 3},
  [2450] = {.lex_state = 74, .external_lex_state = 2},
  [2451] = {.lex_state = 74, .external_lex_state = 3},
  [2452] = {.lex_state = 74, .external_lex_state = 3},
  [2453] = {.lex_state = 74, .external_lex_state = 2},
  [2454] = {.lex_state = 74, .external_lex_state = 2},
  [2455] = {.lex_state = 74, .external_lex_state = 2},
  [2456] = {.lex_state = 74, .external_lex_state = 2},
  [2457] = {.lex_state = 74, .external_lex_state = 2},
  [2458] = {.lex_state = 74, .external_lex_state = 2},
  [2459] = {.lex_state = 74, .external_lex_state = 4},
  [2460] = {.lex_state = 74, .external_lex_state = 2},
  [2461] = {.lex_state = 74, .external_lex_state = 2},
  [2462] = {.lex_state = 74, .external_lex_state = 2},
  [2463] = {.lex_state = 74, .external_lex_state = 2},
  [2464] = {.lex_state = 74, .external_lex_state = 2},
  [2465] = {.lex_state = 74, .external_lex_state = 2},
  [2466] = {.lex_state = 74, .external_lex_state = 2},
  [2467] = {.lex_state = 74, .external_lex_state = 3},
  [2468] = {.lex_state = 74, .external_lex_state = 4},
  [2469] = {.lex_state = 74, .external_lex_state = 4},
  [2470] = {.lex_state = 74, .external_lex_state = 2},
  [2471] = {.lex_state = 74, .external_lex_state = 2},
  [2472] = {.lex_state = 74, .external_lex_state = 2},
  [2473] = {.lex_state = 74, .external_lex_state = 2},
  [2474] = {.lex_state = 74, .external_lex_state = 2},
  [2475] = {.lex_state = 74, .external_lex_state = 2},
  [2476] = {.lex_state = 74, .external_lex_state = 2},
  [2477] = {.lex_state = 74, .external_lex_state = 2},
  [2478] = {.lex_state = 74, .external_lex_state = 2},
  [2479] = {.lex_state = 74, .external_lex_state = 2},
  [2480] = {.lex_state = 74, .external_lex_state = 2},
  [2481] = {.lex_state = 74, .external_lex_state = 2},
  [2482] = {.lex_state = 74, .external_lex_state = 2},
  [2483] = {.lex_state = 74, .external_lex_state = 4},
  [2484] = {.lex_state = 74, .external_lex_state = 2},
  [2485] = {.lex_state = 74, .external_lex_state = 2},
  [2486] = {.lex_state = 74, .external_lex_state = 2},
  [2487] = {.lex_state = 74, .external_lex_state = 2},
  [2488] = {.lex_state = 74, .external_lex_state = 2},
  [2489] = {.lex_state = 74, .external_lex_state = 2},
  [2490] = {.lex_state = 74, .external_lex_state = 2},
  [2491] = {.lex_state = 74, .external_lex_state = 2},
  [2492] = {.lex_state = 74, .external_lex_state = 2},
  [2493] = {.lex_state = 74, .external_lex_state = 2},
  [2494] = {.lex_state = 74, .external_lex_state = 2},
  [2495] = {.lex_state = 74, .external_lex_state = 2},
  [2496] = {.lex_state = 74, .external_lex_state = 2},
  [2497] = {.lex_state = 74, .external_lex_state = 2},
  [2498] = {.lex_state = 74, .external_lex_state = 4},
  [2499] = {.lex_state = 74, .external_lex_state = 2},
  [2500] = {.lex_state = 74, .external_lex_state = 3},
  [2501] = {.lex_state = 74, .external_lex_state = 2},
  [2502] = {.lex_state = 74, .external_lex_state = 2},
  [2503] = {.lex_state = 74, .external_lex_state = 4},
  [2504] = {.lex_state = 74, .external_lex_state = 4},
  [2505] = {.lex_state = 74, .external_lex_state = 4},
  [2506] = {.lex_state = 74, .external_lex_state = 3},
  [2507] = {.lex_state = 74, .external_lex_state = 4},
  [2508] = {.lex_state = 74, .external_lex_state = 4},
  [2509] = {.lex_state = 74, .external_lex_state = 2},
  [2510] = {.lex_state = 74, .external_lex_state = 2},
  [2511] = {.lex_state = 74, .external_lex_state = 2},
  [2512] = {.lex_state = 74, .external_lex_state = 2},
  [2513] = {.lex_state = 74, .external_lex_state = 2},
  [2514] = {.lex_state = 74, .external_lex_state = 2},
  [2515] = {.lex_state = 74, .external_lex_state = 2},
  [2516] = {.lex_state = 74, .external_lex_state = 2},
  [2517] = {.lex_state = 74, .external_lex_state = 4},
  [2518] = {.lex_state = 74, .external_lex_state = 4},
  [2519] = {.lex_state = 74, .external_lex_state = 4},
  [2520] = {.lex_state = 74, .external_lex_state = 4},
  [2521] = {.lex_state = 74, .external_lex_state = 4},
  [2522] = {.lex_state = 74, .external_lex_state = 2},
  [2523] = {.lex_state = 74, .external_lex_state = 4},
  [2524] = {.lex_state = 74, .external_lex_state = 4},
  [2525] = {.lex_state = 74, .external_lex_state = 2},
  [2526] = {.lex_state = 74, .external_lex_state = 3},
  [2527] = {.lex_state = 74, .external_lex_state = 2},
  [2528] = {.lex_state = 74, .external_lex_state = 2},
  [2529] = {.lex_state = 74, .external_lex_state = 2},
  [2530] = {.lex_state = 74, .external_lex_state = 2},
  [2531] = {.lex_state = 74, .external_lex_state = 4},
  [2532] = {.lex_state = 74, .external_lex_state = 2},
  [2533] = {.lex_state = 74, .external_lex_state = 2},
  [2534] = {.lex_state = 74, .external_lex_state = 4},
  [2535] = {.lex_state = 74, .external_lex_state = 2},
  [2536] = {.lex_state = 74, .external_lex_state = 2},
  [2537] = {.lex_state = 74, .external_lex_state = 2},
  [2538] = {.lex_state = 74, .external_lex_state = 2},
  [2539] = {.lex_state = 74, .external_lex_state = 2},
  [2540] = {.lex_state = 74, .external_lex_state = 2},
  [2541] = {.lex_state = 74, .external_lex_state = 2},
  [2542] = {.lex_state = 74, .external_lex_state = 2},
  [2543] = {.lex_state = 74, .external_lex_state = 4},
  [2544] = {.lex_state = 74, .external_lex_state = 2},
  [2545] = {.lex_state = 74, .external_lex_state = 2},
  [2546] = {.lex_state = 74, .external_lex_state = 2},
  [2547] = {.lex_state = 74, .external_lex_state = 4},
  [2548] = {.lex_state = 74, .external_lex_state = 4},
  [2549] = {.lex_state = 74, .external_lex_state = 4},
  [2550] = {.lex_state = 74, .external_lex_state = 4},
  [2551] = {.lex_state = 74, .external_lex_state = 4},
  [2552] = {.lex_state = 74, .external_lex_state = 2},
  [2553] = {.lex_state = 74, .external_lex_state = 2},
  [2554] = {.lex_state = 74, .external_lex_state = 2},
  [2555] = {.lex_state = 74, .external_lex_state = 2},
  [2556] = {.lex_state = 74, .external_lex_state = 3},
  [2557] = {.lex_state = 74, .external_lex_state = 3},
  [2558] = {.lex_state = 74, .external_lex_state = 2},
  [2559] = {.lex_state = 74, .external_lex_state = 2},
  [2560] = {.lex_state = 74, .external_lex_state = 2},
  [2561] = {.lex_state = 74, .external_lex_state = 2},
  [2562] = {.lex_state = 74, .external_lex_state = 2},
  [2563] = {.lex_state = 74, .external_lex_state = 2},
  [2564] = {.lex_state = 74, .external_lex_state = 2},
  [2565] = {.lex_state = 74, .external_lex_state = 2},
  [2566] = {.lex_state = 74, .external_lex_state = 2},
  [2567] = {.lex_state = 74, .external_lex_state = 2},
  [2568] = {.lex_state = 74, .external_lex_state = 2},
  [2569] = {.lex_state = 74, .external_lex_state = 2},
  [2570] = {.lex_state = 74, .external_lex_state = 2},
  [2571] = {.lex_state = 74, .external_lex_state = 2},
  [2572] = {.lex_state = 74, .external_lex_state = 2},
  [2573] = {.lex_state = 74, .external_lex_state = 2},
  [2574] = {.lex_state = 74, .external_lex_state = 2},
  [2575] = {.lex_state = 74, .external_lex_state = 3},
  [2576] = {.lex_state = 74, .external_lex_state = 2},
  [2577] = {.lex_state = 74, .external_lex_state = 4},
  [2578] = {.lex_state = 74, .external_lex_state = 2},
  [2579] = {.lex_state = 74, .external_lex_state = 2},
  [2580] = {.lex_state = 74, .external_lex_state = 2},
  [2581] = {.lex_state = 74, .external_lex_state = 2},
  [2582] = {.lex_state = 74, .external_lex_state = 2},
  [2583] = {.lex_state = 74, .external_lex_state = 2},
  [2584] = {.lex_state = 74, .external_lex_state = 2},
  [2585] = {.lex_state = 74, .external_lex_state = 2},
  [2586] = {.lex_state = 74, .external_lex_state = 2},
  [2587] = {.lex_state = 74, .external_lex_state = 2},
  [2588] = {.lex_state = 74, .external_lex_state = 2},
  [2589] = {.lex_state = 74, .external_lex_state = 2},
  [2590] = {.lex_state = 74, .external_lex_state = 2},
  [2591] = {.lex_state = 74, .external_lex_state = 2},
  [2592] = {.lex_state = 74, .external_lex_state = 2},
  [2593] = {.lex_state = 74, .external_lex_state = 2},
  [2594] = {.lex_state = 74, .external_lex_state = 2},
  [2595] = {.lex_state = 74, .external_lex_state = 2},
  [2596] = {.lex_state = 74, .external_lex_state = 2},
  [2597] = {.lex_state = 74, .external_lex_state = 2},
  [2598] = {.lex_state = 74, .external_lex_state = 2},
  [2599] = {.lex_state = 74, .external_lex_state = 2},
  [2600] = {.lex_state = 74, .external_lex_state = 2},
  [2601] = {.lex_state = 74, .external_lex_state = 2},
  [2602] = {.lex_state = 74, .external_lex_state = 2},
  [2603] = {.lex_state = 74, .external_lex_state = 2},
  [2604] = {.lex_state = 74, .external_lex_state = 2},
  [2605] = {.lex_state = 74, .external_lex_state = 3},
  [2606] = {.lex_state = 74, .external_lex_state = 2},
  [2607] = {.lex_state = 74, .external_lex_state = 3},
  [2608] = {.lex_state = 74, .external_lex_state = 3},
  [2609] = {.lex_state = 74, .external_lex_state = 2},
  [2610] = {.lex_state = 74, .external_lex_state = 3},
  [2611] = {.lex_state = 74, .external_lex_state = 4},
  [2612] = {.lex_state = 74, .external_lex_state = 2},
  [2613] = {.lex_state = 74, .external_lex_state = 2},
  [2614] = {.lex_state = 74, .external_lex_state = 2},
  [2615] = {.lex_state = 74, .external_lex_state = 3},
  [2616] = {.lex_state = 74, .external_lex_state = 3},
  [2617] = {.lex_state = 74, .external_lex_state = 3},
  [2618] = {.lex_state = 74, .external_lex_state = 3},
  [2619] = {.lex_state = 74, .external_lex_state = 2},
  [2620] = {.lex_state = 74, .external_lex_state = 3},
  [2621] = {.lex_state = 74, .external_lex_state = 3},
  [2622] = {.lex_state = 74, .external_lex_state = 3},
  [2623] = {.lex_state = 75},
  [2624] = {.lex_state = 74, .external_lex_state = 3},
  [2625] = {.lex_state = 74, .external_lex_state = 3},
  [2626] = {.lex_state = 74, .external_lex_state = 3},
  [2627] = {.lex_state = 74, .external_lex_state = 3},
  [2628] = {.lex_state = 74, .external_lex_state = 3},
  [2629] = {.lex_state = 74, .external_lex_state = 3},
  [2630] = {.lex_state = 74, .external_lex_state = 4},
  [2631] = {.lex_state = 74, .external_lex_state = 3},
  [2632] = {.lex_state = 74, .external_lex_state = 3},
  [2633] = {.lex_state = 74, .external_lex_state = 3},
  [2634] = {.lex_state = 74, .external_lex_state = 4},
  [2635] = {.lex_state = 74, .external_lex_state = 3},
  [2636] = {.lex_state = 74, .external_lex_state = 3},
  [2637] = {.lex_state = 74, .external_lex_state = 3},
  [2638] = {.lex_state = 74, .external_lex_state = 2},
  [2639] = {.lex_state = 74, .external_lex_state = 3},
  [2640] = {.lex_state = 74, .external_lex_state = 2},
  [2641] = {.lex_state = 74, .external_lex_state = 3},
  [2642] = {.lex_state = 74, .external_lex_state = 3},
  [2643] = {.lex_state = 74, .external_lex_state = 2},
  [2644] = {.lex_state = 74, .external_lex_state = 3},
  [2645] = {.lex_state = 74, .external_lex_state = 4},
  [2646] = {.lex_state = 74, .external_lex_state = 3},
  [2647] = {.lex_state = 74, .external_lex_state = 3},
  [2648] = {.lex_state = 74, .external_lex_state = 2},
  [2649] = {.lex_state = 74, .external_lex_state = 4},
  [2650] = {.lex_state = 74, .external_lex_state = 3},
  [2651] = {.lex_state = 74, .external_lex_state = 3},
  [2652] = {.lex_state = 74, .external_lex_state = 3},
  [2653] = {.lex_state = 74, .external_lex_state = 2},
  [2654] = {.lex_state = 74, .external_lex_state = 2},
  [2655] = {.lex_state = 74, .external_lex_state = 3},
  [2656] = {.lex_state = 74, .external_lex_state = 3},
  [2657] = {.lex_state = 74, .external_lex_state = 3},
  [2658] = {.lex_state = 74, .external_lex_state = 2},
  [2659] = {.lex_state = 74, .external_lex_state = 2},
  [2660] = {.lex_state = 74, .external_lex_state = 3},
  [2661] = {.lex_state = 74, .external_lex_state = 4},
  [2662] = {.lex_state = 4, .external_lex_state = 3},
  [2663] = {.lex_state = 4, .external_lex_state = 3},
  [2664] = {.lex_state = 4, .external_lex_state = 3},
  [2665] = {.lex_state = 4, .external_lex_state = 3},
  [2666] = {.lex_state = 4, .external_lex_state = 3},
  [2667] = {.lex_state = 4, .external_lex_state = 3},
  [2668] = {.lex_state = 4, .external_lex_state = 3},
  [2669] = {.lex_state = 4, .external_lex_state = 3},
  [2670] = {.lex_state = 4, .external_lex_state = 3},
  [2671] = {.lex_state = 4, .external_lex_state = 3},
  [2672] = {.lex_state = 4, .external_lex_state = 3},
  [2673] = {.lex_state = 4, .external_lex_state = 3},
  [2674] = {.lex_state = 4, .external_lex_state = 3},
  [2675] = {.lex_state = 4, .external_lex_state = 3},
  [2676] = {.lex_state = 4, .external_lex_state = 3},
  [2677] = {.lex_state = 4, .external_lex_state = 3},
  [2678] = {.lex_state = 4, .external_lex_state = 3},
  [2679] = {.lex_state = 4, .external_lex_state = 3},
  [2680] = {.lex_state = 4, .external_lex_state = 3},
  [2681] = {.lex_state = 4, .external_lex_state = 3},
  [2682] = {.lex_state = 4, .external_lex_state = 3},
  [2683] = {.lex_state = 4, .external_lex_state = 3},
  [2684] = {.lex_state = 4, .external_lex_state = 3},
  [2685] = {.lex_state = 4, .external_lex_state = 3},
  [2686] = {.lex_state = 74, .external_lex_state = 2},
  [2687] = {.lex_state = 74, .external_lex_state = 2},
  [2688] = {.lex_state = 74, .external_lex_state = 3},
  [2689] = {.lex_state = 74, .external_lex_state = 3},
  [2690] = {.lex_state = 74, .external_lex_state = 3},
  [2691] = {.lex_state = 74, .external_lex_state = 3},
  [2692] = {.lex_state = 74, .external_lex_state = 4},
  [2693] = {.lex_state = 74, .external_lex_state = 3},
  [2694] = {.lex_state = 74, .external_lex_state = 3},
  [2695] = {.lex_state = 74, .external_lex_state = 3},
  [2696] = {.lex_state = 74, .external_lex_state = 3},
  [2697] = {.lex_state = 74, .external_lex_state = 3},
  [2698] = {.lex_state = 74, .external_lex_state = 3},
  [2699] = {.lex_state = 74, .external_lex_state = 3},
  [2700] = {.lex_state = 74, .external_lex_state = 3},
  [2701] = {.lex_state = 74, .external_lex_state = 3},
  [2702] = {.lex_state = 74, .external_lex_state = 3},
  [2703] = {.lex_state = 74, .external_lex_state = 3},
  [2704] = {.lex_state = 74, .external_lex_state = 3},
  [2705] = {.lex_state = 74, .external_lex_state = 3},
  [2706] = {.lex_state = 74, .external_lex_state = 3},
  [2707] = {.lex_state = 74, .external_lex_state = 3},
  [2708] = {.lex_state = 74, .external_lex_state = 3},
  [2709] = {.lex_state = 74, .external_lex_state = 4},
  [2710] = {.lex_state = 74, .external_lex_state = 4},
  [2711] = {.lex_state = 74, .external_lex_state = 3},
  [2712] = {.lex_state = 74, .external_lex_state = 4},
  [2713] = {.lex_state = 74, .external_lex_state = 3},
  [2714] = {.lex_state = 74, .external_lex_state = 3},
  [2715] = {.lex_state = 74, .external_lex_state = 3},
  [2716] = {.lex_state = 74, .external_lex_state = 3},
  [2717] = {.lex_state = 74, .external_lex_state = 3},
  [2718] = {.lex_state = 74, .external_lex_state = 3},
  [2719] = {.lex_state = 74, .external_lex_state = 2},
  [2720] = {.lex_state = 74, .external_lex_state = 2},
  [2721] = {.lex_state = 74, .external_lex_state = 3},
  [2722] = {.lex_state = 74, .external_lex_state = 3},
  [2723] = {.lex_state = 74, .external_lex_state = 3},
  [2724] = {.lex_state = 74, .external_lex_state = 3},
  [2725] = {.lex_state = 74, .external_lex_state = 3},
  [2726] = {.lex_state = 74, .external_lex_state = 3},
  [2727] = {.lex_state = 74, .external_lex_state = 2},
  [2728] = {.lex_state = 74, .external_lex_state = 3},
  [2729] = {.lex_state = 74, .external_lex_state = 3},
  [2730] = {.lex_state = 5, .external_lex_state = 4},
  [2731] = {.lex_state = 74, .external_lex_state = 3},
  [2732] = {.lex_state = 74, .external_lex_state = 3},
  [2733] = {.lex_state = 74, .external_lex_state = 3},
  [2734] = {.lex_state = 74, .external_lex_state = 2},
  [2735] = {.lex_state = 74, .external_lex_state = 2},
  [2736] = {.lex_state = 74, .external_lex_state = 3},
  [2737] = {.lex_state = 74, .external_lex_state = 3},
  [2738] = {.lex_state = 74, .external_lex_state = 3},
  [2739] = {.lex_state = 74, .external_lex_state = 2},
  [2740] = {.lex_state = 74, .external_lex_state = 2},
  [2741] = {.lex_state = 74, .external_lex_state = 2},
  [2742] = {.lex_state = 74, .external_lex_state = 2},
  [2743] = {.lex_state = 74, .external_lex_state = 2},
  [2744] = {.lex_state = 74, .external_lex_state = 2},
  [2745] = {.lex_state = 74, .external_lex_state = 2},
  [2746] = {.lex_state = 74, .external_lex_state = 3},
  [2747] = {.lex_state = 74, .external_lex_state = 2},
  [2748] = {.lex_state = 74, .external_lex_state = 3},
  [2749] = {.lex_state = 74, .external_lex_state = 3},
  [2750] = {.lex_state = 74, .external_lex_state = 2},
  [2751] = {.lex_state = 74, .external_lex_state = 2},
  [2752] = {.lex_state = 74, .external_lex_state = 3},
  [2753] = {.lex_state = 74, .external_lex_state = 2},
  [2754] = {.lex_state = 74, .external_lex_state = 3},
  [2755] = {.lex_state = 74, .external_lex_state = 3},
  [2756] = {.lex_state = 74, .external_lex_state = 4},
  [2757] = {.lex_state = 74, .external_lex_state = 2},
  [2758] = {.lex_state = 74, .external_lex_state = 2},
  [2759] = {.lex_state = 74, .external_lex_state = 2},
  [2760] = {.lex_state = 74, .external_lex_state = 3},
  [2761] = {.lex_state = 74, .external_lex_state = 2},
  [2762] = {.lex_state = 74, .external_lex_state = 4},
  [2763] = {.lex_state = 74, .external_lex_state = 4},
  [2764] = {.lex_state = 74, .external_lex_state = 4},
  [2765] = {.lex_state = 74, .external_lex_state = 4},
  [2766] = {.lex_state = 74, .external_lex_state = 3},
  [2767] = {.lex_state = 74, .external_lex_state = 2},
  [2768] = {.lex_state = 74, .external_lex_state = 3},
  [2769] = {.lex_state = 4, .external_lex_state = 3},
  [2770] = {.lex_state = 74, .external_lex_state = 2},
  [2771] = {.lex_state = 74, .external_lex_state = 4},
  [2772] = {.lex_state = 74, .external_lex_state = 4},
  [2773] = {.lex_state = 74, .external_lex_state = 4},
  [2774] = {.lex_state = 74, .external_lex_state = 3},
  [2775] = {.lex_state = 74, .external_lex_state = 3},
  [2776] = {.lex_state = 74, .external_lex_state = 3},
  [2777] = {.lex_state = 74, .external_lex_state = 2},
  [2778] = {.lex_state = 74, .external_lex_state = 2},
  [2779] = {.lex_state = 74, .external_lex_state = 3},
  [2780] = {.lex_state = 74, .external_lex_state = 2},
  [2781] = {.lex_state = 74, .external_lex_state = 4},
  [2782] = {.lex_state = 4, .external_lex_state = 3},
  [2783] = {.lex_state = 4, .external_lex_state = 3},
  [2784] = {.lex_state = 74, .external_lex_state = 4},
  [2785] = {.lex_state = 74, .external_lex_state = 3},
  [2786] = {.lex_state = 74, .external_lex_state = 3},
  [2787] = {.lex_state = 74, .external_lex_state = 3},
  [2788] = {.lex_state = 74, .external_lex_state = 4},
  [2789] = {.lex_state = 74, .external_lex_state = 3},
  [2790] = {.lex_state = 74, .external_lex_state = 4},
  [2791] = {.lex_state = 74, .external_lex_state = 3},
  [2792] = {.lex_state = 74, .external_lex_state = 3},
  [2793] = {.lex_state = 74, .external_lex_state = 3},
  [2794] = {.lex_state = 74, .external_lex_state = 4},
  [2795] = {.lex_state = 74, .external_lex_state = 4},
  [2796] = {.lex_state = 74, .external_lex_state = 3},
  [2797] = {.lex_state = 74, .external_lex_state = 4},
  [2798] = {.lex_state = 74, .external_lex_state = 2},
  [2799] = {.lex_state = 74, .external_lex_state = 4},
  [2800] = {.lex_state = 74, .external_lex_state = 3},
  [2801] = {.lex_state = 74, .external_lex_state = 3},
  [2802] = {.lex_state = 74, .external_lex_state = 3},
  [2803] = {.lex_state = 4, .external_lex_state = 2},
  [2804] = {.lex_state = 74, .external_lex_state = 4},
  [2805] = {.lex_state = 74, .external_lex_state = 3},
  [2806] = {.lex_state = 74, .external_lex_state = 3},
  [2807] = {.lex_state = 74, .external_lex_state = 3},
  [2808] = {.lex_state = 74, .external_lex_state = 3},
  [2809] = {.lex_state = 74, .external_lex_state = 4},
  [2810] = {.lex_state = 74, .external_lex_state = 3},
  [2811] = {.lex_state = 74, .external_lex_state = 3},
  [2812] = {.lex_state = 74, .external_lex_state = 3},
  [2813] = {.lex_state = 74, .external_lex_state = 3},
  [2814] = {.lex_state = 74, .external_lex_state = 2},
  [2815] = {.lex_state = 74, .external_lex_state = 4},
  [2816] = {.lex_state = 74, .external_lex_state = 4},
  [2817] = {.lex_state = 4, .external_lex_state = 3},
  [2818] = {.lex_state = 4, .external_lex_state = 3},
  [2819] = {.lex_state = 74, .external_lex_state = 4},
  [2820] = {.lex_state = 74, .external_lex_state = 3},
  [2821] = {.lex_state = 74, .external_lex_state = 4},
  [2822] = {.lex_state = 74, .external_lex_state = 2},
  [2823] = {.lex_state = 74, .external_lex_state = 4},
  [2824] = {.lex_state = 74, .external_lex_state = 3},
  [2825] = {.lex_state = 74, .external_lex_state = 3},
  [2826] = {.lex_state = 74, .external_lex_state = 4},
  [2827] = {.lex_state = 4, .external_lex_state = 3},
  [2828] = {.lex_state = 4, .external_lex_state = 3},
  [2829] = {.lex_state = 4, .external_lex_state = 3},
  [2830] = {.lex_state = 74, .external_lex_state = 3},
  [2831] = {.lex_state = 74, .external_lex_state = 4},
  [2832] = {.lex_state = 4, .external_lex_state = 3},
  [2833] = {.lex_state = 74, .external_lex_state = 4},
  [2834] = {.lex_state = 4, .external_lex_state = 3},
  [2835] = {.lex_state = 74, .external_lex_state = 4},
  [2836] = {.lex_state = 74, .external_lex_state = 4},
  [2837] = {.lex_state = 74, .external_lex_state = 4},
  [2838] = {.lex_state = 74, .external_lex_state = 4},
  [2839] = {.lex_state = 74, .external_lex_state = 4},
  [2840] = {.lex_state = 74, .external_lex_state = 4},
  [2841] = {.lex_state = 74, .external_lex_state = 4},
  [2842] = {.lex_state = 74, .external_lex_state = 4},
  [2843] = {.lex_state = 74, .external_lex_state = 2},
  [2844] = {.lex_state = 74, .external_lex_state = 3},
  [2845] = {.lex_state = 74, .external_lex_state = 2},
  [2846] = {.lex_state = 74, .external_lex_state = 3},
  [2847] = {.lex_state = 74, .external_lex_state = 2},
  [2848] = {.lex_state = 74, .external_lex_state = 4},
  [2849] = {.lex_state = 4, .external_lex_state = 3},
  [2850] = {.lex_state = 74, .external_lex_state = 4},
  [2851] = {.lex_state = 74, .external_lex_state = 4},
  [2852] = {.lex_state = 74, .external_lex_state = 4},
  [2853] = {.lex_state = 74, .external_lex_state = 4},
  [2854] = {.lex_state = 74, .external_lex_state = 3},
  [2855] = {.lex_state = 74, .external_lex_state = 4},
  [2856] = {.lex_state = 74, .external_lex_state = 2},
  [2857] = {.lex_state = 74, .external_lex_state = 3},
  [2858] = {.lex_state = 4, .external_lex_state = 3},
  [2859] = {.lex_state = 74, .external_lex_state = 4},
  [2860] = {.lex_state = 74, .external_lex_state = 4},
  [2861] = {.lex_state = 74, .external_lex_state = 4},
  [2862] = {.lex_state = 74, .external_lex_state = 4},
  [2863] = {.lex_state = 74, .external_lex_state = 4},
  [2864] = {.lex_state = 4, .external_lex_state = 3},
  [2865] = {.lex_state = 74, .external_lex_state = 4},
  [2866] = {.lex_state = 74, .external_lex_state = 4},
  [2867] = {.lex_state = 4, .external_lex_state = 3},
  [2868] = {.lex_state = 74, .external_lex_state = 4},
  [2869] = {.lex_state = 4, .external_lex_state = 3},
  [2870] = {.lex_state = 74, .external_lex_state = 4},
  [2871] = {.lex_state = 74, .external_lex_state = 4},
  [2872] = {.lex_state = 74, .external_lex_state = 4},
  [2873] = {.lex_state = 4, .external_lex_state = 3},
  [2874] = {.lex_state = 74, .external_lex_state = 4},
  [2875] = {.lex_state = 74, .external_lex_state = 4},
  [2876] = {.lex_state = 74, .external_lex_state = 4},
  [2877] = {.lex_state = 74, .external_lex_state = 4},
  [2878] = {.lex_state = 74, .external_lex_state = 4},
  [2879] = {.lex_state = 74, .external_lex_state = 4},
  [2880] = {.lex_state = 74, .external_lex_state = 4},
  [2881] = {.lex_state = 74, .external_lex_state = 4},
  [2882] = {.lex_state = 74, .external_lex_state = 4},
  [2883] = {.lex_state = 74, .external_lex_state = 4},
  [2884] = {.lex_state = 74, .external_lex_state = 4},
  [2885] = {.lex_state = 74, .external_lex_state = 4},
  [2886] = {.lex_state = 74, .external_lex_state = 4},
  [2887] = {.lex_state = 74, .external_lex_state = 3},
  [2888] = {.lex_state = 4, .external_lex_state = 3},
  [2889] = {.lex_state = 74, .external_lex_state = 3},
  [2890] = {.lex_state = 74, .external_lex_state = 4},
  [2891] = {.lex_state = 74, .external_lex_state = 4},
  [2892] = {.lex_state = 74, .external_lex_state = 4},
  [2893] = {.lex_state = 74, .external_lex_state = 3},
  [2894] = {.lex_state = 74, .external_lex_state = 4},
  [2895] = {.lex_state = 74, .external_lex_state = 4},
  [2896] = {.lex_state = 74, .external_lex_state = 4},
  [2897] = {.lex_state = 74, .external_lex_state = 4},
  [2898] = {.lex_state = 74, .external_lex_state = 4},
  [2899] = {.lex_state = 74, .external_lex_state = 4},
  [2900] = {.lex_state = 4, .external_lex_state = 3},
  [2901] = {.lex_state = 74, .external_lex_state = 4},
  [2902] = {.lex_state = 74, .external_lex_state = 3},
  [2903] = {.lex_state = 74, .external_lex_state = 4},
  [2904] = {.lex_state = 74, .external_lex_state = 4},
  [2905] = {.lex_state = 74, .external_lex_state = 4},
  [2906] = {.lex_state = 74, .external_lex_state = 4},
  [2907] = {.lex_state = 74, .external_lex_state = 4},
  [2908] = {.lex_state = 74, .external_lex_state = 4},
  [2909] = {.lex_state = 74, .external_lex_state = 4},
  [2910] = {.lex_state = 74, .external_lex_state = 4},
  [2911] = {.lex_state = 74, .external_lex_state = 3},
  [2912] = {.lex_state = 4, .external_lex_state = 3},
  [2913] = {.lex_state = 74, .external_lex_state = 4},
  [2914] = {.lex_state = 4, .external_lex_state = 3},
  [2915] = {.lex_state = 74, .external_lex_state = 4},
  [2916] = {.lex_state = 74, .external_lex_state = 4},
  [2917] = {.lex_state = 74, .external_lex_state = 4},
  [2918] = {.lex_state = 74, .external_lex_state = 3},
  [2919] = {.lex_state = 74, .external_lex_state = 3},
  [2920] = {.lex_state = 74, .external_lex_state = 3},
  [2921] = {.lex_state = 74, .external_lex_state = 3},
  [2922] = {.lex_state = 74, .external_lex_state = 3},
  [2923] = {.lex_state = 74, .external_lex_state = 4},
  [2924] = {.lex_state = 74, .external_lex_state = 4},
  [2925] = {.lex_state = 74, .external_lex_state = 3},
  [2926] = {.lex_state = 74, .external_lex_state = 3},
  [2927] = {.lex_state = 74, .external_lex_state = 4},
  [2928] = {.lex_state = 74, .external_lex_state = 3},
  [2929] = {.lex_state = 74, .external_lex_state = 3},
  [2930] = {.lex_state = 74, .external_lex_state = 3},
  [2931] = {.lex_state = 5, .external_lex_state = 3},
  [2932] = {.lex_state = 74, .external_lex_state = 4},
  [2933] = {.lex_state = 74, .external_lex_state = 4},
  [2934] = {.lex_state = 74, .external_lex_state = 3},
  [2935] = {.lex_state = 74, .external_lex_state = 3},
  [2936] = {.lex_state = 74, .external_lex_state = 4},
  [2937] = {.lex_state = 74, .external_lex_state = 4},
  [2938] = {.lex_state = 74, .external_lex_state = 4},
  [2939] = {.lex_state = 74, .external_lex_state = 4},
  [2940] = {.lex_state = 4, .external_lex_state = 3},
  [2941] = {.lex_state = 74, .external_lex_state = 4},
  [2942] = {.lex_state = 74, .external_lex_state = 3},
  [2943] = {.lex_state = 74, .external_lex_state = 4},
  [2944] = {.lex_state = 74, .external_lex_state = 3},
  [2945] = {.lex_state = 74, .external_lex_state = 3},
  [2946] = {.lex_state = 74, .external_lex_state = 3},
  [2947] = {.lex_state = 74, .external_lex_state = 3},
  [2948] = {.lex_state = 74, .external_lex_state = 4},
  [2949] = {.lex_state = 74, .external_lex_state = 4},
  [2950] = {.lex_state = 74, .external_lex_state = 3},
  [2951] = {.lex_state = 74, .external_lex_state = 3},
  [2952] = {.lex_state = 74, .external_lex_state = 4},
  [2953] = {.lex_state = 74, .external_lex_state = 4},
  [2954] = {.lex_state = 74, .external_lex_state = 4},
  [2955] = {.lex_state = 74, .external_lex_state = 4},
  [2956] = {.lex_state = 74, .external_lex_state = 3},
  [2957] = {.lex_state = 74, .external_lex_state = 3},
  [2958] = {.lex_state = 74, .external_lex_state = 4},
  [2959] = {.lex_state = 74, .external_lex_state = 4},
  [2960] = {.lex_state = 74, .external_lex_state = 3},
  [2961] = {.lex_state = 74, .external_lex_state = 2},
  [2962] = {.lex_state = 74, .external_lex_state = 4},
  [2963] = {.lex_state = 74, .external_lex_state = 2},
  [2964] = {.lex_state = 74, .external_lex_state = 2},
  [2965] = {.lex_state = 74, .external_lex_state = 2},
  [2966] = {.lex_state = 74, .external_lex_state = 2},
  [2967] = {.lex_state = 74, .external_lex_state = 4},
  [2968] = {.lex_state = 74, .external_lex_state = 3},
  [2969] = {.lex_state = 74, .external_lex_state = 3},
  [2970] = {.lex_state = 74, .external_lex_state = 4},
  [2971] = {.lex_state = 74, .external_lex_state = 3},
  [2972] = {.lex_state = 74, .external_lex_state = 4},
  [2973] = {.lex_state = 74, .external_lex_state = 3},
  [2974] = {.lex_state = 74, .external_lex_state = 3},
  [2975] = {.lex_state = 74, .external_lex_state = 3},
  [2976] = {.lex_state = 74, .external_lex_state = 3},
  [2977] = {.lex_state = 74, .external_lex_state = 4},
  [2978] = {.lex_state = 74, .external_lex_state = 4},
  [2979] = {.lex_state = 74, .external_lex_state = 4},
  [2980] = {.lex_state = 74, .external_lex_state = 3},
  [2981] = {.lex_state = 74, .external_lex_state = 2},
  [2982] = {.lex_state = 74, .external_lex_state = 3},
  [2983] = {.lex_state = 74, .external_lex_state = 2},
  [2984] = {.lex_state = 74, .external_lex_state = 2},
  [2985] = {.lex_state = 74, .external_lex_state = 3},
  [2986] = {.lex_state = 74, .external_lex_state = 4},
  [2987] = {.lex_state = 74, .external_lex_state = 4},
  [2988] = {.lex_state = 74, .external_lex_state = 3},
  [2989] = {.lex_state = 74, .external_lex_state = 3},
  [2990] = {.lex_state = 74, .external_lex_state = 2},
  [2991] = {.lex_state = 74, .external_lex_state = 2},
  [2992] = {.lex_state = 74, .external_lex_state = 3},
  [2993] = {.lex_state = 74, .external_lex_state = 2},
  [2994] = {.lex_state = 74, .external_lex_state = 3},
  [2995] = {.lex_state = 4, .external_lex_state = 3},
  [2996] = {.lex_state = 4, .external_lex_state = 3},
  [2997] = {.lex_state = 74, .external_lex_state = 2},
  [2998] = {.lex_state = 74, .external_lex_state = 2},
  [2999] = {.lex_state = 74, .external_lex_state = 2},
  [3000] = {.lex_state = 74, .external_lex_state = 3},
  [3001] = {.lex_state = 74, .external_lex_state = 4},
  [3002] = {.lex_state = 74, .external_lex_state = 3},
  [3003] = {.lex_state = 74, .external_lex_state = 4},
  [3004] = {.lex_state = 4, .external_lex_state = 3},
  [3005] = {.lex_state = 74, .external_lex_state = 3},
  [3006] = {.lex_state = 74, .external_lex_state = 2},
  [3007] = {.lex_state = 74, .external_lex_state = 2},
  [3008] = {.lex_state = 74, .external_lex_state = 2},
  [3009] = {.lex_state = 74, .external_lex_state = 3},
  [3010] = {.lex_state = 74, .external_lex_state = 3},
  [3011] = {.lex_state = 74, .external_lex_state = 3},
  [3012] = {.lex_state = 74, .external_lex_state = 4},
  [3013] = {.lex_state = 74, .external_lex_state = 4},
  [3014] = {.lex_state = 74, .external_lex_state = 3},
  [3015] = {.lex_state = 74, .external_lex_state = 3},
  [3016] = {.lex_state = 74, .external_lex_state = 3},
  [3017] = {.lex_state = 74, .external_lex_state = 2},
  [3018] = {.lex_state = 74, .external_lex_state = 3},
  [3019] = {.lex_state = 74, .external_lex_state = 3},
  [3020] = {.lex_state = 74, .external_lex_state = 3},
  [3021] = {.lex_state = 74, .external_lex_state = 2},
  [3022] = {.lex_state = 74, .external_lex_state = 2},
  [3023] = {.lex_state = 74, .external_lex_state = 4},
  [3024] = {.lex_state = 74, .external_lex_state = 3},
  [3025] = {.lex_state = 74, .external_lex_state = 4},
  [3026] = {.lex_state = 74, .external_lex_state = 2},
  [3027] = {.lex_state = 74, .external_lex_state = 4},
  [3028] = {.lex_state = 74, .external_lex_state = 2},
  [3029] = {.lex_state = 74, .external_lex_state = 2},
  [3030] = {.lex_state = 74, .external_lex_state = 2},
  [3031] = {.lex_state = 74, .external_lex_state = 4},
  [3032] = {.lex_state = 74, .external_lex_state = 4},
  [3033] = {.lex_state = 74, .external_lex_state = 3},
  [3034] = {.lex_state = 74, .external_lex_state = 4},
  [3035] = {.lex_state = 74, .external_lex_state = 4},
  [3036] = {.lex_state = 74, .external_lex_state = 3},
  [3037] = {.lex_state = 74, .external_lex_state = 4},
  [3038] = {.lex_state = 74, .external_lex_state = 2},
  [3039] = {.lex_state = 74, .external_lex_state = 4},
  [3040] = {.lex_state = 74, .external_lex_state = 3},
  [3041] = {.lex_state = 74, .external_lex_state = 3},
  [3042] = {.lex_state = 74, .external_lex_state = 2},
  [3043] = {.lex_state = 74, .external_lex_state = 3},
  [3044] = {.lex_state = 74, .external_lex_state = 2},
  [3045] = {.lex_state = 74, .external_lex_state = 3},
  [3046] = {.lex_state = 74, .external_lex_state = 4},
  [3047] = {.lex_state = 74, .external_lex_state = 4},
  [3048] = {.lex_state = 74, .external_lex_state = 4},
  [3049] = {.lex_state = 4, .external_lex_state = 3},
  [3050] = {.lex_state = 74, .external_lex_state = 2},
  [3051] = {.lex_state = 74, .external_lex_state = 4},
  [3052] = {.lex_state = 74, .external_lex_state = 4},
  [3053] = {.lex_state = 74, .external_lex_state = 3},
  [3054] = {.lex_state = 74, .external_lex_state = 3},
  [3055] = {.lex_state = 4, .external_lex_state = 3},
  [3056] = {.lex_state = 74, .external_lex_state = 4},
  [3057] = {.lex_state = 74, .external_lex_state = 4},
  [3058] = {.lex_state = 4, .external_lex_state = 3},
  [3059] = {.lex_state = 4, .external_lex_state = 3},
  [3060] = {.lex_state = 74, .external_lex_state = 4},
  [3061] = {.lex_state = 74, .external_lex_state = 4},
  [3062] = {.lex_state = 74, .external_lex_state = 3},
  [3063] = {.lex_state = 74, .external_lex_state = 3},
  [3064] = {.lex_state = 74, .external_lex_state = 2},
  [3065] = {.lex_state = 74, .external_lex_state = 2},
  [3066] = {.lex_state = 74, .external_lex_state = 3},
  [3067] = {.lex_state = 74, .external_lex_state = 2},
  [3068] = {.lex_state = 74, .external_lex_state = 3},
  [3069] = {.lex_state = 74, .external_lex_state = 3},
  [3070] = {.lex_state = 74, .external_lex_state = 3},
  [3071] = {.lex_state = 74, .external_lex_state = 2},
  [3072] = {.lex_state = 74, .external_lex_state = 2},
  [3073] = {.lex_state = 74, .external_lex_state = 3},
  [3074] = {.lex_state = 74, .external_lex_state = 3},
  [3075] = {.lex_state = 74, .external_lex_state = 2},
  [3076] = {.lex_state = 74, .external_lex_state = 3},
  [3077] = {.lex_state = 74, .external_lex_state = 3},
  [3078] = {.lex_state = 74, .external_lex_state = 3},
  [3079] = {.lex_state = 75, .external_lex_state = 5},
  [3080] = {.lex_state = 74, .external_lex_state = 2},
  [3081] = {.lex_state = 75, .external_lex_state = 5},
  [3082] = {.lex_state = 75, .external_lex_state = 5},
  [3083] = {.lex_state = 74, .external_lex_state = 3},
  [3084] = {.lex_state = 74, .external_lex_state = 2},
  [3085] = {.lex_state = 74, .external_lex_state = 3},
  [3086] = {.lex_state = 11},
  [3087] = {.lex_state = 74, .external_lex_state = 2},
  [3088] = {.lex_state = 74, .external_lex_state = 2},
  [3089] = {.lex_state = 74, .external_lex_state = 2},
  [3090] = {.lex_state = 74, .external_lex_state = 2},
  [3091] = {.lex_state = 74, .external_lex_state = 2},
  [3092] = {.lex_state = 74, .external_lex_state = 2},
  [3093] = {.lex_state = 74, .external_lex_state = 2},
  [3094] = {.lex_state = 4, .external_lex_state = 3},
  [3095] = {.lex_state = 4, .external_lex_state = 2},
  [3096] = {.lex_state = 11},
  [3097] = {.lex_state = 75, .external_lex_state = 5},
  [3098] = {.lex_state = 75, .external_lex_state = 5},
  [3099] = {.lex_state = 74, .external_lex_state = 2},
  [3100] = {.lex_state = 74, .external_lex_state = 3},
  [3101] = {.lex_state = 74, .external_lex_state = 2},
  [3102] = {.lex_state = 74, .external_lex_state = 3},
  [3103] = {.lex_state = 74, .external_lex_state = 2},
  [3104] = {.lex_state = 5, .external_lex_state = 3},
  [3105] = {.lex_state = 74, .external_lex_state = 3},
  [3106] = {.lex_state = 74, .external_lex_state = 3},
  [3107] = {.lex_state = 74, .external_lex_state = 2},
  [3108] = {.lex_state = 74, .external_lex_state = 2},
  [3109] = {.lex_state = 74, .external_lex_state = 3},
  [3110] = {.lex_state = 74, .external_lex_state = 3},
  [3111] = {.lex_state = 74, .external_lex_state = 3},
  [3112] = {.lex_state = 74, .external_lex_state = 2},
  [3113] = {.lex_state = 74, .external_lex_state = 2},
  [3114] = {.lex_state = 4, .external_lex_state = 3},
  [3115] = {.lex_state = 4, .external_lex_state = 3},
  [3116] = {.lex_state = 75, .external_lex_state = 5},
  [3117] = {.lex_state = 74, .external_lex_state = 2},
  [3118] = {.lex_state = 74, .external_lex_state = 3},
  [3119] = {.lex_state = 74, .external_lex_state = 3},
  [3120] = {.lex_state = 74, .external_lex_state = 3},
  [3121] = {.lex_state = 4, .external_lex_state = 3},
  [3122] = {.lex_state = 11},
  [3123] = {.lex_state = 74, .external_lex_state = 3},
  [3124] = {.lex_state = 74, .external_lex_state = 2},
  [3125] = {.lex_state = 74, .external_lex_state = 2},
  [3126] = {.lex_state = 74, .external_lex_state = 2},
  [3127] = {.lex_state = 74, .external_lex_state = 3},
  [3128] = {.lex_state = 74, .external_lex_state = 2},
  [3129] = {.lex_state = 74, .external_lex_state = 3},
  [3130] = {.lex_state = 74, .external_lex_state = 3},
  [3131] = {.lex_state = 75, .external_lex_state = 5},
  [3132] = {.lex_state = 74, .external_lex_state = 2},
  [3133] = {.lex_state = 74, .external_lex_state = 2},
  [3134] = {.lex_state = 74, .external_lex_state = 2},
  [3135] = {.lex_state = 74, .external_lex_state = 2},
  [3136] = {.lex_state = 74, .external_lex_state = 2},
  [3137] = {.lex_state = 4, .external_lex_state = 2},
  [3138] = {.lex_state = 74, .external_lex_state = 3},
  [3139] = {.lex_state = 75, .external_lex_state = 5},
  [3140] = {.lex_state = 74, .external_lex_state = 2},
  [3141] = {.lex_state = 74, .external_lex_state = 2},
  [3142] = {.lex_state = 75, .external_lex_state = 5},
  [3143] = {.lex_state = 74, .external_lex_state = 2},
  [3144] = {.lex_state = 74, .external_lex_state = 3},
  [3145] = {.lex_state = 74, .external_lex_state = 3},
  [3146] = {.lex_state = 74, .external_lex_state = 3},
  [3147] = {.lex_state = 74, .external_lex_state = 2},
  [3148] = {.lex_state = 11},
  [3149] = {.lex_state = 74, .external_lex_state = 2},
  [3150] = {.lex_state = 4, .external_lex_state = 3},
  [3151] = {.lex_state = 74, .external_lex_state = 2},
  [3152] = {.lex_state = 74, .external_lex_state = 3},
  [3153] = {.lex_state = 74, .external_lex_state = 3},
  [3154] = {.lex_state = 74, .external_lex_state = 3},
  [3155] = {.lex_state = 74, .external_lex_state = 4},
  [3156] = {.lex_state = 74, .external_lex_state = 2},
  [3157] = {.lex_state = 74, .external_lex_state = 3},
  [3158] = {.lex_state = 74, .external_lex_state = 2},
  [3159] = {.lex_state = 74, .external_lex_state = 3},
  [3160] = {.lex_state = 74, .external_lex_state = 2},
  [3161] = {.lex_state = 74, .external_lex_state = 2},
  [3162] = {.lex_state = 4, .external_lex_state = 3},
  [3163] = {.lex_state = 11},
  [3164] = {.lex_state = 75, .external_lex_state = 5},
  [3165] = {.lex_state = 11},
  [3166] = {.lex_state = 11},
  [3167] = {.lex_state = 74, .external_lex_state = 3},
  [3168] = {.lex_state = 75, .external_lex_state = 5},
  [3169] = {.lex_state = 74, .external_lex_state = 3},
  [3170] = {.lex_state = 5, .external_lex_state = 2},
  [3171] = {.lex_state = 74, .external_lex_state = 2},
  [3172] = {.lex_state = 74, .external_lex_state = 2},
  [3173] = {.lex_state = 74, .external_lex_state = 2},
  [3174] = {.lex_state = 74, .external_lex_state = 3},
  [3175] = {.lex_state = 74, .external_lex_state = 2},
  [3176] = {.lex_state = 75, .external_lex_state = 5},
  [3177] = {.lex_state = 75, .external_lex_state = 5},
  [3178] = {.lex_state = 75, .external_lex_state = 5},
  [3179] = {.lex_state = 4, .external_lex_state = 3},
  [3180] = {.lex_state = 4, .external_lex_state = 3},
  [3181] = {.lex_state = 11},
  [3182] = {.lex_state = 75, .external_lex_state = 5},
  [3183] = {.lex_state = 4, .external_lex_state = 3},
  [3184] = {.lex_state = 74, .external_lex_state = 4},
  [3185] = {.lex_state = 4, .external_lex_state = 3},
  [3186] = {.lex_state = 74, .external_lex_state = 2},
  [3187] = {.lex_state = 74, .external_lex_state = 3},
  [3188] = {.lex_state = 74, .external_lex_state = 2},
  [3189] = {.lex_state = 74, .external_lex_state = 2},
  [3190] = {.lex_state = 75, .external_lex_state = 5},
  [3191] = {.lex_state = 75, .external_lex_state = 5},
  [3192] = {.lex_state = 74, .external_lex_state = 2},
  [3193] = {.lex_state = 74, .external_lex_state = 2},
  [3194] = {.lex_state = 75, .external_lex_state = 5},
  [3195] = {.lex_state = 74, .external_lex_state = 2},
  [3196] = {.lex_state = 74, .external_lex_state = 2},
  [3197] = {.lex_state = 11},
  [3198] = {.lex_state = 74, .external_lex_state = 3},
  [3199] = {.lex_state = 74, .external_lex_state = 3},
  [3200] = {.lex_state = 74, .external_lex_state = 2},
  [3201] = {.lex_state = 74, .external_lex_state = 2},
  [3202] = {.lex_state = 74, .external_lex_state = 2},
  [3203] = {.lex_state = 74, .external_lex_state = 3},
  [3204] = {.lex_state = 11},
  [3205] = {.lex_state = 4, .external_lex_state = 3},
  [3206] = {.lex_state = 74, .external_lex_state = 3},
  [3207] = {.lex_state = 74, .external_lex_state = 2},
  [3208] = {.lex_state = 74, .external_lex_state = 2},
  [3209] = {.lex_state = 4, .external_lex_state = 3},
  [3210] = {.lex_state = 4, .external_lex_state = 3},
  [3211] = {.lex_state = 74, .external_lex_state = 2},
  [3212] = {.lex_state = 74, .external_lex_state = 2},
  [3213] = {.lex_state = 74, .external_lex_state = 2},
  [3214] = {.lex_state = 74, .external_lex_state = 3},
  [3215] = {.lex_state = 74, .external_lex_state = 2},
  [3216] = {.lex_state = 74, .external_lex_state = 3},
  [3217] = {.lex_state = 74, .external_lex_state = 3},
  [3218] = {.lex_state = 4, .external_lex_state = 3},
  [3219] = {.lex_state = 74, .external_lex_state = 3},
  [3220] = {.lex_state = 74, .external_lex_state = 3},
  [3221] = {.lex_state = 4, .external_lex_state = 3},
  [3222] = {.lex_state = 74, .external_lex_state = 4},
  [3223] = {.lex_state = 74, .external_lex_state = 3},
  [3224] = {.lex_state = 74, .external_lex_state = 3},
  [3225] = {.lex_state = 74, .external_lex_state = 3},
  [3226] = {.lex_state = 74, .external_lex_state = 3},
  [3227] = {.lex_state = 74, .external_lex_state = 3},
  [3228] = {.lex_state = 74, .external_lex_state = 3},
  [3229] = {.lex_state = 74, .external_lex_state = 3},
  [3230] = {.lex_state = 74, .external_lex_state = 3},
  [3231] = {.lex_state = 74, .external_lex_state = 3},
  [3232] = {.lex_state = 74, .external_lex_state = 2},
  [3233] = {.lex_state = 74, .external_lex_state = 4},
  [3234] = {.lex_state = 4, .external_lex_state = 3},
  [3235] = {.lex_state = 74, .external_lex_state = 3},
  [3236] = {.lex_state = 74, .external_lex_state = 2},
  [3237] = {.lex_state = 75, .external_lex_state = 5},
  [3238] = {.lex_state = 74, .external_lex_state = 2},
  [3239] = {.lex_state = 74, .external_lex_state = 2},
  [3240] = {.lex_state = 75, .external_lex_state = 5},
  [3241] = {.lex_state = 75, .external_lex_state = 5},
  [3242] = {.lex_state = 74, .external_lex_state = 2},
  [3243] = {.lex_state = 74, .external_lex_state = 2},
  [3244] = {.lex_state = 74, .external_lex_state = 2},
  [3245] = {.lex_state = 74, .external_lex_state = 2},
  [3246] = {.lex_state = 11},
  [3247] = {.lex_state = 74, .external_lex_state = 2},
  [3248] = {.lex_state = 74, .external_lex_state = 2},
  [3249] = {.lex_state = 74, .external_lex_state = 2},
  [3250] = {.lex_state = 11},
  [3251] = {.lex_state = 11},
  [3252] = {.lex_state = 74, .external_lex_state = 2},
  [3253] = {.lex_state = 74, .external_lex_state = 2},
  [3254] = {.lex_state = 74, .external_lex_state = 2},
  [3255] = {.lex_state = 74, .external_lex_state = 4},
  [3256] = {.lex_state = 74, .external_lex_state = 2},
  [3257] = {.lex_state = 74, .external_lex_state = 3},
  [3258] = {.lex_state = 74, .external_lex_state = 2},
  [3259] = {.lex_state = 74, .external_lex_state = 3},
  [3260] = {.lex_state = 74, .external_lex_state = 2},
  [3261] = {.lex_state = 74, .external_lex_state = 2},
  [3262] = {.lex_state = 74, .external_lex_state = 3},
  [3263] = {.lex_state = 74, .external_lex_state = 3},
  [3264] = {.lex_state = 75, .external_lex_state = 5},
  [3265] = {.lex_state = 75, .external_lex_state = 5},
  [3266] = {.lex_state = 75, .external_lex_state = 5},
  [3267] = {.lex_state = 74, .external_lex_state = 3},
  [3268] = {.lex_state = 74, .external_lex_state = 3},
  [3269] = {.lex_state = 74, .external_lex_state = 3},
  [3270] = {.lex_state = 74, .external_lex_state = 3},
  [3271] = {.lex_state = 74, .external_lex_state = 3},
  [3272] = {.lex_state = 74, .external_lex_state = 3},
  [3273] = {.lex_state = 74, .external_lex_state = 3},
  [3274] = {.lex_state = 7, .external_lex_state = 3},
  [3275] = {.lex_state = 74, .external_lex_state = 3},
  [3276] = {.lex_state = 74, .external_lex_state = 3},
  [3277] = {.lex_state = 74, .external_lex_state = 3},
  [3278] = {.lex_state = 74, .external_lex_state = 3},
  [3279] = {.lex_state = 74, .external_lex_state = 3},
  [3280] = {.lex_state = 74, .external_lex_state = 2},
  [3281] = {.lex_state = 74, .external_lex_state = 3},
  [3282] = {.lex_state = 74, .external_lex_state = 3},
  [3283] = {.lex_state = 74, .external_lex_state = 2},
  [3284] = {.lex_state = 74, .external_lex_state = 2},
  [3285] = {.lex_state = 74, .external_lex_state = 3},
  [3286] = {.lex_state = 74, .external_lex_state = 3},
  [3287] = {.lex_state = 74, .external_lex_state = 3},
  [3288] = {.lex_state = 74, .external_lex_state = 3},
  [3289] = {.lex_state = 74, .external_lex_state = 4},
  [3290] = {.lex_state = 74, .external_lex_state = 3},
  [3291] = {.lex_state = 74, .external_lex_state = 3},
  [3292] = {.lex_state = 74, .external_lex_state = 3},
  [3293] = {.lex_state = 74, .external_lex_state = 3},
  [3294] = {.lex_state = 75, .external_lex_state = 5},
  [3295] = {.lex_state = 75, .external_lex_state = 5},
  [3296] = {.lex_state = 74, .external_lex_state = 4},
  [3297] = {.lex_state = 75, .external_lex_state = 5},
  [3298] = {.lex_state = 74, .external_lex_state = 4},
  [3299] = {.lex_state = 74, .external_lex_state = 3},
  [3300] = {.lex_state = 74, .external_lex_state = 3},
  [3301] = {.lex_state = 11},
  [3302] = {.lex_state = 74, .external_lex_state = 3},
  [3303] = {.lex_state = 74, .external_lex_state = 3},
  [3304] = {.lex_state = 74, .external_lex_state = 4},
  [3305] = {.lex_state = 11},
  [3306] = {.lex_state = 74, .external_lex_state = 2},
  [3307] = {.lex_state = 75, .external_lex_state = 5},
  [3308] = {.lex_state = 4, .external_lex_state = 3},
  [3309] = {.lex_state = 4, .external_lex_state = 3},
  [3310] = {.lex_state = 4, .external_lex_state = 3},
  [3311] = {.lex_state = 74, .external_lex_state = 3},
  [3312] = {.lex_state = 74, .external_lex_state = 3},
  [3313] = {.lex_state = 74, .external_lex_state = 3},
  [3314] = {.lex_state = 74, .external_lex_state = 3},
  [3315] = {.lex_state = 7, .external_lex_state = 3},
  [3316] = {.lex_state = 74, .external_lex_state = 3},
  [3317] = {.lex_state = 74, .external_lex_state = 3},
  [3318] = {.lex_state = 4, .external_lex_state = 3},
  [3319] = {.lex_state = 4, .external_lex_state = 3},
  [3320] = {.lex_state = 4, .external_lex_state = 3},
  [3321] = {.lex_state = 4, .external_lex_state = 3},
  [3322] = {.lex_state = 74, .external_lex_state = 3},
  [3323] = {.lex_state = 74, .external_lex_state = 3},
  [3324] = {.lex_state = 74, .external_lex_state = 3},
  [3325] = {.lex_state = 74, .external_lex_state = 3},
  [3326] = {.lex_state = 4, .external_lex_state = 3},
  [3327] = {.lex_state = 74, .external_lex_state = 3},
  [3328] = {.lex_state = 4, .external_lex_state = 3},
  [3329] = {.lex_state = 4, .external_lex_state = 3},
  [3330] = {.lex_state = 74, .external_lex_state = 3},
  [3331] = {.lex_state = 74, .external_lex_state = 3},
  [3332] = {.lex_state = 74, .external_lex_state = 3},
  [3333] = {.lex_state = 74, .external_lex_state = 3},
  [3334] = {.lex_state = 74, .external_lex_state = 3},
  [3335] = {.lex_state = 74, .external_lex_state = 3},
  [3336] = {.lex_state = 74, .external_lex_state = 3},
  [3337] = {.lex_state = 74, .external_lex_state = 3},
  [3338] = {.lex_state = 4, .external_lex_state = 3},
  [3339] = {.lex_state = 74, .external_lex_state = 3},
  [3340] = {.lex_state = 4, .external_lex_state = 3},
  [3341] = {.lex_state = 4, .external_lex_state = 3},
  [3342] = {.lex_state = 4, .external_lex_state = 3},
  [3343] = {.lex_state = 74, .external_lex_state = 3},
  [3344] = {.lex_state = 74, .external_lex_state = 3},
  [3345] = {.lex_state = 74, .external_lex_state = 3},
  [3346] = {.lex_state = 4, .external_lex_state = 3},
  [3347] = {.lex_state = 4, .external_lex_state = 3},
  [3348] = {.lex_state = 74, .external_lex_state = 3},
  [3349] = {.lex_state = 75, .external_lex_state = 5},
  [3350] = {.lex_state = 75, .external_lex_state = 5},
  [3351] = {.lex_state = 4, .external_lex_state = 3},
  [3352] = {.lex_state = 4, .external_lex_state = 3},
  [3353] = {.lex_state = 74, .external_lex_state = 3},
  [3354] = {.lex_state = 4, .external_lex_state = 3},
  [3355] = {.lex_state = 74, .external_lex_state = 3},
  [3356] = {.lex_state = 74, .external_lex_state = 3},
  [3357] = {.lex_state = 4, .external_lex_state = 3},
  [3358] = {.lex_state = 74, .external_lex_state = 3},
  [3359] = {.lex_state = 75, .external_lex_state = 5},
  [3360] = {.lex_state = 4, .external_lex_state = 3},
  [3361] = {.lex_state = 4, .external_lex_state = 3},
  [3362] = {.lex_state = 75, .external_lex_state = 5},
  [3363] = {.lex_state = 4, .external_lex_state = 3},
  [3364] = {.lex_state = 4, .external_lex_state = 3},
  [3365] = {.lex_state = 4, .external_lex_state = 3},
  [3366] = {.lex_state = 4, .external_lex_state = 3},
  [3367] = {.lex_state = 75, .external_lex_state = 5},
  [3368] = {.lex_state = 74, .external_lex_state = 3},
  [3369] = {.lex_state = 74, .external_lex_state = 3},
  [3370] = {.lex_state = 4, .external_lex_state = 3},
  [3371] = {.lex_state = 4, .external_lex_state = 3},
  [3372] = {.lex_state = 4, .external_lex_state = 3},
  [3373] = {.lex_state = 4, .external_lex_state = 3},
  [3374] = {.lex_state = 4, .external_lex_state = 3},
  [3375] = {.lex_state = 4, .external_lex_state = 3},
  [3376] = {.lex_state = 74, .external_lex_state = 3},
  [3377] = {.lex_state = 74, .external_lex_state = 3},
  [3378] = {.lex_state = 74, .external_lex_state = 3},
  [3379] = {.lex_state = 74, .external_lex_state = 3},
  [3380] = {.lex_state = 74, .external_lex_state = 3},
  [3381] = {.lex_state = 4, .external_lex_state = 3},
  [3382] = {.lex_state = 4, .external_lex_state = 3},
  [3383] = {.lex_state = 4, .external_lex_state = 3},
  [3384] = {.lex_state = 4, .external_lex_state = 3},
  [3385] = {.lex_state = 75, .external_lex_state = 5},
  [3386] = {.lex_state = 4, .external_lex_state = 3},
  [3387] = {.lex_state = 74, .external_lex_state = 3},
  [3388] = {.lex_state = 74, .external_lex_state = 3},
  [3389] = {.lex_state = 74, .external_lex_state = 3},
  [3390] = {.lex_state = 4, .external_lex_state = 3},
  [3391] = {.lex_state = 4, .external_lex_state = 3},
  [3392] = {.lex_state = 4, .external_lex_state = 3},
  [3393] = {.lex_state = 4, .external_lex_state = 3},
  [3394] = {.lex_state = 4, .external_lex_state = 3},
  [3395] = {.lex_state = 74, .external_lex_state = 3},
  [3396] = {.lex_state = 4, .external_lex_state = 3},
  [3397] = {.lex_state = 4, .external_lex_state = 3},
  [3398] = {.lex_state = 74, .external_lex_state = 3},
  [3399] = {.lex_state = 74, .external_lex_state = 3},
  [3400] = {.lex_state = 4, .external_lex_state = 3},
  [3401] = {.lex_state = 4, .external_lex_state = 3},
  [3402] = {.lex_state = 74, .external_lex_state = 3},
  [3403] = {.lex_state = 4, .external_lex_state = 3},
  [3404] = {.lex_state = 4, .external_lex_state = 3},
  [3405] = {.lex_state = 4, .external_lex_state = 3},
  [3406] = {.lex_state = 74, .external_lex_state = 3},
  [3407] = {.lex_state = 4, .external_lex_state = 3},
  [3408] = {.lex_state = 74, .external_lex_state = 3},
  [3409] = {.lex_state = 5, .external_lex_state = 3},
  [3410] = {.lex_state = 74, .external_lex_state = 3},
  [3411] = {.lex_state = 4, .external_lex_state = 3},
  [3412] = {.lex_state = 4, .external_lex_state = 3},
  [3413] = {.lex_state = 4, .external_lex_state = 3},
  [3414] = {.lex_state = 4, .external_lex_state = 3},
  [3415] = {.lex_state = 4, .external_lex_state = 3},
  [3416] = {.lex_state = 74, .external_lex_state = 3},
  [3417] = {.lex_state = 74, .external_lex_state = 3},
  [3418] = {.lex_state = 4, .external_lex_state = 3},
  [3419] = {.lex_state = 4, .external_lex_state = 3},
  [3420] = {.lex_state = 74, .external_lex_state = 3},
  [3421] = {.lex_state = 4, .external_lex_state = 3},
  [3422] = {.lex_state = 74, .external_lex_state = 3},
  [3423] = {.lex_state = 4, .external_lex_state = 3},
  [3424] = {.lex_state = 4, .external_lex_state = 3},
  [3425] = {.lex_state = 4, .external_lex_state = 3},
  [3426] = {.lex_state = 4, .external_lex_state = 3},
  [3427] = {.lex_state = 4, .external_lex_state = 3},
  [3428] = {.lex_state = 4, .external_lex_state = 3},
  [3429] = {.lex_state = 74, .external_lex_state = 3},
  [3430] = {.lex_state = 4, .external_lex_state = 3},
  [3431] = {.lex_state = 75, .external_lex_state = 5},
  [3432] = {.lex_state = 4, .external_lex_state = 3},
  [3433] = {.lex_state = 74, .external_lex_state = 3},
  [3434] = {.lex_state = 74, .external_lex_state = 3},
  [3435] = {.lex_state = 4, .external_lex_state = 3},
  [3436] = {.lex_state = 4, .external_lex_state = 3},
  [3437] = {.lex_state = 4, .external_lex_state = 3},
  [3438] = {.lex_state = 74, .external_lex_state = 3},
  [3439] = {.lex_state = 4, .external_lex_state = 3},
  [3440] = {.lex_state = 4, .external_lex_state = 3},
  [3441] = {.lex_state = 74, .external_lex_state = 3},
  [3442] = {.lex_state = 4, .external_lex_state = 3},
  [3443] = {.lex_state = 4, .external_lex_state = 3},
  [3444] = {.lex_state = 74, .external_lex_state = 3},
  [3445] = {.lex_state = 4, .external_lex_state = 3},
  [3446] = {.lex_state = 74, .external_lex_state = 3},
  [3447] = {.lex_state = 74, .external_lex_state = 3},
  [3448] = {.lex_state = 75, .external_lex_state = 5},
  [3449] = {.lex_state = 4, .external_lex_state = 3},
  [3450] = {.lex_state = 4, .external_lex_state = 3},
  [3451] = {.lex_state = 4, .external_lex_state = 3},
  [3452] = {.lex_state = 74, .external_lex_state = 3},
  [3453] = {.lex_state = 74, .external_lex_state = 3},
  [3454] = {.lex_state = 4, .external_lex_state = 3},
  [3455] = {.lex_state = 4, .external_lex_state = 3},
  [3456] = {.lex_state = 74, .external_lex_state = 3},
  [3457] = {.lex_state = 74, .external_lex_state = 3},
  [3458] = {.lex_state = 4, .external_lex_state = 3},
  [3459] = {.lex_state = 4, .external_lex_state = 3},
  [3460] = {.lex_state = 4, .external_lex_state = 3},
  [3461] = {.lex_state = 4, .external_lex_state = 3},
  [3462] = {.lex_state = 4, .external_lex_state = 3},
  [3463] = {.lex_state = 4, .external_lex_state = 3},
  [3464] = {.lex_state = 4, .external_lex_state = 3},
  [3465] = {.lex_state = 74, .external_lex_state = 3},
  [3466] = {.lex_state = 74, .external_lex_state = 3},
  [3467] = {.lex_state = 4, .external_lex_state = 3},
  [3468] = {.lex_state = 74, .external_lex_state = 3},
  [3469] = {.lex_state = 74, .external_lex_state = 3},
  [3470] = {.lex_state = 4, .external_lex_state = 3},
  [3471] = {.lex_state = 4, .external_lex_state = 3},
  [3472] = {.lex_state = 74, .external_lex_state = 3},
  [3473] = {.lex_state = 4, .external_lex_state = 3},
  [3474] = {.lex_state = 4, .external_lex_state = 3},
  [3475] = {.lex_state = 74, .external_lex_state = 2},
  [3476] = {.lex_state = 75, .external_lex_state = 5},
  [3477] = {.lex_state = 4, .external_lex_state = 3},
  [3478] = {.lex_state = 4, .external_lex_state = 3},
  [3479] = {.lex_state = 4, .external_lex_state = 3},
  [3480] = {.lex_state = 4, .external_lex_state = 3},
  [3481] = {.lex_state = 4, .external_lex_state = 3},
  [3482] = {.lex_state = 74, .external_lex_state = 3},
  [3483] = {.lex_state = 4, .external_lex_state = 3},
  [3484] = {.lex_state = 4, .external_lex_state = 3},
  [3485] = {.lex_state = 4, .external_lex_state = 3},
  [3486] = {.lex_state = 74, .external_lex_state = 3},
  [3487] = {.lex_state = 4, .external_lex_state = 3},
  [3488] = {.lex_state = 4, .external_lex_state = 3},
  [3489] = {.lex_state = 4, .external_lex_state = 3},
  [3490] = {.lex_state = 4, .external_lex_state = 3},
  [3491] = {.lex_state = 74, .external_lex_state = 3},
  [3492] = {.lex_state = 74, .external_lex_state = 3},
  [3493] = {.lex_state = 74, .external_lex_state = 3},
  [3494] = {.lex_state = 4, .external_lex_state = 3},
  [3495] = {.lex_state = 74, .external_lex_state = 3},
  [3496] = {.lex_state = 4, .external_lex_state = 3},
  [3497] = {.lex_state = 4, .external_lex_state = 3},
  [3498] = {.lex_state = 74, .external_lex_state = 3},
  [3499] = {.lex_state = 4, .external_lex_state = 3},
  [3500] = {.lex_state = 74, .external_lex_state = 3},
  [3501] = {.lex_state = 4, .external_lex_state = 3},
  [3502] = {.lex_state = 4, .external_lex_state = 3},
  [3503] = {.lex_state = 4, .external_lex_state = 3},
  [3504] = {.lex_state = 4, .external_lex_state = 3},
  [3505] = {.lex_state = 74, .external_lex_state = 2},
  [3506] = {.lex_state = 4, .external_lex_state = 3},
  [3507] = {.lex_state = 4, .external_lex_state = 3},
  [3508] = {.lex_state = 74, .external_lex_state = 3},
  [3509] = {.lex_state = 74, .external_lex_state = 3},
  [3510] = {.lex_state = 75, .external_lex_state = 5},
  [3511] = {.lex_state = 75, .external_lex_state = 5},
  [3512] = {.lex_state = 74, .external_lex_state = 3},
  [3513] = {.lex_state = 74, .external_lex_state = 2},
  [3514] = {.lex_state = 4, .external_lex_state = 3},
  [3515] = {.lex_state = 4, .external_lex_state = 3},
  [3516] = {.lex_state = 74, .external_lex_state = 2},
  [3517] = {.lex_state = 4, .external_lex_state = 3},
  [3518] = {.lex_state = 4, .external_lex_state = 3},
  [3519] = {.lex_state = 4, .external_lex_state = 3},
  [3520] = {.lex_state = 74, .external_lex_state = 2},
  [3521] = {.lex_state = 74, .external_lex_state = 3},
  [3522] = {.lex_state = 4, .external_lex_state = 3},
  [3523] = {.lex_state = 74, .external_lex_state = 3},
  [3524] = {.lex_state = 74, .external_lex_state = 3},
  [3525] = {.lex_state = 74, .external_lex_state = 3},
  [3526] = {.lex_state = 74, .external_lex_state = 3},
  [3527] = {.lex_state = 74, .external_lex_state = 3},
  [3528] = {.lex_state = 4, .external_lex_state = 3},
  [3529] = {.lex_state = 74, .external_lex_state = 3},
  [3530] = {.lex_state = 74, .external_lex_state = 3},
  [3531] = {.lex_state = 74, .external_lex_state = 2},
  [3532] = {.lex_state = 74, .external_lex_state = 2},
  [3533] = {.lex_state = 4, .external_lex_state = 3},
  [3534] = {.lex_state = 74, .external_lex_state = 3},
  [3535] = {.lex_state = 4, .external_lex_state = 3},
  [3536] = {.lex_state = 4, .external_lex_state = 3},
  [3537] = {.lex_state = 4, .external_lex_state = 3},
  [3538] = {.lex_state = 74, .external_lex_state = 3},
  [3539] = {.lex_state = 74, .external_lex_state = 3},
  [3540] = {.lex_state = 4, .external_lex_state = 3},
  [3541] = {.lex_state = 74, .external_lex_state = 3},
  [3542] = {.lex_state = 74, .external_lex_state = 3},
  [3543] = {.lex_state = 74, .external_lex_state = 3},
  [3544] = {.lex_state = 74, .external_lex_state = 3},
  [3545] = {.lex_state = 74, .external_lex_state = 3},
  [3546] = {.lex_state = 74, .external_lex_state = 3},
  [3547] = {.lex_state = 74, .external_lex_state = 2},
  [3548] = {.lex_state = 74, .external_lex_state = 3},
  [3549] = {.lex_state = 74, .external_lex_state = 2},
  [3550] = {.lex_state = 74, .external_lex_state = 3},
  [3551] = {.lex_state = 74, .external_lex_state = 3},
  [3552] = {.lex_state = 74, .external_lex_state = 3},
  [3553] = {.lex_state = 74, .external_lex_state = 2},
  [3554] = {.lex_state = 74, .external_lex_state = 3},
  [3555] = {.lex_state = 75, .external_lex_state = 5},
  [3556] = {.lex_state = 74, .external_lex_state = 2},
  [3557] = {.lex_state = 74, .external_lex_state = 3},
  [3558] = {.lex_state = 74, .external_lex_state = 2},
  [3559] = {.lex_state = 74, .external_lex_state = 2},
  [3560] = {.lex_state = 74, .external_lex_state = 3},
  [3561] = {.lex_state = 74, .external_lex_state = 3},
  [3562] = {.lex_state = 74, .external_lex_state = 2},
  [3563] = {.lex_state = 74, .external_lex_state = 3},
  [3564] = {.lex_state = 74, .external_lex_state = 3},
  [3565] = {.lex_state = 74, .external_lex_state = 2},
  [3566] = {.lex_state = 74, .external_lex_state = 3},
  [3567] = {.lex_state = 74, .external_lex_state = 3},
  [3568] = {.lex_state = 74, .external_lex_state = 3},
  [3569] = {.lex_state = 74, .external_lex_state = 2},
  [3570] = {.lex_state = 75, .external_lex_state = 5},
  [3571] = {.lex_state = 75},
  [3572] = {.lex_state = 75, .external_lex_state = 5},
  [3573] = {.lex_state = 75},
  [3574] = {.lex_state = 74, .external_lex_state = 3},
  [3575] = {.lex_state = 74, .external_lex_state = 3},
  [3576] = {.lex_state = 75, .external_lex_state = 5},
  [3577] = {.lex_state = 74, .external_lex_state = 3},
  [3578] = {.lex_state = 74, .external_lex_state = 2},
  [3579] = {.lex_state = 75, .external_lex_state = 5},
  [3580] = {.lex_state = 75, .external_lex_state = 5},
  [3581] = {.lex_state = 75, .external_lex_state = 5},
  [3582] = {.lex_state = 75, .external_lex_state = 5},
  [3583] = {.lex_state = 74, .external_lex_state = 3},
  [3584] = {.lex_state = 75, .external_lex_state = 5},
  [3585] = {.lex_state = 74, .external_lex_state = 3},
  [3586] = {.lex_state = 74, .external_lex_state = 3},
  [3587] = {.lex_state = 74, .external_lex_state = 3},
  [3588] = {.lex_state = 74, .external_lex_state = 3},
  [3589] = {.lex_state = 74, .external_lex_state = 3},
  [3590] = {.lex_state = 75, .external_lex_state = 5},
  [3591] = {.lex_state = 74, .external_lex_state = 3},
  [3592] = {.lex_state = 74, .external_lex_state = 3},
  [3593] = {.lex_state = 74, .external_lex_state = 3},
  [3594] = {.lex_state = 74, .external_lex_state = 3},
  [3595] = {.lex_state = 74, .external_lex_state = 3},
  [3596] = {.lex_state = 74, .external_lex_state = 3},
  [3597] = {.lex_state = 74, .external_lex_state = 3},
  [3598] = {.lex_state = 74, .external_lex_state = 3},
  [3599] = {.lex_state = 75},
  [3600] = {.lex_state = 75, .external_lex_state = 5},
  [3601] = {.lex_state = 75, .external_lex_state = 5},
  [3602] = {.lex_state = 74, .external_lex_state = 3},
  [3603] = {.lex_state = 74, .external_lex_state = 3},
  [3604] = {.lex_state = 75, .external_lex_state = 5},
  [3605] = {.lex_state = 74, .external_lex_state = 3},
  [3606] = {.lex_state = 74, .external_lex_state = 3},
  [3607] = {.lex_state = 74, .external_lex_state = 3},
  [3608] = {.lex_state = 74, .external_lex_state = 3},
  [3609] = {.lex_state = 75, .external_lex_state = 5},
  [3610] = {.lex_state = 75, .external_lex_state = 5},
  [3611] = {.lex_state = 75, .external_lex_state = 5},
  [3612] = {.lex_state = 74, .external_lex_state = 3},
  [3613] = {.lex_state = 75},
  [3614] = {.lex_state = 75},
  [3615] = {.lex_state = 75},
  [3616] = {.lex_state = 75, .external_lex_state = 5},
  [3617] = {.lex_state = 75, .external_lex_state = 5},
  [3618] = {.lex_state = 75, .external_lex_state = 5},
  [3619] = {.lex_state = 75},
  [3620] = {.lex_state = 75, .external_lex_state = 5},
  [3621] = {.lex_state = 75, .external_lex_state = 5},
  [3622] = {.lex_state = 74, .external_lex_state = 3},
  [3623] = {.lex_state = 75},
  [3624] = {.lex_state = 75},
  [3625] = {.lex_state = 75},
  [3626] = {.lex_state = 75, .external_lex_state = 5},
  [3627] = {.lex_state = 74, .external_lex_state = 3},
  [3628] = {.lex_state = 75},
  [3629] = {.lex_state = 75, .external_lex_state = 5},
  [3630] = {.lex_state = 75, .external_lex_state = 5},
  [3631] = {.lex_state = 75, .external_lex_state = 5},
  [3632] = {.lex_state = 75, .external_lex_state = 5},
  [3633] = {.lex_state = 75},
  [3634] = {.lex_state = 75},
  [3635] = {.lex_state = 75},
  [3636] = {.lex_state = 75},
  [3637] = {.lex_state = 75},
  [3638] = {.lex_state = 75},
  [3639] = {.lex_state = 75},
  [3640] = {.lex_state = 75, .external_lex_state = 5},
  [3641] = {.lex_state = 75, .external_lex_state = 5},
  [3642] = {.lex_state = 75, .external_lex_state = 5},
  [3643] = {.lex_state = 75, .external_lex_state = 5},
  [3644] = {.lex_state = 75, .external_lex_state = 5},
  [3645] = {.lex_state = 75},
  [3646] = {.lex_state = 74, .external_lex_state = 3},
  [3647] = {.lex_state = 75, .external_lex_state = 5},
  [3648] = {.lex_state = 75, .external_lex_state = 5},
  [3649] = {.lex_state = 75},
  [3650] = {.lex_state = 75},
  [3651] = {.lex_state = 75},
  [3652] = {.lex_state = 75},
  [3653] = {.lex_state = 75, .external_lex_state = 5},
  [3654] = {.lex_state = 74, .external_lex_state = 3},
  [3655] = {.lex_state = 75},
  [3656] = {.lex_state = 75},
  [3657] = {.lex_state = 75},
  [3658] = {.lex_state = 75},
  [3659] = {.lex_state = 75},
  [3660] = {.lex_state = 74, .external_lex_state = 3},
  [3661] = {.lex_state = 75},
  [3662] = {.lex_state = 75, .external_lex_state = 5},
  [3663] = {.lex_state = 75},
  [3664] = {.lex_state = 75},
  [3665] = {.lex_state = 75},
  [3666] = {.lex_state = 75},
  [3667] = {.lex_state = 75},
  [3668] = {.lex_state = 75},
  [3669] = {.lex_state = 75, .external_lex_state = 5},
  [3670] = {.lex_state = 75},
  [3671] = {.lex_state = 75, .external_lex_state = 5},
  [3672] = {.lex_state = 75, .external_lex_state = 5},
  [3673] = {.lex_state = 75, .external_lex_state = 5},
  [3674] = {.lex_state = 75},
  [3675] = {.lex_state = 75},
  [3676] = {.lex_state = 75},
  [3677] = {.lex_state = 75},
  [3678] = {.lex_state = 75, .external_lex_state = 5},
  [3679] = {.lex_state = 75},
  [3680] = {.lex_state = 75},
  [3681] = {.lex_state = 75, .external_lex_state = 5},
  [3682] = {.lex_state = 75},
  [3683] = {.lex_state = 75, .external_lex_state = 5},
  [3684] = {.lex_state = 75},
  [3685] = {.lex_state = 75, .external_lex_state = 5},
  [3686] = {.lex_state = 75},
  [3687] = {.lex_state = 75, .external_lex_state = 5},
  [3688] = {.lex_state = 75, .external_lex_state = 5},
  [3689] = {.lex_state = 75, .external_lex_state = 5},
  [3690] = {.lex_state = 75, .external_lex_state = 5},
  [3691] = {.lex_state = 75, .external_lex_state = 5},
  [3692] = {.lex_state = 75, .external_lex_state = 5},
  [3693] = {.lex_state = 75, .external_lex_state = 5},
  [3694] = {.lex_state = 75},
  [3695] = {.lex_state = 13},
  [3696] = {.lex_state = 75, .external_lex_state = 5},
  [3697] = {.lex_state = 75},
  [3698] = {.lex_state = 75, .external_lex_state = 5},
  [3699] = {.lex_state = 75},
  [3700] = {.lex_state = 75, .external_lex_state = 5},
  [3701] = {.lex_state = 75, .external_lex_state = 5},
  [3702] = {.lex_state = 75},
  [3703] = {.lex_state = 75},
  [3704] = {.lex_state = 75},
  [3705] = {.lex_state = 75},
  [3706] = {.lex_state = 75, .external_lex_state = 5},
  [3707] = {.lex_state = 75, .external_lex_state = 5},
  [3708] = {.lex_state = 75},
  [3709] = {.lex_state = 75},
  [3710] = {.lex_state = 75},
  [3711] = {.lex_state = 75},
  [3712] = {.lex_state = 75, .external_lex_state = 5},
  [3713] = {.lex_state = 75, .external_lex_state = 5},
  [3714] = {.lex_state = 75, .external_lex_state = 5},
  [3715] = {.lex_state = 75, .external_lex_state = 5},
  [3716] = {.lex_state = 75, .external_lex_state = 5},
  [3717] = {.lex_state = 75},
  [3718] = {.lex_state = 75, .external_lex_state = 5},
  [3719] = {.lex_state = 75, .external_lex_state = 5},
  [3720] = {.lex_state = 75, .external_lex_state = 5},
  [3721] = {.lex_state = 13},
  [3722] = {.lex_state = 75},
  [3723] = {.lex_state = 75},
  [3724] = {.lex_state = 75, .external_lex_state = 5},
  [3725] = {.lex_state = 75},
  [3726] = {.lex_state = 75},
  [3727] = {.lex_state = 75},
  [3728] = {.lex_state = 75},
  [3729] = {.lex_state = 75, .external_lex_state = 5},
  [3730] = {.lex_state = 75},
  [3731] = {.lex_state = 75},
  [3732] = {.lex_state = 75, .external_lex_state = 5},
  [3733] = {.lex_state = 75},
  [3734] = {.lex_state = 75},
  [3735] = {.lex_state = 75},
  [3736] = {.lex_state = 75},
  [3737] = {.lex_state = 75},
  [3738] = {.lex_state = 75},
  [3739] = {.lex_state = 75},
  [3740] = {.lex_state = 75},
  [3741] = {.lex_state = 75},
  [3742] = {.lex_state = 75},
  [3743] = {.lex_state = 75},
  [3744] = {.lex_state = 75, .external_lex_state = 5},
  [3745] = {.lex_state = 75},
  [3746] = {.lex_state = 75},
  [3747] = {.lex_state = 75},
  [3748] = {.lex_state = 75},
  [3749] = {.lex_state = 75},
  [3750] = {.lex_state = 13},
  [3751] = {.lex_state = 75},
  [3752] = {.lex_state = 13},
  [3753] = {.lex_state = 75},
  [3754] = {.lex_state = 13},
  [3755] = {.lex_state = 75},
  [3756] = {.lex_state = 75},
  [3757] = {.lex_state = 75},
  [3758] = {.lex_state = 13},
  [3759] = {.lex_state = 75},
  [3760] = {.lex_state = 13},
  [3761] = {.lex_state = 75},
  [3762] = {.lex_state = 75},
  [3763] = {.lex_state = 75},
  [3764] = {.lex_state = 75},
  [3765] = {.lex_state = 75},
  [3766] = {.lex_state = 11, .external_lex_state = 5},
  [3767] = {.lex_state = 11, .external_lex_state = 5},
  [3768] = {.lex_state = 11, .external_lex_state = 5},
  [3769] = {.lex_state = 11, .external_lex_state = 5},
  [3770] = {.lex_state = 75},
  [3771] = {.lex_state = 11, .external_lex_state = 5},
  [3772] = {.lex_state = 11, .external_lex_state = 5},
  [3773] = {.lex_state = 75},
  [3774] = {.lex_state = 75},
  [3775] = {.lex_state = 11, .external_lex_state = 5},
  [3776] = {.lex_state = 11, .external_lex_state = 5},
  [3777] = {.lex_state = 11, .external_lex_state = 5},
  [3778] = {.lex_state = 11, .external_lex_state = 5},
  [3779] = {.lex_state = 11, .external_lex_state = 5},
  [3780] = {.lex_state = 11, .external_lex_state = 5},
  [3781] = {.lex_state = 11, .external_lex_state = 5},
  [3782] = {.lex_state = 75},
  [3783] = {.lex_state = 11, .external_lex_state = 5},
  [3784] = {.lex_state = 75},
  [3785] = {.lex_state = 75},
  [3786] = {.lex_state = 75},
  [3787] = {.lex_state = 11, .external_lex_state = 5},
  [3788] = {.lex_state = 11, .external_lex_state = 5},
  [3789] = {.lex_state = 11, .external_lex_state = 5},
  [3790] = {.lex_state = 75},
  [3791] = {.lex_state = 75},
  [3792] = {.lex_state = 11, .external_lex_state = 5},
  [3793] = {.lex_state = 11, .external_lex_state = 5},
  [3794] = {.lex_state = 11, .external_lex_state = 5},
  [3795] = {.lex_state = 11, .external_lex_state = 5},
  [3796] = {.lex_state = 11, .external_lex_state = 5},
  [3797] = {.lex_state = 11, .external_lex_state = 5},
  [3798] = {.lex_state = 75},
  [3799] = {.lex_state = 75},
  [3800] = {.lex_state = 75},
  [3801] = {.lex_state = 75},
  [3802] = {.lex_state = 75},
  [3803] = {.lex_state = 75},
  [3804] = {.lex_state = 75},
  [3805] = {.lex_state = 75},
  [3806] = {.lex_state = 75},
  [3807] = {.lex_state = 75},
  [3808] = {.lex_state = 75},
  [3809] = {.lex_state = 75},
  [3810] = {.lex_state = 75},
  [3811] = {.lex_state = 75},
  [3812] = {.lex_state = 75},
  [3813] = {.lex_state = 75},
  [3814] = {.lex_state = 75},
  [3815] = {.lex_state = 75},
  [3816] = {.lex_state = 75},
  [3817] = {.lex_state = 75},
  [3818] = {.lex_state = 75},
  [3819] = {.lex_state = 75},
  [3820] = {.lex_state = 75},
  [3821] = {.lex_state = 75},
  [3822] = {.lex_state = 11},
  [3823] = {.lex_state = 75},
  [3824] = {.lex_state = 75},
  [3825] = {.lex_state = 75},
  [3826] = {.lex_state = 75},
  [3827] = {.lex_state = 75},
  [3828] = {.lex_state = 75},
  [3829] = {.lex_state = 75},
  [3830] = {.lex_state = 75},
  [3831] = {.lex_state = 75},
  [3832] = {.lex_state = 75},
  [3833] = {.lex_state = 75},
  [3834] = {.lex_state = 75},
  [3835] = {.lex_state = 75},
  [3836] = {.lex_state = 75},
  [3837] = {.lex_state = 75},
  [3838] = {.lex_state = 75},
  [3839] = {.lex_state = 75},
  [3840] = {.lex_state = 75},
  [3841] = {.lex_state = 75},
  [3842] = {.lex_state = 75},
  [3843] = {.lex_state = 75},
  [3844] = {.lex_state = 75},
  [3845] = {.lex_state = 75},
  [3846] = {.lex_state = 75},
  [3847] = {.lex_state = 75},
  [3848] = {.lex_state = 75},
  [3849] = {.lex_state = 75},
  [3850] = {.lex_state = 75},
  [3851] = {.lex_state = 75},
  [3852] = {.lex_state = 75},
  [3853] = {.lex_state = 75},
  [3854] = {.lex_state = 75},
  [3855] = {.lex_state = 75},
  [3856] = {.lex_state = 75},
  [3857] = {.lex_state = 75},
  [3858] = {.lex_state = 75},
  [3859] = {.lex_state = 75},
  [3860] = {.lex_state = 75},
  [3861] = {.lex_state = 75},
  [3862] = {.lex_state = 75},
  [3863] = {.lex_state = 75},
  [3864] = {.lex_state = 75},
  [3865] = {.lex_state = 75},
  [3866] = {.lex_state = 18},
  [3867] = {.lex_state = 18},
  [3868] = {.lex_state = 18},
  [3869] = {.lex_state = 18},
  [3870] = {.lex_state = 75},
  [3871] = {.lex_state = 75, .external_lex_state = 5},
  [3872] = {.lex_state = 75},
  [3873] = {.lex_state = 75, .external_lex_state = 5},
  [3874] = {.lex_state = 2},
  [3875] = {.lex_state = 2},
  [3876] = {.lex_state = 2},
  [3877] = {.lex_state = 2},
  [3878] = {.lex_state = 2},
  [3879] = {.lex_state = 2},
  [3880] = {.lex_state = 2},
  [3881] = {.lex_state = 2},
  [3882] = {.lex_state = 2},
  [3883] = {.lex_state = 2},
  [3884] = {.lex_state = 75},
  [3885] = {.lex_state = 2},
  [3886] = {.lex_state = 2},
  [3887] = {.lex_state = 2},
  [3888] = {.lex_state = 2},
  [3889] = {.lex_state = 2},
  [3890] = {.lex_state = 2},
  [3891] = {.lex_state = 2},
  [3892] = {.lex_state = 2},
  [3893] = {.lex_state = 2},
  [3894] = {.lex_state = 2},
  [3895] = {.lex_state = 75, .external_lex_state = 5},
  [3896] = {.lex_state = 75},
  [3897] = {.lex_state = 75, .external_lex_state = 5},
  [3898] = {.lex_state = 75},
  [3899] = {.lex_state = 75, .external_lex_state = 5},
  [3900] = {.lex_state = 75},
  [3901] = {.lex_state = 75, .external_lex_state = 5},
  [3902] = {.lex_state = 75, .external_lex_state = 5},
  [3903] = {.lex_state = 75},
  [3904] = {.lex_state = 75, .external_lex_state = 5},
  [3905] = {.lex_state = 75, .external_lex_state = 5},
  [3906] = {.lex_state = 75, .external_lex_state = 5},
  [3907] = {.lex_state = 75},
  [3908] = {.lex_state = 18},
  [3909] = {.lex_state = 75},
  [3910] = {.lex_state = 75},
  [3911] = {.lex_state = 75},
  [3912] = {.lex_state = 75},
  [3913] = {.lex_state = 75},
  [3914] = {.lex_state = 75, .external_lex_state = 5},
  [3915] = {.lex_state = 75, .external_lex_state = 5},
  [3916] = {.lex_state = 75},
  [3917] = {.lex_state = 75},
  [3918] = {.lex_state = 75, .external_lex_state = 5},
  [3919] = {.lex_state = 75, .external_lex_state = 5},
  [3920] = {.lex_state = 75, .external_lex_state = 5},
  [3921] = {.lex_state = 18},
  [3922] = {.lex_state = 75, .external_lex_state = 5},
  [3923] = {.lex_state = 75, .external_lex_state = 5},
  [3924] = {.lex_state = 75, .external_lex_state = 5},
  [3925] = {.lex_state = 75},
  [3926] = {.lex_state = 75},
  [3927] = {.lex_state = 75},
  [3928] = {.lex_state = 75},
  [3929] = {.lex_state = 75},
  [3930] = {.lex_state = 75},
  [3931] = {.lex_state = 75},
  [3932] = {.lex_state = 75},
  [3933] = {.lex_state = 75, .external_lex_state = 5},
  [3934] = {.lex_state = 75},
  [3935] = {.lex_state = 75},
  [3936] = {.lex_state = 75},
  [3937] = {.lex_state = 75},
  [3938] = {.lex_state = 75},
  [3939] = {.lex_state = 18},
  [3940] = {.lex_state = 75, .external_lex_state = 5},
  [3941] = {.lex_state = 75},
  [3942] = {.lex_state = 75},
  [3943] = {.lex_state = 75},
  [3944] = {.lex_state = 75},
  [3945] = {.lex_state = 75, .external_lex_state = 5},
  [3946] = {.lex_state = 75},
  [3947] = {.lex_state = 75, .external_lex_state = 6},
  [3948] = {.lex_state = 75, .external_lex_state = 5},
  [3949] = {.lex_state = 75, .external_lex_state = 5},
  [3950] = {.lex_state = 75, .external_lex_state = 5},
  [3951] = {.lex_state = 75, .external_lex_state = 5},
  [3952] = {.lex_state = 75, .external_lex_state = 5},
  [3953] = {.lex_state = 18},
  [3954] = {.lex_state = 75},
  [3955] = {.lex_state = 18},
  [3956] = {.lex_state = 18},
  [3957] = {.lex_state = 75, .external_lex_state = 5},
  [3958] = {.lex_state = 75, .external_lex_state = 5},
  [3959] = {.lex_state = 75, .external_lex_state = 5},
  [3960] = {.lex_state = 18},
  [3961] = {.lex_state = 75, .external_lex_state = 5},
  [3962] = {.lex_state = 75, .external_lex_state = 5},
  [3963] = {.lex_state = 75, .external_lex_state = 5},
  [3964] = {.lex_state = 75, .external_lex_state = 5},
  [3965] = {.lex_state = 75, .external_lex_state = 5},
  [3966] = {.lex_state = 75, .external_lex_state = 5},
  [3967] = {.lex_state = 75, .external_lex_state = 5},
  [3968] = {.lex_state = 75, .external_lex_state = 5},
  [3969] = {.lex_state = 75, .external_lex_state = 5},
  [3970] = {.lex_state = 75, .external_lex_state = 5},
  [3971] = {.lex_state = 75},
  [3972] = {.lex_state = 75, .external_lex_state = 5},
  [3973] = {.lex_state = 75, .external_lex_state = 5},
  [3974] = {.lex_state = 18},
  [3975] = {.lex_state = 75, .external_lex_state = 5},
  [3976] = {.lex_state = 75, .external_lex_state = 5},
  [3977] = {.lex_state = 18},
  [3978] = {.lex_state = 75, .external_lex_state = 5},
  [3979] = {.lex_state = 75, .external_lex_state = 5},
  [3980] = {.lex_state = 75, .external_lex_state = 5},
  [3981] = {.lex_state = 75, .external_lex_state = 6},
  [3982] = {.lex_state = 75, .external_lex_state = 5},
  [3983] = {.lex_state = 75, .external_lex_state = 5},
  [3984] = {.lex_state = 75, .external_lex_state = 5},
  [3985] = {.lex_state = 75, .external_lex_state = 5},
  [3986] = {.lex_state = 75, .external_lex_state = 5},
  [3987] = {.lex_state = 75, .external_lex_state = 5},
  [3988] = {.lex_state = 75, .external_lex_state = 5},
  [3989] = {.lex_state = 75, .external_lex_state = 5},
  [3990] = {.lex_state = 75, .external_lex_state = 5},
  [3991] = {.lex_state = 75},
  [3992] = {.lex_state = 75},
  [3993] = {.lex_state = 75, .external_lex_state = 5},
  [3994] = {.lex_state = 75, .external_lex_state = 5},
  [3995] = {.lex_state = 75, .external_lex_state = 5},
  [3996] = {.lex_state = 75, .external_lex_state = 5},
  [3997] = {.lex_state = 75},
  [3998] = {.lex_state = 75, .external_lex_state = 5},
  [3999] = {.lex_state = 75, .external_lex_state = 5},
  [4000] = {.lex_state = 75, .external_lex_state = 5},
  [4001] = {.lex_state = 75},
  [4002] = {.lex_state = 75, .external_lex_state = 5},
  [4003] = {.lex_state = 75, .external_lex_state = 5},
  [4004] = {.lex_state = 75, .external_lex_state = 5},
  [4005] = {.lex_state = 75, .external_lex_state = 5},
  [4006] = {.lex_state = 75, .external_lex_state = 5},
  [4007] = {.lex_state = 75, .external_lex_state = 5},
  [4008] = {.lex_state = 75, .external_lex_state = 5},
  [4009] = {.lex_state = 75, .external_lex_state = 5},
  [4010] = {.lex_state = 75, .external_lex_state = 5},
  [4011] = {.lex_state = 75, .external_lex_state = 5},
  [4012] = {.lex_state = 75},
  [4013] = {.lex_state = 75, .external_lex_state = 5},
  [4014] = {.lex_state = 75, .external_lex_state = 5},
  [4015] = {.lex_state = 75, .external_lex_state = 5},
  [4016] = {.lex_state = 75, .external_lex_state = 5},
  [4017] = {.lex_state = 75},
  [4018] = {.lex_state = 75, .external_lex_state = 5},
  [4019] = {.lex_state = 75, .external_lex_state = 5},
  [4020] = {.lex_state = 75, .external_lex_state = 5},
  [4021] = {.lex_state = 75, .external_lex_state = 5},
  [4022] = {.lex_state = 75, .external_lex_state = 5},
  [4023] = {.lex_state = 75, .external_lex_state = 5},
  [4024] = {.lex_state = 75, .external_lex_state = 5},
  [4025] = {.lex_state = 75, .external_lex_state = 5},
  [4026] = {.lex_state = 18},
  [4027] = {.lex_state = 18},
  [4028] = {.lex_state = 18},
  [4029] = {.lex_state = 26},
  [4030] = {.lex_state = 75, .external_lex_state = 5},
  [4031] = {.lex_state = 75},
  [4032] = {.lex_state = 75, .external_lex_state = 5},
  [4033] = {.lex_state = 26},
  [4034] = {.lex_state = 75},
  [4035] = {.lex_state = 75},
  [4036] = {.lex_state = 75, .external_lex_state = 5},
  [4037] = {.lex_state = 75, .external_lex_state = 5},
  [4038] = {.lex_state = 26},
  [4039] = {.lex_state = 18},
  [4040] = {.lex_state = 75},
  [4041] = {.lex_state = 75, .external_lex_state = 5},
  [4042] = {.lex_state = 75},
  [4043] = {.lex_state = 75, .external_lex_state = 5},
  [4044] = {.lex_state = 75, .external_lex_state = 5},
  [4045] = {.lex_state = 75, .external_lex_state = 5},
  [4046] = {.lex_state = 75},
  [4047] = {.lex_state = 26},
  [4048] = {.lex_state = 26},
  [4049] = {.lex_state = 75, .external_lex_state = 5},
  [4050] = {.lex_state = 75, .external_lex_state = 6},
  [4051] = {.lex_state = 75, .external_lex_state = 6},
  [4052] = {.lex_state = 75},
  [4053] = {.lex_state = 26},
  [4054] = {.lex_state = 75},
  [4055] = {.lex_state = 75},
  [4056] = {.lex_state = 18},
  [4057] = {.lex_state = 75, .external_lex_state = 5},
  [4058] = {.lex_state = 75, .external_lex_state = 5},
  [4059] = {.lex_state = 26},
  [4060] = {.lex_state = 26},
  [4061] = {.lex_state = 75},
  [4062] = {.lex_state = 75},
  [4063] = {.lex_state = 75, .external_lex_state = 5},
  [4064] = {.lex_state = 26},
  [4065] = {.lex_state = 75},
  [4066] = {.lex_state = 26},
  [4067] = {.lex_state = 75},
  [4068] = {.lex_state = 26},
  [4069] = {.lex_state = 75},
  [4070] = {.lex_state = 75, .external_lex_state = 5},
  [4071] = {.lex_state = 75},
  [4072] = {.lex_state = 75},
  [4073] = {.lex_state = 75},
  [4074] = {.lex_state = 75},
  [4075] = {.lex_state = 18},
  [4076] = {.lex_state = 75},
  [4077] = {.lex_state = 26},
  [4078] = {.lex_state = 75},
  [4079] = {.lex_state = 75},
  [4080] = {.lex_state = 75, .external_lex_state = 6},
  [4081] = {.lex_state = 75, .external_lex_state = 5},
  [4082] = {.lex_state = 75},
  [4083] = {.lex_state = 18},
  [4084] = {.lex_state = 18},
  [4085] = {.lex_state = 75},
  [4086] = {.lex_state = 18},
  [4087] = {.lex_state = 26},
  [4088] = {.lex_state = 75},
  [4089] = {.lex_state = 18},
  [4090] = {.lex_state = 18},
  [4091] = {.lex_state = 18},
  [4092] = {.lex_state = 18},
  [4093] = {.lex_state = 75},
  [4094] = {.lex_state = 75},
  [4095] = {.lex_state = 75},
  [4096] = {.lex_state = 18},
  [4097] = {.lex_state = 18},
  [4098] = {.lex_state = 18},
  [4099] = {.lex_state = 18},
  [4100] = {.lex_state = 75},
  [4101] = {.lex_state = 18},
  [4102] = {.lex_state = 18},
  [4103] = {.lex_state = 75},
  [4104] = {.lex_state = 18},
  [4105] = {.lex_state = 18},
  [4106] = {.lex_state = 75, .external_lex_state = 5},
  [4107] = {.lex_state = 18},
  [4108] = {.lex_state = 18},
  [4109] = {.lex_state = 18},
  [4110] = {.lex_state = 18},
  [4111] = {.lex_state = 75},
  [4112] = {.lex_state = 26},
  [4113] = {.lex_state = 26},
  [4114] = {.lex_state = 26},
  [4115] = {.lex_state = 75},
  [4116] = {.lex_state = 75},
  [4117] = {.lex_state = 18},
  [4118] = {.lex_state = 75},
  [4119] = {.lex_state = 75},
  [4120] = {.lex_state = 26},
  [4121] = {.lex_state = 26},
  [4122] = {.lex_state = 75},
  [4123] = {.lex_state = 26},
  [4124] = {.lex_state = 26},
  [4125] = {.lex_state = 75},
  [4126] = {.lex_state = 75},
  [4127] = {.lex_state = 18},
  [4128] = {.lex_state = 75},
  [4129] = {.lex_state = 75},
  [4130] = {.lex_state = 26},
  [4131] = {.lex_state = 18},
  [4132] = {.lex_state = 18},
  [4133] = {.lex_state = 18},
  [4134] = {.lex_state = 18},
  [4135] = {.lex_state = 26},
  [4136] = {.lex_state = 75},
  [4137] = {.lex_state = 18},
  [4138] = {.lex_state = 75},
  [4139] = {.lex_state = 75},
  [4140] = {.lex_state = 75},
  [4141] = {.lex_state = 75},
  [4142] = {.lex_state = 75},
  [4143] = {.lex_state = 75},
  [4144] = {.lex_state = 75},
  [4145] = {.lex_state = 75, .external_lex_state = 5},
  [4146] = {.lex_state = 75},
  [4147] = {.lex_state = 26},
  [4148] = {.lex_state = 75},
  [4149] = {.lex_state = 75},
  [4150] = {.lex_state = 75},
  [4151] = {.lex_state = 75},
  [4152] = {.lex_state = 75},
  [4153] = {.lex_state = 75, .external_lex_state = 5},
  [4154] = {.lex_state = 75},
  [4155] = {.lex_state = 75},
  [4156] = {.lex_state = 75},
  [4157] = {.lex_state = 18},
  [4158] = {.lex_state = 75},
  [4159] = {.lex_state = 18},
  [4160] = {.lex_state = 18},
  [4161] = {.lex_state = 18},
  [4162] = {.lex_state = 18},
  [4163] = {.lex_state = 75, .external_lex_state = 5},
  [4164] = {.lex_state = 18},
  [4165] = {.lex_state = 18},
  [4166] = {.lex_state = 18},
  [4167] = {.lex_state = 75},
  [4168] = {.lex_state = 75, .external_lex_state = 5},
  [4169] = {.lex_state = 18},
  [4170] = {.lex_state = 18},
  [4171] = {.lex_state = 18},
  [4172] = {.lex_state = 18},
  [4173] = {.lex_state = 18},
  [4174] = {.lex_state = 18},
  [4175] = {.lex_state = 18},
  [4176] = {.lex_state = 75, .external_lex_state = 5},
  [4177] = {.lex_state = 75},
  [4178] = {.lex_state = 75, .external_lex_state = 5},
  [4179] = {.lex_state = 75, .external_lex_state = 5},
  [4180] = {.lex_state = 75},
  [4181] = {.lex_state = 75},
  [4182] = {.lex_state = 75},
  [4183] = {.lex_state = 75},
  [4184] = {.lex_state = 26},
  [4185] = {.lex_state = 26},
  [4186] = {.lex_state = 75},
  [4187] = {.lex_state = 75},
  [4188] = {.lex_state = 75},
  [4189] = {.lex_state = 75},
  [4190] = {.lex_state = 75},
  [4191] = {.lex_state = 75},
  [4192] = {.lex_state = 75},
  [4193] = {.lex_state = 75, .external_lex_state = 5},
  [4194] = {.lex_state = 18},
  [4195] = {.lex_state = 18},
  [4196] = {.lex_state = 75},
  [4197] = {.lex_state = 75, .external_lex_state = 6},
  [4198] = {.lex_state = 75, .external_lex_state = 6},
  [4199] = {.lex_state = 75, .external_lex_state = 5},
  [4200] = {.lex_state = 75, .external_lex_state = 5},
  [4201] = {.lex_state = 75, .external_lex_state = 6},
  [4202] = {.lex_state = 75, .external_lex_state = 5},
  [4203] = {.lex_state = 75, .external_lex_state = 5},
  [4204] = {.lex_state = 75, .external_lex_state = 5},
  [4205] = {.lex_state = 75, .external_lex_state = 5},
  [4206] = {.lex_state = 75, .external_lex_state = 5},
  [4207] = {.lex_state = 75, .external_lex_state = 6},
  [4208] = {.lex_state = 75, .external_lex_state = 6},
  [4209] = {.lex_state = 75, .external_lex_state = 6},
  [4210] = {.lex_state = 75, .external_lex_state = 6},
  [4211] = {.lex_state = 75, .external_lex_state = 6},
  [4212] = {.lex_state = 75, .external_lex_state = 6},
  [4213] = {.lex_state = 75},
  [4214] = {.lex_state = 75, .external_lex_state = 6},
  [4215] = {.lex_state = 18},
  [4216] = {.lex_state = 75, .external_lex_state = 6},
  [4217] = {.lex_state = 75, .external_lex_state = 6},
  [4218] = {.lex_state = 75, .external_lex_state = 6},
  [4219] = {.lex_state = 75, .external_lex_state = 6},
  [4220] = {.lex_state = 75, .external_lex_state = 6},
  [4221] = {.lex_state = 75, .external_lex_state = 5},
  [4222] = {.lex_state = 75, .external_lex_state = 6},
  [4223] = {.lex_state = 75, .external_lex_state = 6},
  [4224] = {.lex_state = 75},
  [4225] = {.lex_state = 75, .external_lex_state = 6},
  [4226] = {.lex_state = 75, .external_lex_state = 6},
  [4227] = {.lex_state = 75, .external_lex_state = 6},
  [4228] = {.lex_state = 75},
  [4229] = {.lex_state = 75},
  [4230] = {.lex_state = 75, .external_lex_state = 6},
  [4231] = {.lex_state = 75, .external_lex_state = 6},
  [4232] = {.lex_state = 75, .external_lex_state = 6},
  [4233] = {.lex_state = 75, .external_lex_state = 6},
  [4234] = {.lex_state = 75, .external_lex_state = 6},
  [4235] = {.lex_state = 75, .external_lex_state = 6},
  [4236] = {.lex_state = 75, .external_lex_state = 6},
  [4237] = {.lex_state = 75, .external_lex_state = 6},
  [4238] = {.lex_state = 75, .external_lex_state = 6},
  [4239] = {.lex_state = 75, .external_lex_state = 6},
  [4240] = {.lex_state = 75},
  [4241] = {.lex_state = 75, .external_lex_state = 6},
  [4242] = {.lex_state = 75, .external_lex_state = 6},
  [4243] = {.lex_state = 75, .external_lex_state = 6},
  [4244] = {.lex_state = 75, .external_lex_state = 6},
  [4245] = {.lex_state = 75, .external_lex_state = 6},
  [4246] = {.lex_state = 75, .external_lex_state = 6},
  [4247] = {.lex_state = 75},
  [4248] = {.lex_state = 75, .external_lex_state = 5},
  [4249] = {.lex_state = 75, .external_lex_state = 6},
  [4250] = {.lex_state = 75, .external_lex_state = 6},
  [4251] = {.lex_state = 75, .external_lex_state = 6},
  [4252] = {.lex_state = 75, .external_lex_state = 6},
  [4253] = {.lex_state = 75, .external_lex_state = 6},
  [4254] = {.lex_state = 75, .external_lex_state = 6},
  [4255] = {.lex_state = 75, .external_lex_state = 6},
  [4256] = {.lex_state = 75},
  [4257] = {.lex_state = 75, .external_lex_state = 6},
  [4258] = {.lex_state = 75, .external_lex_state = 6},
  [4259] = {.lex_state = 75, .external_lex_state = 5},
  [4260] = {.lex_state = 75, .external_lex_state = 5},
  [4261] = {.lex_state = 75},
  [4262] = {.lex_state = 75},
  [4263] = {.lex_state = 75},
  [4264] = {.lex_state = 75},
  [4265] = {.lex_state = 75},
  [4266] = {.lex_state = 75},
  [4267] = {.lex_state = 75, .external_lex_state = 5},
  [4268] = {.lex_state = 75},
  [4269] = {.lex_state = 75},
  [4270] = {.lex_state = 75},
  [4271] = {.lex_state = 75},
  [4272] = {.lex_state = 18},
  [4273] = {.lex_state = 75},
  [4274] = {.lex_state = 75},
  [4275] = {.lex_state = 75},
  [4276] = {.lex_state = 75, .external_lex_state = 5},
  [4277] = {.lex_state = 75},
  [4278] = {.lex_state = 75},
  [4279] = {.lex_state = 75},
  [4280] = {.lex_state = 75},
  [4281] = {.lex_state = 75},
  [4282] = {.lex_state = 75},
  [4283] = {.lex_state = 18},
  [4284] = {.lex_state = 75, .external_lex_state = 5},
  [4285] = {.lex_state = 0, .external_lex_state = 5},
  [4286] = {.lex_state = 75, .external_lex_state = 5},
  [4287] = {.lex_state = 75},
  [4288] = {.lex_state = 75},
  [4289] = {.lex_state = 75, .external_lex_state = 5},
  [4290] = {.lex_state = 75},
  [4291] = {.lex_state = 75, .external_lex_state = 5},
  [4292] = {.lex_state = 75, .external_lex_state = 5},
  [4293] = {.lex_state = 75},
  [4294] = {.lex_state = 75},
  [4295] = {.lex_state = 75},
  [4296] = {.lex_state = 75, .external_lex_state = 5},
  [4297] = {.lex_state = 75, .external_lex_state = 5},
  [4298] = {.lex_state = 75},
  [4299] = {.lex_state = 75},
  [4300] = {.lex_state = 75},
  [4301] = {.lex_state = 75},
  [4302] = {.lex_state = 75},
  [4303] = {.lex_state = 75},
  [4304] = {.lex_state = 18},
  [4305] = {.lex_state = 10},
  [4306] = {.lex_state = 75},
  [4307] = {.lex_state = 0, .external_lex_state = 5},
  [4308] = {.lex_state = 75},
  [4309] = {.lex_state = 10},
  [4310] = {.lex_state = 75, .external_lex_state = 5},
  [4311] = {.lex_state = 75},
  [4312] = {.lex_state = 75},
  [4313] = {.lex_state = 75, .external_lex_state = 5},
  [4314] = {.lex_state = 0, .external_lex_state = 5},
  [4315] = {.lex_state = 75},
  [4316] = {.lex_state = 75},
  [4317] = {.lex_state = 75, .external_lex_state = 6},
  [4318] = {.lex_state = 75},
  [4319] = {.lex_state = 75},
  [4320] = {.lex_state = 0, .external_lex_state = 5},
  [4321] = {.lex_state = 75},
  [4322] = {.lex_state = 75, .external_lex_state = 5},
  [4323] = {.lex_state = 75},
  [4324] = {.lex_state = 75},
  [4325] = {.lex_state = 75},
  [4326] = {.lex_state = 75, .external_lex_state = 5},
  [4327] = {.lex_state = 75},
  [4328] = {.lex_state = 75},
  [4329] = {.lex_state = 75},
  [4330] = {.lex_state = 75, .external_lex_state = 5},
  [4331] = {.lex_state = 75},
  [4332] = {.lex_state = 75, .external_lex_state = 5},
  [4333] = {.lex_state = 75},
  [4334] = {.lex_state = 75},
  [4335] = {.lex_state = 75, .external_lex_state = 5},
  [4336] = {.lex_state = 75, .external_lex_state = 5},
  [4337] = {.lex_state = 75, .external_lex_state = 5},
  [4338] = {.lex_state = 75, .external_lex_state = 5},
  [4339] = {.lex_state = 75, .external_lex_state = 5},
  [4340] = {.lex_state = 75, .external_lex_state = 5},
  [4341] = {.lex_state = 75, .external_lex_state = 5},
  [4342] = {.lex_state = 75},
  [4343] = {.lex_state = 75},
  [4344] = {.lex_state = 75},
  [4345] = {.lex_state = 75},
  [4346] = {.lex_state = 18},
  [4347] = {.lex_state = 75},
  [4348] = {.lex_state = 75, .external_lex_state = 5},
  [4349] = {.lex_state = 75, .external_lex_state = 5},
  [4350] = {.lex_state = 75, .external_lex_state = 5},
  [4351] = {.lex_state = 75},
  [4352] = {.lex_state = 75},
  [4353] = {.lex_state = 75, .external_lex_state = 5},
  [4354] = {.lex_state = 75, .external_lex_state = 5},
  [4355] = {.lex_state = 75},
  [4356] = {.lex_state = 75},
  [4357] = {.lex_state = 75},
  [4358] = {.lex_state = 75},
  [4359] = {.lex_state = 75},
  [4360] = {.lex_state = 75},
  [4361] = {.lex_state = 75},
  [4362] = {.lex_state = 75},
  [4363] = {.lex_state = 75},
  [4364] = {.lex_state = 75},
  [4365] = {.lex_state = 75},
  [4366] = {.lex_state = 75},
  [4367] = {.lex_state = 75},
  [4368] = {.lex_state = 75},
  [4369] = {.lex_state = 75},
  [4370] = {.lex_state = 75},
  [4371] = {.lex_state = 75},
  [4372] = {.lex_state = 75},
  [4373] = {.lex_state = 75},
  [4374] = {.lex_state = 75},
  [4375] = {.lex_state = 75},
  [4376] = {.lex_state = 75},
  [4377] = {.lex_state = 75},
  [4378] = {.lex_state = 75},
  [4379] = {.lex_state = 75, .external_lex_state = 5},
  [4380] = {.lex_state = 75},
  [4381] = {.lex_state = 75},
  [4382] = {.lex_state = 75},
  [4383] = {.lex_state = 75},
  [4384] = {.lex_state = 75, .external_lex_state = 5},
  [4385] = {.lex_state = 75, .external_lex_state = 5},
  [4386] = {.lex_state = 75, .external_lex_state = 5},
  [4387] = {.lex_state = 75, .external_lex_state = 5},
  [4388] = {.lex_state = 75},
  [4389] = {.lex_state = 75},
  [4390] = {.lex_state = 75},
  [4391] = {.lex_state = 0, .external_lex_state = 5},
  [4392] = {.lex_state = 75, .external_lex_state = 5},
  [4393] = {.lex_state = 75},
  [4394] = {.lex_state = 75},
  [4395] = {.lex_state = 75},
  [4396] = {.lex_state = 75},
  [4397] = {.lex_state = 75},
  [4398] = {.lex_state = 75},
  [4399] = {.lex_state = 75},
  [4400] = {.lex_state = 75},
  [4401] = {.lex_state = 75},
  [4402] = {.lex_state = 75},
  [4403] = {.lex_state = 75, .external_lex_state = 5},
  [4404] = {.lex_state = 75},
  [4405] = {.lex_state = 75},
  [4406] = {.lex_state = 0, .external_lex_state = 5},
  [4407] = {.lex_state = 75},
  [4408] = {.lex_state = 75},
  [4409] = {.lex_state = 75},
  [4410] = {.lex_state = 75, .external_lex_state = 5},
  [4411] = {.lex_state = 0, .external_lex_state = 5},
  [4412] = {.lex_state = 75},
  [4413] = {.lex_state = 75},
  [4414] = {.lex_state = 0, .external_lex_state = 5},
  [4415] = {.lex_state = 75},
  [4416] = {.lex_state = 14},
  [4417] = {.lex_state = 14},
  [4418] = {.lex_state = 75},
  [4419] = {.lex_state = 18},
  [4420] = {.lex_state = 75},
  [4421] = {.lex_state = 0, .external_lex_state = 5},
  [4422] = {.lex_state = 0, .external_lex_state = 5},
  [4423] = {.lex_state = 75},
  [4424] = {.lex_state = 75, .external_lex_state = 5},
  [4425] = {.lex_state = 18},
  [4426] = {.lex_state = 75},
  [4427] = {.lex_state = 0, .external_lex_state = 5},
  [4428] = {.lex_state = 75},
  [4429] = {.lex_state = 75},
  [4430] = {.lex_state = 16, .external_lex_state = 7},
  [4431] = {.lex_state = 16, .external_lex_state = 7},
  [4432] = {.lex_state = 75},
  [4433] = {.lex_state = 75},
  [4434] = {.lex_state = 18},
  [4435] = {.lex_state = 18},
  [4436] = {.lex_state = 14},
  [4437] = {.lex_state = 14},
  [4438] = {.lex_state = 75},
  [4439] = {.lex_state = 75},
  [4440] = {.lex_state = 18},
  [4441] = {.lex_state = 16, .external_lex_state = 7},
  [4442] = {.lex_state = 75},
  [4443] = {.lex_state = 75},
  [4444] = {.lex_state = 75},
  [4445] = {.lex_state = 75},
  [4446] = {.lex_state = 75},
  [4447] = {.lex_state = 75},
  [4448] = {.lex_state = 14},
  [4449] = {.lex_state = 10},
  [4450] = {.lex_state = 75},
  [4451] = {.lex_state = 18},
  [4452] = {.lex_state = 75, .external_lex_state = 5},
  [4453] = {.lex_state = 0, .external_lex_state = 5},
  [4454] = {.lex_state = 0, .external_lex_state = 5},
  [4455] = {.lex_state = 0, .external_lex_state = 5},
  [4456] = {.lex_state = 0, .external_lex_state = 5},
  [4457] = {.lex_state = 14},
  [4458] = {.lex_state = 14},
  [4459] = {.lex_state = 75, .external_lex_state = 5},
  [4460] = {.lex_state = 14},
  [4461] = {.lex_state = 75},
  [4462] = {.lex_state = 0, .external_lex_state = 5},
  [4463] = {.lex_state = 14},
  [4464] = {.lex_state = 75},
  [4465] = {.lex_state = 75},
  [4466] = {.lex_state = 75},
  [4467] = {.lex_state = 75},
  [4468] = {.lex_state = 75},
  [4469] = {.lex_state = 75},
  [4470] = {.lex_state = 75},
  [4471] = {.lex_state = 75},
  [4472] = {.lex_state = 75},
  [4473] = {.lex_state = 14},
  [4474] = {.lex_state = 18},
  [4475] = {.lex_state = 16, .external_lex_state = 7},
  [4476] = {.lex_state = 75},
  [4477] = {.lex_state = 75},
  [4478] = {.lex_state = 75},
  [4479] = {.lex_state = 75},
  [4480] = {.lex_state = 75},
  [4481] = {.lex_state = 75},
  [4482] = {.lex_state = 75},
  [4483] = {.lex_state = 75},
  [4484] = {.lex_state = 75},
  [4485] = {.lex_state = 75},
  [4486] = {.lex_state = 14},
  [4487] = {.lex_state = 75, .external_lex_state = 5},
  [4488] = {.lex_state = 18},
  [4489] = {.lex_state = 75},
  [4490] = {.lex_state = 75, .external_lex_state = 5},
  [4491] = {.lex_state = 14},
  [4492] = {.lex_state = 0, .external_lex_state = 5},
  [4493] = {.lex_state = 75},
  [4494] = {.lex_state = 75, .external_lex_state = 5},
  [4495] = {.lex_state = 14},
  [4496] = {.lex_state = 14},
  [4497] = {.lex_state = 75},
  [4498] = {.lex_state = 75},
  [4499] = {.lex_state = 75},
  [4500] = {.lex_state = 16, .external_lex_state = 7},
  [4501] = {.lex_state = 0, .external_lex_state = 5},
  [4502] = {.lex_state = 75},
  [4503] = {.lex_state = 75},
  [4504] = {.lex_state = 75},
  [4505] = {.lex_state = 75},
  [4506] = {.lex_state = 0, .external_lex_state = 5},
  [4507] = {.lex_state = 75},
  [4508] = {.lex_state = 0, .external_lex_state = 5},
  [4509] = {.lex_state = 75},
  [4510] = {.lex_state = 75},
  [4511] = {.lex_state = 75},
  [4512] = {.lex_state = 75},
  [4513] = {.lex_state = 14},
  [4514] = {.lex_state = 75},
  [4515] = {.lex_state = 14},
  [4516] = {.lex_state = 75},
  [4517] = {.lex_state = 75},
  [4518] = {.lex_state = 0, .external_lex_state = 5},
  [4519] = {.lex_state = 14},
  [4520] = {.lex_state = 75},
  [4521] = {.lex_state = 75, .external_lex_state = 5},
  [4522] = {.lex_state = 75, .external_lex_state = 5},
  [4523] = {.lex_state = 0, .external_lex_state = 5},
  [4524] = {.lex_state = 75, .external_lex_state = 5},
  [4525] = {.lex_state = 0, .external_lex_state = 5},
  [4526] = {.lex_state = 75, .external_lex_state = 5},
  [4527] = {.lex_state = 75},
  [4528] = {.lex_state = 75, .external_lex_state = 5},
  [4529] = {.lex_state = 75, .external_lex_state = 5},
  [4530] = {.lex_state = 0, .external_lex_state = 5},
  [4531] = {.lex_state = 0, .external_lex_state = 5},
  [4532] = {.lex_state = 14},
  [4533] = {.lex_state = 75},
  [4534] = {.lex_state = 0, .external_lex_state = 5},
  [4535] = {.lex_state = 18},
  [4536] = {.lex_state = 75},
  [4537] = {.lex_state = 0, .external_lex_state = 5},
  [4538] = {.lex_state = 75},
  [4539] = {.lex_state = 0, .external_lex_state = 5},
  [4540] = {.lex_state = 0, .external_lex_state = 5},
  [4541] = {.lex_state = 75},
  [4542] = {.lex_state = 75},
  [4543] = {.lex_state = 75},
  [4544] = {.lex_state = 75},
  [4545] = {.lex_state = 75},
  [4546] = {.lex_state = 16, .external_lex_state = 7},
  [4547] = {.lex_state = 16, .external_lex_state = 7},
  [4548] = {.lex_state = 0, .external_lex_state = 5},
  [4549] = {.lex_state = 75},
  [4550] = {.lex_state = 75},
  [4551] = {.lex_state = 14},
  [4552] = {.lex_state = 18},
  [4553] = {.lex_state = 75},
  [4554] = {.lex_state = 0, .external_lex_state = 5},
  [4555] = {.lex_state = 75},
  [4556] = {.lex_state = 14},
  [4557] = {.lex_state = 75, .external_lex_state = 5},
  [4558] = {.lex_state = 75},
  [4559] = {.lex_state = 18},
  [4560] = {.lex_state = 75},
  [4561] = {.lex_state = 75},
  [4562] = {.lex_state = 75},
  [4563] = {.lex_state = 75},
  [4564] = {.lex_state = 75},
  [4565] = {.lex_state = 16, .external_lex_state = 7},
  [4566] = {.lex_state = 75, .external_lex_state = 5},
  [4567] = {.lex_state = 75},
  [4568] = {.lex_state = 75},
  [4569] = {.lex_state = 16, .external_lex_state = 7},
  [4570] = {.lex_state = 75, .external_lex_state = 5},
  [4571] = {.lex_state = 0, .external_lex_state = 5},
  [4572] = {.lex_state = 0},
  [4573] = {.lex_state = 14},
  [4574] = {.lex_state = 75},
  [4575] = {.lex_state = 75},
  [4576] = {.lex_state = 0, .external_lex_state = 5},
  [4577] = {.lex_state = 75},
  [4578] = {.lex_state = 14},
  [4579] = {.lex_state = 75, .external_lex_state = 5},
  [4580] = {.lex_state = 75},
  [4581] = {.lex_state = 0, .external_lex_state = 5},
  [4582] = {.lex_state = 75, .external_lex_state = 5},
  [4583] = {.lex_state = 75},
  [4584] = {.lex_state = 0, .external_lex_state = 5},
  [4585] = {.lex_state = 0, .external_lex_state = 5},
  [4586] = {.lex_state = 0, .external_lex_state = 5},
  [4587] = {.lex_state = 18},
  [4588] = {.lex_state = 75},
  [4589] = {.lex_state = 0, .external_lex_state = 5},
  [4590] = {.lex_state = 0, .external_lex_state = 5},
  [4591] = {.lex_state = 75},
  [4592] = {.lex_state = 75},
  [4593] = {.lex_state = 75},
  [4594] = {.lex_state = 0, .external_lex_state = 5},
  [4595] = {.lex_state = 18},
  [4596] = {.lex_state = 18},
  [4597] = {.lex_state = 75},
  [4598] = {.lex_state = 75},
  [4599] = {.lex_state = 0, .external_lex_state = 5},
  [4600] = {.lex_state = 75},
  [4601] = {.lex_state = 75},
  [4602] = {.lex_state = 0, .external_lex_state = 5},
  [4603] = {.lex_state = 75},
  [4604] = {.lex_state = 18},
  [4605] = {.lex_state = 0, .external_lex_state = 5},
  [4606] = {.lex_state = 0, .external_lex_state = 5},
  [4607] = {.lex_state = 0, .external_lex_state = 5},
  [4608] = {.lex_state = 0, .external_lex_state = 5},
  [4609] = {.lex_state = 75, .external_lex_state = 5},
  [4610] = {.lex_state = 75, .external_lex_state = 5},
  [4611] = {.lex_state = 0, .external_lex_state = 5},
  [4612] = {.lex_state = 0, .external_lex_state = 5},
  [4613] = {.lex_state = 0, .external_lex_state = 5},
  [4614] = {.lex_state = 0, .external_lex_state = 5},
  [4615] = {.lex_state = 0, .external_lex_state = 5},
  [4616] = {.lex_state = 75, .external_lex_state = 6},
  [4617] = {.lex_state = 0, .external_lex_state = 5},
  [4618] = {.lex_state = 75},
  [4619] = {.lex_state = 75},
  [4620] = {.lex_state = 75},
  [4621] = {.lex_state = 0, .external_lex_state = 5},
  [4622] = {.lex_state = 75, .external_lex_state = 6},
  [4623] = {.lex_state = 0, .external_lex_state = 5},
  [4624] = {.lex_state = 0, .external_lex_state = 5},
  [4625] = {.lex_state = 75},
  [4626] = {.lex_state = 0, .external_lex_state = 5},
  [4627] = {.lex_state = 0},
  [4628] = {.lex_state = 0},
  [4629] = {.lex_state = 75, .external_lex_state = 6},
  [4630] = {.lex_state = 75},
  [4631] = {.lex_state = 0, .external_lex_state = 5},
  [4632] = {.lex_state = 0, .external_lex_state = 5},
  [4633] = {.lex_state = 0, .external_lex_state = 5},
  [4634] = {.lex_state = 0, .external_lex_state = 5},
  [4635] = {.lex_state = 0, .external_lex_state = 5},
  [4636] = {.lex_state = 0},
  [4637] = {.lex_state = 0, .external_lex_state = 5},
  [4638] = {.lex_state = 75, .external_lex_state = 6},
  [4639] = {.lex_state = 75, .external_lex_state = 6},
  [4640] = {.lex_state = 0, .external_lex_state = 5},
  [4641] = {.lex_state = 0, .external_lex_state = 5},
  [4642] = {.lex_state = 0, .external_lex_state = 5},
  [4643] = {.lex_state = 0},
  [4644] = {.lex_state = 75},
  [4645] = {.lex_state = 0, .external_lex_state = 5},
  [4646] = {.lex_state = 0, .external_lex_state = 5},
  [4647] = {.lex_state = 75},
  [4648] = {.lex_state = 75},
  [4649] = {.lex_state = 0},
  [4650] = {.lex_state = 75},
  [4651] = {.lex_state = 0},
  [4652] = {.lex_state = 0},
  [4653] = {.lex_state = 75},
  [4654] = {.lex_state = 0},
  [4655] = {.lex_state = 75},
  [4656] = {.lex_state = 0, .external_lex_state = 5},
  [4657] = {.lex_state = 75},
  [4658] = {.lex_state = 75},
  [4659] = {.lex_state = 10},
  [4660] = {.lex_state = 14},
  [4661] = {.lex_state = 0},
  [4662] = {.lex_state = 0, .external_lex_state = 5},
  [4663] = {.lex_state = 75},
  [4664] = {.lex_state = 0, .external_lex_state = 5},
  [4665] = {.lex_state = 0, .external_lex_state = 5},
  [4666] = {.lex_state = 75},
  [4667] = {.lex_state = 0},
  [4668] = {.lex_state = 0},
  [4669] = {.lex_state = 0, .external_lex_state = 5},
  [4670] = {.lex_state = 0, .external_lex_state = 5},
  [4671] = {.lex_state = 75},
  [4672] = {.lex_state = 75},
  [4673] = {.lex_state = 75},
  [4674] = {.lex_state = 75, .external_lex_state = 6},
  [4675] = {.lex_state = 75},
  [4676] = {.lex_state = 75},
  [4677] = {.lex_state = 75, .external_lex_state = 5},
  [4678] = {.lex_state = 75},
  [4679] = {.lex_state = 75},
  [4680] = {.lex_state = 75},
  [4681] = {.lex_state = 0, .external_lex_state = 5},
  [4682] = {.lex_state = 75},
  [4683] = {.lex_state = 75},
  [4684] = {.lex_state = 75},
  [4685] = {.lex_state = 75},
  [4686] = {.lex_state = 18},
  [4687] = {.lex_state = 75},
  [4688] = {.lex_state = 0, .external_lex_state = 5},
  [4689] = {.lex_state = 75},
  [4690] = {.lex_state = 75, .external_lex_state = 5},
  [4691] = {.lex_state = 0, .external_lex_state = 5},
  [4692] = {.lex_state = 75},
  [4693] = {.lex_state = 0, .external_lex_state = 5},
  [4694] = {.lex_state = 75},
  [4695] = {.lex_state = 75, .external_lex_state = 5},
  [4696] = {.lex_state = 0, .external_lex_state = 5},
  [4697] = {.lex_state = 75},
  [4698] = {.lex_state = 75},
  [4699] = {.lex_state = 75},
  [4700] = {.lex_state = 0, .external_lex_state = 5},
  [4701] = {.lex_state = 75},
  [4702] = {.lex_state = 0},
  [4703] = {.lex_state = 0, .external_lex_state = 5},
  [4704] = {.lex_state = 18},
  [4705] = {.lex_state = 0, .external_lex_state = 5},
  [4706] = {.lex_state = 0, .external_lex_state = 5},
  [4707] = {.lex_state = 0},
  [4708] = {.lex_state = 75},
  [4709] = {.lex_state = 0, .external_lex_state = 5},
  [4710] = {.lex_state = 75, .external_lex_state = 5},
  [4711] = {.lex_state = 75},
  [4712] = {.lex_state = 0, .external_lex_state = 5},
  [4713] = {.lex_state = 18},
  [4714] = {.lex_state = 75},
  [4715] = {.lex_state = 75},
  [4716] = {.lex_state = 14},
  [4717] = {.lex_state = 0, .external_lex_state = 5},
  [4718] = {.lex_state = 75},
  [4719] = {.lex_state = 0, .external_lex_state = 5},
  [4720] = {.lex_state = 75, .external_lex_state = 5},
  [4721] = {.lex_state = 0},
  [4722] = {.lex_state = 0, .external_lex_state = 5},
  [4723] = {.lex_state = 18},
  [4724] = {.lex_state = 0, .external_lex_state = 5},
  [4725] = {.lex_state = 0, .external_lex_state = 5},
  [4726] = {.lex_state = 75},
  [4727] = {.lex_state = 75},
  [4728] = {.lex_state = 0, .external_lex_state = 5},
  [4729] = {.lex_state = 18},
  [4730] = {.lex_state = 0, .external_lex_state = 5},
  [4731] = {.lex_state = 75},
  [4732] = {.lex_state = 0, .external_lex_state = 5},
  [4733] = {.lex_state = 18},
  [4734] = {.lex_state = 0, .external_lex_state = 5},
  [4735] = {.lex_state = 75},
  [4736] = {.lex_state = 0, .external_lex_state = 5},
  [4737] = {.lex_state = 0, .external_lex_state = 5},
  [4738] = {.lex_state = 75},
  [4739] = {.lex_state = 0},
  [4740] = {.lex_state = 0, .external_lex_state = 5},
  [4741] = {.lex_state = 0, .external_lex_state = 5},
  [4742] = {.lex_state = 0, .external_lex_state = 5},
  [4743] = {.lex_state = 75},
  [4744] = {.lex_state = 18},
  [4745] = {.lex_state = 75},
  [4746] = {.lex_state = 0, .external_lex_state = 5},
  [4747] = {.lex_state = 0, .external_lex_state = 5},
  [4748] = {.lex_state = 0, .external_lex_state = 5},
  [4749] = {.lex_state = 75, .external_lex_state = 5},
  [4750] = {.lex_state = 0, .external_lex_state = 5},
  [4751] = {.lex_state = 0, .external_lex_state = 5},
  [4752] = {.lex_state = 0, .external_lex_state = 5},
  [4753] = {.lex_state = 75},
  [4754] = {.lex_state = 75},
  [4755] = {.lex_state = 0, .external_lex_state = 5},
  [4756] = {.lex_state = 0, .external_lex_state = 5},
  [4757] = {.lex_state = 75, .external_lex_state = 5},
  [4758] = {.lex_state = 75},
  [4759] = {.lex_state = 75},
  [4760] = {.lex_state = 0, .external_lex_state = 5},
  [4761] = {.lex_state = 75},
  [4762] = {.lex_state = 75},
  [4763] = {.lex_state = 75},
  [4764] = {.lex_state = 0},
  [4765] = {.lex_state = 75},
  [4766] = {.lex_state = 0},
  [4767] = {.lex_state = 75},
  [4768] = {.lex_state = 75},
  [4769] = {.lex_state = 0, .external_lex_state = 5},
  [4770] = {.lex_state = 75},
  [4771] = {.lex_state = 75},
  [4772] = {.lex_state = 0, .external_lex_state = 5},
  [4773] = {.lex_state = 75},
  [4774] = {.lex_state = 75},
  [4775] = {.lex_state = 18},
  [4776] = {.lex_state = 75, .external_lex_state = 5},
  [4777] = {.lex_state = 75},
  [4778] = {.lex_state = 75},
  [4779] = {.lex_state = 0, .external_lex_state = 5},
  [4780] = {.lex_state = 75},
  [4781] = {.lex_state = 75},
  [4782] = {.lex_state = 0, .external_lex_state = 5},
  [4783] = {.lex_state = 75},
  [4784] = {.lex_state = 75, .external_lex_state = 5},
  [4785] = {.lex_state = 0, .external_lex_state = 5},
  [4786] = {.lex_state = 75},
  [4787] = {.lex_state = 0},
  [4788] = {.lex_state = 0},
  [4789] = {.lex_state = 0, .external_lex_state = 5},
  [4790] = {.lex_state = 75},
  [4791] = {.lex_state = 75},
  [4792] = {.lex_state = 75},
  [4793] = {.lex_state = 75, .external_lex_state = 6},
  [4794] = {.lex_state = 0, .external_lex_state = 5},
  [4795] = {.lex_state = 0, .external_lex_state = 5},
  [4796] = {.lex_state = 75, .external_lex_state = 5},
  [4797] = {.lex_state = 0},
  [4798] = {.lex_state = 18},
  [4799] = {.lex_state = 75},
  [4800] = {.lex_state = 0, .external_lex_state = 5},
  [4801] = {.lex_state = 75, .external_lex_state = 5},
  [4802] = {.lex_state = 10},
  [4803] = {.lex_state = 0, .external_lex_state = 5},
  [4804] = {.lex_state = 0, .external_lex_state = 5},
  [4805] = {.lex_state = 0, .external_lex_state = 5},
  [4806] = {.lex_state = 0, .external_lex_state = 5},
  [4807] = {.lex_state = 75},
  [4808] = {.lex_state = 75},
  [4809] = {.lex_state = 75, .external_lex_state = 5},
  [4810] = {.lex_state = 75},
  [4811] = {.lex_state = 75},
  [4812] = {.lex_state = 0, .external_lex_state = 5},
  [4813] = {.lex_state = 75},
  [4814] = {.lex_state = 75},
  [4815] = {.lex_state = 75},
  [4816] = {.lex_state = 0},
  [4817] = {.lex_state = 75, .external_lex_state = 5},
  [4818] = {.lex_state = 75},
  [4819] = {.lex_state = 75, .external_lex_state = 5},
  [4820] = {.lex_state = 18},
  [4821] = {.lex_state = 75, .external_lex_state = 5},
  [4822] = {.lex_state = 75},
  [4823] = {.lex_state = 75},
  [4824] = {.lex_state = 0, .external_lex_state = 5},
  [4825] = {.lex_state = 0, .external_lex_state = 5},
  [4826] = {.lex_state = 0, .external_lex_state = 5},
  [4827] = {.lex_state = 75, .external_lex_state = 5},
  [4828] = {.lex_state = 0, .external_lex_state = 5},
  [4829] = {.lex_state = 0, .external_lex_state = 5},
  [4830] = {.lex_state = 0, .external_lex_state = 5},
  [4831] = {.lex_state = 75, .external_lex_state = 6},
  [4832] = {.lex_state = 75},
  [4833] = {.lex_state = 18},
  [4834] = {.lex_state = 75, .external_lex_state = 6},
  [4835] = {.lex_state = 0, .external_lex_state = 5},
  [4836] = {.lex_state = 75, .external_lex_state = 5},
  [4837] = {.lex_state = 75},
  [4838] = {.lex_state = 0, .external_lex_state = 5},
  [4839] = {.lex_state = 0, .external_lex_state = 5},
  [4840] = {.lex_state = 75},
  [4841] = {.lex_state = 0},
  [4842] = {.lex_state = 0, .external_lex_state = 5},
  [4843] = {.lex_state = 0},
  [4844] = {.lex_state = 75},
  [4845] = {.lex_state = 0, .external_lex_state = 5},
  [4846] = {.lex_state = 0},
  [4847] = {.lex_state = 75},
  [4848] = {.lex_state = 0, .external_lex_state = 5},
  [4849] = {.lex_state = 75, .external_lex_state = 6},
  [4850] = {.lex_state = 0, .external_lex_state = 5},
  [4851] = {.lex_state = 0, .external_lex_state = 5},
  [4852] = {.lex_state = 0, .external_lex_state = 5},
  [4853] = {.lex_state = 0, .external_lex_state = 5},
  [4854] = {.lex_state = 0, .external_lex_state = 5},
  [4855] = {.lex_state = 0, .external_lex_state = 5},
  [4856] = {.lex_state = 18},
  [4857] = {.lex_state = 75},
  [4858] = {.lex_state = 0, .external_lex_state = 5},
  [4859] = {.lex_state = 75, .external_lex_state = 6},
  [4860] = {.lex_state = 0, .external_lex_state = 5},
  [4861] = {.lex_state = 75},
  [4862] = {.lex_state = 0, .external_lex_state = 5},
  [4863] = {.lex_state = 75, .external_lex_state = 5},
  [4864] = {.lex_state = 0},
  [4865] = {.lex_state = 75},
  [4866] = {.lex_state = 75},
  [4867] = {.lex_state = 10},
  [4868] = {.lex_state = 75},
  [4869] = {.lex_state = 75},
  [4870] = {.lex_state = 0, .external_lex_state = 5},
  [4871] = {.lex_state = 75, .external_lex_state = 6},
  [4872] = {.lex_state = 0},
  [4873] = {.lex_state = 75},
  [4874] = {.lex_state = 0, .external_lex_state = 5},
  [4875] = {.lex_state = 75, .external_lex_state = 5},
  [4876] = {.lex_state = 75},
  [4877] = {.lex_state = 75},
  [4878] = {.lex_state = 18},
  [4879] = {.lex_state = 75, .external_lex_state = 6},
  [4880] = {.lex_state = 0, .external_lex_state = 5},
  [4881] = {.lex_state = 0, .external_lex_state = 5},
  [4882] = {.lex_state = 75, .external_lex_state = 6},
  [4883] = {.lex_state = 18},
  [4884] = {.lex_state = 0, .external_lex_state = 5},
  [4885] = {.lex_state = 0, .external_lex_state = 5},
  [4886] = {.lex_state = 75},
  [4887] = {.lex_state = 0, .external_lex_state = 5},
  [4888] = {.lex_state = 0, .external_lex_state = 5},
  [4889] = {.lex_state = 0, .external_lex_state = 5},
  [4890] = {.lex_state = 75, .external_lex_state = 5},
  [4891] = {.lex_state = 0, .external_lex_state = 5},
  [4892] = {.lex_state = 75},
  [4893] = {.lex_state = 0, .external_lex_state = 5},
  [4894] = {.lex_state = 75},
  [4895] = {.lex_state = 75},
  [4896] = {.lex_state = 0, .external_lex_state = 5},
  [4897] = {.lex_state = 0},
  [4898] = {.lex_state = 0, .external_lex_state = 5},
  [4899] = {.lex_state = 18},
  [4900] = {.lex_state = 75},
  [4901] = {.lex_state = 10},
  [4902] = {.lex_state = 75, .external_lex_state = 5},
  [4903] = {.lex_state = 75},
  [4904] = {.lex_state = 75},
  [4905] = {.lex_state = 75},
  [4906] = {.lex_state = 75, .external_lex_state = 6},
  [4907] = {.lex_state = 75},
  [4908] = {.lex_state = 75, .external_lex_state = 5},
  [4909] = {.lex_state = 0, .external_lex_state = 5},
  [4910] = {.lex_state = 0, .external_lex_state = 5},
  [4911] = {.lex_state = 0, .external_lex_state = 5},
  [4912] = {.lex_state = 75},
  [4913] = {.lex_state = 75},
  [4914] = {.lex_state = 75},
  [4915] = {.lex_state = 75},
  [4916] = {.lex_state = 75},
  [4917] = {.lex_state = 75},
  [4918] = {.lex_state = 75},
  [4919] = {.lex_state = 15},
  [4920] = {.lex_state = 0},
  [4921] = {.lex_state = 75, .external_lex_state = 6},
  [4922] = {.lex_state = 0, .external_lex_state = 5},
  [4923] = {.lex_state = 75},
  [4924] = {.lex_state = 75},
  [4925] = {.lex_state = 15},
  [4926] = {.lex_state = 19},
  [4927] = {.lex_state = 75},
  [4928] = {.lex_state = 75},
  [4929] = {.lex_state = 75},
  [4930] = {.lex_state = 75},
  [4931] = {.lex_state = 15},
  [4932] = {.lex_state = 19},
  [4933] = {.lex_state = 75},
  [4934] = {.lex_state = 19},
  [4935] = {.lex_state = 15},
  [4936] = {.lex_state = 75},
  [4937] = {.lex_state = 75},
  [4938] = {.lex_state = 75},
  [4939] = {.lex_state = 0},
  [4940] = {.lex_state = 75},
  [4941] = {.lex_state = 75},
  [4942] = {.lex_state = 75},
  [4943] = {.lex_state = 15},
  [4944] = {.lex_state = 75},
  [4945] = {.lex_state = 75},
  [4946] = {.lex_state = 75, .external_lex_state = 6},
  [4947] = {.lex_state = 0},
  [4948] = {.lex_state = 75},
  [4949] = {.lex_state = 75},
  [4950] = {.lex_state = 75},
  [4951] = {.lex_state = 75},
  [4952] = {.lex_state = 75},
  [4953] = {.lex_state = 75},
  [4954] = {.lex_state = 75},
  [4955] = {.lex_state = 75},
  [4956] = {.lex_state = 75},
  [4957] = {.lex_state = 0, .external_lex_state = 5},
  [4958] = {.lex_state = 0},
  [4959] = {.lex_state = 75, .external_lex_state = 6},
  [4960] = {.lex_state = 75},
  [4961] = {.lex_state = 75},
  [4962] = {.lex_state = 75},
  [4963] = {.lex_state = 75},
  [4964] = {.lex_state = 75},
  [4965] = {.lex_state = 75},
  [4966] = {.lex_state = 0, .external_lex_state = 5},
  [4967] = {.lex_state = 75},
  [4968] = {.lex_state = 75},
  [4969] = {.lex_state = 75, .external_lex_state = 6},
  [4970] = {.lex_state = 75},
  [4971] = {.lex_state = 0},
  [4972] = {.lex_state = 14},
  [4973] = {.lex_state = 75},
  [4974] = {.lex_state = 75},
  [4975] = {.lex_state = 75},
  [4976] = {.lex_state = 0},
  [4977] = {.lex_state = 0},
  [4978] = {.lex_state = 0},
  [4979] = {.lex_state = 19},
  [4980] = {.lex_state = 75},
  [4981] = {.lex_state = 15},
  [4982] = {.lex_state = 75},
  [4983] = {.lex_state = 15},
  [4984] = {.lex_state = 19},
  [4985] = {.lex_state = 19},
  [4986] = {.lex_state = 75},
  [4987] = {.lex_state = 15},
  [4988] = {.lex_state = 75},
  [4989] = {.lex_state = 75},
  [4990] = {.lex_state = 75},
  [4991] = {.lex_state = 16, .external_lex_state = 7},
  [4992] = {.lex_state = 75},
  [4993] = {.lex_state = 75},
  [4994] = {.lex_state = 75},
  [4995] = {.lex_state = 75},
  [4996] = {.lex_state = 75, .external_lex_state = 5},
  [4997] = {.lex_state = 15},
  [4998] = {.lex_state = 75, .external_lex_state = 5},
  [4999] = {.lex_state = 75},
  [5000] = {.lex_state = 75},
  [5001] = {.lex_state = 19},
  [5002] = {.lex_state = 75},
  [5003] = {.lex_state = 75},
  [5004] = {.lex_state = 0},
  [5005] = {.lex_state = 75},
  [5006] = {.lex_state = 19},
  [5007] = {.lex_state = 75},
  [5008] = {.lex_state = 75},
  [5009] = {.lex_state = 75},
  [5010] = {.lex_state = 0, .external_lex_state = 5},
  [5011] = {.lex_state = 75},
  [5012] = {.lex_state = 15},
  [5013] = {.lex_state = 0, .external_lex_state = 5},
  [5014] = {.lex_state = 0},
  [5015] = {.lex_state = 75},
  [5016] = {.lex_state = 75},
  [5017] = {.lex_state = 15},
  [5018] = {.lex_state = 75},
  [5019] = {.lex_state = 19},
  [5020] = {.lex_state = 75},
  [5021] = {.lex_state = 75},
  [5022] = {.lex_state = 19},
  [5023] = {.lex_state = 0},
  [5024] = {.lex_state = 14},
  [5025] = {.lex_state = 75},
  [5026] = {.lex_state = 75},
  [5027] = {.lex_state = 75},
  [5028] = {.lex_state = 19},
  [5029] = {.lex_state = 15},
  [5030] = {.lex_state = 75},
  [5031] = {.lex_state = 15},
  [5032] = {.lex_state = 75},
  [5033] = {.lex_state = 75},
  [5034] = {.lex_state = 19},
  [5035] = {.lex_state = 75},
  [5036] = {.lex_state = 15},
  [5037] = {.lex_state = 75},
  [5038] = {.lex_state = 19},
  [5039] = {.lex_state = 75},
  [5040] = {.lex_state = 15},
  [5041] = {.lex_state = 75},
  [5042] = {.lex_state = 75},
  [5043] = {.lex_state = 19},
  [5044] = {.lex_state = 75},
  [5045] = {.lex_state = 14},
  [5046] = {.lex_state = 75},
  [5047] = {.lex_state = 75},
  [5048] = {.lex_state = 75},
  [5049] = {.lex_state = 75},
  [5050] = {.lex_state = 75},
  [5051] = {.lex_state = 0, .external_lex_state = 5},
  [5052] = {.lex_state = 0, .external_lex_state = 5},
  [5053] = {.lex_state = 75},
  [5054] = {.lex_state = 75},
  [5055] = {.lex_state = 0},
  [5056] = {.lex_state = 0},
  [5057] = {.lex_state = 75},
  [5058] = {.lex_state = 75},
  [5059] = {.lex_state = 19},
  [5060] = {.lex_state = 15},
  [5061] = {.lex_state = 75},
  [5062] = {.lex_state = 75},
  [5063] = {.lex_state = 75},
  [5064] = {.lex_state = 0, .external_lex_state = 5},
  [5065] = {.lex_state = 75},
  [5066] = {.lex_state = 19},
  [5067] = {.lex_state = 75},
  [5068] = {.lex_state = 75},
  [5069] = {.lex_state = 75},
  [5070] = {.lex_state = 75},
  [5071] = {.lex_state = 75},
  [5072] = {.lex_state = 75},
  [5073] = {.lex_state = 75},
  [5074] = {.lex_state = 15},
  [5075] = {.lex_state = 75},
  [5076] = {.lex_state = 75},
  [5077] = {.lex_state = 75},
  [5078] = {.lex_state = 75},
  [5079] = {.lex_state = 75},
  [5080] = {.lex_state = 75},
  [5081] = {.lex_state = 75},
  [5082] = {.lex_state = 0},
  [5083] = {.lex_state = 0, .external_lex_state = 5},
  [5084] = {.lex_state = 75},
  [5085] = {.lex_state = 15},
  [5086] = {.lex_state = 19},
  [5087] = {.lex_state = 75},
  [5088] = {.lex_state = 0},
  [5089] = {.lex_state = 14},
  [5090] = {.lex_state = 14},
  [5091] = {.lex_state = 19},
  [5092] = {.lex_state = 75},
  [5093] = {.lex_state = 75},
  [5094] = {.lex_state = 75},
  [5095] = {.lex_state = 75},
  [5096] = {.lex_state = 0},
  [5097] = {.lex_state = 0},
  [5098] = {.lex_state = 19},
  [5099] = {.lex_state = 15},
  [5100] = {.lex_state = 75},
  [5101] = {.lex_state = 75},
  [5102] = {.lex_state = 75},
  [5103] = {.lex_state = 75},
  [5104] = {.lex_state = 14},
  [5105] = {.lex_state = 75},
  [5106] = {.lex_state = 0},
  [5107] = {.lex_state = 75},
  [5108] = {.lex_state = 0},
  [5109] = {.lex_state = 0, .external_lex_state = 5},
  [5110] = {.lex_state = 0},
  [5111] = {.lex_state = 0},
  [5112] = {.lex_state = 0},
  [5113] = {.lex_state = 75},
  [5114] = {.lex_state = 26},
  [5115] = {.lex_state = 75},
  [5116] = {.lex_state = 0, .external_lex_state = 5},
  [5117] = {.lex_state = 26},
  [5118] = {.lex_state = 0},
  [5119] = {.lex_state = 0},
  [5120] = {.lex_state = 0},
  [5121] = {.lex_state = 75},
  [5122] = {.lex_state = 75},
  [5123] = {.lex_state = 75},
  [5124] = {.lex_state = 0},
  [5125] = {.lex_state = 0},
  [5126] = {.lex_state = 0},
  [5127] = {.lex_state = 0},
  [5128] = {.lex_state = 0, .external_lex_state = 5},
  [5129] = {.lex_state = 0},
  [5130] = {.lex_state = 75},
  [5131] = {.lex_state = 0},
  [5132] = {.lex_state = 0, .external_lex_state = 5},
  [5133] = {.lex_state = 75},
  [5134] = {.lex_state = 75},
  [5135] = {.lex_state = 0, .external_lex_state = 5},
  [5136] = {.lex_state = 0, .external_lex_state = 5},
  [5137] = {.lex_state = 75},
  [5138] = {.lex_state = 75},
  [5139] = {.lex_state = 0, .external_lex_state = 5},
  [5140] = {.lex_state = 0, .external_lex_state = 5},
  [5141] = {.lex_state = 0},
  [5142] = {.lex_state = 0},
  [5143] = {.lex_state = 26},
  [5144] = {.lex_state = 0, .external_lex_state = 5},
  [5145] = {.lex_state = 0},
  [5146] = {.lex_state = 0},
  [5147] = {.lex_state = 0, .external_lex_state = 5},
  [5148] = {.lex_state = 0},
  [5149] = {.lex_state = 0},
  [5150] = {.lex_state = 0},
  [5151] = {.lex_state = 0},
  [5152] = {.lex_state = 0, .external_lex_state = 5},
  [5153] = {.lex_state = 0, .external_lex_state = 5},
  [5154] = {.lex_state = 0, .external_lex_state = 5},
  [5155] = {.lex_state = 26},
  [5156] = {.lex_state = 0},
  [5157] = {.lex_state = 0, .external_lex_state = 5},
  [5158] = {.lex_state = 0, .external_lex_state = 5},
  [5159] = {.lex_state = 0},
  [5160] = {.lex_state = 0},
  [5161] = {.lex_state = 0},
  [5162] = {.lex_state = 0, .external_lex_state = 5},
  [5163] = {.lex_state = 0},
  [5164] = {.lex_state = 75},
  [5165] = {.lex_state = 0},
  [5166] = {.lex_state = 0, .external_lex_state = 5},
  [5167] = {.lex_state = 0, .external_lex_state = 5},
  [5168] = {.lex_state = 0, .external_lex_state = 5},
  [5169] = {.lex_state = 0, .external_lex_state = 5},
  [5170] = {.lex_state = 0, .external_lex_state = 5},
  [5171] = {.lex_state = 0},
  [5172] = {.lex_state = 0},
  [5173] = {.lex_state = 0},
  [5174] = {.lex_state = 75},
  [5175] = {.lex_state = 75},
  [5176] = {.lex_state = 0},
  [5177] = {.lex_state = 75},
  [5178] = {.lex_state = 0, .external_lex_state = 5},
  [5179] = {.lex_state = 75},
  [5180] = {.lex_state = 0, .external_lex_state = 5},
  [5181] = {.lex_state = 26},
  [5182] = {.lex_state = 0, .external_lex_state = 5},
  [5183] = {.lex_state = 0},
  [5184] = {.lex_state = 0, .external_lex_state = 5},
  [5185] = {.lex_state = 0, .external_lex_state = 5},
  [5186] = {.lex_state = 75},
  [5187] = {.lex_state = 0},
  [5188] = {.lex_state = 0},
  [5189] = {.lex_state = 0},
  [5190] = {.lex_state = 75},
  [5191] = {.lex_state = 0},
  [5192] = {.lex_state = 0},
  [5193] = {.lex_state = 75},
  [5194] = {.lex_state = 0},
  [5195] = {.lex_state = 75},
  [5196] = {.lex_state = 0},
  [5197] = {.lex_state = 75},
  [5198] = {.lex_state = 0, .external_lex_state = 5},
  [5199] = {.lex_state = 75},
  [5200] = {.lex_state = 75},
  [5201] = {.lex_state = 0, .external_lex_state = 5},
  [5202] = {.lex_state = 75},
  [5203] = {.lex_state = 0},
  [5204] = {.lex_state = 0},
  [5205] = {.lex_state = 75},
  [5206] = {.lex_state = 0},
  [5207] = {.lex_state = 75},
  [5208] = {.lex_state = 0, .external_lex_state = 5},
  [5209] = {.lex_state = 0, .external_lex_state = 5},
  [5210] = {.lex_state = 10},
  [5211] = {.lex_state = 75},
  [5212] = {.lex_state = 0},
  [5213] = {.lex_state = 0},
  [5214] = {.lex_state = 0},
  [5215] = {.lex_state = 75},
  [5216] = {.lex_state = 0, .external_lex_state = 5},
  [5217] = {.lex_state = 0},
  [5218] = {.lex_state = 75},
  [5219] = {.lex_state = 0},
  [5220] = {.lex_state = 0},
  [5221] = {.lex_state = 0},
  [5222] = {.lex_state = 0},
  [5223] = {.lex_state = 75},
  [5224] = {.lex_state = 0},
  [5225] = {.lex_state = 75},
  [5226] = {.lex_state = 0},
  [5227] = {.lex_state = 75},
  [5228] = {.lex_state = 0},
  [5229] = {.lex_state = 75},
  [5230] = {.lex_state = 0},
  [5231] = {.lex_state = 26},
  [5232] = {.lex_state = 0},
  [5233] = {.lex_state = 26},
  [5234] = {.lex_state = 0},
  [5235] = {.lex_state = 0},
  [5236] = {.lex_state = 0, .external_lex_state = 5},
  [5237] = {.lex_state = 26},
  [5238] = {.lex_state = 0},
  [5239] = {.lex_state = 0, .external_lex_state = 5},
  [5240] = {.lex_state = 26},
  [5241] = {.lex_state = 26},
  [5242] = {.lex_state = 75},
  [5243] = {.lex_state = 0},
  [5244] = {.lex_state = 75},
  [5245] = {.lex_state = 75},
  [5246] = {.lex_state = 0},
  [5247] = {.lex_state = 10},
  [5248] = {.lex_state = 75},
  [5249] = {.lex_state = 0},
  [5250] = {.lex_state = 75},
  [5251] = {.lex_state = 75},
  [5252] = {.lex_state = 0},
  [5253] = {.lex_state = 26},
  [5254] = {.lex_state = 75},
  [5255] = {.lex_state = 26},
  [5256] = {.lex_state = 75},
  [5257] = {.lex_state = 0},
  [5258] = {.lex_state = 26},
  [5259] = {.lex_state = 75},
  [5260] = {.lex_state = 0},
  [5261] = {.lex_state = 26},
  [5262] = {.lex_state = 0},
  [5263] = {.lex_state = 75},
  [5264] = {.lex_state = 26},
  [5265] = {.lex_state = 75},
  [5266] = {.lex_state = 26},
  [5267] = {.lex_state = 0},
  [5268] = {.lex_state = 75},
  [5269] = {.lex_state = 26},
  [5270] = {.lex_state = 75},
  [5271] = {.lex_state = 0},
  [5272] = {.lex_state = 0},
  [5273] = {.lex_state = 0},
  [5274] = {.lex_state = 75},
  [5275] = {.lex_state = 0, .external_lex_state = 5},
  [5276] = {.lex_state = 75},
  [5277] = {.lex_state = 75},
  [5278] = {.lex_state = 26},
  [5279] = {.lex_state = 0},
  [5280] = {.lex_state = 75},
  [5281] = {.lex_state = 0},
  [5282] = {.lex_state = 0},
  [5283] = {.lex_state = 0},
  [5284] = {.lex_state = 0},
  [5285] = {.lex_state = 0},
  [5286] = {.lex_state = 0},
  [5287] = {.lex_state = 26},
  [5288] = {.lex_state = 26},
  [5289] = {.lex_state = 26},
  [5290] = {.lex_state = 0},
  [5291] = {.lex_state = 0},
  [5292] = {.lex_state = 0},
  [5293] = {.lex_state = 0, .external_lex_state = 5},
  [5294] = {.lex_state = 75},
  [5295] = {.lex_state = 75},
  [5296] = {.lex_state = 75},
  [5297] = {.lex_state = 0, .external_lex_state = 5},
  [5298] = {.lex_state = 0, .external_lex_state = 5},
  [5299] = {.lex_state = 0},
  [5300] = {.lex_state = 75},
  [5301] = {.lex_state = 0},
  [5302] = {.lex_state = 0},
  [5303] = {.lex_state = 0},
  [5304] = {.lex_state = 0},
  [5305] = {.lex_state = 75},
  [5306] = {.lex_state = 0, .external_lex_state = 5},
  [5307] = {.lex_state = 0},
  [5308] = {.lex_state = 0},
  [5309] = {.lex_state = 0},
  [5310] = {.lex_state = 75},
  [5311] = {.lex_state = 75},
  [5312] = {.lex_state = 75},
  [5313] = {.lex_state = 75, .external_lex_state = 5},
  [5314] = {.lex_state = 75},
  [5315] = {.lex_state = 0},
  [5316] = {.lex_state = 0, .external_lex_state = 5},
  [5317] = {.lex_state = 75},
  [5318] = {.lex_state = 75},
  [5319] = {.lex_state = 0, .external_lex_state = 5},
  [5320] = {.lex_state = 0, .external_lex_state = 5},
  [5321] = {.lex_state = 0, .external_lex_state = 5},
  [5322] = {.lex_state = 75},
  [5323] = {.lex_state = 75},
  [5324] = {.lex_state = 75},
  [5325] = {.lex_state = 75},
  [5326] = {.lex_state = 0},
  [5327] = {.lex_state = 75},
  [5328] = {.lex_state = 75, .external_lex_state = 5},
  [5329] = {.lex_state = 0, .external_lex_state = 5},
  [5330] = {.lex_state = 0},
  [5331] = {.lex_state = 0, .external_lex_state = 5},
  [5332] = {.lex_state = 0},
  [5333] = {.lex_state = 75},
  [5334] = {.lex_state = 0},
  [5335] = {.lex_state = 0},
  [5336] = {.lex_state = 75},
  [5337] = {.lex_state = 0, .external_lex_state = 5},
  [5338] = {.lex_state = 75},
  [5339] = {.lex_state = 0},
  [5340] = {.lex_state = 0},
  [5341] = {.lex_state = 75},
  [5342] = {.lex_state = 0},
  [5343] = {.lex_state = 0, .external_lex_state = 5},
  [5344] = {.lex_state = 75},
  [5345] = {.lex_state = 0},
  [5346] = {.lex_state = 75},
  [5347] = {.lex_state = 0},
  [5348] = {.lex_state = 0},
  [5349] = {.lex_state = 75},
  [5350] = {.lex_state = 0},
  [5351] = {.lex_state = 0, .external_lex_state = 5},
  [5352] = {.lex_state = 0},
  [5353] = {.lex_state = 0},
  [5354] = {.lex_state = 75},
  [5355] = {.lex_state = 75},
  [5356] = {.lex_state = 75},
  [5357] = {.lex_state = 10},
  [5358] = {.lex_state = 75},
  [5359] = {.lex_state = 75},
  [5360] = {.lex_state = 75},
  [5361] = {.lex_state = 75},
  [5362] = {.lex_state = 75},
  [5363] = {.lex_state = 75},
  [5364] = {.lex_state = 0},
  [5365] = {.lex_state = 0},
  [5366] = {.lex_state = 0},
  [5367] = {.lex_state = 75},
  [5368] = {.lex_state = 0},
  [5369] = {.lex_state = 0},
  [5370] = {.lex_state = 0},
  [5371] = {.lex_state = 75},
  [5372] = {.lex_state = 0},
  [5373] = {.lex_state = 75},
  [5374] = {.lex_state = 75},
  [5375] = {.lex_state = 0},
  [5376] = {.lex_state = 75},
  [5377] = {.lex_state = 0},
  [5378] = {.lex_state = 0},
  [5379] = {.lex_state = 75},
  [5380] = {.lex_state = 75},
  [5381] = {.lex_state = 75},
  [5382] = {.lex_state = 75},
  [5383] = {.lex_state = 0},
  [5384] = {.lex_state = 0},
  [5385] = {.lex_state = 75},
  [5386] = {.lex_state = 75},
  [5387] = {.lex_state = 0},
  [5388] = {.lex_state = 75},
  [5389] = {.lex_state = 75},
  [5390] = {.lex_state = 0},
  [5391] = {.lex_state = 0},
  [5392] = {.lex_state = 75},
  [5393] = {.lex_state = 0},
  [5394] = {.lex_state = 75},
  [5395] = {.lex_state = 0},
  [5396] = {.lex_state = 0},
  [5397] = {.lex_state = 0},
  [5398] = {.lex_state = 0},
  [5399] = {.lex_state = 75},
  [5400] = {.lex_state = 0},
  [5401] = {.lex_state = 75},
  [5402] = {.lex_state = 0, .external_lex_state = 5},
  [5403] = {.lex_state = 0},
  [5404] = {.lex_state = 0},
  [5405] = {.lex_state = 75},
  [5406] = {.lex_state = 75},
  [5407] = {.lex_state = 75},
  [5408] = {.lex_state = 0},
  [5409] = {.lex_state = 0},
  [5410] = {.lex_state = 0},
  [5411] = {.lex_state = 75},
  [5412] = {.lex_state = 75},
  [5413] = {.lex_state = 0},
  [5414] = {.lex_state = 0},
  [5415] = {.lex_state = 75},
  [5416] = {.lex_state = 0},
  [5417] = {.lex_state = 75},
  [5418] = {.lex_state = 0},
  [5419] = {.lex_state = 75},
  [5420] = {.lex_state = 75},
  [5421] = {.lex_state = 0, .external_lex_state = 5},
  [5422] = {.lex_state = 0},
  [5423] = {.lex_state = 0},
  [5424] = {.lex_state = 0},
  [5425] = {.lex_state = 75},
  [5426] = {.lex_state = 0},
  [5427] = {.lex_state = 0},
  [5428] = {.lex_state = 75},
  [5429] = {.lex_state = 75},
  [5430] = {.lex_state = 75},
  [5431] = {.lex_state = 0},
  [5432] = {.lex_state = 0},
  [5433] = {.lex_state = 0},
  [5434] = {.lex_state = 75},
  [5435] = {.lex_state = 75},
  [5436] = {.lex_state = 0},
  [5437] = {.lex_state = 0},
  [5438] = {.lex_state = 75},
  [5439] = {.lex_state = 0, .external_lex_state = 5},
  [5440] = {.lex_state = 75},
  [5441] = {.lex_state = 75},
  [5442] = {.lex_state = 75},
  [5443] = {.lex_state = 0},
  [5444] = {.lex_state = 75},
  [5445] = {.lex_state = 75},
  [5446] = {.lex_state = 75},
  [5447] = {.lex_state = 75},
  [5448] = {.lex_state = 0},
  [5449] = {.lex_state = 0, .external_lex_state = 5},
  [5450] = {.lex_state = 0},
  [5451] = {.lex_state = 0},
  [5452] = {.lex_state = 75},
  [5453] = {.lex_state = 0},
  [5454] = {.lex_state = 75},
  [5455] = {.lex_state = 75},
  [5456] = {.lex_state = 75},
  [5457] = {.lex_state = 0},
  [5458] = {.lex_state = 75},
  [5459] = {.lex_state = 0, .external_lex_state = 5},
  [5460] = {.lex_state = 75},
  [5461] = {.lex_state = 75},
  [5462] = {.lex_state = 0},
  [5463] = {.lex_state = 75},
  [5464] = {.lex_state = 0},
  [5465] = {.lex_state = 75},
  [5466] = {.lex_state = 75},
  [5467] = {.lex_state = 0},
  [5468] = {.lex_state = 0},
  [5469] = {.lex_state = 0},
  [5470] = {.lex_state = 75},
  [5471] = {.lex_state = 0},
  [5472] = {.lex_state = 14},
  [5473] = {.lex_state = 0},
  [5474] = {.lex_state = 0},
  [5475] = {.lex_state = 75},
  [5476] = {.lex_state = 0},
  [5477] = {.lex_state = 0},
  [5478] = {.lex_state = 0},
  [5479] = {.lex_state = 0},
  [5480] = {.lex_state = 75},
  [5481] = {.lex_state = 0},
  [5482] = {.lex_state = 0},
  [5483] = {.lex_state = 0},
  [5484] = {.lex_state = 0},
  [5485] = {.lex_state = 0},
  [5486] = {.lex_state = 75},
  [5487] = {.lex_state = 0},
  [5488] = {.lex_state = 75},
  [5489] = {.lex_state = 75},
  [5490] = {.lex_state = 75},
  [5491] = {.lex_state = 0},
  [5492] = {.lex_state = 0},
  [5493] = {.lex_state = 0},
  [5494] = {.lex_state = 0, .external_lex_state = 5},
  [5495] = {.lex_state = 0},
  [5496] = {.lex_state = 75},
  [5497] = {.lex_state = 75},
  [5498] = {.lex_state = 75},
  [5499] = {.lex_state = 75},
  [5500] = {.lex_state = 75},
  [5501] = {.lex_state = 0, .external_lex_state = 5},
  [5502] = {.lex_state = 75},
  [5503] = {.lex_state = 75},
  [5504] = {.lex_state = 0},
  [5505] = {.lex_state = 75},
  [5506] = {.lex_state = 75},
  [5507] = {.lex_state = 75},
  [5508] = {.lex_state = 0, .external_lex_state = 5},
  [5509] = {.lex_state = 0},
  [5510] = {.lex_state = 0},
  [5511] = {.lex_state = 75},
  [5512] = {.lex_state = 75},
  [5513] = {.lex_state = 75},
  [5514] = {.lex_state = 75},
  [5515] = {.lex_state = 75},
  [5516] = {.lex_state = 0},
  [5517] = {.lex_state = 0},
  [5518] = {.lex_state = 0},
  [5519] = {.lex_state = 75},
  [5520] = {.lex_state = 0},
  [5521] = {.lex_state = 75},
  [5522] = {.lex_state = 0, .external_lex_state = 5},
  [5523] = {.lex_state = 75},
  [5524] = {.lex_state = 0, .external_lex_state = 5},
  [5525] = {.lex_state = 75},
  [5526] = {.lex_state = 75},
  [5527] = {.lex_state = 0, .external_lex_state = 5},
  [5528] = {.lex_state = 0, .external_lex_state = 5},
  [5529] = {.lex_state = 75},
  [5530] = {.lex_state = 75},
  [5531] = {.lex_state = 0, .external_lex_state = 5},
  [5532] = {.lex_state = 75},
  [5533] = {.lex_state = 0},
  [5534] = {.lex_state = 0},
  [5535] = {.lex_state = 0, .external_lex_state = 5},
  [5536] = {.lex_state = 75},
  [5537] = {.lex_state = 75},
  [5538] = {.lex_state = 75},
  [5539] = {.lex_state = 75},
  [5540] = {.lex_state = 75},
  [5541] = {.lex_state = 0},
  [5542] = {.lex_state = 75},
  [5543] = {.lex_state = 75},
  [5544] = {.lex_state = 0},
  [5545] = {.lex_state = 75},
  [5546] = {.lex_state = 75},
  [5547] = {.lex_state = 0},
  [5548] = {.lex_state = 0},
  [5549] = {.lex_state = 75},
  [5550] = {.lex_state = 0},
  [5551] = {.lex_state = 75},
  [5552] = {.lex_state = 75},
  [5553] = {.lex_state = 75},
  [5554] = {.lex_state = 0},
  [5555] = {.lex_state = 75},
  [5556] = {.lex_state = 0},
  [5557] = {.lex_state = 75},
  [5558] = {.lex_state = 0},
  [5559] = {.lex_state = 75},
  [5560] = {.lex_state = 75},
  [5561] = {.lex_state = 0},
  [5562] = {.lex_state = 0, .external_lex_state = 5},
  [5563] = {.lex_state = 75},
  [5564] = {.lex_state = 0},
  [5565] = {.lex_state = 75},
  [5566] = {.lex_state = 75},
  [5567] = {.lex_state = 75},
  [5568] = {.lex_state = 75},
  [5569] = {.lex_state = 0, .external_lex_state = 5},
  [5570] = {.lex_state = 0},
  [5571] = {.lex_state = 0},
  [5572] = {.lex_state = 0, .external_lex_state = 5},
  [5573] = {.lex_state = 0, .external_lex_state = 5},
  [5574] = {.lex_state = 75},
  [5575] = {.lex_state = 0},
  [5576] = {.lex_state = 75},
  [5577] = {.lex_state = 0},
  [5578] = {.lex_state = 75},
  [5579] = {.lex_state = 0},
  [5580] = {.lex_state = 0},
  [5581] = {.lex_state = 0},
  [5582] = {.lex_state = 75},
  [5583] = {.lex_state = 75},
  [5584] = {.lex_state = 0},
  [5585] = {.lex_state = 75},
  [5586] = {.lex_state = 0},
  [5587] = {.lex_state = 0, .external_lex_state = 5},
  [5588] = {.lex_state = 75},
  [5589] = {.lex_state = 75},
  [5590] = {.lex_state = 0},
  [5591] = {.lex_state = 75},
  [5592] = {.lex_state = 75},
  [5593] = {.lex_state = 0},
  [5594] = {.lex_state = 75},
  [5595] = {.lex_state = 75},
  [5596] = {.lex_state = 75},
  [5597] = {.lex_state = 0},
  [5598] = {.lex_state = 0},
  [5599] = {.lex_state = 75},
  [5600] = {.lex_state = 0},
  [5601] = {.lex_state = 0},
  [5602] = {.lex_state = 75},
  [5603] = {.lex_state = 0},
  [5604] = {.lex_state = 0},
  [5605] = {.lex_state = 75},
  [5606] = {.lex_state = 75},
  [5607] = {.lex_state = 75},
  [5608] = {.lex_state = 0},
  [5609] = {.lex_state = 75},
  [5610] = {.lex_state = 0},
  [5611] = {.lex_state = 75},
  [5612] = {.lex_state = 75},
  [5613] = {.lex_state = 75},
  [5614] = {.lex_state = 75},
  [5615] = {.lex_state = 75},
  [5616] = {.lex_state = 0, .external_lex_state = 5},
  [5617] = {.lex_state = 0, .external_lex_state = 5},
  [5618] = {.lex_state = 0},
  [5619] = {.lex_state = 75},
  [5620] = {.lex_state = 75},
  [5621] = {.lex_state = 0},
  [5622] = {.lex_state = 0},
  [5623] = {.lex_state = 75},
  [5624] = {.lex_state = 0, .external_lex_state = 5},
  [5625] = {.lex_state = 0, .external_lex_state = 5},
  [5626] = {.lex_state = 75},
  [5627] = {.lex_state = 75},
  [5628] = {.lex_state = 75},
  [5629] = {.lex_state = 75},
  [5630] = {.lex_state = 75},
  [5631] = {.lex_state = 75},
  [5632] = {.lex_state = 75},
  [5633] = {.lex_state = 75},
  [5634] = {.lex_state = 0},
  [5635] = {.lex_state = 0},
  [5636] = {.lex_state = 75},
  [5637] = {.lex_state = 0},
  [5638] = {.lex_state = 0},
  [5639] = {.lex_state = 75},
  [5640] = {.lex_state = 0},
  [5641] = {.lex_state = 75},
  [5642] = {.lex_state = 75},
  [5643] = {.lex_state = 75},
  [5644] = {.lex_state = 75},
  [5645] = {.lex_state = 0},
  [5646] = {.lex_state = 0},
  [5647] = {.lex_state = 75},
  [5648] = {.lex_state = 75},
  [5649] = {.lex_state = 75},
  [5650] = {.lex_state = 75},
  [5651] = {.lex_state = 0},
  [5652] = {.lex_state = 0},
  [5653] = {.lex_state = 75},
  [5654] = {.lex_state = 0},
  [5655] = {.lex_state = 0},
  [5656] = {.lex_state = 75},
  [5657] = {.lex_state = 75},
  [5658] = {.lex_state = 0},
  [5659] = {.lex_state = 75},
  [5660] = {.lex_state = 0},
  [5661] = {.lex_state = 75},
  [5662] = {.lex_state = 75},
  [5663] = {.lex_state = 0},
  [5664] = {.lex_state = 75},
  [5665] = {.lex_state = 75},
  [5666] = {.lex_state = 0},
  [5667] = {.lex_state = 0},
  [5668] = {.lex_state = 75},
  [5669] = {.lex_state = 0},
  [5670] = {.lex_state = 75},
  [5671] = {.lex_state = 75},
  [5672] = {.lex_state = 0},
  [5673] = {.lex_state = 75},
  [5674] = {.lex_state = 0},
  [5675] = {.lex_state = 75},
  [5676] = {.lex_state = 0},
  [5677] = {.lex_state = 75},
  [5678] = {.lex_state = 75},
  [5679] = {.lex_state = 0},
  [5680] = {.lex_state = 75},
  [5681] = {.lex_state = 75},
  [5682] = {.lex_state = 75},
  [5683] = {.lex_state = 75},
  [5684] = {.lex_state = 75},
  [5685] = {.lex_state = 75},
  [5686] = {.lex_state = 75},
  [5687] = {.lex_state = 0, .external_lex_state = 5},
  [5688] = {.lex_state = 75},
  [5689] = {.lex_state = 0},
  [5690] = {.lex_state = 75},
  [5691] = {.lex_state = 75},
  [5692] = {.lex_state = 0, .external_lex_state = 5},
  [5693] = {.lex_state = 0},
  [5694] = {.lex_state = 0},
  [5695] = {.lex_state = 75},
  [5696] = {.lex_state = 75},
  [5697] = {.lex_state = 75},
  [5698] = {.lex_state = 0},
  [5699] = {.lex_state = 0},
  [5700] = {.lex_state = 75},
  [5701] = {.lex_state = 75},
  [5702] = {.lex_state = 75},
  [5703] = {.lex_state = 0},
  [5704] = {.lex_state = 75},
  [5705] = {.lex_state = 0},
  [5706] = {.lex_state = 0},
  [5707] = {.lex_state = 0},
  [5708] = {.lex_state = 0},
  [5709] = {.lex_state = 0},
  [5710] = {.lex_state = 0},
  [5711] = {.lex_state = 75},
  [5712] = {.lex_state = 75},
  [5713] = {.lex_state = 0},
  [5714] = {.lex_state = 75},
  [5715] = {.lex_state = 75},
  [5716] = {.lex_state = 75},
  [5717] = {.lex_state = 75},
  [5718] = {.lex_state = 75},
  [5719] = {.lex_state = 75},
  [5720] = {.lex_state = 0},
  [5721] = {.lex_state = 0},
  [5722] = {.lex_state = 75},
  [5723] = {.lex_state = 0},
  [5724] = {.lex_state = 75},
  [5725] = {.lex_state = 0},
  [5726] = {.lex_state = 0},
  [5727] = {.lex_state = 0},
  [5728] = {.lex_state = 0},
  [5729] = {.lex_state = 0},
  [5730] = {.lex_state = 0},
  [5731] = {.lex_state = 0},
  [5732] = {.lex_state = 0},
  [5733] = {.lex_state = 0},
  [5734] = {.lex_state = 0},
  [5735] = {.lex_state = 0},
  [5736] = {.lex_state = 0},
  [5737] = {.lex_state = 0},
  [5738] = {.lex_state = 75},
  [5739] = {.lex_state = 0},
  [5740] = {.lex_state = 75},
  [5741] = {.lex_state = 0},
  [5742] = {.lex_state = 75},
  [5743] = {.lex_state = 75},
  [5744] = {.lex_state = 75},
  [5745] = {.lex_state = 75},
  [5746] = {.lex_state = 0},
  [5747] = {.lex_state = 75},
  [5748] = {.lex_state = 75},
  [5749] = {.lex_state = 0},
  [5750] = {.lex_state = 1},
  [5751] = {.lex_state = 0},
  [5752] = {.lex_state = 0},
  [5753] = {.lex_state = 0},
  [5754] = {.lex_state = 0},
  [5755] = {.lex_state = 75},
  [5756] = {.lex_state = 0},
  [5757] = {.lex_state = 75},
  [5758] = {.lex_state = 0},
  [5759] = {.lex_state = 75},
  [5760] = {.lex_state = 0},
  [5761] = {.lex_state = 0},
  [5762] = {.lex_state = 75},
  [5763] = {.lex_state = 0},
  [5764] = {.lex_state = 0},
  [5765] = {.lex_state = 0},
  [5766] = {.lex_state = 1},
  [5767] = {.lex_state = 0},
  [5768] = {.lex_state = 0},
  [5769] = {.lex_state = 0},
  [5770] = {.lex_state = 0},
  [5771] = {.lex_state = 0},
  [5772] = {.lex_state = 0},
  [5773] = {.lex_state = 0},
  [5774] = {.lex_state = 0},
  [5775] = {.lex_state = 0},
  [5776] = {.lex_state = 75},
  [5777] = {.lex_state = 0},
  [5778] = {.lex_state = 0},
  [5779] = {.lex_state = 0},
  [5780] = {.lex_state = 0},
  [5781] = {.lex_state = 0},
  [5782] = {.lex_state = 0},
  [5783] = {.lex_state = 75},
  [5784] = {.lex_state = 75},
  [5785] = {.lex_state = 0},
  [5786] = {.lex_state = 0},
  [5787] = {.lex_state = 75},
  [5788] = {.lex_state = 0},
  [5789] = {.lex_state = 0},
  [5790] = {.lex_state = 0},
  [5791] = {.lex_state = 0},
  [5792] = {.lex_state = 0},
  [5793] = {.lex_state = 0},
  [5794] = {.lex_state = 0},
  [5795] = {.lex_state = 0},
  [5796] = {.lex_state = 0},
  [5797] = {.lex_state = 0},
  [5798] = {.lex_state = 75},
  [5799] = {.lex_state = 75},
  [5800] = {.lex_state = 11},
  [5801] = {.lex_state = 0},
  [5802] = {.lex_state = 0},
  [5803] = {.lex_state = 0},
  [5804] = {.lex_state = 75},
  [5805] = {.lex_state = 0},
  [5806] = {.lex_state = 0},
  [5807] = {.lex_state = 75},
  [5808] = {.lex_state = 75},
  [5809] = {.lex_state = 75},
  [5810] = {.lex_state = 75},
  [5811] = {.lex_state = 75},
  [5812] = {.lex_state = 0},
  [5813] = {.lex_state = 0},
  [5814] = {.lex_state = 0},
  [5815] = {.lex_state = 75},
  [5816] = {.lex_state = 0},
  [5817] = {.lex_state = 75},
  [5818] = {.lex_state = 75},
  [5819] = {.lex_state = 0},
  [5820] = {.lex_state = 75},
  [5821] = {.lex_state = 75},
  [5822] = {.lex_state = 0},
  [5823] = {.lex_state = 0},
  [5824] = {.lex_state = 0},
  [5825] = {.lex_state = 0},
  [5826] = {.lex_state = 1},
  [5827] = {.lex_state = 0},
  [5828] = {.lex_state = 0},
  [5829] = {.lex_state = 0},
  [5830] = {.lex_state = 75},
  [5831] = {.lex_state = 0},
  [5832] = {.lex_state = 75},
  [5833] = {.lex_state = 0},
  [5834] = {.lex_state = 75},
  [5835] = {.lex_state = 0},
  [5836] = {.lex_state = 0},
  [5837] = {.lex_state = 11},
  [5838] = {.lex_state = 0},
  [5839] = {.lex_state = 0},
  [5840] = {.lex_state = 0},
  [5841] = {.lex_state = 0},
  [5842] = {.lex_state = 0},
  [5843] = {.lex_state = 75},
  [5844] = {.lex_state = 0},
  [5845] = {.lex_state = 75},
  [5846] = {.lex_state = 75},
  [5847] = {.lex_state = 0},
  [5848] = {.lex_state = 0},
  [5849] = {.lex_state = 75},
  [5850] = {.lex_state = 0},
  [5851] = {.lex_state = 0},
  [5852] = {.lex_state = 75},
  [5853] = {.lex_state = 0},
  [5854] = {.lex_state = 0},
  [5855] = {.lex_state = 0},
  [5856] = {.lex_state = 75},
  [5857] = {.lex_state = 0},
  [5858] = {.lex_state = 0},
  [5859] = {.lex_state = 0},
  [5860] = {.lex_state = 75},
  [5861] = {.lex_state = 75},
  [5862] = {.lex_state = 0},
  [5863] = {.lex_state = 0},
  [5864] = {.lex_state = 75},
  [5865] = {.lex_state = 0},
  [5866] = {.lex_state = 0},
  [5867] = {.lex_state = 75},
  [5868] = {.lex_state = 75},
  [5869] = {.lex_state = 75},
  [5870] = {.lex_state = 0},
  [5871] = {.lex_state = 0},
  [5872] = {.lex_state = 0},
  [5873] = {.lex_state = 0},
  [5874] = {.lex_state = 0},
  [5875] = {.lex_state = 75},
  [5876] = {.lex_state = 0},
  [5877] = {.lex_state = 0},
  [5878] = {.lex_state = 0},
  [5879] = {.lex_state = 75},
  [5880] = {.lex_state = 75},
  [5881] = {.lex_state = 0},
  [5882] = {.lex_state = 0},
  [5883] = {.lex_state = 0},
  [5884] = {.lex_state = 0},
  [5885] = {.lex_state = 0},
  [5886] = {.lex_state = 0},
  [5887] = {.lex_state = 0},
  [5888] = {.lex_state = 0},
  [5889] = {.lex_state = 0},
  [5890] = {.lex_state = 0},
  [5891] = {.lex_state = 0},
  [5892] = {.lex_state = 75},
  [5893] = {.lex_state = 0},
  [5894] = {.lex_state = 75},
  [5895] = {.lex_state = 1},
  [5896] = {.lex_state = 0},
  [5897] = {.lex_state = 0},
  [5898] = {.lex_state = 0},
  [5899] = {.lex_state = 0},
  [5900] = {.lex_state = 0},
  [5901] = {.lex_state = 75},
  [5902] = {.lex_state = 0},
  [5903] = {.lex_state = 0},
  [5904] = {.lex_state = 0},
  [5905] = {.lex_state = 0},
  [5906] = {.lex_state = 75},
  [5907] = {.lex_state = 75},
  [5908] = {.lex_state = 75},
  [5909] = {.lex_state = 0},
  [5910] = {.lex_state = 0},
  [5911] = {.lex_state = 75},
  [5912] = {.lex_state = 0},
  [5913] = {.lex_state = 0},
  [5914] = {.lex_state = 75},
  [5915] = {.lex_state = 0},
  [5916] = {.lex_state = 0},
  [5917] = {.lex_state = 0},
  [5918] = {.lex_state = 75},
  [5919] = {.lex_state = 75},
  [5920] = {.lex_state = 1},
  [5921] = {.lex_state = 0},
  [5922] = {.lex_state = 0},
  [5923] = {.lex_state = 75},
  [5924] = {.lex_state = 75},
  [5925] = {.lex_state = 0},
  [5926] = {.lex_state = 0},
  [5927] = {.lex_state = 11},
  [5928] = {.lex_state = 0},
  [5929] = {.lex_state = 75},
  [5930] = {.lex_state = 0},
  [5931] = {.lex_state = 0},
  [5932] = {.lex_state = 1},
  [5933] = {.lex_state = 75},
  [5934] = {.lex_state = 0},
  [5935] = {.lex_state = 75},
  [5936] = {.lex_state = 75},
  [5937] = {.lex_state = 0},
  [5938] = {.lex_state = 75},
  [5939] = {.lex_state = 0},
  [5940] = {.lex_state = 0},
  [5941] = {.lex_state = 75},
  [5942] = {.lex_state = 0},
  [5943] = {.lex_state = 75},
  [5944] = {.lex_state = 0},
  [5945] = {.lex_state = 0},
  [5946] = {.lex_state = 0},
  [5947] = {.lex_state = 75},
  [5948] = {.lex_state = 75},
  [5949] = {.lex_state = 75},
  [5950] = {.lex_state = 0},
  [5951] = {.lex_state = 0},
  [5952] = {.lex_state = 0},
  [5953] = {.lex_state = 0},
  [5954] = {.lex_state = 0},
  [5955] = {.lex_state = 75},
  [5956] = {.lex_state = 11},
  [5957] = {.lex_state = 0},
  [5958] = {.lex_state = 75},
  [5959] = {.lex_state = 0},
  [5960] = {.lex_state = 75},
  [5961] = {.lex_state = 75},
  [5962] = {.lex_state = 75},
  [5963] = {.lex_state = 0},
  [5964] = {.lex_state = 75},
  [5965] = {.lex_state = 75},
  [5966] = {.lex_state = 75},
  [5967] = {.lex_state = 75},
  [5968] = {.lex_state = 0},
  [5969] = {.lex_state = 0},
  [5970] = {.lex_state = 0},
  [5971] = {.lex_state = 0},
  [5972] = {.lex_state = 0},
  [5973] = {.lex_state = 0},
  [5974] = {.lex_state = 0},
  [5975] = {.lex_state = 0},
  [5976] = {.lex_state = 0},
  [5977] = {.lex_state = 0},
  [5978] = {.lex_state = 0},
  [5979] = {.lex_state = 75},
  [5980] = {.lex_state = 0},
  [5981] = {.lex_state = 75},
  [5982] = {.lex_state = 0},
  [5983] = {.lex_state = 0},
  [5984] = {.lex_state = 0},
  [5985] = {.lex_state = 0},
  [5986] = {.lex_state = 0},
  [5987] = {.lex_state = 75},
  [5988] = {.lex_state = 0},
  [5989] = {.lex_state = 0},
  [5990] = {.lex_state = 0},
  [5991] = {.lex_state = 0},
  [5992] = {.lex_state = 0},
  [5993] = {.lex_state = 75},
  [5994] = {.lex_state = 0},
  [5995] = {.lex_state = 0},
  [5996] = {.lex_state = 0},
  [5997] = {.lex_state = 0},
  [5998] = {.lex_state = 75},
  [5999] = {.lex_state = 0},
  [6000] = {.lex_state = 0},
  [6001] = {.lex_state = 75},
  [6002] = {.lex_state = 75},
  [6003] = {.lex_state = 0},
  [6004] = {.lex_state = 75},
  [6005] = {.lex_state = 0},
  [6006] = {.lex_state = 0},
  [6007] = {.lex_state = 0},
  [6008] = {.lex_state = 75},
  [6009] = {.lex_state = 0},
  [6010] = {.lex_state = 0},
  [6011] = {.lex_state = 0},
  [6012] = {.lex_state = 0},
  [6013] = {.lex_state = 0},
  [6014] = {.lex_state = 0},
  [6015] = {.lex_state = 0},
  [6016] = {.lex_state = 0},
  [6017] = {.lex_state = 0},
  [6018] = {.lex_state = 0},
  [6019] = {.lex_state = 0},
  [6020] = {.lex_state = 0},
  [6021] = {.lex_state = 0},
  [6022] = {.lex_state = 0},
  [6023] = {.lex_state = 75},
  [6024] = {.lex_state = 0},
  [6025] = {.lex_state = 0},
  [6026] = {.lex_state = 1},
  [6027] = {.lex_state = 0},
  [6028] = {.lex_state = 0},
  [6029] = {.lex_state = 0},
  [6030] = {.lex_state = 0},
  [6031] = {.lex_state = 0},
  [6032] = {.lex_state = 11},
  [6033] = {.lex_state = 0},
  [6034] = {.lex_state = 0},
  [6035] = {.lex_state = 0},
  [6036] = {.lex_state = 11},
  [6037] = {.lex_state = 0},
  [6038] = {.lex_state = 75},
  [6039] = {.lex_state = 0},
  [6040] = {.lex_state = 0},
  [6041] = {.lex_state = 75},
  [6042] = {.lex_state = 0},
  [6043] = {.lex_state = 0},
  [6044] = {.lex_state = 75},
  [6045] = {.lex_state = 0},
  [6046] = {.lex_state = 75},
  [6047] = {.lex_state = 0},
  [6048] = {.lex_state = 0},
  [6049] = {.lex_state = 0},
  [6050] = {.lex_state = 11},
  [6051] = {.lex_state = 0},
  [6052] = {.lex_state = 0},
  [6053] = {.lex_state = 75},
  [6054] = {.lex_state = 0},
  [6055] = {.lex_state = 75},
  [6056] = {.lex_state = 75},
  [6057] = {.lex_state = 0},
  [6058] = {.lex_state = 0},
  [6059] = {.lex_state = 0},
  [6060] = {.lex_state = 0},
  [6061] = {.lex_state = 11},
  [6062] = {.lex_state = 75},
  [6063] = {.lex_state = 75},
  [6064] = {.lex_state = 75},
  [6065] = {.lex_state = 0},
  [6066] = {.lex_state = 0},
  [6067] = {.lex_state = 75},
  [6068] = {.lex_state = 0},
  [6069] = {.lex_state = 75},
  [6070] = {.lex_state = 0},
  [6071] = {.lex_state = 0},
  [6072] = {.lex_state = 75},
  [6073] = {.lex_state = 0},
  [6074] = {.lex_state = 75},
  [6075] = {.lex_state = 0},
  [6076] = {.lex_state = 75},
  [6077] = {.lex_state = 0},
  [6078] = {.lex_state = 0},
  [6079] = {.lex_state = 75},
  [6080] = {.lex_state = 11},
  [6081] = {.lex_state = 75},
  [6082] = {.lex_state = 0},
  [6083] = {.lex_state = 0},
  [6084] = {.lex_state = 75},
  [6085] = {.lex_state = 0},
  [6086] = {.lex_state = 0},
  [6087] = {.lex_state = 75},
  [6088] = {.lex_state = 0},
  [6089] = {.lex_state = 75},
  [6090] = {.lex_state = 1},
  [6091] = {.lex_state = 0},
  [6092] = {.lex_state = 0},
  [6093] = {.lex_state = 0},
  [6094] = {.lex_state = 75},
  [6095] = {.lex_state = 75},
  [6096] = {.lex_state = 0},
  [6097] = {.lex_state = 0},
  [6098] = {.lex_state = 0},
  [6099] = {.lex_state = 75},
  [6100] = {.lex_state = 75},
  [6101] = {.lex_state = 75},
  [6102] = {.lex_state = 75},
  [6103] = {.lex_state = 75},
  [6104] = {.lex_state = 1},
  [6105] = {.lex_state = 75},
  [6106] = {.lex_state = 0},
  [6107] = {.lex_state = 0},
  [6108] = {.lex_state = 75},
  [6109] = {.lex_state = 0},
  [6110] = {.lex_state = 0},
  [6111] = {.lex_state = 75},
  [6112] = {.lex_state = 0},
  [6113] = {.lex_state = 0},
  [6114] = {.lex_state = 0},
  [6115] = {.lex_state = 0},
  [6116] = {.lex_state = 0},
  [6117] = {.lex_state = 0},
  [6118] = {.lex_state = 75},
  [6119] = {.lex_state = 75},
  [6120] = {.lex_state = 75},
  [6121] = {.lex_state = 75},
  [6122] = {.lex_state = 75},
  [6123] = {.lex_state = 75},
  [6124] = {.lex_state = 0},
  [6125] = {.lex_state = 0},
  [6126] = {.lex_state = 0},
  [6127] = {.lex_state = 75},
  [6128] = {.lex_state = 75},
  [6129] = {.lex_state = 75},
  [6130] = {.lex_state = 0},
  [6131] = {.lex_state = 75},
  [6132] = {.lex_state = 75},
  [6133] = {.lex_state = 0},
  [6134] = {.lex_state = 0},
  [6135] = {.lex_state = 0},
  [6136] = {.lex_state = 0},
  [6137] = {.lex_state = 0},
  [6138] = {.lex_state = 75},
  [6139] = {.lex_state = 0},
};

enum {
  ts_external_token__automatic_semicolon = 0,
  ts_external_token__template_chars = 1,
  ts_external_token_PIPE_PIPE = 2,
  ts_external_token__function_signature_automatic_semicolon = 3,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__automatic_semicolon] = sym__automatic_semicolon,
  [ts_external_token__template_chars] = sym__template_chars,
  [ts_external_token_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [ts_external_token__function_signature_automatic_semicolon] = sym__function_signature_automatic_semicolon,
};

static bool ts_external_scanner_states[8][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__template_chars] = true,
    [ts_external_token_PIPE_PIPE] = true,
    [ts_external_token__function_signature_automatic_semicolon] = true,
  },
  [2] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token_PIPE_PIPE] = true,
  },
  [3] = {
    [ts_external_token_PIPE_PIPE] = true,
  },
  [4] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token_PIPE_PIPE] = true,
    [ts_external_token__function_signature_automatic_semicolon] = true,
  },
  [5] = {
    [ts_external_token__automatic_semicolon] = true,
  },
  [6] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__function_signature_automatic_semicolon] = true,
  },
  [7] = {
    [ts_external_token__template_chars] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_private_property_identifier] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_any] = ACTIONS(1),
    [anon_sym_number] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_symbol] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_require] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_DASH_QMARK_COLON] = ACTIONS(1),
    [anon_sym_asserts] = ACTIONS(1),
    [anon_sym_infer] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_keyof] = ACTIONS(1),
    [anon_sym_LBRACE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_RBRACE] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
    [sym__function_signature_automatic_semicolon] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(5872),
    [sym_export_statement] = STATE(22),
    [sym_declaration] = STATE(22),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_for_in_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_try_statement] = STATE(22),
    [sym_with_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_debugger_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_throw_statement] = STATE(22),
    [sym_empty_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_hash_bang_line] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [2] = {
    [sym_export_statement] = STATE(32),
    [sym_declaration] = STATE(32),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(32),
    [sym_expression_statement] = STATE(32),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(32),
    [sym_if_statement] = STATE(32),
    [sym_switch_statement] = STATE(32),
    [sym_for_statement] = STATE(32),
    [sym_for_in_statement] = STATE(32),
    [sym_while_statement] = STATE(32),
    [sym_do_statement] = STATE(32),
    [sym_try_statement] = STATE(32),
    [sym_with_statement] = STATE(32),
    [sym_break_statement] = STATE(32),
    [sym_continue_statement] = STATE(32),
    [sym_debugger_statement] = STATE(32),
    [sym_return_statement] = STATE(32),
    [sym_throw_statement] = STATE(32),
    [sym_empty_statement] = STATE(32),
    [sym_labeled_statement] = STATE(32),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5877),
    [sym_object_assignment_pattern] = STATE(5148),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5877),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5877),
    [sym_spread_element] = STATE(5284),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(3475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_rest_pattern] = STATE(5148),
    [sym_method_definition] = STATE(5284),
    [sym_pair] = STATE(5284),
    [sym_pair_pattern] = STATE(5148),
    [sym__property_name] = STATE(4362),
    [sym_computed_property_name] = STATE(4362),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_accessibility_modifier] = STATE(3832),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(32),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [aux_sym_object_repeat1] = STATE(5285),
    [aux_sym_object_pattern_repeat1] = STATE(5141),
    [sym_identifier] = ACTIONS(107),
    [anon_sym_export] = ACTIONS(109),
    [anon_sym_STAR] = ACTIONS(111),
    [anon_sym_type] = ACTIONS(113),
    [anon_sym_namespace] = ACTIONS(115),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_RBRACE] = ACTIONS(119),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(123),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(127),
    [sym_private_property_identifier] = ACTIONS(129),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(131),
    [anon_sym_readonly] = ACTIONS(133),
    [anon_sym_get] = ACTIONS(135),
    [anon_sym_set] = ACTIONS(135),
    [anon_sym_declare] = ACTIONS(137),
    [anon_sym_public] = ACTIONS(139),
    [anon_sym_private] = ACTIONS(139),
    [anon_sym_protected] = ACTIONS(139),
    [anon_sym_module] = ACTIONS(141),
    [anon_sym_any] = ACTIONS(143),
    [anon_sym_number] = ACTIONS(143),
    [anon_sym_boolean] = ACTIONS(143),
    [anon_sym_string] = ACTIONS(143),
    [anon_sym_symbol] = ACTIONS(143),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [3] = {
    [sym_export_statement] = STATE(19),
    [sym_declaration] = STATE(19),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(19),
    [sym_expression_statement] = STATE(19),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_switch_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_for_in_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_do_statement] = STATE(19),
    [sym_try_statement] = STATE(19),
    [sym_with_statement] = STATE(19),
    [sym_break_statement] = STATE(19),
    [sym_continue_statement] = STATE(19),
    [sym_debugger_statement] = STATE(19),
    [sym_return_statement] = STATE(19),
    [sym_throw_statement] = STATE(19),
    [sym_empty_statement] = STATE(19),
    [sym_labeled_statement] = STATE(19),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5877),
    [sym_object_assignment_pattern] = STATE(5148),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5877),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5877),
    [sym_spread_element] = STATE(5106),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(3475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_rest_pattern] = STATE(5148),
    [sym_method_definition] = STATE(5106),
    [sym_pair] = STATE(5106),
    [sym_pair_pattern] = STATE(5148),
    [sym__property_name] = STATE(4362),
    [sym_computed_property_name] = STATE(4362),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_accessibility_modifier] = STATE(3832),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [aux_sym_object_repeat1] = STATE(5142),
    [aux_sym_object_pattern_repeat1] = STATE(5141),
    [sym_identifier] = ACTIONS(145),
    [anon_sym_export] = ACTIONS(147),
    [anon_sym_STAR] = ACTIONS(111),
    [anon_sym_type] = ACTIONS(149),
    [anon_sym_namespace] = ACTIONS(151),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_RBRACE] = ACTIONS(153),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(127),
    [sym_private_property_identifier] = ACTIONS(129),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(157),
    [anon_sym_readonly] = ACTIONS(159),
    [anon_sym_get] = ACTIONS(161),
    [anon_sym_set] = ACTIONS(161),
    [anon_sym_declare] = ACTIONS(163),
    [anon_sym_public] = ACTIONS(165),
    [anon_sym_private] = ACTIONS(165),
    [anon_sym_protected] = ACTIONS(165),
    [anon_sym_module] = ACTIONS(167),
    [anon_sym_any] = ACTIONS(169),
    [anon_sym_number] = ACTIONS(169),
    [anon_sym_boolean] = ACTIONS(169),
    [anon_sym_string] = ACTIONS(169),
    [anon_sym_symbol] = ACTIONS(169),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [4] = {
    [sym_export_statement] = STATE(18),
    [sym_declaration] = STATE(18),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(18),
    [sym_expression_statement] = STATE(18),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(18),
    [sym_if_statement] = STATE(18),
    [sym_switch_statement] = STATE(18),
    [sym_for_statement] = STATE(18),
    [sym_for_in_statement] = STATE(18),
    [sym_while_statement] = STATE(18),
    [sym_do_statement] = STATE(18),
    [sym_try_statement] = STATE(18),
    [sym_with_statement] = STATE(18),
    [sym_break_statement] = STATE(18),
    [sym_continue_statement] = STATE(18),
    [sym_debugger_statement] = STATE(18),
    [sym_return_statement] = STATE(18),
    [sym_throw_statement] = STATE(18),
    [sym_empty_statement] = STATE(18),
    [sym_labeled_statement] = STATE(18),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5877),
    [sym_object_assignment_pattern] = STATE(5148),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5877),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5877),
    [sym_spread_element] = STATE(5106),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(3475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_rest_pattern] = STATE(5148),
    [sym_method_definition] = STATE(5106),
    [sym_pair] = STATE(5106),
    [sym_pair_pattern] = STATE(5148),
    [sym__property_name] = STATE(4362),
    [sym_computed_property_name] = STATE(4362),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_accessibility_modifier] = STATE(3832),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [aux_sym_object_repeat1] = STATE(5142),
    [aux_sym_object_pattern_repeat1] = STATE(5141),
    [sym_identifier] = ACTIONS(145),
    [anon_sym_export] = ACTIONS(147),
    [anon_sym_STAR] = ACTIONS(111),
    [anon_sym_type] = ACTIONS(149),
    [anon_sym_namespace] = ACTIONS(151),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_RBRACE] = ACTIONS(171),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(127),
    [sym_private_property_identifier] = ACTIONS(129),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(157),
    [anon_sym_readonly] = ACTIONS(159),
    [anon_sym_get] = ACTIONS(161),
    [anon_sym_set] = ACTIONS(161),
    [anon_sym_declare] = ACTIONS(163),
    [anon_sym_public] = ACTIONS(165),
    [anon_sym_private] = ACTIONS(165),
    [anon_sym_protected] = ACTIONS(165),
    [anon_sym_module] = ACTIONS(167),
    [anon_sym_any] = ACTIONS(169),
    [anon_sym_number] = ACTIONS(169),
    [anon_sym_boolean] = ACTIONS(169),
    [anon_sym_string] = ACTIONS(169),
    [anon_sym_symbol] = ACTIONS(169),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [5] = {
    [sym_export_statement] = STATE(19),
    [sym_declaration] = STATE(19),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(19),
    [sym_expression_statement] = STATE(19),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_switch_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_for_in_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_do_statement] = STATE(19),
    [sym_try_statement] = STATE(19),
    [sym_with_statement] = STATE(19),
    [sym_break_statement] = STATE(19),
    [sym_continue_statement] = STATE(19),
    [sym_debugger_statement] = STATE(19),
    [sym_return_statement] = STATE(19),
    [sym_throw_statement] = STATE(19),
    [sym_empty_statement] = STATE(19),
    [sym_labeled_statement] = STATE(19),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5877),
    [sym_object_assignment_pattern] = STATE(5148),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5877),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5877),
    [sym_spread_element] = STATE(5106),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(3475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_rest_pattern] = STATE(5148),
    [sym_method_definition] = STATE(5106),
    [sym_pair] = STATE(5106),
    [sym_pair_pattern] = STATE(5148),
    [sym__property_name] = STATE(4362),
    [sym_computed_property_name] = STATE(4362),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_accessibility_modifier] = STATE(3832),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [aux_sym_object_repeat1] = STATE(5142),
    [aux_sym_object_pattern_repeat1] = STATE(5141),
    [sym_identifier] = ACTIONS(145),
    [anon_sym_export] = ACTIONS(147),
    [anon_sym_STAR] = ACTIONS(111),
    [anon_sym_type] = ACTIONS(149),
    [anon_sym_namespace] = ACTIONS(151),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_RBRACE] = ACTIONS(173),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(127),
    [sym_private_property_identifier] = ACTIONS(129),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(157),
    [anon_sym_readonly] = ACTIONS(159),
    [anon_sym_get] = ACTIONS(161),
    [anon_sym_set] = ACTIONS(161),
    [anon_sym_declare] = ACTIONS(163),
    [anon_sym_public] = ACTIONS(165),
    [anon_sym_private] = ACTIONS(165),
    [anon_sym_protected] = ACTIONS(165),
    [anon_sym_module] = ACTIONS(167),
    [anon_sym_any] = ACTIONS(169),
    [anon_sym_number] = ACTIONS(169),
    [anon_sym_boolean] = ACTIONS(169),
    [anon_sym_string] = ACTIONS(169),
    [anon_sym_symbol] = ACTIONS(169),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [6] = {
    [sym_export_statement] = STATE(25),
    [sym_declaration] = STATE(25),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(25),
    [sym_expression_statement] = STATE(25),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(25),
    [sym_if_statement] = STATE(25),
    [sym_switch_statement] = STATE(25),
    [sym_for_statement] = STATE(25),
    [sym_for_in_statement] = STATE(25),
    [sym_while_statement] = STATE(25),
    [sym_do_statement] = STATE(25),
    [sym_try_statement] = STATE(25),
    [sym_with_statement] = STATE(25),
    [sym_break_statement] = STATE(25),
    [sym_continue_statement] = STATE(25),
    [sym_debugger_statement] = STATE(25),
    [sym_return_statement] = STATE(25),
    [sym_throw_statement] = STATE(25),
    [sym_empty_statement] = STATE(25),
    [sym_labeled_statement] = STATE(25),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5877),
    [sym_object_assignment_pattern] = STATE(5148),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5877),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5877),
    [sym_spread_element] = STATE(5282),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(3475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_rest_pattern] = STATE(5148),
    [sym_method_definition] = STATE(5282),
    [sym_pair] = STATE(5282),
    [sym_pair_pattern] = STATE(5148),
    [sym__property_name] = STATE(4362),
    [sym_computed_property_name] = STATE(4362),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_accessibility_modifier] = STATE(3832),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(25),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [aux_sym_object_repeat1] = STATE(5272),
    [aux_sym_object_pattern_repeat1] = STATE(5141),
    [sym_identifier] = ACTIONS(175),
    [anon_sym_export] = ACTIONS(177),
    [anon_sym_STAR] = ACTIONS(111),
    [anon_sym_type] = ACTIONS(179),
    [anon_sym_namespace] = ACTIONS(181),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_RBRACE] = ACTIONS(183),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(185),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(127),
    [sym_private_property_identifier] = ACTIONS(129),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(187),
    [anon_sym_readonly] = ACTIONS(189),
    [anon_sym_get] = ACTIONS(191),
    [anon_sym_set] = ACTIONS(191),
    [anon_sym_declare] = ACTIONS(193),
    [anon_sym_public] = ACTIONS(195),
    [anon_sym_private] = ACTIONS(195),
    [anon_sym_protected] = ACTIONS(195),
    [anon_sym_module] = ACTIONS(197),
    [anon_sym_any] = ACTIONS(199),
    [anon_sym_number] = ACTIONS(199),
    [anon_sym_boolean] = ACTIONS(199),
    [anon_sym_string] = ACTIONS(199),
    [anon_sym_symbol] = ACTIONS(199),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [7] = {
    [sym_export_statement] = STATE(25),
    [sym_declaration] = STATE(25),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(25),
    [sym_expression_statement] = STATE(25),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(25),
    [sym_if_statement] = STATE(25),
    [sym_switch_statement] = STATE(25),
    [sym_for_statement] = STATE(25),
    [sym_for_in_statement] = STATE(25),
    [sym_while_statement] = STATE(25),
    [sym_do_statement] = STATE(25),
    [sym_try_statement] = STATE(25),
    [sym_with_statement] = STATE(25),
    [sym_break_statement] = STATE(25),
    [sym_continue_statement] = STATE(25),
    [sym_debugger_statement] = STATE(25),
    [sym_return_statement] = STATE(25),
    [sym_throw_statement] = STATE(25),
    [sym_empty_statement] = STATE(25),
    [sym_labeled_statement] = STATE(25),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5877),
    [sym_object_assignment_pattern] = STATE(5148),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5877),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5877),
    [sym_spread_element] = STATE(5282),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(3475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_rest_pattern] = STATE(5148),
    [sym_method_definition] = STATE(5282),
    [sym_pair] = STATE(5282),
    [sym_pair_pattern] = STATE(5148),
    [sym__property_name] = STATE(4362),
    [sym_computed_property_name] = STATE(4362),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_accessibility_modifier] = STATE(3832),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(25),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [aux_sym_object_repeat1] = STATE(5272),
    [aux_sym_object_pattern_repeat1] = STATE(5141),
    [sym_identifier] = ACTIONS(201),
    [anon_sym_export] = ACTIONS(203),
    [anon_sym_STAR] = ACTIONS(111),
    [anon_sym_type] = ACTIONS(205),
    [anon_sym_namespace] = ACTIONS(207),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_RBRACE] = ACTIONS(183),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(209),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(127),
    [sym_private_property_identifier] = ACTIONS(129),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(213),
    [anon_sym_get] = ACTIONS(215),
    [anon_sym_set] = ACTIONS(215),
    [anon_sym_declare] = ACTIONS(217),
    [anon_sym_public] = ACTIONS(219),
    [anon_sym_private] = ACTIONS(219),
    [anon_sym_protected] = ACTIONS(219),
    [anon_sym_module] = ACTIONS(221),
    [anon_sym_any] = ACTIONS(223),
    [anon_sym_number] = ACTIONS(223),
    [anon_sym_boolean] = ACTIONS(223),
    [anon_sym_string] = ACTIONS(223),
    [anon_sym_symbol] = ACTIONS(223),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [8] = {
    [sym_export_statement] = STATE(25),
    [sym_declaration] = STATE(25),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(25),
    [sym_expression_statement] = STATE(25),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(25),
    [sym_if_statement] = STATE(25),
    [sym_switch_statement] = STATE(25),
    [sym_for_statement] = STATE(25),
    [sym_for_in_statement] = STATE(25),
    [sym_while_statement] = STATE(25),
    [sym_do_statement] = STATE(25),
    [sym_try_statement] = STATE(25),
    [sym_with_statement] = STATE(25),
    [sym_break_statement] = STATE(25),
    [sym_continue_statement] = STATE(25),
    [sym_debugger_statement] = STATE(25),
    [sym_return_statement] = STATE(25),
    [sym_throw_statement] = STATE(25),
    [sym_empty_statement] = STATE(25),
    [sym_labeled_statement] = STATE(25),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5877),
    [sym_object_assignment_pattern] = STATE(5148),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5877),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5877),
    [sym_spread_element] = STATE(5282),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(3475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_rest_pattern] = STATE(5148),
    [sym_method_definition] = STATE(5282),
    [sym_pair] = STATE(5282),
    [sym_pair_pattern] = STATE(5148),
    [sym__property_name] = STATE(4362),
    [sym_computed_property_name] = STATE(4362),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_accessibility_modifier] = STATE(3832),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(25),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [aux_sym_object_repeat1] = STATE(5272),
    [aux_sym_object_pattern_repeat1] = STATE(5141),
    [sym_identifier] = ACTIONS(225),
    [anon_sym_export] = ACTIONS(227),
    [anon_sym_STAR] = ACTIONS(111),
    [anon_sym_type] = ACTIONS(229),
    [anon_sym_namespace] = ACTIONS(231),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_RBRACE] = ACTIONS(233),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(235),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(127),
    [sym_private_property_identifier] = ACTIONS(129),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(237),
    [anon_sym_readonly] = ACTIONS(239),
    [anon_sym_get] = ACTIONS(241),
    [anon_sym_set] = ACTIONS(241),
    [anon_sym_declare] = ACTIONS(243),
    [anon_sym_public] = ACTIONS(245),
    [anon_sym_private] = ACTIONS(245),
    [anon_sym_protected] = ACTIONS(245),
    [anon_sym_module] = ACTIONS(247),
    [anon_sym_any] = ACTIONS(249),
    [anon_sym_number] = ACTIONS(249),
    [anon_sym_boolean] = ACTIONS(249),
    [anon_sym_string] = ACTIONS(249),
    [anon_sym_symbol] = ACTIONS(249),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [9] = {
    [sym_export_statement] = STATE(18),
    [sym_declaration] = STATE(18),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(18),
    [sym_expression_statement] = STATE(18),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(18),
    [sym_if_statement] = STATE(18),
    [sym_switch_statement] = STATE(18),
    [sym_for_statement] = STATE(18),
    [sym_for_in_statement] = STATE(18),
    [sym_while_statement] = STATE(18),
    [sym_do_statement] = STATE(18),
    [sym_try_statement] = STATE(18),
    [sym_with_statement] = STATE(18),
    [sym_break_statement] = STATE(18),
    [sym_continue_statement] = STATE(18),
    [sym_debugger_statement] = STATE(18),
    [sym_return_statement] = STATE(18),
    [sym_throw_statement] = STATE(18),
    [sym_empty_statement] = STATE(18),
    [sym_labeled_statement] = STATE(18),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5877),
    [sym_object_assignment_pattern] = STATE(5148),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5877),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5877),
    [sym_spread_element] = STATE(5106),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(3475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_rest_pattern] = STATE(5148),
    [sym_method_definition] = STATE(5106),
    [sym_pair] = STATE(5106),
    [sym_pair_pattern] = STATE(5148),
    [sym__property_name] = STATE(4362),
    [sym_computed_property_name] = STATE(4362),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_accessibility_modifier] = STATE(3832),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [aux_sym_object_repeat1] = STATE(5142),
    [aux_sym_object_pattern_repeat1] = STATE(5141),
    [sym_identifier] = ACTIONS(251),
    [anon_sym_export] = ACTIONS(253),
    [anon_sym_STAR] = ACTIONS(111),
    [anon_sym_type] = ACTIONS(255),
    [anon_sym_namespace] = ACTIONS(257),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_RBRACE] = ACTIONS(259),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(261),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(127),
    [sym_private_property_identifier] = ACTIONS(129),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(263),
    [anon_sym_readonly] = ACTIONS(265),
    [anon_sym_get] = ACTIONS(267),
    [anon_sym_set] = ACTIONS(267),
    [anon_sym_declare] = ACTIONS(269),
    [anon_sym_public] = ACTIONS(271),
    [anon_sym_private] = ACTIONS(271),
    [anon_sym_protected] = ACTIONS(271),
    [anon_sym_module] = ACTIONS(273),
    [anon_sym_any] = ACTIONS(275),
    [anon_sym_number] = ACTIONS(275),
    [anon_sym_boolean] = ACTIONS(275),
    [anon_sym_string] = ACTIONS(275),
    [anon_sym_symbol] = ACTIONS(275),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [10] = {
    [sym_export_statement] = STATE(29),
    [sym_declaration] = STATE(29),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(29),
    [sym_expression_statement] = STATE(29),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(29),
    [sym_if_statement] = STATE(29),
    [sym_switch_statement] = STATE(29),
    [sym_for_statement] = STATE(29),
    [sym_for_in_statement] = STATE(29),
    [sym_while_statement] = STATE(29),
    [sym_do_statement] = STATE(29),
    [sym_try_statement] = STATE(29),
    [sym_with_statement] = STATE(29),
    [sym_break_statement] = STATE(29),
    [sym_continue_statement] = STATE(29),
    [sym_debugger_statement] = STATE(29),
    [sym_return_statement] = STATE(29),
    [sym_throw_statement] = STATE(29),
    [sym_empty_statement] = STATE(29),
    [sym_labeled_statement] = STATE(29),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5877),
    [sym_object_assignment_pattern] = STATE(5148),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5877),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5877),
    [sym_spread_element] = STATE(5108),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(3475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_rest_pattern] = STATE(5148),
    [sym_method_definition] = STATE(5108),
    [sym_pair] = STATE(5108),
    [sym_pair_pattern] = STATE(5148),
    [sym__property_name] = STATE(4362),
    [sym_computed_property_name] = STATE(4362),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_accessibility_modifier] = STATE(3832),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(29),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [aux_sym_object_repeat1] = STATE(5243),
    [aux_sym_object_pattern_repeat1] = STATE(5141),
    [sym_identifier] = ACTIONS(277),
    [anon_sym_export] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(111),
    [anon_sym_type] = ACTIONS(281),
    [anon_sym_namespace] = ACTIONS(283),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_RBRACE] = ACTIONS(285),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(287),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(127),
    [sym_private_property_identifier] = ACTIONS(129),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(289),
    [anon_sym_readonly] = ACTIONS(291),
    [anon_sym_get] = ACTIONS(293),
    [anon_sym_set] = ACTIONS(293),
    [anon_sym_declare] = ACTIONS(295),
    [anon_sym_public] = ACTIONS(297),
    [anon_sym_private] = ACTIONS(297),
    [anon_sym_protected] = ACTIONS(297),
    [anon_sym_module] = ACTIONS(299),
    [anon_sym_any] = ACTIONS(301),
    [anon_sym_number] = ACTIONS(301),
    [anon_sym_boolean] = ACTIONS(301),
    [anon_sym_string] = ACTIONS(301),
    [anon_sym_symbol] = ACTIONS(301),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [11] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [ts_builtin_sym_end] = ACTIONS(303),
    [sym_identifier] = ACTIONS(305),
    [anon_sym_export] = ACTIONS(308),
    [anon_sym_default] = ACTIONS(311),
    [anon_sym_type] = ACTIONS(313),
    [anon_sym_namespace] = ACTIONS(316),
    [anon_sym_LBRACE] = ACTIONS(319),
    [anon_sym_RBRACE] = ACTIONS(303),
    [anon_sym_typeof] = ACTIONS(322),
    [anon_sym_import] = ACTIONS(325),
    [anon_sym_var] = ACTIONS(328),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(334),
    [anon_sym_BANG] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(340),
    [anon_sym_switch] = ACTIONS(343),
    [anon_sym_for] = ACTIONS(346),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_await] = ACTIONS(352),
    [anon_sym_while] = ACTIONS(355),
    [anon_sym_do] = ACTIONS(358),
    [anon_sym_try] = ACTIONS(361),
    [anon_sym_with] = ACTIONS(364),
    [anon_sym_break] = ACTIONS(367),
    [anon_sym_continue] = ACTIONS(370),
    [anon_sym_debugger] = ACTIONS(373),
    [anon_sym_return] = ACTIONS(376),
    [anon_sym_throw] = ACTIONS(379),
    [anon_sym_SEMI] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(311),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(388),
    [anon_sym_LT] = ACTIONS(391),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_class] = ACTIONS(397),
    [anon_sym_async] = ACTIONS(400),
    [anon_sym_function] = ACTIONS(403),
    [anon_sym_new] = ACTIONS(406),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_TILDE] = ACTIONS(337),
    [anon_sym_void] = ACTIONS(322),
    [anon_sym_delete] = ACTIONS(322),
    [anon_sym_PLUS_PLUS] = ACTIONS(412),
    [anon_sym_DASH_DASH] = ACTIONS(412),
    [anon_sym_DQUOTE] = ACTIONS(415),
    [anon_sym_SQUOTE] = ACTIONS(418),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(421),
    [sym_number] = ACTIONS(424),
    [sym_this] = ACTIONS(427),
    [sym_super] = ACTIONS(427),
    [sym_true] = ACTIONS(427),
    [sym_false] = ACTIONS(427),
    [sym_null] = ACTIONS(427),
    [sym_undefined] = ACTIONS(430),
    [anon_sym_AT] = ACTIONS(433),
    [anon_sym_static] = ACTIONS(436),
    [anon_sym_readonly] = ACTIONS(436),
    [anon_sym_get] = ACTIONS(436),
    [anon_sym_set] = ACTIONS(436),
    [anon_sym_declare] = ACTIONS(439),
    [anon_sym_public] = ACTIONS(436),
    [anon_sym_private] = ACTIONS(436),
    [anon_sym_protected] = ACTIONS(436),
    [anon_sym_module] = ACTIONS(442),
    [anon_sym_any] = ACTIONS(436),
    [anon_sym_number] = ACTIONS(436),
    [anon_sym_boolean] = ACTIONS(436),
    [anon_sym_string] = ACTIONS(436),
    [anon_sym_symbol] = ACTIONS(436),
    [anon_sym_abstract] = ACTIONS(445),
    [anon_sym_interface] = ACTIONS(448),
    [anon_sym_enum] = ACTIONS(451),
  },
  [12] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(454),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(456),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(454),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [13] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(458),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(460),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(458),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [14] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(462),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(464),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(462),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [15] = {
    [sym_export_statement] = STATE(14),
    [sym_declaration] = STATE(14),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(14),
    [sym_expression_statement] = STATE(14),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_switch_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_for_in_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_do_statement] = STATE(14),
    [sym_try_statement] = STATE(14),
    [sym_with_statement] = STATE(14),
    [sym_break_statement] = STATE(14),
    [sym_continue_statement] = STATE(14),
    [sym_debugger_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_throw_statement] = STATE(14),
    [sym_empty_statement] = STATE(14),
    [sym_labeled_statement] = STATE(14),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(466),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(468),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(466),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [16] = {
    [sym_export_statement] = STATE(18),
    [sym_declaration] = STATE(18),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(18),
    [sym_expression_statement] = STATE(18),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(18),
    [sym_if_statement] = STATE(18),
    [sym_switch_statement] = STATE(18),
    [sym_for_statement] = STATE(18),
    [sym_for_in_statement] = STATE(18),
    [sym_while_statement] = STATE(18),
    [sym_do_statement] = STATE(18),
    [sym_try_statement] = STATE(18),
    [sym_with_statement] = STATE(18),
    [sym_break_statement] = STATE(18),
    [sym_continue_statement] = STATE(18),
    [sym_debugger_statement] = STATE(18),
    [sym_return_statement] = STATE(18),
    [sym_throw_statement] = STATE(18),
    [sym_empty_statement] = STATE(18),
    [sym_labeled_statement] = STATE(18),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(470),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [17] = {
    [sym_export_statement] = STATE(19),
    [sym_declaration] = STATE(19),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(19),
    [sym_expression_statement] = STATE(19),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_switch_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_for_in_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_do_statement] = STATE(19),
    [sym_try_statement] = STATE(19),
    [sym_with_statement] = STATE(19),
    [sym_break_statement] = STATE(19),
    [sym_continue_statement] = STATE(19),
    [sym_debugger_statement] = STATE(19),
    [sym_return_statement] = STATE(19),
    [sym_throw_statement] = STATE(19),
    [sym_empty_statement] = STATE(19),
    [sym_labeled_statement] = STATE(19),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(472),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [18] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(474),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [19] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(476),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [20] = {
    [sym_export_statement] = STATE(23),
    [sym_declaration] = STATE(23),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(23),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(478),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [21] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [ts_builtin_sym_end] = ACTIONS(480),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [22] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [ts_builtin_sym_end] = ACTIONS(482),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [23] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(484),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [24] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(486),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [25] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(488),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [26] = {
    [sym_export_statement] = STATE(29),
    [sym_declaration] = STATE(29),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(29),
    [sym_expression_statement] = STATE(29),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(29),
    [sym_if_statement] = STATE(29),
    [sym_switch_statement] = STATE(29),
    [sym_for_statement] = STATE(29),
    [sym_for_in_statement] = STATE(29),
    [sym_while_statement] = STATE(29),
    [sym_do_statement] = STATE(29),
    [sym_try_statement] = STATE(29),
    [sym_with_statement] = STATE(29),
    [sym_break_statement] = STATE(29),
    [sym_continue_statement] = STATE(29),
    [sym_debugger_statement] = STATE(29),
    [sym_return_statement] = STATE(29),
    [sym_throw_statement] = STATE(29),
    [sym_empty_statement] = STATE(29),
    [sym_labeled_statement] = STATE(29),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(29),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(490),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [27] = {
    [sym_export_statement] = STATE(25),
    [sym_declaration] = STATE(25),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(25),
    [sym_expression_statement] = STATE(25),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(25),
    [sym_if_statement] = STATE(25),
    [sym_switch_statement] = STATE(25),
    [sym_for_statement] = STATE(25),
    [sym_for_in_statement] = STATE(25),
    [sym_while_statement] = STATE(25),
    [sym_do_statement] = STATE(25),
    [sym_try_statement] = STATE(25),
    [sym_with_statement] = STATE(25),
    [sym_break_statement] = STATE(25),
    [sym_continue_statement] = STATE(25),
    [sym_debugger_statement] = STATE(25),
    [sym_return_statement] = STATE(25),
    [sym_throw_statement] = STATE(25),
    [sym_empty_statement] = STATE(25),
    [sym_labeled_statement] = STATE(25),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(25),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(492),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [28] = {
    [sym_export_statement] = STATE(32),
    [sym_declaration] = STATE(32),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(32),
    [sym_expression_statement] = STATE(32),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(32),
    [sym_if_statement] = STATE(32),
    [sym_switch_statement] = STATE(32),
    [sym_for_statement] = STATE(32),
    [sym_for_in_statement] = STATE(32),
    [sym_while_statement] = STATE(32),
    [sym_do_statement] = STATE(32),
    [sym_try_statement] = STATE(32),
    [sym_with_statement] = STATE(32),
    [sym_break_statement] = STATE(32),
    [sym_continue_statement] = STATE(32),
    [sym_debugger_statement] = STATE(32),
    [sym_return_statement] = STATE(32),
    [sym_throw_statement] = STATE(32),
    [sym_empty_statement] = STATE(32),
    [sym_labeled_statement] = STATE(32),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(32),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(494),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [29] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(496),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [30] = {
    [sym_export_statement] = STATE(21),
    [sym_declaration] = STATE(21),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(21),
    [sym_expression_statement] = STATE(21),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(21),
    [sym_if_statement] = STATE(21),
    [sym_switch_statement] = STATE(21),
    [sym_for_statement] = STATE(21),
    [sym_for_in_statement] = STATE(21),
    [sym_while_statement] = STATE(21),
    [sym_do_statement] = STATE(21),
    [sym_try_statement] = STATE(21),
    [sym_with_statement] = STATE(21),
    [sym_break_statement] = STATE(21),
    [sym_continue_statement] = STATE(21),
    [sym_debugger_statement] = STATE(21),
    [sym_return_statement] = STATE(21),
    [sym_throw_statement] = STATE(21),
    [sym_empty_statement] = STATE(21),
    [sym_labeled_statement] = STATE(21),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(21),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [ts_builtin_sym_end] = ACTIONS(482),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [31] = {
    [sym_export_statement] = STATE(33),
    [sym_declaration] = STATE(33),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(33),
    [sym_expression_statement] = STATE(33),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(33),
    [sym_if_statement] = STATE(33),
    [sym_switch_statement] = STATE(33),
    [sym_for_statement] = STATE(33),
    [sym_for_in_statement] = STATE(33),
    [sym_while_statement] = STATE(33),
    [sym_do_statement] = STATE(33),
    [sym_try_statement] = STATE(33),
    [sym_with_statement] = STATE(33),
    [sym_break_statement] = STATE(33),
    [sym_continue_statement] = STATE(33),
    [sym_debugger_statement] = STATE(33),
    [sym_return_statement] = STATE(33),
    [sym_throw_statement] = STATE(33),
    [sym_empty_statement] = STATE(33),
    [sym_labeled_statement] = STATE(33),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(33),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(498),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [32] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [33] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(502),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [34] = {
    [sym_export_statement] = STATE(24),
    [sym_declaration] = STATE(24),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(24),
    [sym_expression_statement] = STATE(24),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(24),
    [sym_if_statement] = STATE(24),
    [sym_switch_statement] = STATE(24),
    [sym_for_statement] = STATE(24),
    [sym_for_in_statement] = STATE(24),
    [sym_while_statement] = STATE(24),
    [sym_do_statement] = STATE(24),
    [sym_try_statement] = STATE(24),
    [sym_with_statement] = STATE(24),
    [sym_break_statement] = STATE(24),
    [sym_continue_statement] = STATE(24),
    [sym_debugger_statement] = STATE(24),
    [sym_return_statement] = STATE(24),
    [sym_throw_statement] = STATE(24),
    [sym_empty_statement] = STATE(24),
    [sym_labeled_statement] = STATE(24),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_program_repeat1] = STATE(24),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(504),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [35] = {
    [sym_export_statement] = STATE(1138),
    [sym_declaration] = STATE(1138),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1138),
    [sym_expression_statement] = STATE(1138),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1138),
    [sym_if_statement] = STATE(1138),
    [sym_switch_statement] = STATE(1138),
    [sym_for_statement] = STATE(1138),
    [sym_for_in_statement] = STATE(1138),
    [sym_while_statement] = STATE(1138),
    [sym_do_statement] = STATE(1138),
    [sym_try_statement] = STATE(1138),
    [sym_with_statement] = STATE(1138),
    [sym_break_statement] = STATE(1138),
    [sym_continue_statement] = STATE(1138),
    [sym_debugger_statement] = STATE(1138),
    [sym_return_statement] = STATE(1138),
    [sym_throw_statement] = STATE(1138),
    [sym_empty_statement] = STATE(1138),
    [sym_labeled_statement] = STATE(1138),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4466),
    [sym_identifier] = ACTIONS(506),
    [anon_sym_export] = ACTIONS(508),
    [anon_sym_type] = ACTIONS(510),
    [anon_sym_namespace] = ACTIONS(512),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(516),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(518),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(520),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(526),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(530),
    [anon_sym_readonly] = ACTIONS(530),
    [anon_sym_get] = ACTIONS(530),
    [anon_sym_set] = ACTIONS(530),
    [anon_sym_declare] = ACTIONS(532),
    [anon_sym_public] = ACTIONS(530),
    [anon_sym_private] = ACTIONS(530),
    [anon_sym_protected] = ACTIONS(530),
    [anon_sym_module] = ACTIONS(534),
    [anon_sym_any] = ACTIONS(530),
    [anon_sym_number] = ACTIONS(530),
    [anon_sym_boolean] = ACTIONS(530),
    [anon_sym_string] = ACTIONS(530),
    [anon_sym_symbol] = ACTIONS(530),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [36] = {
    [sym_export_statement] = STATE(1110),
    [sym_declaration] = STATE(1109),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1107),
    [sym_expression_statement] = STATE(1106),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1105),
    [sym_if_statement] = STATE(1104),
    [sym_switch_statement] = STATE(1101),
    [sym_for_statement] = STATE(1100),
    [sym_for_in_statement] = STATE(1079),
    [sym_while_statement] = STATE(1099),
    [sym_do_statement] = STATE(1098),
    [sym_try_statement] = STATE(1097),
    [sym_with_statement] = STATE(1095),
    [sym_break_statement] = STATE(1094),
    [sym_continue_statement] = STATE(1093),
    [sym_debugger_statement] = STATE(1092),
    [sym_return_statement] = STATE(1091),
    [sym_throw_statement] = STATE(1088),
    [sym_empty_statement] = STATE(1085),
    [sym_labeled_statement] = STATE(1083),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [37] = {
    [sym_export_statement] = STATE(1131),
    [sym_declaration] = STATE(1131),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1131),
    [sym_expression_statement] = STATE(1131),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1131),
    [sym_if_statement] = STATE(1131),
    [sym_switch_statement] = STATE(1131),
    [sym_for_statement] = STATE(1131),
    [sym_for_in_statement] = STATE(1131),
    [sym_while_statement] = STATE(1131),
    [sym_do_statement] = STATE(1131),
    [sym_try_statement] = STATE(1131),
    [sym_with_statement] = STATE(1131),
    [sym_break_statement] = STATE(1131),
    [sym_continue_statement] = STATE(1131),
    [sym_debugger_statement] = STATE(1131),
    [sym_return_statement] = STATE(1131),
    [sym_throw_statement] = STATE(1131),
    [sym_empty_statement] = STATE(1131),
    [sym_labeled_statement] = STATE(1131),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4439),
    [sym_identifier] = ACTIONS(536),
    [anon_sym_export] = ACTIONS(538),
    [anon_sym_type] = ACTIONS(540),
    [anon_sym_namespace] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(544),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(546),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(548),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(550),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(552),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(554),
    [anon_sym_readonly] = ACTIONS(554),
    [anon_sym_get] = ACTIONS(554),
    [anon_sym_set] = ACTIONS(554),
    [anon_sym_declare] = ACTIONS(556),
    [anon_sym_public] = ACTIONS(554),
    [anon_sym_private] = ACTIONS(554),
    [anon_sym_protected] = ACTIONS(554),
    [anon_sym_module] = ACTIONS(558),
    [anon_sym_any] = ACTIONS(554),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_boolean] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_symbol] = ACTIONS(554),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [38] = {
    [sym_export_statement] = STATE(1189),
    [sym_declaration] = STATE(1189),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1189),
    [sym_expression_statement] = STATE(1189),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1189),
    [sym_if_statement] = STATE(1189),
    [sym_switch_statement] = STATE(1189),
    [sym_for_statement] = STATE(1189),
    [sym_for_in_statement] = STATE(1189),
    [sym_while_statement] = STATE(1189),
    [sym_do_statement] = STATE(1189),
    [sym_try_statement] = STATE(1189),
    [sym_with_statement] = STATE(1189),
    [sym_break_statement] = STATE(1189),
    [sym_continue_statement] = STATE(1189),
    [sym_debugger_statement] = STATE(1189),
    [sym_return_statement] = STATE(1189),
    [sym_throw_statement] = STATE(1189),
    [sym_empty_statement] = STATE(1189),
    [sym_labeled_statement] = STATE(1189),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4439),
    [sym_identifier] = ACTIONS(536),
    [anon_sym_export] = ACTIONS(538),
    [anon_sym_type] = ACTIONS(540),
    [anon_sym_namespace] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(544),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(546),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(548),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(550),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(552),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(554),
    [anon_sym_readonly] = ACTIONS(554),
    [anon_sym_get] = ACTIONS(554),
    [anon_sym_set] = ACTIONS(554),
    [anon_sym_declare] = ACTIONS(556),
    [anon_sym_public] = ACTIONS(554),
    [anon_sym_private] = ACTIONS(554),
    [anon_sym_protected] = ACTIONS(554),
    [anon_sym_module] = ACTIONS(558),
    [anon_sym_any] = ACTIONS(554),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_boolean] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_symbol] = ACTIONS(554),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [39] = {
    [sym_export_statement] = STATE(1125),
    [sym_declaration] = STATE(1125),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1125),
    [sym_expression_statement] = STATE(1125),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1125),
    [sym_if_statement] = STATE(1125),
    [sym_switch_statement] = STATE(1125),
    [sym_for_statement] = STATE(1125),
    [sym_for_in_statement] = STATE(1125),
    [sym_while_statement] = STATE(1125),
    [sym_do_statement] = STATE(1125),
    [sym_try_statement] = STATE(1125),
    [sym_with_statement] = STATE(1125),
    [sym_break_statement] = STATE(1125),
    [sym_continue_statement] = STATE(1125),
    [sym_debugger_statement] = STATE(1125),
    [sym_return_statement] = STATE(1125),
    [sym_throw_statement] = STATE(1125),
    [sym_empty_statement] = STATE(1125),
    [sym_labeled_statement] = STATE(1125),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4439),
    [sym_identifier] = ACTIONS(536),
    [anon_sym_export] = ACTIONS(538),
    [anon_sym_type] = ACTIONS(540),
    [anon_sym_namespace] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(544),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(546),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(548),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(550),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(552),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(554),
    [anon_sym_readonly] = ACTIONS(554),
    [anon_sym_get] = ACTIONS(554),
    [anon_sym_set] = ACTIONS(554),
    [anon_sym_declare] = ACTIONS(556),
    [anon_sym_public] = ACTIONS(554),
    [anon_sym_private] = ACTIONS(554),
    [anon_sym_protected] = ACTIONS(554),
    [anon_sym_module] = ACTIONS(558),
    [anon_sym_any] = ACTIONS(554),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_boolean] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_symbol] = ACTIONS(554),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [40] = {
    [sym_export_statement] = STATE(1110),
    [sym_declaration] = STATE(1109),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1107),
    [sym_expression_statement] = STATE(1106),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1105),
    [sym_if_statement] = STATE(1104),
    [sym_switch_statement] = STATE(1101),
    [sym_for_statement] = STATE(1100),
    [sym_for_in_statement] = STATE(1079),
    [sym_while_statement] = STATE(1099),
    [sym_do_statement] = STATE(1098),
    [sym_try_statement] = STATE(1097),
    [sym_with_statement] = STATE(1095),
    [sym_break_statement] = STATE(1094),
    [sym_continue_statement] = STATE(1093),
    [sym_debugger_statement] = STATE(1092),
    [sym_return_statement] = STATE(1091),
    [sym_throw_statement] = STATE(1088),
    [sym_empty_statement] = STATE(1085),
    [sym_labeled_statement] = STATE(1083),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4439),
    [sym_identifier] = ACTIONS(536),
    [anon_sym_export] = ACTIONS(538),
    [anon_sym_type] = ACTIONS(540),
    [anon_sym_namespace] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(544),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(546),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(548),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(550),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(552),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(554),
    [anon_sym_readonly] = ACTIONS(554),
    [anon_sym_get] = ACTIONS(554),
    [anon_sym_set] = ACTIONS(554),
    [anon_sym_declare] = ACTIONS(556),
    [anon_sym_public] = ACTIONS(554),
    [anon_sym_private] = ACTIONS(554),
    [anon_sym_protected] = ACTIONS(554),
    [anon_sym_module] = ACTIONS(558),
    [anon_sym_any] = ACTIONS(554),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_boolean] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_symbol] = ACTIONS(554),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [41] = {
    [sym_export_statement] = STATE(1138),
    [sym_declaration] = STATE(1138),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1138),
    [sym_expression_statement] = STATE(1138),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1138),
    [sym_if_statement] = STATE(1138),
    [sym_switch_statement] = STATE(1138),
    [sym_for_statement] = STATE(1138),
    [sym_for_in_statement] = STATE(1138),
    [sym_while_statement] = STATE(1138),
    [sym_do_statement] = STATE(1138),
    [sym_try_statement] = STATE(1138),
    [sym_with_statement] = STATE(1138),
    [sym_break_statement] = STATE(1138),
    [sym_continue_statement] = STATE(1138),
    [sym_debugger_statement] = STATE(1138),
    [sym_return_statement] = STATE(1138),
    [sym_throw_statement] = STATE(1138),
    [sym_empty_statement] = STATE(1138),
    [sym_labeled_statement] = STATE(1138),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4439),
    [sym_identifier] = ACTIONS(536),
    [anon_sym_export] = ACTIONS(538),
    [anon_sym_type] = ACTIONS(540),
    [anon_sym_namespace] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(544),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(546),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(548),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(550),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(552),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(554),
    [anon_sym_readonly] = ACTIONS(554),
    [anon_sym_get] = ACTIONS(554),
    [anon_sym_set] = ACTIONS(554),
    [anon_sym_declare] = ACTIONS(556),
    [anon_sym_public] = ACTIONS(554),
    [anon_sym_private] = ACTIONS(554),
    [anon_sym_protected] = ACTIONS(554),
    [anon_sym_module] = ACTIONS(558),
    [anon_sym_any] = ACTIONS(554),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_boolean] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_symbol] = ACTIONS(554),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [42] = {
    [sym_export_statement] = STATE(1117),
    [sym_declaration] = STATE(1117),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1117),
    [sym_expression_statement] = STATE(1117),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1117),
    [sym_if_statement] = STATE(1117),
    [sym_switch_statement] = STATE(1117),
    [sym_for_statement] = STATE(1117),
    [sym_for_in_statement] = STATE(1117),
    [sym_while_statement] = STATE(1117),
    [sym_do_statement] = STATE(1117),
    [sym_try_statement] = STATE(1117),
    [sym_with_statement] = STATE(1117),
    [sym_break_statement] = STATE(1117),
    [sym_continue_statement] = STATE(1117),
    [sym_debugger_statement] = STATE(1117),
    [sym_return_statement] = STATE(1117),
    [sym_throw_statement] = STATE(1117),
    [sym_empty_statement] = STATE(1117),
    [sym_labeled_statement] = STATE(1117),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4439),
    [sym_identifier] = ACTIONS(536),
    [anon_sym_export] = ACTIONS(538),
    [anon_sym_type] = ACTIONS(540),
    [anon_sym_namespace] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(544),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(546),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(548),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(550),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(552),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(554),
    [anon_sym_readonly] = ACTIONS(554),
    [anon_sym_get] = ACTIONS(554),
    [anon_sym_set] = ACTIONS(554),
    [anon_sym_declare] = ACTIONS(556),
    [anon_sym_public] = ACTIONS(554),
    [anon_sym_private] = ACTIONS(554),
    [anon_sym_protected] = ACTIONS(554),
    [anon_sym_module] = ACTIONS(558),
    [anon_sym_any] = ACTIONS(554),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_boolean] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_symbol] = ACTIONS(554),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [43] = {
    [sym_export_statement] = STATE(1084),
    [sym_declaration] = STATE(1087),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1089),
    [sym_expression_statement] = STATE(1090),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1096),
    [sym_if_statement] = STATE(1166),
    [sym_switch_statement] = STATE(1150),
    [sym_for_statement] = STATE(1156),
    [sym_for_in_statement] = STATE(1214),
    [sym_while_statement] = STATE(1167),
    [sym_do_statement] = STATE(1170),
    [sym_try_statement] = STATE(1172),
    [sym_with_statement] = STATE(1174),
    [sym_break_statement] = STATE(1177),
    [sym_continue_statement] = STATE(1178),
    [sym_debugger_statement] = STATE(1179),
    [sym_return_statement] = STATE(1183),
    [sym_throw_statement] = STATE(1184),
    [sym_empty_statement] = STATE(1196),
    [sym_labeled_statement] = STATE(1201),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4439),
    [sym_identifier] = ACTIONS(536),
    [anon_sym_export] = ACTIONS(538),
    [anon_sym_type] = ACTIONS(540),
    [anon_sym_namespace] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(544),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(546),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(548),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(550),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(552),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(554),
    [anon_sym_readonly] = ACTIONS(554),
    [anon_sym_get] = ACTIONS(554),
    [anon_sym_set] = ACTIONS(554),
    [anon_sym_declare] = ACTIONS(556),
    [anon_sym_public] = ACTIONS(554),
    [anon_sym_private] = ACTIONS(554),
    [anon_sym_protected] = ACTIONS(554),
    [anon_sym_module] = ACTIONS(558),
    [anon_sym_any] = ACTIONS(554),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_boolean] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_symbol] = ACTIONS(554),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [44] = {
    [sym_export_statement] = STATE(1164),
    [sym_declaration] = STATE(1164),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1164),
    [sym_expression_statement] = STATE(1164),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1164),
    [sym_if_statement] = STATE(1164),
    [sym_switch_statement] = STATE(1164),
    [sym_for_statement] = STATE(1164),
    [sym_for_in_statement] = STATE(1164),
    [sym_while_statement] = STATE(1164),
    [sym_do_statement] = STATE(1164),
    [sym_try_statement] = STATE(1164),
    [sym_with_statement] = STATE(1164),
    [sym_break_statement] = STATE(1164),
    [sym_continue_statement] = STATE(1164),
    [sym_debugger_statement] = STATE(1164),
    [sym_return_statement] = STATE(1164),
    [sym_throw_statement] = STATE(1164),
    [sym_empty_statement] = STATE(1164),
    [sym_labeled_statement] = STATE(1164),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4439),
    [sym_identifier] = ACTIONS(536),
    [anon_sym_export] = ACTIONS(538),
    [anon_sym_type] = ACTIONS(540),
    [anon_sym_namespace] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(544),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(546),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(548),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(550),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(552),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(554),
    [anon_sym_readonly] = ACTIONS(554),
    [anon_sym_get] = ACTIONS(554),
    [anon_sym_set] = ACTIONS(554),
    [anon_sym_declare] = ACTIONS(556),
    [anon_sym_public] = ACTIONS(554),
    [anon_sym_private] = ACTIONS(554),
    [anon_sym_protected] = ACTIONS(554),
    [anon_sym_module] = ACTIONS(558),
    [anon_sym_any] = ACTIONS(554),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_boolean] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_symbol] = ACTIONS(554),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [45] = {
    [sym_export_statement] = STATE(1164),
    [sym_declaration] = STATE(1164),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1164),
    [sym_expression_statement] = STATE(1164),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1164),
    [sym_if_statement] = STATE(1164),
    [sym_switch_statement] = STATE(1164),
    [sym_for_statement] = STATE(1164),
    [sym_for_in_statement] = STATE(1164),
    [sym_while_statement] = STATE(1164),
    [sym_do_statement] = STATE(1164),
    [sym_try_statement] = STATE(1164),
    [sym_with_statement] = STATE(1164),
    [sym_break_statement] = STATE(1164),
    [sym_continue_statement] = STATE(1164),
    [sym_debugger_statement] = STATE(1164),
    [sym_return_statement] = STATE(1164),
    [sym_throw_statement] = STATE(1164),
    [sym_empty_statement] = STATE(1164),
    [sym_labeled_statement] = STATE(1164),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4466),
    [sym_identifier] = ACTIONS(506),
    [anon_sym_export] = ACTIONS(508),
    [anon_sym_type] = ACTIONS(510),
    [anon_sym_namespace] = ACTIONS(512),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(516),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(518),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(520),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(526),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(530),
    [anon_sym_readonly] = ACTIONS(530),
    [anon_sym_get] = ACTIONS(530),
    [anon_sym_set] = ACTIONS(530),
    [anon_sym_declare] = ACTIONS(532),
    [anon_sym_public] = ACTIONS(530),
    [anon_sym_private] = ACTIONS(530),
    [anon_sym_protected] = ACTIONS(530),
    [anon_sym_module] = ACTIONS(534),
    [anon_sym_any] = ACTIONS(530),
    [anon_sym_number] = ACTIONS(530),
    [anon_sym_boolean] = ACTIONS(530),
    [anon_sym_string] = ACTIONS(530),
    [anon_sym_symbol] = ACTIONS(530),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [46] = {
    [sym_export_statement] = STATE(1084),
    [sym_declaration] = STATE(1087),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1089),
    [sym_expression_statement] = STATE(1090),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1096),
    [sym_if_statement] = STATE(1166),
    [sym_switch_statement] = STATE(1150),
    [sym_for_statement] = STATE(1156),
    [sym_for_in_statement] = STATE(1214),
    [sym_while_statement] = STATE(1167),
    [sym_do_statement] = STATE(1170),
    [sym_try_statement] = STATE(1172),
    [sym_with_statement] = STATE(1174),
    [sym_break_statement] = STATE(1177),
    [sym_continue_statement] = STATE(1178),
    [sym_debugger_statement] = STATE(1179),
    [sym_return_statement] = STATE(1183),
    [sym_throw_statement] = STATE(1184),
    [sym_empty_statement] = STATE(1196),
    [sym_labeled_statement] = STATE(1201),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4466),
    [sym_identifier] = ACTIONS(506),
    [anon_sym_export] = ACTIONS(508),
    [anon_sym_type] = ACTIONS(510),
    [anon_sym_namespace] = ACTIONS(512),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(516),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(518),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(520),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(526),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(530),
    [anon_sym_readonly] = ACTIONS(530),
    [anon_sym_get] = ACTIONS(530),
    [anon_sym_set] = ACTIONS(530),
    [anon_sym_declare] = ACTIONS(532),
    [anon_sym_public] = ACTIONS(530),
    [anon_sym_private] = ACTIONS(530),
    [anon_sym_protected] = ACTIONS(530),
    [anon_sym_module] = ACTIONS(534),
    [anon_sym_any] = ACTIONS(530),
    [anon_sym_number] = ACTIONS(530),
    [anon_sym_boolean] = ACTIONS(530),
    [anon_sym_string] = ACTIONS(530),
    [anon_sym_symbol] = ACTIONS(530),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [47] = {
    [sym_export_statement] = STATE(1084),
    [sym_declaration] = STATE(1087),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1089),
    [sym_expression_statement] = STATE(1090),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1096),
    [sym_if_statement] = STATE(1166),
    [sym_switch_statement] = STATE(1150),
    [sym_for_statement] = STATE(1156),
    [sym_for_in_statement] = STATE(1214),
    [sym_while_statement] = STATE(1167),
    [sym_do_statement] = STATE(1170),
    [sym_try_statement] = STATE(1172),
    [sym_with_statement] = STATE(1174),
    [sym_break_statement] = STATE(1177),
    [sym_continue_statement] = STATE(1178),
    [sym_debugger_statement] = STATE(1179),
    [sym_return_statement] = STATE(1183),
    [sym_throw_statement] = STATE(1184),
    [sym_empty_statement] = STATE(1196),
    [sym_labeled_statement] = STATE(1201),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [48] = {
    [sym_export_statement] = STATE(5333),
    [sym_declaration] = STATE(5333),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(5333),
    [sym_expression_statement] = STATE(5333),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(5333),
    [sym_if_statement] = STATE(5333),
    [sym_switch_statement] = STATE(5333),
    [sym_for_statement] = STATE(5333),
    [sym_for_in_statement] = STATE(5333),
    [sym_while_statement] = STATE(5333),
    [sym_do_statement] = STATE(5333),
    [sym_try_statement] = STATE(5333),
    [sym_with_statement] = STATE(5333),
    [sym_break_statement] = STATE(5333),
    [sym_continue_statement] = STATE(5333),
    [sym_debugger_statement] = STATE(5333),
    [sym_return_statement] = STATE(5333),
    [sym_throw_statement] = STATE(5333),
    [sym_empty_statement] = STATE(5333),
    [sym_labeled_statement] = STATE(5333),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4439),
    [sym_identifier] = ACTIONS(536),
    [anon_sym_export] = ACTIONS(538),
    [anon_sym_type] = ACTIONS(540),
    [anon_sym_namespace] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(544),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(546),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(548),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(550),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(552),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(554),
    [anon_sym_readonly] = ACTIONS(554),
    [anon_sym_get] = ACTIONS(554),
    [anon_sym_set] = ACTIONS(554),
    [anon_sym_declare] = ACTIONS(556),
    [anon_sym_public] = ACTIONS(554),
    [anon_sym_private] = ACTIONS(554),
    [anon_sym_protected] = ACTIONS(554),
    [anon_sym_module] = ACTIONS(558),
    [anon_sym_any] = ACTIONS(554),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_boolean] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_symbol] = ACTIONS(554),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [49] = {
    [sym_export_statement] = STATE(1189),
    [sym_declaration] = STATE(1189),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1189),
    [sym_expression_statement] = STATE(1189),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1189),
    [sym_if_statement] = STATE(1189),
    [sym_switch_statement] = STATE(1189),
    [sym_for_statement] = STATE(1189),
    [sym_for_in_statement] = STATE(1189),
    [sym_while_statement] = STATE(1189),
    [sym_do_statement] = STATE(1189),
    [sym_try_statement] = STATE(1189),
    [sym_with_statement] = STATE(1189),
    [sym_break_statement] = STATE(1189),
    [sym_continue_statement] = STATE(1189),
    [sym_debugger_statement] = STATE(1189),
    [sym_return_statement] = STATE(1189),
    [sym_throw_statement] = STATE(1189),
    [sym_empty_statement] = STATE(1189),
    [sym_labeled_statement] = STATE(1189),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [50] = {
    [sym_export_statement] = STATE(1138),
    [sym_declaration] = STATE(1138),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1138),
    [sym_expression_statement] = STATE(1138),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1138),
    [sym_if_statement] = STATE(1138),
    [sym_switch_statement] = STATE(1138),
    [sym_for_statement] = STATE(1138),
    [sym_for_in_statement] = STATE(1138),
    [sym_while_statement] = STATE(1138),
    [sym_do_statement] = STATE(1138),
    [sym_try_statement] = STATE(1138),
    [sym_with_statement] = STATE(1138),
    [sym_break_statement] = STATE(1138),
    [sym_continue_statement] = STATE(1138),
    [sym_debugger_statement] = STATE(1138),
    [sym_return_statement] = STATE(1138),
    [sym_throw_statement] = STATE(1138),
    [sym_empty_statement] = STATE(1138),
    [sym_labeled_statement] = STATE(1138),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [51] = {
    [sym_export_statement] = STATE(1110),
    [sym_declaration] = STATE(1109),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1107),
    [sym_expression_statement] = STATE(1106),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1105),
    [sym_if_statement] = STATE(1104),
    [sym_switch_statement] = STATE(1101),
    [sym_for_statement] = STATE(1100),
    [sym_for_in_statement] = STATE(1079),
    [sym_while_statement] = STATE(1099),
    [sym_do_statement] = STATE(1098),
    [sym_try_statement] = STATE(1097),
    [sym_with_statement] = STATE(1095),
    [sym_break_statement] = STATE(1094),
    [sym_continue_statement] = STATE(1093),
    [sym_debugger_statement] = STATE(1092),
    [sym_return_statement] = STATE(1091),
    [sym_throw_statement] = STATE(1088),
    [sym_empty_statement] = STATE(1085),
    [sym_labeled_statement] = STATE(1083),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4466),
    [sym_identifier] = ACTIONS(506),
    [anon_sym_export] = ACTIONS(508),
    [anon_sym_type] = ACTIONS(510),
    [anon_sym_namespace] = ACTIONS(512),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(516),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(518),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(520),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(526),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(530),
    [anon_sym_readonly] = ACTIONS(530),
    [anon_sym_get] = ACTIONS(530),
    [anon_sym_set] = ACTIONS(530),
    [anon_sym_declare] = ACTIONS(532),
    [anon_sym_public] = ACTIONS(530),
    [anon_sym_private] = ACTIONS(530),
    [anon_sym_protected] = ACTIONS(530),
    [anon_sym_module] = ACTIONS(534),
    [anon_sym_any] = ACTIONS(530),
    [anon_sym_number] = ACTIONS(530),
    [anon_sym_boolean] = ACTIONS(530),
    [anon_sym_string] = ACTIONS(530),
    [anon_sym_symbol] = ACTIONS(530),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [52] = {
    [sym_export_statement] = STATE(1164),
    [sym_declaration] = STATE(1164),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1164),
    [sym_expression_statement] = STATE(1164),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1164),
    [sym_if_statement] = STATE(1164),
    [sym_switch_statement] = STATE(1164),
    [sym_for_statement] = STATE(1164),
    [sym_for_in_statement] = STATE(1164),
    [sym_while_statement] = STATE(1164),
    [sym_do_statement] = STATE(1164),
    [sym_try_statement] = STATE(1164),
    [sym_with_statement] = STATE(1164),
    [sym_break_statement] = STATE(1164),
    [sym_continue_statement] = STATE(1164),
    [sym_debugger_statement] = STATE(1164),
    [sym_return_statement] = STATE(1164),
    [sym_throw_statement] = STATE(1164),
    [sym_empty_statement] = STATE(1164),
    [sym_labeled_statement] = STATE(1164),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [53] = {
    [sym_export_statement] = STATE(1117),
    [sym_declaration] = STATE(1117),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1117),
    [sym_expression_statement] = STATE(1117),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1117),
    [sym_if_statement] = STATE(1117),
    [sym_switch_statement] = STATE(1117),
    [sym_for_statement] = STATE(1117),
    [sym_for_in_statement] = STATE(1117),
    [sym_while_statement] = STATE(1117),
    [sym_do_statement] = STATE(1117),
    [sym_try_statement] = STATE(1117),
    [sym_with_statement] = STATE(1117),
    [sym_break_statement] = STATE(1117),
    [sym_continue_statement] = STATE(1117),
    [sym_debugger_statement] = STATE(1117),
    [sym_return_statement] = STATE(1117),
    [sym_throw_statement] = STATE(1117),
    [sym_empty_statement] = STATE(1117),
    [sym_labeled_statement] = STATE(1117),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [54] = {
    [sym_export_statement] = STATE(1125),
    [sym_declaration] = STATE(1125),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1125),
    [sym_expression_statement] = STATE(1125),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1125),
    [sym_if_statement] = STATE(1125),
    [sym_switch_statement] = STATE(1125),
    [sym_for_statement] = STATE(1125),
    [sym_for_in_statement] = STATE(1125),
    [sym_while_statement] = STATE(1125),
    [sym_do_statement] = STATE(1125),
    [sym_try_statement] = STATE(1125),
    [sym_with_statement] = STATE(1125),
    [sym_break_statement] = STATE(1125),
    [sym_continue_statement] = STATE(1125),
    [sym_debugger_statement] = STATE(1125),
    [sym_return_statement] = STATE(1125),
    [sym_throw_statement] = STATE(1125),
    [sym_empty_statement] = STATE(1125),
    [sym_labeled_statement] = STATE(1125),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4466),
    [sym_identifier] = ACTIONS(506),
    [anon_sym_export] = ACTIONS(508),
    [anon_sym_type] = ACTIONS(510),
    [anon_sym_namespace] = ACTIONS(512),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(516),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(518),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(520),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(526),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(530),
    [anon_sym_readonly] = ACTIONS(530),
    [anon_sym_get] = ACTIONS(530),
    [anon_sym_set] = ACTIONS(530),
    [anon_sym_declare] = ACTIONS(532),
    [anon_sym_public] = ACTIONS(530),
    [anon_sym_private] = ACTIONS(530),
    [anon_sym_protected] = ACTIONS(530),
    [anon_sym_module] = ACTIONS(534),
    [anon_sym_any] = ACTIONS(530),
    [anon_sym_number] = ACTIONS(530),
    [anon_sym_boolean] = ACTIONS(530),
    [anon_sym_string] = ACTIONS(530),
    [anon_sym_symbol] = ACTIONS(530),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [55] = {
    [sym_export_statement] = STATE(5901),
    [sym_declaration] = STATE(5901),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(5901),
    [sym_expression_statement] = STATE(5901),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(5901),
    [sym_if_statement] = STATE(5901),
    [sym_switch_statement] = STATE(5901),
    [sym_for_statement] = STATE(5901),
    [sym_for_in_statement] = STATE(5901),
    [sym_while_statement] = STATE(5901),
    [sym_do_statement] = STATE(5901),
    [sym_try_statement] = STATE(5901),
    [sym_with_statement] = STATE(5901),
    [sym_break_statement] = STATE(5901),
    [sym_continue_statement] = STATE(5901),
    [sym_debugger_statement] = STATE(5901),
    [sym_return_statement] = STATE(5901),
    [sym_throw_statement] = STATE(5901),
    [sym_empty_statement] = STATE(5901),
    [sym_labeled_statement] = STATE(5901),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4466),
    [sym_identifier] = ACTIONS(506),
    [anon_sym_export] = ACTIONS(508),
    [anon_sym_type] = ACTIONS(510),
    [anon_sym_namespace] = ACTIONS(512),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(516),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(518),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(520),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(526),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(530),
    [anon_sym_readonly] = ACTIONS(530),
    [anon_sym_get] = ACTIONS(530),
    [anon_sym_set] = ACTIONS(530),
    [anon_sym_declare] = ACTIONS(532),
    [anon_sym_public] = ACTIONS(530),
    [anon_sym_private] = ACTIONS(530),
    [anon_sym_protected] = ACTIONS(530),
    [anon_sym_module] = ACTIONS(534),
    [anon_sym_any] = ACTIONS(530),
    [anon_sym_number] = ACTIONS(530),
    [anon_sym_boolean] = ACTIONS(530),
    [anon_sym_string] = ACTIONS(530),
    [anon_sym_symbol] = ACTIONS(530),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [56] = {
    [sym_export_statement] = STATE(1189),
    [sym_declaration] = STATE(1189),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1189),
    [sym_expression_statement] = STATE(1189),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1189),
    [sym_if_statement] = STATE(1189),
    [sym_switch_statement] = STATE(1189),
    [sym_for_statement] = STATE(1189),
    [sym_for_in_statement] = STATE(1189),
    [sym_while_statement] = STATE(1189),
    [sym_do_statement] = STATE(1189),
    [sym_try_statement] = STATE(1189),
    [sym_with_statement] = STATE(1189),
    [sym_break_statement] = STATE(1189),
    [sym_continue_statement] = STATE(1189),
    [sym_debugger_statement] = STATE(1189),
    [sym_return_statement] = STATE(1189),
    [sym_throw_statement] = STATE(1189),
    [sym_empty_statement] = STATE(1189),
    [sym_labeled_statement] = STATE(1189),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4466),
    [sym_identifier] = ACTIONS(506),
    [anon_sym_export] = ACTIONS(508),
    [anon_sym_type] = ACTIONS(510),
    [anon_sym_namespace] = ACTIONS(512),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(516),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(518),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(520),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(526),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(530),
    [anon_sym_readonly] = ACTIONS(530),
    [anon_sym_get] = ACTIONS(530),
    [anon_sym_set] = ACTIONS(530),
    [anon_sym_declare] = ACTIONS(532),
    [anon_sym_public] = ACTIONS(530),
    [anon_sym_private] = ACTIONS(530),
    [anon_sym_protected] = ACTIONS(530),
    [anon_sym_module] = ACTIONS(534),
    [anon_sym_any] = ACTIONS(530),
    [anon_sym_number] = ACTIONS(530),
    [anon_sym_boolean] = ACTIONS(530),
    [anon_sym_string] = ACTIONS(530),
    [anon_sym_symbol] = ACTIONS(530),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [57] = {
    [sym_export_statement] = STATE(1131),
    [sym_declaration] = STATE(1131),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1131),
    [sym_expression_statement] = STATE(1131),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1131),
    [sym_if_statement] = STATE(1131),
    [sym_switch_statement] = STATE(1131),
    [sym_for_statement] = STATE(1131),
    [sym_for_in_statement] = STATE(1131),
    [sym_while_statement] = STATE(1131),
    [sym_do_statement] = STATE(1131),
    [sym_try_statement] = STATE(1131),
    [sym_with_statement] = STATE(1131),
    [sym_break_statement] = STATE(1131),
    [sym_continue_statement] = STATE(1131),
    [sym_debugger_statement] = STATE(1131),
    [sym_return_statement] = STATE(1131),
    [sym_throw_statement] = STATE(1131),
    [sym_empty_statement] = STATE(1131),
    [sym_labeled_statement] = STATE(1131),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4466),
    [sym_identifier] = ACTIONS(506),
    [anon_sym_export] = ACTIONS(508),
    [anon_sym_type] = ACTIONS(510),
    [anon_sym_namespace] = ACTIONS(512),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(516),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(518),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(520),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(526),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(530),
    [anon_sym_readonly] = ACTIONS(530),
    [anon_sym_get] = ACTIONS(530),
    [anon_sym_set] = ACTIONS(530),
    [anon_sym_declare] = ACTIONS(532),
    [anon_sym_public] = ACTIONS(530),
    [anon_sym_private] = ACTIONS(530),
    [anon_sym_protected] = ACTIONS(530),
    [anon_sym_module] = ACTIONS(534),
    [anon_sym_any] = ACTIONS(530),
    [anon_sym_number] = ACTIONS(530),
    [anon_sym_boolean] = ACTIONS(530),
    [anon_sym_string] = ACTIONS(530),
    [anon_sym_symbol] = ACTIONS(530),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [58] = {
    [sym_export_statement] = STATE(1058),
    [sym_declaration] = STATE(1058),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1058),
    [sym_expression_statement] = STATE(1058),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1058),
    [sym_if_statement] = STATE(1058),
    [sym_switch_statement] = STATE(1058),
    [sym_for_statement] = STATE(1058),
    [sym_for_in_statement] = STATE(1058),
    [sym_while_statement] = STATE(1058),
    [sym_do_statement] = STATE(1058),
    [sym_try_statement] = STATE(1058),
    [sym_with_statement] = STATE(1058),
    [sym_break_statement] = STATE(1058),
    [sym_continue_statement] = STATE(1058),
    [sym_debugger_statement] = STATE(1058),
    [sym_return_statement] = STATE(1058),
    [sym_throw_statement] = STATE(1058),
    [sym_empty_statement] = STATE(1058),
    [sym_labeled_statement] = STATE(1058),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [59] = {
    [sym_export_statement] = STATE(1131),
    [sym_declaration] = STATE(1131),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1131),
    [sym_expression_statement] = STATE(1131),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1131),
    [sym_if_statement] = STATE(1131),
    [sym_switch_statement] = STATE(1131),
    [sym_for_statement] = STATE(1131),
    [sym_for_in_statement] = STATE(1131),
    [sym_while_statement] = STATE(1131),
    [sym_do_statement] = STATE(1131),
    [sym_try_statement] = STATE(1131),
    [sym_with_statement] = STATE(1131),
    [sym_break_statement] = STATE(1131),
    [sym_continue_statement] = STATE(1131),
    [sym_debugger_statement] = STATE(1131),
    [sym_return_statement] = STATE(1131),
    [sym_throw_statement] = STATE(1131),
    [sym_empty_statement] = STATE(1131),
    [sym_labeled_statement] = STATE(1131),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [60] = {
    [sym_export_statement] = STATE(5305),
    [sym_declaration] = STATE(5305),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(5305),
    [sym_expression_statement] = STATE(5305),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(5305),
    [sym_if_statement] = STATE(5305),
    [sym_switch_statement] = STATE(5305),
    [sym_for_statement] = STATE(5305),
    [sym_for_in_statement] = STATE(5305),
    [sym_while_statement] = STATE(5305),
    [sym_do_statement] = STATE(5305),
    [sym_try_statement] = STATE(5305),
    [sym_with_statement] = STATE(5305),
    [sym_break_statement] = STATE(5305),
    [sym_continue_statement] = STATE(5305),
    [sym_debugger_statement] = STATE(5305),
    [sym_return_statement] = STATE(5305),
    [sym_throw_statement] = STATE(5305),
    [sym_empty_statement] = STATE(5305),
    [sym_labeled_statement] = STATE(5305),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4439),
    [sym_identifier] = ACTIONS(536),
    [anon_sym_export] = ACTIONS(538),
    [anon_sym_type] = ACTIONS(540),
    [anon_sym_namespace] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(544),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(546),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(548),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(550),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(552),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(554),
    [anon_sym_readonly] = ACTIONS(554),
    [anon_sym_get] = ACTIONS(554),
    [anon_sym_set] = ACTIONS(554),
    [anon_sym_declare] = ACTIONS(556),
    [anon_sym_public] = ACTIONS(554),
    [anon_sym_private] = ACTIONS(554),
    [anon_sym_protected] = ACTIONS(554),
    [anon_sym_module] = ACTIONS(558),
    [anon_sym_any] = ACTIONS(554),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_boolean] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_symbol] = ACTIONS(554),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [61] = {
    [sym_export_statement] = STATE(1125),
    [sym_declaration] = STATE(1125),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1125),
    [sym_expression_statement] = STATE(1125),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1125),
    [sym_if_statement] = STATE(1125),
    [sym_switch_statement] = STATE(1125),
    [sym_for_statement] = STATE(1125),
    [sym_for_in_statement] = STATE(1125),
    [sym_while_statement] = STATE(1125),
    [sym_do_statement] = STATE(1125),
    [sym_try_statement] = STATE(1125),
    [sym_with_statement] = STATE(1125),
    [sym_break_statement] = STATE(1125),
    [sym_continue_statement] = STATE(1125),
    [sym_debugger_statement] = STATE(1125),
    [sym_return_statement] = STATE(1125),
    [sym_throw_statement] = STATE(1125),
    [sym_empty_statement] = STATE(1125),
    [sym_labeled_statement] = STATE(1125),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(161),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4545),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [62] = {
    [sym_export_statement] = STATE(1117),
    [sym_declaration] = STATE(1117),
    [sym_import] = STATE(2475),
    [sym_import_statement] = STATE(1117),
    [sym_expression_statement] = STATE(1117),
    [sym_variable_declaration] = STATE(1086),
    [sym_lexical_declaration] = STATE(1086),
    [sym_statement_block] = STATE(1117),
    [sym_if_statement] = STATE(1117),
    [sym_switch_statement] = STATE(1117),
    [sym_for_statement] = STATE(1117),
    [sym_for_in_statement] = STATE(1117),
    [sym_while_statement] = STATE(1117),
    [sym_do_statement] = STATE(1117),
    [sym_try_statement] = STATE(1117),
    [sym_with_statement] = STATE(1117),
    [sym_break_statement] = STATE(1117),
    [sym_continue_statement] = STATE(1117),
    [sym_debugger_statement] = STATE(1117),
    [sym_return_statement] = STATE(1117),
    [sym_throw_statement] = STATE(1117),
    [sym_empty_statement] = STATE(1117),
    [sym_labeled_statement] = STATE(1117),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2798),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_class_declaration] = STATE(1086),
    [sym_function] = STATE(2475),
    [sym_function_declaration] = STATE(1086),
    [sym_generator_function] = STATE(2475),
    [sym_generator_function_declaration] = STATE(1086),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_sequence_expression] = STATE(5402),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(2019),
    [sym_function_signature] = STATE(1086),
    [sym_as_expression] = STATE(2484),
    [sym_ambient_declaration] = STATE(1086),
    [sym_abstract_class_declaration] = STATE(1086),
    [sym_module] = STATE(1086),
    [sym_internal_module] = STATE(3143),
    [sym_import_alias] = STATE(1086),
    [sym_interface_declaration] = STATE(1086),
    [sym_enum_declaration] = STATE(1086),
    [sym_type_alias_declaration] = STATE(1086),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(4466),
    [sym_identifier] = ACTIONS(506),
    [anon_sym_export] = ACTIONS(508),
    [anon_sym_type] = ACTIONS(510),
    [anon_sym_namespace] = ACTIONS(512),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(516),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(518),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(520),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_async] = ACTIONS(526),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(530),
    [anon_sym_readonly] = ACTIONS(530),
    [anon_sym_get] = ACTIONS(530),
    [anon_sym_set] = ACTIONS(530),
    [anon_sym_declare] = ACTIONS(532),
    [anon_sym_public] = ACTIONS(530),
    [anon_sym_private] = ACTIONS(530),
    [anon_sym_protected] = ACTIONS(530),
    [anon_sym_module] = ACTIONS(534),
    [anon_sym_any] = ACTIONS(530),
    [anon_sym_number] = ACTIONS(530),
    [anon_sym_boolean] = ACTIONS(530),
    [anon_sym_string] = ACTIONS(530),
    [anon_sym_symbol] = ACTIONS(530),
    [anon_sym_abstract] = ACTIONS(101),
    [anon_sym_interface] = ACTIONS(103),
    [anon_sym_enum] = ACTIONS(105),
  },
  [63] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(3054),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5125),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5372),
    [sym_optional_tuple_parameter] = STATE(5372),
    [sym_optional_type] = STATE(5372),
    [sym_rest_type] = STATE(5372),
    [sym__tuple_type_member] = STATE(5372),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5127),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(586),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [64] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(2789),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5330),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5372),
    [sym_optional_tuple_parameter] = STATE(5372),
    [sym_optional_type] = STATE(5372),
    [sym_rest_type] = STATE(5372),
    [sym__tuple_type_member] = STATE(5372),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5171),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(642),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [65] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(3002),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5230),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5372),
    [sym_optional_tuple_parameter] = STATE(5372),
    [sym_optional_type] = STATE(5372),
    [sym_rest_type] = STATE(5372),
    [sym__tuple_type_member] = STATE(5372),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5222),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(644),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [66] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(2930),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5291),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5372),
    [sym_optional_tuple_parameter] = STATE(5372),
    [sym_optional_type] = STATE(5372),
    [sym_rest_type] = STATE(5372),
    [sym__tuple_type_member] = STATE(5372),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5292),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [67] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(3002),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5230),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5303),
    [sym_optional_tuple_parameter] = STATE(5303),
    [sym_optional_type] = STATE(5303),
    [sym_rest_type] = STATE(5303),
    [sym__tuple_type_member] = STATE(5303),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5222),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(648),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(650),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [68] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(2789),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5330),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5372),
    [sym_optional_tuple_parameter] = STATE(5372),
    [sym_optional_type] = STATE(5372),
    [sym_rest_type] = STATE(5372),
    [sym__tuple_type_member] = STATE(5372),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5171),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(652),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [69] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(3002),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5230),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5372),
    [sym_optional_tuple_parameter] = STATE(5372),
    [sym_optional_type] = STATE(5372),
    [sym_rest_type] = STATE(5372),
    [sym__tuple_type_member] = STATE(5372),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5222),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(654),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [70] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(3002),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5230),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5372),
    [sym_optional_tuple_parameter] = STATE(5372),
    [sym_optional_type] = STATE(5372),
    [sym_rest_type] = STATE(5372),
    [sym__tuple_type_member] = STATE(5372),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5222),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(656),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [71] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(3002),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5230),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5372),
    [sym_optional_tuple_parameter] = STATE(5372),
    [sym_optional_type] = STATE(5372),
    [sym_rest_type] = STATE(5372),
    [sym__tuple_type_member] = STATE(5372),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5222),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(658),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [72] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(2789),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5330),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5372),
    [sym_optional_tuple_parameter] = STATE(5372),
    [sym_optional_type] = STATE(5372),
    [sym_rest_type] = STATE(5372),
    [sym__tuple_type_member] = STATE(5372),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5171),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(660),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [73] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(3002),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5230),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5372),
    [sym_optional_tuple_parameter] = STATE(5372),
    [sym_optional_type] = STATE(5372),
    [sym_rest_type] = STATE(5372),
    [sym__tuple_type_member] = STATE(5372),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5222),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(662),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [74] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(3002),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5230),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5372),
    [sym_optional_tuple_parameter] = STATE(5372),
    [sym_optional_type] = STATE(5372),
    [sym_rest_type] = STATE(5372),
    [sym__tuple_type_member] = STATE(5372),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5222),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(664),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [75] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(2789),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5330),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5372),
    [sym_optional_tuple_parameter] = STATE(5372),
    [sym_optional_type] = STATE(5372),
    [sym_rest_type] = STATE(5372),
    [sym__tuple_type_member] = STATE(5372),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5171),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(666),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [76] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(3002),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5230),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5372),
    [sym_optional_tuple_parameter] = STATE(5372),
    [sym_optional_type] = STATE(5372),
    [sym_rest_type] = STATE(5372),
    [sym__tuple_type_member] = STATE(5372),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5222),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(668),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [77] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(2789),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5330),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5372),
    [sym_optional_tuple_parameter] = STATE(5372),
    [sym_optional_type] = STATE(5372),
    [sym_rest_type] = STATE(5372),
    [sym__tuple_type_member] = STATE(5372),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5171),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(670),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [78] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(2930),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5291),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5372),
    [sym_optional_tuple_parameter] = STATE(5372),
    [sym_optional_type] = STATE(5372),
    [sym_rest_type] = STATE(5372),
    [sym__tuple_type_member] = STATE(5372),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5292),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(672),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [79] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(3054),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5125),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5372),
    [sym_optional_tuple_parameter] = STATE(5372),
    [sym_optional_type] = STATE(5372),
    [sym_rest_type] = STATE(5372),
    [sym__tuple_type_member] = STATE(5372),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5127),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(674),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [80] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(3002),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_assignment_pattern] = STATE(5326),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_spread_element] = STATE(5230),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3587),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4627),
    [sym_pattern] = STATE(4939),
    [sym_rest_pattern] = STATE(4651),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4583),
    [sym_tuple_parameter] = STATE(5372),
    [sym_optional_tuple_parameter] = STATE(5372),
    [sym_optional_type] = STATE(5372),
    [sym_rest_type] = STATE(5372),
    [sym__tuple_type_member] = STATE(5372),
    [sym_constructor_type] = STATE(4583),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4583),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5518),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4583),
    [sym_union_type] = STATE(4583),
    [sym_intersection_type] = STATE(4583),
    [sym_function_type] = STATE(4583),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [aux_sym_array_repeat1] = STATE(5222),
    [aux_sym_array_pattern_repeat1] = STATE(5234),
    [sym_identifier] = ACTIONS(560),
    [anon_sym_export] = ACTIONS(562),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_namespace] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_RBRACK] = ACTIONS(676),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(594),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(602),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(622),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_readonly] = ACTIONS(632),
    [anon_sym_get] = ACTIONS(562),
    [anon_sym_set] = ACTIONS(562),
    [anon_sym_declare] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(638),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [81] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(2657),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym__formal_parameter] = STATE(5176),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_sequence_expression] = STATE(6024),
    [sym_string] = STATE(3446),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4668),
    [sym_pattern] = STATE(4318),
    [sym_rest_pattern] = STATE(4319),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym_accessibility_modifier] = STATE(3833),
    [sym_required_parameter] = STATE(5176),
    [sym_optional_parameter] = STATE(5176),
    [sym__parameter_name] = STATE(4318),
    [sym__type] = STATE(4914),
    [sym_constructor_type] = STATE(4914),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4914),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5457),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4914),
    [sym_union_type] = STATE(4914),
    [sym_intersection_type] = STATE(4914),
    [sym_function_type] = STATE(4914),
    [aux_sym_export_statement_repeat1] = STATE(3748),
    [sym_identifier] = ACTIONS(678),
    [anon_sym_export] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(680),
    [anon_sym_namespace] = ACTIONS(682),
    [anon_sym_LBRACE] = ACTIONS(684),
    [anon_sym_typeof] = ACTIONS(686),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_RPAREN] = ACTIONS(688),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(692),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(694),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(698),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_PIPE] = ACTIONS(702),
    [anon_sym_PLUS] = ACTIONS(704),
    [anon_sym_DASH] = ACTIONS(704),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(706),
    [sym_this] = ACTIONS(708),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(710),
    [sym_false] = ACTIONS(710),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(680),
    [anon_sym_readonly] = ACTIONS(712),
    [anon_sym_get] = ACTIONS(680),
    [anon_sym_set] = ACTIONS(680),
    [anon_sym_declare] = ACTIONS(680),
    [anon_sym_public] = ACTIONS(714),
    [anon_sym_private] = ACTIONS(714),
    [anon_sym_protected] = ACTIONS(714),
    [anon_sym_module] = ACTIONS(680),
    [anon_sym_any] = ACTIONS(716),
    [anon_sym_number] = ACTIONS(716),
    [anon_sym_boolean] = ACTIONS(716),
    [anon_sym_string] = ACTIONS(716),
    [anon_sym_symbol] = ACTIONS(716),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(718),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [82] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(2655),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym__formal_parameter] = STATE(5176),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_sequence_expression] = STATE(5876),
    [sym_string] = STATE(3446),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4668),
    [sym_pattern] = STATE(4318),
    [sym_rest_pattern] = STATE(4319),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym_accessibility_modifier] = STATE(3833),
    [sym_required_parameter] = STATE(5176),
    [sym_optional_parameter] = STATE(5176),
    [sym__parameter_name] = STATE(4318),
    [sym__type] = STATE(4914),
    [sym_constructor_type] = STATE(4914),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4914),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5457),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4914),
    [sym_union_type] = STATE(4914),
    [sym_intersection_type] = STATE(4914),
    [sym_function_type] = STATE(4914),
    [aux_sym_export_statement_repeat1] = STATE(3748),
    [sym_identifier] = ACTIONS(678),
    [anon_sym_export] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(680),
    [anon_sym_namespace] = ACTIONS(682),
    [anon_sym_LBRACE] = ACTIONS(684),
    [anon_sym_typeof] = ACTIONS(686),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_RPAREN] = ACTIONS(688),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(692),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(694),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(698),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_PIPE] = ACTIONS(702),
    [anon_sym_PLUS] = ACTIONS(704),
    [anon_sym_DASH] = ACTIONS(704),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(706),
    [sym_this] = ACTIONS(708),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(710),
    [sym_false] = ACTIONS(710),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(680),
    [anon_sym_readonly] = ACTIONS(712),
    [anon_sym_get] = ACTIONS(680),
    [anon_sym_set] = ACTIONS(680),
    [anon_sym_declare] = ACTIONS(680),
    [anon_sym_public] = ACTIONS(714),
    [anon_sym_private] = ACTIONS(714),
    [anon_sym_protected] = ACTIONS(714),
    [anon_sym_module] = ACTIONS(680),
    [anon_sym_any] = ACTIONS(716),
    [anon_sym_number] = ACTIONS(716),
    [anon_sym_boolean] = ACTIONS(716),
    [anon_sym_string] = ACTIONS(716),
    [anon_sym_symbol] = ACTIONS(716),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(718),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [83] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(2690),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym__formal_parameter] = STATE(5176),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_sequence_expression] = STATE(5926),
    [sym_string] = STATE(3446),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4668),
    [sym_pattern] = STATE(4318),
    [sym_rest_pattern] = STATE(4319),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym_accessibility_modifier] = STATE(3833),
    [sym_required_parameter] = STATE(5176),
    [sym_optional_parameter] = STATE(5176),
    [sym__parameter_name] = STATE(4318),
    [sym__type] = STATE(4914),
    [sym_constructor_type] = STATE(4914),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4914),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5457),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4914),
    [sym_union_type] = STATE(4914),
    [sym_intersection_type] = STATE(4914),
    [sym_function_type] = STATE(4914),
    [aux_sym_export_statement_repeat1] = STATE(3748),
    [sym_identifier] = ACTIONS(678),
    [anon_sym_export] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(680),
    [anon_sym_namespace] = ACTIONS(682),
    [anon_sym_LBRACE] = ACTIONS(684),
    [anon_sym_typeof] = ACTIONS(686),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_RPAREN] = ACTIONS(688),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(692),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(694),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(698),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_PIPE] = ACTIONS(702),
    [anon_sym_PLUS] = ACTIONS(704),
    [anon_sym_DASH] = ACTIONS(704),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(706),
    [sym_this] = ACTIONS(708),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(710),
    [sym_false] = ACTIONS(710),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(680),
    [anon_sym_readonly] = ACTIONS(712),
    [anon_sym_get] = ACTIONS(680),
    [anon_sym_set] = ACTIONS(680),
    [anon_sym_declare] = ACTIONS(680),
    [anon_sym_public] = ACTIONS(714),
    [anon_sym_private] = ACTIONS(714),
    [anon_sym_protected] = ACTIONS(714),
    [anon_sym_module] = ACTIONS(680),
    [anon_sym_any] = ACTIONS(716),
    [anon_sym_number] = ACTIONS(716),
    [anon_sym_boolean] = ACTIONS(716),
    [anon_sym_string] = ACTIONS(716),
    [anon_sym_symbol] = ACTIONS(716),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(718),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [84] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(2657),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym__formal_parameter] = STATE(5176),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_sequence_expression] = STATE(6024),
    [sym_string] = STATE(3446),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4668),
    [sym_pattern] = STATE(4318),
    [sym_rest_pattern] = STATE(4319),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym_accessibility_modifier] = STATE(3833),
    [sym_required_parameter] = STATE(5176),
    [sym_optional_parameter] = STATE(5176),
    [sym__parameter_name] = STATE(4318),
    [sym__type] = STATE(4988),
    [sym_constructor_type] = STATE(4988),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4988),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5457),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4988),
    [sym_union_type] = STATE(4988),
    [sym_intersection_type] = STATE(4988),
    [sym_function_type] = STATE(4988),
    [aux_sym_export_statement_repeat1] = STATE(3748),
    [sym_identifier] = ACTIONS(678),
    [anon_sym_export] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(680),
    [anon_sym_namespace] = ACTIONS(682),
    [anon_sym_LBRACE] = ACTIONS(684),
    [anon_sym_typeof] = ACTIONS(686),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_RPAREN] = ACTIONS(688),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(692),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(694),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(698),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_PIPE] = ACTIONS(702),
    [anon_sym_PLUS] = ACTIONS(704),
    [anon_sym_DASH] = ACTIONS(704),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(706),
    [sym_this] = ACTIONS(708),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(710),
    [sym_false] = ACTIONS(710),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(680),
    [anon_sym_readonly] = ACTIONS(712),
    [anon_sym_get] = ACTIONS(680),
    [anon_sym_set] = ACTIONS(680),
    [anon_sym_declare] = ACTIONS(680),
    [anon_sym_public] = ACTIONS(714),
    [anon_sym_private] = ACTIONS(714),
    [anon_sym_protected] = ACTIONS(714),
    [anon_sym_module] = ACTIONS(680),
    [anon_sym_any] = ACTIONS(716),
    [anon_sym_number] = ACTIONS(716),
    [anon_sym_boolean] = ACTIONS(716),
    [anon_sym_string] = ACTIONS(716),
    [anon_sym_symbol] = ACTIONS(716),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(718),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [85] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(2652),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(4507),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(4507),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym__formal_parameter] = STATE(5176),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(4507),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_sequence_expression] = STATE(5790),
    [sym_string] = STATE(3446),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4668),
    [sym_pattern] = STATE(4318),
    [sym_rest_pattern] = STATE(4319),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym_accessibility_modifier] = STATE(3833),
    [sym_required_parameter] = STATE(5176),
    [sym_optional_parameter] = STATE(5176),
    [sym__parameter_name] = STATE(4318),
    [sym__type] = STATE(4914),
    [sym_constructor_type] = STATE(4914),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4914),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5457),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4914),
    [sym_union_type] = STATE(4914),
    [sym_intersection_type] = STATE(4914),
    [sym_function_type] = STATE(4914),
    [aux_sym_export_statement_repeat1] = STATE(3748),
    [sym_identifier] = ACTIONS(678),
    [anon_sym_export] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(680),
    [anon_sym_namespace] = ACTIONS(682),
    [anon_sym_LBRACE] = ACTIONS(684),
    [anon_sym_typeof] = ACTIONS(686),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_RPAREN] = ACTIONS(688),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(692),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(694),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(698),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_PIPE] = ACTIONS(702),
    [anon_sym_PLUS] = ACTIONS(704),
    [anon_sym_DASH] = ACTIONS(704),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(706),
    [sym_this] = ACTIONS(708),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(710),
    [sym_false] = ACTIONS(710),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(680),
    [anon_sym_readonly] = ACTIONS(712),
    [anon_sym_get] = ACTIONS(680),
    [anon_sym_set] = ACTIONS(680),
    [anon_sym_declare] = ACTIONS(680),
    [anon_sym_public] = ACTIONS(714),
    [anon_sym_private] = ACTIONS(714),
    [anon_sym_protected] = ACTIONS(714),
    [anon_sym_module] = ACTIONS(680),
    [anon_sym_any] = ACTIONS(716),
    [anon_sym_number] = ACTIONS(716),
    [anon_sym_boolean] = ACTIONS(716),
    [anon_sym_string] = ACTIONS(716),
    [anon_sym_symbol] = ACTIONS(716),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(718),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [86] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(3220),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(5308),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(5308),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(5905),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(5308),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(2822),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4872),
    [sym_pattern] = STATE(5651),
    [sym_rest_pattern] = STATE(4319),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3914),
    [sym__type] = STATE(4193),
    [sym_constructor_type] = STATE(4193),
    [sym__primary_type] = STATE(4015),
    [sym_infer_type] = STATE(4193),
    [sym_conditional_type] = STATE(4019),
    [sym_generic_type] = STATE(4019),
    [sym_type_query] = STATE(4019),
    [sym_index_type_query] = STATE(4019),
    [sym_lookup_type] = STATE(4019),
    [sym_literal_type] = STATE(4019),
    [sym__number] = STATE(4014),
    [sym_existential_type] = STATE(4019),
    [sym_flow_maybe_type] = STATE(4019),
    [sym_parenthesized_type] = STATE(4019),
    [sym_predefined_type] = STATE(4019),
    [sym_object_type] = STATE(4019),
    [sym_type_parameters] = STATE(5398),
    [sym_array_type] = STATE(4019),
    [sym_tuple_type] = STATE(4019),
    [sym_readonly_type] = STATE(4193),
    [sym_union_type] = STATE(4193),
    [sym_intersection_type] = STATE(4193),
    [sym_function_type] = STATE(4193),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [sym_identifier] = ACTIONS(720),
    [anon_sym_export] = ACTIONS(722),
    [anon_sym_STAR] = ACTIONS(724),
    [anon_sym_type] = ACTIONS(722),
    [anon_sym_namespace] = ACTIONS(726),
    [anon_sym_LBRACE] = ACTIONS(728),
    [anon_sym_typeof] = ACTIONS(730),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(732),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(738),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_PIPE] = ACTIONS(744),
    [anon_sym_PLUS] = ACTIONS(746),
    [anon_sym_DASH] = ACTIONS(746),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(748),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(750),
    [sym_this] = ACTIONS(752),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(754),
    [sym_false] = ACTIONS(754),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(722),
    [anon_sym_readonly] = ACTIONS(756),
    [anon_sym_get] = ACTIONS(722),
    [anon_sym_set] = ACTIONS(722),
    [anon_sym_declare] = ACTIONS(722),
    [anon_sym_public] = ACTIONS(722),
    [anon_sym_private] = ACTIONS(722),
    [anon_sym_protected] = ACTIONS(722),
    [anon_sym_module] = ACTIONS(722),
    [anon_sym_any] = ACTIONS(758),
    [anon_sym_number] = ACTIONS(758),
    [anon_sym_boolean] = ACTIONS(758),
    [anon_sym_string] = ACTIONS(758),
    [anon_sym_symbol] = ACTIONS(758),
    [anon_sym_infer] = ACTIONS(760),
    [anon_sym_keyof] = ACTIONS(762),
    [anon_sym_LBRACE_PIPE] = ACTIONS(764),
  },
  [87] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(2037),
    [sym_expression] = STATE(2800),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(5754),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(5754),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(5782),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(2037),
    [sym_subscript_expression] = STATE(2037),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3888),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(5754),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(2440),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4721),
    [sym_non_null_expression] = STATE(2037),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4536),
    [sym_constructor_type] = STATE(4536),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4536),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5544),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4536),
    [sym_union_type] = STATE(4536),
    [sym_intersection_type] = STATE(4536),
    [sym_function_type] = STATE(4536),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [sym_identifier] = ACTIONS(766),
    [anon_sym_export] = ACTIONS(768),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(768),
    [anon_sym_namespace] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [anon_sym_typeof] = ACTIONS(774),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(776),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(778),
    [anon_sym_yield] = ACTIONS(780),
    [anon_sym_LBRACK] = ACTIONS(782),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(784),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(786),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(788),
    [anon_sym_QMARK] = ACTIONS(790),
    [anon_sym_AMP] = ACTIONS(792),
    [anon_sym_PIPE] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(796),
    [anon_sym_DASH] = ACTIONS(796),
    [anon_sym_TILDE] = ACTIONS(776),
    [anon_sym_void] = ACTIONS(798),
    [anon_sym_delete] = ACTIONS(800),
    [anon_sym_PLUS_PLUS] = ACTIONS(802),
    [anon_sym_DASH_DASH] = ACTIONS(802),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(804),
    [sym_this] = ACTIONS(806),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(808),
    [sym_false] = ACTIONS(808),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(810),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(768),
    [anon_sym_readonly] = ACTIONS(812),
    [anon_sym_get] = ACTIONS(768),
    [anon_sym_set] = ACTIONS(768),
    [anon_sym_declare] = ACTIONS(768),
    [anon_sym_public] = ACTIONS(768),
    [anon_sym_private] = ACTIONS(768),
    [anon_sym_protected] = ACTIONS(768),
    [anon_sym_module] = ACTIONS(768),
    [anon_sym_any] = ACTIONS(814),
    [anon_sym_number] = ACTIONS(814),
    [anon_sym_boolean] = ACTIONS(814),
    [anon_sym_string] = ACTIONS(814),
    [anon_sym_symbol] = ACTIONS(814),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(816),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [88] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1539),
    [sym_expression] = STATE(2444),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(6030),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(6030),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6006),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1539),
    [sym_subscript_expression] = STATE(1539),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3878),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(6030),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(2440),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4721),
    [sym_non_null_expression] = STATE(1539),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4536),
    [sym_constructor_type] = STATE(4536),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4536),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5544),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4536),
    [sym_union_type] = STATE(4536),
    [sym_intersection_type] = STATE(4536),
    [sym_function_type] = STATE(4536),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [sym_identifier] = ACTIONS(818),
    [anon_sym_export] = ACTIONS(820),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(820),
    [anon_sym_namespace] = ACTIONS(822),
    [anon_sym_LBRACE] = ACTIONS(772),
    [anon_sym_typeof] = ACTIONS(824),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(782),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(826),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(828),
    [anon_sym_QMARK] = ACTIONS(790),
    [anon_sym_AMP] = ACTIONS(792),
    [anon_sym_PIPE] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(830),
    [anon_sym_DASH] = ACTIONS(830),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(804),
    [sym_this] = ACTIONS(806),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(808),
    [sym_false] = ACTIONS(808),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(820),
    [anon_sym_readonly] = ACTIONS(832),
    [anon_sym_get] = ACTIONS(820),
    [anon_sym_set] = ACTIONS(820),
    [anon_sym_declare] = ACTIONS(820),
    [anon_sym_public] = ACTIONS(820),
    [anon_sym_private] = ACTIONS(820),
    [anon_sym_protected] = ACTIONS(820),
    [anon_sym_module] = ACTIONS(820),
    [anon_sym_any] = ACTIONS(834),
    [anon_sym_number] = ACTIONS(834),
    [anon_sym_boolean] = ACTIONS(834),
    [anon_sym_string] = ACTIONS(834),
    [anon_sym_symbol] = ACTIONS(834),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(816),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [89] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1439),
    [sym_expression] = STATE(2209),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(5812),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(5812),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(5758),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1439),
    [sym_subscript_expression] = STATE(1439),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3887),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(5812),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(2211),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4721),
    [sym_non_null_expression] = STATE(1439),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4536),
    [sym_constructor_type] = STATE(4536),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4536),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5544),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4536),
    [sym_union_type] = STATE(4536),
    [sym_intersection_type] = STATE(4536),
    [sym_function_type] = STATE(4536),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [sym_identifier] = ACTIONS(836),
    [anon_sym_export] = ACTIONS(838),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(838),
    [anon_sym_namespace] = ACTIONS(840),
    [anon_sym_LBRACE] = ACTIONS(842),
    [anon_sym_typeof] = ACTIONS(844),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(846),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(848),
    [anon_sym_yield] = ACTIONS(850),
    [anon_sym_LBRACK] = ACTIONS(852),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(854),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(856),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(858),
    [anon_sym_QMARK] = ACTIONS(790),
    [anon_sym_AMP] = ACTIONS(792),
    [anon_sym_PIPE] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(860),
    [anon_sym_DASH] = ACTIONS(860),
    [anon_sym_TILDE] = ACTIONS(846),
    [anon_sym_void] = ACTIONS(862),
    [anon_sym_delete] = ACTIONS(864),
    [anon_sym_PLUS_PLUS] = ACTIONS(866),
    [anon_sym_DASH_DASH] = ACTIONS(866),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(868),
    [sym_this] = ACTIONS(870),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(872),
    [sym_false] = ACTIONS(872),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(874),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(838),
    [anon_sym_readonly] = ACTIONS(876),
    [anon_sym_get] = ACTIONS(838),
    [anon_sym_set] = ACTIONS(838),
    [anon_sym_declare] = ACTIONS(838),
    [anon_sym_public] = ACTIONS(838),
    [anon_sym_private] = ACTIONS(838),
    [anon_sym_protected] = ACTIONS(838),
    [anon_sym_module] = ACTIONS(838),
    [anon_sym_any] = ACTIONS(878),
    [anon_sym_number] = ACTIONS(878),
    [anon_sym_boolean] = ACTIONS(878),
    [anon_sym_string] = ACTIONS(878),
    [anon_sym_symbol] = ACTIONS(878),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(816),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [90] = {
    [sym_import] = STATE(2475),
    [sym_parenthesized_expression] = STATE(2072),
    [sym_expression] = STATE(3017),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5824),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5824),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_function] = STATE(2475),
    [sym_generator_function] = STATE(2475),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5822),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2072),
    [sym_subscript_expression] = STATE(2072),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3891),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5824),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_string] = STATE(3532),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4721),
    [sym_non_null_expression] = STATE(2072),
    [sym_as_expression] = STATE(2484),
    [sym_internal_module] = STATE(2484),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4536),
    [sym_constructor_type] = STATE(4536),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4536),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5544),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4536),
    [sym_union_type] = STATE(4536),
    [sym_intersection_type] = STATE(4536),
    [sym_function_type] = STATE(4536),
    [aux_sym_export_statement_repeat1] = STATE(5016),
    [sym_identifier] = ACTIONS(880),
    [anon_sym_export] = ACTIONS(882),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(882),
    [anon_sym_namespace] = ACTIONS(884),
    [anon_sym_LBRACE] = ACTIONS(886),
    [anon_sym_typeof] = ACTIONS(888),
    [anon_sym_import] = ACTIONS(890),
    [anon_sym_BANG] = ACTIONS(892),
    [anon_sym_LPAREN] = ACTIONS(894),
    [anon_sym_await] = ACTIONS(896),
    [anon_sym_yield] = ACTIONS(898),
    [anon_sym_LBRACK] = ACTIONS(900),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(902),
    [anon_sym_class] = ACTIONS(904),
    [anon_sym_async] = ACTIONS(906),
    [anon_sym_function] = ACTIONS(908),
    [anon_sym_new] = ACTIONS(910),
    [anon_sym_QMARK] = ACTIONS(790),
    [anon_sym_AMP] = ACTIONS(792),
    [anon_sym_PIPE] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(912),
    [anon_sym_DASH] = ACTIONS(912),
    [anon_sym_TILDE] = ACTIONS(892),
    [anon_sym_void] = ACTIONS(914),
    [anon_sym_delete] = ACTIONS(916),
    [anon_sym_PLUS_PLUS] = ACTIONS(918),
    [anon_sym_DASH_DASH] = ACTIONS(918),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(920),
    [sym_this] = ACTIONS(922),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(924),
    [sym_false] = ACTIONS(924),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(926),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(882),
    [anon_sym_readonly] = ACTIONS(928),
    [anon_sym_get] = ACTIONS(882),
    [anon_sym_set] = ACTIONS(882),
    [anon_sym_declare] = ACTIONS(882),
    [anon_sym_public] = ACTIONS(882),
    [anon_sym_private] = ACTIONS(882),
    [anon_sym_protected] = ACTIONS(882),
    [anon_sym_module] = ACTIONS(882),
    [anon_sym_any] = ACTIONS(930),
    [anon_sym_number] = ACTIONS(930),
    [anon_sym_boolean] = ACTIONS(930),
    [anon_sym_string] = ACTIONS(930),
    [anon_sym_symbol] = ACTIONS(930),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(816),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [91] = {
    [sym_import] = STATE(2475),
    [sym_parenthesized_expression] = STATE(1456),
    [sym_expression] = STATE(2315),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5767),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5767),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_function] = STATE(2475),
    [sym_generator_function] = STATE(2475),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5765),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(1456),
    [sym_subscript_expression] = STATE(1456),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3880),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5767),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_string] = STATE(2421),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4721),
    [sym_non_null_expression] = STATE(1456),
    [sym_as_expression] = STATE(2484),
    [sym_internal_module] = STATE(2484),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4536),
    [sym_constructor_type] = STATE(4536),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4536),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5544),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4536),
    [sym_union_type] = STATE(4536),
    [sym_intersection_type] = STATE(4536),
    [sym_function_type] = STATE(4536),
    [aux_sym_export_statement_repeat1] = STATE(5016),
    [sym_identifier] = ACTIONS(932),
    [anon_sym_export] = ACTIONS(934),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(934),
    [anon_sym_namespace] = ACTIONS(936),
    [anon_sym_LBRACE] = ACTIONS(938),
    [anon_sym_typeof] = ACTIONS(940),
    [anon_sym_import] = ACTIONS(890),
    [anon_sym_BANG] = ACTIONS(942),
    [anon_sym_LPAREN] = ACTIONS(894),
    [anon_sym_await] = ACTIONS(944),
    [anon_sym_yield] = ACTIONS(946),
    [anon_sym_LBRACK] = ACTIONS(948),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(902),
    [anon_sym_class] = ACTIONS(904),
    [anon_sym_async] = ACTIONS(950),
    [anon_sym_function] = ACTIONS(908),
    [anon_sym_new] = ACTIONS(952),
    [anon_sym_QMARK] = ACTIONS(790),
    [anon_sym_AMP] = ACTIONS(792),
    [anon_sym_PIPE] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(954),
    [anon_sym_DASH] = ACTIONS(954),
    [anon_sym_TILDE] = ACTIONS(942),
    [anon_sym_void] = ACTIONS(956),
    [anon_sym_delete] = ACTIONS(958),
    [anon_sym_PLUS_PLUS] = ACTIONS(960),
    [anon_sym_DASH_DASH] = ACTIONS(960),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(962),
    [sym_this] = ACTIONS(964),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(966),
    [sym_false] = ACTIONS(966),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(968),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(934),
    [anon_sym_readonly] = ACTIONS(970),
    [anon_sym_get] = ACTIONS(934),
    [anon_sym_set] = ACTIONS(934),
    [anon_sym_declare] = ACTIONS(934),
    [anon_sym_public] = ACTIONS(934),
    [anon_sym_private] = ACTIONS(934),
    [anon_sym_protected] = ACTIONS(934),
    [anon_sym_module] = ACTIONS(934),
    [anon_sym_any] = ACTIONS(972),
    [anon_sym_number] = ACTIONS(972),
    [anon_sym_boolean] = ACTIONS(972),
    [anon_sym_string] = ACTIONS(972),
    [anon_sym_symbol] = ACTIONS(972),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(816),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [92] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(2098),
    [sym_expression] = STATE(2980),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(5978),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(5978),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(5980),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(2098),
    [sym_subscript_expression] = STATE(2098),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3882),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(5978),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(2211),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4721),
    [sym_non_null_expression] = STATE(2098),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4536),
    [sym_constructor_type] = STATE(4536),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4536),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5544),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4536),
    [sym_union_type] = STATE(4536),
    [sym_intersection_type] = STATE(4536),
    [sym_function_type] = STATE(4536),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [sym_identifier] = ACTIONS(974),
    [anon_sym_export] = ACTIONS(976),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(976),
    [anon_sym_namespace] = ACTIONS(978),
    [anon_sym_LBRACE] = ACTIONS(842),
    [anon_sym_typeof] = ACTIONS(980),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(982),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(984),
    [anon_sym_yield] = ACTIONS(986),
    [anon_sym_LBRACK] = ACTIONS(852),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(854),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(988),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(990),
    [anon_sym_QMARK] = ACTIONS(790),
    [anon_sym_AMP] = ACTIONS(792),
    [anon_sym_PIPE] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(992),
    [anon_sym_DASH] = ACTIONS(992),
    [anon_sym_TILDE] = ACTIONS(982),
    [anon_sym_void] = ACTIONS(994),
    [anon_sym_delete] = ACTIONS(996),
    [anon_sym_PLUS_PLUS] = ACTIONS(998),
    [anon_sym_DASH_DASH] = ACTIONS(998),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(868),
    [sym_this] = ACTIONS(870),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(872),
    [sym_false] = ACTIONS(872),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(1000),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(976),
    [anon_sym_readonly] = ACTIONS(1002),
    [anon_sym_get] = ACTIONS(976),
    [anon_sym_set] = ACTIONS(976),
    [anon_sym_declare] = ACTIONS(976),
    [anon_sym_public] = ACTIONS(976),
    [anon_sym_private] = ACTIONS(976),
    [anon_sym_protected] = ACTIONS(976),
    [anon_sym_module] = ACTIONS(976),
    [anon_sym_any] = ACTIONS(1004),
    [anon_sym_number] = ACTIONS(1004),
    [anon_sym_boolean] = ACTIONS(1004),
    [anon_sym_string] = ACTIONS(1004),
    [anon_sym_symbol] = ACTIONS(1004),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(816),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [93] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(2103),
    [sym_expression] = STATE(2733),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(5873),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(5873),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(5916),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(2103),
    [sym_subscript_expression] = STATE(2103),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3892),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(5873),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(2211),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4721),
    [sym_non_null_expression] = STATE(2103),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4536),
    [sym_constructor_type] = STATE(4536),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4536),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5544),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4536),
    [sym_union_type] = STATE(4536),
    [sym_intersection_type] = STATE(4536),
    [sym_function_type] = STATE(4536),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [sym_identifier] = ACTIONS(1006),
    [anon_sym_export] = ACTIONS(1008),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(1008),
    [anon_sym_namespace] = ACTIONS(1010),
    [anon_sym_LBRACE] = ACTIONS(1012),
    [anon_sym_typeof] = ACTIONS(1014),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(1016),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(1018),
    [anon_sym_yield] = ACTIONS(1020),
    [anon_sym_LBRACK] = ACTIONS(1022),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(854),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(1024),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(1026),
    [anon_sym_QMARK] = ACTIONS(790),
    [anon_sym_AMP] = ACTIONS(792),
    [anon_sym_PIPE] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(1028),
    [anon_sym_DASH] = ACTIONS(1028),
    [anon_sym_TILDE] = ACTIONS(1016),
    [anon_sym_void] = ACTIONS(1030),
    [anon_sym_delete] = ACTIONS(1032),
    [anon_sym_PLUS_PLUS] = ACTIONS(1034),
    [anon_sym_DASH_DASH] = ACTIONS(1034),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(868),
    [sym_this] = ACTIONS(870),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(872),
    [sym_false] = ACTIONS(872),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(1036),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(1008),
    [anon_sym_readonly] = ACTIONS(1038),
    [anon_sym_get] = ACTIONS(1008),
    [anon_sym_set] = ACTIONS(1008),
    [anon_sym_declare] = ACTIONS(1008),
    [anon_sym_public] = ACTIONS(1008),
    [anon_sym_private] = ACTIONS(1008),
    [anon_sym_protected] = ACTIONS(1008),
    [anon_sym_module] = ACTIONS(1008),
    [anon_sym_any] = ACTIONS(1040),
    [anon_sym_number] = ACTIONS(1040),
    [anon_sym_boolean] = ACTIONS(1040),
    [anon_sym_string] = ACTIONS(1040),
    [anon_sym_symbol] = ACTIONS(1040),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(816),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [94] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(1347),
    [sym_expression] = STATE(3330),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(6005),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(6005),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6031),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(1347),
    [sym_subscript_expression] = STATE(1347),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3877),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(6005),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3262),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4721),
    [sym_non_null_expression] = STATE(1347),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4536),
    [sym_constructor_type] = STATE(4536),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4536),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5544),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4536),
    [sym_union_type] = STATE(4536),
    [sym_intersection_type] = STATE(4536),
    [sym_function_type] = STATE(4536),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [sym_identifier] = ACTIONS(1042),
    [anon_sym_export] = ACTIONS(1044),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(1044),
    [anon_sym_namespace] = ACTIONS(1046),
    [anon_sym_LBRACE] = ACTIONS(1048),
    [anon_sym_typeof] = ACTIONS(1050),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(1052),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(1054),
    [anon_sym_yield] = ACTIONS(1056),
    [anon_sym_LBRACK] = ACTIONS(1058),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(1060),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(1062),
    [anon_sym_QMARK] = ACTIONS(790),
    [anon_sym_AMP] = ACTIONS(792),
    [anon_sym_PIPE] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(1064),
    [anon_sym_DASH] = ACTIONS(1064),
    [anon_sym_TILDE] = ACTIONS(1052),
    [anon_sym_void] = ACTIONS(1066),
    [anon_sym_delete] = ACTIONS(1068),
    [anon_sym_PLUS_PLUS] = ACTIONS(1070),
    [anon_sym_DASH_DASH] = ACTIONS(1070),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(1072),
    [sym_this] = ACTIONS(1074),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(1076),
    [sym_false] = ACTIONS(1076),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(1078),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(1044),
    [anon_sym_readonly] = ACTIONS(1080),
    [anon_sym_get] = ACTIONS(1044),
    [anon_sym_set] = ACTIONS(1044),
    [anon_sym_declare] = ACTIONS(1044),
    [anon_sym_public] = ACTIONS(1044),
    [anon_sym_private] = ACTIONS(1044),
    [anon_sym_protected] = ACTIONS(1044),
    [anon_sym_module] = ACTIONS(1044),
    [anon_sym_any] = ACTIONS(1082),
    [anon_sym_number] = ACTIONS(1082),
    [anon_sym_boolean] = ACTIONS(1082),
    [anon_sym_string] = ACTIONS(1082),
    [anon_sym_symbol] = ACTIONS(1082),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(816),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [95] = {
    [sym_import] = STATE(3394),
    [sym_parenthesized_expression] = STATE(2074),
    [sym_expression] = STATE(2829),
    [sym_primary_expression] = STATE(3392),
    [sym_yield_expression] = STATE(3361),
    [sym_object] = STATE(3394),
    [sym_object_pattern] = STATE(5963),
    [sym_array] = STATE(3394),
    [sym_array_pattern] = STATE(5963),
    [sym_jsx_element] = STATE(3361),
    [sym_jsx_fragment] = STATE(3361),
    [sym_jsx_opening_element] = STATE(4066),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(3361),
    [sym_class] = STATE(3394),
    [sym_function] = STATE(3394),
    [sym_generator_function] = STATE(3394),
    [sym_arrow_function] = STATE(3394),
    [sym__call_signature] = STATE(6000),
    [sym_call_expression] = STATE(3394),
    [sym_new_expression] = STATE(3361),
    [sym_await_expression] = STATE(3361),
    [sym_member_expression] = STATE(2074),
    [sym_subscript_expression] = STATE(2074),
    [sym_assignment_expression] = STATE(3361),
    [sym__augmented_assignment_lhs] = STATE(3881),
    [sym_augmented_assignment_expression] = STATE(3361),
    [sym__destructuring_pattern] = STATE(5963),
    [sym_ternary_expression] = STATE(3361),
    [sym_binary_expression] = STATE(3361),
    [sym_unary_expression] = STATE(3361),
    [sym_update_expression] = STATE(3361),
    [sym_string] = STATE(3471),
    [sym_template_string] = STATE(3394),
    [sym_regex] = STATE(3394),
    [sym_meta_property] = STATE(3394),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4721),
    [sym_non_null_expression] = STATE(2074),
    [sym_as_expression] = STATE(3361),
    [sym_internal_module] = STATE(3361),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4536),
    [sym_constructor_type] = STATE(4536),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4536),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5544),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4536),
    [sym_union_type] = STATE(4536),
    [sym_intersection_type] = STATE(4536),
    [sym_function_type] = STATE(4536),
    [aux_sym_export_statement_repeat1] = STATE(5044),
    [sym_identifier] = ACTIONS(1084),
    [anon_sym_export] = ACTIONS(1086),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(1086),
    [anon_sym_namespace] = ACTIONS(1088),
    [anon_sym_LBRACE] = ACTIONS(1090),
    [anon_sym_typeof] = ACTIONS(1092),
    [anon_sym_import] = ACTIONS(1094),
    [anon_sym_BANG] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(1098),
    [anon_sym_await] = ACTIONS(1100),
    [anon_sym_yield] = ACTIONS(1102),
    [anon_sym_LBRACK] = ACTIONS(1104),
    [anon_sym_LT] = ACTIONS(1106),
    [anon_sym_SLASH] = ACTIONS(1108),
    [anon_sym_class] = ACTIONS(1110),
    [anon_sym_async] = ACTIONS(1112),
    [anon_sym_function] = ACTIONS(1114),
    [anon_sym_new] = ACTIONS(1116),
    [anon_sym_QMARK] = ACTIONS(790),
    [anon_sym_AMP] = ACTIONS(792),
    [anon_sym_PIPE] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(1118),
    [anon_sym_DASH] = ACTIONS(1118),
    [anon_sym_TILDE] = ACTIONS(1096),
    [anon_sym_void] = ACTIONS(1120),
    [anon_sym_delete] = ACTIONS(1122),
    [anon_sym_PLUS_PLUS] = ACTIONS(1124),
    [anon_sym_DASH_DASH] = ACTIONS(1124),
    [anon_sym_DQUOTE] = ACTIONS(1126),
    [anon_sym_SQUOTE] = ACTIONS(1128),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1130),
    [sym_number] = ACTIONS(1132),
    [sym_this] = ACTIONS(1134),
    [sym_super] = ACTIONS(1136),
    [sym_true] = ACTIONS(1138),
    [sym_false] = ACTIONS(1138),
    [sym_null] = ACTIONS(1136),
    [sym_undefined] = ACTIONS(1140),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(1086),
    [anon_sym_readonly] = ACTIONS(1142),
    [anon_sym_get] = ACTIONS(1086),
    [anon_sym_set] = ACTIONS(1086),
    [anon_sym_declare] = ACTIONS(1086),
    [anon_sym_public] = ACTIONS(1086),
    [anon_sym_private] = ACTIONS(1086),
    [anon_sym_protected] = ACTIONS(1086),
    [anon_sym_module] = ACTIONS(1086),
    [anon_sym_any] = ACTIONS(1144),
    [anon_sym_number] = ACTIONS(1144),
    [anon_sym_boolean] = ACTIONS(1144),
    [anon_sym_string] = ACTIONS(1144),
    [anon_sym_symbol] = ACTIONS(1144),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(816),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [96] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(2082),
    [sym_expression] = STATE(3198),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(5854),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(5854),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(5857),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(2082),
    [sym_subscript_expression] = STATE(2082),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3876),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(5854),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(2437),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4721),
    [sym_non_null_expression] = STATE(2082),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4536),
    [sym_constructor_type] = STATE(4536),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4536),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5544),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4536),
    [sym_union_type] = STATE(4536),
    [sym_intersection_type] = STATE(4536),
    [sym_function_type] = STATE(4536),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [sym_identifier] = ACTIONS(1146),
    [anon_sym_export] = ACTIONS(1148),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(1148),
    [anon_sym_namespace] = ACTIONS(1150),
    [anon_sym_LBRACE] = ACTIONS(1152),
    [anon_sym_typeof] = ACTIONS(1154),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(1156),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(1158),
    [anon_sym_yield] = ACTIONS(1160),
    [anon_sym_LBRACK] = ACTIONS(1162),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(854),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(1164),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(1166),
    [anon_sym_QMARK] = ACTIONS(790),
    [anon_sym_AMP] = ACTIONS(792),
    [anon_sym_PIPE] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(1168),
    [anon_sym_DASH] = ACTIONS(1168),
    [anon_sym_TILDE] = ACTIONS(1156),
    [anon_sym_void] = ACTIONS(1170),
    [anon_sym_delete] = ACTIONS(1172),
    [anon_sym_PLUS_PLUS] = ACTIONS(1174),
    [anon_sym_DASH_DASH] = ACTIONS(1174),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(1176),
    [sym_this] = ACTIONS(1178),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(1180),
    [sym_false] = ACTIONS(1180),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(1182),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(1148),
    [anon_sym_readonly] = ACTIONS(1184),
    [anon_sym_get] = ACTIONS(1148),
    [anon_sym_set] = ACTIONS(1148),
    [anon_sym_declare] = ACTIONS(1148),
    [anon_sym_public] = ACTIONS(1148),
    [anon_sym_private] = ACTIONS(1148),
    [anon_sym_protected] = ACTIONS(1148),
    [anon_sym_module] = ACTIONS(1148),
    [anon_sym_any] = ACTIONS(1186),
    [anon_sym_number] = ACTIONS(1186),
    [anon_sym_boolean] = ACTIONS(1186),
    [anon_sym_string] = ACTIONS(1186),
    [anon_sym_symbol] = ACTIONS(1186),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(816),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [97] = {
    [sym_import] = STATE(2475),
    [sym_parenthesized_expression] = STATE(2019),
    [sym_expression] = STATE(2744),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5922),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5922),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_function] = STATE(2475),
    [sym_generator_function] = STATE(2475),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5915),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(2019),
    [sym_subscript_expression] = STATE(2019),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3883),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5922),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_string] = STATE(3126),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4721),
    [sym_non_null_expression] = STATE(2019),
    [sym_as_expression] = STATE(2484),
    [sym_internal_module] = STATE(2484),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4536),
    [sym_constructor_type] = STATE(4536),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4536),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5544),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4536),
    [sym_union_type] = STATE(4536),
    [sym_intersection_type] = STATE(4536),
    [sym_function_type] = STATE(4536),
    [aux_sym_export_statement_repeat1] = STATE(5016),
    [sym_identifier] = ACTIONS(1188),
    [anon_sym_export] = ACTIONS(1190),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(1190),
    [anon_sym_namespace] = ACTIONS(1192),
    [anon_sym_LBRACE] = ACTIONS(1194),
    [anon_sym_typeof] = ACTIONS(1196),
    [anon_sym_import] = ACTIONS(890),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(894),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(1198),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(904),
    [anon_sym_async] = ACTIONS(1200),
    [anon_sym_function] = ACTIONS(908),
    [anon_sym_new] = ACTIONS(1202),
    [anon_sym_QMARK] = ACTIONS(790),
    [anon_sym_AMP] = ACTIONS(792),
    [anon_sym_PIPE] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(1204),
    [anon_sym_DASH] = ACTIONS(1204),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(1206),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(1208),
    [sym_this] = ACTIONS(1210),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(1212),
    [sym_false] = ACTIONS(1212),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(1190),
    [anon_sym_readonly] = ACTIONS(1214),
    [anon_sym_get] = ACTIONS(1190),
    [anon_sym_set] = ACTIONS(1190),
    [anon_sym_declare] = ACTIONS(1190),
    [anon_sym_public] = ACTIONS(1190),
    [anon_sym_private] = ACTIONS(1190),
    [anon_sym_protected] = ACTIONS(1190),
    [anon_sym_module] = ACTIONS(1190),
    [anon_sym_any] = ACTIONS(1216),
    [anon_sym_number] = ACTIONS(1216),
    [anon_sym_boolean] = ACTIONS(1216),
    [anon_sym_string] = ACTIONS(1216),
    [anon_sym_symbol] = ACTIONS(1216),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(816),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [98] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(2038),
    [sym_expression] = STATE(2942),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(5891),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(5891),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(6020),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(2038),
    [sym_subscript_expression] = STATE(2038),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3890),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(5891),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(2437),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4721),
    [sym_non_null_expression] = STATE(2038),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4536),
    [sym_constructor_type] = STATE(4536),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4536),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5544),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4536),
    [sym_union_type] = STATE(4536),
    [sym_intersection_type] = STATE(4536),
    [sym_function_type] = STATE(4536),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [sym_identifier] = ACTIONS(1218),
    [anon_sym_export] = ACTIONS(1220),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(1220),
    [anon_sym_namespace] = ACTIONS(1222),
    [anon_sym_LBRACE] = ACTIONS(1224),
    [anon_sym_typeof] = ACTIONS(1226),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(1228),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(1230),
    [anon_sym_yield] = ACTIONS(1232),
    [anon_sym_LBRACK] = ACTIONS(1162),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(854),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(1234),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(1236),
    [anon_sym_QMARK] = ACTIONS(790),
    [anon_sym_AMP] = ACTIONS(792),
    [anon_sym_PIPE] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(1238),
    [anon_sym_DASH] = ACTIONS(1238),
    [anon_sym_TILDE] = ACTIONS(1228),
    [anon_sym_void] = ACTIONS(1240),
    [anon_sym_delete] = ACTIONS(1242),
    [anon_sym_PLUS_PLUS] = ACTIONS(1244),
    [anon_sym_DASH_DASH] = ACTIONS(1244),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(1176),
    [sym_this] = ACTIONS(1178),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(1180),
    [sym_false] = ACTIONS(1180),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(1246),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(1220),
    [anon_sym_readonly] = ACTIONS(1248),
    [anon_sym_get] = ACTIONS(1220),
    [anon_sym_set] = ACTIONS(1220),
    [anon_sym_declare] = ACTIONS(1220),
    [anon_sym_public] = ACTIONS(1220),
    [anon_sym_private] = ACTIONS(1220),
    [anon_sym_protected] = ACTIONS(1220),
    [anon_sym_module] = ACTIONS(1220),
    [anon_sym_any] = ACTIONS(1250),
    [anon_sym_number] = ACTIONS(1250),
    [anon_sym_boolean] = ACTIONS(1250),
    [anon_sym_string] = ACTIONS(1250),
    [anon_sym_symbol] = ACTIONS(1250),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(816),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [99] = {
    [sym_import] = STATE(2967),
    [sym_parenthesized_expression] = STATE(1485),
    [sym_expression] = STATE(2381),
    [sym_primary_expression] = STATE(2959),
    [sym_yield_expression] = STATE(2958),
    [sym_object] = STATE(2967),
    [sym_object_pattern] = STATE(5939),
    [sym_array] = STATE(2967),
    [sym_array_pattern] = STATE(5939),
    [sym_jsx_element] = STATE(2958),
    [sym_jsx_fragment] = STATE(2958),
    [sym_jsx_opening_element] = STATE(4060),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2958),
    [sym_class] = STATE(2967),
    [sym_function] = STATE(2967),
    [sym_generator_function] = STATE(2967),
    [sym_arrow_function] = STATE(2967),
    [sym__call_signature] = STATE(5940),
    [sym_call_expression] = STATE(2967),
    [sym_new_expression] = STATE(2958),
    [sym_await_expression] = STATE(2958),
    [sym_member_expression] = STATE(1485),
    [sym_subscript_expression] = STATE(1485),
    [sym_assignment_expression] = STATE(2958),
    [sym__augmented_assignment_lhs] = STATE(3874),
    [sym_augmented_assignment_expression] = STATE(2958),
    [sym__destructuring_pattern] = STATE(5939),
    [sym_ternary_expression] = STATE(2958),
    [sym_binary_expression] = STATE(2958),
    [sym_unary_expression] = STATE(2958),
    [sym_update_expression] = STATE(2958),
    [sym_string] = STATE(2915),
    [sym_template_string] = STATE(2967),
    [sym_regex] = STATE(2967),
    [sym_meta_property] = STATE(2967),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4721),
    [sym_non_null_expression] = STATE(1485),
    [sym_as_expression] = STATE(2958),
    [sym_internal_module] = STATE(2958),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4536),
    [sym_constructor_type] = STATE(4536),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4536),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5544),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4536),
    [sym_union_type] = STATE(4536),
    [sym_intersection_type] = STATE(4536),
    [sym_function_type] = STATE(4536),
    [aux_sym_export_statement_repeat1] = STATE(4944),
    [sym_identifier] = ACTIONS(1252),
    [anon_sym_export] = ACTIONS(1254),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(1254),
    [anon_sym_namespace] = ACTIONS(1256),
    [anon_sym_LBRACE] = ACTIONS(1258),
    [anon_sym_typeof] = ACTIONS(1260),
    [anon_sym_import] = ACTIONS(1262),
    [anon_sym_BANG] = ACTIONS(1264),
    [anon_sym_LPAREN] = ACTIONS(1266),
    [anon_sym_await] = ACTIONS(1268),
    [anon_sym_yield] = ACTIONS(1270),
    [anon_sym_LBRACK] = ACTIONS(1272),
    [anon_sym_LT] = ACTIONS(1274),
    [anon_sym_SLASH] = ACTIONS(1276),
    [anon_sym_class] = ACTIONS(1278),
    [anon_sym_async] = ACTIONS(1280),
    [anon_sym_function] = ACTIONS(1282),
    [anon_sym_new] = ACTIONS(1284),
    [anon_sym_QMARK] = ACTIONS(790),
    [anon_sym_AMP] = ACTIONS(792),
    [anon_sym_PIPE] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(1286),
    [anon_sym_DASH] = ACTIONS(1286),
    [anon_sym_TILDE] = ACTIONS(1264),
    [anon_sym_void] = ACTIONS(1288),
    [anon_sym_delete] = ACTIONS(1290),
    [anon_sym_PLUS_PLUS] = ACTIONS(1292),
    [anon_sym_DASH_DASH] = ACTIONS(1292),
    [anon_sym_DQUOTE] = ACTIONS(1294),
    [anon_sym_SQUOTE] = ACTIONS(1296),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1298),
    [sym_number] = ACTIONS(1300),
    [sym_this] = ACTIONS(1302),
    [sym_super] = ACTIONS(1304),
    [sym_true] = ACTIONS(1306),
    [sym_false] = ACTIONS(1306),
    [sym_null] = ACTIONS(1304),
    [sym_undefined] = ACTIONS(1308),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(1254),
    [anon_sym_readonly] = ACTIONS(1310),
    [anon_sym_get] = ACTIONS(1254),
    [anon_sym_set] = ACTIONS(1254),
    [anon_sym_declare] = ACTIONS(1254),
    [anon_sym_public] = ACTIONS(1254),
    [anon_sym_private] = ACTIONS(1254),
    [anon_sym_protected] = ACTIONS(1254),
    [anon_sym_module] = ACTIONS(1254),
    [anon_sym_any] = ACTIONS(1312),
    [anon_sym_number] = ACTIONS(1312),
    [anon_sym_boolean] = ACTIONS(1312),
    [anon_sym_string] = ACTIONS(1312),
    [anon_sym_symbol] = ACTIONS(1312),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(816),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [100] = {
    [sym_import] = STATE(2339),
    [sym_parenthesized_expression] = STATE(2055),
    [sym_expression] = STATE(3285),
    [sym_primary_expression] = STATE(2186),
    [sym_yield_expression] = STATE(2187),
    [sym_object] = STATE(2339),
    [sym_object_pattern] = STATE(5781),
    [sym_array] = STATE(2339),
    [sym_array_pattern] = STATE(5781),
    [sym_jsx_element] = STATE(2187),
    [sym_jsx_fragment] = STATE(2187),
    [sym_jsx_opening_element] = STATE(4053),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2187),
    [sym_class] = STATE(2339),
    [sym_function] = STATE(2339),
    [sym_generator_function] = STATE(2339),
    [sym_arrow_function] = STATE(2339),
    [sym__call_signature] = STATE(5801),
    [sym_call_expression] = STATE(2339),
    [sym_new_expression] = STATE(2187),
    [sym_await_expression] = STATE(2187),
    [sym_member_expression] = STATE(2055),
    [sym_subscript_expression] = STATE(2055),
    [sym_assignment_expression] = STATE(2187),
    [sym__augmented_assignment_lhs] = STATE(3893),
    [sym_augmented_assignment_expression] = STATE(2187),
    [sym__destructuring_pattern] = STATE(5781),
    [sym_ternary_expression] = STATE(2187),
    [sym_binary_expression] = STATE(2187),
    [sym_unary_expression] = STATE(2187),
    [sym_update_expression] = STATE(2187),
    [sym_string] = STATE(3262),
    [sym_template_string] = STATE(2339),
    [sym_regex] = STATE(2339),
    [sym_meta_property] = STATE(2339),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4721),
    [sym_non_null_expression] = STATE(2055),
    [sym_as_expression] = STATE(2187),
    [sym_internal_module] = STATE(2187),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4536),
    [sym_constructor_type] = STATE(4536),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4536),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5544),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4536),
    [sym_union_type] = STATE(4536),
    [sym_intersection_type] = STATE(4536),
    [sym_function_type] = STATE(4536),
    [aux_sym_export_statement_repeat1] = STATE(4924),
    [sym_identifier] = ACTIONS(1314),
    [anon_sym_export] = ACTIONS(1316),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(1316),
    [anon_sym_namespace] = ACTIONS(1318),
    [anon_sym_LBRACE] = ACTIONS(1320),
    [anon_sym_typeof] = ACTIONS(1322),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(1324),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(1326),
    [anon_sym_yield] = ACTIONS(1328),
    [anon_sym_LBRACK] = ACTIONS(1058),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(1330),
    [anon_sym_function] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(1332),
    [anon_sym_QMARK] = ACTIONS(790),
    [anon_sym_AMP] = ACTIONS(792),
    [anon_sym_PIPE] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(1334),
    [anon_sym_DASH] = ACTIONS(1334),
    [anon_sym_TILDE] = ACTIONS(1324),
    [anon_sym_void] = ACTIONS(1336),
    [anon_sym_delete] = ACTIONS(1338),
    [anon_sym_PLUS_PLUS] = ACTIONS(1340),
    [anon_sym_DASH_DASH] = ACTIONS(1340),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(1072),
    [sym_this] = ACTIONS(1074),
    [sym_super] = ACTIONS(626),
    [sym_true] = ACTIONS(1076),
    [sym_false] = ACTIONS(1076),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(1342),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(1316),
    [anon_sym_readonly] = ACTIONS(1344),
    [anon_sym_get] = ACTIONS(1316),
    [anon_sym_set] = ACTIONS(1316),
    [anon_sym_declare] = ACTIONS(1316),
    [anon_sym_public] = ACTIONS(1316),
    [anon_sym_private] = ACTIONS(1316),
    [anon_sym_protected] = ACTIONS(1316),
    [anon_sym_module] = ACTIONS(1316),
    [anon_sym_any] = ACTIONS(1346),
    [anon_sym_number] = ACTIONS(1346),
    [anon_sym_boolean] = ACTIONS(1346),
    [anon_sym_string] = ACTIONS(1346),
    [anon_sym_symbol] = ACTIONS(1346),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(816),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [101] = {
    [sym_import] = STATE(2967),
    [sym_parenthesized_expression] = STATE(1486),
    [sym_expression] = STATE(2517),
    [sym_primary_expression] = STATE(2959),
    [sym_yield_expression] = STATE(2958),
    [sym_object] = STATE(2967),
    [sym_object_pattern] = STATE(5778),
    [sym_array] = STATE(2967),
    [sym_array_pattern] = STATE(5778),
    [sym_jsx_element] = STATE(2958),
    [sym_jsx_fragment] = STATE(2958),
    [sym_jsx_opening_element] = STATE(4060),
    [sym_nested_identifier] = STATE(6070),
    [sym_jsx_self_closing_element] = STATE(2958),
    [sym_class] = STATE(2967),
    [sym_function] = STATE(2967),
    [sym_generator_function] = STATE(2967),
    [sym_arrow_function] = STATE(2967),
    [sym__call_signature] = STATE(5756),
    [sym_call_expression] = STATE(2967),
    [sym_new_expression] = STATE(2958),
    [sym_await_expression] = STATE(2958),
    [sym_member_expression] = STATE(1486),
    [sym_subscript_expression] = STATE(1486),
    [sym_assignment_expression] = STATE(2958),
    [sym__augmented_assignment_lhs] = STATE(3879),
    [sym_augmented_assignment_expression] = STATE(2958),
    [sym__destructuring_pattern] = STATE(5778),
    [sym_ternary_expression] = STATE(2958),
    [sym_binary_expression] = STATE(2958),
    [sym_unary_expression] = STATE(2958),
    [sym_update_expression] = STATE(2958),
    [sym_string] = STATE(2898),
    [sym_template_string] = STATE(2967),
    [sym_regex] = STATE(2967),
    [sym_meta_property] = STATE(2967),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4721),
    [sym_non_null_expression] = STATE(1486),
    [sym_as_expression] = STATE(2958),
    [sym_internal_module] = STATE(2958),
    [sym_nested_type_identifier] = STATE(3884),
    [sym__type] = STATE(4536),
    [sym_constructor_type] = STATE(4536),
    [sym__primary_type] = STATE(3937),
    [sym_infer_type] = STATE(4536),
    [sym_conditional_type] = STATE(3932),
    [sym_generic_type] = STATE(3932),
    [sym_type_query] = STATE(3932),
    [sym_index_type_query] = STATE(3932),
    [sym_lookup_type] = STATE(3932),
    [sym_literal_type] = STATE(3932),
    [sym__number] = STATE(3942),
    [sym_existential_type] = STATE(3932),
    [sym_flow_maybe_type] = STATE(3932),
    [sym_parenthesized_type] = STATE(3932),
    [sym_predefined_type] = STATE(3932),
    [sym_object_type] = STATE(3932),
    [sym_type_parameters] = STATE(5544),
    [sym_array_type] = STATE(3932),
    [sym_tuple_type] = STATE(3932),
    [sym_readonly_type] = STATE(4536),
    [sym_union_type] = STATE(4536),
    [sym_intersection_type] = STATE(4536),
    [sym_function_type] = STATE(4536),
    [aux_sym_export_statement_repeat1] = STATE(4944),
    [sym_identifier] = ACTIONS(1348),
    [anon_sym_export] = ACTIONS(1350),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_type] = ACTIONS(1350),
    [anon_sym_namespace] = ACTIONS(1352),
    [anon_sym_LBRACE] = ACTIONS(1354),
    [anon_sym_typeof] = ACTIONS(1356),
    [anon_sym_import] = ACTIONS(1262),
    [anon_sym_BANG] = ACTIONS(1358),
    [anon_sym_LPAREN] = ACTIONS(1266),
    [anon_sym_await] = ACTIONS(1360),
    [anon_sym_yield] = ACTIONS(1362),
    [anon_sym_LBRACK] = ACTIONS(1364),
    [anon_sym_LT] = ACTIONS(1274),
    [anon_sym_SLASH] = ACTIONS(1276),
    [anon_sym_class] = ACTIONS(1278),
    [anon_sym_async] = ACTIONS(1366),
    [anon_sym_function] = ACTIONS(1282),
    [anon_sym_new] = ACTIONS(1368),
    [anon_sym_QMARK] = ACTIONS(790),
    [anon_sym_AMP] = ACTIONS(792),
    [anon_sym_PIPE] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(1370),
    [anon_sym_DASH] = ACTIONS(1370),
    [anon_sym_TILDE] = ACTIONS(1358),
    [anon_sym_void] = ACTIONS(1372),
    [anon_sym_delete] = ACTIONS(1374),
    [anon_sym_PLUS_PLUS] = ACTIONS(1376),
    [anon_sym_DASH_DASH] = ACTIONS(1376),
    [anon_sym_DQUOTE] = ACTIONS(1294),
    [anon_sym_SQUOTE] = ACTIONS(1296),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1298),
    [sym_number] = ACTIONS(1378),
    [sym_this] = ACTIONS(1380),
    [sym_super] = ACTIONS(1304),
    [sym_true] = ACTIONS(1382),
    [sym_false] = ACTIONS(1382),
    [sym_null] = ACTIONS(1304),
    [sym_undefined] = ACTIONS(1384),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(1350),
    [anon_sym_readonly] = ACTIONS(1386),
    [anon_sym_get] = ACTIONS(1350),
    [anon_sym_set] = ACTIONS(1350),
    [anon_sym_declare] = ACTIONS(1350),
    [anon_sym_public] = ACTIONS(1350),
    [anon_sym_private] = ACTIONS(1350),
    [anon_sym_protected] = ACTIONS(1350),
    [anon_sym_module] = ACTIONS(1350),
    [anon_sym_any] = ACTIONS(1388),
    [anon_sym_number] = ACTIONS(1388),
    [anon_sym_boolean] = ACTIONS(1388),
    [anon_sym_string] = ACTIONS(1388),
    [anon_sym_symbol] = ACTIONS(1388),
    [anon_sym_infer] = ACTIONS(636),
    [anon_sym_keyof] = ACTIONS(816),
    [anon_sym_LBRACE_PIPE] = ACTIONS(640),
  },
  [102] = {
    [sym_import] = STATE(2475),
    [sym_parenthesized_expression] = STATE(1456),
    [sym_expression] = STATE(2310),
    [sym_primary_expression] = STATE(2482),
    [sym_yield_expression] = STATE(2484),
    [sym_object] = STATE(2475),
    [sym_object_pattern] = STATE(5767),
    [sym_array] = STATE(2475),
    [sym_array_pattern] = STATE(5767),
    [sym_jsx_element] = STATE(2484),
    [sym_jsx_fragment] = STATE(2484),
    [sym_jsx_opening_element] = STATE(4047),
    [sym_jsx_self_closing_element] = STATE(2484),
    [sym_class] = STATE(2475),
    [sym_function] = STATE(2475),
    [sym_generator_function] = STATE(2475),
    [sym_arrow_function] = STATE(2475),
    [sym__call_signature] = STATE(5765),
    [sym_call_expression] = STATE(2475),
    [sym_new_expression] = STATE(2484),
    [sym_await_expression] = STATE(2484),
    [sym_member_expression] = STATE(1456),
    [sym_subscript_expression] = STATE(1456),
    [sym_assignment_expression] = STATE(2484),
    [sym__augmented_assignment_lhs] = STATE(3880),
    [sym_augmented_assignment_expression] = STATE(2484),
    [sym__destructuring_pattern] = STATE(5767),
    [sym_ternary_expression] = STATE(2484),
    [sym_binary_expression] = STATE(2484),
    [sym_unary_expression] = STATE(2484),
    [sym_update_expression] = STATE(2484),
    [sym_string] = STATE(2475),
    [sym_template_string] = STATE(2475),
    [sym_regex] = STATE(2475),
    [sym_meta_property] = STATE(2475),
    [sym_decorator] = STATE(3864),
    [sym_formal_parameters] = STATE(4661),
    [sym_non_null_expression] = STATE(1456),
    [sym_as_expression] = STATE(2484),
    [sym_internal_module] = STATE(2484),
    [sym_type_parameters] = STATE(5504),
    [aux_sym_export_statement_repeat1] = STATE(5016),
    [sym_identifier] = ACTIONS(1390),
    [anon_sym_export] = ACTIONS(934),
    [anon_sym_STAR] = ACTIONS(1392),
    [anon_sym_type] = ACTIONS(934),
    [anon_sym_as] = ACTIONS(1394),
    [anon_sym_namespace] = ACTIONS(936),
    [anon_sym_LBRACE] = ACTIONS(1396),
    [anon_sym_COMMA] = ACTIONS(1398),
    [anon_sym_RBRACE] = ACTIONS(1398),
    [anon_sym_typeof] = ACTIONS(958),
    [anon_sym_import] = ACTIONS(890),
    [anon_sym_BANG] = ACTIONS(1400),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(944),
    [anon_sym_in] = ACTIONS(1394),
    [anon_sym_SEMI] = ACTIONS(1398),
    [anon_sym_yield] = ACTIONS(946),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(1402),
    [anon_sym_GT] = ACTIONS(1394),
    [anon_sym_SLASH] = ACTIONS(902),
    [anon_sym_DOT] = ACTIONS(1394),
    [anon_sym_class] = ACTIONS(904),
    [anon_sym_async] = ACTIONS(950),
    [anon_sym_function] = ACTIONS(908),
    [anon_sym_QMARK_DOT] = ACTIONS(1398),
    [anon_sym_new] = ACTIONS(1404),
    [anon_sym_QMARK] = ACTIONS(1394),
    [anon_sym_AMP_AMP] = ACTIONS(1398),
    [anon_sym_PIPE_PIPE] = ACTIONS(1398),
    [anon_sym_GT_GT] = ACTIONS(1394),
    [anon_sym_GT_GT_GT] = ACTIONS(1398),
    [anon_sym_LT_LT] = ACTIONS(1398),
    [anon_sym_AMP] = ACTIONS(1394),
    [anon_sym_CARET] = ACTIONS(1398),
    [anon_sym_PIPE] = ACTIONS(1394),
    [anon_sym_PLUS] = ACTIONS(1400),
    [anon_sym_DASH] = ACTIONS(1400),
    [anon_sym_PERCENT] = ACTIONS(1398),
    [anon_sym_STAR_STAR] = ACTIONS(1398),
    [anon_sym_LT_EQ] = ACTIONS(1398),
    [anon_sym_EQ_EQ] = ACTIONS(1394),
    [anon_sym_EQ_EQ_EQ] = ACTION