#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 3481
#define LARGE_STATE_COUNT 158
#define SYMBOL_COUNT 164
#define ALIAS_COUNT 0
#define TOKEN_COUNT 103
#define EXTERNAL_TOKEN_COUNT 15
#define FIELD_COUNT 19
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 73

enum {
  sym_word = 1,
  anon_sym_LF = 2,
  anon_sym_for = 3,
  anon_sym_select = 4,
  anon_sym_in = 5,
  anon_sym_LPAREN_LPAREN = 6,
  anon_sym_RPAREN_RPAREN = 7,
  anon_sym_SEMI = 8,
  anon_sym_while = 9,
  anon_sym_until = 10,
  anon_sym_do = 11,
  anon_sym_done = 12,
  anon_sym_if = 13,
  anon_sym_then = 14,
  anon_sym_fi = 15,
  anon_sym_elif = 16,
  anon_sym_else = 17,
  anon_sym_case = 18,
  anon_sym_esac = 19,
  anon_sym_PIPE = 20,
  anon_sym_RPAREN = 21,
  anon_sym_SEMI_SEMI = 22,
  anon_sym_SEMI_AMP = 23,
  anon_sym_SEMI_SEMI_AMP = 24,
  anon_sym_function = 25,
  anon_sym_LPAREN = 26,
  anon_sym_LBRACE = 27,
  anon_sym_RBRACE = 28,
  anon_sym_PIPE_AMP = 29,
  anon_sym_AMP_AMP = 30,
  anon_sym_PIPE_PIPE = 31,
  anon_sym_BANG = 32,
  anon_sym_LBRACK = 33,
  anon_sym_RBRACK = 34,
  anon_sym_LBRACK_LBRACK = 35,
  anon_sym_RBRACK_RBRACK = 36,
  anon_sym_declare = 37,
  anon_sym_typeset = 38,
  anon_sym_export = 39,
  anon_sym_readonly = 40,
  anon_sym_local = 41,
  anon_sym_unset = 42,
  anon_sym_unsetenv = 43,
  anon_sym_EQ_TILDE = 44,
  anon_sym_EQ_EQ = 45,
  anon_sym_EQ = 46,
  anon_sym_PLUS_EQ = 47,
  anon_sym_LT = 48,
  anon_sym_GT = 49,
  anon_sym_GT_GT = 50,
  anon_sym_AMP_GT = 51,
  anon_sym_AMP_GT_GT = 52,
  anon_sym_LT_AMP = 53,
  anon_sym_GT_AMP = 54,
  anon_sym_GT_PIPE = 55,
  anon_sym_LT_LT = 56,
  anon_sym_LT_LT_DASH = 57,
  anon_sym_LT_LT_LT = 58,
  anon_sym_BANG_EQ = 59,
  anon_sym_PLUS = 60,
  anon_sym_DASH = 61,
  anon_sym_DASH_EQ = 62,
  anon_sym_LT_EQ = 63,
  anon_sym_GT_EQ = 64,
  anon_sym_QMARK = 65,
  anon_sym_COLON = 66,
  anon_sym_PLUS_PLUS = 67,
  anon_sym_DASH_DASH = 68,
  anon_sym_DOLLAR = 69,
  sym__special_character = 70,
  anon_sym_DQUOTE = 71,
  sym__string_content = 72,
  sym_raw_string = 73,
  sym_ansii_c_string = 74,
  anon_sym_POUND = 75,
  anon_sym_DOLLAR_LBRACE = 76,
  anon_sym_SLASH = 77,
  anon_sym_COLON_QMARK = 78,
  anon_sym_COLON_DASH = 79,
  anon_sym_PERCENT = 80,
  anon_sym_DOLLAR_LPAREN = 81,
  anon_sym_BQUOTE = 82,
  anon_sym_LT_LPAREN = 83,
  anon_sym_GT_LPAREN = 84,
  sym_comment = 85,
  aux_sym__simple_variable_name_token1 = 86,
  anon_sym_STAR = 87,
  anon_sym_AT = 88,
  anon_sym_0 = 89,
  anon_sym__ = 90,
  sym_test_operator = 91,
  anon_sym_AMP = 92,
  sym_heredoc_start = 93,
  sym__simple_heredoc_body = 94,
  sym__heredoc_body_beginning = 95,
  sym__heredoc_body_middle = 96,
  sym__heredoc_body_end = 97,
  sym_file_descriptor = 98,
  sym__empty_value = 99,
  sym__concat = 100,
  sym_variable_name = 101,
  sym_regex = 102,
  sym_program = 103,
  sym__statements = 104,
  aux_sym__statements2 = 105,
  sym__terminated_statement = 106,
  sym_redirected_statement = 107,
  sym_for_statement = 108,
  sym_c_style_for_statement = 109,
  sym_while_statement = 110,
  sym_do_group = 111,
  sym_if_statement = 112,
  sym_elif_clause = 113,
  sym_else_clause = 114,
  sym_case_statement = 115,
  sym_case_item = 116,
  sym_last_case_item = 117,
  sym_function_definition = 118,
  sym_compound_statement = 119,
  sym_subshell = 120,
  sym_pipeline = 121,
  sym_list = 122,
  sym_negated_command = 123,
  sym_test_command = 124,
  sym_declaration_command = 125,
  sym_unset_command = 126,
  sym_command = 127,
  sym_command_name = 128,
  sym_variable_assignment = 129,
  sym_subscript = 130,
  sym_file_redirect = 131,
  sym_heredoc_redirect = 132,
  sym_heredoc_body = 133,
  sym_herestring_redirect = 134,
  sym__expression = 135,
  sym_binary_expression = 136,
  sym_ternary_expression = 137,
  sym_unary_expression = 138,
  sym_postfix_expression = 139,
  sym_parenthesized_expression = 140,
  sym_concatenation = 141,
  sym_string = 142,
  sym_array = 143,
  sym_simple_expansion = 144,
  sym_string_expansion = 145,
  sym_expansion = 146,
  sym_command_substitution = 147,
  sym_process_substitution = 148,
  aux_sym__statements_repeat1 = 149,
  aux_sym_redirected_statement_repeat1 = 150,
  aux_sym_for_statement_repeat1 = 151,
  aux_sym_if_statement_repeat1 = 152,
  aux_sym_case_statement_repeat1 = 153,
  aux_sym_case_item_repeat1 = 154,
  aux_sym_declaration_command_repeat1 = 155,
  aux_sym_unset_command_repeat1 = 156,
  aux_sym_command_repeat1 = 157,
  aux_sym_command_repeat2 = 158,
  aux_sym_heredoc_body_repeat1 = 159,
  aux_sym__literal_repeat1 = 160,
  aux_sym_concatenation_repeat1 = 161,
  aux_sym_string_repeat1 = 162,
  aux_sym_expansion_repeat1 = 163,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_word] = "word",
  [anon_sym_LF] = "\n",
  [anon_sym_for] = "for",
  [anon_sym_select] = "select",
  [anon_sym_in] = "in",
  [anon_sym_LPAREN_LPAREN] = "((",
  [anon_sym_RPAREN_RPAREN] = "))",
  [anon_sym_SEMI] = ";",
  [anon_sym_while] = "while",
  [anon_sym_until] = "until",
  [anon_sym_do] = "do",
  [anon_sym_done] = "done",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_fi] = "fi",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_case] = "case",
  [anon_sym_esac] = "esac",
  [anon_sym_PIPE] = "|",
  [anon_sym_RPAREN] = ")",
  [anon_sym_SEMI_SEMI] = ";;",
  [anon_sym_SEMI_AMP] = ";&",
  [anon_sym_SEMI_SEMI_AMP] = ";;&",
  [anon_sym_function] = "function",
  [anon_sym_LPAREN] = "(",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_PIPE_AMP] = "|&",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_BANG] = "!",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym_declare] = "declare",
  [anon_sym_typeset] = "typeset",
  [anon_sym_export] = "export",
  [anon_sym_readonly] = "readonly",
  [anon_sym_local] = "local",
  [anon_sym_unset] = "unset",
  [anon_sym_unsetenv] = "unsetenv",
  [anon_sym_EQ_TILDE] = "=~",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_AMP_GT] = "&>",
  [anon_sym_AMP_GT_GT] = "&>>",
  [anon_sym_LT_AMP] = "<&",
  [anon_sym_GT_AMP] = ">&",
  [anon_sym_GT_PIPE] = ">|",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_LT_LT_DASH] = "<<-",
  [anon_sym_LT_LT_LT] = "<<<",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COLON] = ":",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DOLLAR] = "$",
  [sym__special_character] = "_special_character",
  [anon_sym_DQUOTE] = "\"",
  [sym__string_content] = "_string_content",
  [sym_raw_string] = "raw_string",
  [sym_ansii_c_string] = "ansii_c_string",
  [anon_sym_POUND] = "#",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH] = "/",
  [anon_sym_COLON_QMARK] = ":\?",
  [anon_sym_COLON_DASH] = ":-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOLLAR_LPAREN] = "$(",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_LT_LPAREN] = "<(",
  [anon_sym_GT_LPAREN] = ">(",
  [sym_comment] = "comment",
  [aux_sym__simple_variable_name_token1] = "variable_name",
  [anon_sym_STAR] = "special_variable_name",
  [anon_sym_AT] = "special_variable_name",
  [anon_sym_0] = "special_variable_name",
  [anon_sym__] = "special_variable_name",
  [sym_test_operator] = "test_operator",
  [anon_sym_AMP] = "&",
  [sym_heredoc_start] = "heredoc_start",
  [sym__simple_heredoc_body] = "_simple_heredoc_body",
  [sym__heredoc_body_beginning] = "_heredoc_body_beginning",
  [sym__heredoc_body_middle] = "_heredoc_body_middle",
  [sym__heredoc_body_end] = "_heredoc_body_end",
  [sym_file_descriptor] = "file_descriptor",
  [sym__empty_value] = "_empty_value",
  [sym__concat] = "_concat",
  [sym_variable_name] = "variable_name",
  [sym_regex] = "regex",
  [sym_program] = "program",
  [sym__statements] = "_statements",
  [aux_sym__statements2] = "_statements2",
  [sym__terminated_statement] = "_terminated_statement",
  [sym_redirected_statement] = "redirected_statement",
  [sym_for_statement] = "for_statement",
  [sym_c_style_for_statement] = "c_style_for_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_group] = "do_group",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_case_statement] = "case_statement",
  [sym_case_item] = "case_item",
  [sym_last_case_item] = "case_item",
  [sym_function_definition] = "function_definition",
  [sym_compound_statement] = "compound_statement",
  [sym_subshell] = "subshell",
  [sym_pipeline] = "pipeline",
  [sym_list] = "list",
  [sym_negated_command] = "negated_command",
  [sym_test_command] = "test_command",
  [sym_declaration_command] = "declaration_command",
  [sym_unset_command] = "unset_command",
  [sym_command] = "command",
  [sym_command_name] = "command_name",
  [sym_variable_assignment] = "variable_assignment",
  [sym_subscript] = "subscript",
  [sym_file_redirect] = "file_redirect",
  [sym_heredoc_redirect] = "heredoc_redirect",
  [sym_heredoc_body] = "heredoc_body",
  [sym_herestring_redirect] = "herestring_redirect",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_postfix_expression] = "postfix_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_concatenation] = "concatenation",
  [sym_string] = "string",
  [sym_array] = "array",
  [sym_simple_expansion] = "simple_expansion",
  [sym_string_expansion] = "string_expansion",
  [sym_expansion] = "expansion",
  [sym_command_substitution] = "command_substitution",
  [sym_process_substitution] = "process_substitution",
  [aux_sym__statements_repeat1] = "_statements_repeat1",
  [aux_sym_redirected_statement_repeat1] = "redirected_statement_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym_case_item_repeat1] = "case_item_repeat1",
  [aux_sym_declaration_command_repeat1] = "declaration_command_repeat1",
  [aux_sym_unset_command_repeat1] = "unset_command_repeat1",
  [aux_sym_command_repeat1] = "command_repeat1",
  [aux_sym_command_repeat2] = "command_repeat2",
  [aux_sym_heredoc_body_repeat1] = "heredoc_body_repeat1",
  [aux_sym__literal_repeat1] = "_literal_repeat1",
  [aux_sym_concatenation_repeat1] = "concatenation_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_expansion_repeat1] = "expansion_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_word] = sym_word,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_select] = anon_sym_select,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_LPAREN_LPAREN] = anon_sym_LPAREN_LPAREN,
  [anon_sym_RPAREN_RPAREN] = anon_sym_RPAREN_RPAREN,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_until] = anon_sym_until,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_done] = anon_sym_done,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_fi] = anon_sym_fi,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_esac] = anon_sym_esac,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_SEMI_SEMI] = anon_sym_SEMI_SEMI,
  [anon_sym_SEMI_AMP] = anon_sym_SEMI_AMP,
  [anon_sym_SEMI_SEMI_AMP] = anon_sym_SEMI_SEMI_AMP,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_PIPE_AMP] = anon_sym_PIPE_AMP,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACK_LBRACK] = anon_sym_LBRACK_LBRACK,
  [anon_sym_RBRACK_RBRACK] = anon_sym_RBRACK_RBRACK,
  [anon_sym_declare] = anon_sym_declare,
  [anon_sym_typeset] = anon_sym_typeset,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_readonly] = anon_sym_readonly,
  [anon_sym_local] = anon_sym_local,
  [anon_sym_unset] = anon_sym_unset,
  [anon_sym_unsetenv] = anon_sym_unsetenv,
  [anon_sym_EQ_TILDE] = anon_sym_EQ_TILDE,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_AMP_GT] = anon_sym_AMP_GT,
  [anon_sym_AMP_GT_GT] = anon_sym_AMP_GT_GT,
  [anon_sym_LT_AMP] = anon_sym_LT_AMP,
  [anon_sym_GT_AMP] = anon_sym_GT_AMP,
  [anon_sym_GT_PIPE] = anon_sym_GT_PIPE,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_LT_LT_DASH] = anon_sym_LT_LT_DASH,
  [anon_sym_LT_LT_LT] = anon_sym_LT_LT_LT,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [sym__special_character] = sym__special_character,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym__string_content] = sym__string_content,
  [sym_raw_string] = sym_raw_string,
  [sym_ansii_c_string] = sym_ansii_c_string,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_COLON_QMARK] = anon_sym_COLON_QMARK,
  [anon_sym_COLON_DASH] = anon_sym_COLON_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_DOLLAR_LPAREN] = anon_sym_DOLLAR_LPAREN,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_LT_LPAREN] = anon_sym_LT_LPAREN,
  [anon_sym_GT_LPAREN] = anon_sym_GT_LPAREN,
  [sym_comment] = sym_comment,
  [aux_sym__simple_variable_name_token1] = sym_variable_name,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_AT] = anon_sym_STAR,
  [anon_sym_0] = anon_sym_STAR,
  [anon_sym__] = anon_sym_STAR,
  [sym_test_operator] = sym_test_operator,
  [anon_sym_AMP] = anon_sym_AMP,
  [sym_heredoc_start] = sym_heredoc_start,
  [sym__simple_heredoc_body] = sym__simple_heredoc_body,
  [sym__heredoc_body_beginning] = sym__heredoc_body_beginning,
  [sym__heredoc_body_middle] = sym__heredoc_body_middle,
  [sym__heredoc_body_end] = sym__heredoc_body_end,
  [sym_file_descriptor] = sym_file_descriptor,
  [sym__empty_value] = sym__empty_value,
  [sym__concat] = sym__concat,
  [sym_variable_name] = sym_variable_name,
  [sym_regex] = sym_regex,
  [sym_program] = sym_program,
  [sym__statements] = sym__statements,
  [aux_sym__statements2] = aux_sym__statements2,
  [sym__terminated_statement] = sym__terminated_statement,
  [sym_redirected_statement] = sym_redirected_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_c_style_for_statement] = sym_c_style_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_do_group] = sym_do_group,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_case_statement] = sym_case_statement,
  [sym_case_item] = sym_case_item,
  [sym_last_case_item] = sym_case_item,
  [sym_function_definition] = sym_function_definition,
  [sym_compound_statement] = sym_compound_statement,
  [sym_subshell] = sym_subshell,
  [sym_pipeline] = sym_pipeline,
  [sym_list] = sym_list,
  [sym_negated_command] = sym_negated_command,
  [sym_test_command] = sym_test_command,
  [sym_declaration_command] = sym_declaration_command,
  [sym_unset_command] = sym_unset_command,
  [sym_command] = sym_command,
  [sym_command_name] = sym_command_name,
  [sym_variable_assignment] = sym_variable_assignment,
  [sym_subscript] = sym_subscript,
  [sym_file_redirect] = sym_file_redirect,
  [sym_heredoc_redirect] = sym_heredoc_redirect,
  [sym_heredoc_body] = sym_heredoc_body,
  [sym_herestring_redirect] = sym_herestring_redirect,
  [sym__expression] = sym__expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_postfix_expression] = sym_postfix_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_concatenation] = sym_concatenation,
  [sym_string] = sym_string,
  [sym_array] = sym_array,
  [sym_simple_expansion] = sym_simple_expansion,
  [sym_string_expansion] = sym_string_expansion,
  [sym_expansion] = sym_expansion,
  [sym_command_substitution] = sym_command_substitution,
  [sym_process_substitution] = sym_process_substitution,
  [aux_sym__statements_repeat1] = aux_sym__statements_repeat1,
  [aux_sym_redirected_statement_repeat1] = aux_sym_redirected_statement_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_case_statement_repeat1] = aux_sym_case_statement_repeat1,
  [aux_sym_case_item_repeat1] = aux_sym_case_item_repeat1,
  [aux_sym_declaration_command_repeat1] = aux_sym_declaration_command_repeat1,
  [aux_sym_unset_command_repeat1] = aux_sym_unset_command_repeat1,
  [aux_sym_command_repeat1] = aux_sym_command_repeat1,
  [aux_sym_command_repeat2] = aux_sym_command_repeat2,
  [aux_sym_heredoc_body_repeat1] = aux_sym_heredoc_body_repeat1,
  [aux_sym__literal_repeat1] = aux_sym__literal_repeat1,
  [aux_sym_concatenation_repeat1] = aux_sym_concatenation_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_expansion_repeat1] = aux_sym_expansion_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_word] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_select] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_until] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_done] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_esac] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI_SEMI_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsetenv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym__special_character] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_string] = {
    .visible = true,
    .named = true,
  },
  [sym_ansii_c_string] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__simple_variable_name_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__] = {
    .visible = true,
    .named = true,
  },
  [sym_test_operator] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [sym_heredoc_start] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_heredoc_body] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_beginning] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_middle] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_end] = {
    .visible = false,
    .named = true,
  },
  [sym_file_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_value] = {
    .visible = false,
    .named = true,
  },
  [sym__concat] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_name] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__statements] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__statements2] = {
    .visible = false,
    .named = false,
  },
  [sym__terminated_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_redirected_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_c_style_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_group] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_item] = {
    .visible = true,
    .named = true,
  },
  [sym_last_case_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_subshell] = {
    .visible = true,
    .named = true,
  },
  [sym_pipeline] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_negated_command] = {
    .visible = true,
    .named = true,
  },
  [sym_test_command] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_command] = {
    .visible = true,
    .named = true,
  },
  [sym_unset_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_file_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_body] = {
    .visible = true,
    .named = true,
  },
  [sym_herestring_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_string_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_command_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_process_substitution] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_redirected_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_item_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unset_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_heredoc_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expansion_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_argument = 2,
  field_body = 3,
  field_condition = 4,
  field_consequence = 5,
  field_descriptor = 6,
  field_destination = 7,
  field_fallthrough = 8,
  field_index = 9,
  field_initializer = 10,
  field_left = 11,
  field_name = 12,
  field_operator = 13,
  field_redirect = 14,
  field_right = 15,
  field_termination = 16,
  field_update = 17,
  field_value = 18,
  field_variable = 19,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_descriptor] = "descriptor",
  [field_destination] = "destination",
  [field_fallthrough] = "fallthrough",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_left] = "left",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_redirect] = "redirect",
  [field_right] = "right",
  [field_termination] = "termination",
  [field_update] = "update",
  [field_value] = "value",
  [field_variable] = "variable",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 1, .length = 1},
  [6] = {.index = 2, .length = 2},
  [7] = {.index = 4, .length = 1},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 4, .length = 1},
  [10] = {.index = 7, .length = 1},
  [11] = {.index = 8, .length = 2},
  [12] = {.index = 8, .length = 2},
  [13] = {.index = 10, .length = 2},
  [14] = {.index = 10, .length = 2},
  [15] = {.index = 12, .length = 2},
  [16] = {.index = 14, .length = 2},
  [18] = {.index = 16, .length = 2},
  [19] = {.index = 16, .length = 2},
  [20] = {.index = 18, .length = 2},
  [21] = {.index = 20, .length = 2},
  [22] = {.index = 22, .length = 2},
  [23] = {.index = 22, .length = 2},
  [24] = {.index = 24, .length = 2},
  [25] = {.index = 26, .length = 3},
  [26] = {.index = 29, .length = 1},
  [28] = {.index = 30, .length = 2},
  [29] = {.index = 32, .length = 1},
  [30] = {.index = 32, .length = 1},
  [31] = {.index = 33, .length = 2},
  [33] = {.index = 35, .length = 1},
  [34] = {.index = 36, .length = 3},
  [35] = {.index = 39, .length = 3},
  [36] = {.index = 42, .length = 1},
  [37] = {.index = 42, .length = 1},
  [39] = {.index = 43, .length = 1},
  [40] = {.index = 44, .length = 2},
  [41] = {.index = 46, .length = 2},
  [42] = {.index = 48, .length = 2},
  [43] = {.index = 50, .length = 2},
  [44] = {.index = 52, .length = 2},
  [45] = {.index = 54, .length = 2},
  [46] = {.index = 56, .length = 2},
  [47] = {.index = 50, .length = 2},
  [48] = {.index = 52, .length = 2},
  [49] = {.index = 54, .length = 2},
  [50] = {.index = 58, .length = 2},
  [51] = {.index = 60, .length = 2},
  [52] = {.index = 62, .length = 3},
  [53] = {.index = 65, .length = 2},
  [54] = {.index = 67, .length = 3},
  [55] = {.index = 70, .length = 3},
  [56] = {.index = 73, .length = 2},
  [57] = {.index = 75, .length = 2},
  [58] = {.index = 77, .length = 3},
  [59] = {.index = 80, .length = 3},
  [60] = {.index = 73, .length = 2},
  [61] = {.index = 75, .length = 2},
  [62] = {.index = 77, .length = 3},
  [63] = {.index = 80, .length = 3},
  [64] = {.index = 83, .length = 3},
  [65] = {.index = 86, .length = 3},
  [66] = {.index = 89, .length = 3},
  [67] = {.index = 92, .length = 4},
  [68] = {.index = 96, .length = 3},
  [69] = {.index = 99, .length = 3},
  [70] = {.index = 96, .length = 3},
  [71] = {.index = 99, .length = 3},
  [72] = {.index = 102, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_destination, 1},
  [2] =
    {field_body, 0},
    {field_redirect, 1},
  [4] =
    {field_argument, 0},
  [5] =
    {field_argument, 1, .inherited = true},
    {field_name, 0},
  [7] =
    {field_name, 1},
  [8] =
    {field_descriptor, 0},
    {field_destination, 2},
  [10] =
    {field_name, 0},
    {field_value, 2},
  [12] =
    {field_body, 2},
    {field_condition, 1},
  [14] =
    {field_body, 2},
    {field_name, 1},
  [16] =
    {field_argument, 0},
    {field_argument, 1},
  [18] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [20] =
    {field_argument, 2, .inherited = true},
    {field_name, 1},
  [22] =
    {field_index, 2},
    {field_name, 0},
  [24] =
    {field_body, 3},
    {field_variable, 1},
  [26] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [29] =
    {field_condition, 1},
  [30] =
    {field_body, 3},
    {field_name, 0},
  [32] =
    {field_value, 1},
  [33] =
    {field_body, 4},
    {field_name, 1},
  [35] =
    {field_body, 5},
  [36] =
    {field_body, 5},
    {field_value, 3},
    {field_variable, 1},
  [39] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [42] =
    {field_value, 0},
  [43] =
    {field_body, 6},
  [44] =
    {field_body, 6},
    {field_update, 4},
  [46] =
    {field_body, 6},
    {field_condition, 3},
  [48] =
    {field_body, 6},
    {field_initializer, 2},
  [50] =
    {field_termination, 2},
    {field_value, 0},
  [52] =
    {field_fallthrough, 2},
    {field_value, 0},
  [54] =
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [56] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [58] =
    {field_body, 7},
    {field_update, 4},
  [60] =
    {field_body, 7},
    {field_condition, 3},
  [62] =
    {field_body, 7},
    {field_condition, 3},
    {field_update, 5},
  [65] =
    {field_body, 7},
    {field_initializer, 2},
  [67] =
    {field_body, 7},
    {field_initializer, 2},
    {field_update, 5},
  [70] =
    {field_body, 7},
    {field_condition, 4},
    {field_initializer, 2},
  [73] =
    {field_termination, 3},
    {field_value, 0},
  [75] =
    {field_fallthrough, 3},
    {field_value, 0},
  [77] =
    {field_termination, 3},
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [80] =
    {field_fallthrough, 3},
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [83] =
    {field_body, 8},
    {field_condition, 3},
    {field_update, 5},
  [86] =
    {field_body, 8},
    {field_initializer, 2},
    {field_update, 5},
  [89] =
    {field_body, 8},
    {field_condition, 4},
    {field_initializer, 2},
  [92] =
    {field_body, 8},
    {field_condition, 4},
    {field_initializer, 2},
    {field_update, 6},
  [96] =
    {field_termination, 4},
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [99] =
    {field_fallthrough, 4},
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [102] =
    {field_body, 9},
    {field_condition, 4},
    {field_initializer, 2},
    {field_update, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [0] = sym_word,
  },
  [4] = {
    [1] = sym_word,
  },
  [5] = {
    [1] = anon_sym_STAR,
  },
  [9] = {
    [0] = sym_word,
  },
  [12] = {
    [2] = sym_word,
  },
  [14] = {
    [2] = sym_word,
  },
  [17] = {
    [1] = sym_word,
  },
  [19] = {
    [1] = sym_word,
  },
  [23] = {
    [2] = sym_word,
  },
  [27] = {
    [2] = anon_sym_STAR,
  },
  [30] = {
    [1] = sym_word,
  },
  [32] = {
    [3] = sym_word,
  },
  [37] = {
    [0] = sym_word,
  },
  [38] = {
    [4] = sym_word,
  },
  [47] = {
    [0] = sym_word,
  },
  [48] = {
    [0] = sym_word,
  },
  [49] = {
    [0] = sym_word,
  },
  [60] = {
    [0] = sym_word,
  },
  [61] = {
    [0] = sym_word,
  },
  [62] = {
    [0] = sym_word,
  },
  [63] = {
    [0] = sym_word,
  },
  [70] = {
    [0] = sym_word,
  },
  [71] = {
    [0] = sym_word,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__literal_repeat1, 2,
    aux_sym__literal_repeat1,
    sym_word,
  0,
};

static inline bool sym_word_character_set_1(int32_t c) {
  return (c < '&'
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : (c <= '\n' || c == '\r'))
      : (c <= ' ' || (c < '$'
        ? c == '"'
        : c <= '$')))
    : (c <= ')' || (c < '['
      ? (c < '>'
        ? (c >= ';' && c <= '<')
        : c <= '>')
      : (c <= ']' || (c < '{'
        ? c == '`'
        : c <= '}')))));
}

static inline bool sym_word_character_set_2(int32_t c) {
  return (c < '$'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '"')))
    : (c <= '$' || (c < '>'
      ? (c < ';'
        ? (c >= '&' && c <= ')')
        : c <= '<')
      : (c <= '>' || (c < '`'
        ? (c >= '[' && c <= ']')
        : c <= '}')))));
}

static inline bool sym_word_character_set_3(int32_t c) {
  return (c < '$'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '"')))
    : (c <= '$' || (c < '['
      ? (c < ';'
        ? (c >= '&' && c <= ')')
        : c <= '>')
      : (c <= ']' || (c < '{'
        ? c == '`'
        : c <= '}')))));
}

static inline bool sym_word_character_set_4(int32_t c) {
  return (c < '$'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '"')))
    : (c <= '$' || (c < '['
      ? (c < ';'
        ? (c >= '&' && c <= ')')
        : c <= '>')
      : (c <= ']' || (c >= '`' && c <= '}')))));
}

static inline bool sym_word_character_set_5(int32_t c) {
  return (c < '&'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\t')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '$')))
    : (c <= ')' || (c < '['
      ? (c < '>'
        ? (c >= ';' && c <= '<')
        : c <= '>')
      : (c <= ']' || (c >= '`' && c <= '}')))));
}

static inline bool sym_word_character_set_6(int32_t c) {
  return (c < ';'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\t')
      : (c <= '\r' || (c < '&'
        ? (c >= ' ' && c <= '$')
        : c <= ')')))
    : (c <= '<' || (c < '`'
      ? (c < '['
        ? c == '>'
        : c <= ']')
      : (c <= '`' || (c >= '{' && c <= '}')))));
}

static inline bool sym_word_character_set_7(int32_t c) {
  return (c < '&'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\t')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '$')))
    : (c <= ')' || (c < '`'
      ? (c < '['
        ? (c >= ';' && c <= '>')
        : c <= ']')
      : (c <= '`' || (c >= '{' && c <= '}')))));
}

static inline bool sym_word_character_set_8(int32_t c) {
  return (c < '&'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\t')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '$')))
    : (c <= ')' || (c < '['
      ? (c < '>'
        ? (c >= ';' && c <= '<')
        : c <= '>')
      : (c <= ']' || (c < '{'
        ? c == '`'
        : c <= '}')))));
}

static inline bool sym_word_character_set_9(int32_t c) {
  return (c < ';'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '&'
        ? (c >= ' ' && c <= '$')
        : c <= ')')))
    : (c <= '<' || (c < '`'
      ? (c < '['
        ? c == '>'
        : c <= ']')
      : (c <= '`' || (c >= '{' && c <= '}')))));
}

static inline bool sym_word_character_set_10(int32_t c) {
  return (c < '"'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || c == ' '))
    : (c <= ')' || (c < '`'
      ? (c < '['
        ? (c >= ';' && c <= '>')
        : c <= ']')
      : (c <= '`' || (c >= '{' && c <= '}')))));
}

static inline bool sym_word_character_set_11(int32_t c) {
  return (c < '&'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '$')))
    : (c <= ')' || (c < '['
      ? (c < '>'
        ? (c >= ';' && c <= '<')
        : c <= '>')
      : (c <= ']' || (c < '{'
        ? c == '`'
        : c <= '}')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(204);
      if (lookahead == '!') ADVANCE(263);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '+') ADVANCE(302);
      if (lookahead == '-') ADVANCE(305);
      if (lookahead == '/') ADVANCE(341);
      if (lookahead == '0') ADVANCE(366);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '=') ADVANCE(276);
      if (lookahead == '>') ADVANCE(287);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(131);
      if (lookahead == ']') ADVANCE(268);
      if (lookahead == '_') ADVANCE(369);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'd') ADVANCE(418);
      if (lookahead == 'e') ADVANCE(414);
      if (lookahead == 'f') ADVANCE(412);
      if (lookahead == 'i') ADVANCE(416);
      if (lookahead == 't') ADVANCE(411);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(76)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(79)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(81)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(80)
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(82)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(83)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(8)
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(205);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(137);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'e') ADVANCE(354);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(60)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(61)
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(62)
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(63)
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(64)
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(65)
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(66)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(67)
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(68)
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(69)
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(70)
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(95)
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(71)
      END_STATE();
    case 22:
      if (lookahead == '\n') SKIP(72)
      END_STATE();
    case 23:
      if (lookahead == '\n') SKIP(73)
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(25)
      END_STATE();
    case 25:
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(285);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') SKIP(165)
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == 'e') ADVANCE(359);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 26:
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(285);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') SKIP(166)
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 27:
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '&') ADVANCE(424);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') SKIP(175)
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == 'i') ADVANCE(358);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 28:
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(285);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') SKIP(170)
      if (lookahead == 'e') ADVANCE(129);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      END_STATE();
    case 29:
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '&') ADVANCE(424);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '\\') SKIP(181)
      if (lookahead == 'e') ADVANCE(129);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(29)
      END_STATE();
    case 30:
      if (lookahead == '\n') SKIP(26)
      END_STATE();
    case 31:
      if (lookahead == '\n') SKIP(96)
      END_STATE();
    case 32:
      if (lookahead == '\n') SKIP(33)
      END_STATE();
    case 33:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '!') ADVANCE(264);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '&') ADVANCE(425);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') SKIP(167)
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 34:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '!') ADVANCE(113);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '&') ADVANCE(425);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') SKIP(171)
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(34)
      END_STATE();
    case 35:
      if (lookahead == '\n') SKIP(36)
      END_STATE();
    case 36:
      if (lookahead == '\n') ADVANCE(208);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(424);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(255);
      if (lookahead == '-') ADVANCE(420);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(154);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(36)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 37:
      if (lookahead == '\n') SKIP(89)
      END_STATE();
    case 38:
      if (lookahead == '\n') SKIP(78)
      END_STATE();
    case 39:
      if (lookahead == '\n') SKIP(88)
      END_STATE();
    case 40:
      if (lookahead == '\n') SKIP(84)
      END_STATE();
    case 41:
      if (lookahead == '\n') SKIP(93)
      END_STATE();
    case 42:
      if (lookahead == '\n') SKIP(94)
      END_STATE();
    case 43:
      if (lookahead == '\n') SKIP(77)
      END_STATE();
    case 44:
      if (lookahead == '\n') SKIP(28)
      END_STATE();
    case 45:
      if (lookahead == '\n') SKIP(34)
      END_STATE();
    case 46:
      if (lookahead == '\n') SKIP(74)
      END_STATE();
    case 47:
      if (lookahead == '\n') SKIP(75)
      END_STATE();
    case 48:
      if (lookahead == '\n') SKIP(99)
      END_STATE();
    case 49:
      if (lookahead == '\n') SKIP(90)
      END_STATE();
    case 50:
      if (lookahead == '\n') SKIP(91)
      END_STATE();
    case 51:
      if (lookahead == '\n') SKIP(92)
      END_STATE();
    case 52:
      if (lookahead == '\n') SKIP(97)
      END_STATE();
    case 53:
      if (lookahead == '\n') SKIP(98)
      END_STATE();
    case 54:
      if (lookahead == '\n') SKIP(27)
      END_STATE();
    case 55:
      if (lookahead == '\n') SKIP(85)
      END_STATE();
    case 56:
      if (lookahead == '\n') SKIP(101)
      END_STATE();
    case 57:
      if (lookahead == '\n') SKIP(29)
      END_STATE();
    case 58:
      if (lookahead == '\n') SKIP(102)
      END_STATE();
    case 59:
      if (lookahead == '\n') SKIP(103)
      END_STATE();
    case 60:
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(138);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(60)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 61:
      if (lookahead == '\n') ADVANCE(210);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(139);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'e') ADVANCE(354);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(61)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 62:
      if (lookahead == '\n') ADVANCE(211);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(140);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(62)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(421);
      END_STATE();
    case 63:
      if (lookahead == '\n') ADVANCE(212);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(255);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(141);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'e') ADVANCE(419);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(63)
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 64:
      if (lookahead == '\n') ADVANCE(213);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(142);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'e') ADVANCE(354);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(64)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 65:
      if (lookahead == '\n') ADVANCE(214);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(143);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(65)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 66:
      if (lookahead == '\n') ADVANCE(215);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(255);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(144);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(66)
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 67:
      if (lookahead == '\n') ADVANCE(216);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(145);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(67)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(421);
      END_STATE();
    case 68:
      if (lookahead == '\n') ADVANCE(217);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(146);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(68)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 69:
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(255);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(69)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 70:
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(70)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(421);
      END_STATE();
    case 71:
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(150);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'e') ADVANCE(419);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(71)
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 72:
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(151);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(72)
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 73:
      if (lookahead == '\n') ADVANCE(222);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(152);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(73)
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(421);
      END_STATE();
    case 74:
      if (lookahead == '\n') ADVANCE(223);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(424);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(160);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(74)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 75:
      if (lookahead == '\n') ADVANCE(224);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(424);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(161);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(75)
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 76:
      if (lookahead == '!') ADVANCE(263);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '+') ADVANCE(302);
      if (lookahead == '-') ADVANCE(305);
      if (lookahead == '/') ADVANCE(341);
      if (lookahead == '0') ADVANCE(366);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '=') ADVANCE(276);
      if (lookahead == '>') ADVANCE(287);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(131);
      if (lookahead == ']') ADVANCE(268);
      if (lookahead == '_') ADVANCE(369);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'd') ADVANCE(418);
      if (lookahead == 'e') ADVANCE(414);
      if (lookahead == 'f') ADVANCE(412);
      if (lookahead == 'i') ADVANCE(416);
      if (lookahead == 't') ADVANCE(411);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(76)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 77:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(159);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(77)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 78:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(78)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 79:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(132);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(79)
      if (lookahead != 0 &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 80:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(134);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'e') ADVANCE(419);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(80)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 81:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(133);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'e') ADVANCE(415);
      if (lookahead == 'f') ADVANCE(412);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(81)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 82:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(135);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'f') ADVANCE(412);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(82)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 83:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(136);
      if (lookahead == ']') ADVANCE(323);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(83)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 84:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(255);
      if (lookahead == ')') ADVANCE(112);
      if (lookahead == '-') ADVANCE(420);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(156);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(84)
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 85:
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') SKIP(176)
      if (lookahead == ']') ADVANCE(268);
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '|') ADVANCE(247);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(85)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 86:
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') ADVANCE(177);
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(330);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(333);
      END_STATE();
    case 87:
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') ADVANCE(179);
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(331);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '`') ADVANCE(333);
      END_STATE();
    case 88:
      if (lookahead == '!') ADVANCE(264);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') SKIP(169)
      if (lookahead == ']') ADVANCE(268);
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(88)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 89:
      if (lookahead == '!') ADVANCE(264);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(112);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == ':') ADVANCE(314);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') SKIP(168)
      if (lookahead == ']') ADVANCE(116);
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(89)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 90:
      if (lookahead == '!') ADVANCE(113);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '(') ADVANCE(109);
      if (lookahead == ')') ADVANCE(112);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == ':') ADVANCE(314);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') SKIP(172)
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(90)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 91:
      if (lookahead == '!') ADVANCE(113);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') SKIP(173)
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(91)
      END_STATE();
    case 92:
      if (lookahead == '!') ADVANCE(113);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '[' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') SKIP(174)
      if (lookahead == ']') ADVANCE(268);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(92)
      END_STATE();
    case 93:
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '/') ADVANCE(341);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(157);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(93)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 94:
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(158);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(94)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 95:
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(95)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 96:
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(255);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(153);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(96)
      if (lookahead != 0 &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 97:
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(163);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(97)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 98:
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '[' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(164);
      if (lookahead == ']') ADVANCE(268);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(98)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 99:
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(162);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'e') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(99)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 100:
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(327);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '\\') ADVANCE(180);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(332);
      if (lookahead != 0) ADVANCE(333);
      END_STATE();
    case 101:
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '+') ADVANCE(114);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == '<') ADVANCE(281);
      if (lookahead == '=') ADVANCE(275);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') SKIP(178)
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(101)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 102:
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '+') ADVANCE(114);
      if (lookahead == ';') ADVANCE(230);
      if (lookahead == '=') ADVANCE(275);
      if (lookahead == '[') ADVANCE(266);
      if (lookahead == '\\') SKIP(182)
      if (lookahead == 'd') ADVANCE(128);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(102)
      END_STATE();
    case 103:
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(323);
      if (lookahead == '\\') SKIP(183)
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(103)
      END_STATE();
    case 104:
      if (lookahead == '&') ADVANCE(260);
      END_STATE();
    case 105:
      if (lookahead == '&') ADVANCE(253);
      if (lookahead == ';') ADVANCE(252);
      END_STATE();
    case 106:
      if (lookahead == '\'') ADVANCE(335);
      if (lookahead != 0) ADVANCE(106);
      END_STATE();
    case 107:
      if (lookahead == '\'') ADVANCE(336);
      if (lookahead == '\\') ADVANCE(108);
      if (lookahead != 0) ADVANCE(107);
      END_STATE();
    case 108:
      if (lookahead == '\'') ADVANCE(337);
      if (lookahead == '\\') ADVANCE(108);
      if (lookahead != 0) ADVANCE(107);
      END_STATE();
    case 109:
      if (lookahead == '(') ADVANCE(228);
      END_STATE();
    case 110:
      if (lookahead == '(') ADVANCE(347);
      END_STATE();
    case 111:
      if (lookahead == '(') ADVANCE(348);
      END_STATE();
    case 112:
      if (lookahead == ')') ADVANCE(229);
      END_STATE();
    case 113:
      if (lookahead == '=') ADVANCE(300);
      END_STATE();
    case 114:
      if (lookahead == '=') ADVANCE(279);
      END_STATE();
    case 115:
      if (lookahead == '>') ADVANCE(292);
      END_STATE();
    case 116:
      if (lookahead == ']') ADVANCE(270);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(118);
      END_STATE();
    case 118:
      if (lookahead == 'c') ADVANCE(243);
      END_STATE();
    case 119:
      if (lookahead == 'e') ADVANCE(241);
      END_STATE();
    case 120:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 121:
      if (lookahead == 'f') ADVANCE(239);
      END_STATE();
    case 122:
      if (lookahead == 'h') ADVANCE(120);
      END_STATE();
    case 123:
      if (lookahead == 'i') ADVANCE(237);
      END_STATE();
    case 124:
      if (lookahead == 'i') ADVANCE(121);
      if (lookahead == 's') ADVANCE(119);
      END_STATE();
    case 125:
      if (lookahead == 'l') ADVANCE(124);
      if (lookahead == 's') ADVANCE(117);
      END_STATE();
    case 126:
      if (lookahead == 'n') ADVANCE(225);
      END_STATE();
    case 127:
      if (lookahead == 'n') ADVANCE(235);
      END_STATE();
    case 128:
      if (lookahead == 'o') ADVANCE(233);
      END_STATE();
    case 129:
      if (lookahead == 's') ADVANCE(117);
      END_STATE();
    case 130:
      if (lookahead == '|') ADVANCE(261);
      END_STATE();
    case 131:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(76)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(389);
      if (lookahead == '\r') SKIP(1)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 132:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(79)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(393);
      if (lookahead == '\r') SKIP(2)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 133:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(81)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(394);
      if (lookahead == '\r') SKIP(3)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 134:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(80)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(395);
      if (lookahead == '\r') SKIP(4)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 135:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(82)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(396);
      if (lookahead == '\r') SKIP(5)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 136:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(83)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(397);
      if (lookahead == '\r') SKIP(6)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 137:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(8)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(371);
      if (lookahead == '\r') SKIP(7)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 138:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(60)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(373);
      if (lookahead == '\r') SKIP(9)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 139:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(61)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(374);
      if (lookahead == '\r') SKIP(10)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 140:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(62)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(375);
      if (lookahead == '\r') SKIP(11)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 141:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(63)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(376);
      if (lookahead == '\r') SKIP(12)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 142:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(64)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(377);
      if (lookahead == '\r') SKIP(13)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 143:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(65)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(378);
      if (lookahead == '\r') SKIP(14)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 144:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(66)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(379);
      if (lookahead == '\r') SKIP(15)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 145:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(67)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(380);
      if (lookahead == '\r') SKIP(16)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 146:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(68)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(381);
      if (lookahead == '\r') SKIP(17)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 147:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(69)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(382);
      if (lookahead == '\r') SKIP(18)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 148:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(70)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(383);
      if (lookahead == '\r') SKIP(19)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 149:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(95)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(400);
      if (lookahead == '\r') SKIP(20)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 150:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(71)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(384);
      if (lookahead == '\r') SKIP(21)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 151:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(72)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(385);
      if (lookahead == '\r') SKIP(22)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 152:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(73)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(386);
      if (lookahead == '\r') SKIP(23)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 153:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(96)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(401);
      if (lookahead == '\r') SKIP(31)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 154:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(36)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(372);
      if (lookahead == '\r') SKIP(35)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 155:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(78)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(391);
      if (lookahead == '\r') SKIP(38)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 156:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(84)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(392);
      if (lookahead == '\r') SKIP(40)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 157:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(93)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(398);
      if (lookahead == '\r') SKIP(41)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 158:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(94)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(399);
      if (lookahead == '\r') SKIP(42)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 159:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(77)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(390);
      if (lookahead == '\r') SKIP(43)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 160:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(74)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(387);
      if (lookahead == '\r') SKIP(46)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 161:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(75)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(388);
      if (lookahead == '\r') SKIP(47)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 162:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(99)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(402);
      if (lookahead == '\r') SKIP(48)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 163:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(97)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(403);
      if (lookahead == '\r') SKIP(52)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 164:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(98)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(404);
      if (lookahead == '\r') SKIP(53)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 165:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(25)
      if (lookahead == '\r') SKIP(24)
      END_STATE();
    case 166:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(26)
      if (lookahead == '\r') SKIP(30)
      END_STATE();
    case 167:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(33)
      if (lookahead == '\r') SKIP(32)
      END_STATE();
    case 168:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(89)
      if (lookahead == '\r') SKIP(37)
      END_STATE();
    case 169:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(88)
      if (lookahead == '\r') SKIP(39)
      END_STATE();
    case 170:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(28)
      if (lookahead == '\r') SKIP(44)
      END_STATE();
    case 171:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(34)
      if (lookahead == '\r') SKIP(45)
      END_STATE();
    case 172:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(90)
      if (lookahead == '\r') SKIP(49)
      END_STATE();
    case 173:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(91)
      if (lookahead == '\r') SKIP(50)
      END_STATE();
    case 174:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(92)
      if (lookahead == '\r') SKIP(51)
      END_STATE();
    case 175:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(27)
      if (lookahead == '\r') SKIP(54)
      END_STATE();
    case 176:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(85)
      if (lookahead == '\r') SKIP(55)
      END_STATE();
    case 177:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(330);
      if (lookahead == '\r') ADVANCE(326);
      if (lookahead != 0) ADVANCE(333);
      END_STATE();
    case 178:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(101)
      if (lookahead == '\r') SKIP(56)
      END_STATE();
    case 179:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(331);
      if (lookahead == '\r') ADVANCE(328);
      if (lookahead != 0) ADVANCE(333);
      END_STATE();
    case 180:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(332);
      if (lookahead == '\r') ADVANCE(329);
      if (lookahead != 0) ADVANCE(333);
      END_STATE();
    case 181:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(29)
      if (lookahead == '\r') SKIP(57)
      END_STATE();
    case 182:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(102)
      if (lookahead == '\r') SKIP(58)
      END_STATE();
    case 183:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(103)
      if (lookahead == '\r') SKIP(59)
      END_STATE();
    case 184:
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(421);
      END_STATE();
    case 185:
      if (lookahead != 0 &&
          lookahead != '\r') ADVANCE(333);
      if (lookahead == '\r') ADVANCE(334);
      END_STATE();
    case 186:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(285);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') SKIP(200)
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(186)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 187:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(285);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') SKIP(201)
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(187)
      END_STATE();
    case 188:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '&') ADVANCE(424);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') SKIP(203)
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'i') ADVANCE(126);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(188)
      END_STATE();
    case 189:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') SKIP(186)
      END_STATE();
    case 190:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') SKIP(187)
      END_STATE();
    case 191:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') SKIP(199)
      END_STATE();
    case 192:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') SKIP(188)
      END_STATE();
    case 193:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') ADVANCE(211);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(140);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(193)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(421);
      END_STATE();
    case 194:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') ADVANCE(216);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(145);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(194)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(421);
      END_STATE();
    case 195:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(255);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(195)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 196:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(196)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(421);
      END_STATE();
    case 197:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') ADVANCE(222);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(152);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(197)
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(421);
      END_STATE();
    case 198:
      if (eof) ADVANCE(204);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(132);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(198)
      if (lookahead != 0 &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 199:
      if (eof) ADVANCE(204);
      if (lookahead == '!') ADVANCE(113);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == ')') ADVANCE(112);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == ':') ADVANCE(314);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '[' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') SKIP(202)
      if (lookahead == ']') ADVANCE(324);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'd') ADVANCE(128);
      if (lookahead == 'e') ADVANCE(125);
      if (lookahead == 'f') ADVANCE(123);
      if (lookahead == 'i') ADVANCE(126);
      if (lookahead == 't') ADVANCE(122);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(199)
      END_STATE();
    case 200:
      if (eof) ADVANCE(204);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(186)
      if (lookahead == '\r') SKIP(189)
      END_STATE();
    case 201:
      if (eof) ADVANCE(204);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(187)
      if (lookahead == '\r') SKIP(190)
      END_STATE();
    case 202:
      if (eof) ADVANCE(204);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(199)
      if (lookahead == '\r') SKIP(191)
      END_STATE();
    case 203:
      if (eof) ADVANCE(204);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(188)
      if (lookahead == '\r') SKIP(192)
      END_STATE();
    case 204:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(205);
      if (lookahead == '\\') ADVANCE(137);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(206);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '-') ADVANCE(306);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(208);
      if (lookahead == '-') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(154);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '\\') ADVANCE(138);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(210);
      if (lookahead == '\\') ADVANCE(139);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(211);
      if (lookahead == '\\') ADVANCE(140);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(141);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(213);
      if (lookahead == '\\') ADVANCE(142);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(214);
      if (lookahead == '\\') ADVANCE(143);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(215);
      if (lookahead == '\\') ADVANCE(144);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(216);
      if (lookahead == '\\') ADVANCE(145);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(217);
      if (lookahead == '\\') ADVANCE(146);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '\\') ADVANCE(147);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '\\') ADVANCE(148);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '\\') ADVANCE(150);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '\\') ADVANCE(151);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(222);
      if (lookahead == '\\') ADVANCE(152);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(223);
      if (lookahead == '\\') ADVANCE(160);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(224);
      if (lookahead == '\\') ADVANCE(161);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_in);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_LPAREN_LPAREN);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_RPAREN_RPAREN);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_SEMI);
      if (lookahead == '&') ADVANCE(253);
      if (lookahead == ';') ADVANCE(252);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_SEMI);
      if (lookahead == ';') ADVANCE(251);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_then);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_fi);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_fi);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_elif);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_esac);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_esac);
      if (lookahead == '\\') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(421);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_esac);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_esac);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '&') ADVANCE(259);
      if (lookahead == '|') ADVANCE(261);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(261);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_SEMI_SEMI);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_SEMI_SEMI);
      if (lookahead == '&') ADVANCE(254);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_SEMI_AMP);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_SEMI_SEMI_AMP);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '(') ADVANCE(228);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_PIPE_AMP);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(301);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_3(lookahead)) ADVANCE(421);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(300);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(269);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(274);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == '~') ADVANCE(272);
      if (!sym_word_character_set_3(lookahead)) ADVANCE(421);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(273);
      if (lookahead == '~') ADVANCE(271);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(294);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(294);
      if (lookahead == '(') ADVANCE(347);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(294);
      if (lookahead == '(') ADVANCE(347);
      if (lookahead == '<') ADVANCE(297);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(294);
      if (lookahead == '(') ADVANCE(347);
      if (lookahead == '<') ADVANCE(297);
      if (lookahead == '=') ADVANCE(310);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(294);
      if (lookahead == '<') ADVANCE(297);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(310);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&') ADVANCE(295);
      if (lookahead == '(') ADVANCE(348);
      if (lookahead == '=') ADVANCE(311);
      if (lookahead == '>') ADVANCE(291);
      if (lookahead == '|') ADVANCE(296);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&') ADVANCE(295);
      if (lookahead == '(') ADVANCE(348);
      if (lookahead == '>') ADVANCE(291);
      if (lookahead == '|') ADVANCE(296);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&') ADVANCE(295);
      if (lookahead == '>') ADVANCE(291);
      if (lookahead == '|') ADVANCE(296);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(311);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_AMP_GT);
      if (lookahead == '>') ADVANCE(293);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_AMP_GT_GT);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_LT_AMP);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_GT_AMP);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_GT_PIPE);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '-') ADVANCE(298);
      if (lookahead == '<') ADVANCE(299);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_LT_LT_DASH);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_LT_LT_LT);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(317);
      if (lookahead == '=') ADVANCE(280);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_3(lookahead)) ADVANCE(421);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(316);
      if (lookahead == '=') ADVANCE(279);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(319);
      if (lookahead == '=') ADVANCE(309);
      if (lookahead == '\\') ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      if (!sym_word_character_set_4(lookahead)) ADVANCE(421);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(318);
      if (lookahead == '=') ADVANCE(308);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '-') ADVANCE(343);
      if (lookahead == '?') ADVANCE(342);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(345);
      if (lookahead == '{') ADVANCE(340);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '(') ADVANCE(345);
      if (lookahead == '{') ADVANCE(340);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym__special_character);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym__special_character);
      if (lookahead == ']') ADVANCE(270);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n') ADVANCE(330);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(333);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n') ADVANCE(333);
      if (lookahead == '\\') ADVANCE(349);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(327);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n') ADVANCE(331);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(333);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n') ADVANCE(332);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(333);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') ADVANCE(177);
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(330);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(333);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') ADVANCE(179);
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(331);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '`') ADVANCE(333);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(327);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '\\') ADVANCE(180);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(332);
      if (lookahead != 0) ADVANCE(333);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(333);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(333);
      if (lookahead == '\\') ADVANCE(185);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_raw_string);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_ansii_c_string);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_ansii_c_string);
      if (lookahead == '\'') ADVANCE(336);
      if (lookahead == '\\') ADVANCE(108);
      if (lookahead != 0) ADVANCE(107);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '\\') ADVANCE(350);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(422);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_COLON_QMARK);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_COLON_DASH);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_LT_LPAREN);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_GT_LPAREN);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(333);
      if (lookahead == '\r') ADVANCE(327);
      if (lookahead != 0) ADVANCE(327);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(351);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(422);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(351);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'a') ADVANCE(353);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(421);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'c') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(421);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 's') ADVANCE(352);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(421);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == '\\') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(421);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == 'a') ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == 'c') ADVANCE(246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == 'n') ADVANCE(227);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == 's') ADVANCE(356);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == '\\') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(421);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_0);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '\\') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(421);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym__);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(205);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(137);
      if (lookahead == 'e') ADVANCE(354);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_5(lookahead)) ADVANCE(421);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(208);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '-') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(154);
      if (!sym_word_character_set_6(lookahead)) ADVANCE(421);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_5(lookahead)) ADVANCE(421);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(210);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(139);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == 'e') ADVANCE(354);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < ';' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(211);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_5(lookahead)) ADVANCE(421);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(212);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '\\') ADVANCE(141);
      if (lookahead == 'e') ADVANCE(419);
      if (!sym_word_character_set_7(lookahead)) ADVANCE(421);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(213);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(142);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == 'e') ADVANCE(354);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '>' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(214);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(143);
      if (lookahead == '_') ADVANCE(368);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < ';' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(215);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '\\') ADVANCE(144);
      if (!sym_word_character_set_7(lookahead)) ADVANCE(421);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(216);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(145);
      if (lookahead == '_') ADVANCE(368);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < ';' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(217);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(146);
      if (lookahead == '_') ADVANCE(368);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '>' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '\\') ADVANCE(147);
      if (!sym_word_character_set_7(lookahead)) ADVANCE(421);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead == '_') ADVANCE(368);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '>' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(150);
      if (lookahead == 'e') ADVANCE(419);
      if (!sym_word_character_set_8(lookahead)) ADVANCE(421);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(151);
      if (!sym_word_character_set_8(lookahead)) ADVANCE(421);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(222);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(152);
      if (!sym_word_character_set_8(lookahead)) ADVANCE(421);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(223);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(160);
      if (lookahead == '_') ADVANCE(368);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '>' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(224);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(161);
      if (!sym_word_character_set_8(lookahead)) ADVANCE(421);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(263);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '+') ADVANCE(302);
      if (lookahead == '-') ADVANCE(305);
      if (lookahead == '/') ADVANCE(341);
      if (lookahead == '0') ADVANCE(366);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == '=') ADVANCE(276);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(131);
      if (lookahead == '_') ADVANCE(369);
      if (lookahead == 'd') ADVANCE(418);
      if (lookahead == 'e') ADVANCE(414);
      if (lookahead == 'f') ADVANCE(412);
      if (lookahead == 'i') ADVANCE(416);
      if (lookahead == 't') ADVANCE(411);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || ')' < lookahead) &&
          (lookahead < ';' || '>' < lookahead) &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(159);
      if (lookahead == '_') ADVANCE(368);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || ')' < lookahead) &&
          (lookahead < ';' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '_') ADVANCE(368);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '>' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '-') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(156);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(421);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(132);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(421);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(133);
      if (lookahead == 'e') ADVANCE(415);
      if (lookahead == 'f') ADVANCE(412);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(421);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(134);
      if (lookahead == 'e') ADVANCE(419);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(421);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(135);
      if (lookahead == 'f') ADVANCE(412);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(421);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(136);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(421);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '/') ADVANCE(341);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '\\') ADVANCE(157);
      if (!sym_word_character_set_10(lookahead)) ADVANCE(421);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '\\') ADVANCE(158);
      if (!sym_word_character_set_10(lookahead)) ADVANCE(421);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(149);
      if (!sym_word_character_set_11(lookahead)) ADVANCE(421);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(153);
      if (!sym_word_character_set_11(lookahead)) ADVANCE(421);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(162);
      if (lookahead == 'e') ADVANCE(419);
      if (!sym_word_character_set_11(lookahead)) ADVANCE(421);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(163);
      if (!sym_word_character_set_11(lookahead)) ADVANCE(421);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(164);
      if (!sym_word_character_set_11(lookahead)) ADVANCE(421);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '=') ADVANCE(274);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == '~') ADVANCE(272);
      if (!sym_word_character_set_3(lookahead)) ADVANCE(421);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'a') ADVANCE(407);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'c') ADVANCE(245);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'e') ADVANCE(242);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'e') ADVANCE(417);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'f') ADVANCE(240);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'h') ADVANCE(409);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'i') ADVANCE(238);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'i') ADVANCE(410);
      if (lookahead == 's') ADVANCE(408);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'l') ADVANCE(413);
      if (lookahead == 's') ADVANCE(406);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'l') ADVANCE(413);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'n') ADVANCE(226);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'n') ADVANCE(236);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'o') ADVANCE(234);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 's') ADVANCE(406);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(421);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(350);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(422);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym_test_operator);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(260);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(260);
      if (lookahead == '>') ADVANCE(292);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\\') SKIP(1)
      if (lookahead == 'c') ADVANCE(2);
      if (lookahead == 'd') ADVANCE(3);
      if (lookahead == 'e') ADVANCE(4);
      if (lookahead == 'f') ADVANCE(5);
      if (lookahead == 'i') ADVANCE(6);
      if (lookahead == 'l') ADVANCE(7);
      if (lookahead == 'r') ADVANCE(8);
      if (lookahead == 's') ADVANCE(9);
      if (lookahead == 't') ADVANCE(10);
      if (lookahead == 'u') ADVANCE(11);
      if (lookahead == 'w') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(0)
      if (lookahead == '\r') SKIP(13)
      END_STATE();
    case 2:
      if (lookahead == 'a') ADVANCE(14);
      END_STATE();
    case 3:
      if (lookahead == 'e') ADVANCE(15);
      if (lookahead == 'o') ADVANCE(16);
      END_STATE();
    case 4:
      if (lookahead == 'x') ADVANCE(17);
      END_STATE();
    case 5:
      if (lookahead == 'o') ADVANCE(18);
      if (lookahead == 'u') ADVANCE(19);
      END_STATE();
    case 6:
      if (lookahead == 'f') ADVANCE(20);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(21);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(22);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(23);
      END_STATE();
    case 10:
      if (lookahead == 'y') ADVANCE(24);
      END_STATE();
    case 11:
      if (lookahead == 'n') ADVANCE(25);
      END_STATE();
    case 12:
      if (lookahead == 'h') ADVANCE(26);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 14:
      if (lookahead == 's') ADVANCE(27);
      END_STATE();
    case 15:
      if (lookahead == 'c') ADVANCE(28);
      END_STATE();
    case 16:
      if (lookahead == 'n') ADVANCE(29);
      END_STATE();
    case 17:
      if (lookahead == 'p') ADVANCE(30);
      END_STATE();
    case 18:
      if (lookahead == 'r') ADVANCE(31);
      END_STATE();
    case 19:
      if (lookahead == 'n') ADVANCE(32);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 21:
      if (lookahead == 'c') ADVANCE(33);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(34);
      END_STATE();
    case 23:
      if (lookahead == 'l') ADVANCE(35);
      END_STATE();
    case 24:
      if (lookahead == 'p') ADVANCE(36);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(37);
      if (lookahead == 't') ADVANCE(38);
      END_STATE();
    case 26:
      if (lookahead == 'i') ADVANCE(39);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 28:
      if (lookahead == 'l') ADVANCE(41);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 30:
      if (lookahead == 'o') ADVANCE(43);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 32:
      if (lookahead == 'c') ADVANCE(44);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 34:
      if (lookahead == 'd') ADVANCE(46);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 38:
      if (lookahead == 'i') ADVANCE(50);
      END_STATE();
    case 39:
      if (lookahead == 'l') ADVANCE(51);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(52);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_done);
      END_STATE();
    case 43:
      if (lookahead == 'r') ADVANCE(53);
      END_STATE();
    case 44:
      if (lookahead == 't') ADVANCE(54);
      END_STATE();
    case 45:
      if (lookahead == 'l') ADVANCE(55);
      END_STATE();
    case 46:
      if (lookahead == 'o') ADVANCE(56);
      END_STATE();
    case 47:
      if (lookahead == 'c') ADVANCE(57);
      END_STATE();
    case 48:
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 50:
      if (lookahead == 'l') ADVANCE(60);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 52:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 53:
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(64);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_local);
      END_STATE();
    case 56:
      if (lookahead == 'n') ADVANCE(65);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_unset);
      if (lookahead == 'e') ADVANCE(68);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_until);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(69);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 64:
      if (lookahead == 'o') ADVANCE(70);
      END_STATE();
    case 65:
      if (lookahead == 'l') ADVANCE(71);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_select);
      END_STATE();
    case 67:
      if (lookahead == 't') ADVANCE(72);
      END_STATE();
    case 68:
      if (lookahead == 'n') ADVANCE(73);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 70:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 71:
      if (lookahead == 'y') ADVANCE(75);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_typeset);
      END_STATE();
    case 73:
      if (lookahead == 'v') ADVANCE(76);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_unsetenv);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 198, .external_lex_state = 2},
  [2] = {.lex_state = 81, .external_lex_state = 2},
  [3] = {.lex_state = 81, .external_lex_state = 2},
  [4] = {.lex_state = 81, .external_lex_state = 2},
  [5] = {.lex_state = 81, .external_lex_state = 2},
  [6] = {.lex_state = 81, .external_lex_state = 2},
  [7] = {.lex_state = 81, .external_lex_state = 2},
  [8] = {.lex_state = 80, .external_lex_state = 2},
  [9] = {.lex_state = 80, .external_lex_state = 2},
  [10] = {.lex_state = 80, .external_lex_state = 2},
  [11] = {.lex_state = 80, .external_lex_state = 2},
  [12] = {.lex_state = 80, .external_lex_state = 2},
  [13] = {.lex_state = 198, .external_lex_state = 2},
  [14] = {.lex_state = 198, .external_lex_state = 2},
  [15] = {.lex_state = 198, .external_lex_state = 2},
  [16] = {.lex_state = 198, .external_lex_state = 2},
  [17] = {.lex_state = 198, .external_lex_state = 2},
  [18] = {.lex_state = 81, .external_lex_state = 2},
  [19] = {.lex_state = 81, .external_lex_state = 2},
  [20] = {.lex_state = 81, .external_lex_state = 2},
  [21] = {.lex_state = 198, .external_lex_state = 2},
  [22] = {.lex_state = 198, .external_lex_state = 2},
  [23] = {.lex_state = 198, .external_lex_state = 2},
  [24] = {.lex_state = 198, .external_lex_state = 2},
  [25] = {.lex_state = 198, .external_lex_state = 2},
  [26] = {.lex_state = 198, .external_lex_state = 2},
  [27] = {.lex_state = 198, .external_lex_state = 2},
  [28] = {.lex_state = 198, .external_lex_state = 2},
  [29] = {.lex_state = 198, .external_lex_state = 2},
  [30] = {.lex_state = 198, .external_lex_state = 2},
  [31] = {.lex_state = 198, .external_lex_state = 2},
  [32] = {.lex_state = 82, .external_lex_state = 2},
  [33] = {.lex_state = 82, .external_lex_state = 2},
  [34] = {.lex_state = 198, .external_lex_state = 2},
  [35] = {.lex_state = 198, .external_lex_state = 2},
  [36] = {.lex_state = 198, .external_lex_state = 2},
  [37] = {.lex_state = 198, .external_lex_state = 2},
  [38] = {.lex_state = 198, .external_lex_state = 2},
  [39] = {.lex_state = 198, .external_lex_state = 2},
  [40] = {.lex_state = 198, .external_lex_state = 2},
  [41] = {.lex_state = 198, .external_lex_state = 2},
  [42] = {.lex_state = 198, .external_lex_state = 2},
  [43] = {.lex_state = 198, .external_lex_state = 2},
  [44] = {.lex_state = 198, .external_lex_state = 2},
  [45] = {.lex_state = 198, .external_lex_state = 2},
  [46] = {.lex_state = 198, .external_lex_state = 2},
  [47] = {.lex_state = 198, .external_lex_state = 2},
  [48] = {.lex_state = 198, .external_lex_state = 2},
  [49] = {.lex_state = 198, .external_lex_state = 2},
  [50] = {.lex_state = 198, .external_lex_state = 2},
  [51] = {.lex_state = 198, .external_lex_state = 2},
  [52] = {.lex_state = 198, .external_lex_state = 2},
  [53] = {.lex_state = 198, .external_lex_state = 2},
  [54] = {.lex_state = 198, .external_lex_state = 2},
  [55] = {.lex_state = 198, .external_lex_state = 2},
  [56] = {.lex_state = 198, .external_lex_state = 2},
  [57] = {.lex_state = 198, .external_lex_state = 2},
  [58] = {.lex_state = 198, .external_lex_state = 2},
  [59] = {.lex_state = 83, .external_lex_state = 3},
  [60] = {.lex_state = 198, .external_lex_state = 2},
  [61] = {.lex_state = 198, .external_lex_state = 2},
  [62] = {.lex_state = 198, .external_lex_state = 2},
  [63] = {.lex_state = 198, .external_lex_state = 2},
  [64] = {.lex_state = 198, .external_lex_state = 2},
  [65] = {.lex_state = 198, .external_lex_state = 2},
  [66] = {.lex_state = 198, .external_lex_state = 2},
  [67] = {.lex_state = 198, .external_lex_state = 2},
  [68] = {.lex_state = 198, .external_lex_state = 2},
  [69] = {.lex_state = 198, .external_lex_state = 2},
  [70] = {.lex_state = 198, .external_lex_state = 2},
  [71] = {.lex_state = 198, .external_lex_state = 2},
  [72] = {.lex_state = 198, .external_lex_state = 2},
  [73] = {.lex_state = 198, .external_lex_state = 2},
  [74] = {.lex_state = 198, .external_lex_state = 2},
  [75] = {.lex_state = 198, .external_lex_state = 2},
  [76] = {.lex_state = 198, .external_lex_state = 2},
  [77] = {.lex_state = 198, .external_lex_state = 2},
  [78] = {.lex_state = 198, .external_lex_state = 2},
  [79] = {.lex_state = 198, .external_lex_state = 2},
  [80] = {.lex_state = 198, .external_lex_state = 2},
  [81] = {.lex_state = 198, .external_lex_state = 2},
  [82] = {.lex_state = 198, .external_lex_state = 2},
  [83] = {.lex_state = 198, .external_lex_state = 2},
  [84] = {.lex_state = 198, .external_lex_state = 2},
  [85] = {.lex_state = 198, .external_lex_state = 2},
  [86] = {.lex_state = 198, .external_lex_state = 2},
  [87] = {.lex_state = 198, .external_lex_state = 2},
  [88] = {.lex_state = 198, .external_lex_state = 2},
  [89] = {.lex_state = 198, .external_lex_state = 2},
  [90] = {.lex_state = 198, .external_lex_state = 2},
  [91] = {.lex_state = 198, .external_lex_state = 2},
  [92] = {.lex_state = 198, .external_lex_state = 2},
  [93] = {.lex_state = 198, .external_lex_state = 2},
  [94] = {.lex_state = 83, .external_lex_state = 3},
  [95] = {.lex_state = 198, .external_lex_state = 2},
  [96] = {.lex_state = 198, .external_lex_state = 2},
  [97] = {.lex_state = 198, .external_lex_state = 2},
  [98] = {.lex_state = 82, .external_lex_state = 2},
  [99] = {.lex_state = 198, .external_lex_state = 2},
  [100] = {.lex_state = 198, .external_lex_state = 2},
  [101] = {.lex_state = 83, .external_lex_state = 3},
  [102] = {.lex_state = 198, .external_lex_state = 2},
  [103] = {.lex_state = 83, .external_lex_state = 3},
  [104] = {.lex_state = 198, .external_lex_state = 2},
  [105] = {.lex_state = 198, .external_lex_state = 2},
  [106] = {.lex_state = 198, .external_lex_state = 2},
  [107] = {.lex_state = 198, .external_lex_state = 2},
  [108] = {.lex_state = 198, .external_lex_state = 2},
  [109] = {.lex_state = 198, .external_lex_state = 2},
  [110] = {.lex_state = 198, .external_lex_state = 2},
  [111] = {.lex_state = 198, .external_lex_state = 2},
  [112] = {.lex_state = 198, .external_lex_state = 2},
  [113] = {.lex_state = 198, .external_lex_state = 2},
  [114] = {.lex_state = 198, .external_lex_state = 2},
  [115] = {.lex_state = 198, .external_lex_state = 2},
  [116] = {.lex_state = 198, .external_lex_state = 2},
  [117] = {.lex_state = 198, .external_lex_state = 2},
  [118] = {.lex_state = 198, .external_lex_state = 2},
  [119] = {.lex_state = 198, .external_lex_state = 2},
  [120] = {.lex_state = 198, .external_lex_state = 2},
  [121] = {.lex_state = 198, .external_lex_state = 2},
  [122] = {.lex_state = 83, .external_lex_state = 3},
  [123] = {.lex_state = 198, .external_lex_state = 2},
  [124] = {.lex_state = 198, .external_lex_state = 2},
  [125] = {.lex_state = 198, .external_lex_state = 2},
  [126] = {.lex_state = 198, .external_lex_state = 2},
  [127] = {.lex_state = 198, .external_lex_state = 2},
  [128] = {.lex_state = 83, .external_lex_state = 3},
  [129] = {.lex_state = 83, .external_lex_state = 3},
  [130] = {.lex_state = 198, .external_lex_state = 2},
  [131] = {.lex_state = 198, .external_lex_state = 2},
  [132] = {.lex_state = 198, .external_lex_state = 2},
  [133] = {.lex_state = 198, .external_lex_state = 2},
  [134] = {.lex_state = 198, .external_lex_state = 2},
  [135] = {.lex_state = 198, .external_lex_state = 2},
  [136] = {.lex_state = 198, .external_lex_state = 2},
  [137] = {.lex_state = 198, .external_lex_state = 2},
  [138] = {.lex_state = 198, .external_lex_state = 2},
  [139] = {.lex_state = 198, .external_lex_state = 2},
  [140] = {.lex_state = 198, .external_lex_state = 2},
  [141] = {.lex_state = 198, .external_lex_state = 2},
  [142] = {.lex_state = 198, .external_lex_state = 2},
  [143] = {.lex_state = 198, .external_lex_state = 2},
  [144] = {.lex_state = 198, .external_lex_state = 2},
  [145] = {.lex_state = 198, .external_lex_state = 2},
  [146] = {.lex_state = 198, .external_lex_state = 2},
  [147] = {.lex_state = 198, .external_lex_state = 2},
  [148] = {.lex_state = 198, .external_lex_state = 2},
  [149] = {.lex_state = 198, .external_lex_state = 2},
  [150] = {.lex_state = 198, .external_lex_state = 2},
  [151] = {.lex_state = 198, .external_lex_state = 2},
  [152] = {.lex_state = 198, .external_lex_state = 2},
  [153] = {.lex_state = 198, .external_lex_state = 2},
  [154] = {.lex_state = 198, .external_lex_state = 2},
  [155] = {.lex_state = 198, .external_lex_state = 2},
  [156] = {.lex_state = 198, .external_lex_state = 2},
  [157] = {.lex_state = 198, .external_lex_state = 2},
  [158] = {.lex_state = 80, .external_lex_state = 4},
  [159] = {.lex_state = 80, .external_lex_state = 4},
  [160] = {.lex_state = 198, .external_lex_state = 4},
  [161] = {.lex_state = 8, .external_lex_state = 5},
  [162] = {.lex_state = 198, .external_lex_state = 4},
  [163] = {.lex_state = 8, .external_lex_state = 5},
  [164] = {.lex_state = 81, .external_lex_state = 4},
  [165] = {.lex_state = 8, .external_lex_state = 5},
  [166] = {.lex_state = 60, .external_lex_state = 5},
  [167] = {.lex_state = 61, .external_lex_state = 6},
  [168] = {.lex_state = 60, .external_lex_state = 5},
  [169] = {.lex_state = 60, .external_lex_state = 5},
  [170] = {.lex_state = 193, .external_lex_state = 5},
  [171] = {.lex_state = 80, .external_lex_state = 2},
  [172] = {.lex_state = 198, .external_lex_state = 2},
  [173] = {.lex_state = 80, .external_lex_state = 2},
  [174] = {.lex_state = 63, .external_lex_state = 6},
  [175] = {.lex_state = 80, .external_lex_state = 2},
  [176] = {.lex_state = 198, .external_lex_state = 4},
  [177] = {.lex_state = 82, .external_lex_state = 4},
  [178] = {.lex_state = 193, .external_lex_state = 5},
  [179] = {.lex_state = 63, .external_lex_state = 6},
  [180] = {.lex_state = 63, .external_lex_state = 6},
  [181] = {.lex_state = 63, .external_lex_state = 6},
  [182] = {.lex_state = 198, .external_lex_state = 4},
  [183] = {.lex_state = 198, .external_lex_state = 4},
  [184] = {.lex_state = 193, .external_lex_state = 5},
  [185] = {.lex_state = 193, .external_lex_state = 5},
  [186] = {.lex_state = 63, .external_lex_state = 6},
  [187] = {.lex_state = 198, .external_lex_state = 2},
  [188] = {.lex_state = 193, .external_lex_state = 5},
  [189] = {.lex_state = 80, .external_lex_state = 2},
  [190] = {.lex_state = 198, .external_lex_state = 4},
  [191] = {.lex_state = 193, .external_lex_state = 5},
  [192] = {.lex_state = 64, .external_lex_state = 5},
  [193] = {.lex_state = 83, .external_lex_state = 7},
  [194] = {.lex_state = 198, .external_lex_state = 2},
  [195] = {.lex_state = 198, .external_lex_state = 2},
  [196] = {.lex_state = 198, .external_lex_state = 4},
  [197] = {.lex_state = 64, .external_lex_state = 5},
  [198] = {.lex_state = 65, .external_lex_state = 6},
  [199] = {.lex_state = 66, .external_lex_state = 6},
  [200] = {.lex_state = 66, .external_lex_state = 6},
  [201] = {.lex_state = 8, .external_lex_state = 6},
  [202] = {.lex_state = 193, .external_lex_state = 5},
  [203] = {.lex_state = 81, .external_lex_state = 2},
  [204] = {.lex_state = 64, .external_lex_state = 6},
  [205] = {.lex_state = 8, .external_lex_state = 6},
  [206] = {.lex_state = 194, .external_lex_state = 6},
  [207] = {.lex_state = 68, .external_lex_state = 5},
  [208] = {.lex_state = 198, .external_lex_state = 4},
  [209] = {.lex_state = 193, .external_lex_state = 5},
  [210] = {.lex_state = 66, .external_lex_state = 6},
  [211] = {.lex_state = 194, .external_lex_state = 6},
  [212] = {.lex_state = 198, .external_lex_state = 4},
  [213] = {.lex_state = 8, .external_lex_state = 6},
  [214] = {.lex_state = 198, .external_lex_state = 4},
  [215] = {.lex_state = 66, .external_lex_state = 6},
  [216] = {.lex_state = 66, .external_lex_state = 6},
  [217] = {.lex_state = 68, .external_lex_state = 5},
  [218] = {.lex_state = 81, .external_lex_state = 2},
  [219] = {.lex_state = 195, .external_lex_state = 6},
  [220] = {.lex_state = 60, .external_lex_state = 6},
  [221] = {.lex_state = 60, .external_lex_state = 6},
  [222] = {.lex_state = 60, .external_lex_state = 6},
  [223] = {.lex_state = 195, .external_lex_state = 6},
  [224] = {.lex_state = 195, .external_lex_state = 6},
  [225] = {.lex_state = 68, .external_lex_state = 6},
  [226] = {.lex_state = 195, .external_lex_state = 6},
  [227] = {.lex_state = 195, .external_lex_state = 6},
  [228] = {.lex_state = 195, .external_lex_state = 6},
  [229] = {.lex_state = 196, .external_lex_state = 5},
  [230] = {.lex_state = 196, .external_lex_state = 5},
  [231] = {.lex_state = 196, .external_lex_state = 5},
  [232] = {.lex_state = 196, .external_lex_state = 5},
  [233] = {.lex_state = 195, .external_lex_state = 6},
  [234] = {.lex_state = 195, .external_lex_state = 6},
  [235] = {.lex_state = 195, .external_lex_state = 6},
  [236] = {.lex_state = 195, .external_lex_state = 6},
  [237] = {.lex_state = 193, .external_lex_state = 6},
  [238] = {.lex_state = 193, .external_lex_state = 6},
  [239] = {.lex_state = 198, .external_lex_state = 2},
  [240] = {.lex_state = 83, .external_lex_state = 3},
  [241] = {.lex_state = 193, .external_lex_state = 6},
  [242] = {.lex_state = 195, .external_lex_state = 6},
  [243] = {.lex_state = 196, .external_lex_state = 6},
  [244] = {.lex_state = 196, .external_lex_state = 6},
  [245] = {.lex_state = 198, .external_lex_state = 2},
  [246] = {.lex_state = 198, .external_lex_state = 2},
  [247] = {.lex_state = 193, .external_lex_state = 6},
  [248] = {.lex_state = 83, .external_lex_state = 3},
  [249] = {.lex_state = 195, .external_lex_state = 6},
  [250] = {.lex_state = 195, .external_lex_state = 6},
  [251] = {.lex_state = 198, .external_lex_state = 2},
  [252] = {.lex_state = 195, .external_lex_state = 6},
  [253] = {.lex_state = 193, .external_lex_state = 6},
  [254] = {.lex_state = 82, .external_lex_state = 2},
  [255] = {.lex_state = 82, .external_lex_state = 2},
  [256] = {.lex_state = 198, .external_lex_state = 2},
  [257] = {.lex_state = 198, .external_lex_state = 2},
  [258] = {.lex_state = 193, .external_lex_state = 6},
  [259] = {.lex_state = 193, .external_lex_state = 6},
  [260] = {.lex_state = 198, .external_lex_state = 2},
  [261] = {.lex_state = 198, .external_lex_state = 2},
  [262] = {.lex_state = 198, .external_lex_state = 2},
  [263] = {.lex_state = 198, .external_lex_state = 2},
  [264] = {.lex_state = 198, .external_lex_state = 2},
  [265] = {.lex_state = 193, .external_lex_state = 6},
  [266] = {.lex_state = 95, .external_lex_state = 2},
  [267] = {.lex_state = 95, .external_lex_state = 2},
  [268] = {.lex_state = 198, .external_lex_state = 2},
  [269] = {.lex_state = 95, .external_lex_state = 2},
  [270] = {.lex_state = 95, .external_lex_state = 2},
  [271] = {.lex_state = 95, .external_lex_state = 2},
  [272] = {.lex_state = 71, .external_lex_state = 5},
  [273] = {.lex_state = 71, .external_lex_state = 5},
  [274] = {.lex_state = 71, .external_lex_state = 5},
  [275] = {.lex_state = 63, .external_lex_state = 8},
  [276] = {.lex_state = 71, .external_lex_state = 5},
  [277] = {.lex_state = 8, .external_lex_state = 9},
  [278] = {.lex_state = 63, .external_lex_state = 8},
  [279] = {.lex_state = 63, .external_lex_state = 8},
  [280] = {.lex_state = 72, .external_lex_state = 5},
  [281] = {.lex_state = 63, .external_lex_state = 8},
  [282] = {.lex_state = 63, .external_lex_state = 8},
  [283] = {.lex_state = 8, .external_lex_state = 9},
  [284] = {.lex_state = 72, .external_lex_state = 5},
  [285] = {.lex_state = 72, .external_lex_state = 5},
  [286] = {.lex_state = 66, .external_lex_state = 8},
  [287] = {.lex_state = 8, .external_lex_state = 9},
  [288] = {.lex_state = 63, .external_lex_state = 8},
  [289] = {.lex_state = 63, .external_lex_state = 8},
  [290] = {.lex_state = 8, .external_lex_state = 9},
  [291] = {.lex_state = 8, .external_lex_state = 9},
  [292] = {.lex_state = 72, .external_lex_state = 5},
  [293] = {.lex_state = 8, .external_lex_state = 9},
  [294] = {.lex_state = 63, .external_lex_state = 8},
  [295] = {.lex_state = 60, .external_lex_state = 9},
  [296] = {.lex_state = 8, .external_lex_state = 8},
  [297] = {.lex_state = 8, .external_lex_state = 8},
  [298] = {.lex_state = 8, .external_lex_state = 9},
  [299] = {.lex_state = 8, .external_lex_state = 9},
  [300] = {.lex_state = 8, .external_lex_state = 9},
  [301] = {.lex_state = 8, .external_lex_state = 9},
  [302] = {.lex_state = 8, .external_lex_state = 9},
  [303] = {.lex_state = 8, .external_lex_state = 9},
  [304] = {.lex_state = 8, .external_lex_state = 9},
  [305] = {.lex_state = 8, .external_lex_state = 9},
  [306] = {.lex_state = 8, .external_lex_state = 9},
  [307] = {.lex_state = 8, .external_lex_state = 9},
  [308] = {.lex_state = 8, .external_lex_state = 9},
  [309] = {.lex_state = 8, .external_lex_state = 9},
  [310] = {.lex_state = 8, .external_lex_state = 9},
  [311] = {.lex_state = 8, .external_lex_state = 5},
  [312] = {.lex_state = 197, .external_lex_state = 5},
  [313] = {.lex_state = 63, .external_lex_state = 6},
  [314] = {.lex_state = 8, .external_lex_state = 9},
  [315] = {.lex_state = 8, .external_lex_state = 9},
  [316] = {.lex_state = 8, .external_lex_state = 9},
  [317] = {.lex_state = 195, .external_lex_state = 8},
  [318] = {.lex_state = 8, .external_lex_state = 9},
  [319] = {.lex_state = 197, .external_lex_state = 5},
  [320] = {.lex_state = 71, .external_lex_state = 9},
  [321] = {.lex_state = 197, .external_lex_state = 5},
  [322] = {.lex_state = 8, .external_lex_state = 5},
  [323] = {.lex_state = 197, .external_lex_state = 5},
  [324] = {.lex_state = 8, .external_lex_state = 9},
  [325] = {.lex_state = 63, .external_lex_state = 6},
  [326] = {.lex_state = 71, .external_lex_state = 9},
  [327] = {.lex_state = 8, .external_lex_state = 9},
  [328] = {.lex_state = 66, .external_lex_state = 8},
  [329] = {.lex_state = 8, .external_lex_state = 9},
  [330] = {.lex_state = 63, .external_lex_state = 6},
  [331] = {.lex_state = 63, .external_lex_state = 8},
  [332] = {.lex_state = 63, .external_lex_state = 8},
  [333] = {.lex_state = 63, .external_lex_state = 8},
  [334] = {.lex_state = 63, .external_lex_state = 8},
  [335] = {.lex_state = 63, .external_lex_state = 8},
  [336] = {.lex_state = 63, .external_lex_state = 8},
  [337] = {.lex_state = 60, .external_lex_state = 9},
  [338] = {.lex_state = 63, .external_lex_state = 8},
  [339] = {.lex_state = 63, .external_lex_state = 8},
  [340] = {.lex_state = 63, .external_lex_state = 8},
  [341] = {.lex_state = 63, .external_lex_state = 8},
  [342] = {.lex_state = 63, .external_lex_state = 8},
  [343] = {.lex_state = 63, .external_lex_state = 8},
  [344] = {.lex_state = 63, .external_lex_state = 8},
  [345] = {.lex_state = 60, .external_lex_state = 9},
  [346] = {.lex_state = 197, .external_lex_state = 5},
  [347] = {.lex_state = 197, .external_lex_state = 5},
  [348] = {.lex_state = 63, .external_lex_state = 8},
  [349] = {.lex_state = 66, .external_lex_state = 8},
  [350] = {.lex_state = 63, .external_lex_state = 8},
  [351] = {.lex_state = 63, .external_lex_state = 8},
  [352] = {.lex_state = 63, .external_lex_state = 8},
  [353] = {.lex_state = 60, .external_lex_state = 9},
  [354] = {.lex_state = 8, .external_lex_state = 8},
  [355] = {.lex_state = 66, .external_lex_state = 8},
  [356] = {.lex_state = 63, .external_lex_state = 6},
  [357] = {.lex_state = 197, .external_lex_state = 5},
  [358] = {.lex_state = 63, .external_lex_state = 8},
  [359] = {.lex_state = 195, .external_lex_state = 8},
  [360] = {.lex_state = 66, .external_lex_state = 8},
  [361] = {.lex_state = 66, .external_lex_state = 8},
  [362] = {.lex_state = 8, .external_lex_state = 8},
  [363] = {.lex_state = 63, .external_lex_state = 8},
  [364] = {.lex_state = 66, .external_lex_state = 8},
  [365] = {.lex_state = 63, .external_lex_state = 8},
  [366] = {.lex_state = 197, .external_lex_state = 5},
  [367] = {.lex_state = 8, .external_lex_state = 9},
  [368] = {.lex_state = 71, .external_lex_state = 9},
  [369] = {.lex_state = 8, .external_lex_state = 9},
  [370] = {.lex_state = 8, .external_lex_state = 9},
  [371] = {.lex_state = 63, .external_lex_state = 8},
  [372] = {.lex_state = 60, .external_lex_state = 9},
  [373] = {.lex_state = 8, .external_lex_state = 9},
  [374] = {.lex_state = 8, .external_lex_state = 5},
  [375] = {.lex_state = 8, .external_lex_state = 9},
  [376] = {.lex_state = 63, .external_lex_state = 8},
  [377] = {.lex_state = 63, .external_lex_state = 8},
  [378] = {.lex_state = 63, .external_lex_state = 8},
  [379] = {.lex_state = 71, .external_lex_state = 9},
  [380] = {.lex_state = 63, .external_lex_state = 8},
  [381] = {.lex_state = 60, .external_lex_state = 9},
  [382] = {.lex_state = 195, .external_lex_state = 8},
  [383] = {.lex_state = 8, .external_lex_state = 8},
  [384] = {.lex_state = 8, .external_lex_state = 8},
  [385] = {.lex_state = 8, .external_lex_state = 8},
  [386] = {.lex_state = 8, .external_lex_state = 8},
  [387] = {.lex_state = 8, .external_lex_state = 8},
  [388] = {.lex_state = 8, .external_lex_state = 8},
  [389] = {.lex_state = 8, .external_lex_state = 8},
  [390] = {.lex_state = 193, .external_lex_state = 9},
  [391] = {.lex_state = 8, .external_lex_state = 8},
  [392] = {.lex_state = 193, .external_lex_state = 9},
  [393] = {.lex_state = 193, .external_lex_state = 9},
  [394] = {.lex_state = 8, .external_lex_state = 8},
  [395] = {.lex_state = 60, .external_lex_state = 5},
  [396] = {.lex_state = 72, .external_lex_state = 9},
  [397] = {.lex_state = 60, .external_lex_state = 9},
  [398] = {.lex_state = 8, .external_lex_state = 5},
  [399] = {.lex_state = 8, .external_lex_state = 8},
  [400] = {.lex_state = 60, .external_lex_state = 9},
  [401] = {.lex_state = 8, .external_lex_state = 5},
  [402] = {.lex_state = 8, .external_lex_state = 8},
  [403] = {.lex_state = 8, .external_lex_state = 5},
  [404] = {.lex_state = 193, .external_lex_state = 9},
  [405] = {.lex_state = 8, .external_lex_state = 8},
  [406] = {.lex_state = 193, .external_lex_state = 9},
  [407] = {.lex_state = 71, .external_lex_state = 5},
  [408] = {.lex_state = 193, .external_lex_state = 9},
  [409] = {.lex_state = 195, .external_lex_state = 8},
  [410] = {.lex_state = 60, .external_lex_state = 9},
  [411] = {.lex_state = 8, .external_lex_state = 8},
  [412] = {.lex_state = 8, .external_lex_state = 8},
  [413] = {.lex_state = 193, .external_lex_state = 9},
  [414] = {.lex_state = 8, .external_lex_state = 8},
  [415] = {.lex_state = 8, .external_lex_state = 8},
  [416] = {.lex_state = 60, .external_lex_state = 9},
  [417] = {.lex_state = 8, .external_lex_state = 8},
  [418] = {.lex_state = 71, .external_lex_state = 9},
  [419] = {.lex_state = 8, .external_lex_state = 8},
  [420] = {.lex_state = 66, .external_lex_state = 8},
  [421] = {.lex_state = 60, .external_lex_state = 9},
  [422] = {.lex_state = 60, .external_lex_state = 9},
  [423] = {.lex_state = 60, .external_lex_state = 9},
  [424] = {.lex_state = 71, .external_lex_state = 9},
  [425] = {.lex_state = 8, .external_lex_state = 8},
  [426] = {.lex_state = 66, .external_lex_state = 8},
  [427] = {.lex_state = 60, .external_lex_state = 9},
  [428] = {.lex_state = 60, .external_lex_state = 9},
  [429] = {.lex_state = 71, .external_lex_state = 9},
  [430] = {.lex_state = 60, .external_lex_state = 9},
  [431] = {.lex_state = 60, .external_lex_state = 9},
  [432] = {.lex_state = 60, .external_lex_state = 9},
  [433] = {.lex_state = 60, .external_lex_state = 9},
  [434] = {.lex_state = 71, .external_lex_state = 5},
  [435] = {.lex_state = 66, .external_lex_state = 6},
  [436] = {.lex_state = 8, .external_lex_state = 8},
  [437] = {.lex_state = 66, .external_lex_state = 8},
  [438] = {.lex_state = 60, .external_lex_state = 5},
  [439] = {.lex_state = 60, .external_lex_state = 9},
  [440] = {.lex_state = 66, .external_lex_state = 8},
  [441] = {.lex_state = 71, .external_lex_state = 9},
  [442] = {.lex_state = 195, .external_lex_state = 8},
  [443] = {.lex_state = 8, .external_lex_state = 8},
  [444] = {.lex_state = 60, .external_lex_state = 9},
  [445] = {.lex_state = 71, .external_lex_state = 9},
  [446] = {.lex_state = 60, .external_lex_state = 9},
  [447] = {.lex_state = 71, .external_lex_state = 9},
  [448] = {.lex_state = 60, .external_lex_state = 9},
  [449] = {.lex_state = 60, .external_lex_state = 9},
  [450] = {.lex_state = 60, .external_lex_state = 8},
  [451] = {.lex_state = 193, .external_lex_state = 9},
  [452] = {.lex_state = 71, .external_lex_state = 9},
  [453] = {.lex_state = 66, .external_lex_state = 8},
  [454] = {.lex_state = 66, .external_lex_state = 6},
  [455] = {.lex_state = 72, .external_lex_state = 9},
  [456] = {.lex_state = 193, .external_lex_state = 9},
  [457] = {.lex_state = 66, .external_lex_state = 8},
  [458] = {.lex_state = 63, .external_lex_state = 6},
  [459] = {.lex_state = 71, .external_lex_state = 9},
  [460] = {.lex_state = 71, .external_lex_state = 9},
  [461] = {.lex_state = 197, .external_lex_state = 5},
  [462] = {.lex_state = 72, .external_lex_state = 9},
  [463] = {.lex_state = 71, .external_lex_state = 9},
  [464] = {.lex_state = 71, .external_lex_state = 9},
  [465] = {.lex_state = 60, .external_lex_state = 8},
  [466] = {.lex_state = 60, .external_lex_state = 5},
  [467] = {.lex_state = 71, .external_lex_state = 9},
  [468] = {.lex_state = 8, .external_lex_state = 8},
  [469] = {.lex_state = 66, .external_lex_state = 6},
  [470] = {.lex_state = 71, .external_lex_state = 9},
  [471] = {.lex_state = 197, .external_lex_state = 5},
  [472] = {.lex_state = 71, .external_lex_state = 9},
  [473] = {.lex_state = 197, .external_lex_state = 5},
  [474] = {.lex_state = 71, .external_lex_state = 9},
  [475] = {.lex_state = 71, .external_lex_state = 9},
  [476] = {.lex_state = 71, .external_lex_state = 9},
  [477] = {.lex_state = 195, .external_lex_state = 8},
  [478] = {.lex_state = 71, .external_lex_state = 9},
  [479] = {.lex_state = 71, .external_lex_state = 9},
  [480] = {.lex_state = 8, .external_lex_state = 8},
  [481] = {.lex_state = 71, .external_lex_state = 9},
  [482] = {.lex_state = 195, .external_lex_state = 8},
  [483] = {.lex_state = 60, .external_lex_state = 9},
  [484] = {.lex_state = 8, .external_lex_state = 8},
  [485] = {.lex_state = 72, .external_lex_state = 9},
  [486] = {.lex_state = 60, .external_lex_state = 9},
  [487] = {.lex_state = 60, .external_lex_state = 9},
  [488] = {.lex_state = 8, .external_lex_state = 8},
  [489] = {.lex_state = 60, .external_lex_state = 9},
  [490] = {.lex_state = 60, .external_lex_state = 9},
  [491] = {.lex_state = 25, .external_lex_state = 6},
  [492] = {.lex_state = 60, .external_lex_state = 9},
  [493] = {.lex_state = 8, .external_lex_state = 6},
  [494] = {.lex_state = 197, .external_lex_state = 5},
  [495] = {.lex_state = 63, .external_lex_state = 6},
  [496] = {.lex_state = 197, .external_lex_state = 5},
  [497] = {.lex_state = 197, .external_lex_state = 5},
  [498] = {.lex_state = 195, .external_lex_state = 8},
  [499] = {.lex_state = 66, .external_lex_state = 8},
  [500] = {.lex_state = 195, .external_lex_state = 8},
  [501] = {.lex_state = 66, .external_lex_state = 8},
  [502] = {.lex_state = 195, .external_lex_state = 8},
  [503] = {.lex_state = 60, .external_lex_state = 8},
  [504] = {.lex_state = 66, .external_lex_state = 8},
  [505] = {.lex_state = 66, .external_lex_state = 6},
  [506] = {.lex_state = 60, .external_lex_state = 8},
  [507] = {.lex_state = 193, .external_lex_state = 9},
  [508] = {.lex_state = 197, .external_lex_state = 5},
  [509] = {.lex_state = 66, .external_lex_state = 8},
  [510] = {.lex_state = 197, .external_lex_state = 5},
  [511] = {.lex_state = 71, .external_lex_state = 9},
  [512] = {.lex_state = 66, .external_lex_state = 8},
  [513] = {.lex_state = 63, .external_lex_state = 6},
  [514] = {.lex_state = 66, .external_lex_state = 8},
  [515] = {.lex_state = 197, .external_lex_state = 5},
  [516] = {.lex_state = 71, .external_lex_state = 9},
  [517] = {.lex_state = 66, .external_lex_state = 8},
  [518] = {.lex_state = 8, .external_lex_state = 5},
  [519] = {.lex_state = 66, .external_lex_state = 8},
  [520] = {.lex_state = 71, .external_lex_state = 9},
  [521] = {.lex_state = 195, .external_lex_state = 8},
  [522] = {.lex_state = 66, .external_lex_state = 8},
  [523] = {.lex_state = 66, .external_lex_state = 8},
  [524] = {.lex_state = 71, .external_lex_state = 9},
  [525] = {.lex_state = 66, .external_lex_state = 8},
  [526] = {.lex_state = 195, .external_lex_state = 8},
  [527] = {.lex_state = 66, .external_lex_state = 8},
  [528] = {.lex_state = 195, .external_lex_state = 8},
  [529] = {.lex_state = 66, .external_lex_state = 8},
  [530] = {.lex_state = 66, .external_lex_state = 8},
  [531] = {.lex_state = 195, .external_lex_state = 8},
  [532] = {.lex_state = 66, .external_lex_state = 8},
  [533] = {.lex_state = 66, .external_lex_state = 8},
  [534] = {.lex_state = 66, .external_lex_state = 8},
  [535] = {.lex_state = 197, .external_lex_state = 5},
  [536] = {.lex_state = 63, .external_lex_state = 6},
  [537] = {.lex_state = 66, .external_lex_state = 8},
  [538] = {.lex_state = 60, .external_lex_state = 9},
  [539] = {.lex_state = 66, .external_lex_state = 8},
  [540] = {.lex_state = 66, .external_lex_state = 8},
  [541] = {.lex_state = 71, .external_lex_state = 9},
  [542] = {.lex_state = 71, .external_lex_state = 9},
  [543] = {.lex_state = 8, .external_lex_state = 8},
  [544] = {.lex_state = 8, .external_lex_state = 6},
  [545] = {.lex_state = 60, .external_lex_state = 8},
  [546] = {.lex_state = 72, .external_lex_state = 9},
  [547] = {.lex_state = 193, .external_lex_state = 8},
  [548] = {.lex_state = 193, .external_lex_state = 9},
  [549] = {.lex_state = 193, .external_lex_state = 9},
  [550] = {.lex_state = 193, .external_lex_state = 9},
  [551] = {.lex_state = 193, .external_lex_state = 8},
  [552] = {.lex_state = 193, .external_lex_state = 9},
  [553] = {.lex_state = 193, .external_lex_state = 9},
  [554] = {.lex_state = 193, .external_lex_state = 9},
  [555] = {.lex_state = 193, .external_lex_state = 9},
  [556] = {.lex_state = 193, .external_lex_state = 9},
  [557] = {.lex_state = 193, .external_lex_state = 9},
  [558] = {.lex_state = 193, .external_lex_state = 9},
  [559] = {.lex_state = 193, .external_lex_state = 9},
  [560] = {.lex_state = 193, .external_lex_state = 9},
  [561] = {.lex_state = 193, .external_lex_state = 9},
  [562] = {.lex_state = 193, .external_lex_state = 9},
  [563] = {.lex_state = 193, .external_lex_state = 9},
  [564] = {.lex_state = 193, .external_lex_state = 9},
  [565] = {.lex_state = 193, .external_lex_state = 9},
  [566] = {.lex_state = 193, .external_lex_state = 9},
  [567] = {.lex_state = 193, .external_lex_state = 9},
  [568] = {.lex_state = 193, .external_lex_state = 9},
  [569] = {.lex_state = 193, .external_lex_state = 9},
  [570] = {.lex_state = 193, .external_lex_state = 9},
  [571] = {.lex_state = 195, .external_lex_state = 6},
  [572] = {.lex_state = 193, .external_lex_state = 9},
  [573] = {.lex_state = 193, .external_lex_state = 9},
  [574] = {.lex_state = 193, .external_lex_state = 9},
  [575] = {.lex_state = 193, .external_lex_state = 9},
  [576] = {.lex_state = 193, .external_lex_state = 5},
  [577] = {.lex_state = 193, .external_lex_state = 8},
  [578] = {.lex_state = 197, .external_lex_state = 9},
  [579] = {.lex_state = 60, .external_lex_state = 5},
  [580] = {.lex_state = 197, .external_lex_state = 9},
  [581] = {.lex_state = 60, .external_lex_state = 5},
  [582] = {.lex_state = 197, .external_lex_state = 9},
  [583] = {.lex_state = 60, .external_lex_state = 5},
  [584] = {.lex_state = 197, .external_lex_state = 9},
  [585] = {.lex_state = 197, .external_lex_state = 9},
  [586] = {.lex_state = 72, .external_lex_state = 5},
  [587] = {.lex_state = 197, .external_lex_state = 9},
  [588] = {.lex_state = 193, .external_lex_state = 8},
  [589] = {.lex_state = 193, .external_lex_state = 8},
  [590] = {.lex_state = 186, .external_lex_state = 6},
  [591] = {.lex_state = 193, .external_lex_state = 5},
  [592] = {.lex_state = 193, .external_lex_state = 8},
  [593] = {.lex_state = 193, .external_lex_state = 9},
  [594] = {.lex_state = 193, .external_lex_state = 9},
  [595] = {.lex_state = 193, .external_lex_state = 9},
  [596] = {.lex_state = 193, .external_lex_state = 9},
  [597] = {.lex_state = 193, .external_lex_state = 9},
  [598] = {.lex_state = 193, .external_lex_state = 9},
  [599] = {.lex_state = 193, .external_lex_state = 9},
  [600] = {.lex_state = 193, .external_lex_state = 9},
  [601] = {.lex_state = 193, .external_lex_state = 9},
  [602] = {.lex_state = 193, .external_lex_state = 9},
  [603] = {.lex_state = 71, .external_lex_state = 5},
  [604] = {.lex_state = 193, .external_lex_state = 9},
  [605] = {.lex_state = 193, .external_lex_state = 9},
  [606] = {.lex_state = 193, .external_lex_state = 9},
  [607] = {.lex_state = 193, .external_lex_state = 9},
  [608] = {.lex_state = 71, .external_lex_state = 5},
  [609] = {.lex_state = 193, .external_lex_state = 9},
  [610] = {.lex_state = 193, .external_lex_state = 9},
  [611] = {.lex_state = 193, .external_lex_state = 9},
  [612] = {.lex_state = 193, .external_lex_state = 9},
  [613] = {.lex_state = 193, .external_lex_state = 9},
  [614] = {.lex_state = 193, .external_lex_state = 9},
  [615] = {.lex_state = 193, .external_lex_state = 9},
  [616] = {.lex_state = 71, .external_lex_state = 5},
  [617] = {.lex_state = 193, .external_lex_state = 9},
  [618] = {.lex_state = 193, .external_lex_state = 9},
  [619] = {.lex_state = 193, .external_lex_state = 9},
  [620] = {.lex_state = 193, .external_lex_state = 9},
  [621] = {.lex_state = 193, .external_lex_state = 9},
  [622] = {.lex_state = 195, .external_lex_state = 8},
  [623] = {.lex_state = 195, .external_lex_state = 8},
  [624] = {.lex_state = 195, .external_lex_state = 8},
  [625] = {.lex_state = 193, .external_lex_state = 5},
  [626] = {.lex_state = 195, .external_lex_state = 8},
  [627] = {.lex_state = 195, .external_lex_state = 8},
  [628] = {.lex_state = 195, .external_lex_state = 8},
  [629] = {.lex_state = 195, .external_lex_state = 8},
  [630] = {.lex_state = 195, .external_lex_state = 8},
  [631] = {.lex_state = 8, .external_lex_state = 6},
  [632] = {.lex_state = 195, .external_lex_state = 8},
  [633] = {.lex_state = 195, .external_lex_state = 8},
  [634] = {.lex_state = 195, .external_lex_state = 8},
  [635] = {.lex_state = 195, .external_lex_state = 8},
  [636] = {.lex_state = 195, .external_lex_state = 8},
  [637] = {.lex_state = 195, .external_lex_state = 8},
  [638] = {.lex_state = 195, .external_lex_state = 8},
  [639] = {.lex_state = 197, .external_lex_state = 9},
  [640] = {.lex_state = 71, .external_lex_state = 5},
  [641] = {.lex_state = 195, .external_lex_state = 8},
  [642] = {.lex_state = 195, .external_lex_state = 8},
  [643] = {.lex_state = 195, .external_lex_state = 6},
  [644] = {.lex_state = 195, .external_lex_state = 8},
  [645] = {.lex_state = 195, .external_lex_state = 6},
  [646] = {.lex_state = 195, .external_lex_state = 8},
  [647] = {.lex_state = 60, .external_lex_state = 8},
  [648] = {.lex_state = 66, .external_lex_state = 6},
  [649] = {.lex_state = 60, .external_lex_state = 8},
  [650] = {.lex_state = 66, .external_lex_state = 6},
  [651] = {.lex_state = 195, .external_lex_state = 6},
  [652] = {.lex_state = 195, .external_lex_state = 8},
  [653] = {.lex_state = 195, .external_lex_state = 8},
  [654] = {.lex_state = 195, .external_lex_state = 8},
  [655] = {.lex_state = 195, .external_lex_state = 8},
  [656] = {.lex_state = 195, .external_lex_state = 8},
  [657] = {.lex_state = 60, .external_lex_state = 8},
  [658] = {.lex_state = 60, .external_lex_state = 8},
  [659] = {.lex_state = 193, .external_lex_state = 8},
  [660] = {.lex_state = 60, .external_lex_state = 8},
  [661] = {.lex_state = 195, .external_lex_state = 6},
  [662] = {.lex_state = 60, .external_lex_state = 8},
  [663] = {.lex_state = 193, .external_lex_state = 5},
  [664] = {.lex_state = 193, .external_lex_state = 5},
  [665] = {.lex_state = 72, .external_lex_state = 9},
  [666] = {.lex_state = 72, .external_lex_state = 9},
  [667] = {.lex_state = 195, .external_lex_state = 6},
  [668] = {.lex_state = 60, .external_lex_state = 5},
  [669] = {.lex_state = 193, .external_lex_state = 5},
  [670] = {.lex_state = 66, .external_lex_state = 6},
  [671] = {.lex_state = 193, .external_lex_state = 8},
  [672] = {.lex_state = 195, .external_lex_state = 8},
  [673] = {.lex_state = 72, .external_lex_state = 9},
  [674] = {.lex_state = 72, .external_lex_state = 9},
  [675] = {.lex_state = 195, .external_lex_state = 8},
  [676] = {.lex_state = 195, .external_lex_state = 8},
  [677] = {.lex_state = 195, .external_lex_state = 8},
  [678] = {.lex_state = 195, .external_lex_state = 8},
  [679] = {.lex_state = 195, .external_lex_state = 8},
  [680] = {.lex_state = 195, .external_lex_state = 8},
  [681] = {.lex_state = 195, .external_lex_state = 8},
  [682] = {.lex_state = 195, .external_lex_state = 8},
  [683] = {.lex_state = 197, .external_lex_state = 9},
  [684] = {.lex_state = 195, .external_lex_state = 8},
  [685] = {.lex_state = 195, .external_lex_state = 8},
  [686] = {.lex_state = 195, .external_lex_state = 8},
  [687] = {.lex_state = 195, .external_lex_state = 8},
  [688] = {.lex_state = 26, .external_lex_state = 6},
  [689] = {.lex_state = 72, .external_lex_state = 9},
  [690] = {.lex_state = 72, .external_lex_state = 9},
  [691] = {.lex_state = 72, .external_lex_state = 9},
  [692] = {.lex_state = 72, .external_lex_state = 9},
  [693] = {.lex_state = 72, .external_lex_state = 9},
  [694] = {.lex_state = 72, .external_lex_state = 9},
  [695] = {.lex_state = 72, .external_lex_state = 9},
  [696] = {.lex_state = 195, .external_lex_state = 8},
  [697] = {.lex_state = 195, .external_lex_state = 8},
  [698] = {.lex_state = 195, .external_lex_state = 8},
  [699] = {.lex_state = 195, .external_lex_state = 8},
  [700] = {.lex_state = 72, .external_lex_state = 9},
  [701] = {.lex_state = 72, .external_lex_state = 9},
  [702] = {.lex_state = 72, .external_lex_state = 9},
  [703] = {.lex_state = 72, .external_lex_state = 9},
  [704] = {.lex_state = 72, .external_lex_state = 9},
  [705] = {.lex_state = 72, .external_lex_state = 9},
  [706] = {.lex_state = 195, .external_lex_state = 8},
  [707] = {.lex_state = 195, .external_lex_state = 8},
  [708] = {.lex_state = 195, .external_lex_state = 8},
  [709] = {.lex_state = 195, .external_lex_state = 8},
  [710] = {.lex_state = 195, .external_lex_state = 8},
  [711] = {.lex_state = 72, .external_lex_state = 9},
  [712] = {.lex_state = 72, .external_lex_state = 9},
  [713] = {.lex_state = 72, .external_lex_state = 9},
  [714] = {.lex_state = 72, .external_lex_state = 9},
  [715] = {.lex_state = 72, .external_lex_state = 5},
  [716] = {.lex_state = 72, .external_lex_state = 9},
  [717] = {.lex_state = 195, .external_lex_state = 8},
  [718] = {.lex_state = 195, .external_lex_state = 8},
  [719] = {.lex_state = 72, .external_lex_state = 9},
  [720] = {.lex_state = 72, .external_lex_state = 9},
  [721] = {.lex_state = 60, .external_lex_state = 8},
  [722] = {.lex_state = 60, .external_lex_state = 8},
  [723] = {.lex_state = 60, .external_lex_state = 8},
  [724] = {.lex_state = 60, .external_lex_state = 8},
  [725] = {.lex_state = 60, .external_lex_state = 8},
  [726] = {.lex_state = 60, .external_lex_state = 8},
  [727] = {.lex_state = 60, .external_lex_state = 8},
  [728] = {.lex_state = 60, .external_lex_state = 8},
  [729] = {.lex_state = 60, .external_lex_state = 8},
  [730] = {.lex_state = 60, .external_lex_state = 8},
  [731] = {.lex_state = 60, .external_lex_state = 8},
  [732] = {.lex_state = 60, .external_lex_state = 8},
  [733] = {.lex_state = 60, .external_lex_state = 8},
  [734] = {.lex_state = 195, .external_lex_state = 6},
  [735] = {.lex_state = 195, .external_lex_state = 6},
  [736] = {.lex_state = 66, .external_lex_state = 6},
  [737] = {.lex_state = 60, .external_lex_state = 8},
  [738] = {.lex_state = 60, .external_lex_state = 8},
  [739] = {.lex_state = 60, .external_lex_state = 8},
  [740] = {.lex_state = 195, .external_lex_state = 8},
  [741] = {.lex_state = 60, .external_lex_state = 6},
  [742] = {.lex_state = 60, .external_lex_state = 8},
  [743] = {.lex_state = 60, .external_lex_state = 8},
  [744] = {.lex_state = 60, .external_lex_state = 8},
  [745] = {.lex_state = 60, .external_lex_state = 6},
  [746] = {.lex_state = 195, .external_lex_state = 8},
  [747] = {.lex_state = 195, .external_lex_state = 8},
  [748] = {.lex_state = 195, .external_lex_state = 8},
  [749] = {.lex_state = 72, .external_lex_state = 9},
  [750] = {.lex_state = 197, .external_lex_state = 9},
  [751] = {.lex_state = 197, .external_lex_state = 9},
  [752] = {.lex_state = 193, .external_lex_state = 8},
  [753] = {.lex_state = 193, .external_lex_state = 5},
  [754] = {.lex_state = 197, .external_lex_state = 5},
  [755] = {.lex_state = 195, .external_lex_state = 6},
  [756] = {.lex_state = 193, .external_lex_state = 8},
  [757] = {.lex_state = 195, .external_lex_state = 6},
  [758] = {.lex_state = 193, .external_lex_state = 8},
  [759] = {.lex_state = 193, .external_lex_state = 8},
  [760] = {.lex_state = 193, .external_lex_state = 8},
  [761] = {.lex_state = 193, .external_lex_state = 8},
  [762] = {.lex_state = 193, .external_lex_state = 8},
  [763] = {.lex_state = 96, .external_lex_state = 2},
  [764] = {.lex_state = 193, .external_lex_state = 8},
  [765] = {.lex_state = 193, .external_lex_state = 8},
  [766] = {.lex_state = 193, .external_lex_state = 5},
  [767] = {.lex_state = 195, .external_lex_state = 6},
  [768] = {.lex_state = 193, .external_lex_state = 8},
  [769] = {.lex_state = 193, .external_lex_state = 5},
  [770] = {.lex_state = 193, .external_lex_state = 8},
  [771] = {.lex_state = 96, .external_lex_state = 2},
  [772] = {.lex_state = 193, .external_lex_state = 8},
  [773] = {.lex_state = 193, .external_lex_state = 8},
  [774] = {.lex_state = 193, .external_lex_state = 5},
  [775] = {.lex_state = 193, .external_lex_state = 8},
  [776] = {.lex_state = 60, .external_lex_state = 6},
  [777] = {.lex_state = 193, .external_lex_state = 8},
  [778] = {.lex_state = 193, .external_lex_state = 8},
  [779] = {.lex_state = 72, .external_lex_state = 5},
  [780] = {.lex_state = 193, .external_lex_state = 8},
  [781] = {.lex_state = 193, .external_lex_state = 8},
  [782] = {.lex_state = 193, .external_lex_state = 8},
  [783] = {.lex_state = 193, .external_lex_state = 8},
  [784] = {.lex_state = 193, .external_lex_state = 8},
  [785] = {.lex_state = 193, .external_lex_state = 8},
  [786] = {.lex_state = 193, .external_lex_state = 8},
  [787] = {.lex_state = 193, .external_lex_state = 8},
  [788] = {.lex_state = 193, .external_lex_state = 8},
  [789] = {.lex_state = 193, .external_lex_state = 8},
  [790] = {.lex_state = 193, .external_lex_state = 8},
  [791] = {.lex_state = 193, .external_lex_state = 8},
  [792] = {.lex_state = 193, .external_lex_state = 8},
  [793] = {.lex_state = 195, .external_lex_state = 6},
  [794] = {.lex_state = 193, .external_lex_state = 6},
  [795] = {.lex_state = 193, .external_lex_state = 8},
  [796] = {.lex_state = 193, .external_lex_state = 8},
  [797] = {.lex_state = 193, .external_lex_state = 8},
  [798] = {.lex_state = 193, .external_lex_state = 8},
  [799] = {.lex_state = 197, .external_lex_state = 5},
  [800] = {.lex_state = 193, .external_lex_state = 8},
  [801] = {.lex_state = 193, .external_lex_state = 8},
  [802] = {.lex_state = 193, .external_lex_state = 6},
  [803] = {.lex_state = 197, .external_lex_state = 9},
  [804] = {.lex_state = 197, .external_lex_state = 9},
  [805] = {.lex_state = 197, .external_lex_state = 9},
  [806] = {.lex_state = 193, .external_lex_state = 8},
  [807] = {.lex_state = 193, .external_lex_state = 5},
  [808] = {.lex_state = 197, .external_lex_state = 9},
  [809] = {.lex_state = 197, .external_lex_state = 9},
  [810] = {.lex_state = 197, .external_lex_state = 9},
  [811] = {.lex_state = 193, .external_lex_state = 8},
  [812] = {.lex_state = 197, .external_lex_state = 9},
  [813] = {.lex_state = 197, .external_lex_state = 9},
  [814] = {.lex_state = 197, .external_lex_state = 9},
  [815] = {.lex_state = 197, .external_lex_state = 9},
  [816] = {.lex_state = 96, .external_lex_state = 2},
  [817] = {.lex_state = 195, .external_lex_state = 6},
  [818] = {.lex_state = 197, .external_lex_state = 9},
  [819] = {.lex_state = 96, .external_lex_state = 2},
  [820] = {.lex_state = 193, .external_lex_state = 6},
  [821] = {.lex_state = 197, .external_lex_state = 9},
  [822] = {.lex_state = 197, .external_lex_state = 9},
  [823] = {.lex_state = 197, .external_lex_state = 9},
  [824] = {.lex_state = 197, .external_lex_state = 9},
  [825] = {.lex_state = 197, .external_lex_state = 9},
  [826] = {.lex_state = 197, .external_lex_state = 9},
  [827] = {.lex_state = 197, .external_lex_state = 9},
  [828] = {.lex_state = 186, .external_lex_state = 6},
  [829] = {.lex_state = 197, .external_lex_state = 9},
  [830] = {.lex_state = 195, .external_lex_state = 6},
  [831] = {.lex_state = 96, .external_lex_state = 2},
  [832] = {.lex_state = 197, .external_lex_state = 9},
  [833] = {.lex_state = 197, .external_lex_state = 9},
  [834] = {.lex_state = 197, .external_lex_state = 9},
  [835] = {.lex_state = 197, .external_lex_state = 9},
  [836] = {.lex_state = 195, .external_lex_state = 6},
  [837] = {.lex_state = 197, .external_lex_state = 9},
  [838] = {.lex_state = 197, .external_lex_state = 9},
  [839] = {.lex_state = 193, .external_lex_state = 5},
  [840] = {.lex_state = 197, .external_lex_state = 9},
  [841] = {.lex_state = 195, .external_lex_state = 6},
  [842] = {.lex_state = 197, .external_lex_state = 9},
  [843] = {.lex_state = 197, .external_lex_state = 9},
  [844] = {.lex_state = 197, .external_lex_state = 9},
  [845] = {.lex_state = 197, .external_lex_state = 9},
  [846] = {.lex_state = 197, .external_lex_state = 9},
  [847] = {.lex_state = 197, .external_lex_state = 9},
  [848] = {.lex_state = 197, .external_lex_state = 5},
  [849] = {.lex_state = 197, .external_lex_state = 9},
  [850] = {.lex_state = 193, .external_lex_state = 5},
  [851] = {.lex_state = 72, .external_lex_state = 5},
  [852] = {.lex_state = 197, .external_lex_state = 9},
  [853] = {.lex_state = 197, .external_lex_state = 9},
  [854] = {.lex_state = 197, .external_lex_state = 9},
  [855] = {.lex_state = 193, .external_lex_state = 8},
  [856] = {.lex_state = 193, .external_lex_state = 8},
  [857] = {.lex_state = 72, .external_lex_state = 5},
  [858] = {.lex_state = 197, .external_lex_state = 9},
  [859] = {.lex_state = 197, .external_lex_state = 9},
  [860] = {.lex_state = 197, .external_lex_state = 9},
  [861] = {.lex_state = 197, .external_lex_state = 9},
  [862] = {.lex_state = 197, .external_lex_state = 9},
  [863] = {.lex_state = 197, .external_lex_state = 9},
  [864] = {.lex_state = 197, .external_lex_state = 5},
  [865] = {.lex_state = 197, .external_lex_state = 9},
  [866] = {.lex_state = 197, .external_lex_state = 9},
  [867] = {.lex_state = 197, .external_lex_state = 9},
  [868] = {.lex_state = 72, .external_lex_state = 5},
  [869] = {.lex_state = 193, .external_lex_state = 8},
  [870] = {.lex_state = 193, .external_lex_state = 6},
  [871] = {.lex_state = 193, .external_lex_state = 8},
  [872] = {.lex_state = 197, .external_lex_state = 9},
  [873] = {.lex_state = 197, .external_lex_state = 9},
  [874] = {.lex_state = 197, .external_lex_state = 9},
  [875] = {.lex_state = 197, .external_lex_state = 9},
  [876] = {.lex_state = 197, .external_lex_state = 9},
  [877] = {.lex_state = 193, .external_lex_state = 8},
  [878] = {.lex_state = 193, .external_lex_state = 8},
  [879] = {.lex_state = 193, .external_lex_state = 8},
  [880] = {.lex_state = 193, .external_lex_state = 8},
  [881] = {.lex_state = 193, .external_lex_state = 8},
  [882] = {.lex_state = 193, .external_lex_state = 8},
  [883] = {.lex_state = 193, .external_lex_state = 8},
  [884] = {.lex_state = 193, .external_lex_state = 8},
  [885] = {.lex_state = 193, .external_lex_state = 8},
  [886] = {.lex_state = 193, .external_lex_state = 8},
  [887] = {.lex_state = 193, .external_lex_state = 8},
  [888] = {.lex_state = 193, .external_lex_state = 5},
  [889] = {.lex_state = 33, .external_lex_state = 10},
  [890] = {.lex_state = 193, .external_lex_state = 6},
  [891] = {.lex_state = 197, .external_lex_state = 5},
  [892] = {.lex_state = 193, .external_lex_state = 6},
  [893] = {.lex_state = 197, .external_lex_state = 5},
  [894] = {.lex_state = 197, .external_lex_state = 5},
  [895] = {.lex_state = 197, .external_lex_state = 5},
  [896] = {.lex_state = 197, .external_lex_state = 5},
  [897] = {.lex_state = 197, .external_lex_state = 5},
  [898] = {.lex_state = 197, .external_lex_state = 5},
  [899] = {.lex_state = 197, .external_lex_state = 5},
  [900] = {.lex_state = 36, .external_lex_state = 10},
  [901] = {.lex_state = 36, .external_lex_state = 10},
  [902] = {.lex_state = 36, .external_lex_state = 10},
  [903] = {.lex_state = 36, .external_lex_state = 10},
  [904] = {.lex_state = 89},
  [905] = {.lex_state = 36, .external_lex_state = 10},
  [906] = {.lex_state = 36, .external_lex_state = 10},
  [907] = {.lex_state = 36, .external_lex_state = 10},
  [908] = {.lex_state = 78, .external_lex_state = 2},
  [909] = {.lex_state = 36, .external_lex_state = 10},
  [910] = {.lex_state = 36, .external_lex_state = 10},
  [911] = {.lex_state = 88, .external_lex_state = 11},
  [912] = {.lex_state = 88},
  [913] = {.lex_state = 84},
  [914] = {.lex_state = 93, .external_lex_state = 12},
  [915] = {.lex_state = 94, .external_lex_state = 13},
  [916] = {.lex_state = 93, .external_lex_state = 12},
  [917] = {.lex_state = 94, .external_lex_state = 13},
  [918] = {.lex_state = 93, .external_lex_state = 12},
  [919] = {.lex_state = 93, .external_lex_state = 12},
  [920] = {.lex_state = 93, .external_lex_state = 12},
  [921] = {.lex_state = 93, .external_lex_state = 12},
  [922] = {.lex_state = 93, .external_lex_state = 12},
  [923] = {.lex_state = 94, .external_lex_state = 13},
  [924] = {.lex_state = 93, .external_lex_state = 12},
  [925] = {.lex_state = 93, .external_lex_state = 12},
  [926] = {.lex_state = 93, .external_lex_state = 12},
  [927] = {.lex_state = 94, .external_lex_state = 13},
  [928] = {.lex_state = 94, .external_lex_state = 13},
  [929] = {.lex_state = 94, .external_lex_state = 13},
  [930] = {.lex_state = 94, .external_lex_state = 13},
  [931] = {.lex_state = 94, .external_lex_state = 13},
  [932] = {.lex_state = 94, .external_lex_state = 13},
  [933] = {.lex_state = 94, .external_lex_state = 13},
  [934] = {.lex_state = 84},
  [935] = {.lex_state = 93, .external_lex_state = 12},
  [936] = {.lex_state = 93, .external_lex_state = 12},
  [937] = {.lex_state = 94, .external_lex_state = 13},
  [938] = {.lex_state = 93, .external_lex_state = 12},
  [939] = {.lex_state = 94, .external_lex_state = 13},
  [940] = {.lex_state = 93, .external_lex_state = 12},
  [941] = {.lex_state = 93, .external_lex_state = 12},
  [942] = {.lex_state = 93, .external_lex_state = 12},
  [943] = {.lex_state = 93, .external_lex_state = 12},
  [944] = {.lex_state = 93, .external_lex_state = 12},
  [945] = {.lex_state = 93, .external_lex_state = 12},
  [946] = {.lex_state = 93, .external_lex_state = 12},
  [947] = {.lex_state = 93, .external_lex_state = 12},
  [948] = {.lex_state = 94, .external_lex_state = 13},
  [949] = {.lex_state = 94, .external_lex_state = 13},
  [950] = {.lex_state = 94, .external_lex_state = 13},
  [951] = {.lex_state = 94, .external_lex_state = 13},
  [952] = {.lex_state = 94, .external_lex_state = 13},
  [953] = {.lex_state = 94, .external_lex_state = 13},
  [954] = {.lex_state = 94, .external_lex_state = 13},
  [955] = {.lex_state = 94, .external_lex_state = 13},
  [956] = {.lex_state = 93, .external_lex_state = 12},
  [957] = {.lex_state = 93, .external_lex_state = 12},
  [958] = {.lex_state = 93, .external_lex_state = 12},
  [959] = {.lex_state = 93, .external_lex_state = 12},
  [960] = {.lex_state = 93, .external_lex_state = 12},
  [961] = {.lex_state = 93, .external_lex_state = 12},
  [962] = {.lex_state = 94, .external_lex_state = 13},
  [963] = {.lex_state = 94, .external_lex_state = 13},
  [964] = {.lex_state = 93, .external_lex_state = 12},
  [965] = {.lex_state = 94, .external_lex_state = 13},
  [966] = {.lex_state = 94, .external_lex_state = 13},
  [967] = {.lex_state = 94, .external_lex_state = 13},
  [968] = {.lex_state = 93, .external_lex_state = 12},
  [969] = {.lex_state = 94, .external_lex_state = 13},
  [970] = {.lex_state = 93, .external_lex_state = 12},
  [971] = {.lex_state = 94, .external_lex_state = 13},
  [972] = {.lex_state = 94, .external_lex_state = 13},
  [973] = {.lex_state = 94, .external_lex_state = 13},
  [974] = {.lex_state = 93, .external_lex_state = 12},
  [975] = {.lex_state = 93, .external_lex_state = 12},
  [976] = {.lex_state = 93, .external_lex_state = 12},
  [977] = {.lex_state = 93, .external_lex_state = 12},
  [978] = {.lex_state = 93, .external_lex_state = 12},
  [979] = {.lex_state = 94, .external_lex_state = 13},
  [980] = {.lex_state = 94, .external_lex_state = 13},
  [981] = {.lex_state = 94, .external_lex_state = 13},
  [982] = {.lex_state = 94, .external_lex_state = 13},
  [983] = {.lex_state = 94, .external_lex_state = 13},
  [984] = {.lex_state = 93, .external_lex_state = 12},
  [985] = {.lex_state = 93, .external_lex_state = 12},
  [986] = {.lex_state = 93, .external_lex_state = 12},
  [987] = {.lex_state = 94, .external_lex_state = 13},
  [988] = {.lex_state = 94, .external_lex_state = 13},
  [989] = {.lex_state = 94, .external_lex_state = 13},
  [990] = {.lex_state = 94, .external_lex_state = 13},
  [991] = {.lex_state = 84},
  [992] = {.lex_state = 93, .external_lex_state = 12},
  [993] = {.lex_state = 84},
  [994] = {.lex_state = 84},
  [995] = {.lex_state = 93, .external_lex_state = 12},
  [996] = {.lex_state = 94, .external_lex_state = 13},
  [997] = {.lex_state = 84},
  [998] = {.lex_state = 94, .external_lex_state = 13},
  [999] = {.lex_state = 94, .external_lex_state = 13},
  [1000] = {.lex_state = 94, .external_lex_state = 13},
  [1001] = {.lex_state = 94, .external_lex_state = 13},
  [1002] = {.lex_state = 94, .external_lex_state = 13},
  [1003] = {.lex_state = 94, .external_lex_state = 13},
  [1004] = {.lex_state = 94, .external_lex_state = 13},
  [1005] = {.lex_state = 94, .external_lex_state = 13},
  [1006] = {.lex_state = 93, .external_lex_state = 12},
  [1007] = {.lex_state = 93, .external_lex_state = 12},
  [1008] = {.lex_state = 94, .external_lex_state = 13},
  [1009] = {.lex_state = 94, .external_lex_state = 13},
  [1010] = {.lex_state = 93, .external_lex_state = 12},
  [1011] = {.lex_state = 93, .external_lex_state = 12},
  [1012] = {.lex_state = 93, .external_lex_state = 12},
  [1013] = {.lex_state = 93, .external_lex_state = 12},
  [1014] = {.lex_state = 93, .external_lex_state = 12},
  [1015] = {.lex_state = 93, .external_lex_state = 12},
  [1016] = {.lex_state = 84},
  [1017] = {.lex_state = 84},
  [1018] = {.lex_state = 84},
  [1019] = {.lex_state = 94, .external_lex_state = 13},
  [1020] = {.lex_state = 93, .external_lex_state = 12},
  [1021] = {.lex_state = 84},
  [1022] = {.lex_state = 94, .external_lex_state = 13},
  [1023] = {.lex_state = 94, .external_lex_state = 13},
  [1024] = {.lex_state = 84},
  [1025] = {.lex_state = 94, .external_lex_state = 13},
  [1026] = {.lex_state = 93, .external_lex_state = 12},
  [1027] = {.lex_state = 93, .external_lex_state = 12},
  [1028] = {.lex_state = 93, .external_lex_state = 12},
  [1029] = {.lex_state = 93, .external_lex_state = 12},
  [1030] = {.lex_state = 93, .external_lex_state = 12},
  [1031] = {.lex_state = 93, .external_lex_state = 12},
  [1032] = {.lex_state = 94, .external_lex_state = 13},
  [1033] = {.lex_state = 94, .external_lex_state = 13},
  [1034] = {.lex_state = 94, .external_lex_state = 13},
  [1035] = {.lex_state = 93, .external_lex_state = 12},
  [1036] = {.lex_state = 94, .external_lex_state = 13},
  [1037] = {.lex_state = 94, .external_lex_state = 13},
  [1038] = {.lex_state = 94, .external_lex_state = 13},
  [1039] = {.lex_state = 94, .external_lex_state = 13},
  [1040] = {.lex_state = 94, .external_lex_state = 13},
  [1041] = {.lex_state = 84, .external_lex_state = 14},
  [1042] = {.lex_state = 94, .external_lex_state = 13},
  [1043] = {.lex_state = 93, .external_lex_state = 12},
  [1044] = {.lex_state = 94, .external_lex_state = 13},
  [1045] = {.lex_state = 94, .external_lex_state = 13},
  [1046] = {.lex_state = 93, .external_lex_state = 12},
  [1047] = {.lex_state = 94, .external_lex_state = 13},
  [1048] = {.lex_state = 94, .external_lex_state = 13},
  [1049] = {.lex_state = 93, .external_lex_state = 12},
  [1050] = {.lex_state = 94, .external_lex_state = 13},
  [1051] = {.lex_state = 94, .external_lex_state = 13},
  [1052] = {.lex_state = 93, .external_lex_state = 12},
  [1053] = {.lex_state = 94, .external_lex_state = 13},
  [1054] = {.lex_state = 93, .external_lex_state = 12},
  [1055] = {.lex_state = 93, .external_lex_state = 12},
  [1056] = {.lex_state = 94, .external_lex_state = 13},
  [1057] = {.lex_state = 94, .external_lex_state = 13},
  [1058] = {.lex_state = 93, .external_lex_state = 12},
  [1059] = {.lex_state = 93, .external_lex_state = 12},
  [1060] = {.lex_state = 93, .external_lex_state = 12},
  [1061] = {.lex_state = 93, .external_lex_state = 12},
  [1062] = {.lex_state = 93, .external_lex_state = 12},
  [1063] = {.lex_state = 93, .external_lex_state = 12},
  [1064] = {.lex_state = 93, .external_lex_state = 12},
  [1065] = {.lex_state = 93, .external_lex_state = 12},
  [1066] = {.lex_state = 94, .external_lex_state = 13},
  [1067] = {.lex_state = 94, .external_lex_state = 13},
  [1068] = {.lex_state = 94, .external_lex_state = 13},
  [1069] = {.lex_state = 94, .external_lex_state = 13},
  [1070] = {.lex_state = 93, .external_lex_state = 12},
  [1071] = {.lex_state = 94, .external_lex_state = 13},
  [1072] = {.lex_state = 93, .external_lex_state = 12},
  [1073] = {.lex_state = 94, .external_lex_state = 13},
  [1074] = {.lex_state = 93, .external_lex_state = 12},
  [1075] = {.lex_state = 93, .external_lex_state = 12},
  [1076] = {.lex_state = 93, .external_lex_state = 12},
  [1077] = {.lex_state = 93, .external_lex_state = 12},
  [1078] = {.lex_state = 94, .external_lex_state = 13},
  [1079] = {.lex_state = 94, .external_lex_state = 13},
  [1080] = {.lex_state = 93, .external_lex_state = 12},
  [1081] = {.lex_state = 94, .external_lex_state = 13},
  [1082] = {.lex_state = 94, .external_lex_state = 13},
  [1083] = {.lex_state = 94, .external_lex_state = 13},
  [1084] = {.lex_state = 94, .external_lex_state = 13},
  [1085] = {.lex_state = 94, .external_lex_state = 13},
  [1086] = {.lex_state = 93, .external_lex_state = 12},
  [1087] = {.lex_state = 93, .external_lex_state = 12},
  [1088] = {.lex_state = 93, .external_lex_state = 12},
  [1089] = {.lex_state = 93, .external_lex_state = 12},
  [1090] = {.lex_state = 94, .external_lex_state = 13},
  [1091] = {.lex_state = 93, .external_lex_state = 12},
  [1092] = {.lex_state = 93, .external_lex_state = 12},
  [1093] = {.lex_state = 93, .external_lex_state = 12},
  [1094] = {.lex_state = 94, .external_lex_state = 13},
  [1095] = {.lex_state = 94, .external_lex_state = 13},
  [1096] = {.lex_state = 94, .external_lex_state = 13},
  [1097] = {.lex_state = 84, .external_lex_state = 14},
  [1098] = {.lex_state = 94, .external_lex_state = 13},
  [1099] = {.lex_state = 93, .external_lex_state = 12},
  [1100] = {.lex_state = 93, .external_lex_state = 12},
  [1101] = {.lex_state = 84, .external_lex_state = 14},
  [1102] = {.lex_state = 84},
  [1103] = {.lex_state = 93, .external_lex_state = 12},
  [1104] = {.lex_state = 94, .external_lex_state = 13},
  [1105] = {.lex_state = 94, .external_lex_state = 13},
  [1106] = {.lex_state = 94, .external_lex_state = 13},
  [1107] = {.lex_state = 93, .external_lex_state = 12},
  [1108] = {.lex_state = 93, .external_lex_state = 12},
  [1109] = {.lex_state = 94, .external_lex_state = 13},
  [1110] = {.lex_state = 94, .external_lex_state = 13},
  [1111] = {.lex_state = 93, .external_lex_state = 12},
  [1112] = {.lex_state = 93, .external_lex_state = 12},
  [1113] = {.lex_state = 94, .external_lex_state = 13},
  [1114] = {.lex_state = 93, .external_lex_state = 12},
  [1115] = {.lex_state = 94, .external_lex_state = 13},
  [1116] = {.lex_state = 94, .external_lex_state = 13},
  [1117] = {.lex_state = 93, .external_lex_state = 12},
  [1118] = {.lex_state = 93, .external_lex_state = 12},
  [1119] = {.lex_state = 94, .external_lex_state = 13},
  [1120] = {.lex_state = 94, .external_lex_state = 13},
  [1121] = {.lex_state = 94, .external_lex_state = 13},
  [1122] = {.lex_state = 93, .external_lex_state = 12},
  [1123] = {.lex_state = 94, .external_lex_state = 13},
  [1124] = {.lex_state = 94, .external_lex_state = 13},
  [1125] = {.lex_state = 93, .external_lex_state = 12},
  [1126] = {.lex_state = 84, .external_lex_state = 14},
  [1127] = {.lex_state = 93, .external_lex_state = 12},
  [1128] = {.lex_state = 93, .external_lex_state = 12},
  [1129] = {.lex_state = 93, .external_lex_state = 12},
  [1130] = {.lex_state = 94, .external_lex_state = 13},
  [1131] = {.lex_state = 94, .external_lex_state = 13},
  [1132] = {.lex_state = 94, .external_lex_state = 13},
  [1133] = {.lex_state = 94, .external_lex_state = 13},
  [1134] = {.lex_state = 94, .external_lex_state = 13},
  [1135] = {.lex_state = 94, .external_lex_state = 13},
  [1136] = {.lex_state = 94, .external_lex_state = 13},
  [1137] = {.lex_state = 93, .external_lex_state = 12},
  [1138] = {.lex_state = 94, .external_lex_state = 13},
  [1139] = {.lex_state = 94, .external_lex_state = 13},
  [1140] = {.lex_state = 94, .external_lex_state = 13},
  [1141] = {.lex_state = 94, .external_lex_state = 13},
  [1142] = {.lex_state = 93, .external_lex_state = 12},
  [1143] = {.lex_state = 93, .external_lex_state = 12},
  [1144] = {.lex_state = 93, .external_lex_state = 12},
  [1145] = {.lex_state = 93, .external_lex_state = 12},
  [1146] = {.lex_state = 93, .external_lex_state = 12},
  [1147] = {.lex_state = 94, .external_lex_state = 13},
  [1148] = {.lex_state = 94, .external_lex_state = 13},
  [1149] = {.lex_state = 94, .external_lex_state = 13},
  [1150] = {.lex_state = 93, .external_lex_state = 12},
  [1151] = {.lex_state = 93, .external_lex_state = 12},
  [1152] = {.lex_state = 94, .external_lex_state = 13},
  [1153] = {.lex_state = 94, .external_lex_state = 13},
  [1154] = {.lex_state = 94, .external_lex_state = 13},
  [1155] = {.lex_state = 93, .external_lex_state = 12},
  [1156] = {.lex_state = 93, .external_lex_state = 12},
  [1157] = {.lex_state = 94, .external_lex_state = 13},
  [1158] = {.lex_state = 93, .external_lex_state = 12},
  [1159] = {.lex_state = 94, .external_lex_state = 13},
  [1160] = {.lex_state = 93, .external_lex_state = 12},
  [1161] = {.lex_state = 93, .external_lex_state = 12},
  [1162] = {.lex_state = 93, .external_lex_state = 12},
  [1163] = {.lex_state = 93, .external_lex_state = 12},
  [1164] = {.lex_state = 93, .external_lex_state = 12},
  [1165] = {.lex_state = 93, .external_lex_state = 12},
  [1166] = {.lex_state = 93, .external_lex_state = 12},
  [1167] = {.lex_state = 93, .external_lex_state = 12},
  [1168] = {.lex_state = 94, .external_lex_state = 13},
  [1169] = {.lex_state = 94, .external_lex_state = 13},
  [1170] = {.lex_state = 93, .external_lex_state = 12},
  [1171] = {.lex_state = 93, .external_lex_state = 12},
  [1172] = {.lex_state = 93, .external_lex_state = 12},
  [1173] = {.lex_state = 84, .external_lex_state = 14},
  [1174] = {.lex_state = 93, .external_lex_state = 12},
  [1175] = {.lex_state = 93, .external_lex_state = 12},
  [1176] = {.lex_state = 93, .external_lex_state = 12},
  [1177] = {.lex_state = 94, .external_lex_state = 13},
  [1178] = {.lex_state = 94, .external_lex_state = 12},
  [1179] = {.lex_state = 94, .external_lex_state = 12},
  [1180] = {.lex_state = 94, .external_lex_state = 12},
  [1181] = {.lex_state = 94, .external_lex_state = 12},
  [1182] = {.lex_state = 94, .external_lex_state = 12},
  [1183] = {.lex_state = 94, .external_lex_state = 12},
  [1184] = {.lex_state = 94, .external_lex_state = 12},
  [1185] = {.lex_state = 94, .external_lex_state = 12},
  [1186] = {.lex_state = 94, .external_lex_state = 12},
  [1187] = {.lex_state = 94, .external_lex_state = 12},
  [1188] = {.lex_state = 94, .external_lex_state = 12},
  [1189] = {.lex_state = 94, .external_lex_state = 12},
  [1190] = {.lex_state = 94, .external_lex_state = 12},
  [1191] = {.lex_state = 94, .external_lex_state = 12},
  [1192] = {.lex_state = 94, .external_lex_state = 12},
  [1193] = {.lex_state = 94, .external_lex_state = 12},
  [1194] = {.lex_state = 94, .external_lex_state = 12},
  [1195] = {.lex_state = 94, .external_lex_state = 12},
  [1196] = {.lex_state = 84},
  [1197] = {.lex_state = 94, .external_lex_state = 12},
  [1198] = {.lex_state = 94, .external_lex_state = 12},
  [1199] = {.lex_state = 94, .external_lex_state = 12},
  [1200] = {.lex_state = 94, .external_lex_state = 12},
  [1201] = {.lex_state = 94, .external_lex_state = 12},
  [1202] = {.lex_state = 94, .external_lex_state = 12},
  [1203] = {.lex_state = 94, .external_lex_state = 12},
  [1204] = {.lex_state = 94, .external_lex_state = 12},
  [1205] = {.lex_state = 94, .external_lex_state = 12},
  [1206] = {.lex_state = 94, .external_lex_state = 12},
  [1207] = {.lex_state = 94, .external_lex_state = 12},
  [1208] = {.lex_state = 94, .external_lex_state = 12},
  [1209] = {.lex_state = 94, .external_lex_state = 12},
  [1210] = {.lex_state = 94, .external_lex_state = 12},
  [1211] = {.lex_state = 94, .external_lex_state = 12},
  [1212] = {.lex_state = 94, .external_lex_state = 12},
  [1213] = {.lex_state = 94, .external_lex_state = 12},
  [1214] = {.lex_state = 94, .external_lex_state = 12},
  [1215] = {.lex_state = 94, .external_lex_state = 12},
  [1216] = {.lex_state = 94, .external_lex_state = 12},
  [1217] = {.lex_state = 94, .external_lex_state = 12},
  [1218] = {.lex_state = 94, .external_lex_state = 12},
  [1219] = {.lex_state = 94, .external_lex_state = 12},
  [1220] = {.lex_state = 94, .external_lex_state = 12},
  [1221] = {.lex_state = 94, .external_lex_state = 12},
  [1222] = {.lex_state = 94, .external_lex_state = 12},
  [1223] = {.lex_state = 94, .external_lex_state = 12},
  [1224] = {.lex_state = 94, .external_lex_state = 12},
  [1225] = {.lex_state = 94, .external_lex_state = 12},
  [1226] = {.lex_state = 94, .external_lex_state = 12},
  [1227] = {.lex_state = 94, .external_lex_state = 12},
  [1228] = {.lex_state = 94, .external_lex_state = 12},
  [1229] = {.lex_state = 94, .external_lex_state = 12},
  [1230] = {.lex_state = 94, .external_lex_state = 12},
  [1231] = {.lex_state = 94, .external_lex_state = 12},
  [1232] = {.lex_state = 94, .external_lex_state = 12},
  [1233] = {.lex_state = 94, .external_lex_state = 12},
  [1234] = {.lex_state = 94, .external_lex_state = 12},
  [1235] = {.lex_state = 94, .external_lex_state = 12},
  [1236] = {.lex_state = 94, .external_lex_state = 12},
  [1237] = {.lex_state = 94, .external_lex_state = 12},
  [1238] = {.lex_state = 94, .external_lex_state = 12},
  [1239] = {.lex_state = 94, .external_lex_state = 12},
  [1240] = {.lex_state = 94, .external_lex_state = 12},
  [1241] = {.lex_state = 94, .external_lex_state = 12},
  [1242] = {.lex_state = 94, .external_lex_state = 12},
  [1243] = {.lex_state = 94, .external_lex_state = 12},
  [1244] = {.lex_state = 94, .external_lex_state = 12},
  [1245] = {.lex_state = 94, .external_lex_state = 12},
  [1246] = {.lex_state = 94, .external_lex_state = 12},
  [1247] = {.lex_state = 94, .external_lex_state = 12},
  [1248] = {.lex_state = 94, .external_lex_state = 12},
  [1249] = {.lex_state = 94, .external_lex_state = 12},
  [1250] = {.lex_state = 94, .external_lex_state = 12},
  [1251] = {.lex_state = 94, .external_lex_state = 12},
  [1252] = {.lex_state = 94, .external_lex_state = 12},
  [1253] = {.lex_state = 94, .external_lex_state = 12},
  [1254] = {.lex_state = 94, .external_lex_state = 12},
  [1255] = {.lex_state = 94, .external_lex_state = 12},
  [1256] = {.lex_state = 94, .external_lex_state = 12},
  [1257] = {.lex_state = 94, .external_lex_state = 12},
  [1258] = {.lex_state = 94, .external_lex_state = 12},
  [1259] = {.lex_state = 94, .external_lex_state = 12},
  [1260] = {.lex_state = 94, .external_lex_state = 12},
  [1261] = {.lex_state = 94, .external_lex_state = 12},
  [1262] = {.lex_state = 94, .external_lex_state = 12},
  [1263] = {.lex_state = 94, .external_lex_state = 12},
  [1264] = {.lex_state = 94, .external_lex_state = 12},
  [1265] = {.lex_state = 94, .external_lex_state = 12},
  [1266] = {.lex_state = 94, .external_lex_state = 12},
  [1267] = {.lex_state = 94, .external_lex_state = 12},
  [1268] = {.lex_state = 94, .external_lex_state = 12},
  [1269] = {.lex_state = 94, .external_lex_state = 12},
  [1270] = {.lex_state = 94, .external_lex_state = 12},
  [1271] = {.lex_state = 94, .external_lex_state = 12},
  [1272] = {.lex_state = 94, .external_lex_state = 12},
  [1273] = {.lex_state = 94, .external_lex_state = 12},
  [1274] = {.lex_state = 94, .external_lex_state = 12},
  [1275] = {.lex_state = 94, .external_lex_state = 12},
  [1276] = {.lex_state = 94, .external_lex_state = 12},
  [1277] = {.lex_state = 94, .external_lex_state = 12},
  [1278] = {.lex_state = 94, .external_lex_state = 12},
  [1279] = {.lex_state = 94, .external_lex_state = 12},
  [1280] = {.lex_state = 84},
  [1281] = {.lex_state = 94, .external_lex_state = 12},
  [1282] = {.lex_state = 94, .external_lex_state = 12},
  [1283] = {.lex_state = 94, .external_lex_state = 12},
  [1284] = {.lex_state = 94, .external_lex_state = 12},
  [1285] = {.lex_state = 94, .external_lex_state = 12},
  [1286] = {.lex_state = 94, .external_lex_state = 12},
  [1287] = {.lex_state = 94, .external_lex_state = 12},
  [1288] = {.lex_state = 94, .external_lex_state = 12},
  [1289] = {.lex_state = 94, .external_lex_state = 12},
  [1290] = {.lex_state = 94, .external_lex_state = 12},
  [1291] = {.lex_state = 94, .external_lex_state = 12},
  [1292] = {.lex_state = 94, .external_lex_state = 12},
  [1293] = {.lex_state = 94, .external_lex_state = 12},
  [1294] = {.lex_state = 94, .external_lex_state = 12},
  [1295] = {.lex_state = 94, .external_lex_state = 12},
  [1296] = {.lex_state = 94, .external_lex_state = 12},
  [1297] = {.lex_state = 94, .external_lex_state = 12},
  [1298] = {.lex_state = 94, .external_lex_state = 12},
  [1299] = {.lex_state = 94, .external_lex_state = 12},
  [1300] = {.lex_state = 94, .external_lex_state = 12},
  [1301] = {.lex_state = 94, .external_lex_state = 12},
  [1302] = {.lex_state = 94, .external_lex_state = 12},
  [1303] = {.lex_state = 84},
  [1304] = {.lex_state = 84},
  [1305] = {.lex_state = 94, .external_lex_state = 12},
  [1306] = {.lex_state = 94, .external_lex_state = 12},
  [1307] = {.lex_state = 94, .external_lex_state = 12},
  [1308] = {.lex_state = 94, .external_lex_state = 12},
  [1309] = {.lex_state = 94, .external_lex_state = 12},
  [1310] = {.lex_state = 94, .external_lex_state = 12},
  [1311] = {.lex_state = 94, .external_lex_state = 12},
  [1312] = {.lex_state = 94, .external_lex_state = 12},
  [1313] = {.lex_state = 94, .external_lex_state = 12},
  [1314] = {.lex_state = 94, .external_lex_state = 12},
  [1315] = {.lex_state = 94, .external_lex_state = 12},
  [1316] = {.lex_state = 94, .external_lex_state = 12},
  [1317] = {.lex_state = 94, .external_lex_state = 12},
  [1318] = {.lex_state = 94, .external_lex_state = 12},
  [1319] = {.lex_state = 94, .external_lex_state = 12},
  [1320] = {.lex_state = 94, .external_lex_state = 12},
  [1321] = {.lex_state = 94, .external_lex_state = 12},
  [1322] = {.lex_state = 94, .external_lex_state = 12},
  [1323] = {.lex_state = 94, .external_lex_state = 12},
  [1324] = {.lex_state = 94, .external_lex_state = 12},
  [1325] = {.lex_state = 94, .external_lex_state = 12},
  [1326] = {.lex_state = 94, .external_lex_state = 12},
  [1327] = {.lex_state = 94, .external_lex_state = 12},
  [1328] = {.lex_state = 94, .external_lex_state = 12},
  [1329] = {.lex_state = 94, .external_lex_state = 12},
  [1330] = {.lex_state = 94, .external_lex_state = 12},
  [1331] = {.lex_state = 94, .external_lex_state = 12},
  [1332] = {.lex_state = 94, .external_lex_state = 12},
  [1333] = {.lex_state = 94, .external_lex_state = 12},
  [1334] = {.lex_state = 94, .external_lex_state = 12},
  [1335] = {.lex_state = 94, .external_lex_state = 12},
  [1336] = {.lex_state = 94, .external_lex_state = 12},
  [1337] = {.lex_state = 94, .external_lex_state = 12},
  [1338] = {.lex_state = 94, .external_lex_state = 12},
  [1339] = {.lex_state = 94, .external_lex_state = 12},
  [1340] = {.lex_state = 94, .external_lex_state = 12},
  [1341] = {.lex_state = 94, .external_lex_state = 12},
  [1342] = {.lex_state = 94, .external_lex_state = 12},
  [1343] = {.lex_state = 94, .external_lex_state = 12},
  [1344] = {.lex_state = 94, .external_lex_state = 12},
  [1345] = {.lex_state = 94, .external_lex_state = 12},
  [1346] = {.lex_state = 94, .external_lex_state = 12},
  [1347] = {.lex_state = 94, .external_lex_state = 12},
  [1348] = {.lex_state = 94, .external_lex_state = 12},
  [1349] = {.lex_state = 94, .external_lex_state = 12},
  [1350] = {.lex_state = 94, .external_lex_state = 12},
  [1351] = {.lex_state = 94, .external_lex_state = 12},
  [1352] = {.lex_state = 94, .external_lex_state = 12},
  [1353] = {.lex_state = 94, .external_lex_state = 12},
  [1354] = {.lex_state = 94, .external_lex_state = 12},
  [1355] = {.lex_state = 94, .external_lex_state = 12},
  [1356] = {.lex_state = 94, .external_lex_state = 12},
  [1357] = {.lex_state = 94, .external_lex_state = 12},
  [1358] = {.lex_state = 94, .external_lex_state = 12},
  [1359] = {.lex_state = 94, .external_lex_state = 12},
  [1360] = {.lex_state = 94, .external_lex_state = 12},
  [1361] = {.lex_state = 94, .external_lex_state = 12},
  [1362] = {.lex_state = 94, .external_lex_state = 12},
  [1363] = {.lex_state = 84},
  [1364] = {.lex_state = 94, .external_lex_state = 12},
  [1365] = {.lex_state = 84},
  [1366] = {.lex_state = 94, .external_lex_state = 12},
  [1367] = {.lex_state = 94, .external_lex_state = 12},
  [1368] = {.lex_state = 94, .external_lex_state = 12},
  [1369] = {.lex_state = 94, .external_lex_state = 12},
  [1370] = {.lex_state = 94, .external_lex_state = 12},
  [1371] = {.lex_state = 94, .external_lex_state = 12},
  [1372] = {.lex_state = 84},
  [1373] = {.lex_state = 84},
  [1374] = {.lex_state = 84},
  [1375] = {.lex_state = 94, .external_lex_state = 12},
  [1376] = {.lex_state = 94, .external_lex_state = 12},
  [1377] = {.lex_state = 94, .external_lex_state = 12},
  [1378] = {.lex_state = 94, .external_lex_state = 12},
  [1379] = {.lex_state = 94, .external_lex_state = 12},
  [1380] = {.lex_state = 94, .external_lex_state = 12},
  [1381] = {.lex_state = 94, .external_lex_state = 12},
  [1382] = {.lex_state = 94, .external_lex_state = 12},
  [1383] = {.lex_state = 94, .external_lex_state = 12},
  [1384] = {.lex_state = 94, .external_lex_state = 12},
  [1385] = {.lex_state = 94, .external_lex_state = 12},
  [1386] = {.lex_state = 94, .external_lex_state = 12},
  [1387] = {.lex_state = 94, .external_lex_state = 12},
  [1388] = {.lex_state = 94, .external_lex_state = 12},
  [1389] = {.lex_state = 94, .external_lex_state = 12},
  [1390] = {.lex_state = 94, .external_lex_state = 12},
  [1391] = {.lex_state = 94, .external_lex_state = 12},
  [1392] = {.lex_state = 94, .external_lex_state = 12},
  [1393] = {.lex_state = 94, .external_lex_state = 12},
  [1394] = {.lex_state = 94, .external_lex_state = 12},
  [1395] = {.lex_state = 94, .external_lex_state = 12},
  [1396] = {.lex_state = 94, .external_lex_state = 12},
  [1397] = {.lex_state = 94, .external_lex_state = 12},
  [1398] = {.lex_state = 94, .external_lex_state = 12},
  [1399] = {.lex_state = 94, .external_lex_state = 12},
  [1400] = {.lex_state = 94, .external_lex_state = 12},
  [1401] = {.lex_state = 94, .external_lex_state = 12},
  [1402] = {.lex_state = 94, .external_lex_state = 12},
  [1403] = {.lex_state = 94, .external_lex_state = 12},
  [1404] = {.lex_state = 94, .external_lex_state = 12},
  [1405] = {.lex_state = 94, .external_lex_state = 12},
  [1406] = {.lex_state = 94, .external_lex_state = 12},
  [1407] = {.lex_state = 94, .external_lex_state = 12},
  [1408] = {.lex_state = 94, .external_lex_state = 12},
  [1409] = {.lex_state = 94, .external_lex_state = 12},
  [1410] = {.lex_state = 84},
  [1411] = {.lex_state = 94, .external_lex_state = 12},
  [1412] = {.lex_state = 94, .external_lex_state = 12},
  [1413] = {.lex_state = 94, .external_lex_state = 12},
  [1414] = {.lex_state = 94, .external_lex_state = 12},
  [1415] = {.lex_state = 94, .external_lex_state = 12},
  [1416] = {.lex_state = 94, .external_lex_state = 12},
  [1417] = {.lex_state = 94, .external_lex_state = 12},
  [1418] = {.lex_state = 94, .external_lex_state = 12},
  [1419] = {.lex_state = 94, .external_lex_state = 12},
  [1420] = {.lex_state = 94, .external_lex_state = 12},
  [1421] = {.lex_state = 94, .external_lex_state = 12},
  [1422] = {.lex_state = 94, .external_lex_state = 12},
  [1423] = {.lex_state = 94, .external_lex_state = 12},
  [1424] = {.lex_state = 94, .external_lex_state = 12},
  [1425] = {.lex_state = 94, .external_lex_state = 12},
  [1426] = {.lex_state = 94, .external_lex_state = 12},
  [1427] = {.lex_state = 94, .external_lex_state = 12},
  [1428] = {.lex_state = 94, .external_lex_state = 12},
  [1429] = {.lex_state = 94, .external_lex_state = 12},
  [1430] = {.lex_state = 94, .external_lex_state = 12},
  [1431] = {.lex_state = 94, .external_lex_state = 12},
  [1432] = {.lex_state = 94, .external_lex_state = 12},
  [1433] = {.lex_state = 94, .external_lex_state = 12},
  [1434] = {.lex_state = 94, .external_lex_state = 12},
  [1435] = {.lex_state = 94, .external_lex_state = 12},
  [1436] = {.lex_state = 94, .external_lex_state = 12},
  [1437] = {.lex_state = 94, .external_lex_state = 12},
  [1438] = {.lex_state = 94, .external_lex_state = 12},
  [1439] = {.lex_state = 94, .external_lex_state = 12},
  [1440] = {.lex_state = 94, .external_lex_state = 12},
  [1441] = {.lex_state = 94, .external_lex_state = 12},
  [1442] = {.lex_state = 94, .external_lex_state = 12},
  [1443] = {.lex_state = 94, .external_lex_state = 12},
  [1444] = {.lex_state = 94, .external_lex_state = 12},
  [1445] = {.lex_state = 94, .external_lex_state = 12},
  [1446] = {.lex_state = 94, .external_lex_state = 12},
  [1447] = {.lex_state = 94, .external_lex_state = 12},
  [1448] = {.lex_state = 94, .external_lex_state = 12},
  [1449] = {.lex_state = 94, .external_lex_state = 12},
  [1450] = {.lex_state = 94, .external_lex_state = 12},
  [1451] = {.lex_state = 94, .external_lex_state = 12},
  [1452] = {.lex_state = 94, .external_lex_state = 12},
  [1453] = {.lex_state = 94, .external_lex_state = 12},
  [1454] = {.lex_state = 94, .external_lex_state = 12},
  [1455] = {.lex_state = 94, .external_lex_state = 12},
  [1456] = {.lex_state = 84},
  [1457] = {.lex_state = 94, .external_lex_state = 12},
  [1458] = {.lex_state = 94, .external_lex_state = 12},
  [1459] = {.lex_state = 94, .external_lex_state = 12},
  [1460] = {.lex_state = 94, .external_lex_state = 12},
  [1461] = {.lex_state = 94, .external_lex_state = 12},
  [1462] = {.lex_state = 94, .external_lex_state = 12},
  [1463] = {.lex_state = 84},
  [1464] = {.lex_state = 94, .external_lex_state = 12},
  [1465] = {.lex_state = 94, .external_lex_state = 12},
  [1466] = {.lex_state = 94, .external_lex_state = 12},
  [1467] = {.lex_state = 94, .external_lex_state = 12},
  [1468] = {.lex_state = 94, .external_lex_state = 12},
  [1469] = {.lex_state = 94, .external_lex_state = 12},
  [1470] = {.lex_state = 94, .external_lex_state = 12},
  [1471] = {.lex_state = 94, .external_lex_state = 12},
  [1472] = {.lex_state = 84},
  [1473] = {.lex_state = 94, .external_lex_state = 12},
  [1474] = {.lex_state = 94, .external_lex_state = 12},
  [1475] = {.lex_state = 94, .external_lex_state = 12},
  [1476] = {.lex_state = 94, .external_lex_state = 12},
  [1477] = {.lex_state = 94, .external_lex_state = 12},
  [1478] = {.lex_state = 94, .external_lex_state = 12},
  [1479] = {.lex_state = 94, .external_lex_state = 12},
  [1480] = {.lex_state = 94, .external_lex_state = 12},
  [1481] = {.lex_state = 94, .external_lex_state = 12},
  [1482] = {.lex_state = 94, .external_lex_state = 12},
  [1483] = {.lex_state = 94, .external_lex_state = 12},
  [1484] = {.lex_state = 94, .external_lex_state = 12},
  [1485] = {.lex_state = 94, .external_lex_state = 12},
  [1486] = {.lex_state = 94, .external_lex_state = 12},
  [1487] = {.lex_state = 94, .external_lex_state = 12},
  [1488] = {.lex_state = 94, .external_lex_state = 12},
  [1489] = {.lex_state = 94, .external_lex_state = 12},
  [1490] = {.lex_state = 94, .external_lex_state = 12},
  [1491] = {.lex_state = 94, .external_lex_state = 12},
  [1492] = {.lex_state = 94, .external_lex_state = 12},
  [1493] = {.lex_state = 94, .external_lex_state = 12},
  [1494] = {.lex_state = 94, .external_lex_state = 12},
  [1495] = {.lex_state = 94, .external_lex_state = 12},
  [1496] = {.lex_state = 94, .external_lex_state = 12},
  [1497] = {.lex_state = 94, .external_lex_state = 12},
  [1498] = {.lex_state = 94, .external_lex_state = 12},
  [1499] = {.lex_state = 94, .external_lex_state = 12},
  [1500] = {.lex_state = 94, .external_lex_state = 12},
  [1501] = {.lex_state = 94, .external_lex_state = 12},
  [1502] = {.lex_state = 94, .external_lex_state = 12},
  [1503] = {.lex_state = 94, .external_lex_state = 12},
  [1504] = {.lex_state = 94, .external_lex_state = 12},
  [1505] = {.lex_state = 94, .external_lex_state = 12},
  [1506] = {.lex_state = 94, .external_lex_state = 12},
  [1507] = {.lex_state = 94, .external_lex_state = 12},
  [1508] = {.lex_state = 94, .external_lex_state = 12},
  [1509] = {.lex_state = 94, .external_lex_state = 12},
  [1510] = {.lex_state = 94, .external_lex_state = 12},
  [1511] = {.lex_state = 94, .external_lex_state = 12},
  [1512] = {.lex_state = 94, .external_lex_state = 12},
  [1513] = {.lex_state = 94, .external_lex_state = 12},
  [1514] = {.lex_state = 94, .external_lex_state = 12},
  [1515] = {.lex_state = 94, .external_lex_state = 12},
  [1516] = {.lex_state = 94, .external_lex_state = 12},
  [1517] = {.lex_state = 94, .external_lex_state = 12},
  [1518] = {.lex_state = 94, .external_lex_state = 12},
  [1519] = {.lex_state = 94, .external_lex_state = 12},
  [1520] = {.lex_state = 94, .external_lex_state = 12},
  [1521] = {.lex_state = 94, .external_lex_state = 12},
  [1522] = {.lex_state = 94, .external_lex_state = 12},
  [1523] = {.lex_state = 94, .external_lex_state = 12},
  [1524] = {.lex_state = 94, .external_lex_state = 12},
  [1525] = {.lex_state = 84},
  [1526] = {.lex_state = 94, .external_lex_state = 12},
  [1527] = {.lex_state = 94, .external_lex_state = 12},
  [1528] = {.lex_state = 94, .external_lex_state = 12},
  [1529] = {.lex_state = 84},
  [1530] = {.lex_state = 94, .external_lex_state = 12},
  [1531] = {.lex_state = 84},
  [1532] = {.lex_state = 94, .external_lex_state = 12},
  [1533] = {.lex_state = 94, .external_lex_state = 12},
  [1534] = {.lex_state = 84},
  [1535] = {.lex_state = 84},
  [1536] = {.lex_state = 94, .external_lex_state = 12},
  [1537] = {.lex_state = 94, .external_lex_state = 12},
  [1538] = {.lex_state = 84},
  [1539] = {.lex_state = 84},
  [1540] = {.lex_state = 94, .external_lex_state = 12},
  [1541] = {.lex_state = 94, .external_lex_state = 12},
  [1542] = {.lex_state = 94, .external_lex_state = 12},
  [1543] = {.lex_state = 94, .external_lex_state = 12},
  [1544] = {.lex_state = 94, .external_lex_state = 12},
  [1545] = {.lex_state = 84},
  [1546] = {.lex_state = 94, .external_lex_state = 12},
  [1547] = {.lex_state = 94, .external_lex_state = 12},
  [1548] = {.lex_state = 84},
  [1549] = {.lex_state = 94, .external_lex_state = 12},
  [1550] = {.lex_state = 94, .external_lex_state = 12},
  [1551] = {.lex_state = 94, .external_lex_state = 12},
  [1552] = {.lex_state = 94, .external_lex_state = 12},
  [1553] = {.lex_state = 94, .external_lex_state = 12},
  [1554] = {.lex_state = 94, .external_lex_state = 12},
  [1555] = {.lex_state = 94, .external_lex_state = 12},
  [1556] = {.lex_state = 94, .external_lex_state = 12},
  [1557] = {.lex_state = 94, .external_lex_state = 12},
  [1558] = {.lex_state = 94, .external_lex_state = 12},
  [1559] = {.lex_state = 94, .external_lex_state = 12},
  [1560] = {.lex_state = 94, .external_lex_state = 12},
  [1561] = {.lex_state = 94, .external_lex_state = 12},
  [1562] = {.lex_state = 94, .external_lex_state = 12},
  [1563] = {.lex_state = 94, .external_lex_state = 12},
  [1564] = {.lex_state = 94, .external_lex_state = 12},
  [1565] = {.lex_state = 94, .external_lex_state = 12},
  [1566] = {.lex_state = 94, .external_lex_state = 12},
  [1567] = {.lex_state = 94, .external_lex_state = 12},
  [1568] = {.lex_state = 94, .external_lex_state = 12},
  [1569] = {.lex_state = 94, .external_lex_state = 12},
  [1570] = {.lex_state = 94, .external_lex_state = 12},
  [1571] = {.lex_state = 84},
  [1572] = {.lex_state = 94, .external_lex_state = 12},
  [1573] = {.lex_state = 94, .external_lex_state = 12},
  [1574] = {.lex_state = 94, .external_lex_state = 12},
  [1575] = {.lex_state = 94, .external_lex_state = 12},
  [1576] = {.lex_state = 94, .external_lex_state = 12},
  [1577] = {.lex_state = 84},
  [1578] = {.lex_state = 94, .external_lex_state = 12},
  [1579] = {.lex_state = 94, .external_lex_state = 12},
  [1580] = {.lex_state = 94, .external_lex_state = 12},
  [1581] = {.lex_state = 94, .external_lex_state = 12},
  [1582] = {.lex_state = 94, .external_lex_state = 12},
  [1583] = {.lex_state = 94, .external_lex_state = 12},
  [1584] = {.lex_state = 84},
  [1585] = {.lex_state = 94, .external_lex_state = 12},
  [1586] = {.lex_state = 94, .external_lex_state = 12},
  [1587] = {.lex_state = 94, .external_lex_state = 12},
  [1588] = {.lex_state = 94, .external_lex_state = 12},
  [1589] = {.lex_state = 94, .external_lex_state = 12},
  [1590] = {.lex_state = 94, .external_lex_state = 12},
  [1591] = {.lex_state = 94, .external_lex_state = 12},
  [1592] = {.lex_state = 94, .external_lex_state = 12},
  [1593] = {.lex_state = 94, .external_lex_state = 12},
  [1594] = {.lex_state = 94, .external_lex_state = 12},
  [1595] = {.lex_state = 94, .external_lex_state = 12},
  [1596] = {.lex_state = 94, .external_lex_state = 12},
  [1597] = {.lex_state = 94, .external_lex_state = 12},
  [1598] = {.lex_state = 94, .external_lex_state = 12},
  [1599] = {.lex_state = 94, .external_lex_state = 12},
  [1600] = {.lex_state = 94, .external_lex_state = 12},
  [1601] = {.lex_state = 94, .external_lex_state = 12},
  [1602] = {.lex_state = 94, .external_lex_state = 12},
  [1603] = {.lex_state = 94, .external_lex_state = 12},
  [1604] = {.lex_state = 94, .external_lex_state = 12},
  [1605] = {.lex_state = 94, .external_lex_state = 12},
  [1606] = {.lex_state = 84},
  [1607] = {.lex_state = 94, .external_lex_state = 12},
  [1608] = {.lex_state = 84},
  [1609] = {.lex_state = 84},
  [1610] = {.lex_state = 94, .external_lex_state = 12},
  [1611] = {.lex_state = 84},
  [1612] = {.lex_state = 94, .external_lex_state = 12},
  [1613] = {.lex_state = 94, .external_lex_state = 12},
  [1614] = {.lex_state = 84},
  [1615] = {.lex_state = 94, .external_lex_state = 12},
  [1616] = {.lex_state = 94, .external_lex_state = 12},
  [1617] = {.lex_state = 94, .external_lex_state = 12},
  [1618] = {.lex_state = 94, .external_lex_state = 12},
  [1619] = {.lex_state = 94, .external_lex_state = 12},
  [1620] = {.lex_state = 94, .external_lex_state = 12},
  [1621] = {.lex_state = 94, .external_lex_state = 12},
  [1622] = {.lex_state = 94, .external_lex_state = 12},
  [1623] = {.lex_state = 94, .external_lex_state = 12},
  [1624] = {.lex_state = 84},
  [1625] = {.lex_state = 94, .external_lex_state = 12},
  [1626] = {.lex_state = 94, .external_lex_state = 12},
  [1627] = {.lex_state = 94, .external_lex_state = 12},
  [1628] = {.lex_state = 94, .external_lex_state = 12},
  [1629] = {.lex_state = 94, .external_lex_state = 12},
  [1630] = {.lex_state = 94, .external_lex_state = 12},
  [1631] = {.lex_state = 94, .external_lex_state = 12},
  [1632] = {.lex_state = 84},
  [1633] = {.lex_state = 94, .external_lex_state = 12},
  [1634] = {.lex_state = 84},
  [1635] = {.lex_state = 94, .external_lex_state = 12},
  [1636] = {.lex_state = 94, .external_lex_state = 12},
  [1637] = {.lex_state = 94, .external_lex_state = 12},
  [1638] = {.lex_state = 94, .external_lex_state = 12},
  [1639] = {.lex_state = 94, .external_lex_state = 12},
  [1640] = {.lex_state = 94, .external_lex_state = 12},
  [1641] = {.lex_state = 94, .external_lex_state = 12},
  [1642] = {.lex_state = 94, .external_lex_state = 12},
  [1643] = {.lex_state = 94, .external_lex_state = 12},
  [1644] = {.lex_state = 94, .external_lex_state = 12},
  [1645] = {.lex_state = 94, .external_lex_state = 12},
  [1646] = {.lex_state = 77, .external_lex_state = 12},
  [1647] = {.lex_state = 28, .external_lex_state = 6},
  [1648] = {.lex_state = 28, .external_lex_state = 6},
  [1649] = {.lex_state = 28, .external_lex_state = 6},
  [1650] = {.lex_state = 28, .external_lex_state = 6},
  [1651] = {.lex_state = 28, .external_lex_state = 6},
  [1652] = {.lex_state = 28, .external_lex_state = 6},
  [1653] = {.lex_state = 28, .external_lex_state = 6},
  [1654] = {.lex_state = 28, .external_lex_state = 6},
  [1655] = {.lex_state = 28, .external_lex_state = 6},
  [1656] = {.lex_state = 28, .external_lex_state = 6},
  [1657] = {.lex_state = 187, .external_lex_state = 6},
  [1658] = {.lex_state = 187, .external_lex_state = 6},
  [1659] = {.lex_state = 28, .external_lex_state = 8},
  [1660] = {.lex_state = 28, .external_lex_state = 6},
  [1661] = {.lex_state = 187, .external_lex_state = 6},
  [1662] = {.lex_state = 28, .external_lex_state = 6},
  [1663] = {.lex_state = 187, .external_lex_state = 6},
  [1664] = {.lex_state = 28, .external_lex_state = 8},
  [1665] = {.lex_state = 187, .external_lex_state = 8},
  [1666] = {.lex_state = 187, .external_lex_state = 6},
  [1667] = {.lex_state = 187, .external_lex_state = 6},
  [1668] = {.lex_state = 187, .external_lex_state = 6},
  [1669] = {.lex_state = 96, .external_lex_state = 2},
  [1670] = {.lex_state = 187, .external_lex_state = 6},
  [1671] = {.lex_state = 187, .external_lex_state = 6},
  [1672] = {.lex_state = 187, .external_lex_state = 6},
  [1673] = {.lex_state = 28, .external_lex_state = 6},
  [1674] = {.lex_state = 34, .external_lex_state = 15},
  [1675] = {.lex_state = 74, .external_lex_state = 10},
  [1676] = {.lex_state = 28, .external_lex_state = 6},
  [1677] = {.lex_state = 28, .external_lex_state = 8},
  [1678] = {.lex_state = 28, .external_lex_state = 8},
  [1679] = {.lex_state = 28, .external_lex_state = 8},
  [1680] = {.lex_state = 187, .external_lex_state = 6},
  [1681] = {.lex_state = 187, .external_lex_state = 6},
  [1682] = {.lex_state = 28, .external_lex_state = 8},
  [1683] = {.lex_state = 28, .external_lex_state = 6},
  [1684] = {.lex_state = 28, .external_lex_state = 8},
  [1685] = {.lex_state = 187, .external_lex_state = 6},
  [1686] = {.lex_state = 187, .external_lex_state = 6},
  [1687] = {.lex_state = 187, .external_lex_state = 6},
  [1688] = {.lex_state = 28, .external_lex_state = 6},
  [1689] = {.lex_state = 187, .external_lex_state = 6},
  [1690] = {.lex_state = 96, .external_lex_state = 16},
  [1691] = {.lex_state = 28, .external_lex_state = 8},
  [1692] = {.lex_state = 75, .external_lex_state = 10},
  [1693] = {.lex_state = 28, .external_lex_state = 8},
  [1694] = {.lex_state = 28, .external_lex_state = 8},
  [1695] = {.lex_state = 75, .external_lex_state = 10},
  [1696] = {.lex_state = 187, .external_lex_state = 6},
  [1697] = {.lex_state = 96, .external_lex_state = 16},
  [1698] = {.lex_state = 187, .external_lex_state = 6},
  [1699] = {.lex_state = 28, .external_lex_state = 8},
  [1700] = {.lex_state = 28, .external_lex_state = 8},
  [1701] = {.lex_state = 187, .external_lex_state = 8},
  [1702] = {.lex_state = 28, .external_lex_state = 8},
  [1703] = {.lex_state = 28, .external_lex_state = 8},
  [1704] = {.lex_state = 187, .external_lex_state = 6},
  [1705] = {.lex_state = 187, .external_lex_state = 6},
  [1706] = {.lex_state = 28, .external_lex_state = 8},
  [1707] = {.lex_state = 75, .external_lex_state = 10},
  [1708] = {.lex_state = 28, .external_lex_state = 8},
  [1709] = {.lex_state = 28, .external_lex_state = 8},
  [1710] = {.lex_state = 28, .external_lex_state = 8},
  [1711] = {.lex_state = 187, .external_lex_state = 6},
  [1712] = {.lex_state = 28, .external_lex_state = 8},
  [1713] = {.lex_state = 28, .external_lex_state = 8},
  [1714] = {.lex_state = 187, .external_lex_state = 6},
  [1715] = {.lex_state = 187, .external_lex_state = 8},
  [1716] = {.lex_state = 28, .external_lex_state = 8},
  [1717] = {.lex_state = 28, .external_lex_state = 8},
  [1718] = {.lex_state = 28, .external_lex_state = 8},
  [1719] = {.lex_state = 28, .external_lex_state = 8},
  [1720] = {.lex_state = 96, .external_lex_state = 16},
  [1721] = {.lex_state = 28, .external_lex_state = 8},
  [1722] = {.lex_state = 96, .external_lex_state = 16},
  [1723] = {.lex_state = 187, .external_lex_state = 8},
  [1724] = {.lex_state = 34, .external_lex_state = 15},
  [1725] = {.lex_state = 187, .external_lex_state = 8},
  [1726] = {.lex_state = 28, .external_lex_state = 8},
  [1727] = {.lex_state = 28, .external_lex_state = 8},
  [1728] = {.lex_state = 28, .external_lex_state = 8},
  [1729] = {.lex_state = 28, .external_lex_state = 8},
  [1730] = {.lex_state = 187, .external_lex_state = 6},
  [1731] = {.lex_state = 96, .external_lex_state = 16},
  [1732] = {.lex_state = 28, .external_lex_state = 8},
  [1733] = {.lex_state = 28, .external_lex_state = 8},
  [1734] = {.lex_state = 28, .external_lex_state = 8},
  [1735] = {.lex_state = 187, .external_lex_state = 8},
  [1736] = {.lex_state = 187, .external_lex_state = 6},
  [1737] = {.lex_state = 187, .external_lex_state = 8},
  [1738] = {.lex_state = 34, .external_lex_state = 15},
  [1739] = {.lex_state = 34, .external_lex_state = 15},
  [1740] = {.lex_state = 34, .external_lex_state = 10},
  [1741] = {.lex_state = 28, .external_lex_state = 8},
  [1742] = {.lex_state = 28, .external_lex_state = 8},
  [1743] = {.lex_state = 28, .external_lex_state = 6},
  [1744] = {.lex_state = 28, .external_lex_state = 8},
  [1745] = {.lex_state = 28, .external_lex_state = 8},
  [1746] = {.lex_state = 28, .external_lex_state = 8},
  [1747] = {.lex_state = 187, .external_lex_state = 6},
  [1748] = {.lex_state = 34, .external_lex_state = 10},
  [1749] = {.lex_state = 75, .external_lex_state = 10},
  [1750] = {.lex_state = 187, .external_lex_state = 8},
  [1751] = {.lex_state = 28, .external_lex_state = 6},
  [1752] = {.lex_state = 34, .external_lex_state = 15},
  [1753] = {.lex_state = 34, .external_lex_state = 10},
  [1754] = {.lex_state = 187, .external_lex_state = 6},
  [1755] = {.lex_state = 34, .external_lex_state = 15},
  [1756] = {.lex_state = 187, .external_lex_state = 8},
  [1757] = {.lex_state = 34, .external_lex_state = 15},
  [1758] = {.lex_state = 187, .external_lex_state = 6},
  [1759] = {.lex_state = 34, .external_lex_state = 15},
  [1760] = {.lex_state = 34, .external_lex_state = 15},
  [1761] = {.lex_state = 199, .external_lex_state = 17},
  [1762] = {.lex_state = 28, .external_lex_state = 6},
  [1763] = {.lex_state = 34, .external_lex_state = 15},
  [1764] = {.lex_state = 34, .external_lex_state = 15},
  [1765] = {.lex_state = 34, .external_lex_state = 15},
  [1766] = {.lex_state = 34, .external_lex_state = 15},
  [1767] = {.lex_state = 34, .external_lex_state = 15},
  [1768] = {.lex_state = 34, .external_lex_state = 15},
  [1769] = {.lex_state = 34, .external_lex_state = 15},
  [1770] = {.lex_state = 34, .external_lex_state = 15},
  [1771] = {.lex_state = 34, .external_lex_state = 15},
  [1772] = {.lex_state = 34, .external_lex_state = 15},
  [1773] = {.lex_state = 34, .external_lex_state = 15},
  [1774] = {.lex_state = 28, .external_lex_state = 6},
  [1775] = {.lex_state = 28, .external_lex_state = 6},
  [1776] = {.lex_state = 28, .external_lex_state = 6},
  [1777] = {.lex_state = 28, .external_lex_state = 6},
  [1778] = {.lex_state = 28, .external_lex_state = 6},
  [1779] = {.lex_state = 28, .external_lex_state = 6},
  [1780] = {.lex_state = 28, .external_lex_state = 6},
  [1781] = {.lex_state = 28, .external_lex_state = 6},
  [1782] = {.lex_state = 28, .external_lex_state = 6},
  [1783] = {.lex_state = 28, .external_lex_state = 6},
  [1784] = {.lex_state = 28, .external_lex_state = 6},
  [1785] = {.lex_state = 28, .external_lex_state = 6},
  [1786] = {.lex_state = 28, .external_lex_state = 6},
  [1787] = {.lex_state = 28, .external_lex_state = 6},
  [1788] = {.lex_state = 28, .external_lex_state = 6},
  [1789] = {.lex_state = 28, .external_lex_state = 6},
  [1790] = {.lex_state = 28, .external_lex_state = 6},
  [1791] = {.lex_state = 28, .external_lex_state = 6},
  [1792] = {.lex_state = 28, .external_lex_state = 6},
  [1793] = {.lex_state = 28, .external_lex_state = 6},
  [1794] = {.lex_state = 28, .external_lex_state = 6},
  [1795] = {.lex_state = 28, .external_lex_state = 6},
  [1796] = {.lex_state = 28, .external_lex_state = 6},
  [1797] = {.lex_state = 34, .external_lex_state = 15},
  [1798] = {.lex_state = 28, .external_lex_state = 6},
  [1799] = {.lex_state = 28, .external_lex_state = 6},
  [1800] = {.lex_state = 187, .external_lex_state = 8},
  [1801] = {.lex_state = 34, .external_lex_state = 15},
  [1802] = {.lex_state = 28, .external_lex_state = 6},
  [1803] = {.lex_state = 28, .external_lex_state = 6},
  [1804] = {.lex_state = 28, .external_lex_state = 6},
  [1805] = {.lex_state = 28, .external_lex_state = 6},
  [1806] = {.lex_state = 28, .external_lex_state = 6},
  [1807] = {.lex_state = 187, .external_lex_state = 8},
  [1808] = {.lex_state = 34, .external_lex_state = 15},
  [1809] = {.lex_state = 187, .external_lex_state = 6},
  [1810] = {.lex_state = 28, .external_lex_state = 6},
  [1811] = {.lex_state = 28, .external_lex_state = 6},
  [1812] = {.lex_state = 187, .external_lex_state = 8},
  [1813] = {.lex_state = 28, .external_lex_state = 6},
  [1814] = {.lex_state = 34, .external_lex_state = 15},
  [1815] = {.lex_state = 34, .external_lex_state = 15},
  [1816] = {.lex_state = 34, .external_lex_state = 15},
  [1817] = {.lex_state = 34, .external_lex_state = 15},
  [1818] = {.lex_state = 34, .external_lex_state = 15},
  [1819] = {.lex_state = 34, .external_lex_state = 15},
  [1820] = {.lex_state = 28, .external_lex_state = 6},
  [1821] = {.lex_state = 34, .external_lex_state = 15},
  [1822] = {.lex_state = 187, .external_lex_state = 6},
  [1823] = {.lex_state = 96, .external_lex_state = 2},
  [1824] = {.lex_state = 96, .external_lex_state = 16},
  [1825] = {.lex_state = 28, .external_lex_state = 6},
  [1826] = {.lex_state = 96, .external_lex_state = 16},
  [1827] = {.lex_state = 96, .external_lex_state = 16},
  [1828] = {.lex_state = 96, .external_lex_state = 16},
  [1829] = {.lex_state = 96, .external_lex_state = 16},
  [1830] = {.lex_state = 96, .external_lex_state = 16},
  [1831] = {.lex_state = 96, .external_lex_state = 16},
  [1832] = {.lex_state = 96, .external_lex_state = 16},
  [1833] = {.lex_state = 187, .external_lex_state = 8},
  [1834] = {.lex_state = 28, .external_lex_state = 6},
  [1835] = {.lex_state = 96, .external_lex_state = 16},
  [1836] = {.lex_state = 187, .external_lex_state = 8},
  [1837] = {.lex_state = 96, .external_lex_state = 16},
  [1838] = {.lex_state = 28, .external_lex_state = 6},
  [1839] = {.lex_state = 187, .external_lex_state = 8},
  [1840] = {.lex_state = 187, .external_lex_state = 8},
  [1841] = {.lex_state = 96, .external_lex_state = 16},
  [1842] = {.lex_state = 96, .external_lex_state = 16},
  [1843] = {.lex_state = 99},
  [1844] = {.lex_state = 99},
  [1845] = {.lex_state = 96, .external_lex_state = 16},
  [1846] = {.lex_state = 96, .external_lex_state = 16},
  [1847] = {.lex_state = 90, .external_lex_state = 17},
  [1848] = {.lex_state = 187, .external_lex_state = 8},
  [1849] = {.lex_state = 99},
  [1850] = {.lex_state = 187, .external_lex_state = 8},
  [1851] = {.lex_state = 96, .external_lex_state = 16},
  [1852] = {.lex_state = 96, .external_lex_state = 2},
  [1853] = {.lex_state = 96, .external_lex_state = 16},
  [1854] = {.lex_state = 96, .external_lex_state = 16},
  [1855] = {.lex_state = 96, .external_lex_state = 16},
  [1856] = {.lex_state = 96, .external_lex_state = 16},
  [1857] = {.lex_state = 96, .external_lex_state = 16},
  [1858] = {.lex_state = 96, .external_lex_state = 16},
  [1859] = {.lex_state = 99},
  [1860] = {.lex_state = 96, .external_lex_state = 16},
  [1861] = {.lex_state = 28, .external_lex_state = 6},
  [1862] = {.lex_state = 187, .external_lex_state = 8},
  [1863] = {.lex_state = 28, .external_lex_state = 6},
  [1864] = {.lex_state = 99},
  [1865] = {.lex_state = 96, .external_lex_state = 16},
  [1866] = {.lex_state = 99},
  [1867] = {.lex_state = 96, .external_lex_state = 16},
  [1868] = {.lex_state = 99},
  [1869] = {.lex_state = 96, .external_lex_state = 16},
  [1870] = {.lex_state = 187, .external_lex_state = 8},
  [1871] = {.lex_state = 187, .external_lex_state = 8},
  [1872] = {.lex_state = 99},
  [1873] = {.lex_state = 187, .external_lex_state = 8},
  [1874] = {.lex_state = 96, .external_lex_state = 16},
  [1875] = {.lex_state = 187, .external_lex_state = 8},
  [1876] = {.lex_state = 99},
  [1877] = {.lex_state = 187, .external_lex_state = 8},
  [1878] = {.lex_state = 199, .external_lex_state = 17},
  [1879] = {.lex_state = 99},
  [1880] = {.lex_state = 28, .external_lex_state = 6},
  [1881] = {.lex_state = 187, .external_lex_state = 8},
  [1882] = {.lex_state = 28, .external_lex_state = 6},
  [1883] = {.lex_state = 187, .external_lex_state = 8},
  [1884] = {.lex_state = 187, .external_lex_state = 8},
  [1885] = {.lex_state = 28, .external_lex_state = 6},
  [1886] = {.lex_state = 187, .external_lex_state = 8},
  [1887] = {.lex_state = 187, .external_lex_state = 8},
  [1888] = {.lex_state = 187, .external_lex_state = 8},
  [1889] = {.lex_state = 187, .external_lex_state = 8},
  [1890] = {.lex_state = 187, .external_lex_state = 8},
  [1891] = {.lex_state = 187, .external_lex_state = 8},
  [1892] = {.lex_state = 187, .external_lex_state = 8},
  [1893] = {.lex_state = 187, .external_lex_state = 8},
  [1894] = {.lex_state = 96, .external_lex_state = 2},
  [1895] = {.lex_state = 187, .external_lex_state = 8},
  [1896] = {.lex_state = 187, .external_lex_state = 8},
  [1897] = {.lex_state = 28, .external_lex_state = 6},
  [1898] = {.lex_state = 99},
  [1899] = {.lex_state = 99},
  [1900] = {.lex_state = 187, .external_lex_state = 6},
  [1901] = {.lex_state = 187, .external_lex_state = 8},
  [1902] = {.lex_state = 199, .external_lex_state = 17},
  [1903] = {.lex_state = 96, .external_lex_state = 16},
  [1904] = {.lex_state = 34, .external_lex_state = 10},
  [1905] = {.lex_state = 187, .external_lex_state = 6},
  [1906] = {.lex_state = 91, .external_lex_state = 17},
  [1907] = {.lex_state = 96},
  [1908] = {.lex_state = 34, .external_lex_state = 10},
  [1909] = {.lex_state = 91},
  [1910] = {.lex_state = 96, .external_lex_state = 18},
  [1911] = {.lex_state = 96, .external_lex_state = 2},
  [1912] = {.lex_state = 96, .external_lex_state = 2},
  [1913] = {.lex_state = 199, .external_lex_state = 17},
  [1914] = {.lex_state = 187, .external_lex_state = 6},
  [1915] = {.lex_state = 96, .external_lex_state = 18},
  [1916] = {.lex_state = 34, .external_lex_state = 10},
  [1917] = {.lex_state = 96, .external_lex_state = 2},
  [1918] = {.lex_state = 34, .external_lex_state = 10},
  [1919] = {.lex_state = 96, .external_lex_state = 2},
  [1920] = {.lex_state = 187, .external_lex_state = 6},
  [1921] = {.lex_state = 187, .external_lex_state = 6},
  [1922] = {.lex_state = 187, .external_lex_state = 6},
  [1923] = {.lex_state = 96, .external_lex_state = 2},
  [1924] = {.lex_state = 96, .external_lex_state = 2},
  [1925] = {.lex_state = 187, .external_lex_state = 6},
  [1926] = {.lex_state = 187, .external_lex_state = 6},
  [1927] = {.lex_state = 187, .external_lex_state = 6},
  [1928] = {.lex_state = 199, .external_lex_state = 17},
  [1929] = {.lex_state = 187, .external_lex_state = 6},
  [1930] = {.lex_state = 96, .external_lex_state = 2},
  [1931] = {.lex_state = 96, .external_lex_state = 18},
  [1932] = {.lex_state = 96, .external_lex_state = 2},
  [1933] = {.lex_state = 199, .external_lex_state = 17},
  [1934] = {.lex_state = 96, .external_lex_state = 2},
  [1935] = {.lex_state = 187, .external_lex_state = 6},
  [1936] = {.lex_state = 199, .external_lex_state = 17},
  [1937] = {.lex_state = 199, .external_lex_state = 17},
  [1938] = {.lex_state = 199, .external_lex_state = 17},
  [1939] = {.lex_state = 199, .external_lex_state = 17},
  [1940] = {.lex_state = 199, .external_lex_state = 17},
  [1941] = {.lex_state = 34, .external_lex_state = 10},
  [1942] = {.lex_state = 96, .external_lex_state = 2},
  [1943] = {.lex_state = 96, .external_lex_state = 2},
  [1944] = {.lex_state = 90},
  [1945] = {.lex_state = 199, .external_lex_state = 17},
  [1946] = {.lex_state = 96, .external_lex_state = 2},
  [1947] = {.lex_state = 199, .external_lex_state = 17},
  [1948] = {.lex_state = 199, .external_lex_state = 17},
  [1949] = {.lex_state = 199, .external_lex_state = 17},
  [1950] = {.lex_state = 199, .external_lex_state = 17},
  [1951] = {.lex_state = 199, .external_lex_state = 17},
  [1952] = {.lex_state = 96, .external_lex_state = 2},
  [1953] = {.lex_state = 199, .external_lex_state = 17},
  [1954] = {.lex_state = 199, .external_lex_state = 17},
  [1955] = {.lex_state = 96, .external_lex_state = 18},
  [1956] = {.lex_state = 199, .external_lex_state = 17},
  [1957] = {.lex_state = 96},
  [1958] = {.lex_state = 34, .external_lex_state = 10},
  [1959] = {.lex_state = 34, .external_lex_state = 10},
  [1960] = {.lex_state = 34, .external_lex_state = 10},
  [1961] = {.lex_state = 187, .external_lex_state = 6},
  [1962] = {.lex_state = 187, .external_lex_state = 6},
  [1963] = {.lex_state = 187, .external_lex_state = 6},
  [1964] = {.lex_state = 90},
  [1965] = {.lex_state = 34, .external_lex_state = 10},
  [1966] = {.lex_state = 96},
  [1967] = {.lex_state = 96, .external_lex_state = 18},
  [1968] = {.lex_state = 96},
  [1969] = {.lex_state = 187, .external_lex_state = 6},
  [1970] = {.lex_state = 187, .external_lex_state = 6},
  [1971] = {.lex_state = 96, .external_lex_state = 2},
  [1972] = {.lex_state = 96},
  [1973] = {.lex_state = 187, .external_lex_state = 6},
  [1974] = {.lex_state = 96, .external_lex_state = 2},
  [1975] = {.lex_state = 34, .external_lex_state = 10},
  [1976] = {.lex_state = 187, .external_lex_state = 6},
  [1977] = {.lex_state = 92, .external_lex_state = 19},
  [1978] = {.lex_state = 187, .external_lex_state = 6},
  [1979] = {.lex_state = 187, .external_lex_state = 6},
  [1980] = {.lex_state = 199, .external_lex_state = 17},
  [1981] = {.lex_state = 187, .external_lex_state = 6},
  [1982] = {.lex_state = 199, .external_lex_state = 17},
  [1983] = {.lex_state = 96},
  [1984] = {.lex_state = 199, .external_lex_state = 17},
  [1985] = {.lex_state = 96, .external_lex_state = 2},
  [1986] = {.lex_state = 96, .external_lex_state = 2},
  [1987] = {.lex_state = 96},
  [1988] = {.lex_state = 199, .external_lex_state = 17},
  [1989] = {.lex_state = 187, .external_lex_state = 6},
  [1990] = {.lex_state = 34, .external_lex_state = 10},
  [1991] = {.lex_state = 199, .external_lex_state = 17},
  [1992] = {.lex_state = 96, .external_lex_state = 18},
  [1993] = {.lex_state = 199, .external_lex_state = 17},
  [1994] = {.lex_state = 187, .external_lex_state = 6},
  [1995] = {.lex_state = 96},
  [1996] = {.lex_state = 96},
  [1997] = {.lex_state = 96},
  [1998] = {.lex_state = 96, .external_lex_state = 18},
  [1999] = {.lex_state = 96},
  [2000] = {.lex_state = 187, .external_lex_state = 6},
  [2001] = {.lex_state = 96, .external_lex_state = 2},
  [2002] = {.lex_state = 96, .external_lex_state = 2},
  [2003] = {.lex_state = 96, .external_lex_state = 2},
  [2004] = {.lex_state = 91, .external_lex_state = 17},
  [2005] = {.lex_state = 96, .external_lex_state = 2},
  [2006] = {.lex_state = 187, .external_lex_state = 8},
  [2007] = {.lex_state = 187, .external_lex_state = 6},
  [2008] = {.lex_state = 34, .external_lex_state = 10},
  [2009] = {.lex_state = 96, .external_lex_state = 2},
  [2010] = {.lex_state = 187, .external_lex_state = 8},
  [2011] = {.lex_state = 187, .external_lex_state = 6},
  [2012] = {.lex_state = 187, .external_lex_state = 6},
  [2013] = {.lex_state = 96, .external_lex_state = 2},
  [2014] = {.lex_state = 187, .external_lex_state = 6},
  [2015] = {.lex_state = 187, .external_lex_state = 8},
  [2016] = {.lex_state = 96, .external_lex_state = 2},
  [2017] = {.lex_state = 34, .external_lex_state = 10},
  [2018] = {.lex_state = 187, .external_lex_state = 8},
  [2019] = {.lex_state = 187, .external_lex_state = 6},
  [2020] = {.lex_state = 96, .external_lex_state = 18},
  [2021] = {.lex_state = 187, .external_lex_state = 6},
  [2022] = {.lex_state = 96, .external_lex_state = 2},
  [2023] = {.lex_state = 96},
  [2024] = {.lex_state = 34, .external_lex_state = 10},
  [2025] = {.lex_state = 34, .external_lex_state = 10},
  [2026] = {.lex_state = 187, .external_lex_state = 6},
  [2027] = {.lex_state = 187, .external_lex_state = 6},
  [2028] = {.lex_state = 187, .external_lex_state = 8},
  [2029] = {.lex_state = 96, .external_lex_state = 2},
  [2030] = {.lex_state = 34, .external_lex_state = 10},
  [2031] = {.lex_state = 96, .external_lex_state = 2},
  [2032] = {.lex_state = 96, .external_lex_state = 2},
  [2033] = {.lex_state = 96, .external_lex_state = 2},
  [2034] = {.lex_state = 187, .external_lex_state = 8},
  [2035] = {.lex_state = 78},
  [2036] = {.lex_state = 187, .external_lex_state = 6},
  [2037] = {.lex_state = 199, .external_lex_state = 17},
  [2038] = {.lex_state = 96, .external_lex_state = 2},
  [2039] = {.lex_state = 187, .external_lex_state = 6},
  [2040] = {.lex_state = 187, .external_lex_state = 8},
  [2041] = {.lex_state = 187, .external_lex_state = 8},
  [2042] = {.lex_state = 187, .external_lex_state = 6},
  [2043] = {.lex_state = 187, .external_lex_state = 8},
  [2044] = {.lex_state = 96, .external_lex_state = 2},
  [2045] = {.lex_state = 187, .external_lex_state = 6},
  [2046] = {.lex_state = 187, .external_lex_state = 8},
  [2047] = {.lex_state = 187, .external_lex_state = 6},
  [2048] = {.lex_state = 187, .external_lex_state = 8},
  [2049] = {.lex_state = 187, .external_lex_state = 6},
  [2050] = {.lex_state = 187, .external_lex_state = 8},
  [2051] = {.lex_state = 187, .external_lex_state = 6},
  [2052] = {.lex_state = 187, .external_lex_state = 8},
  [2053] = {.lex_state = 187, .external_lex_state = 6},
  [2054] = {.lex_state = 187, .external_lex_state = 8},
  [2055] = {.lex_state = 187, .external_lex_state = 8},
  [2056] = {.lex_state = 187, .external_lex_state = 8},
  [2057] = {.lex_state = 187, .external_lex_state = 8},
  [2058] = {.lex_state = 187, .external_lex_state = 6},
  [2059] = {.lex_state = 187, .external_lex_state = 6},
  [2060] = {.lex_state = 187, .external_lex_state = 6},
  [2061] = {.lex_state = 187, .external_lex_state = 8},
  [2062] = {.lex_state = 187, .external_lex_state = 8},
  [2063] = {.lex_state = 199, .external_lex_state = 17},
  [2064] = {.lex_state = 187, .external_lex_state = 8},
  [2065] = {.lex_state = 187, .external_lex_state = 8},
  [2066] = {.lex_state = 187, .external_lex_state = 8},
  [2067] = {.lex_state = 187, .external_lex_state = 8},
  [2068] = {.lex_state = 199, .external_lex_state = 17},
  [2069] = {.lex_state = 96, .external_lex_state = 2},
  [2070] = {.lex_state = 199, .external_lex_state = 17},
  [2071] = {.lex_state = 187, .external_lex_state = 6},
  [2072] = {.lex_state = 96, .external_lex_state = 18},
  [2073] = {.lex_state = 96, .external_lex_state = 2},
  [2074] = {.lex_state = 96, .external_lex_state = 2},
  [2075] = {.lex_state = 187, .external_lex_state = 8},
  [2076] = {.lex_state = 187, .external_lex_state = 6},
  [2077] = {.lex_state = 187, .external_lex_state = 8},
  [2078] = {.lex_state = 187, .external_lex_state = 6},
  [2079] = {.lex_state = 187, .external_lex_state = 6},
  [2080] = {.lex_state = 187, .external_lex_state = 8},
  [2081] = {.lex_state = 96, .external_lex_state = 2},
  [2082] = {.lex_state = 187, .external_lex_state = 6},
  [2083] = {.lex_state = 91, .external_lex_state = 17},
  [2084] = {.lex_state = 96},
  [2085] = {.lex_state = 96},
  [2086] = {.lex_state = 91, .external_lex_state = 17},
  [2087] = {.lex_state = 187, .external_lex_state = 6},
  [2088] = {.lex_state = 92, .external_lex_state = 11},
  [2089] = {.lex_state = 96},
  [2090] = {.lex_state = 96},
  [2091] = {.lex_state = 96, .external_lex_state = 2},
  [2092] = {.lex_state = 96},
  [2093] = {.lex_state = 96},
  [2094] = {.lex_state = 93, .external_lex_state = 20},
  [2095] = {.lex_state = 91, .external_lex_state = 17},
  [2096] = {.lex_state = 96},
  [2097] = {.lex_state = 187, .external_lex_state = 6},
  [2098] = {.lex_state = 187, .external_lex_state = 6},
  [2099] = {.lex_state = 91, .external_lex_state = 17},
  [2100] = {.lex_state = 199},
  [2101] = {.lex_state = 199},
  [2102] = {.lex_state = 93, .external_lex_state = 20},
  [2103] = {.lex_state = 199},
  [2104] = {.lex_state = 91, .external_lex_state = 17},
  [2105] = {.lex_state = 187, .external_lex_state = 6},
  [2106] = {.lex_state = 96},
  [2107] = {.lex_state = 96},
  [2108] = {.lex_state = 91, .external_lex_state = 17},
  [2109] = {.lex_state = 187, .external_lex_state = 6},
  [2110] = {.lex_state = 96, .external_lex_state = 2},
  [2111] = {.lex_state = 199},
  [2112] = {.lex_state = 187, .external_lex_state = 6},
  [2113] = {.lex_state = 91, .external_lex_state = 17},
  [2114] = {.lex_state = 187, .external_lex_state = 6},
  [2115] = {.lex_state = 96},
  [2116] = {.lex_state = 187, .external_lex_state = 6},
  [2117] = {.lex_state = 96},
  [2118] = {.lex_state = 187, .external_lex_state = 6},
  [2119] = {.lex_state = 187, .external_lex_state = 6},
  [2120] = {.lex_state = 187, .external_lex_state = 6},
  [2121] = {.lex_state = 96},
  [2122] = {.lex_state = 187, .external_lex_state = 6},
  [2123] = {.lex_state = 187, .external_lex_state = 6},
  [2124] = {.lex_state = 187, .external_lex_state = 6},
  [2125] = {.lex_state = 91},
  [2126] = {.lex_state = 187, .external_lex_state = 6},
  [2127] = {.lex_state = 92, .external_lex_state = 19},
  [2128] = {.lex_state = 187, .external_lex_state = 6},
  [2129] = {.lex_state = 96},
  [2130] = {.lex_state = 187, .external_lex_state = 6},
  [2131] = {.lex_state = 199},
  [2132] = {.lex_state = 91, .external_lex_state = 17},
  [2133] = {.lex_state = 187, .external_lex_state = 6},
  [2134] = {.lex_state = 187, .external_lex_state = 6},
  [2135] = {.lex_state = 91, .external_lex_state = 17},
  [2136] = {.lex_state = 187, .external_lex_state = 6},
  [2137] = {.lex_state = 91, .external_lex_state = 17},
  [2138] = {.lex_state = 96},
  [2139] = {.lex_state = 90},
  [2140] = {.lex_state = 187, .external_lex_state = 6},
  [2141] = {.lex_state = 92, .external_lex_state = 19},
  [2142] = {.lex_state = 187, .external_lex_state = 6},
  [2143] = {.lex_state = 187, .external_lex_state = 6},
  [2144] = {.lex_state = 96},
  [2145] = {.lex_state = 199},
  [2146] = {.lex_state = 187, .external_lex_state = 6},
  [2147] = {.lex_state = 187, .external_lex_state = 6},
  [2148] = {.lex_state = 187, .external_lex_state = 6},
  [2149] = {.lex_state = 187, .external_lex_state = 6},
  [2150] = {.lex_state = 94, .external_lex_state = 20},
  [2151] = {.lex_state = 199},
  [2152] = {.lex_state = 94, .external_lex_state = 20},
  [2153] = {.lex_state = 187, .external_lex_state = 6},
  [2154] = {.lex_state = 187, .external_lex_state = 6},
  [2155] = {.lex_state = 94, .external_lex_state = 20},
  [2156] = {.lex_state = 91, .external_lex_state = 17},
  [2157] = {.lex_state = 91, .external_lex_state = 17},
  [2158] = {.lex_state = 199},
  [2159] = {.lex_state = 91, .external_lex_state = 17},
  [2160] = {.lex_state = 94, .external_lex_state = 20},
  [2161] = {.lex_state = 91, .external_lex_state = 17},
  [2162] = {.lex_state = 96},
  [2163] = {.lex_state = 187, .external_lex_state = 6},
  [2164] = {.lex_state = 91, .external_lex_state = 17},
  [2165] = {.lex_state = 187, .external_lex_state = 6},
  [2166] = {.lex_state = 96},
  [2167] = {.lex_state = 91, .external_lex_state = 17},
  [2168] = {.lex_state = 187, .external_lex_state = 6},
  [2169] = {.lex_state = 187, .external_lex_state = 6},
  [2170] = {.lex_state = 187, .external_lex_state = 6},
  [2171] = {.lex_state = 187, .external_lex_state = 6},
  [2172] = {.lex_state = 91, .external_lex_state = 17},
  [2173] = {.lex_state = 187, .external_lex_state = 6},
  [2174] = {.lex_state = 96},
  [2175] = {.lex_state = 187, .external_lex_state = 6},
  [2176] = {.lex_state = 187, .external_lex_state = 6},
  [2177] = {.lex_state = 91, .external_lex_state = 17},
  [2178] = {.lex_state = 91, .external_lex_state = 17},
  [2179] = {.lex_state = 93, .external_lex_state = 20},
  [2180] = {.lex_state = 91, .external_lex_state = 17},
  [2181] = {.lex_state = 187, .external_lex_state = 6},
  [2182] = {.lex_state = 91, .external_lex_state = 17},
  [2183] = {.lex_state = 96},
  [2184] = {.lex_state = 96},
  [2185] = {.lex_state = 92, .external_lex_state = 19},
  [2186] = {.lex_state = 93, .external_lex_state = 20},
  [2187] = {.lex_state = 187, .external_lex_state = 6},
  [2188] = {.lex_state = 92, .external_lex_state = 11},
  [2189] = {.lex_state = 91, .external_lex_state = 17},
  [2190] = {.lex_state = 96, .external_lex_state = 2},
  [2191] = {.lex_state = 91, .external_lex_state = 17},
  [2192] = {.lex_state = 91, .external_lex_state = 17},
  [2193] = {.lex_state = 91, .external_lex_state = 17},
  [2194] = {.lex_state = 91, .external_lex_state = 17},
  [2195] = {.lex_state = 187, .external_lex_state = 6},
  [2196] = {.lex_state = 187, .external_lex_state = 6},
  [2197] = {.lex_state = 187, .external_lex_state = 6},
  [2198] = {.lex_state = 91},
  [2199] = {.lex_state = 187, .external_lex_state = 6},
  [2200] = {.lex_state = 91, .external_lex_state = 17},
  [2201] = {.lex_state = 91, .external_lex_state = 17},
  [2202] = {.lex_state = 94, .external_lex_state = 12},
  [2203] = {.lex_state = 92, .external_lex_state = 11},
  [2204] = {.lex_state = 93, .external_lex_state = 12},
  [2205] = {.lex_state = 92, .external_lex_state = 19},
  [2206] = {.lex_state = 92, .external_lex_state = 19},
  [2207] = {.lex_state = 97, .external_lex_state = 12},
  [2208] = {.lex_state = 97, .external_lex_state = 12},
  [2209] = {.lex_state = 92, .external_lex_state = 19},
  [2210] = {.lex_state = 92, .external_lex_state = 19},
  [2211] = {.lex_state = 92, .external_lex_state = 19},
  [2212] = {.lex_state = 92, .external_lex_state = 19},
  [2213] = {.lex_state = 93, .external_lex_state = 12},
  [2214] = {.lex_state = 97, .external_lex_state = 12},
  [2215] = {.lex_state = 92, .external_lex_state = 19},
  [2216] = {.lex_state = 97, .external_lex_state = 12},
  [2217] = {.lex_state = 93, .external_lex_state = 12},
  [2218] = {.lex_state = 93, .external_lex_state = 12},
  [2219] = {.lex_state = 97, .external_lex_state = 12},
  [2220] = {.lex_state = 92, .external_lex_state = 19},
  [2221] = {.lex_state = 97, .external_lex_state = 12},
  [2222] = {.lex_state = 96},
  [2223] = {.lex_state = 97, .external_lex_state = 12},
  [2224] = {.lex_state = 92, .external_lex_state = 19},
  [2225] = {.lex_state = 92, .external_lex_state = 19},
  [2226] = {.lex_state = 97, .external_lex_state = 12},
  [2227] = {.lex_state = 96, .external_lex_state = 14},
  [2228] = {.lex_state = 92, .external_lex_state = 19},
  [2229] = {.lex_state = 97, .external_lex_state = 12},
  [2230] = {.lex_state = 94, .external_lex_state = 12},
  [2231] = {.lex_state = 97, .external_lex_state = 12},
  [2232] = {.lex_state = 97, .external_lex_state = 12},
  [2233] = {.lex_state = 97, .external_lex_state = 12},
  [2234] = {.lex_state = 92, .external_lex_state = 19},
  [2235] = {.lex_state = 199},
  [2236] = {.lex_state = 92, .external_lex_state = 19},
  [2237] = {.lex_state = 94, .external_lex_state = 20},
  [2238] = {.lex_state = 92, .external_lex_state = 19},
  [2239] = {.lex_state = 94, .external_lex_state = 20},
  [2240] = {.lex_state = 92, .external_lex_state = 19},
  [2241] = {.lex_state = 97, .external_lex_state = 12},
  [2242] = {.lex_state = 92, .external_lex_state = 19},
  [2243] = {.lex_state = 94, .external_lex_state = 20},
  [2244] = {.lex_state = 92, .external_lex_state = 19},
  [2245] = {.lex_state = 97, .external_lex_state = 12},
  [2246] = {.lex_state = 96},
  [2247] = {.lex_state = 97, .external_lex_state = 12},
  [2248] = {.lex_state = 96},
  [2249] = {.lex_state = 97, .external_lex_state = 12},
  [2250] = {.lex_state = 97, .external_lex_state = 12},
  [2251] = {.lex_state = 97, .external_lex_state = 12},
  [2252] = {.lex_state = 97, .external_lex_state = 12},
  [2253] = {.lex_state = 94, .external_lex_state = 20},
  [2254] = {.lex_state = 92, .external_lex_state = 19},
  [2255] = {.lex_state = 97, .external_lex_state = 12},
  [2256] = {.lex_state = 97, .external_lex_state = 12},
  [2257] = {.lex_state = 97, .external_lex_state = 12},
  [2258] = {.lex_state = 97, .external_lex_state = 12},
  [2259] = {.lex_state = 94, .external_lex_state = 20},
  [2260] = {.lex_state = 94, .external_lex_state = 20},
  [2261] = {.lex_state = 92, .external_lex_state = 19},
  [2262] = {.lex_state = 199},
  [2263] = {.lex_state = 94, .external_lex_state = 20},
  [2264] = {.lex_state = 97, .external_lex_state = 12},
  [2265] = {.lex_state = 94, .external_lex_state = 20},
  [2266] = {.lex_state = 97, .external_lex_state = 12},
  [2267] = {.lex_state = 94, .external_lex_state = 20},
  [2268] = {.lex_state = 92, .external_lex_state = 19},
  [2269] = {.lex_state = 94, .external_lex_state = 20},
  [2270] = {.lex_state = 97, .external_lex_state = 12},
  [2271] = {.lex_state = 97, .external_lex_state = 12},
  [2272] = {.lex_state = 97, .external_lex_state = 12},
  [2273] = {.lex_state = 97, .external_lex_state = 12},
  [2274] = {.lex_state = 97, .external_lex_state = 12},
  [2275] = {.lex_state = 97, .external_lex_state = 12},
  [2276] = {.lex_state = 92, .external_lex_state = 19},
  [2277] = {.lex_state = 97, .external_lex_state = 12},
  [2278] = {.lex_state = 97, .external_lex_state = 12},
  [2279] = {.lex_state = 96, .external_lex_state = 14},
  [2280] = {.lex_state = 97, .external_lex_state = 12},
  [2281] = {.lex_state = 97, .external_lex_state = 12},
  [2282] = {.lex_state = 96, .external_lex_state = 14},
  [2283] = {.lex_state = 97, .external_lex_state = 12},
  [2284] = {.lex_state = 97, .external_lex_state = 12},
  [2285] = {.lex_state = 97, .external_lex_state = 12},
  [2286] = {.lex_state = 97, .external_lex_state = 12},
  [2287] = {.lex_state = 94, .external_lex_state = 20},
  [2288] = {.lex_state = 97, .external_lex_state = 12},
  [2289] = {.lex_state = 97, .external_lex_state = 12},
  [2290] = {.lex_state = 94, .external_lex_state = 20},
  [2291] = {.lex_state = 97, .external_lex_state = 12},
  [2292] = {.lex_state = 97, .external_lex_state = 12},
  [2293] = {.lex_state = 94, .external_lex_state = 20},
  [2294] = {.lex_state = 94, .external_lex_state = 20},
  [2295] = {.lex_state = 92, .external_lex_state = 19},
  [2296] = {.lex_state = 94, .external_lex_state = 20},
  [2297] = {.lex_state = 94, .external_lex_state = 20},
  [2298] = {.lex_state = 92, .external_lex_state = 19},
  [2299] = {.lex_state = 96, .external_lex_state = 14},
  [2300] = {.lex_state = 92, .external_lex_state = 19},
  [2301] = {.lex_state = 97, .external_lex_state = 12},
  [2302] = {.lex_state = 97, .external_lex_state = 12},
  [2303] = {.lex_state = 97, .external_lex_state = 12},
  [2304] = {.lex_state = 97, .external_lex_state = 12},
  [2305] = {.lex_state = 97, .external_lex_state = 12},
  [2306] = {.lex_state = 92, .external_lex_state = 19},
  [2307] = {.lex_state = 97, .external_lex_state = 12},
  [2308] = {.lex_state = 97, .external_lex_state = 12},
  [2309] = {.lex_state = 92, .external_lex_state = 19},
  [2310] = {.lex_state = 97, .external_lex_state = 12},
  [2311] = {.lex_state = 97, .external_lex_state = 12},
  [2312] = {.lex_state = 97, .external_lex_state = 12},
  [2313] = {.lex_state = 97, .external_lex_state = 12},
  [2314] = {.lex_state = 97, .external_lex_state = 12},
  [2315] = {.lex_state = 97, .external_lex_state = 12},
  [2316] = {.lex_state = 97, .external_lex_state = 12},
  [2317] = {.lex_state = 97, .external_lex_state = 12},
  [2318] = {.lex_state = 94, .external_lex_state = 20},
  [2319] = {.lex_state = 94, .external_lex_state = 20},
  [2320] = {.lex_state = 94, .external_lex_state = 20},
  [2321] = {.lex_state = 94, .external_lex_state = 20},
  [2322] = {.lex_state = 94, .external_lex_state = 20},
  [2323] = {.lex_state = 97, .external_lex_state = 12},
  [2324] = {.lex_state = 94, .external_lex_state = 20},
  [2325] = {.lex_state = 94, .external_lex_state = 20},
  [2326] = {.lex_state = 94, .external_lex_state = 20},
  [2327] = {.lex_state = 97, .external_lex_state = 12},
  [2328] = {.lex_state = 97, .external_lex_state = 12},
  [2329] = {.lex_state = 97, .external_lex_state = 12},
  [2330] = {.lex_state = 94, .external_lex_state = 20},
  [2331] = {.lex_state = 94, .external_lex_state = 20},
  [2332] = {.lex_state = 96},
  [2333] = {.lex_state = 91},
  [2334] = {.lex_state = 199},
  [2335] = {.lex_state = 199},
  [2336] = {.lex_state = 91},
  [2337] = {.lex_state = 91},
  [2338] = {.lex_state = 91},
  [2339] = {.lex_state = 96},
  [2340] = {.lex_state = 94, .external_lex_state = 12},
  [2341] = {.lex_state = 199},
  [2342] = {.lex_state = 92, .external_lex_state = 11},
  [2343] = {.lex_state = 96},
  [2344] = {.lex_state = 199},
  [2345] = {.lex_state = 92, .external_lex_state = 11},
  [2346] = {.lex_state = 96},
  [2347] = {.lex_state = 96},
  [2348] = {.lex_state = 199},
  [2349] = {.lex_state = 199},
  [2350] = {.lex_state = 96},
  [2351] = {.lex_state = 199},
  [2352] = {.lex_state = 96},
  [2353] = {.lex_state = 199},
  [2354] = {.lex_state = 92, .external_lex_state = 11},
  [2355] = {.lex_state = 96},
  [2356] = {.lex_state = 91},
  [2357] = {.lex_state = 96},
  [2358] = {.lex_state = 96},
  [2359] = {.lex_state = 199},
  [2360] = {.lex_state = 199},
  [2361] = {.lex_state = 199},
  [2362] = {.lex_state = 199},
  [2363] = {.lex_state = 96},
  [2364] = {.lex_state = 199},
  [2365] = {.lex_state = 96},
  [2366] = {.lex_state = 96},
  [2367] = {.lex_state = 91},
  [2368] = {.lex_state = 91},
  [2369] = {.lex_state = 91},
  [2370] = {.lex_state = 91},
  [2371] = {.lex_state = 199},
  [2372] = {.lex_state = 199},
  [2373] = {.lex_state = 199},
  [2374] = {.lex_state = 199},
  [2375] = {.lex_state = 96},
  [2376] = {.lex_state = 96},
  [2377] = {.lex_state = 96},
  [2378] = {.lex_state = 92, .external_lex_state = 11},
  [2379] = {.lex_state = 199},
  [2380] = {.lex_state = 199},
  [2381] = {.lex_state = 199},
  [2382] = {.lex_state = 92, .external_lex_state = 11},
  [2383] = {.lex_state = 91},
  [2384] = {.lex_state = 199},
  [2385] = {.lex_state = 199},
  [2386] = {.lex_state = 92, .external_lex_state = 11},
  [2387] = {.lex_state = 96},
  [2388] = {.lex_state = 92, .external_lex_state = 11},
  [2389] = {.lex_state = 91},
  [2390] = {.lex_state = 199},
  [2391] = {.lex_state = 92, .external_lex_state = 11},
  [2392] = {.lex_state = 96},
  [2393] = {.lex_state = 96},
  [2394] = {.lex_state = 199},
  [2395] = {.lex_state = 92, .external_lex_state = 11},
  [2396] = {.lex_state = 96},
  [2397] = {.lex_state = 92, .external_lex_state = 11},
  [2398] = {.lex_state = 98, .external_lex_state = 11},
  [2399] = {.lex_state = 27, .external_lex_state = 10},
  [2400] = {.lex_state = 98, .external_lex_state = 11},
  [2401] = {.lex_state = 96},
  [2402] = {.lex_state = 96},
  [2403] = {.lex_state = 96},
  [2404] = {.lex_state = 96},
  [2405] = {.lex_state = 96},
  [2406] = {.lex_state = 96},
  [2407] = {.lex_state = 96},
  [2408] = {.lex_state = 96},
  [2409] = {.lex_state = 96},
  [2410] = {.lex_state = 96},
  [2411] = {.lex_state = 96},
  [2412] = {.lex_state = 96},
  [2413] = {.lex_state = 96},
  [2414] = {.lex_state = 96},
  [2415] = {.lex_state = 96},
  [2416] = {.lex_state = 96},
  [2417] = {.lex_state = 96},
  [2418] = {.lex_state = 96},
  [2419] = {.lex_state = 96},
  [2420] = {.lex_state = 96},
  [2421] = {.lex_state = 96},
  [2422] = {.lex_state = 96},
  [2423] = {.lex_state = 96},
  [2424] = {.lex_state = 96},
  [2425] = {.lex_state = 75, .external_lex_state = 15},
  [2426] = {.lex_state = 96},
  [2427] = {.lex_state = 96},
  [2428] = {.lex_state = 96},
  [2429] = {.lex_state = 96},
  [2430] = {.lex_state = 96},
  [2431] = {.lex_state = 96},
  [2432] = {.lex_state = 96},
  [2433] = {.lex_state = 96},
  [2434] = {.lex_state = 75, .external_lex_state = 15},
  [2435] = {.lex_state = 96},
  [2436] = {.lex_state = 96},
  [2437] = {.lex_state = 96},
  [2438] = {.lex_state = 96},
  [2439] = {.lex_state = 96},
  [2440] = {.lex_state = 96},
  [2441] = {.lex_state = 96},
  [2442] = {.lex_state = 75, .external_lex_state = 15},
  [2443] = {.lex_state = 96},
  [2444] = {.lex_state = 75, .external_lex_state = 15},
  [2445] = {.lex_state = 96},
  [2446] = {.lex_state = 96},
  [2447] = {.lex_state = 96},
  [2448] = {.lex_state = 96},
  [2449] = {.lex_state = 96},
  [2450] = {.lex_state = 96},
  [2451] = {.lex_state = 96},
  [2452] = {.lex_state = 96},
  [2453] = {.lex_state = 96},
  [2454] = {.lex_state = 96},
  [2455] = {.lex_state = 96},
  [2456] = {.lex_state = 96},
  [2457] = {.lex_state = 96},
  [2458] = {.lex_state = 96},
  [2459] = {.lex_state = 96},
  [2460] = {.lex_state = 96},
  [2461] = {.lex_state = 96},
  [2462] = {.lex_state = 96},
  [2463] = {.lex_state = 96},
  [2464] = {.lex_state = 96},
  [2465] = {.lex_state = 96},
  [2466] = {.lex_state = 75, .external_lex_state = 15},
  [2467] = {.lex_state = 75, .external_lex_state = 15},
  [2468] = {.lex_state = 75, .external_lex_state = 15},
  [2469] = {.lex_state = 75, .external_lex_state = 15},
  [2470] = {.lex_state = 75, .external_lex_state = 15},
  [2471] = {.lex_state = 75, .external_lex_state = 15},
  [2472] = {.lex_state = 75, .external_lex_state = 15},
  [2473] = {.lex_state = 75, .external_lex_state = 15},
  [2474] = {.lex_state = 75, .external_lex_state = 15},
  [2475] = {.lex_state = 75, .external_lex_state = 15},
  [2476] = {.lex_state = 75, .external_lex_state = 10},
  [2477] = {.lex_state = 75, .external_lex_state = 15},
  [2478] = {.lex_state = 75, .external_lex_state = 15},
  [2479] = {.lex_state = 75, .external_lex_state = 15},
  [2480] = {.lex_state = 75, .external_lex_state = 15},
  [2481] = {.lex_state = 75, .external_lex_state = 15},
  [2482] = {.lex_state = 75, .external_lex_state = 15},
  [2483] = {.lex_state = 75, .external_lex_state = 15},
  [2484] = {.lex_state = 75, .external_lex_state = 15},
  [2485] = {.lex_state = 75, .external_lex_state = 15},
  [2486] = {.lex_state = 75, .external_lex_state = 15},
  [2487] = {.lex_state = 75, .external_lex_state = 15},
  [2488] = {.lex_state = 75, .external_lex_state = 15},
  [2489] = {.lex_state = 75, .external_lex_state = 10},
  [2490] = {.lex_state = 75, .external_lex_state = 15},
  [2491] = {.lex_state = 75, .external_lex_state = 15},
  [2492] = {.lex_state = 75, .external_lex_state = 15},
  [2493] = {.lex_state = 75, .external_lex_state = 15},
  [2494] = {.lex_state = 85},
  [2495] = {.lex_state = 85, .external_lex_state = 19},
  [2496] = {.lex_state = 75, .external_lex_state = 10},
  [2497] = {.lex_state = 96, .external_lex_state = 17},
  [2498] = {.lex_state = 96, .external_lex_state = 17},
  [2499] = {.lex_state = 96, .external_lex_state = 17},
  [2500] = {.lex_state = 96, .external_lex_state = 17},
  [2501] = {.lex_state = 85, .external_lex_state = 12},
  [2502] = {.lex_state = 85, .external_lex_state = 21},
  [2503] = {.lex_state = 85, .external_lex_state = 21},
  [2504] = {.lex_state = 85, .external_lex_state = 21},
  [2505] = {.lex_state = 85, .external_lex_state = 21},
  [2506] = {.lex_state = 85},
  [2507] = {.lex_state = 85, .external_lex_state = 21},
  [2508] = {.lex_state = 85, .external_lex_state = 21},
  [2509] = {.lex_state = 85},
  [2510] = {.lex_state = 85},
  [2511] = {.lex_state = 85},
  [2512] = {.lex_state = 85, .external_lex_state = 21},
  [2513] = {.lex_state = 85},
  [2514] = {.lex_state = 96, .external_lex_state = 17},
  [2515] = {.lex_state = 85, .external_lex_state = 21},
  [2516] = {.lex_state = 85, .external_lex_state = 21},
  [2517] = {.lex_state = 85},
  [2518] = {.lex_state = 85, .external_lex_state = 21},
  [2519] = {.lex_state = 85},
  [2520] = {.lex_state = 96},
  [2521] = {.lex_state = 85, .external_lex_state = 21},
  [2522] = {.lex_state = 85, .external_lex_state = 21},
  [2523] = {.lex_state = 85},
  [2524] = {.lex_state = 85, .external_lex_state = 21},
  [2525] = {.lex_state = 85},
  [2526] = {.lex_state = 85},
  [2527] = {.lex_state = 85, .external_lex_state = 21},
  [2528] = {.lex_state = 96, .external_lex_state = 17},
  [2529] = {.lex_state = 85},
  [2530] = {.lex_state = 85, .external_lex_state = 21},
  [2531] = {.lex_state = 85},
  [2532] = {.lex_state = 85, .external_lex_state = 21},
  [2533] = {.lex_state = 96, .external_lex_state = 17},
  [2534] = {.lex_state = 96, .external_lex_state = 17},
  [2535] = {.lex_state = 96, .external_lex_state = 17},
  [2536] = {.lex_state = 96, .external_lex_state = 17},
  [2537] = {.lex_state = 96, .external_lex_state = 17},
  [2538] = {.lex_state = 96, .external_lex_state = 17},
  [2539] = {.lex_state = 96, .external_lex_state = 17},
  [2540] = {.lex_state = 96, .external_lex_state = 17},
  [2541] = {.lex_state = 96, .external_lex_state = 17},
  [2542] = {.lex_state = 96, .external_lex_state = 17},
  [2543] = {.lex_state = 96, .external_lex_state = 17},
  [2544] = {.lex_state = 96, .external_lex_state = 17},
  [2545] = {.lex_state = 85},
  [2546] = {.lex_state = 96, .external_lex_state = 17},
  [2547] = {.lex_state = 85},
  [2548] = {.lex_state = 96, .external_lex_state = 17},
  [2549] = {.lex_state = 96, .external_lex_state = 17},
  [2550] = {.lex_state = 85, .external_lex_state = 21},
  [2551] = {.lex_state = 85},
  [2552] = {.lex_state = 85},
  [2553] = {.lex_state = 85, .external_lex_state = 21},
  [2554] = {.lex_state = 85, .external_lex_state = 21},
  [2555] = {.lex_state = 96, .external_lex_state = 17},
  [2556] = {.lex_state = 85},
  [2557] = {.lex_state = 85, .external_lex_state = 21},
  [2558] = {.lex_state = 96, .external_lex_state = 17},
  [2559] = {.lex_state = 85},
  [2560] = {.lex_state = 96, .external_lex_state = 17},
  [2561] = {.lex_state = 96, .external_lex_state = 17},
  [2562] = {.lex_state = 85, .external_lex_state = 21},
  [2563] = {.lex_state = 96, .external_lex_state = 17},
  [2564] = {.lex_state = 96, .external_lex_state = 17},
  [2565] = {.lex_state = 85, .external_lex_state = 21},
  [2566] = {.lex_state = 85},
  [2567] = {.lex_state = 96, .external_lex_state = 17},
  [2568] = {.lex_state = 96, .external_lex_state = 17},
  [2569] = {.lex_state = 96, .external_lex_state = 17},
  [2570] = {.lex_state = 85},
  [2571] = {.lex_state = 85, .external_lex_state = 21},
  [2572] = {.lex_state = 85},
  [2573] = {.lex_state = 85, .external_lex_state = 21},
  [2574] = {.lex_state = 85, .external_lex_state = 21},
  [2575] = {.lex_state = 85},
  [2576] = {.lex_state = 85, .external_lex_state = 21},
  [2577] = {.lex_state = 85},
  [2578] = {.lex_state = 85, .external_lex_state = 21},
  [2579] = {.lex_state = 96},
  [2580] = {.lex_state = 85},
  [2581] = {.lex_state = 85, .external_lex_state = 21},
  [2582] = {.lex_state = 85, .external_lex_state = 21},
  [2583] = {.lex_state = 85, .external_lex_state = 21},
  [2584] = {.lex_state = 85},
  [2585] = {.lex_state = 85},
  [2586] = {.lex_state = 85},
  [2587] = {.lex_state = 85},
  [2588] = {.lex_state = 85, .external_lex_state = 21},
  [2589] = {.lex_state = 85},
  [2590] = {.lex_state = 99},
  [2591] = {.lex_state = 86},
  [2592] = {.lex_state = 99},
  [2593] = {.lex_state = 86},
  [2594] = {.lex_state = 99},
  [2595] = {.lex_state = 86},
  [2596] = {.lex_state = 99},
  [2597] = {.lex_state = 99},
  [2598] = {.lex_state = 86},
  [2599] = {.lex_state = 86},
  [2600] = {.lex_state = 86},
  [2601] = {.lex_state = 86},
  [2602] = {.lex_state = 99},
  [2603] = {.lex_state = 86},
  [2604] = {.lex_state = 99},
  [2605] = {.lex_state = 86},
  [2606] = {.lex_state = 86},
  [2607] = {.lex_state = 86},
  [2608] = {.lex_state = 86},
  [2609] = {.lex_state = 86},
  [2610] = {.lex_state = 86},
  [2611] = {.lex_state = 99},
  [2612] = {.lex_state = 86},
  [2613] = {.lex_state = 86},
  [2614] = {.lex_state = 86},
  [2615] = {.lex_state = 86},
  [2616] = {.lex_state = 86},
  [2617] = {.lex_state = 86},
  [2618] = {.lex_state = 86},
  [2619] = {.lex_state = 86},
  [2620] = {.lex_state = 86},
  [2621] = {.lex_state = 86},
  [2622] = {.lex_state = 86},
  [2623] = {.lex_state = 99},
  [2624] = {.lex_state = 86},
  [2625] = {.lex_state = 86},
  [2626] = {.lex_state = 86},
  [2627] = {.lex_state = 86},
  [2628] = {.lex_state = 86},
  [2629] = {.lex_state = 86},
  [2630] = {.lex_state = 96},
  [2631] = {.lex_state = 86},
  [2632] = {.lex_state = 86},
  [2633] = {.lex_state = 86},
  [2634] = {.lex_state = 86},
  [2635] = {.lex_state = 86},
  [2636] = {.lex_state = 86},
  [2637] = {.lex_state = 86},
  [2638] = {.lex_state = 86},
  [2639] = {.lex_state = 86},
  [2640] = {.lex_state = 86},
  [2641] = {.lex_state = 86},
  [2642] = {.lex_state = 86},
  [2643] = {.lex_state = 86},
  [2644] = {.lex_state = 86},
  [2645] = {.lex_state = 86},
  [2646] = {.lex_state = 86},
  [2647] = {.lex_state = 86},
  [2648] = {.lex_state = 86},
  [2649] = {.lex_state = 86},
  [2650] = {.lex_state = 86},
  [2651] = {.lex_state = 86},
  [2652] = {.lex_state = 86},
  [2653] = {.lex_state = 99},
  [2654] = {.lex_state = 86},
  [2655] = {.lex_state = 86},
  [2656] = {.lex_state = 86},
  [2657] = {.lex_state = 86},
  [2658] = {.lex_state = 86},
  [2659] = {.lex_state = 96},
  [2660] = {.lex_state = 96},
  [2661] = {.lex_state = 101, .external_lex_state = 21},
  [2662] = {.lex_state = 96},
  [2663] = {.lex_state = 96},
  [2664] = {.lex_state = 96},
  [2665] = {.lex_state = 96},
  [2666] = {.lex_state = 101, .external_lex_state = 21},
  [2667] = {.lex_state = 96},
  [2668] = {.lex_state = 96},
  [2669] = {.lex_state = 101, .external_lex_state = 21},
  [2670] = {.lex_state = 96},
  [2671] = {.lex_state = 87},
  [2672] = {.lex_state = 96},
  [2673] = {.lex_state = 101, .external_lex_state = 21},
  [2674] = {.lex_state = 96},
  [2675] = {.lex_state = 96},
  [2676] = {.lex_state = 101, .external_lex_state = 21},
  [2677] = {.lex_state = 96},
  [2678] = {.lex_state = 101, .external_lex_state = 21},
  [2679] = {.lex_state = 101, .external_lex_state = 21},
  [2680] = {.lex_state = 101, .external_lex_state = 21},
  [2681] = {.lex_state = 96},
  [2682] = {.lex_state = 101, .external_lex_state = 21},
  [2683] = {.lex_state = 101, .external_lex_state = 21},
  [2684] = {.lex_state = 96},
  [2685] = {.lex_state = 101, .external_lex_state = 21},
  [2686] = {.lex_state = 96},
  [2687] = {.lex_state = 101, .external_lex_state = 21},
  [2688] = {.lex_state = 101, .external_lex_state = 21},
  [2689] = {.lex_state = 101, .external_lex_state = 21},
  [2690] = {.lex_state = 96},
  [2691] = {.lex_state = 101, .external_lex_state = 21},
  [2692] = {.lex_state = 101, .external_lex_state = 21},
  [2693] = {.lex_state = 101, .external_lex_state = 21},
  [2694] = {.lex_state = 101, .external_lex_state = 21},
  [2695] = {.lex_state = 101, .external_lex_state = 21},
  [2696] = {.lex_state = 101, .external_lex_state = 21},
  [2697] = {.lex_state = 96},
  [2698] = {.lex_state = 101, .external_lex_state = 21},
  [2699] = {.lex_state = 101, .external_lex_state = 21},
  [2700] = {.lex_state = 101, .external_lex_state = 21},
  [2701] = {.lex_state = 101, .external_lex_state = 21},
  [2702] = {.lex_state = 101, .external_lex_state = 21},
  [2703] = {.lex_state = 96},
  [2704] = {.lex_state = 96},
  [2705] = {.lex_state = 96},
  [2706] = {.lex_state = 101, .external_lex_state = 21},
  [2707] = {.lex_state = 101, .external_lex_state = 21},
  [2708] = {.lex_state = 96},
  [2709] = {.lex_state = 96},
  [2710] = {.lex_state = 96},
  [2711] = {.lex_state = 101, .external_lex_state = 21},
  [2712] = {.lex_state = 96},
  [2713] = {.lex_state = 101, .external_lex_state = 21},
  [2714] = {.lex_state = 101, .external_lex_state = 21},
  [2715] = {.lex_state = 101, .external_lex_state = 21},
  [2716] = {.lex_state = 96},
  [2717] = {.lex_state = 100},
  [2718] = {.lex_state = 100},
  [2719] = {.lex_state = 100},
  [2720] = {.lex_state = 100},
  [2721] = {.lex_state = 100},
  [2722] = {.lex_state = 100},
  [2723] = {.lex_state = 100},
  [2724] = {.lex_state = 100},
  [2725] = {.lex_state = 100},
  [2726] = {.lex_state = 100},
  [2727] = {.lex_state = 100},
  [2728] = {.lex_state = 100},
  [2729] = {.lex_state = 199, .external_lex_state = 22},
  [2730] = {.lex_state = 100},
  [2731] = {.lex_state = 199, .external_lex_state = 22},
  [2732] = {.lex_state = 100},
  [2733] = {.lex_state = 100},
  [2734] = {.lex_state = 199, .external_lex_state = 22},
  [2735] = {.lex_state = 100},
  [2736] = {.lex_state = 100},
  [2737] = {.lex_state = 100},
  [2738] = {.lex_state = 100},
  [2739] = {.lex_state = 100},
  [2740] = {.lex_state = 199, .external_lex_state = 22},
  [2741] = {.lex_state = 199, .external_lex_state = 22},
  [2742] = {.lex_state = 100},
  [2743] = {.lex_state = 100},
  [2744] = {.lex_state = 100},
  [2745] = {.lex_state = 100},
  [2746] = {.lex_state = 100},
  [2747] = {.lex_state = 100},
  [2748] = {.lex_state = 100},
  [2749] = {.lex_state = 100},
  [2750] = {.lex_state = 100},
  [2751] = {.lex_state = 100},
  [2752] = {.lex_state = 100},
  [2753] = {.lex_state = 100},
  [2754] = {.lex_state = 100},
  [2755] = {.lex_state = 100},
  [2756] = {.lex_state = 199, .external_lex_state = 22},
  [2757] = {.lex_state = 100},
  [2758] = {.lex_state = 100},
  [2759] = {.lex_state = 100},
  [2760] = {.lex_state = 85},
  [2761] = {.lex_state = 100},
  [2762] = {.lex_state = 100},
  [2763] = {.lex_state = 100},
  [2764] = {.lex_state = 100},
  [2765] = {.lex_state = 100},
  [2766] = {.lex_state = 100},
  [2767] = {.lex_state = 100},
  [2768] = {.lex_state = 100},
  [2769] = {.lex_state = 100},
  [2770] = {.lex_state = 100},
  [2771] = {.lex_state = 100},
  [2772] = {.lex_state = 100},
  [2773] = {.lex_state = 100},
  [2774] = {.lex_state = 100},
  [2775] = {.lex_state = 100},
  [2776] = {.lex_state = 100},
  [2777] = {.lex_state = 100},
  [2778] = {.lex_state = 199, .external_lex_state = 22},
  [2779] = {.lex_state = 100},
  [2780] = {.lex_state = 100},
  [2781] = {.lex_state = 100},
  [2782] = {.lex_state = 100},
  [2783] = {.lex_state = 100},
  [2784] = {.lex_state = 101},
  [2785] = {.lex_state = 101},
  [2786] = {.lex_state = 101},
  [2787] = {.lex_state = 101},
  [2788] = {.lex_state = 101},
  [2789] = {.lex_state = 101},
  [2790] = {.lex_state = 101},
  [2791] = {.lex_state = 101},
  [2792] = {.lex_state = 101},
  [2793] = {.lex_state = 101},
  [2794] = {.lex_state = 101},
  [2795] = {.lex_state = 101},
  [2796] = {.lex_state = 101},
  [2797] = {.lex_state = 101},
  [2798] = {.lex_state = 188, .external_lex_state = 15},
  [2799] = {.lex_state = 188, .external_lex_state = 10},
  [2800] = {.lex_state = 29, .external_lex_state = 10},
  [2801] = {.lex_state = 100, .external_lex_state = 17},
  [2802] = {.lex_state = 100, .external_lex_state = 17},
  [2803] = {.lex_state = 188, .external_lex_state = 15},
  [2804] = {.lex_state = 100, .external_lex_state = 17},
  [2805] = {.lex_state = 100, .external_lex_state = 17},
  [2806] = {.lex_state = 188, .external_lex_state = 10},
  [2807] = {.lex_state = 188, .external_lex_state = 15},
  [2808] = {.lex_state = 188, .external_lex_state = 10},
  [2809] = {.lex_state = 100, .external_lex_state = 17},
  [2810] = {.lex_state = 188, .external_lex_state = 15},
  [2811] = {.lex_state = 100, .external_lex_state = 17},
  [2812] = {.lex_state = 100, .external_lex_state = 17},
  [2813] = {.lex_state = 29, .external_lex_state = 10},
  [2814] = {.lex_state = 100, .external_lex_state = 17},
  [2815] = {.lex_state = 100, .external_lex_state = 17},
  [2816] = {.lex_state = 188, .external_lex_state = 10},
  [2817] = {.lex_state = 188, .external_lex_state = 15},
  [2818] = {.lex_state = 100, .external_lex_state = 17},
  [2819] = {.lex_state = 100, .external_lex_state = 17},
  [2820] = {.lex_state = 100, .external_lex_state = 17},
  [2821] = {.lex_state = 100, .external_lex_state = 17},
  [2822] = {.lex_state = 29, .external_lex_state = 10},
  [2823] = {.lex_state = 100, .external_lex_state = 17},
  [2824] = {.lex_state = 100, .external_lex_state = 17},
  [2825] = {.lex_state = 100, .external_lex_state = 17},
  [2826] = {.lex_state = 100, .external_lex_state = 17},
  [2827] = {.lex_state = 188, .external_lex_state = 15},
  [2828] = {.lex_state = 100, .external_lex_state = 17},
  [2829] = {.lex_state = 29, .external_lex_state = 10},
  [2830] = {.lex_state = 100, .external_lex_state = 17},
  [2831] = {.lex_state = 100, .external_lex_state = 17},
  [2832] = {.lex_state = 100, .external_lex_state = 17},
  [2833] = {.lex_state = 29, .external_lex_state = 10},
  [2834] = {.lex_state = 100, .external_lex_state = 17},
  [2835] = {.lex_state = 199, .external_lex_state = 22},
  [2836] = {.lex_state = 199, .external_lex_state = 22},
  [2837] = {.lex_state = 199, .external_lex_state = 22},
  [2838] = {.lex_state = 199, .external_lex_state = 22},
  [2839] = {.lex_state = 188, .external_lex_state = 15},
  [2840] = {.lex_state = 188, .external_lex_state = 15},
  [2841] = {.lex_state = 199},
  [2842] = {.lex_state = 188, .external_lex_state = 15},
  [2843] = {.lex_state = 199},
  [2844] = {.lex_state = 199, .external_lex_state = 22},
  [2845] = {.lex_state = 188, .external_lex_state = 15},
  [2846] = {.lex_state = 188, .external_lex_state = 15},
  [2847] = {.lex_state = 199, .external_lex_state = 22},
  [2848] = {.lex_state = 199, .external_lex_state = 22},
  [2849] = {.lex_state = 199, .external_lex_state = 22},
  [2850] = {.lex_state = 199, .external_lex_state = 22},
  [2851] = {.lex_state = 29, .external_lex_state = 10},
  [2852] = {.lex_state = 199, .external_lex_state = 22},
  [2853] = {.lex_state = 199, .external_lex_state = 22},
  [2854] = {.lex_state = 188, .external_lex_state = 15},
  [2855] = {.lex_state = 199, .external_lex_state = 22},
  [2856] = {.lex_state = 100},
  [2857] = {.lex_state = 199, .external_lex_state = 22},
  [2858] = {.lex_state = 100},
  [2859] = {.lex_state = 188, .external_lex_state = 15},
  [2860] = {.lex_state = 188, .external_lex_state = 15},
  [2861] = {.lex_state = 199},
  [2862] = {.lex_state = 188, .external_lex_state = 15},
  [2863] = {.lex_state = 188, .external_lex_state = 15},
  [2864] = {.lex_state = 199, .external_lex_state = 22},
  [2865] = {.lex_state = 188, .external_lex_state = 10},
  [2866] = {.lex_state = 199, .external_lex_state = 22},
  [2867] = {.lex_state = 188, .external_lex_state = 15},
  [2868] = {.lex_state = 199, .external_lex_state = 22},
  [2869] = {.lex_state = 188, .external_lex_state = 15},
  [2870] = {.lex_state = 199, .external_lex_state = 22},
  [2871] = {.lex_state = 188, .external_lex_state = 10},
  [2872] = {.lex_state = 29, .external_lex_state = 10},
  [2873] = {.lex_state = 199, .external_lex_state = 22},
  [2874] = {.lex_state = 188, .external_lex_state = 15},
  [2875] = {.lex_state = 188, .external_lex_state = 15},
  [2876] = {.lex_state = 188, .external_lex_state = 15},
  [2877] = {.lex_state = 188, .external_lex_state = 15},
  [2878] = {.lex_state = 199, .external_lex_state = 22},
  [2879] = {.lex_state = 199, .external_lex_state = 22},
  [2880] = {.lex_state = 199},
  [2881] = {.lex_state = 188, .external_lex_state = 15},
  [2882] = {.lex_state = 188, .external_lex_state = 15},
  [2883] = {.lex_state = 188, .external_lex_state = 15},
  [2884] = {.lex_state = 188, .external_lex_state = 15},
  [2885] = {.lex_state = 188, .external_lex_state = 10},
  [2886] = {.lex_state = 199},
  [2887] = {.lex_state = 188, .external_lex_state = 15},
  [2888] = {.lex_state = 199},
  [2889] = {.lex_state = 188, .external_lex_state = 10},
  [2890] = {.lex_state = 188, .external_lex_state = 15},
  [2891] = {.lex_state = 188, .external_lex_state = 15},
  [2892] = {.lex_state = 188, .external_lex_state = 15},
  [2893] = {.lex_state = 188, .external_lex_state = 15},
  [2894] = {.lex_state = 188, .external_lex_state = 15},
  [2895] = {.lex_state = 102},
  [2896] = {.lex_state = 188, .external_lex_state = 10},
  [2897] = {.lex_state = 188, .external_lex_state = 10},
  [2898] = {.lex_state = 188, .external_lex_state = 10},
  [2899] = {.lex_state = 102},
  [2900] = {.lex_state = 188, .external_lex_state = 10},
  [2901] = {.lex_state = 188, .external_lex_state = 10},
  [2902] = {.lex_state = 188, .external_lex_state = 10},
  [2903] = {.lex_state = 188, .external_lex_state = 10},
  [2904] = {.lex_state = 102},
  [2905] = {.lex_state = 102},
  [2906] = {.lex_state = 102},
  [2907] = {.lex_state = 102},
  [2908] = {.lex_state = 102},
  [2909] = {.lex_state = 102},
  [2910] = {.lex_state = 102},
  [2911] = {.lex_state = 102},
  [2912] = {.lex_state = 102},
  [2913] = {.lex_state = 188, .external_lex_state = 10},
  [2914] = {.lex_state = 91, .external_lex_state = 17},
  [2915] = {.lex_state = 102},
  [2916] = {.lex_state = 199},
  [2917] = {.lex_state = 102},
  [2918] = {.lex_state = 102},
  [2919] = {.lex_state = 102},
  [2920] = {.lex_state = 102},
  [2921] = {.lex_state = 188, .external_lex_state = 10},
  [2922] = {.lex_state = 188, .external_lex_state = 10},
  [2923] = {.lex_state = 91, .external_lex_state = 17},
  [2924] = {.lex_state = 188, .external_lex_state = 10},
  [2925] = {.lex_state = 102},
  [2926] = {.lex_state = 91},
  [2927] = {.lex_state = 91, .external_lex_state = 17},
  [2928] = {.lex_state = 91},
  [2929] = {.lex_state = 188, .external_lex_state = 10},
  [2930] = {.lex_state = 188, .external_lex_state = 10},
  [2931] = {.lex_state = 102},
  [2932] = {.lex_state = 102},
  [2933] = {.lex_state = 102},
  [2934] = {.lex_state = 102},
  [2935] = {.lex_state = 102},
  [2936] = {.lex_state = 102},
  [2937] = {.lex_state = 188, .external_lex_state = 10},
  [2938] = {.lex_state = 188, .external_lex_state = 10},
  [2939] = {.lex_state = 102},
  [2940] = {.lex_state = 188, .external_lex_state = 10},
  [2941] = {.lex_state = 102},
  [2942] = {.lex_state = 102},
  [2943] = {.lex_state = 102},
  [2944] = {.lex_state = 102},
  [2945] = {.lex_state = 102},
  [2946] = {.lex_state = 102},
  [2947] = {.lex_state = 102},
  [2948] = {.lex_state = 188, .external_lex_state = 10},
  [2949] = {.lex_state = 188, .external_lex_state = 10},
  [2950] = {.lex_state = 102},
  [2951] = {.lex_state = 102},
  [2952] = {.lex_state = 102},
  [2953] = {.lex_state = 102},
  [2954] = {.lex_state = 199},
  [2955] = {.lex_state = 102},
  [2956] = {.lex_state = 188, .external_lex_state = 10},
  [2957] = {.lex_state = 102},
  [2958] = {.lex_state = 199},
  [2959] = {.lex_state = 188, .external_lex_state = 10},
  [2960] = {.lex_state = 188, .external_lex_state = 10},
  [2961] = {.lex_state = 188, .external_lex_state = 10},
  [2962] = {.lex_state = 92, .external_lex_state = 19},
  [2963] = {.lex_state = 92, .external_lex_state = 19},
  [2964] = {.lex_state = 92, .external_lex_state = 19},
  [2965] = {.lex_state = 199},
  [2966] = {.lex_state = 188, .external_lex_state = 10},
  [2967] = {.lex_state = 103, .external_lex_state = 20},
  [2968] = {.lex_state = 188, .external_lex_state = 10},
  [2969] = {.lex_state = 199},
  [2970] = {.lex_state = 91, .external_lex_state = 17},
  [2971] = {.lex_state = 188, .external_lex_state = 10},
  [2972] = {.lex_state = 188, .external_lex_state = 10},
  [2973] = {.lex_state = 188, .external_lex_state = 10},
  [2974] = {.lex_state = 199},
  [2975] = {.lex_state = 188, .external_lex_state = 10},
  [2976] = {.lex_state = 188, .external_lex_state = 10},
  [2977] = {.lex_state = 188, .external_lex_state = 10},
  [2978] = {.lex_state = 188, .external_lex_state = 10},
  [2979] = {.lex_state = 102},
  [2980] = {.lex_state = 92, .external_lex_state = 19},
  [2981] = {.lex_state = 91},
  [2982] = {.lex_state = 102},
  [2983] = {.lex_state = 91, .external_lex_state = 17},
  [2984] = {.lex_state = 102},
  [2985] = {.lex_state = 102},
  [2986] = {.lex_state = 102},
  [2987] = {.lex_state = 102},
  [2988] = {.lex_state = 102},
  [2989] = {.lex_state = 102},
  [2990] = {.lex_state = 188, .external_lex_state = 10},
  [2991] = {.lex_state = 102},
  [2992] = {.lex_state = 102},
  [2993] = {.lex_state = 102},
  [2994] = {.lex_state = 103, .external_lex_state = 12},
  [2995] = {.lex_state = 103, .external_lex_state = 12},
  [2996] = {.lex_state = 103, .external_lex_state = 12},
  [2997] = {.lex_state = 101, .external_lex_state = 20},
  [2998] = {.lex_state = 101, .external_lex_state = 20},
  [2999] = {.lex_state = 101, .external_lex_state = 20},
  [3000] = {.lex_state = 103, .external_lex_state = 12},
  [3001] = {.lex_state = 103, .external_lex_state = 12},
  [3002] = {.lex_state = 101, .external_lex_state = 20},
  [3003] = {.lex_state = 101, .external_lex_state = 20},
  [3004] = {.lex_state = 101, .external_lex_state = 20},
  [3005] = {.lex_state = 102},
  [3006] = {.lex_state = 103, .external_lex_state = 12},
  [3007] = {.lex_state = 103, .external_lex_state = 12},
  [3008] = {.lex_state = 103, .external_lex_state = 12},
  [3009] = {.lex_state = 91},
  [3010] = {.lex_state = 91},
  [3011] = {.lex_state = 91},
  [3012] = {.lex_state = 101, .external_lex_state = 20},
  [3013] = {.lex_state = 103, .external_lex_state = 12},
  [3014] = {.lex_state = 103, .external_lex_state = 12},
  [3015] = {.lex_state = 101, .external_lex_state = 20},
  [3016] = {.lex_state = 101, .external_lex_state = 20},
  [3017] = {.lex_state = 103, .external_lex_state = 12},
  [3018] = {.lex_state = 101, .external_lex_state = 20},
  [3019] = {.lex_state = 103, .external_lex_state = 12},
  [3020] = {.lex_state = 103, .external_lex_state = 12},
  [3021] = {.lex_state = 101, .external_lex_state = 20},
  [3022] = {.lex_state = 103, .external_lex_state = 12},
  [3023] = {.lex_state = 101, .external_lex_state = 20},
  [3024] = {.lex_state = 101, .external_lex_state = 20},
  [3025] = {.lex_state = 103, .external_lex_state = 12},
  [3026] = {.lex_state = 101, .external_lex_state = 20},
  [3027] = {.lex_state = 101, .external_lex_state = 20},
  [3028] = {.lex_state = 103, .external_lex_state = 12},
  [3029] = {.lex_state = 101, .external_lex_state = 20},
  [3030] = {.lex_state = 101, .external_lex_state = 20},
  [3031] = {.lex_state = 103, .external_lex_state = 12},
  [3032] = {.lex_state = 103, .external_lex_state = 12},
  [3033] = {.lex_state = 101, .external_lex_state = 20},
  [3034] = {.lex_state = 101, .external_lex_state = 20},
  [3035] = {.lex_state = 101, .external_lex_state = 20},
  [3036] = {.lex_state = 91},
  [3037] = {.lex_state = 103, .external_lex_state = 12},
  [3038] = {.lex_state = 103, .external_lex_state = 12},
  [3039] = {.lex_state = 101, .external_lex_state = 20},
  [3040] = {.lex_state = 101, .external_lex_state = 20},
  [3041] = {.lex_state = 101, .external_lex_state = 20},
  [3042] = {.lex_state = 103, .external_lex_state = 12},
  [3043] = {.lex_state = 101, .external_lex_state = 20},
  [3044] = {.lex_state = 103, .external_lex_state = 12},
  [3045] = {.lex_state = 103, .external_lex_state = 12},
  [3046] = {.lex_state = 101, .external_lex_state = 20},
  [3047] = {.lex_state = 101, .external_lex_state = 20},
  [3048] = {.lex_state = 103, .external_lex_state = 12},
  [3049] = {.lex_state = 103, .external_lex_state = 12},
  [3050] = {.lex_state = 103, .external_lex_state = 12},
  [3051] = {.lex_state = 101, .external_lex_state = 17},
  [3052] = {.lex_state = 101, .external_lex_state = 20},
  [3053] = {.lex_state = 103, .external_lex_state = 12},
  [3054] = {.lex_state = 103, .external_lex_state = 12},
  [3055] = {.lex_state = 101, .external_lex_state = 20},
  [3056] = {.lex_state = 101, .external_lex_state = 17},
  [3057] = {.lex_state = 101, .external_lex_state = 20},
  [3058] = {.lex_state = 199},
  [3059] = {.lex_state = 102},
  [3060] = {.lex_state = 102},
  [3061] = {.lex_state = 199},
  [3062] = {.lex_state = 101, .external_lex_state = 20},
  [3063] = {.lex_state = 102},
  [3064] = {.lex_state = 103, .external_lex_state = 12},
  [3065] = {.lex_state = 103, .external_lex_state = 12},
  [3066] = {.lex_state = 101, .external_lex_state = 20},
  [3067] = {.lex_state = 101, .external_lex_state = 20},
  [3068] = {.lex_state = 102},
  [3069] = {.lex_state = 103, .external_lex_state = 12},
  [3070] = {.lex_state = 103, .external_lex_state = 12},
  [3071] = {.lex_state = 101, .external_lex_state = 20},
  [3072] = {.lex_state = 101, .external_lex_state = 20},
  [3073] = {.lex_state = 92, .external_lex_state = 19},
  [3074] = {.lex_state = 103, .external_lex_state = 12},
  [3075] = {.lex_state = 101, .external_lex_state = 20},
  [3076] = {.lex_state = 91},
  [3077] = {.lex_state = 102},
  [3078] = {.lex_state = 103, .external_lex_state = 12},
  [3079] = {.lex_state = 103, .external_lex_state = 12},
  [3080] = {.lex_state = 101, .external_lex_state = 20},
  [3081] = {.lex_state = 101, .external_lex_state = 17},
  [3082] = {.lex_state = 102},
  [3083] = {.lex_state = 101, .external_lex_state = 20},
  [3084] = {.lex_state = 199},
  [3085] = {.lex_state = 103, .external_lex_state = 12},
  [3086] = {.lex_state = 103, .external_lex_state = 12},
  [3087] = {.lex_state = 101, .external_lex_state = 20},
  [3088] = {.lex_state = 101, .external_lex_state = 20},
  [3089] = {.lex_state = 103, .external_lex_state = 12},
  [3090] = {.lex_state = 91},
  [3091] = {.lex_state = 101, .external_lex_state = 20},
  [3092] = {.lex_state = 103, .external_lex_state = 12},
  [3093] = {.lex_state = 103, .external_lex_state = 12},
  [3094] = {.lex_state = 103, .external_lex_state = 12},
  [3095] = {.lex_state = 101, .external_lex_state = 20},
  [3096] = {.lex_state = 103, .external_lex_state = 12},
  [3097] = {.lex_state = 199},
  [3098] = {.lex_state = 101, .external_lex_state = 20},
  [3099] = {.lex_state = 103, .external_lex_state = 12},
  [3100] = {.lex_state = 102},
  [3101] = {.lex_state = 92, .external_lex_state = 19},
  [3102] = {.lex_state = 101, .external_lex_state = 20},
  [3103] = {.lex_state = 101, .external_lex_state = 20},
  [3104] = {.lex_state = 103, .external_lex_state = 12},
  [3105] = {.lex_state = 199},
  [3106] = {.lex_state = 101, .external_lex_state = 20},
  [3107] = {.lex_state = 103, .external_lex_state = 12},
  [3108] = {.lex_state = 101, .external_lex_state = 20},
  [3109] = {.lex_state = 103, .external_lex_state = 12},
  [3110] = {.lex_state = 102},
  [3111] = {.lex_state = 101, .external_lex_state = 20},
  [3112] = {.lex_state = 101, .external_lex_state = 20},
  [3113] = {.lex_state = 92, .external_lex_state = 19},
  [3114] = {.lex_state = 101, .external_lex_state = 20},
  [3115] = {.lex_state = 101, .external_lex_state = 20},
  [3116] = {.lex_state = 103, .external_lex_state = 12},
  [3117] = {.lex_state = 103, .external_lex_state = 12},
  [3118] = {.lex_state = 101, .external_lex_state = 20},
  [3119] = {.lex_state = 101, .external_lex_state = 17},
  [3120] = {.lex_state = 103, .external_lex_state = 12},
  [3121] = {.lex_state = 103, .external_lex_state = 12},
  [3122] = {.lex_state = 103, .external_lex_state = 12},
  [3123] = {.lex_state = 103, .external_lex_state = 12},
  [3124] = {.lex_state = 101, .external_lex_state = 20},
  [3125] = {.lex_state = 101, .external_lex_state = 20},
  [3126] = {.lex_state = 103, .external_lex_state = 12},
  [3127] = {.lex_state = 101, .external_lex_state = 20},
  [3128] = {.lex_state = 92, .external_lex_state = 19},
  [3129] = {.lex_state = 103, .external_lex_state = 12},
  [3130] = {.lex_state = 101, .external_lex_state = 20},
  [3131] = {.lex_state = 101, .external_lex_state = 20},
  [3132] = {.lex_state = 101, .external_lex_state = 20},
  [3133] = {.lex_state = 103, .external_lex_state = 12},
  [3134] = {.lex_state = 103, .external_lex_state = 12},
  [3135] = {.lex_state = 101, .external_lex_state = 20},
  [3136] = {.lex_state = 103, .external_lex_state = 12},
  [3137] = {.lex_state = 101, .external_lex_state = 20},
  [3138] = {.lex_state = 91},
  [3139] = {.lex_state = 91},
  [3140] = {.lex_state = 91},
  [3141] = {.lex_state = 101, .external_lex_state = 20},
  [3142] = {.lex_state = 103, .external_lex_state = 12},
  [3143] = {.lex_state = 101, .external_lex_state = 20},
  [3144] = {.lex_state = 103, .external_lex_state = 12},
  [3145] = {.lex_state = 103, .external_lex_state = 12},
  [3146] = {.lex_state = 103, .external_lex_state = 12},
  [3147] = {.lex_state = 101, .external_lex_state = 20},
  [3148] = {.lex_state = 101, .external_lex_state = 20},
  [3149] = {.lex_state = 103, .external_lex_state = 12},
  [3150] = {.lex_state = 103, .external_lex_state = 12},
  [3151] = {.lex_state = 101, .external_lex_state = 20},
  [3152] = {.lex_state = 102},
  [3153] = {.lex_state = 101, .external_lex_state = 20},
  [3154] = {.lex_state = 101, .external_lex_state = 20},
  [3155] = {.lex_state = 101, .external_lex_state = 20},
  [3156] = {.lex_state = 90},
  [3157] = {.lex_state = 101, .external_lex_state = 20},
  [3158] = {.lex_state = 101},
  [3159] = {.lex_state = 101},
  [3160] = {.lex_state = 101, .external_lex_state = 20},
  [3161] = {.lex_state = 90},
  [3162] = {.lex_state = 90},
  [3163] = {.lex_state = 102},
  [3164] = {.lex_state = 102},
  [3165] = {.lex_state = 102},
  [3166] = {.lex_state = 102},
  [3167] = {.lex_state = 102},
  [3168] = {.lex_state = 102},
  [3169] = {.lex_state = 199},
  [3170] = {.lex_state = 102},
  [3171] = {.lex_state = 102},
  [3172] = {.lex_state = 102},
  [3173] = {.lex_state = 102},
  [3174] = {.lex_state = 102},
  [3175] = {.lex_state = 102},
  [3176] = {.lex_state = 101},
  [3177] = {.lex_state = 102},
  [3178] = {.lex_state = 102},
  [3179] = {.lex_state = 102},
  [3180] = {.lex_state = 102},
  [3181] = {.lex_state = 101, .external_lex_state = 20},
  [3182] = {.lex_state = 103, .external_lex_state = 12},
  [3183] = {.lex_state = 102},
  [3184] = {.lex_state = 102},
  [3185] = {.lex_state = 102},
  [3186] = {.lex_state = 102},
  [3187] = {.lex_state = 102},
  [3188] = {.lex_state = 102},
  [3189] = {.lex_state = 199},
  [3190] = {.lex_state = 102},
  [3191] = {.lex_state = 102},
  [3192] = {.lex_state = 102},
  [3193] = {.lex_state = 102},
  [3194] = {.lex_state = 199},
  [3195] = {.lex_state = 92, .external_lex_state = 19},
  [3196] = {.lex_state = 91},
  [3197] = {.lex_state = 102},
  [3198] = {.lex_state = 102},
  [3199] = {.lex_state = 102},
  [3200] = {.lex_state = 102},
  [3201] = {.lex_state = 102},
  [3202] = {.lex_state = 101, .external_lex_state = 20},
  [3203] = {.lex_state = 101, .external_lex_state = 20},
  [3204] = {.lex_state = 101, .external_lex_state = 20},
  [3205] = {.lex_state = 101, .external_lex_state = 20},
  [3206] = {.lex_state = 102},
  [3207] = {.lex_state = 101, .external_lex_state = 20},
  [3208] = {.lex_state = 199},
  [3209] = {.lex_state = 102},
  [3210] = {.lex_state = 102},
  [3211] = {.lex_state = 101},
  [3212] = {.lex_state = 102},
  [3213] = {.lex_state = 102},
  [3214] = {.lex_state = 102},
  [3215] = {.lex_state = 199},
  [3216] = {.lex_state = 101},
  [3217] = {.lex_state = 102},
  [3218] = {.lex_state = 102},
  [3219] = {.lex_state = 199},
  [3220] = {.lex_state = 102},
  [3221] = {.lex_state = 102},
  [3222] = {.lex_state = 102},
  [3223] = {.lex_state = 102},
  [3224] = {.lex_state = 101, .external_lex_state = 20},
  [3225] = {.lex_state = 102},
  [3226] = {.lex_state = 101, .external_lex_state = 20},
  [3227] = {.lex_state = 102},
  [3228] = {.lex_state = 102},
  [3229] = {.lex_state = 101},
  [3230] = {.lex_state = 102},
  [3231] = {.lex_state = 101, .external_lex_state = 20},
  [3232] = {.lex_state = 101, .external_lex_state = 20},
  [3233] = {.lex_state = 102},
  [3234] = {.lex_state = 101},
  [3235] = {.lex_state = 102},
  [3236] = {.lex_state = 102},
  [3237] = {.lex_state = 101},
  [3238] = {.lex_state = 101, .external_lex_state = 20},
  [3239] = {.lex_state = 101, .external_lex_state = 20},
  [3240] = {.lex_state = 101, .external_lex_state = 20},
  [3241] = {.lex_state = 102},
  [3242] = {.lex_state = 199},
  [3243] = {.lex_state = 102},
  [3244] = {.lex_state = 101},
  [3245] = {.lex_state = 102},
  [3246] = {.lex_state = 101, .external_lex_state = 20},
  [3247] = {.lex_state = 199},
  [3248] = {.lex_state = 102},
  [3249] = {.lex_state = 101},
  [3250] = {.lex_state = 101, .external_lex_state = 20},
  [3251] = {.lex_state = 102},
  [3252] = {.lex_state = 101, .external_lex_state = 20},
  [3253] = {.lex_state = 102},
  [3254] = {.lex_state = 101},
  [3255] = {.lex_state = 102},
  [3256] = {.lex_state = 102},
  [3257] = {.lex_state = 199},
  [3258] = {.lex_state = 101},
  [3259] = {.lex_state = 92, .external_lex_state = 19},
  [3260] = {.lex_state = 101, .external_lex_state = 20},
  [3261] = {.lex_state = 101, .external_lex_state = 20},
  [3262] = {.lex_state = 102},
  [3263] = {.lex_state = 101},
  [3264] = {.lex_state = 101, .external_lex_state = 20},
  [3265] = {.lex_state = 199},
  [3266] = {.lex_state = 101, .external_lex_state = 20},
  [3267] = {.lex_state = 102},
  [3268] = {.lex_state = 102},
  [3269] = {.lex_state = 101, .external_lex_state = 20},
  [3270] = {.lex_state = 199},
  [3271] = {.lex_state = 101, .external_lex_state = 12},
  [3272] = {.lex_state = 91},
  [3273] = {.lex_state = 199},
  [3274] = {.lex_state = 199},
  [3275] = {.lex_state = 91},
  [3276] = {.lex_state = 101, .external_lex_state = 12},
  [3277] = {.lex_state = 199},
  [3278] = {.lex_state = 199},
  [3279] = {.lex_state = 199},
  [3280] = {.lex_state = 91},
  [3281] = {.lex_state = 101, .external_lex_state = 12},
  [3282] = {.lex_state = 199},
  [3283] = {.lex_state = 91},
  [3284] = {.lex_state = 199},
  [3285] = {.lex_state = 199},
  [3286] = {.lex_state = 92, .external_lex_state = 11},
  [3287] = {.lex_state = 91},
  [3288] = {.lex_state = 101, .external_lex_state = 12},
  [3289] = {.lex_state = 101, .external_lex_state = 12},
  [3290] = {.lex_state = 101, .external_lex_state = 12},
  [3291] = {.lex_state = 92, .external_lex_state = 11},
  [3292] = {.lex_state = 101, .external_lex_state = 12},
  [3293] = {.lex_state = 91},
  [3294] = {.lex_state = 101, .external_lex_state = 12},
  [3295] = {.lex_state = 101, .external_lex_state = 12},
  [3296] = {.lex_state = 199},
  [3297] = {.lex_state = 95},
  [3298] = {.lex_state = 199},
  [3299] = {.lex_state = 101, .external_lex_state = 12},
  [3300] = {.lex_state = 199},
  [3301] = {.lex_state = 199},
  [3302] = {.lex_state = 101, .external_lex_state = 12},
  [3303] = {.lex_state = 91},
  [3304] = {.lex_state = 101, .external_lex_state = 12},
  [3305] = {.lex_state = 91},
  [3306] = {.lex_state = 101, .external_lex_state = 12},
  [3307] = {.lex_state = 199},
  [3308] = {.lex_state = 91},
  [3309] = {.lex_state = 101, .external_lex_state = 12},
  [3310] = {.lex_state = 91},
  [3311] = {.lex_state = 199},
  [3312] = {.lex_state = 91},
  [3313] = {.lex_state = 91},
  [3314] = {.lex_state = 101, .external_lex_state = 12},
  [3315] = {.lex_state = 91},
  [3316] = {.lex_state = 199},
  [3317] = {.lex_state = 91},
  [3318] = {.lex_state = 91},
  [3319] = {.lex_state = 199},
  [3320] = {.lex_state = 199},
  [3321] = {.lex_state = 199, .external_lex_state = 23},
  [3322] = {.lex_state = 199},
  [3323] = {.lex_state = 101, .external_lex_state = 12},
  [3324] = {.lex_state = 91},
  [3325] = {.lex_state = 91},
  [3326] = {.lex_state = 91},
  [3327] = {.lex_state = 91},
  [3328] = {.lex_state = 199},
  [3329] = {.lex_state = 199, .external_lex_state = 23},
  [3330] = {.lex_state = 91},
  [3331] = {.lex_state = 91},
  [3332] = {.lex_state = 91},
  [3333] = {.lex_state = 199},
  [3334] = {.lex_state = 91},
  [3335] = {.lex_state = 199},
  [3336] = {.lex_state = 91},
  [3337] = {.lex_state = 101, .external_lex_state = 12},
  [3338] = {.lex_state = 199},
  [3339] = {.lex_state = 199},
  [3340] = {.lex_state = 101, .external_lex_state = 12},
  [3341] = {.lex_state = 101, .external_lex_state = 12},
  [3342] = {.lex_state = 199},
  [3343] = {.lex_state = 91},
  [3344] = {.lex_state = 199},
  [3345] = {.lex_state = 101, .external_lex_state = 12},
  [3346] = {.lex_state = 91},
  [3347] = {.lex_state = 199},
  [3348] = {.lex_state = 199},
  [3349] = {.lex_state = 101, .external_lex_state = 12},
  [3350] = {.lex_state = 91},
  [3351] = {.lex_state = 101, .external_lex_state = 12},
  [3352] = {.lex_state = 91},
  [3353] = {.lex_state = 199},
  [3354] = {.lex_state = 91},
  [3355] = {.lex_state = 91},
  [3356] = {.lex_state = 199},
  [3357] = {.lex_state = 91},
  [3358] = {.lex_state = 199},
  [3359] = {.lex_state = 91},
  [3360] = {.lex_state = 91},
  [3361] = {.lex_state = 199},
  [3362] = {.lex_state = 101, .external_lex_state = 12},
  [3363] = {.lex_state = 91},
  [3364] = {.lex_state = 91},
  [3365] = {.lex_state = 101, .external_lex_state = 12},
  [3366] = {.lex_state = 95},
  [3367] = {.lex_state = 199},
  [3368] = {.lex_state = 91},
  [3369] = {.lex_state = 101, .external_lex_state = 12},
  [3370] = {.lex_state = 199},
  [3371] = {.lex_state = 101, .external_lex_state = 12},
  [3372] = {.lex_state = 101, .external_lex_state = 12},
  [3373] = {.lex_state = 199, .external_lex_state = 23},
  [3374] = {.lex_state = 101, .external_lex_state = 12},
  [3375] = {.lex_state = 199},
  [3376] = {.lex_state = 101, .external_lex_state = 12},
  [3377] = {.lex_state = 101, .external_lex_state = 12},
  [3378] = {.lex_state = 101, .external_lex_state = 12},
  [3379] = {.lex_state = 199},
  [3380] = {.lex_state = 91},
  [3381] = {.lex_state = 101, .external_lex_state = 12},
  [3382] = {.lex_state = 101, .external_lex_state = 12},
  [3383] = {.lex_state = 101, .external_lex_state = 12},
  [3384] = {.lex_state = 101, .external_lex_state = 12},
  [3385] = {.lex_state = 199},
  [3386] = {.lex_state = 91},
  [3387] = {.lex_state = 199},
  [3388] = {.lex_state = 199},
  [3389] = {.lex_state = 199},
  [3390] = {.lex_state = 91},
  [3391] = {.lex_state = 91},
  [3392] = {.lex_state = 91},
  [3393] = {.lex_state = 199},
  [3394] = {.lex_state = 199},
  [3395] = {.lex_state = 91},
  [3396] = {.lex_state = 91},
  [3397] = {.lex_state = 91},
  [3398] = {.lex_state = 101, .external_lex_state = 12},
  [3399] = {.lex_state = 199},
  [3400] = {.lex_state = 91},
  [3401] = {.lex_state = 101, .external_lex_state = 12},
  [3402] = {.lex_state = 101, .external_lex_state = 12},
  [3403] = {.lex_state = 199},
  [3404] = {.lex_state = 91},
  [3405] = {.lex_state = 101, .external_lex_state = 12},
  [3406] = {.lex_state = 199},
  [3407] = {.lex_state = 91},
  [3408] = {.lex_state = 199},
  [3409] = {.lex_state = 91},
  [3410] = {.lex_state = 91},
  [3411] = {.lex_state = 101, .external_lex_state = 12},
  [3412] = {.lex_state = 199},
  [3413] = {.lex_state = 91},
  [3414] = {.lex_state = 101, .external_lex_state = 12},
  [3415] = {.lex_state = 91},
  [3416] = {.lex_state = 199},
  [3417] = {.lex_state = 199},
  [3418] = {.lex_state = 199},
  [3419] = {.lex_state = 101, .external_lex_state = 12},
  [3420] = {.lex_state = 199},
  [3421] = {.lex_state = 199},
  [3422] = {.lex_state = 91},
  [3423] = {.lex_state = 101, .external_lex_state = 12},
  [3424] = {.lex_state = 101, .external_lex_state = 12},
  [3425] = {.lex_state = 101, .external_lex_state = 12},
  [3426] = {.lex_state = 91},
  [3427] = {.lex_state = 92, .external_lex_state = 11},
  [3428] = {.lex_state = 92, .external_lex_state = 11},
  [3429] = {.lex_state = 199},
  [3430] = {.lex_state = 91},
  [3431] = {.lex_state = 199},
  [3432] = {.lex_state = 101, .external_lex_state = 12},
  [3433] = {.lex_state = 101, .external_lex_state = 12},
  [3434] = {.lex_state = 95},
  [3435] = {.lex_state = 91},
  [3436] = {.lex_state = 101, .external_lex_state = 12},
  [3437] = {.lex_state = 101, .external_lex_state = 12},
  [3438] = {.lex_state = 91},
  [3439] = {.lex_state = 90},
  [3440] = {.lex_state = 101, .external_lex_state = 12},
  [3441] = {.lex_state = 101, .external_lex_state = 12},
  [3442] = {.lex_state = 101, .external_lex_state = 12},
  [3443] = {.lex_state = 90},
  [3444] = {.lex_state = 199},
  [3445] = {.lex_state = 199},
  [3446] = {.lex_state = 101, .external_lex_state = 12},
  [3447] = {.lex_state = 91},
  [3448] = {.lex_state = 91},
  [3449] = {.lex_state = 101, .external_lex_state = 12},
  [3450] = {.lex_state = 199},
  [3451] = {.lex_state = 199},
  [3452] = {.lex_state = 199},
  [3453] = {.lex_state = 199},
  [3454] = {.lex_state = 101, .external_lex_state = 12},
  [3455] = {.lex_state = 101, .external_lex_state = 12},
  [3456] = {.lex_state = 101, .external_lex_state = 12},
  [3457] = {.lex_state = 91},
  [3458] = {.lex_state = 199},
  [3459] = {.lex_state = 199},
  [3460] = {.lex_state = 199},
  [3461] = {.lex_state = 101, .external_lex_state = 12},
  [3462] = {.lex_state = 91},
  [3463] = {.lex_state = 90},
  [3464] = {.lex_state = 91},
  [3465] = {.lex_state = 101, .external_lex_state = 12},
  [3466] = {.lex_state = 199},
  [3467] = {.lex_state = 91},
  [3468] = {.lex_state = 199},
  [3469] = {.lex_state = 91},
  [3470] = {.lex_state = 199},
  [3471] = {.lex_state = 199},
  [3472] = {.lex_state = 199},
  [3473] = {.lex_state = 101, .external_lex_state = 12},
  [3474] = {.lex_state = 91},
  [3475] = {.lex_state = 199},
  [3476] = {.lex_state = 91},
  [3477] = {.lex_state = 91},
  [3478] = {.lex_state = 101, .external_lex_state = 12},
  [3479] = {.lex_state = 101, .external_lex_state = 12},
  [3480] = {.lex_state = 199},
};

enum {
  ts_external_token_heredoc_start = 0,
  ts_external_token__simple_heredoc_body = 1,
  ts_external_token__heredoc_body_beginning = 2,
  ts_external_token__heredoc_body_middle = 3,
  ts_external_token__heredoc_body_end = 4,
  ts_external_token_file_descriptor = 5,
  ts_external_token__empty_value = 6,
  ts_external_token__concat = 7,
  ts_external_token_variable_name = 8,
  ts_external_token_regex = 9,
  ts_external_token_RBRACE = 10,
  ts_external_token_RBRACK = 11,
  ts_external_token_LT_LT = 12,
  ts_external_token_LT_LT_DASH = 13,
  ts_external_token_LF = 14,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_heredoc_start] = sym_heredoc_start,
  [ts_external_token__simple_heredoc_body] = sym__simple_heredoc_body,
  [ts_external_token__heredoc_body_beginning] = sym__heredoc_body_beginning,
  [ts_external_token__heredoc_body_middle] = sym__heredoc_body_middle,
  [ts_external_token__heredoc_body_end] = sym__heredoc_body_end,
  [ts_external_token_file_descriptor] = sym_file_descriptor,
  [ts_external_token__empty_value] = sym__empty_value,
  [ts_external_token__concat] = sym__concat,
  [ts_external_token_variable_name] = sym_variable_name,
  [ts_external_token_regex] = sym_regex,
  [ts_external_token_RBRACE] = anon_sym_RBRACE,
  [ts_external_token_RBRACK] = anon_sym_RBRACK,
  [ts_external_token_LT_LT] = anon_sym_LT_LT,
  [ts_external_token_LT_LT_DASH] = anon_sym_LT_LT_DASH,
  [ts_external_token_LF] = anon_sym_LF,
};

static const bool ts_external_scanner_states[24][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_heredoc_start] = true,
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token__heredoc_body_middle] = true,
    [ts_external_token__heredoc_body_end] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__empty_value] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_regex] = true,
    [ts_external_token_RBRACE] = true,
    [ts_external_token_RBRACK] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
  },
  [2] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
  },
  [3] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_RBRACE] = true,
  },
  [4] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
  },
  [5] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [6] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [7] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_RBRACE] = true,
  },
  [8] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [9] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [10] = {
    [ts_external_token_LF] = true,
  },
  [11] = {
    [ts_external_token_RBRACK] = true,
  },
  [12] = {
    [ts_external_token_RBRACE] = true,
  },
  [13] = {
    [ts_external_token_regex] = true,
    [ts_external_token_RBRACE] = true,
  },
  [14] = {
    [ts_external_token_regex] = true,
  },
  [15] = {
    [ts_external_token__concat] = true,
    [ts_external_token_LF] = true,
  },
  [16] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
  },
  [17] = {
    [ts_external_token__concat] = true,
  },
  [18] = {
    [ts_external_token__empty_value] = true,
  },
  [19] = {
    [ts_external_token__concat] = true,
    [ts_external_token_RBRACK] = true,
  },
  [20] = {
    [ts_external_token__concat] = true,
    [ts_external_token_RBRACE] = true,
  },
  [21] = {
    [ts_external_token_variable_name] = true,
    [ts_external_token_RBRACE] = true,
  },
  [22] = {
    [ts_external_token__heredoc_body_middle] = true,
    [ts_external_token__heredoc_body_end] = true,
  },
  [23] = {
    [ts_external_token_heredoc_start] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_word] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_select] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_until] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_done] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_fi] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_esac] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_SEMI_SEMI] = ACTIONS(1),
    [anon_sym_SEMI_AMP] = ACTIONS(1),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_PIPE_AMP] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_typeset] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_unset] = ACTIONS(1),
    [anon_sym_unsetenv] = ACTIONS(1),
    [anon_sym_EQ_TILDE] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_AMP_GT] = ACTIONS(1),
    [anon_sym_AMP_GT_GT] = ACTIONS(1),
    [anon_sym_LT_AMP] = ACTIONS(1),
    [anon_sym_GT_AMP] = ACTIONS(1),
    [anon_sym_GT_PIPE] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_LT_LT_DASH] = ACTIONS(1),
    [anon_sym_LT_LT_LT] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [sym__special_character] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_raw_string] = ACTIONS(1),
    [sym_ansii_c_string] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_COLON_QMARK] = ACTIONS(1),
    [anon_sym_COLON_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_LT_LPAREN] = ACTIONS(1),
    [anon_sym_GT_LPAREN] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [sym_test_operator] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [sym_heredoc_start] = ACTIONS(1),
    [sym__simple_heredoc_body] = ACTIONS(1),
    [sym__heredoc_body_beginning] = ACTIONS(1),
    [sym__heredoc_body_middle] = ACTIONS(1),
    [sym__heredoc_body_end] = ACTIONS(1),
    [sym_file_descriptor] = ACTIONS(1),
    [sym__empty_value] = ACTIONS(1),
    [sym__concat] = ACTIONS(1),
    [sym_variable_name] = ACTIONS(1),
    [sym_regex] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(3421),
    [sym__statements] = STATE(3420),
    [sym_redirected_statement] = STATE(1680),
    [sym_for_statement] = STATE(1680),
    [sym_c_style_for_statement] = STATE(1680),
    [sym_while_statement] = STATE(1680),
    [sym_if_statement] = STATE(1680),
    [sym_case_statement] = STATE(1680),
    [sym_function_definition] = STATE(1680),
    [sym_compound_statement] = STATE(1680),
    [sym_subshell] = STATE(1680),
    [sym_pipeline] = STATE(1680),
    [sym_list] = STATE(1680),
    [sym_negated_command] = STATE(1680),
    [sym_test_command] = STATE(1680),
    [sym_declaration_command] = STATE(1680),
    [sym_unset_command] = STATE(1680),
    [sym_command] = STATE(1680),
    [sym_command_name] = STATE(227),
    [sym_variable_assignment] = STATE(323),
    [sym_subscript] = STATE(3176),
    [sym_file_redirect] = STATE(763),
    [sym_concatenation] = STATE(757),
    [sym_string] = STATE(526),
    [sym_simple_expansion] = STATE(526),
    [sym_string_expansion] = STATE(526),
    [sym_expansion] = STATE(526),
    [sym_command_substitution] = STATE(526),
    [sym_process_substitution] = STATE(526),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(763),
    [aux_sym__literal_repeat1] = STATE(735),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_word] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(9),
    [anon_sym_select] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_until] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(33),
    [anon_sym_typeset] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(33),
    [anon_sym_readonly] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(33),
    [anon_sym_unset] = ACTIONS(35),
    [anon_sym_unsetenv] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [sym__special_character] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [sym_ansii_c_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(57),
  },
  [2] = {
    [aux_sym__statements2] = STATE(19),
    [sym_redirected_statement] = STATE(1689),
    [sym_for_statement] = STATE(1689),
    [sym_c_style_for_statement] = STATE(1689),
    [sym_while_statement] = STATE(1689),
    [sym_if_statement] = STATE(1689),
    [sym_elif_clause] = STATE(2841),
    [sym_else_clause] = STATE(3379),
    [sym_case_statement] = STATE(1689),
    [sym_function_definition] = STATE(1689),
    [sym_compound_statement] = STATE(1689),
    [sym_subshell] = STATE(1689),
    [sym_pipeline] = STATE(1689),
    [sym_list] = STATE(1689),
    [sym_negated_command] = STATE(1689),
    [sym_test_command] = STATE(1689),
    [sym_declaration_command] = STATE(1689),
    [sym_unset_command] = STATE(1689),
    [sym_command] = STATE(1689),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(471),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_if_statement_repeat1] = STATE(2841),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(71),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [3] = {
    [aux_sym__statements2] = STATE(19),
    [sym_redirected_statement] = STATE(1689),
    [sym_for_statement] = STATE(1689),
    [sym_c_style_for_statement] = STATE(1689),
    [sym_while_statement] = STATE(1689),
    [sym_if_statement] = STATE(1689),
    [sym_elif_clause] = STATE(2880),
    [sym_else_clause] = STATE(3273),
    [sym_case_statement] = STATE(1689),
    [sym_function_definition] = STATE(1689),
    [sym_compound_statement] = STATE(1689),
    [sym_subshell] = STATE(1689),
    [sym_pipeline] = STATE(1689),
    [sym_list] = STATE(1689),
    [sym_negated_command] = STATE(1689),
    [sym_test_command] = STATE(1689),
    [sym_declaration_command] = STATE(1689),
    [sym_unset_command] = STATE(1689),
    [sym_command] = STATE(1689),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(471),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_if_statement_repeat1] = STATE(2880),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(113),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [4] = {
    [aux_sym__statements2] = STATE(3),
    [sym_redirected_statement] = STATE(1689),
    [sym_for_statement] = STATE(1689),
    [sym_c_style_for_statement] = STATE(1689),
    [sym_while_statement] = STATE(1689),
    [sym_if_statement] = STATE(1689),
    [sym_elif_clause] = STATE(2843),
    [sym_else_clause] = STATE(3307),
    [sym_case_statement] = STATE(1689),
    [sym_function_definition] = STATE(1689),
    [sym_compound_statement] = STATE(1689),
    [sym_subshell] = STATE(1689),
    [sym_pipeline] = STATE(1689),
    [sym_list] = STATE(1689),
    [sym_negated_command] = STATE(1689),
    [sym_test_command] = STATE(1689),
    [sym_declaration_command] = STATE(1689),
    [sym_unset_command] = STATE(1689),
    [sym_command] = STATE(1689),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(471),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_if_statement_repeat1] = STATE(2843),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(115),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [5] = {
    [aux_sym__statements2] = STATE(2),
    [sym_redirected_statement] = STATE(1689),
    [sym_for_statement] = STATE(1689),
    [sym_c_style_for_statement] = STATE(1689),
    [sym_while_statement] = STATE(1689),
    [sym_if_statement] = STATE(1689),
    [sym_elif_clause] = STATE(2861),
    [sym_else_clause] = STATE(3300),
    [sym_case_statement] = STATE(1689),
    [sym_function_definition] = STATE(1689),
    [sym_compound_statement] = STATE(1689),
    [sym_subshell] = STATE(1689),
    [sym_pipeline] = STATE(1689),
    [sym_list] = STATE(1689),
    [sym_negated_command] = STATE(1689),
    [sym_test_command] = STATE(1689),
    [sym_declaration_command] = STATE(1689),
    [sym_unset_command] = STATE(1689),
    [sym_command] = STATE(1689),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(471),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_if_statement_repeat1] = STATE(2861),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(117),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [6] = {
    [aux_sym__statements2] = STATE(19),
    [sym_redirected_statement] = STATE(1689),
    [sym_for_statement] = STATE(1689),
    [sym_c_style_for_statement] = STATE(1689),
    [sym_while_statement] = STATE(1689),
    [sym_if_statement] = STATE(1689),
    [sym_elif_clause] = STATE(2888),
    [sym_else_clause] = STATE(3353),
    [sym_case_statement] = STATE(1689),
    [sym_function_definition] = STATE(1689),
    [sym_compound_statement] = STATE(1689),
    [sym_subshell] = STATE(1689),
    [sym_pipeline] = STATE(1689),
    [sym_list] = STATE(1689),
    [sym_negated_command] = STATE(1689),
    [sym_test_command] = STATE(1689),
    [sym_declaration_command] = STATE(1689),
    [sym_unset_command] = STATE(1689),
    [sym_command] = STATE(1689),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(471),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_if_statement_repeat1] = STATE(2888),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(119),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [7] = {
    [aux_sym__statements2] = STATE(6),
    [sym_redirected_statement] = STATE(1689),
    [sym_for_statement] = STATE(1689),
    [sym_c_style_for_statement] = STATE(1689),
    [sym_while_statement] = STATE(1689),
    [sym_if_statement] = STATE(1689),
    [sym_elif_clause] = STATE(2886),
    [sym_else_clause] = STATE(3403),
    [sym_case_statement] = STATE(1689),
    [sym_function_definition] = STATE(1689),
    [sym_compound_statement] = STATE(1689),
    [sym_subshell] = STATE(1689),
    [sym_pipeline] = STATE(1689),
    [sym_list] = STATE(1689),
    [sym_negated_command] = STATE(1689),
    [sym_test_command] = STATE(1689),
    [sym_declaration_command] = STATE(1689),
    [sym_unset_command] = STATE(1689),
    [sym_command] = STATE(1689),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(471),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_if_statement_repeat1] = STATE(2886),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(121),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [8] = {
    [sym__statements] = STATE(2974),
    [sym_redirected_statement] = STATE(1652),
    [sym_for_statement] = STATE(1652),
    [sym_c_style_for_statement] = STATE(1652),
    [sym_while_statement] = STATE(1652),
    [sym_if_statement] = STATE(1652),
    [sym_case_statement] = STATE(1652),
    [sym_function_definition] = STATE(1652),
    [sym_compound_statement] = STATE(1652),
    [sym_subshell] = STATE(1652),
    [sym_pipeline] = STATE(1652),
    [sym_list] = STATE(1652),
    [sym_negated_command] = STATE(1652),
    [sym_test_command] = STATE(1652),
    [sym_declaration_command] = STATE(1652),
    [sym_unset_command] = STATE(1652),
    [sym_command] = STATE(1652),
    [sym_command_name] = STATE(186),
    [sym_variable_assignment] = STATE(274),
    [sym_subscript] = STATE(3249),
    [sym_file_redirect] = STATE(831),
    [sym_concatenation] = STATE(536),
    [sym_string] = STATE(278),
    [sym_simple_expansion] = STATE(278),
    [sym_string_expansion] = STATE(278),
    [sym_expansion] = STATE(278),
    [sym_command_substitution] = STATE(278),
    [sym_process_substitution] = STATE(278),
    [aux_sym__statements_repeat1] = STATE(138),
    [aux_sym_command_repeat1] = STATE(831),
    [aux_sym__literal_repeat1] = STATE(313),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_esac] = ACTIONS(137),
    [anon_sym_SEMI_SEMI] = ACTIONS(139),
    [anon_sym_SEMI_AMP] = ACTIONS(141),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(141),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansii_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [9] = {
    [sym__statements] = STATE(2969),
    [sym_redirected_statement] = STATE(1652),
    [sym_for_statement] = STATE(1652),
    [sym_c_style_for_statement] = STATE(1652),
    [sym_while_statement] = STATE(1652),
    [sym_if_statement] = STATE(1652),
    [sym_case_statement] = STATE(1652),
    [sym_function_definition] = STATE(1652),
    [sym_compound_statement] = STATE(1652),
    [sym_subshell] = STATE(1652),
    [sym_pipeline] = STATE(1652),
    [sym_list] = STATE(1652),
    [sym_negated_command] = STATE(1652),
    [sym_test_command] = STATE(1652),
    [sym_declaration_command] = STATE(1652),
    [sym_unset_command] = STATE(1652),
    [sym_command] = STATE(1652),
    [sym_command_name] = STATE(186),
    [sym_variable_assignment] = STATE(274),
    [sym_subscript] = STATE(3249),
    [sym_file_redirect] = STATE(831),
    [sym_concatenation] = STATE(536),
    [sym_string] = STATE(278),
    [sym_simple_expansion] = STATE(278),
    [sym_string_expansion] = STATE(278),
    [sym_expansion] = STATE(278),
    [sym_command_substitution] = STATE(278),
    [sym_process_substitution] = STATE(278),
    [aux_sym__statements_repeat1] = STATE(138),
    [aux_sym_command_repeat1] = STATE(831),
    [aux_sym__literal_repeat1] = STATE(313),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_esac] = ACTIONS(177),
    [anon_sym_SEMI_SEMI] = ACTIONS(179),
    [anon_sym_SEMI_AMP] = ACTIONS(181),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(181),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansii_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [10] = {
    [sym__statements] = STATE(2965),
    [sym_redirected_statement] = STATE(1652),
    [sym_for_statement] = STATE(1652),
    [sym_c_style_for_statement] = STATE(1652),
    [sym_while_statement] = STATE(1652),
    [sym_if_statement] = STATE(1652),
    [sym_case_statement] = STATE(1652),
    [sym_function_definition] = STATE(1652),
    [sym_compound_statement] = STATE(1652),
    [sym_subshell] = STATE(1652),
    [sym_pipeline] = STATE(1652),
    [sym_list] = STATE(1652),
    [sym_negated_command] = STATE(1652),
    [sym_test_command] = STATE(1652),
    [sym_declaration_command] = STATE(1652),
    [sym_unset_command] = STATE(1652),
    [sym_command] = STATE(1652),
    [sym_command_name] = STATE(186),
    [sym_variable_assignment] = STATE(274),
    [sym_subscript] = STATE(3249),
    [sym_file_redirect] = STATE(831),
    [sym_concatenation] = STATE(536),
    [sym_string] = STATE(278),
    [sym_simple_expansion] = STATE(278),
    [sym_string_expansion] = STATE(278),
    [sym_expansion] = STATE(278),
    [sym_command_substitution] = STATE(278),
    [sym_process_substitution] = STATE(278),
    [aux_sym__statements_repeat1] = STATE(138),
    [aux_sym_command_repeat1] = STATE(831),
    [aux_sym__literal_repeat1] = STATE(313),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_esac] = ACTIONS(183),
    [anon_sym_SEMI_SEMI] = ACTIONS(185),
    [anon_sym_SEMI_AMP] = ACTIONS(187),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(189),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansii_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [11] = {
    [sym__statements] = STATE(2954),
    [sym_redirected_statement] = STATE(1652),
    [sym_for_statement] = STATE(1652),
    [sym_c_style_for_statement] = STATE(1652),
    [sym_while_statement] = STATE(1652),
    [sym_if_statement] = STATE(1652),
    [sym_case_statement] = STATE(1652),
    [sym_function_definition] = STATE(1652),
    [sym_compound_statement] = STATE(1652),
    [sym_subshell] = STATE(1652),
    [sym_pipeline] = STATE(1652),
    [sym_list] = STATE(1652),
    [sym_negated_command] = STATE(1652),
    [sym_test_command] = STATE(1652),
    [sym_declaration_command] = STATE(1652),
    [sym_unset_command] = STATE(1652),
    [sym_command] = STATE(1652),
    [sym_command_name] = STATE(186),
    [sym_variable_assignment] = STATE(274),
    [sym_subscript] = STATE(3249),
    [sym_file_redirect] = STATE(831),
    [sym_concatenation] = STATE(536),
    [sym_string] = STATE(278),
    [sym_simple_expansion] = STATE(278),
    [sym_string_expansion] = STATE(278),
    [sym_expansion] = STATE(278),
    [sym_command_substitution] = STATE(278),
    [sym_process_substitution] = STATE(278),
    [aux_sym__statements_repeat1] = STATE(138),
    [aux_sym_command_repeat1] = STATE(831),
    [aux_sym__literal_repeat1] = STATE(313),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_esac] = ACTIONS(183),
    [anon_sym_SEMI_SEMI] = ACTIONS(191),
    [anon_sym_SEMI_AMP] = ACTIONS(193),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(195),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansii_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [12] = {
    [sym__statements] = STATE(2958),
    [sym_redirected_statement] = STATE(1652),
    [sym_for_statement] = STATE(1652),
    [sym_c_style_for_statement] = STATE(1652),
    [sym_while_statement] = STATE(1652),
    [sym_if_statement] = STATE(1652),
    [sym_case_statement] = STATE(1652),
    [sym_function_definition] = STATE(1652),
    [sym_compound_statement] = STATE(1652),
    [sym_subshell] = STATE(1652),
    [sym_pipeline] = STATE(1652),
    [sym_list] = STATE(1652),
    [sym_negated_command] = STATE(1652),
    [sym_test_command] = STATE(1652),
    [sym_declaration_command] = STATE(1652),
    [sym_unset_command] = STATE(1652),
    [sym_command] = STATE(1652),
    [sym_command_name] = STATE(186),
    [sym_variable_assignment] = STATE(274),
    [sym_subscript] = STATE(3249),
    [sym_file_redirect] = STATE(831),
    [sym_concatenation] = STATE(536),
    [sym_string] = STATE(278),
    [sym_simple_expansion] = STATE(278),
    [sym_string_expansion] = STATE(278),
    [sym_expansion] = STATE(278),
    [sym_command_substitution] = STATE(278),
    [sym_process_substitution] = STATE(278),
    [aux_sym__statements_repeat1] = STATE(138),
    [aux_sym_command_repeat1] = STATE(831),
    [aux_sym__literal_repeat1] = STATE(313),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_esac] = ACTIONS(197),
    [anon_sym_SEMI_SEMI] = ACTIONS(199),
    [anon_sym_SEMI_AMP] = ACTIONS(201),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(203),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansii_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [13] = {
    [sym__statements] = STATE(3084),
    [sym_redirected_statement] = STATE(1655),
    [sym_for_statement] = STATE(1655),
    [sym_c_style_for_statement] = STATE(1655),
    [sym_while_statement] = STATE(1655),
    [sym_if_statement] = STATE(1655),
    [sym_case_statement] = STATE(1655),
    [sym_function_definition] = STATE(1655),
    [sym_compound_statement] = STATE(1655),
    [sym_subshell] = STATE(1655),
    [sym_pipeline] = STATE(1655),
    [sym_list] = STATE(1655),
    [sym_negated_command] = STATE(1655),
    [sym_test_command] = STATE(1655),
    [sym_declaration_command] = STATE(1655),
    [sym_unset_command] = STATE(1655),
    [sym_command] = STATE(1655),
    [sym_command_name] = STATE(200),
    [sym_variable_assignment] = STATE(292),
    [sym_subscript] = STATE(3237),
    [sym_file_redirect] = STATE(771),
    [sym_concatenation] = STATE(736),
    [sym_string] = STATE(349),
    [sym_simple_expansion] = STATE(349),
    [sym_string_expansion] = STATE(349),
    [sym_expansion] = STATE(349),
    [sym_command_substitution] = STATE(349),
    [sym_process_substitution] = STATE(349),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(771),
    [aux_sym__literal_repeat1] = STATE(469),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_SEMI_SEMI] = ACTIONS(207),
    [anon_sym_SEMI_AMP] = ACTIONS(187),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(189),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [14] = {
    [sym__statements] = STATE(3058),
    [sym_redirected_statement] = STATE(1655),
    [sym_for_statement] = STATE(1655),
    [sym_c_style_for_statement] = STATE(1655),
    [sym_while_statement] = STATE(1655),
    [sym_if_statement] = STATE(1655),
    [sym_case_statement] = STATE(1655),
    [sym_function_definition] = STATE(1655),
    [sym_compound_statement] = STATE(1655),
    [sym_subshell] = STATE(1655),
    [sym_pipeline] = STATE(1655),
    [sym_list] = STATE(1655),
    [sym_negated_command] = STATE(1655),
    [sym_test_command] = STATE(1655),
    [sym_declaration_command] = STATE(1655),
    [sym_unset_command] = STATE(1655),
    [sym_command] = STATE(1655),
    [sym_command_name] = STATE(200),
    [sym_variable_assignment] = STATE(292),
    [sym_subscript] = STATE(3237),
    [sym_file_redirect] = STATE(771),
    [sym_concatenation] = STATE(736),
    [sym_string] = STATE(349),
    [sym_simple_expansion] = STATE(349),
    [sym_string_expansion] = STATE(349),
    [sym_expansion] = STATE(349),
    [sym_command_substitution] = STATE(349),
    [sym_process_substitution] = STATE(349),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(771),
    [aux_sym__literal_repeat1] = STATE(469),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_SEMI_SEMI] = ACTIONS(233),
    [anon_sym_SEMI_AMP] = ACTIONS(201),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(203),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [15] = {
    [sym__statements] = STATE(3061),
    [sym_redirected_statement] = STATE(1655),
    [sym_for_statement] = STATE(1655),
    [sym_c_style_for_statement] = STATE(1655),
    [sym_while_statement] = STATE(1655),
    [sym_if_statement] = STATE(1655),
    [sym_case_statement] = STATE(1655),
    [sym_function_definition] = STATE(1655),
    [sym_compound_statement] = STATE(1655),
    [sym_subshell] = STATE(1655),
    [sym_pipeline] = STATE(1655),
    [sym_list] = STATE(1655),
    [sym_negated_command] = STATE(1655),
    [sym_test_command] = STATE(1655),
    [sym_declaration_command] = STATE(1655),
    [sym_unset_command] = STATE(1655),
    [sym_command] = STATE(1655),
    [sym_command_name] = STATE(200),
    [sym_variable_assignment] = STATE(292),
    [sym_subscript] = STATE(3237),
    [sym_file_redirect] = STATE(771),
    [sym_concatenation] = STATE(736),
    [sym_string] = STATE(349),
    [sym_simple_expansion] = STATE(349),
    [sym_string_expansion] = STATE(349),
    [sym_expansion] = STATE(349),
    [sym_command_substitution] = STATE(349),
    [sym_process_substitution] = STATE(349),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(771),
    [aux_sym__literal_repeat1] = STATE(469),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_SEMI_SEMI] = ACTIONS(235),
    [anon_sym_SEMI_AMP] = ACTIONS(193),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(195),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [16] = {
    [sym__statements] = STATE(3097),
    [sym_redirected_statement] = STATE(1655),
    [sym_for_statement] = STATE(1655),
    [sym_c_style_for_statement] = STATE(1655),
    [sym_while_statement] = STATE(1655),
    [sym_if_statement] = STATE(1655),
    [sym_case_statement] = STATE(1655),
    [sym_function_definition] = STATE(1655),
    [sym_compound_statement] = STATE(1655),
    [sym_subshell] = STATE(1655),
    [sym_pipeline] = STATE(1655),
    [sym_list] = STATE(1655),
    [sym_negated_command] = STATE(1655),
    [sym_test_command] = STATE(1655),
    [sym_declaration_command] = STATE(1655),
    [sym_unset_command] = STATE(1655),
    [sym_command] = STATE(1655),
    [sym_command_name] = STATE(200),
    [sym_variable_assignment] = STATE(292),
    [sym_subscript] = STATE(3237),
    [sym_file_redirect] = STATE(771),
    [sym_concatenation] = STATE(736),
    [sym_string] = STATE(349),
    [sym_simple_expansion] = STATE(349),
    [sym_string_expansion] = STATE(349),
    [sym_expansion] = STATE(349),
    [sym_command_substitution] = STATE(349),
    [sym_process_substitution] = STATE(349),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(771),
    [aux_sym__literal_repeat1] = STATE(469),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_SEMI_SEMI] = ACTIONS(237),
    [anon_sym_SEMI_AMP] = ACTIONS(181),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(181),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [17] = {
    [sym__statements] = STATE(3105),
    [sym_redirected_statement] = STATE(1655),
    [sym_for_statement] = STATE(1655),
    [sym_c_style_for_statement] = STATE(1655),
    [sym_while_statement] = STATE(1655),
    [sym_if_statement] = STATE(1655),
    [sym_case_statement] = STATE(1655),
    [sym_function_definition] = STATE(1655),
    [sym_compound_statement] = STATE(1655),
    [sym_subshell] = STATE(1655),
    [sym_pipeline] = STATE(1655),
    [sym_list] = STATE(1655),
    [sym_negated_command] = STATE(1655),
    [sym_test_command] = STATE(1655),
    [sym_declaration_command] = STATE(1655),
    [sym_unset_command] = STATE(1655),
    [sym_command] = STATE(1655),
    [sym_command_name] = STATE(200),
    [sym_variable_assignment] = STATE(292),
    [sym_subscript] = STATE(3237),
    [sym_file_redirect] = STATE(771),
    [sym_concatenation] = STATE(736),
    [sym_string] = STATE(349),
    [sym_simple_expansion] = STATE(349),
    [sym_string_expansion] = STATE(349),
    [sym_expansion] = STATE(349),
    [sym_command_substitution] = STATE(349),
    [sym_process_substitution] = STATE(349),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(771),
    [aux_sym__literal_repeat1] = STATE(469),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_SEMI_SEMI] = ACTIONS(239),
    [anon_sym_SEMI_AMP] = ACTIONS(141),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(141),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [18] = {
    [aux_sym__statements2] = STATE(20),
    [sym_redirected_statement] = STATE(1689),
    [sym_for_statement] = STATE(1689),
    [sym_c_style_for_statement] = STATE(1689),
    [sym_while_statement] = STATE(1689),
    [sym_if_statement] = STATE(1689),
    [sym_case_statement] = STATE(1689),
    [sym_function_definition] = STATE(1689),
    [sym_compound_statement] = STATE(1689),
    [sym_subshell] = STATE(1689),
    [sym_pipeline] = STATE(1689),
    [sym_list] = STATE(1689),
    [sym_negated_command] = STATE(1689),
    [sym_test_command] = STATE(1689),
    [sym_declaration_command] = STATE(1689),
    [sym_unset_command] = STATE(1689),
    [sym_command] = STATE(1689),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(471),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(241),
    [anon_sym_elif] = ACTIONS(241),
    [anon_sym_else] = ACTIONS(241),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [19] = {
    [aux_sym__statements2] = STATE(19),
    [sym_redirected_statement] = STATE(1689),
    [sym_for_statement] = STATE(1689),
    [sym_c_style_for_statement] = STATE(1689),
    [sym_while_statement] = STATE(1689),
    [sym_if_statement] = STATE(1689),
    [sym_case_statement] = STATE(1689),
    [sym_function_definition] = STATE(1689),
    [sym_compound_statement] = STATE(1689),
    [sym_subshell] = STATE(1689),
    [sym_pipeline] = STATE(1689),
    [sym_list] = STATE(1689),
    [sym_negated_command] = STATE(1689),
    [sym_test_command] = STATE(1689),
    [sym_declaration_command] = STATE(1689),
    [sym_unset_command] = STATE(1689),
    [sym_command] = STATE(1689),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(471),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(243),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_select] = ACTIONS(249),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_until] = ACTIONS(255),
    [anon_sym_if] = ACTIONS(258),
    [anon_sym_fi] = ACTIONS(261),
    [anon_sym_elif] = ACTIONS(261),
    [anon_sym_else] = ACTIONS(261),
    [anon_sym_case] = ACTIONS(263),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(269),
    [anon_sym_LBRACE] = ACTIONS(272),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(278),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(281),
    [anon_sym_declare] = ACTIONS(284),
    [anon_sym_typeset] = ACTIONS(284),
    [anon_sym_export] = ACTIONS(284),
    [anon_sym_readonly] = ACTIONS(284),
    [anon_sym_local] = ACTIONS(284),
    [anon_sym_unset] = ACTIONS(287),
    [anon_sym_unsetenv] = ACTIONS(287),
    [anon_sym_LT] = ACTIONS(290),
    [anon_sym_GT] = ACTIONS(290),
    [anon_sym_GT_GT] = ACTIONS(290),
    [anon_sym_AMP_GT] = ACTIONS(290),
    [anon_sym_AMP_GT_GT] = ACTIONS(290),
    [anon_sym_LT_AMP] = ACTIONS(290),
    [anon_sym_GT_AMP] = ACTIONS(290),
    [anon_sym_GT_PIPE] = ACTIONS(290),
    [anon_sym_DOLLAR] = ACTIONS(293),
    [sym__special_character] = ACTIONS(296),
    [anon_sym_DQUOTE] = ACTIONS(299),
    [sym_raw_string] = ACTIONS(302),
    [sym_ansii_c_string] = ACTIONS(302),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(305),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(308),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [anon_sym_LT_LPAREN] = ACTIONS(314),
    [anon_sym_GT_LPAREN] = ACTIONS(314),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(317),
    [sym_variable_name] = ACTIONS(320),
  },
  [20] = {
    [aux_sym__statements2] = STATE(19),
    [sym_redirected_statement] = STATE(1689),
    [sym_for_statement] = STATE(1689),
    [sym_c_style_for_statement] = STATE(1689),
    [sym_while_statement] = STATE(1689),
    [sym_if_statement] = STATE(1689),
    [sym_case_statement] = STATE(1689),
    [sym_function_definition] = STATE(1689),
    [sym_compound_statement] = STATE(1689),
    [sym_subshell] = STATE(1689),
    [sym_pipeline] = STATE(1689),
    [sym_list] = STATE(1689),
    [sym_negated_command] = STATE(1689),
    [sym_test_command] = STATE(1689),
    [sym_declaration_command] = STATE(1689),
    [sym_unset_command] = STATE(1689),
    [sym_command] = STATE(1689),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(471),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(323),
    [anon_sym_elif] = ACTIONS(323),
    [anon_sym_else] = ACTIONS(323),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [21] = {
    [sym__statements] = STATE(3303),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_RPAREN] = ACTIONS(325),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [22] = {
    [sym__statements] = STATE(3380),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_RPAREN] = ACTIONS(327),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [23] = {
    [sym__statements] = STATE(3368),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_RPAREN] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [24] = {
    [sym__statements] = STATE(3474),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [25] = {
    [sym__statements] = STATE(3435),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(1971),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [26] = {
    [sym__statements] = STATE(3335),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [27] = {
    [sym__statements] = STATE(3334),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [28] = {
    [aux_sym__statements2] = STATE(78),
    [sym_redirected_statement] = STATE(1747),
    [sym_for_statement] = STATE(1747),
    [sym_c_style_for_statement] = STATE(1747),
    [sym_while_statement] = STATE(1747),
    [sym_if_statement] = STATE(1747),
    [sym_case_statement] = STATE(1747),
    [sym_function_definition] = STATE(1747),
    [sym_compound_statement] = STATE(1747),
    [sym_subshell] = STATE(1747),
    [sym_pipeline] = STATE(1747),
    [sym_list] = STATE(1747),
    [sym_negated_command] = STATE(1747),
    [sym_test_command] = STATE(1747),
    [sym_declaration_command] = STATE(1747),
    [sym_unset_command] = STATE(1747),
    [sym_command] = STATE(1747),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(461),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [29] = {
    [sym__statements] = STATE(3429),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [30] = {
    [sym__statements] = STATE(3448),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(2038),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [31] = {
    [sym__statements] = STATE(3364),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [32] = {
    [aux_sym__statements2] = STATE(33),
    [sym_redirected_statement] = STATE(1730),
    [sym_for_statement] = STATE(1730),
    [sym_c_style_for_statement] = STATE(1730),
    [sym_while_statement] = STATE(1730),
    [sym_if_statement] = STATE(1730),
    [sym_case_statement] = STATE(1730),
    [sym_function_definition] = STATE(1730),
    [sym_compound_statement] = STATE(1730),
    [sym_subshell] = STATE(1730),
    [sym_pipeline] = STATE(1730),
    [sym_list] = STATE(1730),
    [sym_negated_command] = STATE(1730),
    [sym_test_command] = STATE(1730),
    [sym_declaration_command] = STATE(1730),
    [sym_unset_command] = STATE(1730),
    [sym_command] = STATE(1730),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(473),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(339),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [33] = {
    [aux_sym__statements2] = STATE(98),
    [sym_redirected_statement] = STATE(1730),
    [sym_for_statement] = STATE(1730),
    [sym_c_style_for_statement] = STATE(1730),
    [sym_while_statement] = STATE(1730),
    [sym_if_statement] = STATE(1730),
    [sym_case_statement] = STATE(1730),
    [sym_function_definition] = STATE(1730),
    [sym_compound_statement] = STATE(1730),
    [sym_subshell] = STATE(1730),
    [sym_pipeline] = STATE(1730),
    [sym_list] = STATE(1730),
    [sym_negated_command] = STATE(1730),
    [sym_test_command] = STATE(1730),
    [sym_declaration_command] = STATE(1730),
    [sym_unset_command] = STATE(1730),
    [sym_command] = STATE(1730),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(473),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(341),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [34] = {
    [sym__statements] = STATE(3344),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [35] = {
    [sym__statements] = STATE(3308),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(2033),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [36] = {
    [sym__statements] = STATE(3417),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [37] = {
    [sym__statements] = STATE(3343),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [38] = {
    [sym__statements] = STATE(3342),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [39] = {
    [sym__statements] = STATE(3305),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(2022),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [40] = {
    [sym__statements] = STATE(3397),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [41] = {
    [sym__statements] = STATE(3393),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [42] = {
    [sym__statements] = STATE(3391),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(1952),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [43] = {
    [sym__statements] = STATE(3350),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [44] = {
    [sym__statements] = STATE(3348),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [45] = {
    [sym__statements] = STATE(3317),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(1934),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [46] = {
    [sym__statements] = STATE(3415),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [47] = {
    [sym__statements] = STATE(3274),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [48] = {
    [sym__statements] = STATE(3404),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(1924),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [49] = {
    [sym__statements] = STATE(3476),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [50] = {
    [sym__statements] = STATE(3472),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [51] = {
    [sym__statements] = STATE(3464),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(1919),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [52] = {
    [sym__statements] = STATE(3410),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [53] = {
    [sym__statements] = STATE(3406),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [54] = {
    [sym__statements] = STATE(3386),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(1974),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [55] = {
    [sym__statements] = STATE(3336),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [56] = {
    [sym__statements] = STATE(3320),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [57] = {
    [sym__statements] = STATE(3313),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(2001),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [58] = {
    [sym__statements] = STATE(3280),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [59] = {
    [aux_sym__statements2] = STATE(122),
    [sym_redirected_statement] = STATE(1698),
    [sym_for_statement] = STATE(1698),
    [sym_c_style_for_statement] = STATE(1698),
    [sym_while_statement] = STATE(1698),
    [sym_if_statement] = STATE(1698),
    [sym_case_statement] = STATE(1698),
    [sym_function_definition] = STATE(1698),
    [sym_compound_statement] = STATE(1698),
    [sym_subshell] = STATE(1698),
    [sym_pipeline] = STATE(1698),
    [sym_list] = STATE(1698),
    [sym_negated_command] = STATE(1698),
    [sym_test_command] = STATE(1698),
    [sym_declaration_command] = STATE(1698),
    [sym_unset_command] = STATE(1698),
    [sym_command] = STATE(1698),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(508),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(343),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [60] = {
    [sym__statements] = STATE(3277),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [61] = {
    [sym__statements] = STATE(3422),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(1930),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [62] = {
    [sym__statements] = STATE(3275),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(2073),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [63] = {
    [sym__statements] = STATE(3325),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [64] = {
    [sym__statements] = STATE(3333),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [65] = {
    [sym__statements] = STATE(3450),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [66] = {
    [sym__statements] = STATE(3462),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(2032),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [67] = {
    [sym__statements] = STATE(3392),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(2013),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [68] = {
    [sym__statements] = STATE(3331),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [69] = {
    [sym__statements] = STATE(3324),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [70] = {
    [sym__statements] = STATE(3466),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [71] = {
    [sym__statements] = STATE(3457),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(2009),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [72] = {
    [sym__statements] = STATE(3413),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [73] = {
    [sym__statements] = STATE(3412),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [74] = {
    [sym__statements] = STATE(3407),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(1946),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [75] = {
    [sym__statements] = STATE(3357),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [76] = {
    [sym__statements] = STATE(3285),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [77] = {
    [sym__statements] = STATE(3352),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(1912),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [78] = {
    [aux_sym__statements2] = STATE(78),
    [sym_redirected_statement] = STATE(1747),
    [sym_for_statement] = STATE(1747),
    [sym_c_style_for_statement] = STATE(1747),
    [sym_while_statement] = STATE(1747),
    [sym_if_statement] = STATE(1747),
    [sym_case_statement] = STATE(1747),
    [sym_function_definition] = STATE(1747),
    [sym_compound_statement] = STATE(1747),
    [sym_subshell] = STATE(1747),
    [sym_pipeline] = STATE(1747),
    [sym_list] = STATE(1747),
    [sym_negated_command] = STATE(1747),
    [sym_test_command] = STATE(1747),
    [sym_declaration_command] = STATE(1747),
    [sym_unset_command] = STATE(1747),
    [sym_command] = STATE(1747),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(461),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(243),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_select] = ACTIONS(249),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_until] = ACTIONS(255),
    [anon_sym_done] = ACTIONS(261),
    [anon_sym_if] = ACTIONS(258),
    [anon_sym_case] = ACTIONS(263),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(269),
    [anon_sym_LBRACE] = ACTIONS(272),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(278),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(281),
    [anon_sym_declare] = ACTIONS(284),
    [anon_sym_typeset] = ACTIONS(284),
    [anon_sym_export] = ACTIONS(284),
    [anon_sym_readonly] = ACTIONS(284),
    [anon_sym_local] = ACTIONS(284),
    [anon_sym_unset] = ACTIONS(287),
    [anon_sym_unsetenv] = ACTIONS(287),
    [anon_sym_LT] = ACTIONS(290),
    [anon_sym_GT] = ACTIONS(290),
    [anon_sym_GT_GT] = ACTIONS(290),
    [anon_sym_AMP_GT] = ACTIONS(290),
    [anon_sym_AMP_GT_GT] = ACTIONS(290),
    [anon_sym_LT_AMP] = ACTIONS(290),
    [anon_sym_GT_AMP] = ACTIONS(290),
    [anon_sym_GT_PIPE] = ACTIONS(290),
    [anon_sym_DOLLAR] = ACTIONS(293),
    [sym__special_character] = ACTIONS(296),
    [anon_sym_DQUOTE] = ACTIONS(299),
    [sym_raw_string] = ACTIONS(302),
    [sym_ansii_c_string] = ACTIONS(302),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(305),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(308),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [anon_sym_LT_LPAREN] = ACTIONS(314),
    [anon_sym_GT_LPAREN] = ACTIONS(314),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(317),
    [sym_variable_name] = ACTIONS(320),
  },
  [79] = {
    [sym__statements] = STATE(3312),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [80] = {
    [sym__statements] = STATE(3311),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [81] = {
    [sym__statements] = STATE(3310),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(1942),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [82] = {
    [sym__statements] = STATE(3283),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [83] = {
    [sym__statements] = STATE(3284),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [84] = {
    [sym__statements] = STATE(3287),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(1985),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [85] = {
    [sym__statements] = STATE(3355),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [86] = {
    [sym__statements] = STATE(3356),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [87] = {
    [sym__statements] = STATE(3359),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(2016),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [88] = {
    [sym__statements] = STATE(3390),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [89] = {
    [sym__statements] = STATE(3394),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [90] = {
    [sym__statements] = STATE(3395),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(2069),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [91] = {
    [sym__statements] = STATE(3430),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [92] = {
    [sym__statements] = STATE(3431),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [93] = {
    [sym__statements] = STATE(3380),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [94] = {
    [aux_sym__statements2] = STATE(59),
    [sym_redirected_statement] = STATE(1698),
    [sym_for_statement] = STATE(1698),
    [sym_c_style_for_statement] = STATE(1698),
    [sym_while_statement] = STATE(1698),
    [sym_if_statement] = STATE(1698),
    [sym_case_statement] = STATE(1698),
    [sym_function_definition] = STATE(1698),
    [sym_compound_statement] = STATE(1698),
    [sym_subshell] = STATE(1698),
    [sym_pipeline] = STATE(1698),
    [sym_list] = STATE(1698),
    [sym_negated_command] = STATE(1698),
    [sym_test_command] = STATE(1698),
    [sym_declaration_command] = STATE(1698),
    [sym_unset_command] = STATE(1698),
    [sym_command] = STATE(1698),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(508),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [95] = {
    [sym__statements] = STATE(3322),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [96] = {
    [sym__statements] = STATE(3318),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(1943),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [97] = {
    [sym__statements] = STATE(3438),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(1986),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [98] = {
    [aux_sym__statements2] = STATE(98),
    [sym_redirected_statement] = STATE(1730),
    [sym_for_statement] = STATE(1730),
    [sym_c_style_for_statement] = STATE(1730),
    [sym_while_statement] = STATE(1730),
    [sym_if_statement] = STATE(1730),
    [sym_case_statement] = STATE(1730),
    [sym_function_definition] = STATE(1730),
    [sym_compound_statement] = STATE(1730),
    [sym_subshell] = STATE(1730),
    [sym_pipeline] = STATE(1730),
    [sym_list] = STATE(1730),
    [sym_negated_command] = STATE(1730),
    [sym_test_command] = STATE(1730),
    [sym_declaration_command] = STATE(1730),
    [sym_unset_command] = STATE(1730),
    [sym_command] = STATE(1730),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(473),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(243),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_select] = ACTIONS(249),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_until] = ACTIONS(255),
    [anon_sym_if] = ACTIONS(258),
    [anon_sym_fi] = ACTIONS(261),
    [anon_sym_case] = ACTIONS(263),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(269),
    [anon_sym_LBRACE] = ACTIONS(272),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(278),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(281),
    [anon_sym_declare] = ACTIONS(284),
    [anon_sym_typeset] = ACTIONS(284),
    [anon_sym_export] = ACTIONS(284),
    [anon_sym_readonly] = ACTIONS(284),
    [anon_sym_local] = ACTIONS(284),
    [anon_sym_unset] = ACTIONS(287),
    [anon_sym_unsetenv] = ACTIONS(287),
    [anon_sym_LT] = ACTIONS(290),
    [anon_sym_GT] = ACTIONS(290),
    [anon_sym_GT_GT] = ACTIONS(290),
    [anon_sym_AMP_GT] = ACTIONS(290),
    [anon_sym_AMP_GT_GT] = ACTIONS(290),
    [anon_sym_LT_AMP] = ACTIONS(290),
    [anon_sym_GT_AMP] = ACTIONS(290),
    [anon_sym_GT_PIPE] = ACTIONS(290),
    [anon_sym_DOLLAR] = ACTIONS(293),
    [sym__special_character] = ACTIONS(296),
    [anon_sym_DQUOTE] = ACTIONS(299),
    [sym_raw_string] = ACTIONS(302),
    [sym_ansii_c_string] = ACTIONS(302),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(305),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(308),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [anon_sym_LT_LPAREN] = ACTIONS(314),
    [anon_sym_GT_LPAREN] = ACTIONS(314),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(317),
    [sym_variable_name] = ACTIONS(320),
  },
  [99] = {
    [sym__statements] = STATE(3475),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [100] = {
    [sym__statements] = STATE(3477),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(1917),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [101] = {
    [aux_sym__statements2] = STATE(103),
    [sym_redirected_statement] = STATE(1698),
    [sym_for_statement] = STATE(1698),
    [sym_c_style_for_statement] = STATE(1698),
    [sym_while_statement] = STATE(1698),
    [sym_if_statement] = STATE(1698),
    [sym_case_statement] = STATE(1698),
    [sym_function_definition] = STATE(1698),
    [sym_compound_statement] = STATE(1698),
    [sym_subshell] = STATE(1698),
    [sym_pipeline] = STATE(1698),
    [sym_list] = STATE(1698),
    [sym_negated_command] = STATE(1698),
    [sym_test_command] = STATE(1698),
    [sym_declaration_command] = STATE(1698),
    [sym_unset_command] = STATE(1698),
    [sym_command] = STATE(1698),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(508),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(347),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [102] = {
    [sym__statements] = STATE(3469),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [103] = {
    [aux_sym__statements2] = STATE(122),
    [sym_redirected_statement] = STATE(1698),
    [sym_for_statement] = STATE(1698),
    [sym_c_style_for_statement] = STATE(1698),
    [sym_while_statement] = STATE(1698),
    [sym_if_statement] = STATE(1698),
    [sym_case_statement] = STATE(1698),
    [sym_function_definition] = STATE(1698),
    [sym_compound_statement] = STATE(1698),
    [sym_subshell] = STATE(1698),
    [sym_pipeline] = STATE(1698),
    [sym_list] = STATE(1698),
    [sym_negated_command] = STATE(1698),
    [sym_test_command] = STATE(1698),
    [sym_declaration_command] = STATE(1698),
    [sym_unset_command] = STATE(1698),
    [sym_command] = STATE(1698),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(508),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(349),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [104] = {
    [sym__statements] = STATE(3468),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [105] = {
    [sym__statements] = STATE(3467),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(1923),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [106] = {
    [aux_sym__statements2] = STATE(108),
    [sym_redirected_statement] = STATE(1747),
    [sym_for_statement] = STATE(1747),
    [sym_c_style_for_statement] = STATE(1747),
    [sym_while_statement] = STATE(1747),
    [sym_if_statement] = STATE(1747),
    [sym_case_statement] = STATE(1747),
    [sym_function_definition] = STATE(1747),
    [sym_compound_statement] = STATE(1747),
    [sym_subshell] = STATE(1747),
    [sym_pipeline] = STATE(1747),
    [sym_list] = STATE(1747),
    [sym_negated_command] = STATE(1747),
    [sym_test_command] = STATE(1747),
    [sym_declaration_command] = STATE(1747),
    [sym_unset_command] = STATE(1747),
    [sym_command] = STATE(1747),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(461),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [107] = {
    [sym__statements] = STATE(3315),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [108] = {
    [aux_sym__statements2] = STATE(78),
    [sym_redirected_statement] = STATE(1747),
    [sym_for_statement] = STATE(1747),
    [sym_c_style_for_statement] = STATE(1747),
    [sym_while_statement] = STATE(1747),
    [sym_if_statement] = STATE(1747),
    [sym_case_statement] = STATE(1747),
    [sym_function_definition] = STATE(1747),
    [sym_compound_statement] = STATE(1747),
    [sym_subshell] = STATE(1747),
    [sym_pipeline] = STATE(1747),
    [sym_list] = STATE(1747),
    [sym_negated_command] = STATE(1747),
    [sym_test_command] = STATE(1747),
    [sym_declaration_command] = STATE(1747),
    [sym_unset_command] = STATE(1747),
    [sym_command] = STATE(1747),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(461),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(353),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [109] = {
    [sym__statements] = STATE(3447),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [110] = {
    [sym__statements] = STATE(3445),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [111] = {
    [sym__statements] = STATE(3363),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(2003),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [112] = {
    [sym__statements] = STATE(3400),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [113] = {
    [sym__statements] = STATE(3399),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [114] = {
    [sym__statements] = STATE(3396),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(2081),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [115] = {
    [sym__statements] = STATE(3409),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [116] = {
    [sym__statements] = STATE(3361),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [117] = {
    [sym__statements] = STATE(3354),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(2031),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [118] = {
    [sym__statements] = STATE(3326),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [119] = {
    [sym__statements] = STATE(3270),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [120] = {
    [sym__statements] = STATE(3332),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(1932),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [121] = {
    [sym__statements] = STATE(3368),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [122] = {
    [aux_sym__statements2] = STATE(122),
    [sym_redirected_statement] = STATE(1698),
    [sym_for_statement] = STATE(1698),
    [sym_c_style_for_statement] = STATE(1698),
    [sym_while_statement] = STATE(1698),
    [sym_if_statement] = STATE(1698),
    [sym_case_statement] = STATE(1698),
    [sym_function_definition] = STATE(1698),
    [sym_compound_statement] = STATE(1698),
    [sym_subshell] = STATE(1698),
    [sym_pipeline] = STATE(1698),
    [sym_list] = STATE(1698),
    [sym_negated_command] = STATE(1698),
    [sym_test_command] = STATE(1698),
    [sym_declaration_command] = STATE(1698),
    [sym_unset_command] = STATE(1698),
    [sym_command] = STATE(1698),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(508),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(243),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_select] = ACTIONS(249),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_until] = ACTIONS(255),
    [anon_sym_if] = ACTIONS(258),
    [anon_sym_case] = ACTIONS(263),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(269),
    [anon_sym_LBRACE] = ACTIONS(272),
    [anon_sym_RBRACE] = ACTIONS(261),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(278),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(281),
    [anon_sym_declare] = ACTIONS(284),
    [anon_sym_typeset] = ACTIONS(284),
    [anon_sym_export] = ACTIONS(284),
    [anon_sym_readonly] = ACTIONS(284),
    [anon_sym_local] = ACTIONS(284),
    [anon_sym_unset] = ACTIONS(287),
    [anon_sym_unsetenv] = ACTIONS(287),
    [anon_sym_LT] = ACTIONS(290),
    [anon_sym_GT] = ACTIONS(290),
    [anon_sym_GT_GT] = ACTIONS(290),
    [anon_sym_AMP_GT] = ACTIONS(290),
    [anon_sym_AMP_GT_GT] = ACTIONS(290),
    [anon_sym_LT_AMP] = ACTIONS(290),
    [anon_sym_GT_AMP] = ACTIONS(290),
    [anon_sym_GT_PIPE] = ACTIONS(290),
    [anon_sym_DOLLAR] = ACTIONS(293),
    [sym__special_character] = ACTIONS(296),
    [anon_sym_DQUOTE] = ACTIONS(299),
    [sym_raw_string] = ACTIONS(302),
    [sym_ansii_c_string] = ACTIONS(302),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(305),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(308),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [anon_sym_LT_LPAREN] = ACTIONS(314),
    [anon_sym_GT_LPAREN] = ACTIONS(314),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(317),
    [sym_variable_name] = ACTIONS(320),
  },
  [123] = {
    [sym__statements] = STATE(3293),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [124] = {
    [sym__statements] = STATE(3367),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [125] = {
    [sym__statements] = STATE(3360),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(2044),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [126] = {
    [sym__statements] = STATE(3303),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [127] = {
    [sym__statements] = STATE(3316),
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(535),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(141),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [128] = {
    [aux_sym__statements2] = STATE(129),
    [sym_redirected_statement] = STATE(1698),
    [sym_for_statement] = STATE(1698),
    [sym_c_style_for_statement] = STATE(1698),
    [sym_while_statement] = STATE(1698),
    [sym_if_statement] = STATE(1698),
    [sym_case_statement] = STATE(1698),
    [sym_function_definition] = STATE(1698),
    [sym_compound_statement] = STATE(1698),
    [sym_subshell] = STATE(1698),
    [sym_pipeline] = STATE(1698),
    [sym_list] = STATE(1698),
    [sym_negated_command] = STATE(1698),
    [sym_test_command] = STATE(1698),
    [sym_declaration_command] = STATE(1698),
    [sym_unset_command] = STATE(1698),
    [sym_command] = STATE(1698),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(508),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [129] = {
    [aux_sym__statements2] = STATE(122),
    [sym_redirected_statement] = STATE(1698),
    [sym_for_statement] = STATE(1698),
    [sym_c_style_for_statement] = STATE(1698),
    [sym_while_statement] = STATE(1698),
    [sym_if_statement] = STATE(1698),
    [sym_case_statement] = STATE(1698),
    [sym_function_definition] = STATE(1698),
    [sym_compound_statement] = STATE(1698),
    [sym_subshell] = STATE(1698),
    [sym_pipeline] = STATE(1698),
    [sym_list] = STATE(1698),
    [sym_negated_command] = STATE(1698),
    [sym_test_command] = STATE(1698),
    [sym_declaration_command] = STATE(1698),
    [sym_unset_command] = STATE(1698),
    [sym_command] = STATE(1698),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(508),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [130] = {
    [aux_sym__statements2] = STATE(132),
    [sym_redirected_statement] = STATE(1747),
    [sym_for_statement] = STATE(1747),
    [sym_c_style_for_statement] = STATE(1747),
    [sym_while_statement] = STATE(1747),
    [sym_if_statement] = STATE(1747),
    [sym_case_statement] = STATE(1747),
    [sym_function_definition] = STATE(1747),
    [sym_compound_statement] = STATE(1747),
    [sym_subshell] = STATE(1747),
    [sym_pipeline] = STATE(1747),
    [sym_list] = STATE(1747),
    [sym_negated_command] = STATE(1747),
    [sym_test_command] = STATE(1747),
    [sym_declaration_command] = STATE(1747),
    [sym_unset_command] = STATE(1747),
    [sym_command] = STATE(1747),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(461),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(359),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [131] = {
    [sym__statements] = STATE(3327),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(2074),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [132] = {
    [aux_sym__statements2] = STATE(78),
    [sym_redirected_statement] = STATE(1747),
    [sym_for_statement] = STATE(1747),
    [sym_c_style_for_statement] = STATE(1747),
    [sym_while_statement] = STATE(1747),
    [sym_if_statement] = STATE(1747),
    [sym_case_statement] = STATE(1747),
    [sym_function_definition] = STATE(1747),
    [sym_compound_statement] = STATE(1747),
    [sym_subshell] = STATE(1747),
    [sym_pipeline] = STATE(1747),
    [sym_list] = STATE(1747),
    [sym_negated_command] = STATE(1747),
    [sym_test_command] = STATE(1747),
    [sym_declaration_command] = STATE(1747),
    [sym_unset_command] = STATE(1747),
    [sym_command] = STATE(1747),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(461),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(361),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [133] = {
    [aux_sym__statements2] = STATE(28),
    [sym_redirected_statement] = STATE(1747),
    [sym_for_statement] = STATE(1747),
    [sym_c_style_for_statement] = STATE(1747),
    [sym_while_statement] = STATE(1747),
    [sym_if_statement] = STATE(1747),
    [sym_case_statement] = STATE(1747),
    [sym_function_definition] = STATE(1747),
    [sym_compound_statement] = STATE(1747),
    [sym_subshell] = STATE(1747),
    [sym_pipeline] = STATE(1747),
    [sym_list] = STATE(1747),
    [sym_negated_command] = STATE(1747),
    [sym_test_command] = STATE(1747),
    [sym_declaration_command] = STATE(1747),
    [sym_unset_command] = STATE(1747),
    [sym_command] = STATE(1747),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(461),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(363),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [134] = {
    [sym__statements] = STATE(3426),
    [sym_redirected_statement] = STATE(1687),
    [sym_for_statement] = STATE(1687),
    [sym_c_style_for_statement] = STATE(1687),
    [sym_while_statement] = STATE(1687),
    [sym_if_statement] = STATE(1687),
    [sym_case_statement] = STATE(1687),
    [sym_function_definition] = STATE(1687),
    [sym_compound_statement] = STATE(1687),
    [sym_subshell] = STATE(1687),
    [sym_pipeline] = STATE(1687),
    [sym_list] = STATE(1687),
    [sym_negated_command] = STATE(1687),
    [sym_test_command] = STATE(1687),
    [sym_declaration_command] = STATE(1687),
    [sym_unset_command] = STATE(1687),
    [sym_command] = STATE(1687),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(357),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [135] = {
    [sym__terminated_statement] = STATE(3189),
    [sym_redirected_statement] = STATE(1704),
    [sym_for_statement] = STATE(1704),
    [sym_c_style_for_statement] = STATE(1704),
    [sym_while_statement] = STATE(1704),
    [sym_if_statement] = STATE(1704),
    [sym_case_statement] = STATE(1704),
    [sym_function_definition] = STATE(1704),
    [sym_compound_statement] = STATE(1704),
    [sym_subshell] = STATE(1704),
    [sym_pipeline] = STATE(1704),
    [sym_list] = STATE(1704),
    [sym_negated_command] = STATE(1704),
    [sym_test_command] = STATE(1704),
    [sym_declaration_command] = STATE(1704),
    [sym_unset_command] = STATE(1704),
    [sym_command] = STATE(1704),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(515),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [136] = {
    [sym__terminated_statement] = STATE(3375),
    [sym_redirected_statement] = STATE(1704),
    [sym_for_statement] = STATE(1704),
    [sym_c_style_for_statement] = STATE(1704),
    [sym_while_statement] = STATE(1704),
    [sym_if_statement] = STATE(1704),
    [sym_case_statement] = STATE(1704),
    [sym_function_definition] = STATE(1704),
    [sym_compound_statement] = STATE(1704),
    [sym_subshell] = STATE(1704),
    [sym_pipeline] = STATE(1704),
    [sym_list] = STATE(1704),
    [sym_negated_command] = STATE(1704),
    [sym_test_command] = STATE(1704),
    [sym_declaration_command] = STATE(1704),
    [sym_unset_command] = STATE(1704),
    [sym_command] = STATE(1704),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(515),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [137] = {
    [sym__terminated_statement] = STATE(3347),
    [sym_redirected_statement] = STATE(1704),
    [sym_for_statement] = STATE(1704),
    [sym_c_style_for_statement] = STATE(1704),
    [sym_while_statement] = STATE(1704),
    [sym_if_statement] = STATE(1704),
    [sym_case_statement] = STATE(1704),
    [sym_function_definition] = STATE(1704),
    [sym_compound_statement] = STATE(1704),
    [sym_subshell] = STATE(1704),
    [sym_pipeline] = STATE(1704),
    [sym_list] = STATE(1704),
    [sym_negated_command] = STATE(1704),
    [sym_test_command] = STATE(1704),
    [sym_declaration_command] = STATE(1704),
    [sym_unset_command] = STATE(1704),
    [sym_command] = STATE(1704),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(515),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [138] = {
    [sym_redirected_statement] = STATE(1651),
    [sym_for_statement] = STATE(1651),
    [sym_c_style_for_statement] = STATE(1651),
    [sym_while_statement] = STATE(1651),
    [sym_if_statement] = STATE(1651),
    [sym_case_statement] = STATE(1651),
    [sym_function_definition] = STATE(1651),
    [sym_compound_statement] = STATE(1651),
    [sym_subshell] = STATE(1651),
    [sym_pipeline] = STATE(1651),
    [sym_list] = STATE(1651),
    [sym_negated_command] = STATE(1651),
    [sym_test_command] = STATE(1651),
    [sym_declaration_command] = STATE(1651),
    [sym_unset_command] = STATE(1651),
    [sym_command] = STATE(1651),
    [sym_command_name] = STATE(186),
    [sym_variable_assignment] = STATE(273),
    [sym_subscript] = STATE(3249),
    [sym_file_redirect] = STATE(831),
    [sym_concatenation] = STATE(536),
    [sym_string] = STATE(278),
    [sym_simple_expansion] = STATE(278),
    [sym_string_expansion] = STATE(278),
    [sym_expansion] = STATE(278),
    [sym_command_substitution] = STATE(278),
    [sym_process_substitution] = STATE(278),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(831),
    [aux_sym__literal_repeat1] = STATE(313),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansii_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [139] = {
    [sym_redirected_statement] = STATE(1653),
    [sym_for_statement] = STATE(1653),
    [sym_c_style_for_statement] = STATE(1653),
    [sym_while_statement] = STATE(1653),
    [sym_if_statement] = STATE(1653),
    [sym_case_statement] = STATE(1653),
    [sym_function_definition] = STATE(1653),
    [sym_compound_statement] = STATE(1653),
    [sym_subshell] = STATE(1653),
    [sym_pipeline] = STATE(1653),
    [sym_list] = STATE(1653),
    [sym_negated_command] = STATE(1653),
    [sym_test_command] = STATE(1653),
    [sym_declaration_command] = STATE(1653),
    [sym_unset_command] = STATE(1653),
    [sym_command] = STATE(1653),
    [sym_command_name] = STATE(200),
    [sym_variable_assignment] = STATE(285),
    [sym_subscript] = STATE(3237),
    [sym_file_redirect] = STATE(771),
    [sym_concatenation] = STATE(736),
    [sym_string] = STATE(349),
    [sym_simple_expansion] = STATE(349),
    [sym_string_expansion] = STATE(349),
    [sym_expansion] = STATE(349),
    [sym_command_substitution] = STATE(349),
    [sym_process_substitution] = STATE(349),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(771),
    [aux_sym__literal_repeat1] = STATE(469),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [140] = {
    [sym_redirected_statement] = STATE(1686),
    [sym_for_statement] = STATE(1686),
    [sym_c_style_for_statement] = STATE(1686),
    [sym_while_statement] = STATE(1686),
    [sym_if_statement] = STATE(1686),
    [sym_case_statement] = STATE(1686),
    [sym_function_definition] = STATE(1686),
    [sym_compound_statement] = STATE(1686),
    [sym_subshell] = STATE(1686),
    [sym_pipeline] = STATE(1686),
    [sym_list] = STATE(1686),
    [sym_negated_command] = STATE(1686),
    [sym_test_command] = STATE(1686),
    [sym_declaration_command] = STATE(1686),
    [sym_unset_command] = STATE(1686),
    [sym_command] = STATE(1686),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(347),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [141] = {
    [sym_redirected_statement] = STATE(1671),
    [sym_for_statement] = STATE(1671),
    [sym_c_style_for_statement] = STATE(1671),
    [sym_while_statement] = STATE(1671),
    [sym_if_statement] = STATE(1671),
    [sym_case_statement] = STATE(1671),
    [sym_function_definition] = STATE(1671),
    [sym_compound_statement] = STATE(1671),
    [sym_subshell] = STATE(1671),
    [sym_pipeline] = STATE(1671),
    [sym_list] = STATE(1671),
    [sym_negated_command] = STATE(1671),
    [sym_test_command] = STATE(1671),
    [sym_declaration_command] = STATE(1671),
    [sym_unset_command] = STATE(1671),
    [sym_command] = STATE(1671),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(510),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [142] = {
    [sym__terminated_statement] = STATE(3370),
    [sym_redirected_statement] = STATE(1704),
    [sym_for_statement] = STATE(1704),
    [sym_c_style_for_statement] = STATE(1704),
    [sym_while_statement] = STATE(1704),
    [sym_if_statement] = STATE(1704),
    [sym_case_statement] = STATE(1704),
    [sym_function_definition] = STATE(1704),
    [sym_compound_statement] = STATE(1704),
    [sym_subshell] = STATE(1704),
    [sym_pipeline] = STATE(1704),
    [sym_list] = STATE(1704),
    [sym_negated_command] = STATE(1704),
    [sym_test_command] = STATE(1704),
    [sym_declaration_command] = STATE(1704),
    [sym_unset_command] = STATE(1704),
    [sym_command] = STATE(1704),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(515),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [143] = {
    [sym__terminated_statement] = STATE(3389),
    [sym_redirected_statement] = STATE(1704),
    [sym_for_statement] = STATE(1704),
    [sym_c_style_for_statement] = STATE(1704),
    [sym_while_statement] = STATE(1704),
    [sym_if_statement] = STATE(1704),
    [sym_case_statement] = STATE(1704),
    [sym_function_definition] = STATE(1704),
    [sym_compound_statement] = STATE(1704),
    [sym_subshell] = STATE(1704),
    [sym_pipeline] = STATE(1704),
    [sym_list] = STATE(1704),
    [sym_negated_command] = STATE(1704),
    [sym_test_command] = STATE(1704),
    [sym_declaration_command] = STATE(1704),
    [sym_unset_command] = STATE(1704),
    [sym_command] = STATE(1704),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(515),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [144] = {
    [sym__terminated_statement] = STATE(3257),
    [sym_redirected_statement] = STATE(1704),
    [sym_for_statement] = STATE(1704),
    [sym_c_style_for_statement] = STATE(1704),
    [sym_while_statement] = STATE(1704),
    [sym_if_statement] = STATE(1704),
    [sym_case_statement] = STATE(1704),
    [sym_function_definition] = STATE(1704),
    [sym_compound_statement] = STATE(1704),
    [sym_subshell] = STATE(1704),
    [sym_pipeline] = STATE(1704),
    [sym_list] = STATE(1704),
    [sym_negated_command] = STATE(1704),
    [sym_test_command] = STATE(1704),
    [sym_declaration_command] = STATE(1704),
    [sym_unset_command] = STATE(1704),
    [sym_command] = STATE(1704),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(515),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [145] = {
    [sym__terminated_statement] = STATE(3219),
    [sym_redirected_statement] = STATE(1704),
    [sym_for_statement] = STATE(1704),
    [sym_c_style_for_statement] = STATE(1704),
    [sym_while_statement] = STATE(1704),
    [sym_if_statement] = STATE(1704),
    [sym_case_statement] = STATE(1704),
    [sym_function_definition] = STATE(1704),
    [sym_compound_statement] = STATE(1704),
    [sym_subshell] = STATE(1704),
    [sym_pipeline] = STATE(1704),
    [sym_list] = STATE(1704),
    [sym_negated_command] = STATE(1704),
    [sym_test_command] = STATE(1704),
    [sym_declaration_command] = STATE(1704),
    [sym_unset_command] = STATE(1704),
    [sym_command] = STATE(1704),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(515),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [146] = {
    [sym_redirected_statement] = STATE(1668),
    [sym_for_statement] = STATE(1668),
    [sym_c_style_for_statement] = STATE(1668),
    [sym_while_statement] = STATE(1668),
    [sym_if_statement] = STATE(1668),
    [sym_case_statement] = STATE(1668),
    [sym_function_definition] = STATE(1668),
    [sym_compound_statement] = STATE(1668),
    [sym_subshell] = STATE(1668),
    [sym_pipeline] = STATE(1668),
    [sym_list] = STATE(1668),
    [sym_negated_command] = STATE(1668),
    [sym_test_command] = STATE(1668),
    [sym_declaration_command] = STATE(1668),
    [sym_unset_command] = STATE(1668),
    [sym_command] = STATE(1668),
    [sym_command_name] = STATE(227),
    [sym_variable_assignment] = STATE(346),
    [sym_subscript] = STATE(3176),
    [sym_file_redirect] = STATE(763),
    [sym_concatenation] = STATE(757),
    [sym_string] = STATE(526),
    [sym_simple_expansion] = STATE(526),
    [sym_string_expansion] = STATE(526),
    [sym_expansion] = STATE(526),
    [sym_command_substitution] = STATE(526),
    [sym_process_substitution] = STATE(526),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(763),
    [aux_sym__literal_repeat1] = STATE(735),
    [sym_word] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(9),
    [anon_sym_select] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_until] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(33),
    [anon_sym_typeset] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(33),
    [anon_sym_readonly] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(33),
    [anon_sym_unset] = ACTIONS(35),
    [anon_sym_unsetenv] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [sym__special_character] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [sym_ansii_c_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(57),
  },
  [147] = {
    [sym_redirected_statement] = STATE(1705),
    [sym_for_statement] = STATE(1705),
    [sym_c_style_for_statement] = STATE(1705),
    [sym_while_statement] = STATE(1705),
    [sym_if_statement] = STATE(1705),
    [sym_case_statement] = STATE(1705),
    [sym_function_definition] = STATE(1705),
    [sym_compound_statement] = STATE(1705),
    [sym_subshell] = STATE(1705),
    [sym_pipeline] = STATE(1705),
    [sym_list] = STATE(1705),
    [sym_negated_command] = STATE(1705),
    [sym_test_command] = STATE(1705),
    [sym_declaration_command] = STATE(1705),
    [sym_unset_command] = STATE(1705),
    [sym_command] = STATE(1705),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(494),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(365),
    [anon_sym_for] = ACTIONS(368),
    [anon_sym_select] = ACTIONS(371),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(374),
    [anon_sym_while] = ACTIONS(377),
    [anon_sym_until] = ACTIONS(377),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_case] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(386),
    [anon_sym_LPAREN] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(392),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_LBRACK] = ACTIONS(398),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_declare] = ACTIONS(404),
    [anon_sym_typeset] = ACTIONS(404),
    [anon_sym_export] = ACTIONS(404),
    [anon_sym_readonly] = ACTIONS(404),
    [anon_sym_local] = ACTIONS(404),
    [anon_sym_unset] = ACTIONS(407),
    [anon_sym_unsetenv] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(410),
    [anon_sym_GT] = ACTIONS(410),
    [anon_sym_GT_GT] = ACTIONS(410),
    [anon_sym_AMP_GT] = ACTIONS(410),
    [anon_sym_AMP_GT_GT] = ACTIONS(410),
    [anon_sym_LT_AMP] = ACTIONS(410),
    [anon_sym_GT_AMP] = ACTIONS(410),
    [anon_sym_GT_PIPE] = ACTIONS(410),
    [anon_sym_DOLLAR] = ACTIONS(413),
    [sym__special_character] = ACTIONS(416),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [sym_raw_string] = ACTIONS(422),
    [sym_ansii_c_string] = ACTIONS(422),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(425),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(431),
    [anon_sym_LT_LPAREN] = ACTIONS(434),
    [anon_sym_GT_LPAREN] = ACTIONS(434),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(437),
    [sym_variable_name] = ACTIONS(440),
  },
  [148] = {
    [sym_redirected_statement] = STATE(1656),
    [sym_for_statement] = STATE(1656),
    [sym_c_style_for_statement] = STATE(1656),
    [sym_while_statement] = STATE(1656),
    [sym_if_statement] = STATE(1656),
    [sym_case_statement] = STATE(1656),
    [sym_function_definition] = STATE(1656),
    [sym_compound_statement] = STATE(1656),
    [sym_subshell] = STATE(1656),
    [sym_pipeline] = STATE(1656),
    [sym_list] = STATE(1656),
    [sym_negated_command] = STATE(1656),
    [sym_test_command] = STATE(1656),
    [sym_declaration_command] = STATE(1656),
    [sym_unset_command] = STATE(1656),
    [sym_command] = STATE(1656),
    [sym_command_name] = STATE(200),
    [sym_variable_assignment] = STATE(280),
    [sym_subscript] = STATE(3237),
    [sym_file_redirect] = STATE(771),
    [sym_concatenation] = STATE(736),
    [sym_string] = STATE(349),
    [sym_simple_expansion] = STATE(349),
    [sym_string_expansion] = STATE(349),
    [sym_expansion] = STATE(349),
    [sym_command_substitution] = STATE(349),
    [sym_process_substitution] = STATE(349),
    [aux_sym_command_repeat1] = STATE(771),
    [aux_sym__literal_repeat1] = STATE(469),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [149] = {
    [sym_redirected_statement] = STATE(1681),
    [sym_for_statement] = STATE(1681),
    [sym_c_style_for_statement] = STATE(1681),
    [sym_while_statement] = STATE(1681),
    [sym_if_statement] = STATE(1681),
    [sym_case_statement] = STATE(1681),
    [sym_function_definition] = STATE(1681),
    [sym_compound_statement] = STATE(1681),
    [sym_subshell] = STATE(1681),
    [sym_pipeline] = STATE(1681),
    [sym_list] = STATE(1681),
    [sym_negated_command] = STATE(1681),
    [sym_test_command] = STATE(1681),
    [sym_declaration_command] = STATE(1681),
    [sym_unset_command] = STATE(1681),
    [sym_command] = STATE(1681),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(496),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [150] = {
    [sym_redirected_statement] = STATE(1663),
    [sym_for_statement] = STATE(1663),
    [sym_c_style_for_statement] = STATE(1663),
    [sym_while_statement] = STATE(1663),
    [sym_if_statement] = STATE(1663),
    [sym_case_statement] = STATE(1663),
    [sym_function_definition] = STATE(1663),
    [sym_compound_statement] = STATE(1663),
    [sym_subshell] = STATE(1663),
    [sym_pipeline] = STATE(1663),
    [sym_list] = STATE(1663),
    [sym_negated_command] = STATE(1663),
    [sym_test_command] = STATE(1663),
    [sym_declaration_command] = STATE(1663),
    [sym_unset_command] = STATE(1663),
    [sym_command] = STATE(1663),
    [sym_command_name] = STATE(227),
    [sym_variable_assignment] = STATE(312),
    [sym_subscript] = STATE(3176),
    [sym_file_redirect] = STATE(763),
    [sym_concatenation] = STATE(757),
    [sym_string] = STATE(526),
    [sym_simple_expansion] = STATE(526),
    [sym_string_expansion] = STATE(526),
    [sym_expansion] = STATE(526),
    [sym_command_substitution] = STATE(526),
    [sym_process_substitution] = STATE(526),
    [aux_sym_command_repeat1] = STATE(763),
    [aux_sym__literal_repeat1] = STATE(735),
    [sym_word] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(9),
    [anon_sym_select] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_until] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(33),
    [anon_sym_typeset] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(33),
    [anon_sym_readonly] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(33),
    [anon_sym_unset] = ACTIONS(35),
    [anon_sym_unsetenv] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [sym__special_character] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [sym_ansii_c_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(57),
  },
  [151] = {
    [sym_redirected_statement] = STATE(1672),
    [sym_for_statement] = STATE(1672),
    [sym_c_style_for_statement] = STATE(1672),
    [sym_while_statement] = STATE(1672),
    [sym_if_statement] = STATE(1672),
    [sym_case_statement] = STATE(1672),
    [sym_function_definition] = STATE(1672),
    [sym_compound_statement] = STATE(1672),
    [sym_subshell] = STATE(1672),
    [sym_pipeline] = STATE(1672),
    [sym_list] = STATE(1672),
    [sym_negated_command] = STATE(1672),
    [sym_test_command] = STATE(1672),
    [sym_declaration_command] = STATE(1672),
    [sym_unset_command] = STATE(1672),
    [sym_command] = STATE(1672),
    [sym_command_name] = STATE(227),
    [sym_variable_assignment] = STATE(366),
    [sym_subscript] = STATE(3176),
    [sym_file_redirect] = STATE(763),
    [sym_concatenation] = STATE(757),
    [sym_string] = STATE(526),
    [sym_simple_expansion] = STATE(526),
    [sym_string_expansion] = STATE(526),
    [sym_expansion] = STATE(526),
    [sym_command_substitution] = STATE(526),
    [sym_process_substitution] = STATE(526),
    [aux_sym_command_repeat1] = STATE(763),
    [aux_sym__literal_repeat1] = STATE(735),
    [sym_word] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(9),
    [anon_sym_select] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_until] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(33),
    [anon_sym_typeset] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(33),
    [anon_sym_readonly] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(33),
    [anon_sym_unset] = ACTIONS(35),
    [anon_sym_unsetenv] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [sym__special_character] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [sym_ansii_c_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(57),
  },
  [152] = {
    [sym_redirected_statement] = STATE(1667),
    [sym_for_statement] = STATE(1667),
    [sym_c_style_for_statement] = STATE(1667),
    [sym_while_statement] = STATE(1667),
    [sym_if_statement] = STATE(1667),
    [sym_case_statement] = STATE(1667),
    [sym_function_definition] = STATE(1667),
    [sym_compound_statement] = STATE(1667),
    [sym_subshell] = STATE(1667),
    [sym_pipeline] = STATE(1667),
    [sym_list] = STATE(1667),
    [sym_negated_command] = STATE(1667),
    [sym_test_command] = STATE(1667),
    [sym_declaration_command] = STATE(1667),
    [sym_unset_command] = STATE(1667),
    [sym_command] = STATE(1667),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(319),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [153] = {
    [sym_redirected_statement] = STATE(1648),
    [sym_for_statement] = STATE(1648),
    [sym_c_style_for_statement] = STATE(1648),
    [sym_while_statement] = STATE(1648),
    [sym_if_statement] = STATE(1648),
    [sym_case_statement] = STATE(1648),
    [sym_function_definition] = STATE(1648),
    [sym_compound_statement] = STATE(1648),
    [sym_subshell] = STATE(1648),
    [sym_pipeline] = STATE(1648),
    [sym_list] = STATE(1648),
    [sym_negated_command] = STATE(1648),
    [sym_test_command] = STATE(1648),
    [sym_declaration_command] = STATE(1648),
    [sym_unset_command] = STATE(1648),
    [sym_command] = STATE(1648),
    [sym_command_name] = STATE(186),
    [sym_variable_assignment] = STATE(276),
    [sym_subscript] = STATE(3249),
    [sym_file_redirect] = STATE(831),
    [sym_concatenation] = STATE(536),
    [sym_string] = STATE(278),
    [sym_simple_expansion] = STATE(278),
    [sym_string_expansion] = STATE(278),
    [sym_expansion] = STATE(278),
    [sym_command_substitution] = STATE(278),
    [sym_process_substitution] = STATE(278),
    [aux_sym_command_repeat1] = STATE(831),
    [aux_sym__literal_repeat1] = STATE(313),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansii_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [154] = {
    [sym_redirected_statement] = STATE(1661),
    [sym_for_statement] = STATE(1661),
    [sym_c_style_for_statement] = STATE(1661),
    [sym_while_statement] = STATE(1661),
    [sym_if_statement] = STATE(1661),
    [sym_case_statement] = STATE(1661),
    [sym_function_definition] = STATE(1661),
    [sym_compound_statement] = STATE(1661),
    [sym_subshell] = STATE(1661),
    [sym_pipeline] = STATE(1661),
    [sym_list] = STATE(1661),
    [sym_negated_command] = STATE(1661),
    [sym_test_command] = STATE(1661),
    [sym_declaration_command] = STATE(1661),
    [sym_unset_command] = STATE(1661),
    [sym_command] = STATE(1661),
    [sym_command_name] = STATE(242),
    [sym_variable_assignment] = STATE(497),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(819),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(819),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [155] = {
    [sym_redirected_statement] = STATE(1649),
    [sym_for_statement] = STATE(1649),
    [sym_c_style_for_statement] = STATE(1649),
    [sym_while_statement] = STATE(1649),
    [sym_if_statement] = STATE(1649),
    [sym_case_statement] = STATE(1649),
    [sym_function_definition] = STATE(1649),
    [sym_compound_statement] = STATE(1649),
    [sym_subshell] = STATE(1649),
    [sym_pipeline] = STATE(1649),
    [sym_list] = STATE(1649),
    [sym_negated_command] = STATE(1649),
    [sym_test_command] = STATE(1649),
    [sym_declaration_command] = STATE(1649),
    [sym_unset_command] = STATE(1649),
    [sym_command] = STATE(1649),
    [sym_command_name] = STATE(186),
    [sym_variable_assignment] = STATE(272),
    [sym_subscript] = STATE(3249),
    [sym_file_redirect] = STATE(831),
    [sym_concatenation] = STATE(536),
    [sym_string] = STATE(278),
    [sym_simple_expansion] = STATE(278),
    [sym_string_expansion] = STATE(278),
    [sym_expansion] = STATE(278),
    [sym_command_substitution] = STATE(278),
    [sym_process_substitution] = STATE(278),
    [aux_sym_command_repeat1] = STATE(831),
    [aux_sym__literal_repeat1] = STATE(313),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansii_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [156] = {
    [sym_redirected_statement] = STATE(1661),
    [sym_for_statement] = STATE(1661),
    [sym_c_style_for_statement] = STATE(1661),
    [sym_while_statement] = STATE(1661),
    [sym_if_statement] = STATE(1661),
    [sym_case_statement] = STATE(1661),
    [sym_function_definition] = STATE(1661),
    [sym_compound_statement] = STATE(1661),
    [sym_subshell] = STATE(1661),
    [sym_pipeline] = STATE(1661),
    [sym_list] = STATE(1661),
    [sym_negated_command] = STATE(1661),
    [sym_test_command] = STATE(1661),
    [sym_declaration_command] = STATE(1661),
    [sym_unset_command] = STATE(1661),
    [sym_command] = STATE(1661),
    [sym_command_name] = STATE(223),
    [sym_variable_assignment] = STATE(321),
    [sym_subscript] = STATE(3216),
    [sym_file_redirect] = STATE(816),
    [sym_concatenation] = STATE(817),
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [aux_sym_command_repeat1] = STATE(816),
    [aux_sym__literal_repeat1] = STATE(661),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [157] = {
    [sym_redirected_statement] = STATE(1662),
    [sym_for_statement] = STATE(1662),
    [sym_c_style_for_statement] = STATE(1662),
    [sym_while_statement] = STATE(1662),
    [sym_if_statement] = STATE(1662),
    [sym_case_statement] = STATE(1662),
    [sym_function_definition] = STATE(1662),
    [sym_compound_statement] = STATE(1662),
    [sym_subshell] = STATE(1662),
    [sym_pipeline] = STATE(1662),
    [sym_list] = STATE(1662),
    [sym_negated_command] = STATE(1662),
    [sym_test_command] = STATE(1662),
    [sym_declaration_command] = STATE(1662),
    [sym_unset_command] = STATE(1662),
    [sym_command] = STATE(1662),
    [sym_command_name] = STATE(200),
    [sym_variable_assignment] = STATE(284),
    [sym_subscript] = STATE(3237),
    [sym_file_redirect] = STATE(771),
    [sym_concatenation] = STATE(736),
    [sym_string] = STATE(349),
    [sym_simple_expansion] = STATE(349),
    [sym_string_expansion] = STATE(349),
    [sym_expansion] = STATE(349),
    [sym_command_substitution] = STATE(349),
    [sym_process_substitution] = STATE(349),
    [aux_sym_command_repeat1] = STATE(771),
    [aux_sym__literal_repeat1] = STATE(469),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 1,
      sym__simple_heredoc_body,
    ACTIONS(449), 1,
      sym__heredoc_body_beginning,
    STATE(2800), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(445), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [64] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 1,
      sym__simple_heredoc_body,
    ACTIONS(449), 1,
      sym__heredoc_body_beginning,
    STATE(2833), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(453), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [128] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 1,
      sym__simple_heredoc_body,
    ACTIONS(449), 1,
      sym__heredoc_body_beginning,
    STATE(2872), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(453), 3,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [191] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(460), 1,
      anon_sym_DOLLAR,
    ACTIONS(463), 1,
      sym__special_character,
    ACTIONS(466), 1,
      anon_sym_DQUOTE,
    ACTIONS(469), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(472), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(475), 1,
      anon_sym_BQUOTE,
    ACTIONS(481), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(484), 1,
      sym_file_descriptor,
    ACTIONS(486), 1,
      sym_variable_name,
    STATE(311), 1,
      aux_sym__literal_repeat1,
    STATE(3244), 1,
      sym_subscript,
    ACTIONS(478), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(455), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(161), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(291), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(458), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [274] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 1,
      sym__simple_heredoc_body,
    ACTIONS(449), 1,
      sym__heredoc_body_beginning,
    STATE(2851), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(445), 3,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [337] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(493), 1,
      anon_sym_DOLLAR,
    ACTIONS(495), 1,
      sym__special_character,
    ACTIONS(497), 1,
      anon_sym_DQUOTE,
    ACTIONS(499), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(501), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(503), 1,
      anon_sym_BQUOTE,
    ACTIONS(507), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(509), 1,
      sym_file_descriptor,
    ACTIONS(511), 1,
      sym_variable_name,
    STATE(311), 1,
      aux_sym__literal_repeat1,
    STATE(3244), 1,
      sym_subscript,
    ACTIONS(505), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(489), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(165), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(291), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(491), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [420] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 1,
      sym__simple_heredoc_body,
    ACTIONS(515), 1,
      sym__heredoc_body_beginning,
    STATE(2972), 1,
      sym_heredoc_body,
    ACTIONS(517), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(261), 42,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [481] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(493), 1,
      anon_sym_DOLLAR,
    ACTIONS(495), 1,
      sym__special_character,
    ACTIONS(497), 1,
      anon_sym_DQUOTE,
    ACTIONS(499), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(501), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(503), 1,
      anon_sym_BQUOTE,
    ACTIONS(511), 1,
      sym_variable_name,
    ACTIONS(521), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(523), 1,
      sym_file_descriptor,
    STATE(311), 1,
      aux_sym__literal_repeat1,
    STATE(3244), 1,
      sym_subscript,
    ACTIONS(505), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(489), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(161), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(291), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(519), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [564] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 1,
      sym_file_descriptor,
    ACTIONS(527), 1,
      anon_sym_DOLLAR,
    ACTIONS(529), 1,
      sym__special_character,
    ACTIONS(531), 1,
      anon_sym_DQUOTE,
    ACTIONS(533), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(537), 1,
      anon_sym_BQUOTE,
    ACTIONS(541), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(543), 1,
      sym_variable_name,
    STATE(466), 1,
      aux_sym__literal_repeat1,
    STATE(3234), 1,
      sym_subscript,
    ACTIONS(539), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(525), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(168), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(353), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(519), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [646] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 1,
      anon_sym_DQUOTE,
    ACTIONS(549), 1,
      sym_raw_string,
    ACTIONS(551), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(553), 1,
      sym_file_descriptor,
    STATE(371), 1,
      sym_string,
    ACTIONS(547), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(545), 32,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [710] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(484), 1,
      sym_file_descriptor,
    ACTIONS(558), 1,
      anon_sym_DOLLAR,
    ACTIONS(561), 1,
      sym__special_character,
    ACTIONS(564), 1,
      anon_sym_DQUOTE,
    ACTIONS(567), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(570), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(573), 1,
      anon_sym_BQUOTE,
    ACTIONS(579), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(582), 1,
      sym_variable_name,
    STATE(466), 1,
      aux_sym__literal_repeat1,
    STATE(3234), 1,
      sym_subscript,
    ACTIONS(576), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(555), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(168), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(353), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(458), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [792] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 1,
      sym_file_descriptor,
    ACTIONS(527), 1,
      anon_sym_DOLLAR,
    ACTIONS(529), 1,
      sym__special_character,
    ACTIONS(531), 1,
      anon_sym_DQUOTE,
    ACTIONS(533), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(537), 1,
      anon_sym_BQUOTE,
    ACTIONS(543), 1,
      sym_variable_name,
    ACTIONS(585), 1,
      aux_sym__simple_variable_name_token1,
    STATE(466), 1,
      aux_sym__literal_repeat1,
    STATE(3234), 1,
      sym_subscript,
    ACTIONS(539), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(525), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(166), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(353), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(491), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [874] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 1,
      sym_file_descriptor,
    ACTIONS(589), 1,
      anon_sym_DOLLAR,
    ACTIONS(591), 1,
      sym__special_character,
    ACTIONS(593), 1,
      anon_sym_DQUOTE,
    ACTIONS(595), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(597), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(599), 1,
      anon_sym_BQUOTE,
    ACTIONS(603), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(605), 1,
      sym_variable_name,
    STATE(669), 1,
      aux_sym__literal_repeat1,
    STATE(3254), 1,
      sym_subscript,
    ACTIONS(601), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(587), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(185), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(456), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(491), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [955] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(611), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(609), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(607), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1010] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(453), 4,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1065] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(453), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1120] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 1,
      anon_sym_DOLLAR,
    ACTIONS(161), 1,
      sym__special_character,
    ACTIONS(163), 1,
      anon_sym_DQUOTE,
    ACTIONS(167), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(169), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(171), 1,
      anon_sym_BQUOTE,
    ACTIONS(619), 1,
      sym_file_descriptor,
    STATE(181), 1,
      aux_sym_command_repeat2,
    STATE(325), 1,
      aux_sym__literal_repeat1,
    STATE(513), 1,
      sym_concatenation,
    ACTIONS(173), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(617), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(613), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(289), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(615), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1199] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(611), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(621), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(607), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1254] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_RPAREN,
    ACTIONS(513), 1,
      sym__simple_heredoc_body,
    ACTIONS(515), 1,
      sym__heredoc_body_beginning,
    STATE(2900), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1315] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 1,
      sym__simple_heredoc_body,
    ACTIONS(515), 1,
      sym__heredoc_body_beginning,
    STATE(2948), 1,
      sym_heredoc_body,
    ACTIONS(517), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(261), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1374] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_DOLLAR,
    ACTIONS(627), 1,
      sym__special_character,
    ACTIONS(629), 1,
      anon_sym_DQUOTE,
    ACTIONS(631), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(633), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(635), 1,
      anon_sym_BQUOTE,
    ACTIONS(639), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(641), 1,
      sym_variable_name,
    STATE(663), 1,
      aux_sym__literal_repeat1,
    STATE(3258), 1,
      sym_subscript,
    ACTIONS(509), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(637), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(623), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(184), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(507), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(491), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1455] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 1,
      anon_sym_DOLLAR,
    ACTIONS(161), 1,
      sym__special_character,
    ACTIONS(163), 1,
      anon_sym_DQUOTE,
    ACTIONS(167), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(169), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(171), 1,
      anon_sym_BQUOTE,
    ACTIONS(645), 1,
      sym_file_descriptor,
    STATE(174), 1,
      aux_sym_command_repeat2,
    STATE(325), 1,
      aux_sym__literal_repeat1,
    STATE(513), 1,
      sym_concatenation,
    ACTIONS(173), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(617), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(613), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(289), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(643), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1534] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 1,
      anon_sym_DOLLAR,
    ACTIONS(161), 1,
      sym__special_character,
    ACTIONS(163), 1,
      anon_sym_DQUOTE,
    ACTIONS(167), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(169), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(171), 1,
      anon_sym_BQUOTE,
    ACTIONS(649), 1,
      sym_file_descriptor,
    STATE(181), 1,
      aux_sym_command_repeat2,
    STATE(325), 1,
      aux_sym__literal_repeat1,
    STATE(513), 1,
      sym_concatenation,
    ACTIONS(173), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(617), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(613), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(289), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(647), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1613] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(659), 1,
      anon_sym_DOLLAR,
    ACTIONS(662), 1,
      sym__special_character,
    ACTIONS(665), 1,
      anon_sym_DQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(671), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(674), 1,
      anon_sym_BQUOTE,
    ACTIONS(680), 1,
      sym_file_descriptor,
    STATE(181), 1,
      aux_sym_command_repeat2,
    STATE(325), 1,
      aux_sym__literal_repeat1,
    STATE(513), 1,
      sym_concatenation,
    ACTIONS(656), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(677), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(651), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(289), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(654), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1692] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 1,
      ts_builtin_sym_end,
    ACTIONS(684), 1,
      sym__simple_heredoc_body,
    ACTIONS(686), 1,
      sym__heredoc_body_beginning,
    STATE(2929), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1753] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 1,
      sym__simple_heredoc_body,
    ACTIONS(515), 1,
      sym__heredoc_body_beginning,
    STATE(2960), 1,
      sym_heredoc_body,
    ACTIONS(517), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(261), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_done,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1812] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_DOLLAR,
    ACTIONS(627), 1,
      sym__special_character,
    ACTIONS(629), 1,
      anon_sym_DQUOTE,
    ACTIONS(631), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(633), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(635), 1,
      anon_sym_BQUOTE,
    ACTIONS(641), 1,
      sym_variable_name,
    ACTIONS(688), 1,
      aux_sym__simple_variable_name_token1,
    STATE(663), 1,
      aux_sym__literal_repeat1,
    STATE(3258), 1,
      sym_subscript,
    ACTIONS(523), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(637), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(623), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(191), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(507), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(519), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1893] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 1,
      sym_file_descriptor,
    ACTIONS(589), 1,
      anon_sym_DOLLAR,
    ACTIONS(591), 1,
      sym__special_character,
    ACTIONS(593), 1,
      anon_sym_DQUOTE,
    ACTIONS(595), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(597), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(599), 1,
      anon_sym_BQUOTE,
    ACTIONS(605), 1,
      sym_variable_name,
    ACTIONS(690), 1,
      aux_sym__simple_variable_name_token1,
    STATE(669), 1,
      aux_sym__literal_repeat1,
    STATE(3254), 1,
      sym_subscript,
    ACTIONS(601), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(587), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(188), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(456), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(519), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1974] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 1,
      anon_sym_DOLLAR,
    ACTIONS(161), 1,
      sym__special_character,
    ACTIONS(163), 1,
      anon_sym_DQUOTE,
    ACTIONS(167), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(169), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(171), 1,
      anon_sym_BQUOTE,
    ACTIONS(694), 1,
      sym_file_descriptor,
    STATE(180), 1,
      aux_sym_command_repeat2,
    STATE(325), 1,
      aux_sym__literal_repeat1,
    STATE(513), 1,
      sym_concatenation,
    ACTIONS(173), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(617), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(613), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(289), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(692), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [2053] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(611), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(609), 4,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(607), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2108] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(484), 1,
      sym_file_descriptor,
    ACTIONS(699), 1,
      anon_sym_DOLLAR,
    ACTIONS(702), 1,
      sym__special_character,
    ACTIONS(705), 1,
      anon_sym_DQUOTE,
    ACTIONS(708), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(714), 1,
      anon_sym_BQUOTE,
    ACTIONS(720), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(723), 1,
      sym_variable_name,
    STATE(669), 1,
      aux_sym__literal_repeat1,
    STATE(3254), 1,
      sym_subscript,
    ACTIONS(717), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(696), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(188), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(456), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(458), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [2189] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(445), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2244] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(684), 1,
      sym__simple_heredoc_body,
    ACTIONS(686), 1,
      sym__heredoc_body_beginning,
    ACTIONS(726), 1,
      ts_builtin_sym_end,
    STATE(2921), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2305] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(731), 1,
      anon_sym_DOLLAR,
    ACTIONS(734), 1,
      sym__special_character,
    ACTIONS(737), 1,
      anon_sym_DQUOTE,
    ACTIONS(740), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(743), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(746), 1,
      anon_sym_BQUOTE,
    ACTIONS(752), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(755), 1,
      sym_variable_name,
    STATE(663), 1,
      aux_sym__literal_repeat1,
    STATE(3258), 1,
      sym_subscript,
    ACTIONS(484), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(749), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(728), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(191), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(507), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(458), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [2386] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 1,
      anon_sym_DQUOTE,
    ACTIONS(760), 1,
      sym_raw_string,
    ACTIONS(762), 1,
      aux_sym__simple_variable_name_token1,
    STATE(375), 1,
      sym_string,
    ACTIONS(553), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(758), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(545), 30,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [2449] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 1,
      sym__simple_heredoc_body,
    ACTIONS(515), 1,
      sym__heredoc_body_beginning,
    STATE(2975), 1,
      sym_heredoc_body,
    ACTIONS(517), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(261), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2508] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(611), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(621), 4,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(607), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2563] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(445), 4,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2618] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      anon_sym_RPAREN,
    ACTIONS(513), 1,
      sym__simple_heredoc_body,
    ACTIONS(515), 1,
      sym__heredoc_body_beginning,
    STATE(2897), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2679] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_DQUOTE,
    ACTIONS(768), 1,
      sym_raw_string,
    ACTIONS(770), 1,
      aux_sym__simple_variable_name_token1,
    STATE(511), 1,
      sym_string,
    ACTIONS(553), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(764), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(545), 30,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [2742] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      anon_sym_DQUOTE,
    ACTIONS(553), 1,
      sym_file_descriptor,
    ACTIONS(774), 1,
      sym_raw_string,
    ACTIONS(776), 1,
      aux_sym__simple_variable_name_token1,
    STATE(420), 1,
      sym_string,
    ACTIONS(772), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(545), 31,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [2805] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 1,
      anon_sym_DOLLAR,
    ACTIONS(217), 1,
      sym__special_character,
    ACTIONS(219), 1,
      anon_sym_DQUOTE,
    ACTIONS(223), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(225), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(227), 1,
      anon_sym_BQUOTE,
    ACTIONS(619), 1,
      sym_file_descriptor,
    STATE(216), 1,
      aux_sym_command_repeat2,
    STATE(454), 1,
      aux_sym__literal_repeat1,
    STATE(670), 1,
      sym_concatenation,
    ACTIONS(229), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(780), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(778), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(355), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(615), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [2883] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 1,
      anon_sym_DOLLAR,
    ACTIONS(217), 1,
      sym__special_character,
    ACTIONS(219), 1,
      anon_sym_DQUOTE,
    ACTIONS(223), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(225), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(227), 1,
      anon_sym_BQUOTE,
    ACTIONS(694), 1,
      sym_file_descriptor,
    STATE(215), 1,
      aux_sym_command_repeat2,
    STATE(454), 1,
      aux_sym__literal_repeat1,
    STATE(670), 1,
      sym_concatenation,
    ACTIONS(229), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(780), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(778), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(355), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(692), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [2961] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 1,
      anon_sym_DOLLAR,
    ACTIONS(788), 1,
      sym__special_character,
    ACTIONS(790), 1,
      anon_sym_DQUOTE,
    ACTIONS(792), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(794), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(796), 1,
      anon_sym_BQUOTE,
    ACTIONS(800), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(802), 1,
      sym_file_descriptor,
    STATE(544), 1,
      aux_sym__literal_repeat1,
    ACTIONS(798), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(205), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(782), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(296), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(784), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3037] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 1,
      sym_file_descriptor,
    ACTIONS(589), 1,
      anon_sym_DOLLAR,
    ACTIONS(591), 1,
      sym__special_character,
    ACTIONS(593), 1,
      anon_sym_DQUOTE,
    ACTIONS(595), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(597), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(605), 1,
      sym_variable_name,
    ACTIONS(690), 1,
      aux_sym__simple_variable_name_token1,
    STATE(669), 1,
      aux_sym__literal_repeat1,
    STATE(3254), 1,
      sym_subscript,
    ACTIONS(601), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(587), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(188), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(456), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(519), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [3115] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(804), 42,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [3167] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(553), 1,
      sym_file_descriptor,
    ACTIONS(790), 1,
      anon_sym_DQUOTE,
    ACTIONS(810), 1,
      sym_raw_string,
    ACTIONS(812), 1,
      aux_sym__simple_variable_name_token1,
    STATE(436), 1,
      sym_string,
    ACTIONS(808), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(545), 30,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [3229] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 1,
      anon_sym_DOLLAR,
    ACTIONS(788), 1,
      sym__special_character,
    ACTIONS(790), 1,
      anon_sym_DQUOTE,
    ACTIONS(792), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(794), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(796), 1,
      anon_sym_BQUOTE,
    ACTIONS(816), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(818), 1,
      sym_file_descriptor,
    STATE(544), 1,
      aux_sym__literal_repeat1,
    ACTIONS(798), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(213), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(782), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(296), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(814), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3305] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(553), 1,
      sym_file_descriptor,
    ACTIONS(822), 1,
      sym_raw_string,
    ACTIONS(824), 1,
      aux_sym__simple_variable_name_token1,
    STATE(633), 1,
      sym_string,
    ACTIONS(820), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(545), 30,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [3367] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(828), 1,
      anon_sym_DQUOTE,
    ACTIONS(830), 1,
      sym_raw_string,
    ACTIONS(832), 1,
      aux_sym__simple_variable_name_token1,
    STATE(665), 1,
      sym_string,
    ACTIONS(553), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(826), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(545), 29,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [3429] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 1,
      sym__simple_heredoc_body,
    ACTIONS(515), 1,
      sym__heredoc_body_beginning,
    STATE(2990), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [3487] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 1,
      sym_file_descriptor,
    ACTIONS(589), 1,
      anon_sym_DOLLAR,
    ACTIONS(591), 1,
      sym__special_character,
    ACTIONS(593), 1,
      anon_sym_DQUOTE,
    ACTIONS(595), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(597), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(605), 1,
      sym_variable_name,
    ACTIONS(834), 1,
      aux_sym__simple_variable_name_token1,
    STATE(669), 1,
      aux_sym__literal_repeat1,
    STATE(3254), 1,
      sym_subscript,
    ACTIONS(601), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(587), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(202), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(456), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(491), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [3565] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 1,
      anon_sym_DOLLAR,
    ACTIONS(217), 1,
      sym__special_character,
    ACTIONS(219), 1,
      anon_sym_DQUOTE,
    ACTIONS(223), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(225), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(227), 1,
      anon_sym_BQUOTE,
    ACTIONS(645), 1,
      sym_file_descriptor,
    STATE(199), 1,
      aux_sym_command_repeat2,
    STATE(454), 1,
      aux_sym__literal_repeat1,
    STATE(670), 1,
      sym_concatenation,
    ACTIONS(229), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(780), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(778), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(355), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(643), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3643] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(838), 1,
      sym_raw_string,
    ACTIONS(840), 1,
      aux_sym__simple_variable_name_token1,
    STATE(655), 1,
      sym_string,
    ACTIONS(553), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(836), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(545), 29,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [3705] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      anon_sym_BQUOTE,
    ACTIONS(513), 1,
      sym__simple_heredoc_body,
    ACTIONS(515), 1,
      sym__heredoc_body_beginning,
    STATE(2938), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 38,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [3765] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(847), 1,
      anon_sym_DOLLAR,
    ACTIONS(850), 1,
      sym__special_character,
    ACTIONS(853), 1,
      anon_sym_DQUOTE,
    ACTIONS(856), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(859), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(862), 1,
      anon_sym_BQUOTE,
    ACTIONS(868), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(871), 1,
      sym_file_descriptor,
    STATE(544), 1,
      aux_sym__literal_repeat1,
    ACTIONS(865), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(213), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(842), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(296), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(845), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3841] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_BQUOTE,
    ACTIONS(513), 1,
      sym__simple_heredoc_body,
    ACTIONS(515), 1,
      sym__heredoc_body_beginning,
    STATE(2896), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 38,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [3901] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 1,
      anon_sym_DOLLAR,
    ACTIONS(217), 1,
      sym__special_character,
    ACTIONS(219), 1,
      anon_sym_DQUOTE,
    ACTIONS(223), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(225), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(227), 1,
      anon_sym_BQUOTE,
    ACTIONS(649), 1,
      sym_file_descriptor,
    STATE(216), 1,
      aux_sym_command_repeat2,
    STATE(454), 1,
      aux_sym__literal_repeat1,
    STATE(670), 1,
      sym_concatenation,
    ACTIONS(229), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(780), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(778), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(355), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(647), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3979] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 1,
      sym_file_descriptor,
    ACTIONS(879), 1,
      anon_sym_DOLLAR,
    ACTIONS(882), 1,
      sym__special_character,
    ACTIONS(885), 1,
      anon_sym_DQUOTE,
    ACTIONS(888), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(891), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(894), 1,
      anon_sym_BQUOTE,
    STATE(216), 1,
      aux_sym_command_repeat2,
    STATE(454), 1,
      aux_sym__literal_repeat1,
    STATE(670), 1,
      sym_concatenation,
    ACTIONS(876), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(897), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(873), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(355), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(654), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4057] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 1,
      anon_sym_DQUOTE,
    ACTIONS(902), 1,
      sym_raw_string,
    ACTIONS(904), 1,
      aux_sym__simple_variable_name_token1,
    STATE(483), 1,
      sym_string,
    ACTIONS(553), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(900), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(545), 29,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [4119] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(261), 42,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [4171] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(107), 1,
      anon_sym_BQUOTE,
    ACTIONS(649), 1,
      sym_file_descriptor,
    STATE(224), 1,
      aux_sym_command_repeat2,
    STATE(734), 1,
      aux_sym__literal_repeat1,
    STATE(767), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(908), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(906), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(477), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(647), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4248] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 1,
      sym_file_descriptor,
    ACTIONS(912), 1,
      anon_sym_DOLLAR,
    ACTIONS(914), 1,
      sym__special_character,
    ACTIONS(916), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(920), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(922), 1,
      anon_sym_BQUOTE,
    ACTIONS(926), 1,
      aux_sym__simple_variable_name_token1,
    STATE(745), 1,
      aux_sym__literal_repeat1,
    ACTIONS(924), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(221), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(910), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(465), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(784), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4323] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      sym_file_descriptor,
    ACTIONS(912), 1,
      anon_sym_DOLLAR,
    ACTIONS(914), 1,
      sym__special_character,
    ACTIONS(916), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(920), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(922), 1,
      anon_sym_BQUOTE,
    ACTIONS(928), 1,
      aux_sym__simple_variable_name_token1,
    STATE(745), 1,
      aux_sym__literal_repeat1,
    ACTIONS(924), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(222), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(910), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(465), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(814), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4398] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(871), 1,
      sym_file_descriptor,
    ACTIONS(933), 1,
      anon_sym_DOLLAR,
    ACTIONS(936), 1,
      sym__special_character,
    ACTIONS(939), 1,
      anon_sym_DQUOTE,
    ACTIONS(942), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(945), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(948), 1,
      anon_sym_BQUOTE,
    ACTIONS(954), 1,
      aux_sym__simple_variable_name_token1,
    STATE(745), 1,
      aux_sym__literal_repeat1,
    ACTIONS(951), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(222), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(930), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(465), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(845), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4473] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(107), 1,
      anon_sym_BQUOTE,
    ACTIONS(694), 1,
      sym_file_descriptor,
    STATE(219), 1,
      aux_sym_command_repeat2,
    STATE(734), 1,
      aux_sym__literal_repeat1,
    STATE(767), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(908), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(906), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(477), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(692), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4550] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 1,
      sym_file_descriptor,
    ACTIONS(963), 1,
      anon_sym_DOLLAR,
    ACTIONS(966), 1,
      sym__special_character,
    ACTIONS(969), 1,
      anon_sym_DQUOTE,
    ACTIONS(972), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(975), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(978), 1,
      anon_sym_BQUOTE,
    STATE(224), 1,
      aux_sym_command_repeat2,
    STATE(734), 1,
      aux_sym__literal_repeat1,
    STATE(767), 1,
      sym_concatenation,
    ACTIONS(960), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(981), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(957), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(477), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(654), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4627] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(553), 1,
      sym_file_descriptor,
    ACTIONS(916), 1,
      anon_sym_DQUOTE,
    ACTIONS(986), 1,
      sym_raw_string,
    ACTIONS(988), 1,
      aux_sym__simple_variable_name_token1,
    STATE(647), 1,
      sym_string,
    ACTIONS(984), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(545), 29,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [4688] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      anon_sym_DOLLAR,
    ACTIONS(41), 1,
      sym__special_character,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(49), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(51), 1,
      anon_sym_BQUOTE,
    STATE(236), 1,
      aux_sym_command_repeat2,
    STATE(645), 1,
      aux_sym__literal_repeat1,
    STATE(836), 1,
      sym_concatenation,
    ACTIONS(53), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(649), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(992), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(990), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(500), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(647), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4765] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      anon_sym_DOLLAR,
    ACTIONS(41), 1,
      sym__special_character,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(49), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(51), 1,
      anon_sym_BQUOTE,
    STATE(226), 1,
      aux_sym_command_repeat2,
    STATE(645), 1,
      aux_sym__literal_repeat1,
    STATE(836), 1,
      sym_concatenation,
    ACTIONS(53), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(694), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(992), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(990), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(500), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(692), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4842] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(107), 1,
      anon_sym_BQUOTE,
    ACTIONS(619), 1,
      sym_file_descriptor,
    STATE(224), 1,
      aux_sym_command_repeat2,
    STATE(734), 1,
      aux_sym__literal_repeat1,
    STATE(767), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(908), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(906), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(477), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(615), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4919] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(629), 1,
      anon_sym_DQUOTE,
    ACTIONS(996), 1,
      sym_raw_string,
    ACTIONS(998), 1,
      aux_sym__simple_variable_name_token1,
    STATE(620), 1,
      sym_string,
    ACTIONS(553), 3,
      sym_file_descriptor,
      sym_variable_name,
      ts_builtin_sym_end,
    ACTIONS(994), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(545), 27,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [4980] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1002), 1,
      anon_sym_DQUOTE,
    ACTIONS(1004), 1,
      sym_raw_string,
    ACTIONS(1006), 1,
      aux_sym__simple_variable_name_token1,
    STATE(844), 1,
      sym_string,
    ACTIONS(553), 3,
      sym_file_descriptor,
      sym_variable_name,
      ts_builtin_sym_end,
    ACTIONS(1000), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(545), 27,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [5041] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(593), 1,
      anon_sym_DQUOTE,
    ACTIONS(1010), 1,
      sym_raw_string,
    ACTIONS(1012), 1,
      aux_sym__simple_variable_name_token1,
    STATE(575), 1,
      sym_string,
    ACTIONS(553), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(1008), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(545), 28,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [5102] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1016), 1,
      anon_sym_DQUOTE,
    ACTIONS(1018), 1,
      sym_raw_string,
    ACTIONS(1020), 1,
      aux_sym__simple_variable_name_token1,
    STATE(832), 1,
      sym_string,
    ACTIONS(553), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(1014), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(545), 28,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [5163] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      anon_sym_DOLLAR,
    ACTIONS(41), 1,
      sym__special_character,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(49), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(51), 1,
      anon_sym_BQUOTE,
    STATE(236), 1,
      aux_sym_command_repeat2,
    STATE(645), 1,
      aux_sym__literal_repeat1,
    STATE(836), 1,
      sym_concatenation,
    ACTIONS(53), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(619), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(992), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(990), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(500), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(615), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5240] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      anon_sym_DOLLAR,
    ACTIONS(41), 1,
      sym__special_character,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(49), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(51), 1,
      anon_sym_BQUOTE,
    STATE(233), 1,
      aux_sym_command_repeat2,
    STATE(645), 1,
      aux_sym__literal_repeat1,
    STATE(836), 1,
      sym_concatenation,
    ACTIONS(53), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(645), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(992), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(990), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(500), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(643), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5317] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(107), 1,
      anon_sym_BQUOTE,
    ACTIONS(645), 1,
      sym_file_descriptor,
    STATE(228), 1,
      aux_sym_command_repeat2,
    STATE(734), 1,
      aux_sym__literal_repeat1,
    STATE(767), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(908), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(906), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(477), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(643), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5394] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_DOLLAR,
    ACTIONS(1031), 1,
      sym__special_character,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1037), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1040), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1043), 1,
      anon_sym_BQUOTE,
    STATE(236), 1,
      aux_sym_command_repeat2,
    STATE(645), 1,
      aux_sym__literal_repeat1,
    STATE(836), 1,
      sym_concatenation,
    ACTIONS(680), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(1025), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(1046), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(1022), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(500), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(654), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5471] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1052), 1,
      anon_sym_DOLLAR,
    ACTIONS(1055), 1,
      sym__special_character,
    ACTIONS(1058), 1,
      anon_sym_DQUOTE,
    ACTIONS(1061), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1064), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1067), 1,
      anon_sym_BQUOTE,
    ACTIONS(1073), 1,
      aux_sym__simple_variable_name_token1,
    STATE(820), 1,
      aux_sym__literal_repeat1,
    ACTIONS(871), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(1070), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(237), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1049), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(659), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(845), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5545] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(871), 1,
      sym_file_descriptor,
    ACTIONS(1079), 1,
      anon_sym_DOLLAR,
    ACTIONS(1082), 1,
      sym__special_character,
    ACTIONS(1085), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1091), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1094), 1,
      anon_sym_BQUOTE,
    ACTIONS(1100), 1,
      aux_sym__simple_variable_name_token1,
    STATE(794), 1,
      aux_sym__literal_repeat1,
    ACTIONS(1097), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(238), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1076), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(671), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(845), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5619] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      ts_builtin_sym_end,
    ACTIONS(611), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(607), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [5671] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(804), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [5721] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1107), 1,
      anon_sym_DOLLAR,
    ACTIONS(1109), 1,
      sym__special_character,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1115), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1117), 1,
      anon_sym_BQUOTE,
    ACTIONS(1121), 1,
      aux_sym__simple_variable_name_token1,
    STATE(820), 1,
      aux_sym__literal_repeat1,
    ACTIONS(802), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(1119), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(253), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1105), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(659), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(784), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5795] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(694), 1,
      sym_file_descriptor,
    STATE(249), 1,
      aux_sym_command_repeat2,
    STATE(734), 1,
      aux_sym__literal_repeat1,
    STATE(767), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(908), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(906), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(477), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(692), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [5869] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(553), 1,
      sym_file_descriptor,
    ACTIONS(1125), 1,
      anon_sym_DQUOTE,
    ACTIONS(1127), 1,
      sym_raw_string,
    ACTIONS(1129), 1,
      aux_sym__simple_variable_name_token1,
    STATE(752), 1,
      sym_string,
    ACTIONS(1123), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(545), 28,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [5929] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1133), 1,
      sym_raw_string,
    ACTIONS(1135), 1,
      aux_sym__simple_variable_name_token1,
    STATE(760), 1,
      sym_string,
    ACTIONS(553), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(1131), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(545), 27,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [5989] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(804), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_done,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [6039] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 1,
      ts_builtin_sym_end,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [6091] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      sym_file_descriptor,
    ACTIONS(1125), 1,
      anon_sym_DQUOTE,
    ACTIONS(1139), 1,
      anon_sym_DOLLAR,
    ACTIONS(1141), 1,
      sym__special_character,
    ACTIONS(1143), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1145), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1147), 1,
      anon_sym_BQUOTE,
    ACTIONS(1151), 1,
      aux_sym__simple_variable_name_token1,
    STATE(794), 1,
      aux_sym__literal_repeat1,
    ACTIONS(1149), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(238), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1137), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(671), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(814), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [6165] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(261), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [6215] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(649), 1,
      sym_file_descriptor,
    STATE(224), 1,
      aux_sym_command_repeat2,
    STATE(734), 1,
      aux_sym__literal_repeat1,
    STATE(767), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(908), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(906), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(477), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(647), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [6289] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(645), 1,
      sym_file_descriptor,
    STATE(252), 1,
      aux_sym_command_repeat2,
    STATE(734), 1,
      aux_sym__literal_repeat1,
    STATE(767), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(908), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(906), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(477), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(643), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [6363] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1153), 1,
      ts_builtin_sym_end,
    ACTIONS(611), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(607), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [6415] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(619), 1,
      sym_file_descriptor,
    STATE(224), 1,
      aux_sym_command_repeat2,
    STATE(734), 1,
      aux_sym__literal_repeat1,
    STATE(767), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(908), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(906), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(477), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(615), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [6489] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1107), 1,
      anon_sym_DOLLAR,
    ACTIONS(1109), 1,
      sym__special_character,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1115), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1117), 1,
      anon_sym_BQUOTE,
    ACTIONS(1155), 1,
      aux_sym__simple_variable_name_token1,
    STATE(820), 1,
      aux_sym__literal_repeat1,
    ACTIONS(818), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(1119), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(237), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1105), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(659), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(814), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [6563] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(804), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [6613] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(261), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [6663] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(261), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_done,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [6713] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 1,
      ts_builtin_sym_end,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [6765] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 1,
      sym_file_descriptor,
    ACTIONS(1125), 1,
      anon_sym_DQUOTE,
    ACTIONS(1139), 1,
      anon_sym_DOLLAR,
    ACTIONS(1141), 1,
      sym__special_character,
    ACTIONS(1143), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1145), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1147), 1,
      anon_sym_BQUOTE,
    ACTIONS(1157), 1,
      aux_sym__simple_variable_name_token1,
    STATE(794), 1,
      aux_sym__literal_repeat1,
    ACTIONS(1149), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(247), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1137), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(671), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(784), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [6839] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 1,
      sym_file_descriptor,
    ACTIONS(1125), 1,
      anon_sym_DQUOTE,
    ACTIONS(1139), 1,
      anon_sym_DOLLAR,
    ACTIONS(1141), 1,
      sym__special_character,
    ACTIONS(1143), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1145), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1159), 1,
      aux_sym__simple_variable_name_token1,
    STATE(794), 1,
      aux_sym__literal_repeat1,
    ACTIONS(1149), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(265), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1137), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(671), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(784), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [6910] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(609), 1,
      anon_sym_BQUOTE,
    ACTIONS(611), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(607), 38,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [6961] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      anon_sym_BQUOTE,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 38,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [7012] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [7061] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(621), 1,
      anon_sym_BQUOTE,
    ACTIONS(611), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(607), 38,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [7112] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(611), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(607), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [7161] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      sym_file_descriptor,
    ACTIONS(1125), 1,
      anon_sym_DQUOTE,
    ACTIONS(1139), 1,
      anon_sym_DOLLAR,
    ACTIONS(1141), 1,
      sym__special_character,
    ACTIONS(1143), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1145), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1151), 1,
      aux_sym__simple_variable_name_token1,
    STATE(794), 1,
      aux_sym__literal_repeat1,
    ACTIONS(1149), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(238), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1137), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(671), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(814), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [7232] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(55), 1,
      sym_file_descriptor,
    ACTIONS(65), 1,
      anon_sym_LPAREN_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(87), 1,
      anon_sym_LBRACK,
    ACTIONS(89), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(107), 1,
      anon_sym_BQUOTE,
    ACTIONS(1161), 1,
      sym_word,
    ACTIONS(1163), 1,
      sym_variable_name,
    STATE(223), 1,
      sym_command_name,
    STATE(661), 1,
      aux_sym__literal_repeat1,
    STATE(817), 1,
      sym_concatenation,
    STATE(3263), 1,
      sym_subscript,
    ACTIONS(101), 2,
      sym_raw_string,
      sym_ansii_c_string,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(816), 3,
      sym_variable_assignment,
      sym_file_redirect,
      aux_sym_command_repeat1,
    STATE(2076), 3,
      sym_subshell,
      sym_test_command,
      sym_command,
    STATE(442), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(37), 8,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
  [7323] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(55), 1,
      sym_file_descriptor,
    ACTIONS(129), 1,
      anon_sym_LPAREN_LPAREN,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(151), 1,
      anon_sym_LBRACK,
    ACTIONS(153), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(215), 1,
      anon_sym_DOLLAR,
    ACTIONS(217), 1,
      sym__special_character,
    ACTIONS(219), 1,
      anon_sym_DQUOTE,
    ACTIONS(223), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(225), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(227), 1,
      anon_sym_BQUOTE,
    ACTIONS(1163), 1,
      sym_variable_name,
    ACTIONS(1165), 1,
      sym_word,
    STATE(200), 1,
      sym_command_name,
    STATE(469), 1,
      aux_sym__literal_repeat1,
    STATE(736), 1,
      sym_concatenation,
    STATE(3263), 1,
      sym_subscript,
    ACTIONS(221), 2,
      sym_raw_string,
      sym_ansii_c_string,
    ACTIONS(229), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(771), 3,
      sym_variable_assignment,
      sym_file_redirect,
      aux_sym_command_repeat1,
    STATE(1863), 3,
      sym_subshell,
      sym_test_command,
      sym_command,
    STATE(349), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(37), 8,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
  [7414] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_BQUOTE,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 38,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [7465] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(55), 1,
      sym_file_descriptor,
    ACTIONS(129), 1,
      anon_sym_LPAREN_LPAREN,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(151), 1,
      anon_sym_LBRACK,
    ACTIONS(153), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(159), 1,
      anon_sym_DOLLAR,
    ACTIONS(161), 1,
      sym__special_character,
    ACTIONS(163), 1,
      anon_sym_DQUOTE,
    ACTIONS(167), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(169), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(171), 1,
      anon_sym_BQUOTE,
    ACTIONS(1163), 1,
      sym_variable_name,
    ACTIONS(1167), 1,
      sym_word,
    STATE(186), 1,
      sym_command_name,
    STATE(313), 1,
      aux_sym__literal_repeat1,
    STATE(536), 1,
      sym_concatenation,
    STATE(3263), 1,
      sym_subscript,
    ACTIONS(165), 2,
      sym_raw_string,
      sym_ansii_c_string,
    ACTIONS(173), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(831), 3,
      sym_variable_assignment,
      sym_file_redirect,
      aux_sym_command_repeat1,
    STATE(1863), 3,
      sym_subshell,
      sym_test_command,
      sym_command,
    STATE(278), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(37), 8,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
  [7556] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(39), 1,
      anon_sym_DOLLAR,
    ACTIONS(41), 1,
      sym__special_character,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(49), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(51), 1,
      anon_sym_BQUOTE,
    ACTIONS(55), 1,
      sym_file_descriptor,
    ACTIONS(1163), 1,
      sym_variable_name,
    ACTIONS(1169), 1,
      sym_word,
    STATE(227), 1,
      sym_command_name,
    STATE(735), 1,
      aux_sym__literal_repeat1,
    STATE(757), 1,
      sym_concatenation,
    STATE(3263), 1,
      sym_subscript,
    ACTIONS(45), 2,
      sym_raw_string,
      sym_ansii_c_string,
    ACTIONS(53), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(763), 3,
      sym_variable_assignment,
      sym_file_redirect,
      aux_sym_command_repeat1,
    STATE(2097), 3,
      sym_subshell,
      sym_test_command,
      sym_command,
    STATE(526), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(37), 8,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
  [7647] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(55), 1,
      sym_file_descriptor,
    ACTIONS(65), 1,
      anon_sym_LPAREN_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(87), 1,
      anon_sym_LBRACK,
    ACTIONS(89), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(107), 1,
      anon_sym_BQUOTE,
    ACTIONS(1161), 1,
      sym_word,
    ACTIONS(1163), 1,
      sym_variable_name,
    STATE(242), 1,
      sym_command_name,
    STATE(661), 1,
      aux_sym__literal_repeat1,
    STATE(817), 1,
      sym_concatenation,
    STATE(3263), 1,
      sym_subscript,
    ACTIONS(101), 2,
      sym_raw_string,
      sym_ansii_c_string,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(819), 3,
      sym_variable_assignment,
      sym_file_redirect,
      aux_sym_command_repeat1,
    STATE(2076), 3,
      sym_subshell,
      sym_test_command,
      sym_command,
    STATE(442), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(37), 8,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
  [7738] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1175), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(1177), 2,
      sym_file_descriptor,
      sym_variable_name,
    STATE(1650), 4,
      sym_file_redirect,
      sym_heredoc_redirect,
      sym_herestring_redirect,
      aux_sym_redirected_statement_repeat1,
    ACTIONS(1173), 12,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
    ACTIONS(1171), 19,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [7791] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1179), 1,
      anon_sym_LF,
    ACTIONS(1187), 1,
      anon_sym_LT_LT_LT,
    ACTIONS(1175), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(1177), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(1181), 2,
      anon_sym_SEMI,
      anon_sym_AMP,
    ACTIONS(1183), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(1185), 2,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
    ACTIONS(445), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    STATE(1650), 4,
      sym_file_redirect,
      sym_heredoc_redirect,
      sym_herestring_redirect,
      aux_sym_redirected_statement_repeat1,
    ACTIONS(1171), 19,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [7854] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1187), 1,
      anon_sym_LT_LT_LT,
    ACTIONS(1189), 1,
      anon_sym_LF,
    ACTIONS(1175), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(1177), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(1183), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(1185), 2,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
    ACTIONS(1191), 2,
      anon_sym_SEMI,
      anon_sym_AMP,
    ACTIONS(1193), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    STATE(1650), 4,
      sym_file_redirect,
      sym_heredoc_redirect,
      sym_herestring_redirect,
      aux_sym_redirected_statement_repeat1,
    ACTIONS(1171), 19,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [7917] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1199), 1,
      sym_file_descriptor,
    ACTIONS(1201), 1,
      sym__concat,
    STATE(281), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1195), 35,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [7970] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1177), 1,
      sym_variable_name,
    ACTIONS(1205), 1,
      sym_file_descriptor,
    STATE(1650), 4,
      sym_file_redirect,
      sym_heredoc_redirect,
      sym_herestring_redirect,
      aux_sym_redirected_statement_repeat1,
    ACTIONS(1171), 11,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
    ACTIONS(1203), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [8023] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1211), 1,
      sym__concat,
    STATE(283), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1209), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(1207), 34,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      aux_sym__simple_variable_name_token1,
      sym_word,
      anon_sym_AMP,
  [8073] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1199), 1,
      sym_file_descriptor,
    ACTIONS(1201), 1,
      sym__concat,
    STATE(281), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1195), 35,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [8123] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1201), 1,
      sym__concat,
    ACTIONS(1215), 1,
      sym_file_descriptor,
    STATE(281), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1213), 35,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [8173] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1177), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(1217), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    STATE(1660), 4,
      sym_file_redirect,
      sym_heredoc_redirect,
      sym_herestring_redirect,
      aux_sym_redirected_statement_repeat1,
    ACTIONS(1173), 11,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
    ACTIONS(1171), 19,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [8225] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1221), 1,
      sym_file_descriptor,
    ACTIONS(1223), 1,
      sym__concat,
    STATE(282), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1219), 35,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [8275] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1227), 1,
      sym_file_descriptor,
    ACTIONS(1229), 1,
      sym__concat,
    STATE(282), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1225), 35,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [8325] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1232), 1,
      sym__concat,
    STATE(287), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1221), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(1219), 34,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      aux_sym__simple_variable_name_token1,
      sym_word,
      anon_sym_AMP,
  [8375] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1177), 1,
      sym_variable_name,
    ACTIONS(1205), 1,
      sym_file_descriptor,
    STATE(1660), 4,
      sym_file_redirect,
      sym_heredoc_redirect,
      sym_herestring_redirect,
      aux_sym_redirected_statement_repeat1,
    ACTIONS(1171), 11,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
    ACTIONS(1203), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [8427] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1234), 1,
      anon_sym_LF,
    ACTIONS(1240), 1,
      anon_sym_LT_LT_LT,
    ACTIONS(1177), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(1185), 2,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
    ACTIONS(1217), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(1236), 2,
      anon_sym_SEMI,
      anon_sym_AMP,
    ACTIONS(1238), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(445), 3,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    STATE(1660), 4,
      sym_file_redirect,
      sym_heredoc_redirect,
      sym_herestring_redirect,
      aux_sym_redirected_statement_repeat1,
    ACTIONS(1171), 19,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [8489] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1199), 1,
      sym_file_descriptor,
    ACTIONS(1242), 1,
      sym__concat,
    STATE(364), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1195), 34,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [8541] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1244), 1,
      sym__concat,
    STATE(287), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1227), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(1225), 34,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      aux_sym__simple_variable_name_token1,
      sym_word,
      anon_sym_AMP,
  [8591] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1201), 1,
      sym__concat,
    ACTIONS(1249), 1,
      sym_file_descriptor,
    STATE(281), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1247), 35,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [8641] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1201), 1,
      sym__concat,
    ACTIONS(1253), 1,
      sym_file_descriptor,
    STATE(281), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1251), 35,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [8691] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1211), 1,
      sym__concat,
    STATE(283), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1249), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(1247), 34,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      aux_sym__simple_variable_name_token1,
      sym_word,
      anon_sym_AMP,
  [8741] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1211), 1,
      sym__concat,
    STATE(283), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1257), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(1255), 34,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      aux_sym__simple_variable_name_token1,
      sym_word,
      anon_sym_AMP,
  [8791] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_LT_LT_LT,
    ACTIONS(1259), 1,
      anon_sym_LF,
    ACTIONS(1177), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(1185), 2,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
    ACTIONS(1217), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(1238), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(1261), 2,
      anon_sym_SEMI,
      anon_sym_AMP,
    ACTIONS(1193), 3,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    STATE(1660), 4,
      sym_file_redirect,
      sym_heredoc_redirect,
      sym_herestring_redirect,
      aux_sym_redirected_statement_repeat1,
    ACTIONS(1171), 19,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [8853] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1227), 3,
      sym_file_descriptor,
      sym__concat,
      sym_variable_name,
    ACTIONS(1225), 34,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      aux_sym__simple_variable_name_token1,
      sym_word,
      anon_sym_AMP,
  [8898] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1265), 2,
      sym_file_descriptor,
      sym__concat,
    ACTIONS(1263), 35,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [8943] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1267), 1,
      sym__concat,
    STATE(345), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1249), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(1247), 33,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      aux_sym__simple_variable_name_token1,
      sym_word,
      anon_sym_AMP,
  [8992] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1271), 1,
      sym_file_descriptor,
    ACTIONS(1273), 1,
      sym__concat,
    STATE(362), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1269), 34,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      aux_sym__simple_variable_name_token1,
      sym_word,
      anon_sym_AMP,
  [9041] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1249), 1,
      sym_file_descriptor,
    ACTIONS(1273), 1,
      sym__concat,
    STATE(362), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1247), 34,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      aux_sym__simple_variable_name_token1,
      sym_word,
      anon_sym_AMP,
  [9090] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1277), 3,
      sym_file_descriptor,
      sym__concat,
      sym_variable_name,
    ACTIONS(1275), 34,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      aux_sym__simple_variable_name_token1,
      sym_word,
      anon_sym_AMP,
  [9135] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1281), 3,
      sym_file_descriptor,
      sym__concat,
      sym_variable_name,
    ACTIONS(1279), 34,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      aux_sym__simple_variable_name_token1,
      sym_word,
      anon_sym_AMP,
  [9180] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1285), 3,
      sym_file_descriptor,
      sym__concat,
      sym_variable_name,
    ACTIONS(1283), 34,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      aux_sym__simple_variable_name_token1,
      sym_word,
      anon_sym_AMP,
  [9225] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1289), 3,
      sym_file_descriptor,
      sym__concat,
      sym_variable_name,
    ACTIONS(1287), 34,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      aux_sym__simple_variable_name_token1,
      sym_word,
      anon_sym_AMP,
  [9270] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1293), 3,
      sym_file_descriptor,
      sym__concat,
      sym_variable_name,
    ACTIONS(1291), 34,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      aux_sym__simple_variable_name_token1,
      sym_word,
      anon_sym_AMP,
  [9315] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1297), 3,
      sym_file_descriptor,
      sym__concat,
      sym_variable_name,
    ACTIONS(1295), 34,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_s