// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!
import Foundation

// Depending on the consumer's build setup, the low-level FFI code
// might be in a separate module, or it might be compiled inline into
// this module. This is a bit of light hackery to work with both.
#if canImport(didcommFFI)
import didcommFFI
#endif

fileprivate extension RustBuffer {
    // Allocate a new buffer, copying the contents of a `UInt8` array.
    init(bytes: [UInt8]) {
        let rbuf = bytes.withUnsafeBufferPointer { ptr in
            RustBuffer.from(ptr)
        }
        self.init(capacity: rbuf.capacity, len: rbuf.len, data: rbuf.data)
    }

    static func from(_ ptr: UnsafeBufferPointer<UInt8>) -> RustBuffer {
        try! rustCall { ffi_didcomm_7b5e_rustbuffer_from_bytes(ForeignBytes(bufferPointer: ptr), $0) }
    }

    // Frees the buffer in place.
    // The buffer must not be used after this is called.
    func deallocate() {
        try! rustCall { ffi_didcomm_7b5e_rustbuffer_free(self, $0) }
    }
}

fileprivate extension ForeignBytes {
    init(bufferPointer: UnsafeBufferPointer<UInt8>) {
        self.init(len: Int32(bufferPointer.count), data: bufferPointer.baseAddress)
    }
}

// For every type used in the interface, we provide helper methods for conveniently
// lifting and lowering that type from C-compatible data, and for reading and writing
// values of that type in a buffer.

// Helper classes/extensions that don't change.
// Someday, this will be in a libray of its own.

fileprivate extension Data {
    init(rustBuffer: RustBuffer) {
        // TODO: This copies the buffer. Can we read directly from a
        // Rust buffer?
        self.init(bytes: rustBuffer.data!, count: Int(rustBuffer.len))
    }
}

// A helper class to read values out of a byte buffer.
fileprivate class Reader {
    let data: Data
    var offset: Data.Index

    init(data: Data) {
        self.data = data
        self.offset = 0
    }

    // Reads an integer at the current offset, in big-endian order, and advances
    // the offset on success. Throws if reading the integer would move the
    // offset past the end of the buffer.
    func readInt<T: FixedWidthInteger>() throws -> T {
        let range = offset..<offset + MemoryLayout<T>.size
        guard data.count >= range.upperBound else {
            throw UniffiInternalError.bufferOverflow
        }
        if T.self == UInt8.self {
            let value = data[offset]
            offset += 1
            return value as! T
        }
        var value: T = 0
        let _ = withUnsafeMutableBytes(of: &value, { data.copyBytes(to: $0, from: range)})
        offset = range.upperBound
        return value.bigEndian
    }

    // Reads an arbitrary number of bytes, to be used to read
    // raw bytes, this is useful when lifting strings
    func readBytes(count: Int) throws -> Array<UInt8> {
        let range = offset..<(offset+count)
        guard data.count >= range.upperBound else {
            throw UniffiInternalError.bufferOverflow
        }
        var value = [UInt8](repeating: 0, count: count)
        value.withUnsafeMutableBufferPointer({ buffer in
            data.copyBytes(to: buffer, from: range)
        })
        offset = range.upperBound
        return value
    }

    // Reads a float at the current offset.
    @inlinable
    func readFloat() throws -> Float {
        return Float(bitPattern: try readInt())
    }

    // Reads a float at the current offset.
    @inlinable
    func readDouble() throws -> Double {
        return Double(bitPattern: try readInt())
    }

    // Indicates if the offset has reached the end of the buffer.
    @inlinable
    func hasRemaining() -> Bool {
        return offset < data.count
    }
}

// A helper class to write values into a byte buffer.
fileprivate class Writer {
    var bytes: [UInt8]
    var offset: Array<UInt8>.Index

    init() {
        self.bytes = []
        self.offset = 0
    }

    func writeBytes<S>(_ byteArr: S) where S: Sequence, S.Element == UInt8 {
        bytes.append(contentsOf: byteArr)
    }

    // Writes an integer in big-endian order.
    //
    // Warning: make sure what you are trying to write
    // is in the correct type!
    func writeInt<T: FixedWidthInteger>(_ value: T) {
        var value = value.bigEndian
        withUnsafeBytes(of: &value) { bytes.append(contentsOf: $0) }
    }

    @inlinable
    func writeFloat(_ value: Float) {
        writeInt(value.bitPattern)
    }

    @inlinable
    func writeDouble(_ value: Double) {
        writeInt(value.bitPattern)
    }
}


// Types conforming to `Serializable` can be read and written in a bytebuffer.
fileprivate protocol Serializable {
    func write(into: Writer)
    static func read(from: Reader) throws -> Self
}

// Types confirming to `ViaFfi` can be transferred back-and-for over the FFI.
// This is analogous to the Rust trait of the same name.
fileprivate protocol ViaFfi: Serializable {
    associatedtype FfiType
    static func lift(_ v: FfiType) throws -> Self
    func lower() -> FfiType
}

// Types conforming to `Primitive` pass themselves directly over the FFI.
fileprivate protocol Primitive {}

extension Primitive {
    fileprivate typealias FfiType = Self

    fileprivate static func lift(_ v: Self) throws -> Self {
        return v
    }

    fileprivate func lower() -> Self {
        return self
    }
}

// Types conforming to `ViaFfiUsingByteBuffer` lift and lower into a bytebuffer.
// Use this for complex types where it's hard to write a custom lift/lower.
fileprivate protocol ViaFfiUsingByteBuffer: Serializable {}

extension ViaFfiUsingByteBuffer {
    fileprivate typealias FfiType = RustBuffer

    fileprivate static func lift(_ buf: FfiType) throws -> Self {
      let reader = Reader(data: Data(rustBuffer: buf))
      let value = try Self.read(from: reader)
      if reader.hasRemaining() {
          throw UniffiInternalError.incompleteData
      }
      buf.deallocate()
      return value
    }

    fileprivate func lower() -> FfiType {
      let writer = Writer()
      self.write(into: writer)
      return RustBuffer(bytes: writer.bytes)
    }
}
// An error type for FFI errors. These errors occur at the UniFFI level, not
// the library level.
fileprivate enum UniffiInternalError: LocalizedError {
    case bufferOverflow
    case incompleteData
    case unexpectedOptionalTag
    case unexpectedEnumCase
    case unexpectedNullPointer
    case unexpectedRustCallStatusCode
    case unexpectedRustCallError
    case unexpectedStaleHandle
    case rustPanic(_ message: String)

    public var errorDescription: String? {
        switch self {
        case .bufferOverflow: return "Reading the requested value would read past the end of the buffer"
        case .incompleteData: return "The buffer still has data after lifting its containing value"
        case .unexpectedOptionalTag: return "Unexpected optional tag; should be 0 or 1"
        case .unexpectedEnumCase: return "Raw enum value doesn't match any cases"
        case .unexpectedNullPointer: return "Raw pointer value was null"
        case .unexpectedRustCallStatusCode: return "Unexpected RustCallStatus code"
        case .unexpectedRustCallError: return "CALL_ERROR but no errorClass specified"
        case .unexpectedStaleHandle: return "The object in the handle map has been dropped already"
        case let .rustPanic(message): return message
        }
    }
}

fileprivate let CALL_SUCCESS: Int8 = 0
fileprivate let CALL_ERROR: Int8 = 1
fileprivate let CALL_PANIC: Int8 = 2

fileprivate extension RustCallStatus {
    init() {
        self.init(
            code: CALL_SUCCESS,
            errorBuf: RustBuffer.init(
                capacity: 0,
                len: 0,
                data: nil
            )
        )
    }
}

private func rustCall<T>(_ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    try makeRustCall(callback, errorHandler: {
        $0.deallocate()
        return UniffiInternalError.unexpectedRustCallError
    })
}

private func rustCallWithError<T, E: ViaFfiUsingByteBuffer & Error>(_ errorClass: E.Type, _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    try makeRustCall(callback, errorHandler: { return try E.lift($0) })
}

private func makeRustCall<T>(_ callback: (UnsafeMutablePointer<RustCallStatus>) -> T, errorHandler: (RustBuffer) throws -> Error) throws -> T {
    var callStatus = RustCallStatus.init()
    let returnedVal = callback(&callStatus)
    switch callStatus.code {
        case CALL_SUCCESS:
            return returnedVal

        case CALL_ERROR:
            throw try errorHandler(callStatus.errorBuf)

        case CALL_PANIC:
            // When the rust code sees a panic, it tries to construct a RustBuffer
            // with the message.  But if that code panics, then it just sends back
            // an empty buffer.
            if callStatus.errorBuf.len > 0 {
                throw UniffiInternalError.rustPanic(try String.lift(callStatus.errorBuf))
            } else {
                callStatus.errorBuf.deallocate()
                throw UniffiInternalError.rustPanic("Rust panic")
            }

        default:
            throw UniffiInternalError.unexpectedRustCallStatusCode
    }
}
// Protocols for converters we'll implement in templates

fileprivate protocol FfiConverter {
    associatedtype SwiftType
    associatedtype FfiType

    static func lift(_ ffiValue: FfiType) throws -> SwiftType
    static func lower(_ value: SwiftType) -> FfiType

    static func read(from: Reader) throws -> SwiftType
    static func write(_ value: SwiftType, into: Writer)
}

fileprivate protocol FfiConverterUsingByteBuffer: FfiConverter where FfiType == RustBuffer {
    // Empty, because we want to declare some helper methods in the extension below.
}

extension FfiConverterUsingByteBuffer {
    static func lower(_ value: SwiftType) -> FfiType {
        let writer = Writer()
        Self.write(value, into: writer)
        return RustBuffer(bytes: writer.bytes)
    }

    static func lift(_ buf: FfiType) throws -> SwiftType {
        let reader = Reader(data: Data(rustBuffer: buf))
        let value = try Self.read(from: reader)
        if reader.hasRemaining() {
          throw UniffiInternalError.incompleteData
        }
        buf.deallocate()
        return value
    }
}

// Helpers for structural types. Note that because of canonical_names, it /should/ be impossible
// to make another `FfiConverterSequence` etc just using the UDL.
fileprivate enum FfiConverterSequence {
    static func write<T>(_ value: [T], into buf: Writer, writeItem: (T, Writer) -> Void) {
        let len = Int32(value.count)
        buf.writeInt(len)
        for item in value {
            writeItem(item, buf)
        }
    }

    static func read<T>(from buf: Reader, readItem: (Reader) throws -> T) throws -> [T] {
        let len: Int32 = try buf.readInt()
        var seq = [T]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try readItem(buf))
        }
        return seq
    }
}

fileprivate enum FfiConverterOptional {
    static func write<T>(_ value: T?, into buf: Writer, writeItem: (T, Writer) -> Void) {
        guard let value = value else {
            buf.writeInt(Int8(0))
            return
        }
        buf.writeInt(Int8(1))
        writeItem(value, buf)
    }

    static func read<T>(from buf: Reader, readItem: (Reader) throws -> T) throws -> T? {
        switch try buf.readInt() as Int8 {
        case 0: return nil
        case 1: return try readItem(buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

fileprivate enum FfiConverterDictionary {
    static func write<T>(_ value: [String: T], into buf: Writer, writeItem: (String, T, Writer) -> Void) {
        let len = Int32(value.count)
        buf.writeInt(len)
        for (key, value) in value {
            writeItem(key, value, buf)
        }
    }

    static func read<T>(from buf: Reader, readItem: (Reader) throws -> (String, T)) throws -> [String: T] {
        let len: Int32 = try buf.readInt()
        var dict = [String: T]()
        dict.reserveCapacity(Int(len))
        for _ in 0..<len {
            let (key, value) = try readItem(buf)
            dict[key] = value
        }
        return dict
    }
}

// Public interface members begin here.


fileprivate extension NSLock {
    func withLock<T>(f: () throws -> T) rethrows -> T {
        self.lock()
        defer { self.unlock() }
        return try f()
    }
}

fileprivate typealias Handle = UInt64
fileprivate class ConcurrentHandleMap<T> {
    private var leftMap: [Handle: T] = [:]
    private var counter: [Handle: UInt64] = [:]
    private var rightMap: [ObjectIdentifier: Handle] = [:]

    private let lock = NSLock()
    private var currentHandle: Handle = 0
    private let stride: Handle = 1

    func insert(obj: T) -> Handle {
        lock.withLock {
            let id = ObjectIdentifier(obj as AnyObject)
            let handle = rightMap[id] ?? {
                currentHandle += stride
                let handle = currentHandle
                leftMap[handle] = obj
                rightMap[id] = handle
                return handle
            }()
            counter[handle] = (counter[handle] ?? 0) + 1
            return handle
        }
    }

    func get(handle: Handle) -> T? {
        lock.withLock {
            leftMap[handle]
        }
    }

    func delete(handle: Handle) {
        remove(handle: handle)
    }

    @discardableResult
    func remove(handle: Handle) -> T? {
        lock.withLock {
            defer { counter[handle] = (counter[handle] ?? 1) - 1 }
            guard counter[handle] == 1 else { return leftMap[handle] }
            let obj = leftMap.removeValue(forKey: handle)
            if let obj = obj {
                rightMap.removeValue(forKey: ObjectIdentifier(obj as AnyObject))
            }
            return obj
        }
    }
}

// Magic number for the Rust proxy to call using the same mechanism as every other method,
// to free the callback once it's dropped by Rust.
private let IDX_CALLBACK_FREE: Int32 = 0

fileprivate class FfiConverterCallbackInterface<CallbackInterface> {
    fileprivate let handleMap = ConcurrentHandleMap<CallbackInterface>()

    func drop(handle: Handle) {
        handleMap.remove(handle: handle)
    }

    func lift(_ handle: Handle) throws -> CallbackInterface {
        guard let callback = handleMap.get(handle: handle) else {
            throw UniffiInternalError.unexpectedStaleHandle
        }
        return callback
    }

    func read(from buf: Reader) throws -> CallbackInterface {
        let handle: Handle = try buf.readInt()
        return try lift(handle)
    }

    func lower(_ v: CallbackInterface) -> Handle {
        let handle = handleMap.insert(obj: v)
        return handle
        // assert(handleMap.get(handle: obj) == v, "Handle map is not returning the object we just placed there. This is a bug in the HandleMap.")
    }

    func write(_ v: CallbackInterface, into buf: Writer) {
        buf.writeInt(lower(v))
    }
}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum AttachmentData {
    
    case base64(value: Base64AttachmentData )
    case json(value: JsonAttachmentData )
    case links(value: LinksAttachmentData )
}

extension AttachmentData: ViaFfiUsingByteBuffer, ViaFfi {
    fileprivate static func read(from buf: Reader) throws -> AttachmentData {
        let variant: Int32 = try buf.readInt()
        switch variant {
        
        case 1: return .base64(
            value: try Base64AttachmentData.read(from: buf)
            )
        case 2: return .json(
            value: try JsonAttachmentData.read(from: buf)
            )
        case 3: return .links(
            value: try LinksAttachmentData.read(from: buf)
            )
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    fileprivate func write(into buf: Writer) {
        switch self {
        
        
        case let .base64(value):
            buf.writeInt(Int32(1))
            value.write(into: buf)
            
        
        
        case let .json(value):
            buf.writeInt(Int32(2))
            value.write(into: buf)
            
        
        
        case let .links(value):
            buf.writeInt(Int32(3))
            value.write(into: buf)
            
        
        }
    }
}


extension AttachmentData: Equatable, Hashable {}


// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum ErrorCode {
    
    case success
    case error
}

extension ErrorCode: ViaFfiUsingByteBuffer, ViaFfi {
    fileprivate static func read(from buf: Reader) throws -> ErrorCode {
        let variant: Int32 = try buf.readInt()
        switch variant {
        
        case 1: return .success
        case 2: return .error
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    fileprivate func write(into buf: Writer) {
        switch self {
        
        
        case .success:
            buf.writeInt(Int32(1))
        
        
        case .error:
            buf.writeInt(Int32(2))
        
        }
    }
}


extension ErrorCode: Equatable, Hashable {}


// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum VerificationMaterial {
    
    case jwk(value: String )
    case multibase(value: String )
    case base58(value: String )
    case hex(value: String )
    case other(value: String )
}

extension VerificationMaterial: ViaFfiUsingByteBuffer, ViaFfi {
    fileprivate static func read(from buf: Reader) throws -> VerificationMaterial {
        let variant: Int32 = try buf.readInt()
        switch variant {
        
        case 1: return .jwk(
            value: try String.read(from: buf)
            )
        case 2: return .multibase(
            value: try String.read(from: buf)
            )
        case 3: return .base58(
            value: try String.read(from: buf)
            )
        case 4: return .hex(
            value: try String.read(from: buf)
            )
        case 5: return .other(
            value: try String.read(from: buf)
            )
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    fileprivate func write(into buf: Writer) {
        switch self {
        
        
        case let .jwk(value):
            buf.writeInt(Int32(1))
            value.write(into: buf)
            
        
        
        case let .multibase(value):
            buf.writeInt(Int32(2))
            value.write(into: buf)
            
        
        
        case let .base58(value):
            buf.writeInt(Int32(3))
            value.write(into: buf)
            
        
        
        case let .hex(value):
            buf.writeInt(Int32(4))
            value.write(into: buf)
            
        
        
        case let .other(value):
            buf.writeInt(Int32(5))
            value.write(into: buf)
            
        
        }
    }
}


extension VerificationMaterial: Equatable, Hashable {}


// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum VerificationMethodType {
    
    case jsonWebKey2020
    case x25519KeyAgreementKey2019
    case ed25519VerificationKey2018
    case ecdsaSecp256k1VerificationKey2019
    case x25519KeyAgreementKey2020
    case ed25519VerificationKey2020
    case other
}

extension VerificationMethodType: ViaFfiUsingByteBuffer, ViaFfi {
    fileprivate static func read(from buf: Reader) throws -> VerificationMethodType {
        let variant: Int32 = try buf.readInt()
        switch variant {
        
        case 1: return .jsonWebKey2020
        case 2: return .x25519KeyAgreementKey2019
        case 3: return .ed25519VerificationKey2018
        case 4: return .ecdsaSecp256k1VerificationKey2019
        case 5: return .x25519KeyAgreementKey2020
        case 6: return .ed25519VerificationKey2020
        case 7: return .other
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    fileprivate func write(into buf: Writer) {
        switch self {
        
        
        case .jsonWebKey2020:
            buf.writeInt(Int32(1))
        
        
        case .x25519KeyAgreementKey2019:
            buf.writeInt(Int32(2))
        
        
        case .ed25519VerificationKey2018:
            buf.writeInt(Int32(3))
        
        
        case .ecdsaSecp256k1VerificationKey2019:
            buf.writeInt(Int32(4))
        
        
        case .x25519KeyAgreementKey2020:
            buf.writeInt(Int32(5))
        
        
        case .ed25519VerificationKey2020:
            buf.writeInt(Int32(6))
        
        
        case .other:
            buf.writeInt(Int32(7))
        
        }
    }
}


extension VerificationMethodType: Equatable, Hashable {}


// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum ServiceKind {
    
    case didCommMessaging(value: DidCommMessagingService )
    case other(value: String )
}

extension ServiceKind: ViaFfiUsingByteBuffer, ViaFfi {
    fileprivate static func read(from buf: Reader) throws -> ServiceKind {
        let variant: Int32 = try buf.readInt()
        switch variant {
        
        case 1: return .didCommMessaging(
            value: try DidCommMessagingService.read(from: buf)
            )
        case 2: return .other(
            value: try String.read(from: buf)
            )
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    fileprivate func write(into buf: Writer) {
        switch self {
        
        
        case let .didCommMessaging(value):
            buf.writeInt(Int32(1))
            value.write(into: buf)
            
        
        
        case let .other(value):
            buf.writeInt(Int32(2))
            value.write(into: buf)
            
        
        }
    }
}


extension ServiceKind: Equatable, Hashable {}


// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum SecretMaterial {
    
    case jwk(value: String )
    case multibase(value: String )
    case base58(value: String )
    case hex(value: String )
    case other(value: String )
}

extension SecretMaterial: ViaFfiUsingByteBuffer, ViaFfi {
    fileprivate static func read(from buf: Reader) throws -> SecretMaterial {
        let variant: Int32 = try buf.readInt()
        switch variant {
        
        case 1: return .jwk(
            value: try String.read(from: buf)
            )
        case 2: return .multibase(
            value: try String.read(from: buf)
            )
        case 3: return .base58(
            value: try String.read(from: buf)
            )
        case 4: return .hex(
            value: try String.read(from: buf)
            )
        case 5: return .other(
            value: try String.read(from: buf)
            )
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    fileprivate func write(into buf: Writer) {
        switch self {
        
        
        case let .jwk(value):
            buf.writeInt(Int32(1))
            value.write(into: buf)
            
        
        
        case let .multibase(value):
            buf.writeInt(Int32(2))
            value.write(into: buf)
            
        
        
        case let .base58(value):
            buf.writeInt(Int32(3))
            value.write(into: buf)
            
        
        
        case let .hex(value):
            buf.writeInt(Int32(4))
            value.write(into: buf)
            
        
        
        case let .other(value):
            buf.writeInt(Int32(5))
            value.write(into: buf)
            
        
        }
    }
}


extension SecretMaterial: Equatable, Hashable {}


// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum SecretType {
    
    case jsonWebKey2020
    case x25519KeyAgreementKey2019
    case ed25519VerificationKey2018
    case ecdsaSecp256k1VerificationKey2019
    case x25519KeyAgreementKey2020
    case ed25519VerificationKey2020
    case other
}

extension SecretType: ViaFfiUsingByteBuffer, ViaFfi {
    fileprivate static func read(from buf: Reader) throws -> SecretType {
        let variant: Int32 = try buf.readInt()
        switch variant {
        
        case 1: return .jsonWebKey2020
        case 2: return .x25519KeyAgreementKey2019
        case 3: return .ed25519VerificationKey2018
        case 4: return .ecdsaSecp256k1VerificationKey2019
        case 5: return .x25519KeyAgreementKey2020
        case 6: return .ed25519VerificationKey2020
        case 7: return .other
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    fileprivate func write(into buf: Writer) {
        switch self {
        
        
        case .jsonWebKey2020:
            buf.writeInt(Int32(1))
        
        
        case .x25519KeyAgreementKey2019:
            buf.writeInt(Int32(2))
        
        
        case .ed25519VerificationKey2018:
            buf.writeInt(Int32(3))
        
        
        case .ecdsaSecp256k1VerificationKey2019:
            buf.writeInt(Int32(4))
        
        
        case .x25519KeyAgreementKey2020:
            buf.writeInt(Int32(5))
        
        
        case .ed25519VerificationKey2020:
            buf.writeInt(Int32(6))
        
        
        case .other:
            buf.writeInt(Int32(7))
        
        }
    }
}


extension SecretType: Equatable, Hashable {}


// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum AuthCryptAlg {
    
    case a256cbcHs512Ecdh1puA256kw
}

extension AuthCryptAlg: ViaFfiUsingByteBuffer, ViaFfi {
    fileprivate static func read(from buf: Reader) throws -> AuthCryptAlg {
        let variant: Int32 = try buf.readInt()
        switch variant {
        
        case 1: return .a256cbcHs512Ecdh1puA256kw
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    fileprivate func write(into buf: Writer) {
        switch self {
        
        
        case .a256cbcHs512Ecdh1puA256kw:
            buf.writeInt(Int32(1))
        
        }
    }
}


extension AuthCryptAlg: Equatable, Hashable {}


// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum AnonCryptAlg {
    
    case a256cbcHs512EcdhEsA256kw
    case xc20pEcdhEsA256kw
    case a256gcmEcdhEsA256kw
}

extension AnonCryptAlg: ViaFfiUsingByteBuffer, ViaFfi {
    fileprivate static func read(from buf: Reader) throws -> AnonCryptAlg {
        let variant: Int32 = try buf.readInt()
        switch variant {
        
        case 1: return .a256cbcHs512EcdhEsA256kw
        case 2: return .xc20pEcdhEsA256kw
        case 3: return .a256gcmEcdhEsA256kw
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    fileprivate func write(into buf: Writer) {
        switch self {
        
        
        case .a256cbcHs512EcdhEsA256kw:
            buf.writeInt(Int32(1))
        
        
        case .xc20pEcdhEsA256kw:
            buf.writeInt(Int32(2))
        
        
        case .a256gcmEcdhEsA256kw:
            buf.writeInt(Int32(3))
        
        }
    }
}


extension AnonCryptAlg: Equatable, Hashable {}


// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum SignAlg {
    
    case edDsa
    case es256
    case es256k
}

extension SignAlg: ViaFfiUsingByteBuffer, ViaFfi {
    fileprivate static func read(from buf: Reader) throws -> SignAlg {
        let variant: Int32 = try buf.readInt()
        switch variant {
        
        case 1: return .edDsa
        case 2: return .es256
        case 3: return .es256k
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    fileprivate func write(into buf: Writer) {
        switch self {
        
        
        case .edDsa:
            buf.writeInt(Int32(1))
        
        
        case .es256:
            buf.writeInt(Int32(2))
        
        
        case .es256k:
            buf.writeInt(Int32(3))
        
        }
    }
}


extension SignAlg: Equatable, Hashable {}



public protocol DIDCommProtocol {
    func packPlaintext(msg: Message, cb: OnPackPlaintextResult )  -> ErrorCode
    func packSigned(msg: Message, signBy: String, cb: OnPackSignedResult )  -> ErrorCode
    func packEncrypted(msg: Message, to: String, from: String?, signBy: String?, options: PackEncryptedOptions, cb: OnPackEncryptedResult )  -> ErrorCode
    func unpack(msg: String, options: UnpackOptions, cb: OnUnpackResult )  -> ErrorCode
    func packFromPrior(msg: FromPrior, issuerKid: String?, cb: OnFromPriorPackResult )  -> ErrorCode
    func unpackFromPrior(fromPriorJwt: String, cb: OnFromPriorUnpackResult )  -> ErrorCode
    func wrapInForward(msg: String, headers: [String: String], to: String, routingKeys: [String], encAlgAnon: AnonCryptAlg, cb: OnWrapInForwardResult )  -> ErrorCode
    
}

public class DidComm: DIDCommProtocol {
    fileprivate let pointer: UnsafeMutableRawPointer

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `ViaFfi` without making this `required` and we can't
    // make it `required` without making it `public`.
    required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }
    public convenience init(didResolver: DidResolver, secretResolver: SecretsResolver )  {
        self.init(unsafeFromRawPointer: try!
    
    
    rustCall() {
    
    didcomm_7b5e_DIDComm_new(ffiConverterCallbackInterfaceDidResolver.lower(didResolver), ffiConverterCallbackInterfaceSecretsResolver.lower(secretResolver) , $0)
})
    }

    deinit {
        try! rustCall { ffi_didcomm_7b5e_DIDComm_object_free(pointer, $0) }
    }

    

    
    public func packPlaintext(msg: Message, cb: OnPackPlaintextResult )  -> ErrorCode {
        let _retval = try!
    rustCall() {
    
    didcomm_7b5e_DIDComm_pack_plaintext(self.pointer, msg.lower(), ffiConverterCallbackInterfaceOnPackPlaintextResult.lower(cb) , $0
    )
}
        return try! ErrorCode.lift(_retval)
    }
    public func packSigned(msg: Message, signBy: String, cb: OnPackSignedResult )  -> ErrorCode {
        let _retval = try!
    rustCall() {
    
    didcomm_7b5e_DIDComm_pack_signed(self.pointer, msg.lower(), signBy.lower(), ffiConverterCallbackInterfaceOnPackSignedResult.lower(cb) , $0
    )
}
        return try! ErrorCode.lift(_retval)
    }
    public func packEncrypted(msg: Message, to: String, from: String?, signBy: String?, options: PackEncryptedOptions, cb: OnPackEncryptedResult )  -> ErrorCode {
        let _retval = try!
    rustCall() {
    
    didcomm_7b5e_DIDComm_pack_encrypted(self.pointer, msg.lower(), to.lower(), FfiConverterOptionString.lower(from), FfiConverterOptionString.lower(signBy), options.lower(), ffiConverterCallbackInterfaceOnPackEncryptedResult.lower(cb) , $0
    )
}
        return try! ErrorCode.lift(_retval)
    }
    public func unpack(msg: String, options: UnpackOptions, cb: OnUnpackResult )  -> ErrorCode {
        let _retval = try!
    rustCall() {
    
    didcomm_7b5e_DIDComm_unpack(self.pointer, msg.lower(), options.lower(), ffiConverterCallbackInterfaceOnUnpackResult.lower(cb) , $0
    )
}
        return try! ErrorCode.lift(_retval)
    }
    public func packFromPrior(msg: FromPrior, issuerKid: String?, cb: OnFromPriorPackResult )  -> ErrorCode {
        let _retval = try!
    rustCall() {
    
    didcomm_7b5e_DIDComm_pack_from_prior(self.pointer, msg.lower(), FfiConverterOptionString.lower(issuerKid), ffiConverterCallbackInterfaceOnFromPriorPackResult.lower(cb) , $0
    )
}
        return try! ErrorCode.lift(_retval)
    }
    public func unpackFromPrior(fromPriorJwt: String, cb: OnFromPriorUnpackResult )  -> ErrorCode {
        let _retval = try!
    rustCall() {
    
    didcomm_7b5e_DIDComm_unpack_from_prior(self.pointer, fromPriorJwt.lower(), ffiConverterCallbackInterfaceOnFromPriorUnpackResult.lower(cb) , $0
    )
}
        return try! ErrorCode.lift(_retval)
    }
    public func wrapInForward(msg: String, headers: [String: String], to: String, routingKeys: [String], encAlgAnon: AnonCryptAlg, cb: OnWrapInForwardResult )  -> ErrorCode {
        let _retval = try!
    rustCall() {
    
    didcomm_7b5e_DIDComm_wrap_in_forward(self.pointer, msg.lower(), FfiConverterDictionaryJsonValue.lower(headers), to.lower(), FfiConverterSequenceString.lower(routingKeys), encAlgAnon.lower(), ffiConverterCallbackInterfaceOnWrapInForwardResult.lower(cb) , $0
    )
}
        return try! ErrorCode.lift(_retval)
    }
    
}


fileprivate extension DidComm {
    fileprivate typealias FfiType = UnsafeMutableRawPointer

    fileprivate static func read(from buf: Reader) throws -> Self {
        let v: UInt64 = try buf.readInt()
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if (ptr == nil) {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try self.lift(ptr!)
    }

    fileprivate func write(into buf: Writer) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        buf.writeInt(UInt64(bitPattern: Int64(Int(bitPattern: self.lower()))))
    }

    fileprivate static func lift(_ pointer: UnsafeMutableRawPointer) throws -> Self {
        return Self(unsafeFromRawPointer: pointer)
    }

    fileprivate func lower() -> UnsafeMutableRawPointer {
        return self.pointer
    }
}

// Ideally this would be `fileprivate`, but Swift says:
// """
// 'private' modifier cannot be used with extensions that declare protocol conformances
// """
extension DidComm : ViaFfi, Serializable {}


public protocol OnDIDResolverResultProtocol {
    func success(result: DidDoc? ) throws
    func error(err: ErrorKind, msg: String ) throws
    
}

public class OnDidResolverResult: OnDIDResolverResultProtocol {
    fileprivate let pointer: UnsafeMutableRawPointer

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `ViaFfi` without making this `required` and we can't
    // make it `required` without making it `public`.
    required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    deinit {
        try! rustCall { ffi_didcomm_7b5e_OnDIDResolverResult_object_free(pointer, $0) }
    }

    

    
    public func success(result: DidDoc? ) throws {
        try
    rustCallWithError(ErrorKind.self) {
    
    didcomm_7b5e_OnDIDResolverResult_success(self.pointer, FfiConverterOptionRecordDidDoc.lower(result) , $0
    )
}
    }
    public func error(err: ErrorKind, msg: String ) throws {
        try
    rustCallWithError(ErrorKind.self) {
    
    didcomm_7b5e_OnDIDResolverResult_error(self.pointer, err.lower(), msg.lower() , $0
    )
}
    }
    
}


fileprivate extension OnDidResolverResult {
    fileprivate typealias FfiType = UnsafeMutableRawPointer

    fileprivate static func read(from buf: Reader) throws -> Self {
        let v: UInt64 = try buf.readInt()
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if (ptr == nil) {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try self.lift(ptr!)
    }

    fileprivate func write(into buf: Writer) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        buf.writeInt(UInt64(bitPattern: Int64(Int(bitPattern: self.lower()))))
    }

    fileprivate static func lift(_ pointer: UnsafeMutableRawPointer) throws -> Self {
        return Self(unsafeFromRawPointer: pointer)
    }

    fileprivate func lower() -> UnsafeMutableRawPointer {
        return self.pointer
    }
}

// Ideally this would be `fileprivate`, but Swift says:
// """
// 'private' modifier cannot be used with extensions that declare protocol conformances
// """
extension OnDidResolverResult : ViaFfi, Serializable {}


public protocol ExampleDIDResolverProtocol {
    func resolve(did: String, cb: OnDidResolverResult )  -> ErrorCode
    
}

public class ExampleDidResolver: ExampleDIDResolverProtocol {
    fileprivate let pointer: UnsafeMutableRawPointer

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `ViaFfi` without making this `required` and we can't
    // make it `required` without making it `public`.
    required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }
    public convenience init(knownDids: [DidDoc] )  {
        self.init(unsafeFromRawPointer: try!
    
    
    rustCall() {
    
    didcomm_7b5e_ExampleDIDResolver_new(FfiConverterSequenceRecordDidDoc.lower(knownDids) , $0)
})
    }

    deinit {
        try! rustCall { ffi_didcomm_7b5e_ExampleDIDResolver_object_free(pointer, $0) }
    }

    

    
    public func resolve(did: String, cb: OnDidResolverResult )  -> ErrorCode {
        let _retval = try!
    rustCall() {
    
    didcomm_7b5e_ExampleDIDResolver_resolve(self.pointer, did.lower(), cb.lower() , $0
    )
}
        return try! ErrorCode.lift(_retval)
    }
    
}


fileprivate extension ExampleDidResolver {
    fileprivate typealias FfiType = UnsafeMutableRawPointer

    fileprivate static func read(from buf: Reader) throws -> Self {
        let v: UInt64 = try buf.readInt()
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if (ptr == nil) {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try self.lift(ptr!)
    }

    fileprivate func write(into buf: Writer) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        buf.writeInt(UInt64(bitPattern: Int64(Int(bitPattern: self.lower()))))
    }

    fileprivate static func lift(_ pointer: UnsafeMutableRawPointer) throws -> Self {
        return Self(unsafeFromRawPointer: pointer)
    }

    fileprivate func lower() -> UnsafeMutableRawPointer {
        return self.pointer
    }
}

// Ideally this would be `fileprivate`, but Swift says:
// """
// 'private' modifier cannot be used with extensions that declare protocol conformances
// """
extension ExampleDidResolver : ViaFfi, Serializable {}


public protocol OnGetSecretResultProtocol {
    func success(result: Secret? ) throws
    func error(err: ErrorKind, msg: String ) throws
    
}

public class OnGetSecretResult: OnGetSecretResultProtocol {
    fileprivate let pointer: UnsafeMutableRawPointer

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `ViaFfi` without making this `required` and we can't
    // make it `required` without making it `public`.
    required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    deinit {
        try! rustCall { ffi_didcomm_7b5e_OnGetSecretResult_object_free(pointer, $0) }
    }

    

    
    public func success(result: Secret? ) throws {
        try
    rustCallWithError(ErrorKind.self) {
    
    didcomm_7b5e_OnGetSecretResult_success(self.pointer, FfiConverterOptionRecordSecret.lower(result) , $0
    )
}
    }
    public func error(err: ErrorKind, msg: String ) throws {
        try
    rustCallWithError(ErrorKind.self) {
    
    didcomm_7b5e_OnGetSecretResult_error(self.pointer, err.lower(), msg.lower() , $0
    )
}
    }
    
}


fileprivate extension OnGetSecretResult {
    fileprivate typealias FfiType = UnsafeMutableRawPointer

    fileprivate static func read(from buf: Reader) throws -> Self {
        let v: UInt64 = try buf.readInt()
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if (ptr == nil) {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try self.lift(ptr!)
    }

    fileprivate func write(into buf: Writer) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        buf.writeInt(UInt64(bitPattern: Int64(Int(bitPattern: self.lower()))))
    }

    fileprivate static func lift(_ pointer: UnsafeMutableRawPointer) throws -> Self {
        return Self(unsafeFromRawPointer: pointer)
    }

    fileprivate func lower() -> UnsafeMutableRawPointer {
        return self.pointer
    }
}

// Ideally this would be `fileprivate`, but Swift says:
// """
// 'private' modifier cannot be used with extensions that declare protocol conformances
// """
extension OnGetSecretResult : ViaFfi, Serializable {}


public protocol OnFindSecretsResultProtocol {
    func success(result: [String] ) throws
    func error(err: ErrorKind, msg: String ) throws
    
}

public class OnFindSecretsResult: OnFindSecretsResultProtocol {
    fileprivate let pointer: UnsafeMutableRawPointer

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `ViaFfi` without making this `required` and we can't
    // make it `required` without making it `public`.
    required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    deinit {
        try! rustCall { ffi_didcomm_7b5e_OnFindSecretsResult_object_free(pointer, $0) }
    }

    

    
    public func success(result: [String] ) throws {
        try
    rustCallWithError(ErrorKind.self) {
    
    didcomm_7b5e_OnFindSecretsResult_success(self.pointer, FfiConverterSequenceString.lower(result) , $0
    )
}
    }
    public func error(err: ErrorKind, msg: String ) throws {
        try
    rustCallWithError(ErrorKind.self) {
    
    didcomm_7b5e_OnFindSecretsResult_error(self.pointer, err.lower(), msg.lower() , $0
    )
}
    }
    
}


fileprivate extension OnFindSecretsResult {
    fileprivate typealias FfiType = UnsafeMutableRawPointer

    fileprivate static func read(from buf: Reader) throws -> Self {
        let v: UInt64 = try buf.readInt()
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if (ptr == nil) {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try self.lift(ptr!)
    }

    fileprivate func write(into buf: Writer) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        buf.writeInt(UInt64(bitPattern: Int64(Int(bitPattern: self.lower()))))
    }

    fileprivate static func lift(_ pointer: UnsafeMutableRawPointer) throws -> Self {
        return Self(unsafeFromRawPointer: pointer)
    }

    fileprivate func lower() -> UnsafeMutableRawPointer {
        return self.pointer
    }
}

// Ideally this would be `fileprivate`, but Swift says:
// """
// 'private' modifier cannot be used with extensions that declare protocol conformances
// """
extension OnFindSecretsResult : ViaFfi, Serializable {}


public protocol ExampleSecretsResolverProtocol {
    func getSecret(secretId: String, cb: OnGetSecretResult )  -> ErrorCode
    func findSecrets(secretIds: [String], cb: OnFindSecretsResult )  -> ErrorCode
    
}

public class ExampleSecretsResolver: ExampleSecretsResolverProtocol {
    fileprivate let pointer: UnsafeMutableRawPointer

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `ViaFfi` without making this `required` and we can't
    // make it `required` without making it `public`.
    required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }
    public convenience init(knownSecrets: [Secret] )  {
        self.init(unsafeFromRawPointer: try!
    
    
    rustCall() {
    
    didcomm_7b5e_ExampleSecretsResolver_new(FfiConverterSequenceRecordSecret.lower(knownSecrets) , $0)
})
    }

    deinit {
        try! rustCall { ffi_didcomm_7b5e_ExampleSecretsResolver_object_free(pointer, $0) }
    }

    

    
    public func getSecret(secretId: String, cb: OnGetSecretResult )  -> ErrorCode {
        let _retval = try!
    rustCall() {
    
    didcomm_7b5e_ExampleSecretsResolver_get_secret(self.pointer, secretId.lower(), cb.lower() , $0
    )
}
        return try! ErrorCode.lift(_retval)
    }
    public func findSecrets(secretIds: [String], cb: OnFindSecretsResult )  -> ErrorCode {
        let _retval = try!
    rustCall() {
    
    didcomm_7b5e_ExampleSecretsResolver_find_secrets(self.pointer, FfiConverterSequenceString.lower(secretIds), cb.lower() , $0
    )
}
        return try! ErrorCode.lift(_retval)
    }
    
}


fileprivate extension ExampleSecretsResolver {
    fileprivate typealias FfiType = UnsafeMutableRawPointer

    fileprivate static func read(from buf: Reader) throws -> Self {
        let v: UInt64 = try buf.readInt()
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if (ptr == nil) {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try self.lift(ptr!)
    }

    fileprivate func write(into buf: Writer) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        buf.writeInt(UInt64(bitPattern: Int64(Int(bitPattern: self.lower()))))
    }

    fileprivate static func lift(_ pointer: UnsafeMutableRawPointer) throws -> Self {
        return Self(unsafeFromRawPointer: pointer)
    }

    fileprivate func lower() -> UnsafeMutableRawPointer {
        return self.pointer
    }
}

// Ideally this would be `fileprivate`, but Swift says:
// """
// 'private' modifier cannot be used with extensions that declare protocol conformances
// """
extension ExampleSecretsResolver : ViaFfi, Serializable {}

public struct Message {
    public var id: String
    public var typ: String
    public var type: String
    public var body: String
    public var from: String?
    public var to: [String]?
    public var thid: String?
    public var pthid: String?
    public var extraHeaders: [String: String]
    public var createdTime: UInt64?
    public var expiresTime: UInt64?
    public var fromPrior: String?
    public var attachments: [Attachment]?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(id: String, typ: String, type: String, body: String, from: String?, to: [String]?, thid: String?, pthid: String?, extraHeaders: [String: String], createdTime: UInt64?, expiresTime: UInt64?, fromPrior: String?, attachments: [Attachment]? ) {
        self.id = id
        self.typ = typ
        self.type = type
        self.body = body
        self.from = from
        self.to = to
        self.thid = thid
        self.pthid = pthid
        self.extraHeaders = extraHeaders
        self.createdTime = createdTime
        self.expiresTime = expiresTime
        self.fromPrior = fromPrior
        self.attachments = attachments
    }
}


extension Message: Equatable, Hashable {
    public static func ==(lhs: Message, rhs: Message) -> Bool {
        if lhs.id != rhs.id {
            return false
        }
        if lhs.typ != rhs.typ {
            return false
        }
        if lhs.type != rhs.type {
            return false
        }
        if lhs.body != rhs.body {
            return false
        }
        if lhs.from != rhs.from {
            return false
        }
        if lhs.to != rhs.to {
            return false
        }
        if lhs.thid != rhs.thid {
            return false
        }
        if lhs.pthid != rhs.pthid {
            return false
        }
        if lhs.extraHeaders != rhs.extraHeaders {
            return false
        }
        if lhs.createdTime != rhs.createdTime {
            return false
        }
        if lhs.expiresTime != rhs.expiresTime {
            return false
        }
        if lhs.fromPrior != rhs.fromPrior {
            return false
        }
        if lhs.attachments != rhs.attachments {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(id)
        hasher.combine(typ)
        hasher.combine(type)
        hasher.combine(body)
        hasher.combine(from)
        hasher.combine(to)
        hasher.combine(thid)
        hasher.combine(pthid)
        hasher.combine(extraHeaders)
        hasher.combine(createdTime)
        hasher.combine(expiresTime)
        hasher.combine(fromPrior)
        hasher.combine(attachments)
    }
}


fileprivate extension Message {
    static func read(from buf: Reader) throws -> Message {
        return try Message(
            id: String.read(from: buf),
            typ: String.read(from: buf),
            type: String.read(from: buf),
            body: String.read(from: buf),
            from: FfiConverterOptionString.read(from: buf),
            to: FfiConverterOptionSequenceString.read(from: buf),
            thid: FfiConverterOptionString.read(from: buf),
            pthid: FfiConverterOptionString.read(from: buf),
            extraHeaders: FfiConverterDictionaryJsonValue.read(from: buf),
            createdTime: FfiConverterOptionUInt64.read(from: buf),
            expiresTime: FfiConverterOptionUInt64.read(from: buf),
            fromPrior: FfiConverterOptionString.read(from: buf),
            attachments: FfiConverterOptionSequenceRecordAttachment.read(from: buf)
        )
    }

    func write(into buf: Writer) {
        self.id.write(into: buf)
        self.typ.write(into: buf)
        self.type.write(into: buf)
        self.body.write(into: buf)
        FfiConverterOptionString.write(self.from, into: buf)
        FfiConverterOptionSequenceString.write(self.to, into: buf)
        FfiConverterOptionString.write(self.thid, into: buf)
        FfiConverterOptionString.write(self.pthid, into: buf)
        FfiConverterDictionaryJsonValue.write(self.extraHeaders, into: buf)
        FfiConverterOptionUInt64.write(self.createdTime, into: buf)
        FfiConverterOptionUInt64.write(self.expiresTime, into: buf)
        FfiConverterOptionString.write(self.fromPrior, into: buf)
        FfiConverterOptionSequenceRecordAttachment.write(self.attachments, into: buf)
    }
}

extension Message: ViaFfiUsingByteBuffer, ViaFfi {}

public struct Attachment {
    public var data: AttachmentData
    public var id: String?
    public var description: String?
    public var filename: String?
    public var mediaType: String?
    public var format: String?
    public var lastmodTime: UInt64?
    public var byteCount: UInt64?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(data: AttachmentData, id: String?, description: String?, filename: String?, mediaType: String?, format: String?, lastmodTime: UInt64?, byteCount: UInt64? ) {
        self.data = data
        self.id = id
        self.description = description
        self.filename = filename
        self.mediaType = mediaType
        self.format = format
        self.lastmodTime = lastmodTime
        self.byteCount = byteCount
    }
}


extension Attachment: Equatable, Hashable {
    public static func ==(lhs: Attachment, rhs: Attachment) -> Bool {
        if lhs.data != rhs.data {
            return false
        }
        if lhs.id != rhs.id {
            return false
        }
        if lhs.description != rhs.description {
            return false
        }
        if lhs.filename != rhs.filename {
            return false
        }
        if lhs.mediaType != rhs.mediaType {
            return false
        }
        if lhs.format != rhs.format {
            return false
        }
        if lhs.lastmodTime != rhs.lastmodTime {
            return false
        }
        if lhs.byteCount != rhs.byteCount {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(data)
        hasher.combine(id)
        hasher.combine(description)
        hasher.combine(filename)
        hasher.combine(mediaType)
        hasher.combine(format)
        hasher.combine(lastmodTime)
        hasher.combine(byteCount)
    }
}


fileprivate extension Attachment {
    static func read(from buf: Reader) throws -> Attachment {
        return try Attachment(
            data: AttachmentData.read(from: buf),
            id: FfiConverterOptionString.read(from: buf),
            description: FfiConverterOptionString.read(from: buf),
            filename: FfiConverterOptionString.read(from: buf),
            mediaType: FfiConverterOptionString.read(from: buf),
            format: FfiConverterOptionString.read(from: buf),
            lastmodTime: FfiConverterOptionUInt64.read(from: buf),
            byteCount: FfiConverterOptionUInt64.read(from: buf)
        )
    }

    func write(into buf: Writer) {
        self.data.write(into: buf)
        FfiConverterOptionString.write(self.id, into: buf)
        FfiConverterOptionString.write(self.description, into: buf)
        FfiConverterOptionString.write(self.filename, into: buf)
        FfiConverterOptionString.write(self.mediaType, into: buf)
        FfiConverterOptionString.write(self.format, into: buf)
        FfiConverterOptionUInt64.write(self.lastmodTime, into: buf)
        FfiConverterOptionUInt64.write(self.byteCount, into: buf)
    }
}

extension Attachment: ViaFfiUsingByteBuffer, ViaFfi {}

public struct Base64AttachmentData {
    public var base64: String
    public var jws: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(base64: String, jws: String? ) {
        self.base64 = base64
        self.jws = jws
    }
}


extension Base64AttachmentData: Equatable, Hashable {
    public static func ==(lhs: Base64AttachmentData, rhs: Base64AttachmentData) -> Bool {
        if lhs.base64 != rhs.base64 {
            return false
        }
        if lhs.jws != rhs.jws {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(base64)
        hasher.combine(jws)
    }
}


fileprivate extension Base64AttachmentData {
    static func read(from buf: Reader) throws -> Base64AttachmentData {
        return try Base64AttachmentData(
            base64: String.read(from: buf),
            jws: FfiConverterOptionString.read(from: buf)
        )
    }

    func write(into buf: Writer) {
        self.base64.write(into: buf)
        FfiConverterOptionString.write(self.jws, into: buf)
    }
}

extension Base64AttachmentData: ViaFfiUsingByteBuffer, ViaFfi {}

public struct JsonAttachmentData {
    public var json: String
    public var jws: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(json: String, jws: String? ) {
        self.json = json
        self.jws = jws
    }
}


extension JsonAttachmentData: Equatable, Hashable {
    public static func ==(lhs: JsonAttachmentData, rhs: JsonAttachmentData) -> Bool {
        if lhs.json != rhs.json {
            return false
        }
        if lhs.jws != rhs.jws {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(json)
        hasher.combine(jws)
    }
}


fileprivate extension JsonAttachmentData {
    static func read(from buf: Reader) throws -> JsonAttachmentData {
        return try JsonAttachmentData(
            json: String.read(from: buf),
            jws: FfiConverterOptionString.read(from: buf)
        )
    }

    func write(into buf: Writer) {
        self.json.write(into: buf)
        FfiConverterOptionString.write(self.jws, into: buf)
    }
}

extension JsonAttachmentData: ViaFfiUsingByteBuffer, ViaFfi {}

public struct LinksAttachmentData {
    public var links: [String]
    public var hash: String
    public var jws: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(links: [String], hash: String, jws: String? ) {
        self.links = links
        self.hash = hash
        self.jws = jws
    }
}


extension LinksAttachmentData: Equatable, Hashable {
    public static func ==(lhs: LinksAttachmentData, rhs: LinksAttachmentData) -> Bool {
        if lhs.links != rhs.links {
            return false
        }
        if lhs.hash != rhs.hash {
            return false
        }
        if lhs.jws != rhs.jws {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(links)
        hasher.combine(hash)
        hasher.combine(jws)
    }
}


fileprivate extension LinksAttachmentData {
    static func read(from buf: Reader) throws -> LinksAttachmentData {
        return try LinksAttachmentData(
            links: FfiConverterSequenceString.read(from: buf),
            hash: String.read(from: buf),
            jws: FfiConverterOptionString.read(from: buf)
        )
    }

    func write(into buf: Writer) {
        FfiConverterSequenceString.write(self.links, into: buf)
        self.hash.write(into: buf)
        FfiConverterOptionString.write(self.jws, into: buf)
    }
}

extension LinksAttachmentData: ViaFfiUsingByteBuffer, ViaFfi {}

public struct DidDoc {
    public var did: String
    public var keyAgreements: [String]
    public var authentications: [String]
    public var verificationMethods: [VerificationMethod]
    public var services: [Service]

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(did: String, keyAgreements: [String], authentications: [String], verificationMethods: [VerificationMethod], services: [Service] ) {
        self.did = did
        self.keyAgreements = keyAgreements
        self.authentications = authentications
        self.verificationMethods = verificationMethods
        self.services = services
    }
}


extension DidDoc: Equatable, Hashable {
    public static func ==(lhs: DidDoc, rhs: DidDoc) -> Bool {
        if lhs.did != rhs.did {
            return false
        }
        if lhs.keyAgreements != rhs.keyAgreements {
            return false
        }
        if lhs.authentications != rhs.authentications {
            return false
        }
        if lhs.verificationMethods != rhs.verificationMethods {
            return false
        }
        if lhs.services != rhs.services {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(did)
        hasher.combine(keyAgreements)
        hasher.combine(authentications)
        hasher.combine(verificationMethods)
        hasher.combine(services)
    }
}


fileprivate extension DidDoc {
    static func read(from buf: Reader) throws -> DidDoc {
        return try DidDoc(
            did: String.read(from: buf),
            keyAgreements: FfiConverterSequenceString.read(from: buf),
            authentications: FfiConverterSequenceString.read(from: buf),
            verificationMethods: FfiConverterSequenceRecordVerificationMethod.read(from: buf),
            services: FfiConverterSequenceRecordService.read(from: buf)
        )
    }

    func write(into buf: Writer) {
        self.did.write(into: buf)
        FfiConverterSequenceString.write(self.keyAgreements, into: buf)
        FfiConverterSequenceString.write(self.authentications, into: buf)
        FfiConverterSequenceRecordVerificationMethod.write(self.verificationMethods, into: buf)
        FfiConverterSequenceRecordService.write(self.services, into: buf)
    }
}

extension DidDoc: ViaFfiUsingByteBuffer, ViaFfi {}

public struct VerificationMethod {
    public var id: String
    public var type: VerificationMethodType
    public var controller: String
    public var verificationMaterial: VerificationMaterial

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(id: String, type: VerificationMethodType, controller: String, verificationMaterial: VerificationMaterial ) {
        self.id = id
        self.type = type
        self.controller = controller
        self.verificationMaterial = verificationMaterial
    }
}


extension VerificationMethod: Equatable, Hashable {
    public static func ==(lhs: VerificationMethod, rhs: VerificationMethod) -> Bool {
        if lhs.id != rhs.id {
            return false
        }
        if lhs.type != rhs.type {
            return false
        }
        if lhs.controller != rhs.controller {
            return false
        }
        if lhs.verificationMaterial != rhs.verificationMaterial {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(id)
        hasher.combine(type)
        hasher.combine(controller)
        hasher.combine(verificationMaterial)
    }
}


fileprivate extension VerificationMethod {
    static func read(from buf: Reader) throws -> VerificationMethod {
        return try VerificationMethod(
            id: String.read(from: buf),
            type: VerificationMethodType.read(from: buf),
            controller: String.read(from: buf),
            verificationMaterial: VerificationMaterial.read(from: buf)
        )
    }

    func write(into buf: Writer) {
        self.id.write(into: buf)
        self.type.write(into: buf)
        self.controller.write(into: buf)
        self.verificationMaterial.write(into: buf)
    }
}

extension VerificationMethod: ViaFfiUsingByteBuffer, ViaFfi {}

public struct Service {
    public var id: String
    public var kind: ServiceKind

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(id: String, kind: ServiceKind ) {
        self.id = id
        self.kind = kind
    }
}


extension Service: Equatable, Hashable {
    public static func ==(lhs: Service, rhs: Service) -> Bool {
        if lhs.id != rhs.id {
            return false
        }
        if lhs.kind != rhs.kind {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(id)
        hasher.combine(kind)
    }
}


fileprivate extension Service {
    static func read(from buf: Reader) throws -> Service {
        return try Service(
            id: String.read(from: buf),
            kind: ServiceKind.read(from: buf)
        )
    }

    func write(into buf: Writer) {
        self.id.write(into: buf)
        self.kind.write(into: buf)
    }
}

extension Service: ViaFfiUsingByteBuffer, ViaFfi {}

public struct DidCommMessagingService {
    public var serviceEndpoint: String
    public var accept: [String]
    public var routingKeys: [String]

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(serviceEndpoint: String, accept: [String], routingKeys: [String] ) {
        self.serviceEndpoint = serviceEndpoint
        self.accept = accept
        self.routingKeys = routingKeys
    }
}


extension DidCommMessagingService: Equatable, Hashable {
    public static func ==(lhs: DidCommMessagingService, rhs: DidCommMessagingService) -> Bool {
        if lhs.serviceEndpoint != rhs.serviceEndpoint {
            return false
        }
        if lhs.accept != rhs.accept {
            return false
        }
        if lhs.routingKeys != rhs.routingKeys {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(serviceEndpoint)
        hasher.combine(accept)
        hasher.combine(routingKeys)
    }
}


fileprivate extension DidCommMessagingService {
    static func read(from buf: Reader) throws -> DidCommMessagingService {
        return try DidCommMessagingService(
            serviceEndpoint: String.read(from: buf),
            accept: FfiConverterSequenceString.read(from: buf),
            routingKeys: FfiConverterSequenceString.read(from: buf)
        )
    }

    func write(into buf: Writer) {
        self.serviceEndpoint.write(into: buf)
        FfiConverterSequenceString.write(self.accept, into: buf)
        FfiConverterSequenceString.write(self.routingKeys, into: buf)
    }
}

extension DidCommMessagingService: ViaFfiUsingByteBuffer, ViaFfi {}

public struct Secret {
    public var id: String
    public var type: SecretType
    public var secretMaterial: SecretMaterial

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(id: String, type: SecretType, secretMaterial: SecretMaterial ) {
        self.id = id
        self.type = type
        self.secretMaterial = secretMaterial
    }
}


extension Secret: Equatable, Hashable {
    public static func ==(lhs: Secret, rhs: Secret) -> Bool {
        if lhs.id != rhs.id {
            return false
        }
        if lhs.type != rhs.type {
            return false
        }
        if lhs.secretMaterial != rhs.secretMaterial {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(id)
        hasher.combine(type)
        hasher.combine(secretMaterial)
    }
}


fileprivate extension Secret {
    static func read(from buf: Reader) throws -> Secret {
        return try Secret(
            id: String.read(from: buf),
            type: SecretType.read(from: buf),
            secretMaterial: SecretMaterial.read(from: buf)
        )
    }

    func write(into buf: Writer) {
        self.id.write(into: buf)
        self.type.write(into: buf)
        self.secretMaterial.write(into: buf)
    }
}

extension Secret: ViaFfiUsingByteBuffer, ViaFfi {}

public struct PackSignedMetadata {
    public var signByKid: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(signByKid: String ) {
        self.signByKid = signByKid
    }
}


extension PackSignedMetadata: Equatable, Hashable {
    public static func ==(lhs: PackSignedMetadata, rhs: PackSignedMetadata) -> Bool {
        if lhs.signByKid != rhs.signByKid {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(signByKid)
    }
}


fileprivate extension PackSignedMetadata {
    static func read(from buf: Reader) throws -> PackSignedMetadata {
        return try PackSignedMetadata(
            signByKid: String.read(from: buf)
        )
    }

    func write(into buf: Writer) {
        self.signByKid.write(into: buf)
    }
}

extension PackSignedMetadata: ViaFfiUsingByteBuffer, ViaFfi {}

public struct PackEncryptedMetadata {
    public var messagingService: MessagingServiceMetadata?
    public var fromKid: String?
    public var signByKid: String?
    public var toKids: [String]

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(messagingService: MessagingServiceMetadata?, fromKid: String?, signByKid: String?, toKids: [String] ) {
        self.messagingService = messagingService
        self.fromKid = fromKid
        self.signByKid = signByKid
        self.toKids = toKids
    }
}


extension PackEncryptedMetadata: Equatable, Hashable {
    public static func ==(lhs: PackEncryptedMetadata, rhs: PackEncryptedMetadata) -> Bool {
        if lhs.messagingService != rhs.messagingService {
            return false
        }
        if lhs.fromKid != rhs.fromKid {
            return false
        }
        if lhs.signByKid != rhs.signByKid {
            return false
        }
        if lhs.toKids != rhs.toKids {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(messagingService)
        hasher.combine(fromKid)
        hasher.combine(signByKid)
        hasher.combine(toKids)
    }
}


fileprivate extension PackEncryptedMetadata {
    static func read(from buf: Reader) throws -> PackEncryptedMetadata {
        return try PackEncryptedMetadata(
            messagingService: FfiConverterOptionRecordMessagingServiceMetadata.read(from: buf),
            fromKid: FfiConverterOptionString.read(from: buf),
            signByKid: FfiConverterOptionString.read(from: buf),
            toKids: FfiConverterSequenceString.read(from: buf)
        )
    }

    func write(into buf: Writer) {
        FfiConverterOptionRecordMessagingServiceMetadata.write(self.messagingService, into: buf)
        FfiConverterOptionString.write(self.fromKid, into: buf)
        FfiConverterOptionString.write(self.signByKid, into: buf)
        FfiConverterSequenceString.write(self.toKids, into: buf)
    }
}

extension PackEncryptedMetadata: ViaFfiUsingByteBuffer, ViaFfi {}

public struct MessagingServiceMetadata {
    public var id: String
    public var serviceEndpoint: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(id: String, serviceEndpoint: String ) {
        self.id = id
        self.serviceEndpoint = serviceEndpoint
    }
}


extension MessagingServiceMetadata: Equatable, Hashable {
    public static func ==(lhs: MessagingServiceMetadata, rhs: MessagingServiceMetadata) -> Bool {
        if lhs.id != rhs.id {
            return false
        }
        if lhs.serviceEndpoint != rhs.serviceEndpoint {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(id)
        hasher.combine(serviceEndpoint)
    }
}


fileprivate extension MessagingServiceMetadata {
    static func read(from buf: Reader) throws -> MessagingServiceMetadata {
        return try MessagingServiceMetadata(
            id: String.read(from: buf),
            serviceEndpoint: String.read(from: buf)
        )
    }

    func write(into buf: Writer) {
        self.id.write(into: buf)
        self.serviceEndpoint.write(into: buf)
    }
}

extension MessagingServiceMetadata: ViaFfiUsingByteBuffer, ViaFfi {}

public struct PackEncryptedOptions {
    public var protectSender: Bool
    public var forward: Bool
    public var forwardHeaders: [String: String]?
    public var messagingService: String?
    public var encAlgAuth: AuthCryptAlg
    public var encAlgAnon: AnonCryptAlg

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(protectSender: Bool, forward: Bool, forwardHeaders: [String: String]?, messagingService: String?, encAlgAuth: AuthCryptAlg, encAlgAnon: AnonCryptAlg ) {
        self.protectSender = protectSender
        self.forward = forward
        self.forwardHeaders = forwardHeaders
        self.messagingService = messagingService
        self.encAlgAuth = encAlgAuth
        self.encAlgAnon = encAlgAnon
    }
}


extension PackEncryptedOptions: Equatable, Hashable {
    public static func ==(lhs: PackEncryptedOptions, rhs: PackEncryptedOptions) -> Bool {
        if lhs.protectSender != rhs.protectSender {
            return false
        }
        if lhs.forward != rhs.forward {
            return false
        }
        if lhs.forwardHeaders != rhs.forwardHeaders {
            return false
        }
        if lhs.messagingService != rhs.messagingService {
            return false
        }
        if lhs.encAlgAuth != rhs.encAlgAuth {
            return false
        }
        if lhs.encAlgAnon != rhs.encAlgAnon {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(protectSender)
        hasher.combine(forward)
        hasher.combine(forwardHeaders)
        hasher.combine(messagingService)
        hasher.combine(encAlgAuth)
        hasher.combine(encAlgAnon)
    }
}


fileprivate extension PackEncryptedOptions {
    static func read(from buf: Reader) throws -> PackEncryptedOptions {
        return try PackEncryptedOptions(
            protectSender: Bool.read(from: buf),
            forward: Bool.read(from: buf),
            forwardHeaders: FfiConverterOptionDictionaryJsonValue.read(from: buf),
            messagingService: FfiConverterOptionString.read(from: buf),
            encAlgAuth: AuthCryptAlg.read(from: buf),
            encAlgAnon: AnonCryptAlg.read(from: buf)
        )
    }

    func write(into buf: Writer) {
        self.protectSender.write(into: buf)
        self.forward.write(into: buf)
        FfiConverterOptionDictionaryJsonValue.write(self.forwardHeaders, into: buf)
        FfiConverterOptionString.write(self.messagingService, into: buf)
        self.encAlgAuth.write(into: buf)
        self.encAlgAnon.write(into: buf)
    }
}

extension PackEncryptedOptions: ViaFfiUsingByteBuffer, ViaFfi {}

public struct UnpackMetadata {
    public var encrypted: Bool
    public var authenticated: Bool
    public var nonRepudiation: Bool
    public var anonymousSender: Bool
    public var reWrappedInForward: Bool
    public var encryptedFromKid: String?
    public var encryptedToKids: [String]?
    public var signFrom: String?
    public var fromPriorIssuerKid: String?
    public var encAlgAuth: AuthCryptAlg?
    public var encAlgAnon: AnonCryptAlg?
    public var signAlg: SignAlg?
    public var signedMessage: String?
    public var fromPrior: FromPrior?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(encrypted: Bool, authenticated: Bool, nonRepudiation: Bool, anonymousSender: Bool, reWrappedInForward: Bool, encryptedFromKid: String?, encryptedToKids: [String]?, signFrom: String?, fromPriorIssuerKid: String?, encAlgAuth: AuthCryptAlg?, encAlgAnon: AnonCryptAlg?, signAlg: SignAlg?, signedMessage: String?, fromPrior: FromPrior? ) {
        self.encrypted = encrypted
        self.authenticated = authenticated
        self.nonRepudiation = nonRepudiation
        self.anonymousSender = anonymousSender
        self.reWrappedInForward = reWrappedInForward
        self.encryptedFromKid = encryptedFromKid
        self.encryptedToKids = encryptedToKids
        self.signFrom = signFrom
        self.fromPriorIssuerKid = fromPriorIssuerKid
        self.encAlgAuth = encAlgAuth
        self.encAlgAnon = encAlgAnon
        self.signAlg = signAlg
        self.signedMessage = signedMessage
        self.fromPrior = fromPrior
    }
}


extension UnpackMetadata: Equatable, Hashable {
    public static func ==(lhs: UnpackMetadata, rhs: UnpackMetadata) -> Bool {
        if lhs.encrypted != rhs.encrypted {
            return false
        }
        if lhs.authenticated != rhs.authenticated {
            return false
        }
        if lhs.nonRepudiation != rhs.nonRepudiation {
            return false
        }
        if lhs.anonymousSender != rhs.anonymousSender {
            return false
        }
        if lhs.reWrappedInForward != rhs.reWrappedInForward {
            return false
        }
        if lhs.encryptedFromKid != rhs.encryptedFromKid {
            return false
        }
        if lhs.encryptedToKids != rhs.encryptedToKids {
            return false
        }
        if lhs.signFrom != rhs.signFrom {
            return false
        }
        if lhs.fromPriorIssuerKid != rhs.fromPriorIssuerKid {
            return false
        }
        if lhs.encAlgAuth != rhs.encAlgAuth {
            return false
        }
        if lhs.encAlgAnon != rhs.encAlgAnon {
            return false
        }
        if lhs.signAlg != rhs.signAlg {
            return false
        }
        if lhs.signedMessage != rhs.signedMessage {
            return false
        }
        if lhs.fromPrior != rhs.fromPrior {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(encrypted)
        hasher.combine(authenticated)
        hasher.combine(nonRepudiation)
        hasher.combine(anonymousSender)
        hasher.combine(reWrappedInForward)
        hasher.combine(encryptedFromKid)
        hasher.combine(encryptedToKids)
        hasher.combine(signFrom)
        hasher.combine(fromPriorIssuerKid)
        hasher.combine(encAlgAuth)
        hasher.combine(encAlgAnon)
        hasher.combine(signAlg)
        hasher.combine(signedMessage)
        hasher.combine(fromPrior)
    }
}


fileprivate extension UnpackMetadata {
    static func read(from buf: Reader) throws -> UnpackMetadata {
        return try UnpackMetadata(
            encrypted: Bool.read(from: buf),
            authenticated: Bool.read(from: buf),
            nonRepudiation: Bool.read(from: buf),
            anonymousSender: Bool.read(from: buf),
            reWrappedInForward: Bool.read(from: buf),
            encryptedFromKid: FfiConverterOptionString.read(from: buf),
            encryptedToKids: FfiConverterOptionSequenceString.read(from: buf),
            signFrom: FfiConverterOptionString.read(from: buf),
            fromPriorIssuerKid: FfiConverterOptionString.read(from: buf),
            encAlgAuth: FfiConverterOptionEnumAuthCryptAlg.read(from: buf),
            encAlgAnon: FfiConverterOptionEnumAnonCryptAlg.read(from: buf),
            signAlg: FfiConverterOptionEnumSignAlg.read(from: buf),
            signedMessage: FfiConverterOptionString.read(from: buf),
            fromPrior: FfiConverterOptionRecordFromPrior.read(from: buf)
        )
    }

    func write(into buf: Writer) {
        self.encrypted.write(into: buf)
        self.authenticated.write(into: buf)
        self.nonRepudiation.write(into: buf)
        self.anonymousSender.write(into: buf)
        self.reWrappedInForward.write(into: buf)
        FfiConverterOptionString.write(self.encryptedFromKid, into: buf)
        FfiConverterOptionSequenceString.write(self.encryptedToKids, into: buf)
        FfiConverterOptionString.write(self.signFrom, into: buf)
        FfiConverterOptionString.write(self.fromPriorIssuerKid, into: buf)
        FfiConverterOptionEnumAuthCryptAlg.write(self.encAlgAuth, into: buf)
        FfiConverterOptionEnumAnonCryptAlg.write(self.encAlgAnon, into: buf)
        FfiConverterOptionEnumSignAlg.write(self.signAlg, into: buf)
        FfiConverterOptionString.write(self.signedMessage, into: buf)
        FfiConverterOptionRecordFromPrior.write(self.fromPrior, into: buf)
    }
}

extension UnpackMetadata: ViaFfiUsingByteBuffer, ViaFfi {}

public struct UnpackOptions {
    public var expectDecryptByAllKeys: Bool
    public var unwrapReWrappingForward: Bool

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(expectDecryptByAllKeys: Bool, unwrapReWrappingForward: Bool ) {
        self.expectDecryptByAllKeys = expectDecryptByAllKeys
        self.unwrapReWrappingForward = unwrapReWrappingForward
    }
}


extension UnpackOptions: Equatable, Hashable {
    public static func ==(lhs: UnpackOptions, rhs: UnpackOptions) -> Bool {
        if lhs.expectDecryptByAllKeys != rhs.expectDecryptByAllKeys {
            return false
        }
        if lhs.unwrapReWrappingForward != rhs.unwrapReWrappingForward {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(expectDecryptByAllKeys)
        hasher.combine(unwrapReWrappingForward)
    }
}


fileprivate extension UnpackOptions {
    static func read(from buf: Reader) throws -> UnpackOptions {
        return try UnpackOptions(
            expectDecryptByAllKeys: Bool.read(from: buf),
            unwrapReWrappingForward: Bool.read(from: buf)
        )
    }

    func write(into buf: Writer) {
        self.expectDecryptByAllKeys.write(into: buf)
        self.unwrapReWrappingForward.write(into: buf)
    }
}

extension UnpackOptions: ViaFfiUsingByteBuffer, ViaFfi {}

public struct FromPrior {
    public var iss: String
    public var sub: String
    public var aud: String?
    public var exp: UInt64?
    public var nbf: UInt64?
    public var iat: UInt64?
    public var jti: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(iss: String, sub: String, aud: String?, exp: UInt64?, nbf: UInt64?, iat: UInt64?, jti: String? ) {
        self.iss = iss
        self.sub = sub
        self.aud = aud
        self.exp = exp
        self.nbf = nbf
        self.iat = iat
        self.jti = jti
    }
}


extension FromPrior: Equatable, Hashable {
    public static func ==(lhs: FromPrior, rhs: FromPrior) -> Bool {
        if lhs.iss != rhs.iss {
            return false
        }
        if lhs.sub != rhs.sub {
            return false
        }
        if lhs.aud != rhs.aud {
            return false
        }
        if lhs.exp != rhs.exp {
            return false
        }
        if lhs.nbf != rhs.nbf {
            return false
        }
        if lhs.iat != rhs.iat {
            return false
        }
        if lhs.jti != rhs.jti {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(iss)
        hasher.combine(sub)
        hasher.combine(aud)
        hasher.combine(exp)
        hasher.combine(nbf)
        hasher.combine(iat)
        hasher.combine(jti)
    }
}


fileprivate extension FromPrior {
    static func read(from buf: Reader) throws -> FromPrior {
        return try FromPrior(
            iss: String.read(from: buf),
            sub: String.read(from: buf),
            aud: FfiConverterOptionString.read(from: buf),
            exp: FfiConverterOptionUInt64.read(from: buf),
            nbf: FfiConverterOptionUInt64.read(from: buf),
            iat: FfiConverterOptionUInt64.read(from: buf),
            jti: FfiConverterOptionString.read(from: buf)
        )
    }

    func write(into buf: Writer) {
        self.iss.write(into: buf)
        self.sub.write(into: buf)
        FfiConverterOptionString.write(self.aud, into: buf)
        FfiConverterOptionUInt64.write(self.exp, into: buf)
        FfiConverterOptionUInt64.write(self.nbf, into: buf)
        FfiConverterOptionUInt64.write(self.iat, into: buf)
        FfiConverterOptionString.write(self.jti, into: buf)
    }
}

extension FromPrior: ViaFfiUsingByteBuffer, ViaFfi {}

public enum ErrorKind {

    
    
    // Simple error enums only carry a message
    case DidNotResolved(message: String)
    
    // Simple error enums only carry a message
    case DidUrlNotFound(message: String)
    
    // Simple error enums only carry a message
    case SecretNotFound(message: String)
    
    // Simple error enums only carry a message
    case Malformed(message: String)
    
    // Simple error enums only carry a message
    case IoError(message: String)
    
    // Simple error enums only carry a message
    case InvalidState(message: String)
    
    // Simple error enums only carry a message
    case NoCompatibleCrypto(message: String)
    
    // Simple error enums only carry a message
    case Unsupported(message: String)
    
    // Simple error enums only carry a message
    case IllegalArgument(message: String)
    
}

extension ErrorKind: ViaFfiUsingByteBuffer, ViaFfi {
    fileprivate static func read(from buf: Reader) throws -> ErrorKind {
        let variant: Int32 = try buf.readInt()
        switch variant {

        

        
        case 1: return .DidNotResolved(
            message: try String.read(from: buf)
        )
        
        case 2: return .DidUrlNotFound(
            message: try String.read(from: buf)
        )
        
        case 3: return .SecretNotFound(
            message: try String.read(from: buf)
        )
        
        case 4: return .Malformed(
            message: try String.read(from: buf)
        )
        
        case 5: return .IoError(
            message: try String.read(from: buf)
        )
        
        case 6: return .InvalidState(
            message: try String.read(from: buf)
        )
        
        case 7: return .NoCompatibleCrypto(
            message: try String.read(from: buf)
        )
        
        case 8: return .Unsupported(
            message: try String.read(from: buf)
        )
        
        case 9: return .IllegalArgument(
            message: try String.read(from: buf)
        )
        

         default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    fileprivate func write(into buf: Writer) {
        switch self {

        

        
        case let .DidNotResolved(message):
            buf.writeInt(Int32(1))
            message.write(into: buf)
        case let .DidUrlNotFound(message):
            buf.writeInt(Int32(2))
            message.write(into: buf)
        case let .SecretNotFound(message):
            buf.writeInt(Int32(3))
            message.write(into: buf)
        case let .Malformed(message):
            buf.writeInt(Int32(4))
            message.write(into: buf)
        case let .IoError(message):
            buf.writeInt(Int32(5))
            message.write(into: buf)
        case let .InvalidState(message):
            buf.writeInt(Int32(6))
            message.write(into: buf)
        case let .NoCompatibleCrypto(message):
            buf.writeInt(Int32(7))
            message.write(into: buf)
        case let .Unsupported(message):
            buf.writeInt(Int32(8))
            message.write(into: buf)
        case let .IllegalArgument(message):
            buf.writeInt(Int32(9))
            message.write(into: buf)
        }
    }
}


extension ErrorKind: Equatable, Hashable {}

extension ErrorKind: Error { }


// Declaration and FfiConverters for DidResolver Callback Interface

public protocol DidResolver : AnyObject {
    func resolve(did: String, cb: OnDidResolverResult )  -> ErrorCode
    
}

// The ForeignCallback that is passed to Rust.
fileprivate let foreignCallbackCallbackInterfaceDidResolver : ForeignCallback =
    { (handle: Handle, method: Int32, args: RustBuffer) -> RustBuffer in
        func invokeResolve(_ swiftCallbackInterface: DidResolver, _ args: RustBuffer) throws -> RustBuffer {
        defer { args.deallocate() }

            let reader = Reader(data: Data(rustBuffer: args))
            let result =  swiftCallbackInterface.resolve(
                    did: try String.read(from: reader), 
                    cb: try OnDidResolverResult.read(from: reader) 
                    )
            let writer = Writer()
                result.write(into: writer)
                return RustBuffer(bytes: writer.bytes)
                // TODO catch errors and report them back to Rust.
                // https://github.com/mozilla/uniffi-rs/issues/351

    }
    

        let cb = try! ffiConverterCallbackInterfaceDidResolver.lift(handle)
        switch method {
            case IDX_CALLBACK_FREE:
                ffiConverterCallbackInterfaceDidResolver.drop(handle: handle)
                return RustBuffer()
            case 1: return try! invokeResolve(cb, args)
            
            // This should never happen, because an out of bounds method index won't
            // ever be used. Once we can catch errors, we should return an InternalError.
            // https://github.com/mozilla/uniffi-rs/issues/351
            default: return RustBuffer()
        }
    }

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
private let ffiConverterCallbackInterfaceDidResolver: FfiConverterCallbackInterface<DidResolver> = {
    try! rustCall { (err: UnsafeMutablePointer<RustCallStatus>) in
            ffi_didcomm_7b5e_DIDResolver_init_callback(foreignCallbackCallbackInterfaceDidResolver, err)
    }
    return FfiConverterCallbackInterface<DidResolver>()
}()


// Declaration and FfiConverters for SecretsResolver Callback Interface

public protocol SecretsResolver : AnyObject {
    func getSecret(secretId: String, cb: OnGetSecretResult )  -> ErrorCode
    func findSecrets(secretIds: [String], cb: OnFindSecretsResult )  -> ErrorCode
    
}

// The ForeignCallback that is passed to Rust.
fileprivate let foreignCallbackCallbackInterfaceSecretsResolver : ForeignCallback =
    { (handle: Handle, method: Int32, args: RustBuffer) -> RustBuffer in
        func invokeGetSecret(_ swiftCallbackInterface: SecretsResolver, _ args: RustBuffer) throws -> RustBuffer {
        defer { args.deallocate() }

            let reader = Reader(data: Data(rustBuffer: args))
            let result =  swiftCallbackInterface.getSecret(
                    secretId: try String.read(from: reader), 
                    cb: try OnGetSecretResult.read(from: reader) 
                    )
            let writer = Writer()
                result.write(into: writer)
                return RustBuffer(bytes: writer.bytes)
                // TODO catch errors and report them back to Rust.
                // https://github.com/mozilla/uniffi-rs/issues/351

    }
    func invokeFindSecrets(_ swiftCallbackInterface: SecretsResolver, _ args: RustBuffer) throws -> RustBuffer {
        defer { args.deallocate() }

            let reader = Reader(data: Data(rustBuffer: args))
            let result =  swiftCallbackInterface.findSecrets(
                    secretIds: try FfiConverterSequenceString.read(from: reader), 
                    cb: try OnFindSecretsResult.read(from: reader) 
                    )
            let writer = Writer()
                result.write(into: writer)
                return RustBuffer(bytes: writer.bytes)
                // TODO catch errors and report them back to Rust.
                // https://github.com/mozilla/uniffi-rs/issues/351

    }
    

        let cb = try! ffiConverterCallbackInterfaceSecretsResolver.lift(handle)
        switch method {
            case IDX_CALLBACK_FREE:
                ffiConverterCallbackInterfaceSecretsResolver.drop(handle: handle)
                return RustBuffer()
            case 1: return try! invokeGetSecret(cb, args)
            case 2: return try! invokeFindSecrets(cb, args)
            
            // This should never happen, because an out of bounds method index won't
            // ever be used. Once we can catch errors, we should return an InternalError.
            // https://github.com/mozilla/uniffi-rs/issues/351
            default: return RustBuffer()
        }
    }

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
private let ffiConverterCallbackInterfaceSecretsResolver: FfiConverterCallbackInterface<SecretsResolver> = {
    try! rustCall { (err: UnsafeMutablePointer<RustCallStatus>) in
            ffi_didcomm_7b5e_SecretsResolver_init_callback(foreignCallbackCallbackInterfaceSecretsResolver, err)
    }
    return FfiConverterCallbackInterface<SecretsResolver>()
}()


// Declaration and FfiConverters for OnPackSignedResult Callback Interface

public protocol OnPackSignedResult : AnyObject {
    func success(result: String, metadata: PackSignedMetadata ) 
    func error(err: ErrorKind, msg: String ) 
    
}

// The ForeignCallback that is passed to Rust.
fileprivate let foreignCallbackCallbackInterfaceOnPackSignedResult : ForeignCallback =
    { (handle: Handle, method: Int32, args: RustBuffer) -> RustBuffer in
        func invokeSuccess(_ swiftCallbackInterface: OnPackSignedResult, _ args: RustBuffer) throws -> RustBuffer {
        defer { args.deallocate() }

            let reader = Reader(data: Data(rustBuffer: args))
              swiftCallbackInterface.success(
                    result: try String.read(from: reader), 
                    metadata: try PackSignedMetadata.read(from: reader) 
                    )
            return RustBuffer()
                // TODO catch errors and report them back to Rust.
                // https://github.com/mozilla/uniffi-rs/issues/351

    }
    func invokeError(_ swiftCallbackInterface: OnPackSignedResult, _ args: RustBuffer) throws -> RustBuffer {
        defer { args.deallocate() }

            let reader = Reader(data: Data(rustBuffer: args))
              swiftCallbackInterface.error(
                    err: try ErrorKind.read(from: reader), 
                    msg: try String.read(from: reader) 
                    )
            return RustBuffer()
                // TODO catch errors and report them back to Rust.
                // https://github.com/mozilla/uniffi-rs/issues/351

    }
    

        let cb = try! ffiConverterCallbackInterfaceOnPackSignedResult.lift(handle)
        switch method {
            case IDX_CALLBACK_FREE:
                ffiConverterCallbackInterfaceOnPackSignedResult.drop(handle: handle)
                return RustBuffer()
            case 1: return try! invokeSuccess(cb, args)
            case 2: return try! invokeError(cb, args)
            
            // This should never happen, because an out of bounds method index won't
            // ever be used. Once we can catch errors, we should return an InternalError.
            // https://github.com/mozilla/uniffi-rs/issues/351
            default: return RustBuffer()
        }
    }

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
private let ffiConverterCallbackInterfaceOnPackSignedResult: FfiConverterCallbackInterface<OnPackSignedResult> = {
    try! rustCall { (err: UnsafeMutablePointer<RustCallStatus>) in
            ffi_didcomm_7b5e_OnPackSignedResult_init_callback(foreignCallbackCallbackInterfaceOnPackSignedResult, err)
    }
    return FfiConverterCallbackInterface<OnPackSignedResult>()
}()


// Declaration and FfiConverters for OnPackEncryptedResult Callback Interface

public protocol OnPackEncryptedResult : AnyObject {
    func success(result: String, metadata: PackEncryptedMetadata ) 
    func error(err: ErrorKind, msg: String ) 
    
}

// The ForeignCallback that is passed to Rust.
fileprivate let foreignCallbackCallbackInterfaceOnPackEncryptedResult : ForeignCallback =
    { (handle: Handle, method: Int32, args: RustBuffer) -> RustBuffer in
        func invokeSuccess(_ swiftCallbackInterface: OnPackEncryptedResult, _ args: RustBuffer) throws -> RustBuffer {
        defer { args.deallocate() }

            let reader = Reader(data: Data(rustBuffer: args))
              swiftCallbackInterface.success(
                    result: try String.read(from: reader), 
                    metadata: try PackEncryptedMetadata.read(from: reader) 
                    )
            return RustBuffer()
                // TODO catch errors and report them back to Rust.
                // https://github.com/mozilla/uniffi-rs/issues/351

    }
    func invokeError(_ swiftCallbackInterface: OnPackEncryptedResult, _ args: RustBuffer) throws -> RustBuffer {
        defer { args.deallocate() }

            let reader = Reader(data: Data(rustBuffer: args))
              swiftCallbackInterface.error(
                    err: try ErrorKind.read(from: reader), 
                    msg: try String.read(from: reader) 
                    )
            return RustBuffer()
                // TODO catch errors and report them back to Rust.
                // https://github.com/mozilla/uniffi-rs/issues/351

    }
    

        let cb = try! ffiConverterCallbackInterfaceOnPackEncryptedResult.lift(handle)
        switch method {
            case IDX_CALLBACK_FREE:
                ffiConverterCallbackInterfaceOnPackEncryptedResult.drop(handle: handle)
                return RustBuffer()
            case 1: return try! invokeSuccess(cb, args)
            case 2: return try! invokeError(cb, args)
            
            // This should never happen, because an out of bounds method index won't
            // ever be used. Once we can catch errors, we should return an InternalError.
            // https://github.com/mozilla/uniffi-rs/issues/351
            default: return RustBuffer()
        }
    }

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
private let ffiConverterCallbackInterfaceOnPackEncryptedResult: FfiConverterCallbackInterface<OnPackEncryptedResult> = {
    try! rustCall { (err: UnsafeMutablePointer<RustCallStatus>) in
            ffi_didcomm_7b5e_OnPackEncryptedResult_init_callback(foreignCallbackCallbackInterfaceOnPackEncryptedResult, err)
    }
    return FfiConverterCallbackInterface<OnPackEncryptedResult>()
}()


// Declaration and FfiConverters for OnPackPlaintextResult Callback Interface

public protocol OnPackPlaintextResult : AnyObject {
    func success(result: String ) 
    func error(err: ErrorKind, msg: String ) 
    
}

// The ForeignCallback that is passed to Rust.
fileprivate let foreignCallbackCallbackInterfaceOnPackPlaintextResult : ForeignCallback =
    { (handle: Handle, method: Int32, args: RustBuffer) -> RustBuffer in
        func invokeSuccess(_ swiftCallbackInterface: OnPackPlaintextResult, _ args: RustBuffer) throws -> RustBuffer {
        defer { args.deallocate() }

            let reader = Reader(data: Data(rustBuffer: args))
              swiftCallbackInterface.success(
                    result: try String.read(from: reader) 
                    )
            return RustBuffer()
                // TODO catch errors and report them back to Rust.
                // https://github.com/mozilla/uniffi-rs/issues/351

    }
    func invokeError(_ swiftCallbackInterface: OnPackPlaintextResult, _ args: RustBuffer) throws -> RustBuffer {
        defer { args.deallocate() }

            let reader = Reader(data: Data(rustBuffer: args))
              swiftCallbackInterface.error(
                    err: try ErrorKind.read(from: reader), 
                    msg: try String.read(from: reader) 
                    )
            return RustBuffer()
                // TODO catch errors and report them back to Rust.
                // https://github.com/mozilla/uniffi-rs/issues/351

    }
    

        let cb = try! ffiConverterCallbackInterfaceOnPackPlaintextResult.lift(handle)
        switch method {
            case IDX_CALLBACK_FREE:
                ffiConverterCallbackInterfaceOnPackPlaintextResult.drop(handle: handle)
                return RustBuffer()
            case 1: return try! invokeSuccess(cb, args)
            case 2: return try! invokeError(cb, args)
            
            // This should never happen, because an out of bounds method index won't
            // ever be used. Once we can catch errors, we should return an InternalError.
            // https://github.com/mozilla/uniffi-rs/issues/351
            default: return RustBuffer()
        }
    }

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
private let ffiConverterCallbackInterfaceOnPackPlaintextResult: FfiConverterCallbackInterface<OnPackPlaintextResult> = {
    try! rustCall { (err: UnsafeMutablePointer<RustCallStatus>) in
            ffi_didcomm_7b5e_OnPackPlaintextResult_init_callback(foreignCallbackCallbackInterfaceOnPackPlaintextResult, err)
    }
    return FfiConverterCallbackInterface<OnPackPlaintextResult>()
}()


// Declaration and FfiConverters for OnUnpackResult Callback Interface

public protocol OnUnpackResult : AnyObject {
    func success(result: Message, metadata: UnpackMetadata ) 
    func error(err: ErrorKind, msg: String ) 
    
}

// The ForeignCallback that is passed to Rust.
fileprivate let foreignCallbackCallbackInterfaceOnUnpackResult : ForeignCallback =
    { (handle: Handle, method: Int32, args: RustBuffer) -> RustBuffer in
        func invokeSuccess(_ swiftCallbackInterface: OnUnpackResult, _ args: RustBuffer) throws -> RustBuffer {
        defer { args.deallocate() }

            let reader = Reader(data: Data(rustBuffer: args))
              swiftCallbackInterface.success(
                    result: try Message.read(from: reader), 
                    metadata: try UnpackMetadata.read(from: reader) 
                    )
            return RustBuffer()
                // TODO catch errors and report them back to Rust.
                // https://github.com/mozilla/uniffi-rs/issues/351

    }
    func invokeError(_ swiftCallbackInterface: OnUnpackResult, _ args: RustBuffer) throws -> RustBuffer {
        defer { args.deallocate() }

            let reader = Reader(data: Data(rustBuffer: args))
              swiftCallbackInterface.error(
                    err: try ErrorKind.read(from: reader), 
                    msg: try String.read(from: reader) 
                    )
            return RustBuffer()
                // TODO catch errors and report them back to Rust.
                // https://github.com/mozilla/uniffi-rs/issues/351

    }
    

        let cb = try! ffiConverterCallbackInterfaceOnUnpackResult.lift(handle)
        switch method {
            case IDX_CALLBACK_FREE:
                ffiConverterCallbackInterfaceOnUnpackResult.drop(handle: handle)
                return RustBuffer()
            case 1: return try! invokeSuccess(cb, args)
            case 2: return try! invokeError(cb, args)
            
            // This should never happen, because an out of bounds method index won't
            // ever be used. Once we can catch errors, we should return an InternalError.
            // https://github.com/mozilla/uniffi-rs/issues/351
            default: return RustBuffer()
        }
    }

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
private let ffiConverterCallbackInterfaceOnUnpackResult: FfiConverterCallbackInterface<OnUnpackResult> = {
    try! rustCall { (err: UnsafeMutablePointer<RustCallStatus>) in
            ffi_didcomm_7b5e_OnUnpackResult_init_callback(foreignCallbackCallbackInterfaceOnUnpackResult, err)
    }
    return FfiConverterCallbackInterface<OnUnpackResult>()
}()


// Declaration and FfiConverters for OnFromPriorPackResult Callback Interface

public protocol OnFromPriorPackResult : AnyObject {
    func success(fromPriorJwt: String, kid: String ) 
    func error(err: ErrorKind, msg: String ) 
    
}

// The ForeignCallback that is passed to Rust.
fileprivate let foreignCallbackCallbackInterfaceOnFromPriorPackResult : ForeignCallback =
    { (handle: Handle, method: Int32, args: RustBuffer) -> RustBuffer in
        func invokeSuccess(_ swiftCallbackInterface: OnFromPriorPackResult, _ args: RustBuffer) throws -> RustBuffer {
        defer { args.deallocate() }

            let reader = Reader(data: Data(rustBuffer: args))
              swiftCallbackInterface.success(
                    fromPriorJwt: try String.read(from: reader), 
                    kid: try String.read(from: reader) 
                    )
            return RustBuffer()
                // TODO catch errors and report them back to Rust.
                // https://github.com/mozilla/uniffi-rs/issues/351

    }
    func invokeError(_ swiftCallbackInterface: OnFromPriorPackResult, _ args: RustBuffer) throws -> RustBuffer {
        defer { args.deallocate() }

            let reader = Reader(data: Data(rustBuffer: args))
              swiftCallbackInterface.error(
                    err: try ErrorKind.read(from: reader), 
                    msg: try String.read(from: reader) 
                    )
            return RustBuffer()
                // TODO catch errors and report them back to Rust.
                // https://github.com/mozilla/uniffi-rs/issues/351

    }
    

        let cb = try! ffiConverterCallbackInterfaceOnFromPriorPackResult.lift(handle)
        switch method {
            case IDX_CALLBACK_FREE:
                ffiConverterCallbackInterfaceOnFromPriorPackResult.drop(handle: handle)
                return RustBuffer()
            case 1: return try! invokeSuccess(cb, args)
            case 2: return try! invokeError(cb, args)
            
            // This should never happen, because an out of bounds method index won't
            // ever be used. Once we can catch errors, we should return an InternalError.
            // https://github.com/mozilla/uniffi-rs/issues/351
            default: return RustBuffer()
        }
    }

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
private let ffiConverterCallbackInterfaceOnFromPriorPackResult: FfiConverterCallbackInterface<OnFromPriorPackResult> = {
    try! rustCall { (err: UnsafeMutablePointer<RustCallStatus>) in
            ffi_didcomm_7b5e_OnFromPriorPackResult_init_callback(foreignCallbackCallbackInterfaceOnFromPriorPackResult, err)
    }
    return FfiConverterCallbackInterface<OnFromPriorPackResult>()
}()


// Declaration and FfiConverters for OnFromPriorUnpackResult Callback Interface

public protocol OnFromPriorUnpackResult : AnyObject {
    func success(fromPrior: FromPrior, kid: String ) 
    func error(err: ErrorKind, msg: String ) 
    
}

// The ForeignCallback that is passed to Rust.
fileprivate let foreignCallbackCallbackInterfaceOnFromPriorUnpackResult : ForeignCallback =
    { (handle: Handle, method: Int32, args: RustBuffer) -> RustBuffer in
        func invokeSuccess(_ swiftCallbackInterface: OnFromPriorUnpackResult, _ args: RustBuffer) throws -> RustBuffer {
        defer { args.deallocate() }

            let reader = Reader(data: Data(rustBuffer: args))
              swiftCallbackInterface.success(
                    fromPrior: try FromPrior.read(from: reader), 
                    kid: try String.read(from: reader) 
                    )
            return RustBuffer()
                // TODO catch errors and report them back to Rust.
                // https://github.com/mozilla/uniffi-rs/issues/351

    }
    func invokeError(_ swiftCallbackInterface: OnFromPriorUnpackResult, _ args: RustBuffer) throws -> RustBuffer {
        defer { args.deallocate() }

            let reader = Reader(data: Data(rustBuffer: args))
              swiftCallbackInterface.error(
                    err: try ErrorKind.read(from: reader), 
                    msg: try String.read(from: reader) 
                    )
            return RustBuffer()
                // TODO catch errors and report them back to Rust.
                // https://github.com/mozilla/uniffi-rs/issues/351

    }
    

        let cb = try! ffiConverterCallbackInterfaceOnFromPriorUnpackResult.lift(handle)
        switch method {
            case IDX_CALLBACK_FREE:
                ffiConverterCallbackInterfaceOnFromPriorUnpackResult.drop(handle: handle)
                return RustBuffer()
            case 1: return try! invokeSuccess(cb, args)
            case 2: return try! invokeError(cb, args)
            
            // This should never happen, because an out of bounds method index won't
            // ever be used. Once we can catch errors, we should return an InternalError.
            // https://github.com/mozilla/uniffi-rs/issues/351
            default: return RustBuffer()
        }
    }

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
private let ffiConverterCallbackInterfaceOnFromPriorUnpackResult: FfiConverterCallbackInterface<OnFromPriorUnpackResult> = {
    try! rustCall { (err: UnsafeMutablePointer<RustCallStatus>) in
            ffi_didcomm_7b5e_OnFromPriorUnpackResult_init_callback(foreignCallbackCallbackInterfaceOnFromPriorUnpackResult, err)
    }
    return FfiConverterCallbackInterface<OnFromPriorUnpackResult>()
}()


// Declaration and FfiConverters for OnWrapInForwardResult Callback Interface

public protocol OnWrapInForwardResult : AnyObject {
    func success(result: String ) 
    func error(err: ErrorKind, msg: String ) 
    
}

// The ForeignCallback that is passed to Rust.
fileprivate let foreignCallbackCallbackInterfaceOnWrapInForwardResult : ForeignCallback =
    { (handle: Handle, method: Int32, args: RustBuffer) -> RustBuffer in
        func invokeSuccess(_ swiftCallbackInterface: OnWrapInForwardResult, _ args: RustBuffer) throws -> RustBuffer {
        defer { args.deallocate() }

            let reader = Reader(data: Data(rustBuffer: args))
              swiftCallbackInterface.success(
                    result: try String.read(from: reader) 
                    )
            return RustBuffer()
                // TODO catch errors and report them back to Rust.
                // https://github.com/mozilla/uniffi-rs/issues/351

    }
    func invokeError(_ swiftCallbackInterface: OnWrapInForwardResult, _ args: RustBuffer) throws -> RustBuffer {
        defer { args.deallocate() }

            let reader = Reader(data: Data(rustBuffer: args))
              swiftCallbackInterface.error(
                    err: try ErrorKind.read(from: reader), 
                    msg: try String.read(from: reader) 
                    )
            return RustBuffer()
                // TODO catch errors and report them back to Rust.
                // https://github.com/mozilla/uniffi-rs/issues/351

    }
    

        let cb = try! ffiConverterCallbackInterfaceOnWrapInForwardResult.lift(handle)
        switch method {
            case IDX_CALLBACK_FREE:
                ffiConverterCallbackInterfaceOnWrapInForwardResult.drop(handle: handle)
                return RustBuffer()
            case 1: return try! invokeSuccess(cb, args)
            case 2: return try! invokeError(cb, args)
            
            // This should never happen, because an out of bounds method index won't
            // ever be used. Once we can catch errors, we should return an InternalError.
            // https://github.com/mozilla/uniffi-rs/issues/351
            default: return RustBuffer()
        }
    }

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
private let ffiConverterCallbackInterfaceOnWrapInForwardResult: FfiConverterCallbackInterface<OnWrapInForwardResult> = {
    try! rustCall { (err: UnsafeMutablePointer<RustCallStatus>) in
            ffi_didcomm_7b5e_OnWrapInForwardResult_init_callback(foreignCallbackCallbackInterfaceOnWrapInForwardResult, err)
    }
    return FfiConverterCallbackInterface<OnWrapInForwardResult>()
}()
extension UInt64: Primitive, ViaFfi {
    fileprivate static func read(from buf: Reader) throws -> Self {
        return try self.lift(buf.readInt())
    }

    fileprivate func write(into buf: Writer) {
        buf.writeInt(self.lower())
    }
}
extension Bool: ViaFfi {
    fileprivate typealias FfiType = Int8

    fileprivate static func read(from buf: Reader) throws -> Self {
        return try self.lift(buf.readInt())
    }

    fileprivate func write(into buf: Writer) {
        buf.writeInt(self.lower())
    }

    fileprivate static func lift(_ v: FfiType) throws -> Self {
        return v != 0
    }

    fileprivate func lower() -> FfiType {
        return self ? 1 : 0
    }
}
extension String: ViaFfi {
    fileprivate typealias FfiType = RustBuffer

    fileprivate static func lift(_ v: FfiType) throws -> Self {
        defer {
            v.deallocate()
        }
        if v.data == nil {
            return String()
        }
        let bytes = UnsafeBufferPointer<UInt8>(start: v.data!, count: Int(v.len))
        return String(bytes: bytes, encoding: String.Encoding.utf8)!
    }

    fileprivate func lower() -> FfiType {
        return self.utf8CString.withUnsafeBufferPointer { ptr in
            // The swift string gives us int8_t, we want uint8_t.
            ptr.withMemoryRebound(to: UInt8.self) { ptr in
                // The swift string gives us a trailing null byte, we don't want it.
                let buf = UnsafeBufferPointer(rebasing: ptr.prefix(upTo: ptr.count - 1))
                return RustBuffer.from(buf)
            }
        }
    }

    fileprivate static func read(from buf: Reader) throws -> Self {
        let len: Int32 = try buf.readInt()
        return String(bytes: try buf.readBytes(count: Int(len)), encoding: String.Encoding.utf8)!
    }

    fileprivate func write(into buf: Writer) {
        let len = Int32(self.utf8.count)
        buf.writeInt(len)
        buf.writeBytes(self.utf8)
    }
}
// Helper code for DidComm class is found in ObjectTemplate.swift
// Helper code for ExampleDidResolver class is found in ObjectTemplate.swift
// Helper code for ExampleSecretsResolver class is found in ObjectTemplate.swift
// Helper code for OnDidResolverResult class is found in ObjectTemplate.swift
// Helper code for OnFindSecretsResult class is found in ObjectTemplate.swift
// Helper code for OnGetSecretResult class is found in ObjectTemplate.swift
// Helper code for Attachment record is found in RecordTemplate.swift
// Helper code for Base64AttachmentData record is found in RecordTemplate.swift
// Helper code for DidCommMessagingService record is found in RecordTemplate.swift
// Helper code for DidDoc record is found in RecordTemplate.swift
// Helper code for FromPrior record is found in RecordTemplate.swift
// Helper code for JsonAttachmentData record is found in RecordTemplate.swift
// Helper code for LinksAttachmentData record is found in RecordTemplate.swift
// Helper code for Message record is found in RecordTemplate.swift
// Helper code for MessagingServiceMetadata record is found in RecordTemplate.swift
// Helper code for PackEncryptedMetadata record is found in RecordTemplate.swift
// Helper code for PackEncryptedOptions record is found in RecordTemplate.swift
// Helper code for PackSignedMetadata record is found in RecordTemplate.swift
// Helper code for Secret record is found in RecordTemplate.swift
// Helper code for Service record is found in RecordTemplate.swift
// Helper code for UnpackMetadata record is found in RecordTemplate.swift
// Helper code for UnpackOptions record is found in RecordTemplate.swift
// Helper code for VerificationMethod record is found in RecordTemplate.swift
// Helper code for AnonCryptAlg enum is found in EnumTemplate.swift
// Helper code for AttachmentData enum is found in EnumTemplate.swift
// Helper code for AuthCryptAlg enum is found in EnumTemplate.swift
// Helper code for ErrorCode enum is found in EnumTemplate.swift
// Helper code for SecretMaterial enum is found in EnumTemplate.swift
// Helper code for SecretType enum is found in EnumTemplate.swift
// Helper code for ServiceKind enum is found in EnumTemplate.swift
// Helper code for SignAlg enum is found in EnumTemplate.swift
// Helper code for VerificationMaterial enum is found in EnumTemplate.swift
// Helper code for VerificationMethodType enum is found in EnumTemplate.swift
// Helper code for ErrorKind error is found in ErrorTemplate.swift

fileprivate enum FfiConverterOptionUInt64: FfiConverterUsingByteBuffer {
    typealias SwiftType = UInt64?

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterOptional.write(value, into: buf) { item, buf in
            item.write(into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterOptional.read(from: buf) { buf in
            try UInt64.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterOptionString: FfiConverterUsingByteBuffer {
    typealias SwiftType = String?

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterOptional.write(value, into: buf) { item, buf in
            item.write(into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterOptional.read(from: buf) { buf in
            try String.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterOptionRecordDidDoc: FfiConverterUsingByteBuffer {
    typealias SwiftType = DidDoc?

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterOptional.write(value, into: buf) { item, buf in
            item.write(into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterOptional.read(from: buf) { buf in
            try DidDoc.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterOptionRecordFromPrior: FfiConverterUsingByteBuffer {
    typealias SwiftType = FromPrior?

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterOptional.write(value, into: buf) { item, buf in
            item.write(into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterOptional.read(from: buf) { buf in
            try FromPrior.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterOptionRecordMessagingServiceMetadata: FfiConverterUsingByteBuffer {
    typealias SwiftType = MessagingServiceMetadata?

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterOptional.write(value, into: buf) { item, buf in
            item.write(into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterOptional.read(from: buf) { buf in
            try MessagingServiceMetadata.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterOptionRecordSecret: FfiConverterUsingByteBuffer {
    typealias SwiftType = Secret?

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterOptional.write(value, into: buf) { item, buf in
            item.write(into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterOptional.read(from: buf) { buf in
            try Secret.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterOptionEnumAnonCryptAlg: FfiConverterUsingByteBuffer {
    typealias SwiftType = AnonCryptAlg?

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterOptional.write(value, into: buf) { item, buf in
            item.write(into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterOptional.read(from: buf) { buf in
            try AnonCryptAlg.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterOptionEnumAuthCryptAlg: FfiConverterUsingByteBuffer {
    typealias SwiftType = AuthCryptAlg?

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterOptional.write(value, into: buf) { item, buf in
            item.write(into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterOptional.read(from: buf) { buf in
            try AuthCryptAlg.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterOptionEnumSignAlg: FfiConverterUsingByteBuffer {
    typealias SwiftType = SignAlg?

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterOptional.write(value, into: buf) { item, buf in
            item.write(into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterOptional.read(from: buf) { buf in
            try SignAlg.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterOptionSequenceString: FfiConverterUsingByteBuffer {
    typealias SwiftType = [String]?

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterOptional.write(value, into: buf) { item, buf in
            FfiConverterSequenceString.write(item, into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterOptional.read(from: buf) { buf in
            try FfiConverterSequenceString.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterOptionSequenceRecordAttachment: FfiConverterUsingByteBuffer {
    typealias SwiftType = [Attachment]?

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterOptional.write(value, into: buf) { item, buf in
            FfiConverterSequenceRecordAttachment.write(item, into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterOptional.read(from: buf) { buf in
            try FfiConverterSequenceRecordAttachment.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterOptionDictionaryJsonValue: FfiConverterUsingByteBuffer {
    typealias SwiftType = [String: String]?

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterOptional.write(value, into: buf) { item, buf in
            FfiConverterDictionaryJsonValue.write(item, into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterOptional.read(from: buf) { buf in
            try FfiConverterDictionaryJsonValue.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterSequenceString: FfiConverterUsingByteBuffer {
    typealias SwiftType = [String]

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterSequence.write(value, into: buf) { (item, buf) in
            item.write(into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterSequence.read(from: buf) { buf in
            try String.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterSequenceRecordAttachment: FfiConverterUsingByteBuffer {
    typealias SwiftType = [Attachment]

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterSequence.write(value, into: buf) { (item, buf) in
            item.write(into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterSequence.read(from: buf) { buf in
            try Attachment.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterSequenceRecordDidDoc: FfiConverterUsingByteBuffer {
    typealias SwiftType = [DidDoc]

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterSequence.write(value, into: buf) { (item, buf) in
            item.write(into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterSequence.read(from: buf) { buf in
            try DidDoc.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterSequenceRecordSecret: FfiConverterUsingByteBuffer {
    typealias SwiftType = [Secret]

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterSequence.write(value, into: buf) { (item, buf) in
            item.write(into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterSequence.read(from: buf) { buf in
            try Secret.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterSequenceRecordService: FfiConverterUsingByteBuffer {
    typealias SwiftType = [Service]

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterSequence.write(value, into: buf) { (item, buf) in
            item.write(into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterSequence.read(from: buf) { buf in
            try Service.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterSequenceRecordVerificationMethod: FfiConverterUsingByteBuffer {
    typealias SwiftType = [VerificationMethod]

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterSequence.write(value, into: buf) { (item, buf) in
            item.write(into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterSequence.read(from: buf) { buf in
            try VerificationMethod.read(from: buf)
        }
    }
}

fileprivate enum FfiConverterDictionaryJsonValue: FfiConverterUsingByteBuffer {
    typealias SwiftType = [String: String]

    static func write(_ value: SwiftType, into buf: Writer) {
        FfiConverterDictionary.write(value, into: buf) { (key, value, buf) in
            key.write(into: buf)
            value.write(into: buf)
        }
    }

    static func read(from buf: Reader) throws -> SwiftType {
        try FfiConverterDictionary.read(from: buf) { buf in
            (try String.read(from: buf),
            try String.read(from: buf))
        }
    }
}


/**
 * Top level initializers and tear down methods.
 *
 * This is generated by uniffi.
 */
public enum DidcommLifecycle {
    /**
     * Initialize the FFI and Rust library. This should be only called once per application.
     */
    func initialize() {
        
        // No initialization code needed
        
    }
}