// License: see LICENSE file at root directory of `master` branch

extern crate dia_time;

use dia_time::{
    decis, centis, millis, micros, nanos, picos, femtos, attos, zeptos, yoctos, symbols,
    SECOND, MINUTE, HOUR, DAY, WEEK,
    DECASECOND, HECTOSECOND, KILOSECOND, MEGASECOND, GIGASECOND, TERASECOND, PETASECOND, EXASECOND, ZETTASECOND, YOTTASECOND
};

#[test]
fn seconds() {
    assert_eq!(SECOND,        1_u64);
    assert_eq!(MINUTE,       60_u64);
    assert_eq!(HOUR,      3_600_u64);
    assert_eq!(DAY,      86_400_u64);
    assert_eq!(WEEK,    604_800_u64);

    assert_eq!(DECASECOND,                                  10_u64);
    assert_eq!(HECTOSECOND,                                100_u64);
    assert_eq!(KILOSECOND,                               1_000_u64);
    assert_eq!(MEGASECOND,                           1_000_000_u64);
    assert_eq!(GIGASECOND,                       1_000_000_000_u64);
    assert_eq!(TERASECOND,                   1_000_000_000_000_u64);
    assert_eq!(PETASECOND,               1_000_000_000_000_000_u64);
    assert_eq!(EXASECOND,            1_000_000_000_000_000_000_u64);
    assert_eq!(ZETTASECOND,     1_000_000_000_000_000_000_000_u128);
    assert_eq!(YOTTASECOND, 1_000_000_000_000_000_000_000_000_u128);
}

#[test]
fn decis() {
    assert_eq!(decis::SECOND,          10_u64);
    assert_eq!(decis::MINUTE,         600_u64);
    assert_eq!(decis::HOUR,        36_000_u64);
    assert_eq!(decis::DAY,        864_000_u64);
    assert_eq!(decis::WEEK,     6_048_000_u64);
}

#[test]
fn centis() {
    assert_eq!(centis::SECOND,         100_u64);
    assert_eq!(centis::MINUTE,       6_000_u64);
    assert_eq!(centis::HOUR,       360_000_u64);
    assert_eq!(centis::DAY,      8_640_000_u64);
    assert_eq!(centis::WEEK,    6_0480_000_u64);
}

#[test]
fn millis() {
    assert_eq!(millis::SECOND,        1_000_u64);
    assert_eq!(millis::MINUTE,       60_000_u64);
    assert_eq!(millis::HOUR,      3_600_000_u64);
    assert_eq!(millis::DAY,      86_400_000_u64);
    assert_eq!(millis::WEEK,    604_800_000_u64);
}

#[test]
fn micros() {
    assert_eq!(micros::SECOND,        1_000_000_u64);
    assert_eq!(micros::MINUTE,       60_000_000_u64);
    assert_eq!(micros::HOUR,      3_600_000_000_u64);
    assert_eq!(micros::DAY,      86_400_000_000_u64);
    assert_eq!(micros::WEEK,    604_800_000_000_u64);
}

#[test]
fn nanos() {
    assert_eq!(nanos::SECOND,     1_000_000_000_u64);
    assert_eq!(nanos::MINUTE,    60_000_000_000_u64);
    assert_eq!(nanos::HOUR,   3_600_000_000_000_u64);
    assert_eq!(nanos::DAY,   86_400_000_000_000_u64);
    assert_eq!(nanos::WEEK, 604_800_000_000_000_u64);
}

#[test]
fn picos() {
    assert_eq!(picos::SECOND,         1_000_000_000_000_u64);
    assert_eq!(picos::MINUTE,        60_000_000_000_000_u64);
    assert_eq!(picos::HOUR,       3_600_000_000_000_000_u64);
    assert_eq!(picos::DAY,       86_400_000_000_000_000_u64);
    assert_eq!(picos::WEEK,     604_800_000_000_000_000_u64);
}

#[test]
fn femtos() {
    assert_eq!(femtos::SECOND,        1_000_000_000_000_000_u128);
    assert_eq!(femtos::MINUTE,       60_000_000_000_000_000_u128);
    assert_eq!(femtos::HOUR,      3_600_000_000_000_000_000_u128);
    assert_eq!(femtos::DAY,      86_400_000_000_000_000_000_u128);
    assert_eq!(femtos::WEEK,    604_800_000_000_000_000_000_u128);
}

#[test]
fn attos() {
    assert_eq!(attos::SECOND,        1_000_000_000_000_000_000_u128);
    assert_eq!(attos::MINUTE,       60_000_000_000_000_000_000_u128);
    assert_eq!(attos::HOUR,      3_600_000_000_000_000_000_000_u128);
    assert_eq!(attos::DAY,      86_400_000_000_000_000_000_000_u128);
    assert_eq!(attos::WEEK,    604_800_000_000_000_000_000_000_u128);
}

#[test]
fn zeptos() {
    assert_eq!(zeptos::SECOND,        1_000_000_000_000_000_000_000_u128);
    assert_eq!(zeptos::MINUTE,       60_000_000_000_000_000_000_000_u128);
    assert_eq!(zeptos::HOUR,      3_600_000_000_000_000_000_000_000_u128);
    assert_eq!(zeptos::DAY,      86_400_000_000_000_000_000_000_000_u128);
    assert_eq!(zeptos::WEEK,    604_800_000_000_000_000_000_000_000_u128);
}

#[test]
fn yoctos() {
    assert_eq!(yoctos::SECOND,        1_000_000_000_000_000_000_000_000_u128);
    assert_eq!(yoctos::MINUTE,       60_000_000_000_000_000_000_000_000_u128);
    assert_eq!(yoctos::HOUR,      3_600_000_000_000_000_000_000_000_000_u128);
    assert_eq!(yoctos::DAY,      86_400_000_000_000_000_000_000_000_000_u128);
    assert_eq!(yoctos::WEEK,    604_800_000_000_000_000_000_000_000_000_u128);
}

#[test]
fn symbols() {
    assert_eq!(symbols::DECISECOND,     "ds");
    assert_eq!(symbols::CENTISECOND,    "cs");
    assert_eq!(symbols::MILLISECOND,    "ms");
    assert_eq!(symbols::MICROSECOND,    "µs");
    assert_eq!(symbols::NANOSECOND,     "ns");
    assert_eq!(symbols::PICOSECOND,     "ps");
    assert_eq!(symbols::FEMTOSECOND,    "fs");
    assert_eq!(symbols::ATTOSECOND,     "as");
    assert_eq!(symbols::ZEPTOSECOND,    "zs");
    assert_eq!(symbols::YOCTOSECOND,    "ys");

    assert_eq!(symbols::DECASECOND,     "das");
    assert_eq!(symbols::HECTOSECOND,    "hs");
    assert_eq!(symbols::KILOSECOND,     "ks");
    assert_eq!(symbols::MEGASECOND,     "Ms");
    assert_eq!(symbols::GIGASECOND,     "Gs");
    assert_eq!(symbols::TERASECOND,     "Ts");
    assert_eq!(symbols::PETASECOND,     "Ps");
    assert_eq!(symbols::EXASECOND,      "Es");
    assert_eq!(symbols::ZETTASECOND,    "Zs");
    assert_eq!(symbols::YOTTASECOND,    "Ys");
}

#[test]
fn time() {
    macro_rules! test { ($($module: ident, $factor: expr, $ty: ty,)+) => {{
        $(
            assert_eq!($module::SECOND, $factor);
            assert_eq!($module::MINUTE, $factor * <$ty>::from(MINUTE));
            assert_eq!($module::HOUR,   $factor * <$ty>::from(HOUR));
            assert_eq!($module::DAY,    $factor * <$ty>::from(DAY));
            assert_eq!($module::WEEK,   $factor * <$ty>::from(WEEK));
        )+
    }};}

    test!(
        decis,                                 10_u64, u64,
        centis,                               100_u64, u64,
        millis,                             1_000_u64, u64,
        micros,                         1_000_000_u64, u64,
        nanos,                      1_000_000_000_u64, u64,
        picos,                  1_000_000_000_000_u64, u64,
        femtos,             1_000_000_000_000_000_u128, u128,
        attos,          1_000_000_000_000_000_000_u128, u128,
        zeptos,     1_000_000_000_000_000_000_000_u128, u128,
        yoctos, 1_000_000_000_000_000_000_000_000_u128, u128,
    );
}
