// License: see LICENSE file at root directory of `master` branch

//! # Tests

#![cfg(test)]

use {
    core::convert::TryFrom,

    crate::{Month},
};

#[test]
fn test_consts() {
    assert_eq!(super::END_OF_FEBRUARY_IN_COMMON_YEARS, 28);
    assert_eq!(super::END_OF_FEBRUARY_IN_LEAP_YEARS, 29);

    assert_eq!(super::SECONDS_OF_28_DAYS, i64::try_from(crate::DAY.checked_mul(28).unwrap()).unwrap());
    assert_eq!(super::SECONDS_OF_29_DAYS, i64::try_from(crate::DAY.checked_mul(29).unwrap()).unwrap());
    assert_eq!(super::SECONDS_OF_30_DAYS, i64::try_from(crate::DAY.checked_mul(30).unwrap()).unwrap());
    assert_eq!(super::SECONDS_OF_31_DAYS, i64::try_from(crate::DAY.checked_mul(31).unwrap()).unwrap());
}

#[test]
fn tests() {
    [
        Month::January, Month::February, Month::March, Month::April, Month::May, Month::June, Month::July, Month::August, Month::September,
        Month::October, Month::November, Month::December,
    ].iter().enumerate().for_each(|(i, m)| {
        let order = u8::try_from(i.checked_add(1).unwrap()).unwrap();
        assert_eq!(m.order(), order);
        assert_eq!(m, &Month::try_from_order(order).unwrap());
    });

    for (month, next) in &[
        (Month::January, Some(Month::February)),
        (Month::February, Some(Month::March)),
        (Month::March, Some(Month::April)),
        (Month::April, Some(Month::May)),
        (Month::May, Some(Month::June)),
        (Month::June, Some(Month::July)),
        (Month::July, Some(Month::August)),
        (Month::August, Some(Month::September)),
        (Month::September,Some(Month::October)),
        (Month::October, Some(Month::November)),
        (Month::November, Some(Month::December)),
        (Month::December, None),
    ] {
        assert_eq!(&month.next(), next);
    }

    for (month, next) in &[
        (Month::January, Month::February),
        (Month::February, Month::March),
        (Month::March, Month::April),
        (Month::April, Month::May),
        (Month::May, Month::June),
        (Month::June, Month::July),
        (Month::July, Month::August),
        (Month::August, Month::September),
        (Month::September,Month::October),
        (Month::October, Month::November),
        (Month::November, Month::December),
        (Month::December, Month::January),
    ] {
        assert_eq!(&month.wrapping_next(), next);
    }

    for (month, last) in &[
        (Month::January, None),
        (Month::February, Some(Month::January)),
        (Month::March, Some(Month::February)),
        (Month::April, Some(Month::March)),
        (Month::May, Some(Month::April)),
        (Month::June, Some(Month::May)),
        (Month::July, Some(Month::June)),
        (Month::August, Some(Month::July)),
        (Month::September,Some(Month::August)),
        (Month::October, Some(Month::September)),
        (Month::November, Some(Month::October)),
        (Month::December, Some(Month::November)),
    ] {
        assert_eq!(&month.last(), last);
    }

    for (month, last) in &[
        (Month::January, Month::December),
        (Month::February, Month::January),
        (Month::March, Month::February),
        (Month::April, Month::March),
        (Month::May, Month::April),
        (Month::June, Month::May),
        (Month::July, Month::June),
        (Month::August, Month::July),
        (Month::September,Month::August),
        (Month::October, Month::September),
        (Month::November, Month::October),
        (Month::December, Month::November),
    ] {
        assert_eq!(&month.wrapping_last(), last);
    }
}
