// License: see LICENSE file at root directory of `master` branch

use {
    std::{
        borrow::Cow,
    },

    dia_args::{
        Result,
        docs::{self, Cmd, Docs, Opt, Project},
    },
};

/// # Docs tests
///
/// You should run this test with `--nocapture` flag and watch the output.
#[test]
fn docs() -> Result<()> {
    let docs = Cow::Owned(format!(
        concat!(
            "- If set to '{}', trim input string before hashing it.\n",
            "- This option is only available for calculating hash of an input string.",
            " It is NOT available for calculating hashes from stdin or files. It's also NOT available if input file is too large.",
            " Note that this is a test documentation. So take it easy  :-)",
        ),
        true,
    ));
    let trim_opt = Opt::new(&["-t", "--trim"], true, None, Some(&false), docs);
    let format_opt = Opt::new(
        &["--format"], false, Some(docs::make_cow_strings(&["hex", "hex-array"])), Some(&"hex"), Cow::Borrowed("Format for output hashes."),
    );
    let options = dia_args::make_opts![&trim_opt, &format_opt,];

    let help_cmd = Cmd::new("help", "Prints help and exits.".into(), None);
    let hash_cmd = Cmd::new(
        "hash",
        concat!(
            "Hash an input string or stdin or input file(s).\n",
            "\n",
            "Supported algorithms:",
            " Keccak-224, Keccak-256, Keccak-384, Keccak-512, SHA3-224, SHA3-256, SHA3-384, SHA3-512, Shake-128, Shake-256.\n",
        ).into(),
        Some(options.clone()),
    );

    let mut docs = Docs::new(
        "Dia-Hammer".into(),
        Cow::Owned(format!(
            concat!(
                "Project: https://bitbucket.org/haibison/hammer\n",
                "License: Nice License\n",
                "This project follows Semantic Versioning 2.0.0\n",
                "\n",
                "Features:\n",
                "\n",
                "- Calculating hashes of data via Keccak algorithms. Supported algorithms are: please see 'help' command for details.\n",
                "- Meow.\n",
                "- Woof.\n\n",
                "{}",
            ),
            dia_args::DIA_ARGS_FILE_FORMAT,
        )),
    );
    docs.options = Some(options.clone());
    docs.commands = Some(dia_args::make_cmds![&help_cmd, hash_cmd,]);
    docs.project = Some(Project::new(
        "https://bitbucket.org/haibison/dia-args", "Nice License", Some(Cow::Borrowed(include_str!("../LICENSE"))),
    ));
    docs.print()?;

    Ok(())
}
