// License: see LICENSE file at root directory of `master` branch

//! # Read-only `u64`

use {
    core::ops::Deref,
};

/// # Read-only `u64`
#[derive(Debug)]
pub (crate) struct ReadOnlyU64 {
    value: u64,
}

impl Deref for ReadOnlyU64 {

    type Target = u64;

    fn deref(&self) -> &Self::Target {
        &self.value
    }

}

impl From<u64> for ReadOnlyU64 {

    fn from(value: u64) -> Self {
        Self {
            value,
        }
    }

}
