// License: see LICENSE file at root directory of `master` branch

//! # Internatinonalization

use {
    std::borrow::Cow,
};

/// # Internatinonalization
///
/// ## Default values
///
/// Please see documentation of each field.
#[derive(Debug)]
pub struct I18n<'a> {

    /// # "Commands"
    pub commands: Cow<'a, str>,

    /// # "No Commands"
    pub no_commands: Cow<'a, str>,

    /// # "Options"
    pub options: Cow<'a, str>,

    /// # "No Options"
    pub no_options: Cow<'a, str>,

    /// # "Values"
    pub values: Cow<'a, str>,

    /// # "Default"
    pub default: Cow<'a, str>,

    /// # "Required"
    pub required: Cow<'a, str>,

    /// # "Project"
    pub project: Cow<'a, str>,

    /// # "Home"
    pub home: Cow<'a, str>,

    /// # "License"
    pub license: Cow<'a, str>,

}

impl Default for I18n<'_> {

    fn default() -> Self {
        Self {
            commands: Cow::Borrowed("Commands"),
            no_commands: Cow::Borrowed("No Commands"),
            options: Cow::Borrowed("Options"),
            no_options: Cow::Borrowed("No Options"),
            values: Cow::Borrowed("Values"),
            default: Cow::Borrowed("Default"),
            required: Cow::Borrowed("Required"),
            project: Cow::Borrowed("Project"),
            home: Cow::Borrowed("Home"),
            license: Cow::Borrowed("License"),
        }
    }

}
