// License: see LICENSE file at root directory of `master` branch

//! # Configuration

/// # Configuration
///
/// ## Default values
///
/// | Name       | Value
/// | ---------- | -----
/// | Tab length | `4`
/// | Tab level  | `0`
/// | Columns    | `128`
#[derive(Debug)]
pub struct Cfg {
    tab_len: usize,
    tab_level: u8,
    columns: usize,
}

impl Default for Cfg {

    fn default() -> Self {
        Self::new(4, 0, 128)
    }

}

impl Cfg {

    /// # Makes new instance
    pub const fn new(tab_len: usize, tab_level: u8, columns: usize) -> Self {
        Self {
            tab_len,
            tab_level,
            columns,
        }
    }

    /// # Length of a tab
    pub fn tab_len(&self) -> usize {
        self.tab_len
    }

    /// # Tab level
    pub fn tab_level(&self) -> u8 {
        self.tab_level
    }

    /// # Increments level
    ///
    /// This function uses `saturating_add()` while incrementing level.
    pub fn increment_level(&self) -> Self {
        Self::new(self.tab_len, self.tab_level.saturating_add(1), self.columns)
    }

    /// # Columns
    pub fn columns(&self) -> usize {
        self.columns
    }

}
