// License: see LICENSE file at root directory of `master` branch

// ╔═════════════════╗
// ║   IDENTIFIERS   ║
// ╚═════════════════╝

macro_rules! code_name  { () => { ">>>code_name<<<" }}
macro_rules! version    { () => { "0.0.0" }}

/// # Crate name
pub const NAME: &str = ">>>name<<<";

/// # Crate code name
pub const CODE_NAME: &str = code_name!();

/// # ID of this crate
pub const ID: &str = >>>id<<<;

/// # Crate version
pub const VERSION: &str = version!();

/// # Crate release date (year/month/day)
pub const RELEASE_DATE: (u16, u8, u8) = (>>>year<<<, >>>month<<<, >>>day<<<);

/// # Tag, which can be used for logging...
pub const TAG: &str = concat!(code_name!(), "::>>>tag_id<<<::", version!());

// ╔════════════════════╗
// ║   IMPLEMENTATION   ║
// ╚════════════════════╝

/// # Result type used in this crate
pub type Result<T> = core::result::Result<T, std::io::Error>;

#[test]
fn test_crate_version() {
    assert_eq!(VERSION, env!("CARGO_PKG_VERSION"));
}
