// License: see LICENSE file at root directory of `master` branch

//! # Templates

const LICENSE_LINES: usize = 2;
const HEADER: &str = include_str!("templates/header.rs");
const USES: &str = include_str!("templates/uses.rs");
const IDENTIFIERS: &str = include_str!("templates/identifiers.rs");
const FOOTER: &str = include_str!("templates/footer.rs");

/// # Placeholder for crate name
pub const CRATE_NAME_PLACEHOLDER: &str = ">>>name<<<";

/// # Placeholder for crate code name
pub const CRATE_CODE_NAME_PLACEHOLDER: &str = ">>>code_name<<<";

/// # Placeholder for crate ID
pub const CRATE_ID_PLACEHOLDER: &str = ">>>id<<<";

/// # Placeholder for tag ID
pub const TAG_ID_PLACEHOLDER: &str = ">>>tag_id<<<";

/// # Placeholder for year
pub const YEAR_PLACEHOLDER: &str = ">>>year<<<";

/// # Placeholder for month
pub const MONTH_PLACEHOLDER: &str = ">>>month<<<";

/// # Placeholder for day
pub const DAY_PLACEHOLDER: &str = ">>>day<<<";

/// # Gets header
pub fn header<'a>() -> &'a str {
    skip_license_lines(HEADER)
}

/// # Gets uses
pub fn uses<'a>() -> &'a str {
    skip_license_lines(USES)
}

/// # Gets identifiers
///
/// Supported placeholders:
///
/// - [`CRATE_NAME_PLACEHOLDER`][::CRATE_NAME_PLACEHOLDER]
/// - [`CRATE_CODE_NAME_PLACEHOLDER`][::CRATE_CODE_NAME_PLACEHOLDER]
/// - [`CRATE_ID_PLACEHOLDER`][::CRATE_ID_PLACEHOLDER]
/// - [`TAG_ID_PLACEHOLDER`][::TAG_ID_PLACEHOLDER]
/// - [`YEAR_PLACEHOLDER`][::YEAR_PLACEHOLDER]
/// - [`MONTH_PLACEHOLDER`][::MONTH_PLACEHOLDER]
/// - [`DAY_PLACEHOLDER`][::DAY_PLACEHOLDER]
///
/// [::CRATE_NAME_PLACEHOLDER]: constant.CRATE_NAME_PLACEHOLDER.html
/// [::CRATE_CODE_NAME_PLACEHOLDER]: constant.CRATE_CODE_NAME_PLACEHOLDER.html
/// [::CRATE_ID_PLACEHOLDER]: constant.CRATE_ID_PLACEHOLDER.html
/// [::TAG_ID_PLACEHOLDER]: constant.TAG_ID_PLACEHOLDER.html
/// [::YEAR_PLACEHOLDER]: constant.YEAR_PLACEHOLDER.html
/// [::MONTH_PLACEHOLDER]: constant.MONTH_PLACEHOLDER.html
/// [::DAY_PLACEHOLDER]: constant.DAY_PLACEHOLDER.html
pub fn identifiers<'a>() -> &'a str {
    skip_license_lines(IDENTIFIERS)
}

/// # Gets footer
pub fn footer<'a>() -> &'a str {
    skip_license_lines(FOOTER)
}

/// # Line break on Unix
#[cfg(unix)]
const LINE_BREAK: &str = concat!('\n');

/// # Line break on non-Unix
#[cfg(not(unix))]
const LINE_BREAK: &str = concat!('\r', '\n');

/// # Skips license lines
fn skip_license_lines(mut content: &str) -> &str {
    for _ in 0..LICENSE_LINES {
        match content.find(LINE_BREAK) {
            Some(idx) => content = &content[idx + LINE_BREAK.len()..],
            None => break,
        }
    }
    content
}
