// License: see LICENSE file at root directory of `master` branch

//! # Template type

use {
    core::{
        fmt,
        str::FromStr,
    },
    std::io::{Error, ErrorKind},
};

const LIB: &str = "lib";
const BIN: &str = "bin";

/// # Template type
#[derive(Debug, Eq, PartialEq)]
pub enum TemplateType {

    /// # Library
    LIB,

    /// # Binary
    BIN,

}

impl FromStr for TemplateType {

    type Err = Error;

    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            self::LIB => Ok(TemplateType::LIB),
            self::BIN => Ok(TemplateType::BIN),
            _ => Err(Error::new(ErrorKind::InvalidInput, format!("Unknown template type: {:?}", s))),
        }
    }

}

impl fmt::Display for TemplateType {

    fn fmt(&self, f: &mut fmt::Formatter) -> Result<(), fmt::Error> {
        f.write_str(match self {
            TemplateType::LIB => LIB,
            TemplateType::BIN => BIN,
        })
    }

}
