use std::env;
use std::fs;
use serde_json::Value;
use tera::Context;
use tera::Tera;
use log::{info};
use simple_logger::SimpleLogger;

fn main() {
    SimpleLogger::new().init().unwrap();

    let args: Vec<String> = env::args().collect();

    let filename = &args[1];

    info!("Reading Dhall file: {}", filename);

    let context: Option<Context> = serde_dhall::from_file(&filename)
        .parse()
        .ok()
        .and_then(|x: Value| Context::from_serialize(&x).ok());

    let result = Tera::new("templates/*.tex")
        .ok()
        .map(|t| context.map(|c| t.render("resume.tex", &c).ok()))
        .flatten()
        .flatten()
        .and_then(|x| fs::write("resume.tex", x).ok());

    match result {
        None => info!("Fail"),
        Some(_) => info!("Success")
    }
}
