use std::env;
use std::fs;

use serde_json::Value;
use tera::Context;
use tera::Tera;
use log::{info};
use simple_logger::SimpleLogger;

#[tokio::main]
async fn main() -> Result<(), Box<dyn std::error::Error>> {
    SimpleLogger::new().init().unwrap();

    let args: Vec<String> = env::args().collect();

    let filename = &args[1];

    info!("Reading Dhall file: {}", filename);

    let resume: Value = serde_dhall::from_file(&filename).parse()?;

    let tera = match Tera::new("templates/*.tex") {
        Ok(t) => t,
        Err(e) => {
            println!("Parsing error(s): {}", e);
            ::std::process::exit(1);
        }
    };

    let rendered_latex = tera.render("resume.tex", &Context::from_serialize(&resume)?)?;
    fs::write("resume.tex", rendered_latex)?;

    Ok(())
}
