use actix_web::get;
use actix_web::web::ServiceConfig;
use actix_web::Responder;
#[cfg(not(debug_assertions))]
use actix_web::{http::header::ContentType, HttpResponse};

#[get("/static/css/index.css")]
async fn css() -> impl Responder {
	#[cfg(debug_assertions)]
	{
		actix_files::NamedFile::open("static/index.css")
	}
	#[cfg(not(debug_assertions))]
	{
		HttpResponse::Ok()
			.insert_header(ContentType(mime::TEXT_CSS))
			.body::<&[u8]>(std::include_bytes!("../static/index.css"))
	}
}

#[get("/static/js/index.js")]
async fn js() -> impl Responder {
	#[cfg(debug_assertions)]
	{
		actix_files::NamedFile::open("static/index.js")
	}
	#[cfg(not(debug_assertions))]
	{
		HttpResponse::Ok()
			.insert_header(ContentType(mime::TEXT_JAVASCRIPT))
			.body::<&[u8]>(std::include_bytes!("../static/index.js"))
	}
}

pub fn configure(app: &mut ServiceConfig) {
	app.service(css).service(js);
}
