use crate::paths::UserPath;
use crate::util::RichType;
use actix_web::Either;

#[derive(askama::Template)]
#[template(path = "index.html")]
pub struct Template {
	pub title: UserPath,
	pub entries: Vec<EntryData>,
}

pub struct EntryData {
	pub thumbnail: ThumbnailType,
	pub name: String,
	pub modified_time: chrono::DateTime<chrono::Local>,
	pub size: Option<EntrySize>,
}

pub struct EntrySize {
	pub number: u64,
	pub should_format: bool,
}

pub struct RichThumbnail {
	pub url: String,
	pub ty: RichType,
}

pub enum ThumbnailType {
	RichThumbnail(RichThumbnail),
	File,
	Directory,
	Unknown,
}

impl ThumbnailType {
	pub fn as_rich_or_alt(&self) -> Either<&RichThumbnail, &'static str> {
		match self {
			ThumbnailType::RichThumbnail(rich) => Either::Left(rich),
			_ => Either::Right(self.ty()),
		}
	}
	pub fn ty(&self) -> &'static str {
		use ThumbnailType::*;
		match self {
			RichThumbnail(_) => "rich_thumbnail",
			File => "file",
			Directory => "directory",
			Unknown => "unknown",
		}
	}
}
